"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureFlags = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxapi = require("@aws-cdk/cx-api");
/**
 * Features that are implemented behind a flag in order to preserve backwards compatibility for existing apps.
 *
 * The list of flags are available in the
 * `@aws-cdk/cx-api` module.
 *
 * The state of the flag for this application is stored as a CDK context variable.
 *
 * @stability stable
 */
class FeatureFlags {
    constructor(construct) {
        this.construct = construct;
    }
    /**
     * Inspect feature flags on the construct node's context.
     *
     * @stability stable
     */
    static of(scope) {
        return new FeatureFlags(scope);
    }
    /**
     * Check whether a feature flag is enabled.
     *
     * If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the `cx-api`
     * module.
     *
     * @stability stable
     */
    isEnabled(featureFlag) {
        const context = this.construct.node.tryGetContext(featureFlag);
        if (cxapi.FUTURE_FLAGS_EXPIRED.includes(featureFlag)) {
            if (context !== undefined) {
                throw new Error(`Unsupported feature flag '${featureFlag}'. This flag existed on CDKv1 but has been removed in CDKv2.`
                    + ' CDK will now behave as the same as when the flag is enabled.');
            }
            return true;
        }
        return context !== null && context !== void 0 ? context : cxapi.futureFlagDefault(featureFlag);
    }
}
exports.FeatureFlags = FeatureFlags;
_a = JSII_RTTI_SYMBOL_1;
FeatureFlags[_a] = { fqn: "@aws-cdk/core.FeatureFlags", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,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