"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_PythonLayerVersionProps(props);
        const compatibleRuntimes = (_b = props.compatibleRuntimes) !== null && _b !== void 0 ? _b : [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = (_c = props.compatibleArchitectures) !== null && _c !== void 0 ? _c : [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonLayerVersion", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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