"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const ecs_deployment_provider_1 = require("../ecs-deployment-provider");
/**
 * A CodeDeploy Deployment for a Amazon ECS service DeploymentGroup. An EcsDeploymentGroup
 * must only have 1 EcsDeployment. This limit is enforced by removing the scope and id
 * from the constructor. The scope will always be set to the EcsDeploymentGroup
 * and the id will always be set to the string 'Deployment' to force an error if mulitiple
 * EcsDeployment constructs are created for a single EcsDeploymentGroup.
 */
class EcsDeployment extends constructs_1.Construct {
    constructor(props) {
        super(props.deploymentGroup, 'Deployment');
        const ecsDeploymentProvider = new ecs_deployment_provider_1.EcsDeploymentProvider(this, 'DeploymentProvider', {
            deploymentGroup: props.deploymentGroup,
            timeout: props.timeout || cdk.Duration.minutes(30),
        });
        let autoRollbackConfigurationEvents = undefined;
        let autoRollbackConfigurationEnabled = undefined;
        if (props.autoRollback) {
            let events = [];
            if (props.autoRollback.deploymentInAlarm) {
                events.push('DEPLOYMENT_STOP_ON_ALARM');
            }
            if (props.autoRollback.failedDeployment) {
                events.push('DEPLOYMENT_FAILURE');
            }
            if (props.autoRollback.stoppedDeployment) {
                events.push('DEPLOYMENT_STOP_ON_REQUEST');
            }
            if (events.length > 0) {
                autoRollbackConfigurationEnabled = 'true';
                autoRollbackConfigurationEvents = events.join(',');
            }
            else {
                autoRollbackConfigurationEnabled = 'false';
            }
        }
        const deployment = new cdk.CustomResource(this, 'Resource', {
            serviceToken: ecsDeploymentProvider.serviceToken,
            resourceType: 'Custom::EcsDeployment',
            properties: {
                applicationName: props.deploymentGroup.application.applicationName,
                deploymentConfigName: props.deploymentGroup.deploymentConfig.deploymentConfigName,
                deploymentGroupName: props.deploymentGroup.deploymentGroupName,
                autoRollbackConfigurationEnabled,
                autoRollbackConfigurationEvents,
                description: props.description,
                revisionAppSpecContent: props.appspec.toString(),
            },
        });
        this.deploymentId = deployment.getAttString('deploymentId');
    }
}
exports.EcsDeployment = EcsDeployment;
_a = JSII_RTTI_SYMBOL_1;
EcsDeployment[_a] = { fqn: "@cdklabs/cdk-ecs-codedeploy.EcsDeployment", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,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