"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class Instance(google.protobuf.message.Message):
    """Running instance of a product definition
    To list the running instances, use `ListInstances`
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class ServicesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text = ...
        @property
        def value(self) -> global___Service: ...
        def __init__(self,
            *,
            key : typing.Text = ...,
            value : typing.Optional[global___Service] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DEFINITION_NAME_FIELD_NUMBER: builtins.int
    READY_FIELD_NUMBER: builtins.int
    STATUS_MESSAGE_FIELD_NUMBER: builtins.int
    SERVICES_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """(Output only) The name of the product instance.
    Starts with 'instances/'
    e.g: instances/workbench-221-12345
    """

    definition_name: typing.Text = ...
    """The name of the product definition.
    e.g: definitions/workbench-221
    Note: A list of all product definition names can be found using `ListDefinitions`
    """

    ready: builtins.bool = ...
    """(Output only) The status of the instance.
    When this status is true, then the services can be used.
    """

    status_message: typing.Text = ...
    """(Output only) Human readable message elaborating the status of the instance.
    Available only if ready is false.
    """

    @property
    def services(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, global___Service]:
        """(Output only) Services exposed by this instance, by name.
        Available only if the instance is ready.
        The list of keys must match the `available_service_names` of this instance definition.
        If the instance exposes a main HTTP API, then the service must be named "http"
        If the instance exposes a main GRPC API, then the service must be named "grpc"
        """
        pass
    def __init__(self,
        *,
        name : typing.Text = ...,
        definition_name : typing.Text = ...,
        ready : builtins.bool = ...,
        status_message : typing.Text = ...,
        services : typing.Optional[typing.Mapping[typing.Text, global___Service]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["definition_name",b"definition_name","name",b"name","ready",b"ready","services",b"services","status_message",b"status_message"]) -> None: ...
global___Instance = Instance

class Definition(google.protobuf.message.Message):
    """Static definition of a product instance.
    To list all available product definitions, use `ListDefinitions`
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    PRODUCT_NAME_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_FIELD_NUMBER: builtins.int
    AVAILABLE_SERVICE_NAMES_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """The product definition name.
    e.g: definitions/workbench-221
    """

    product_name: typing.Text = ...
    """Name of the product.
    e.g: workbench
    """

    product_version: typing.Text = ...
    """Version of the product.
    For product following the unified installation, it
    should be the 3 letters short name of the version.
    e.g: 221
    """

    @property
    def available_service_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """List of available services name that an instance of this definition
        will expose once created.
        If the instance exposes a main HTTP API, then the service must be named "http"
        If the instance exposes a main GRPC API, then the service must be named "grpc"
        """
        pass
    def __init__(self,
        *,
        name : typing.Text = ...,
        product_name : typing.Text = ...,
        product_version : typing.Text = ...,
        available_service_names : typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_service_names",b"available_service_names","name",b"name","product_name",b"product_name","product_version",b"product_version"]) -> None: ...
global___Definition = Definition

class Service(google.protobuf.message.Message):
    """A service available from a running product instance."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text = ...
        value: typing.Text = ...
        def __init__(self,
            *,
            key : typing.Text = ...,
            value : typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    URI_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    uri: typing.Text = ...
    """The URI to reach the service
    For gRPC, this is a valid URI, following gRPC name resolution syntax:
    https://grpc.github.io/grpc/core/md_doc_naming.html
    For HTTP/REST, this is a valid http or https URI. It is the base path of the service API.
    """

    @property
    def headers(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, typing.Text]:
        """The list of headers to pass to the service for each request to the service."""
        pass
    def __init__(self,
        *,
        uri : typing.Text = ...,
        headers : typing.Optional[typing.Mapping[typing.Text, typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["headers",b"headers","uri",b"uri"]) -> None: ...
global___Service = Service

class CreateInstanceRequest(google.protobuf.message.Message):
    """Request message for `CreateInstance` method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    INSTANCE_FIELD_NUMBER: builtins.int
    @property
    def instance(self) -> global___Instance:
        """The product instance resource to create.
        Note: you can call `ListDefinitions` to get a list of existing instance definitions.
        """
        pass
    def __init__(self,
        *,
        instance : typing.Optional[global___Instance] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["instance",b"instance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance",b"instance"]) -> None: ...
global___CreateInstanceRequest = CreateInstanceRequest

class DeleteInstanceRequest(google.protobuf.message.Message):
    """Request message for `DeleteInstance` method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """The instance name of the product to delete."""

    def __init__(self,
        *,
        name : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___DeleteInstanceRequest = DeleteInstanceRequest

class GetInstanceRequest(google.protobuf.message.Message):
    """
    Request message for `GetInstance` method.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """The name of the product instance. E.g: instances/example-212-IDAENEID"""

    def __init__(self,
        *,
        name : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___GetInstanceRequest = GetInstanceRequest

class ListInstancesRequest(google.protobuf.message.Message):
    """Request message for `ListInstances` method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_size: builtins.int = ...
    """The maximum number of productInstances to return in the response. If this value
    is zero, the service will select a default size. A call may return fewer
    objects than requested. A non-empty `next_page_token` in the response
    indicates that more data is available.
    """

    page_token: typing.Text = ...
    """The value returned by the last `ListInstancesResponse`; indicates
    that this is a continuation of a prior `ListApps` call and
    the system should return the next page of data.
    """

    def __init__(self,
        *,
        page_size : builtins.int = ...,
        page_token : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_size",b"page_size","page_token",b"page_token"]) -> None: ...
global___ListInstancesRequest = ListInstancesRequest

class ListInstancesResponse(google.protobuf.message.Message):
    """Response message for ListInstances call."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    INSTANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Instance]:
        """The list of running productInstances."""
        pass
    next_page_token: typing.Text = ...
    """If not empty, indicates that there may be more productInstances that match the
    request; this value should be passed in a new `ListInstancesRequest`.
    """

    def __init__(self,
        *,
        instances : typing.Optional[typing.Iterable[global___Instance]] = ...,
        next_page_token : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instances",b"instances","next_page_token",b"next_page_token"]) -> None: ...
global___ListInstancesResponse = ListInstancesResponse

class ListDefinitionsRequest(google.protobuf.message.Message):
    """Request message for `ListDefinitions` method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PRODUCT_NAME_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_FIELD_NUMBER: builtins.int
    page_size: builtins.int = ...
    """The maximum number of product definitions to return in the response. If this value
    is zero, the service will select a default size. A call may return fewer
    objects than requested. A non-empty `next_page_token` in the response
    indicates that more data is available.
    """

    page_token: typing.Text = ...
    """The value returned by the last `ListDefinitionsResponse`; indicates
    that this is a continuation of a prior `ListApps` call and
    the system should return the next page of data.
    """

    product_name: typing.Text = ...
    """When specified, only products matching this name will be returned.
    e.g: workbench
    """

    product_version: typing.Text = ...
    """When specified, only products matching this version will be returned.
    e.g: 211
    """

    def __init__(self,
        *,
        page_size : builtins.int = ...,
        page_token : typing.Text = ...,
        product_name : typing.Text = ...,
        product_version : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_size",b"page_size","page_token",b"page_token","product_name",b"product_name","product_version",b"product_version"]) -> None: ...
global___ListDefinitionsRequest = ListDefinitionsRequest

class ListDefinitionsResponse(google.protobuf.message.Message):
    """Response message for `ListDefinitions` call."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Definition]:
        """The list of all products that can be used to start new instances."""
        pass
    next_page_token: typing.Text = ...
    """If not empty, indicates that there may be more products that match the
    request; this value should be passed in a new `ListDefinitionsRequest`.
    """

    def __init__(self,
        *,
        definitions : typing.Optional[typing.Iterable[global___Definition]] = ...,
        next_page_token : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["definitions",b"definitions","next_page_token",b"next_page_token"]) -> None: ...
global___ListDefinitionsResponse = ListDefinitionsResponse

class GetDefinitionRequest(google.protobuf.message.Message):
    """Request message for `GetDefinition` method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NAME_FIELD_NUMBER: builtins.int
    name: typing.Text = ...
    """The name of the product definition. E.g: definitions/example-212
    Note: you can call `ListDefinitions` to get a list of existing job definition.
    """

    def __init__(self,
        *,
        name : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name"]) -> None: ...
global___GetDefinitionRequest = GetDefinitionRequest
