"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tests for the L1 escape hatches (overrides). those are in the IAM module
// because we want to verify them end-to-end, as a complement to the unit
// tests in the @aws-cdk/core module
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
// tslint:disable:object-literal-key-quotes
describe('IAM escape hatches', () => {
    test('addPropertyOverride should allow overriding supported properties', () => {
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', {
            userName: 'MyUserName',
        });
        const cfn = user.node.findChild('Resource');
        cfn.addPropertyOverride('UserName', 'OverriddenUserName');
        expect(stack).toMatchTemplate({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "OverriddenUserName"
                    }
                }
            }
        });
    });
    test('addPropertyOverrides should allow specifying arbitrary properties', () => {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        // WHEN
        cfn.addPropertyOverride('Hello.World', 'Boom');
        // THEN
        expect(stack).toMatchTemplate({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "MyUserName",
                        "Hello": {
                            "World": "Boom"
                        }
                    }
                }
            }
        });
    });
    test('addOverride should allow overriding properties', () => {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        cfn.cfnOptions.updatePolicy = { useOnlineResharding: true };
        // WHEN
        cfn.addOverride('Properties.Hello.World', 'Bam');
        cfn.addOverride('Properties.UserName', 'HA!');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('UpdatePolicy.UseOnlineResharding.Type', 'None');
        // THEN
        expect(stack).toMatchTemplate({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "HA!",
                        "Hello": {
                            "World": "Bam"
                        }
                    },
                    "Joob": {
                        "Jab": "Jib"
                    },
                    "UpdatePolicy": {
                        "UseOnlineResharding": {
                            "Type": "None"
                        }
                    }
                }
            }
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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