"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
/**
 * Code configuration providing the location to a Flink application JAR file.
 */
class ApplicationCode {
    /**
     * Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket
     * @param fileKey - a key pointing to a Flink JAR file
     * @param objectVersion - an optional version string for the provided fileKey
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.ApplicationCode", version: "2.72.1-alpha.0" };
exports.ApplicationCode = ApplicationCode;
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        return this._asset?.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,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