# Generated by Django 3.0.3 on 2020-02-09 04:26

from django.db import migrations


def populate_new_candidate_fields(apps, schema_editor):
    """"""
    Candidate = apps.get_model("election", "Candidate")

    for candidate in Candidate.objects.all():
        candidate.cycle_id = candidate.race.cycle_id
        candidate.office_id = candidate.race.office_id
        candidate.save()


def revert_candidate_fields(apps, schema_editor):
    Candidate = apps.get_model("election", "Candidate")
    ElectionCycle = apps.get_model("election", "ElectionCycle")
    Office = apps.get_model("government", "Office")
    Race = apps.get_model("election", "Race")

    for candidate in Candidate.objects.all():
        matching_races = Race.objects.filter(
            cycle=candidate.cycle_id, office_id=candidate.office_id
        )

        if matching_races.count() == 1:
            candidate.race_id = matching_races[0].id
        elif matching_races.count() > 1:
            matching_race_id = matching_races[0].id
            print(
                " ".join(
                    [
                        f"Multiple races found for cycle '{self.name}'",
                        f"and office '{self.uid}'.",
                        f"Chose the race with UID {matching_race_id}.",
                    ]
                )
            )
            candidate.race_id = matching_race_id
        else:
            print(
                " ".join(
                    [
                        f"No races found for cycle '{self.name}'",
                        f"and office '{self.uid}'.",
                    ]
                )
            )


class Migration(migrations.Migration):

    dependencies = [
        ("election", "0013_auto_20200209_0418"),
        ("government", "0005_auto_20190826_2043"),
    ]

    operations = [
        migrations.RunPython(
            populate_new_candidate_fields, revert_candidate_fields
        )
    ]
