# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import os
import pathlib
import typing
from enum import Enum, auto

class GenomicInterval:
    r"""
    A segment is a genomic interval defined by a chromosome, a start position and an end position.
    The start position is inclusive and the end position is exclusive.
    """

    start: int
    end: int
    chr: str
    def __new__(cls, chr: str, start: int, end: int): ...
    def set_chr(self, chr: str) -> None: ...
    def overlap(self, other: GenomicInterval) -> bool: ...
    def __repr__(self) -> str: ...

class PslAlignment:
    qname: str
    qsize: int
    qstart: int
    qend: int
    qmatch: int
    tname: str
    tsize: int
    tstart: int
    tend: int
    identity: float
    def __repr__(self) -> str: ...

class CompressedType(Enum):
    r"""
    Represents different types of file compression formats.

    This enum is used to identify and handle various compression formats commonly used for files.
    It can be used in Python through the deepbiop.utils module.

    # Variants

    * `Uncompress` - Uncompressed/raw file format
    * `Gzip` - Standard gzip compression (.gz files)
    * `Bgzip` - Blocked gzip format, commonly used in bioinformatics
    * `Zip` - ZIP archive format
    * `Bzip2` - bzip2 compression format
    * `Xz` - XZ compression format (LZMA2)
    * `Zstd` - Zstandard compression format
    * `Unknown` - Unknown or unrecognized compression format
    """

    Uncompress = auto()
    Gzip = auto()
    Bgzip = auto()
    Zip = auto()
    Bzip2 = auto()
    Xz = auto()
    Zstd = auto()
    Unknown = auto()

def check_compressed_type(path: str | os.PathLike | pathlib.Path) -> CompressedType:
    r"""
    Check the compression type of a file.

    Args:
        path: Path to the file to check

    Returns
    -------
        The compression type of the file (None, Gzip, Bzip2, Xz)

    Raises
    ------
        IOError: If the file cannot be opened or read
    """

def generate_unmaped_intervals(
    input: typing.Sequence[tuple[int, int]], total_length: int
) -> list[tuple[int, int]]: ...
def highlight_targets(sequence, targets, text_width=...) -> str: ...
def majority_voting(labels: typing.Sequence[int], window_size: int) -> list[int]: ...
def parse_psl_by_qname(
    file_path: str | os.PathLike | pathlib.Path,
) -> dict[str, list[PslAlignment]]:
    r"""Parse PSL file by query name."""

def remove_intervals_and_keep_left(
    seq: str, intervals: typing.Sequence[tuple[int, int]]
) -> tuple[list[str], list[tuple[int, int]]]: ...
