"""
    EMIL Tenant Service

    The EMIL TenantService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.tenant.api_client import ApiClient, Endpoint as _Endpoint
from eis.tenant.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.tenant.model.create_data_report_request_dto import CreateDataReportRequestDto
from eis.tenant.model.create_data_report_response_class import CreateDataReportResponseClass
from eis.tenant.model.get_data_report_response_class import GetDataReportResponseClass
from eis.tenant.model.list_data_reports_response_class import ListDataReportsResponseClass
from eis.tenant.model.update_data_report_request_dto import UpdateDataReportRequestDto
from eis.tenant.model.update_data_report_response_class import UpdateDataReportResponseClass


class DataReportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_custom_schema_endpoint = _Endpoint(
            settings={
                'response_type': (CreateDataReportResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/tenantservice/v1/data-reports',
                'operation_id': 'create_custom_schema',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_data_report_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_data_report_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_data_report_request_dto':
                        (CreateDataReportRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_data_report_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_alert_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/tenantservice/v1/data-reports/{id}',
                'operation_id': 'delete_alert',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'authorization',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_data_report_endpoint = _Endpoint(
            settings={
                'response_type': (GetDataReportResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/tenantservice/v1/data-reports/{code}',
                'operation_id': 'get_data_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_data_reports_endpoint = _Endpoint(
            settings={
                'response_type': (ListDataReportsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/tenantservice/v1/data-reports',
                'operation_id': 'list_data_reports',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'page_token':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'filter':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'search':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'order':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'expand':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_data_report_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateDataReportResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/tenantservice/v1/data-reports/{code}',
                'operation_id': 'update_data_report',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'update_data_report_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'update_data_report_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'update_data_report_request_dto':
                        (UpdateDataReportRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'update_data_report_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_custom_schema(
        self,
        create_data_report_request_dto,
        **kwargs
    ):
        """Create the data-report  # noqa: E501

        This will create a data report for tenant in the database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_custom_schema(create_data_report_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_data_report_request_dto (CreateDataReportRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateDataReportResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_data_report_request_dto'] = \
            create_data_report_request_dto
        return self.create_custom_schema_endpoint.call_with_http_info(**kwargs)

    def delete_alert(
        self,
        id,
        **kwargs
    ):
        """delete_alert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_alert(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_alert_endpoint.call_with_http_info(**kwargs)

    def get_data_report(
        self,
        code,
        **kwargs
    ):
        """Retrieve the data-report  # noqa: E501

        Retrieves the details of the data-report that was previously created. Supply the unique data-report code that was returned when you created it and Emil Api will return the corresponding data-report information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_report(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            expand (str): Fields to expand response by. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetDataReportResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_data_report_endpoint.call_with_http_info(**kwargs)

    def list_data_reports(
        self,
        **kwargs
    ):
        """List data-reports  # noqa: E501

        Returns a list of data-reports you have previously created. The data-reports are returned in sorted order, with the oldest one appearing first. For more information about pagination, read the Pagination documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_data_reports(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            page_size (bool, date, datetime, dict, float, int, list, str, none_type): A limit on the number of objects to be returned.     Limit ranges between 1 and 100. Default: 10.. [optional]
            page_token (bool, date, datetime, dict, float, int, list, str, none_type): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1,     your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (bool, date, datetime, dict, float, int, list, str, none_type): Filter the response by one or multiple fields.     In general, fetching filtered responses will conserve bandwidth and reduce response time.. [optional]
            search (bool, date, datetime, dict, float, int, list, str, none_type): Search the list by any field. For instance, if you want to search by code     add code=xxx in order to fetch the result.. [optional]
            order (bool, date, datetime, dict, float, int, list, str, none_type): The order parameter determines how the results should be sorted according to a specified field.     It functions similarly to an SQL ORDER BY.     Sorting can be performed in either ascending (ASC) or descending (DESC) order.     Default: ASC.. [optional]
            expand (bool, date, datetime, dict, float, int, list, str, none_type): Use this parameter to fetch additional information about the list items.     The expand query parameter increases the set of fields that appear in the response in     addition to the default ones.     Expanding resources can reduce the number of API calls required to accomplish a task.     However, use this with parsimony as some expanded fields can drastically increase payload size.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListDataReportsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_data_reports_endpoint.call_with_http_info(**kwargs)

    def update_data_report(
        self,
        code,
        update_data_report_request_dto,
        **kwargs
    ):
        """Update the data-report  # noqa: E501

        Updates the specified data-report by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_data_report(code, update_data_report_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str):
            update_data_report_request_dto (UpdateDataReportRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateDataReportResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['update_data_report_request_dto'] = \
            update_data_report_request_dto
        return self.update_data_report_endpoint.call_with_http_info(**kwargs)

