# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstancePoolsResult',
    'AwaitableGetInstancePoolsResult',
    'get_instance_pools',
    'get_instance_pools_output',
]

@pulumi.output_type
class GetInstancePoolsResult:
    """
    A collection of values returned by getInstancePools.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, instance_pools=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_pools and not isinstance(instance_pools, list):
            raise TypeError("Expected argument 'instance_pools' to be a list")
        pulumi.set(__self__, "instance_pools", instance_pools)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstancePoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instancePools")
    def instance_pools(self) -> Sequence['outputs.GetInstancePoolsInstancePoolResult']:
        """
        The list of instance_pools.
        """
        return pulumi.get(self, "instance_pools")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the instance pool.
        """
        return pulumi.get(self, "state")


class AwaitableGetInstancePoolsResult(GetInstancePoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancePoolsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            instance_pools=self.instance_pools,
            state=self.state)


def get_instance_pools(compartment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[Union['GetInstancePoolsFilterArgs', 'GetInstancePoolsFilterArgsDict']]] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancePoolsResult:
    """
    This data source provides the list of Instance Pools in Oracle Cloud Infrastructure Core service.

    Lists the instance pools in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_pools = oci.Core.get_instance_pools(compartment_id=compartment_id,
        display_name=instance_pool_display_name,
        state=instance_pool_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstancePools:getInstancePools', __args__, opts=opts, typ=GetInstancePoolsResult).value

    return AwaitableGetInstancePoolsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_pools=pulumi.get(__ret__, 'instance_pools'),
        state=pulumi.get(__ret__, 'state'))
def get_instance_pools_output(compartment_id: Optional[pulumi.Input[str]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstancePoolsFilterArgs', 'GetInstancePoolsFilterArgsDict']]]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancePoolsResult]:
    """
    This data source provides the list of Instance Pools in Oracle Cloud Infrastructure Core service.

    Lists the instance pools in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_pools = oci.Core.get_instance_pools(compartment_id=compartment_id,
        display_name=instance_pool_display_name,
        state=instance_pool_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstancePools:getInstancePools', __args__, opts=opts, typ=GetInstancePoolsResult)
    return __ret__.apply(lambda __response__: GetInstancePoolsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_pools=pulumi.get(__response__, 'instance_pools'),
        state=pulumi.get(__response__, 'state')))
