# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsAuthenticationFactorSettingArgs', 'DomainsAuthenticationFactorSetting']

@pulumi.input_type
class DomainsAuthenticationFactorSettingArgs:
    def __init__(__self__, *,
                 authentication_factor_setting_id: pulumi.Input[str],
                 bypass_code_enabled: pulumi.Input[bool],
                 bypass_code_settings: pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs'],
                 client_app_settings: pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs'],
                 compliance_policies: pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]],
                 endpoint_restrictions: pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs'],
                 idcs_endpoint: pulumi.Input[str],
                 mfa_enrollment_type: pulumi.Input[str],
                 notification_settings: pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs'],
                 push_enabled: pulumi.Input[bool],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_questions_enabled: pulumi.Input[bool],
                 sms_enabled: pulumi.Input[bool],
                 totp_enabled: pulumi.Input[bool],
                 totp_settings: pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs'],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 auto_enroll_email_factor_disabled: Optional[pulumi.Input[bool]] = None,
                 email_enabled: Optional[pulumi.Input[bool]] = None,
                 email_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']] = None,
                 fido_authenticator_enabled: Optional[pulumi.Input[bool]] = None,
                 hide_backup_factor_enabled: Optional[pulumi.Input[bool]] = None,
                 identity_store_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 phone_call_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]] = None,
                 third_party_factor: Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']] = None,
                 user_enrollment_disabled_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yubico_otp_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DomainsAuthenticationFactorSetting resource.
        :param pulumi.Input[str] authentication_factor_setting_id: ID of the resource
        :param pulumi.Input[bool] bypass_code_enabled: (Updatable) If true, indicates that Bypass Code is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs'] bypass_code_settings: (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs'] client_app_settings: (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]] compliance_policies: (Updatable) Compliance Policy that defines actions to be taken when a condition is violated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs'] endpoint_restrictions: (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] mfa_enrollment_type: (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs'] notification_settings: (Updatable) Settings related to the Mobile App Notification channel, such as pull
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] push_enabled: (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] security_questions_enabled: (Updatable) If true, indicates that Security Questions are enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] sms_enabled: (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] totp_enabled: (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs'] totp_settings: (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] auto_enroll_email_factor_disabled: (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] email_enabled: (Updatable) If true, indicates that the EMAIL channel is enabled for authentication
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs'] email_settings: (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] fido_authenticator_enabled: (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication
               
               **Added In:** 2009232244
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] hide_backup_factor_enabled: (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs'] identity_store_settings: (Updatable) Settings related to the use of a user's profile details from the identity store
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[bool] phone_call_enabled: (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs'] third_party_factor: (Updatable) Settings related to third-party factor
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs'] urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        :param pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs'] urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_enrollment_disabled_factors: (Updatable) Factors for which enrollment should be blocked for End User
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] yubico_otp_enabled: (Updatable) If true, indicates that the Yubico OTP is enabled for authentication
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "authentication_factor_setting_id", authentication_factor_setting_id)
        pulumi.set(__self__, "bypass_code_enabled", bypass_code_enabled)
        pulumi.set(__self__, "bypass_code_settings", bypass_code_settings)
        pulumi.set(__self__, "client_app_settings", client_app_settings)
        pulumi.set(__self__, "compliance_policies", compliance_policies)
        pulumi.set(__self__, "endpoint_restrictions", endpoint_restrictions)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "mfa_enrollment_type", mfa_enrollment_type)
        pulumi.set(__self__, "notification_settings", notification_settings)
        pulumi.set(__self__, "push_enabled", push_enabled)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "security_questions_enabled", security_questions_enabled)
        pulumi.set(__self__, "sms_enabled", sms_enabled)
        pulumi.set(__self__, "totp_enabled", totp_enabled)
        pulumi.set(__self__, "totp_settings", totp_settings)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_enroll_email_factor_disabled is not None:
            pulumi.set(__self__, "auto_enroll_email_factor_disabled", auto_enroll_email_factor_disabled)
        if email_enabled is not None:
            pulumi.set(__self__, "email_enabled", email_enabled)
        if email_settings is not None:
            pulumi.set(__self__, "email_settings", email_settings)
        if fido_authenticator_enabled is not None:
            pulumi.set(__self__, "fido_authenticator_enabled", fido_authenticator_enabled)
        if hide_backup_factor_enabled is not None:
            pulumi.set(__self__, "hide_backup_factor_enabled", hide_backup_factor_enabled)
        if identity_store_settings is not None:
            pulumi.set(__self__, "identity_store_settings", identity_store_settings)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if phone_call_enabled is not None:
            pulumi.set(__self__, "phone_call_enabled", phone_call_enabled)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if third_party_factor is not None:
            pulumi.set(__self__, "third_party_factor", third_party_factor)
        if urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings", urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings)
        if urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings", urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings)
        if user_enrollment_disabled_factors is not None:
            pulumi.set(__self__, "user_enrollment_disabled_factors", user_enrollment_disabled_factors)
        if yubico_otp_enabled is not None:
            pulumi.set(__self__, "yubico_otp_enabled", yubico_otp_enabled)

    @property
    @pulumi.getter(name="authenticationFactorSettingId")
    def authentication_factor_setting_id(self) -> pulumi.Input[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "authentication_factor_setting_id")

    @authentication_factor_setting_id.setter
    def authentication_factor_setting_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_factor_setting_id", value)

    @property
    @pulumi.getter(name="bypassCodeEnabled")
    def bypass_code_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) If true, indicates that Bypass Code is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_enabled")

    @bypass_code_enabled.setter
    def bypass_code_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "bypass_code_enabled", value)

    @property
    @pulumi.getter(name="bypassCodeSettings")
    def bypass_code_settings(self) -> pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs']:
        """
        (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_settings")

    @bypass_code_settings.setter
    def bypass_code_settings(self, value: pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs']):
        pulumi.set(self, "bypass_code_settings", value)

    @property
    @pulumi.getter(name="clientAppSettings")
    def client_app_settings(self) -> pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs']:
        """
        (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "client_app_settings")

    @client_app_settings.setter
    def client_app_settings(self, value: pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs']):
        pulumi.set(self, "client_app_settings", value)

    @property
    @pulumi.getter(name="compliancePolicies")
    def compliance_policies(self) -> pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]]:
        """
        (Updatable) Compliance Policy that defines actions to be taken when a condition is violated

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "compliance_policies")

    @compliance_policies.setter
    def compliance_policies(self, value: pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]]):
        pulumi.set(self, "compliance_policies", value)

    @property
    @pulumi.getter(name="endpointRestrictions")
    def endpoint_restrictions(self) -> pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs']:
        """
        (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "endpoint_restrictions")

    @endpoint_restrictions.setter
    def endpoint_restrictions(self, value: pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs']):
        pulumi.set(self, "endpoint_restrictions", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="mfaEnrollmentType")
    def mfa_enrollment_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user

        **Deprecated Since: 18.1.2**

        **SCIM++ Properties:**
        * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "mfa_enrollment_type")

    @mfa_enrollment_type.setter
    def mfa_enrollment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "mfa_enrollment_type", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs']:
        """
        (Updatable) Settings related to the Mobile App Notification channel, such as pull

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs']):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter(name="pushEnabled")
    def push_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "push_enabled")

    @push_enabled.setter
    def push_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "push_enabled", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="securityQuestionsEnabled")
    def security_questions_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) If true, indicates that Security Questions are enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "security_questions_enabled")

    @security_questions_enabled.setter
    def security_questions_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "security_questions_enabled", value)

    @property
    @pulumi.getter(name="smsEnabled")
    def sms_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "sms_enabled")

    @sms_enabled.setter
    def sms_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sms_enabled", value)

    @property
    @pulumi.getter(name="totpEnabled")
    def totp_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "totp_enabled")

    @totp_enabled.setter
    def totp_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "totp_enabled", value)

    @property
    @pulumi.getter(name="totpSettings")
    def totp_settings(self) -> pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs']:
        """
        (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "totp_settings")

    @totp_settings.setter
    def totp_settings(self, value: pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs']):
        pulumi.set(self, "totp_settings", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="autoEnrollEmailFactorDisabled")
    def auto_enroll_email_factor_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_enroll_email_factor_disabled")

    @auto_enroll_email_factor_disabled.setter
    def auto_enroll_email_factor_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_enroll_email_factor_disabled", value)

    @property
    @pulumi.getter(name="emailEnabled")
    def email_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the EMAIL channel is enabled for authentication

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "email_enabled")

    @email_enabled.setter
    def email_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_enabled", value)

    @property
    @pulumi.getter(name="emailSettings")
    def email_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']]:
        """
        (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "email_settings")

    @email_settings.setter
    def email_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']]):
        pulumi.set(self, "email_settings", value)

    @property
    @pulumi.getter(name="fidoAuthenticatorEnabled")
    def fido_authenticator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication

        **Added In:** 2009232244

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "fido_authenticator_enabled")

    @fido_authenticator_enabled.setter
    def fido_authenticator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fido_authenticator_enabled", value)

    @property
    @pulumi.getter(name="hideBackupFactorEnabled")
    def hide_backup_factor_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "hide_backup_factor_enabled")

    @hide_backup_factor_enabled.setter
    def hide_backup_factor_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_backup_factor_enabled", value)

    @property
    @pulumi.getter(name="identityStoreSettings")
    def identity_store_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']]:
        """
        (Updatable) Settings related to the use of a user's profile details from the identity store

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "identity_store_settings")

    @identity_store_settings.setter
    def identity_store_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']]):
        pulumi.set(self, "identity_store_settings", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="phoneCallEnabled")
    def phone_call_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "phone_call_enabled")

    @phone_call_enabled.setter
    def phone_call_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "phone_call_enabled", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thirdPartyFactor")
    def third_party_factor(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']]:
        """
        (Updatable) Settings related to third-party factor

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "third_party_factor")

    @third_party_factor.setter
    def third_party_factor(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']]):
        pulumi.set(self, "third_party_factor", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings")

    @urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings.setter
    def urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings")

    @urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings.setter
    def urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings", value)

    @property
    @pulumi.getter(name="userEnrollmentDisabledFactors")
    def user_enrollment_disabled_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Factors for which enrollment should be blocked for End User

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_enrollment_disabled_factors")

    @user_enrollment_disabled_factors.setter
    def user_enrollment_disabled_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_enrollment_disabled_factors", value)

    @property
    @pulumi.getter(name="yubicoOtpEnabled")
    def yubico_otp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Yubico OTP is enabled for authentication

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "yubico_otp_enabled")

    @yubico_otp_enabled.setter
    def yubico_otp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "yubico_otp_enabled", value)


@pulumi.input_type
class _DomainsAuthenticationFactorSettingState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authentication_factor_setting_id: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 auto_enroll_email_factor_disabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_enabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs']] = None,
                 client_app_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs']] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 compliance_policies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 email_enabled: Optional[pulumi.Input[bool]] = None,
                 email_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']] = None,
                 endpoint_restrictions: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs']] = None,
                 fido_authenticator_enabled: Optional[pulumi.Input[bool]] = None,
                 hide_backup_factor_enabled: Optional[pulumi.Input[bool]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity_store_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingMetaArgs']]]] = None,
                 mfa_enabled_category: Optional[pulumi.Input[str]] = None,
                 mfa_enrollment_type: Optional[pulumi.Input[str]] = None,
                 notification_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs']] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 phone_call_enabled: Optional[pulumi.Input[bool]] = None,
                 push_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_questions_enabled: Optional[pulumi.Input[bool]] = None,
                 sms_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 third_party_factor: Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']] = None,
                 totp_enabled: Optional[pulumi.Input[bool]] = None,
                 totp_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']] = None,
                 user_enrollment_disabled_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yubico_otp_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DomainsAuthenticationFactorSetting resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authentication_factor_setting_id: ID of the resource
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] auto_enroll_email_factor_disabled: (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] bypass_code_enabled: (Updatable) If true, indicates that Bypass Code is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs'] bypass_code_settings: (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs'] client_app_settings: (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]] compliance_policies: (Updatable) Compliance Policy that defines actions to be taken when a condition is violated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] email_enabled: (Updatable) If true, indicates that the EMAIL channel is enabled for authentication
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs'] email_settings: (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs'] endpoint_restrictions: (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] fido_authenticator_enabled: (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication
               
               **Added In:** 2009232244
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] hide_backup_factor_enabled: (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs'] identity_store_settings: (Updatable) Settings related to the use of a user's profile details from the identity store
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] mfa_enabled_category: (Updatable) Specifies the category of people for whom Multi-Factor Authentication is enabled. This is a readOnly attribute which reflects the value of mfaEnabledCategory attribute in SsoSettings
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] mfa_enrollment_type: (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs'] notification_settings: (Updatable) Settings related to the Mobile App Notification channel, such as pull
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[bool] phone_call_enabled: (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] push_enabled: (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] security_questions_enabled: (Updatable) If true, indicates that Security Questions are enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] sms_enabled: (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs'] third_party_factor: (Updatable) Settings related to third-party factor
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] totp_enabled: (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs'] totp_settings: (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs'] urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        :param pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs'] urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_enrollment_disabled_factors: (Updatable) Factors for which enrollment should be blocked for End User
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] yubico_otp_enabled: (Updatable) If true, indicates that the Yubico OTP is enabled for authentication
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authentication_factor_setting_id is not None:
            pulumi.set(__self__, "authentication_factor_setting_id", authentication_factor_setting_id)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if auto_enroll_email_factor_disabled is not None:
            pulumi.set(__self__, "auto_enroll_email_factor_disabled", auto_enroll_email_factor_disabled)
        if bypass_code_enabled is not None:
            pulumi.set(__self__, "bypass_code_enabled", bypass_code_enabled)
        if bypass_code_settings is not None:
            pulumi.set(__self__, "bypass_code_settings", bypass_code_settings)
        if client_app_settings is not None:
            pulumi.set(__self__, "client_app_settings", client_app_settings)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if compliance_policies is not None:
            pulumi.set(__self__, "compliance_policies", compliance_policies)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if email_enabled is not None:
            pulumi.set(__self__, "email_enabled", email_enabled)
        if email_settings is not None:
            pulumi.set(__self__, "email_settings", email_settings)
        if endpoint_restrictions is not None:
            pulumi.set(__self__, "endpoint_restrictions", endpoint_restrictions)
        if fido_authenticator_enabled is not None:
            pulumi.set(__self__, "fido_authenticator_enabled", fido_authenticator_enabled)
        if hide_backup_factor_enabled is not None:
            pulumi.set(__self__, "hide_backup_factor_enabled", hide_backup_factor_enabled)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if identity_store_settings is not None:
            pulumi.set(__self__, "identity_store_settings", identity_store_settings)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if mfa_enabled_category is not None:
            pulumi.set(__self__, "mfa_enabled_category", mfa_enabled_category)
        if mfa_enrollment_type is not None:
            pulumi.set(__self__, "mfa_enrollment_type", mfa_enrollment_type)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if phone_call_enabled is not None:
            pulumi.set(__self__, "phone_call_enabled", phone_call_enabled)
        if push_enabled is not None:
            pulumi.set(__self__, "push_enabled", push_enabled)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if security_questions_enabled is not None:
            pulumi.set(__self__, "security_questions_enabled", security_questions_enabled)
        if sms_enabled is not None:
            pulumi.set(__self__, "sms_enabled", sms_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if third_party_factor is not None:
            pulumi.set(__self__, "third_party_factor", third_party_factor)
        if totp_enabled is not None:
            pulumi.set(__self__, "totp_enabled", totp_enabled)
        if totp_settings is not None:
            pulumi.set(__self__, "totp_settings", totp_settings)
        if urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings", urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings)
        if urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings", urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings)
        if user_enrollment_disabled_factors is not None:
            pulumi.set(__self__, "user_enrollment_disabled_factors", user_enrollment_disabled_factors)
        if yubico_otp_enabled is not None:
            pulumi.set(__self__, "yubico_otp_enabled", yubico_otp_enabled)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="authenticationFactorSettingId")
    def authentication_factor_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the resource
        """
        return pulumi.get(self, "authentication_factor_setting_id")

    @authentication_factor_setting_id.setter
    def authentication_factor_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_factor_setting_id", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="autoEnrollEmailFactorDisabled")
    def auto_enroll_email_factor_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_enroll_email_factor_disabled")

    @auto_enroll_email_factor_disabled.setter
    def auto_enroll_email_factor_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_enroll_email_factor_disabled", value)

    @property
    @pulumi.getter(name="bypassCodeEnabled")
    def bypass_code_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that Bypass Code is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_enabled")

    @bypass_code_enabled.setter
    def bypass_code_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_code_enabled", value)

    @property
    @pulumi.getter(name="bypassCodeSettings")
    def bypass_code_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs']]:
        """
        (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_settings")

    @bypass_code_settings.setter
    def bypass_code_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs']]):
        pulumi.set(self, "bypass_code_settings", value)

    @property
    @pulumi.getter(name="clientAppSettings")
    def client_app_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs']]:
        """
        (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "client_app_settings")

    @client_app_settings.setter
    def client_app_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingClientAppSettingsArgs']]):
        pulumi.set(self, "client_app_settings", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="compliancePolicies")
    def compliance_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]]]:
        """
        (Updatable) Compliance Policy that defines actions to be taken when a condition is violated

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "compliance_policies")

    @compliance_policies.setter
    def compliance_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingCompliancePolicyArgs']]]]):
        pulumi.set(self, "compliance_policies", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="emailEnabled")
    def email_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the EMAIL channel is enabled for authentication

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "email_enabled")

    @email_enabled.setter
    def email_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_enabled", value)

    @property
    @pulumi.getter(name="emailSettings")
    def email_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']]:
        """
        (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "email_settings")

    @email_settings.setter
    def email_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEmailSettingsArgs']]):
        pulumi.set(self, "email_settings", value)

    @property
    @pulumi.getter(name="endpointRestrictions")
    def endpoint_restrictions(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs']]:
        """
        (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "endpoint_restrictions")

    @endpoint_restrictions.setter
    def endpoint_restrictions(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs']]):
        pulumi.set(self, "endpoint_restrictions", value)

    @property
    @pulumi.getter(name="fidoAuthenticatorEnabled")
    def fido_authenticator_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication

        **Added In:** 2009232244

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "fido_authenticator_enabled")

    @fido_authenticator_enabled.setter
    def fido_authenticator_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fido_authenticator_enabled", value)

    @property
    @pulumi.getter(name="hideBackupFactorEnabled")
    def hide_backup_factor_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "hide_backup_factor_enabled")

    @hide_backup_factor_enabled.setter
    def hide_backup_factor_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_backup_factor_enabled", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="identityStoreSettings")
    def identity_store_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']]:
        """
        (Updatable) Settings related to the use of a user's profile details from the identity store

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "identity_store_settings")

    @identity_store_settings.setter
    def identity_store_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs']]):
        pulumi.set(self, "identity_store_settings", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="mfaEnabledCategory")
    def mfa_enabled_category(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the category of people for whom Multi-Factor Authentication is enabled. This is a readOnly attribute which reflects the value of mfaEnabledCategory attribute in SsoSettings

        **Deprecated Since: 18.1.2**

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "mfa_enabled_category")

    @mfa_enabled_category.setter
    def mfa_enabled_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_enabled_category", value)

    @property
    @pulumi.getter(name="mfaEnrollmentType")
    def mfa_enrollment_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user

        **Deprecated Since: 18.1.2**

        **SCIM++ Properties:**
        * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "mfa_enrollment_type")

    @mfa_enrollment_type.setter
    def mfa_enrollment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_enrollment_type", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs']]:
        """
        (Updatable) Settings related to the Mobile App Notification channel, such as pull

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="phoneCallEnabled")
    def phone_call_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "phone_call_enabled")

    @phone_call_enabled.setter
    def phone_call_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "phone_call_enabled", value)

    @property
    @pulumi.getter(name="pushEnabled")
    def push_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "push_enabled")

    @push_enabled.setter
    def push_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_enabled", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="securityQuestionsEnabled")
    def security_questions_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that Security Questions are enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "security_questions_enabled")

    @security_questions_enabled.setter
    def security_questions_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_questions_enabled", value)

    @property
    @pulumi.getter(name="smsEnabled")
    def sms_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "sms_enabled")

    @sms_enabled.setter
    def sms_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sms_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAuthenticationFactorSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="thirdPartyFactor")
    def third_party_factor(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']]:
        """
        (Updatable) Settings related to third-party factor

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "third_party_factor")

    @third_party_factor.setter
    def third_party_factor(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingThirdPartyFactorArgs']]):
        pulumi.set(self, "third_party_factor", value)

    @property
    @pulumi.getter(name="totpEnabled")
    def totp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "totp_enabled")

    @totp_enabled.setter
    def totp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "totp_enabled", value)

    @property
    @pulumi.getter(name="totpSettings")
    def totp_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs']]:
        """
        (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "totp_settings")

    @totp_settings.setter
    def totp_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingTotpSettingsArgs']]):
        pulumi.set(self, "totp_settings", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings")

    @urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings.setter
    def urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings(self) -> Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings")

    @urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings.setter
    def urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings(self, value: Optional[pulumi.Input['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings", value)

    @property
    @pulumi.getter(name="userEnrollmentDisabledFactors")
    def user_enrollment_disabled_factors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Factors for which enrollment should be blocked for End User

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_enrollment_disabled_factors")

    @user_enrollment_disabled_factors.setter
    def user_enrollment_disabled_factors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_enrollment_disabled_factors", value)

    @property
    @pulumi.getter(name="yubicoOtpEnabled")
    def yubico_otp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Yubico OTP is enabled for authentication

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "yubico_otp_enabled")

    @yubico_otp_enabled.setter
    def yubico_otp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "yubico_otp_enabled", value)


class DomainsAuthenticationFactorSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authentication_factor_setting_id: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 auto_enroll_email_factor_disabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_enabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs', 'DomainsAuthenticationFactorSettingBypassCodeSettingsArgsDict']]] = None,
                 client_app_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingClientAppSettingsArgs', 'DomainsAuthenticationFactorSettingClientAppSettingsArgsDict']]] = None,
                 compliance_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingCompliancePolicyArgs', 'DomainsAuthenticationFactorSettingCompliancePolicyArgsDict']]]]] = None,
                 email_enabled: Optional[pulumi.Input[bool]] = None,
                 email_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEmailSettingsArgs', 'DomainsAuthenticationFactorSettingEmailSettingsArgsDict']]] = None,
                 endpoint_restrictions: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs', 'DomainsAuthenticationFactorSettingEndpointRestrictionsArgsDict']]] = None,
                 fido_authenticator_enabled: Optional[pulumi.Input[bool]] = None,
                 hide_backup_factor_enabled: Optional[pulumi.Input[bool]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_store_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs', 'DomainsAuthenticationFactorSettingIdentityStoreSettingsArgsDict']]] = None,
                 mfa_enrollment_type: Optional[pulumi.Input[str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingNotificationSettingsArgs', 'DomainsAuthenticationFactorSettingNotificationSettingsArgsDict']]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 phone_call_enabled: Optional[pulumi.Input[bool]] = None,
                 push_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_questions_enabled: Optional[pulumi.Input[bool]] = None,
                 sms_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingTagArgs', 'DomainsAuthenticationFactorSettingTagArgsDict']]]]] = None,
                 third_party_factor: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingThirdPartyFactorArgs', 'DomainsAuthenticationFactorSettingThirdPartyFactorArgsDict']]] = None,
                 totp_enabled: Optional[pulumi.Input[bool]] = None,
                 totp_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingTotpSettingsArgs', 'DomainsAuthenticationFactorSettingTotpSettingsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgsDict']]] = None,
                 user_enrollment_disabled_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yubico_otp_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Authentication Factor Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace Authentication Factor Settings

        ## Import

        AuthenticationFactorSettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsAuthenticationFactorSetting:DomainsAuthenticationFactorSetting test_authentication_factor_setting "idcsEndpoint/{idcsEndpoint}/authenticationFactorSettings/{authenticationFactorSettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authentication_factor_setting_id: ID of the resource
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] auto_enroll_email_factor_disabled: (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] bypass_code_enabled: (Updatable) If true, indicates that Bypass Code is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs', 'DomainsAuthenticationFactorSettingBypassCodeSettingsArgsDict']] bypass_code_settings: (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingClientAppSettingsArgs', 'DomainsAuthenticationFactorSettingClientAppSettingsArgsDict']] client_app_settings: (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingCompliancePolicyArgs', 'DomainsAuthenticationFactorSettingCompliancePolicyArgsDict']]]] compliance_policies: (Updatable) Compliance Policy that defines actions to be taken when a condition is violated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] email_enabled: (Updatable) If true, indicates that the EMAIL channel is enabled for authentication
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingEmailSettingsArgs', 'DomainsAuthenticationFactorSettingEmailSettingsArgsDict']] email_settings: (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs', 'DomainsAuthenticationFactorSettingEndpointRestrictionsArgsDict']] endpoint_restrictions: (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] fido_authenticator_enabled: (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication
               
               **Added In:** 2009232244
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] hide_backup_factor_enabled: (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs', 'DomainsAuthenticationFactorSettingIdentityStoreSettingsArgsDict']] identity_store_settings: (Updatable) Settings related to the use of a user's profile details from the identity store
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] mfa_enrollment_type: (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingNotificationSettingsArgs', 'DomainsAuthenticationFactorSettingNotificationSettingsArgsDict']] notification_settings: (Updatable) Settings related to the Mobile App Notification channel, such as pull
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[bool] phone_call_enabled: (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] push_enabled: (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] security_questions_enabled: (Updatable) If true, indicates that Security Questions are enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] sms_enabled: (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingTagArgs', 'DomainsAuthenticationFactorSettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingThirdPartyFactorArgs', 'DomainsAuthenticationFactorSettingThirdPartyFactorArgsDict']] third_party_factor: (Updatable) Settings related to third-party factor
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] totp_enabled: (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingTotpSettingsArgs', 'DomainsAuthenticationFactorSettingTotpSettingsArgsDict']] totp_settings: (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgsDict']] urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgsDict']] urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_enrollment_disabled_factors: (Updatable) Factors for which enrollment should be blocked for End User
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] yubico_otp_enabled: (Updatable) If true, indicates that the Yubico OTP is enabled for authentication
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsAuthenticationFactorSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Authentication Factor Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace Authentication Factor Settings

        ## Import

        AuthenticationFactorSettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsAuthenticationFactorSetting:DomainsAuthenticationFactorSetting test_authentication_factor_setting "idcsEndpoint/{idcsEndpoint}/authenticationFactorSettings/{authenticationFactorSettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsAuthenticationFactorSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsAuthenticationFactorSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authentication_factor_setting_id: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 auto_enroll_email_factor_disabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_enabled: Optional[pulumi.Input[bool]] = None,
                 bypass_code_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs', 'DomainsAuthenticationFactorSettingBypassCodeSettingsArgsDict']]] = None,
                 client_app_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingClientAppSettingsArgs', 'DomainsAuthenticationFactorSettingClientAppSettingsArgsDict']]] = None,
                 compliance_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingCompliancePolicyArgs', 'DomainsAuthenticationFactorSettingCompliancePolicyArgsDict']]]]] = None,
                 email_enabled: Optional[pulumi.Input[bool]] = None,
                 email_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEmailSettingsArgs', 'DomainsAuthenticationFactorSettingEmailSettingsArgsDict']]] = None,
                 endpoint_restrictions: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs', 'DomainsAuthenticationFactorSettingEndpointRestrictionsArgsDict']]] = None,
                 fido_authenticator_enabled: Optional[pulumi.Input[bool]] = None,
                 hide_backup_factor_enabled: Optional[pulumi.Input[bool]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_store_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs', 'DomainsAuthenticationFactorSettingIdentityStoreSettingsArgsDict']]] = None,
                 mfa_enrollment_type: Optional[pulumi.Input[str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingNotificationSettingsArgs', 'DomainsAuthenticationFactorSettingNotificationSettingsArgsDict']]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 phone_call_enabled: Optional[pulumi.Input[bool]] = None,
                 push_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_questions_enabled: Optional[pulumi.Input[bool]] = None,
                 sms_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingTagArgs', 'DomainsAuthenticationFactorSettingTagArgsDict']]]]] = None,
                 third_party_factor: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingThirdPartyFactorArgs', 'DomainsAuthenticationFactorSettingThirdPartyFactorArgsDict']]] = None,
                 totp_enabled: Optional[pulumi.Input[bool]] = None,
                 totp_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingTotpSettingsArgs', 'DomainsAuthenticationFactorSettingTotpSettingsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgsDict']]] = None,
                 user_enrollment_disabled_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yubico_otp_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsAuthenticationFactorSettingArgs.__new__(DomainsAuthenticationFactorSettingArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            if authentication_factor_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_factor_setting_id'")
            __props__.__dict__["authentication_factor_setting_id"] = authentication_factor_setting_id
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["auto_enroll_email_factor_disabled"] = auto_enroll_email_factor_disabled
            if bypass_code_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'bypass_code_enabled'")
            __props__.__dict__["bypass_code_enabled"] = bypass_code_enabled
            if bypass_code_settings is None and not opts.urn:
                raise TypeError("Missing required property 'bypass_code_settings'")
            __props__.__dict__["bypass_code_settings"] = bypass_code_settings
            if client_app_settings is None and not opts.urn:
                raise TypeError("Missing required property 'client_app_settings'")
            __props__.__dict__["client_app_settings"] = client_app_settings
            if compliance_policies is None and not opts.urn:
                raise TypeError("Missing required property 'compliance_policies'")
            __props__.__dict__["compliance_policies"] = compliance_policies
            __props__.__dict__["email_enabled"] = email_enabled
            __props__.__dict__["email_settings"] = email_settings
            if endpoint_restrictions is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_restrictions'")
            __props__.__dict__["endpoint_restrictions"] = endpoint_restrictions
            __props__.__dict__["fido_authenticator_enabled"] = fido_authenticator_enabled
            __props__.__dict__["hide_backup_factor_enabled"] = hide_backup_factor_enabled
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["identity_store_settings"] = identity_store_settings
            if mfa_enrollment_type is None and not opts.urn:
                raise TypeError("Missing required property 'mfa_enrollment_type'")
            __props__.__dict__["mfa_enrollment_type"] = mfa_enrollment_type
            if notification_settings is None and not opts.urn:
                raise TypeError("Missing required property 'notification_settings'")
            __props__.__dict__["notification_settings"] = notification_settings
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["phone_call_enabled"] = phone_call_enabled
            if push_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'push_enabled'")
            __props__.__dict__["push_enabled"] = push_enabled
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            if security_questions_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'security_questions_enabled'")
            __props__.__dict__["security_questions_enabled"] = security_questions_enabled
            if sms_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'sms_enabled'")
            __props__.__dict__["sms_enabled"] = sms_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["third_party_factor"] = third_party_factor
            if totp_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'totp_enabled'")
            __props__.__dict__["totp_enabled"] = totp_enabled
            if totp_settings is None and not opts.urn:
                raise TypeError("Missing required property 'totp_settings'")
            __props__.__dict__["totp_settings"] = totp_settings
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings"] = urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings"] = urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings
            __props__.__dict__["user_enrollment_disabled_factors"] = user_enrollment_disabled_factors
            __props__.__dict__["yubico_otp_enabled"] = yubico_otp_enabled
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["mfa_enabled_category"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsAuthenticationFactorSetting, __self__).__init__(
            'oci:Identity/domainsAuthenticationFactorSetting:DomainsAuthenticationFactorSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authentication_factor_setting_id: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            auto_enroll_email_factor_disabled: Optional[pulumi.Input[bool]] = None,
            bypass_code_enabled: Optional[pulumi.Input[bool]] = None,
            bypass_code_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs', 'DomainsAuthenticationFactorSettingBypassCodeSettingsArgsDict']]] = None,
            client_app_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingClientAppSettingsArgs', 'DomainsAuthenticationFactorSettingClientAppSettingsArgsDict']]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            compliance_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingCompliancePolicyArgs', 'DomainsAuthenticationFactorSettingCompliancePolicyArgsDict']]]]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            email_enabled: Optional[pulumi.Input[bool]] = None,
            email_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEmailSettingsArgs', 'DomainsAuthenticationFactorSettingEmailSettingsArgsDict']]] = None,
            endpoint_restrictions: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs', 'DomainsAuthenticationFactorSettingEndpointRestrictionsArgsDict']]] = None,
            fido_authenticator_enabled: Optional[pulumi.Input[bool]] = None,
            hide_backup_factor_enabled: Optional[pulumi.Input[bool]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdcsCreatedByArgs', 'DomainsAuthenticationFactorSettingIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs', 'DomainsAuthenticationFactorSettingIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            identity_store_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs', 'DomainsAuthenticationFactorSettingIdentityStoreSettingsArgsDict']]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingMetaArgs', 'DomainsAuthenticationFactorSettingMetaArgsDict']]]]] = None,
            mfa_enabled_category: Optional[pulumi.Input[str]] = None,
            mfa_enrollment_type: Optional[pulumi.Input[str]] = None,
            notification_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingNotificationSettingsArgs', 'DomainsAuthenticationFactorSettingNotificationSettingsArgsDict']]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            phone_call_enabled: Optional[pulumi.Input[bool]] = None,
            push_enabled: Optional[pulumi.Input[bool]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_questions_enabled: Optional[pulumi.Input[bool]] = None,
            sms_enabled: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingTagArgs', 'DomainsAuthenticationFactorSettingTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            third_party_factor: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingThirdPartyFactorArgs', 'DomainsAuthenticationFactorSettingThirdPartyFactorArgsDict']]] = None,
            totp_enabled: Optional[pulumi.Input[bool]] = None,
            totp_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingTotpSettingsArgs', 'DomainsAuthenticationFactorSettingTotpSettingsArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: Optional[pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgsDict']]] = None,
            user_enrollment_disabled_factors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            yubico_otp_enabled: Optional[pulumi.Input[bool]] = None) -> 'DomainsAuthenticationFactorSetting':
        """
        Get an existing DomainsAuthenticationFactorSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authentication_factor_setting_id: ID of the resource
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] auto_enroll_email_factor_disabled: (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] bypass_code_enabled: (Updatable) If true, indicates that Bypass Code is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingBypassCodeSettingsArgs', 'DomainsAuthenticationFactorSettingBypassCodeSettingsArgsDict']] bypass_code_settings: (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingClientAppSettingsArgs', 'DomainsAuthenticationFactorSettingClientAppSettingsArgsDict']] client_app_settings: (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingCompliancePolicyArgs', 'DomainsAuthenticationFactorSettingCompliancePolicyArgsDict']]]] compliance_policies: (Updatable) Compliance Policy that defines actions to be taken when a condition is violated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] email_enabled: (Updatable) If true, indicates that the EMAIL channel is enabled for authentication
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingEmailSettingsArgs', 'DomainsAuthenticationFactorSettingEmailSettingsArgsDict']] email_settings: (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingEndpointRestrictionsArgs', 'DomainsAuthenticationFactorSettingEndpointRestrictionsArgsDict']] endpoint_restrictions: (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] fido_authenticator_enabled: (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication
               
               **Added In:** 2009232244
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] hide_backup_factor_enabled: (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication
               
               **Added In:** 19.3.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdcsCreatedByArgs', 'DomainsAuthenticationFactorSettingIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingIdcsLastModifiedByArgs', 'DomainsAuthenticationFactorSettingIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingIdentityStoreSettingsArgs', 'DomainsAuthenticationFactorSettingIdentityStoreSettingsArgsDict']] identity_store_settings: (Updatable) Settings related to the use of a user's profile details from the identity store
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingMetaArgs', 'DomainsAuthenticationFactorSettingMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] mfa_enabled_category: (Updatable) Specifies the category of people for whom Multi-Factor Authentication is enabled. This is a readOnly attribute which reflects the value of mfaEnabledCategory attribute in SsoSettings
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] mfa_enrollment_type: (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user
               
               **Deprecated Since: 18.1.2**
               
               **SCIM++ Properties:**
               * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingNotificationSettingsArgs', 'DomainsAuthenticationFactorSettingNotificationSettingsArgsDict']] notification_settings: (Updatable) Settings related to the Mobile App Notification channel, such as pull
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[bool] phone_call_enabled: (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] push_enabled: (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] security_questions_enabled: (Updatable) If true, indicates that Security Questions are enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] sms_enabled: (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsAuthenticationFactorSettingTagArgs', 'DomainsAuthenticationFactorSettingTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingThirdPartyFactorArgs', 'DomainsAuthenticationFactorSettingThirdPartyFactorArgsDict']] third_party_factor: (Updatable) Settings related to third-party factor
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] totp_enabled: (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingTotpSettingsArgs', 'DomainsAuthenticationFactorSettingTotpSettingsArgsDict']] totp_settings: (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettingsArgsDict']] urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        :param pulumi.Input[Union['DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgs', 'DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettingsArgsDict']] urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_enrollment_disabled_factors: (Updatable) Factors for which enrollment should be blocked for End User
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] yubico_otp_enabled: (Updatable) If true, indicates that the Yubico OTP is enabled for authentication
               
               **Added In:** 2109090424
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsAuthenticationFactorSettingState.__new__(_DomainsAuthenticationFactorSettingState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authentication_factor_setting_id"] = authentication_factor_setting_id
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["auto_enroll_email_factor_disabled"] = auto_enroll_email_factor_disabled
        __props__.__dict__["bypass_code_enabled"] = bypass_code_enabled
        __props__.__dict__["bypass_code_settings"] = bypass_code_settings
        __props__.__dict__["client_app_settings"] = client_app_settings
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["compliance_policies"] = compliance_policies
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["email_enabled"] = email_enabled
        __props__.__dict__["email_settings"] = email_settings
        __props__.__dict__["endpoint_restrictions"] = endpoint_restrictions
        __props__.__dict__["fido_authenticator_enabled"] = fido_authenticator_enabled
        __props__.__dict__["hide_backup_factor_enabled"] = hide_backup_factor_enabled
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["identity_store_settings"] = identity_store_settings
        __props__.__dict__["metas"] = metas
        __props__.__dict__["mfa_enabled_category"] = mfa_enabled_category
        __props__.__dict__["mfa_enrollment_type"] = mfa_enrollment_type
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["phone_call_enabled"] = phone_call_enabled
        __props__.__dict__["push_enabled"] = push_enabled
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["security_questions_enabled"] = security_questions_enabled
        __props__.__dict__["sms_enabled"] = sms_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["third_party_factor"] = third_party_factor
        __props__.__dict__["totp_enabled"] = totp_enabled
        __props__.__dict__["totp_settings"] = totp_settings
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings"] = urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings"] = urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings
        __props__.__dict__["user_enrollment_disabled_factors"] = user_enrollment_disabled_factors
        __props__.__dict__["yubico_otp_enabled"] = yubico_otp_enabled
        return DomainsAuthenticationFactorSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="authenticationFactorSettingId")
    def authentication_factor_setting_id(self) -> pulumi.Output[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "authentication_factor_setting_id")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="autoEnrollEmailFactorDisabled")
    def auto_enroll_email_factor_disabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that email will not be enrolled as a MFA factor automatically if it a account recovery factor

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "auto_enroll_email_factor_disabled")

    @property
    @pulumi.getter(name="bypassCodeEnabled")
    def bypass_code_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that Bypass Code is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_enabled")

    @property
    @pulumi.getter(name="bypassCodeSettings")
    def bypass_code_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingBypassCodeSettings']:
        """
        (Updatable) Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_code_settings")

    @property
    @pulumi.getter(name="clientAppSettings")
    def client_app_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingClientAppSettings']:
        """
        (Updatable) Settings related to compliance, Personal Identification Number (PIN) policy, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "client_app_settings")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="compliancePolicies")
    def compliance_policies(self) -> pulumi.Output[Sequence['outputs.DomainsAuthenticationFactorSettingCompliancePolicy']]:
        """
        (Updatable) Compliance Policy that defines actions to be taken when a condition is violated

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "compliance_policies")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="emailEnabled")
    def email_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the EMAIL channel is enabled for authentication

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "email_enabled")

    @property
    @pulumi.getter(name="emailSettings")
    def email_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingEmailSettings']:
        """
        (Updatable) Settings related to Email Factor, such as enabled email magic link factor, custom url for Email Link

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "email_settings")

    @property
    @pulumi.getter(name="endpointRestrictions")
    def endpoint_restrictions(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingEndpointRestrictions']:
        """
        (Updatable) Settings that describe the set of restrictions that the system should apply to devices and trusted endpoints of a user

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "endpoint_restrictions")

    @property
    @pulumi.getter(name="fidoAuthenticatorEnabled")
    def fido_authenticator_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Fido Authenticator channels are enabled for authentication

        **Added In:** 2009232244

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "fido_authenticator_enabled")

    @property
    @pulumi.getter(name="hideBackupFactorEnabled")
    def hide_backup_factor_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that 'Show backup factor(s)' button will be hidden during authentication

        **Added In:** 19.3.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "hide_backup_factor_enabled")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAuthenticationFactorSettingIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAuthenticationFactorSettingIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="identityStoreSettings")
    def identity_store_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingIdentityStoreSettings']:
        """
        (Updatable) Settings related to the use of a user's profile details from the identity store

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "identity_store_settings")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsAuthenticationFactorSettingMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="mfaEnabledCategory")
    def mfa_enabled_category(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies the category of people for whom Multi-Factor Authentication is enabled. This is a readOnly attribute which reflects the value of mfaEnabledCategory attribute in SsoSettings

        **Deprecated Since: 18.1.2**

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "mfa_enabled_category")

    @property
    @pulumi.getter(name="mfaEnrollmentType")
    def mfa_enrollment_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies if Multi-Factor Authentication enrollment is mandatory or optional for a user

        **Deprecated Since: 18.1.2**

        **SCIM++ Properties:**
        * idcsCanonicalValueSourceFilter: attrName eq "mfaEnrollmentType" and attrValues.value eq "$(mfaEnrollmentType)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "mfa_enrollment_type")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingNotificationSettings']:
        """
        (Updatable) Settings related to the Mobile App Notification channel, such as pull

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="phoneCallEnabled")
    def phone_call_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the phone (PHONE_CALL) channel is enabled for authentication

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "phone_call_enabled")

    @property
    @pulumi.getter(name="pushEnabled")
    def push_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Mobile App Push Notification channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "push_enabled")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="securityQuestionsEnabled")
    def security_questions_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that Security Questions are enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "security_questions_enabled")

    @property
    @pulumi.getter(name="smsEnabled")
    def sms_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Short Message Service (SMS) channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "sms_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsAuthenticationFactorSettingTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="thirdPartyFactor")
    def third_party_factor(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingThirdPartyFactor']:
        """
        (Updatable) Settings related to third-party factor

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "third_party_factor")

    @property
    @pulumi.getter(name="totpEnabled")
    def totp_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Mobile App One Time Passcode channel is enabled for authentication

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "totp_enabled")

    @property
    @pulumi.getter(name="totpSettings")
    def totp_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingTotpSettings']:
        """
        (Updatable) Settings related to Time-Based One-Time Passcodes (TOTP), such as hashing algo, totp time step, passcode length, and so on

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "totp_settings")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionfidoAuthenticationFactorSettings']:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of fido authentication
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionfido_authentication_factor_settings")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettings")
    def urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings(self) -> pulumi.Output['outputs.DomainsAuthenticationFactorSettingUrnietfparamsscimschemasoracleidcsextensionthirdPartyAuthenticationFactorSettings']:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication settings of third party provider
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionthird_party_authentication_factor_settings")

    @property
    @pulumi.getter(name="userEnrollmentDisabledFactors")
    def user_enrollment_disabled_factors(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Factors for which enrollment should be blocked for End User

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_enrollment_disabled_factors")

    @property
    @pulumi.getter(name="yubicoOtpEnabled")
    def yubico_otp_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Yubico OTP is enabled for authentication

        **Added In:** 2109090424

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "yubico_otp_enabled")

