# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMediaWorkflowJobsResult',
    'AwaitableGetMediaWorkflowJobsResult',
    'get_media_workflow_jobs',
    'get_media_workflow_jobs_output',
]

@pulumi.output_type
class GetMediaWorkflowJobsResult:
    """
    A collection of values returned by getMediaWorkflowJobs.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, media_workflow_id=None, media_workflow_job_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if media_workflow_id and not isinstance(media_workflow_id, str):
            raise TypeError("Expected argument 'media_workflow_id' to be a str")
        pulumi.set(__self__, "media_workflow_id", media_workflow_id)
        if media_workflow_job_collections and not isinstance(media_workflow_job_collections, list):
            raise TypeError("Expected argument 'media_workflow_job_collections' to be a list")
        pulumi.set(__self__, "media_workflow_job_collections", media_workflow_job_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMediaWorkflowJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID associated with the job output.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mediaWorkflowId")
    def media_workflow_id(self) -> Optional[str]:
        """
        The workflow to execute.
        """
        return pulumi.get(self, "media_workflow_id")

    @property
    @pulumi.getter(name="mediaWorkflowJobCollections")
    def media_workflow_job_collections(self) -> Sequence['outputs.GetMediaWorkflowJobsMediaWorkflowJobCollectionResult']:
        """
        The list of media_workflow_job_collection.
        """
        return pulumi.get(self, "media_workflow_job_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")


class AwaitableGetMediaWorkflowJobsResult(GetMediaWorkflowJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaWorkflowJobsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            media_workflow_id=self.media_workflow_id,
            media_workflow_job_collections=self.media_workflow_job_collections,
            state=self.state)


def get_media_workflow_jobs(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetMediaWorkflowJobsFilterArgs', 'GetMediaWorkflowJobsFilterArgsDict']]] = None,
                            id: Optional[str] = None,
                            media_workflow_id: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaWorkflowJobsResult:
    """
    This data source provides the list of Media Workflow Jobs in Oracle Cloud Infrastructure Media Services service.

    Lists the MediaWorkflowJobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_jobs = oci.MediaServices.get_media_workflow_jobs(compartment_id=compartment_id,
        display_name=media_workflow_job_display_name,
        id=media_workflow_job_id,
        media_workflow_id=test_media_workflow["id"],
        state=media_workflow_job_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str id: unique MediaWorkflowJob identifier
    :param str media_workflow_id: Unique MediaWorkflow identifier.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['mediaWorkflowId'] = media_workflow_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaWorkflowJobs:getMediaWorkflowJobs', __args__, opts=opts, typ=GetMediaWorkflowJobsResult).value

    return AwaitableGetMediaWorkflowJobsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        media_workflow_id=pulumi.get(__ret__, 'media_workflow_id'),
        media_workflow_job_collections=pulumi.get(__ret__, 'media_workflow_job_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_media_workflow_jobs_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMediaWorkflowJobsFilterArgs', 'GetMediaWorkflowJobsFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   media_workflow_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMediaWorkflowJobsResult]:
    """
    This data source provides the list of Media Workflow Jobs in Oracle Cloud Infrastructure Media Services service.

    Lists the MediaWorkflowJobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_jobs = oci.MediaServices.get_media_workflow_jobs(compartment_id=compartment_id,
        display_name=media_workflow_job_display_name,
        id=media_workflow_job_id,
        media_workflow_id=test_media_workflow["id"],
        state=media_workflow_job_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str id: unique MediaWorkflowJob identifier
    :param str media_workflow_id: Unique MediaWorkflow identifier.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['mediaWorkflowId'] = media_workflow_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getMediaWorkflowJobs:getMediaWorkflowJobs', __args__, opts=opts, typ=GetMediaWorkflowJobsResult)
    return __ret__.apply(lambda __response__: GetMediaWorkflowJobsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        media_workflow_id=pulumi.get(__response__, 'media_workflow_id'),
        media_workflow_job_collections=pulumi.get(__response__, 'media_workflow_job_collections'),
        state=pulumi.get(__response__, 'state')))
