# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceArgs', 'BdsInstance']

@pulumi.input_type
class BdsInstanceArgs:
    def __init__(__self__, *,
                 cluster_admin_password: pulumi.Input[str],
                 cluster_public_key: pulumi.Input[str],
                 cluster_version: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 is_high_availability: pulumi.Input[bool],
                 is_secure: pulumi.Input[bool],
                 master_node: pulumi.Input['BdsInstanceMasterNodeArgs'],
                 util_node: pulumi.Input['BdsInstanceUtilNodeArgs'],
                 worker_node: pulumi.Input['BdsInstanceWorkerNodeArgs'],
                 bootstrap_script_url: Optional[pulumi.Input[str]] = None,
                 cloud_sql_details: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]] = None,
                 cluster_profile: Optional[pulumi.Input[str]] = None,
                 compute_only_worker_node: Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 edge_node: Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ignore_existing_nodes_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_cloud_sql_configured: Optional[pulumi.Input[bool]] = None,
                 is_force_stop_jobs: Optional[pulumi.Input[bool]] = None,
                 is_kafka_configured: Optional[pulumi.Input[bool]] = None,
                 kafka_broker_node: Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']] = None,
                 kerberos_realm_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']] = None,
                 os_patch_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BdsInstance resource.
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[str] cluster_public_key: The SSH public key used to authenticate the cluster connection.
        :param pulumi.Input[str] cluster_version: Version of the Hadoop distribution
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment
        :param pulumi.Input[str] display_name: (Updatable) Name of the BDS instance
        :param pulumi.Input[bool] is_high_availability: Boolean flag specifying whether or not the cluster is HA
        :param pulumi.Input[bool] is_secure: Boolean flag specifying whether or not the cluster should be setup as secure.
        :param pulumi.Input['BdsInstanceMasterNodeArgs'] master_node: The master node in the BDS instance
        :param pulumi.Input['BdsInstanceUtilNodeArgs'] util_node: The utility node in the BDS instance
        :param pulumi.Input[str] bootstrap_script_url: (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]] cloud_sql_details: The information about added Cloud SQL capability
        :param pulumi.Input[str] cluster_profile: Profile of the Big Data Service cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_existing_nodes_shapes: Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        :param pulumi.Input[bool] is_cloud_sql_configured: (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        :param pulumi.Input[bool] is_force_stop_jobs: (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        :param pulumi.Input[bool] is_kafka_configured: Boolean flag specifying whether or not Kafka should be configured.
        :param pulumi.Input['BdsInstanceKafkaBrokerNodeArgs'] kafka_broker_node: The kafka broker node in the BDS instance
        :param pulumi.Input[str] kerberos_realm_name: The user-defined kerberos realm name.
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of the Key Management master encryption key.
        :param pulumi.Input['BdsInstanceNetworkConfigArgs'] network_config: Additional configuration of the user's network.
        :param pulumi.Input[str] os_patch_version: (Updatable) The version of the patch to be upated.
        :param pulumi.Input[str] state: (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        """
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_high_availability", is_high_availability)
        pulumi.set(__self__, "is_secure", is_secure)
        pulumi.set(__self__, "master_node", master_node)
        pulumi.set(__self__, "util_node", util_node)
        pulumi.set(__self__, "worker_node", worker_node)
        if bootstrap_script_url is not None:
            pulumi.set(__self__, "bootstrap_script_url", bootstrap_script_url)
        if cloud_sql_details is not None:
            pulumi.set(__self__, "cloud_sql_details", cloud_sql_details)
        if cluster_profile is not None:
            pulumi.set(__self__, "cluster_profile", cluster_profile)
        if compute_only_worker_node is not None:
            pulumi.set(__self__, "compute_only_worker_node", compute_only_worker_node)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if edge_node is not None:
            pulumi.set(__self__, "edge_node", edge_node)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ignore_existing_nodes_shapes is not None:
            pulumi.set(__self__, "ignore_existing_nodes_shapes", ignore_existing_nodes_shapes)
        if is_cloud_sql_configured is not None:
            pulumi.set(__self__, "is_cloud_sql_configured", is_cloud_sql_configured)
        if is_force_stop_jobs is not None:
            pulumi.set(__self__, "is_force_stop_jobs", is_force_stop_jobs)
        if is_kafka_configured is not None:
            pulumi.set(__self__, "is_kafka_configured", is_kafka_configured)
        if kafka_broker_node is not None:
            pulumi.set(__self__, "kafka_broker_node", kafka_broker_node)
        if kerberos_realm_name is not None:
            pulumi.set(__self__, "kerberos_realm_name", kerberos_realm_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if os_patch_version is not None:
            pulumi.set(__self__, "os_patch_version", os_patch_version)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[str]:
        """
        Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> pulumi.Input[str]:
        """
        The SSH public key used to authenticate the cluster connection.
        """
        return pulumi.get(self, "cluster_public_key")

    @cluster_public_key.setter
    def cluster_public_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_public_key", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[str]:
        """
        Version of the Hadoop distribution
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the BDS instance
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isHighAvailability")
    def is_high_availability(self) -> pulumi.Input[bool]:
        """
        Boolean flag specifying whether or not the cluster is HA
        """
        return pulumi.get(self, "is_high_availability")

    @is_high_availability.setter
    def is_high_availability(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_high_availability", value)

    @property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> pulumi.Input[bool]:
        """
        Boolean flag specifying whether or not the cluster should be setup as secure.
        """
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_secure", value)

    @property
    @pulumi.getter(name="masterNode")
    def master_node(self) -> pulumi.Input['BdsInstanceMasterNodeArgs']:
        """
        The master node in the BDS instance
        """
        return pulumi.get(self, "master_node")

    @master_node.setter
    def master_node(self, value: pulumi.Input['BdsInstanceMasterNodeArgs']):
        pulumi.set(self, "master_node", value)

    @property
    @pulumi.getter(name="utilNode")
    def util_node(self) -> pulumi.Input['BdsInstanceUtilNodeArgs']:
        """
        The utility node in the BDS instance
        """
        return pulumi.get(self, "util_node")

    @util_node.setter
    def util_node(self, value: pulumi.Input['BdsInstanceUtilNodeArgs']):
        pulumi.set(self, "util_node", value)

    @property
    @pulumi.getter(name="workerNode")
    def worker_node(self) -> pulumi.Input['BdsInstanceWorkerNodeArgs']:
        return pulumi.get(self, "worker_node")

    @worker_node.setter
    def worker_node(self, value: pulumi.Input['BdsInstanceWorkerNodeArgs']):
        pulumi.set(self, "worker_node", value)

    @property
    @pulumi.getter(name="bootstrapScriptUrl")
    def bootstrap_script_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        """
        return pulumi.get(self, "bootstrap_script_url")

    @bootstrap_script_url.setter
    def bootstrap_script_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_script_url", value)

    @property
    @pulumi.getter(name="cloudSqlDetails")
    def cloud_sql_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]]:
        """
        The information about added Cloud SQL capability
        """
        return pulumi.get(self, "cloud_sql_details")

    @cloud_sql_details.setter
    def cloud_sql_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]]):
        pulumi.set(self, "cloud_sql_details", value)

    @property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Profile of the Big Data Service cluster.
        """
        return pulumi.get(self, "cluster_profile")

    @cluster_profile.setter
    def cluster_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_profile", value)

    @property
    @pulumi.getter(name="computeOnlyWorkerNode")
    def compute_only_worker_node(self) -> Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']]:
        return pulumi.get(self, "compute_only_worker_node")

    @compute_only_worker_node.setter
    def compute_only_worker_node(self, value: Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']]):
        pulumi.set(self, "compute_only_worker_node", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="edgeNode")
    def edge_node(self) -> Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']]:
        return pulumi.get(self, "edge_node")

    @edge_node.setter
    def edge_node(self, value: Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']]):
        pulumi.set(self, "edge_node", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ignoreExistingNodesShapes")
    def ignore_existing_nodes_shapes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        """
        return pulumi.get(self, "ignore_existing_nodes_shapes")

    @ignore_existing_nodes_shapes.setter
    def ignore_existing_nodes_shapes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ignore_existing_nodes_shapes", value)

    @property
    @pulumi.getter(name="isCloudSqlConfigured")
    def is_cloud_sql_configured(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        """
        return pulumi.get(self, "is_cloud_sql_configured")

    @is_cloud_sql_configured.setter
    def is_cloud_sql_configured(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloud_sql_configured", value)

    @property
    @pulumi.getter(name="isForceStopJobs")
    def is_force_stop_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        """
        return pulumi.get(self, "is_force_stop_jobs")

    @is_force_stop_jobs.setter
    def is_force_stop_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_stop_jobs", value)

    @property
    @pulumi.getter(name="isKafkaConfigured")
    def is_kafka_configured(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag specifying whether or not Kafka should be configured.
        """
        return pulumi.get(self, "is_kafka_configured")

    @is_kafka_configured.setter
    def is_kafka_configured(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kafka_configured", value)

    @property
    @pulumi.getter(name="kafkaBrokerNode")
    def kafka_broker_node(self) -> Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']]:
        """
        The kafka broker node in the BDS instance
        """
        return pulumi.get(self, "kafka_broker_node")

    @kafka_broker_node.setter
    def kafka_broker_node(self, value: Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']]):
        pulumi.set(self, "kafka_broker_node", value)

    @property
    @pulumi.getter(name="kerberosRealmName")
    def kerberos_realm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-defined kerberos realm name.
        """
        return pulumi.get(self, "kerberos_realm_name")

    @kerberos_realm_name.setter
    def kerberos_realm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kerberos_realm_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Key Management master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']]:
        """
        Additional configuration of the user's network.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the patch to be upated.
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_patch_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _BdsInstanceState:
    def __init__(__self__, *,
                 bootstrap_script_url: Optional[pulumi.Input[str]] = None,
                 cloud_sql_details: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceClusterDetailArgs']]]] = None,
                 cluster_profile: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_only_worker_node: Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 edge_node: Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ignore_existing_nodes_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_cloud_sql_configured: Optional[pulumi.Input[bool]] = None,
                 is_force_stop_jobs: Optional[pulumi.Input[bool]] = None,
                 is_high_availability: Optional[pulumi.Input[bool]] = None,
                 is_kafka_configured: Optional[pulumi.Input[bool]] = None,
                 is_secure: Optional[pulumi.Input[bool]] = None,
                 kafka_broker_node: Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']] = None,
                 kerberos_realm_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_node: Optional[pulumi.Input['BdsInstanceMasterNodeArgs']] = None,
                 network_config: Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceNodeArgs']]]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 number_of_nodes_requiring_maintenance_reboot: Optional[pulumi.Input[int]] = None,
                 os_patch_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 util_node: Optional[pulumi.Input['BdsInstanceUtilNodeArgs']] = None,
                 worker_node: Optional[pulumi.Input['BdsInstanceWorkerNodeArgs']] = None):
        """
        Input properties used for looking up and filtering BdsInstance resources.
        :param pulumi.Input[str] bootstrap_script_url: (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]] cloud_sql_details: The information about added Cloud SQL capability
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceClusterDetailArgs']]] cluster_details: Specific info about a Hadoop cluster
        :param pulumi.Input[str] cluster_profile: Profile of the Big Data Service cluster.
        :param pulumi.Input[str] cluster_public_key: The SSH public key used to authenticate the cluster connection.
        :param pulumi.Input[str] cluster_version: Version of the Hadoop distribution
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment
        :param pulumi.Input[str] created_by: The user who created the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the BDS instance
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_existing_nodes_shapes: Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        :param pulumi.Input[bool] is_cloud_sql_configured: (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        :param pulumi.Input[bool] is_force_stop_jobs: (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        :param pulumi.Input[bool] is_high_availability: Boolean flag specifying whether or not the cluster is HA
        :param pulumi.Input[bool] is_kafka_configured: Boolean flag specifying whether or not Kafka should be configured.
        :param pulumi.Input[bool] is_secure: Boolean flag specifying whether or not the cluster should be setup as secure.
        :param pulumi.Input['BdsInstanceKafkaBrokerNodeArgs'] kafka_broker_node: The kafka broker node in the BDS instance
        :param pulumi.Input[str] kerberos_realm_name: The user-defined kerberos realm name.
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of the Key Management master encryption key.
        :param pulumi.Input['BdsInstanceMasterNodeArgs'] master_node: The master node in the BDS instance
        :param pulumi.Input['BdsInstanceNetworkConfigArgs'] network_config: Additional configuration of the user's network.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceNodeArgs']]] nodes: The list of nodes in the Big Data Service cluster.
        :param pulumi.Input[int] number_of_nodes: Number of nodes that forming the cluster
        :param pulumi.Input[int] number_of_nodes_requiring_maintenance_reboot: Number of nodes that require a maintenance reboot
        :param pulumi.Input[str] os_patch_version: (Updatable) The version of the patch to be upated.
        :param pulumi.Input[str] state: (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        :param pulumi.Input[str] time_created: The time the BDS instance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the BDS instance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input['BdsInstanceUtilNodeArgs'] util_node: The utility node in the BDS instance
        """
        if bootstrap_script_url is not None:
            pulumi.set(__self__, "bootstrap_script_url", bootstrap_script_url)
        if cloud_sql_details is not None:
            pulumi.set(__self__, "cloud_sql_details", cloud_sql_details)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if cluster_details is not None:
            pulumi.set(__self__, "cluster_details", cluster_details)
        if cluster_profile is not None:
            pulumi.set(__self__, "cluster_profile", cluster_profile)
        if cluster_public_key is not None:
            pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_only_worker_node is not None:
            pulumi.set(__self__, "compute_only_worker_node", compute_only_worker_node)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if edge_node is not None:
            pulumi.set(__self__, "edge_node", edge_node)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ignore_existing_nodes_shapes is not None:
            pulumi.set(__self__, "ignore_existing_nodes_shapes", ignore_existing_nodes_shapes)
        if is_cloud_sql_configured is not None:
            pulumi.set(__self__, "is_cloud_sql_configured", is_cloud_sql_configured)
        if is_force_stop_jobs is not None:
            pulumi.set(__self__, "is_force_stop_jobs", is_force_stop_jobs)
        if is_high_availability is not None:
            pulumi.set(__self__, "is_high_availability", is_high_availability)
        if is_kafka_configured is not None:
            pulumi.set(__self__, "is_kafka_configured", is_kafka_configured)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if kafka_broker_node is not None:
            pulumi.set(__self__, "kafka_broker_node", kafka_broker_node)
        if kerberos_realm_name is not None:
            pulumi.set(__self__, "kerberos_realm_name", kerberos_realm_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_node is not None:
            pulumi.set(__self__, "master_node", master_node)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if number_of_nodes_requiring_maintenance_reboot is not None:
            pulumi.set(__self__, "number_of_nodes_requiring_maintenance_reboot", number_of_nodes_requiring_maintenance_reboot)
        if os_patch_version is not None:
            pulumi.set(__self__, "os_patch_version", os_patch_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if util_node is not None:
            pulumi.set(__self__, "util_node", util_node)
        if worker_node is not None:
            pulumi.set(__self__, "worker_node", worker_node)

    @property
    @pulumi.getter(name="bootstrapScriptUrl")
    def bootstrap_script_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        """
        return pulumi.get(self, "bootstrap_script_url")

    @bootstrap_script_url.setter
    def bootstrap_script_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_script_url", value)

    @property
    @pulumi.getter(name="cloudSqlDetails")
    def cloud_sql_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]]:
        """
        The information about added Cloud SQL capability
        """
        return pulumi.get(self, "cloud_sql_details")

    @cloud_sql_details.setter
    def cloud_sql_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceCloudSqlDetailArgs']]]]):
        pulumi.set(self, "cloud_sql_details", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceClusterDetailArgs']]]]:
        """
        Specific info about a Hadoop cluster
        """
        return pulumi.get(self, "cluster_details")

    @cluster_details.setter
    def cluster_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceClusterDetailArgs']]]]):
        pulumi.set(self, "cluster_details", value)

    @property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Profile of the Big Data Service cluster.
        """
        return pulumi.get(self, "cluster_profile")

    @cluster_profile.setter
    def cluster_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_profile", value)

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH public key used to authenticate the cluster connection.
        """
        return pulumi.get(self, "cluster_public_key")

    @cluster_public_key.setter
    def cluster_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_public_key", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the Hadoop distribution
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeOnlyWorkerNode")
    def compute_only_worker_node(self) -> Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']]:
        return pulumi.get(self, "compute_only_worker_node")

    @compute_only_worker_node.setter
    def compute_only_worker_node(self, value: Optional[pulumi.Input['BdsInstanceComputeOnlyWorkerNodeArgs']]):
        pulumi.set(self, "compute_only_worker_node", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the BDS instance
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="edgeNode")
    def edge_node(self) -> Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']]:
        return pulumi.get(self, "edge_node")

    @edge_node.setter
    def edge_node(self, value: Optional[pulumi.Input['BdsInstanceEdgeNodeArgs']]):
        pulumi.set(self, "edge_node", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ignoreExistingNodesShapes")
    def ignore_existing_nodes_shapes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        """
        return pulumi.get(self, "ignore_existing_nodes_shapes")

    @ignore_existing_nodes_shapes.setter
    def ignore_existing_nodes_shapes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ignore_existing_nodes_shapes", value)

    @property
    @pulumi.getter(name="isCloudSqlConfigured")
    def is_cloud_sql_configured(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        """
        return pulumi.get(self, "is_cloud_sql_configured")

    @is_cloud_sql_configured.setter
    def is_cloud_sql_configured(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cloud_sql_configured", value)

    @property
    @pulumi.getter(name="isForceStopJobs")
    def is_force_stop_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        """
        return pulumi.get(self, "is_force_stop_jobs")

    @is_force_stop_jobs.setter
    def is_force_stop_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_stop_jobs", value)

    @property
    @pulumi.getter(name="isHighAvailability")
    def is_high_availability(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag specifying whether or not the cluster is HA
        """
        return pulumi.get(self, "is_high_availability")

    @is_high_availability.setter
    def is_high_availability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_high_availability", value)

    @property
    @pulumi.getter(name="isKafkaConfigured")
    def is_kafka_configured(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag specifying whether or not Kafka should be configured.
        """
        return pulumi.get(self, "is_kafka_configured")

    @is_kafka_configured.setter
    def is_kafka_configured(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kafka_configured", value)

    @property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag specifying whether or not the cluster should be setup as secure.
        """
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secure", value)

    @property
    @pulumi.getter(name="kafkaBrokerNode")
    def kafka_broker_node(self) -> Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']]:
        """
        The kafka broker node in the BDS instance
        """
        return pulumi.get(self, "kafka_broker_node")

    @kafka_broker_node.setter
    def kafka_broker_node(self, value: Optional[pulumi.Input['BdsInstanceKafkaBrokerNodeArgs']]):
        pulumi.set(self, "kafka_broker_node", value)

    @property
    @pulumi.getter(name="kerberosRealmName")
    def kerberos_realm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-defined kerberos realm name.
        """
        return pulumi.get(self, "kerberos_realm_name")

    @kerberos_realm_name.setter
    def kerberos_realm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kerberos_realm_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Key Management master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="masterNode")
    def master_node(self) -> Optional[pulumi.Input['BdsInstanceMasterNodeArgs']]:
        """
        The master node in the BDS instance
        """
        return pulumi.get(self, "master_node")

    @master_node.setter
    def master_node(self, value: Optional[pulumi.Input['BdsInstanceMasterNodeArgs']]):
        pulumi.set(self, "master_node", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']]:
        """
        Additional configuration of the user's network.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['BdsInstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceNodeArgs']]]]:
        """
        The list of nodes in the Big Data Service cluster.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes that forming the cluster
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="numberOfNodesRequiringMaintenanceReboot")
    def number_of_nodes_requiring_maintenance_reboot(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes that require a maintenance reboot
        """
        return pulumi.get(self, "number_of_nodes_requiring_maintenance_reboot")

    @number_of_nodes_requiring_maintenance_reboot.setter
    def number_of_nodes_requiring_maintenance_reboot(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes_requiring_maintenance_reboot", value)

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the patch to be upated.
        """
        return pulumi.get(self, "os_patch_version")

    @os_patch_version.setter
    def os_patch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_patch_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the BDS instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the BDS instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="utilNode")
    def util_node(self) -> Optional[pulumi.Input['BdsInstanceUtilNodeArgs']]:
        """
        The utility node in the BDS instance
        """
        return pulumi.get(self, "util_node")

    @util_node.setter
    def util_node(self, value: Optional[pulumi.Input['BdsInstanceUtilNodeArgs']]):
        pulumi.set(self, "util_node", value)

    @property
    @pulumi.getter(name="workerNode")
    def worker_node(self) -> Optional[pulumi.Input['BdsInstanceWorkerNodeArgs']]:
        return pulumi.get(self, "worker_node")

    @worker_node.setter
    def worker_node(self, value: Optional[pulumi.Input['BdsInstanceWorkerNodeArgs']]):
        pulumi.set(self, "worker_node", value)


class BdsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_script_url: Optional[pulumi.Input[str]] = None,
                 cloud_sql_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceCloudSqlDetailArgs', 'BdsInstanceCloudSqlDetailArgsDict']]]]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 cluster_profile: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_only_worker_node: Optional[pulumi.Input[Union['BdsInstanceComputeOnlyWorkerNodeArgs', 'BdsInstanceComputeOnlyWorkerNodeArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 edge_node: Optional[pulumi.Input[Union['BdsInstanceEdgeNodeArgs', 'BdsInstanceEdgeNodeArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ignore_existing_nodes_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_cloud_sql_configured: Optional[pulumi.Input[bool]] = None,
                 is_force_stop_jobs: Optional[pulumi.Input[bool]] = None,
                 is_high_availability: Optional[pulumi.Input[bool]] = None,
                 is_kafka_configured: Optional[pulumi.Input[bool]] = None,
                 is_secure: Optional[pulumi.Input[bool]] = None,
                 kafka_broker_node: Optional[pulumi.Input[Union['BdsInstanceKafkaBrokerNodeArgs', 'BdsInstanceKafkaBrokerNodeArgsDict']]] = None,
                 kerberos_realm_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_node: Optional[pulumi.Input[Union['BdsInstanceMasterNodeArgs', 'BdsInstanceMasterNodeArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['BdsInstanceNetworkConfigArgs', 'BdsInstanceNetworkConfigArgsDict']]] = None,
                 os_patch_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 util_node: Optional[pulumi.Input[Union['BdsInstanceUtilNodeArgs', 'BdsInstanceUtilNodeArgsDict']]] = None,
                 worker_node: Optional[pulumi.Input[Union['BdsInstanceWorkerNodeArgs', 'BdsInstanceWorkerNodeArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance resource in Oracle Cloud Infrastructure Big Data Service service.

        Creates a new BDS instance.

        ## Import

        BdsInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstance:BdsInstance test_bds_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bootstrap_script_url: (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceCloudSqlDetailArgs', 'BdsInstanceCloudSqlDetailArgsDict']]]] cloud_sql_details: The information about added Cloud SQL capability
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[str] cluster_profile: Profile of the Big Data Service cluster.
        :param pulumi.Input[str] cluster_public_key: The SSH public key used to authenticate the cluster connection.
        :param pulumi.Input[str] cluster_version: Version of the Hadoop distribution
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the BDS instance
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_existing_nodes_shapes: Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        :param pulumi.Input[bool] is_cloud_sql_configured: (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        :param pulumi.Input[bool] is_force_stop_jobs: (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        :param pulumi.Input[bool] is_high_availability: Boolean flag specifying whether or not the cluster is HA
        :param pulumi.Input[bool] is_kafka_configured: Boolean flag specifying whether or not Kafka should be configured.
        :param pulumi.Input[bool] is_secure: Boolean flag specifying whether or not the cluster should be setup as secure.
        :param pulumi.Input[Union['BdsInstanceKafkaBrokerNodeArgs', 'BdsInstanceKafkaBrokerNodeArgsDict']] kafka_broker_node: The kafka broker node in the BDS instance
        :param pulumi.Input[str] kerberos_realm_name: The user-defined kerberos realm name.
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of the Key Management master encryption key.
        :param pulumi.Input[Union['BdsInstanceMasterNodeArgs', 'BdsInstanceMasterNodeArgsDict']] master_node: The master node in the BDS instance
        :param pulumi.Input[Union['BdsInstanceNetworkConfigArgs', 'BdsInstanceNetworkConfigArgsDict']] network_config: Additional configuration of the user's network.
        :param pulumi.Input[str] os_patch_version: (Updatable) The version of the patch to be upated.
        :param pulumi.Input[str] state: (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        :param pulumi.Input[Union['BdsInstanceUtilNodeArgs', 'BdsInstanceUtilNodeArgsDict']] util_node: The utility node in the BDS instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance resource in Oracle Cloud Infrastructure Big Data Service service.

        Creates a new BDS instance.

        ## Import

        BdsInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstance:BdsInstance test_bds_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_script_url: Optional[pulumi.Input[str]] = None,
                 cloud_sql_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceCloudSqlDetailArgs', 'BdsInstanceCloudSqlDetailArgsDict']]]]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 cluster_profile: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_only_worker_node: Optional[pulumi.Input[Union['BdsInstanceComputeOnlyWorkerNodeArgs', 'BdsInstanceComputeOnlyWorkerNodeArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 edge_node: Optional[pulumi.Input[Union['BdsInstanceEdgeNodeArgs', 'BdsInstanceEdgeNodeArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ignore_existing_nodes_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_cloud_sql_configured: Optional[pulumi.Input[bool]] = None,
                 is_force_stop_jobs: Optional[pulumi.Input[bool]] = None,
                 is_high_availability: Optional[pulumi.Input[bool]] = None,
                 is_kafka_configured: Optional[pulumi.Input[bool]] = None,
                 is_secure: Optional[pulumi.Input[bool]] = None,
                 kafka_broker_node: Optional[pulumi.Input[Union['BdsInstanceKafkaBrokerNodeArgs', 'BdsInstanceKafkaBrokerNodeArgsDict']]] = None,
                 kerberos_realm_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_node: Optional[pulumi.Input[Union['BdsInstanceMasterNodeArgs', 'BdsInstanceMasterNodeArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['BdsInstanceNetworkConfigArgs', 'BdsInstanceNetworkConfigArgsDict']]] = None,
                 os_patch_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 util_node: Optional[pulumi.Input[Union['BdsInstanceUtilNodeArgs', 'BdsInstanceUtilNodeArgsDict']]] = None,
                 worker_node: Optional[pulumi.Input[Union['BdsInstanceWorkerNodeArgs', 'BdsInstanceWorkerNodeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceArgs.__new__(BdsInstanceArgs)

            __props__.__dict__["bootstrap_script_url"] = bootstrap_script_url
            __props__.__dict__["cloud_sql_details"] = cloud_sql_details
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            __props__.__dict__["cluster_profile"] = cluster_profile
            if cluster_public_key is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_public_key'")
            __props__.__dict__["cluster_public_key"] = cluster_public_key
            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_only_worker_node"] = compute_only_worker_node
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["edge_node"] = edge_node
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ignore_existing_nodes_shapes"] = ignore_existing_nodes_shapes
            __props__.__dict__["is_cloud_sql_configured"] = is_cloud_sql_configured
            __props__.__dict__["is_force_stop_jobs"] = is_force_stop_jobs
            if is_high_availability is None and not opts.urn:
                raise TypeError("Missing required property 'is_high_availability'")
            __props__.__dict__["is_high_availability"] = is_high_availability
            __props__.__dict__["is_kafka_configured"] = is_kafka_configured
            if is_secure is None and not opts.urn:
                raise TypeError("Missing required property 'is_secure'")
            __props__.__dict__["is_secure"] = is_secure
            __props__.__dict__["kafka_broker_node"] = kafka_broker_node
            __props__.__dict__["kerberos_realm_name"] = kerberos_realm_name
            __props__.__dict__["kms_key_id"] = kms_key_id
            if master_node is None and not opts.urn:
                raise TypeError("Missing required property 'master_node'")
            __props__.__dict__["master_node"] = master_node
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["os_patch_version"] = os_patch_version
            __props__.__dict__["state"] = state
            if util_node is None and not opts.urn:
                raise TypeError("Missing required property 'util_node'")
            __props__.__dict__["util_node"] = util_node
            if worker_node is None and not opts.urn:
                raise TypeError("Missing required property 'worker_node'")
            __props__.__dict__["worker_node"] = worker_node
            __props__.__dict__["cluster_details"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["number_of_nodes"] = None
            __props__.__dict__["number_of_nodes_requiring_maintenance_reboot"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstance, __self__).__init__(
            'oci:BigDataService/bdsInstance:BdsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bootstrap_script_url: Optional[pulumi.Input[str]] = None,
            cloud_sql_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceCloudSqlDetailArgs', 'BdsInstanceCloudSqlDetailArgsDict']]]]] = None,
            cluster_admin_password: Optional[pulumi.Input[str]] = None,
            cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceClusterDetailArgs', 'BdsInstanceClusterDetailArgsDict']]]]] = None,
            cluster_profile: Optional[pulumi.Input[str]] = None,
            cluster_public_key: Optional[pulumi.Input[str]] = None,
            cluster_version: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_only_worker_node: Optional[pulumi.Input[Union['BdsInstanceComputeOnlyWorkerNodeArgs', 'BdsInstanceComputeOnlyWorkerNodeArgsDict']]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            edge_node: Optional[pulumi.Input[Union['BdsInstanceEdgeNodeArgs', 'BdsInstanceEdgeNodeArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ignore_existing_nodes_shapes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_cloud_sql_configured: Optional[pulumi.Input[bool]] = None,
            is_force_stop_jobs: Optional[pulumi.Input[bool]] = None,
            is_high_availability: Optional[pulumi.Input[bool]] = None,
            is_kafka_configured: Optional[pulumi.Input[bool]] = None,
            is_secure: Optional[pulumi.Input[bool]] = None,
            kafka_broker_node: Optional[pulumi.Input[Union['BdsInstanceKafkaBrokerNodeArgs', 'BdsInstanceKafkaBrokerNodeArgsDict']]] = None,
            kerberos_realm_name: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            master_node: Optional[pulumi.Input[Union['BdsInstanceMasterNodeArgs', 'BdsInstanceMasterNodeArgsDict']]] = None,
            network_config: Optional[pulumi.Input[Union['BdsInstanceNetworkConfigArgs', 'BdsInstanceNetworkConfigArgsDict']]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceNodeArgs', 'BdsInstanceNodeArgsDict']]]]] = None,
            number_of_nodes: Optional[pulumi.Input[int]] = None,
            number_of_nodes_requiring_maintenance_reboot: Optional[pulumi.Input[int]] = None,
            os_patch_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            util_node: Optional[pulumi.Input[Union['BdsInstanceUtilNodeArgs', 'BdsInstanceUtilNodeArgsDict']]] = None,
            worker_node: Optional[pulumi.Input[Union['BdsInstanceWorkerNodeArgs', 'BdsInstanceWorkerNodeArgsDict']]] = None) -> 'BdsInstance':
        """
        Get an existing BdsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bootstrap_script_url: (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceCloudSqlDetailArgs', 'BdsInstanceCloudSqlDetailArgsDict']]]] cloud_sql_details: The information about added Cloud SQL capability
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceClusterDetailArgs', 'BdsInstanceClusterDetailArgsDict']]]] cluster_details: Specific info about a Hadoop cluster
        :param pulumi.Input[str] cluster_profile: Profile of the Big Data Service cluster.
        :param pulumi.Input[str] cluster_public_key: The SSH public key used to authenticate the cluster connection.
        :param pulumi.Input[str] cluster_version: Version of the Hadoop distribution
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment
        :param pulumi.Input[str] created_by: The user who created the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the BDS instance
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_existing_nodes_shapes: Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        :param pulumi.Input[bool] is_cloud_sql_configured: (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        :param pulumi.Input[bool] is_force_stop_jobs: (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        :param pulumi.Input[bool] is_high_availability: Boolean flag specifying whether or not the cluster is HA
        :param pulumi.Input[bool] is_kafka_configured: Boolean flag specifying whether or not Kafka should be configured.
        :param pulumi.Input[bool] is_secure: Boolean flag specifying whether or not the cluster should be setup as secure.
        :param pulumi.Input[Union['BdsInstanceKafkaBrokerNodeArgs', 'BdsInstanceKafkaBrokerNodeArgsDict']] kafka_broker_node: The kafka broker node in the BDS instance
        :param pulumi.Input[str] kerberos_realm_name: The user-defined kerberos realm name.
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of the Key Management master encryption key.
        :param pulumi.Input[Union['BdsInstanceMasterNodeArgs', 'BdsInstanceMasterNodeArgsDict']] master_node: The master node in the BDS instance
        :param pulumi.Input[Union['BdsInstanceNetworkConfigArgs', 'BdsInstanceNetworkConfigArgsDict']] network_config: Additional configuration of the user's network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceNodeArgs', 'BdsInstanceNodeArgsDict']]]] nodes: The list of nodes in the Big Data Service cluster.
        :param pulumi.Input[int] number_of_nodes: Number of nodes that forming the cluster
        :param pulumi.Input[int] number_of_nodes_requiring_maintenance_reboot: Number of nodes that require a maintenance reboot
        :param pulumi.Input[str] os_patch_version: (Updatable) The version of the patch to be upated.
        :param pulumi.Input[str] state: (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        :param pulumi.Input[str] time_created: The time the BDS instance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the BDS instance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[Union['BdsInstanceUtilNodeArgs', 'BdsInstanceUtilNodeArgsDict']] util_node: The utility node in the BDS instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceState.__new__(_BdsInstanceState)

        __props__.__dict__["bootstrap_script_url"] = bootstrap_script_url
        __props__.__dict__["cloud_sql_details"] = cloud_sql_details
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["cluster_details"] = cluster_details
        __props__.__dict__["cluster_profile"] = cluster_profile
        __props__.__dict__["cluster_public_key"] = cluster_public_key
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_only_worker_node"] = compute_only_worker_node
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["edge_node"] = edge_node
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ignore_existing_nodes_shapes"] = ignore_existing_nodes_shapes
        __props__.__dict__["is_cloud_sql_configured"] = is_cloud_sql_configured
        __props__.__dict__["is_force_stop_jobs"] = is_force_stop_jobs
        __props__.__dict__["is_high_availability"] = is_high_availability
        __props__.__dict__["is_kafka_configured"] = is_kafka_configured
        __props__.__dict__["is_secure"] = is_secure
        __props__.__dict__["kafka_broker_node"] = kafka_broker_node
        __props__.__dict__["kerberos_realm_name"] = kerberos_realm_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["master_node"] = master_node
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["number_of_nodes"] = number_of_nodes
        __props__.__dict__["number_of_nodes_requiring_maintenance_reboot"] = number_of_nodes_requiring_maintenance_reboot
        __props__.__dict__["os_patch_version"] = os_patch_version
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["util_node"] = util_node
        __props__.__dict__["worker_node"] = worker_node
        return BdsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bootstrapScriptUrl")
    def bootstrap_script_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Pre-authenticated URL of the script in Object Store that is downloaded and executed.
        """
        return pulumi.get(self, "bootstrap_script_url")

    @property
    @pulumi.getter(name="cloudSqlDetails")
    def cloud_sql_details(self) -> pulumi.Output[Sequence['outputs.BdsInstanceCloudSqlDetail']]:
        """
        The information about added Cloud SQL capability
        """
        return pulumi.get(self, "cloud_sql_details")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[str]:
        """
        Base-64 encoded password for the cluster (and Cloudera Manager) admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> pulumi.Output[Sequence['outputs.BdsInstanceClusterDetail']]:
        """
        Specific info about a Hadoop cluster
        """
        return pulumi.get(self, "cluster_details")

    @property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> pulumi.Output[str]:
        """
        Profile of the Big Data Service cluster.
        """
        return pulumi.get(self, "cluster_profile")

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> pulumi.Output[str]:
        """
        The SSH public key used to authenticate the cluster connection.
        """
        return pulumi.get(self, "cluster_public_key")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[str]:
        """
        Version of the Hadoop distribution
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeOnlyWorkerNode")
    def compute_only_worker_node(self) -> pulumi.Output[Optional['outputs.BdsInstanceComputeOnlyWorkerNode']]:
        return pulumi.get(self, "compute_only_worker_node")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the BDS instance
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="edgeNode")
    def edge_node(self) -> pulumi.Output[Optional['outputs.BdsInstanceEdgeNode']]:
        return pulumi.get(self, "edge_node")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ignoreExistingNodesShapes")
    def ignore_existing_nodes_shapes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tag to ignore changing the shape of existing worker, master, utility, compute_only_worker, edge, kafka_broker nodes, in a list format, when new nodes are added with a different shape.
        """
        return pulumi.get(self, "ignore_existing_nodes_shapes")

    @property
    @pulumi.getter(name="isCloudSqlConfigured")
    def is_cloud_sql_configured(self) -> pulumi.Output[bool]:
        """
        (Updatable) Boolean flag specifying whether we configure Cloud SQL or not
        """
        return pulumi.get(self, "is_cloud_sql_configured")

    @property
    @pulumi.getter(name="isForceStopJobs")
    def is_force_stop_jobs(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) When setting state as `INACTIVE` for stopping a cluster, setting this flag to true forcefully stops the bds instance.
        """
        return pulumi.get(self, "is_force_stop_jobs")

    @property
    @pulumi.getter(name="isHighAvailability")
    def is_high_availability(self) -> pulumi.Output[bool]:
        """
        Boolean flag specifying whether or not the cluster is HA
        """
        return pulumi.get(self, "is_high_availability")

    @property
    @pulumi.getter(name="isKafkaConfigured")
    def is_kafka_configured(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean flag specifying whether or not Kafka should be configured.
        """
        return pulumi.get(self, "is_kafka_configured")

    @property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> pulumi.Output[bool]:
        """
        Boolean flag specifying whether or not the cluster should be setup as secure.
        """
        return pulumi.get(self, "is_secure")

    @property
    @pulumi.getter(name="kafkaBrokerNode")
    def kafka_broker_node(self) -> pulumi.Output[Optional['outputs.BdsInstanceKafkaBrokerNode']]:
        """
        The kafka broker node in the BDS instance
        """
        return pulumi.get(self, "kafka_broker_node")

    @property
    @pulumi.getter(name="kerberosRealmName")
    def kerberos_realm_name(self) -> pulumi.Output[str]:
        """
        The user-defined kerberos realm name.
        """
        return pulumi.get(self, "kerberos_realm_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Key Management master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="masterNode")
    def master_node(self) -> pulumi.Output['outputs.BdsInstanceMasterNode']:
        """
        The master node in the BDS instance
        """
        return pulumi.get(self, "master_node")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.BdsInstanceNetworkConfig']:
        """
        Additional configuration of the user's network.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.BdsInstanceNode']]:
        """
        The list of nodes in the Big Data Service cluster.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> pulumi.Output[int]:
        """
        Number of nodes that forming the cluster
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="numberOfNodesRequiringMaintenanceReboot")
    def number_of_nodes_requiring_maintenance_reboot(self) -> pulumi.Output[int]:
        """
        Number of nodes that require a maintenance reboot
        """
        return pulumi.get(self, "number_of_nodes_requiring_maintenance_reboot")

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The version of the patch to be upated.
        """
        return pulumi.get(self, "os_patch_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the Bds Instance. Could be set to `ACTIVE` or `INACTIVE` to start/stop the bds instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the BDS instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the BDS instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="utilNode")
    def util_node(self) -> pulumi.Output['outputs.BdsInstanceUtilNode']:
        """
        The utility node in the BDS instance
        """
        return pulumi.get(self, "util_node")

    @property
    @pulumi.getter(name="workerNode")
    def worker_node(self) -> pulumi.Output['outputs.BdsInstanceWorkerNode']:
        return pulumi.get(self, "worker_node")

