"""
water_properties - A module to get water vapor pressure (bar) and specific gravity (kg/dm³)
based on temperature in degree Celsius.

Data source: Embedded from provided CSV.
"""

# Embedded water properties data
_water_data = [{'temp (°C)': 0.0, 'Vap_Pr  (bar)': 0.00611, 'SG  (kg/dm³)': 0.9998}, {'temp (°C)': 1.0, 'Vap_Pr  (bar)': 0.00657, 'SG  (kg/dm³)': 0.9999}, {'temp (°C)': 2.0, 'Vap_Pr  (bar)': 0.00706, 'SG  (kg/dm³)': 0.9999}, {'temp (°C)': 3.0, 'Vap_Pr  (bar)': 0.00758, 'SG  (kg/dm³)': 0.9999}, {'temp (°C)': 4.0, 'Vap_Pr  (bar)': 0.00813, 'SG  (kg/dm³)': 1.0}, {'temp (°C)': 5.0, 'Vap_Pr  (bar)': 0.00872, 'SG  (kg/dm³)': 1.0}, {'temp (°C)': 6.0, 'Vap_Pr  (bar)': 0.00985, 'SG  (kg/dm³)': 1.0}, {'temp (°C)': 7.0, 'Vap_Pr  (bar)': 0.01001, 'SG  (kg/dm³)': 0.9999}, {'temp (°C)': 8.0, 'Vap_Pr  (bar)': 0.01072, 'SG  (kg/dm³)': 0.9999}, {'temp (°C)': 9.0, 'Vap_Pr  (bar)': 0.01147, 'SG  (kg/dm³)': 0.9998}, {'temp (°C)': 10.0, 'Vap_Pr  (bar)': 0.01227, 'SG  (kg/dm³)': 0.9997}, {'temp (°C)': 11.0, 'Vap_Pr  (bar)': 0.01312, 'SG  (kg/dm³)': 0.9997}, {'temp (°C)': 12.0, 'Vap_Pr  (bar)': 0.01401, 'SG  (kg/dm³)': 0.9996}, {'temp (°C)': 13.0, 'Vap_Pr  (bar)': 0.01497, 'SG  (kg/dm³)': 0.9994}, {'temp (°C)': 14.0, 'Vap_Pr  (bar)': 0.01597, 'SG  (kg/dm³)': 0.9993}, {'temp (°C)': 15.0, 'Vap_Pr  (bar)': 0.01704, 'SG  (kg/dm³)': 0.9992}, {'temp (°C)': 16.0, 'Vap_Pr  (bar)': 0.01817, 'SG  (kg/dm³)': 0.999}, {'temp (°C)': 17.0, 'Vap_Pr  (bar)': 0.01936, 'SG  (kg/dm³)': 0.9988}, {'temp (°C)': 18.0, 'Vap_Pr  (bar)': 0.02062, 'SG  (kg/dm³)': 0.9987}, {'temp (°C)': 19.0, 'Vap_Pr  (bar)': 0.02196, 'SG  (kg/dm³)': 0.9985}, {'temp (°C)': 20.0, 'Vap_Pr  (bar)': 0.02337, 'SG  (kg/dm³)': 0.9983}, {'temp (°C)': 21.0, 'Vap_Pr  (bar)': 0.02485, 'SG  (kg/dm³)': 0.9981}, {'temp (°C)': 22.0, 'Vap_Pr  (bar)': 0.02642, 'SG  (kg/dm³)': 0.9978}, {'temp (°C)': 23.0, 'Vap_Pr  (bar)': 0.02808, 'SG  (kg/dm³)': 0.9976}, {'temp (°C)': 24.0, 'Vap_Pr  (bar)': 0.02982, 'SG  (kg/dm³)': 0.9974}, {'temp (°C)': 25.0, 'Vap_Pr  (bar)': 0.03166, 'SG  (kg/dm³)': 0.9971}, {'temp (°C)': 26.0, 'Vap_Pr  (bar)': 0.0336, 'SG  (kg/dm³)': 0.9968}, {'temp (°C)': 27.0, 'Vap_Pr  (bar)': 0.03564, 'SG  (kg/dm³)': 0.9966}, {'temp (°C)': 28.0, 'Vap_Pr  (bar)': 0.03738, 'SG  (kg/dm³)': 0.9963}, {'temp (°C)': 29.0, 'Vap_Pr  (bar)': 0.04004, 'SG  (kg/dm³)': 0.996}, {'temp (°C)': 30.0, 'Vap_Pr  (bar)': 0.04241, 'SG  (kg/dm³)': 0.9957}, {'temp (°C)': 31.0, 'Vap_Pr  (bar)': 0.04491, 'SG  (kg/dm³)': 0.9954}, {'temp (°C)': 32.0, 'Vap_Pr  (bar)': 0.04753, 'SG  (kg/dm³)': 0.99951}, {'temp (°C)': 33.0, 'Vap_Pr  (bar)': 0.05029, 'SG  (kg/dm³)': 0.9947}, {'temp (°C)': 34.0, 'Vap_Pr  (bar)': 0.05318, 'SG  (kg/dm³)': 0.9944}, {'temp (°C)': 35.0, 'Vap_Pr  (bar)': 0.05622, 'SG  (kg/dm³)': 0.994}, {'temp (°C)': 36.0, 'Vap_Pr  (bar)': 0.0594, 'SG  (kg/dm³)': 0.9937}, {'temp (°C)': 37.0, 'Vap_Pr  (bar)': 0.06274, 'SG  (kg/dm³)': 0.9933}, {'temp (°C)': 38.0, 'Vap_Pr  (bar)': 0.06624, 'SG  (kg/dm³)': 0.993}, {'temp (°C)': 39.0, 'Vap_Pr  (bar)': 0.06991, 'SG  (kg/dm³)': 0.9927}, {'temp (°C)': 40.0, 'Vap_Pr  (bar)': 0.07375, 'SG  (kg/dm³)': 0.9923}, {'temp (°C)': 41.0, 'Vap_Pr  (bar)': 0.07777, 'SG  (kg/dm³)': 0.09919}, {'temp (°C)': 42.0, 'Vap_Pr  (bar)': 0.08198, 'SG  (kg/dm³)': 0.9915}, {'temp (°C)': 43.0, 'Vap_Pr  (bar)': 0.08639, 'SG  (kg/dm³)': 0.9911}, {'temp (°C)': 44.0, 'Vap_Pr  (bar)': 0.091, 'SG  (kg/dm³)': 0.9907}, {'temp (°C)': 45.0, 'Vap_Pr  (bar)': 0.09582, 'SG  (kg/dm³)': 0.9902}, {'temp (°C)': 46.0, 'Vap_Pr  (bar)': 0.10086, 'SG  (kg/dm³)': 0.9898}, {'temp (°C)': 47.0, 'Vap_Pr  (bar)': 0.10612, 'SG  (kg/dm³)': 0.9894}, {'temp (°C)': 48.0, 'Vap_Pr  (bar)': 0.11162, 'SG  (kg/dm³)': 0.9889}, {'temp (°C)': 49.0, 'Vap_Pr  (bar)': 0.11736, 'SG  (kg/dm³)': 0.9884}, {'temp (°C)': 50.0, 'Vap_Pr  (bar)': 0.12335, 'SG  (kg/dm³)': 0.988}, {'temp (°C)': 51.0, 'Vap_Pr  (bar)': 0.12961, 'SG  (kg/dm³)': 0.9876}, {'temp (°C)': 52.0, 'Vap_Pr  (bar)': 0.13613, 'SG  (kg/dm³)': 0.9871}, {'temp (°C)': 53.0, 'Vap_Pr  (bar)': 0.14293, 'SG  (kg/dm³)': 0.9866}, {'temp (°C)': 54.0, 'Vap_Pr  (bar)': 0.15002, 'SG  (kg/dm³)': 0.9862}, {'temp (°C)': 55.0, 'Vap_Pr  (bar)': 0.15741, 'SG  (kg/dm³)': 0.9857}, {'temp (°C)': 56.0, 'Vap_Pr  (bar)': 0.16511, 'SG  (kg/dm³)': 0.9852}, {'temp (°C)': 57.0, 'Vap_Pr  (bar)': 0.17313, 'SG  (kg/dm³)': 0.9846}, {'temp (°C)': 58.0, 'Vap_Pr  (bar)': 0.18147, 'SG  (kg/dm³)': 0.9842}, {'temp (°C)': 59.0, 'Vap_Pr  (bar)': 0.19016, 'SG  (kg/dm³)': 0.9837}, {'temp (°C)': 60.0, 'Vap_Pr  (bar)': 0.1992, 'SG  (kg/dm³)': 0.9832}, {'temp (°C)': 61.0, 'Vap_Pr  (bar)': 0.2086, 'SG  (kg/dm³)': 0.9826}, {'temp (°C)': 62.0, 'Vap_Pr  (bar)': 0.2184, 'SG  (kg/dm³)': 0.9821}, {'temp (°C)': 63.0, 'Vap_Pr  (bar)': 0.2286, 'SG  (kg/dm³)': 0.9816}, {'temp (°C)': 64.0, 'Vap_Pr  (bar)': 0.2391, 'SG  (kg/dm³)': 0.9811}, {'temp (°C)': 65.0, 'Vap_Pr  (bar)': 0.2501, 'SG  (kg/dm³)': 0.9805}, {'temp (°C)': 66.0, 'Vap_Pr  (bar)': 0.2615, 'SG  (kg/dm³)': 0.9799}, {'temp (°C)': 67.0, 'Vap_Pr  (bar)': 0.2733, 'SG  (kg/dm³)': 0.9793}, {'temp (°C)': 68.0, 'Vap_Pr  (bar)': 0.2856, 'SG  (kg/dm³)': 0.9788}, {'temp (°C)': 69.0, 'Vap_Pr  (bar)': 0.2984, 'SG  (kg/dm³)': 0.9782}, {'temp (°C)': 70.0, 'Vap_Pr  (bar)': 0.3116, 'SG  (kg/dm³)': 0.9777}, {'temp (°C)': 71.0, 'Vap_Pr  (bar)': 0.3253, 'SG  (kg/dm³)': 0.977}, {'temp (°C)': 72.0, 'Vap_Pr  (bar)': 0.3395, 'SG  (kg/dm³)': 0.9765}, {'temp (°C)': 73.0, 'Vap_Pr  (bar)': 0.3543, 'SG  (kg/dm³)': 0.976}, {'temp (°C)': 74.0, 'Vap_Pr  (bar)': 0.3696, 'SG  (kg/dm³)': 0.9753}, {'temp (°C)': 75.0, 'Vap_Pr  (bar)': 0.3855, 'SG  (kg/dm³)': 0.9748}, {'temp (°C)': 76.0, 'Vap_Pr  (bar)': 0.4019, 'SG  (kg/dm³)': 0.9741}, {'temp (°C)': 77.0, 'Vap_Pr  (bar)': 0.4189, 'SG  (kg/dm³)': 0.9735}, {'temp (°C)': 78.0, 'Vap_Pr  (bar)': 0.4365, 'SG  (kg/dm³)': 0.9729}, {'temp (°C)': 79.0, 'Vap_Pr  (bar)': 0.4547, 'SG  (kg/dm³)': 0.9723}, {'temp (°C)': 80.0, 'Vap_Pr  (bar)': 0.4736, 'SG  (kg/dm³)': 0.9716}, {'temp (°C)': 81.0, 'Vap_Pr  (bar)': 0.4931, 'SG  (kg/dm³)': 0.971}, {'temp (°C)': 82.0, 'Vap_Pr  (bar)': 0.5133, 'SG  (kg/dm³)': 0.9704}, {'temp (°C)': 83.0, 'Vap_Pr  (bar)': 0.5432, 'SG  (kg/dm³)': 0.9697}, {'temp (°C)': 84.0, 'Vap_Pr  (bar)': 0.5557, 'SG  (kg/dm³)': 0.9691}, {'temp (°C)': 85.0, 'Vap_Pr  (bar)': 0.578, 'SG  (kg/dm³)': 0.9684}, {'temp (°C)': 86.0, 'Vap_Pr  (bar)': 0.6011, 'SG  (kg/dm³)': 0.9678}, {'temp (°C)': 87.0, 'Vap_Pr  (bar)': 0.6249, 'SG  (kg/dm³)': 0.9671}, {'temp (°C)': 88.0, 'Vap_Pr  (bar)': 0.6495, 'SG  (kg/dm³)': 0.9665}, {'temp (°C)': 89.0, 'Vap_Pr  (bar)': 0.6749, 'SG  (kg/dm³)': 0.9658}, {'temp (°C)': 90.0, 'Vap_Pr  (bar)': 0.7011, 'SG  (kg/dm³)': 0.9652}, {'temp (°C)': 91.0, 'Vap_Pr  (bar)': 0.7281, 'SG  (kg/dm³)': 0.9644}, {'temp (°C)': 92.0, 'Vap_Pr  (bar)': 0.7561, 'SG  (kg/dm³)': 0.9638}, {'temp (°C)': 93.0, 'Vap_Pr  (bar)': 0.7849, 'SG  (kg/dm³)': 0.963}, {'temp (°C)': 94.0, 'Vap_Pr  (bar)': 0.8046, 'SG  (kg/dm³)': 0.9624}, {'temp (°C)': 95.0, 'Vap_Pr  (bar)': 0.8453, 'SG  (kg/dm³)': 0.9616}, {'temp (°C)': 96.0, 'Vap_Pr  (bar)': 0.8769, 'SG  (kg/dm³)': 0.961}, {'temp (°C)': 97.0, 'Vap_Pr  (bar)': 0.9094, 'SG  (kg/dm³)': 0.9602}, {'temp (°C)': 98.0, 'Vap_Pr  (bar)': 0.943, 'SG  (kg/dm³)': 0.9596}, {'temp (°C)': 99.0, 'Vap_Pr  (bar)': 0.9776, 'SG  (kg/dm³)': 0.9586}, {'temp (°C)': 100.0, 'Vap_Pr  (bar)': -1.0133, 'SG  (kg/dm³)': -0.9581}, {'temp (°C)': 102.0, 'Vap_Pr  (bar)': 1.0878, 'SG  (kg/dm³)': 0.9567}, {'temp (°C)': 104.0, 'Vap_Pr  (bar)': 1.1668, 'SG  (kg/dm³)': 0.9552}, {'temp (°C)': 106.0, 'Vap_Pr  (bar)': 1.2504, 'SG  (kg/dm³)': 0.9537}, {'temp (°C)': 108.0, 'Vap_Pr  (bar)': 1.339, 'SG  (kg/dm³)': 0.9522}, {'temp (°C)': 110.0, 'Vap_Pr  (bar)': 1.4327, 'SG  (kg/dm³)': 0.9507}, {'temp (°C)': 112.0, 'Vap_Pr  (bar)': 1.5316, 'SG  (kg/dm³)': 0.9491}, {'temp (°C)': 114.0, 'Vap_Pr  (bar)': 1.6362, 'SG  (kg/dm³)': 0.9476}, {'temp (°C)': 116.0, 'Vap_Pr  (bar)': 1.7465, 'SG  (kg/dm³)': 0.946}, {'temp (°C)': 118.0, 'Vap_Pr  (bar)': 1.8628, 'SG  (kg/dm³)': 0.9445}, {'temp (°C)': 120.0, 'Vap_Pr  (bar)': 1.9854, 'SG  (kg/dm³)': 0.9429}, {'temp (°C)': 122.0, 'Vap_Pr  (bar)': 2.1145, 'SG  (kg/dm³)': 0.9412}, {'temp (°C)': 124.0, 'Vap_Pr  (bar)': 2.2504, 'SG  (kg/dm³)': 0.9396}, {'temp (°C)': 126.0, 'Vap_Pr  (bar)': 2.3933, 'SG  (kg/dm³)': 0.9379}, {'temp (°C)': 128.0, 'Vap_Pr  (bar)': 2.5435, 'SG  (kg/dm³)': 0.9362}, {'temp (°C)': 130.0, 'Vap_Pr  (bar)': 2.7013, 'SG  (kg/dm³)': 0.9346}, {'temp (°C)': 132.0, 'Vap_Pr  (bar)': 2.867, 'SG  (kg/dm³)': 0.9328}, {'temp (°C)': 134.0, 'Vap_Pr  (bar)': 3.041, 'SG  (kg/dm³)': 0.9311}, {'temp (°C)': 136.0, 'Vap_Pr  (bar)': 3.223, 'SG  (kg/dm³)': 0.9394}, {'temp (°C)': 138.0, 'Vap_Pr  (bar)': 3.414, 'SG  (kg/dm³)': 0.9276}, {'temp (°C)': 140.0, 'Vap_Pr  (bar)': 3.614, 'SG  (kg/dm³)': 0.9258}, {'temp (°C)': 145.0, 'Vap_Pr  (bar)': 4.155, 'SG  (kg/dm³)': 0.9214}, {'temp (°C)': 150.0, 'Vap_Pr  (bar)': 4.76, 'SG  (kg/dm³)': 0.9168}, {'temp (°C)': 155.0, 'Vap_Pr  (bar)': 5.433, 'SG  (kg/dm³)': 0.9121}, {'temp (°C)': 160.0, 'Vap_Pr  (bar)': 6181.0, 'SG  (kg/dm³)': 0.9073}, {'temp (°C)': 165.0, 'Vap_Pr  (bar)': 7.008, 'SG  (kg/dm³)': 0.9024}, {'temp (°C)': 170.0, 'Vap_Pr  (bar)': 7.92, 'SG  (kg/dm³)': 0.8973}, {'temp (°C)': 175.0, 'Vap_Pr  (bar)': 8.924, 'SG  (kg/dm³)': 0.8921}, {'temp (°C)': 180.0, 'Vap_Pr  (bar)': 10.027, 'SG  (kg/dm³)': 0.8869}, {'temp (°C)': 185.0, 'Vap_Pr  (bar)': 11.233, 'SG  (kg/dm³)': 0.8815}, {'temp (°C)': 190.0, 'Vap_Pr  (bar)': 12.551, 'SG  (kg/dm³)': 0.876}, {'temp (°C)': 195.0, 'Vap_Pr  (bar)': 13.987, 'SG  (kg/dm³)': 0.8704}, {'temp (°C)': 200.0, 'Vap_Pr  (bar)': 15.55, 'SG  (kg/dm³)': 0.8647}, {'temp (°C)': 205.0, 'Vap_Pr  (bar)': 17.243, 'SG  (kg/dm³)': 0.8588}, {'temp (°C)': 210.0, 'Vap_Pr  (bar)': 19.077, 'SG  (kg/dm³)': 0.8528}, {'temp (°C)': 215.0, 'Vap_Pr  (bar)': 21.06, 'SG  (kg/dm³)': 0.8467}, {'temp (°C)': 220.0, 'Vap_Pr  (bar)': 23.198, 'SG  (kg/dm³)': 0.8403}, {'temp (°C)': 225.0, 'Vap_Pr  (bar)': 25.501, 'SG  (kg/dm³)': 0.8339}, {'temp (°C)': 230.0, 'Vap_Pr  (bar)': 27.976, 'SG  (kg/dm³)': 0.8273}, {'temp (°C)': 235.0, 'Vap_Pr  (bar)': 30.632, 'SG  (kg/dm³)': 0.8205}, {'temp (°C)': 240.0, 'Vap_Pr  (bar)': 33.478, 'SG  (kg/dm³)': 0.8136}, {'temp (°C)': 245.0, 'Vap_Pr  (bar)': 36.523, 'SG  (kg/dm³)': 0.8065}, {'temp (°C)': 250.0, 'Vap_Pr  (bar)': 39.776, 'SG  (kg/dm³)': 0.7992}, {'temp (°C)': 255.0, 'Vap_Pr  (bar)': 43.246, 'SG  (kg/dm³)': 0.7916}, {'temp (°C)': 260.0, 'Vap_Pr  (bar)': 46.943, 'SG  (kg/dm³)': 0.7839}, {'temp (°C)': 265.0, 'Vap_Pr  (bar)': 50.877, 'SG  (kg/dm³)': 0.7759}, {'temp (°C)': 270.0, 'Vap_Pr  (bar)': 55.058, 'SG  (kg/dm³)': 7678.0}, {'temp (°C)': 275.0, 'Vap_Pr  (bar)': 59.496, 'SG  (kg/dm³)': 0.7593}, {'temp (°C)': 280.0, 'Vap_Pr  (bar)': 64.202, 'SG  (kg/dm³)': 0.7505}, {'temp (°C)': 285.0, 'Vap_Pr  (bar)': 69.186, 'SG  (kg/dm³)': 0.7415}, {'temp (°C)': 290.0, 'Vap_Pr  (bar)': 80.037, 'SG  (kg/dm³)': 0.7223}, {'temp (°C)': 300.0, 'Vap_Pr  (bar)': 85.927, 'SG  (kg/dm³)': 0.7122}, {'temp (°C)': 305.0, 'Vap_Pr  (bar)': 92.144, 'SG  (kg/dm³)': 0.7017}, {'temp (°C)': 310.0, 'Vap_Pr  (bar)': 98.7, 'SG  (kg/dm³)': 0.6906}, {'temp (°C)': 315.0, 'Vap_Pr  (bar)': 106.61, 'SG  (kg/dm³)': 0.6791}, {'temp (°C)': 320.0, 'Vap_Pr  (bar)': 112.89, 'SG  (kg/dm³)': 0.6669}, {'temp (°C)': 325.0, 'Vap_Pr  (bar)': 120.53, 'SG  (kg/dm³)': 0.6541}, {'temp (°C)': 330.0, 'Vap_Pr  (bar)': 128.63, 'SG  (kg/dm³)': 0.6504}, {'temp (°C)': 340.0, 'Vap_Pr  (bar)': 146.05, 'SG  (kg/dm³)': 0.6102}, {'temp (°C)': 350.0, 'Vap_Pr  (bar)': 165.35, 'SG  (kg/dm³)': 0.5275}, {'temp (°C)': 360.0, 'Vap_Pr  (bar)': 186.75, 'SG  (kg/dm³)': 0.5275}, {'temp (°C)': 370.0, 'Vap_Pr  (bar)': 210.54, 'SG  (kg/dm³)': 0.4518}, {'temp (°C)': 374.15, 'Vap_Pr  (bar)': 221.2, 'SG  (kg/dm³)': 0.3154}]

def get_vapor_pressure(temp_c):
    """
    Get the vapor pressure (bar) of water at a given temperature (°C).

    Parameters:
        temp_c (float): Temperature in degree Celsius.

    Returns:
        float: Vapor pressure in bar.
    """
    for entry in _water_data:
        if entry['temp (°C)'] == temp_c:
            return entry['Vap_Pr  (bar)']
    raise ValueError(f"No data available for temperature: {temp_c}°C")

def get_specific_gravity(temp_c):
    """
    Get the specific gravity (kg/dm³) of water at a given temperature (°C).

    Parameters:
        temp_c (float): Temperature in degree Celsius.

    Returns:
        float: Specific gravity.
    """
    for entry in _water_data:
        if entry['temp (°C)'] == temp_c:
            return entry['SG  (kg/dm³)']
    raise ValueError(f"No data available for temperature: {temp_c}°C")
