import pandas as pd
import os


class Rainfall:
    """Rainfall time series"""
    def __init__(self, data: pd.DataFrame, spatial=False):
        assert type(data) == pd.DataFrame
        assert len(data) > 0, 'Rainfall DataFrame is empty'
        if len(data.columns) > 1:
            assert spatial, 'if len(data.columns) > 1, spatial must be True'
        self.data = data
        self.spatial = spatial

    def write(self, path):
        with open(os.path.join(path, '{}Rainfall_Data_1.txt'.format('Spatial_' if self.spatial else '')), 'w') as f:
            f.write('* * *\n')
            f.write('* * * rainfall * * *\n')
            f.write('* * *\n')
            f.write('{}\n'.format(len(self.data)))
            f.write('* * *\n')
            self.data.to_csv(f, sep=' ', header=False, line_terminator='\n')
