import numpy as np
from rockverse._utils import rvtqdm
from numba import njit, cuda
from rockverse.configure import config
mpi_rank = config.mpi_rank
mpi_nprocs = config.mpi_nprocs

#Domain: [-20:20, -20:20, -20:20], radius=1
SPHERES = np.array([
    [1, -0.324554, 0.081522, -0.452144],
    [2, 0.139446, -1.232478, 0.985858],
    [3, 1.641446, -0.078478, -0.876144],
    [4, -1.182554, 0.557522, 1.385856],
    [5, 1.713446, 0.143522, 1.107856],
    [6, -1.874554, -0.956478, 0.277856],
    [7, 0.687446, 1.669524, -1.132144],
    [8, 0.467446, 1.679522, 1.389856],
    [9, 0.799446, -1.950478, -0.794144],
    [10, -1.420554, 1.755522, -0.566142],
    [11, -0.972554, -1.438478, -1.568144],
    [12, 0.483446, -0.406478, -2.474144],
    [13, 0.349446, 0.045522, 2.573856],
    [14, -2.210554, 0.121522, -1.396142],
    [15, -0.800554, 1.371524, -2.432144],
    [16, -0.876554, -2.780478, -0.078144],
    [17, -2.894554, 0.763524, 0.363858],
    [18, -0.078554, 3.085522, 0.077856],
    [19, 2.635446, -1.552476, 0.585856],
    [20, -1.548554, -1.722476, 2.085856],
    [21, 2.617446, 1.885522, 0.755856],
    [22, -1.886554, 2.425522, 1.259858],
    [23, 1.577446, -2.074478, 2.189856],
    [24, -0.102554, -3.056478, 1.741856],
    [25, -0.764554, 1.749524, 2.961856],
    [26, 2.627448, 1.727522, -1.628144],
    [27, 1.173446, 1.379522, -3.074144],
    [28, -1.504554, -0.330478, -3.224144],
    [29, -1.492554, -0.158478, 3.331856],
    [30, 1.557446, -3.308478, 0.575858],
    [31, 2.607446, -0.326476, -2.612144],
    [32, 1.823446, 3.197524, -0.528142],
    [33, 1.553446, -2.078478, -2.672144],
    [34, 3.595446, -0.510478, -0.852144],
    [35, -2.748554, -2.472476, -0.710144],
    [36, -3.096554, -0.126478, 2.137856],
    [37, -0.010554, -1.762478, 3.361856],
    [38, 2.489446, 1.201522, 2.629856],
    [39, -0.992554, 3.335522, -1.722144],
    [40, 2.653446, -2.636478, -1.102144],
    [41, 3.095446, -0.668478, 2.307856],
    [42, -2.734554, 1.925522, -2.062144],
    [43, -3.834554, -0.734478, -0.596144],
    [44, 0.039446, -3.564478, -1.756144],
    [45, -0.360554, -1.950478, -3.484144],
    [46, -0.260554, 3.449522, 2.039856],
    [47, -2.958554, -1.430478, -2.412144],
    [48, 1.007446, 3.229522, -2.350144],
    [49, -3.182554, 2.653522, -0.246144],
    [50, 1.699446, 3.087522, 2.207858],
    [51, 1.715446, -0.834478, 3.741856],
    [52, 0.961446, 1.413522, 3.903856],
    [53, -1.802554, -3.076478, -2.372144],
    [54, -2.982554, -2.838478, 1.243856],
    [55, 4.161446, 1.363522, -0.406144],
    [56, -1.820554, 4.069522, 0.115856],
    [57, 1.433446, -0.342478, -4.230144],
    [58, 4.135446, 0.841522, 1.523858],
    [59, -3.698554, 1.771522, 1.915858],
    [60, 0.081446, -4.530478, 0.003856],
    [61, -4.300554, 1.167522, -0.998144],
    [62, 0.027446, -0.200478, 4.633856],
    [63, -1.572554, -4.240478, 1.083856],
    [64, -3.772554, 0.355522, -2.746144],
    [65, -2.644554, 1.455522, 3.581856],
    [66, -0.352554, 2.843524, -3.766144],
    [67, -4.358554, -1.382478, 1.221856],
    [68, -1.630554, 1.381524, -4.262144],
    [69, 0.933446, 4.599522, 0.915858],
    [70, 0.445446, 4.677522, -1.014142],
    [71, 4.587446, -1.030478, 1.003856],
    [72, -1.732554, -4.444478, -0.898144],
    [73, 1.777446, -4.448478, -1.056142],
    [74, 3.119446, 1.373522, -3.532144],
    [75, -3.412554, -1.920478, 2.965856],
    [76, -4.824554, 0.521522, 0.829856],
    [77, 3.959446, -1.774478, -2.352144],
    [78, -1.826554, -1.946478, 4.183856],
    [79, -2.074554, -3.466478, 2.903856],
    [80, 4.015446, -2.982478, 0.319856],
    [81, 0.899446, -3.628478, 3.373856],
    [82, 0.277446, 1.295522, -4.864144],
    [83, 3.777446, 3.253522, -0.958144],
    [84, 2.867446, 4.085522, 0.933858],
    [85, -2.092554, 3.685522, 2.801856],
    [86, 2.547448, -3.814478, 2.227856],
    [87, -2.276554, -1.866478, -4.238144],
    [88, 0.721446, -3.632478, -3.642144],
    [89, 0.507446, 3.433524, 3.905858],
    [90, 4.003446, -2.456478, 2.289856],
    [91, -2.840554, 4.085522, -1.604144],
    [92, -2.244554, 3.361522, -3.370144],
    [93, 0.907446, -4.880478, 1.785856],
    [94, 2.937446, -1.664478, -4.064144],
    [95, 4.391448, 2.779522, 0.979856],
    [96, -3.536554, 3.699522, 1.419858],
    [97, 2.575448, -2.626478, 3.831856],
    [98, -3.288554, -0.350478, 4.191856],
    [99, -4.570554, -2.300478, -1.594144],
    [100, -1.264552, -0.450478, -5.206144],
    [101, -0.648554, 2.067522, 4.923856],
    [102, 3.153446, 0.421522, 4.347856],
    [103, 1.695446, 2.941522, -4.210144],
    [104, 2.861446, -3.614478, -2.850144],
    [105, 3.205446, 3.275522, -2.938144],
    [106, 4.559446, 1.957522, -2.270144],
    [107, 2.297448, 4.663522, -1.810144],
    [108, 4.489446, -0.056478, -3.224144],
    [109, -1.768554, 0.433524, 5.227856],
    [110, 5.199446, -1.770478, -0.750142],
    [111, 2.679448, 2.393522, 4.221858],
    [112, 1.209446, -2.190478, -4.948144],
    [113, -3.134554, -0.098478, -4.586144],
    [114, 1.019446, -2.204478, 5.017856],
    [115, 4.177446, 2.293522, 2.901858],
    [116, 2.987446, -4.732478, 0.509858],
    [117, -0.090554, 4.811524, -2.942144],
    [118, -4.712554, -3.090476, 0.243856],
    [119, -4.994554, 2.557522, 0.611856],
    [120, 5.463446, 0.327522, -1.518144],
    [121, -3.644554, 2.011522, -3.866144],
    [122, -3.666554, -4.140478, -1.302142],
    [123, -0.696554, 5.677522, 0.519856],
    [124, -4.428554, 2.997522, -2.140144],
    [125, -1.208554, -3.850478, -4.116144],
    [126, -1.382554, 5.433524, -1.348144],
    [127, -0.826554, -5.022478, 2.763856],
    [128, 4.071448, -1.312478, 3.929858],
    [129, 5.779446, 0.471522, 0.447856],
    [130, -0.802554, -3.726478, 4.423856],
    [131, 1.601446, 0.551524, 5.603858],
    [132, 3.855446, -4.228478, -1.236144],
    [133, -3.522554, -4.652478, 0.619856],
    [134, -4.596554, 1.019522, 3.541856],
    [135, -5.792554, -1.048478, -0.248144],
    [136, -5.440554, -0.590476, -2.188144],
    [137, 4.877448, 0.417522, 3.341856],
    [138, 2.347446, 1.045522, -5.346144],
    [139, 1.579446, 5.011522, 2.767856],
    [140, -3.424554, -3.346478, -3.518144],
    [141, -0.730554, -2.400478, -5.396144],
    [142, -0.400554, 5.377524, 2.573856],
    [143, -5.106554, -0.844478, 2.987856],
    [144, -4.402554, -1.570478, -3.796144],
    [145, 0.401446, -5.826478, -1.484144],
    [146, -2.364554, 5.337522, 1.563856],
    [147, 3.367446, 4.129522, 2.869856],
    [148, 0.559446, -0.302476, -6.024144],
    [149, -0.716554, -1.632478, 5.817856],
    [150, -2.350554, 3.087522, 4.695856],
    [151, -4.020554, 2.933524, 3.537858],
    [152, 1.455446, -5.984478, 0.205856],
    [153, -2.426554, -4.930478, -2.808144],
    [154, 1.855446, 5.893522, -0.292142],
    [155, 2.729446, -1.254478, 5.417856],
    [156, 1.679448, -5.228478, -2.904144],
    [157, 1.197446, 2.509522, 5.559856],
    [158, -4.410554, -3.628478, 2.635856],
    [159, -4.574554, 4.285522, -0.622142],
    [160, -6.242554, 0.899522, -0.556142],
    [161, -0.986554, 2.679522, -5.652144],
    [162, -5.692554, 1.439522, -2.414144],
    [163, -1.086554, 4.585522, 4.273858],
    [164, -1.910552, -6.070478, 0.313856],
    [165, -0.418554, -5.488478, -3.282144],
    [166, 2.455446, -0.918478, -5.860144],
    [167, -3.060554, 5.639522, -0.276144],
    [168, 3.779446, 5.225522, -0.596144],
    [169, -0.204554, 0.541522, 6.467858],
    [170, -3.112554, -5.136478, 2.509858],
    [171, -1.148554, 4.493522, -4.602144],
    [172, -3.270554, -3.414478, 4.511856],
    [173, 5.891448, -1.318478, -2.568144],
    [174, 2.729446, -3.484478, -4.846144],
    [175, 5.963446, 1.713522, 2.203856],
    [176, 4.071448, 0.039522, -5.180144],
    [177, 5.351446, -3.202478, -2.142144],
    [178, -0.254552, -6.456478, 1.363858],
    [179, -2.244554, 5.351522, -3.152144],
    [180, -3.632554, 1.571522, 5.321858],
    [181, 2.217448, 4.315524, 4.527856],
    [182, -2.862554, -1.414478, 5.829856],
    [183, 3.583446, 2.789522, -4.862144],
    [184, -2.738554, 1.337522, -5.918144],
    [185, -5.228554, 0.229522, -4.120144],
    [186, -1.542552, -6.286478, -1.638144],
    [187, 5.605446, -3.332478, 1.471856],
    [188, 4.455446, -3.064478, -3.934144],
    [189, -6.306554, -1.658478, 1.577856],
    [190, 6.261446, 2.409524, 0.355856],
    [191, 0.977446, 2.725522, -6.070144],
    [192, 1.597446, -5.484478, 3.557856],
    [193, 6.479446, -1.672478, 0.789856],
    [194, 0.165446, 6.661522, -1.040144],
    [195, -0.908554, 0.935522, -6.620144],
    [196, -4.544554, -1.880478, 4.619856],
    [197, 0.821446, 6.531522, 1.491856],
    [198, 0.829446, 4.611522, -4.880144],
    [199, 5.069446, 1.647522, -4.172144],
    [200, 2.755446, 6.011522, 1.489856],
    [201, 1.733446, -4.082478, 5.133856],
    [202, -6.094554, 2.833522, -1.042142],
    [203, -2.872554, 3.215522, -5.260144],
    [204, -6.510554, 1.453522, 1.375856],
    [205, 0.999446, -1.044478, 6.659856],
    [206, 4.169446, -4.976478, 2.091856],
    [207, 5.385446, 4.187522, -0.060144],
    [208, -3.718554, 4.843524, 3.047858],
    [209, 3.293446, -4.496478, 3.953858],
    [210, 1.651446, 5.703522, -3.408144],
    [211, 4.511446, 1.817522, 4.823856],
    [212, 2.519448, -6.090478, 1.893856],
    [213, 5.813446, -1.886478, 3.135856],
    [214, 5.403446, 3.777524, -2.006144],
    [215, 6.543448, -0.212478, 2.153856],
    [216, 2.557446, -6.270478, -1.442144],
    [217, 4.511446, 5.059522, 1.515856],
    [218, -3.194554, -1.526478, -5.978144],
    [219, -4.088554, 4.345522, -3.570144],
    [220, -2.480554, -3.348478, -5.568144],
    [221, 6.443448, 2.093524, -1.610144],
    [222, 5.019448, -4.860478, 0.273858],
    [223, -2.014554, 2.063522, 6.391858],
    [224, -5.660554, -3.958478, -1.300144],
    [225, -5.472554, 4.003522, 1.893856],
    [226, -5.388554, -3.260478, -3.156144],
    [227, -5.920554, 2.415522, 3.023858],
    [228, -1.942554, -3.210478, 5.997856],
    [229, 3.057446, 4.659524, -4.376144],
    [230, -3.554554, -6.080478, -0.820144],
    [231, 4.017446, 5.225522, -2.634144],
    [232, -2.098554, -5.254478, 4.309856],
    [233, 0.027446, -3.456478, 6.225856],
    [234, 5.361446, -1.324478, -4.498144],
    [235, -4.330554, 5.521522, 1.257856],
    [236, 5.089448, -3.740478, 3.355856],
    [237, 6.295446, -3.458478, -0.396142],
    [238, 0.931446, -3.874478, -5.990144],
    [239, 3.063446, 2.115522, 6.163856],
    [240, 0.537446, 5.753522, 4.299856],
    [241, -4.984554, -0.026478, 5.207858],
    [242, -3.966554, 5.669524, -2.070144],
    [243, -6.620554, -2.180478, -1.896142],
    [244, -0.138554, -5.618478, 4.555856],
    [245, -6.680554, -2.832478, 0.001856],
    [246, -5.476554, 2.817522, -3.838144],
    [247, -2.158554, 6.035522, 3.429858],
    [248, 3.507446, -3.240478, 5.489856],
    [249, 0.491446, -2.080478, -6.956144],
    [250, -1.464554, -1.428478, -6.988144],
    [251, 3.997446, -2.182478, -5.682144],
    [252, 0.929448, -5.450478, -4.752144],
    [253, -0.786554, 6.685522, -2.804144],
    [254, -4.426554, -4.994478, -2.952144],
    [255, 4.135446, 3.777524, 4.683856],
    [256, 0.667446, 4.415522, 5.787858],
    [257, 6.009448, 3.773524, 1.805856],
    [258, 6.539446, 0.601522, -3.320144],
    [259, 4.223446, 0.245522, 6.021856],
    [260, 1.453446, 1.093524, -7.140144],
    [261, 3.343446, -5.202478, -4.008144],
    [262, -1.228554, 3.885522, 6.151858],
    [263, -1.732554, 7.165524, -0.326144],
    [264, -1.278554, 7.029522, 1.871856],
    [265, -7.356554, -0.216478, 0.675856],
    [266, -6.928554, -0.066476, 2.611856],
    [267, -6.212554, -3.648478, 1.761856],
    [268, 2.729446, 6.611522, -1.972144],
    [269, 4.891448, 3.985524, -3.934144],
    [270, -4.410554, -2.970478, -5.214144],
    [271, -0.154554, 2.453522, 7.039856],
    [272, 7.187446, -1.664478, -1.084144],
    [273, -3.150554, 0.309522, 6.787858],
    [274, -5.982554, -2.780478, 3.549856],
    [275, -5.492554, -5.084478, 0.339858],
    [276, 5.787446, -0.672478, 4.737856],
    [277, 1.931446, -2.836478, 6.695856],
    [278, 3.555446, -6.630478, 0.263856],
    [279, -4.816554, 1.865522, -5.478144],
    [280, -4.538554, -0.050478, -6.008144],
    [281, 4.887448, -5.044478, -2.744144],
    [282, -2.296554, -5.404478, -4.742144],
    [283, -1.928554, -6.684478, 2.941856],
    [284, 5.783448, 3.173522, 3.701856],
    [285, -3.640554, -6.568478, 1.185856],
    [286, -1.584554, -0.774478, 7.403856],
    [287, 7.461446, 0.373522, -1.466144],
    [288, 3.157446, 6.021522, 3.443858],
    [289, -5.628554, 4.587522, -2.318144],
    [290, -6.402554, -1.668478, -3.814144],
    [291, -0.954554, -4.544478, -6.066144],
    [292, 2.373446, -2.712478, -6.736144],
    [293, -7.532554, -0.422478, -1.336144],
    [294, -0.768554, -7.634478, -0.330144],
    [295, 2.919446, 2.391522, -6.706144],
    [296, -7.000554, 0.145524, -3.194144],
    [297, 1.383446, 1.203522, 7.483856],
    [298, -6.928554, 3.295522, 0.725856],
    [299, -5.378554, 2.485524, 4.945856],
    [300, -4.060554, 3.947524, 5.281856],
    [301, 1.149446, -7.604478, -0.920144],
    [302, 3.351446, 0.465522, -6.994144],
    [303, 6.379446, 1.377522, 4.243856],
    [304, -2.982554, 5.197524, -5.006144],
    [305, -6.470554, 0.949522, 4.277856],
    [306, 2.297448, 4.229522, -6.180144],
    [307, -3.138554, 7.123522, 1.145856],
    [308, -2.896554, -0.080478, -7.328144],
    [309, -2.614554, 7.133522, -2.118144],
    [310, -0.054554, -7.480478, -2.514142],
    [311, 6.493446, 2.897522, -3.436144],
    [312, 4.695446, 1.677522, -6.146144],
    [313, -6.510554, -1.046478, 4.403856],
    [314, -0.076554, -0.342478, -7.926144],
    [315, -0.028552, -7.280478, 3.167856],
    [316, 1.319446, -7.678478, 1.547858],
    [317, 7.929448, -0.372478, 0.333856],
    [318, -3.218554, -6.770478, -2.672144],
    [319, 7.727448, 1.367524, 1.327856],
    [320, 4.443448, -1.712478, 6.385856],
    [321, 3.487446, 7.163522, -0.210144],
    [322, -2.636554, 5.363524, 5.277856],
    [323, 1.053446, 7.453522, -2.652144],
    [324, 5.433446, -2.846478, 5.109856],
    [325, 4.979446, 5.205522, 3.447856],
    [326, -0.036554, 7.985524, 0.433856],
    [327, 2.855446, -1.034478, 7.403856],
    [328, -5.598554, 4.185522, 3.911856],
    [329, -5.014554, 6.259524, -0.468144],
    [330, 4.913446, -6.258478, -1.148144],
    [331, -7.658554, 1.525522, -1.912144],
    [332, 1.909446, -0.748478, -7.774144],
    [333, -4.318554, -5.124478, 4.455856],
    [334, -1.250554, -5.074478, 6.127858],
    [335, -1.844552, 4.431522, -6.478144],
    [336, -1.976552, 2.553522, -7.388144],
    [337, -4.158554, -2.970478, 6.247856],
    [338, 6.135446, 0.347522, -5.264142],
    [339, -6.504554, 4.795522, -0.532144],
    [340, -0.008554, 2.321522, -7.762144],
    [341, 3.329446, -6.478478, 3.673856],
    [342, -4.762554, 3.863522, -5.388144],
    [343, -1.576554, -7.064478, -3.776144],
    [344, -8.008554, 1.587522, 0.063856],
    [345, 1.763446, 7.949522, -0.848144],
    [346, -5.436554, -5.936478, -1.498144],
    [347, 2.179448, -6.830478, -3.990144],
    [348, -1.308554, 1.145522, 8.019858],
    [349, -0.492554, -2.392478, 7.835858],
    [350, 7.247446, 3.799522, -0.704144],
    [351, -1.610554, -7.954478, 1.419858],
    [352, 1.819446, 7.479522, 2.937856],
    [353, -1.642554, 6.635522, -4.608144],
    [354, -7.080554, 3.259522, -2.728144],
    [355, 2.599448, -5.212478, -5.858144],
    [356, -0.088554, 7.481524, 3.527856],
    [357, 5.935446, 5.599522, -1.378144],
    [358, -4.566554, -1.098478, 6.831856],
    [359, 6.915448, -2.460478, -3.858144],
    [360, 6.161446, -5.168478, 2.047858],
    [361, -0.398554, 5.757522, -5.964144],
    [362, 0.395446, 6.989522, -4.478144],
    [363, 0.733446, -5.344478, 6.327856],
    [364, 0.137446, -0.288478, 8.309856],
    [365, 3.869446, -6.774478, -2.880144],
    [366, 3.231448, 4.203522, 6.409856],
    [367, 7.343446, -3.372478, -2.106144],
    [368, 2.375446, -5.966478, 5.355856],
    [369, -5.918554, -4.916478, 3.275856],
    [370, -3.230554, -4.734478, 6.089858],
    [371, 0.015446, 4.249524, -7.210144],
    [372, -2.906554, -7.860478, -0.156144],
    [373, 5.283448, 6.499524, 0.355856],
    [374, -1.108554, 6.627524, 5.021856],
    [375, 8.135446, 2.007522, -0.522144],
    [376, 7.809446, -0.906476, -2.954144],
    [377, 6.497446, -5.102478, -1.568144],
    [378, 4.443448, -4.512478, -5.536144],
    [379, -1.914554, -3.316478, -7.492144],
    [380, -4.620554, -6.402478, 2.915858],
    [381, 7.081446, -3.424478, 2.999856],
    [382, -3.934554, 6.831522, 2.963856],
    [383, -2.792552, -2.356478, 7.595858],
    [384, 3.351446, 0.871524, 7.709856],
    [385, 2.065446, 6.023524, 5.563856],
    [386, 2.259448, 8.079524, 1.081856],
    [387, -3.622554, 6.649522, -3.780144],
    [388, -7.690554, -1.866478, 3.009858],
    [389, 2.247446, 6.275522, -5.222144],
    [390, -3.852554, -4.790478, -5.836144],
    [391, 1.653446, 3.175522, 7.683856],
    [392, -5.438554, -4.594478, -4.632144],
    [393, 5.799446, -3.042478, -5.410144],
    [394, 4.389446, 6.953522, 2.163856],
    [395, -6.648554, 1.101522, -5.214144],
    [396, -0.766554, -6.462478, -5.504144],
    [397, -6.340554, -0.834478, -5.636144],
    [398, 3.765446, -1.442478, -7.526144],
    [399, 7.729446, -1.068478, 3.473856],
    [400, 5.451446, -1.070478, -6.488144],
    [401, 5.931446, 3.035522, -5.348144],
    [402, 4.293446, 4.249524, -6.042144],
    [403, 7.569446, 2.617524, 2.989856],
    [404, -5.636554, 5.811524, 2.747856],
    [405, -3.756554, 2.129522, 7.379856],
    [406, -8.368556, -1.758478, -0.104144],
    [407, 7.497446, -3.988478, 1.123856],
    [408, 4.979446, -5.514478, 4.285856],
    [409, -4.224554, 1.423522, -7.336144],
    [410, -5.020554, -1.832478, -6.746144],
    [411, 7.855446, 3.357522, 1.151856],
    [412, 4.913446, 3.077522, 6.383856],
    [413, 6.297448, -4.358478, -3.978144],
    [414, -5.424554, 1.353524, 6.591856],
    [415, 5.887448, 1.347522, 6.191856],
    [416, -7.326554, 3.789522, 2.619856],
    [417, 8.219446, -2.054478, 1.783858],
    [418, -2.000554, -8.212478, -1.900144],
    [419, -4.482554, 5.799522, 4.629856],
    [420, 4.683446, 7.029522, -2.026144],
    [421, -0.034554, -3.944478, -7.740144],
    [422, -3.736554, 3.451522, -7.052144],
    [423, 3.485446, 6.999524, -3.804144],
    [424, 4.009448, 5.689522, 5.231858],
    [425, 5.399446, -6.760478, 1.019856],
    [426, 3.887448, -7.534478, 2.073856],
    [427, -5.992554, -2.190478, 5.959856],
    [428, 1.377448, -1.960478, 8.395856],
    [429, -8.078554, -3.014478, 1.421856],
    [430, -1.340554, 1.069522, -8.570144],
    [431, -8.036554, 3.323522, -0.958144],
    [432, 6.907446, 5.349522, 0.527856],
    [433, 1.873446, -7.820478, 3.459856],
    [434, -8.018554, 1.523522, 3.165858],
    [435, 2.367446, -8.090478, -2.440144],
    [436, -3.220554, 4.029522, 7.099858],
    [437, 1.681446, 3.393522, -7.924144],
    [438, -3.320554, -6.860478, 4.363858],
    [439, -5.910554, -4.060478, 5.083856],
    [440, -4.266554, -6.224478, -4.512144],
    [441, -6.704554, -4.770478, -3.100144],
    [442, 2.603446, -8.398478, 0.185856],
    [443, -1.320554, -7.290478, 4.747856],
    [444, -0.000554, 8.687522, -1.442144],
    [445, -8.180554, -1.448478, -2.922144],
    [446, -3.294554, -1.936478, -7.948144],
    [447, 2.505446, -4.726478, 7.021856],
    [448, -6.202554, 4.657522, -4.234144],
    [449, 5.805446, 5.703522, -3.450144],
    [450, -1.680554, 3.213522, 8.079856],
    [451, -3.474554, 8.129522, -0.550144],
    [452, -6.972554, 5.299522, 1.349858],
    [453, -4.886554, -7.404478, -0.148144],
    [454, 7.177446, 4.561524, -2.550144],
    [455, 0.431446, -7.674478, -4.446144],
    [456, -6.386554, -2.830478, -5.508144],
    [457, -7.436554, -4.884478, 0.775856],
    [458, -0.006554, 4.285522, 7.835858],
    [459, 0.705446, -7.358478, 5.029856],
    [460, 4.241446, -5.002478, 6.081856],
    [461, 0.887446, -4.006478, 7.947856],
    [462, -0.562554, -2.234478, -8.644144],
    [463, 8.535446, -2.748478, -0.058144],
    [464, 8.373448, 1.391522, -2.934144],
    [465, -7.334554, -5.046478, -1.216144],
    [466, -7.268554, 2.877522, 4.431856],
    [467, 0.431446, -5.712478, -6.928144],
    [468, -0.078554, 6.069522, 6.639856],
    [469, 6.945446, -5.716478, 0.295856],
    [470, -6.272554, -6.208478, 1.795856],
    [471, 7.503446, 1.715522, -4.702144],
    [472, -1.980554, -4.170478, 7.755858],
    [473, -2.046554, 8.771522, 0.843856],
    [474, 8.227448, 0.853524, 3.671856],
    [475, -1.968554, 8.167522, 3.367856],
    [476, 3.591446, -2.860478, 7.801856],
    [477, 6.057448, -0.574478, 6.715856],
    [478, 1.913446, -4.546478, -7.622144],
    [479, 4.639446, 5.947524, -5.058144],
    [480, 0.533446, -9.062480, 0.287856],
    [481, -5.560554, 6.341522, -3.376144],
    [482, -8.060554, -3.520478, -2.280144],
    [483, -8.916554, 0.499524, 1.701856],
    [484, -3.338554, -8.102478, 2.427856],
    [485, 5.119446, -6.060478, -4.450144],
    [486, -4.710554, 7.523524, -2.002144],
    [487, -5.218554, 7.307522, 1.491856],
    [488, -7.616554, -3.860478, 3.165858],
    [489, 8.865446, -0.174478, 2.087856],
    [490, 1.723446, 5.141524, 7.327856],
    [491, 4.045446, -8.058478, -1.350144],
    [492, 1.427446, -2.846478, -8.550144],
    [493, -6.672554, 3.107522, -5.414144],
    [494, -0.542554, 8.865522, 2.157856],
    [495, 2.023448, -0.038476, 8.919858],
    [496, 2.679448, 1.733522, -8.578144],
    [497, 1.341446, 5.809522, -6.944144],
    [498, -6.706554, -0.218478, 6.227856],
    [499, -1.932554, -0.812478, -8.920146],
    [500, 3.619446, 2.923522, 7.903856],
    [501, -3.092554, 7.223522, 4.737856],
    [502, 7.323446, -2.172478, 5.087856],
    [503, 5.891448, 4.775522, 5.185856],
    [504, 6.755448, 2.999524, 5.459856],
    [505, -5.274554, 3.341522, 6.745858],
    [506, -1.342554, 8.613524, -2.918144],
    [507, 0.913446, 0.959522, -9.102144],
    [508, -8.664554, 2.647522, 1.633856],
    [509, -4.870554, 5.849522, -5.186144],
    [510, -7.966554, 2.149522, -4.136144],
    [511, -9.236556, 0.035522, -0.220144],
    [512, 1.615446, -6.946478, -5.896144],
    [513, 4.967448, -3.014478, -7.224144],
    [514, 0.019446, -9.030478, 2.213856],
    [515, 7.189448, -1.634478, -5.666144],
    [516, 7.661448, -0.208478, 5.275856],
    [517, 2.809446, 8.509524, -2.584144],
    [518, -1.708554, 5.281522, 7.501856],
    [519, 0.957446, 7.663522, 5.239856],
    [520, -3.968554, -3.778478, -7.570144],
    [521, -7.538554, -2.720478, 4.807858],
    [522, -0.306552, -9.216478, -1.526144],
    [523, 2.871446, 7.603524, 4.635856],
    [524, -5.138554, -7.224478, -3.012144],
    [525, 9.289446, -0.374478, -1.136144],
    [526, -2.584554, -5.214478, -7.340144],
    [527, 8.559446, 3.181522, -2.092144],
    [528, -1.618554, -8.626478, 3.303856],
    [529, -6.112554, 0.499524, -7.108144],
    [530, -0.014554, 2.647522, 9.017856],
    [531, -6.598554, 6.483522, -1.670144],
    [532, -2.538554, -6.602478, 6.191856],
    [533, -8.632556, -3.726478, -0.366144],
    [534, -6.716554, -6.598478, -0.116144],
    [535, 8.951446, -2.190478, -1.936144],
    [536, -4.066554, -8.316478, -1.726142],
    [537, -7.896554, -2.966478, -4.198144],
    [538, 6.375446, 6.639522, 2.023858],
    [539, -2.842554, -0.892476, 8.951856],
    [540, -4.676554, -0.390478, -8.194144],
    [541, -1.896554, 9.223522, -1.096144],
    [542, -3.594552, 5.439522, -6.884144],
    [543, -4.760554, 0.347522, 8.195856],
    [544, 5.295446, -3.590476, 7.001856],
    [545, -5.634554, 2.815524, -7.098144],
    [546, 7.017446, 4.501522, -4.544144],
    [547, 5.947446, 0.719522, -7.386144],
    [548, 4.667446, -0.970478, 8.239856],
    [549, 4.769448, 7.153522, 4.117856],
    [550, -0.524554, -6.922478, 6.541856],
    [551, -3.076554, 1.095522, 8.967858],
    [552, -3.096554, -6.680478, -6.076144],
    [553, -1.460554, -9.438478, 0.099856],
    [554, 2.033448, 8.151524, -4.552144],
    [555, 9.507446, 0.879522, 0.393856],
    [556, -9.290554, -1.460478, 1.763856],
    [557, 2.341446, 1.929522, 9.085858],
    [558, 7.705446, 5.179524, 2.387856],
    [559, 6.935446, -5.362478, 3.879856],
    [560, 0.919448, -1.140478, -9.476144],
    [561, 3.355446, -3.352478, -8.364144],
    [562, 1.209446, 9.547524, 0.219856],
    [563, 3.695446, 3.521522, -8.168144],
    [564, -0.468554, -5.468478, 7.919858],
    [565, -8.580554, -0.050478, -4.406144],
    [566, 5.459446, 3.193522, -7.286144],
    [567, 6.237446, -4.728478, 5.643856],
    [568, 8.435446, -4.678478, -0.556142],
    [569, -9.020554, -0.452478, 3.461856],
    [570, 3.777446, 0.069522, -8.910144],
    [571, -8.608554, 4.377524, 0.653856],
    [572, 2.627448, -9.086478, 2.067856],
    [573, -5.096554, -4.640478, 6.813856],
    [574, -5.638554, -4.320478, -6.604144],
    [575, 5.323446, 0.911522, 8.057858],
    [576, -2.346554, 4.245522, -8.402144],
    [577, -3.374554, 7.059522, -5.740144],
    [578, 4.615446, -8.524478, 0.491856],
    [579, 3.403446, 8.677522, 2.707858],
    [580, -6.604554, 4.329524, 5.643856],
    [581, 3.527446, 5.927522, -6.842144],
    [582, 0.827446, -9.158478, -3.168144],
    [583, 4.149446, -6.916478, 5.449856],
    [584, -3.334554, -8.002478, -4.432144],
    [585, 4.475446, 8.593524, 1.015856],
    [586, 6.165448, -6.988478, 2.853858],
    [587, 3.875446, -7.608478, -4.708144],
    [588, 3.465446, 9.103524, -0.720144],
    [589, 6.789446, -6.184478, -3.338144],
    [590, -3.206554, 0.733522, -9.202144],
    [591, -8.184556, 4.855522, -2.228144],
    [592, 0.441446, 9.031522, -3.724144],
    [593, -2.714554, 8.333522, -4.352144],
    [594, 1.383446, 9.419524, 2.275856],
    [595, -1.158554, 5.749524, -7.838144],
    [596, -5.060554, 5.313522, 6.487856],
    [597, 1.651446, -9.570478, -1.292142],
    [598, -1.154554, -9.076478, -3.512144],
    [599, -9.568554, 1.691522, -1.332144],
    [600, -1.130554, -1.700478, 9.593856],
    [601, 9.707448, -1.294478, 0.657856],
    [602, -8.068554, 1.043522, 5.497856],
    [603, -2.346554, 6.935522, 6.571858],
    [604, 4.103446, -4.968478, -7.446144],
    [605, -5.834554, -6.536478, 4.497856],
    [606, -0.536554, 3.757522, -9.092144],
    [607, -4.518554, -6.384478, 5.997856],
    [608, 4.677446, 1.809522, -8.490144],
    [609, -5.470554, 8.201522, -0.276144],
    [610, -0.860554, 8.399522, -5.106144],
    [611, 2.847446, -1.658478, -9.308144],
    [612, -4.020554, 8.911522, 1.403856],
    [613, 6.717448, 6.093524, 3.915858],
    [614, -8.308554, -0.932478, 5.267856],
    [615, -9.646554, -0.342478, -2.140144],
    [616, 8.057448, 5.623522, -1.108142],
    [617, -3.384554, 8.935522, -2.558144],
    [618, 9.479446, 1.899522, 2.105856],
    [619, 7.953448, 4.223522, 4.121856],
    [620, 4.939448, 5.109522, 6.907856],
    [621, -1.566554, 7.247522, -6.578144],
    [622, -9.506554, -2.278478, -1.664144],
    [623, 0.521446, 0.917522, 9.865856],
    [624, 0.424650, 7.515928, -6.463744],
    [625, -1.460554, 0.279522, 9.811858],
    [626, -7.142554, 2.571522, 6.401858],
    [627, -6.474554, 6.005522, 4.559856],
    [628, -4.276554, -3.516478, 8.257856],
    [629, 8.887448, -2.736476, 3.539856],
    [630, -9.074554, 3.113522, -2.652144],
    [631, 1.579446, -7.092478, 6.803856],
    [632, 6.895446, 7.173522, -0.610144],
    [633, 3.127448, -1.650478, 9.323856],
    [634, -6.394554, -6.340478, -4.292144],
    [635, 5.985446, -7.934478, -0.896144],
    [636, -7.074554, -6.614478, -2.436144],
    [637, 8.761446, -0.846478, -4.722144],
    [638, 7.173446, 2.121522, -6.632144],
    [639, -1.562554, -8.312480, -5.330142],
    [640, 8.631446, -3.510478, -3.632144],
    [641, -6.980554, 7.151522, 0.521856],
    [642, 4.715446, -7.954478, 3.843856],
    [643, 5.347446, 8.433524, -0.774144],
    [644, 5.651448, -7.762478, -2.866144],
    [645, 2.537446, -8.104478, 5.335858],
    [646, 7.957448, 0.353522, -6.102144],
    [647, 8.263446, -5.126478, -2.504144],
    [648, -5.122554, -8.520478, 1.497856],
    [649, 0.527446, -9.148478, 4.143856],
    [650, 3.387448, 6.363524, 7.015856],
    [651, -8.186554, 4.139522, -4.148144],
    [652, 8.567446, 3.307522, -4.134144],
    [653, -4.688554, -1.630478, 8.763856],
    [654, 6.193448, 4.793522, -6.340144],
    [655, -0.452554, -3.654478, 9.389856],
    [656, -8.156554, 5.925522, -0.540144],
    [657, -7.404554, -4.752478, -4.968144],
    [658, -0.560554, 0.043522, -10.100144],
    [659, 8.237446, 1.665522, 5.641858],
    [660, 6.147446, -4.630478, -6.580144],
    [661, -4.062554, 2.685522, -8.878144],
    [662, 9.671446, 2.973522, 0.401856],
    [663, 5.385446, 7.537524, -4.112144],
    [664, 7.611446, -3.904478, -5.436144],
    [665, -5.682554, 4.923522, -6.810144],
    [666, -8.098554, -1.844478, -5.830144],
    [667, 9.667446, -0.128478, -3.084144],
    [668, 0.709446, -1.062478, 10.069856],
    [669, -0.818554, 8.579524, 5.371856],
    [670, 2.529446, 5.129522, -8.412144],
    [671, -7.978554, 0.093524, -6.312144],
    [672, -3.546554, -9.510478, 0.769856],
    [673, -3.392554, 3.069522, 9.101856],
    [674, -3.880554, 8.751522, 3.509858],
    [675, 1.505446, 9.893522, -1.960144],
    [676, -9.566556, 1.291522, -3.298144],
    [677, 5.541446, -1.474478, -8.442144],
    [678, -7.438554, -5.340478, 4.505858],
    [679, -8.110554, -5.678478, 2.479856],
    [680, 1.537446, 7.131524, 7.139856],
    [681, -7.984554, 4.731522, 4.251856],
    [682, 3.323446, -6.750478, -6.918144],
    [683, 8.061448, -4.022478, 4.839858],
    [684, -2.494554, -3.168478, 9.399856],
    [685, 0.221448, 9.457524, 3.905858],
    [686, 8.873448, 5.051524, 0.767856],
    [687, 2.525446, -8.990478, -4.212142],
    [688, -0.984554, -5.894478, -8.326144],
    [689, -3.566554, -5.366478, 7.985858],
    [690, -10.118556, 1.641522, 0.597856],
    [691, -5.472554, 2.231522, 8.397858],
    [692, 7.509448, -6.836478, -1.588144],
    [693, 8.635446, -4.684478, 3.043856],
    [694, 1.469446, 2.737522, -9.810144],
    [695, -7.456554, 1.945522, -6.836144],
    [696, -6.132554, -8.134478, -1.532144],
    [697, 0.575448, 5.385522, -8.764144],
    [698, -9.108554, 3.119522, 3.693858],
    [699, -7.652554, 6.263524, 2.965856],
    [700, -0.424554, 2.039522, -10.116144],
    [701, -7.050554, -1.272478, -7.448144],
    [702, -5.152554, 7.679524, 4.627858],
    [703, 3.833446, 0.449522, 9.597856],
    [704, 10.047448, 2.077522, -1.340144],
    [705, -1.878554, -4.340476, -9.208144],
    [706, -3.598554, 5.887522, 7.723856],
    [707, 6.303446, -2.134478, 7.947856],
    [708, -0.630554, 10.321524, 0.793856],
    [709, -5.352554, -8.183678, 3.455856],
    [710, -6.406554, -0.790478, 8.121856],
    [711, -1.488554, -7.402478, -7.116144],
    [712, -6.172554, -2.758478, 7.877858],
    [713, -3.082554, -9.434478, -3.062144],
    [714, -4.956554, 8.001522, -4.396142],
    [715, -2.996554, -9.890478, -1.116144],
    [716, -7.606554, 6.007522, -3.758144],
    [717, -9.474554, -3.204478, 2.841856],
    [718, -2.264554, 2.779522, -9.762144],
    [719, 1.669446, -5.846478, 8.443858],
    [720, 7.969446, -6.370478, 2.047858],
    [721, 0.157446, -8.240478, -6.356144],
    [722, -1.998554, -10.040478, 1.925856],
    [723, 2.405448, 7.575524, -6.734144],
    [724, 9.391448, 3.889522, 2.309856],
    [725, 7.257446, -3.362478, 6.685856],
    [726, 7.189448, -0.848478, -7.502144],
    [727, 2.997446, 9.933524, 1.033856],
    [728, 3.657446, -6.456478, 7.327856],
    [729, 6.965446, -2.892478, -7.214144],
    [730, 9.311448, 2.611522, 3.963856],
    [731, 4.165448, -9.088478, -3.072144],
    [732, -4.548554, -5.798478, -7.422144],
    [733, 6.789446, 2.469522, 7.563856],
    [734, 4.761446, 8.939522, -2.624144],
    [735, -3.644554, -8.832478, 4.269858],
    [736, 7.681446, 6.421522, -3.052144],
    [737, 6.449446, 7.877524, -2.436144],
    [738, 5.227446, -6.408478, -6.422144],
    [739, 3.225446, -4.492478, 8.893856],
    [740, 0.163446, -3.874478, -9.730144],
    [741, 5.621446, 8.393522, 2.773858],
    [742, -9.330554, -4.576478, 1.333856],
    [743, -1.726552, 2.469522, 10.035856],
    [744, -2.194554, -2.506478, -9.942144],
    [745, -2.606554, 9.865522, 2.451856],
    [746, 2.333446, 3.895524, 9.461856],
    [747, -7.054554, 1.063522, 7.717858],
    [748, 7.157446, -7.664478, 0.705856],
    [749, 2.091446, -10.288478, 0.559856],
    [750, 7.529448, 0.633522, 7.311858],
    [751, 2.305446, 0.099522, -10.260144],
    [752, 6.619446, 6.355522, -5.150144],
    [753, 9.813446, -3.308478, 1.867856],
    [754, -6.370554, 7.801524, 3.049856],
    [755, 6.119446, -7.040478, 4.871856],
    [756, 0.475446, 6.101522, 8.561858],
    [757, -4.320554, 7.177522, 6.371856],
    [758, 7.845448, -1.446478, 6.875856],
    [759, -3.780554, -1.252478, -9.754144],
    [760, -10.308554, -2.192478, 0.183856],
    [761, -5.748554, -2.526478, -8.480144],
    [762, -4.722554, 4.361522, 8.369856],
    [763, 3.665448, -9.878480, -0.618144],
    [764, 3.819446, 4.875522, 8.547858],
    [765, -9.062554, 4.769522, 2.561858],
    [766, -5.750554, 1.615522, -8.734144],
    [767, -7.740554, -1.922478, 6.957858],
    [768, 6.459446, 8.331522, 0.961856],
    [769, 9.499446, -1.120478, 4.551856],
    [770, 0.939446, -5.772478, -8.860144],
    [771, -8.648554, -5.106478, -3.446144],
    [772, 4.249446, 7.689522, -5.972144],
    [773, 6.795446, 4.359522, 6.915858],
    [774, 5.409446, 3.669524, 8.389856],
    [775, -7.410554, 4.953522, -5.806144],
    [776, -7.598554, -4.200478, 6.153856],
    [777, -9.516554, -1.810478, -4.412144],
    [778, -8.996554, -5.692478, -0.310144],
    [779, 6.017446, 6.711524, 5.679858],
    [780, 2.157446, 9.461524, 4.405858],
    [781, 9.275446, -5.116478, 1.197858],
    [782, 9.657446, 4.427522, -0.970144],
    [783, -9.746554, 1.283522, 4.149856],
    [784, 3.897446, 8.897522, -4.418144],
    [785, -4.296554, 4.655524, -8.592144],
    [786, -5.300554, -7.902478, -4.882144],
    [787, -0.264554, -8.840478, 6.015856],
    [788, -9.986556, 3.751522, -0.830142],
    [789, 4.909446, 5.105522, -8.050144],
    [790, 5.723446, -8.812480, 2.135856],
    [791, 4.351446, 7.789522, 5.963856],
    [792, -7.188554, -7.294478, 3.215856],
    [793, -0.370554, 10.427522, -2.546144],
    [794, 2.555446, -9.622478, 4.031856],
    [795, -7.194554, -3.264478, -7.278144],
    [796, 6.907446, -6.268478, -5.336144],
    [797, 10.283448, -1.522478, 2.755856],
    [798, -6.132554, -6.224478, -6.270144],
    [799, 2.165448, -4.376478, -9.600144],
    [800, 5.615446, -6.328478, 6.669858],
    [801, -1.852554, -6.934478, 8.039856],
    [802, 0.439446, 4.421522, 9.821858],
    [803, 9.821448, -3.998478, -1.962142],
    [804, 9.089448, 5.019522, -2.926144],
    [805, -5.102554, -9.492478, -0.490142],
    [806, -4.006554, -3.218478, -9.486146],
    [807, 1.497446, -4.168478, 9.843856],
    [808, -0.276554, -10.726478, 1.187856],
    [809, -4.510554, 9.747522, -1.116144],
    [810, -3.172554, 10.319522, 0.257856],
    [811, 9.977448, -2.030478, -3.646142],
    [812, -6.544554, -5.906478, 6.271856],
    [813, -7.898554, -7.310478, 1.333856],
    [814, -6.520554, 6.985524, -5.130144],
    [815, -9.206554, 1.473522, -5.546144],
    [816, -0.344552, -2.170476, -10.628144],
    [817, 5.117446, -3.366478, 8.981858],
    [818, 2.829446, -8.520478, -6.136144],
    [819, 4.333446, 2.379522, 9.687856],
    [820, -9.784554, -3.460478, -3.304144],
    [821, 1.305446, -10.552478, 2.395856],
    [822, 10.683446, -1.934478, -0.982144],
    [823, -8.788554, 6.313522, 1.321856],
    [824, -9.012554, -4.080478, 4.581856],
    [825, 4.957448, -5.206478, 8.197856],
    [826, -1.934554, -9.446478, 5.099858],
    [827, -1.230554, 7.083522, 8.217858],
    [828, 0.839448, 9.301524, -5.664144],
    [829, -10.406556, 2.189522, 2.493856],
    [830, 8.131446, 3.957524, -6.132144],
    [831, 8.707448, -6.606478, -0.006144],
    [832, -6.742554, -8.600478, 0.315856],
    [833, -1.714554, -5.206478, 9.459856],
    [834, 10.807448, 0.083522, 1.673856],
    [835, 2.325448, 9.981524, -3.838144],
    [836, -5.044554, 6.813522, -6.928144],
    [837, 10.251448, -3.846478, -0.014142],
    [838, -8.586554, 3.341522, -5.940144],
    [839, 5.719446, 0.293522, -9.350144],
    [840, -6.896554, 7.839524, -3.348144],
    [841, -1.214554, 5.473522, 9.427856],
    [842, 9.191446, -2.680478, -5.358144],
    [843, 1.239446, 2.661522, 10.581858],
    [844, -9.820554, -2.090476, 4.467858],
    [845, -4.368554, -0.160478, 10.083856],
    [846, 1.581446, -2.694478, -10.538146],
    [847, -10.686554, 0.209522, 2.577856],
    [848, -2.044554, 9.853524, 4.435856],
    [849, 3.705446, 2.703522, -9.998144],
    [850, -10.972556, -0.380478, 0.687856],
    [851, -2.942554, 6.141524, -8.650144],
    [852, 9.867446, 0.825522, 4.825858],
    [853, 9.073446, 2.225522, -5.836144],
    [854, -5.046554, -9.194478, -3.368144],
    [855, 4.129446, 9.153522, 4.529856],
    [856, -5.340554, 9.217524, -2.856144],
    [857, 7.679448, 5.595522, 5.619856],
    [858, 8.505448, -5.422478, -4.488144],
    [859, 6.637448, 2.197524, -8.562144],
    [860, -0.034554, 8.361522, 7.243856],
    [861, -3.856554, -10.020478, 2.679858],
    [862, 0.273448, -7.284478, 8.341856],
    [863, -10.406556, 3.639522, 1.121856],
    [864, -1.688554, 10.055522, -4.340144],
    [865, 5.231448, -3.310478, -9.192144],
    [866, 8.495448, 3.821522, 6.007856],
    [867, 2.451446, 6.307522, 8.779858],
    [868, -7.264554, 8.295522, -1.158144],
    [869, 0.349446, 11.055522, -0.792142],
    [870, 2.645446, 8.787524, 6.229856],
    [871, 1.193448, 7.273524, -8.294144],
    [872, -8.548554, -0.098478, 7.075858],
    [873, 6.421446, -0.452478, 9.039856],
    [874, 2.677446, -10.406478, -2.796144],
    [875, -3.706554, -5.160478, -9.116144],
    [876, -9.182554, 2.691522, 5.663856],
    [877, 5.777446, -7.922478, -5.252144],
    [878, 8.641448, 6.997522, 0.351856],
    [879, -0.842554, 10.739522, 2.777856],
    [880, 2.461446, -0.288478, 10.845858],
    [881, -1.362554, -10.918478, -1.646142],
    [882, -2.306554, -8.496480, 6.811858],
    [883, 5.637448, 6.621522, -6.950144],
    [884, 0.185446, -7.512478, -8.220144],
    [885, -2.210554, -0.756478, -10.894144],
    [886, -7.262554, 3.903522, -7.506144],
    [887, -3.752554, 8.961524, 5.497856],
    [888, 8.295446, 7.105522, 2.315856],
    [889, -5.524554, -4.512478, -8.592144],
    [890, -0.538554, -10.700478, 3.159856],
    [891, -3.164554, 5.027524, 9.469856],
    [892, -5.036554, -8.266478, 5.603858],
    [893, -3.094552, -6.936478, -8.212144],
    [894, -2.356554, 10.649522, -2.492144],
    [895, -6.460554, 9.053522, 1.239856],
    [896, 1.981448, -2.458478, 10.741858],
    [897, -3.766554, -7.320478, 7.589858],
    [898, 4.343446, -9.830478, 3.149856],
    [899, -0.394554, -9.930480, -5.164144],
    [900, -9.900554, -4.890478, -1.902144],
    [901, 11.091446, 0.379522, -1.560144],
    [902, 9.235446, -2.686478, 5.767856],
    [903, 10.027446, 0.687522, -4.976144],
    [904, -4.972554, 0.325522, -10.048144],
    [905, -2.410552, 9.029522, -6.202144],
    [906, -8.408554, 7.091522, -2.266144],
    [907, -8.905754, -3.686078, -5.767744],
    [908, 5.439448, -9.700478, -1.658144],
    [909, -6.786554, -8.226478, -3.576144],
    [910, 4.609446, -1.224478, -10.190144],
    [911, -2.022554, 1.229522, -11.006144],
    [912, 0.833446, 9.561524, 5.901858],
    [913, 2.847446, -6.376478, -8.842144],
    [914, 9.225446, -0.054478, 6.499856],
    [915, 8.987446, -1.244478, -6.726144],
    [916, -4.594554, 1.823522, 10.155858],
    [917, -2.644554, -0.952478, 10.941856],
    [918, -3.098554, -8.592478, -6.668144],
    [919, 7.867446, -7.134478, 3.901858],
    [920, -1.644554, 11.177522, -0.704144],
    [921, -6.416554, -0.834478, -9.296144],
    [922, 0.195446, -5.696478, 9.793858],
    [923, 8.717448, 6.059522, 3.963856],
    [924, -8.402554, -7.586478, -0.586144],
    [925, 3.359446, 10.645524, -1.984144],
    [926, -6.378554, 6.899522, 6.345856],
    [927, 0.837446, 0.999524, -11.264144],
    [928, 7.965446, -5.914478, 5.499856],
    [929, 0.819446, -11.048480, -2.452144],
    [930, -6.824554, 5.209522, 7.425858],
    [931, 8.551446, 5.771522, -4.740144],
    [932, -3.202554, 7.819522, -7.584144],
    [933, 10.457448, 3.581522, -2.596144],
    [934, 2.871446, 10.597522, 2.917856],
    [935, -10.580554, -4.146478, -0.160142],
    [936, -7.776554, 0.409524, -8.278144],
    [937, 4.849448, -1.160478, 10.221858],
    [938, -4.874554, -7.688478, -6.826144],
    [939, -5.936554, 3.583522, -9.024144],
    [940, -7.104554, 3.395524, 8.219856],
    [941, -6.218554, 0.739522, 9.505858],
    [942, -2.878554, 1.119522, 10.957858],
    [943, 1.075446, 11.283524, 1.211856],
    [944, 3.601446, -3.198478, -10.336144],
    [945, 7.189448, 4.001522, -7.896144],
    [946, 8.051446, 0.883522, -8.028144],
    [947, 2.297448, 11.179524, -0.362144],
    [948, -2.370554, -10.078478, -4.824144],
    [949, 4.081446, -4.926478, -9.466144],
    [950, -9.974554, 3.297522, -4.496144],
    [951, 11.259448, 1.813522, 0.769856],
    [952, -6.776554, -4.740478, 7.899856],
    [953, 0.023448, -2.606478, 11.135856],
    [954, -1.960554, 8.845522, 6.995858],
    [955, -0.718554, -0.670476, 11.407856],
    [956, 1.503446, -9.788478, 5.763856],
    [957, -0.738554, 1.329522, 11.357856],
    [958, 0.481448, -11.438478, -0.516144],
    [959, 2.103446, -8.008478, -7.928144],
    [960, 2.975446, 1.633522, 10.949858],
    [961, -2.386554, -11.212478, 0.259858],
    [962, 6.279446, -9.594478, 0.181856],
    [963, -11.356554, -1.130478, -1.148144],
    [964, -4.074554, 9.809522, -4.330142],
    [965, -9.066556, -6.666478, -2.240142],
    [966, -10.992554, -1.758478, 2.781856],
    [967, 4.523448, -8.868478, 5.709856],
    [968, -1.152554, 5.387522, -10.068144],
    [969, 3.183446, 7.023524, -8.510144],
    [970, -11.428554, 0.841522, -0.834144],
    [971, -10.978554, -1.506478, -3.082144],
    [972, -1.270554, 7.627524, -8.518144],
    [973, 5.807448, -5.166478, -8.486146],
    [974, 6.055446, 8.567522, 4.729856],
    [975, 2.807446, 9.413522, -6.020144],
    [976, 2.575448, 4.311522, -10.370144],
    [977, 4.129446, 0.791522, -10.738144],
    [978, -5.596554, 9.637524, 2.965856],
    [979, 10.399446, 2.531522, -4.296144],
    [980, -3.890554, 1.883522, -10.700144],
    [981, 1.037446, -0.982478, -11.452144],
    [982, -4.316554, -3.154478, 10.229856],
    [983, -9.828554, 5.831522, -1.636144],
    [984, -8.036554, 8.053522, 1.975856],
    [985, 11.005448, 1.307522, 3.249856],
    [986, -8.014554, 5.829524, 5.933856],
    [987, -8.276554, -6.974478, -4.046144],
    [988, -8.372554, 4.083522, 6.839858],
    [989, -7.700554, -5.164478, -6.908144],
    [990, -4.386554, 8.713522, -6.232144],
    [991, -9.316556, -2.936478, 6.213856],
    [992, -10.658554, -0.174478, -4.548144],
    [993, 8.711446, -6.942478, -3.202144],
    [994, 1.419446, -10.654478, -4.348144],
    [995, 7.307448, -8.734478, -2.184144],
    [996, -9.552556, 5.505522, -3.592144],
    [997, 5.665448, 10.107522, 0.463856],
    [998, 7.251446, -5.364478, 7.303856],
    [999, -9.914554, -5.148478, 3.157856],
    [1000, -9.766554, -0.816476, -6.226144],
    [1001, 5.775446, 3.833522, -9.320144],
    [1002, -10.264554, 5.445522, 0.283856],
    [1003, -5.560554, -6.498478, 7.889856],
    [1004, 6.533448, -8.780478, 3.961856],
    [1005, 4.515446, -9.462478, -5.064144],
    [1006, -0.840554, -11.054478, -3.576144],
    [1007, 7.335448, 8.007522, -4.222144],
    [1008, 8.375446, 7.883522, -1.868142],
    [1009, -3.074554, 4.839524, -10.164144],
    [1010, 11.401448, -2.252478, 1.097856],
    [1011, 9.841446, 5.841522, 2.319856],
    [1012, -7.594554, -7.226478, 5.175856],
    [1013, 3.211446, -11.054478, 2.051856],
    [1014, 2.435446, -11.386478, -1.076144],
    [1015, -7.090554, -9.026478, 2.233856],
    [1016, 1.335446, -9.846478, -6.168144],
    [1017, 10.025446, -5.876478, -1.328144],
    [1018, 4.833446, 10.225522, 2.989856],
    [1019, 2.537446, -7.658478, 8.471858],
    [1020, 1.099448, -8.906478, 7.509858],
    [1021, 9.981448, 4.521522, 4.111856],
    [1022, 7.195446, 9.187522, -0.918144],
    [1023, 0.653446, 4.771522, -10.678144],
    [1024, -11.066556, -3.476478, 1.649856],
    [1025, -11.368556, 0.463522, -2.796144],
    [1026, -4.240554, -9.544478, -5.324144],
    [1027, 5.313446, 7.165524, 7.609858],
    [1028, -11.288556, 2.347522, -2.144144],
    [1029, -10.830554, -0.364478, 4.489856],
    [1030, -3.142554, 7.783524, 8.193858],
    [1031, -5.464554, 6.521522, 8.077856],
    [1032, -9.982554, 0.911522, 6.099858],
    [1033, 10.783448, 4.519522, 1.013856],
    [1034, 8.781446, 2.419524, 7.411858],
    [1035, 7.391448, -8.154478, -4.096144],
    [1036, 7.765446, -8.476478, 2.417856],
    [1037, -0.998554, 3.683524, -11.110144],
    [1038, -5.126554, 10.527524, 0.991856],
    [1039, -7.864554, 7.451522, 4.557856],
    [1040, 5.651448, 0.961522, 10.265858],
    [1041, -0.516554, 9.293522, -7.186144],
    [1042, -4.600554, -10.626478, -2.052144],
    [1043, 8.043448, -4.572478, -7.262144],
    [1044, 0.621446, 10.967524, -4.204144],
    [1045, -8.888554, 1.831522, 7.495858],
    [1046, 7.019448, -3.874478, 8.619856],
    [1047, 7.271446, 1.367524, 9.157856],
    [1048, -2.432554, -10.880478, 3.787858],
    [1049, -8.872554, 7.745524, -0.074144],
    [1050, 4.677446, -8.338478, -6.880144],
    [1051, 2.971446, -1.476478, -11.302146],
    [1052, -1.962554, -2.804478, 11.289856],
    [1053, 10.249446, -4.050478, 4.211856],
    [1054, 1.027446, 11.309522, 3.209856],
    [1055, -2.100554, 11.523524, 1.437856],
    [1056, 11.789430, -0.570478, 0.065856],
    [1057, 3.049446, 8.073522, 8.053856],
    [1058, 5.071448, -10.566478, 1.429858],
    [1059, -1.316554, -9.454478, -6.956144],
    [1060, 6.187446, 8.193524, -5.840144],
    [1061, 3.047448, -8.972478, 7.059856],
    [1062, -0.328554, -10.636478, 5.155858],
    [1063, 5.291446, 10.483522, -1.470144],
    [1064, 1.241040, 1.024724, 11.725846],
    [1065, -10.744554, 4.225522, -2.620144],
    [1066, 7.723446, 7.489522, 4.953858],
    [1067, -0.484554, 3.311522, 11.363858],
    [1068, -7.584554, 2.399522, -8.782144],
    [1069, 11.211446, 3.065524, 2.315856],
    [1070, -5.300554, -10.510478, 1.393856],
    [1071, 5.587446, 2.077522, -10.248144],
    [1072, 6.025446, 5.561524, 8.569856],
    [1073, 7.827446, 5.905524, -6.688144],
    [1074, -9.762554, -6.530478, 1.719856],
    [1075, 11.311448, 0.951522, -3.476142],
    [1076, -11.264554, -3.190478, -1.980144],
    [1077, 5.997446, -9.546478, -3.730144],
    [1078, -10.078554, -1.084478, 6.191856],
    [1079, 10.027446, 2.549522, 5.835858],
    [1080, 9.803446, 6.579524, -1.362144],
    [1081, -2.208554, -6.246478, -9.874144],
    [1082, -9.812554, 4.479522, 5.019858],
    [1083, 1.923446, 6.323522, -9.900144],
    [1084, 11.415448, 3.369522, -0.496144],
    [1085, 3.953448, 5.623522, -9.732144],
    [1086, -9.338554, 6.203522, 4.039856],
    [1087, 2.533448, 2.039522, -11.466144],
    [1088, -11.600554, 2.731522, -0.190144],
    [1089, -7.116554, 6.541522, -6.986144],
    [1090, 7.005448, -6.284478, -7.330144],
    [1091, -6.058554, -3.850478, 9.539856],
    [1092, 7.529448, 8.651524, 3.335858],
    [1093, -5.432554, -2.160478, -10.416144],
    [1094, -6.458554, 10.031522, -0.584144],
    [1095, 1.459446, 9.119522, -7.578144],
    [1096, 8.903446, -4.498478, 6.577856],
    [1097, 11.537446, -0.970478, -2.956144],
    [1098, 3.735446, -6.360478, 9.409856],
    [1099, 4.987446, -6.980478, -8.328144],
    [1100, 10.103446, -5.490478, -3.286144],
    [1101, 5.913446, 9.461524, -4.316144],
    [1102, -4.678554, -5.304478, 9.649856],
    [1103, 10.473446, -3.830478, -4.348144],
    [1104, 10.103446, 4.509524, -4.582144],
    [1105, 8.731448, 2.737522, -7.732144],
    [1106, 10.571448, -1.164478, -5.516144],
    [1107, -3.314554, 3.067522, 11.097856],
    [1108, 9.739446, 0.661522, -6.960144],
    [1109, -6.104554, -1.946478, 10.135856],
    [1110, -3.154554, -6.582478, 9.519858],
    [1111, -7.716554, -2.048478, 8.959856],
    [1112, -9.106554, -6.920478, 3.683856],
    [1113, 1.257446, 7.901524, 8.967858],
    [1114, -3.716554, -9.700478, 6.073856],
    [1115, -1.048554, -4.940478, -10.928144],
    [1116, -10.808554, 4.151522, 3.319856],
    [1117, -0.900554, -4.494478, 11.145856],
    [1118, 11.403446, -2.932478, -2.582144],
    [1119, -6.524554, 5.445522, -8.552146],
    [1120, -9.084554, -5.688478, -5.522144],
    [1121, -11.898554, 1.347522, 1.463856],
    [1122, -7.668554, -2.368478, -9.008144],
    [1123, -8.406554, -3.584478, 7.881856],
    [1124, -3.004554, -4.354478, -10.852144],
    [1125, 9.659446, -6.350478, 3.483856],
    [1126, -8.788554, -5.790478, 5.917856],
    [1127, -4.324554, 10.945522, -2.704144],
    [1128, 6.493446, -2.248478, 9.929858],
    [1129, -4.886554, 6.543522, -8.908144],
    [1130, 0.811448, 3.035522, -11.670146],
    [1131, 8.219446, -2.158478, -8.598144],
    [1132, -8.966554, -1.210478, -8.024144],
    [1133, -8.068554, -0.078478, 9.015858],
    [1134, -0.692554, -0.184476, -12.080144],
    [1135, 7.573446, -0.464478, -9.432144],
    [1136, -1.996554, 4.579524, 11.029858],
    [1137, -2.734554, -11.402480, -3.030144],
    [1138, 3.203448, -4.260478, 10.875856],
    [1139, 1.153446, 11.801524, -2.468144],
    [1140, -3.978554, 10.589524, 4.329856],
    [1141, -5.584554, 8.725522, 6.277856],
    [1142, 1.398650, -11.227278, 4.335858],
    [1143, -6.636554, 9.031522, 4.603858],
    [1144, 4.459446, 10.659524, -3.652144],
    [1145, 0.031446, 6.991522, -9.900144],
    [1146, -5.798554, -10.130478, 3.283858],
    [1147, 10.775446, -4.968478, 2.511856],
    [1148, 1.114648, -1.187276, 12.021836],
    [1149, -8.508554, 6.629522, -5.554144],
    [1150, 11.387448, -0.428478, 4.173856],
    [1151, 3.495448, 3.557522, 11.071858],
    [1152, 1.295446, 6.137522, 10.399856],
    [1153, -0.354554, 11.211524, 4.665858],
    [1154, -1.582554, -7.976478, -9.026144],
    [1155, -11.218554, 1.733522, -4.330142],
    [1156, 6.247446, 2.847522, 10.023858],
    [1157, -6.542554, -10.090478, -1.746144],
    [1158, 8.861446, -2.910478, 7.793858],
    [1159, -6.668554, -9.010478, 4.711856],
    [1160, -8.234554, -8.658478, -2.264142],
    [1161, -4.784554, 4.205522, 10.361856],
    [1162, 3.211446, 5.433524, 10.397858],
    [1163, 9.831448, -6.988478, 1.597856],
    [1164, 7.257446, -3.868478, -8.968144],
    [1165, 0.877448, -5.470478, -10.836144],
    [1166, 4.987446, 4.527524, 10.139856],
    [1167, 9.575448, -4.586478, -5.962144],
    [1168, -9.644554, 4.985524, -5.522144],
    [1169, -4.428554, -11.354478, -0.196144],
    [1170, 8.133446, -9.072478, -0.376144],
    [1171, -6.548554, -6.188478, -8.226144],
    [1172, 9.247446, -7.828478, -1.490142],
    [1173, -3.134554, -4.754478, 10.797858],
    [1174, 6.749446, -2.198478, -9.942144],
    [1175, -9.220554, 2.471524, -7.634144],
    [1176, 8.115446, -1.512478, 9.023858],
    [1177, 7.223446, 6.679524, 7.277856],
    [1178, -3.450554, -2.442478, -11.486146],
    [1179, -6.348554, 2.997522, 10.025856],
    [1180, -3.952554, 11.347522, 2.385856],
    [1181, 11.493446, -3.114478, 2.931856],
    [1182, 4.441446, 6.615522, 9.323856],
    [1183, -10.942554, -3.716478, 4.107856],
    [1184, -0.494554, 10.773524, -5.854144],
    [1185, 4.301446, -11.350480, -1.818144],
    [1186, -6.582554, -7.828478, 6.787858],
    [1187, -10.972556, 2.769522, 4.763856],
    [1188, -1.056552, -7.270478, 9.843856],
    [1189, 5.279446, -7.192478, 8.451856],
    [1190, 11.089448, -2.312478, 4.767856],
    [1191, 1.605446, -12.130478, 1.159856],
    [1192, 2.109446, -5.932478, 10.557858],
    [1193, 0.339446, -3.734478, -11.712144],
    [1194, -1.626554, -3.224478, -11.760144],
    [1195, 4.263446, 0.228726, 11.537858],
    [1196, -0.902554, 10.449522, 6.433856],
    [1197, 9.407446, -3.114478, -7.296144],
    [1198, 11.923434, 2.253522, -2.082144],
    [1199, 3.881446, -11.684478, 0.273858],
    [1200, 6.793448, 5.897522, -8.412144],
    [1201, 1.720650, 4.429116, 11.363858],
    [1202, 9.575448, 6.957524, -3.412144],
    [1203, -0.364554, 7.177522, 10.015858],
    [1204, -0.346554, -6.916478, -10.200144],
    [1205, -6.390554, 4.887522, 9.345858],
    [1206, 4.799446, 9.607522, -6.062144],
    [1207, -5.826554, 2.373522, -10.608144],
    [1208, -7.056554, 0.897522, -10.076144],
    [1209, 3.593040, -1.723680, 11.673856],
    [1210, 6.669446, 10.151524, 2.203856],
    [1211, -1.822554, -12.000478, 2.253856],
    [1212, 3.427446, 8.893522, -7.848144],
    [1213, 4.943448, -4.956478, 10.177856],
    [1214, -7.880554, 1.911522, 9.323856],
    [1215, 8.223446, 9.101522, 1.505856],
    [1216, -6.316554, 8.327522, -6.596144],
    [1217, 4.851446, -3.090476, 10.945856],
    [1218, -2.354554, 7.053522, 9.893856],
    [1219, 10.557448, 6.443524, 0.555856],
    [1220, -12.182554, -1.888478, 1.161856],
    [1221, 5.153446, 6.973522, -8.856144],
    [1222, -0.996554, -9.414478, 8.009858],
    [1223, 0.707446, -9.430480, -8.022144],
    [1224, 2.931446, 11.965522, 1.467856],
    [1225, 7.393446, -7.768478, 6.239856],
    [1226, -7.940554, -7.076478, -6.390144],
    [1227, 11.247446, 2.987522, 4.313856],
    [1228, -3.734554, -11.724478, 1.637856],
    [1229, 7.283448, 9.639522, -2.868144],
    [1230, 1.507446, -7.518478, -9.774144],
    [1231, -2.916554, 3.391524, -11.590146],
    [1232, 1.659446, 9.519524, 7.809856],
    [1233, -2.428554, 11.633522, 3.641858],
    [1234, -10.656556, -2.568478, -5.862144],
    [1235, 7.919446, 3.269522, 9.007856],
    [1236, 3.025446, -10.712478, -5.542144],
    [1237, -7.042554, -8.638478, -5.524144],
    [1238, 4.283448, -11.046478, -3.792144],
    [1239, 10.977448, -5.840478, 0.431856],
    [1240, -4.908554, -6.996478, -9.048144],
    [1241, -4.310554, -10.790478, 4.467858],
    [1242, 8.685446, -6.362478, -6.256144],
    [1243, -10.592554, -4.338478, -4.914144],
    [1244, 3.373446, -10.498478, 5.801856],
    [1245, 4.219446, 11.739522, -0.338144],
    [1246, -0.640554, 1.827522, -12.334144],
    [1247, -9.446554, -1.734478, 7.985858],
    [1248, -0.466554, 12.461524, 0.743856],
    [1249, 2.437446, 0.203522, -12.252144],
    [1250, -10.906556, -6.096478, 0.135856],
    [1251, -9.080554, -3.710478, -7.760144],
    [1252, 1.585446, 11.301524, 5.131856],
    [1253, -9.834554, 0.577522, -7.720144],
    [1254, 9.311448, 0.731522, 8.333856],
    [1255, 12.225436, -1.066476, 2.481858],
    [1256, 4.451446, 9.699522, 6.553856],
    [1257, -4.308554, 6.649522, 9.713858],
    [1258, 3.531446, 11.055522, 4.747856],
    [1259, -3.342554, 12.019524, -1.344144],
    [1260, -4.444554, -11.034480, -3.998144],
    [1261, 0.985446, -4.240478, 11.771836],
    [1262, -4.614554, -0.822478, -11.644144],
    [1263, -4.744554, 4.031522, -10.908144],
    [1264, -2.742554, -8.578478, 8.765858],
    [1265, -5.814554, 9.793522, -5.316144],
    [1266, 3.365446, -11.440478, 4.009858],
    [1267, -2.860554, 10.653522, 6.077856],
    [1268, 5.503446, -10.308478, 4.733856],
    [1269, 4.619446, 4.203522, -10.960144],
    [1270, -10.304554, -6.088478, -3.986144],
    [1271, 7.013446, -10.316478, 1.899856],
    [1272, 2.383446, -4.394478, -11.586144],
    [1273, 7.597446, -8.036478, -6.078144],
    [1274, -12.010556, 1.579522, 3.537858],
    [1275, 7.967448, 5.147522, 8.329856],
    [1276, -7.042554, 9.797524, -3.732144],
    [1277, -8.252554, 9.553522, 0.509858],
    [1278, 9.945446, -5.676478, 5.343856],
    [1279, 12.125430, -3.476478, -0.792142],
    [1280, -3.802554, 9.497522, 7.425858],
    [1281, -1.180554, -12.578478, -0.552142],
    [1282, 11.439448, 5.335522, -0.858142],
    [1283, -9.038554, 4.821522, -7.430144],
    [1284, 10.973446, 5.671522, -2.770144],
    [1285, -9.424554, 7.471524, -3.956144],
    [1286, 11.903444, -4.188478, 1.061858],
    [1287, 5.385446, 8.541522, -7.642144],
    [1288, 11.057448, -0.766478, 6.127858],
    [1289, 1.707448, 11.087522, -5.882144],
    [1290, 5.859448, -8.636478, 7.183856],
    [1291, -7.740554, -4.712478, -8.856144],
    [1292, -4.768554, -1.760476, 11.615856],
    [1293, 6.211446, 8.765522, 6.737856],
    [1294, 4.895446, 11.599524, 1.539856],
    [1295, -3.054554, 11.607522, -4.106144],
    [1296, -7.984554, 8.483522, -5.024144],
    [1297, 12.627444, 1.139522, -0.536144],
    [1298, -0.092148, 5.255928, 11.551856],
    [1299, 9.369446, -0.526478, -8.556144],
    [1300, -5.024554, -8.882478, 7.567856],
    [1301, 7.463446, 1.389522, -10.192144],
    [1302, -9.266554, -8.378480, 2.333856],
    [1303, -2.304554, 7.247522, -10.184144],
    [1304, -5.196554, 11.579524, -0.732144],
    [1305, 0.909446, -7.510478, 10.225856],
    [1306, -8.384554, -9.566478, -0.314144],
    [1307, -5.032554, 8.413522, -8.130144],
    [1308, -1.654554, 8.895524, 8.963858],
    [1309, -1.992554, 0.342320, 12.575852],
    [1310, -5.614554, 0.653522, 11.415858],
    [1311, -6.840554, -10.750478, 0.135856],
    [1312, 6.513446, -5.820478, 9.279858],
    [1313, -2.480554, 11.009524, -5.924144],
    [1314, -3.026554, -12.318478, -1.268144],
    [1315, 9.823446, -1.178478, 8.045856],
    [1316, 2.797448, 11.915524, -3.608144],
    [1317, -4.964554, -4.008478, -11.056144],
    [1318, 3.345446, -9.600480, -7.740144],
    [1319, 5.393446, -2.966478, -11.200144],
    [1320, -12.358554, -3.240478, -0.316144],
    [1321, -1.100554, 11.963522, -4.366144],
    [1322, -11.562554, 5.155524, 1.775856],
    [1323, 11.613448, -4.908478, -2.120144],
    [1324, 4.882244, 2.231116, 11.603858],
    [1325, 0.207448, 8.925522, -9.156144],
    [1326, 5.751446, -11.414478, -0.452144],
    [1327, 9.989446, 4.053522, -6.888144],
    [1328, -7.534554, 10.001522, 2.643856],
    [1329, 12.613436, -1.646478, -1.416144],
    [1330, -6.756554, -3.656476, -10.238144],
    [1331, 0.247446, -10.670478, 7.069856],
    [1332, -12.242554, 3.279522, 1.823856],
    [1333, -0.180554, -2.046478, -12.640144],
    [1334, -3.916554, -0.062478, 12.193832],
    [1335, -1.824554, -10.902480, 6.469856],
    [1336, -11.658554, 5.183524, -1.128144],
    [1337, -6.158554, -10.226478, -4.660144],
    [1338, 12.731448, 0.567522, 1.409856],
    [1339, 11.797426, -2.340476, -4.460144],
    [1340, -12.600554, -0.360478, 2.389856],
    [1341, 0.577446, -12.464478, 2.997856],
    [1342, -11.010554, 1.579522, -6.400144],
    [1343, -11.472556, -5.418478, 1.931856],
    [1344, 3.645446, -8.182478, -9.192144],
    [1345, -3.836554, 12.237522, 0.587856],
    [1346, -0.288554, -12.780478, 1.231858],
    [1347, -0.402554, 12.735524, -1.618142],
    [1348, 9.913446, 8.033524, 1.589858],
    [1349, -1.930148, 2.472318, 12.479844],
    [1350, -10.546554, 7.321522, 0.939856],
    [1351, 2.003852, 2.745116, 12.417832],
    [1352, 6.455446, -0.230478, -11.138144],
    [1353, 1.169446, 12.831522, -0.356144],
    [1354, 7.829446, 3.357522, -9.676144],
    [1355, -3.640554, 0.775522, -12.346144],
    [1356, 6.675448, -0.582478, 11.019858],
    [1357, 10.767446, 1.109522, 7.013856],
    [1358, -10.030554, -8.094478, 0.497856],
    [1359, 4.457448, 2.413522, -11.864144],
    [1360, -10.542554, 3.521522, -6.552144],
    [1361, 3.653446, 11.123524, -5.422144],
    [1362, 1.787446, -2.568478, -12.520144],
    [1363, -11.564554, -4.880478, -3.006144],
    [1364, -7.920554, 10.007522, -1.952144],
    [1365, 6.093446, -4.654478, -10.390144],
    [1366, 11.587446, 4.979522, 2.777856],
    [1367, 9.115446, 5.997522, 6.925858],
    [1368, 9.651448, 8.589524, -0.318144],
    [1369, -11.282554, -2.618478, 5.749856],
    [1370, 7.257446, 7.679524, -7.458144],
    [1371, 2.753446, 10.739522, 6.663856],
    [1372, 2.173446, 8.639522, -9.388144],
    [1373, -3.512554, 9.801524, -7.698144],
    [1374, -8.340554, -0.620478, -9.888144],
    [1375, 11.761446, 1.273522, 5.287858],
    [1376, -11.018554, -6.580478, -1.790144],
    [1377, -8.580554, -8.800478, 4.159856],
    [1378, 6.483446, -8.172478, -7.730144],
    [1379, -7.222554, -0.426478, 10.785856],
    [1380, 9.125446, 7.607522, -5.248144],
    [1381, -2.112554, -1.540478, -12.730144],
    [1382, -0.444554, 12.701522, 2.717858],
    [1383, -2.680554, -9.530478, -8.420144],
    [1384, 6.183446, 10.541522, 4.431856],
    [1385, 10.023448, 7.501522, 3.507856],
    [1386, 9.681446, 4.205522, 7.591856],
    [1387, 2.831446, 12.587522, -1.716144],
    [1388, 9.175448, -7.520478, 5.357856],
    [1389, -9.472554, 8.773524, -1.680144],
    [1390, -5.726554, -9.584478, -6.702144],
    [1391, -10.480554, -6.010478, 4.871856],
    [1392, 2.947446, 7.793522, 10.025856],
    [1393, -0.208554, 10.083522, 8.259858],
    [1394, -10.418554, 0.001522, 7.835858],
    [1395, -7.728554, 4.249524, -9.610144],
    [1396, 7.387448, -10.670478, -1.328144],
    [1397, -4.566554, -8.870478, -8.410144],
    [1398, 0.157446, -12.894478, -2.002144],
    [1399, -10.612554, -4.468478, 6.143856],
    [1400, -0.030554, 0.233928, 13.049850],
    [1401, 5.909446, 5.623522, -10.190144],
    [1402, 0.609446, -12.442478, -3.900144],
    [1403, 6.307448, -9.552478, -6.288144],
    [1404, 9.925448, -8.488478, 0.271856],
    [1405, -1.896554, -6.222478, 11.329856],
    [1406, -8.886554, 8.877524, 3.591856],
    [1407, -6.580554, -8.148478, -7.810144],
    [1408, 9.205446, -7.878480, -4.900144],
    [1409, -5.966554, -5.706478, -10.132144],
    [1410, -0.636554, -11.902480, -5.370144],
    [1411, -10.280554, 7.543522, 2.903856],
    [1412, 8.507446, -9.000478, 4.201856],
    [1413, 10.797448, 4.385522, 5.935856],
    [1414, -0.064554, -11.010478, -7.068144],
    [1415, 7.591446, 10.649522, 0.395856],
    [1416, -1.096960, -1.966884, 12.889846],
    [1417, -1.732554, 9.559522, -8.768144],
    [1418, 11.107446, -2.934478, -6.268144],
    [1419, -4.136554, -6.202478, -10.756144],
    [1420, 3.217448, -6.716478, -10.764144],
    [1421, -4.576554, -7.998478, 9.303856],
    [1422, -12.982554, -0.060478, -1.728144],
    [1423, -4.972554, 8.309522, 8.821858],
    [1424, 0.142242, 2.221930, 12.913834],
    [1425, -8.508554, -9.032478, -4.216144],
    [1426, 6.095446, -11.280478, -2.712142],
    [1427, -11.316556, 4.931522, -4.410144],
    [1428, -5.728554, -10.074478, 6.131856],
    [1429, -7.454554, -6.476478, 8.625856],
    [1430, 9.939448, 5.921522, -6.170144],
    [1431, -10.042554, -8.300478, -1.486144],
    [1432, 10.811448, -2.552478, 6.977858],
    [1433, 10.337446, -6.240478, -5.128144],
    [1434, -12.236556, -2.928478, -3.716144],
    [1435, -10.756554, 3.665522, 6.571858],
    [1436, 11.923434, 1.613522, -5.254144],
    [1437, -3.356554, -7.884478, -9.948144],
    [1438, -11.874554, 1.137522, 5.491858],
    [1439, 12.241426, -0.388478, -4.740144],
    [1440, -2.046554, 12.683524, -2.744144],
    [1441, 2.731854, -0.354070, 12.845840],
    [1442, 7.007446, 4.697524, 10.071858],
    [1443, -1.118554, -12.446478, 4.067856],
    [1444, 2.565854, -3.258478, 12.475846],
    [1445, -8.462554, 5.303522, 8.563856],
    [1446, -9.544554, 3.505522, 8.351856],
    [1447, 4.329446, -4.854478, -11.438144],
    [1448, -13.152554, 0.371522, 0.233856],
    [1449, -6.742554, -0.918478, -11.264144],
    [1450, -12.104556, -5.056478, -1.088144],
    [1451, 9.161448, -8.900478, -3.182144],
    [1452, 7.259448, -7.322478, 8.183856],
    [1453, 8.745448, -4.888478, 8.541856],
    [1454, 8.835448, -6.662478, 7.135856],
    [1455, -7.832554, 8.555522, 6.231858],
    [1456, -7.052554, 11.073522, 1.021856],
    [1457, -12.214554, 3.319522, -3.634144],
    [1458, 5.713446, -11.446478, 3.129856],
    [1459, -4.860554, 10.595522, 6.131856],
    [1460, -6.706554, 8.189522, 7.839858],
    [1461, 4.901448, -1.242478, -12.166144],
    [1462, 5.137448, -6.416478, -10.302146],
    [1463, -5.820554, 0.765522, -11.802146],
    [1464, -3.938554, -10.384478, -7.116144],
    [1465, -9.046554, -5.482478, 7.881856],
    [1466, -9.680554, 5.581522, 7.011856],
    [1467, 2.099448, -12.786478, -2.482144],
    [1468, 6.721446, -4.134478, 10.573856],
    [1469, 13.019442, 0.149522, -2.218144],
    [1470, -5.948554, 10.909524, 4.481858],
    [1471, -8.310554, 7.043522, 7.481858],
    [1472, 9.063446, 8.883522, -3.708144],
    [1473, -6.440554, 11.323522, -2.276144],
    [1474, -3.424554, 8.691522, -9.364144],
    [1475, 12.323428, 4.235524, -2.276144],
    [1476, -3.084554, -1.790478, 12.739852],
    [1477, -10.868556, 7.459522, -1.122142],
    [1478, 1.563446, -13.124480, -0.578144],
    [1479, -5.880554, 5.609522, -10.442144],
    [1480, -8.976554, 1.255522, -9.640144],
    [1481, -12.432554, -1.834478, 4.163856],
    [1482, 10.837446, -1.370478, -7.482144],
    [1483, 8.967448, 4.609522, -8.592144],
    [1484, -3.940554, -3.526478, 12.147842],
    [1485, -9.450554, 7.211524, 5.853858],
    [1486, 1.661446, -9.184478, 9.413856],
    [1487, -5.930554, 11.571524, 2.593856],
    [1488, 4.679448, 12.181522, -2.368144],
    [1489, 8.863448, -9.770478, 1.369856],
    [1490, 3.747446, -3.130478, -12.332144],
    [1491, 0.845446, 11.239522, 6.991858],
    [1492, -6.668554, 7.433524, -8.730144],
    [1493, 11.469446, 3.519522, -5.660144],
    [1494, 4.767446, 8.553522, 8.951856],
    [1495, 2.615446, -12.258478, -4.350144],
    [1496, -1.978554, 13.123510, -0.386144],
    [1497, 10.643446, -7.382478, -2.920144],
    [1498, 0.081446, -6.294478, 11.695856],
    [1499, -11.206554, 6.505522, -2.920144],
    [1500, 0.589448, 10.929524, -7.528144],
    [1501, -5.510554, 2.615522, 11.801834],
    [1502, -2.582554, -12.066478, -4.922144],
    [1503, -12.174554, -1.502478, -5.118144],
    [1504, -0.556552, 5.311524, -12.172144],
    [1505, 9.731448, 7.219522, 5.465856],
    [1506, -3.732554, 5.429524, 11.545856],
    [1507, -2.014554, -11.314478, -6.692144],
    [1508, 3.811448, 12.327522, 3.227856],
    [1509, -4.122554, 6.565524, -10.810144],
    [1510, -8.062554, -4.758478, 9.453858],
    [1511, -10.046554, -8.006478, -3.470144],
    [1512, 7.209446, -9.668478, 5.625856],
    [1513, 2.815446, 5.845522, -11.622144],
    [1514, -13.134554, 1.849522, -1.126144],
    [1515, 7.193448, 11.103524, -1.506144],
    [1516, 1.363448, -11.846478, -5.950144],
    [1517, -2.392554, 5.929524, -11.694144],
    [1518, -3.837758, 1.889116, 12.631852],
    [1519, -5.830554, -3.458478, 11.485858],
    [1520, -4.460554, 11.203524, -5.702144],
    [1521, 0.997446, 1.141522, -13.256144],
    [1522, 2.540244, -12.799678, 2.796654],
    [1523, 3.489446, 7.397522, -10.546144],
    [1524, -0.008554, -9.018478, -9.840144],
    [1525, 7.777446, -10.346478, -3.262144],
    [1526, 9.815446, -8.636478, 2.727856],
    [1527, 12.399446, 3.057522, -3.952144],
    [1528, 0.931446, 6.533522, -11.626144],
    [1529, 3.223446, 3.901522, -12.374144],
    [1530, 4.223446, -8.690478, 9.239856],
    [1531, -5.668554, 11.385522, -4.120144],
    [1532, -8.166554, 3.819522, 9.873858],
    [1533, -8.574554, -7.310478, 7.201856],
    [1534, 2.881446, -7.832478, 10.451856],
    [1535, -11.314554, 6.057522, 3.769858],
    [1536, 7.131446, -6.410478, -9.332144],
    [1537, 11.189448, -4.244478, 5.989856],
    [1538, 8.923446, 9.827522, -1.720144],
    [1539, 8.591446, -0.034478, 10.269858],
    [1540, -7.160554, 6.713522, 9.121856],
    [1541, -10.908554, 1.943522, 7.537858],
    [1542, 4.677446, -10.638478, -6.674144],
    [1543, 1.841446, -11.698478, 6.275856],
    [1544, -9.500556, -5.808478, -7.472144],
    [1545, 6.519448, 3.585522, -11.158144],
    [1546, -9.558554, -7.716478, -5.386144],
    [1547, -2.620554, -13.140478, 0.715856],
    [1548, -9.548554, -7.666478, 5.491858],
    [1549, -6.176554, -11.504478, -3.102144],
    [1550, -8.486556, -10.284480, 1.541856],
    [1551, -0.286554, -9.104478, 9.863858],
    [1552, -2.194554, 10.569522, 7.985858],
    [1553, 3.492650, 1.496318, 12.879838],
    [1554, -7.614554, -3.176478, 10.603858],
    [1555, 6.293448, 11.413522, -3.270144],
    [1556, 12.869448, 3.785522, 0.807856],
    [1557, 10.285446, 8.373522, -2.214144],
    [1558, -9.726554, 9.111522, 1.791856],
    [1559, -13.362554, -1.506478, -0.406144],
    [1560, 0.707446, -2.791678, 13.141830],
    [1561, 4.339448, 0.617524, -12.722146],
    [1562, 7.407446, 1.321522, 11.155858],
    [1563, 1.409446, 4.731522, -12.520144],
    [1564, -8.988554, 9.379522, -3.526144],
    [1565, 11.147448, -7.490478, -0.970144],
    [1566, -6.002554, -6.764478, 9.979856],
    [1567, -13.016554, 1.547522, -3.098144],
    [1568, -1.652554, 6.509524, 11.675858],
    [1569, 2.353446, -10.620478, 7.943858],
    [1570, 11.691446, 0.253522, -6.696144],
    [1571, 13.083436, 2.359522, 2.207858],
    [1572, -1.692554, -13.086480, -2.744144],
    [1573, -3.394554, -12.592478, 3.403856],
    [1574, 5.835448, -11.046478, -5.064144],
    [1575, 11.185448, 6.129522, 4.367856],
    [1576, 3.523448, 9.987522, 8.343856],
    [1577, 3.265446, 10.819522, -7.354144],
    [1578, -12.340556, 0.467522, -5.414144],
    [1579, 13.281436, -2.318478, 0.353858],
    [1580, -11.056554, -7.022478, 3.241856],
    [1581, 12.939424, 1.035522, 3.687856],
    [1582, -12.852554, 3.725522, -1.780144],
    [1583, 7.393446, -10.622478, 3.843856],
    [1584, -7.304554, 1.707522, 11.225856],
    [1585, 7.791446, 9.919524, -4.840144],
    [1586, 8.401448, 8.195522, 6.693858],
    [1587, -8.112554, -8.918478, 6.099858],
    [1588, -4.632554, 2.539522, -12.436144],
    [1589, -2.470554, -6.012478, -11.848144],
    [1590, 9.247446, -4.370478, -8.852144],
    [1591, 4.451446, -12.616478, 1.997856],
    [1592, 11.255448, 2.187522, -7.180144],
    [1593, -2.436554, 2.183524, -13.128146],
    [1594, -13.006554, -0.352478, -3.710144],
    [1595, -10.406556, -3.486478, 7.913856],
    [1596, 9.093446, 8.907522, 4.587856],
    [1597, -6.940554, -11.426478, 2.089858],
    [1598, 1.261446, -0.886478, -13.448144],
    [1599, 11.613448, -5.504478, 4.249856],
    [1600, 0.067446, 9.133522, 9.993856],
    [1601, -10.788556, -4.392478, -6.904144],
    [1602, 1.961446, 13.065496, 2.987856],
    [1603, -12.186554, -0.848478, 5.879856],
    [1604, 9.029448, 1.893522, 9.941856],
    [1605, -2.712554, -12.208478, 5.251856],
    [1606, 1.885446, -11.012478, -7.698144],
    [1607, -1.396554, 11.153522, -7.600144],
    [1608, 8.805446, -6.222478, -8.246144],
    [1609, -10.756554, -2.616478, -7.858144],
    [1610, 3.529446, -13.066478, -1.116144],
    [1611, -11.614554, -0.994478, -6.974144],
    [1612, 7.619446, 9.725522, 5.667856],
    [1613, 2.179448, -9.614480, -9.366144],
    [1614, 12.371432, -4.168478, -3.820144],
    [1615, -6.118554, -12.096478, -1.156144],
    [1616, -8.258554, 8.189522, -7.060144],
    [1617, -12.962554, 4.157522, 0.177856],
    [1618, -7.964554, 2.597522, -10.740144],
    [1619, -9.872554, 1.747522, 9.229856],
    [1620, 3.887448, -6.368478, 11.403856],
    [1621, -5.420554, 10.195522, -7.240144],
    [1622, 5.372244, -1.142478, 12.483840],
    [1623, 9.311448, 2.007522, -9.762144],
    [1624, -4.644554, -12.594478, -2.418144],
    [1625, 11.525446, 6.923522, 2.321856],
    [1626, -12.642556, 3.479522, 3.773858],
    [1627, 6.165448, 12.173522, -0.140144],
    [1628, -12.752554, -3.604478, 3.263856],
    [1629, -1.278146, 4.337116, 12.879838],
    [1630, 11.461446, -6.870478, 2.787858],
    [1631, 8.121446, -9.708478, -5.132144],
    [1632, -4.884554, -5.220478, 11.637858],
    [1633, -5.702554, 5.885522, 10.929858],
    [1634, 8.981448, -3.302478, 9.749856],
    [1635, 1.311448, 12.789522, -4.620144],
    [1636, 6.709446, 8.231524, 8.597856],
    [1637, -12.942554, -4.166478, 1.357856],
    [1638, -7.816556, -10.586478, 3.679858],
    [1639, 4.313446, -10.228478, 7.967858],
    [1640, -2.440554, 13.229498, 2.417856],
    [1641, -5.278554, -12.298480, 2.777856],
    [1642, 12.377444, 5.725522, 0.939856],
    [1643, -6.530554, -8.236478, 8.739856],
    [1644, -8.676554, 6.627524, -8.232144],
    [1645, -3.384554, 8.761522, 9.949858],
    [1646, -3.866554, -10.482480, 7.901858],
    [1647, -2.132554, -3.924478, 12.935836],
    [1648, -0.944554, -10.460478, -8.780144],
    [1649, 6.701446, 10.013524, -6.516144],
    [1650, -11.804554, 4.689522, 5.129856],
    [1651, -2.680554, -8.116478, 10.707858],
    [1652, 0.705852, 4.131930, 13.057846],
    [1653, -9.130554, -1.312478, 10.163856],
    [1654, 6.393446, 1.649522, -12.038146],
    [1655, 10.351446, 2.625522, 8.629856],
    [1656, 6.019042, 3.873928, 11.723832],
    [1657, 12.025424, 5.021522, -4.352144],
    [1658, 8.667446, 6.599524, -8.374144],
    [1659, 12.963442, -1.822478, 4.177856],
    [1660, -13.054554, 0.053522, 4.289856],
    [1661, -9.426554, 3.191522, -9.480144],
    [1662, -0.236554, 3.649522, -13.250144],
    [1663, 5.171446, -9.440478, -8.554144],
    [1664, -9.660554, -2.342478, -9.502144],
    [1665, -13.398554, -1.866478, -2.470144],
    [1666, 3.255446, -1.438478, -13.284144],
    [1667, 0.097446, -12.518478, 5.697856],
    [1668, -0.542554, -6.468478, -12.132144],
    [1669, 3.049446, 13.417516, 0.087856],
    [1670, -0.920554, 7.291522, -11.636144],
    [1671, -6.698554, 4.015522, -11.336144],
    [1672, -10.094554, 6.411522, -6.838144],
    [1673, 13.385438, 3.109522, -1.004142],
    [1674, 11.589448, -4.796478, -5.706144],
    [1675, -12.088554, -5.406478, 3.837856],
    [1676, -8.282554, -7.186478, -8.358144],
    [1677, -9.344554, -3.232478, 9.609858],
    [1678, 6.389446, -12.142478, 1.379856],
    [1679, 5.877448, 11.331522, -5.222144],
    [1680, 3.073446, -13.426478, 0.795856],
    [1681, -11.440554, -1.710478, 7.521856],
    [1682, 2.497446, -5.388478, 12.457840],
    [1683, 4.244244, 5.142724, 12.083848],
    [1684, 10.673446, 1.013524, -8.692144],
    [1685, 4.415448, 8.889522, -9.592144],
    [1686, -0.940554, -4.654478, -12.962144],
    [1687, 0.549446, 13.067510, 4.417856],
    [1688, 5.971040, 0.765928, 12.427842],
    [1689, 12.489442, -3.732478, 4.559856],
    [1690, 8.095448, 10.503522, 3.853858],
    [1691, -6.836554, 10.285522, 6.179858],
    [1692, -1.796554, -7.790478, -11.262144],
    [1693, -12.310554, 2.855522, -5.574144],
    [1694, -4.340554, -7.050478, 11.055856],
    [1695, 13.801424, -0.466478, -0.318144],
    [1696, 10.147448, -2.464478, -9.046144],
    [1697, 12.707430, -5.398478, -0.534144],
    [1698, -6.744554, -5.150478, 10.903856],
    [1699, 11.681446, 7.263524, -1.310144],
    [1700, 1.662242, 1.119116, 13.675858],
    [1701, 8.177446, -1.938478, 10.973856],
    [1702, 5.809446, -10.608478, 6.695856],
    [1703, 2.075448, 9.567522, 9.761856],
    [1704, 6.549446, -2.641682, 11.895828],
    [1705, -8.088554, -10.752478, -3.256144],
    [1706, -13.630554, 2.313522, 0.751856],
    [1707, 4.011446, -12.894478, -3.058144],
    [1708, 5.253446, -7.446478, 10.427856],
    [1709, 8.257446, -1.450478, -11.024146],
    [1710, 11.873446, 2.813522, 6.551856],
    [1711, 5.799446, 12.139522, 3.291856],
    [1712, -1.408554, 12.917516, 4.797858],
    [1713, 7.465446, 6.595522, 9.625856],
    [1714, 12.733430, -4.676478, 2.809856],
    [1715, -5.866554, -12.526478, 0.791856],
    [1716, 7.973446, -11.328478, 0.465856],
    [1717, 0.963446, 13.765508, 1.407856],
    [1718, 13.387422, -2.696478, 2.431856],
    [1719, 1.561448, -7.096478, -11.820144],
    [1720, 9.301446, -10.168478, -1.646142],
    [1721, -8.246554, -2.338478, -10.918144],
    [1722, 3.173446, 2.107522, -13.358144],
    [1723, -5.706554, 9.911522, 7.883856],
    [1724, -4.408554, -11.564478, 6.311858],
    [1725, 9.655448, 9.589524, 2.809856],
    [1726, -3.370960, 3.935522, 12.895828],
    [1727, -5.782554, 12.615522, 0.877858],
    [1728, 0.989446, -5.286478, -12.826146],
    [1729, -4.784554, 12.449522, 3.975856],
    [1730, 2.401042, 6.713522, 11.953842],
    [1731, -3.286554, 12.445522, 5.301856],
    [1732, -11.086554, 6.857522, -4.888144],
    [1733, -8.926554, 0.623522, 10.673856],
    [1734, -10.778554, -0.838478, -8.782144],
    [1735, 10.397448, -5.464478, 7.493856],
    [1736, 10.775446, -4.548478, -7.572144],
    [1737, 4.263446, 6.979522, 11.281856],
    [1738, 11.901430, -6.114478, -3.906144],
    [1739, 10.431446, 3.247522, -8.664144],
    [1740, -0.214554, 13.509496, -3.450144],
    [1741, -10.576554, 9.095522, -0.016144],
    [1742, -11.756554, -7.380478, 1.403856],
    [1743, 7.905448, 5.579524, -10.052146],
    [1744, 11.615446, -7.676478, 0.963856],
    [1745, -5.190554, 8.117524, -10.098144],
    [1746, -13.222556, -3.864478, -2.248144],
    [1747, 13.371432, -3.232478, -2.368144],
    [1748, 4.659446, -11.986478, 5.441856],
    [1749, -7.520554, 9.907522, -6.348144],
    [1750, -13.682554, 1.323522, 2.477856],
    [1751, -5.074554, 12.777524, -2.474144],
    [1752, 6.111446, 10.803522, 6.413856],
    [1753, 7.987446, 3.223522, 11.003856],
    [1754, 4.891040, -4.820878, 12.171830],
    [1755, -12.514554, 6.219522, 0.363858],
    [1756, -7.734554, 11.621522, -0.778142],
    [1757, 0.561448, 8.517522, -11.076144],
    [1758, -6.244554, -11.704480, 4.431856],
    [1759, 1.265446, 13.767522, -2.124144],
    [1760, 4.501852, -2.992878, 12.907852],
    [1761, -2.406554, 0.137522, -13.786144],
    [1762, -1.330554, 9.001522, -10.634144],
    [1763, 6.077446, -8.070478, -9.690144],
    [1764, -9.824554, 8.113524, -5.800144],
    [1765, -7.988554, -11.416480, -1.364144],
    [1766, -3.910552, 4.815524, -12.552146],
    [1767, -10.862554, -6.386478, -6.108144],
    [1768, 8.493446, 9.045522, -6.498144],
    [1769, 2.255446, -12.982480, 4.767856],
    [1770, -3.020554, -3.770478, -13.156146],
    [1771, -12.336554, -3.628478, -5.578144],
    [1772, 13.507418, -1.520478, -3.426144],
    [1773, 9.347446, 0.129522, -10.448144],
    [1774, 3.755042, 3.474320, 13.053848],
    [1775, -6.640554, -2.780478, -12.032144],
    [1776, 4.555446, 12.541522, -4.330142],
    [1777, 5.927446, 5.867524, 11.279858],
    [1778, 6.977448, 12.055522, 1.681856],
    [1779, -0.314960, -4.706478, 13.215836],
    [1780, -9.476554, -10.180480, -1.876144],
    [1781, -4.824554, -2.960478, -12.854146],
    [1782, -10.440554, -6.466478, 6.821858],
    [1783, -7.714554, 6.245524, -9.946144],
    [1784, 10.507446, -3.764478, 8.547858],
    [1785, -0.430554, -0.010478, -14.052146],
    [1786, -6.904554, -1.886478, 12.103836],
    [1787, -13.696554, -2.036478, 2.463856],
    [1788, -4.424554, -13.352478, -0.296144],
    [1789, -7.942554, 10.729522, 4.455856],
    [1790, 7.299446, -3.518478, -11.508144],
    [1791, 12.933444, -0.362478, 5.547858],
    [1792, -2.036554, -11.074478, 8.451856],
    [1793, -2.170554, 4.159524, -13.276144],
    [1794, -3.606554, 7.423522, 11.409856],
    [1795, 8.061448, -5.002478, -10.420146],
    [1796, 11.059446, -7.374478, 4.685856],
    [1797, 4.797448, 6.063522, -11.786144],
    [1798, 1.169040, -1.041276, 14.011856],
    [1799, -3.938554, -1.236476, -13.484144],
    [1800, 6.981448, 7.825524, -9.434144],
    [1801, 5.889446, 7.623522, 10.317858],
    [1802, -1.898554, -9.516478, -10.260144],
    [1803, -8.404554, -9.002478, -6.942144],
    [1804, 6.273448, -8.784478, 9.131856],
    [1805, -10.898554, 8.477522, -3.052144],
    [1806, 14.021426, -0.950478, 1.601856],
    [1807, 5.183446, 12.093524, 5.191856],
    [1808, 9.881446, -1.534478, 10.007856],
    [1809, -1.334554, 12.629522, -6.240144],
    [1810, 0.030242, 7.629928, 11.921830],
    [1811, -6.972554, -7.404478, -9.852144],
    [1812, 12.583436, -2.292478, 6.083856],
    [1813, 9.579446, 10.425522, 0.451856],
    [1814, -4.426554, 13.277502, 2.189856],
    [1815, -4.204554, -12.080478, -6.092144],
    [1816, 5.517446, -12.936478, -1.740142],
    [1817, 8.987446, -3.234478, -10.470144],
    [1818, -0.126554, -10.930480, 9.031856],
    [1819, 1.771446, -7.310478, 12.025834],
    [1820, 12.745424, -6.074478, 1.379856],
    [1821, 5.174650, -13.209278, 0.216262],
    [1822, 4.403446, -12.436478, -5.238144],
    [1823, -7.134554, 3.875522, 11.643856],
    [1824, -9.436554, 10.581522, -0.740142],
    [1825, 13.745424, 2.065524, -2.894144],
    [1826, 0.541446, -3.552478, -13.736146],
    [1827, -12.868556, -5.986478, 0.511856],
    [1828, -11.054554, 2.473522, -8.568144],
    [1829, -0.292554, 14.199500, -0.250142],
    [1830, -11.752554, -7.968478, -0.512144],
    [1831, -12.586554, -4.046478, 5.209856],
    [1832, 6.293448, -5.964478, 11.263856],
    [1833, -11.616554, 5.197524, -6.368144],
    [1834, -1.740554, 8.667522, 11.153856],
    [1835, -1.264146, 1.443116, 14.103836],
    [1836, -3.218554, -5.592478, 12.687850],
    [1837, 10.489446, -6.480478, -7.118144],
    [1838, 6.815446, -1.780478, -12.374144],
    [1839, 2.611446, -8.600478, -11.044144],
    [1840, -12.144554, -5.754478, -4.710144],
    [1841, -7.946554, -10.446478, -5.526144],
    [1842, -5.260554, 4.491522, 12.451828],
    [1843, -6.950554, 9.345522, -8.202144],
    [1844, 5.471446, 7.619522, -10.726144],
    [1845, 12.657442, -1.642478, -6.336144],
    [1846, 11.445446, 6.749524, -5.152144],
    [1847, -12.644554, 3.019522, 5.839858],
    [1848, 11.691446, 7.463522, -3.292144],
    [1849, 0.645446, 12.657522, -6.528144],
    [1850, 14.107424, 2.021522, 0.507856],
    [1851, -11.252554, 6.367524, 6.059856],
    [1852, -8.934556, -4.124478, -10.350144],
    [1853, 1.099448, -14.206478, 1.023858],
    [1854, 3.027446, -5.992478, -12.610144],
    [1855, 7.881446, -9.286478, 7.469856],
    [1856, 8.163446, -5.498478, 10.359858],
    [1857, 2.530650, 5.094320, 13.109848],
    [1858, -11.808554, 0.697524, -8.020144],
    [1859, 13.119448, 2.733522, 4.981858],
    [1860, 5.817446, 10.111522, 8.267856],
    [1861, 12.565432, 4.767522, 4.893856],
    [1862, 5.239446, 11.251522, -7.110144],
    [1863, -0.408554, 12.725522, 6.519858],
    [1864, -0.302554, 10.845522, -9.322144],
    [1865, -1.042552, -7.964478, 11.841842],
    [1866, -7.684556, 5.597522, 10.695856],
    [1867, 13.339418, 4.097522, 3.171856],
    [1868, -2.098554, -9.928478, 10.091856],
    [1869, -7.540554, -10.782478, 5.637858],
    [1870, -12.290554, 0.521522, 7.339858],
    [1871, -0.044554, -14.314478, -0.614144],
    [1872, -8.134554, 0.885522, -11.762144],
    [1873, -10.992554, 7.867524, 4.757856],
    [1874, -10.766554, 4.439522, -8.352144],
    [1875, -1.380554, -2.934478, -13.962144],
    [1876, -9.582554, 9.165524, 5.443858],
    [1877, -2.182554, -13.940480, 2.555856],
    [1878, -1.413352, -0.544884, 14.265854],
    [1879, 9.813446, 7.673522, -7.128144],
    [1880, -5.164554, -7.920478, -10.804144],
    [1881, 13.413424, 5.081522, -0.642144],
    [1882, -4.166554, -5.336478, -12.662144],
    [1883, 3.351446, -12.134478, -6.916144],
    [1884, -2.298554, 12.313522, 7.033858],
    [1885, 9.495448, -8.344478, -6.826144],
    [1886, -3.396554, -13.450478, -3.736144],
    [1887, -12.914554, 5.477522, -3.102144],
    [1888, 11.043448, -0.090476, 9.201856],
    [1889, 12.093446, 7.753522, 0.587856],
    [1890, 11.259448, 6.289522, 6.359858],
    [1891, 1.751852, 8.541116, 11.437856],
    [1892, -9.694554, -10.152478, 3.131856],
    [1893, 1.467446, 2.943522, -14.002144],
    [1894, 8.747446, 11.225522, 2.085856],
    [1895, 12.581422, -6.656478, -2.108142],
    [1896, 8.749446, 10.909524, -3.392144],
    [1897, 3.643446, -11.940478, 7.161858],
    [1898, 9.297448, -10.524478, 3.167856],
    [1899, 2.461446, -4.148478, -13.568144],
    [1900, 1.291446, 11.215522, 8.939858],
    [1901, -10.630554, -8.754478, 4.211856],
    [1902, -4.288554, -13.648478, 1.691856],
    [1903, 4.885446, 13.527502, -0.916144],
    [1904, -12.462554, 6.853524, 2.331856],
    [1905, 12.257418, -0.098478, 7.587856],
    [1906, -3.246554, 12.839524, -5.698144],
    [1907, -5.664554, 7.889522, 10.655858],
    [1908, -6.112554, -11.484478, -6.216144],
    [1909, 3.503446, 12.541522, 6.191856],
    [1910, 8.091446, 0.603524, -11.926144],
    [1911, -4.894554, 13.555518, -0.646144],
    [1912, -3.358962, 0.540320, 14.019852],
    [1913, -0.944554, 14.307500, 1.633856],
    [1914, 3.491446, 13.861516, 1.983856],
    [1915, 7.961446, -9.482480, -7.416144],
    [1916, -0.828554, -12.330478, 7.461856],
    [1917, 0.051446, -8.412478, -11.740144],
    [1918, -5.268956, 0.742320, 13.431838],
    [1919, -9.434556, 5.293522, -9.576144],
    [1920, 9.613448, 6.159524, 8.861856],
    [1921, 4.571448, -8.202478, -10.988144],
    [1922, -0.486554, 1.971524, -14.312146],
    [1923, 4.573446, 11.475522, 7.507856],
    [1924, -3.338554, 13.941504, -1.886144],
    [1925, -10.618556, -0.024476, 9.815856],
    [1926, 4.233446, -13.250478, 3.955856],
    [1927, -10.348554, -4.724478, -8.930144],
    [1928, 0.843040, 6.162320, 13.071854],
    [1929, -3.728554, 13.467504, -3.788144],
    [1930, -4.945354, -1.291682, 13.549850],
    [1931, -7.242554, -10.064478, 7.485858],
    [1932, -12.088554, -7.236478, -3.360144],
    [1933, 11.765444, 5.243522, -6.630144],
    [1934, 8.129446, -8.078478, -8.866144],
    [1935, 1.567446, 13.033514, 6.135856],
    [1936, -1.988554, -14.306478, -1.170144],
    [1937, 13.929446, 0.381524, -3.984144],
    [1938, 6.193448, -0.038476, -13.108144],
    [1939, -4.238554, 10.443524, 9.129856],
    [1940, 3.271446, 10.599524, -9.346144],
    [1941, -0.210554, -14.282478, 2.529856],
    [1942, 6.903446, 9.557522, -8.454144],
    [1943, 2.955446, 0.301524, -14.206144],
    [1944, -12.708556, 6.825524, -1.596144],
    [1945, -5.508554, -12.596478, -4.664144],
    [1946, -6.992554, 0.021522, 12.723832],
    [1947, 5.163446, 4.267522, -12.882144],
    [1948, -8.560554, -6.114478, -10.022144],
    [1949, 9.049446, -6.800478, 9.111856],
    [1950, 5.259448, 13.505498, 1.053856],
    [1951, -7.438554, -5.158478, -11.370144],
    [1952, 8.217448, 2.679522, -11.684144],
    [1953, -10.882556, -1.964478, 9.431856],
    [1954, 12.983430, 6.125522, -2.304144],
    [1955, -5.922554, -1.330478, -13.212144],
    [1956, -11.146554, -9.054478, 2.303856],
    [1957, 10.783448, 8.589524, -4.688144],
    [1958, -6.604554, 2.337522, -12.766144],
    [1959, 1.457448, 10.329524, -10.162144],
    [1960, -3.880554, -9.818478, -10.032144],
    [1961, 3.239446, -10.360478, 9.715856],
    [1962, -9.028554, 11.385522, 1.047858],
    [1963, 6.645446, -11.874478, 5.215856],
    [1964, -3.592554, 11.813522, -7.740144],
    [1965, 0.837446, -11.086480, -9.434144],
    [1966, -7.884554, 11.965522, 2.707858],
    [1967, -9.916554, -7.764478, -7.356144],
    [1968, -11.076954, 4.782320, 8.199856],
    [1969, 8.683446, 7.909524, 8.651858],
    [1970, 7.437446, -7.354478, 10.169858],
    [1971, 14.487428, 1.153522, -1.276144],
    [1972, 11.703448, -6.172478, 6.153856],
    [1973, -13.786554, 1.949522, 4.369856],
    [1974, 2.277446, 7.943524, -12.032144],
    [1975, -9.170556, 2.569522, 11.061858],
    [1976, 6.491448, 12.923498, -1.978144],
    [1977, -4.724554, -12.930480, 4.873858],
    [1978, 0.535446, -13.932478, 4.357856],
    [1979, 4.027446, -1.367276, 13.975846],
    [1980, 11.443448, -2.024478, 8.857856],
    [1981, -13.892556, -4.516478, -0.384144],
    [1982, -0.818554, 11.979522, 8.331858],
    [1983, -5.470554, -10.648478, -8.384144],
    [1984, -3.106554, 14.261510, 0.821856],
    [1985, -9.472554, 10.755524, 2.893856],
    [1986, 13.939424, -4.232478, 1.279856],
    [1987, -8.212554, 11.309522, -4.326144],
    [1988, -1.624554, -13.788478, -4.616144],
    [1989, -5.128554, 0.893522, -13.678144],
    [1990, 11.133448, -0.778478, -9.472144],
    [1991, -13.564554, 5.231522, 1.747856],
    [1992, 8.969446, 5.065524, 10.407856],
    [1993, -14.578554, -0.902478, 1.061858],
    [1994, -12.240554, -3.690478, 7.143856],
    [1995, 2.627448, 12.659524, -6.880144],
    [1996, 1.101446, -12.176478, 8.065856],
    [1997, 8.145446, -11.946478, 2.357856],
    [1998, 6.099448, -4.926478, -12.380144],
    [1999, 0.685446, -8.934478, 11.597856],
    [2000, -8.316556, -12.058478, 0.499858],
    [2001, -4.254554, 11.793524, 7.599858],
    [2002, 5.827446, -12.878480, -3.892144],
    [2003, 5.573446, -3.180478, -13.186144],
    [2004, -6.126554, -9.226478, -9.612144],
    [2005, -14.364556, -2.888478, 0.775856],
    [2006, -2.866554, -12.440478, 7.233856],
    [2007, -2.660552, 5.777116, 13.227828],
    [2008, 11.863436, -2.960478, -8.120144],
    [2009, 0.441446, -13.590478, -5.532144],
    [2010, 3.061448, 13.613500, 4.571858],
    [2011, -5.392554, 9.951522, -9.354146],
    [2012, -11.716554, 8.659524, 1.837856],
    [2013, -4.080554, -10.094478, 9.855856],
    [2014, 7.170244, -12.802078, -0.622142],
    [2015, -6.830554, 11.681522, -5.720144],
    [2016, -2.702554, 8.141524, -11.932144],
    [2017, -5.694554, -10.380478, 8.711856],
    [2018, 14.265444, -0.460478, 3.521856],
    [2019, -2.428554, 10.529522, 9.977858],
    [2020, 11.041446, -9.616478, 1.479856],
    [2021, -10.936554, 0.881524, -9.808144],
    [2022, 14.139436, -4.022478, -0.698144],
    [2023, -1.308554, -14.632478, 0.901856],
    [2024, 4.015446, -9.922478, -10.104146],
    [2025, -1.820554, 13.833502, -4.702144],
    [2026, 1.785446, -14.058480, -3.998144],
    [2027, 11.087446, -9.650478, -0.876144],
    [2028, 4.357446, 8.939522, 10.863858],
    [2029, -14.140554, 3.309522, 2.457858],
    [2030, 11.177446, -8.074478, -5.190144],
    [2031, 4.067446, -11.268478, -8.578144],
    [2032, -13.200554, 5.403522, 3.701856],
    [2033, 6.937446, -6.406478, -11.316144],
    [2034, -10.812554, 9.395524, 3.469856],
    [2035, 14.555422, 0.953522, 2.133856],
    [2036, -6.020554, -4.568478, -12.658144],
    [2037, 14.543428, -2.114478, -1.186144],
    [2038, 9.899446, -10.928478, 0.107856],
    [2039, 5.324650, 2.332320, 13.551834],
    [2040, 1.527854, -4.398878, 13.995834],
    [2041, -3.556554, 10.743522, -9.462144],
    [2042, -9.406554, 10.013524, -5.376144],
    [2043, -10.206554, -9.980478, -3.728144],
    [2044, 10.445446, -9.416480, 4.465856],
    [2045, 11.793428, 4.475522, 7.663856],
    [2046, -1.221756, -6.494878, 13.199844],
    [2047, 13.509432, 0.607524, -5.928144],
    [2048, -10.042554, -5.098478, 9.561858],
    [2049, 11.099448, -9.332478, -2.848144],
    [2050, 13.663424, -2.982478, -4.782144],
    [2051, -9.932554, 4.801524, 9.839858],
    [2052, 2.393446, -2.581680, 14.357834],
    [2053, 10.089448, -9.698478, -4.766144],
    [2054, 6.647446, 5.373522, -12.066144],
    [2055, 9.711446, -9.042478, 6.531856],
    [2056, 4.957448, -6.572478, -12.292144],
    [2057, -5.814554, -6.452478, -11.978144],
    [2058, 7.515446, -11.946478, -4.442144],
    [2059, -13.224554, 4.541522, -4.844144],
    [2060, 7.133852, 2.526726, 12.721848],
    [2061, 5.323446, 2.149522, -13.646144],
    [2062, -13.508554, -4.412478, -4.154144],
    [2063, 3.077446, 9.453524, -10.974144],
    [2064, 3.619446, 13.973516, -3.306144],
    [2065, 9.237446, 4.265522, -10.760144],
    [2066, -11.060554, -9.826478, -0.702144],
    [2067, 12.157442, 1.835522, 8.265856],
    [2068, -9.422554, 11.121522, -2.658144],
    [2069, -12.354556, 8.183524, 0.009858],
    [2070, 1.955446, 11.907522, -8.608144],
    [2071, -5.496554, 12.465522, 5.845856],
    [2072, -13.148554, -6.394478, 2.449856],
    [2073, 11.583446, 9.019524, 2.069856],
    [2074, -8.324554, 8.335524, 9.001856],
    [2075, -2.951758, 2.498726, 14.315842],
    [2076, 1.999446, -2.424478, -14.496146],
    [2077, -6.620554, 9.239522, 9.533858],
    [2078, 11.477448, 8.081522, 4.801856],
    [2079, -5.464554, 6.303522, -12.268144],
    [2080, 11.357446, 9.551524, 0.151856],
    [2081, -12.332554, 3.587522, -7.438144],
    [2082, -5.712554, 4.113522, -13.070144],
    [2083, 7.296244, -0.636884, 12.917832],
    [2084, 4.815040, 0.459522, 14.039840],
    [2085, 10.653446, 4.511522, 9.313856],
    [2086, -7.704554, 9.911522, 7.945856],
    [2087, -3.658554, -11.390478, -8.814144],
    [2088, 13.087434, 2.645524, -6.528144],
    [2089, 13.237428, 1.365522, 6.619856],
    [2090, 8.999446, -10.528478, 5.399856],
    [2091, -12.206554, -5.668478, 6.315856],
    [2092, 0.097446, -1.848478, -14.752144],
    [2093, 2.763446, 12.215522, 8.015856],
    [2094, -13.398554, -5.838478, -2.762144],
    [2095, 5.251446, 10.611522, -9.008144],
    [2096, 1.607446, 14.785498, -0.436144],
    [2097, 8.479040, -3.826078, 11.613452],
    [2098, 13.209444, 6.129522, 3.061858],
    [2099, 2.194648, 3.519928, 14.297836],
    [2100, 10.831448, 6.241522, -8.086144],
    [2101, -7.310554, -10.510478, -7.602144],
    [2102, -9.416554, -10.344478, 5.103858],
    [2103, 0.941852, -6.233678, 13.491836],
    [2104, -9.794554, -9.686478, -5.666144],
    [2105, -8.684556, -0.868476, 12.071854],
    [2106, 0.471446, -12.912478, -7.420144],
    [2107, -9.414554, 8.857522, 7.421856],
    [2108, -12.156556, -7.094478, 4.915858],
    [2109, 8.695446, 8.681522, -8.448144],
    [2110, 3.029446, 13.647498, -5.192144],
    [2111, -11.388554, -5.236478, 8.079856],
    [2112, -8.592554, -8.276478, 8.949858],
    [2113, 4.377448, -4.762478, -13.440144],
    [2114, -9.704554, -0.270478, -11.324144],
    [2115, 6.283448, -11.028478, -7.836144],
    [2116, -1.396554, -13.330478, -6.548144],
    [2117, 10.365446, 7.541522, 7.637858],
    [2118, -14.870554, 1.201522, -0.368142],
    [2119, -1.864554, -2.783678, 14.547836],
    [2120, -5.168554, 13.021520, -5.158144],
    [2121, -3.952154, -2.994878, 14.081832],
    [2122, 10.685448, -7.462478, 7.291856],
    [2123, 9.065446, 11.793524, -1.352144],
    [2124, -14.614556, -2.848478, -1.210144],
    [2125, 7.559446, -11.234478, -6.310144],
    [2126, -8.854554, -6.626478, 10.047858],
    [2127, -13.924554, 5.297522, -1.156144],
    [2128, -13.888554, -2.578478, -4.878144],
    [2129, -13.410554, -2.408478, 6.149856],
    [2130, -8.670554, 4.367524, -11.368144],
    [2131, -5.084554, 2.985930, 13.741836],
    [2132, -6.838554, 1.967522, 13.151840],
    [2133, 10.179448, 8.997522, 6.259858],
    [2134, 0.463446, 14.617498, 3.145856],
    [2135, -3.528554, 14.005498, 3.901858],
    [2136, 3.715446, 5.549522, -13.390144],
    [2137, 2.415448, -13.554478, -5.860144],
    [2138, 10.567448, 10.107522, -3.184144],
    [2139, 1.941446, 6.483522, -13.350144],
    [2140, -1.244554, -12.390478, -8.306144],
    [2141, -0.468554, 11.061524, 10.075858],
    [2142, -13.194556, -2.212478, -6.718144],
    [2143, 6.836648, -4.517278, 12.529830],
    [2144, -14.094554, 2.871522, -4.156144],
    [2145, -3.860554, 3.417522, -14.060144],
    [2146, 3.519854, -4.446078, 13.873856],
    [2147, 7.499446, -12.718480, -2.586144],
    [2148, -7.462554, -12.210478, -4.462142],
    [2149, -1.732554, 6.081522, -13.592144],
    [2150, 7.737446, 11.919524, -4.786144],
    [2151, -14.782554, 0.347522, -2.504144],
    [2152, -3.850554, -14.370478, -1.920144],
    [2153, 12.337434, -3.618478, 7.731858],
    [2154, -11.056554, 9.993522, -1.762144],
    [2155, -7.984554, -9.082478, -8.890144],
    [2156, -13.262554, 1.469522, -6.872144],
    [2157, -11.866554, -8.904478, -2.280144],
    [2158, -5.802554, -9.204478, 10.339858],
    [2159, -0.992960, 3.361522, 14.599838],
    [2160, -6.744554, 12.721524, 4.263856],
    [2161, -10.456554, -10.692478, 1.355856],
    [2162, -9.440554, 6.757522, 9.531856],
    [2163, 1.727446, -14.644478, 2.873856],
    [2164, -3.148960, -7.592478, 12.575852],
    [2165, 9.755448, 10.277524, -5.000144],
    [2166, -14.628556, 3.387522, -0.614144],
    [2167, 0.229040, 0.399116, 15.025834],
    [2168, 13.129426, -7.320478, -0.300144],
    [2169, 13.021426, -3.588478, -6.606144],
    [2170, -10.622554, 7.087522, 7.937856],
    [2171, 12.213442, 3.785522, -7.912144],
    [2172, 7.678244, 4.977116, 11.933854],
    [2173, 1.221446, -14.834478, -2.144144],
    [2174, -13.952554, -0.702478, -5.568144],
    [2175, 12.629426, -0.774478, -8.136144],
    [2176, -3.514554, -8.682478, -11.776144],
    [2177, -7.508554, -4.060478, 12.391830],
    [2178, 0.323446, 5.505522, -14.012144],
    [2179, -14.712554, -0.228478, 3.209856],
    [2180, -1.742554, 14.681494, -2.900144],
    [2181, -14.362554, 0.917522, -4.470144],
    [2182, 1.045446, -10.634478, 10.627858],
    [2183, 3.667446, -14.414478, 2.435856],
    [2184, -7.026554, 0.329522, -13.334144],
    [2185, -8.232554, -1.072478, -12.588144],
    [2186, 10.081854, -5.048076, 10.016654],
    [2187, 14.111422, 2.185522, -4.856144],
    [2188, 2.573446, -14.854478, -0.536144],
    [2189, 2.727852, -0.115274, 14.839828],
    [2190, -11.934556, 1.325522, 9.137858],
    [2191, -14.722556, 2.341522, -2.336144],
    [2192, 13.939424, 4.709522, -3.358144],
    [2193, -8.006554, 12.539522, -2.536144],
    [2194, -7.754554, 12.927496, 0.743856],
    [2195, 4.543446, 12.945502, -6.294144],
    [2196, -9.888554, 2.261522, -11.178144],
    [2197, 13.567446, 4.073522, -5.220144],
    [2198, -9.304554, -2.714478, 11.575858],
    [2199, -0.094554, -14.650478, -3.652144],
    [2200, -8.574554, 8.535522, -9.036144],
    [2201, -3.654554, 6.743522, -13.010146],
    [2202, -4.924554, 6.595522, 12.663834],
    [2203, 3.327446, 14.665502, -1.450144],
    [2204, 14.139436, 5.081522, 1.633856],
    [2205, 6.739446, -13.170478, 3.087856],
    [2206, 1.343446, -10.146478, -11.122144],
    [2207, -1.412554, -14.408478, 4.353858],
    [2208, 9.869446, 5.907522, -9.816144],
    [2209, -9.012554, -4.656478, 11.217858],
    [2210, 5.185446, -1.454478, -14.136144],
    [2211, 9.993446, 3.405524, 10.839858],
    [2212, 0.698244, 2.345928, 14.933854],
    [2213, 7.043448, -9.756478, -9.178144],
    [2214, -7.366554, 5.831522, -11.868144],
    [2215, -6.300554, -12.198478, 6.379856],
    [2216, 4.531446, -9.174478, 11.159856],
    [2217, 3.927446, -3.012478, -14.310144],
    [2218, -13.390554, -6.994478, -1.134144],
    [2219, 6.759448, -10.600480, 8.453858],
    [2220, 14.531436, 2.245522, 3.651858],
    [2221, 0.055446, 14.191504, -5.308144],
    [2222, -12.556554, -5.322478, -6.610144],
    [2223, -3.742554, 9.623522, -11.096144],
    [2224, 2.593446, -9.520478, 11.505858],
    [2225, 6.889446, 3.281522, -13.100144],
    [2226, 3.237446, -14.616478, -2.402144],
    [2227, -12.432554, -3.736478, -7.834144],
    [2228, 5.239446, -10.380478, 9.731858],
    [2229, -10.112554, 8.169524, -7.810144],
    [2230, -4.858954, -4.709678, 13.573838],
    [2231, 10.587446, -5.814478, -9.182144],
    [2232, 7.323446, 7.065524, -11.256144],
    [2233, 9.199448, -11.712478, -2.918144],
    [2234, 10.591446, 1.015522, 10.823856],
    [2235, -1.576554, -13.740478, 6.253856],
    [2236, -13.740554, 1.411522, 6.295856],
    [2237, -15.140554, -0.714478, -0.854144],
    [2238, 9.130244, -0.581680, 12.117844],
    [2239, -6.724554, 7.625522, -11.280144],
    [2240, 9.192244, 1.924318, 11.933854],
    [2241, -0.322554, 12.635522, -8.422144],
    [2242, -3.054554, -12.834478, -7.548144],
    [2243, -3.192554, -1.297682, 14.803848],
    [2244, -12.760556, 2.643522, 7.825858],
    [2245, -1.824554, -6.284478, -13.720144],
    [2246, -5.456554, 12.329524, -7.024144],
    [2247, 8.739446, 10.067522, 7.309856],
    [2248, 1.799446, 14.589514, -3.886144],
    [2249, -1.958554, 15.051520, -0.950144],
    [2250, 7.739446, -11.184478, 6.817856],
    [2251, -7.760554, -12.618478, 3.469856],
    [2252, 12.419436, -8.024478, -3.598144],
    [2253, 0.147446, 7.379522, -13.316144],
    [2254, -6.564554, 13.219518, -3.738144],
    [2255, 8.729446, 12.467524, 0.499858],
    [2256, -12.618556, 7.665524, -3.732144],
    [2257, 10.419446, -1.916478, -10.942144],
    [2258, 9.379446, 10.663522, 5.503856],
    [2259, -9.986556, -11.498478, -0.452144],
    [2260, -12.474554, -1.866478, -8.548144],
    [2261, -6.149754, -3.187678, 13.571854],
    [2262, -3.546554, 1.469522, -14.748144],
    [2263, 14.267428, -1.134478, -5.240144],
    [2264, -7.492554, -7.998478, 10.593856],
    [2265, -12.312554, -0.638478, 8.969856],
    [2266, -11.408554, -6.160478, -8.024144],
    [2267, -10.398554, -6.902478, 8.767856],
    [2268, 13.135438, -4.642478, 6.215856],
    [2269, -6.140554, -7.310478, 11.899856],
    [2270, 12.015444, 9.247522, -1.708144],
    [2271, 13.011446, 1.171522, -7.884144],
    [2272, -1.392554, 14.691504, 3.879856],
    [2273, 6.411446, 13.235510, -4.068144],
    [2274, 3.135040, 1.845116, 14.819840],
    [2275, -5.798554, -14.026478, -1.582144],
    [2276, -6.536554, 13.569494, 2.467858],
    [2277, 0.903446, 12.957494, 8.019858],
    [2278, -8.776554, 10.701522, 6.447856],
    [2279, -4.250554, -8.970478, 11.601856],
    [2280, 3.851446, 3.729522, -14.300144],
    [2281, 4.737446, 14.071508, 3.575858],
    [2282, -11.580554, 3.269522, 9.409856],
    [2283, -6.674554, 13.661504, -1.548144],
    [2284, -4.708554, 8.155524, -12.038146],
    [2285, -3.302554, -13.814478, -5.696144],
    [2286, 6.203448, 9.441522, -10.324144],
    [2287, -7.488554, -13.160478, -2.222144],
    [2288, 2.151448, 4.775522, -14.380144],
    [2289, -12.676554, 5.119522, 6.883856],
    [2290, 3.183446, 11.325524, 9.793858],
    [2291, 1.533448, 1.321522, -15.174144],
    [2292, -1.978554, 11.977522, -9.326144],
    [2293, -9.234554, -11.996480, 2.279856],
    [2294, -11.454554, -3.226478, -9.632144],
    [2295, 13.605440, -5.442478, 4.439858],
    [2296, -8.652554, 1.133522, 12.587844],
    [2297, 10.797448, 10.783524, -1.320144],
    [2298, 3.543446, -8.085678, 12.519852],
    [2299, -3.300554, -14.958478, 0.189856],
    [2300, -1.154554, 7.203116, 13.471848],
    [2301, -14.602554, -3.954478, 2.447856],
    [2302, 7.719446, 11.869522, 5.865856],
    [2303, -11.100554, 10.489522, 1.323856],
    [2304, -14.814554, -1.214478, -3.756144],
    [2305, 8.717448, -6.898478, -10.560144],
    [2306, 13.525424, -4.956478, -5.256144],
    [2307, 6.165040, -2.392478, 13.839828],
    [2308, -3.154554, -2.520478, -14.798146],
    [2309, -7.814554, 7.599524, 10.793858],
    [2310, 3.968242, -6.335278, 13.397842],
    [2311, 6.105446, 9.685522, 10.213858],
    [2312, -12.768554, 6.959522, 4.893856],
    [2313, -11.524556, 8.861522, -4.908144],
    [2314, 14.447420, 0.865522, 5.095856],
    [2315, -0.097352, -3.649278, 14.903854],
    [2316, 14.883424, 3.199522, 1.935856],
    [2317, -7.224554, -13.538478, -0.276144],
    [2318, -14.474554, -1.174478, 4.987856],
    [2319, -1.716554, -1.140478, -15.216144],
    [2320, 10.087446, -7.716478, -8.636144],
    [2321, -14.484554, 4.277524, -2.790144],
    [2322, -3.498554, -7.202478, -13.106144],
    [2323, 3.529446, -7.920478, -12.686144],
    [2324, 13.567446, 7.187522, -0.644144],
    [2325, -6.882556, 5.655524, 12.525834],
    [2326, -11.246554, -8.460478, 6.189858],
    [2327, 0.637446, -7.164478, -13.590146],
    [2328, 10.839448, -3.974478, -10.156146],
    [2329, -9.794554, -9.620478, 6.933856],
    [2330, 12.611422, -8.638478, -1.704144],
    [2331, 3.767446, -13.722478, 5.847856],
    [2332, -6.294554, 11.809522, 7.599858],
    [2333, 14.261446, -4.676478, -3.406144],
    [2334, 13.243440, 6.605522, -4.226144],
    [2335, 5.396650, -7.334478, 12.413834],
    [2336, -9.068554, 4.491522, 11.603858],
    [2337, 12.625430, -6.772478, -5.650144],
    [2338, 9.109448, -12.376478, -1.032144],
    [2339, 3.711446, -14.258478, -4.490144],
    [2340, 15.113436, -2.612478, 1.421856],
    [2341, 7.709446, 8.453522, 10.317858],
    [2342, 12.093446, 2.301524, -9.264144],
    [2343, -2.142554, 2.869522, -14.988144],
    [2344, -13.440554, -0.414478, -7.534144],
    [2345, -2.084554, -11.508478, -10.042144],
    [2346, 15.405428, 0.509522, 0.381858],
    [2347, 9.557448, -8.626478, 8.483856],
    [2348, 8.045446, 12.527524, 4.011856],
    [2349, -11.364554, -8.430480, -6.140144],
    [2350, -14.356554, -3.478478, 4.453858],
    [2351, -0.188552, 10.513524, -11.292144],
    [2352, 3.413852, 8.338320, 12.527848],
    [2353, -4.952554, -12.142478, 8.139856],
    [2354, -6.948554, 11.315524, -7.870144],
    [2355, 7.107446, 11.965522, -6.682144],
    [2356, 10.951446, -3.192478, 10.403856],
    [2357, -11.100554, -1.526478, -10.626144],
    [2358, 6.267446, -12.848478, -5.840144],
    [2359, 4.741446, -14.656478, -1.094144],
    [2360, 12.879426, 6.715522, 5.247856],
    [2361, 4.903446, 0.455522, -14.638144],
    [2362, 10.813446, 3.025522, -10.604146],
    [2363, -2.300554, -14.970478, -3.030144],
    [2364, 7.673446, 9.945522, 8.993856],
    [2365, -4.288554, -14.406478, 3.573856],
    [2366, -0.180960, -1.674478, 15.359848],
    [2367, 0.457446, 10.047524, 11.733840],
    [2368, 6.137854, 5.268320, 13.173844],
    [2369, -11.636554, 7.773524, -6.580144],
    [2370, -13.002554, 6.473522, -5.308144],
    [2371, -0.730554, -10.340478, 11.485858],
    [2372, -9.138554, 9.967524, -7.520144],
    [2373, -14.818554, -3.128478, -3.182144],
    [2374, 14.939424, 4.039522, 0.123856],
    [2375, -11.852554, -8.986478, -4.280144],
    [2376, 3.997446, 7.483522, -12.946144],
    [2377, 11.183446, 9.909524, 4.055856],
    [2378, 11.093446, 1.051524, -10.756144],
    [2379, -15.388554, 0.865522, 1.531856],
    [2380, 8.889446, 7.617524, -10.144144],
    [2381, -0.556552, -10.780478, -11.112144],
    [2382, -5.186554, 9.829524, 10.799856],
    [2383, -2.922554, 12.245524, 9.037858],
    [2384, 1.643446, -0.662478, -15.396144],
    [2385, -14.060554, 4.165522, 5.015856],
    [2386, -11.990554, -3.612478, 9.131856],
    [2387, -8.574554, 2.665522, -12.634144],
    [2388, 14.237428, -3.096478, 5.287858],
    [2389, -12.612554, 8.769524, -2.068144],
    [2390, -0.184554, 15.387518, -1.864144],
    [2391, -7.112554, 9.263524, -10.196144],
    [2392, 12.821444, 8.067522, 3.319856],
    [2393, 2.389446, -13.486478, 7.277856],
    [2394, -10.186554, -7.048478, -9.336144],
    [2395, -13.926554, -0.514478, 6.813856],
    [2396, 13.209444, -1.818478, 7.927856],
    [2397, -10.928554, 10.363524, -3.736144],
    [2398, 14.319430, -5.730478, -1.716144],
    [2399, -7.480554, 12.181522, 6.041856],
    [2400, 4.125446, 12.515522, -8.198144],
    [2401, -2.134554, 10.801524, -10.938144],
    [2402, 9.447446, -10.460478, -6.506144],
    [2403, 5.867446, -12.596478, 6.921856],
    [2404, 7.571448, 6.957524, 11.631856],
    [2405, -0.340554, 14.491522, 5.573856],
    [2406, -1.038146, 5.495524, 14.495834],
    [2407, 6.471446, 13.887518, 2.595856],
    [2408, -12.360554, -9.392478, 0.753856],
    [2409, 8.647448, -2.534478, -12.664144],
    [2410, -2.340554, 14.099524, 6.119856],
    [2411, 13.391420, -7.220478, 3.205856],
    [2412, 2.295446, -12.414478, -9.080144],
    [2413, -11.218554, 8.485524, 6.637858],
    [2414, -11.724554, 6.359522, -8.002144],
    [2415, 7.205446, 13.769506, 0.657856],
    [2416, -3.224554, -14.286478, 5.263856],
    [2417, -10.978554, 1.721524, 10.899856],
    [2418, -7.472554, -9.850480, 9.461856],
    [2419, 13.831422, 7.037524, 1.329856],
    [2420, 5.645446, -14.390478, 1.939856],
    [2421, -9.500556, -12.074478, -2.582144],
    [2422, 8.381446, 12.813522, -2.924144],
    [2423, -4.801754, -6.677680, 13.241836],
    [2424, 2.497446, 15.035498, 3.269858],
    [2425, -3.310554, 9.801524, 11.661858],
    [2426, 4.366650, 5.079116, 14.077836],
    [2427, 8.171446, -2.466478, 13.047836],
    [2428, 8.479446, -12.268478, 4.549856],
    [2429, -9.368556, -11.612478, -4.528142],
    [2430, 9.797448, 11.539522, 3.749856],
    [2431, -2.393756, -9.457678, 12.171830],
    [2432, 14.431428, -5.916478, 0.305856],
    [2433, -7.626554, -13.504478, 1.683856],
    [2434, 0.143446, -5.434478, -14.624144],
    [2435, 9.613448, -0.650478, -12.272144],
    [2436, -3.106960, -4.752478, 14.535842],
    [2437, -5.042554, 14.737494, 0.973856],
    [2438, -6.516554, -5.684478, 12.995834],
    [2439, 2.907446, 10.173522, 11.481858],
    [2440, 5.181446, -12.666480, -7.518144],
    [2441, -5.006554, -12.528478, -7.864144],
    [2442, 4.139446, 15.053504, 0.443858],
    [2443, 4.881040, 6.819116, 13.179856],
    [2444, -1.756554, 0.975522, -15.492144],
    [2445, -2.720554, 4.437116, 14.729844],
    [2446, -12.598554, 8.495524, 3.627858],
    [2447, 12.755434, -5.480478, -7.178144],
    [2448, 6.505448, -8.856478, 11.115856],
    [2449, -2.708554, 8.361522, 12.925858],
    [2450, -9.960554, 7.219522, -9.646144],
    [2451, -5.747354, -14.524478, 0.636262],
    [2452, 12.735446, -8.804478, 2.175856],
    [2453, -9.868556, 11.123524, 4.829856],
    [2454, 0.317446, -13.926478, 7.099858],
    [2455, 2.365446, 15.403510, 1.305856],
    [2456, 8.495448, 10.577522, -7.788144],
    [2457, -7.964554, -6.430478, 11.829850],
    [2458, 0.271446, -8.122078, 13.377854],
    [2459, 1.362244, 8.068726, 13.343856],
    [2460, -1.116554, -8.120478, -13.336144],
    [2461, -2.018554, -4.622478, -14.820144],
    [2462, 0.401446, 15.623510, 0.963856],
    [2463, 5.035446, -12.048480, 8.643856],
    [2464, 6.395446, 13.551520, 4.559856],
    [2465, -2.216554, 13.351508, -7.886144],
    [2466, 9.881446, -2.431274, 11.909836],
    [2467, 11.445446, 4.679522, -9.626144],
    [2468, 5.509854, -4.327278, 14.017838],
    [2469, -12.968554, -8.360478, 2.747856],
    [2470, 15.317446, 2.967522, -1.516144],
    [2471, 5.879446, -9.718478, -10.804144],
    [2472, 15.055422, -2.816478, -3.360144],
    [2473, -3.490554, -11.974478, 9.503856],
    [2474, 11.597446, 8.321522, -6.504144],
    [2475, -4.411754, 5.298726, 14.091842],
    [2476, 15.597444, -0.472476, -1.626144],
    [2477, -10.584554, 4.107522, -10.828144],
    [2478, 8.125446, -9.220478, 9.753856],
    [2479, 7.325448, 1.463522, -13.806144],
    [2480, 2.071446, -5.944478, -14.382144],
    [2481, 11.031446, -6.530478, 9.067856],
    [2482, -1.204554, 4.639522, -14.960144],
    [2483, 3.535446, -1.300478, -15.252144],
    [2484, -3.592554, -0.460478, -15.292144],
    [2485, 0.767040, 4.759930, 14.957840],
    [2486, -13.614554, -7.816478, 0.727856],
    [2487, 1.681446, -9.024478, -12.758144],
    [2488, 5.709446, -13.678478, 5.231858],
    [2489, 5.129446, -14.550478, -3.050144],
    [2490, -6.464554, -3.138478, -13.990144],
    [2491, 7.429448, -13.820478, 1.079856],
    [2492, 14.753420, -1.168478, 5.329856],
    [2493, -9.856554, -2.126478, -12.074144],
    [2494, 11.759432, 2.943522, 10.025856],
    [2495, -13.282554, -2.186478, 8.143856],
    [2496, 12.375430, -8.788478, 4.141858],
    [2497, -2.632554, 15.319494, 2.441856],
    [2498, 4.885446, 9.191522, -11.800144],
    [2499, -6.810554, 3.979522, 13.615830],
    [2500, 6.059446, 12.813522, 6.835858],
    [2501, 15.129426, -2.246478, 3.699856],
    [2502, 9.231448, 7.169524, 10.537858],
    [2503, 1.525446, 9.903522, -12.136144],
    [2504, 11.071448, 10.939524, 2.341856],
    [2505, -13.776554, -5.674478, 5.075858],
    [2506, 7.177446, 11.559522, 7.921856],
    [2507, -0.706554, -15.602478, -1.996144],
    [2508, 1.547448, 14.845496, 5.021856],
    [2509, -8.472554, 3.099522, 12.911850],
    [2510, -4.482554, -13.506480, 6.753856],
    [2511, 8.387448, 4.499524, -12.560144],
    [2512, -6.856154, -1.388884, 14.121842],
    [2513, -4.534554, -3.954478, -14.566144],
    [2514, 5.353446, 14.613500, -2.536144],
    [2515, 8.071448, -0.580478, -13.534144],
    [2516, 11.597446, 6.307522, 8.627858],
    [2517, 12.789430, -9.228478, 0.215856],
    [2518, 13.831422, -6.602478, -3.728144],
    [2519, -1.644554, -11.860478, 10.269858],
    [2520, -10.460554, 0.013524, 11.807846],
    [2521, -5.652554, 2.641522, -14.494144],
    [2522, 9.443448, -11.656478, -4.896142],
    [2523, -10.836554, -3.770478, 10.835858],
    [2524, -6.086554, -14.310478, 2.699856],
    [2525, 2.925852, 6.947116, 13.871842],
    [2526, 4.733446, 13.995520, 5.589858],
    [2527, 7.659446, -8.682478, -10.748144],
    [2528, -14.668554, -5.712478, 1.341856],
    [2529, 10.305446, 9.813522, -6.866144],
    [2530, -6.276554, -14.066478, -3.530144],
    [2531, 6.712244, 1.084320, 14.265854],
    [2532, -14.134554, 3.179522, -6.328144],
    [2533, -5.260554, 11.911522, -8.966144],
    [2534, -9.498554, 12.587522, -1.190144],
    [2535, -12.894554, -7.548478, -5.196144],
    [2536, 5.737852, 8.319930, 12.171830],
    [2537, 8.265446, -5.342478, -12.388144],
    [2538, 3.093446, -14.894478, 4.369856],
    [2539, 9.175448, -12.866478, 0.915858],
    [2540, -4.314554, 14.105504, 5.747856],
    [2541, -0.330552, 9.255522, -12.842144],
    [2542, -8.242554, -3.348478, -13.098144],
    [2543, 9.765448, 1.599522, -12.362144],
    [2544, 13.095430, -7.242478, 5.179858],
    [2545, 6.261446, -8.130478, -12.064144],
    [2546, -13.034554, 2.229522, -8.720144],
    [2547, 13.561434, 3.085522, 7.583856],
    [2548, 14.543428, -5.844478, 2.297858],
    [2549, 1.675446, 14.365514, -6.474144],
    [2550, 10.683446, -11.558478, 1.833856],
    [2551, -0.856554, 9.109116, 12.939834],
    [2552, 1.719446, -14.648478, 5.799856],
    [2553, -6.940554, -8.086478, -11.732144],
    [2554, -1.978554, -9.910478, -12.214144],
    [2555, -1.236554, -5.372880, 14.863846],
    [2556, 10.845448, -11.438478, -1.718144],
    [2557, 7.419446, -3.892478, -13.464144],
    [2558, -4.874554, 8.641524, 12.371842],
    [2559, 9.869446, -5.380478, -11.188144],
    [2560, -12.620554, -0.176478, -9.610144],
    [2561, 15.435426, -0.860478, -3.582144],
    [2562, 3.175446, -12.714478, 8.949858],
    [2563, -1.472554, 10.587522, 11.729844],
    [2564, -3.986554, 15.349524, -0.612144],
    [2565, -9.208554, 6.327522, -11.274146],
    [2566, 14.617434, 4.029522, 4.707858],
    [2567, 12.583436, -5.648478, 7.867856],
    [2568, 14.219424, -0.324478, 7.069856],
    [2569, 11.647448, -8.980478, 5.997856],
    [2570, -6.526554, -13.752478, 4.567856],
    [2571, 3.821448, 1.991522, -15.300144],
    [2572, -5.116554, -1.994478, -14.918144],
    [2573, -11.240554, -10.996480, -2.348144],
    [2574, 12.341432, 9.325524, -3.680144],
    [2575, 4.307446, -15.288478, 0.755856],
    [2576, -8.770554, 11.731524, -6.194144],
    [2577, -5.536554, 14.313512, 4.179858],
    [2578, -15.088554, 5.013524, 0.449856],
    [2579, 12.253420, -4.732478, -8.970144],
    [2580, 13.491426, 8.023524, -2.636144],
    [2581, 12.115420, -2.436478, -10.036144],
    [2582, -14.358554, 6.825524, 0.835856],
    [2583, 1.541446, 11.507522, 10.897858],
    [2584, -15.624554, 2.825522, 1.215856],
    [2585, 5.357446, 11.749524, 9.321858],
    [2586, 2.421446, -15.690480, 1.273858],
    [2587, -15.096554, -4.684478, -1.964144],
    [2588, 8.235446, 13.591498, -1.076144],
    [2589, -8.398554, -2.398478, 13.331832],
    [2590, -3.128554, 5.131524, -14.762144],
    [2591, -0.284554, -12.954480, 9.283858],
    [2592, -15.492554, 1.665522, 3.365856],
    [2593, -10.362554, -5.628478, -10.728144],
    [2594, 11.015448, -0.828478, 11.497856],
    [2595, -15.418554, -2.088478, 3.485858],
    [2596, 4.351852, -3.040878, 15.037858],
    [2597, -0.376554, -3.718478, -15.504144],
    [2598, 5.619446, 6.137522, -13.606144],
    [2599, 1.783448, 15.697516, -2.220144],
    [2600, -4.938554, 5.647522, -14.082144],
    [2601, 9.053446, 6.135522, -11.624144],
    [2602, -0.540554, 14.223516, -7.220144],
    [2603, -4.710554, 1.616320, 15.165848],
    [2604, -11.800554, 2.567522, -10.446144],
    [2605, 10.503446, 8.001522, -8.982144],
    [2606, 8.379446, 13.411504, 2.235858],
    [2607, 0.427446, 3.639522, -15.556144],
    [2608, -7.998554, -12.714478, 5.459856],
    [2609, -6.604554, 7.635522, 12.391830],
    [2610, 15.263430, 3.215522, -3.502144],
    [2611, 8.445446, -5.688078, 12.325852],
    [2612, 1.563446, -4.174478, -15.356144],
    [2613, -5.254554, 14.961524, -2.108142],
    [2614, 11.713442, -10.418478, 3.187856],
    [2615, -1.698552, 8.077522, -13.704144],
    [2616, -13.584554, 5.123522, -6.720144],
    [2617, 12.695436, 0.451522, -9.728144],
    [2618, -10.906556, 9.639522, -6.644144],
    [2619, 4.959446, 14.441504, -4.786144],
    [2620, -8.102554, -12.244478, -6.366144],
    [2621, -12.360554, 10.173522, -0.248144],
    [2622, 0.045446, 15.543524, -3.848144],
    [2623, -12.108554, -7.056478, 7.747856],
    [2624, 15.237428, -4.046478, 2.815856],
    [2625, 12.947420, 6.847522, -6.478144],
    [2626, -15.170556, 0.701522, 5.091856],
    [2627, 6.971446, 11.549522, -8.638144],
    [2628, 11.785432, -7.992478, -7.340144],
    [2629, 8.554650, 0.882724, 13.517838],
    [2630, 7.380650, -7.368880, 12.163834],
    [2631, -11.095354, -1.838478, 11.412652],
    [2632, 15.151430, 4.953522, -1.650144],
    [2633, 4.279446, -14.062480, -6.388144],
    [2634, -0.182554, -0.146478, -16.036144],
    [2635, -11.602554, -10.452478, 3.667856],
    [2636, -9.238554, -4.856478, -12.182144],
    [2637, -11.420556, 9.945522, 5.293856],
    [2638, 11.997438, -4.720478, 9.549856],
    [2639, -9.066556, -13.200478, -0.988144],
    [2640, -6.932554, -11.886478, 8.253856],
    [2641, 6.071448, 7.819522, -12.630144],
    [2642, 0.285446, -15.970478, 1.561858],
    [2643, 10.951446, -11.144478, -3.688144],
    [2644, 15.995424, -1.382478, 0.103858],
    [2645, 12.451418, 1.065524, 10.081858],
    [2646, 0.963446, -16.024479, -0.328144],
    [2647, 15.865420, -0.780478, 2.361856],
    [2648, 13.017428, 5.993522, 7.249856],
    [2649, 9.175042, 3.840318, 12.609848],
    [2650, -3.642554, -5.760478, -14.544144],
    [2651, 12.247438, 7.991522, 6.651858],
    [2652, -11.386554, 5.635522, -9.836144],
    [2653, 2.953448, 14.451514, 6.383856],
    [2654, 6.851446, -14.434478, -1.756144],
    [2655, -3.642554, 13.695502, 7.587856],
    [2656, 5.629446, -11.434478, -9.808144],
    [2657, -7.964554, 4.493522, -13.232144],
    [2658, 9.099448, 11.699522, -6.248144],
    [2659, -10.890554, 3.685522, 11.255858],
    [2660, 2.163040, -7.768478, 13.923844],
    [2661, 1.513446, -12.494478, 10.027856],
    [2662, -4.074554, 13.771520, -7.266144],
    [2663, 14.387422, -0.682478, -7.184144],
    [2664, -2.628554, -15.770480, 1.887856],
    [2665, -4.916954, -0.366072, 15.327836],
    [2666, -1.664554, 16.001501, 0.779856],
    [2667, -9.040554, -8.156478, -10.546144],
    [2668, 4.547448, 11.017522, -10.838144],
    [2669, -14.450554, 6.645524, -2.566144],
    [2670, -8.720554, 12.749524, 4.581856],
    [2671, -2.836960, -6.728878, 14.363846],
    [2672, -0.372552, -12.540478, -10.112144],
    [2673, 7.061448, -2.124478, -14.328144],
    [2674, -2.772960, 1.191522, 15.829850],
    [2675, -8.470554, -6.808478, -11.900144],
    [2676, -5.238554, -8.360478, -12.748144],
    [2677, -14.168554, -4.230478, 6.427856],
    [2678, -10.748554, -3.780478, -11.412144],
    [2679, -3.656554, 14.795508, -5.276144],
    [2680, 13.781436, -2.402478, -8.032144],
    [2681, 11.191446, 11.609524, 0.459856],
    [2682, -1.686554, -8.375278, 13.685836],
    [2683, 9.383448, -10.572478, 7.781856],
    [2684, -5.238554, -11.272478, -10.290144],
    [2685, -3.590554, 15.393500, -3.250144],
    [2686, -10.160554, -11.868478, 4.043856],
    [2687, 14.173434, -7.594478, 1.379856],
    [2688, 1.141446, 12.293524, -10.396144],
    [2689, -9.986556, -8.998478, -8.936144],
    [2690, -8.554554, -11.704480, 7.099858],
    [2691, 13.317446, 9.123522, -0.192144],
    [2692, -5.694554, 9.803522, -11.496144],
    [2693, -5.270554, 14.705512, -4.094142],
    [2694, 9.656244, -6.681278, 11.089858],
    [2695, -0.934554, 1.942320, 16.007828],
    [2696, 2.851446, -13.862478, -7.788144],
    [2697, -3.158554, -11.094478, 11.315856],
    [2698, 10.539446, -11.414478, 4.455856],
    [2699, -5.822554, 11.473522, 9.787858],
    [2700, -14.356554, -3.806478, -6.384144],
    [2701, 12.955446, -0.824478, 9.639856],
    [2702, 3.103446, -10.320478, -12.058144],
    [2703, -12.544554, 4.073522, -9.362144],
    [2704, -6.876554, 14.641516, 0.185856],
    [2705, 2.568244, -6.021278, 14.793838],
    [2706, 8.201446, 9.497522, -10.210144],
    [2707, 10.213448, -3.600478, -12.018144],
    [2708, 1.311448, 13.791510, -8.356144],
    [2709, -6.838954, 0.567522, 14.651840],
    [2710, -1.794554, 13.745520, 8.343856],
    [2711, 11.285446, -9.674478, -6.390144],
    [2712, -12.530554, -9.052478, 4.779856],
    [2713, -13.432554, -8.978478, -0.886144],
    [2714, 12.091432, -9.738478, -4.560144],
    [2715, 15.787446, 1.101522, -3.420144],
    [2716, -14.494554, 6.643522, 2.819856],
    [2717, -7.076554, -11.022478, -9.520144],
    [2718, -11.034554, 11.851522, -0.136142],
    [2719, 14.787446, 2.585522, 6.077856],
    [2720, 6.367446, 14.873510, -0.778142],
    [2721, 4.731448, 10.895524, 11.019858],
    [2722, -5.844554, -9.794478, -11.510144],
    [2723, 10.425448, 12.085524, -2.808144],
    [2724, -13.700554, -8.224478, -2.724144],
    [2725, -1.894554, -13.742480, 8.387858],
    [2726, 11.903444, -11.010478, 0.349856],
    [2727, 1.774648, 1.118724, 16.083849],
    [2728, -13.776554, 8.331522, 2.015856],
    [2729, 13.837434, 4.631524, -7.116144],
    [2730, -8.622554, 8.233522, -11.020144],
    [2731, 3.585448, -11.834478, -10.530144],
    [2732, 2.660244, 5.382724, 15.091842],
    [2733, 3.894650, 3.602320, 15.357834],
    [2734, 12.711428, 5.649522, -8.418144],
    [2735, 5.807448, 3.767522, -14.712144],
    [2736, -9.666554, 1.039522, -13.034144],
    [2737, 16.071444, 2.417522, 0.527856],
    [2738, -13.966554, 1.103524, 8.257856],
    [2739, 2.393446, 3.335522, -15.738144],
    [2740, 15.089418, 6.073522, 0.007856],
    [2741, -10.462554, -8.932478, 8.679858],
    [2742, -5.240554, -14.328478, -5.642144],
    [2743, -14.168554, 7.953522, -0.804144],
    [2744, -0.868554, -15.142478, -5.886144],
    [2745, 6.373448, 13.709508, -6.014144],
    [2746, -12.384554, 6.269522, 8.489856],
    [2747, 4.039446, -6.506478, -14.358144],
    [2748, 4.423446, 13.727514, 7.541856],
    [2749, -10.116554, 12.549522, 2.257856],
    [2750, -12.316556, -5.010478, -9.388144],
    [2751, 10.291446, -9.644478, -8.130144],
    [2752, 6.699446, -6.610478, -13.284144],
    [2753, -2.222554, 9.905524, -12.728144],
    [2754, -14.228554, -5.634478, -5.558144],
    [2755, 8.513446, -11.296478, -8.066144],
    [2756, -12.836554, 7.327522, 6.849858],
    [2757, -6.098554, -0.118476, -15.106144],
    [2758, -0.780554, 16.069494, 2.569856],
    [2759, -8.034554, 13.227514, -5.092144],
    [2760, -4.042554, 11.465522, 10.849858],
    [2761, -0.172554, -15.290478, 5.641858],
    [2762, -1.550554, -16.222479, -0.304144],
    [2763, -8.838554, 6.453522, 12.083848],
    [2764, -11.242554, 0.917522, -11.772144],
    [2765, -8.290554, 10.573522, -9.236146],
    [2766, 15.625430, -4.188478, -2.036144],
    [2767, -5.272554, -6.716478, -13.892146],
    [2768, -3.740148, 7.175522, 14.161850],
    [2769, 6.404244, -6.154078, 13.681838],
    [2770, -10.284554, 8.633522, 9.261856],
    [2771, -15.106554, -6.130478, -0.584144],
    [2772, -13.080554, 4.401522, 8.701856],
    [2773, -5.440954, -2.284884, 15.213852],
    [2774, 3.467448, -4.782478, -15.216144],
    [2775, 15.975436, -3.352478, -0.254142],
    [2776, 7.621852, 4.105522, 13.843856],
    [2777, -15.740554, -4.332478, 0.363858],
    [2778, -14.926554, -5.668478, 3.435856],
    [2779, -15.410554, 4.851522, 2.411856],
    [2780, 1.223446, -14.714478, -6.988144],
    [2781, 0.967446, -15.474478, -5.144144],
    [2782, -11.396554, 11.277524, 3.133856],
    [2783, -7.606554, -5.668478, -13.300144],
    [2784, -9.228554, -11.136478, -7.598144],
    [2785, 15.429446, 0.523522, -5.348144],
    [2786, 3.269448, 12.495524, -10.010144],
    [2787, 13.831422, 0.813522, 8.663856],
    [2788, -4.598554, 15.431494, 2.803856],
    [2789, 9.647448, 9.621522, 9.029858],
    [2790, -16.192554, -2.248478, -0.120144],
    [2791, 1.569446, 8.711524, -13.746146],
    [2792, -0.100554, 13.025518, 9.883858],
    [2793, -1.249352, -0.012478, 16.305832],
    [2794, 1.367040, -2.726072, 16.071854],
    [2795, -7.456554, -1.472476, -14.486146],
    [2796, -1.026554, -16.036478, 3.067856],
    [2797, 6.211446, -15.134478, 0.171856],
    [2798, 3.275446, 9.413522, -12.976144],
    [2799, -3.928554, -15.252478, -4.438144],
    [2800, -0.114554, -9.998478, -12.954144],
    [2801, 5.633446, -14.534480, -4.988144],
    [2802, 10.199448, 12.665524, 1.853858],
    [2803, 3.195446, -1.701274, 15.963852],
    [2804, 1.067446, 14.775518, 6.963856],
    [2805, 14.271426, -3.380478, 7.271856],
    [2806, 8.987446, -9.702478, -9.648144],
    [2807, -9.146554, -10.516478, 8.593856],
    [2808, -6.514554, -13.368478, -6.856144],
    [2809, -0.066554, 1.839524, -16.272144],
    [2810, 15.923434, 0.641522, 3.775856],
    [2811, -8.520554, -0.286478, 13.983840],
    [2812, 10.377448, -4.408478, 11.881852],
    [2813, 0.701446, -5.598078, 15.377854],
    [2814, -9.554554, 12.723522, -3.892144],
    [2815, -16.140554, -1.920478, -2.110144],
    [2816, -15.062556, 0.711522, -6.436144],
    [2817, 5.017040, 1.925928, 15.495834],
    [2818, 14.845430, -2.800478, -6.386144],
    [2819, 4.215446, 15.659522, 2.463856],
    [2820, -4.716554, -15.588478, 1.979856],
    [2821, 6.901042, -0.841274, 14.865830],
    [2822, -4.912554, -15.638480, -0.800144],
    [2823, 1.649446, -12.118478, -10.948144],
    [2824, -8.514554, 13.839514, 2.343856],
    [2825, -15.188554, 2.629522, 5.649856],
    [2826, 4.913852, -0.728478, 15.647842],
    [2827, 12.669436, -7.660478, 7.095858],
    [2828, 4.351446, -13.802478, 7.753856],
    [2829, 2.633446, -4.204076, 15.651840],
    [2830, 14.599428, 6.019522, 4.495858],
    [2831, 4.217448, -11.932478, 10.463858],
    [2832, -7.036554, 9.379522, 11.497856],
    [2833, -14.000556, -7.468478, 4.231858],
    [2834, -10.824554, -9.918478, -7.362144],
    [2835, -4.066554, -10.602478, -11.866144],
    [2836, 4.831446, -9.432478, -12.548144],
    [2837, -11.880554, 5.181522, 10.097856],
    [2838, 8.783448, 2.813522, -13.598144],
    [2839, -16.272554, -0.854476, 2.119856],
    [2840, -12.260556, -0.270478, 10.937856],
    [2841, 5.958650, 3.695116, 14.871842],
    [2842, -14.862554, 5.615522, -4.232144],
    [2843, -1.908554, 12.287524, 10.763856],
    [2844, -7.750556, -9.668478, -10.820144],
    [2845, 10.175448, 3.609522, -12.412144],
    [2846, 9.849448, -12.790478, 3.171856],
    [2847, -2.832554, -15.736478, 3.881856],
    [2848, 1.226244, 6.832726, 14.917832],
    [2849, 1.580244, -9.630878, 13.249832],
    [2850, 7.181446, -14.336480, -3.724144],
    [2851, 1.901448, 13.119512, 9.759858],
    [2852, 14.347444, 4.653522, 6.595856],
    [2853, 10.755448, -10.744478, 6.333856],
    [2854, -11.686554, -8.268478, -8.144144],
    [2855, 6.011446, 13.143500, -7.904144],
    [2856, 10.861446, 7.929524, 9.527856],
    [2857, 13.233430, 8.349524, -5.188144],
    [2858, -16.138554, -2.860478, 1.781856],
    [2859, 6.817446, -0.064478, -15.012144],
    [2860, 12.709444, 4.605522, 9.439858],
    [2861, 15.495424, 4.737522, 3.059856],
    [2862, -11.888554, -11.426478, 0.171856],
    [2863, 9.599448, 12.615522, -4.542144],
    [2864, 13.141420, -3.080478, 9.475856],
    [2865, 2.739446, 11.405524, -11.596144],
    [2866, -11.162554, 11.957524, -2.132144],
    [2867, -3.738554, 13.203496, -9.160144],
    [2868, -11.972556, -5.410478, 9.983856],
    [2869, -0.800554, 12.369522, -10.896144],
    [2870, -5.126554, -10.762478, 11.417856],
    [2871, -7.734554, 10.895524, 9.697856],
    [2872, 0.753446, -16.004478, 3.989856],
    [2873, -10.660554, 10.441522, 7.071858],
    [2874, 7.331446, 14.521520, -2.842144],
    [2875, 12.079440, -0.842478, -11.234144],
    [2876, 2.585448, -11.520480, 11.551856],
    [2877, -15.642556, 3.569522, 3.935856],
    [2878, 2.369446, -7.924478, -14.302146],
    [2879, -8.288554, 11.831522, 8.023858],
    [2880, -14.434556, -6.946478, -4.066144],
    [2881, 2.653446, -15.846480, -3.872144],
    [2882, -4.614554, 11.429524, -11.010144],
    [2883, -10.332554, 2.379522, 12.677842],
    [2884, 5.877448, 15.385504, 1.395856],
    [2885, -13.050554, -7.188478, -7.162144],
    [2886, 7.251446, -12.774478, -7.586144],
    [2887, 4.923446, -15.354478, 3.663856],
    [2888, -9.490554, 10.373524, 8.703858],
    [2889, -3.088554, -16.180479, -1.576144],
    [2890, -3.612554, 8.681522, -13.624144],
    [2891, 8.301446, -13.048480, -5.906144],
    [2892, -5.636554, 13.685522, 7.421856],
    [2893, 14.439424, 5.829524, -5.632144],
    [2894, -8.760554, -13.552478, -3.716144],
    [2895, -1.900554, -1.901276, 16.345840],
    [2896, 16.475435, 1.333522, -1.102144],
    [2897, 11.963442, 9.833522, 5.891858],
    [2898, -6.832554, 6.201522, -13.762144],
    [2899, -10.160554, -13.070478, 0.763856],
    [2900, -0.554554, -14.564478, -7.890144],
    [2901, -7.316556, 13.095496, -7.052144],
    [2902, -2.102554, 15.809514, -4.518144],
    [2903, 8.919446, -13.378480, -4.030144],
    [2904, -10.574554, 11.633522, -5.262144],
    [2905, -4.762554, 13.023504, 9.097856],
    [2906, 9.747852, 5.696726, 12.149856],
    [2907, -16.448553, 1.439522, -1.580142],
    [2908, 13.825442, 8.997522, 1.741856],
    [2909, 14.993440, 3.201522, -6.332144],
    [2910, 14.887422, 1.319522, -7.200144],
    [2911, -0.666554, 6.879522, -15.082144],
    [2912, 12.715426, 10.585524, 1.233856],
    [2913, 1.155448, -2.388478, -16.378145],
    [2914, 7.429040, -3.854478, 14.327836],
    [2915, 2.885446, 16.337500, -0.450144],
    [2916, -6.724554, 14.041510, 5.763856],
    [2917, 4.129446, -13.210478, -9.170146],
    [2918, 7.223446, 5.041522, -14.084144],
    [2919, 10.583040, 0.649116, 12.789840],
    [2920, 3.903446, 13.137518, 9.393856],
    [2921, -10.150554, -6.324478, 11.535856],
    [2922, -9.658554, 13.509496, 0.569856],
    [2923, 3.327446, 15.583502, -4.712142],
    [2924, -2.326554, 15.001502, -6.760144],
    [2925, -6.824554, -9.184478, 12.055832],
    [2926, 12.447420, -6.708478, -8.738144],
    [2927, -6.192554, -5.074478, -14.580144],
    [2928, -13.326556, -5.106478, 8.545856],
    [2929, -12.974554, 10.201522, 2.089858],
    [2930, -6.506554, 11.253522, -10.386144],
    [2931, 3.019448, 6.463522, -15.032144],
    [2932, 2.943448, 0.553522, -16.374144],
    [2933, 7.587446, -14.064478, 4.661856],
    [2934, 1.187446, 16.395514, 2.627858],
    [2935, 12.319430, 7.597522, -8.226144],
    [2936, 8.167446, -7.596478, -12.360144],
    [2937, -0.608146, -7.274078, 14.963852],
    [2938, 14.213442, 2.961524, -8.150144],
    [2939, 0.999446, -13.934478, -9.058144],
    [2940, 11.411448, 4.791522, 11.137858],
    [2941, -14.298556, 6.157522, 5.905858],
    [2942, -15.614556, 2.285522, -5.316144],
    [2943, 10.879446, 5.307522, -11.436144],
    [2944, -16.650555, -0.086478, 0.303856],
    [2945, -8.482554, 14.299506, -0.956144],
    [2946, -6.526554, -11.462478, 10.169858],
    [2947, 5.597446, -2.940478, -15.414144],
    [2948, -5.132554, -14.882478, 5.453858],
    [2949, 3.027446, -3.030478, -16.106144],
    [2950, 0.869446, 16.635504, -0.702144],
    [2951, -6.683754, 2.513524, 15.067856],
    [2952, 16.415438, -2.270478, -1.880144],
    [2953, 12.147432, 9.991522, -5.552144],
    [2954, -10.266554, -8.000478, 10.435858],
    [2955, -15.364556, -5.146478, -3.974144],
    [2956, 16.541445, 1.067522, 1.923856],
    [2957, 10.873448, -12.658478, -0.128144],
    [2958, 10.611446, 10.765522, 7.071858],
    [2959, -16.230555, 1.543522, -3.566144],
    [2960, -5.346154, -8.600078, 13.269852],
    [2961, 15.063418, 6.935522, -1.942144],
    [2962, -1.924554, -2.778478, -16.352144],
    [2963, 3.965446, 14.869512, -6.480144],
    [2964, 1.517852, -0.804072, 16.609848],
    [2965, -13.188554, -8.026478, 6.363858],
    [2966, 3.905448, 15.579504, 4.571858],
    [2967, 14.345430, -8.158478, -2.574144],
    [2968, 11.415448, 9.197524, 8.011856],
    [2969, 6.173446, 1.793522, -15.422144],
    [2970, -13.032554, -1.996478, 10.263856],
    [2971, 7.685446, 6.765522, -13.206144],
    [2972, -15.876554, 4.983522, -1.530144],
    [2973, -2.846554, -9.014478, -13.780144],
    [2974, 5.707448, -4.886478, -14.928144],
    [2975, -8.536554, 5.037524, 13.457840],
    [2976, 8.453448, -14.158478, 2.769858],
    [2977, 1.303446, -14.148478, 8.821858],
    [2978, 11.715426, 6.685522, -9.890144],
    [2979, 6.815446, 7.232318, 13.455856],
    [2980, 12.237428, 11.087522, -2.682144],
    [2981, -14.562556, 4.453522, 6.927856],
    [2982, 7.683446, -13.348478, 6.535856],
    [2983, -13.104556, 8.811524, 5.533858],
    [2984, -0.479352, -9.982480, 13.433854],
    [2985, 8.793042, -0.962886, 14.221848],
    [2986, -13.320554, 8.407522, -5.696144],
    [2987, 4.665448, 5.337522, -15.176144],
    [2988, -10.556554, -11.470478, -6.130144],
    [2989, 4.777446, 16.013494, -1.186144],
    [2990, -11.570554, -11.282478, -4.416144],
    [2991, 10.839448, -7.342478, -10.456144],
    [2992, 15.515444, -4.068478, -4.848144],
    [2993, 13.397432, 8.653522, 5.141858],
    [2994, 0.813446, -16.408478, -3.306144],
    [2995, 11.275446, 11.515522, -4.592144],
    [2996, 15.403444, -4.616478, 4.717858],
    [2997, 9.081448, 12.031522, 7.321858],
    [2998, -8.960554, 9.517522, 10.491858],
    [2999, -11.378554, 7.121522, 10.039856],
    [3000, -3.786554, 16.289495, 1.141858],
    [3001, -3.964554, -13.308478, -9.390144],
    [3002, 12.943422, -10.574478, -1.310144],
    [3003, -4.702956, -4.107678, 15.563828],
    [3004, -16.054554, -0.088478, -4.852144],
    [3005, -3.036554, -14.854478, 7.173856],
    [3006, -13.412554, 7.067522, -7.176144],
    [3007, 9.473040, -12.331678, 6.296654],
    [3008, 16.041445, -4.794478, 1.137856],
    [3009, 9.565446, 12.655524, 5.473856],
    [3010, -4.380554, -14.386478, -7.450144],
    [3011, -0.176554, 16.177496, 4.469856],
    [3012, 10.693448, 12.899512, -0.992144],
    [3013, -6.324554, 5.783928, 14.433854],
    [3014, -14.874554, -7.392478, 2.427856],
    [3015, -2.251350, -3.859678, 16.187851],
    [3016, 5.309446, -7.958478, -13.802146],
    [3017, 12.701418, 10.963522, -0.730144],
    [3018, -12.578554, -10.950478, 1.983856],
    [3019, -10.688554, 5.949522, 11.509858],
    [3020, -9.056554, -5.334478, 13.101852],
    [3021, 2.669040, 14.323522, 8.359452],
    [3022, 3.635446, 16.157507, -2.814144],
    [3023, -5.620554, 7.793522, -13.782144],
    [3024, 7.627448, -12.410478, 8.379856],
    [3025, -12.630554, 10.741522, -2.746144],
    [3026, -5.562152, 4.153116, 15.305832],
    [3027, -3.076554, 7.209522, -14.872144],
    [3028, -3.718554, 3.085928, 16.103836],
    [3029, -6.654554, 4.355522, -14.814144],
    [3030, -14.160554, 3.899522, -8.190144],
    [3031, -10.274554, -1.590476, 13.219834],
    [3032, 0.165040, 3.555930, 16.437851],
    [3033, -10.428554, -11.580478, 6.331856],
    [3034, -15.710554, -3.406476, -4.964144],
    [3035, -15.592554, -1.728478, -6.080144],
    [3036, 2.879446, -15.494478, -5.896144],
    [3037, 6.529446, -11.880478, 9.973856],
    [3038, 3.239446, 14.303504, -8.262144],
    [3039, -7.498554, 1.309522, -15.016144],
    [3040, -5.976554, 14.401494, -6.352144],
    [3041, -15.314554, 5.539522, 4.283858],
    [3042, -5.124554, 1.407522, -15.980144],
    [3043, 12.491426, -2.110478, 11.095858],
    [3044, 2.490650, 9.881524, 13.409836],
    [3045, -9.882556, 7.869522, 11.139856],
    [3046, 6.493446, 11.391524, -10.572144],
    [3047, 11.401448, -9.554478, 7.901858],
    [3048, 0.723446, -11.273678, 12.495834],
    [3049, 9.233446, -4.096076, 13.483840],
    [3050, 3.991040, -10.511278, 12.547836],
    [3051, -11.200554, -12.368478, 2.331856],
    [3052, 4.605852, -5.680478, 15.181838],
    [3053, -13.942554, -6.304478, 7.059856],
    [3054, -7.534554, 14.545508, 3.973856],
    [3055, -4.804554, 4.315524, -15.572144],
    [3056, -7.750556, -13.968480, -5.386144],
    [3057, 2.142242, 3.861116, 16.271835],
    [3058, 3.791446, -16.408478, -0.836144],
    [3059, 4.394650, 10.062726, 12.805832],
    [3060, 13.675448, 2.623522, 9.521856],
    [3061, 13.275424, 3.867524, -9.664144],
    [3062, 5.646244, -9.380078, 12.835830],
    [3063, 1.237446, 5.903522, -15.756144],
    [3064, -13.864554, -5.146478, -8.120144],
    [3065, -0.168554, 12.125522, 11.731858],
    [3066, -10.438554, 9.381524, -9.368144],
    [3067, -15.884554, 3.897522, -4.168144],
    [3068, -1.128554, -16.414478, -3.784144],
    [3069, -4.698554, -15.988478, -2.756144],
    [3070, 3.307446, -16.300478, 2.963856],
    [3071, -10.140554, 5.079524, -12.522144],
    [3072, -0.068554, -12.610478, 11.243856],
    [3073, -3.710554, 2.781522, -16.248144],
    [3074, -2.350554, -14.280478, -8.726144],
    [3075, -1.819352, 3.756726, 16.377853],
    [3076, -10.798554, -0.610478, -12.988144],
    [3077, 7.131446, 9.431522, -12.096144],
    [3078, -0.842554, 15.205512, 7.371856],
    [3079, -9.042554, -10.656478, -9.536144],
    [3080, 9.127854, -8.589678, 11.367856],
    [3081, -1.032554, -7.380478, -15.192144],
    [3082, -6.353354, -4.988078, 14.869858],
    [3083, -8.052554, -4.098478, 14.311844],
    [3084, 13.771426, -1.336478, -9.750144],
    [3085, -12.928554, -2.350478, -10.678144],
    [3086, 5.325448, -0.898478, -16.048145],
    [3087, -3.786554, 15.801520, 4.763856],
    [3088, -15.048556, -2.618478, 7.311858],
    [3089, 11.807436, -5.620478, -10.760144],
    [3090, -2.936554, 16.587500, -1.786144],
    [3091, -2.624554, -15.216478, -6.972144],
    [3092, -2.553756, 6.307522, 15.515854],
    [3093, -1.138554, 16.879522, -0.946144],
    [3094, -14.524556, 7.583522, -4.324144],
    [3095, 13.093446, -8.874478, -6.088144],
    [3096, -9.342554, -1.948478, -14.008144],
    [3097, -12.996554, -10.352478, -3.352144],
    [3098, 9.211446, 0.923524, -14.204144],
    [3099, -3.000554, 12.615522, -10.926144],
    [3100, -7.820554, -12.528478, -8.332144],
    [3101, -6.662554, -14.164478, 6.527856],
    [3102, 11.301446, 0.345522, -12.648144],
    [3103, 7.681446, 8.835118, 12.279830],
    [3104, 1.329446, 16.029516, -5.408144],
    [3105, -12.976554, 1.669524, 10.807858],
    [3106, -14.874554, 2.053522, -7.910144],
    [3107, 14.787446, 7.747522, 3.057856],
    [3108, -4.679754, -6.067678, 15.143844],
    [3109, -8.611354, 1.641928, 14.533828],
    [3110, 13.459444, -9.868478, -3.104144],
    [3111, -10.004554, -3.584478, 13.237838],
    [3112, -3.811350, -2.500478, 16.353836],
    [3113, 5.643446, -11.066078, 11.573856],
    [3114, 14.617434, -6.600478, -5.572144],
    [3115, -12.122554, 8.251522, 8.559856],
    [3116, 8.341446, 5.946726, 13.543838],
    [3117, 5.279446, 12.801524, -9.830144],
    [3118, -16.460554, -0.512478, 4.143856],
    [3119, -16.494555, 3.273524, -2.372144],
    [3120, 7.985446, 13.849524, 5.739856],
    [3121, -16.616554, 3.505522, -0.392144],
    [3122, -13.772554, -3.534478, -9.302146],
    [3123, -3.412554, -0.521680, 16.637833],
    [3124, -2.084554, -15.862478, 5.735858],
    [3125, -8.580554, -9.590478, 11.105856],
    [3126, 4.809040, -7.956478, 14.231858],
    [3127, 10.773448, -8.154478, 10.315856],
    [3128, -13.518554, 9.493522, -4.026144],
    [3129, 2.095446, -16.774479, -1.824144],
    [3130, 15.655428, 6.357522, 1.899856],
    [3131, 14.893434, -8.190478, -0.652144],
    [3132, -8.872554, -0.068478, -14.512144],
    [3133, 7.901448, 10.329524, 10.967858],
    [3134, -1.298554, 16.709509, -2.928144],
    [3135, -12.006554, -10.312480, 6.243856],
    [3136, -8.086554, -14.604478, 3.287858],
    [3137, -13.014554, -10.866478, -1.428144],
    [3138, 8.146244, 2.400320, 14.753830],
    [3139, 8.001446, 14.521520, 3.863858],
    [3140, 10.227448, 10.397522, -8.782144],
    [3141, -14.856554, -2.600478, -7.898144],
    [3142, 15.667422, 5.723522, -3.420144],
    [3143, 8.639446, -11.140478, 9.551856],
    [3144, 14.515444, 0.327522, -8.900144],
    [3145, -13.492554, 5.729522, -8.670144],
    [3146, 3.462244, 0.195116, 16.675858],
    [3147, -14.424554, 0.469522, -9.046144],
    [3148, -11.980554, 8.933524, -8.172144],
    [3149, -8.814554, -14.570478, 0.443858],
    [3150, -2.232554, -11.880478, -12.006144],
    [3151, 0.657446, -8.956478, -14.480144],
    [3152, -11.066556, -12.858478, -1.594144],
    [3153, -4.158554, -14.084478, 8.643856],
    [3154, -1.102554, -15.302478, 7.417856],
    [3155, -15.896554, -2.756478, 5.499856],
    [3156, -14.446554, 7.943524, 4.331856],
    [3157, 10.343446, -13.310478, -2.542142],
    [3158, 11.395446, 11.595522, 5.129856],
    [3159, -16.176554, -3.926478, 3.683856],
    [3160, 11.133448, 3.339524, 12.475846],
    [3161, 8.365446, 13.545508, -6.108144],
    [3162, 5.045446, -11.268478, -11.764144],
    [3163, -3.382554, -4.136478, -16.202145],
    [3164, -8.728554, 12.187522, -8.146144],
    [3165, -7.494554, 7.959522, -13.098144],
    [3166, -9.346554, 12.685522, 6.559856],
    [3167, 6.270648, 10.252320, 12.121842],
    [3168, 11.657446, 2.281522, -12.268144],
    [3169, 9.737446, 13.535498, 3.693858],
    [3170, -8.756554, 6.339524, -13.222146],
    [3171, 0.045446, 13.899512, -9.926144],
    [3172, 7.525040, -10.568878, 11.111856],
    [3173, -7.100554, -15.530478, -0.440144],
    [3174, 7.605446, -11.744478, -9.800144],
    [3175, 5.971446, 15.635504, 3.423856],
    [3176, 11.193448, -1.776478, -12.786144],
    [3177, -1.780554, 15.981512, 5.783858],
    [3178, 6.877448, -15.308480, 3.223856],
    [3179, -7.106554, 15.289496, -2.796144],
    [3180, -11.930554, 7.553522, -9.630144],
    [3181, 16.135439, -5.596478, -0.694144],
    [3182, -6.190554, -12.824478, -9.454144],
    [3183, -8.318554, 3.083522, -14.612144],
    [3184, -5.641354, 7.799116, 14.129838],
    [3185, -12.938554, 10.407522, 4.077856],
    [3186, 16.259432, 2.881524, 4.437856],
    [3187, -3.964954, -10.380878, 12.995834],
    [3188, 12.103426, 1.659524, 11.963852],
    [3189, -16.876554, -0.154478, -2.746144],
    [3190, 0.925446, 11.811524, -12.330144],
    [3191, -3.664148, -8.544076, 14.351852],
    [3192, -12.328554, 10.685522, -5.124144],
    [3193, -3.316554, 0.893522, -16.752144],
    [3194, -12.576556, -0.564478, -11.574144],
    [3195, 9.882244, 2.358724, 13.761856],
    [3196, 4.263446, -16.336479, -2.796144],
    [3197, -13.436554, 1.417522, -10.504144],
    [3198, 12.795442, 10.861522, 3.347856],
    [3199, -8.872554, 14.341498, -2.916144],
    [3200, 14.163424, -4.712478, -8.376144],
    [3201, -10.252554, 0.667522, 13.689834],
    [3202, -7.553354, -7.757678, 13.257828],
    [3203, -14.084554, 2.785522, 9.323856],
    [3204, 9.487446, 9.109522, 10.957858],
    [3205, -0.642960, 7.154726, 15.539840],
    [3206, 15.757418, 4.473522, -4.980144],
    [3207, 11.097446, 6.773524, 11.141858],
    [3208, -13.960554, -0.016478, 9.913856],
    [3209, 1.345446, -11.338478, -12.762144],
    [3210, 6.044242, -2.366478, 15.847854],
    [3211, 13.273440, -10.678478, 1.767856],
    [3212, -12.264554, -9.074478, 7.787858],
    [3213, -15.836554, -0.990478, 6.455856],
    [3214, -5.180554, -12.934478, 9.965856],
    [3215, -2.137756, 8.291930, 14.839828],
    [3216, -14.228554, -1.478478, -9.430144],
    [3217, 15.033418, -4.928478, -6.578144],
    [3218, -11.472556, 2.969522, -12.376144],
    [3219, -15.376554, 4.701522, -5.930144],
    [3220, 13.683444, -7.348478, -7.244144],
    [3221, -10.438554, 11.485524, -7.270144],
    [3222, 15.383424, 1.255522, 7.453858],
    [3223, 10.597446, -1.256070, 13.419846],
    [3224, 16.243441, 2.309522, -4.984144],
    [3225, -14.264554, 9.507522, 0.475856],
    [3226, 0.561448, 10.293928, 13.705856],
    [3227, -15.114556, -7.996480, -1.318144],
    [3228, 9.595448, -8.686478, -11.252144],
    [3229, -1.956554, 13.919500, -9.828144],
    [3230, 9.385446, -4.174478, -13.736146],
    [3231, -6.930554, 15.525518, 2.277856],
    [3232, -5.804554, 13.865514, -8.266144],
    [3233, 12.323428, -10.798480, 5.089858],
    [3234, -15.666556, -6.516478, -2.552144],
    [3235, 4.581852, 8.585524, 14.135848],
    [3236, -7.252554, -15.476478, 1.559856],
    [3237, -14.204554, -9.490478, 1.659856],
    [3238, 0.405448, 14.705512, 8.843856],
    [3239, -2.619756, 10.313928, 13.469834],
    [3240, 13.893434, 9.883522, -1.998144],
    [3241, 3.303446, 12.119522, 11.705856],
    [3242, 15.555422, -1.864478, 7.027856],
    [3243, -6.640554, -15.658478, -2.378144],
    [3244, -15.154554, 2.679522, 7.639856],
    [3245, -9.188554, -7.982478, 12.127854],
    [3246, 8.135446, -15.130478, -0.384144],
    [3247, 8.713448, -14.606478, -2.466144],
    [3248, -0.442148, -3.314878, 16.857834],
    [3249, -1.862554, -11.295278, 12.823838],
    [3250, 8.957448, 8.643522, -11.858144],
    [3251, -1.868554, 2.385522, -16.926144],
    [3252, -8.400554, -14.896478, -1.814144],
    [3253, -2.162554, 16.609503, 3.919858],
    [3254, 11.361446, -11.566478, -5.752144],
    [3255, -3.022554, -7.574478, -15.148144],
    [3256, 4.474244, 6.847116, 15.135848],
    [3257, 16.507418, 4.707524, 1.163856],
    [3258, 16.569429, -1.122478, 4.503856],
    [3259, -10.678554, 12.839524, 4.153856],
    [3260, -16.742554, -3.778478, -1.288144],
    [3261, 0.933446, -7.306478, -15.558144],
    [3262, -0.650554, 16.175512, -5.854144],
    [3263, 3.384650, -9.342478, 14.057846],
    [3264, 14.983430, 7.539522, -3.880144],
    [3265, -14.660554, 8.641524, -2.614144],
    [3266, -1.044554, -5.672478, -16.224144],
    [3267, 16.167421, 0.219522, 5.939858],
    [3268, 13.969424, 1.981522, -9.884144],
    [3269, 16.035433, -1.204478, -6.186144],
    [3270, -10.260554, -3.606478, -13.364144],
    [3271, -12.712554, -10.180480, -5.640144],
    [3272, 15.185426, -6.622478, 4.755858],
    [3273, -2.330554, -13.438478, -10.538146],
    [3274, -2.406554, 4.279522, -16.524145],
    [3275, 2.961446, -15.398478, 7.169858],
    [3276, 11.887422, 9.543522, -8.056144],
    [3277, 3.281040, 2.229116, 16.779831],
    [3278, 8.691446, 11.355522, -9.636144],
    [3279, 10.610650, 7.776726, -11.150546],
    [3280, -12.848554, -6.982478, -9.148144],
    [3281, 12.283418, -8.100478, 9.005858],
    [3282, -1.038554, 11.595522, -12.732144],
    [3283, 6.841446, 15.129522, -4.688144],
    [3284, -6.134554, -13.758478, 8.411858],
    [3285, -3.962554, -12.504478, -11.210144],
    [3286, 15.089418, -5.094478, 6.643856],
    [3287, 3.327446, 8.409524, -14.700144],
    [3288, 6.139446, -13.272478, -9.168144],
    [3289, -15.646554, -4.992478, 5.311858],
    [3290, -16.682554, -1.860478, -4.036144],
    [3291, -7.128554, 14.985510, -4.772144],
    [3292, -10.674554, -12.994478, -3.928144],
    [3293, -13.000556, 3.669524, 10.759858],
    [3294, -8.456554, 8.375522, 12.515854],
    [3295, -7.849354, 6.886320, 13.763840],
    [3296, -3.834554, -16.832478, 0.687856],
    [3297, -14.002554, -9.062480, -4.510144],
    [3298, -10.386554, 4.361522, 13.101852],
    [3299, -2.442554, -16.274479, -5.288144],
    [3300, 8.239446, 11.771522, 9.609858],
    [3301, -12.828554, -3.862478, 10.923856],
    [3302, -2.796554, -1.026478, -17.032145],
    [3303, 5.257446, 7.909524, -14.452144],
    [3304, 4.847446, -15.282478, 6.485858],
    [3305, -7.156554, 12.755524, -9.236146],
    [3306, 9.256242, 7.598320, 12.483840],
    [3307, -13.982554, 10.089524, -1.422144],
    [3308, -6.834554, 13.073522, 9.045856],
    [3309, 16.793428, 3.307522, 2.553856],
    [3310, -14.096554, -3.482478, 9.415858],
    [3311, 12.369448, 3.959522, -11.438144],
    [3312, 14.395418, -8.546478, 4.403856],
    [3313, 7.643446, 3.129522, -15.216144],
    [3314, 13.883424, -3.334478, -9.796144],
    [3315, 7.763446, 15.341498, 2.049856],
    [3316, -13.622554, -10.110478, 3.469856],
    [3317, 5.909446, -16.192478, -1.670144],
    [3318, 14.177432, 7.477522, 6.563856],
    [3319, 16.929445, 2.549522, -2.626144],
    [3320, -12.058554, -8.038478, 9.485858],
    [3321, 14.291444, -8.690478, -4.504144],
    [3322, -10.394554, -7.330478, -11.760144],
    [3323, -1.294554, -17.214478, 1.475856],
    [3324, -15.462554, -0.696478, -7.790144],
    [3325, -0.646146, 5.386726, 16.457840],
    [3326, -15.164554, -0.894478, 8.339858],
    [3327, 11.893832, -8.554078, -9.256544],
    [3328, 8.681446, 14.369512, -4.306144],
    [3329, -4.092554, 9.141118, 14.145828],
    [3330, 12.917422, -0.202478, 11.557858],
    [3331, 8.823446, 14.917516, 0.403856],
    [3332, 15.139436, 8.429524, -0.628144],
    [3333, 7.741448, 13.473516, 7.693858],
    [3334, 2.723446, -1.306478, -17.080145],
    [3335, 9.871446, -14.238478, -0.836144],
    [3336, -4.592554, 10.519524, -13.006144],
    [3337, -10.060554, 3.467522, -13.704144],
    [3338, 0.423446, 8.745524, 14.979844],
    [3339, 16.225435, -2.886478, 5.435856],
    [3340, -0.500554, -1.700478, -17.264145],
    [3341, 6.229446, -13.830478, 8.439858],
    [3342, -9.700554, -13.232480, -5.668144],
    [3343, 11.467448, 12.581522, 3.395856],
    [3344, 14.945436, -1.090476, 8.763856],
    [3345, -4.226554, -2.386478, -16.668144],
    [3346, -11.104556, -10.692478, 7.991858],
    [3347, 16.071444, -5.516478, -3.592144],
    [3348, 10.419446, -10.070478, 9.573856],
    [3349, -5.476554, 16.481512, 0.091856],
    [3350, 8.035446, 13.137518, -8.036144],
    [3351, 6.343446, 0.583930, 16.161850],
    [3352, -9.648554, -13.776478, 4.367856],
    [3353, -11.166554, 6.535522, -11.600144],
    [3354, 4.415448, -16.114479, -4.780144],
    [3355, 15.373446, -7.538478, 2.983856],
    [3356, 11.071448, 11.657522, -6.606144],
    [3357, -6.050554, -3.580478, -15.896144],
    [3358, -3.991354, 5.067116, 16.141830],
    [3359, 13.149446, 7.571522, 8.483856],
    [3360, 12.324648, -4.049678, 11.573856],
    [3361, 10.095448, -7.044478, -12.278144],
    [3362, -8.341354, 3.601116, 14.835830],
    [3363, 14.495424, -7.002478, 6.595856],
    [3364, -7.810554, 13.671514, 7.407856],
    [3365, -17.302555, 1.809522, 0.399856],
    [3366, -0.326554, -12.500478, -12.102144],
    [3367, 7.597446, -5.480478, -14.668144],
    [3368, 1.803446, 17.285498, 0.941856],
    [3369, 17.063448, -3.100478, 1.483856],
    [3370, 2.441852, 8.602320, 14.939834],
    [3371, 4.877448, 0.951522, -16.690144],
    [3372, -0.253352, -1.384884, 17.357834],
    [3373, -9.836554, -14.172478, 2.417856],
    [3374, 0.191446, -17.344477, -1.620144],
    [3375, -16.988554, 2.787524, 2.669858],
    [3376, 6.179448, 15.369512, 5.395856],
    [3377, -5.860554, -15.796478, -4.436144],
    [3378, -4.496554, 10.823522, 12.893844],
    [3379, 1.253446, 0.211522, -17.380144],
    [3380, 9.409446, 14.467504, -2.442144],
    [3381, 6.959852, 5.622726, 14.959854],
    [3382, -17.194555, 0.799522, 2.763856],
    [3383, 6.797448, -9.998478, -12.560144],
    [3384, -4.842554, -16.262478, 4.033858],
    [3385, 6.479446, -14.700478, -6.790144],
    [3386, 15.865420, -6.916478, -2.170144],
    [3387, 1.009446, -15.782478, 7.359858],
    [3388, -6.132154, -7.323678, 14.595840],
    [3389, -15.614556, -7.752478, 0.607856],
    [3390, 0.305446, 0.582320, 17.433853],
    [3391, -15.764554, 0.781522, 7.433856],
    [3392, 5.531446, -16.420479, 2.051856],
    [3393, 1.649446, -17.214478, 2.325858],
    [3394, 6.611446, 11.863524, 10.955856],
    [3395, -12.860554, 11.765522, 0.857856],
    [3396, 0.777446, 10.561524, -13.876144],
    [3397, 14.409426, -4.920478, 8.539856],
    [3398, 0.593446, 17.257515, -2.582144],
    [3399, -4.992554, -0.534478, -16.724144],
    [3400, 1.753446, 11.661116, 12.879838],
    [3401, 3.865446, -9.256478, -14.296144],
    [3402, 13.649446, -10.254478, 3.687856],
    [3403, 9.897448, -2.300478, -14.210144],
    [3404, 10.023448, 5.431522, -13.238144],
    [3405, 11.545852, -6.018078, 11.649856],
    [3406, 8.237852, -5.685678, 14.319840],
    [3407, 12.713442, -3.940478, -11.318144],
    [3408, 4.707448, -13.732480, 9.735858],
    [3409, 7.738244, -9.286878, 12.627854],
    [3410, 6.781040, -8.105678, 13.925858],
    [3411, 5.335448, 16.191504, -3.876144],
    [3412, 5.061448, 3.093524, -16.448145],
    [3413, -3.048554, -16.868479, -3.456144],
    [3414, 10.887448, -13.584478, 1.659856],
    [3415, -12.680554, -4.280478, -11.258144],
    [3416, -15.002554, 6.667522, -6.030144],
    [3417, -15.984554, 6.979522, -1.300144],
    [3418, -12.112554, 0.831522, 12.591842],
    [3419, -3.022554, -13.836480, 10.271856],
    [3420, -1.484554, 0.441522, -17.430145],
    [3421, 8.221446, -10.554478, -11.280144],
    [3422, -11.622554, -8.014478, -10.340146],
    [3423, 17.295443, -0.262478, -2.664144],
    [3424, 10.853446, -12.990478, -4.450144],
    [3425, 17.145418, 3.419524, -0.842144],
    [3426, 1.605446, 7.863524, -15.556144],
    [3427, -0.404554, 5.253522, -16.694145],
    [3428, 12.729434, -6.494478, 10.115856],
    [3429, -16.752554, -3.876478, -3.300144],
    [3430, 14.553438, 4.427522, 8.677856],
    [3431, 5.080650, 5.131930, 15.957840],
    [3432, -16.148554, 6.573522, 1.693858],
    [3433, -12.042554, -2.664478, -12.446144],
    [3434, -8.451754, -1.830886, 15.243850],
    [3435, 16.947420, -2.334478, -3.812144],
    [3436, 6.793448, 13.127508, 9.419858],
    [3437, 17.513430, -0.310478, -0.632144],
    [3438, -9.338554, 10.095522, -10.872144],
    [3439, -7.928554, -7.614478, -13.656146],
    [3440, -2.942554, 11.997522, 12.443832],
    [3441, -14.292554, 6.411522, 7.881856],
    [3442, -0.266554, 17.489508, 1.259858],
    [3443, -11.732554, -5.178478, 11.963852],
    [3444, 14.701418, -9.292478, 2.289856],
    [3445, -12.314554, 4.795522, -11.536144],
    [3446, -11.172554, 12.141524, 5.963856],
    [3447, 16.127443, -6.786478, 1.289856],
    [3448, 2.571446, 16.339514, 5.857856],
    [3449, 2.417446, -16.502478, 5.481858],
    [3450, -8.462554, -4.530478, -14.700144],
    [3451, -11.906556, -11.888480, 5.017856],
    [3452, 0.927446, -5.604478, -16.616144],
    [3453, 0.531446, 15.893500, -7.450144],
    [3454, -0.730554, -14.500478, -9.882144],
    [3455, 3.873446, 17.095495, 1.113858],
    [3456, 16.265444, -5.750478, 3.309856],
    [3457, -5.560554, 15.667516, 5.681856],
    [3458, 6.287446, -15.588478, 5.115856],
    [3459, 1.507446, 2.465522, -17.332144],
    [3460, 4.599448, 11.085524, -12.840146],
    [3461, 5.081446, -14.678478, -8.226144],
    [3462, 2.311448, 14.251502, -10.026144],
    [3463, 6.149446, 14.759496, 7.301856],
    [3464, -6.803754, -1.173274, 16.165848],
    [3465, 10.079446, -12.720478, -6.766144],
    [3466, -6.224554, 11.509524, 11.747848],
    [3467, -3.034554, 11.743522, -12.732144],
    [3468, -14.698554, -7.506478, -6.076144],
    [3469, 5.771446, 9.619522, -13.546144],
    [3470, -11.994554, 12.249524, -3.928144],
    [3471, -11.864554, -3.276478, 12.563828],
    [3472, 9.597446, -13.902480, 4.895856],
    [3473, 14.323428, 9.437522, -3.912144],
    [3474, -3.206554, 15.041510, -8.546144],
    [3475, 7.627448, -15.792478, 1.431856],
    [3476, -12.908554, 11.907522, -1.136144],
    [3477, -2.104554, 6.247522, -16.318144],
    [3478, 2.175446, 17.027502, -3.886144],
    [3479, 12.823428, 6.445522, 10.187856],
    [3480, 1.171852, -4.482478, 16.981857],
    [3481, 10.167446, 9.659524, -10.642144],
    [3482, -16.848555, -4.712478, 1.977856],
    [3483, 9.407446, -14.842478, 1.153856],
    [3484, 2.855446, -6.904478, -15.948144],
    [3485, -12.774556, 9.667522, 7.315856],
    [3486, -12.232554, -6.238478, -11.030144],
    [3487, 11.118244, -3.185678, 13.283828],
    [3488, 3.775446, -17.160477, 1.221856],
    [3489, -5.844554, -16.602478, 0.683858],
    [3490, -8.510554, 15.385504, 1.063856],
    [3491, -7.891754, -6.202078, 14.475846],
    [3492, 8.389852, 0.563116, 15.479844],
    [3493, 13.515444, 8.775522, -7.118144],
    [3494, -8.134554, -14.704480, 5.287858],
    [3495, -0.688960, -5.309278, 16.787857],
    [3496, 1.315446, 5.765928, 16.599838],
    [3497, -6.568554, -1.680478, -16.270144],
    [3498, 8.149446, 15.573522, -1.356144],
    [3499, 13.589418, -9.514478, 5.967858],
    [3500, 6.485446, 16.239508, -2.250144],
    [3501, 2.963446, -13.690480, 10.707858],
    [3502, 17.549440, -1.116478, 1.331856],
    [3503, -6.132554, 0.681928, 16.523849],
    [3504, -17.044554, 4.321522, 1.393856],
    [3505, 6.462650, -5.070078, 15.611832],
    [3506, 14.353426, 9.623522, 3.573856],
    [3507, -7.112154, -3.207678, 15.833848],
    [3508, 6.235446, -16.100479, -3.672144],
    [3509, 0.384650, -9.198478, 15.061844],
    [3510, 8.653446, -1.216478, -15.338144],
    [3511, 7.791446, -3.644478, -15.416146],
    [3512, -2.066960, -6.651678, 16.221848],
    [3513, 12.149446, -12.494478, -2.822144],
    [3514, 3.299446, 5.011522, -16.606144],
    [3515, 9.819446, 12.241524, -8.100144],
    [3516, -8.676554, -11.414478, 10.311858],
    [3517, -2.086554, 14.221502, 10.261856],
    [3518, -16.132557, 4.385522, 5.695856],
    [3519, -2.300554, 17.389502, 2.083856],
    [3520, -11.230554, -5.368478, -12.534144],
    [3521, -7.860554, -15.324478, -3.928144],
    [3522, -6.760554, -15.750478, 4.277856],
    [3523, -1.246554, -9.352478, -14.936144],
    [3524, 3.169446, -14.826478, 9.069856],
    [3525, -16.892555, 2.145524, 4.709856],
    [3526, -10.876554, 8.439522, -11.082144],
    [3527, -13.830554, -10.996480, 0.391858],
    [3528, -9.536554, -13.358478, 6.563856],
    [3529, 8.026244, -2.415276, 15.565842],
    [3530, -12.270554, 2.815524, 12.413834],
    [3531, 3.001446, 17.179510, 2.911856],
    [3532, -3.846554, 13.457494, 10.813856],
    [3533, -5.352554, -10.246480, -13.390144],
    [3534, -4.315354, 1.270726, 17.111832],
    [3535, -4.658554, -8.822478, -14.612144],
    [3536, 2.151448, -17.564476, 0.123856],
    [3537, 2.149446, -10.274478, -14.248144],
    [3538, 16.845430, 5.405524, -0.686144],
    [3539, -6.496554, 9.687522, -13.326146],
    [3540, -2.420146, -10.110478, 14.339828],
    [3541, 13.249422, 3.679522, 11.167856],
    [3542, -10.270554, -10.194478, 10.221858],
    [3543, -17.646555, -1.218478, -1.016144],
    [3544, -2.103352, -13.009678, 11.843856],
    [3545, -4.292554, 15.731512, -6.932144],
    [3546, -5.590554, 13.105504, -10.538146],
    [3547, 10.213854, -5.842878, 13.251846],
    [3548, -1.012554, 11.505118, 13.443832],
    [3549, 14.653444, 6.589524, -7.490144],
    [3550, 17.105440, -0.520478, -4.640144],
    [3551, -9.726554, -6.376478, -13.384144],
    [3552, -1.102554, 15.381506, -8.756144],
    [3553, -11.628554, 13.349524, 1.051856],
    [3554, 14.601442, -10.062480, 0.413856],
    [3555, 16.177431, 4.027524, 6.067856],
    [3556, 15.641420, 8.271522, 1.303856],
    [3557, -2.730554, 15.675512, 7.849858],
    [3558, -5.228554, -15.248478, 7.413856],
    [3559, 1.437446, 4.449522, -17.116144],
    [3560, 11.203448, -11.376478, -7.742144],
    [3561, 13.885438, -6.986478, 8.559856],
    [3562, -6.682554, 2.685522, -16.218145],
    [3563, 16.979433, 4.541522, -2.482144],
    [3564, 2.529446, 15.947516, -7.374144],
    [3565, -11.576554, 10.157522, 8.835858],
    [3566, 0.623446, 16.605503, 6.255858],
    [3567, 5.131446, -13.050478, -10.892144],
    [3568, -4.900554, 16.975500, -1.766144],
    [3569, -4.380554, -16.044479, -6.220144],
    [3570, -8.068554, -13.720478, 7.875856],
    [3571, 5.129446, 14.949500, -8.100144],
    [3572, -1.160552, 10.413522, -14.344144],
    [3573, -5.032554, -5.278478, -16.200144],
    [3574, 8.892244, -7.402478, 13.483840],
    [3575, -9.532554, 14.469518, 3.943858],
    [3576, -1.086554, -14.212478, 10.613858],
    [3577, 3.181446, -12.286478, -12.442144],
    [3578, 1.432650, 2.459928, 17.543839],
    [3579, -1.740554, -17.564476, -2.094142],
    [3580, 2.909446, -13.674478, -10.978144],
    [3581, -8.692554, 14.397498, 5.761856],
    [3582, -4.678554, 15.443518, 7.471858],
    [3583, 10.127448, 11.561524, 8.957858],
    [3584, -7.252554, -9.846478, -12.924144],
    [3585, -10.182554, -14.370478, -2.558144],
    [3586, 0.721446, -13.878480, -11.118144],
    [3587, 6.822650, 2.520726, 16.243851],
    [3588, 8.071448, 1.273522, -15.816144],
    [3589, -15.822554, 8.153522, 0.303856],
    [3590, 7.945446, -14.966478, -5.460144],
    [3591, -10.442554, -9.566478, -10.790144],
    [3592, -3.522960, -5.338078, 16.615829],
    [3593, -14.602554, 9.647522, 3.271856],
    [3594, -0.242554, 3.423522, -17.472145],
    [3595, 6.205446, -6.862478, -15.214144],
    [3596, 2.653446, 11.201522, -13.586144],
    [3597, 15.675448, -1.772478, -8.264144],
    [3598, 0.169446, 9.219522, -15.238144],
    [3599, -4.084554, -12.848478, 11.639856],
    [3600, 6.471040, 9.169930, 13.831832],
    [3601, -15.198554, -4.528478, 8.115856],
    [3602, -3.756554, 14.731512, 9.287858],
    [3603, -3.864554, 16.747503, -4.694144],
    [3604, -4.096554, 6.061524, -16.252144],
    [3605, -1.476552, -11.254478, -13.744144],
    [3606, -12.432554, -1.136478, 12.723832],
    [3607, -7.196554, 16.283514, -0.912144],
    [3608, 3.687852, -7.334078, 15.823838],
    [3609, -6.352554, 10.153522, 13.203842],
    [3610, 3.495448, 2.235524, -17.338144],
    [3611, 9.315446, -6.168478, -13.894144],
    [3612, 5.449446, -16.980478, 0.123856],
    [3613, 13.615420, 0.409524, -11.512144],
    [3614, -3.778554, -17.228477, 2.643856],
    [3615, -10.174554, 11.361522, -9.246144],
    [3616, 7.251446, -8.426478, -13.948144],
    [3617, 12.607424, -12.538478, 1.431856],
    [3618, 2.481448, 17.553505, -1.990142],
    [3619, 12.543428, -9.904478, -7.932144],
    [3620, -16.758554, -6.108478, 0.547858],
    [3621, -16.888554, 5.767522, 0.005856],
    [3622, 5.813446, 15.633520, -6.348144],
    [3623, -9.708554, 13.447516, -6.592144],
    [3624, 7.337446, 16.269506, 0.333856],
    [3625, 14.593446, 5.153522, -8.896144],
    [3626, 1.517446, 17.231512, 4.411856],
    [3627, -12.808554, -9.838478, -7.606144],
    [3628, 11.275446, -5.486478, -12.708146],
    [3629, -12.402554, -12.478478, -3.046144],
    [3630, -5.116154, 6.673522, 15.753830],
    [3631, -9.732554, 7.993522, -12.660144],
    [3632, -6.030554, 16.359503, 3.863858],
    [3633, 5.125040, -3.950078, 16.645828],
    [3634, -14.694556, 2.779522, -9.762144],
    [3635, 17.801424, 1.385522, 0.393856],
    [3636, 2.775446, 7.060320, 16.171829],
    [3637, -15.080554, -7.512478, 5.937856],
    [3638, -11.520554, 13.623510, -0.930144],
    [3639, 9.815446, -2.613276, 14.697830],
    [3640, 17.709444, -2.358478, -0.260144],
    [3641, -7.476554, -11.060478, 11.875840],
    [3642, -1.122146, 10.009524, 14.763840],
    [3643, -12.044554, -6.998478, 11.199858],
    [3644, -17.776554, -1.610478, 0.947858],
    [3645, 12.737428, -12.514478, -0.842144],
    [3646, 1.145446, 13.611516, 11.531856],
    [3647, 9.825448, 14.781500, 2.131856],
    [3648, -11.000556, 13.775518, -2.982144],
    [3649, 10.655448, -0.460478, -14.352144],
    [3650, 7.053446, -1.910478, -16.322144],
    [3651, -6.022554, 6.025522, -15.724144],
    [3652, 15.099428, -3.114478, 9.063856],
    [3653, 12.931428, -11.550478, -4.414144],
    [3654, -5.754554, 16.571508, -3.532144],
    [3655, 15.019442, 7.761522, -5.866144],
    [3656, -3.240554, -6.112478, -16.504145],
    [3657, -1.664554, 8.517522, -15.652144],
    [3658, 14.595430, 0.071522, 10.357856],
    [3659, 17.631441, -0.150478, 3.081856],
    [3660, -0.546554, -3.734478, -17.502144],
    [3661, 15.629426, 6.147522, 6.207858],
    [3662, 13.707430, -5.280478, -10.242144],
    [3663, 6.259448, 6.519522, -15.460144],
    [3664, 9.703448, -12.578478, 8.267856],
    [3665, -12.656556, 10.505524, -7.090144],
    [3666, -14.712554, -9.930480, -2.418144],
    [3667, 4.679448, -6.032478, -16.206144],
    [3668, -2.218960, 1.044320, 17.745834],
    [3669, 12.123446, 8.741522, -9.880144],
    [3670, -14.502554, -9.224478, 5.059856],
    [3671, 15.787446, -7.420478, -4.106144],
    [3672, 1.839040, -8.100478, 15.879838],
    [3673, 14.399446, -1.910478, 10.499856],
    [3674, -9.862554, 1.839524, -14.856144],
    [3675, -3.506554, -10.954478, -13.750144],
    [3676, 1.017446, -14.274478, 10.799856],
    [3677, -10.520554, -14.506480, -0.594142],
    [3678, 9.627448, -11.602478, -9.706144],
    [3679, -0.226552, -15.372478, 9.227858],
    [3680, 5.355446, 14.489508, 9.113858],
    [3681, -17.574554, -3.552478, 0.519856],
    [3682, -4.010554, -16.330479, 6.249856],
    [3683, -17.308554, -2.320478, 4.107856],
    [3684, -11.512554, 1.451522, -13.684144],
    [3685, -0.964554, -17.310476, 4.617856],
    [3686, -10.242554, 12.187522, 8.275856],
    [3687, -5.604554, -11.914478, -12.190144],
    [3688, -15.176554, -9.580478, -0.100144],
    [3689, -5.693754, 2.688726, 16.807846],
    [3690, 13.807436, -4.750478, 10.437856],
    [3691, 8.201446, 11.029522, -11.548144],
    [3692, 15.283418, 7.997522, 4.975856],
    [3693, -13.324554, 3.075524, -11.636144],
    [3694, -9.102554, -9.434478, -12.270144],
    [3695, -12.180554, 4.807522, 12.287858],
    [3696, 12.807436, -12.074478, 3.571858],
    [3697, -13.852554, -7.926478, 8.237856],
    [3698, -11.552556, -10.206478, -9.218144],
    [3699, 4.489446, -4.154478, -16.888144],
    [3700, 2.061448, 13.381506, -11.808144],
    [3701, 6.773448, -15.100480, 6.991858],
    [3702, -9.494554, -12.480478, 8.769858],
    [3703, 4.071448, 15.677496, 7.775856],
    [3704, -16.266554, 6.851522, -3.376144],
    [3705, 15.857424, 3.155524, 7.845858],
    [3706, 2.801446, -15.860480, -7.978144],
    [3707, -2.107352, -8.583278, 15.651046],
    [3708, 9.587446, 7.391524, -13.286144],
    [3709, 9.875040, 4.852726, 14.213852],
    [3710, 11.043448, 1.717522, -14.078144],
    [3711, 10.255042, 0.575116, 14.755844],
    [3712, 16.737429, 2.121522, 6.219856],
    [3713, 3.139852, -3.345278, 17.387833],
    [3714, -15.254554, 5.563522, -7.730144],
    [3715, 4.593446, -16.002478, -6.800144],
    [3716, -8.076554, -2.908478, -15.804144],
    [3717, -5.606554, 16.183508, -5.492144],
    [3718, -6.031352, -10.627678, 13.197830],
    [3719, -7.676554, -13.042478, 9.719856],
    [3720, -8.383754, 0.212318, 15.915848],
    [3721, -8.220554, 10.985524, 11.635856],
    [3722, 14.839418, -10.040478, -1.668144],
    [3723, 5.317446, 13.381506, 10.791856],
    [3724, 8.983446, 4.587522, -14.902144],
    [3725, -17.000557, 0.523522, 5.879856],
    [3726, -10.402554, 14.527502, 2.155858],
    [3727, -5.584554, 16.991522, 2.015856],
    [3728, -6.088554, -15.372478, -7.116144],
    [3729, 12.613436, 12.741524, -1.630144],
    [3730, 13.347444, 11.279522, -4.340144],
    [3731, 4.671852, -2.072884, 17.265854],
    [3732, 1.972648, -6.305278, 16.751846],
    [3733, -7.492554, -11.424478, -11.732144],
    [3734, 0.183446, 17.429510, -4.526144],
    [3735, -0.526554, -17.096479, -5.642144],
    [3736, -3.970554, 17.243505, 3.367856],
    [3737, 15.801424, 5.009524, -7.048144],
    [3738, -6.784554, -6.890478, -15.198144],
    [3739, -5.834554, 13.205512, 10.775856],
    [3740, -15.610554, -8.378480, -3.294144],
    [3741, 14.843446, 6.303522, 8.047858],
    [3742, 14.703432, 10.413522, 0.459856],
    [3743, 5.081040, 3.409930, 16.953842],
    [3744, -12.032554, -13.420478, 0.149856],
    [3745, 10.767446, 14.455512, 0.253856],
    [3746, 1.586648, -13.060878, 12.323838],
    [3747, 17.621431, -2.150478, 3.145856],
    [3748, 12.931428, 12.397522, 2.037858],
    [3749, 17.139437, -3.932478, 3.995858],
    [3750, 13.517428, -2.146478, -11.746144],
    [3751, -13.188554, 6.313522, -10.560144],
    [3752, 6.073852, -7.024478, 15.467850],
    [3753, 2.659852, -11.628480, 13.535842],
    [3754, -12.900554, 11.119522, 5.953858],
    [3755, 13.639436, 10.639522, 5.143856],
    [3756, 11.409446, 9.833522, 9.941856],
    [3757, 7.265446, 8.459522, -14.192144],
    [3758, 4.267446, -11.076478, -13.598144],
    [3759, 4.183446, -16.934479, 4.649856],
    [3760, 13.983430, 1.737522, 11.285856],
    [3761, -10.232554, 3.020726, 14.567856],
    [3762, -13.876554, 6.101522, 9.813856],
    [3763, -7.914554, 11.145524, -11.800144],
    [3764, -4.880554, -7.238478, -15.808144],
    [3765, 1.053446, -16.698479, -6.806144],
    [3766, -6.190554, -16.778479, 2.643856],
    [3767, -6.076554, 11.737522, -12.336144],
    [3768, -3.628554, 17.709509, -0.290144],
    [3769, 11.895418, -3.636478, -13.124144],
    [3770, -1.112554, -16.440479, -7.450144],
    [3771, 12.041444, 13.027502, -3.520144],
    [3772, -16.258554, -5.466478, -5.736144],
    [3773, -16.044554, 3.663522, -7.506144],
    [3774, 5.443448, 12.581522, -11.804144],
    [3775, -15.042554, 4.781522, 8.843856],
    [3776, 3.364242, 5.305116, 16.967850],
    [3777, -10.248554, -12.860478, -7.550144],
    [3778, -9.340554, 14.719518, -4.850144],
    [3779, -17.102554, -5.746478, -1.394144],
    [3780, 0.895446, -15.882478, -8.632144],
    [3781, -0.513352, 2.326726, 17.943832],
    [3782, 12.353426, 13.229498, 0.297858],
    [3783, -5.666554, -14.680480, -8.950144],
    [3784, 1.441446, -3.930478, -17.614145],
    [3785, 11.441446, -13.138480, 4.931856],
    [3786, -13.108554, 1.141522, -12.450144],
    [3787, 2.839448, -5.268478, -17.100145],
    [3788, 16.867434, -3.014478, -5.896144],
    [3789, 3.703042, -5.318478, 16.923843],
    [3790, 4.535446, -7.946478, -15.644144],
    [3791, -17.136555, 5.027524, -3.096144],
    [3792, 8.699446, -13.174478, -8.906144],
    [3793, 17.473421, -3.960478, -2.762144],
    [3794, 16.283419, 0.107522, -7.968144],
    [3795, -7.856554, -0.152478, -16.338144],
    [3796, 3.197446, 14.003516, 11.061858],
    [3797, -16.632557, 1.831522, -6.978144],
    [3798, -4.850554, 7.809522, -15.626144],
    [3799, -3.150554, 10.571524, -14.392146],
    [3800, 10.623042, -7.692878, 12.523850],
    [3801, 4.948244, 1.317522, 17.397842],
    [3802, -8.234554, 14.789496, -6.518144],
    [3803, 2.139446, 16.191504, 7.891858],
    [3804, 11.257446, -10.412478, -9.710144],
    [3805, 6.823446, -12.222478, -11.556144],
    [3806, 9.517040, -10.553678, 11.295856],
    [3807, -16.298555, 7.143522, 3.603858],
    [3808, -16.498154, -3.355678, -6.801744],
    [3809, -2.496554, 16.903509, -6.148144],
    [3810, -14.460554, -0.234478, -10.982144],
    [3811, 11.065446, 12.697524, 6.789856],
    [3812, -10.972556, 13.573522, -5.014142],
    [3813, -9.852954, 6.503116, 13.801834],
    [3814, -8.400554, -12.428478, -10.244144],
    [3815, -13.876554, 8.985524, -7.530144],
    [3816, -12.716554, 12.709522, 2.601856],
    [3817, 13.601442, 2.385522, -11.804144],
    [3818, 1.323446, -17.428476, -4.970144],
    [3819, 13.713442, 6.661522, -9.888144],
    [3820, 16.641420, 2.247522, -6.946144],
    [3821, 16.987429, 4.739522, 4.387858],
    [3822, -14.112554, 4.545522, -10.512144],
    [3823, 11.493852, 5.201930, 13.087844],
    [3824, -16.738554, -6.648478, 2.467858],
    [3825, 8.695446, -9.444478, -12.876144],
    [3826, 7.093446, 14.873510, -7.686144],
    [3827, -15.368556, -9.156478, 3.255856],
    [3828, -5.242154, -0.892884, 17.389847],
    [3829, 17.655428, -4.290478, -0.802142],
    [3830, -2.398554, -15.458478, 9.277856],
    [3831, 17.719423, 1.239524, -3.920144],
    [3832, 13.159426, -10.874478, -6.294144],
    [3833, -9.462554, 11.827522, 10.085858],
    [3834, 5.141040, 12.211524, 12.479844],
    [3835, 16.451418, 6.651522, 4.067856],
    [3836, -14.084554, -5.692478, -10.036144],
    [3837, -15.012554, -1.698478, 10.163856],
    [3838, 0.973446, 15.583502, -9.374144],
    [3839, -0.098554, -17.974476, 2.941856],
    [3840, 9.827446, -14.294478, -5.562144],
    [3841, -3.827350, -7.600478, 16.107834],
    [3842, -15.414554, 1.335522, 9.619856],
    [3843, -17.408554, 1.347522, -5.202144],
    [3844, 2.884650, -1.431680, 17.933853],
    [3845, -13.840556, 7.663522, -9.042144],
    [3846, -16.224554, -7.070478, 4.349858],
    [3847, -10.077354, -0.667274, 15.173844],
    [3848, -6.044554, -12.494478, 11.815842],
    [3849, 12.713442, -11.006478, 7.037858],
    [3850, -11.578554, -13.528478, 3.907856],
    [3851, 17.593447, 1.403522, 4.567856],
    [3852, 8.377448, -14.424478, -7.368144],
    [3853, 16.147432, -3.654478, -7.646144],
    [3854, -8.114152, 5.659524, 15.321854],
    [3855, 6.613448, 11.247522, -12.744144],
    [3856, -2.088148, -0.913680, 18.099838],
    [3857, -10.240554, 15.013494, -1.604144],
    [3858, -8.596554, 9.621522, -12.902144],
    [3859, 14.437440, -6.634478, -8.974144],
    [3860, -5.616954, -2.849278, 17.127853],
    [3861, -15.946554, 8.585524, 2.255856],
    [3862, -7.868556, -14.520480, -7.770144],
    [3863, 4.507446, 7.191522, -16.160145],
    [3864, -8.748554, 12.243522, -10.332144],
    [3865, 12.707826, -1.575276, 13.011856],
    [3866, 6.216650, 7.821522, 15.287858],
    [3867, -15.806554, -5.034478, -7.640144],
    [3868, -14.478554, 8.339524, 7.377858],
    [3869, -7.382556, 8.768726, 14.223832],
    [3870, 0.171852, -7.168078, 16.803848],
    [3871, -5.012554, 9.579524, -14.738144],
    [3872, 5.565446, 17.411505, 0.033856],
    [3873, 16.027437, -8.744478, 0.895856],
    [3874, 10.717448, 3.755522, -14.324144],
    [3875, 7.763446, -16.374479, -2.402144],
    [3876, -6.732554, 15.357520, 7.279856],
    [3877, 10.331448, 13.889502, -5.896144],
    [3878, 15.885438, 1.851522, -8.872144],
    [3879, 5.425448, -13.132478, 11.515858],
    [3880, 5.761446, -9.898478, -14.260146],
    [3881, 11.305446, -12.518478, 7.075858],
    [3882, -3.834554, 8.211524, 15.889846],
    [3883, 4.103446, 10.257522, -14.580144],
    [3884, -0.168554, -17.120478, 6.443858],
    [3885, -9.766554, 5.249524, -14.554144],
    [3886, 15.615420, 1.813522, 9.361856],
    [3887, -6.654554, -8.866478, -14.556144],
    [3888, 15.923434, 8.669524, -2.484144],
    [3889, -0.238554, 14.819494, 10.733856],
    [3890, 0.273448, -10.918478, -14.686144],
    [3891, -17.622555, 2.923522, -3.986144],
    [3892, -0.000554, 1.503522, -18.244144],
    [3893, 2.227446, 0.743116, 18.155838],
    [3894, -11.320554, -2.140478, -14.228144],
    [3895, -17.212555, 5.469522, 3.015856],
    [3896, -8.026554, 5.937522, -15.350146],
    [3897, -8.481754, -9.576078, 13.103836],
    [3898, -1.302554, 15.757514, 9.239856],
    [3899, 10.433446, -14.694478, 3.253856],
    [3900, -17.100555, -0.150478, -6.552144],
    [3901, -1.304554, 13.743506, 12.033828],
    [3902, -11.844554, -11.594478, -7.790144],
    [3903, 7.879446, 13.139502, -10.036144],
    [3904, 2.109446, 9.889522, -15.272144],
    [3905, -13.856554, -9.838478, 6.845856],
    [3906, 14.131442, 10.129522, -5.778144],
    [3907, -1.740554, 13.837500, -11.884144],
    [3908, 4.021446, 13.979498, -11.144144],
    [3909, 5.325448, -2.406476, -17.368143],
    [3910, 3.658650, -12.955678, 12.433854],
    [3911, 9.623448, 2.463522, -15.404144],
    [3912, 16.267427, -3.740478, 7.573856],
    [3913, 4.767446, 16.601507, 6.137858],
    [3914, 8.585854, 4.257522, 15.627854],
    [3915, 1.377040, -2.732070, 18.079849],
    [3916, -13.302556, -12.098478, 3.595856],
    [3917, 11.785432, 1.775522, 13.937850],
    [3918, -9.562152, -7.158478, 13.915848],
    [3919, -2.432148, 5.393928, 17.359848],
    [3920, -14.748554, -6.920478, -8.428144],
    [3921, 9.561448, 13.983496, 7.043858],
    [3922, -18.274555, 0.625522, -1.502144],
    [3923, 18.003420, 3.403522, 0.963856],
    [3924, 4.975446, 17.369513, 3.191856],
    [3925, 16.357424, 6.333522, -5.386144],
    [3926, 11.391448, 6.771522, -12.696144],
    [3927, -4.828554, 14.779516, -9.750144],
    [3928, -17.044554, 3.605522, -5.772144],
    [3929, -10.256554, -2.651276, 14.987838],
    [3930, 8.679448, -15.646478, 4.095856],
    [3931, 16.757418, -7.476478, -0.476142],
    [3932, 11.673446, 14.023504, 2.003856],
    [3933, -12.618556, 6.631524, 11.569856],
    [3934, 1.753446, 15.127508, 10.257856],
    [3935, -13.702554, -11.036478, 5.251856],
    [3936, -18.018555, -2.652478, -2.342144],
    [3937, 6.201446, -16.334478, -5.660144],
    [3938, 3.827446, -15.094478, -9.738144],
    [3939, -16.460554, -6.898478, -4.344144],
    [3940, 10.675448, 14.403510, -3.998144],
    [3941, -3.456554, 16.873510, 6.417856],
    [3942, -0.607352, -12.824478, 13.155838],
    [3943, 12.683444, 11.523524, 6.657856],
    [3944, 12.903444, -0.780478, -13.072144],
    [3945, -14.392556, -9.450478, -6.448144],
    [3946, -7.201754, 3.948318, 16.451828],
    [3947, -18.144554, 2.623522, -1.444144],
    [3948, -11.682554, 8.733522, 11.199858],
    [3949, -18.154554, -0.954478, 2.801856],
    [3950, 13.241426, -7.306478, -10.476144],
    [3951, -12.614554, 12.579524, 4.595856],
    [3952, 17.023439, 6.955522, 0.567856],
    [3953, 12.007418, 11.065524, 8.481858],
    [3954, -3.368554, -17.462477, 4.727856],
    [3955, -7.776554, 12.725522, 10.781856],
    [3956, 7.421446, 5.009524, -16.080145],
    [3957, -12.068554, 12.309522, -6.448144],
    [3958, -16.786554, 5.717522, -4.936144],
    [3959, 12.919436, 11.047524, -7.066144],
    [3960, 11.336650, 8.704726, 11.603450],
    [3961, 7.653852, -0.826070, 16.723831],
    [3962, 5.039446, -15.418478, 8.707858],
    [3963, -13.698554, -7.048478, 10.081858],
    [3964, -2.752148, 2.959116, 17.963852],
    [3965, 2.951446, 17.207495, -5.862144],
    [3966, -5.234554, -13.984478, -10.780144],
    [3967, 0.983852, 7.811118, 16.649857],
    [3968, -15.992554, 5.941522, 6.939858],
    [3969, -15.926554, -6.050478, 6.999856],
    [3970, 8.531446, -15.166480, 6.037858],
    [3971, 8.155448, -14.328478, 8.213858],
    [3972, -18.378553, 0.327522, 1.227856],
    [3973, 14.479434, 11.157522, 2.297858],
    [3974, -2.088960, -2.913678, 18.071854],
    [3975, -15.928554, 7.401522, 5.567856],
    [3976, -14.142556, -0.664478, 11.793838],
    [3977, -4.476554, 13.071508, -12.192144],
    [3978, -4.800554, 12.739522, 12.421830],
    [3979, -14.236556, 10.193524, -5.760144],
    [3980, -13.102554, -8.954478, -9.376144],
    [3981, -10.924154, -5.700478, 13.709854],
    [3982, 17.579439, 3.589524, -4.240144],
    [3983, -12.152554, -10.040478, 9.561858],
    [3984, -6.865354, -9.260478, 14.391830],
    [3985, 11.291446, 13.673498, 5.055856],
    [3986, 16.649446, -0.218478, 7.923856],
    [3987, 9.659446, 14.817510, 5.219856],
    [3988, 13.989442, -11.744478, -2.556144],
    [3989, 14.297426, 9.541522, 6.689858],
    [3990, 11.639446, -11.374478, 8.681856],
    [3991, -18.028555, -3.068478, 2.411856],
    [3992, 11.555446, -9.066478, -11.160144],
    [3993, -14.274556, -5.182478, 10.471858],
    [3994, -10.028554, 9.567522, 12.175858],
    [3995, -2.182554, -4.878478, -17.662144],
    [3996, 1.948244, -10.510478, 15.041854],
    [3997, 13.335420, 9.563522, 8.439858],
    [3998, 0.963446, -17.758476, 4.923856],
    [3999, 18.309420, 1.283522, -1.912144],
    [4000, -4.232554, -17.832478, -2.168144],
    [4001, 12.825442, 8.445522, 10.243856],
    [4002, 4.555446, -0.626478, -17.878145],
    [4003, 0.179448, 13.659522, -12.416144],
    [4004, -10.798554, -0.364478, -14.968144],
    [4005, -10.564554, -11.946478, -9.300144],
    [4006, 6.433446, 14.433508, -9.552146],
    [4007, -0.042552, 7.869522, -16.704144],
    [4008, 8.721446, 6.571522, -14.892146],
    [4009, 3.767446, 10.238320, 14.903854],
    [4010, -8.376554, 14.135504, -8.436144],
    [4011, 15.579440, -6.702478, -7.322144],
    [4012, 15.265444, 3.505522, -9.806144],
    [4013, 1.903446, -15.252478, -10.268144],
    [4014, 18.187441, 1.881524, 2.721858],
    [4015, -13.208556, -12.828478, 1.649856],
    [4016, -7.518554, 15.985510, 5.449856],
    [4017, 3.547448, 11.858320, 13.735856],
    [4018, 5.597446, 4.971524, -16.908144],
    [4019, -8.748554, 16.023504, 2.961856],
    [4020, 7.353446, -16.964479, -0.500142],
    [4021, -13.228554, 7.943524, 10.203858],
])


@njit()
def _process_block_cpu(block, box, boy, boz, ox, oy, oz, hx, hy, hz, sphere_radius, fill_value, spheres):
    nx, ny, nz = block.shape
    for a, xs, ys, zs in spheres:
        imin = int(np.floor(max( 0, (xs-sphere_radius-ox)/hx-box)))
        imax = int(np.ceil( min(nx, (xs+sphere_radius-ox)/hx-box+1)))
        jmin = int(np.floor(max( 0, (ys-sphere_radius-oy)/hy-boy)))
        jmax = int(np.ceil( min(ny, (ys+sphere_radius-oy)/hy-boy+1)))
        kmin = int(np.floor(max( 0, (zs-sphere_radius-oz)/hz-boz)))
        kmax = int(np.ceil( min(nz, (zs+sphere_radius-oz)/hz-boz+1)))
        for i in range(imin, imax):
            for j in range(jmin, jmax):
                for k in range(kmin, kmax):
                    xp = ox + (box+i)*hx
                    yp = oy + (boy+j)*hy
                    zp = oz + (boz+k)*hz
                    dx = xp-xs
                    dy = yp-ys
                    dz = zp-zs
                    r = ((dx**2)+(dy**2)+(dz**2))/sphere_radius/sphere_radius
                    if r <= 1:
                        block[i, j, k] = fill_value


@cuda.jit()
def _process_block_gpu(block, box, boy, boz, ox, oy, oz, hx, hy, hz, radius, fill_value, spheres):
    nx, ny, nz = block.shape
    i, j, k = cuda.grid(3)
    if i<0 or i>=nx or j<0 or j>=ny or k<0 or k>=nz:
        return
    xp = ox + (box+i)*hx
    yp = oy + (boy+j)*hy
    zp = oz + (boz+k)*hz
    for a, xs, ys, zs in spheres:
        dx = xp-xs
        dy = yp-ys
        dz = zp-zs
        r = ((dx**2)+(dy**2)+(dz**2))/radius/radius
        if r <= 1:
            block[i, j, k] = fill_value
            return


def fill_finney_pack(array,
                     sphere_radius,
                     fill_value,
                     hx, hy, hz, ox, oy, oz):

    threadsperblock = (4, 4, 2)

    chunks = array.chunks
    Nblocks = array.cdata_shape
    pbar = rvtqdm(total=np.prod(Nblocks),
                  desc='Generating sphere pack',
                  unit='chunk')
    for bk in range(0, Nblocks[2]):
        for bj in range(0, Nblocks[1]):
            for bi in range(0, Nblocks[0]):
                block_id = bi + bj*Nblocks[0] + bk*Nblocks[0]*Nblocks[1]
                if block_id % mpi_nprocs == mpi_rank:
                    block = array.blocks[bi, bj, bk]
                    bnx, bny, bnz = block.shape
                    box = bi*chunks[0]
                    boy = bj*chunks[1]
                    boz = bk*chunks[2]
                    bex = (bi+1)*chunks[0]
                    bey = (bj+1)*chunks[1]
                    bez = (bk+1)*chunks[2]

                    ind = SPHERES[:, 1] >= (box*hx+ox)-sphere_radius
                    ind = np.logical_and(ind, SPHERES[:, 1] <= (bex*hx+ox)+sphere_radius)
                    ind = np.logical_and(ind, SPHERES[:, 2] >= (boy*hy+oy)-sphere_radius)
                    ind = np.logical_and(ind, SPHERES[:, 2] <= (bey*hy+oy)+sphere_radius)
                    ind = np.logical_and(ind, SPHERES[:, 3] >= (boz*hz+oz)-sphere_radius)
                    ind = np.logical_and(ind, SPHERES[:, 3] <= (bez*hz+oz)+sphere_radius)
                    ind = np.argwhere(ind).flatten()
                    spheres = SPHERES[ind, :]
                    device_index = config.rank_select_gpu()
                    if device_index is not None:
                        with config._gpus[device_index]:
                            d_block = cuda.to_device(block)
                            d_spheres = cuda.to_device(spheres)
                            blockspergrid = (int(np.ceil(bnx/threadsperblock[0])),
                                             int(np.ceil(bny/threadsperblock[1])),
                                             int(np.ceil(bnz/threadsperblock[2])))
                            _process_block_gpu[blockspergrid, threadsperblock](d_block, box, boy, boz, ox, oy, oz, hx, hy, hz, sphere_radius, fill_value, d_spheres)
                            block = d_block.copy_to_host()
                    else:
                        _process_block_cpu(block, box, boy, boz, ox, oy, oz, hx, hy, hz, sphere_radius, fill_value, spheres)
                    array.blocks[bi, bj, bk] = block.copy()
                pbar.update(1)
    pbar.close()