"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Emotion Recognition gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class RecognizeRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Recognize</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data to recognize the emotions of speakers from.
        If the audio is in a raw format and the <code>config.speech_length</code> is set,
        the service will stop processing the audio once the required speech length is met.
        Otherwise, the service will process the whole audio. There is no minimum audio length limit.
        """

    @property
    def config(self) -> global___RecognizeConfig:
        """Configuration for the emotion detection."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___RecognizeConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_config", b"_config", "audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_config", b"_config", "audio", b"audio", "config", b"config"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_config", b"_config"]) -> typing.Literal["config"] | None: ...

global___RecognizeRequest = RecognizeRequest

@typing.final
class RecognizeConfig(google.protobuf.message.Message):
    """The configuration message for the <code>Recognize</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Specifies the maximum speech length from which the emotions will be recognized. 
        If there is less speech in the audio than the specified
        duration, the emotions will be recognized from the entire audio.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> None: ...

global___RecognizeConfig = RecognizeConfig

@typing.final
class RecognizeResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Recognize</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___RecognizeResult:
        """Result containing the recognized emotions with their scores."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio."""

    def __init__(
        self,
        *,
        result: global___RecognizeResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___RecognizeResponse = RecognizeResponse

@typing.final
class RecognizeResult(google.protobuf.message.Message):
    """Message containing the result of emotion recognition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    SCORES_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total speech length from which the emotions were recognized."""

    @property
    def scores(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EmotionScore]:
        """List of emotions and their probabilities.
        It can be empty if the input does not contain any speech.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        scores: collections.abc.Iterable[global___EmotionScore] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["scores", b"scores", "speech_length", b"speech_length"]) -> None: ...

global___RecognizeResult = RecognizeResult

@typing.final
class EmotionScore(google.protobuf.message.Message):
    """Message containing the emotion type and its probability."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EmotionType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EmotionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[EmotionScore._EmotionType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ANGRY: EmotionScore._EmotionType.ValueType  # 0
        SAD: EmotionScore._EmotionType.ValueType  # 1
        HAPPY: EmotionScore._EmotionType.ValueType  # 2
        NEUTRAL: EmotionScore._EmotionType.ValueType  # 3

    class EmotionType(_EmotionType, metaclass=_EmotionTypeEnumTypeWrapper):
        """Supported emotion types."""

    ANGRY: EmotionScore.EmotionType.ValueType  # 0
    SAD: EmotionScore.EmotionType.ValueType  # 1
    HAPPY: EmotionScore.EmotionType.ValueType  # 2
    NEUTRAL: EmotionScore.EmotionType.ValueType  # 3

    EMOTION_FIELD_NUMBER: builtins.int
    PROBABILITY_FIELD_NUMBER: builtins.int
    emotion: global___EmotionScore.EmotionType.ValueType
    """Recognized emotion from the supported types."""
    probability: builtins.float
    """Probability score associated with the recognized emotion."""
    def __init__(
        self,
        *,
        emotion: global___EmotionScore.EmotionType.ValueType = ...,
        probability: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["emotion", b"emotion", "probability", b"probability"]) -> None: ...

global___EmotionScore = EmotionScore
