"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Enhanced Speech To Text Built On Whisper gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class TranscribeRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Transcribe</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data from which a transcription should be extracted.
        A variety of common audio formats are supported, including WAV, FLAC,
        and others. There is no minimum audio length limit.
        """

    @property
    def config(self) -> global___TranscribeConfig:
        """Speech to text transcription configuration."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___TranscribeConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___TranscribeRequest = TranscribeRequest

@typing.final
class TranscribeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_FIELD_NUMBER: builtins.int
    ENABLE_LANGUAGE_SWITCHING_FIELD_NUMBER: builtins.int
    ENABLE_WORD_SEGMENTATION_FIELD_NUMBER: builtins.int
    language: builtins.str
    """The language of the audio data specified as an RFC 5646 language tag.
    If not set, the language will be detected automatically.
    """
    enable_language_switching: builtins.bool
    """By default, the language of the speech is detected once at the beginning of
    the audio. Setting `enable_language_switching` to `true` allows for dynamic
    language switching in the audio, with the language being detected
    approximately every 30 seconds.

    Note: This option is ignored if the language is enforced by setting the
    <code>language</code> option.
    """
    enable_word_segmentation: builtins.bool
    """If set to `true`, the result will contain word-level segmentation.

    Note: Enabling this option may incrase processing time.
    """
    def __init__(
        self,
        *,
        language: builtins.str = ...,
        enable_language_switching: builtins.bool = ...,
        enable_word_segmentation: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enable_language_switching", b"enable_language_switching", "enable_word_segmentation", b"enable_word_segmentation", "language", b"language"]) -> None: ...

global___TranscribeConfig = TranscribeConfig

@typing.final
class TranslateRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Translate</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data on which the translation should be performed.
        A variety of common audio formats are supported, including WAV, FLAC,
        and others. There is no minimum audio length limit.
        """

    @property
    def config(self) -> global___TranslateConfig:
        """Speech to text translation configuration."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___TranslateConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___TranslateRequest = TranslateRequest

@typing.final
class TranslateConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_LANGUAGE_FIELD_NUMBER: builtins.int
    ENABLE_LANGUAGE_SWITCHING_FIELD_NUMBER: builtins.int
    ENABLE_WORD_SEGMENTATION_FIELD_NUMBER: builtins.int
    source_language: builtins.str
    """The language of the audio data specified as an RFC 5646 language tag.
    If not set, the language will be detected automatically.
    """
    enable_language_switching: builtins.bool
    """By default, the language of the speech is detected once at the beginning of
    the audio. Setting `enable_language_switching` to `true` allows for dynamic
    language switching in the audio, with the language being detected
    approximately every 30 seconds.

    Note: This option is ignored if the language is enforced by setting the
    <code>source_language</code> option.
    """
    enable_word_segmentation: builtins.bool
    """If set to `true`, the result will contain word-level segmentation.

    Note: Enabling this option may increase processing time.
    """
    def __init__(
        self,
        *,
        source_language: builtins.str = ...,
        enable_language_switching: builtins.bool = ...,
        enable_word_segmentation: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enable_language_switching", b"enable_language_switching", "enable_word_segmentation", b"enable_word_segmentation", "source_language", b"source_language"]) -> None: ...

global___TranslateConfig = TranslateConfig

@typing.final
class TranscribeResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Transcribe</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___TranscribeResult:
        """The Speech to Text transcription result."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio.
        Set only if this is the last response in the stream.
        """

    def __init__(
        self,
        *,
        result: global___TranscribeResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___TranscribeResponse = TranscribeResponse

@typing.final
class TranslateResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Translate</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___TranslateResult:
        """The Speech to Text translation result."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio.
        Set only if this is the last response in the stream.
        """

    def __init__(
        self,
        *,
        result: global___TranslateResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___TranslateResponse = TranslateResponse

@typing.final
class ListSupportedLanguagesRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>ListSupportedLanguages</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListSupportedLanguagesRequest = ListSupportedLanguagesRequest

@typing.final
class ListSupportedLanguagesResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>ListSupportedLanguages</code>"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGES_FIELD_NUMBER: builtins.int
    TRANSLATION_LANGUAGES_FIELD_NUMBER: builtins.int
    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of available languages for transcription.
        The language is specified as an RFC 5646 language tag.
        """

    @property
    def translation_languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of available source languages for translation.
        The language is specified as an RFC 5646 language tag.
        """

    def __init__(
        self,
        *,
        languages: collections.abc.Iterable[builtins.str] | None = ...,
        translation_languages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["languages", b"languages", "translation_languages", b"translation_languages"]) -> None: ...

global___ListSupportedLanguagesResponse = ListSupportedLanguagesResponse

@typing.final
class TranscribeResult(google.protobuf.message.Message):
    """The collection of all transcription result formats."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONE_BEST_FIELD_NUMBER: builtins.int
    @property
    def one_best(self) -> global___OneBest:
        """Result in one-best format."""

    def __init__(
        self,
        *,
        one_best: global___OneBest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_best", b"one_best"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["one_best", b"one_best"]) -> None: ...

global___TranscribeResult = TranscribeResult

@typing.final
class TranslateResult(google.protobuf.message.Message):
    """The collection of all translation result formats."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONE_BEST_FIELD_NUMBER: builtins.int
    @property
    def one_best(self) -> global___OneBest:
        """Result in one-best format."""

    def __init__(
        self,
        *,
        one_best: global___OneBest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_best", b"one_best"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["one_best", b"one_best"]) -> None: ...

global___TranslateResult = TranslateResult

@typing.final
class OneBest(google.protobuf.message.Message):
    """The one-best output from Speech To Text."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEGMENTS_FIELD_NUMBER: builtins.int
    @property
    def segments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OneBestSegment]:
        """Sequential list of transcription segments corresponding to sequential
        portions of audio.
        """

    def __init__(
        self,
        *,
        segments: collections.abc.Iterable[global___OneBestSegment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["segments", b"segments"]) -> None: ...

global___OneBest = OneBest

@typing.final
class Word(google.protobuf.message.Message):
    """Individual word with timestamps."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    PUNCTUATED_TEXT_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text of the word."""
    punctuated_text: builtins.str
    """Text of the word with punctuation and capitalization."""
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the word."""

    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the word."""

    def __init__(
        self,
        *,
        text: builtins.str = ...,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
        punctuated_text: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "punctuated_text", b"punctuated_text", "start_time", b"start_time", "text", b"text"]) -> None: ...

global___Word = Word

@typing.final
class OneBestSegment(google.protobuf.message.Message):
    """Segment of the one-best output."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    SOURCE_LANGUAGE_FIELD_NUMBER: builtins.int
    DETECTED_SOURCE_LANGUAGE_FIELD_NUMBER: builtins.int
    WORDS_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text content of the segment."""
    language: builtins.str
    """Target language, that the <code>text</code> field of this message is transcribed in.
    The language is specified as an RFC 5646 language tag.

    Note: If a specific language was enforced in the <code>Transcribe</code> method,
    the target language is the same as this specified language.
    """
    source_language: builtins.str
    """The selected language of the audio data as an RFC 5646 language tag.
    This field contains the language that whisper used for transcription/translation.
    In case that the user does not have a license for the language identified in the
    audio data, this field may not contain this language. Rather it will contain the most probable
    of the licensed languages.
    Note that this will have radical influence on the output, so always compare this field
    against <code>detected_source_language</code> to know if the text is transcribed/translated
    to/from the correct language.

    Note: If a specific <code>source_language</code> was enforced in the config,
    this field is the same as that specified language.
    """
    detected_source_language: builtins.str
    """The detected language of the audio data as an RFC 5646 language tag.
    This field contains the language that whisper detected as the source language of the audio data.
    This field may not equal to <code>source_language</code> in case the audio data is in different
    language than from the set of licensed languages.
    Always check if this field is equal to <code>source_language</code>.
    """
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the segment."""

    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the segment."""

    @property
    def words(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Word]:
        """Detailed word-level segmentation of the segment."""

    def __init__(
        self,
        *,
        text: builtins.str = ...,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
        language: builtins.str = ...,
        source_language: builtins.str = ...,
        detected_source_language: builtins.str = ...,
        words: collections.abc.Iterable[global___Word] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["detected_source_language", b"detected_source_language", "end_time", b"end_time", "language", b"language", "source_language", b"source_language", "start_time", b"start_time", "text", b"text", "words", b"words"]) -> None: ...

global___OneBestSegment = OneBestSegment
