"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Keyword Spotting gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Keyword(google.protobuf.message.Message):
    """*
    A keyword.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPELLING_FIELD_NUMBER: builtins.int
    PRONUNCIATIONS_FIELD_NUMBER: builtins.int
    spelling: builtins.str
    """*
    The spelling of the keyword written in graphemes.
    Only supported graphemes listed by <code>ListAllowedSymbols</code> can be used.
    """
    @property
    def pronunciations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """*
        Pronunciations written in phonemes separated by spaces.
        Only supported phonemes listed by <code>ListAllowedSymbols</code> can be used.
        Keyword is matched if any of the pronunciations matches.
        If not set, the pronunciation is searched in the system's vocabulary and if it is not found,
        it is automatically generated by the system.
        """

    def __init__(
        self,
        *,
        spelling: builtins.str = ...,
        pronunciations: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pronunciations", b"pronunciations", "spelling", b"spelling"]) -> None: ...

global___Keyword = Keyword

@typing.final
class DetectRequest(google.protobuf.message.Message):
    """*
    A request to detect keywords in an audio file.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    KEYWORDS_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """*
        The audio data to process. There is no minimum audio length limit.
        """

    @property
    def keywords(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Keyword]:
        """*
        The list of keywords to detect.
        """

    @property
    def config(self) -> global___DetectConfig:
        """*
        Optional Detect request configuration.
        """

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        keywords: collections.abc.Iterable[global___Keyword] | None = ...,
        config: global___DetectConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config", "keywords", b"keywords"]) -> None: ...

global___DetectRequest = DetectRequest

@typing.final
class DetectConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIDENCE_SHARPNESS_FIELD_NUMBER: builtins.int
    confidence_sharpness: builtins.float
    """*
     Specifies how the dynamic range of score is used (default is 1.0). Must be greater than zero.
    """
    def __init__(
        self,
        *,
        confidence_sharpness: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_confidence_sharpness", b"_confidence_sharpness", "confidence_sharpness", b"confidence_sharpness"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_confidence_sharpness", b"_confidence_sharpness", "confidence_sharpness", b"confidence_sharpness"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_confidence_sharpness", b"_confidence_sharpness"]) -> typing.Literal["confidence_sharpness"] | None: ...

global___DetectConfig = DetectConfig

@typing.final
class MatchedKeyword(google.protobuf.message.Message):
    """*
    A matched keyword.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PronunciationSource:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PronunciationSourceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MatchedKeyword._PronunciationSource.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DICTIONARY: MatchedKeyword._PronunciationSource.ValueType  # 0
        """*
        The pronunciation is in system's vocabulary.
        """
        GENERATED: MatchedKeyword._PronunciationSource.ValueType  # 1
        """*
        The pronunciation has been generated by the system
        """
        USER: MatchedKeyword._PronunciationSource.ValueType  # 2
        """*
        The pronunciation was set by the user.
        """

    class PronunciationSource(_PronunciationSource, metaclass=_PronunciationSourceEnumTypeWrapper):
        """*
        The source of the matched keyword.
        """

    DICTIONARY: MatchedKeyword.PronunciationSource.ValueType  # 0
    """*
    The pronunciation is in system's vocabulary.
    """
    GENERATED: MatchedKeyword.PronunciationSource.ValueType  # 1
    """*
    The pronunciation has been generated by the system
    """
    USER: MatchedKeyword.PronunciationSource.ValueType  # 2
    """*
    The pronunciation was set by the user.
    """

    SPELLING_FIELD_NUMBER: builtins.int
    PRONUNCIATION_FIELD_NUMBER: builtins.int
    PRONUNCIATION_SOURCE_FIELD_NUMBER: builtins.int
    spelling: builtins.str
    """*
    The spelling of the matched keyword written in graphemes.
    """
    pronunciation: builtins.str
    """*
    The pronunciation of the matched keyword written in phonemes separated by spaces.
    """
    pronunciation_source: global___MatchedKeyword.PronunciationSource.ValueType
    """*
    The source of the matched pronunciation.
    """
    def __init__(
        self,
        *,
        spelling: builtins.str = ...,
        pronunciation: builtins.str = ...,
        pronunciation_source: global___MatchedKeyword.PronunciationSource.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["pronunciation", b"pronunciation", "pronunciation_source", b"pronunciation_source", "spelling", b"spelling"]) -> None: ...

global___MatchedKeyword = MatchedKeyword

@typing.final
class Match(google.protobuf.message.Message):
    """*
    A match.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    KEYWORD_FIELD_NUMBER: builtins.int
    confidence: builtins.float
    """*
    The confidence of the match in range [0, 1].
    """
    score: builtins.float
    """*
    Score is calculated as log likelihood ratio in range [-inf, inf].
    """
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """*
        The start time of the match.
        """

    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """*
        The end time of the match.
        """

    @property
    def keyword(self) -> global___MatchedKeyword:
        """*
        The matched keyword.
        """

    def __init__(
        self,
        *,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
        confidence: builtins.float = ...,
        score: builtins.float = ...,
        keyword: global___MatchedKeyword | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "keyword", b"keyword", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["confidence", b"confidence", "end_time", b"end_time", "keyword", b"keyword", "score", b"score", "start_time", b"start_time"]) -> None: ...

global___Match = Match

@typing.final
class DetectResult(google.protobuf.message.Message):
    """*
    The result of the detect operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCHES_FIELD_NUMBER: builtins.int
    @property
    def matches(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Match]:
        """*
        The list of matches.
        """

    def __init__(
        self,
        *,
        matches: collections.abc.Iterable[global___Match] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["matches", b"matches"]) -> None: ...

global___DetectResult = DetectResult

@typing.final
class DetectResponse(google.protobuf.message.Message):
    """*
    The response of the detect operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___DetectResult:
        """*
        The result of the detect operation.
        """

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """*
        The length of the processed audio.
        """

    def __init__(
        self,
        *,
        result: global___DetectResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___DetectResponse = DetectResponse

@typing.final
class ListAllowedSymbolsRequest(google.protobuf.message.Message):
    """*
    The request to list allowed symbols.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListAllowedSymbolsRequest = ListAllowedSymbolsRequest

@typing.final
class ListAllowedSymbolsResponse(google.protobuf.message.Message):
    """*
    The response of the list allowed symbols operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GRAPHEMES_FIELD_NUMBER: builtins.int
    PHONEMES_FIELD_NUMBER: builtins.int
    @property
    def graphemes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """*
        The list of allowed graphemes.
        """

    @property
    def phonemes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """*
        The list of allowed phonemes.
        """

    def __init__(
        self,
        *,
        graphemes: collections.abc.Iterable[builtins.str] | None = ...,
        phonemes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["graphemes", b"graphemes", "phonemes", b"phonemes"]) -> None: ...

global___ListAllowedSymbolsResponse = ListAllowedSymbolsResponse
