"""ham.genai

```markdown
## `hammad-python-genai`

This module contains various resources for working with Generative
AI models.
```
"""

from typing import TYPE_CHECKING

try:
    from ham.core._internal import type_checking_importer
except ImportError:
    from ...core._internal import type_checking_importer  # type: ignore


if TYPE_CHECKING:
    from .a2a import (
        as_a2a_app,
        GraphWorker,
        AgentWorker,
    )
if TYPE_CHECKING:
    from .agents import (
        Agent,
        AgentEvent,
        AgentSettings,
        AgentResponse,
        AgentStream,
        AgentContext,
        AgentMessages,
        AgentResponseChunk,
        create_agent,
    )
    from .agents.run import (
        run_agent,
        run_agent_iter,
        async_run_agent,
        async_run_agent_iter,
        agent_decorator,
    )
    from .graphs import (
        GraphBuilder,
        GraphContext,
        GraphEnd,
        GraphEvent,
        GraphHistoryEntry,
        GraphNode,
        GraphState,
        GraphResponse,
        GraphStream,
        GraphResponseChunk,
        BaseGraph,
        BasePlugin,
        PluginDecorator,
        PydanticGraphContext,
        AudioPlugin,
        ServePlugin,
        MemoryPlugin,
        HistoryPlugin,
        SettingsPlugin,
        ActionNode,
        ActionInfo,
        ActionSettings,
        action,
        plugin,
        select as graph_select,
        SelectionStrategy as GraphSelectionStrategy,
        ActionDecorator,
    )
    from .models.embeddings import (
        Embedding,
        EmbeddingModel,
        EmbeddingModelResponse,
        EmbeddingModelSettings,
        run_embedding_model,
        async_run_embedding_model,
        create_embedding_model,
    )
    from .models.language import (
        LanguageModel,
        LanguageModelInstructorMode,
        LanguageModelMessages,
        LanguageModelName,
        LanguageModelRequest,
        LanguageModelResponse,
        LanguageModelResponseChunk,
        LanguageModelSettings,
        LanguageModelStream,
        run_language_model,
        async_run_language_model,
        language_model_decorator,
        create_language_model,
    )
    from .models.reranking import run_reranking_model, async_run_reranking_model
    from .models.multimodal import (
        run_image_edit_model,
        run_image_generation_model,
        run_image_variation_model,
        run_transcription_model,
        run_tts_model,
        async_run_image_edit_model,
        async_run_image_generation_model,
        async_run_image_variation_model,
        async_run_transcription_model,
        async_run_tts_model,
    )
    from .types.base import (
        BaseGenAIModel,
        BaseGenAIModelEvent,
        BaseGenAIModelResponse,
        BaseGenAIModelSettings,
        BaseGenAIModelStream,
    )
    from .types.history import History
    from .types.tools import (
        Tool,
        define_tool,
        execute_tools_from_language_model_response,
    )

    # PROMPTED
    from .prompted import (
        PromptedAgent,
        PromptedContext,
        PromptedFunction,
        PromptedIterator,
        PromptedResponse,
        PromptedStream,
        prompted_fn,
        contextualize,
        itemize,
        SelectionStrategy,
        select,
        tool,
    )


__all__ = [
    # hammad.genai.a2a
    "as_a2a_app",
    "GraphWorker",
    "AgentWorker",
    # hammad.genai.agents.agent
    "Agent",
    "AgentEvent",
    "AgentSettings",
    "AgentResponse",
    "AgentStream",
    "AgentContext",
    "AgentMessages",
    "AgentResponseChunk",
    "create_agent",
    # hammad.genai.agents.run
    "run_agent",
    "run_agent_iter",
    "async_run_agent",
    "async_run_agent_iter",
    "agent_decorator",
    # hammad.genai.graphs
    "GraphBuilder",
    "GraphContext",
    "GraphEnd",
    "GraphEvent",
    "GraphHistoryEntry",
    "GraphNode",
    "GraphState",
    "GraphResponse",
    "GraphStream",
    "GraphResponseChunk",
    "BaseGraph",
    "BasePlugin",
    "PluginDecorator",
    "PydanticGraphContext",
    "AudioPlugin",
    "ServePlugin",
    "MemoryPlugin",
    "HistoryPlugin",
    "SettingsPlugin",
    "ActionNode",
    "ActionInfo",
    "ActionSettings",
    "action",
    "plugin",
    "graph_select",
    "GraphSelectionStrategy",
    "ActionDecorator",
    # hammad.genai.models.embeddings
    "Embedding",
    "EmbeddingModel",
    "EmbeddingModelResponse",
    "EmbeddingModelSettings",
    "run_embedding_model",
    "async_run_embedding_model",
    "create_embedding_model",
    # hammad.genai.models.language
    "LanguageModel",
    "LanguageModelInstructorMode",
    "LanguageModelMessages",
    "LanguageModelName",
    "LanguageModelRequest",
    "LanguageModelResponse",
    "LanguageModelResponseChunk",
    "LanguageModelSettings",
    "LanguageModelStream",
    "run_language_model",
    "async_run_language_model",
    "create_language_model",
    "language_model_decorator",
    # hammad.genai.models.reranking
    "run_reranking_model",
    "async_run_reranking_model",
    # hammad.genai.models.multimodal
    "run_image_edit_model",
    "run_image_generation_model",
    "run_image_variation_model",
    "run_transcription_model",
    "run_tts_model",
    "async_run_image_edit_model",
    "async_run_image_generation_model",
    "async_run_image_variation_model",
    "async_run_transcription_model",
    "async_run_tts_model",
    # hammad.genai.types.base
    "BaseGenAIModel",
    "BaseGenAIModelEvent",
    "BaseGenAIModelResponse",
    "BaseGenAIModelSettings",
    "BaseGenAIModelStream",
    # hammad.genai.types.history
    "History",
    # hammad.genai.types.tools
    "Tool",
    "define_tool",
    "execute_tools_from_language_model_response",
    # hammad.genai.prompted
    "PromptedAgent",
    "PromptedContext",
    "PromptedFunction",
    "PromptedIterator",
    "PromptedResponse",
    "PromptedStream",
    "prompted_fn",
    "contextualize",
    "itemize",
    "SelectionStrategy",
    "select",
    "tool",
]


__getattr__ = type_checking_importer(__all__)


def __dir__() -> list[str]:
    return __all__
