import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceSourceControlTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#token AppServiceSourceControlToken#token}.
     *
     * @stability stable
     */
    readonly token: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#token_secret AppServiceSourceControlToken#token_secret}.
     *
     * @stability stable
     */
    readonly tokenSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#type AppServiceSourceControlToken#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#timeouts AppServiceSourceControlToken#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceSourceControlTokenTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceSourceControlTokenTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#create AppServiceSourceControlToken#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#delete AppServiceSourceControlToken#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#read AppServiceSourceControlToken#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html#update AppServiceSourceControlToken#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceSourceControlTokenTimeoutsToTerraform(struct?: AppServiceSourceControlTokenTimeoutsOutputReference | AppServiceSourceControlTokenTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceSourceControlTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSourceControlTokenTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSourceControlTokenTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html azurerm_app_service_source_control_token}.
 *
 * @stability stable
 */
export declare class AppServiceSourceControlToken extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token.html azurerm_app_service_source_control_token} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceSourceControlTokenConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _token?;
    /**
     * @stability stable
     */
    get token(): string;
    /**
     * @stability stable
     */
    set token(value: string);
    /**
     * @stability stable
     */
    get tokenInput(): string | undefined;
    private _tokenSecret?;
    /**
     * @stability stable
     */
    get tokenSecret(): string;
    /**
     * @stability stable
     */
    set tokenSecret(value: string);
    /**
     * @stability stable
     */
    resetTokenSecret(): void;
    /**
     * @stability stable
     */
    get tokenSecretInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceSourceControlTokenTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceSourceControlTokenTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceSourceControlTokenTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
