import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#access_key_metadata_writes_enabled CosmosdbAccount#access_key_metadata_writes_enabled}.
     *
     * @stability stable
     */
    readonly accessKeyMetadataWritesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#analytical_storage_enabled CosmosdbAccount#analytical_storage_enabled}.
     *
     * @stability stable
     */
    readonly analyticalStorageEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#create_mode CosmosdbAccount#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#default_identity_type CosmosdbAccount#default_identity_type}.
     *
     * @stability stable
     */
    readonly defaultIdentityType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#enable_automatic_failover CosmosdbAccount#enable_automatic_failover}.
     *
     * @stability stable
     */
    readonly enableAutomaticFailover?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#enable_free_tier CosmosdbAccount#enable_free_tier}.
     *
     * @stability stable
     */
    readonly enableFreeTier?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#enable_multiple_write_locations CosmosdbAccount#enable_multiple_write_locations}.
     *
     * @stability stable
     */
    readonly enableMultipleWriteLocations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#ip_range_filter CosmosdbAccount#ip_range_filter}.
     *
     * @stability stable
     */
    readonly ipRangeFilter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#is_virtual_network_filter_enabled CosmosdbAccount#is_virtual_network_filter_enabled}.
     *
     * @stability stable
     */
    readonly isVirtualNetworkFilterEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#key_vault_key_id CosmosdbAccount#key_vault_key_id}.
     *
     * @stability stable
     */
    readonly keyVaultKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#kind CosmosdbAccount#kind}.
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#local_authentication_disabled CosmosdbAccount#local_authentication_disabled}.
     *
     * @stability stable
     */
    readonly localAuthenticationDisabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#location CosmosdbAccount#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#mongo_server_version CosmosdbAccount#mongo_server_version}.
     *
     * @stability stable
     */
    readonly mongoServerVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#name CosmosdbAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#network_acl_bypass_for_azure_services CosmosdbAccount#network_acl_bypass_for_azure_services}.
     *
     * @stability stable
     */
    readonly networkAclBypassForAzureServices?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#network_acl_bypass_ids CosmosdbAccount#network_acl_bypass_ids}.
     *
     * @stability stable
     */
    readonly networkAclBypassIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#offer_type CosmosdbAccount#offer_type}.
     *
     * @stability stable
     */
    readonly offerType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#public_network_access_enabled CosmosdbAccount#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#resource_group_name CosmosdbAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#tags CosmosdbAccount#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * analytical_storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#analytical_storage CosmosdbAccount#analytical_storage}
     *
     * @stability stable
     */
    readonly analyticalStorage?: CosmosdbAccountAnalyticalStorage;
    /**
     * backup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#backup CosmosdbAccount#backup}
     *
     * @stability stable
     */
    readonly backup?: CosmosdbAccountBackup;
    /**
     * capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#capabilities CosmosdbAccount#capabilities}
     *
     * @stability stable
     */
    readonly capabilities?: CosmosdbAccountCapabilities[];
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#capacity CosmosdbAccount#capacity}
     *
     * @stability stable
     */
    readonly capacity?: CosmosdbAccountCapacity;
    /**
     * consistency_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#consistency_policy CosmosdbAccount#consistency_policy}
     *
     * @stability stable
     */
    readonly consistencyPolicy: CosmosdbAccountConsistencyPolicy;
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#cors_rule CosmosdbAccount#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: CosmosdbAccountCorsRule;
    /**
     * geo_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#geo_location CosmosdbAccount#geo_location}
     *
     * @stability stable
     */
    readonly geoLocation: CosmosdbAccountGeoLocation[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#identity CosmosdbAccount#identity}
     *
     * @stability stable
     */
    readonly identity?: CosmosdbAccountIdentity;
    /**
     * restore block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#restore CosmosdbAccount#restore}
     *
     * @stability stable
     */
    readonly restore?: CosmosdbAccountRestore;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#timeouts CosmosdbAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbAccountTimeouts;
    /**
     * virtual_network_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#virtual_network_rule CosmosdbAccount#virtual_network_rule}
     *
     * @stability stable
     */
    readonly virtualNetworkRule?: CosmosdbAccountVirtualNetworkRule[];
}
/**
 * @stability stable
 */
export interface CosmosdbAccountAnalyticalStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#schema_type CosmosdbAccount#schema_type}.
     *
     * @stability stable
     */
    readonly schemaType: string;
}
export declare function cosmosdbAccountAnalyticalStorageToTerraform(struct?: CosmosdbAccountAnalyticalStorageOutputReference | CosmosdbAccountAnalyticalStorage): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountAnalyticalStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountAnalyticalStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountAnalyticalStorage | undefined);
    private _schemaType?;
    /**
     * @stability stable
     */
    get schemaType(): string;
    /**
     * @stability stable
     */
    set schemaType(value: string);
    /**
     * @stability stable
     */
    get schemaTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountBackup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#interval_in_minutes CosmosdbAccount#interval_in_minutes}.
     *
     * @stability stable
     */
    readonly intervalInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#retention_in_hours CosmosdbAccount#retention_in_hours}.
     *
     * @stability stable
     */
    readonly retentionInHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#storage_redundancy CosmosdbAccount#storage_redundancy}.
     *
     * @stability stable
     */
    readonly storageRedundancy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#type CosmosdbAccount#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function cosmosdbAccountBackupToTerraform(struct?: CosmosdbAccountBackupOutputReference | CosmosdbAccountBackup): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountBackup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountBackup | undefined);
    private _intervalInMinutes?;
    /**
     * @stability stable
     */
    get intervalInMinutes(): number;
    /**
     * @stability stable
     */
    set intervalInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIntervalInMinutes(): void;
    /**
     * @stability stable
     */
    get intervalInMinutesInput(): number | undefined;
    private _retentionInHours?;
    /**
     * @stability stable
     */
    get retentionInHours(): number;
    /**
     * @stability stable
     */
    set retentionInHours(value: number);
    /**
     * @stability stable
     */
    resetRetentionInHours(): void;
    /**
     * @stability stable
     */
    get retentionInHoursInput(): number | undefined;
    private _storageRedundancy?;
    /**
     * @stability stable
     */
    get storageRedundancy(): string;
    /**
     * @stability stable
     */
    set storageRedundancy(value: string);
    /**
     * @stability stable
     */
    resetStorageRedundancy(): void;
    /**
     * @stability stable
     */
    get storageRedundancyInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#name CosmosdbAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function cosmosdbAccountCapabilitiesToTerraform(struct?: CosmosdbAccountCapabilities): any;
/**
 * @stability stable
 */
export interface CosmosdbAccountCapacity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#total_throughput_limit CosmosdbAccount#total_throughput_limit}.
     *
     * @stability stable
     */
    readonly totalThroughputLimit: number;
}
export declare function cosmosdbAccountCapacityToTerraform(struct?: CosmosdbAccountCapacityOutputReference | CosmosdbAccountCapacity): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountCapacity | undefined);
    private _totalThroughputLimit?;
    /**
     * @stability stable
     */
    get totalThroughputLimit(): number;
    /**
     * @stability stable
     */
    set totalThroughputLimit(value: number);
    /**
     * @stability stable
     */
    get totalThroughputLimitInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountConsistencyPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#consistency_level CosmosdbAccount#consistency_level}.
     *
     * @stability stable
     */
    readonly consistencyLevel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#max_interval_in_seconds CosmosdbAccount#max_interval_in_seconds}.
     *
     * @stability stable
     */
    readonly maxIntervalInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#max_staleness_prefix CosmosdbAccount#max_staleness_prefix}.
     *
     * @stability stable
     */
    readonly maxStalenessPrefix?: number;
}
export declare function cosmosdbAccountConsistencyPolicyToTerraform(struct?: CosmosdbAccountConsistencyPolicyOutputReference | CosmosdbAccountConsistencyPolicy): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountConsistencyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountConsistencyPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountConsistencyPolicy | undefined);
    private _consistencyLevel?;
    /**
     * @stability stable
     */
    get consistencyLevel(): string;
    /**
     * @stability stable
     */
    set consistencyLevel(value: string);
    /**
     * @stability stable
     */
    get consistencyLevelInput(): string | undefined;
    private _maxIntervalInSeconds?;
    /**
     * @stability stable
     */
    get maxIntervalInSeconds(): number;
    /**
     * @stability stable
     */
    set maxIntervalInSeconds(value: number);
    /**
     * @stability stable
     */
    resetMaxIntervalInSeconds(): void;
    /**
     * @stability stable
     */
    get maxIntervalInSecondsInput(): number | undefined;
    private _maxStalenessPrefix?;
    /**
     * @stability stable
     */
    get maxStalenessPrefix(): number;
    /**
     * @stability stable
     */
    set maxStalenessPrefix(value: number);
    /**
     * @stability stable
     */
    resetMaxStalenessPrefix(): void;
    /**
     * @stability stable
     */
    get maxStalenessPrefixInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#allowed_headers CosmosdbAccount#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#allowed_methods CosmosdbAccount#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#allowed_origins CosmosdbAccount#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#exposed_headers CosmosdbAccount#exposed_headers}.
     *
     * @stability stable
     */
    readonly exposedHeaders: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#max_age_in_seconds CosmosdbAccount#max_age_in_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeInSeconds: number;
}
export declare function cosmosdbAccountCorsRuleToTerraform(struct?: CosmosdbAccountCorsRuleOutputReference | CosmosdbAccountCorsRule): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountCorsRule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountCorsRule | undefined);
    private _allowedHeaders?;
    /**
     * @stability stable
     */
    get allowedHeaders(): string[];
    /**
     * @stability stable
     */
    set allowedHeaders(value: string[]);
    /**
     * @stability stable
     */
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    /**
     * @stability stable
     */
    get allowedMethods(): string[];
    /**
     * @stability stable
     */
    set allowedMethods(value: string[]);
    /**
     * @stability stable
     */
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    /**
     * @stability stable
     */
    get exposedHeaders(): string[];
    /**
     * @stability stable
     */
    set exposedHeaders(value: string[]);
    /**
     * @stability stable
     */
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    /**
     * @stability stable
     */
    get maxAgeInSeconds(): number;
    /**
     * @stability stable
     */
    set maxAgeInSeconds(value: number);
    /**
     * @stability stable
     */
    get maxAgeInSecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountGeoLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#failover_priority CosmosdbAccount#failover_priority}.
     *
     * @stability stable
     */
    readonly failoverPriority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#location CosmosdbAccount#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#prefix CosmosdbAccount#prefix}.
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#zone_redundant CosmosdbAccount#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbAccountGeoLocationToTerraform(struct?: CosmosdbAccountGeoLocation): any;
/**
 * @stability stable
 */
export interface CosmosdbAccountIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#type CosmosdbAccount#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function cosmosdbAccountIdentityToTerraform(struct?: CosmosdbAccountIdentityOutputReference | CosmosdbAccountIdentity): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountRestoreDatabase {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#collection_names CosmosdbAccount#collection_names}.
     *
     * @stability stable
     */
    readonly collectionNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#name CosmosdbAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function cosmosdbAccountRestoreDatabaseToTerraform(struct?: CosmosdbAccountRestoreDatabase): any;
/**
 * @stability stable
 */
export interface CosmosdbAccountRestore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#restore_timestamp_in_utc CosmosdbAccount#restore_timestamp_in_utc}.
     *
     * @stability stable
     */
    readonly restoreTimestampInUtc: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#source_cosmosdb_account_id CosmosdbAccount#source_cosmosdb_account_id}.
     *
     * @stability stable
     */
    readonly sourceCosmosdbAccountId: string;
    /**
     * database block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#database CosmosdbAccount#database}
     *
     * @stability stable
     */
    readonly database?: CosmosdbAccountRestoreDatabase[];
}
export declare function cosmosdbAccountRestoreToTerraform(struct?: CosmosdbAccountRestoreOutputReference | CosmosdbAccountRestore): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountRestore | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountRestore | undefined);
    private _restoreTimestampInUtc?;
    /**
     * @stability stable
     */
    get restoreTimestampInUtc(): string;
    /**
     * @stability stable
     */
    set restoreTimestampInUtc(value: string);
    /**
     * @stability stable
     */
    get restoreTimestampInUtcInput(): string | undefined;
    private _sourceCosmosdbAccountId?;
    /**
     * @stability stable
     */
    get sourceCosmosdbAccountId(): string;
    /**
     * @stability stable
     */
    set sourceCosmosdbAccountId(value: string);
    /**
     * @stability stable
     */
    get sourceCosmosdbAccountIdInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): CosmosdbAccountRestoreDatabase[];
    /**
     * @stability stable
     */
    set database(value: CosmosdbAccountRestoreDatabase[]);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): CosmosdbAccountRestoreDatabase[] | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#create CosmosdbAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#delete CosmosdbAccount#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#read CosmosdbAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#update CosmosdbAccount#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbAccountTimeoutsToTerraform(struct?: CosmosdbAccountTimeoutsOutputReference | CosmosdbAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbAccountTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbAccountVirtualNetworkRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#id CosmosdbAccount#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html#ignore_missing_vnet_service_endpoint CosmosdbAccount#ignore_missing_vnet_service_endpoint}.
     *
     * @stability stable
     */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbAccountVirtualNetworkRuleToTerraform(struct?: CosmosdbAccountVirtualNetworkRule): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html azurerm_cosmosdb_account}.
 *
 * @stability stable
 */
export declare class CosmosdbAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account.html azurerm_cosmosdb_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbAccountConfig);
    private _accessKeyMetadataWritesEnabled?;
    /**
     * @stability stable
     */
    get accessKeyMetadataWritesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessKeyMetadataWritesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessKeyMetadataWritesEnabled(): void;
    /**
     * @stability stable
     */
    get accessKeyMetadataWritesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _analyticalStorageEnabled?;
    /**
     * @stability stable
     */
    get analyticalStorageEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set analyticalStorageEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAnalyticalStorageEnabled(): void;
    /**
     * @stability stable
     */
    get analyticalStorageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get connectionStrings(): string[];
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _defaultIdentityType?;
    /**
     * @stability stable
     */
    get defaultIdentityType(): string;
    /**
     * @stability stable
     */
    set defaultIdentityType(value: string);
    /**
     * @stability stable
     */
    resetDefaultIdentityType(): void;
    /**
     * @stability stable
     */
    get defaultIdentityTypeInput(): string | undefined;
    private _enableAutomaticFailover?;
    /**
     * @stability stable
     */
    get enableAutomaticFailover(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticFailover(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticFailover(): void;
    /**
     * @stability stable
     */
    get enableAutomaticFailoverInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFreeTier?;
    /**
     * @stability stable
     */
    get enableFreeTier(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFreeTier(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFreeTier(): void;
    /**
     * @stability stable
     */
    get enableFreeTierInput(): boolean | cdktf.IResolvable | undefined;
    private _enableMultipleWriteLocations?;
    /**
     * @stability stable
     */
    get enableMultipleWriteLocations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableMultipleWriteLocations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableMultipleWriteLocations(): void;
    /**
     * @stability stable
     */
    get enableMultipleWriteLocationsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipRangeFilter?;
    /**
     * @stability stable
     */
    get ipRangeFilter(): string;
    /**
     * @stability stable
     */
    set ipRangeFilter(value: string);
    /**
     * @stability stable
     */
    resetIpRangeFilter(): void;
    /**
     * @stability stable
     */
    get ipRangeFilterInput(): string | undefined;
    private _isVirtualNetworkFilterEnabled?;
    /**
     * @stability stable
     */
    get isVirtualNetworkFilterEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isVirtualNetworkFilterEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsVirtualNetworkFilterEnabled(): void;
    /**
     * @stability stable
     */
    get isVirtualNetworkFilterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    /**
     * @stability stable
     */
    set keyVaultKeyId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultKeyId(): void;
    /**
     * @stability stable
     */
    get keyVaultKeyIdInput(): string | undefined;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    resetKind(): void;
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _localAuthenticationDisabled?;
    /**
     * @stability stable
     */
    get localAuthenticationDisabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthenticationDisabled(): void;
    /**
     * @stability stable
     */
    get localAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _mongoServerVersion?;
    /**
     * @stability stable
     */
    get mongoServerVersion(): string;
    /**
     * @stability stable
     */
    set mongoServerVersion(value: string);
    /**
     * @stability stable
     */
    resetMongoServerVersion(): void;
    /**
     * @stability stable
     */
    get mongoServerVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkAclBypassForAzureServices?;
    /**
     * @stability stable
     */
    get networkAclBypassForAzureServices(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set networkAclBypassForAzureServices(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNetworkAclBypassForAzureServices(): void;
    /**
     * @stability stable
     */
    get networkAclBypassForAzureServicesInput(): boolean | cdktf.IResolvable | undefined;
    private _networkAclBypassIds?;
    /**
     * @stability stable
     */
    get networkAclBypassIds(): string[];
    /**
     * @stability stable
     */
    set networkAclBypassIds(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkAclBypassIds(): void;
    /**
     * @stability stable
     */
    get networkAclBypassIdsInput(): string[] | undefined;
    private _offerType?;
    /**
     * @stability stable
     */
    get offerType(): string;
    /**
     * @stability stable
     */
    set offerType(value: string);
    /**
     * @stability stable
     */
    get offerTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    get primaryMasterKey(): string;
    /**
     * @stability stable
     */
    get primaryReadonlyKey(): string;
    /**
     * @stability stable
     */
    get primaryReadonlyMasterKey(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get readEndpoints(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    /**
     * @stability stable
     */
    get secondaryMasterKey(): string;
    /**
     * @stability stable
     */
    get secondaryReadonlyKey(): string;
    /**
     * @stability stable
     */
    get secondaryReadonlyMasterKey(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get writeEndpoints(): string[];
    private _analyticalStorage;
    /**
     * @stability stable
     */
    get analyticalStorage(): CosmosdbAccountAnalyticalStorageOutputReference;
    /**
     * @stability stable
     */
    putAnalyticalStorage(value: CosmosdbAccountAnalyticalStorage): void;
    /**
     * @stability stable
     */
    resetAnalyticalStorage(): void;
    /**
     * @stability stable
     */
    get analyticalStorageInput(): CosmosdbAccountAnalyticalStorage | undefined;
    private _backup;
    /**
     * @stability stable
     */
    get backup(): CosmosdbAccountBackupOutputReference;
    /**
     * @stability stable
     */
    putBackup(value: CosmosdbAccountBackup): void;
    /**
     * @stability stable
     */
    resetBackup(): void;
    /**
     * @stability stable
     */
    get backupInput(): CosmosdbAccountBackup | undefined;
    private _capabilities?;
    /**
     * @stability stable
     */
    get capabilities(): CosmosdbAccountCapabilities[];
    /**
     * @stability stable
     */
    set capabilities(value: CosmosdbAccountCapabilities[]);
    /**
     * @stability stable
     */
    resetCapabilities(): void;
    /**
     * @stability stable
     */
    get capabilitiesInput(): CosmosdbAccountCapabilities[] | undefined;
    private _capacity;
    /**
     * @stability stable
     */
    get capacity(): CosmosdbAccountCapacityOutputReference;
    /**
     * @stability stable
     */
    putCapacity(value: CosmosdbAccountCapacity): void;
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): CosmosdbAccountCapacity | undefined;
    private _consistencyPolicy;
    /**
     * @stability stable
     */
    get consistencyPolicy(): CosmosdbAccountConsistencyPolicyOutputReference;
    /**
     * @stability stable
     */
    putConsistencyPolicy(value: CosmosdbAccountConsistencyPolicy): void;
    /**
     * @stability stable
     */
    get consistencyPolicyInput(): CosmosdbAccountConsistencyPolicy | undefined;
    private _corsRule;
    /**
     * @stability stable
     */
    get corsRule(): CosmosdbAccountCorsRuleOutputReference;
    /**
     * @stability stable
     */
    putCorsRule(value: CosmosdbAccountCorsRule): void;
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): CosmosdbAccountCorsRule | undefined;
    private _geoLocation?;
    /**
     * @stability stable
     */
    get geoLocation(): CosmosdbAccountGeoLocation[];
    /**
     * @stability stable
     */
    set geoLocation(value: CosmosdbAccountGeoLocation[]);
    /**
     * @stability stable
     */
    get geoLocationInput(): CosmosdbAccountGeoLocation[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): CosmosdbAccountIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: CosmosdbAccountIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): CosmosdbAccountIdentity | undefined;
    private _restore;
    /**
     * @stability stable
     */
    get restore(): CosmosdbAccountRestoreOutputReference;
    /**
     * @stability stable
     */
    putRestore(value: CosmosdbAccountRestore): void;
    /**
     * @stability stable
     */
    resetRestore(): void;
    /**
     * @stability stable
     */
    get restoreInput(): CosmosdbAccountRestore | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbAccountTimeouts | undefined;
    private _virtualNetworkRule?;
    /**
     * @stability stable
     */
    get virtualNetworkRule(): CosmosdbAccountVirtualNetworkRule[];
    /**
     * @stability stable
     */
    set virtualNetworkRule(value: CosmosdbAccountVirtualNetworkRule[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkRule(): void;
    /**
     * @stability stable
     */
    get virtualNetworkRuleInput(): CosmosdbAccountVirtualNetworkRule[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
