var _JUPYTERLAB;
(() => {
var __webpack_modules__ = ({
31068(__unused_rspack_module, __unused_rspack_exports, __webpack_require__) {
Promise.all(/* import() */ [__webpack_require__.e("1407"), __webpack_require__.e("945"), __webpack_require__.e("2533"), __webpack_require__.e("5289"), __webpack_require__.e("4004"), __webpack_require__.e("3833"), __webpack_require__.e("683"), __webpack_require__.e("1815")]).then(__webpack_require__.bind(__webpack_require__, 80458));

},
80551(__unused_rspack_module, __unused_rspack_exports, __webpack_require__) {
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

// We dynamically set the webpack public path based on the page config
// settings from the JupyterLab app. We copy some of the pageconfig parsing
// logic in @jupyterlab/coreutils below, since this must run before any other
// files are loaded (including @jupyterlab/coreutils).

/**
 * Get global configuration data for the Jupyter application.
 *
 * @param name - The name of the configuration option.
 *
 * @returns The config value or an empty string if not found.
 *
 * #### Notes
 * All values are treated as strings.
 * For browser based applications, it is assumed that the page HTML
 * includes a script tag with the id `jupyter-config-data` containing the
 * configuration as valid JSON.  In order to support the classic Notebook,
 * we fall back on checking for `body` data of the given `name`.
 */
function getOption(name) {
  let configData = Object.create(null);
  // Use script tag if available.
  if (typeof document !== 'undefined' && document) {
    const el = document.getElementById('jupyter-config-data');

    if (el) {
      configData = JSON.parse(el.textContent || '{}');
    }
  }
  return configData[name] || '';
}

// eslint-disable-next-line no-undef
__webpack_require__.p = getOption('fullStaticUrl') + '/';


},
53630(__unused_rspack_module, exports) {
"use strict";


const RUNTIME_001 = 'RUNTIME-001';
const RUNTIME_002 = 'RUNTIME-002';
const RUNTIME_003 = 'RUNTIME-003';
const RUNTIME_004 = 'RUNTIME-004';
const RUNTIME_005 = 'RUNTIME-005';
const RUNTIME_006 = 'RUNTIME-006';
const RUNTIME_007 = 'RUNTIME-007';
const RUNTIME_008 = 'RUNTIME-008';
const RUNTIME_009 = 'RUNTIME-009';
const TYPE_001 = 'TYPE-001';
const BUILD_001 = 'BUILD-001';
const BUILD_002 = 'BUILD-002';

const getDocsUrl = (errorCode) => {
    const type = errorCode.split('-')[0].toLowerCase();
    return `View the docs to see how to solve: https://module-federation.io/guide/troubleshooting/${type}/${errorCode}`;
};
const getShortErrorMsg = (errorCode, errorDescMap, args, originalErrorMsg) => {
    const msg = [`${[errorDescMap[errorCode]]} #${errorCode}`];
    args && msg.push(`args: ${JSON.stringify(args)}`);
    msg.push(getDocsUrl(errorCode));
    originalErrorMsg && msg.push(`Original Error Message:\n ${originalErrorMsg}`);
    return msg.join('\n');
};

const runtimeDescMap = {
    [RUNTIME_001]: 'Failed to get remoteEntry exports.',
    [RUNTIME_002]: 'The remote entry interface does not contain "init"',
    [RUNTIME_003]: 'Failed to get manifest.',
    [RUNTIME_004]: 'Failed to locate remote.',
    [RUNTIME_005]: 'Invalid loadShareSync function call from bundler runtime',
    [RUNTIME_006]: 'Invalid loadShareSync function call from runtime',
    [RUNTIME_007]: 'Failed to get remote snapshot.',
    [RUNTIME_008]: 'Failed to load script resources.',
    [RUNTIME_009]: 'Please call createInstance first.',
};
const typeDescMap = {
    [TYPE_001]: 'Failed to generate type declaration. Execute the below cmd to reproduce and fix the error.',
};
const buildDescMap = {
    [BUILD_001]: 'Failed to find expose module.',
    [BUILD_002]: 'PublicPath is required in prod mode.',
};
const errorDescMap = {
    ...runtimeDescMap,
    ...typeDescMap,
    ...buildDescMap,
};

exports.BUILD_001 = BUILD_001;
exports.BUILD_002 = BUILD_002;
exports.RUNTIME_001 = RUNTIME_001;
exports.RUNTIME_002 = RUNTIME_002;
exports.RUNTIME_003 = RUNTIME_003;
exports.RUNTIME_004 = RUNTIME_004;
exports.RUNTIME_005 = RUNTIME_005;
exports.RUNTIME_006 = RUNTIME_006;
exports.RUNTIME_007 = RUNTIME_007;
exports.RUNTIME_008 = RUNTIME_008;
exports.RUNTIME_009 = RUNTIME_009;
exports.TYPE_001 = TYPE_001;
exports.buildDescMap = buildDescMap;
exports.errorDescMap = errorDescMap;
exports.getShortErrorMsg = getShortErrorMsg;
exports.runtimeDescMap = runtimeDescMap;
exports.typeDescMap = typeDescMap;
//# sourceMappingURL=index.cjs.js.map


},
88538(module) {
// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


},
35118(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";
/* import */ var _home_runner_work_notebook_notebook_jupyter_releaser_checkout_node_modules_module_federation_webpack_bundler_runtime_dist_index_cjs_cjs__rspack_import_0 = __webpack_require__(6802);
/* import */ var _home_runner_work_notebook_notebook_jupyter_releaser_checkout_node_modules_module_federation_webpack_bundler_runtime_dist_index_cjs_cjs__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_home_runner_work_notebook_notebook_jupyter_releaser_checkout_node_modules_module_federation_webpack_bundler_runtime_dist_index_cjs_cjs__rspack_import_0);
const __module_federation_runtime_plugins__ = [];const __module_federation_remote_infos__ = {};const __module_federation_container_name__ = "CORE_FEDERATION";const __module_federation_share_strategy__ = "version-first";if((__webpack_require__.initializeSharingData||__webpack_require__.initializeExposesData)&&__webpack_require__.federation){var __webpack_require___remotesLoadingData,__webpack_require___remotesLoadingData1,__webpack_require___initializeSharingData,__webpack_require___consumesLoadingData,__webpack_require___consumesLoadingData1,__webpack_require___initializeExposesData,__webpack_require___consumesLoadingData2;const override=(obj,key,value)=>{if(!obj)return;if(obj[key])obj[key]=value};const merge=(obj,key,fn)=>{const value=fn();if(Array.isArray(value)){var _obj,_key;var _;(_=(_obj=obj)[_key=key])!==null&&_!==void 0?_:_obj[_key]=[];obj[key].push(...value)}else if(typeof value==="object"&&value!==null){var _obj1,_key1;var _1;(_1=(_obj1=obj)[_key1=key])!==null&&_1!==void 0?_1:_obj1[_key1]={};Object.assign(obj[key],value)}};const early=(obj,key,initial)=>{var _obj,_key;var _;(_=(_obj=obj)[_key=key])!==null&&_!==void 0?_:_obj[_key]=initial()};var __webpack_require___remotesLoadingData_chunkMapping;const remotesLoadingChunkMapping=(__webpack_require___remotesLoadingData_chunkMapping=(__webpack_require___remotesLoadingData=__webpack_require__.remotesLoadingData)===null||__webpack_require___remotesLoadingData===void 0?void 0:__webpack_require___remotesLoadingData.chunkMapping)!==null&&__webpack_require___remotesLoadingData_chunkMapping!==void 0?__webpack_require___remotesLoadingData_chunkMapping:{};var __webpack_require___remotesLoadingData_moduleIdToRemoteDataMapping;const remotesLoadingModuleIdToRemoteDataMapping=(__webpack_require___remotesLoadingData_moduleIdToRemoteDataMapping=(__webpack_require___remotesLoadingData1=__webpack_require__.remotesLoadingData)===null||__webpack_require___remotesLoadingData1===void 0?void 0:__webpack_require___remotesLoadingData1.moduleIdToRemoteDataMapping)!==null&&__webpack_require___remotesLoadingData_moduleIdToRemoteDataMapping!==void 0?__webpack_require___remotesLoadingData_moduleIdToRemoteDataMapping:{};var __webpack_require___initializeSharingData_scopeToSharingDataMapping;const initializeSharingScopeToInitDataMapping=(__webpack_require___initializeSharingData_scopeToSharingDataMapping=(__webpack_require___initializeSharingData=__webpack_require__.initializeSharingData)===null||__webpack_require___initializeSharingData===void 0?void 0:__webpack_require___initializeSharingData.scopeToSharingDataMapping)!==null&&__webpack_require___initializeSharingData_scopeToSharingDataMapping!==void 0?__webpack_require___initializeSharingData_scopeToSharingDataMapping:{};var __webpack_require___consumesLoadingData_chunkMapping;const consumesLoadingChunkMapping=(__webpack_require___consumesLoadingData_chunkMapping=(__webpack_require___consumesLoadingData=__webpack_require__.consumesLoadingData)===null||__webpack_require___consumesLoadingData===void 0?void 0:__webpack_require___consumesLoadingData.chunkMapping)!==null&&__webpack_require___consumesLoadingData_chunkMapping!==void 0?__webpack_require___consumesLoadingData_chunkMapping:{};var __webpack_require___consumesLoadingData_moduleIdToConsumeDataMapping;const consumesLoadingModuleToConsumeDataMapping=(__webpack_require___consumesLoadingData_moduleIdToConsumeDataMapping=(__webpack_require___consumesLoadingData1=__webpack_require__.consumesLoadingData)===null||__webpack_require___consumesLoadingData1===void 0?void 0:__webpack_require___consumesLoadingData1.moduleIdToConsumeDataMapping)!==null&&__webpack_require___consumesLoadingData_moduleIdToConsumeDataMapping!==void 0?__webpack_require___consumesLoadingData_moduleIdToConsumeDataMapping:{};const consumesLoadinginstalledModules={};const initializeSharingInitPromises=[];const initializeSharingInitTokens={};const containerShareScope=(__webpack_require___initializeExposesData=__webpack_require__.initializeExposesData)===null||__webpack_require___initializeExposesData===void 0?void 0:__webpack_require___initializeExposesData.shareScope;for(const key in (_home_runner_work_notebook_notebook_jupyter_releaser_checkout_node_modules_module_federation_webpack_bundler_runtime_dist_index_cjs_cjs__rspack_import_0_default())){__webpack_require__.federation[key]=(_home_runner_work_notebook_notebook_jupyter_releaser_checkout_node_modules_module_federation_webpack_bundler_runtime_dist_index_cjs_cjs__rspack_import_0_default())[key]}early(__webpack_require__.federation,"consumesLoadingModuleToHandlerMapping",()=>{const consumesLoadingModuleToHandlerMapping={};for(let[moduleId,data]of Object.entries(consumesLoadingModuleToConsumeDataMapping)){consumesLoadingModuleToHandlerMapping[moduleId]={getter:data.fallback,shareInfo:{shareConfig:{fixedDependencies:false,requiredVersion:data.requiredVersion,strictVersion:data.strictVersion,singleton:data.singleton,eager:data.eager},scope:[data.shareScope]},shareKey:data.shareKey}}return consumesLoadingModuleToHandlerMapping});early(__webpack_require__.federation,"initOptions",()=>({}));early(__webpack_require__.federation.initOptions,"name",()=>__module_federation_container_name__);early(__webpack_require__.federation.initOptions,"shareStrategy",()=>__module_federation_share_strategy__);early(__webpack_require__.federation.initOptions,"shared",()=>{const shared={};for(let[scope,stages]of Object.entries(initializeSharingScopeToInitDataMapping)){for(let stage of stages){if(typeof stage==="object"&&stage!==null){const{name,version,factory,eager,singleton,requiredVersion,strictVersion}=stage;const shareConfig={};const isValidValue=function(val){return typeof val!=="undefined"};if(isValidValue(singleton)){shareConfig.singleton=singleton}if(isValidValue(requiredVersion)){shareConfig.requiredVersion=requiredVersion}if(isValidValue(eager)){shareConfig.eager=eager}if(isValidValue(strictVersion)){shareConfig.strictVersion=strictVersion}const options={version,scope:[scope],shareConfig,get:factory};if(shared[name]){shared[name].push(options)}else{shared[name]=[options]}}}}return shared});merge(__webpack_require__.federation.initOptions,"remotes",()=>Object.values(__module_federation_remote_infos__).flat().filter(remote=>remote.externalType==="script"));merge(__webpack_require__.federation.initOptions,"plugins",()=>__module_federation_runtime_plugins__);early(__webpack_require__.federation,"bundlerRuntimeOptions",()=>({}));early(__webpack_require__.federation.bundlerRuntimeOptions,"remotes",()=>({}));early(__webpack_require__.federation.bundlerRuntimeOptions.remotes,"chunkMapping",()=>remotesLoadingChunkMapping);early(__webpack_require__.federation.bundlerRuntimeOptions.remotes,"remoteInfos",()=>__module_federation_remote_infos__);early(__webpack_require__.federation.bundlerRuntimeOptions.remotes,"idToExternalAndNameMapping",()=>{const remotesLoadingIdToExternalAndNameMappingMapping={};for(let[moduleId,data]of Object.entries(remotesLoadingModuleIdToRemoteDataMapping)){remotesLoadingIdToExternalAndNameMappingMapping[moduleId]=[data.shareScope,data.name,data.externalModuleId,data.remoteName]}return remotesLoadingIdToExternalAndNameMappingMapping});early(__webpack_require__.federation.bundlerRuntimeOptions.remotes,"webpackRequire",()=>__webpack_require__);merge(__webpack_require__.federation.bundlerRuntimeOptions.remotes,"idToRemoteMap",()=>{const idToRemoteMap={};for(let[id,remoteData]of Object.entries(remotesLoadingModuleIdToRemoteDataMapping)){const info=__module_federation_remote_infos__[remoteData.remoteName];if(info)idToRemoteMap[id]=info}return idToRemoteMap});override(__webpack_require__,"S",__webpack_require__.federation.bundlerRuntime.S);if(__webpack_require__.federation.attachShareScopeMap){__webpack_require__.federation.attachShareScopeMap(__webpack_require__)}override(__webpack_require__.f,"remotes",(chunkId,promises)=>__webpack_require__.federation.bundlerRuntime.remotes({chunkId,promises,chunkMapping:remotesLoadingChunkMapping,idToExternalAndNameMapping:__webpack_require__.federation.bundlerRuntimeOptions.remotes.idToExternalAndNameMapping,idToRemoteMap:__webpack_require__.federation.bundlerRuntimeOptions.remotes.idToRemoteMap,webpackRequire:__webpack_require__}));override(__webpack_require__.f,"consumes",(chunkId,promises)=>__webpack_require__.federation.bundlerRuntime.consumes({chunkId,promises,chunkMapping:consumesLoadingChunkMapping,moduleToHandlerMapping:__webpack_require__.federation.consumesLoadingModuleToHandlerMapping,installedModules:consumesLoadinginstalledModules,webpackRequire:__webpack_require__}));override(__webpack_require__,"I",(name,initScope)=>__webpack_require__.federation.bundlerRuntime.I({shareScopeName:name,initScope,initPromises:initializeSharingInitPromises,initTokens:initializeSharingInitTokens,webpackRequire:__webpack_require__}));override(__webpack_require__,"initContainer",(shareScope,initScope,remoteEntryInitOptions)=>__webpack_require__.federation.bundlerRuntime.initContainerEntry({shareScope,initScope,remoteEntryInitOptions,shareScopeKey:containerShareScope,webpackRequire:__webpack_require__}));override(__webpack_require__,"getContainer",(module1,getScope)=>{var moduleMap=__webpack_require__.initializeExposesData.moduleMap;__webpack_require__.R=getScope;getScope=Object.prototype.hasOwnProperty.call(moduleMap,module1)?moduleMap[module1]():Promise.resolve().then(()=>{throw new Error('Module "'+module1+'" does not exist in container.')});__webpack_require__.R=undefined;return getScope});__webpack_require__.federation.instance=__webpack_require__.federation.runtime.init(__webpack_require__.federation.initOptions);if((__webpack_require___consumesLoadingData2=__webpack_require__.consumesLoadingData)===null||__webpack_require___consumesLoadingData2===void 0?void 0:__webpack_require___consumesLoadingData2.initialConsumes){__webpack_require__.federation.bundlerRuntime.installInitialConsumes({webpackRequire:__webpack_require__,installedModules:consumesLoadinginstalledModules,initialConsumes:__webpack_require__.consumesLoadingData.initialConsumes,moduleToHandlerMapping:__webpack_require__.federation.consumesLoadingModuleToHandlerMapping})}}

},
88961(__unused_rspack_module, exports, __webpack_require__) {
"use strict";


var sdk = __webpack_require__(7783);
var errorCodes = __webpack_require__(53630);

const LOG_CATEGORY = '[ Federation Runtime ]';
// FIXME: pre-bundle ?
const logger = sdk.createLogger(LOG_CATEGORY);
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function assert(condition, msg) {
    if (!condition) {
        error(msg);
    }
}
function error(msg) {
    if (msg instanceof Error) {
        // Check if the message already starts with the log category to avoid duplication
        if (!msg.message.startsWith(LOG_CATEGORY)) {
            msg.message = `${LOG_CATEGORY}: ${msg.message}`;
        }
        throw msg;
    }
    throw new Error(`${LOG_CATEGORY}: ${msg}`);
}
function warn(msg) {
    if (msg instanceof Error) {
        // Check if the message already starts with the log category to avoid duplication
        if (!msg.message.startsWith(LOG_CATEGORY)) {
            msg.message = `${LOG_CATEGORY}: ${msg.message}`;
        }
        logger.warn(msg);
    }
    else {
        logger.warn(msg);
    }
}

function addUniqueItem(arr, item) {
    if (arr.findIndex((name) => name === item) === -1) {
        arr.push(item);
    }
    return arr;
}
function getFMId(remoteInfo) {
    if ('version' in remoteInfo && remoteInfo.version) {
        return `${remoteInfo.name}:${remoteInfo.version}`;
    }
    else if ('entry' in remoteInfo && remoteInfo.entry) {
        return `${remoteInfo.name}:${remoteInfo.entry}`;
    }
    else {
        return `${remoteInfo.name}`;
    }
}
function isRemoteInfoWithEntry(remote) {
    return typeof remote.entry !== 'undefined';
}
function isPureRemoteEntry(remote) {
    return !remote.entry.includes('.json');
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function safeWrapper(callback, disableWarn) {
    try {
        const res = await callback();
        return res;
    }
    catch (e) {
        !disableWarn && warn(e);
        return;
    }
}
function isObject(val) {
    return val && typeof val === 'object';
}
const objectToString = Object.prototype.toString;
// eslint-disable-next-line @typescript-eslint/ban-types
function isPlainObject(val) {
    return objectToString.call(val) === '[object Object]';
}
function isStaticResourcesEqual(url1, url2) {
    const REG_EXP = /^(https?:)?\/\//i;
    // Transform url1 and url2 into relative paths
    const relativeUrl1 = url1.replace(REG_EXP, '').replace(/\/$/, '');
    const relativeUrl2 = url2.replace(REG_EXP, '').replace(/\/$/, '');
    // Check if the relative paths are identical
    return relativeUrl1 === relativeUrl2;
}
function arrayOptions(options) {
    return Array.isArray(options) ? options : [options];
}
function getRemoteEntryInfoFromSnapshot(snapshot) {
    const defaultRemoteEntryInfo = {
        url: '',
        type: 'global',
        globalName: '',
    };
    if (sdk.isBrowserEnv() || sdk.isReactNativeEnv()) {
        return 'remoteEntry' in snapshot
            ? {
                url: snapshot.remoteEntry,
                type: snapshot.remoteEntryType,
                globalName: snapshot.globalName,
            }
            : defaultRemoteEntryInfo;
    }
    if ('ssrRemoteEntry' in snapshot) {
        return {
            url: snapshot.ssrRemoteEntry || defaultRemoteEntryInfo.url,
            type: snapshot.ssrRemoteEntryType || defaultRemoteEntryInfo.type,
            globalName: snapshot.globalName,
        };
    }
    return defaultRemoteEntryInfo;
}
const processModuleAlias = (name, subPath) => {
    // @host/ ./button -> @host/button
    let moduleName;
    if (name.endsWith('/')) {
        moduleName = name.slice(0, -1);
    }
    else {
        moduleName = name;
    }
    if (subPath.startsWith('.')) {
        subPath = subPath.slice(1);
    }
    moduleName = moduleName + subPath;
    return moduleName;
};

const CurrentGlobal = typeof globalThis === 'object' ? globalThis : window;
const nativeGlobal = (() => {
    try {
        // get real window (incase of sandbox)
        return document.defaultView;
    }
    catch {
        // node env
        return CurrentGlobal;
    }
})();
const Global = nativeGlobal;
function definePropertyGlobalVal(target, key, val) {
    Object.defineProperty(target, key, {
        value: val,
        configurable: false,
        writable: true,
    });
}
function includeOwnProperty(target, key) {
    return Object.hasOwnProperty.call(target, key);
}
// This section is to prevent encapsulation by certain microfrontend frameworks. Due to reuse policies, sandbox escapes.
// The sandbox in the microfrontend does not replicate the value of 'configurable'.
// If there is no loading content on the global object, this section defines the loading object.
if (!includeOwnProperty(CurrentGlobal, '__GLOBAL_LOADING_REMOTE_ENTRY__')) {
    definePropertyGlobalVal(CurrentGlobal, '__GLOBAL_LOADING_REMOTE_ENTRY__', {});
}
const globalLoading = CurrentGlobal.__GLOBAL_LOADING_REMOTE_ENTRY__;
function setGlobalDefaultVal(target) {
    if (includeOwnProperty(target, '__VMOK__') &&
        !includeOwnProperty(target, '__FEDERATION__')) {
        definePropertyGlobalVal(target, '__FEDERATION__', target.__VMOK__);
    }
    if (!includeOwnProperty(target, '__FEDERATION__')) {
        definePropertyGlobalVal(target, '__FEDERATION__', {
            __GLOBAL_PLUGIN__: [],
            __INSTANCES__: [],
            moduleInfo: {},
            __SHARE__: {},
            __MANIFEST_LOADING__: {},
            __PRELOADED_MAP__: new Map(),
        });
        definePropertyGlobalVal(target, '__VMOK__', target.__FEDERATION__);
    }
    target.__FEDERATION__.__GLOBAL_PLUGIN__ ??= [];
    target.__FEDERATION__.__INSTANCES__ ??= [];
    target.__FEDERATION__.moduleInfo ??= {};
    target.__FEDERATION__.__SHARE__ ??= {};
    target.__FEDERATION__.__MANIFEST_LOADING__ ??= {};
    target.__FEDERATION__.__PRELOADED_MAP__ ??= new Map();
}
setGlobalDefaultVal(CurrentGlobal);
setGlobalDefaultVal(nativeGlobal);
function resetFederationGlobalInfo() {
    CurrentGlobal.__FEDERATION__.__GLOBAL_PLUGIN__ = [];
    CurrentGlobal.__FEDERATION__.__INSTANCES__ = [];
    CurrentGlobal.__FEDERATION__.moduleInfo = {};
    CurrentGlobal.__FEDERATION__.__SHARE__ = {};
    CurrentGlobal.__FEDERATION__.__MANIFEST_LOADING__ = {};
    Object.keys(globalLoading).forEach((key) => {
        delete globalLoading[key];
    });
}
function setGlobalFederationInstance(FederationInstance) {
    CurrentGlobal.__FEDERATION__.__INSTANCES__.push(FederationInstance);
}
function getGlobalFederationConstructor() {
    return CurrentGlobal.__FEDERATION__.__DEBUG_CONSTRUCTOR__;
}
function setGlobalFederationConstructor(FederationConstructor, isDebug = sdk.isDebugMode()) {
    if (isDebug) {
        CurrentGlobal.__FEDERATION__.__DEBUG_CONSTRUCTOR__ = FederationConstructor;
        CurrentGlobal.__FEDERATION__.__DEBUG_CONSTRUCTOR_VERSION__ = "0.21.6";
    }
}
// eslint-disable-next-line @typescript-eslint/ban-types
function getInfoWithoutType(target, key) {
    if (typeof key === 'string') {
        const keyRes = target[key];
        if (keyRes) {
            return {
                value: target[key],
                key: key,
            };
        }
        else {
            const targetKeys = Object.keys(target);
            for (const targetKey of targetKeys) {
                const [targetTypeOrName, _] = targetKey.split(':');
                const nKey = `${targetTypeOrName}:${key}`;
                const typeWithKeyRes = target[nKey];
                if (typeWithKeyRes) {
                    return {
                        value: typeWithKeyRes,
                        key: nKey,
                    };
                }
            }
            return {
                value: undefined,
                key: key,
            };
        }
    }
    else {
        throw new Error('key must be string');
    }
}
const getGlobalSnapshot = () => nativeGlobal.__FEDERATION__.moduleInfo;
const getTargetSnapshotInfoByModuleInfo = (moduleInfo, snapshot) => {
    // Check if the remote is included in the hostSnapshot
    const moduleKey = getFMId(moduleInfo);
    const getModuleInfo = getInfoWithoutType(snapshot, moduleKey).value;
    // The remoteSnapshot might not include a version
    if (getModuleInfo &&
        !getModuleInfo.version &&
        'version' in moduleInfo &&
        moduleInfo['version']) {
        getModuleInfo.version = moduleInfo['version'];
    }
    if (getModuleInfo) {
        return getModuleInfo;
    }
    // If the remote is not included in the hostSnapshot, deploy a micro app snapshot
    if ('version' in moduleInfo && moduleInfo['version']) {
        const { version, ...resModuleInfo } = moduleInfo;
        const moduleKeyWithoutVersion = getFMId(resModuleInfo);
        const getModuleInfoWithoutVersion = getInfoWithoutType(nativeGlobal.__FEDERATION__.moduleInfo, moduleKeyWithoutVersion).value;
        if (getModuleInfoWithoutVersion?.version === version) {
            return getModuleInfoWithoutVersion;
        }
    }
    return;
};
const getGlobalSnapshotInfoByModuleInfo = (moduleInfo) => getTargetSnapshotInfoByModuleInfo(moduleInfo, nativeGlobal.__FEDERATION__.moduleInfo);
const setGlobalSnapshotInfoByModuleInfo = (remoteInfo, moduleDetailInfo) => {
    const moduleKey = getFMId(remoteInfo);
    nativeGlobal.__FEDERATION__.moduleInfo[moduleKey] = moduleDetailInfo;
    return nativeGlobal.__FEDERATION__.moduleInfo;
};
const addGlobalSnapshot = (moduleInfos) => {
    nativeGlobal.__FEDERATION__.moduleInfo = {
        ...nativeGlobal.__FEDERATION__.moduleInfo,
        ...moduleInfos,
    };
    return () => {
        const keys = Object.keys(moduleInfos);
        for (const key of keys) {
            delete nativeGlobal.__FEDERATION__.moduleInfo[key];
        }
    };
};
const getRemoteEntryExports = (name, globalName) => {
    const remoteEntryKey = globalName || `__FEDERATION_${name}:custom__`;
    const entryExports = CurrentGlobal[remoteEntryKey];
    return {
        remoteEntryKey,
        entryExports,
    };
};
// This function is used to register global plugins.
// It iterates over the provided plugins and checks if they are already registered.
// If a plugin is not registered, it is added to the global plugins.
// If a plugin is already registered, a warning message is logged.
const registerGlobalPlugins = (plugins) => {
    const { __GLOBAL_PLUGIN__ } = nativeGlobal.__FEDERATION__;
    plugins.forEach((plugin) => {
        if (__GLOBAL_PLUGIN__.findIndex((p) => p.name === plugin.name) === -1) {
            __GLOBAL_PLUGIN__.push(plugin);
        }
        else {
            warn(`The plugin ${plugin.name} has been registered.`);
        }
    });
};
const getGlobalHostPlugins = () => nativeGlobal.__FEDERATION__.__GLOBAL_PLUGIN__;
const getPreloaded = (id) => CurrentGlobal.__FEDERATION__.__PRELOADED_MAP__.get(id);
const setPreloaded = (id) => CurrentGlobal.__FEDERATION__.__PRELOADED_MAP__.set(id, true);

const DEFAULT_SCOPE = 'default';
const DEFAULT_REMOTE_TYPE = 'global';

// fork from https://github.com/originjs/vite-plugin-federation/blob/v1.1.12/packages/lib/src/utils/semver/index.ts
// those constants are based on https://www.rubydoc.info/gems/semantic_range/3.0.0/SemanticRange#BUILDIDENTIFIER-constant
// Copyright (c)
// vite-plugin-federation is licensed under Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at:
//      http://license.coscl.org.cn/MulanPSL2
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
// See the Mulan PSL v2 for more details.
const buildIdentifier = '[0-9A-Za-z-]+';
const build = `(?:\\+(${buildIdentifier}(?:\\.${buildIdentifier})*))`;
const numericIdentifier = '0|[1-9]\\d*';
const numericIdentifierLoose = '[0-9]+';
const nonNumericIdentifier = '\\d*[a-zA-Z-][a-zA-Z0-9-]*';
const preReleaseIdentifierLoose = `(?:${numericIdentifierLoose}|${nonNumericIdentifier})`;
const preReleaseLoose = `(?:-?(${preReleaseIdentifierLoose}(?:\\.${preReleaseIdentifierLoose})*))`;
const preReleaseIdentifier = `(?:${numericIdentifier}|${nonNumericIdentifier})`;
const preRelease = `(?:-(${preReleaseIdentifier}(?:\\.${preReleaseIdentifier})*))`;
const xRangeIdentifier = `${numericIdentifier}|x|X|\\*`;
const xRangePlain = `[v=\\s]*(${xRangeIdentifier})(?:\\.(${xRangeIdentifier})(?:\\.(${xRangeIdentifier})(?:${preRelease})?${build}?)?)?`;
const hyphenRange = `^\\s*(${xRangePlain})\\s+-\\s+(${xRangePlain})\\s*$`;
const mainVersionLoose = `(${numericIdentifierLoose})\\.(${numericIdentifierLoose})\\.(${numericIdentifierLoose})`;
const loosePlain = `[v=\\s]*${mainVersionLoose}${preReleaseLoose}?${build}?`;
const gtlt = '((?:<|>)?=?)';
const comparatorTrim = `(\\s*)${gtlt}\\s*(${loosePlain}|${xRangePlain})`;
const loneTilde = '(?:~>?)';
const tildeTrim = `(\\s*)${loneTilde}\\s+`;
const loneCaret = '(?:\\^)';
const caretTrim = `(\\s*)${loneCaret}\\s+`;
const star = '(<|>)?=?\\s*\\*';
const caret = `^${loneCaret}${xRangePlain}$`;
const mainVersion = `(${numericIdentifier})\\.(${numericIdentifier})\\.(${numericIdentifier})`;
const fullPlain = `v?${mainVersion}${preRelease}?${build}?`;
const tilde = `^${loneTilde}${xRangePlain}$`;
const xRange = `^${gtlt}\\s*${xRangePlain}$`;
const comparator = `^${gtlt}\\s*(${fullPlain})$|^$`;
// copy from semver package
const gte0 = '^\\s*>=\\s*0.0.0\\s*$';

// fork from https://github.com/originjs/vite-plugin-federation/blob/v1.1.12/packages/lib/src/utils/semver/index.ts
// Copyright (c)
// vite-plugin-federation is licensed under Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at:
//      http://license.coscl.org.cn/MulanPSL2
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
// See the Mulan PSL v2 for more details.
function parseRegex(source) {
    return new RegExp(source);
}
function isXVersion(version) {
    return !version || version.toLowerCase() === 'x' || version === '*';
}
function pipe(...fns) {
    return (x) => fns.reduce((v, f) => f(v), x);
}
function extractComparator(comparatorString) {
    return comparatorString.match(parseRegex(comparator));
}
function combineVersion(major, minor, patch, preRelease) {
    const mainVersion = `${major}.${minor}.${patch}`;
    if (preRelease) {
        return `${mainVersion}-${preRelease}`;
    }
    return mainVersion;
}

// fork from https://github.com/originjs/vite-plugin-federation/blob/v1.1.12/packages/lib/src/utils/semver/index.ts
// Copyright (c)
// vite-plugin-federation is licensed under Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at:
//      http://license.coscl.org.cn/MulanPSL2
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
// See the Mulan PSL v2 for more details.
function parseHyphen(range) {
    return range.replace(parseRegex(hyphenRange), (_range, from, fromMajor, fromMinor, fromPatch, _fromPreRelease, _fromBuild, to, toMajor, toMinor, toPatch, toPreRelease) => {
        if (isXVersion(fromMajor)) {
            from = '';
        }
        else if (isXVersion(fromMinor)) {
            from = `>=${fromMajor}.0.0`;
        }
        else if (isXVersion(fromPatch)) {
            from = `>=${fromMajor}.${fromMinor}.0`;
        }
        else {
            from = `>=${from}`;
        }
        if (isXVersion(toMajor)) {
            to = '';
        }
        else if (isXVersion(toMinor)) {
            to = `<${Number(toMajor) + 1}.0.0-0`;
        }
        else if (isXVersion(toPatch)) {
            to = `<${toMajor}.${Number(toMinor) + 1}.0-0`;
        }
        else if (toPreRelease) {
            to = `<=${toMajor}.${toMinor}.${toPatch}-${toPreRelease}`;
        }
        else {
            to = `<=${to}`;
        }
        return `${from} ${to}`.trim();
    });
}
function parseComparatorTrim(range) {
    return range.replace(parseRegex(comparatorTrim), '$1$2$3');
}
function parseTildeTrim(range) {
    return range.replace(parseRegex(tildeTrim), '$1~');
}
function parseCaretTrim(range) {
    return range.replace(parseRegex(caretTrim), '$1^');
}
function parseCarets(range) {
    return range
        .trim()
        .split(/\s+/)
        .map((rangeVersion) => rangeVersion.replace(parseRegex(caret), (_, major, minor, patch, preRelease) => {
        if (isXVersion(major)) {
            return '';
        }
        else if (isXVersion(minor)) {
            return `>=${major}.0.0 <${Number(major) + 1}.0.0-0`;
        }
        else if (isXVersion(patch)) {
            if (major === '0') {
                return `>=${major}.${minor}.0 <${major}.${Number(minor) + 1}.0-0`;
            }
            else {
                return `>=${major}.${minor}.0 <${Number(major) + 1}.0.0-0`;
            }
        }
        else if (preRelease) {
            if (major === '0') {
                if (minor === '0') {
                    return `>=${major}.${minor}.${patch}-${preRelease} <${major}.${minor}.${Number(patch) + 1}-0`;
                }
                else {
                    return `>=${major}.${minor}.${patch}-${preRelease} <${major}.${Number(minor) + 1}.0-0`;
                }
            }
            else {
                return `>=${major}.${minor}.${patch}-${preRelease} <${Number(major) + 1}.0.0-0`;
            }
        }
        else {
            if (major === '0') {
                if (minor === '0') {
                    return `>=${major}.${minor}.${patch} <${major}.${minor}.${Number(patch) + 1}-0`;
                }
                else {
                    return `>=${major}.${minor}.${patch} <${major}.${Number(minor) + 1}.0-0`;
                }
            }
            return `>=${major}.${minor}.${patch} <${Number(major) + 1}.0.0-0`;
        }
    }))
        .join(' ');
}
function parseTildes(range) {
    return range
        .trim()
        .split(/\s+/)
        .map((rangeVersion) => rangeVersion.replace(parseRegex(tilde), (_, major, minor, patch, preRelease) => {
        if (isXVersion(major)) {
            return '';
        }
        else if (isXVersion(minor)) {
            return `>=${major}.0.0 <${Number(major) + 1}.0.0-0`;
        }
        else if (isXVersion(patch)) {
            return `>=${major}.${minor}.0 <${major}.${Number(minor) + 1}.0-0`;
        }
        else if (preRelease) {
            return `>=${major}.${minor}.${patch}-${preRelease} <${major}.${Number(minor) + 1}.0-0`;
        }
        return `>=${major}.${minor}.${patch} <${major}.${Number(minor) + 1}.0-0`;
    }))
        .join(' ');
}
function parseXRanges(range) {
    return range
        .split(/\s+/)
        .map((rangeVersion) => rangeVersion
        .trim()
        .replace(parseRegex(xRange), (ret, gtlt, major, minor, patch, preRelease) => {
        const isXMajor = isXVersion(major);
        const isXMinor = isXMajor || isXVersion(minor);
        const isXPatch = isXMinor || isXVersion(patch);
        if (gtlt === '=' && isXPatch) {
            gtlt = '';
        }
        preRelease = '';
        if (isXMajor) {
            if (gtlt === '>' || gtlt === '<') {
                // nothing is allowed
                return '<0.0.0-0';
            }
            else {
                // nothing is forbidden
                return '*';
            }
        }
        else if (gtlt && isXPatch) {
            // replace X with 0
            if (isXMinor) {
                minor = 0;
            }
            patch = 0;
            if (gtlt === '>') {
                // >1 => >=2.0.0
                // >1.2 => >=1.3.0
                gtlt = '>=';
                if (isXMinor) {
                    major = Number(major) + 1;
                    minor = 0;
                    patch = 0;
                }
                else {
                    minor = Number(minor) + 1;
                    patch = 0;
                }
            }
            else if (gtlt === '<=') {
                // <=0.7.x is actually <0.8.0, since any 0.7.x should pass
                // Similarly, <=7.x is actually <8.0.0, etc.
                gtlt = '<';
                if (isXMinor) {
                    major = Number(major) + 1;
                }
                else {
                    minor = Number(minor) + 1;
                }
            }
            if (gtlt === '<') {
                preRelease = '-0';
            }
            return `${gtlt + major}.${minor}.${patch}${preRelease}`;
        }
        else if (isXMinor) {
            return `>=${major}.0.0${preRelease} <${Number(major) + 1}.0.0-0`;
        }
        else if (isXPatch) {
            return `>=${major}.${minor}.0${preRelease} <${major}.${Number(minor) + 1}.0-0`;
        }
        return ret;
    }))
        .join(' ');
}
function parseStar(range) {
    return range.trim().replace(parseRegex(star), '');
}
function parseGTE0(comparatorString) {
    return comparatorString.trim().replace(parseRegex(gte0), '');
}

// fork from https://github.com/originjs/vite-plugin-federation/blob/v1.1.12/packages/lib/src/utils/semver/index.ts
// Copyright (c)
// vite-plugin-federation is licensed under Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at:
//      http://license.coscl.org.cn/MulanPSL2
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
// See the Mulan PSL v2 for more details.
function compareAtom(rangeAtom, versionAtom) {
    rangeAtom = Number(rangeAtom) || rangeAtom;
    versionAtom = Number(versionAtom) || versionAtom;
    if (rangeAtom > versionAtom) {
        return 1;
    }
    if (rangeAtom === versionAtom) {
        return 0;
    }
    return -1;
}
function comparePreRelease(rangeAtom, versionAtom) {
    const { preRelease: rangePreRelease } = rangeAtom;
    const { preRelease: versionPreRelease } = versionAtom;
    if (rangePreRelease === undefined && Boolean(versionPreRelease)) {
        return 1;
    }
    if (Boolean(rangePreRelease) && versionPreRelease === undefined) {
        return -1;
    }
    if (rangePreRelease === undefined && versionPreRelease === undefined) {
        return 0;
    }
    for (let i = 0, n = rangePreRelease.length; i <= n; i++) {
        const rangeElement = rangePreRelease[i];
        const versionElement = versionPreRelease[i];
        if (rangeElement === versionElement) {
            continue;
        }
        if (rangeElement === undefined && versionElement === undefined) {
            return 0;
        }
        if (!rangeElement) {
            return 1;
        }
        if (!versionElement) {
            return -1;
        }
        return compareAtom(rangeElement, versionElement);
    }
    return 0;
}
function compareVersion(rangeAtom, versionAtom) {
    return (compareAtom(rangeAtom.major, versionAtom.major) ||
        compareAtom(rangeAtom.minor, versionAtom.minor) ||
        compareAtom(rangeAtom.patch, versionAtom.patch) ||
        comparePreRelease(rangeAtom, versionAtom));
}
function eq(rangeAtom, versionAtom) {
    return rangeAtom.version === versionAtom.version;
}
function compare(rangeAtom, versionAtom) {
    switch (rangeAtom.operator) {
        case '':
        case '=':
            return eq(rangeAtom, versionAtom);
        case '>':
            return compareVersion(rangeAtom, versionAtom) < 0;
        case '>=':
            return (eq(rangeAtom, versionAtom) || compareVersion(rangeAtom, versionAtom) < 0);
        case '<':
            return compareVersion(rangeAtom, versionAtom) > 0;
        case '<=':
            return (eq(rangeAtom, versionAtom) || compareVersion(rangeAtom, versionAtom) > 0);
        case undefined: {
            // mean * or x -> all versions
            return true;
        }
        default:
            return false;
    }
}

// fork from https://github.com/originjs/vite-plugin-federation/blob/v1.1.12/packages/lib/src/utils/semver/index.ts
// Copyright (c)
// vite-plugin-federation is licensed under Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at:
//      http://license.coscl.org.cn/MulanPSL2
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
// See the Mulan PSL v2 for more details.
function parseComparatorString(range) {
    return pipe(
    // handle caret
    // ^ --> * (any, kinda silly)
    // ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0-0
    // ^2.0, ^2.0.x --> >=2.0.0 <3.0.0-0
    // ^1.2, ^1.2.x --> >=1.2.0 <2.0.0-0
    // ^1.2.3 --> >=1.2.3 <2.0.0-0
    // ^1.2.0 --> >=1.2.0 <2.0.0-0
    parseCarets, 
    // handle tilde
    // ~, ~> --> * (any, kinda silly)
    // ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0-0
    // ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0-0
    // ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0-0
    // ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0-0
    // ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0-0
    parseTildes, parseXRanges, parseStar)(range);
}
function parseRange(range) {
    return pipe(
    // handle hyphenRange
    // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`
    parseHyphen, 
    // handle trim comparator
    // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`
    parseComparatorTrim, 
    // handle trim tilde
    // `~ 1.2.3` => `~1.2.3`
    parseTildeTrim, 
    // handle trim caret
    // `^ 1.2.3` => `^1.2.3`
    parseCaretTrim)(range.trim())
        .split(/\s+/)
        .join(' ');
}
function satisfy(version, range) {
    if (!version) {
        return false;
    }
    // Extract version details once
    const extractedVersion = extractComparator(version);
    if (!extractedVersion) {
        // If the version string is invalid, it can't satisfy any range
        return false;
    }
    const [, versionOperator, , versionMajor, versionMinor, versionPatch, versionPreRelease,] = extractedVersion;
    const versionAtom = {
        operator: versionOperator,
        version: combineVersion(versionMajor, versionMinor, versionPatch, versionPreRelease), // exclude build atom
        major: versionMajor,
        minor: versionMinor,
        patch: versionPatch,
        preRelease: versionPreRelease?.split('.'),
    };
    // Split the range by || to handle OR conditions
    const orRanges = range.split('||');
    for (const orRange of orRanges) {
        const trimmedOrRange = orRange.trim();
        if (!trimmedOrRange) {
            // An empty range string signifies wildcard *, satisfy any valid version
            // (We already checked if the version itself is valid)
            return true;
        }
        // Handle simple wildcards explicitly before complex parsing
        if (trimmedOrRange === '*' || trimmedOrRange === 'x') {
            return true;
        }
        try {
            // Apply existing parsing logic to the current OR sub-range
            const parsedSubRange = parseRange(trimmedOrRange); // Handles hyphens, trims etc.
            // Check if the result of initial parsing is empty, which can happen
            // for some wildcard cases handled by parseRange/parseComparatorString.
            // E.g. `parseStar` used in `parseComparatorString` returns ''.
            if (!parsedSubRange.trim()) {
                // If parsing results in empty string, treat as wildcard match
                return true;
            }
            const parsedComparatorString = parsedSubRange
                .split(' ')
                .map((rangeVersion) => parseComparatorString(rangeVersion)) // Expands ^, ~
                .join(' ');
            // Check again if the comparator string became empty after specific parsing like ^ or ~
            if (!parsedComparatorString.trim()) {
                return true;
            }
            // Split the sub-range by space for implicit AND conditions
            const comparators = parsedComparatorString
                .split(/\s+/)
                .map((comparator) => parseGTE0(comparator))
                // Filter out empty strings that might result from multiple spaces
                .filter(Boolean);
            // If a sub-range becomes empty after parsing (e.g., invalid characters),
            // it cannot be satisfied. This check might be redundant now but kept for safety.
            if (comparators.length === 0) {
                continue;
            }
            let subRangeSatisfied = true;
            for (const comparator of comparators) {
                const extractedComparator = extractComparator(comparator);
                // If any part of the AND sub-range is invalid, the sub-range is not satisfied
                if (!extractedComparator) {
                    subRangeSatisfied = false;
                    break;
                }
                const [, rangeOperator, , rangeMajor, rangeMinor, rangePatch, rangePreRelease,] = extractedComparator;
                const rangeAtom = {
                    operator: rangeOperator,
                    version: combineVersion(rangeMajor, rangeMinor, rangePatch, rangePreRelease),
                    major: rangeMajor,
                    minor: rangeMinor,
                    patch: rangePatch,
                    preRelease: rangePreRelease?.split('.'),
                };
                // Check if the version satisfies this specific comparator in the AND chain
                if (!compare(rangeAtom, versionAtom)) {
                    subRangeSatisfied = false; // This part of the AND condition failed
                    break; // No need to check further comparators in this sub-range
                }
            }
            // If all AND conditions within this OR sub-range were met, the overall range is satisfied
            if (subRangeSatisfied) {
                return true;
            }
        }
        catch (e) {
            // Log error and treat this sub-range as unsatisfied
            console.error(`[semver] Error processing range part "${trimmedOrRange}":`, e);
            continue;
        }
    }
    // If none of the OR sub-ranges were satisfied
    return false;
}

function formatShare(shareArgs, from, name, shareStrategy) {
    let get;
    if ('get' in shareArgs) {
        // eslint-disable-next-line prefer-destructuring
        get = shareArgs.get;
    }
    else if ('lib' in shareArgs) {
        get = () => Promise.resolve(shareArgs.lib);
    }
    else {
        get = () => Promise.resolve(() => {
            throw new Error(`Can not get shared '${name}'!`);
        });
    }
    return {
        deps: [],
        useIn: [],
        from,
        loading: null,
        ...shareArgs,
        shareConfig: {
            requiredVersion: `^${shareArgs.version}`,
            singleton: false,
            eager: false,
            strictVersion: false,
            ...shareArgs.shareConfig,
        },
        get,
        loaded: shareArgs?.loaded || 'lib' in shareArgs ? true : undefined,
        version: shareArgs.version ?? '0',
        scope: Array.isArray(shareArgs.scope)
            ? shareArgs.scope
            : [shareArgs.scope ?? 'default'],
        strategy: (shareArgs.strategy ?? shareStrategy) || 'version-first',
    };
}
function formatShareConfigs(globalOptions, userOptions) {
    const shareArgs = userOptions.shared || {};
    const from = userOptions.name;
    const shareInfos = Object.keys(shareArgs).reduce((res, pkgName) => {
        const arrayShareArgs = arrayOptions(shareArgs[pkgName]);
        res[pkgName] = res[pkgName] || [];
        arrayShareArgs.forEach((shareConfig) => {
            res[pkgName].push(formatShare(shareConfig, from, pkgName, userOptions.shareStrategy));
        });
        return res;
    }, {});
    const shared = {
        ...globalOptions.shared,
    };
    Object.keys(shareInfos).forEach((shareKey) => {
        if (!shared[shareKey]) {
            shared[shareKey] = shareInfos[shareKey];
        }
        else {
            shareInfos[shareKey].forEach((newUserSharedOptions) => {
                const isSameVersion = shared[shareKey].find((sharedVal) => sharedVal.version === newUserSharedOptions.version);
                if (!isSameVersion) {
                    shared[shareKey].push(newUserSharedOptions);
                }
            });
        }
    });
    return { shared, shareInfos };
}
function versionLt(a, b) {
    const transformInvalidVersion = (version) => {
        const isNumberVersion = !Number.isNaN(Number(version));
        if (isNumberVersion) {
            const splitArr = version.split('.');
            let validVersion = version;
            for (let i = 0; i < 3 - splitArr.length; i++) {
                validVersion += '.0';
            }
            return validVersion;
        }
        return version;
    };
    if (satisfy(transformInvalidVersion(a), `<=${transformInvalidVersion(b)}`)) {
        return true;
    }
    else {
        return false;
    }
}
const findVersion = (shareVersionMap, cb) => {
    const callback = cb ||
        function (prev, cur) {
            return versionLt(prev, cur);
        };
    return Object.keys(shareVersionMap).reduce((prev, cur) => {
        if (!prev) {
            return cur;
        }
        if (callback(prev, cur)) {
            return cur;
        }
        // default version is '0' https://github.com/webpack/webpack/blob/main/lib/sharing/ProvideSharedModule.js#L136
        if (prev === '0') {
            return cur;
        }
        return prev;
    }, 0);
};
const isLoaded = (shared) => {
    return Boolean(shared.loaded) || typeof shared.lib === 'function';
};
const isLoading = (shared) => {
    return Boolean(shared.loading);
};
function findSingletonVersionOrderByVersion(shareScopeMap, scope, pkgName) {
    const versions = shareScopeMap[scope][pkgName];
    const callback = function (prev, cur) {
        return !isLoaded(versions[prev]) && versionLt(prev, cur);
    };
    return findVersion(shareScopeMap[scope][pkgName], callback);
}
function findSingletonVersionOrderByLoaded(shareScopeMap, scope, pkgName) {
    const versions = shareScopeMap[scope][pkgName];
    const callback = function (prev, cur) {
        const isLoadingOrLoaded = (shared) => {
            return isLoaded(shared) || isLoading(shared);
        };
        if (isLoadingOrLoaded(versions[cur])) {
            if (isLoadingOrLoaded(versions[prev])) {
                return Boolean(versionLt(prev, cur));
            }
            else {
                return true;
            }
        }
        if (isLoadingOrLoaded(versions[prev])) {
            return false;
        }
        return versionLt(prev, cur);
    };
    return findVersion(shareScopeMap[scope][pkgName], callback);
}
function getFindShareFunction(strategy) {
    if (strategy === 'loaded-first') {
        return findSingletonVersionOrderByLoaded;
    }
    return findSingletonVersionOrderByVersion;
}
function getRegisteredShare(localShareScopeMap, pkgName, shareInfo, resolveShare) {
    if (!localShareScopeMap) {
        return;
    }
    const { shareConfig, scope = DEFAULT_SCOPE, strategy } = shareInfo;
    const scopes = Array.isArray(scope) ? scope : [scope];
    for (const sc of scopes) {
        if (shareConfig &&
            localShareScopeMap[sc] &&
            localShareScopeMap[sc][pkgName]) {
            const { requiredVersion } = shareConfig;
            const findShareFunction = getFindShareFunction(strategy);
            const maxOrSingletonVersion = findShareFunction(localShareScopeMap, sc, pkgName);
            //@ts-ignore
            const defaultResolver = () => {
                if (shareConfig.singleton) {
                    if (typeof requiredVersion === 'string' &&
                        !satisfy(maxOrSingletonVersion, requiredVersion)) {
                        const msg = `Version ${maxOrSingletonVersion} from ${maxOrSingletonVersion &&
                            localShareScopeMap[sc][pkgName][maxOrSingletonVersion].from} of shared singleton module ${pkgName} does not satisfy the requirement of ${shareInfo.from} which needs ${requiredVersion})`;
                        if (shareConfig.strictVersion) {
                            error(msg);
                        }
                        else {
                            warn(msg);
                        }
                    }
                    return localShareScopeMap[sc][pkgName][maxOrSingletonVersion];
                }
                else {
                    if (requiredVersion === false || requiredVersion === '*') {
                        return localShareScopeMap[sc][pkgName][maxOrSingletonVersion];
                    }
                    if (satisfy(maxOrSingletonVersion, requiredVersion)) {
                        return localShareScopeMap[sc][pkgName][maxOrSingletonVersion];
                    }
                    for (const [versionKey, versionValue] of Object.entries(localShareScopeMap[sc][pkgName])) {
                        if (satisfy(versionKey, requiredVersion)) {
                            return versionValue;
                        }
                    }
                }
            };
            const params = {
                shareScopeMap: localShareScopeMap,
                scope: sc,
                pkgName,
                version: maxOrSingletonVersion,
                GlobalFederation: Global.__FEDERATION__,
                resolver: defaultResolver,
            };
            const resolveShared = resolveShare.emit(params) || params;
            return resolveShared.resolver();
        }
    }
}
function getGlobalShareScope() {
    return Global.__FEDERATION__.__SHARE__;
}
function getTargetSharedOptions(options) {
    const { pkgName, extraOptions, shareInfos } = options;
    const defaultResolver = (sharedOptions) => {
        if (!sharedOptions) {
            return undefined;
        }
        const shareVersionMap = {};
        sharedOptions.forEach((shared) => {
            shareVersionMap[shared.version] = shared;
        });
        const callback = function (prev, cur) {
            return !isLoaded(shareVersionMap[prev]) && versionLt(prev, cur);
        };
        const maxVersion = findVersion(shareVersionMap, callback);
        return shareVersionMap[maxVersion];
    };
    const resolver = extraOptions?.resolver ?? defaultResolver;
    return Object.assign({}, resolver(shareInfos[pkgName]), extraOptions?.customShareInfo);
}

function getBuilderId() {
    //@ts-ignore
    return typeof FEDERATION_BUILD_IDENTIFIER !== 'undefined'
        ? //@ts-ignore
            FEDERATION_BUILD_IDENTIFIER
        : '';
}

// Function to match a remote with its name and expose
// id: pkgName(@federation/app1) + expose(button) = @federation/app1/button
// id: alias(app1) + expose(button) = app1/button
// id: alias(app1/utils) + expose(loadash/sort) = app1/utils/loadash/sort
function matchRemoteWithNameAndExpose(remotes, id) {
    for (const remote of remotes) {
        // match pkgName
        const isNameMatched = id.startsWith(remote.name);
        let expose = id.replace(remote.name, '');
        if (isNameMatched) {
            if (expose.startsWith('/')) {
                const pkgNameOrAlias = remote.name;
                expose = `.${expose}`;
                return {
                    pkgNameOrAlias,
                    expose,
                    remote,
                };
            }
            else if (expose === '') {
                return {
                    pkgNameOrAlias: remote.name,
                    expose: '.',
                    remote,
                };
            }
        }
        // match alias
        const isAliasMatched = remote.alias && id.startsWith(remote.alias);
        let exposeWithAlias = remote.alias && id.replace(remote.alias, '');
        if (remote.alias && isAliasMatched) {
            if (exposeWithAlias && exposeWithAlias.startsWith('/')) {
                const pkgNameOrAlias = remote.alias;
                exposeWithAlias = `.${exposeWithAlias}`;
                return {
                    pkgNameOrAlias,
                    expose: exposeWithAlias,
                    remote,
                };
            }
            else if (exposeWithAlias === '') {
                return {
                    pkgNameOrAlias: remote.alias,
                    expose: '.',
                    remote,
                };
            }
        }
    }
    return;
}
// Function to match a remote with its name or alias
function matchRemote(remotes, nameOrAlias) {
    for (const remote of remotes) {
        const isNameMatched = nameOrAlias === remote.name;
        if (isNameMatched) {
            return remote;
        }
        const isAliasMatched = remote.alias && nameOrAlias === remote.alias;
        if (isAliasMatched) {
            return remote;
        }
    }
    return;
}

function registerPlugins(plugins, instance) {
    const globalPlugins = getGlobalHostPlugins();
    const hookInstances = [
        instance.hooks,
        instance.remoteHandler.hooks,
        instance.sharedHandler.hooks,
        instance.snapshotHandler.hooks,
        instance.loaderHook,
        instance.bridgeHook,
    ];
    // Incorporate global plugins
    if (globalPlugins.length > 0) {
        globalPlugins.forEach((plugin) => {
            if (plugins?.find((item) => item.name !== plugin.name)) {
                plugins.push(plugin);
            }
        });
    }
    if (plugins && plugins.length > 0) {
        plugins.forEach((plugin) => {
            hookInstances.forEach((hookInstance) => {
                hookInstance.applyPlugin(plugin, instance);
            });
        });
    }
    return plugins;
}

const importCallback = '.then(callbacks[0]).catch(callbacks[1])';
async function loadEsmEntry({ entry, remoteEntryExports, }) {
    return new Promise((resolve, reject) => {
        try {
            if (!remoteEntryExports) {
                if (typeof FEDERATION_ALLOW_NEW_FUNCTION !== 'undefined') {
                    new Function('callbacks', `import("${entry}")${importCallback}`)([
                        resolve,
                        reject,
                    ]);
                }
                else {
                    import(/* webpackIgnore: true */ /* @vite-ignore */ entry)
                        .then(resolve)
                        .catch(reject);
                }
            }
            else {
                resolve(remoteEntryExports);
            }
        }
        catch (e) {
            reject(e);
        }
    });
}
async function loadSystemJsEntry({ entry, remoteEntryExports, }) {
    return new Promise((resolve, reject) => {
        try {
            if (!remoteEntryExports) {
                //@ts-ignore
                if (false) {}
                else {
                    new Function('callbacks', `System.import("${entry}")${importCallback}`)([resolve, reject]);
                }
            }
            else {
                resolve(remoteEntryExports);
            }
        }
        catch (e) {
            reject(e);
        }
    });
}
function handleRemoteEntryLoaded(name, globalName, entry) {
    const { remoteEntryKey, entryExports } = getRemoteEntryExports(name, globalName);
    assert(entryExports, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_001, errorCodes.runtimeDescMap, {
        remoteName: name,
        remoteEntryUrl: entry,
        remoteEntryKey,
    }));
    return entryExports;
}
async function loadEntryScript({ name, globalName, entry, loaderHook, getEntryUrl, }) {
    const { entryExports: remoteEntryExports } = getRemoteEntryExports(name, globalName);
    if (remoteEntryExports) {
        return remoteEntryExports;
    }
    // if getEntryUrl is passed, use the getEntryUrl to get the entry url
    const url = getEntryUrl ? getEntryUrl(entry) : entry;
    return sdk.loadScript(url, {
        attrs: {},
        createScriptHook: (url, attrs) => {
            const res = loaderHook.lifecycle.createScript.emit({ url, attrs });
            if (!res)
                return;
            if (res instanceof HTMLScriptElement) {
                return res;
            }
            if ('script' in res || 'timeout' in res) {
                return res;
            }
            return;
        },
    })
        .then(() => {
        return handleRemoteEntryLoaded(name, globalName, entry);
    })
        .catch((e) => {
        assert(undefined, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_008, errorCodes.runtimeDescMap, {
            remoteName: name,
            resourceUrl: entry,
        }));
        throw e;
    });
}
async function loadEntryDom({ remoteInfo, remoteEntryExports, loaderHook, getEntryUrl, }) {
    const { entry, entryGlobalName: globalName, name, type } = remoteInfo;
    switch (type) {
        case 'esm':
        case 'module':
            return loadEsmEntry({ entry, remoteEntryExports });
        case 'system':
            return loadSystemJsEntry({ entry, remoteEntryExports });
        default:
            return loadEntryScript({
                entry,
                globalName,
                name,
                loaderHook,
                getEntryUrl,
            });
    }
}
async function loadEntryNode({ remoteInfo, loaderHook, }) {
    const { entry, entryGlobalName: globalName, name, type } = remoteInfo;
    const { entryExports: remoteEntryExports } = getRemoteEntryExports(name, globalName);
    if (remoteEntryExports) {
        return remoteEntryExports;
    }
    return sdk.loadScriptNode(entry, {
        attrs: { name, globalName, type },
        loaderHook: {
            createScriptHook: (url, attrs = {}) => {
                const res = loaderHook.lifecycle.createScript.emit({ url, attrs });
                if (!res)
                    return;
                if ('url' in res) {
                    return res;
                }
                return;
            },
        },
    })
        .then(() => {
        return handleRemoteEntryLoaded(name, globalName, entry);
    })
        .catch((e) => {
        throw e;
    });
}
function getRemoteEntryUniqueKey(remoteInfo) {
    const { entry, name } = remoteInfo;
    return sdk.composeKeyWithSeparator(name, entry);
}
async function getRemoteEntry(params) {
    const { origin, remoteEntryExports, remoteInfo, getEntryUrl, _inErrorHandling = false, } = params;
    const uniqueKey = getRemoteEntryUniqueKey(remoteInfo);
    if (remoteEntryExports) {
        return remoteEntryExports;
    }
    if (!globalLoading[uniqueKey]) {
        const loadEntryHook = origin.remoteHandler.hooks.lifecycle.loadEntry;
        const loaderHook = origin.loaderHook;
        globalLoading[uniqueKey] = loadEntryHook
            .emit({
            loaderHook,
            remoteInfo,
            remoteEntryExports,
        })
            .then((res) => {
            if (res) {
                return res;
            }
            // Use ENV_TARGET if defined, otherwise fallback to isBrowserEnv, must keep this
            const isWebEnvironment = typeof ENV_TARGET !== 'undefined'
                ? ENV_TARGET === 'web'
                : sdk.isBrowserEnv();
            return isWebEnvironment
                ? loadEntryDom({
                    remoteInfo,
                    remoteEntryExports,
                    loaderHook,
                    getEntryUrl,
                })
                : loadEntryNode({ remoteInfo, loaderHook });
        })
            .catch(async (err) => {
            const uniqueKey = getRemoteEntryUniqueKey(remoteInfo);
            const isScriptLoadError = err instanceof Error && err.message.includes(errorCodes.RUNTIME_008);
            if (isScriptLoadError && !_inErrorHandling) {
                const wrappedGetRemoteEntry = (params) => {
                    return getRemoteEntry({ ...params, _inErrorHandling: true });
                };
                const RemoteEntryExports = await origin.loaderHook.lifecycle.loadEntryError.emit({
                    getRemoteEntry: wrappedGetRemoteEntry,
                    origin,
                    remoteInfo: remoteInfo,
                    remoteEntryExports,
                    globalLoading,
                    uniqueKey,
                });
                if (RemoteEntryExports) {
                    return RemoteEntryExports;
                }
            }
            throw err;
        });
    }
    return globalLoading[uniqueKey];
}
function getRemoteInfo(remote) {
    return {
        ...remote,
        entry: 'entry' in remote ? remote.entry : '',
        type: remote.type || DEFAULT_REMOTE_TYPE,
        entryGlobalName: remote.entryGlobalName || remote.name,
        shareScope: remote.shareScope || DEFAULT_SCOPE,
    };
}

function defaultPreloadArgs(preloadConfig) {
    return {
        resourceCategory: 'sync',
        share: true,
        depsRemote: true,
        prefetchInterface: false,
        ...preloadConfig,
    };
}
function formatPreloadArgs(remotes, preloadArgs) {
    return preloadArgs.map((args) => {
        const remoteInfo = matchRemote(remotes, args.nameOrAlias);
        assert(remoteInfo, `Unable to preload ${args.nameOrAlias} as it is not included in ${!remoteInfo &&
            sdk.safeToString({
                remoteInfo,
                remotes,
            })}`);
        return {
            remote: remoteInfo,
            preloadConfig: defaultPreloadArgs(args),
        };
    });
}
function normalizePreloadExposes(exposes) {
    if (!exposes) {
        return [];
    }
    return exposes.map((expose) => {
        if (expose === '.') {
            return expose;
        }
        if (expose.startsWith('./')) {
            return expose.replace('./', '');
        }
        return expose;
    });
}
function preloadAssets(remoteInfo, host, assets, 
// It is used to distinguish preload from load remote parallel loading
useLinkPreload = true) {
    const { cssAssets, jsAssetsWithoutEntry, entryAssets } = assets;
    if (host.options.inBrowser) {
        entryAssets.forEach((asset) => {
            const { moduleInfo } = asset;
            const module = host.moduleCache.get(remoteInfo.name);
            if (module) {
                getRemoteEntry({
                    origin: host,
                    remoteInfo: moduleInfo,
                    remoteEntryExports: module.remoteEntryExports,
                });
            }
            else {
                getRemoteEntry({
                    origin: host,
                    remoteInfo: moduleInfo,
                    remoteEntryExports: undefined,
                });
            }
        });
        if (useLinkPreload) {
            const defaultAttrs = {
                rel: 'preload',
                as: 'style',
            };
            cssAssets.forEach((cssUrl) => {
                const { link: cssEl, needAttach } = sdk.createLink({
                    url: cssUrl,
                    cb: () => {
                        // noop
                    },
                    attrs: defaultAttrs,
                    createLinkHook: (url, attrs) => {
                        const res = host.loaderHook.lifecycle.createLink.emit({
                            url,
                            attrs,
                        });
                        if (res instanceof HTMLLinkElement) {
                            return res;
                        }
                        return;
                    },
                });
                needAttach && document.head.appendChild(cssEl);
            });
        }
        else {
            const defaultAttrs = {
                rel: 'stylesheet',
                type: 'text/css',
            };
            cssAssets.forEach((cssUrl) => {
                const { link: cssEl, needAttach } = sdk.createLink({
                    url: cssUrl,
                    cb: () => {
                        // noop
                    },
                    attrs: defaultAttrs,
                    createLinkHook: (url, attrs) => {
                        const res = host.loaderHook.lifecycle.createLink.emit({
                            url,
                            attrs,
                        });
                        if (res instanceof HTMLLinkElement) {
                            return res;
                        }
                        return;
                    },
                    needDeleteLink: false,
                });
                needAttach && document.head.appendChild(cssEl);
            });
        }
        if (useLinkPreload) {
            const defaultAttrs = {
                rel: 'preload',
                as: 'script',
            };
            jsAssetsWithoutEntry.forEach((jsUrl) => {
                const { link: linkEl, needAttach } = sdk.createLink({
                    url: jsUrl,
                    cb: () => {
                        // noop
                    },
                    attrs: defaultAttrs,
                    createLinkHook: (url, attrs) => {
                        const res = host.loaderHook.lifecycle.createLink.emit({
                            url,
                            attrs,
                        });
                        if (res instanceof HTMLLinkElement) {
                            return res;
                        }
                        return;
                    },
                });
                needAttach && document.head.appendChild(linkEl);
            });
        }
        else {
            const defaultAttrs = {
                fetchpriority: 'high',
                type: remoteInfo?.type === 'module' ? 'module' : 'text/javascript',
            };
            jsAssetsWithoutEntry.forEach((jsUrl) => {
                const { script: scriptEl, needAttach } = sdk.createScript({
                    url: jsUrl,
                    cb: () => {
                        // noop
                    },
                    attrs: defaultAttrs,
                    createScriptHook: (url, attrs) => {
                        const res = host.loaderHook.lifecycle.createScript.emit({
                            url,
                            attrs,
                        });
                        if (res instanceof HTMLScriptElement) {
                            return res;
                        }
                        return;
                    },
                    needDeleteScript: true,
                });
                needAttach && document.head.appendChild(scriptEl);
            });
        }
    }
}

const ShareUtils = {
    getRegisteredShare,
    getGlobalShareScope,
};
const GlobalUtils = {
    Global,
    nativeGlobal,
    resetFederationGlobalInfo,
    setGlobalFederationInstance,
    getGlobalFederationConstructor,
    setGlobalFederationConstructor,
    getInfoWithoutType,
    getGlobalSnapshot,
    getTargetSnapshotInfoByModuleInfo,
    getGlobalSnapshotInfoByModuleInfo,
    setGlobalSnapshotInfoByModuleInfo,
    addGlobalSnapshot,
    getRemoteEntryExports,
    registerGlobalPlugins,
    getGlobalHostPlugins,
    getPreloaded,
    setPreloaded,
};
var helpers = {
    global: GlobalUtils,
    share: ShareUtils,
    utils: {
        matchRemoteWithNameAndExpose,
        preloadAssets,
        getRemoteInfo,
    },
};

class Module {
    constructor({ remoteInfo, host, }) {
        this.inited = false;
        this.lib = undefined;
        this.remoteInfo = remoteInfo;
        this.host = host;
    }
    async getEntry() {
        if (this.remoteEntryExports) {
            return this.remoteEntryExports;
        }
        let remoteEntryExports;
        remoteEntryExports = await getRemoteEntry({
            origin: this.host,
            remoteInfo: this.remoteInfo,
            remoteEntryExports: this.remoteEntryExports,
        });
        assert(remoteEntryExports, `remoteEntryExports is undefined \n ${sdk.safeToString(this.remoteInfo)}`);
        this.remoteEntryExports = remoteEntryExports;
        return this.remoteEntryExports;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(id, expose, options, remoteSnapshot) {
        const { loadFactory = true } = options || { loadFactory: true };
        // Get remoteEntry.js
        const remoteEntryExports = await this.getEntry();
        if (!this.inited) {
            const localShareScopeMap = this.host.shareScopeMap;
            const shareScopeKeys = Array.isArray(this.remoteInfo.shareScope)
                ? this.remoteInfo.shareScope
                : [this.remoteInfo.shareScope];
            if (!shareScopeKeys.length) {
                shareScopeKeys.push('default');
            }
            shareScopeKeys.forEach((shareScopeKey) => {
                if (!localShareScopeMap[shareScopeKey]) {
                    localShareScopeMap[shareScopeKey] = {};
                }
            });
            // TODO: compate legacy init params, should use shareScopeMap if exist
            const shareScope = localShareScopeMap[shareScopeKeys[0]];
            const initScope = [];
            const remoteEntryInitOptions = {
                version: this.remoteInfo.version || '',
                shareScopeKeys: Array.isArray(this.remoteInfo.shareScope)
                    ? shareScopeKeys
                    : this.remoteInfo.shareScope || 'default',
            };
            // Help to find host instance
            Object.defineProperty(remoteEntryInitOptions, 'shareScopeMap', {
                value: localShareScopeMap,
                // remoteEntryInitOptions will be traversed and assigned during container init, ,so this attribute is not allowed to be traversed
                enumerable: false,
            });
            const initContainerOptions = await this.host.hooks.lifecycle.beforeInitContainer.emit({
                shareScope,
                // @ts-ignore shareScopeMap will be set by Object.defineProperty
                remoteEntryInitOptions,
                initScope,
                remoteInfo: this.remoteInfo,
                origin: this.host,
            });
            if (typeof remoteEntryExports?.init === 'undefined') {
                error(errorCodes.getShortErrorMsg(errorCodes.RUNTIME_002, errorCodes.runtimeDescMap, {
                    hostName: this.host.name,
                    remoteName: this.remoteInfo.name,
                    remoteEntryUrl: this.remoteInfo.entry,
                    remoteEntryKey: this.remoteInfo.entryGlobalName,
                }));
            }
            await remoteEntryExports.init(initContainerOptions.shareScope, initContainerOptions.initScope, initContainerOptions.remoteEntryInitOptions);
            await this.host.hooks.lifecycle.initContainer.emit({
                ...initContainerOptions,
                id,
                remoteSnapshot,
                remoteEntryExports,
            });
        }
        this.lib = remoteEntryExports;
        this.inited = true;
        let moduleFactory;
        moduleFactory = await this.host.loaderHook.lifecycle.getModuleFactory.emit({
            remoteEntryExports,
            expose,
            moduleInfo: this.remoteInfo,
        });
        // get exposeGetter
        if (!moduleFactory) {
            moduleFactory = await remoteEntryExports.get(expose);
        }
        assert(moduleFactory, `${getFMId(this.remoteInfo)} remote don't export ${expose}.`);
        // keep symbol for module name always one format
        const symbolName = processModuleAlias(this.remoteInfo.name, expose);
        const wrapModuleFactory = this.wraperFactory(moduleFactory, symbolName);
        if (!loadFactory) {
            return wrapModuleFactory;
        }
        const exposeContent = await wrapModuleFactory();
        return exposeContent;
    }
    wraperFactory(moduleFactory, id) {
        function defineModuleId(res, id) {
            if (res &&
                typeof res === 'object' &&
                Object.isExtensible(res) &&
                !Object.getOwnPropertyDescriptor(res, Symbol.for('mf_module_id'))) {
                Object.defineProperty(res, Symbol.for('mf_module_id'), {
                    value: id,
                    enumerable: false,
                });
            }
        }
        if (moduleFactory instanceof Promise) {
            return async () => {
                const res = await moduleFactory();
                // This parameter is used for bridge debugging
                defineModuleId(res, id);
                return res;
            };
        }
        else {
            return () => {
                const res = moduleFactory();
                // This parameter is used for bridge debugging
                defineModuleId(res, id);
                return res;
            };
        }
    }
}

class SyncHook {
    constructor(type) {
        this.type = '';
        this.listeners = new Set();
        if (type) {
            this.type = type;
        }
    }
    on(fn) {
        if (typeof fn === 'function') {
            this.listeners.add(fn);
        }
    }
    once(fn) {
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const self = this;
        this.on(function wrapper(...args) {
            self.remove(wrapper);
            // eslint-disable-next-line prefer-spread
            return fn.apply(null, args);
        });
    }
    emit(...data) {
        let result;
        if (this.listeners.size > 0) {
            // eslint-disable-next-line prefer-spread
            this.listeners.forEach((fn) => {
                result = fn(...data);
            });
        }
        return result;
    }
    remove(fn) {
        this.listeners.delete(fn);
    }
    removeAll() {
        this.listeners.clear();
    }
}

class AsyncHook extends SyncHook {
    emit(...data) {
        let result;
        const ls = Array.from(this.listeners);
        if (ls.length > 0) {
            let i = 0;
            const call = (prev) => {
                if (prev === false) {
                    return false; // Abort process
                }
                else if (i < ls.length) {
                    return Promise.resolve(ls[i++].apply(null, data)).then(call);
                }
                else {
                    return prev;
                }
            };
            result = call();
        }
        return Promise.resolve(result);
    }
}

// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function checkReturnData(originalData, returnedData) {
    if (!isObject(returnedData)) {
        return false;
    }
    if (originalData !== returnedData) {
        // eslint-disable-next-line no-restricted-syntax
        for (const key in originalData) {
            if (!(key in returnedData)) {
                return false;
            }
        }
    }
    return true;
}
class SyncWaterfallHook extends SyncHook {
    constructor(type) {
        super();
        this.onerror = error;
        this.type = type;
    }
    emit(data) {
        if (!isObject(data)) {
            error(`The data for the "${this.type}" hook should be an object.`);
        }
        for (const fn of this.listeners) {
            try {
                const tempData = fn(data);
                if (checkReturnData(data, tempData)) {
                    data = tempData;
                }
                else {
                    this.onerror(`A plugin returned an unacceptable value for the "${this.type}" type.`);
                    break;
                }
            }
            catch (e) {
                warn(e);
                this.onerror(e);
            }
        }
        return data;
    }
}

class AsyncWaterfallHook extends SyncHook {
    constructor(type) {
        super();
        this.onerror = error;
        this.type = type;
    }
    emit(data) {
        if (!isObject(data)) {
            error(`The response data for the "${this.type}" hook must be an object.`);
        }
        const ls = Array.from(this.listeners);
        if (ls.length > 0) {
            let i = 0;
            const processError = (e) => {
                warn(e);
                this.onerror(e);
                return data;
            };
            const call = (prevData) => {
                if (checkReturnData(data, prevData)) {
                    data = prevData;
                    if (i < ls.length) {
                        try {
                            return Promise.resolve(ls[i++](data)).then(call, processError);
                        }
                        catch (e) {
                            return processError(e);
                        }
                    }
                }
                else {
                    this.onerror(`A plugin returned an incorrect value for the "${this.type}" type.`);
                }
                return data;
            };
            return Promise.resolve(call(data));
        }
        return Promise.resolve(data);
    }
}

class PluginSystem {
    constructor(lifecycle) {
        this.registerPlugins = {};
        this.lifecycle = lifecycle;
        this.lifecycleKeys = Object.keys(lifecycle);
    }
    applyPlugin(plugin, instance) {
        assert(isPlainObject(plugin), 'Plugin configuration is invalid.');
        // The plugin's name is mandatory and must be unique
        const pluginName = plugin.name;
        assert(pluginName, 'A name must be provided by the plugin.');
        if (!this.registerPlugins[pluginName]) {
            this.registerPlugins[pluginName] = plugin;
            plugin.apply?.(instance);
            Object.keys(this.lifecycle).forEach((key) => {
                const pluginLife = plugin[key];
                if (pluginLife) {
                    this.lifecycle[key].on(pluginLife);
                }
            });
        }
    }
    removePlugin(pluginName) {
        assert(pluginName, 'A name is required.');
        const plugin = this.registerPlugins[pluginName];
        assert(plugin, `The plugin "${pluginName}" is not registered.`);
        Object.keys(plugin).forEach((key) => {
            if (key !== 'name') {
                this.lifecycle[key].remove(plugin[key]);
            }
        });
    }
}

function assignRemoteInfo(remoteInfo, remoteSnapshot) {
    const remoteEntryInfo = getRemoteEntryInfoFromSnapshot(remoteSnapshot);
    if (!remoteEntryInfo.url) {
        error(`The attribute remoteEntry of ${remoteInfo.name} must not be undefined.`);
    }
    let entryUrl = sdk.getResourceUrl(remoteSnapshot, remoteEntryInfo.url);
    if (!sdk.isBrowserEnv() && !entryUrl.startsWith('http')) {
        entryUrl = `https:${entryUrl}`;
    }
    remoteInfo.type = remoteEntryInfo.type;
    remoteInfo.entryGlobalName = remoteEntryInfo.globalName;
    remoteInfo.entry = entryUrl;
    remoteInfo.version = remoteSnapshot.version;
    remoteInfo.buildVersion = remoteSnapshot.buildVersion;
}
function snapshotPlugin() {
    return {
        name: 'snapshot-plugin',
        async afterResolve(args) {
            const { remote, pkgNameOrAlias, expose, origin, remoteInfo, id } = args;
            if (!isRemoteInfoWithEntry(remote) || !isPureRemoteEntry(remote)) {
                const { remoteSnapshot, globalSnapshot } = await origin.snapshotHandler.loadRemoteSnapshotInfo({
                    moduleInfo: remote,
                    id,
                });
                assignRemoteInfo(remoteInfo, remoteSnapshot);
                // preloading assets
                const preloadOptions = {
                    remote,
                    preloadConfig: {
                        nameOrAlias: pkgNameOrAlias,
                        exposes: [expose],
                        resourceCategory: 'sync',
                        share: false,
                        depsRemote: false,
                    },
                };
                const assets = await origin.remoteHandler.hooks.lifecycle.generatePreloadAssets.emit({
                    origin,
                    preloadOptions,
                    remoteInfo,
                    remote,
                    remoteSnapshot,
                    globalSnapshot,
                });
                if (assets) {
                    preloadAssets(remoteInfo, origin, assets, false);
                }
                return {
                    ...args,
                    remoteSnapshot,
                };
            }
            return args;
        },
    };
}

// name
// name:version
function splitId(id) {
    const splitInfo = id.split(':');
    if (splitInfo.length === 1) {
        return {
            name: splitInfo[0],
            version: undefined,
        };
    }
    else if (splitInfo.length === 2) {
        return {
            name: splitInfo[0],
            version: splitInfo[1],
        };
    }
    else {
        return {
            name: splitInfo[1],
            version: splitInfo[2],
        };
    }
}
// Traverse all nodes in moduleInfo and traverse the entire snapshot
function traverseModuleInfo(globalSnapshot, remoteInfo, traverse, isRoot, memo = {}, remoteSnapshot) {
    const id = getFMId(remoteInfo);
    const { value: snapshotValue } = getInfoWithoutType(globalSnapshot, id);
    const effectiveRemoteSnapshot = remoteSnapshot || snapshotValue;
    if (effectiveRemoteSnapshot && !sdk.isManifestProvider(effectiveRemoteSnapshot)) {
        traverse(effectiveRemoteSnapshot, remoteInfo, isRoot);
        if (effectiveRemoteSnapshot.remotesInfo) {
            const remoteKeys = Object.keys(effectiveRemoteSnapshot.remotesInfo);
            for (const key of remoteKeys) {
                if (memo[key]) {
                    continue;
                }
                memo[key] = true;
                const subRemoteInfo = splitId(key);
                const remoteValue = effectiveRemoteSnapshot.remotesInfo[key];
                traverseModuleInfo(globalSnapshot, {
                    name: subRemoteInfo.name,
                    version: remoteValue.matchedVersion,
                }, traverse, false, memo, undefined);
            }
        }
    }
}
const isExisted = (type, url) => {
    return document.querySelector(`${type}[${type === 'link' ? 'href' : 'src'}="${url}"]`);
};
// eslint-disable-next-line max-lines-per-function
function generatePreloadAssets(origin, preloadOptions, remote, globalSnapshot, remoteSnapshot) {
    const cssAssets = [];
    const jsAssets = [];
    const entryAssets = [];
    const loadedSharedJsAssets = new Set();
    const loadedSharedCssAssets = new Set();
    const { options } = origin;
    const { preloadConfig: rootPreloadConfig } = preloadOptions;
    const { depsRemote } = rootPreloadConfig;
    const memo = {};
    traverseModuleInfo(globalSnapshot, remote, (moduleInfoSnapshot, remoteInfo, isRoot) => {
        let preloadConfig;
        if (isRoot) {
            preloadConfig = rootPreloadConfig;
        }
        else {
            if (Array.isArray(depsRemote)) {
                // eslint-disable-next-line array-callback-return
                const findPreloadConfig = depsRemote.find((remoteConfig) => {
                    if (remoteConfig.nameOrAlias === remoteInfo.name ||
                        remoteConfig.nameOrAlias === remoteInfo.alias) {
                        return true;
                    }
                    return false;
                });
                if (!findPreloadConfig) {
                    return;
                }
                preloadConfig = defaultPreloadArgs(findPreloadConfig);
            }
            else if (depsRemote === true) {
                preloadConfig = rootPreloadConfig;
            }
            else {
                return;
            }
        }
        const remoteEntryUrl = sdk.getResourceUrl(moduleInfoSnapshot, getRemoteEntryInfoFromSnapshot(moduleInfoSnapshot).url);
        if (remoteEntryUrl) {
            entryAssets.push({
                name: remoteInfo.name,
                moduleInfo: {
                    name: remoteInfo.name,
                    entry: remoteEntryUrl,
                    type: 'remoteEntryType' in moduleInfoSnapshot
                        ? moduleInfoSnapshot.remoteEntryType
                        : 'global',
                    entryGlobalName: 'globalName' in moduleInfoSnapshot
                        ? moduleInfoSnapshot.globalName
                        : remoteInfo.name,
                    shareScope: '',
                    version: 'version' in moduleInfoSnapshot
                        ? moduleInfoSnapshot.version
                        : undefined,
                },
                url: remoteEntryUrl,
            });
        }
        let moduleAssetsInfo = 'modules' in moduleInfoSnapshot ? moduleInfoSnapshot.modules : [];
        const normalizedPreloadExposes = normalizePreloadExposes(preloadConfig.exposes);
        if (normalizedPreloadExposes.length && 'modules' in moduleInfoSnapshot) {
            moduleAssetsInfo = moduleInfoSnapshot?.modules?.reduce((assets, moduleAssetInfo) => {
                if (normalizedPreloadExposes?.indexOf(moduleAssetInfo.moduleName) !==
                    -1) {
                    assets.push(moduleAssetInfo);
                }
                return assets;
            }, []);
        }
        function handleAssets(assets) {
            const assetsRes = assets.map((asset) => sdk.getResourceUrl(moduleInfoSnapshot, asset));
            if (preloadConfig.filter) {
                return assetsRes.filter(preloadConfig.filter);
            }
            return assetsRes;
        }
        if (moduleAssetsInfo) {
            const assetsLength = moduleAssetsInfo.length;
            for (let index = 0; index < assetsLength; index++) {
                const assetsInfo = moduleAssetsInfo[index];
                const exposeFullPath = `${remoteInfo.name}/${assetsInfo.moduleName}`;
                origin.remoteHandler.hooks.lifecycle.handlePreloadModule.emit({
                    id: assetsInfo.moduleName === '.' ? remoteInfo.name : exposeFullPath,
                    name: remoteInfo.name,
                    remoteSnapshot: moduleInfoSnapshot,
                    preloadConfig,
                    remote: remoteInfo,
                    origin,
                });
                const preloaded = getPreloaded(exposeFullPath);
                if (preloaded) {
                    continue;
                }
                if (preloadConfig.resourceCategory === 'all') {
                    cssAssets.push(...handleAssets(assetsInfo.assets.css.async));
                    cssAssets.push(...handleAssets(assetsInfo.assets.css.sync));
                    jsAssets.push(...handleAssets(assetsInfo.assets.js.async));
                    jsAssets.push(...handleAssets(assetsInfo.assets.js.sync));
                    // eslint-disable-next-line no-constant-condition
                }
                else if ((preloadConfig.resourceCategory = 'sync')) {
                    cssAssets.push(...handleAssets(assetsInfo.assets.css.sync));
                    jsAssets.push(...handleAssets(assetsInfo.assets.js.sync));
                }
                setPreloaded(exposeFullPath);
            }
        }
    }, true, memo, remoteSnapshot);
    if (remoteSnapshot.shared && remoteSnapshot.shared.length > 0) {
        const collectSharedAssets = (shareInfo, snapshotShared) => {
            const registeredShared = getRegisteredShare(origin.shareScopeMap, snapshotShared.sharedName, shareInfo, origin.sharedHandler.hooks.lifecycle.resolveShare);
            // If the global share does not exist, or the lib function does not exist, it means that the shared has not been loaded yet and can be preloaded.
            if (registeredShared && typeof registeredShared.lib === 'function') {
                snapshotShared.assets.js.sync.forEach((asset) => {
                    loadedSharedJsAssets.add(asset);
                });
                snapshotShared.assets.css.sync.forEach((asset) => {
                    loadedSharedCssAssets.add(asset);
                });
            }
        };
        remoteSnapshot.shared.forEach((shared) => {
            const shareInfos = options.shared?.[shared.sharedName];
            if (!shareInfos) {
                return;
            }
            // if no version, preload all shared
            const sharedOptions = shared.version
                ? shareInfos.find((s) => s.version === shared.version)
                : shareInfos;
            if (!sharedOptions) {
                return;
            }
            const arrayShareInfo = arrayOptions(sharedOptions);
            arrayShareInfo.forEach((s) => {
                collectSharedAssets(s, shared);
            });
        });
    }
    const needPreloadJsAssets = jsAssets.filter((asset) => !loadedSharedJsAssets.has(asset) && !isExisted('script', asset));
    const needPreloadCssAssets = cssAssets.filter((asset) => !loadedSharedCssAssets.has(asset) && !isExisted('link', asset));
    return {
        cssAssets: needPreloadCssAssets,
        jsAssetsWithoutEntry: needPreloadJsAssets,
        entryAssets: entryAssets.filter((entry) => !isExisted('script', entry.url)),
    };
}
const generatePreloadAssetsPlugin = function () {
    return {
        name: 'generate-preload-assets-plugin',
        async generatePreloadAssets(args) {
            const { origin, preloadOptions, remoteInfo, remote, globalSnapshot, remoteSnapshot, } = args;
            if (!sdk.isBrowserEnv()) {
                return {
                    cssAssets: [],
                    jsAssetsWithoutEntry: [],
                    entryAssets: [],
                };
            }
            if (isRemoteInfoWithEntry(remote) && isPureRemoteEntry(remote)) {
                return {
                    cssAssets: [],
                    jsAssetsWithoutEntry: [],
                    entryAssets: [
                        {
                            name: remote.name,
                            url: remote.entry,
                            moduleInfo: {
                                name: remoteInfo.name,
                                entry: remote.entry,
                                type: remoteInfo.type || 'global',
                                entryGlobalName: '',
                                shareScope: '',
                            },
                        },
                    ],
                };
            }
            assignRemoteInfo(remoteInfo, remoteSnapshot);
            const assets = generatePreloadAssets(origin, preloadOptions, remoteInfo, globalSnapshot, remoteSnapshot);
            return assets;
        },
    };
};

function getGlobalRemoteInfo(moduleInfo, origin) {
    const hostGlobalSnapshot = getGlobalSnapshotInfoByModuleInfo({
        name: origin.name,
        version: origin.options.version,
    });
    // get remote detail info from global
    const globalRemoteInfo = hostGlobalSnapshot &&
        'remotesInfo' in hostGlobalSnapshot &&
        hostGlobalSnapshot.remotesInfo &&
        getInfoWithoutType(hostGlobalSnapshot.remotesInfo, moduleInfo.name).value;
    if (globalRemoteInfo && globalRemoteInfo.matchedVersion) {
        return {
            hostGlobalSnapshot,
            globalSnapshot: getGlobalSnapshot(),
            remoteSnapshot: getGlobalSnapshotInfoByModuleInfo({
                name: moduleInfo.name,
                version: globalRemoteInfo.matchedVersion,
            }),
        };
    }
    return {
        hostGlobalSnapshot: undefined,
        globalSnapshot: getGlobalSnapshot(),
        remoteSnapshot: getGlobalSnapshotInfoByModuleInfo({
            name: moduleInfo.name,
            version: 'version' in moduleInfo ? moduleInfo.version : undefined,
        }),
    };
}
class SnapshotHandler {
    constructor(HostInstance) {
        this.loadingHostSnapshot = null;
        this.manifestCache = new Map();
        this.hooks = new PluginSystem({
            beforeLoadRemoteSnapshot: new AsyncHook('beforeLoadRemoteSnapshot'),
            loadSnapshot: new AsyncWaterfallHook('loadGlobalSnapshot'),
            loadRemoteSnapshot: new AsyncWaterfallHook('loadRemoteSnapshot'),
            afterLoadSnapshot: new AsyncWaterfallHook('afterLoadSnapshot'),
        });
        this.manifestLoading = Global.__FEDERATION__.__MANIFEST_LOADING__;
        this.HostInstance = HostInstance;
        this.loaderHook = HostInstance.loaderHook;
    }
    // eslint-disable-next-line max-lines-per-function
    async loadRemoteSnapshotInfo({ moduleInfo, id, expose, }) {
        const { options } = this.HostInstance;
        await this.hooks.lifecycle.beforeLoadRemoteSnapshot.emit({
            options,
            moduleInfo,
        });
        let hostSnapshot = getGlobalSnapshotInfoByModuleInfo({
            name: this.HostInstance.options.name,
            version: this.HostInstance.options.version,
        });
        if (!hostSnapshot) {
            hostSnapshot = {
                version: this.HostInstance.options.version || '',
                remoteEntry: '',
                remotesInfo: {},
            };
            addGlobalSnapshot({
                [this.HostInstance.options.name]: hostSnapshot,
            });
        }
        // In dynamic loadRemote scenarios, incomplete remotesInfo delivery may occur. In such cases, the remotesInfo in the host needs to be completed in the snapshot at runtime.
        // This ensures the snapshot's integrity and helps the chrome plugin correctly identify all producer modules, ensuring that proxyable producer modules will not be missing.
        if (hostSnapshot &&
            'remotesInfo' in hostSnapshot &&
            !getInfoWithoutType(hostSnapshot.remotesInfo, moduleInfo.name).value) {
            if ('version' in moduleInfo || 'entry' in moduleInfo) {
                hostSnapshot.remotesInfo = {
                    ...hostSnapshot?.remotesInfo,
                    [moduleInfo.name]: {
                        matchedVersion: 'version' in moduleInfo ? moduleInfo.version : moduleInfo.entry,
                    },
                };
            }
        }
        const { hostGlobalSnapshot, remoteSnapshot, globalSnapshot } = this.getGlobalRemoteInfo(moduleInfo);
        const { remoteSnapshot: globalRemoteSnapshot, globalSnapshot: globalSnapshotRes, } = await this.hooks.lifecycle.loadSnapshot.emit({
            options,
            moduleInfo,
            hostGlobalSnapshot,
            remoteSnapshot,
            globalSnapshot,
        });
        let mSnapshot;
        let gSnapshot;
        // global snapshot includes manifest or module info includes manifest
        if (globalRemoteSnapshot) {
            if (sdk.isManifestProvider(globalRemoteSnapshot)) {
                const remoteEntry = sdk.isBrowserEnv()
                    ? globalRemoteSnapshot.remoteEntry
                    : globalRemoteSnapshot.ssrRemoteEntry ||
                        globalRemoteSnapshot.remoteEntry ||
                        '';
                const moduleSnapshot = await this.getManifestJson(remoteEntry, moduleInfo, {});
                // eslint-disable-next-line @typescript-eslint/no-shadow
                const globalSnapshotRes = setGlobalSnapshotInfoByModuleInfo({
                    ...moduleInfo,
                    // The global remote may be overridden
                    // Therefore, set the snapshot key to the global address of the actual request
                    entry: remoteEntry,
                }, moduleSnapshot);
                mSnapshot = moduleSnapshot;
                gSnapshot = globalSnapshotRes;
            }
            else {
                const { remoteSnapshot: remoteSnapshotRes } = await this.hooks.lifecycle.loadRemoteSnapshot.emit({
                    options: this.HostInstance.options,
                    moduleInfo,
                    remoteSnapshot: globalRemoteSnapshot,
                    from: 'global',
                });
                mSnapshot = remoteSnapshotRes;
                gSnapshot = globalSnapshotRes;
            }
        }
        else {
            if (isRemoteInfoWithEntry(moduleInfo)) {
                // get from manifest.json and merge remote info from remote server
                const moduleSnapshot = await this.getManifestJson(moduleInfo.entry, moduleInfo, {});
                // eslint-disable-next-line @typescript-eslint/no-shadow
                const globalSnapshotRes = setGlobalSnapshotInfoByModuleInfo(moduleInfo, moduleSnapshot);
                const { remoteSnapshot: remoteSnapshotRes } = await this.hooks.lifecycle.loadRemoteSnapshot.emit({
                    options: this.HostInstance.options,
                    moduleInfo,
                    remoteSnapshot: moduleSnapshot,
                    from: 'global',
                });
                mSnapshot = remoteSnapshotRes;
                gSnapshot = globalSnapshotRes;
            }
            else {
                error(errorCodes.getShortErrorMsg(errorCodes.RUNTIME_007, errorCodes.runtimeDescMap, {
                    hostName: moduleInfo.name,
                    hostVersion: moduleInfo.version,
                    globalSnapshot: JSON.stringify(globalSnapshotRes),
                }));
            }
        }
        await this.hooks.lifecycle.afterLoadSnapshot.emit({
            id,
            host: this.HostInstance,
            options,
            moduleInfo,
            remoteSnapshot: mSnapshot,
        });
        return {
            remoteSnapshot: mSnapshot,
            globalSnapshot: gSnapshot,
        };
    }
    getGlobalRemoteInfo(moduleInfo) {
        return getGlobalRemoteInfo(moduleInfo, this.HostInstance);
    }
    async getManifestJson(manifestUrl, moduleInfo, extraOptions) {
        const getManifest = async () => {
            let manifestJson = this.manifestCache.get(manifestUrl);
            if (manifestJson) {
                return manifestJson;
            }
            try {
                let res = await this.loaderHook.lifecycle.fetch.emit(manifestUrl, {});
                if (!res || !(res instanceof Response)) {
                    res = await fetch(manifestUrl, {});
                }
                manifestJson = (await res.json());
            }
            catch (err) {
                manifestJson =
                    (await this.HostInstance.remoteHandler.hooks.lifecycle.errorLoadRemote.emit({
                        id: manifestUrl,
                        error: err,
                        from: 'runtime',
                        lifecycle: 'afterResolve',
                        origin: this.HostInstance,
                    }));
                if (!manifestJson) {
                    delete this.manifestLoading[manifestUrl];
                    error(errorCodes.getShortErrorMsg(errorCodes.RUNTIME_003, errorCodes.runtimeDescMap, {
                        manifestUrl,
                        moduleName: moduleInfo.name,
                        hostName: this.HostInstance.options.name,
                    }, `${err}`));
                }
            }
            assert(manifestJson.metaData && manifestJson.exposes && manifestJson.shared, `${manifestUrl} is not a federation manifest`);
            this.manifestCache.set(manifestUrl, manifestJson);
            return manifestJson;
        };
        const asyncLoadProcess = async () => {
            const manifestJson = await getManifest();
            const remoteSnapshot = sdk.generateSnapshotFromManifest(manifestJson, {
                version: manifestUrl,
            });
            const { remoteSnapshot: remoteSnapshotRes } = await this.hooks.lifecycle.loadRemoteSnapshot.emit({
                options: this.HostInstance.options,
                moduleInfo,
                manifestJson,
                remoteSnapshot,
                manifestUrl,
                from: 'manifest',
            });
            return remoteSnapshotRes;
        };
        if (!this.manifestLoading[manifestUrl]) {
            this.manifestLoading[manifestUrl] = asyncLoadProcess().then((res) => res);
        }
        return this.manifestLoading[manifestUrl];
    }
}

class SharedHandler {
    constructor(host) {
        this.hooks = new PluginSystem({
            afterResolve: new AsyncWaterfallHook('afterResolve'),
            beforeLoadShare: new AsyncWaterfallHook('beforeLoadShare'),
            // not used yet
            loadShare: new AsyncHook(),
            resolveShare: new SyncWaterfallHook('resolveShare'),
            // maybe will change, temporarily for internal use only
            initContainerShareScopeMap: new SyncWaterfallHook('initContainerShareScopeMap'),
        });
        this.host = host;
        this.shareScopeMap = {};
        this.initTokens = {};
        this._setGlobalShareScopeMap(host.options);
    }
    // register shared in shareScopeMap
    registerShared(globalOptions, userOptions) {
        const { shareInfos, shared } = formatShareConfigs(globalOptions, userOptions);
        const sharedKeys = Object.keys(shareInfos);
        sharedKeys.forEach((sharedKey) => {
            const sharedVals = shareInfos[sharedKey];
            sharedVals.forEach((sharedVal) => {
                sharedVal.scope.forEach((sc) => {
                    const registeredShared = this.shareScopeMap[sc]?.[sharedKey];
                    if (!registeredShared) {
                        this.setShared({
                            pkgName: sharedKey,
                            lib: sharedVal.lib,
                            get: sharedVal.get,
                            loaded: sharedVal.loaded || Boolean(sharedVal.lib),
                            shared: sharedVal,
                            from: userOptions.name,
                        });
                    }
                });
            });
        });
        return {
            shareInfos,
            shared,
        };
    }
    async loadShare(pkgName, extraOptions) {
        const { host } = this;
        // This function performs the following steps:
        // 1. Checks if the currently loaded share already exists, if not, it throws an error
        // 2. Searches globally for a matching share, if found, it uses it directly
        // 3. If not found, it retrieves it from the current share and stores the obtained share globally.
        const shareOptions = getTargetSharedOptions({
            pkgName,
            extraOptions,
            shareInfos: host.options.shared,
        });
        if (shareOptions?.scope) {
            await Promise.all(shareOptions.scope.map(async (shareScope) => {
                await Promise.all(this.initializeSharing(shareScope, {
                    strategy: shareOptions.strategy,
                }));
                return;
            }));
        }
        const loadShareRes = await this.hooks.lifecycle.beforeLoadShare.emit({
            pkgName,
            shareInfo: shareOptions,
            shared: host.options.shared,
            origin: host,
        });
        const { shareInfo: shareOptionsRes } = loadShareRes;
        // Assert that shareInfoRes exists, if not, throw an error
        assert(shareOptionsRes, `Cannot find ${pkgName} Share in the ${host.options.name}. Please ensure that the ${pkgName} Share parameters have been injected`);
        // Retrieve from cache
        const registeredShared = getRegisteredShare(this.shareScopeMap, pkgName, shareOptionsRes, this.hooks.lifecycle.resolveShare);
        const addUseIn = (shared) => {
            if (!shared.useIn) {
                shared.useIn = [];
            }
            addUniqueItem(shared.useIn, host.options.name);
        };
        if (registeredShared && registeredShared.lib) {
            addUseIn(registeredShared);
            return registeredShared.lib;
        }
        else if (registeredShared &&
            registeredShared.loading &&
            !registeredShared.loaded) {
            const factory = await registeredShared.loading;
            registeredShared.loaded = true;
            if (!registeredShared.lib) {
                registeredShared.lib = factory;
            }
            addUseIn(registeredShared);
            return factory;
        }
        else if (registeredShared) {
            const asyncLoadProcess = async () => {
                const factory = await registeredShared.get();
                addUseIn(registeredShared);
                registeredShared.loaded = true;
                registeredShared.lib = factory;
                return factory;
            };
            const loading = asyncLoadProcess();
            this.setShared({
                pkgName,
                loaded: false,
                shared: registeredShared,
                from: host.options.name,
                lib: null,
                loading,
            });
            return loading;
        }
        else {
            if (extraOptions?.customShareInfo) {
                return false;
            }
            const asyncLoadProcess = async () => {
                const factory = await shareOptionsRes.get();
                shareOptionsRes.lib = factory;
                shareOptionsRes.loaded = true;
                addUseIn(shareOptionsRes);
                const gShared = getRegisteredShare(this.shareScopeMap, pkgName, shareOptionsRes, this.hooks.lifecycle.resolveShare);
                if (gShared) {
                    gShared.lib = factory;
                    gShared.loaded = true;
                    gShared.from = shareOptionsRes.from;
                }
                return factory;
            };
            const loading = asyncLoadProcess();
            this.setShared({
                pkgName,
                loaded: false,
                shared: shareOptionsRes,
                from: host.options.name,
                lib: null,
                loading,
            });
            return loading;
        }
    }
    /**
     * This function initializes the sharing sequence (executed only once per share scope).
     * It accepts one argument, the name of the share scope.
     * If the share scope does not exist, it creates one.
     */
    // eslint-disable-next-line @typescript-eslint/member-ordering
    initializeSharing(shareScopeName = DEFAULT_SCOPE, extraOptions) {
        const { host } = this;
        const from = extraOptions?.from;
        const strategy = extraOptions?.strategy;
        let initScope = extraOptions?.initScope;
        const promises = [];
        if (from !== 'build') {
            const { initTokens } = this;
            if (!initScope)
                initScope = [];
            let initToken = initTokens[shareScopeName];
            if (!initToken)
                initToken = initTokens[shareScopeName] = { from: this.host.name };
            if (initScope.indexOf(initToken) >= 0)
                return promises;
            initScope.push(initToken);
        }
        const shareScope = this.shareScopeMap;
        const hostName = host.options.name;
        // Creates a new share scope if necessary
        if (!shareScope[shareScopeName]) {
            shareScope[shareScopeName] = {};
        }
        // Executes all initialization snippets from all accessible modules
        const scope = shareScope[shareScopeName];
        const register = (name, shared) => {
            const { version, eager } = shared;
            scope[name] = scope[name] || {};
            const versions = scope[name];
            const activeVersion = versions[version];
            const activeVersionEager = Boolean(activeVersion &&
                (activeVersion.eager || activeVersion.shareConfig?.eager));
            if (!activeVersion ||
                (activeVersion.strategy !== 'loaded-first' &&
                    !activeVersion.loaded &&
                    (Boolean(!eager) !== !activeVersionEager
                        ? eager
                        : hostName > activeVersion.from))) {
                versions[version] = shared;
            }
        };
        const initFn = (mod) => mod && mod.init && mod.init(shareScope[shareScopeName], initScope);
        const initRemoteModule = async (key) => {
            const { module } = await host.remoteHandler.getRemoteModuleAndOptions({
                id: key,
            });
            if (module.getEntry) {
                let remoteEntryExports;
                try {
                    remoteEntryExports = await module.getEntry();
                }
                catch (error) {
                    remoteEntryExports =
                        (await host.remoteHandler.hooks.lifecycle.errorLoadRemote.emit({
                            id: key,
                            error,
                            from: 'runtime',
                            lifecycle: 'beforeLoadShare',
                            origin: host,
                        }));
                }
                if (!module.inited) {
                    await initFn(remoteEntryExports);
                    module.inited = true;
                }
            }
        };
        Object.keys(host.options.shared).forEach((shareName) => {
            const sharedArr = host.options.shared[shareName];
            sharedArr.forEach((shared) => {
                if (shared.scope.includes(shareScopeName)) {
                    register(shareName, shared);
                }
            });
        });
        // TODO: strategy==='version-first' need to be removed in the future
        if (host.options.shareStrategy === 'version-first' ||
            strategy === 'version-first') {
            host.options.remotes.forEach((remote) => {
                if (remote.shareScope === shareScopeName) {
                    promises.push(initRemoteModule(remote.name));
                }
            });
        }
        return promises;
    }
    // The lib function will only be available if the shared set by eager or runtime init is set or the shared is successfully loaded.
    // 1. If the loaded shared already exists globally, then it will be reused
    // 2. If lib exists in local shared, it will be used directly
    // 3. If the local get returns something other than Promise, then it will be used directly
    loadShareSync(pkgName, extraOptions) {
        const { host } = this;
        const shareOptions = getTargetSharedOptions({
            pkgName,
            extraOptions,
            shareInfos: host.options.shared,
        });
        if (shareOptions?.scope) {
            shareOptions.scope.forEach((shareScope) => {
                this.initializeSharing(shareScope, { strategy: shareOptions.strategy });
            });
        }
        const registeredShared = getRegisteredShare(this.shareScopeMap, pkgName, shareOptions, this.hooks.lifecycle.resolveShare);
        const addUseIn = (shared) => {
            if (!shared.useIn) {
                shared.useIn = [];
            }
            addUniqueItem(shared.useIn, host.options.name);
        };
        if (registeredShared) {
            if (typeof registeredShared.lib === 'function') {
                addUseIn(registeredShared);
                if (!registeredShared.loaded) {
                    registeredShared.loaded = true;
                    if (registeredShared.from === host.options.name) {
                        shareOptions.loaded = true;
                    }
                }
                return registeredShared.lib;
            }
            if (typeof registeredShared.get === 'function') {
                const module = registeredShared.get();
                if (!(module instanceof Promise)) {
                    addUseIn(registeredShared);
                    this.setShared({
                        pkgName,
                        loaded: true,
                        from: host.options.name,
                        lib: module,
                        shared: registeredShared,
                    });
                    return module;
                }
            }
        }
        if (shareOptions.lib) {
            if (!shareOptions.loaded) {
                shareOptions.loaded = true;
            }
            return shareOptions.lib;
        }
        if (shareOptions.get) {
            const module = shareOptions.get();
            if (module instanceof Promise) {
                const errorCode = extraOptions?.from === 'build' ? errorCodes.RUNTIME_005 : errorCodes.RUNTIME_006;
                throw new Error(errorCodes.getShortErrorMsg(errorCode, errorCodes.runtimeDescMap, {
                    hostName: host.options.name,
                    sharedPkgName: pkgName,
                }));
            }
            shareOptions.lib = module;
            this.setShared({
                pkgName,
                loaded: true,
                from: host.options.name,
                lib: shareOptions.lib,
                shared: shareOptions,
            });
            return shareOptions.lib;
        }
        throw new Error(errorCodes.getShortErrorMsg(errorCodes.RUNTIME_006, errorCodes.runtimeDescMap, {
            hostName: host.options.name,
            sharedPkgName: pkgName,
        }));
    }
    initShareScopeMap(scopeName, shareScope, extraOptions = {}) {
        const { host } = this;
        this.shareScopeMap[scopeName] = shareScope;
        this.hooks.lifecycle.initContainerShareScopeMap.emit({
            shareScope,
            options: host.options,
            origin: host,
            scopeName,
            hostShareScopeMap: extraOptions.hostShareScopeMap,
        });
    }
    setShared({ pkgName, shared, from, lib, loading, loaded, get, }) {
        const { version, scope = 'default', ...shareInfo } = shared;
        const scopes = Array.isArray(scope) ? scope : [scope];
        scopes.forEach((sc) => {
            if (!this.shareScopeMap[sc]) {
                this.shareScopeMap[sc] = {};
            }
            if (!this.shareScopeMap[sc][pkgName]) {
                this.shareScopeMap[sc][pkgName] = {};
            }
            if (!this.shareScopeMap[sc][pkgName][version]) {
                this.shareScopeMap[sc][pkgName][version] = {
                    version,
                    scope: [sc],
                    ...shareInfo,
                    lib,
                    loaded,
                    loading,
                };
                if (get) {
                    this.shareScopeMap[sc][pkgName][version].get = get;
                }
                return;
            }
            const registeredShared = this.shareScopeMap[sc][pkgName][version];
            if (loading && !registeredShared.loading) {
                registeredShared.loading = loading;
            }
            if (loaded && !registeredShared.loaded) {
                registeredShared.loaded = loaded;
            }
            if (from && registeredShared.from !== from) {
                registeredShared.from = from;
            }
        });
    }
    _setGlobalShareScopeMap(hostOptions) {
        const globalShareScopeMap = getGlobalShareScope();
        const identifier = hostOptions.id || hostOptions.name;
        if (identifier && !globalShareScopeMap[identifier]) {
            globalShareScopeMap[identifier] = this.shareScopeMap;
        }
    }
}

class RemoteHandler {
    constructor(host) {
        this.hooks = new PluginSystem({
            beforeRegisterRemote: new SyncWaterfallHook('beforeRegisterRemote'),
            registerRemote: new SyncWaterfallHook('registerRemote'),
            beforeRequest: new AsyncWaterfallHook('beforeRequest'),
            onLoad: new AsyncHook('onLoad'),
            handlePreloadModule: new SyncHook('handlePreloadModule'),
            errorLoadRemote: new AsyncHook('errorLoadRemote'),
            beforePreloadRemote: new AsyncHook('beforePreloadRemote'),
            generatePreloadAssets: new AsyncHook('generatePreloadAssets'),
            // not used yet
            afterPreloadRemote: new AsyncHook(),
            loadEntry: new AsyncHook(),
        });
        this.host = host;
        this.idToRemoteMap = {};
    }
    formatAndRegisterRemote(globalOptions, userOptions) {
        const userRemotes = userOptions.remotes || [];
        return userRemotes.reduce((res, remote) => {
            this.registerRemote(remote, res, { force: false });
            return res;
        }, globalOptions.remotes);
    }
    setIdToRemoteMap(id, remoteMatchInfo) {
        const { remote, expose } = remoteMatchInfo;
        const { name, alias } = remote;
        this.idToRemoteMap[id] = { name: remote.name, expose };
        if (alias && id.startsWith(name)) {
            const idWithAlias = id.replace(name, alias);
            this.idToRemoteMap[idWithAlias] = { name: remote.name, expose };
            return;
        }
        if (alias && id.startsWith(alias)) {
            const idWithName = id.replace(alias, name);
            this.idToRemoteMap[idWithName] = { name: remote.name, expose };
        }
    }
    // eslint-disable-next-line max-lines-per-function
    // eslint-disable-next-line @typescript-eslint/member-ordering
    async loadRemote(id, options) {
        const { host } = this;
        try {
            const { loadFactory = true } = options || {
                loadFactory: true,
            };
            // 1. Validate the parameters of the retrieved module. There are two module request methods: pkgName + expose and alias + expose.
            // 2. Request the snapshot information of the current host and globally store the obtained snapshot information. The retrieved module information is partially offline and partially online. The online module information will retrieve the modules used online.
            // 3. Retrieve the detailed information of the current module from global (remoteEntry address, expose resource address)
            // 4. After retrieving remoteEntry, call the init of the module, and then retrieve the exported content of the module through get
            // id: pkgName(@federation/app1) + expose(button) = @federation/app1/button
            // id: alias(app1) + expose(button) = app1/button
            // id: alias(app1/utils) + expose(loadash/sort) = app1/utils/loadash/sort
            const { module, moduleOptions, remoteMatchInfo } = await this.getRemoteModuleAndOptions({
                id,
            });
            const { pkgNameOrAlias, remote, expose, id: idRes, remoteSnapshot, } = remoteMatchInfo;
            const moduleOrFactory = (await module.get(idRes, expose, options, remoteSnapshot));
            const moduleWrapper = await this.hooks.lifecycle.onLoad.emit({
                id: idRes,
                pkgNameOrAlias,
                expose,
                exposeModule: loadFactory ? moduleOrFactory : undefined,
                exposeModuleFactory: loadFactory ? undefined : moduleOrFactory,
                remote,
                options: moduleOptions,
                moduleInstance: module,
                origin: host,
            });
            this.setIdToRemoteMap(id, remoteMatchInfo);
            if (typeof moduleWrapper === 'function') {
                return moduleWrapper;
            }
            return moduleOrFactory;
        }
        catch (error) {
            const { from = 'runtime' } = options || { from: 'runtime' };
            const failOver = await this.hooks.lifecycle.errorLoadRemote.emit({
                id,
                error,
                from,
                lifecycle: 'onLoad',
                origin: host,
            });
            if (!failOver) {
                throw error;
            }
            return failOver;
        }
    }
    // eslint-disable-next-line @typescript-eslint/member-ordering
    async preloadRemote(preloadOptions) {
        const { host } = this;
        await this.hooks.lifecycle.beforePreloadRemote.emit({
            preloadOps: preloadOptions,
            options: host.options,
            origin: host,
        });
        const preloadOps = formatPreloadArgs(host.options.remotes, preloadOptions);
        await Promise.all(preloadOps.map(async (ops) => {
            const { remote } = ops;
            const remoteInfo = getRemoteInfo(remote);
            const { globalSnapshot, remoteSnapshot } = await host.snapshotHandler.loadRemoteSnapshotInfo({
                moduleInfo: remote,
            });
            const assets = await this.hooks.lifecycle.generatePreloadAssets.emit({
                origin: host,
                preloadOptions: ops,
                remote,
                remoteInfo,
                globalSnapshot,
                remoteSnapshot,
            });
            if (!assets) {
                return;
            }
            preloadAssets(remoteInfo, host, assets);
        }));
    }
    registerRemotes(remotes, options) {
        const { host } = this;
        remotes.forEach((remote) => {
            this.registerRemote(remote, host.options.remotes, {
                force: options?.force,
            });
        });
    }
    async getRemoteModuleAndOptions(options) {
        const { host } = this;
        const { id } = options;
        let loadRemoteArgs;
        try {
            loadRemoteArgs = await this.hooks.lifecycle.beforeRequest.emit({
                id,
                options: host.options,
                origin: host,
            });
        }
        catch (error) {
            loadRemoteArgs = (await this.hooks.lifecycle.errorLoadRemote.emit({
                id,
                options: host.options,
                origin: host,
                from: 'runtime',
                error,
                lifecycle: 'beforeRequest',
            }));
            if (!loadRemoteArgs) {
                throw error;
            }
        }
        const { id: idRes } = loadRemoteArgs;
        const remoteSplitInfo = matchRemoteWithNameAndExpose(host.options.remotes, idRes);
        assert(remoteSplitInfo, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_004, errorCodes.runtimeDescMap, {
            hostName: host.options.name,
            requestId: idRes,
        }));
        const { remote: rawRemote } = remoteSplitInfo;
        const remoteInfo = getRemoteInfo(rawRemote);
        const matchInfo = await host.sharedHandler.hooks.lifecycle.afterResolve.emit({
            id: idRes,
            ...remoteSplitInfo,
            options: host.options,
            origin: host,
            remoteInfo,
        });
        const { remote, expose } = matchInfo;
        assert(remote && expose, `The 'beforeRequest' hook was executed, but it failed to return the correct 'remote' and 'expose' values while loading ${idRes}.`);
        let module = host.moduleCache.get(remote.name);
        const moduleOptions = {
            host: host,
            remoteInfo,
        };
        if (!module) {
            module = new Module(moduleOptions);
            host.moduleCache.set(remote.name, module);
        }
        return {
            module,
            moduleOptions,
            remoteMatchInfo: matchInfo,
        };
    }
    registerRemote(remote, targetRemotes, options) {
        const { host } = this;
        const normalizeRemote = () => {
            if (remote.alias) {
                // Validate if alias equals the prefix of remote.name and remote.alias, if so, throw an error
                // As multi-level path references cannot guarantee unique names, alias being a prefix of remote.name is not supported
                const findEqual = targetRemotes.find((item) => remote.alias &&
                    (item.name.startsWith(remote.alias) ||
                        item.alias?.startsWith(remote.alias)));
                assert(!findEqual, `The alias ${remote.alias} of remote ${remote.name} is not allowed to be the prefix of ${findEqual && findEqual.name} name or alias`);
            }
            // Set the remote entry to a complete path
            if ('entry' in remote) {
                if (sdk.isBrowserEnv() && !remote.entry.startsWith('http')) {
                    remote.entry = new URL(remote.entry, window.location.origin).href;
                }
            }
            if (!remote.shareScope) {
                remote.shareScope = DEFAULT_SCOPE;
            }
            if (!remote.type) {
                remote.type = DEFAULT_REMOTE_TYPE;
            }
        };
        this.hooks.lifecycle.beforeRegisterRemote.emit({ remote, origin: host });
        const registeredRemote = targetRemotes.find((item) => item.name === remote.name);
        if (!registeredRemote) {
            normalizeRemote();
            targetRemotes.push(remote);
            this.hooks.lifecycle.registerRemote.emit({ remote, origin: host });
        }
        else {
            const messages = [
                `The remote "${remote.name}" is already registered.`,
                'Please note that overriding it may cause unexpected errors.',
            ];
            if (options?.force) {
                // remove registered remote
                this.removeRemote(registeredRemote);
                normalizeRemote();
                targetRemotes.push(remote);
                this.hooks.lifecycle.registerRemote.emit({ remote, origin: host });
                sdk.warn(messages.join(' '));
            }
        }
    }
    removeRemote(remote) {
        try {
            const { host } = this;
            const { name } = remote;
            const remoteIndex = host.options.remotes.findIndex((item) => item.name === name);
            if (remoteIndex !== -1) {
                host.options.remotes.splice(remoteIndex, 1);
            }
            const loadedModule = host.moduleCache.get(remote.name);
            if (loadedModule) {
                const remoteInfo = loadedModule.remoteInfo;
                const key = remoteInfo.entryGlobalName;
                if (CurrentGlobal[key]) {
                    if (Object.getOwnPropertyDescriptor(CurrentGlobal, key)?.configurable) {
                        delete CurrentGlobal[key];
                    }
                    else {
                        // @ts-ignore
                        CurrentGlobal[key] = undefined;
                    }
                }
                const remoteEntryUniqueKey = getRemoteEntryUniqueKey(loadedModule.remoteInfo);
                if (globalLoading[remoteEntryUniqueKey]) {
                    delete globalLoading[remoteEntryUniqueKey];
                }
                host.snapshotHandler.manifestCache.delete(remoteInfo.entry);
                // delete unloaded shared and instance
                let remoteInsId = remoteInfo.buildVersion
                    ? sdk.composeKeyWithSeparator(remoteInfo.name, remoteInfo.buildVersion)
                    : remoteInfo.name;
                const remoteInsIndex = CurrentGlobal.__FEDERATION__.__INSTANCES__.findIndex((ins) => {
                    if (remoteInfo.buildVersion) {
                        return ins.options.id === remoteInsId;
                    }
                    else {
                        return ins.name === remoteInsId;
                    }
                });
                if (remoteInsIndex !== -1) {
                    const remoteIns = CurrentGlobal.__FEDERATION__.__INSTANCES__[remoteInsIndex];
                    remoteInsId = remoteIns.options.id || remoteInsId;
                    const globalShareScopeMap = getGlobalShareScope();
                    let isAllSharedNotUsed = true;
                    const needDeleteKeys = [];
                    Object.keys(globalShareScopeMap).forEach((instId) => {
                        const shareScopeMap = globalShareScopeMap[instId];
                        shareScopeMap &&
                            Object.keys(shareScopeMap).forEach((shareScope) => {
                                const shareScopeVal = shareScopeMap[shareScope];
                                shareScopeVal &&
                                    Object.keys(shareScopeVal).forEach((shareName) => {
                                        const sharedPkgs = shareScopeVal[shareName];
                                        sharedPkgs &&
                                            Object.keys(sharedPkgs).forEach((shareVersion) => {
                                                const shared = sharedPkgs[shareVersion];
                                                if (shared &&
                                                    typeof shared === 'object' &&
                                                    shared.from === remoteInfo.name) {
                                                    if (shared.loaded || shared.loading) {
                                                        shared.useIn = shared.useIn.filter((usedHostName) => usedHostName !== remoteInfo.name);
                                                        if (shared.useIn.length) {
                                                            isAllSharedNotUsed = false;
                                                        }
                                                        else {
                                                            needDeleteKeys.push([
                                                                instId,
                                                                shareScope,
                                                                shareName,
                                                                shareVersion,
                                                            ]);
                                                        }
                                                    }
                                                    else {
                                                        needDeleteKeys.push([
                                                            instId,
                                                            shareScope,
                                                            shareName,
                                                            shareVersion,
                                                        ]);
                                                    }
                                                }
                                            });
                                    });
                            });
                    });
                    if (isAllSharedNotUsed) {
                        remoteIns.shareScopeMap = {};
                        delete globalShareScopeMap[remoteInsId];
                    }
                    needDeleteKeys.forEach(([insId, shareScope, shareName, shareVersion]) => {
                        delete globalShareScopeMap[insId]?.[shareScope]?.[shareName]?.[shareVersion];
                    });
                    CurrentGlobal.__FEDERATION__.__INSTANCES__.splice(remoteInsIndex, 1);
                }
                const { hostGlobalSnapshot } = getGlobalRemoteInfo(remote, host);
                if (hostGlobalSnapshot) {
                    const remoteKey = hostGlobalSnapshot &&
                        'remotesInfo' in hostGlobalSnapshot &&
                        hostGlobalSnapshot.remotesInfo &&
                        getInfoWithoutType(hostGlobalSnapshot.remotesInfo, remote.name).key;
                    if (remoteKey) {
                        delete hostGlobalSnapshot.remotesInfo[remoteKey];
                        if (
                        //eslint-disable-next-line no-extra-boolean-cast
                        Boolean(Global.__FEDERATION__.__MANIFEST_LOADING__[remoteKey])) {
                            delete Global.__FEDERATION__.__MANIFEST_LOADING__[remoteKey];
                        }
                    }
                }
                host.moduleCache.delete(remote.name);
            }
        }
        catch (err) {
            logger.log('removeRemote fail: ', err);
        }
    }
}

const USE_SNAPSHOT = typeof FEDERATION_OPTIMIZE_NO_SNAPSHOT_PLUGIN === 'boolean'
    ? !FEDERATION_OPTIMIZE_NO_SNAPSHOT_PLUGIN
    : true; // Default to true (use snapshot) when not explicitly defined
class ModuleFederation {
    constructor(userOptions) {
        this.hooks = new PluginSystem({
            beforeInit: new SyncWaterfallHook('beforeInit'),
            init: new SyncHook(),
            // maybe will change, temporarily for internal use only
            beforeInitContainer: new AsyncWaterfallHook('beforeInitContainer'),
            // maybe will change, temporarily for internal use only
            initContainer: new AsyncWaterfallHook('initContainer'),
        });
        this.version = "0.21.6";
        this.moduleCache = new Map();
        this.loaderHook = new PluginSystem({
            // FIXME: may not be suitable , not open to the public yet
            getModuleInfo: new SyncHook(),
            createScript: new SyncHook(),
            createLink: new SyncHook(),
            fetch: new AsyncHook(),
            loadEntryError: new AsyncHook(),
            getModuleFactory: new AsyncHook(),
        });
        this.bridgeHook = new PluginSystem({
            beforeBridgeRender: new SyncHook(),
            afterBridgeRender: new SyncHook(),
            beforeBridgeDestroy: new SyncHook(),
            afterBridgeDestroy: new SyncHook(),
        });
        const plugins = USE_SNAPSHOT
            ? [snapshotPlugin(), generatePreloadAssetsPlugin()]
            : [];
        // TODO: Validate the details of the options
        // Initialize options with default values
        const defaultOptions = {
            id: getBuilderId(),
            name: userOptions.name,
            plugins,
            remotes: [],
            shared: {},
            inBrowser: sdk.isBrowserEnv(),
        };
        this.name = userOptions.name;
        this.options = defaultOptions;
        this.snapshotHandler = new SnapshotHandler(this);
        this.sharedHandler = new SharedHandler(this);
        this.remoteHandler = new RemoteHandler(this);
        this.shareScopeMap = this.sharedHandler.shareScopeMap;
        this.registerPlugins([
            ...defaultOptions.plugins,
            ...(userOptions.plugins || []),
        ]);
        this.options = this.formatOptions(defaultOptions, userOptions);
    }
    initOptions(userOptions) {
        this.registerPlugins(userOptions.plugins);
        const options = this.formatOptions(this.options, userOptions);
        this.options = options;
        return options;
    }
    async loadShare(pkgName, extraOptions) {
        return this.sharedHandler.loadShare(pkgName, extraOptions);
    }
    // The lib function will only be available if the shared set by eager or runtime init is set or the shared is successfully loaded.
    // 1. If the loaded shared already exists globally, then it will be reused
    // 2. If lib exists in local shared, it will be used directly
    // 3. If the local get returns something other than Promise, then it will be used directly
    loadShareSync(pkgName, extraOptions) {
        return this.sharedHandler.loadShareSync(pkgName, extraOptions);
    }
    initializeSharing(shareScopeName = DEFAULT_SCOPE, extraOptions) {
        return this.sharedHandler.initializeSharing(shareScopeName, extraOptions);
    }
    initRawContainer(name, url, container) {
        const remoteInfo = getRemoteInfo({ name, entry: url });
        const module = new Module({ host: this, remoteInfo });
        module.remoteEntryExports = container;
        this.moduleCache.set(name, module);
        return module;
    }
    // eslint-disable-next-line max-lines-per-function
    // eslint-disable-next-line @typescript-eslint/member-ordering
    async loadRemote(id, options) {
        return this.remoteHandler.loadRemote(id, options);
    }
    // eslint-disable-next-line @typescript-eslint/member-ordering
    async preloadRemote(preloadOptions) {
        return this.remoteHandler.preloadRemote(preloadOptions);
    }
    initShareScopeMap(scopeName, shareScope, extraOptions = {}) {
        this.sharedHandler.initShareScopeMap(scopeName, shareScope, extraOptions);
    }
    formatOptions(globalOptions, userOptions) {
        const { shared } = formatShareConfigs(globalOptions, userOptions);
        const { userOptions: userOptionsRes, options: globalOptionsRes } = this.hooks.lifecycle.beforeInit.emit({
            origin: this,
            userOptions,
            options: globalOptions,
            shareInfo: shared,
        });
        const remotes = this.remoteHandler.formatAndRegisterRemote(globalOptionsRes, userOptionsRes);
        const { shared: handledShared } = this.sharedHandler.registerShared(globalOptionsRes, userOptionsRes);
        const plugins = [...globalOptionsRes.plugins];
        if (userOptionsRes.plugins) {
            userOptionsRes.plugins.forEach((plugin) => {
                if (!plugins.includes(plugin)) {
                    plugins.push(plugin);
                }
            });
        }
        const optionsRes = {
            ...globalOptions,
            ...userOptions,
            plugins,
            remotes,
            shared: handledShared,
        };
        this.hooks.lifecycle.init.emit({
            origin: this,
            options: optionsRes,
        });
        return optionsRes;
    }
    registerPlugins(plugins) {
        const pluginRes = registerPlugins(plugins, this);
        // Merge plugin
        this.options.plugins = this.options.plugins.reduce((res, plugin) => {
            if (!plugin)
                return res;
            if (res && !res.find((item) => item.name === plugin.name)) {
                res.push(plugin);
            }
            return res;
        }, pluginRes || []);
    }
    registerRemotes(remotes, options) {
        return this.remoteHandler.registerRemotes(remotes, options);
    }
    registerShared(shared) {
        this.sharedHandler.registerShared(this.options, {
            ...this.options,
            shared,
        });
    }
}

var index = /*#__PURE__*/Object.freeze({
    __proto__: null
});

exports.loadScript = sdk.loadScript;
exports.loadScriptNode = sdk.loadScriptNode;
exports.CurrentGlobal = CurrentGlobal;
exports.Global = Global;
exports.Module = Module;
exports.ModuleFederation = ModuleFederation;
exports.addGlobalSnapshot = addGlobalSnapshot;
exports.assert = assert;
exports.getGlobalFederationConstructor = getGlobalFederationConstructor;
exports.getGlobalSnapshot = getGlobalSnapshot;
exports.getInfoWithoutType = getInfoWithoutType;
exports.getRegisteredShare = getRegisteredShare;
exports.getRemoteEntry = getRemoteEntry;
exports.getRemoteInfo = getRemoteInfo;
exports.helpers = helpers;
exports.isStaticResourcesEqual = isStaticResourcesEqual;
exports.matchRemoteWithNameAndExpose = matchRemoteWithNameAndExpose;
exports.registerGlobalPlugins = registerGlobalPlugins;
exports.resetFederationGlobalInfo = resetFederationGlobalInfo;
exports.safeWrapper = safeWrapper;
exports.satisfy = satisfy;
exports.setGlobalFederationConstructor = setGlobalFederationConstructor;
exports.setGlobalFederationInstance = setGlobalFederationInstance;
exports.types = index;
//# sourceMappingURL=index.cjs.cjs.map


},
32055(__unused_rspack_module, exports, __webpack_require__) {
"use strict";


var runtimeCore = __webpack_require__(88961);
var errorCodes = __webpack_require__(53630);
var utils = __webpack_require__(79344);

function createInstance(options) {
    // Retrieve debug constructor
    const ModuleFederationConstructor = runtimeCore.getGlobalFederationConstructor() || runtimeCore.ModuleFederation;
    const instance = new ModuleFederationConstructor(options);
    runtimeCore.setGlobalFederationInstance(instance);
    return instance;
}
let FederationInstance = null;
/**
 * @deprecated Use createInstance or getInstance instead
 */
function init(options) {
    // Retrieve the same instance with the same name
    const instance = utils.getGlobalFederationInstance(options.name, options.version);
    if (!instance) {
        FederationInstance = createInstance(options);
        return FederationInstance;
    }
    else {
        // Merge options
        instance.initOptions(options);
        if (!FederationInstance) {
            FederationInstance = instance;
        }
        return instance;
    }
}
function loadRemote(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    const loadRemote = FederationInstance.loadRemote;
    // eslint-disable-next-line prefer-spread
    return loadRemote.apply(FederationInstance, args);
}
function loadShare(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    // eslint-disable-next-line prefer-spread
    const loadShare = FederationInstance.loadShare;
    return loadShare.apply(FederationInstance, args);
}
function loadShareSync(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    const loadShareSync = FederationInstance.loadShareSync;
    // eslint-disable-next-line prefer-spread
    return loadShareSync.apply(FederationInstance, args);
}
function preloadRemote(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    // eslint-disable-next-line prefer-spread
    return FederationInstance.preloadRemote.apply(FederationInstance, args);
}
function registerRemotes(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    // eslint-disable-next-line prefer-spread
    return FederationInstance.registerRemotes.apply(FederationInstance, args);
}
function registerPlugins(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    // eslint-disable-next-line prefer-spread
    return FederationInstance.registerPlugins.apply(FederationInstance, args);
}
function getInstance() {
    return FederationInstance;
}
function registerShared(...args) {
    runtimeCore.assert(FederationInstance, errorCodes.getShortErrorMsg(errorCodes.RUNTIME_009, errorCodes.runtimeDescMap));
    // eslint-disable-next-line prefer-spread
    return FederationInstance.registerShared.apply(FederationInstance, args);
}
// Inject for debug
runtimeCore.setGlobalFederationConstructor(runtimeCore.ModuleFederation);

exports.Module = runtimeCore.Module;
exports.ModuleFederation = runtimeCore.ModuleFederation;
exports.getRemoteEntry = runtimeCore.getRemoteEntry;
exports.getRemoteInfo = runtimeCore.getRemoteInfo;
exports.loadScript = runtimeCore.loadScript;
exports.loadScriptNode = runtimeCore.loadScriptNode;
exports.registerGlobalPlugins = runtimeCore.registerGlobalPlugins;
exports.createInstance = createInstance;
exports.getInstance = getInstance;
exports.init = init;
exports.loadRemote = loadRemote;
exports.loadShare = loadShare;
exports.loadShareSync = loadShareSync;
exports.preloadRemote = preloadRemote;
exports.registerPlugins = registerPlugins;
exports.registerRemotes = registerRemotes;
exports.registerShared = registerShared;
//# sourceMappingURL=index.cjs.cjs.map


},
79344(__unused_rspack_module, exports, __webpack_require__) {
"use strict";


var runtimeCore = __webpack_require__(88961);

// injected by bundler, so it can not use runtime-core stuff
function getBuilderId() {
    //@ts-ignore
    return typeof FEDERATION_BUILD_IDENTIFIER !== 'undefined'
        ? //@ts-ignore
            FEDERATION_BUILD_IDENTIFIER
        : '';
}
function getGlobalFederationInstance(name, version) {
    const buildId = getBuilderId();
    return runtimeCore.CurrentGlobal.__FEDERATION__.__INSTANCES__.find((GMInstance) => {
        if (buildId && GMInstance.options.id === buildId) {
            return true;
        }
        if (GMInstance.options.name === name &&
            !GMInstance.options.version &&
            !version) {
            return true;
        }
        if (GMInstance.options.name === name &&
            version &&
            GMInstance.options.version === version) {
            return true;
        }
        return false;
    });
}

exports.getGlobalFederationInstance = getGlobalFederationInstance;
//# sourceMappingURL=utils.cjs.cjs.map


},
7783(__unused_rspack_module, exports, __webpack_require__) {
"use strict";
/* provided dependency */ var process = __webpack_require__(88538);


const FederationModuleManifest = 'federation-manifest.json';
const MANIFEST_EXT = '.json';
const BROWSER_LOG_KEY = 'FEDERATION_DEBUG';
const NameTransformSymbol = {
    AT: '@',
    HYPHEN: '-',
    SLASH: '/',
};
const NameTransformMap = {
    [NameTransformSymbol.AT]: 'scope_',
    [NameTransformSymbol.HYPHEN]: '_',
    [NameTransformSymbol.SLASH]: '__',
};
const EncodedNameTransformMap = {
    [NameTransformMap[NameTransformSymbol.AT]]: NameTransformSymbol.AT,
    [NameTransformMap[NameTransformSymbol.HYPHEN]]: NameTransformSymbol.HYPHEN,
    [NameTransformMap[NameTransformSymbol.SLASH]]: NameTransformSymbol.SLASH,
};
const SEPARATOR = ':';
const ManifestFileName = 'mf-manifest.json';
const StatsFileName = 'mf-stats.json';
const MFModuleType = {
    NPM: 'npm',
    APP: 'app',
};
const MODULE_DEVTOOL_IDENTIFIER = '__MF_DEVTOOLS_MODULE_INFO__';
const ENCODE_NAME_PREFIX = 'ENCODE_NAME_PREFIX';
const TEMP_DIR = '.federation';
const MFPrefetchCommon = {
    identifier: 'MFDataPrefetch',
    globalKey: '__PREFETCH__',
    library: 'mf-data-prefetch',
    exportsKey: '__PREFETCH_EXPORTS__',
    fileName: 'bootstrap.js',
};

/*
 * This file was automatically generated.
 * DO NOT MODIFY BY HAND.
 * Run `yarn special-lint-fix` to update
 */

var ContainerPlugin = /*#__PURE__*/Object.freeze({
    __proto__: null
});

/*
 * This file was automatically generated.
 * DO NOT MODIFY BY HAND.
 * Run `yarn special-lint-fix` to update
 */

var ContainerReferencePlugin = /*#__PURE__*/Object.freeze({
    __proto__: null
});

var ModuleFederationPlugin = /*#__PURE__*/Object.freeze({
    __proto__: null
});

/*
 * This file was automatically generated.
 * DO NOT MODIFY BY HAND.
 * Run `yarn special-lint-fix` to update
 */

var SharePlugin = /*#__PURE__*/Object.freeze({
    __proto__: null
});

function isBrowserEnv() {
    return (typeof window !== 'undefined' && typeof window.document !== 'undefined');
}
function isReactNativeEnv() {
    return (typeof navigator !== 'undefined' && navigator?.product === 'ReactNative');
}
function isBrowserDebug() {
    try {
        if (isBrowserEnv() && window.localStorage) {
            return Boolean(localStorage.getItem(BROWSER_LOG_KEY));
        }
    }
    catch (error) {
        return false;
    }
    return false;
}
function isDebugMode() {
    if (typeof process !== 'undefined' &&
        process.env &&
        process.env['FEDERATION_DEBUG']) {
        return Boolean(process.env['FEDERATION_DEBUG']);
    }
    if (typeof FEDERATION_DEBUG !== 'undefined' && Boolean(FEDERATION_DEBUG)) {
        return true;
    }
    return isBrowserDebug();
}
const getProcessEnv = function () {
    return typeof process !== 'undefined' && process.env ? process.env : {};
};

const LOG_CATEGORY = '[ Federation Runtime ]';
// entry: name:version   version : 1.0.0 | ^1.2.3
// entry: name:entry  entry:  https://localhost:9000/federation-manifest.json
const parseEntry = (str, devVerOrUrl, separator = SEPARATOR) => {
    const strSplit = str.split(separator);
    const devVersionOrUrl = getProcessEnv()['NODE_ENV'] === 'development' && devVerOrUrl;
    const defaultVersion = '*';
    const isEntry = (s) => s.startsWith('http') || s.includes(MANIFEST_EXT);
    // Check if the string starts with a type
    if (strSplit.length >= 2) {
        let [name, ...versionOrEntryArr] = strSplit;
        // @name@manifest-url.json
        if (str.startsWith(separator)) {
            name = strSplit.slice(0, 2).join(separator);
            versionOrEntryArr = [
                devVersionOrUrl || strSplit.slice(2).join(separator),
            ];
        }
        let versionOrEntry = devVersionOrUrl || versionOrEntryArr.join(separator);
        if (isEntry(versionOrEntry)) {
            return {
                name,
                entry: versionOrEntry,
            };
        }
        else {
            // Apply version rule
            // devVersionOrUrl => inputVersion => defaultVersion
            return {
                name,
                version: versionOrEntry || defaultVersion,
            };
        }
    }
    else if (strSplit.length === 1) {
        const [name] = strSplit;
        if (devVersionOrUrl && isEntry(devVersionOrUrl)) {
            return {
                name,
                entry: devVersionOrUrl,
            };
        }
        return {
            name,
            version: devVersionOrUrl || defaultVersion,
        };
    }
    else {
        throw `Invalid entry value: ${str}`;
    }
};
const composeKeyWithSeparator = function (...args) {
    if (!args.length) {
        return '';
    }
    return args.reduce((sum, cur) => {
        if (!cur) {
            return sum;
        }
        if (!sum) {
            return cur;
        }
        return `${sum}${SEPARATOR}${cur}`;
    }, '');
};
const encodeName = function (name, prefix = '', withExt = false) {
    try {
        const ext = withExt ? '.js' : '';
        return `${prefix}${name
            .replace(new RegExp(`${NameTransformSymbol.AT}`, 'g'), NameTransformMap[NameTransformSymbol.AT])
            .replace(new RegExp(`${NameTransformSymbol.HYPHEN}`, 'g'), NameTransformMap[NameTransformSymbol.HYPHEN])
            .replace(new RegExp(`${NameTransformSymbol.SLASH}`, 'g'), NameTransformMap[NameTransformSymbol.SLASH])}${ext}`;
    }
    catch (err) {
        throw err;
    }
};
const decodeName = function (name, prefix, withExt) {
    try {
        let decodedName = name;
        if (prefix) {
            if (!decodedName.startsWith(prefix)) {
                return decodedName;
            }
            decodedName = decodedName.replace(new RegExp(prefix, 'g'), '');
        }
        decodedName = decodedName
            .replace(new RegExp(`${NameTransformMap[NameTransformSymbol.AT]}`, 'g'), EncodedNameTransformMap[NameTransformMap[NameTransformSymbol.AT]])
            .replace(new RegExp(`${NameTransformMap[NameTransformSymbol.SLASH]}`, 'g'), EncodedNameTransformMap[NameTransformMap[NameTransformSymbol.SLASH]])
            .replace(new RegExp(`${NameTransformMap[NameTransformSymbol.HYPHEN]}`, 'g'), EncodedNameTransformMap[NameTransformMap[NameTransformSymbol.HYPHEN]]);
        if (withExt) {
            decodedName = decodedName.replace('.js', '');
        }
        return decodedName;
    }
    catch (err) {
        throw err;
    }
};
const generateExposeFilename = (exposeName, withExt) => {
    if (!exposeName) {
        return '';
    }
    let expose = exposeName;
    if (expose === '.') {
        expose = 'default_export';
    }
    if (expose.startsWith('./')) {
        expose = expose.replace('./', '');
    }
    return encodeName(expose, '__federation_expose_', withExt);
};
const generateShareFilename = (pkgName, withExt) => {
    if (!pkgName) {
        return '';
    }
    return encodeName(pkgName, '__federation_shared_', withExt);
};
const getResourceUrl = (module, sourceUrl) => {
    if ('getPublicPath' in module) {
        let publicPath;
        if (!module.getPublicPath.startsWith('function')) {
            publicPath = new Function(module.getPublicPath)();
        }
        else {
            publicPath = new Function('return ' + module.getPublicPath)()();
        }
        return `${publicPath}${sourceUrl}`;
    }
    else if ('publicPath' in module) {
        if (!isBrowserEnv() && !isReactNativeEnv() && 'ssrPublicPath' in module) {
            return `${module.ssrPublicPath}${sourceUrl}`;
        }
        return `${module.publicPath}${sourceUrl}`;
    }
    else {
        console.warn('Cannot get resource URL. If in debug mode, please ignore.', module, sourceUrl);
        return '';
    }
};
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
const assert = (condition, msg) => {
    if (!condition) {
        error(msg);
    }
};
const error = (msg) => {
    throw new Error(`${LOG_CATEGORY}: ${msg}`);
};
const warn = (msg) => {
    console.warn(`${LOG_CATEGORY}: ${msg}`);
};
function safeToString(info) {
    try {
        return JSON.stringify(info, null, 2);
    }
    catch (e) {
        return '';
    }
}
// RegExp for version string
const VERSION_PATTERN_REGEXP = /^([\d^=v<>~]|[*xX]$)/;
function isRequiredVersion(str) {
    return VERSION_PATTERN_REGEXP.test(str);
}

const simpleJoinRemoteEntry = (rPath, rName) => {
    if (!rPath) {
        return rName;
    }
    const transformPath = (str) => {
        if (str === '.') {
            return '';
        }
        if (str.startsWith('./')) {
            return str.replace('./', '');
        }
        if (str.startsWith('/')) {
            const strWithoutSlash = str.slice(1);
            if (strWithoutSlash.endsWith('/')) {
                return strWithoutSlash.slice(0, -1);
            }
            return strWithoutSlash;
        }
        return str;
    };
    const transformedPath = transformPath(rPath);
    if (!transformedPath) {
        return rName;
    }
    if (transformedPath.endsWith('/')) {
        return `${transformedPath}${rName}`;
    }
    return `${transformedPath}/${rName}`;
};
function inferAutoPublicPath(url) {
    return url
        .replace(/#.*$/, '')
        .replace(/\?.*$/, '')
        .replace(/\/[^\/]+$/, '/');
}
// Priority: overrides > remotes
// eslint-disable-next-line max-lines-per-function
function generateSnapshotFromManifest(manifest, options = {}) {
    const { remotes = {}, overrides = {}, version } = options;
    let remoteSnapshot;
    const getPublicPath = () => {
        if ('publicPath' in manifest.metaData) {
            if (manifest.metaData.publicPath === 'auto' && version) {
                // use same implementation as publicPath auto runtime module implements
                return inferAutoPublicPath(version);
            }
            return manifest.metaData.publicPath;
        }
        else {
            return manifest.metaData.getPublicPath;
        }
    };
    const overridesKeys = Object.keys(overrides);
    let remotesInfo = {};
    // If remotes are not provided, only the remotes in the manifest will be read
    if (!Object.keys(remotes).length) {
        remotesInfo =
            manifest.remotes?.reduce((res, next) => {
                let matchedVersion;
                const name = next.federationContainerName;
                // overrides have higher priority
                if (overridesKeys.includes(name)) {
                    matchedVersion = overrides[name];
                }
                else {
                    if ('version' in next) {
                        matchedVersion = next.version;
                    }
                    else {
                        matchedVersion = next.entry;
                    }
                }
                res[name] = {
                    matchedVersion,
                };
                return res;
            }, {}) || {};
    }
    // If remotes (deploy scenario) are specified, they need to be traversed again
    Object.keys(remotes).forEach((key) => (remotesInfo[key] = {
        // overrides will override dependencies
        matchedVersion: overridesKeys.includes(key)
            ? overrides[key]
            : remotes[key],
    }));
    const { remoteEntry: { path: remoteEntryPath, name: remoteEntryName, type: remoteEntryType, }, types: remoteTypes = { path: '', name: '', zip: '', api: '' }, buildInfo: { buildVersion }, globalName, ssrRemoteEntry, } = manifest.metaData;
    const { exposes } = manifest;
    let basicRemoteSnapshot = {
        version: version ? version : '',
        buildVersion,
        globalName,
        remoteEntry: simpleJoinRemoteEntry(remoteEntryPath, remoteEntryName),
        remoteEntryType,
        remoteTypes: simpleJoinRemoteEntry(remoteTypes.path, remoteTypes.name),
        remoteTypesZip: remoteTypes.zip || '',
        remoteTypesAPI: remoteTypes.api || '',
        remotesInfo,
        shared: manifest?.shared.map((item) => ({
            assets: item.assets,
            sharedName: item.name,
            version: item.version,
        })),
        modules: exposes?.map((expose) => ({
            moduleName: expose.name,
            modulePath: expose.path,
            assets: expose.assets,
        })),
    };
    if (manifest.metaData?.prefetchInterface) {
        const prefetchInterface = manifest.metaData.prefetchInterface;
        basicRemoteSnapshot = {
            ...basicRemoteSnapshot,
            prefetchInterface,
        };
    }
    if (manifest.metaData?.prefetchEntry) {
        const { path, name, type } = manifest.metaData.prefetchEntry;
        basicRemoteSnapshot = {
            ...basicRemoteSnapshot,
            prefetchEntry: simpleJoinRemoteEntry(path, name),
            prefetchEntryType: type,
        };
    }
    if ('publicPath' in manifest.metaData) {
        remoteSnapshot = {
            ...basicRemoteSnapshot,
            publicPath: getPublicPath(),
            ssrPublicPath: manifest.metaData.ssrPublicPath,
        };
    }
    else {
        remoteSnapshot = {
            ...basicRemoteSnapshot,
            getPublicPath: getPublicPath(),
        };
    }
    if (ssrRemoteEntry) {
        const fullSSRRemoteEntry = simpleJoinRemoteEntry(ssrRemoteEntry.path, ssrRemoteEntry.name);
        remoteSnapshot.ssrRemoteEntry = fullSSRRemoteEntry;
        remoteSnapshot.ssrRemoteEntryType =
            ssrRemoteEntry.type || 'commonjs-module';
    }
    return remoteSnapshot;
}
function isManifestProvider(moduleInfo) {
    if ('remoteEntry' in moduleInfo &&
        moduleInfo.remoteEntry.includes(MANIFEST_EXT)) {
        return true;
    }
    else {
        return false;
    }
}
function getManifestFileName(manifestOptions) {
    if (!manifestOptions) {
        return {
            statsFileName: StatsFileName,
            manifestFileName: ManifestFileName,
        };
    }
    let filePath = typeof manifestOptions === 'boolean' ? '' : manifestOptions.filePath || '';
    let fileName = typeof manifestOptions === 'boolean' ? '' : manifestOptions.fileName || '';
    const JSON_EXT = '.json';
    const addExt = (name) => {
        if (name.endsWith(JSON_EXT)) {
            return name;
        }
        return `${name}${JSON_EXT}`;
    };
    const insertSuffix = (name, suffix) => {
        return name.replace(JSON_EXT, `${suffix}${JSON_EXT}`);
    };
    const manifestFileName = fileName ? addExt(fileName) : ManifestFileName;
    const statsFileName = fileName
        ? insertSuffix(manifestFileName, '-stats')
        : StatsFileName;
    return {
        statsFileName: simpleJoinRemoteEntry(filePath, statsFileName),
        manifestFileName: simpleJoinRemoteEntry(filePath, manifestFileName),
    };
}

const PREFIX = '[ Module Federation ]';
const DEFAULT_DELEGATE = console;
const LOGGER_STACK_SKIP_TOKENS = [
    'logger.ts',
    'logger.js',
    'captureStackTrace',
    'Logger.emit',
    'Logger.log',
    'Logger.info',
    'Logger.warn',
    'Logger.error',
    'Logger.debug',
];
function captureStackTrace() {
    try {
        const stack = new Error().stack;
        if (!stack) {
            return undefined;
        }
        const [, ...rawLines] = stack.split('\n');
        const filtered = rawLines.filter((line) => !LOGGER_STACK_SKIP_TOKENS.some((token) => line.includes(token)));
        if (!filtered.length) {
            return undefined;
        }
        const stackPreview = filtered.slice(0, 5).join('\n');
        return `Stack trace:\n${stackPreview}`;
    }
    catch {
        return undefined;
    }
}
class Logger {
    constructor(prefix, delegate = DEFAULT_DELEGATE) {
        this.prefix = prefix;
        this.delegate = delegate ?? DEFAULT_DELEGATE;
    }
    setPrefix(prefix) {
        this.prefix = prefix;
    }
    setDelegate(delegate) {
        this.delegate = delegate ?? DEFAULT_DELEGATE;
    }
    emit(method, args) {
        const delegate = this.delegate;
        const debugMode = isDebugMode();
        const stackTrace = debugMode ? captureStackTrace() : undefined;
        const enrichedArgs = stackTrace ? [...args, stackTrace] : args;
        const order = (() => {
            switch (method) {
                case 'log':
                    return ['log', 'info'];
                case 'info':
                    return ['info', 'log'];
                case 'warn':
                    return ['warn', 'info', 'log'];
                case 'error':
                    return ['error', 'warn', 'log'];
                case 'debug':
                default:
                    return ['debug', 'log'];
            }
        })();
        for (const candidate of order) {
            const handler = delegate[candidate];
            if (typeof handler === 'function') {
                handler.call(delegate, this.prefix, ...enrichedArgs);
                return;
            }
        }
        for (const candidate of order) {
            const handler = DEFAULT_DELEGATE[candidate];
            if (typeof handler === 'function') {
                handler.call(DEFAULT_DELEGATE, this.prefix, ...enrichedArgs);
                return;
            }
        }
    }
    log(...args) {
        this.emit('log', args);
    }
    warn(...args) {
        this.emit('warn', args);
    }
    error(...args) {
        this.emit('error', args);
    }
    success(...args) {
        this.emit('info', args);
    }
    info(...args) {
        this.emit('info', args);
    }
    ready(...args) {
        this.emit('info', args);
    }
    debug(...args) {
        if (isDebugMode()) {
            this.emit('debug', args);
        }
    }
}
function createLogger(prefix) {
    return new Logger(prefix);
}
function createInfrastructureLogger(prefix) {
    const infrastructureLogger = new Logger(prefix);
    Object.defineProperty(infrastructureLogger, '__mf_infrastructure_logger__', {
        value: true,
        enumerable: false,
        configurable: false,
    });
    return infrastructureLogger;
}
function bindLoggerToCompiler(loggerInstance, compiler, name) {
    if (!loggerInstance
        .__mf_infrastructure_logger__) {
        return;
    }
    if (!compiler?.getInfrastructureLogger) {
        return;
    }
    try {
        const infrastructureLogger = compiler.getInfrastructureLogger(name);
        if (infrastructureLogger &&
            typeof infrastructureLogger === 'object' &&
            (typeof infrastructureLogger.log === 'function' ||
                typeof infrastructureLogger.info === 'function' ||
                typeof infrastructureLogger.warn === 'function' ||
                typeof infrastructureLogger.error === 'function')) {
            loggerInstance.setDelegate(infrastructureLogger);
        }
    }
    catch {
        // If the bundler throws (older versions), fall back to default console logger.
        loggerInstance.setDelegate(undefined);
    }
}
const logger = createLogger(PREFIX);
const infrastructureLogger = createInfrastructureLogger(PREFIX);

// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function safeWrapper(callback, disableWarn) {
    try {
        const res = await callback();
        return res;
    }
    catch (e) {
        !disableWarn && warn(e);
        return;
    }
}
function isStaticResourcesEqual(url1, url2) {
    const REG_EXP = /^(https?:)?\/\//i;
    // Transform url1 and url2 into relative paths
    const relativeUrl1 = url1.replace(REG_EXP, '').replace(/\/$/, '');
    const relativeUrl2 = url2.replace(REG_EXP, '').replace(/\/$/, '');
    // Check if the relative paths are identical
    return relativeUrl1 === relativeUrl2;
}
function createScript(info) {
    // Retrieve the existing script element by its src attribute
    let script = null;
    let needAttach = true;
    let timeout = 20000;
    let timeoutId;
    const scripts = document.getElementsByTagName('script');
    for (let i = 0; i < scripts.length; i++) {
        const s = scripts[i];
        const scriptSrc = s.getAttribute('src');
        if (scriptSrc && isStaticResourcesEqual(scriptSrc, info.url)) {
            script = s;
            needAttach = false;
            break;
        }
    }
    if (!script) {
        const attrs = info.attrs;
        script = document.createElement('script');
        script.type = attrs?.['type'] === 'module' ? 'module' : 'text/javascript';
        let createScriptRes = undefined;
        if (info.createScriptHook) {
            createScriptRes = info.createScriptHook(info.url, info.attrs);
            if (createScriptRes instanceof HTMLScriptElement) {
                script = createScriptRes;
            }
            else if (typeof createScriptRes === 'object') {
                if ('script' in createScriptRes && createScriptRes.script) {
                    script = createScriptRes.script;
                }
                if ('timeout' in createScriptRes && createScriptRes.timeout) {
                    timeout = createScriptRes.timeout;
                }
            }
        }
        if (!script.src) {
            script.src = info.url;
        }
        if (attrs && !createScriptRes) {
            Object.keys(attrs).forEach((name) => {
                if (script) {
                    if (name === 'async' || name === 'defer') {
                        script[name] = attrs[name];
                        // Attributes that do not exist are considered overridden
                    }
                    else if (!script.getAttribute(name)) {
                        script.setAttribute(name, attrs[name]);
                    }
                }
            });
        }
    }
    const onScriptComplete = async (prev, 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    event) => {
        clearTimeout(timeoutId);
        const onScriptCompleteCallback = () => {
            if (event?.type === 'error') {
                info?.onErrorCallback && info?.onErrorCallback(event);
            }
            else {
                info?.cb && info?.cb();
            }
        };
        // Prevent memory leaks in IE.
        if (script) {
            script.onerror = null;
            script.onload = null;
            safeWrapper(() => {
                const { needDeleteScript = true } = info;
                if (needDeleteScript) {
                    script?.parentNode && script.parentNode.removeChild(script);
                }
            });
            if (prev && typeof prev === 'function') {
                const result = prev(event);
                if (result instanceof Promise) {
                    const res = await result;
                    onScriptCompleteCallback();
                    return res;
                }
                onScriptCompleteCallback();
                return result;
            }
        }
        onScriptCompleteCallback();
    };
    script.onerror = onScriptComplete.bind(null, script.onerror);
    script.onload = onScriptComplete.bind(null, script.onload);
    timeoutId = setTimeout(() => {
        onScriptComplete(null, new Error(`Remote script "${info.url}" time-outed.`));
    }, timeout);
    return { script, needAttach };
}
function createLink(info) {
    // <link rel="preload" href="script.js" as="script">
    // Retrieve the existing script element by its src attribute
    let link = null;
    let needAttach = true;
    const links = document.getElementsByTagName('link');
    for (let i = 0; i < links.length; i++) {
        const l = links[i];
        const linkHref = l.getAttribute('href');
        const linkRel = l.getAttribute('rel');
        if (linkHref &&
            isStaticResourcesEqual(linkHref, info.url) &&
            linkRel === info.attrs['rel']) {
            link = l;
            needAttach = false;
            break;
        }
    }
    if (!link) {
        link = document.createElement('link');
        link.setAttribute('href', info.url);
        let createLinkRes = undefined;
        const attrs = info.attrs;
        if (info.createLinkHook) {
            createLinkRes = info.createLinkHook(info.url, attrs);
            if (createLinkRes instanceof HTMLLinkElement) {
                link = createLinkRes;
            }
        }
        if (attrs && !createLinkRes) {
            Object.keys(attrs).forEach((name) => {
                if (link && !link.getAttribute(name)) {
                    link.setAttribute(name, attrs[name]);
                }
            });
        }
    }
    const onLinkComplete = (prev, 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    event) => {
        const onLinkCompleteCallback = () => {
            if (event?.type === 'error') {
                info?.onErrorCallback && info?.onErrorCallback(event);
            }
            else {
                info?.cb && info?.cb();
            }
        };
        // Prevent memory leaks in IE.
        if (link) {
            link.onerror = null;
            link.onload = null;
            safeWrapper(() => {
                const { needDeleteLink = true } = info;
                if (needDeleteLink) {
                    link?.parentNode && link.parentNode.removeChild(link);
                }
            });
            if (prev) {
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                const res = prev(event);
                onLinkCompleteCallback();
                return res;
            }
        }
        onLinkCompleteCallback();
    };
    link.onerror = onLinkComplete.bind(null, link.onerror);
    link.onload = onLinkComplete.bind(null, link.onload);
    return { link, needAttach };
}
function loadScript(url, info) {
    const { attrs = {}, createScriptHook } = info;
    return new Promise((resolve, reject) => {
        const { script, needAttach } = createScript({
            url,
            cb: resolve,
            onErrorCallback: reject,
            attrs: {
                fetchpriority: 'high',
                ...attrs,
            },
            createScriptHook,
            needDeleteScript: true,
        });
        needAttach && document.head.appendChild(script);
    });
}

const sdkImportCache = new Map();
function importNodeModule(name) {
    if (!name) {
        throw new Error('import specifier is required');
    }
    // Check cache to prevent infinite recursion
    if (sdkImportCache.has(name)) {
        return sdkImportCache.get(name);
    }
    const importModule = new Function('name', `return import(name)`);
    const promise = importModule(name)
        .then((res) => res)
        .catch((error) => {
        console.error(`Error importing module ${name}:`, error);
        // Remove from cache on error so it can be retried
        sdkImportCache.delete(name);
        throw error;
    });
    // Cache the promise to prevent recursive calls
    sdkImportCache.set(name, promise);
    return promise;
}
const loadNodeFetch = async () => {
    const fetchModule = await importNodeModule('node-fetch');
    return (fetchModule.default || fetchModule);
};
const lazyLoaderHookFetch = async (input, init, loaderHook) => {
    const hook = (url, init) => {
        return loaderHook.lifecycle.fetch.emit(url, init);
    };
    const res = await hook(input, init || {});
    if (!res || !(res instanceof Response)) {
        const fetchFunction = typeof fetch === 'undefined' ? await loadNodeFetch() : fetch;
        return fetchFunction(input, init || {});
    }
    return res;
};
const createScriptNode = typeof ENV_TARGET === 'undefined' || ENV_TARGET !== 'web'
    ? (url, cb, attrs, loaderHook) => {
        if (loaderHook?.createScriptHook) {
            const hookResult = loaderHook.createScriptHook(url);
            if (hookResult &&
                typeof hookResult === 'object' &&
                'url' in hookResult) {
                url = hookResult.url;
            }
        }
        let urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (e) {
            console.error('Error constructing URL:', e);
            cb(new Error(`Invalid URL: ${e}`));
            return;
        }
        const getFetch = async () => {
            if (loaderHook?.fetch) {
                return (input, init) => lazyLoaderHookFetch(input, init, loaderHook);
            }
            return typeof fetch === 'undefined' ? loadNodeFetch() : fetch;
        };
        const handleScriptFetch = async (f, urlObj) => {
            try {
                const res = await f(urlObj.href);
                const data = await res.text();
                const [path, vm] = await Promise.all([
                    importNodeModule('path'),
                    importNodeModule('vm'),
                ]);
                const scriptContext = { exports: {}, module: { exports: {} } };
                const urlDirname = urlObj.pathname
                    .split('/')
                    .slice(0, -1)
                    .join('/');
                const filename = path.basename(urlObj.pathname);
                const script = new vm.Script(`(function(exports, module, require, __dirname, __filename) {${data}\n})`, {
                    filename,
                    importModuleDynamically: 
                    //@ts-ignore
                    vm.constants?.USE_MAIN_CONTEXT_DEFAULT_LOADER ??
                        importNodeModule,
                });
                script.runInThisContext()(scriptContext.exports, scriptContext.module, eval('require'), urlDirname, filename);
                const exportedInterface = scriptContext.module.exports || scriptContext.exports;
                if (attrs && exportedInterface && attrs['globalName']) {
                    const container = exportedInterface[attrs['globalName']] || exportedInterface;
                    cb(undefined, container);
                    return;
                }
                cb(undefined, exportedInterface);
            }
            catch (e) {
                cb(e instanceof Error
                    ? e
                    : new Error(`Script execution error: ${e}`));
            }
        };
        getFetch()
            .then(async (f) => {
            if (attrs?.['type'] === 'esm' || attrs?.['type'] === 'module') {
                return loadModule(urlObj.href, {
                    fetch: f,
                    vm: await importNodeModule('vm'),
                })
                    .then(async (module) => {
                    await module.evaluate();
                    cb(undefined, module.namespace);
                })
                    .catch((e) => {
                    cb(e instanceof Error
                        ? e
                        : new Error(`Script execution error: ${e}`));
                });
            }
            handleScriptFetch(f, urlObj);
        })
            .catch((err) => {
            cb(err);
        });
    }
    : (url, cb, attrs, loaderHook) => {
        cb(new Error('createScriptNode is disabled in non-Node.js environment'));
    };
const loadScriptNode = typeof ENV_TARGET === 'undefined' || ENV_TARGET !== 'web'
    ? (url, info) => {
        return new Promise((resolve, reject) => {
            createScriptNode(url, (error, scriptContext) => {
                if (error) {
                    reject(error);
                }
                else {
                    const remoteEntryKey = info?.attrs?.['globalName'] ||
                        `__FEDERATION_${info?.attrs?.['name']}:custom__`;
                    const entryExports = (globalThis[remoteEntryKey] =
                        scriptContext);
                    resolve(entryExports);
                }
            }, info.attrs, info.loaderHook);
        });
    }
    : (url, info) => {
        throw new Error('loadScriptNode is disabled in non-Node.js environment');
    };
const esmModuleCache = new Map();
async function loadModule(url, options) {
    // Check cache to prevent infinite recursion in ESM loading
    if (esmModuleCache.has(url)) {
        return esmModuleCache.get(url);
    }
    const { fetch, vm } = options;
    const response = await fetch(url);
    const code = await response.text();
    const module = new vm.SourceTextModule(code, {
        // @ts-ignore
        importModuleDynamically: async (specifier, script) => {
            const resolvedUrl = new URL(specifier, url).href;
            return loadModule(resolvedUrl, options);
        },
    });
    // Cache the module before linking to prevent cycles
    esmModuleCache.set(url, module);
    await module.link(async (specifier) => {
        const resolvedUrl = new URL(specifier, url).href;
        const module = await loadModule(resolvedUrl, options);
        return module;
    });
    return module;
}

function normalizeOptions(enableDefault, defaultOptions, key) {
    return function (options) {
        if (options === false) {
            return false;
        }
        if (typeof options === 'undefined') {
            if (enableDefault) {
                return defaultOptions;
            }
            else {
                return false;
            }
        }
        if (options === true) {
            return defaultOptions;
        }
        if (options && typeof options === 'object') {
            return {
                ...defaultOptions,
                ...options,
            };
        }
        throw new Error(`Unexpected type for \`${key}\`, expect boolean/undefined/object, got: ${typeof options}`);
    };
}

const createModuleFederationConfig = (options) => {
    return options;
};

exports.BROWSER_LOG_KEY = BROWSER_LOG_KEY;
exports.ENCODE_NAME_PREFIX = ENCODE_NAME_PREFIX;
exports.EncodedNameTransformMap = EncodedNameTransformMap;
exports.FederationModuleManifest = FederationModuleManifest;
exports.MANIFEST_EXT = MANIFEST_EXT;
exports.MFModuleType = MFModuleType;
exports.MFPrefetchCommon = MFPrefetchCommon;
exports.MODULE_DEVTOOL_IDENTIFIER = MODULE_DEVTOOL_IDENTIFIER;
exports.ManifestFileName = ManifestFileName;
exports.NameTransformMap = NameTransformMap;
exports.NameTransformSymbol = NameTransformSymbol;
exports.SEPARATOR = SEPARATOR;
exports.StatsFileName = StatsFileName;
exports.TEMP_DIR = TEMP_DIR;
exports.assert = assert;
exports.bindLoggerToCompiler = bindLoggerToCompiler;
exports.composeKeyWithSeparator = composeKeyWithSeparator;
exports.containerPlugin = ContainerPlugin;
exports.containerReferencePlugin = ContainerReferencePlugin;
exports.createInfrastructureLogger = createInfrastructureLogger;
exports.createLink = createLink;
exports.createLogger = createLogger;
exports.createModuleFederationConfig = createModuleFederationConfig;
exports.createScript = createScript;
exports.createScriptNode = createScriptNode;
exports.decodeName = decodeName;
exports.encodeName = encodeName;
exports.error = error;
exports.generateExposeFilename = generateExposeFilename;
exports.generateShareFilename = generateShareFilename;
exports.generateSnapshotFromManifest = generateSnapshotFromManifest;
exports.getManifestFileName = getManifestFileName;
exports.getProcessEnv = getProcessEnv;
exports.getResourceUrl = getResourceUrl;
exports.inferAutoPublicPath = inferAutoPublicPath;
exports.infrastructureLogger = infrastructureLogger;
exports.isBrowserEnv = isBrowserEnv;
exports.isDebugMode = isDebugMode;
exports.isManifestProvider = isManifestProvider;
exports.isReactNativeEnv = isReactNativeEnv;
exports.isRequiredVersion = isRequiredVersion;
exports.isStaticResourcesEqual = isStaticResourcesEqual;
exports.loadScript = loadScript;
exports.loadScriptNode = loadScriptNode;
exports.logger = logger;
exports.moduleFederationPlugin = ModuleFederationPlugin;
exports.normalizeOptions = normalizeOptions;
exports.parseEntry = parseEntry;
exports.safeToString = safeToString;
exports.safeWrapper = safeWrapper;
exports.sharePlugin = SharePlugin;
exports.simpleJoinRemoteEntry = simpleJoinRemoteEntry;
exports.warn = warn;
//# sourceMappingURL=index.cjs.cjs.map


},
96582(__unused_rspack_module, exports) {
"use strict";


const FEDERATION_SUPPORTED_TYPES = ['script'];

exports.FEDERATION_SUPPORTED_TYPES = FEDERATION_SUPPORTED_TYPES;
//# sourceMappingURL=constant.cjs.cjs.map


},
6802(module, __unused_rspack_exports, __webpack_require__) {
"use strict";


var runtime = __webpack_require__(32055);
var constant = __webpack_require__(96582);
var sdk = __webpack_require__(7783);

function _interopNamespaceDefault(e) {
    var n = Object.create(null);
    if (e) {
        for (var k in e) {
            n[k] = e[k];
        }
    }
    n.default = e;
    return Object.freeze(n);
}

var runtime__namespace = /*#__PURE__*/_interopNamespaceDefault(runtime);

function attachShareScopeMap(webpackRequire) {
    if (!webpackRequire.S ||
        webpackRequire.federation.hasAttachShareScopeMap ||
        !webpackRequire.federation.instance ||
        !webpackRequire.federation.instance.shareScopeMap) {
        return;
    }
    webpackRequire.S = webpackRequire.federation.instance.shareScopeMap;
    webpackRequire.federation.hasAttachShareScopeMap = true;
}

function updateConsumeOptions(options) {
    const { webpackRequire, moduleToHandlerMapping } = options;
    const { consumesLoadingData, initializeSharingData } = webpackRequire;
    if (consumesLoadingData && !consumesLoadingData._updated) {
        const { moduleIdToConsumeDataMapping: updatedModuleIdToConsumeDataMapping = {}, initialConsumes: updatedInitialConsumes = [], chunkMapping: updatedChunkMapping = {}, } = consumesLoadingData;
        Object.entries(updatedModuleIdToConsumeDataMapping).forEach(([id, data]) => {
            if (!moduleToHandlerMapping[id]) {
                moduleToHandlerMapping[id] = {
                    getter: data.fallback,
                    shareInfo: {
                        shareConfig: {
                            requiredVersion: data.requiredVersion,
                            strictVersion: data.strictVersion,
                            singleton: data.singleton,
                            eager: data.eager,
                            layer: data.layer,
                        },
                        scope: Array.isArray(data.shareScope)
                            ? data.shareScope
                            : [data.shareScope || 'default'],
                    },
                    shareKey: data.shareKey,
                };
            }
        });
        if ('initialConsumes' in options) {
            const { initialConsumes = [] } = options;
            updatedInitialConsumes.forEach((id) => {
                if (!initialConsumes.includes(id)) {
                    initialConsumes.push(id);
                }
            });
        }
        if ('chunkMapping' in options) {
            const { chunkMapping = {} } = options;
            Object.entries(updatedChunkMapping).forEach(([id, chunkModules]) => {
                if (!chunkMapping[id]) {
                    chunkMapping[id] = [];
                }
                chunkModules.forEach((moduleId) => {
                    if (!chunkMapping[id].includes(moduleId)) {
                        chunkMapping[id].push(moduleId);
                    }
                });
            });
        }
        consumesLoadingData._updated = 1;
    }
    if (initializeSharingData && !initializeSharingData._updated) {
        const { federation } = webpackRequire;
        if (!federation.instance ||
            !initializeSharingData.scopeToSharingDataMapping) {
            return;
        }
        const shared = {};
        for (let [scope, stages] of Object.entries(initializeSharingData.scopeToSharingDataMapping)) {
            for (let stage of stages) {
                if (typeof stage === 'object' && stage !== null) {
                    const { name, version, factory, eager, singleton, requiredVersion, strictVersion, } = stage;
                    const shareConfig = {
                        requiredVersion: `^${version}`,
                    };
                    const isValidValue = function (val) {
                        return typeof val !== 'undefined';
                    };
                    if (isValidValue(singleton)) {
                        shareConfig.singleton = singleton;
                    }
                    if (isValidValue(requiredVersion)) {
                        shareConfig.requiredVersion = requiredVersion;
                    }
                    if (isValidValue(eager)) {
                        shareConfig.eager = eager;
                    }
                    if (isValidValue(strictVersion)) {
                        shareConfig.strictVersion = strictVersion;
                    }
                    const options = {
                        version,
                        scope: [scope],
                        shareConfig,
                        get: factory,
                    };
                    if (shared[name]) {
                        shared[name].push(options);
                    }
                    else {
                        shared[name] = [options];
                    }
                }
            }
        }
        federation.instance.registerShared(shared);
        initializeSharingData._updated = 1;
    }
}
function updateRemoteOptions(options) {
    const { webpackRequire, idToExternalAndNameMapping = {}, idToRemoteMap = {}, chunkMapping = {}, } = options;
    const { remotesLoadingData } = webpackRequire;
    const remoteInfos = webpackRequire.federation?.bundlerRuntimeOptions?.remotes?.remoteInfos;
    if (!remotesLoadingData || remotesLoadingData._updated || !remoteInfos) {
        return;
    }
    const { chunkMapping: updatedChunkMapping, moduleIdToRemoteDataMapping } = remotesLoadingData;
    if (!updatedChunkMapping || !moduleIdToRemoteDataMapping) {
        return;
    }
    for (let [moduleId, data] of Object.entries(moduleIdToRemoteDataMapping)) {
        if (!idToExternalAndNameMapping[moduleId]) {
            idToExternalAndNameMapping[moduleId] = [
                data.shareScope,
                data.name,
                data.externalModuleId,
            ];
        }
        if (!idToRemoteMap[moduleId] && remoteInfos[data.remoteName]) {
            const items = remoteInfos[data.remoteName];
            idToRemoteMap[moduleId] ||= [];
            items.forEach((item) => {
                if (!idToRemoteMap[moduleId].includes(item)) {
                    idToRemoteMap[moduleId].push(item);
                }
            });
        }
    }
    if (chunkMapping) {
        Object.entries(updatedChunkMapping).forEach(([id, chunkModules]) => {
            if (!chunkMapping[id]) {
                chunkMapping[id] = [];
            }
            chunkModules.forEach((moduleId) => {
                if (!chunkMapping[id].includes(moduleId)) {
                    chunkMapping[id].push(moduleId);
                }
            });
        });
    }
    remotesLoadingData._updated = 1;
}

function remotes(options) {
    updateRemoteOptions(options);
    const { chunkId, promises, webpackRequire, chunkMapping, idToExternalAndNameMapping, idToRemoteMap, } = options;
    attachShareScopeMap(webpackRequire);
    if (webpackRequire.o(chunkMapping, chunkId)) {
        chunkMapping[chunkId].forEach((id) => {
            let getScope = webpackRequire.R;
            if (!getScope) {
                getScope = [];
            }
            const data = idToExternalAndNameMapping[id];
            const remoteInfos = idToRemoteMap[id] || [];
            // @ts-ignore seems not work
            if (getScope.indexOf(data) >= 0) {
                return;
            }
            // @ts-ignore seems not work
            getScope.push(data);
            if (data.p) {
                return promises.push(data.p);
            }
            const onError = (error) => {
                if (!error) {
                    error = new Error('Container missing');
                }
                if (typeof error.message === 'string') {
                    error.message += `\nwhile loading "${data[1]}" from ${data[2]}`;
                }
                webpackRequire.m[id] = () => {
                    throw error;
                };
                data.p = 0;
            };
            const handleFunction = (fn, arg1, arg2, d, next, first) => {
                try {
                    const promise = fn(arg1, arg2);
                    if (promise && promise.then) {
                        const p = promise.then((result) => next(result, d), onError);
                        if (first) {
                            promises.push((data.p = p));
                        }
                        else {
                            return p;
                        }
                    }
                    else {
                        return next(promise, d, first);
                    }
                }
                catch (error) {
                    onError(error);
                }
            };
            const onExternal = (external, _, first) => external
                ? handleFunction(webpackRequire.I, data[0], 0, external, onInitialized, first)
                : onError();
            // eslint-disable-next-line no-var
            var onInitialized = (_, external, first) => handleFunction(external.get, data[1], getScope, 0, onFactory, first);
            // eslint-disable-next-line no-var
            var onFactory = (factory) => {
                data.p = 1;
                webpackRequire.m[id] = (module) => {
                    module.exports = factory();
                };
            };
            const onRemoteLoaded = () => {
                try {
                    const remoteName = sdk.decodeName(remoteInfos[0].name, sdk.ENCODE_NAME_PREFIX);
                    const remoteModuleName = remoteName + data[1].slice(1);
                    const instance = webpackRequire.federation.instance;
                    const loadRemote = () => webpackRequire.federation.instance.loadRemote(remoteModuleName, {
                        loadFactory: false,
                        from: 'build',
                    });
                    if (instance.options.shareStrategy === 'version-first') {
                        return Promise.all(instance.sharedHandler.initializeSharing(data[0])).then(() => {
                            return loadRemote();
                        });
                    }
                    return loadRemote();
                }
                catch (error) {
                    onError(error);
                }
            };
            const useRuntimeLoad = remoteInfos.length === 1 &&
                constant.FEDERATION_SUPPORTED_TYPES.includes(remoteInfos[0].externalType) &&
                remoteInfos[0].name;
            if (useRuntimeLoad) {
                handleFunction(onRemoteLoaded, data[2], 0, 0, onFactory, 1);
            }
            else {
                handleFunction(webpackRequire, data[2], 0, 0, onExternal, 1);
            }
        });
    }
}

function consumes(options) {
    updateConsumeOptions(options);
    const { chunkId, promises, installedModules, webpackRequire, chunkMapping, moduleToHandlerMapping, } = options;
    attachShareScopeMap(webpackRequire);
    if (webpackRequire.o(chunkMapping, chunkId)) {
        chunkMapping[chunkId].forEach((id) => {
            if (webpackRequire.o(installedModules, id)) {
                return promises.push(installedModules[id]);
            }
            const onFactory = (factory) => {
                installedModules[id] = 0;
                webpackRequire.m[id] = (module) => {
                    delete webpackRequire.c[id];
                    const result = factory();
                    // Add layer property from shareConfig if available
                    const { shareInfo } = moduleToHandlerMapping[id];
                    if (shareInfo?.shareConfig?.layer &&
                        result &&
                        typeof result === 'object') {
                        try {
                            // Only set layer if it's not already defined or if it's undefined
                            if (!result.hasOwnProperty('layer') ||
                                result.layer === undefined) {
                                result.layer = shareInfo.shareConfig.layer;
                            }
                        }
                        catch (e) {
                            // Ignore if layer property is read-only
                        }
                    }
                    module.exports = result;
                };
            };
            const onError = (error) => {
                delete installedModules[id];
                webpackRequire.m[id] = (module) => {
                    delete webpackRequire.c[id];
                    throw error;
                };
            };
            try {
                const federationInstance = webpackRequire.federation.instance;
                if (!federationInstance) {
                    throw new Error('Federation instance not found!');
                }
                const { shareKey, getter, shareInfo } = moduleToHandlerMapping[id];
                const promise = federationInstance
                    .loadShare(shareKey, { customShareInfo: shareInfo })
                    .then((factory) => {
                    if (factory === false) {
                        return getter();
                    }
                    return factory;
                });
                if (promise.then) {
                    promises.push((installedModules[id] = promise.then(onFactory).catch(onError)));
                }
                else {
                    // @ts-ignore maintain previous logic
                    onFactory(promise);
                }
            }
            catch (e) {
                onError(e);
            }
        });
    }
}

function initializeSharing({ shareScopeName, webpackRequire, initPromises, initTokens, initScope, }) {
    const shareScopeKeys = Array.isArray(shareScopeName)
        ? shareScopeName
        : [shareScopeName];
    var initializeSharingPromises = [];
    var _initializeSharing = function (shareScopeKey) {
        if (!initScope)
            initScope = [];
        const mfInstance = webpackRequire.federation.instance;
        // handling circular init calls
        var initToken = initTokens[shareScopeKey];
        if (!initToken)
            initToken = initTokens[shareScopeKey] = { from: mfInstance.name };
        if (initScope.indexOf(initToken) >= 0)
            return;
        initScope.push(initToken);
        const promise = initPromises[shareScopeKey];
        if (promise)
            return promise;
        var warn = (msg) => typeof console !== 'undefined' && console.warn && console.warn(msg);
        var initExternal = (id) => {
            var handleError = (err) => warn('Initialization of sharing external failed: ' + err);
            try {
                var module = webpackRequire(id);
                if (!module)
                    return;
                var initFn = (module) => module &&
                    module.init &&
                    // @ts-ignore compat legacy mf shared behavior
                    module.init(webpackRequire.S[shareScopeKey], initScope, {
                        shareScopeMap: webpackRequire.S || {},
                        shareScopeKeys: shareScopeName,
                    });
                if (module.then)
                    return promises.push(module.then(initFn, handleError));
                var initResult = initFn(module);
                // @ts-ignore
                if (initResult && typeof initResult !== 'boolean' && initResult.then)
                    // @ts-ignore
                    return promises.push(initResult['catch'](handleError));
            }
            catch (err) {
                handleError(err);
            }
        };
        const promises = mfInstance.initializeSharing(shareScopeKey, {
            strategy: mfInstance.options.shareStrategy,
            initScope,
            from: 'build',
        });
        attachShareScopeMap(webpackRequire);
        const bundlerRuntimeRemotesOptions = webpackRequire.federation.bundlerRuntimeOptions.remotes;
        if (bundlerRuntimeRemotesOptions) {
            Object.keys(bundlerRuntimeRemotesOptions.idToRemoteMap).forEach((moduleId) => {
                const info = bundlerRuntimeRemotesOptions.idToRemoteMap[moduleId];
                const externalModuleId = bundlerRuntimeRemotesOptions.idToExternalAndNameMapping[moduleId][2];
                if (info.length > 1) {
                    initExternal(externalModuleId);
                }
                else if (info.length === 1) {
                    const remoteInfo = info[0];
                    if (!constant.FEDERATION_SUPPORTED_TYPES.includes(remoteInfo.externalType)) {
                        initExternal(externalModuleId);
                    }
                }
            });
        }
        if (!promises.length) {
            return (initPromises[shareScopeKey] = true);
        }
        return (initPromises[shareScopeKey] = Promise.all(promises).then(() => (initPromises[shareScopeKey] = true)));
    };
    shareScopeKeys.forEach((key) => {
        initializeSharingPromises.push(_initializeSharing(key));
    });
    return Promise.all(initializeSharingPromises).then(() => true);
}

function handleInitialConsumes(options) {
    const { moduleId, moduleToHandlerMapping, webpackRequire } = options;
    const federationInstance = webpackRequire.federation.instance;
    if (!federationInstance) {
        throw new Error('Federation instance not found!');
    }
    const { shareKey, shareInfo } = moduleToHandlerMapping[moduleId];
    try {
        return federationInstance.loadShareSync(shareKey, {
            customShareInfo: shareInfo,
        });
    }
    catch (err) {
        console.error('loadShareSync failed! The function should not be called unless you set "eager:true". If you do not set it, and encounter this issue, you can check whether an async boundary is implemented.');
        console.error('The original error message is as follows: ');
        throw err;
    }
}
function installInitialConsumes(options) {
    const { webpackRequire } = options;
    updateConsumeOptions(options);
    const { initialConsumes, moduleToHandlerMapping, installedModules } = options;
    initialConsumes.forEach((id) => {
        webpackRequire.m[id] = (module) => {
            // Handle scenario when module is used synchronously
            installedModules[id] = 0;
            delete webpackRequire.c[id];
            const factory = handleInitialConsumes({
                moduleId: id,
                moduleToHandlerMapping,
                webpackRequire,
            });
            if (typeof factory !== 'function') {
                throw new Error(`Shared module is not available for eager consumption: ${id}`);
            }
            const result = factory();
            // Add layer property from shareConfig if available
            const { shareInfo } = moduleToHandlerMapping[id];
            if (shareInfo?.shareConfig?.layer &&
                result &&
                typeof result === 'object') {
                try {
                    // Only set layer if it's not already defined or if it's undefined
                    if (!result.hasOwnProperty('layer') ||
                        result.layer === undefined) {
                        result.layer = shareInfo.shareConfig.layer;
                    }
                }
                catch (e) {
                    // Ignore if layer property is read-only
                }
            }
            module.exports = result;
        };
    });
}

function initContainerEntry(options) {
    const { webpackRequire, shareScope, initScope, shareScopeKey, remoteEntryInitOptions, } = options;
    if (!webpackRequire.S)
        return;
    if (!webpackRequire.federation ||
        !webpackRequire.federation.instance ||
        !webpackRequire.federation.initOptions)
        return;
    const federationInstance = webpackRequire.federation.instance;
    federationInstance.initOptions({
        name: webpackRequire.federation.initOptions.name,
        remotes: [],
        ...remoteEntryInitOptions,
    });
    const hostShareScopeKeys = remoteEntryInitOptions?.shareScopeKeys;
    const hostShareScopeMap = remoteEntryInitOptions?.shareScopeMap;
    // host: 'default' remote: 'default'  remote['default'] = hostShareScopeMap['default']
    // host: ['default', 'scope1'] remote: 'default'  remote['default'] = hostShareScopeMap['default']; remote['scope1'] = hostShareScopeMap['scop1']
    // host: 'default' remote: ['default','scope1']  remote['default'] = hostShareScopeMap['default']; remote['scope1'] = hostShareScopeMap['scope1'] = {}
    // host: ['scope1','default'] remote: ['scope1','scope2'] => remote['scope1'] = hostShareScopeMap['scope1']; remote['scope2'] = hostShareScopeMap['scope2'] = {};
    if (!shareScopeKey || typeof shareScopeKey === 'string') {
        const key = shareScopeKey || 'default';
        if (Array.isArray(hostShareScopeKeys)) {
            // const sc = hostShareScopeMap![key];
            // if (!sc) {
            //   throw new Error('shareScopeKey is not exist in hostShareScopeMap');
            // }
            // federationInstance.initShareScopeMap(key, sc, {
            //   hostShareScopeMap: remoteEntryInitOptions?.shareScopeMap || {},
            // });
            hostShareScopeKeys.forEach((hostKey) => {
                if (!hostShareScopeMap[hostKey]) {
                    hostShareScopeMap[hostKey] = {};
                }
                const sc = hostShareScopeMap[hostKey];
                federationInstance.initShareScopeMap(hostKey, sc, {
                    hostShareScopeMap: remoteEntryInitOptions?.shareScopeMap || {},
                });
            });
        }
        else {
            federationInstance.initShareScopeMap(key, shareScope, {
                hostShareScopeMap: remoteEntryInitOptions?.shareScopeMap || {},
            });
        }
    }
    else {
        shareScopeKey.forEach((key) => {
            if (!hostShareScopeKeys || !hostShareScopeMap) {
                federationInstance.initShareScopeMap(key, shareScope, {
                    hostShareScopeMap: remoteEntryInitOptions?.shareScopeMap || {},
                });
                return;
            }
            if (!hostShareScopeMap[key]) {
                hostShareScopeMap[key] = {};
            }
            const sc = hostShareScopeMap[key];
            federationInstance.initShareScopeMap(key, sc, {
                hostShareScopeMap: remoteEntryInitOptions?.shareScopeMap || {},
            });
        });
    }
    if (webpackRequire.federation.attachShareScopeMap) {
        webpackRequire.federation.attachShareScopeMap(webpackRequire);
    }
    if (typeof webpackRequire.federation.prefetch === 'function') {
        webpackRequire.federation.prefetch();
    }
    if (!Array.isArray(shareScopeKey)) {
        // @ts-ignore
        return webpackRequire.I(shareScopeKey || 'default', initScope);
    }
    var proxyInitializeSharing = Boolean(webpackRequire.federation.initOptions.shared);
    if (proxyInitializeSharing) {
        // @ts-ignore
        return webpackRequire.I(shareScopeKey, initScope);
    }
    // @ts-ignore
    return Promise.all(shareScopeKey.map((key) => {
        // @ts-ignore
        return webpackRequire.I(key, initScope);
    })).then(() => true);
}

const federation = {
    runtime: runtime__namespace,
    instance: undefined,
    initOptions: undefined,
    bundlerRuntime: {
        remotes,
        consumes,
        I: initializeSharing,
        S: {},
        installInitialConsumes,
        initContainerEntry,
    },
    attachShareScopeMap,
    bundlerRuntimeOptions: {},
};

module.exports = federation;
//# sourceMappingURL=index.cjs.cjs.map


},

});
// The module cache
var __webpack_module_cache__ = {};

// The require function
function __webpack_require__(moduleId) {

// Check if module is in cache
var cachedModule = __webpack_module_cache__[moduleId];
if (cachedModule !== undefined) {
return cachedModule.exports;
}
// Create a new module (and put it into the cache)
var module = (__webpack_module_cache__[moduleId] = {
id: moduleId,
loaded: false,
exports: {}
});
// Execute the module function
__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);

// Flag the module as loaded
module.loaded = true;
// Return the exports of the module
return module.exports;

}

// expose the modules object (__webpack_modules__)
__webpack_require__.m = __webpack_modules__;

// expose the module cache
__webpack_require__.c = __webpack_module_cache__;

// the startup function
__webpack_require__.x = () => {
// Load entry module and return exports
__webpack_require__(80551);
var __webpack_exports__ = __webpack_require__(31068);
return __webpack_exports__
};

// module_federation/runtime
(() => {

if(!__webpack_require__.federation){
    __webpack_require__.federation = {
        
chunkMatcher: function(chunkId) {
    return !/^(4(004|22|305|392|435|539)|2(355|379|533|681|808)|5(8(13|17|87)|(25|55|9)5|177|289|448|451|613|791|917)|6(9(69|75|83)|3(21|27|92)|62[39]|567|585|731|83|871)|1(41[19]|(|23|61)1|043|189|755|867)|8(5(13|23|57)|(26|29|63)7|063|153|424|780|939)|7(8(19|41|71)|(45|55|97)9|195|3|493|5|621|676|742|767|991)|3(274|443|621|833)|9(5(15|7|80)|8(31|67|80)|211|346|398|419|967|980))$/.test(chunkId);
},
rootOutputDir: "",

    };
}

})();
// webpack/runtime/compat_get_default_export
(() => {
// getDefaultExport function for compatibility with non-ESM modules
__webpack_require__.n = (module) => {
	var getter = module && module.__esModule ?
		() => (module['default']) :
		() => (module);
	__webpack_require__.d(getter, { a: getter });
	return getter;
};

})();
// webpack/runtime/create_fake_namespace_object
(() => {
var getProto = Object.getPrototypeOf ? (obj) => (Object.getPrototypeOf(obj)) : (obj) => (obj.__proto__);
var leafPrototypes;
// create a fake namespace object
// mode & 1: value is a module id, require it
// mode & 2: merge all properties of value into the ns
// mode & 4: return value when already ns object
// mode & 16: return value when it's Promise-like
// mode & 8|1: behave like require
__webpack_require__.t = function(value, mode) {
	if(mode & 1) value = this(value);
	if(mode & 8) return value;
	if(typeof value === 'object' && value) {
		if((mode & 4) && value.__esModule) return value;
		if((mode & 16) && typeof value.then === 'function') return value;
	}
	var ns = Object.create(null);
  __webpack_require__.r(ns);
	var def = {};
	leafPrototypes = leafPrototypes || [null, getProto({}), getProto([]), getProto(getProto)];
	for(var current = mode & 2 && value; (typeof current == 'object' || typeof current == 'function') && !~leafPrototypes.indexOf(current); current = getProto(current)) {
		Object.getOwnPropertyNames(current).forEach((key) => { def[key] = () => (value[key]) });
	}
	def['default'] = () => (value);
	__webpack_require__.d(ns, def);
	return ns;
};
})();
// webpack/runtime/define_property_getters
(() => {
__webpack_require__.d = (exports, definition) => {
	for(var key in definition) {
        if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
            Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
        }
    }
};
})();
// webpack/runtime/ensure_chunk
(() => {
__webpack_require__.f = {};
// This file contains only the entry chunk.
// The chunk loading function for additional chunks
__webpack_require__.e = (chunkId) => {
	return Promise.all(
		Object.keys(__webpack_require__.f).reduce((promises, key) => {
			__webpack_require__.f[key](chunkId, promises);
			return promises;
		}, [])
	);
};
})();
// webpack/runtime/esm_module_decorator
(() => {
__webpack_require__.hmd = (module) => {
  module = Object.create(module);
  if (!module.children) module.children = [];
  Object.defineProperty(module, 'exports', {
      enumerable: true,
      set: () => {
          throw new Error('ES Modules may not assign module.exports or exports.*, Use ESM export syntax, instead: ' + module.id);
      }
  });
  return module;
};
})();
// webpack/runtime/get javascript chunk filename
(() => {
// This function allow to reference chunks
__webpack_require__.u = (chunkId) => {
  // return url for filenames not based on template
  
  // return url for filenames based on template
  return "" + (chunkId === "1407" ? "notebook_core" : chunkId) + "." + {"1014": "dc179f061d5c85fe","1053": "10846e227bbc57b8","1106": "8f84914e735f885c","1162": "d166bf64607add69","1305": "1789af21c3b4f8f6","1320": "341192a76cdc0fec","1321": "a23e1d57f8456bbf","1324": "727b3a299c8feff0","1336": "8cae2f625b582bc9","1353": "4317630c1cd2fbe8","1407": "311368382124e6d5","1459": "12944df766e14efe","1479": "f427d62bd1c0646c","1536": "127e996a9b143f39","1608": "e95405f104a3c590","1627": "969051ec46d43c59","1682": "0740fba5e398ccef","1712": "f07147e518a7f122","1713": "55e57dd489c0fb4f","1736": "d79c99503d71f3ce","1749": "7622123bb8d8da37","175": "a86ba612d958e4ed","1773": "5f52a764eec1fdb2","1774": "26b8befef9d7f85c","1780": "cee809333884625c","1815": "b68b1b57670401c6","1858": "44461589ca9f7839","1921": "56f8b291b0f511ea","2060": "7ae0af0b05115d74","2070": "ba5d96909c50334b","2113": "3120c8e48e1a30d0","2143": "36b2eb09f04ad3d1","2172": "01f702c2ef5e2fb3","2185": "4396f46e7bc2f41a","2213": "2065ee2bf28face8","2253": "46ad9bd90a86364c","2320": "7b0b62dea3e94751","2436": "276a4ab6f06e346e","256": "74cb8e47c8d3e9de","2595": "6309b42174bec70e","2613": "974f8b2f5a0f3149","2654": "b921b285293855fe","2706": "2f8aa0575ec9f10f","2715": "4e307a35d9a85749","273": "0665a7a9d14fc600","2753": "6b6753e96ba96a29","2762": "b56c1a846212c569","2776": "c1315370176f5f1c","2778": "28ec1eb48eec6e80","2785": "6327b775da441b3c","2878": "e34a70d0b829fac8","290": "a36e3a50a30c7d07","3003": "f3fbf7fe2571540b","3007": "b32e0abe9d9634bb","308": "c90f9f2b02855234","3200": "9362558a2d1b4a7f","3267": "9bfb569538aa61c9","3276": "8093e85e3b18fc87","3293": "49dd8697c6408826","3294": "2eb43cb372c826dc","3399": "7f07079df21531a7","3429": "cfce8ce7321f20dd","3481": "5ac9c9382397970b","3594": "caedce0c975a7ad2","3604": "6f6d72d3c2c9d1d1","3620": "cbd745c192dfe9a2","3732": "3472aba231e2b979","3749": "19a5140eea0a3f77","3805": "6352926e0644c3e2","3810": "df1eae441405fc71","3826": "086005393ca28448","3854": "6028234fe207f6c5","3896": "b1f620e0b1e22561","390": "11b02c71781d988e","3935": "222c0ea155f8ab7a","3984": "38412bb401c40909","4008": "e570e9771be09788","4011": "b6a3de74e121c25c","4113": "14ffb94d6b18594e","4117": "85d030346bd6036f","4121": "389e37b526d8cc8e","4143": "8a7e59a0081e8afc","4166": "7738576d7ef62be4","421": "1a4cf828e4ee7222","4248": "7134ea9d1bde4e05","4249": "049ca8bf510ba543","4275": "51dc5243ad970ac8","4282": "b11727bcfc76dcdf","4283": "b0846c8dae09ac29","4286": "5b19ea1906c41947","4292": "0a4f69ee5e86c173","4313": "436a341950158bd0","4346": "f508c71301ad2430","4422": "4d78b6798c6e4d44","4464": "f27196b3fbe41837","4494": "613cc4cde18a2030","4518": "51060b038fd5efc5","4570": "157f3f6145b0d5ba","4594": "7641ca7e76d061f4","4610": "b99bdc1f59c65eca","4676": "92f291b33e32f290","4702": "7f16e6d83b3711fc","4769": "198a02aeee1353fc","4793": "d22768d8322e5c34","490": "0bfd312894e5aa3f","4959": "5ab3e164e8e34d23","4976": "a3968bb5b23efc65","5061": "812c713da48e7bfd","5062": "df4873e7086d7e42","5063": "f87cdfceef550702","5072": "a388fecdad54d51f","5119": "b451f68c3990414b","5134": "ae7a70e03806e2e5","5147": "58a74513ae6a8ccd","5192": "15ba25fed7feb482","5244": "78b76443f692be23","5253": "421750e62cfe79df","533": "119bb80677a918b6","5353": "600f659078a4a3f5","5395": "d2c2e1ea5807ed0a","5425": "2ae7b4ac4b917abd","5462": "1a2d9498e96b131b","5538": "562f229bcddc9872","5574": "6d0528ac22b1dae0","5593": "79f47b2db8c33110","5599": "220488cf3f6274b6","5663": "64e72685faf6a18a","5717": "2357c82ac6c8b072","5733": "3bc2a11c04f2c7a3","5805": "9b4f3237e8fa4bc2","5858": "253319a4af95ed63","5876": "d9414d28a28f9e6e","5886": "699a97a6826a0af0","5896": "f5bf4662225c54d7","590": "aa50e11b399cf6bc","5927": "6050ae4f1b45cfad","5932": "a92edf61edb7e86d","6000": "869868e9c798bb13","6068": "25a45359340488d7","6102": "b234c9d055e8dc08","6219": "f55bfefc2e13692b","6240": "98fd72d2aaafe1e9","6290": "05d5ff1501c69cd3","637": "8dea838f6e5c9274","6391": "b6337d9e4d1c601c","6397": "3c40ec8c43e297d7","6418": "9d050e84de7a64c2","6428": "1ed13dd28aa1f48b","6432": "291eed7e59d3c195","6471": "f46487803496e551","6491": "724a5ce4df2ff05b","6494": "8cb340d6e005a200","6504": "6aaa6ef55ab4ae6e","6576": "77e70e2ef208ab0d","6639": "b265684c5a5f4c4c","6656": "11a3e92bfec88ecc","6757": "5e564e77d666ac6a","6775": "eb9d88f73adbbd35","6863": "be8cbace3bd7ebd8","6899": "e5be509574c04b4d","7006": "8f0abe2ebca9d4bd","7017": "b3e2929b4c89311a","7034": "8fba0be96ff399ae","7086": "a984e551cbdf716a","7103": "353ebe6a2b1ac15c","7154": "c6534340031838cb","7161": "a3210f3ad58a11f8","7177": "9c4ebbb18ebee09b","723": "514f1b43874c85d1","7295": "840e8e597a4c9874","7300": "f048700a00a27c50","7312": "fcb1578dac74d6c8","7442": "03b04aea60f9423d","7443": "3502cc1fa5c8e8c5","7451": "99b7abe8fa686d7e","754": "8b724c4352b742a7","7540": "d3238b3fe37b0997","7543": "6cb131885b6b6cdc","7604": "41e5e32cc11cd1a5","7617": "7530e68c780409d2","7622": "0d152e32fa0958bc","7625": "162569de505684ff","7693": "807bc5d00a514e7f","7703": "3a0261f25e996e63","7743": "03f093a94d47780d","7752": "06d2d1e20e0d694e","7763": "f33a055bf9352695","7766": "5955edfa46207616","7820": "7252660a0b6e6612","7909": "5d73deca7ad7e805","7936": "ceb21534ff37a409","8037": "97608826b90a257c","8041": "eb6915e851562b6d","8109": "79ea5fc5e703003e","8150": "718ecc2b6d9fa0d3","8173": "4166599369134fe6","8174": "cd4c6b09dc49f2f0","8179": "d467986e90b29761","8198": "dcebb3b0e743ba6a","8458": "c70d91b92825468e","8469": "3611ea9e57a9192a","8470": "7566e68b5d10e4d2","8495": "727f5d47718d78ba","8558": "65ae94e77cd37ed1","8597": "288eeb6eddcdf897","8652": "fe32bf2c3f41396a","8706": "a5381d49bee32290","8748": "c25d26ac4bc84d12","876": "3b51e4a4b2efb5ae","8776": "629feb43343811cb","8794": "d8e0710395d18a80","8829": "1d3758eb8059fa72","8898": "6dc0cf3a68e2973d","8903": "7743bced77919689","8924": "2d73cb99f5b5c428","8951": "75bd1ce0e3d766a3","8962": "39eac2b1dc02fc66","8985": "59338c0a08816c82","9056": "1b4bb65a7e6c0aff","9099": "0d1c551334705516","9107": "a8d84aa017615ae6","9128": "9a0df289365ad514","9213": "8102d589f351db07","9280": "6c00e64e0c044e29","9301": "d06f4d6e4f9dcdfa","937": "bd18cc2c0d1b1718","9393": "b98e99cc11d52c30","9415": "328c9aa76c02bf03","9432": "da1b850492c0b827","945": "1a97901077d3ca41","9456": "ad89d89c576cacdc","9513": "a24640cff346c9c7","953": "45faa4b2510e1cf6","9596": "1fb66dd999220e9a","9618": "ab938e6bb5c7dfc0","963": "3b8e68300d1a9b88","9651": "1fceb1621e341bdb","9690": "96c4bbfc53fc9d7c","9784": "e0ac11175c197ffe","9832": "e3640dfd64066f1f","9924": "afd09f7a711a797c",}[chunkId] + ".js?v=" + {"1014": "dc179f061d5c85fe","1053": "10846e227bbc57b8","1106": "8f84914e735f885c","1162": "d166bf64607add69","1305": "1789af21c3b4f8f6","1320": "341192a76cdc0fec","1321": "a23e1d57f8456bbf","1324": "727b3a299c8feff0","1336": "8cae2f625b582bc9","1353": "4317630c1cd2fbe8","1407": "311368382124e6d5","1459": "12944df766e14efe","1479": "f427d62bd1c0646c","1536": "127e996a9b143f39","1608": "e95405f104a3c590","1627": "969051ec46d43c59","1682": "0740fba5e398ccef","1712": "f07147e518a7f122","1713": "55e57dd489c0fb4f","1736": "d79c99503d71f3ce","1749": "7622123bb8d8da37","175": "a86ba612d958e4ed","1773": "5f52a764eec1fdb2","1774": "26b8befef9d7f85c","1780": "cee809333884625c","1815": "b68b1b57670401c6","1858": "44461589ca9f7839","1921": "56f8b291b0f511ea","2060": "7ae0af0b05115d74","2070": "ba5d96909c50334b","2113": "3120c8e48e1a30d0","2143": "36b2eb09f04ad3d1","2172": "01f702c2ef5e2fb3","2185": "4396f46e7bc2f41a","2213": "2065ee2bf28face8","2253": "46ad9bd90a86364c","2320": "7b0b62dea3e94751","2436": "276a4ab6f06e346e","256": "74cb8e47c8d3e9de","2595": "6309b42174bec70e","2613": "974f8b2f5a0f3149","2654": "b921b285293855fe","2706": "2f8aa0575ec9f10f","2715": "4e307a35d9a85749","273": "0665a7a9d14fc600","2753": "6b6753e96ba96a29","2762": "b56c1a846212c569","2776": "c1315370176f5f1c","2778": "28ec1eb48eec6e80","2785": "6327b775da441b3c","2878": "e34a70d0b829fac8","290": "a36e3a50a30c7d07","3003": "f3fbf7fe2571540b","3007": "b32e0abe9d9634bb","308": "c90f9f2b02855234","3200": "9362558a2d1b4a7f","3267": "9bfb569538aa61c9","3276": "8093e85e3b18fc87","3293": "49dd8697c6408826","3294": "2eb43cb372c826dc","3399": "7f07079df21531a7","3429": "cfce8ce7321f20dd","3481": "5ac9c9382397970b","3594": "caedce0c975a7ad2","3604": "6f6d72d3c2c9d1d1","3620": "cbd745c192dfe9a2","3732": "3472aba231e2b979","3749": "19a5140eea0a3f77","3805": "6352926e0644c3e2","3810": "df1eae441405fc71","3826": "086005393ca28448","3854": "6028234fe207f6c5","3896": "b1f620e0b1e22561","390": "11b02c71781d988e","3935": "222c0ea155f8ab7a","3984": "38412bb401c40909","4008": "e570e9771be09788","4011": "b6a3de74e121c25c","4113": "14ffb94d6b18594e","4117": "85d030346bd6036f","4121": "389e37b526d8cc8e","4143": "8a7e59a0081e8afc","4166": "7738576d7ef62be4","421": "1a4cf828e4ee7222","4248": "7134ea9d1bde4e05","4249": "049ca8bf510ba543","4275": "51dc5243ad970ac8","4282": "b11727bcfc76dcdf","4283": "b0846c8dae09ac29","4286": "5b19ea1906c41947","4292": "0a4f69ee5e86c173","4313": "436a341950158bd0","4346": "f508c71301ad2430","4422": "4d78b6798c6e4d44","4464": "f27196b3fbe41837","4494": "613cc4cde18a2030","4518": "51060b038fd5efc5","4570": "157f3f6145b0d5ba","4594": "7641ca7e76d061f4","4610": "b99bdc1f59c65eca","4676": "92f291b33e32f290","4702": "7f16e6d83b3711fc","4769": "198a02aeee1353fc","4793": "d22768d8322e5c34","490": "0bfd312894e5aa3f","4959": "5ab3e164e8e34d23","4976": "a3968bb5b23efc65","5061": "812c713da48e7bfd","5062": "df4873e7086d7e42","5063": "f87cdfceef550702","5072": "a388fecdad54d51f","5119": "b451f68c3990414b","5134": "ae7a70e03806e2e5","5147": "58a74513ae6a8ccd","5192": "15ba25fed7feb482","5244": "78b76443f692be23","5253": "421750e62cfe79df","533": "119bb80677a918b6","5353": "600f659078a4a3f5","5395": "d2c2e1ea5807ed0a","5425": "2ae7b4ac4b917abd","5462": "1a2d9498e96b131b","5538": "562f229bcddc9872","5574": "6d0528ac22b1dae0","5593": "79f47b2db8c33110","5599": "220488cf3f6274b6","5663": "64e72685faf6a18a","5717": "2357c82ac6c8b072","5733": "3bc2a11c04f2c7a3","5805": "9b4f3237e8fa4bc2","5858": "253319a4af95ed63","5876": "d9414d28a28f9e6e","5886": "699a97a6826a0af0","5896": "f5bf4662225c54d7","590": "aa50e11b399cf6bc","5927": "6050ae4f1b45cfad","5932": "a92edf61edb7e86d","6000": "869868e9c798bb13","6068": "25a45359340488d7","6102": "b234c9d055e8dc08","6219": "f55bfefc2e13692b","6240": "98fd72d2aaafe1e9","6290": "05d5ff1501c69cd3","637": "8dea838f6e5c9274","6391": "b6337d9e4d1c601c","6397": "3c40ec8c43e297d7","6418": "9d050e84de7a64c2","6428": "1ed13dd28aa1f48b","6432": "291eed7e59d3c195","6471": "f46487803496e551","6491": "724a5ce4df2ff05b","6494": "8cb340d6e005a200","6504": "6aaa6ef55ab4ae6e","6576": "77e70e2ef208ab0d","6639": "b265684c5a5f4c4c","6656": "11a3e92bfec88ecc","6757": "5e564e77d666ac6a","6775": "eb9d88f73adbbd35","6863": "be8cbace3bd7ebd8","6899": "e5be509574c04b4d","7006": "8f0abe2ebca9d4bd","7017": "b3e2929b4c89311a","7034": "8fba0be96ff399ae","7086": "a984e551cbdf716a","7103": "353ebe6a2b1ac15c","7154": "c6534340031838cb","7161": "a3210f3ad58a11f8","7177": "9c4ebbb18ebee09b","723": "514f1b43874c85d1","7295": "840e8e597a4c9874","7300": "f048700a00a27c50","7312": "fcb1578dac74d6c8","7442": "03b04aea60f9423d","7443": "3502cc1fa5c8e8c5","7451": "99b7abe8fa686d7e","754": "8b724c4352b742a7","7540": "d3238b3fe37b0997","7543": "6cb131885b6b6cdc","7604": "41e5e32cc11cd1a5","7617": "7530e68c780409d2","7622": "0d152e32fa0958bc","7625": "162569de505684ff","7693": "807bc5d00a514e7f","7703": "3a0261f25e996e63","7743": "03f093a94d47780d","7752": "06d2d1e20e0d694e","7763": "f33a055bf9352695","7766": "5955edfa46207616","7820": "7252660a0b6e6612","7909": "5d73deca7ad7e805","7936": "ceb21534ff37a409","8037": "97608826b90a257c","8041": "eb6915e851562b6d","8109": "79ea5fc5e703003e","8150": "718ecc2b6d9fa0d3","8173": "4166599369134fe6","8174": "cd4c6b09dc49f2f0","8179": "d467986e90b29761","8198": "dcebb3b0e743ba6a","8458": "c70d91b92825468e","8469": "3611ea9e57a9192a","8470": "7566e68b5d10e4d2","8495": "727f5d47718d78ba","8558": "65ae94e77cd37ed1","8597": "288eeb6eddcdf897","8652": "fe32bf2c3f41396a","8706": "a5381d49bee32290","8748": "c25d26ac4bc84d12","876": "3b51e4a4b2efb5ae","8776": "629feb43343811cb","8794": "d8e0710395d18a80","8829": "1d3758eb8059fa72","8898": "6dc0cf3a68e2973d","8903": "7743bced77919689","8924": "2d73cb99f5b5c428","8951": "75bd1ce0e3d766a3","8962": "39eac2b1dc02fc66","8985": "59338c0a08816c82","9056": "1b4bb65a7e6c0aff","9099": "0d1c551334705516","9107": "a8d84aa017615ae6","9128": "9a0df289365ad514","9213": "8102d589f351db07","9280": "6c00e64e0c044e29","9301": "d06f4d6e4f9dcdfa","937": "bd18cc2c0d1b1718","9393": "b98e99cc11d52c30","9415": "328c9aa76c02bf03","9432": "da1b850492c0b827","945": "1a97901077d3ca41","9456": "ad89d89c576cacdc","9513": "a24640cff346c9c7","953": "45faa4b2510e1cf6","9596": "1fb66dd999220e9a","9618": "ab938e6bb5c7dfc0","963": "3b8e68300d1a9b88","9651": "1fceb1621e341bdb","9690": "96c4bbfc53fc9d7c","9784": "e0ac11175c197ffe","9832": "e3640dfd64066f1f","9924": "afd09f7a711a797c",}[chunkId] + ""
}
})();
// webpack/runtime/global
(() => {
__webpack_require__.g = (() => {
	if (typeof globalThis === 'object') return globalThis;
	try {
		return this || new Function('return this')();
	} catch (e) {
		if (typeof window === 'object') return window;
	}
})();
})();
// webpack/runtime/has_own_property
(() => {
__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
})();
// webpack/runtime/load_script
(() => {
var inProgress = {};

var uniqueName = "_JUPYTERLAB.CORE_OUTPUT:";
// loadScript function to load a script via script tag
__webpack_require__.l = function (url, done, key, chunkId) {
	if (inProgress[url]) {
		inProgress[url].push(done);
		return;
	}
	var script, needAttach;
	if (key !== undefined) {
		var scripts = document.getElementsByTagName("script");
		for (var i = 0; i < scripts.length; i++) {
			var s = scripts[i];
			if (s.getAttribute("src") == url || s.getAttribute("data-rspack") == uniqueName + key) {
				script = s;
				break;
			}
		}
	}
	if (!script) {
		needAttach = true;
		script = document.createElement('script');


script.timeout = 120;
if (__webpack_require__.nc) {
  script.setAttribute("nonce", __webpack_require__.nc);
}

script.setAttribute("data-rspack", uniqueName + key);



script.src = url;


	}
	inProgress[url] = [done];
	var onScriptComplete = function (prev, event) {
		script.onerror = script.onload = null;
		clearTimeout(timeout);
		var doneFns = inProgress[url];
		delete inProgress[url];
		script.parentNode && script.parentNode.removeChild(script);
		doneFns &&
			doneFns.forEach(function (fn) {
				return fn(event);
			});
		if (prev) return prev(event);
	};
	var timeout = setTimeout(
		onScriptComplete.bind(null, undefined, {
			type: 'timeout',
			target: script
		}),
		120000
	);
	script.onerror = onScriptComplete.bind(null, script.onerror);
	script.onload = onScriptComplete.bind(null, script.onload);
	needAttach && document.head.appendChild(script);
};

})();
// webpack/runtime/make_namespace_object
(() => {
// define __esModule on exports
__webpack_require__.r = (exports) => {
	if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
		Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
	}
	Object.defineProperty(exports, '__esModule', { value: true });
};
})();
// webpack/runtime/node_module_decorator
(() => {
__webpack_require__.nmd = (module) => {
  module.paths = [];
  if (!module.children) module.children = [];
  return module;
};
})();
// webpack/runtime/nonce
(() => {
__webpack_require__.nc = undefined;
})();
// webpack/runtime/public_path
(() => {
__webpack_require__.p = "{{page_config.fullStaticUrl}}/";
})();
// webpack/runtime/sharing
(() => {

__webpack_require__.S = {};
__webpack_require__.initializeSharingData = { scopeToSharingDataMapping: { "default": [{ name: "@codemirror/commands", version: "6.8.1", factory: () => (Promise.all([__webpack_require__.e("8198"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("7819")]).then(() => (() => (__webpack_require__(16229))))), eager: 0, requiredVersion: "^6.8.1" }, { name: "@codemirror/lang-markdown", version: "6.3.2", factory: () => (Promise.all([__webpack_require__.e("6428"), __webpack_require__.e("8794"), __webpack_require__.e("9924"), __webpack_require__.e("2785"), __webpack_require__.e("8898"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("7819"), __webpack_require__.e("8780")]).then(() => (() => (__webpack_require__(21545))))), eager: 0, requiredVersion: "^6.3.2" }, { name: "@codemirror/language", version: "6.11.0", factory: () => (Promise.all([__webpack_require__.e("8150"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("8780")]).then(() => (() => (__webpack_require__(34885))))), eager: 0, requiredVersion: "^6.11.0" }, { name: "@codemirror/search", version: "6.5.10", factory: () => (Promise.all([__webpack_require__.e("3732"), __webpack_require__.e("11"), __webpack_require__.e("2808")]).then(() => (() => (__webpack_require__(28271))))), eager: 0, requiredVersion: "^6.5.10" }, { name: "@codemirror/state", version: "6.5.2", factory: () => (__webpack_require__.e("1608").then(() => (() => (__webpack_require__(47995))))), eager: 0, singleton: 1, requiredVersion: "~6.5.2" }, { name: "@codemirror/view", version: "6.38.1", factory: () => (Promise.all([__webpack_require__.e("175"), __webpack_require__.e("2808")]).then(() => (() => (__webpack_require__(57490))))), eager: 0, singleton: 1, requiredVersion: "~6.38.1" }, { name: "@jupyter-notebook/application-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("6321"), __webpack_require__.e("3833"), __webpack_require__.e("5555"), __webpack_require__.e("5927")]).then(() => (() => (__webpack_require__(20442))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/application", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("7909")]).then(() => (() => (__webpack_require__(58260))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/console-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("6321"), __webpack_require__.e("3833"), __webpack_require__.e("1774")]).then(() => (() => (__webpack_require__(77965))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/docmanager-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("1755"), __webpack_require__.e("3833"), __webpack_require__.e("490")]).then(() => (() => (__webpack_require__(52913))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/documentsearch-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("8267"), __webpack_require__.e("3833"), __webpack_require__.e("1682")]).then(() => (() => (__webpack_require__(33081))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/help-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6731"), __webpack_require__.e("4435"), __webpack_require__.e("5555"), __webpack_require__.e("2320")]).then(() => (() => (__webpack_require__(46051))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/notebook-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("4305"), __webpack_require__.e("1611"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("7991"), __webpack_require__.e("3833"), __webpack_require__.e("6432")]).then(() => (() => (__webpack_require__(40467))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/terminal-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("3833"), __webpack_require__.e("9515"), __webpack_require__.e("273")]).then(() => (() => (__webpack_require__(77048))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/tree-extension", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("4305"), __webpack_require__.e("2379"), __webpack_require__.e("3621"), __webpack_require__.e("8297"), __webpack_require__.e("5448"), __webpack_require__.e("4594")]).then(() => (() => (__webpack_require__(51017))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/tree", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("9280")]).then(() => (() => (__webpack_require__(47907))))), eager: 0, singleton: 1, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter-notebook/ui-components", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("6975"), __webpack_require__.e("2070")]).then(() => (() => (__webpack_require__(17621))))), eager: 0, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyter/react-components", version: "0.16.7", factory: () => (Promise.all([__webpack_require__.e("4282"), __webpack_require__.e("6731"), __webpack_require__.e("9419")]).then(() => (() => (__webpack_require__(25569))))), eager: 0, singleton: 1, requiredVersion: "~0.16.7" }, { name: "@jupyter/web-components", version: "0.16.7", factory: () => (__webpack_require__.e("7820").then(() => (() => (__webpack_require__(8631))))), eager: 0, singleton: 1, requiredVersion: "~0.16.7" }, { name: "@jupyter/ydoc", version: "3.1.0", factory: () => (Promise.all([__webpack_require__.e("2878"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("9346")]).then(() => (() => (__webpack_require__(40493))))), eager: 0, singleton: 1, requiredVersion: "~3.1.0" }, { name: "@jupyterlab/application-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("3443"), __webpack_require__.e("6392")]).then(() => (() => (__webpack_require__(19508))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/application", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("4392")]).then(() => (() => (__webpack_require__(86152))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/apputils-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("4004"), __webpack_require__.e("4435"), __webpack_require__.e("5887"), __webpack_require__.e("1189"), __webpack_require__.e("3443"), __webpack_require__.e("7559"), __webpack_require__.e("9211"), __webpack_require__.e("4275")]).then(() => (() => (__webpack_require__(83061))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/apputils", version: "4.7.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("3429"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("73"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1189"), __webpack_require__.e("9980"), __webpack_require__.e("7767"), __webpack_require__.e("3896")]).then(() => (() => (__webpack_require__(5706))))), eager: 0, singleton: 1, requiredVersion: "~4.7.0-alpha.0" }, { name: "@jupyterlab/attachments", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6629"), __webpack_require__.e("7871"), __webpack_require__.e("9980")]).then(() => (() => (__webpack_require__(25312))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/audio-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("6969"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(89346))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/cell-toolbar-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("4305"), __webpack_require__.e("1043")]).then(() => (() => (__webpack_require__(87722))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/cell-toolbar", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("9980")]).then(() => (() => (__webpack_require__(2810))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/cells", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("1611"), __webpack_require__.e("9867"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("11"), __webpack_require__.e("2681"), __webpack_require__.e("7767"), __webpack_require__.e("7676"), __webpack_require__.e("8523"), __webpack_require__.e("595")]).then(() => (() => (__webpack_require__(20072))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/celltags-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7991")]).then(() => (() => (__webpack_require__(61671))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/codeeditor", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("73"), __webpack_require__.e("9980"), __webpack_require__.e("7676")]).then(() => (() => (__webpack_require__(50459))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/codemirror-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("7979"), __webpack_require__.e("7991"), __webpack_require__.e("7819"), __webpack_require__.e("8424"), __webpack_require__.e("5451"), __webpack_require__.e("7493")]).then(() => (() => (__webpack_require__(17770))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/codemirror", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9924"), __webpack_require__.e("8985"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("9867"), __webpack_require__.e("8267"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("7819"), __webpack_require__.e("8424"), __webpack_require__.e("8780"), __webpack_require__.e("7493"), __webpack_require__.e("9346")]).then(() => (() => (__webpack_require__(52075))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/completer-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("9867"), __webpack_require__.e("3443"), __webpack_require__.e("422")]).then(() => (() => (__webpack_require__(37921))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/completer", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("9867"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("7979"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("7819")]).then(() => (() => (__webpack_require__(81379))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/console-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("9867"), __webpack_require__.e("4435"), __webpack_require__.e("1231"), __webpack_require__.e("2379"), __webpack_require__.e("6321"), __webpack_require__.e("422"), __webpack_require__.e("6623")]).then(() => (() => (__webpack_require__(91920))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/console", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("9980"), __webpack_require__.e("5177"), __webpack_require__.e("5917"), __webpack_require__.e("7676")]).then(() => (() => (__webpack_require__(65606))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/coreutils", version: "6.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5353"), __webpack_require__.e("2533"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(43228))))), eager: 0, singleton: 1, requiredVersion: "~6.6.0-alpha.0" }, { name: "@jupyterlab/csvviewer-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("6969"), __webpack_require__.e("4435"), __webpack_require__.e("8267")]).then(() => (() => (__webpack_require__(17242))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/csvviewer", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("6969"), __webpack_require__.e("5613")]).then(() => (() => (__webpack_require__(13842))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/debugger-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("6969"), __webpack_require__.e("9867"), __webpack_require__.e("7991"), __webpack_require__.e("6321"), __webpack_require__.e("422"), __webpack_require__.e("5917"), __webpack_require__.e("6567"), __webpack_require__.e("9831")]).then(() => (() => (__webpack_require__(39112))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/debugger", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("1611"), __webpack_require__.e("9867"), __webpack_require__.e("9980"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("5917"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(61681))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/docmanager-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("1755")]).then(() => (() => (__webpack_require__(59341))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/docmanager", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("8637"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(53158))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/docregistry", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("9867"), __webpack_require__.e("8637")]).then(() => (() => (__webpack_require__(77803))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/documentsearch-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("8267")]).then(() => (() => (__webpack_require__(6053))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/documentsearch", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(9039))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/extensionmanager-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("9967")]).then(() => (() => (__webpack_require__(56016))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/extensionmanager", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("1773"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("1611"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(77095))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/filebrowser-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("3443"), __webpack_require__.e("2379")]).then(() => (() => (__webpack_require__(63546))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/filebrowser", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1755"), __webpack_require__.e("7767"), __webpack_require__.e("5177")]).then(() => (() => (__webpack_require__(9949))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/fileeditor-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("4435"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("2379"), __webpack_require__.e("6321"), __webpack_require__.e("6585"), __webpack_require__.e("422"), __webpack_require__.e("6623"), __webpack_require__.e("8424"), __webpack_require__.e("6567"), __webpack_require__.e("7493")]).then(() => (() => (__webpack_require__(75658))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/fileeditor", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("6585")]).then(() => (() => (__webpack_require__(99241))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/help-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4435")]).then(() => (() => (__webpack_require__(83775))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/htmlviewer-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("1867")]).then(() => (() => (__webpack_require__(66787))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/htmlviewer", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(78062))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/hub-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("5289"), __webpack_require__.e("7195")]).then(() => (() => (__webpack_require__(56715))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/imageviewer-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("957")]).then(() => (() => (__webpack_require__(92483))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/imageviewer", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("5289"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(76882))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/javascript-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7871")]).then(() => (() => (__webpack_require__(24207))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/json-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("7559"), __webpack_require__.e("6656")]).then(() => (() => (__webpack_require__(26762))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/launcher", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(52507))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/logconsole-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("1419")]).then(() => (() => (__webpack_require__(45939))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/logconsole", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("7871"), __webpack_require__.e("8523")]).then(() => (() => (__webpack_require__(1786))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/lsp-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("1611"), __webpack_require__.e("6585"), __webpack_require__.e("3621")]).then(() => (() => (__webpack_require__(30805))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/lsp", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("4113"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("6969"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(440))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/mainmenu-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4004"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("2379")]).then(() => (() => (__webpack_require__(30289))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/mainmenu", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(71468))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/markdownviewer-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2681"), __webpack_require__.e("7459")]).then(() => (() => (__webpack_require__(46543))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/markdownviewer", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("6969"), __webpack_require__.e("2681")]).then(() => (() => (__webpack_require__(94474))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/markedparser-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("7979"), __webpack_require__.e("5813")]).then(() => (() => (__webpack_require__(41979))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/mathjax-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7871")]).then(() => (() => (__webpack_require__(44453))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/mermaid-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("5813")]).then(() => (() => (__webpack_require__(29071))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/mermaid", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("5289")]).then(() => (() => (__webpack_require__(43693))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/metadataform-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("4305"), __webpack_require__.e("7991"), __webpack_require__.e("5791")]).then(() => (() => (__webpack_require__(20787))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/metadataform", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("7991"), __webpack_require__.e("5451")]).then(() => (() => (__webpack_require__(13531))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/nbformat", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533")]).then(() => (() => (__webpack_require__(40399))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/notebook-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("4435"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("9980"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("7991"), __webpack_require__.e("2379"), __webpack_require__.e("6585"), __webpack_require__.e("422"), __webpack_require__.e("6623"), __webpack_require__.e("5917"), __webpack_require__.e("6392"), __webpack_require__.e("5791"), __webpack_require__.e("1419"), __webpack_require__.e("1043"), __webpack_require__.e("683")]).then(() => (() => (__webpack_require__(49339))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/notebook", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("9980"), __webpack_require__.e("8267"), __webpack_require__.e("1231"), __webpack_require__.e("2681"), __webpack_require__.e("6585"), __webpack_require__.e("7767"), __webpack_require__.e("5177"), __webpack_require__.e("5917"), __webpack_require__.e("7676"), __webpack_require__.e("75")]).then(() => (() => (__webpack_require__(16891))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/observables", version: "5.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("8637")]).then(() => (() => (__webpack_require__(80097))))), eager: 0, singleton: 1, requiredVersion: "~5.6.0-alpha.0" }, { name: "@jupyterlab/outputarea", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("7871"), __webpack_require__.e("4004"), __webpack_require__.e("9980"), __webpack_require__.e("1231"), __webpack_require__.e("75")]).then(() => (() => (__webpack_require__(22225))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/pdf-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(38222))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/pluginmanager-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("1411")]).then(() => (() => (__webpack_require__(83778))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/pluginmanager", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(90604))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/property-inspector", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(84695))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/rendermime-interfaces", version: "3.14.0-alpha.0", factory: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(96963))))), eager: 0, singleton: 1, requiredVersion: "~3.14.0-alpha.0" }, { name: "@jupyterlab/rendermime", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("9980"), __webpack_require__.e("75"), __webpack_require__.e("2253")]).then(() => (() => (__webpack_require__(23788))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/running-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("4004"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("3621")]).then(() => (() => (__webpack_require__(42270))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/running", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(23203))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@jupyterlab/services-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(47236))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/services", version: "7.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("1189")]).then(() => (() => (__webpack_require__(76492))))), eager: 0, singleton: 1, requiredVersion: "~7.6.0-alpha.0" }, { name: "@jupyterlab/settingeditor-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("9867"), __webpack_require__.e("1189"), __webpack_require__.e("11"), __webpack_require__.e("8424"), __webpack_require__.e("1411")]).then(() => (() => (__webpack_require__(74316))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/settingeditor", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("1611"), __webpack_require__.e("9867"), __webpack_require__.e("1189"), __webpack_require__.e("5451")]).then(() => (() => (__webpack_require__(97816))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/settingregistry", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("1459"), __webpack_require__.e("5876"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("2355"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(51056))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/shortcuts-extension", version: "5.4.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("3443"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(15829))))), eager: 0, requiredVersion: "~5.4.0-alpha.0" }, { name: "@jupyterlab/statedb", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(13431))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/statusbar", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(57217))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/terminal-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4004"), __webpack_require__.e("4435"), __webpack_require__.e("8267"), __webpack_require__.e("3621"), __webpack_require__.e("6623"), __webpack_require__.e("9515"), __webpack_require__.e("7621")]).then(() => (() => (__webpack_require__(13293))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/terminal", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("7621")]).then(() => (() => (__webpack_require__(83651))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/theme-dark-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(4304))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/theme-dark-high-contrast-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(12272))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/theme-light-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(18688))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/toc-extension", version: "6.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2681")]).then(() => (() => (__webpack_require__(60030))))), eager: 0, requiredVersion: "~6.6.0-alpha.0" }, { name: "@jupyterlab/toc", version: "6.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(68873))))), eager: 0, requiredVersion: "^6.6.0-alpha.0" }, { name: "@jupyterlab/tooltip-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("7742"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("7991"), __webpack_require__.e("6321"), __webpack_require__.e("6567"), __webpack_require__.e("8153")]).then(() => (() => (__webpack_require__(71351))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/tooltip", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("7871")]).then(() => (() => (__webpack_require__(34659))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/translation-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4435")]).then(() => (() => (__webpack_require__(29271))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/translation", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("5289"), __webpack_require__.e("4004"), __webpack_require__.e("1189")]).then(() => (() => (__webpack_require__(68154))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/ui-components-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6975")]).then(() => (() => (__webpack_require__(86241))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/ui-components", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("723"), __webpack_require__.e("9784"), __webpack_require__.e("8706"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("3443"), __webpack_require__.e("7767"), __webpack_require__.e("3274"), __webpack_require__.e("7559"), __webpack_require__.e("9419"), __webpack_require__.e("5817")]).then(() => (() => (__webpack_require__(80640))))), eager: 0, singleton: 1, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/vega5-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7742")]).then(() => (() => (__webpack_require__(84484))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/video-extension", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("6969"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(26455))))), eager: 0, requiredVersion: "~4.6.0-alpha.0" }, { name: "@jupyterlab/workspaces", version: "4.6.0-alpha.0", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("1611")]).then(() => (() => (__webpack_require__(5218))))), eager: 0, requiredVersion: "^4.6.0-alpha.0" }, { name: "@lezer/common", version: "1.2.1", factory: () => (__webpack_require__.e("6757").then(() => (() => (__webpack_require__(77956))))), eager: 0, singleton: 1, requiredVersion: "~1.2.1" }, { name: "@lezer/highlight", version: "1.2.0", factory: () => (Promise.all([__webpack_require__.e("5244"), __webpack_require__.e("6983")]).then(() => (() => (__webpack_require__(6311))))), eager: 0, singleton: 1, requiredVersion: "~1.2.0" }, { name: "@lumino/algorithm", version: "2.0.4", factory: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(52144))))), eager: 0, singleton: 1, requiredVersion: "~2.0.4" }, { name: "@lumino/application", version: "2.4.5", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(62534))))), eager: 0, singleton: 1, requiredVersion: "~2.4.5" }, { name: "@lumino/commands", version: "2.3.3", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(1337))))), eager: 0, singleton: 1, requiredVersion: "~2.3.3" }, { name: "@lumino/coreutils", version: "2.2.2", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(92359))))), eager: 0, singleton: 1, requiredVersion: "~2.2.2" }, { name: "@lumino/datagrid", version: "2.5.3", factory: () => (Promise.all([__webpack_require__.e("8924"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("5177"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(56967))))), eager: 0, requiredVersion: "^2.5.3" }, { name: "@lumino/disposable", version: "2.1.5", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(19877))))), eager: 0, singleton: 1, requiredVersion: "~2.1.5" }, { name: "@lumino/domutils", version: "2.0.4", factory: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(91356))))), eager: 0, singleton: 1, requiredVersion: "~2.0.4" }, { name: "@lumino/dragdrop", version: "2.1.7", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(72790))))), eager: 0, singleton: 1, requiredVersion: "~2.1.7" }, { name: "@lumino/keyboard", version: "2.0.4", factory: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(56704))))), eager: 0, requiredVersion: "^2.0.4" }, { name: "@lumino/messaging", version: "2.0.4", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(46364))))), eager: 0, singleton: 1, requiredVersion: "~2.0.4" }, { name: "@lumino/polling", version: "2.1.5", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(16538))))), eager: 0, requiredVersion: "^2.1.5" }, { name: "@lumino/properties", version: "2.0.4", factory: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(25328))))), eager: 0, singleton: 1, requiredVersion: "~2.0.4" }, { name: "@lumino/signaling", version: "2.1.5", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(97339))))), eager: 0, singleton: 1, requiredVersion: "~2.1.5" }, { name: "@lumino/virtualdom", version: "2.0.4", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(61848))))), eager: 0, singleton: 1, requiredVersion: "~2.0.4" }, { name: "@lumino/widgets", version: "2.7.2", factory: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1231"), __webpack_require__.e("3443"), __webpack_require__.e("7767"), __webpack_require__.e("5177"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(65352))))), eager: 0, singleton: 1, requiredVersion: "~2.7.2" }, { name: "@rjsf/utils", version: "5.16.1", factory: () => (Promise.all([__webpack_require__.e("723"), __webpack_require__.e("9784"), __webpack_require__.e("7703"), __webpack_require__.e("6731")]).then(() => (() => (__webpack_require__(85674))))), eager: 0, requiredVersion: "^5.13.4" }, { name: "@rjsf/validator-ajv8", version: "5.15.1", factory: () => (Promise.all([__webpack_require__.e("723"), __webpack_require__.e("1459"), __webpack_require__.e("6863"), __webpack_require__.e("5817")]).then(() => (() => (__webpack_require__(28290))))), eager: 0, requiredVersion: "^5.13.4" }, { name: "@xterm/addon-search", version: "0.15.0", factory: () => (__webpack_require__.e("1305").then(() => (() => (__webpack_require__(83488))))), eager: 0, requiredVersion: "~0.15.0" }, { name: "color", version: "3.2.1", factory: () => (__webpack_require__.e("8458").then(() => (() => (__webpack_require__(10353))))), eager: 0, requiredVersion: "^5.0.0" }, { name: "color", version: "5.0.0", factory: () => (__webpack_require__.e("8776").then(() => (() => (__webpack_require__(60379))))), eager: 0, requiredVersion: "^5.0.0" }, { name: "marked-gfm-heading-id", version: "4.1.2", factory: () => (__webpack_require__.e("7312").then(() => (() => (__webpack_require__(22835))))), eager: 0, requiredVersion: "^4.1.2" }, { name: "marked-mangle", version: "1.1.11", factory: () => (__webpack_require__.e("256").then(() => (() => (__webpack_require__(12787))))), eager: 0, requiredVersion: "^1.1.11" }, { name: "marked", version: "16.3.0", factory: () => (__webpack_require__.e("953").then(() => (() => (__webpack_require__(56320))))), eager: 0, requiredVersion: "^16.2.1" }, { name: "react-dom", version: "18.2.0", factory: () => (Promise.all([__webpack_require__.e("8470"), __webpack_require__.e("6731")]).then(() => (() => (__webpack_require__(78325))))), eager: 0, singleton: 1, requiredVersion: "~18.2.0" }, { name: "react-toastify", version: "9.1.3", factory: () => (Promise.all([__webpack_require__.e("6731"), __webpack_require__.e("4008")]).then(() => (() => (__webpack_require__(21659))))), eager: 0, requiredVersion: "^9.0.8" }, { name: "react", version: "18.2.0", factory: () => (__webpack_require__.e("4121").then(() => (() => (__webpack_require__(63696))))), eager: 0, singleton: 1, requiredVersion: "~18.2.0" }, { name: "yjs", version: "13.6.8", factory: () => (__webpack_require__.e("4976").then(() => (() => (__webpack_require__(48019))))), eager: 0, singleton: 1, requiredVersion: "~13.6.8" }] }, uniqueName: "_JUPYTERLAB.CORE_OUTPUT" };
__webpack_require__.I = __webpack_require__.I || function() { throw new Error("should have __webpack_require__.I") }

})();
// webpack/runtime/consumes_loading
(() => {

__webpack_require__.consumesLoadingData = { chunkMapping: {"5817":["13456"],"5917":["64972"],"9880":["12779"],"7871":["45922"],"6969":["33088"],"422":["77504"],"7493":["59332"],"8063":["29970"],"5813":["80996"],"8513":["53816"],"6983":["6202"],"8637":["1884"],"8780":["6951"],"683":["10054"],"595":["93822"],"7195":["11158"],"9515":["68678"],"7767":["22778"],"8523":["80070"],"4305":["19352"],"9867":["34390"],"2808":["81947"],"75":["28310"],"4392":["41035"],"1815":["88422","16210","98050","75966","23676","67030","12000","19982","84304","7438","10728","86058","93918","39324","64926","35900","12624","75332","15010","42806","59300","79046","94798","8158","21170","58282","32254","64090","11142","38847","82356","41350","71094","25630","53638","5234","96662","94138","74558","37514","56070","44448","5048","79138","49666","54142","20486","66504","11138","93182","95344","92448","1846"],"7979":["48774"],"6321":["75272"],"9211":["66518"],"1231":["98818"],"2379":["74134"],"4435":["12542"],"7841":["45384"],"8297":["1120"],"73":["69360"],"2253":["35884"],"7819":["82614"],"6629":["16324"],"5255":["86554"],"2355":["42574"],"8267":["14038"],"5177":["21824"],"9980":["81975"],"7559":["92074"],"7991":["3530"],"6871":["53738"],"5555":["31918"],"11":["62358"],"6975":["58948"],"6567":["81882"],"1611":["33206"],"1867":["12838"],"8939":["70827"],"1419":["65702"],"9967":["43890"],"3833":["41440"],"957":["30444"],"7459":["23102"],"8153":["8336"],"9419":["16118"],"5613":["28716"],"6623":["96690"],"1755":["31430"],"6585":["12320"],"8557":["16812"],"5791":["12482"],"3274":["72465"],"8424":["87880"],"4004":["43775"],"9831":["5066"],"5289":["3744"],"2681":["45488"],"6327":["48634"],"2533":["83044"],"3443":["99774"],"1411":["1902"],"4539":["94854"],"5451":["1910"],"9398":["3877"],"5448":["96710"],"9580":["42167"],"7742":["34381"],"9346":["60553"],"6392":["79814"],"6731":["38550"],"7621":["88804"],"7676":["67127"],"5887":["60930"],"3621":["16292"],"1189":["36548"],"1043":["42590"]}, moduleIdToConsumeDataMapping: {"42806": { shareScope: "default", shareKey: "@jupyterlab/json-extension", import: "@jupyterlab/json-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("7559"), __webpack_require__.e("6656")]).then(() => (() => (__webpack_require__(26762))))) }, "12320": { shareScope: "default", shareKey: "@jupyterlab/lsp", import: "@jupyterlab/lsp", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("4113"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("6969"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(440))))) }, "79814": { shareScope: "default", shareKey: "@jupyterlab/property-inspector", import: "@jupyterlab/property-inspector", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(84695))))) }, "5048": { shareScope: "default", shareKey: "@jupyterlab/toc-extension", import: "@jupyterlab/toc-extension", requiredVersion: "~6.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2681")]).then(() => (() => (__webpack_require__(60030))))) }, "1902": { shareScope: "default", shareKey: "@jupyterlab/pluginmanager", import: "@jupyterlab/pluginmanager", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(90604))))) }, "19982": { shareScope: "default", shareKey: "@jupyterlab/markdownviewer-extension", import: "@jupyterlab/markdownviewer-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2681"), __webpack_require__.e("7459")]).then(() => (() => (__webpack_require__(46543))))) }, "21824": { shareScope: "default", shareKey: "@lumino/dragdrop", import: "@lumino/dragdrop", requiredVersion: "~2.1.7", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(72790))))) }, "66504": { shareScope: "default", shareKey: "@jupyterlab/mathjax-extension", import: "@jupyterlab/mathjax-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("7871")]).then(() => (() => (__webpack_require__(44453))))) }, "41440": { shareScope: "default", shareKey: "@jupyter-notebook/application", import: "@jupyter-notebook/application", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7195"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("7909")]).then(() => (() => (__webpack_require__(58260))))) }, "60553": { shareScope: "default", shareKey: "yjs", import: "yjs", requiredVersion: "~13.6.8", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("4976").then(() => (() => (__webpack_require__(48019))))) }, "16812": { shareScope: "default", shareKey: "@xterm/addon-search", import: "@xterm/addon-search", requiredVersion: "~0.15.0", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("1305").then(() => (() => (__webpack_require__(83488))))) }, "33206": { shareScope: "default", shareKey: "@lumino/polling", import: "@lumino/polling", requiredVersion: "^2.1.5", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(16538))))) }, "32254": { shareScope: "default", shareKey: "@jupyter-notebook/console-extension", import: "@jupyter-notebook/console-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("6321"), __webpack_require__.e("9393")]).then(() => (() => (__webpack_require__(77965))))) }, "70827": { shareScope: "default", shareKey: "marked-gfm-heading-id", import: "marked-gfm-heading-id", requiredVersion: "^4.1.2", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("7312").then(() => (() => (__webpack_require__(22835))))) }, "75966": { shareScope: "default", shareKey: "@jupyterlab/terminal-extension", import: "@jupyterlab/terminal-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4435"), __webpack_require__.e("8267"), __webpack_require__.e("3621"), __webpack_require__.e("6623"), __webpack_require__.e("9515"), __webpack_require__.e("7621")]).then(() => (() => (__webpack_require__(13293))))) }, "81947": { shareScope: "default", shareKey: "@codemirror/state", import: "@codemirror/state", requiredVersion: "~6.5.2", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1608").then(() => (() => (__webpack_require__(47995))))) }, "84304": { shareScope: "default", shareKey: "@jupyterlab/console-extension", import: "@jupyterlab/console-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("9867"), __webpack_require__.e("4435"), __webpack_require__.e("1231"), __webpack_require__.e("2379"), __webpack_require__.e("6321"), __webpack_require__.e("422"), __webpack_require__.e("6623")]).then(() => (() => (__webpack_require__(91920))))) }, "99774": { shareScope: "default", shareKey: "@lumino/commands", import: "@lumino/commands", requiredVersion: "~2.3.3", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(1337))))) }, "29970": { shareScope: "default", shareKey: "@lumino/keyboard", import: "@lumino/keyboard", requiredVersion: "^2.0.4", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(56704))))) }, "92074": { shareScope: "default", shareKey: "react-dom", import: "react-dom", requiredVersion: "~18.2.0", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("8470").then(() => (() => (__webpack_require__(78325))))) }, "44448": { shareScope: "default", shareKey: "@jupyterlab/settingeditor-extension", import: "@jupyterlab/settingeditor-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("9867"), __webpack_require__.e("1189"), __webpack_require__.e("11"), __webpack_require__.e("8424"), __webpack_require__.e("1411")]).then(() => (() => (__webpack_require__(74316))))) }, "42167": { shareScope: "default", shareKey: "@codemirror/lang-markdown", import: "@codemirror/lang-markdown", requiredVersion: "^6.3.2", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("6428"), __webpack_require__.e("8794"), __webpack_require__.e("9924"), __webpack_require__.e("2785"), __webpack_require__.e("8898"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("8780")]).then(() => (() => (__webpack_require__(21545))))) }, "77504": { shareScope: "default", shareKey: "@jupyterlab/completer", import: "@jupyterlab/completer", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("7979"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("7819")]).then(() => (() => (__webpack_require__(81379))))) }, "64090": { shareScope: "default", shareKey: "@jupyterlab/fileeditor-extension", import: "@jupyterlab/fileeditor-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("4435"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("2379"), __webpack_require__.e("6321"), __webpack_require__.e("6585"), __webpack_require__.e("422"), __webpack_require__.e("6623"), __webpack_require__.e("8424"), __webpack_require__.e("6567"), __webpack_require__.e("7493")]).then(() => (() => (__webpack_require__(75658))))) }, "93822": { shareScope: "default", shareKey: "@jupyterlab/attachments", import: "@jupyterlab/attachments", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9980")]).then(() => (() => (__webpack_require__(25312))))) }, "88422": { shareScope: "default", shareKey: "@jupyterlab/htmlviewer-extension", import: "@jupyterlab/htmlviewer-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("1867")]).then(() => (() => (__webpack_require__(66787))))) }, "7438": { shareScope: "default", shareKey: "@jupyterlab/filebrowser-extension", import: "@jupyterlab/filebrowser-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("3443"), __webpack_require__.e("2379")]).then(() => (() => (__webpack_require__(63546))))) }, "41350": { shareScope: "default", shareKey: "@jupyterlab/pluginmanager-extension", import: "@jupyterlab/pluginmanager-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("1411")]).then(() => (() => (__webpack_require__(83778))))) }, "3877": { shareScope: "default", shareKey: "@jupyterlab/apputils", import: "@jupyterlab/apputils", requiredVersion: "~4.7.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("3429"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("73"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1189"), __webpack_require__.e("9980"), __webpack_require__.e("7767"), __webpack_require__.e("3896")]).then(() => (() => (__webpack_require__(5706))))) }, "28716": { shareScope: "default", shareKey: "@lumino/datagrid", import: "@lumino/datagrid", requiredVersion: "^2.5.3", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8924"), __webpack_require__.e("5255"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("5177"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(56967))))) }, "12000": { shareScope: "default", shareKey: "@jupyterlab/lsp-extension", import: "@jupyterlab/lsp-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("1611"), __webpack_require__.e("6585"), __webpack_require__.e("3621")]).then(() => (() => (__webpack_require__(30805))))) }, "72465": { shareScope: "default", shareKey: "@jupyter/react-components", import: "@jupyter/react-components", requiredVersion: "~0.16.7", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("4282"), __webpack_require__.e("9419")]).then(() => (() => (__webpack_require__(25569))))) }, "96662": { shareScope: "default", shareKey: "@jupyterlab/cell-toolbar-extension", import: "@jupyterlab/cell-toolbar-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("4305"), __webpack_require__.e("1043")]).then(() => (() => (__webpack_require__(87722))))) }, "12482": { shareScope: "default", shareKey: "@jupyterlab/metadataform", import: "@jupyterlab/metadataform", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("5451")]).then(() => (() => (__webpack_require__(13531))))) }, "23676": { shareScope: "default", shareKey: "@jupyterlab/imageviewer-extension", import: "@jupyterlab/imageviewer-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("957")]).then(() => (() => (__webpack_require__(92483))))) }, "53738": { shareScope: "default", shareKey: "@jupyterlab/csvviewer", import: "@jupyterlab/csvviewer", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5613")]).then(() => (() => (__webpack_require__(13842))))) }, "39324": { shareScope: "default", shareKey: "@jupyterlab/mermaid-extension", import: "@jupyterlab/mermaid-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("5813")]).then(() => (() => (__webpack_require__(29071))))) }, "95344": { shareScope: "default", shareKey: "@jupyter-notebook/application-extension", import: "@jupyter-notebook/application-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("6321"), __webpack_require__.e("5555"), __webpack_require__.e("5927")]).then(() => (() => (__webpack_require__(20442))))) }, "48774": { shareScope: "default", shareKey: "@jupyterlab/codemirror", import: "@jupyterlab/codemirror", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9924"), __webpack_require__.e("8985"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("9867"), __webpack_require__.e("8267"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("7819"), __webpack_require__.e("8424"), __webpack_require__.e("8780"), __webpack_require__.e("7493"), __webpack_require__.e("9346")]).then(() => (() => (__webpack_require__(52075))))) }, "1120": { shareScope: "default", shareKey: "@jupyterlab/settingeditor", import: "@jupyterlab/settingeditor", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("1611"), __webpack_require__.e("9867"), __webpack_require__.e("1189"), __webpack_require__.e("5451")]).then(() => (() => (__webpack_require__(97816))))) }, "45922": { shareScope: "default", shareKey: "@jupyterlab/rendermime", import: "@jupyterlab/rendermime", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("9980"), __webpack_require__.e("75"), __webpack_require__.e("2253")]).then(() => (() => (__webpack_require__(23788))))) }, "86058": { shareScope: "default", shareKey: "@jupyterlab/services-extension", import: "@jupyterlab/services-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(47236))))) }, "94854": { shareScope: "default", shareKey: "react-toastify", import: "react-toastify", requiredVersion: "^9.0.8", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("1627").then(() => (() => (__webpack_require__(21659))))) }, "35884": { shareScope: "default", shareKey: "@jupyterlab/rendermime-interfaces", import: "@jupyterlab/rendermime-interfaces", requiredVersion: "~3.14.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(96963))))) }, "62358": { shareScope: "default", shareKey: "@codemirror/view", import: "@codemirror/view", requiredVersion: "~6.38.1", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("175"), __webpack_require__.e("2808")]).then(() => (() => (__webpack_require__(57490))))) }, "11158": { shareScope: "default", shareKey: "@jupyterlab/application", import: "@jupyterlab/application", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("4392")]).then(() => (() => (__webpack_require__(86152))))) }, "20486": { shareScope: "default", shareKey: "@jupyterlab/documentsearch-extension", import: "@jupyterlab/documentsearch-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("8267")]).then(() => (() => (__webpack_require__(6053))))) }, "82614": { shareScope: "default", shareKey: "@codemirror/language", import: "@codemirror/language", requiredVersion: "^6.11.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8150"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("8780")]).then(() => (() => (__webpack_require__(34885))))) }, "36548": { shareScope: "default", shareKey: "@jupyterlab/statedb", import: "@jupyterlab/statedb", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(13431))))) }, "38847": { shareScope: "default", shareKey: "@jupyterlab/shortcuts-extension", import: "@jupyterlab/shortcuts-extension", requiredVersion: "~5.4.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("3443"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(15829))))) }, "75332": { shareScope: "default", shareKey: "@jupyterlab/video-extension", import: "@jupyterlab/video-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(26455))))) }, "74558": { shareScope: "default", shareKey: "@jupyter-notebook/notebook-extension", import: "@jupyter-notebook/notebook-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("1611"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("7991"), __webpack_require__.e("6432")]).then(() => (() => (__webpack_require__(40467))))) }, "54142": { shareScope: "default", shareKey: "@jupyter-notebook/documentsearch-extension", import: "@jupyter-notebook/documentsearch-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8267"), __webpack_require__.e("9301")]).then(() => (() => (__webpack_require__(33081))))) }, "11138": { shareScope: "default", shareKey: "@jupyterlab/metadataform-extension", import: "@jupyterlab/metadataform-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("4305"), __webpack_require__.e("7991"), __webpack_require__.e("5791")]).then(() => (() => (__webpack_require__(20787))))) }, "31918": { shareScope: "default", shareKey: "@jupyter-notebook/ui-components", import: "@jupyter-notebook/ui-components", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("6975"), __webpack_require__.e("2070")]).then(() => (() => (__webpack_require__(17621))))) }, "8336": { shareScope: "default", shareKey: "@jupyterlab/tooltip", import: "@jupyterlab/tooltip", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6975")]).then(() => (() => (__webpack_require__(34659))))) }, "3530": { shareScope: "default", shareKey: "@jupyterlab/notebook", import: "@jupyterlab/notebook", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("9980"), __webpack_require__.e("8267"), __webpack_require__.e("1231"), __webpack_require__.e("2681"), __webpack_require__.e("6585"), __webpack_require__.e("7767"), __webpack_require__.e("5177"), __webpack_require__.e("5917"), __webpack_require__.e("7676"), __webpack_require__.e("75")]).then(() => (() => (__webpack_require__(16891))))) }, "1846": { shareScope: "default", shareKey: "@jupyterlab/mainmenu-extension", import: "@jupyterlab/mainmenu-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4435"), __webpack_require__.e("1755"), __webpack_require__.e("2379")]).then(() => (() => (__webpack_require__(30289))))) }, "98050": { shareScope: "default", shareKey: "@jupyterlab/apputils-extension", import: "@jupyterlab/apputils-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("4435"), __webpack_require__.e("5887"), __webpack_require__.e("1189"), __webpack_require__.e("3443"), __webpack_require__.e("7559"), __webpack_require__.e("9211"), __webpack_require__.e("9513")]).then(() => (() => (__webpack_require__(83061))))) }, "16324": { shareScope: "default", shareKey: "@lumino/signaling", import: "@lumino/signaling", requiredVersion: "~2.1.5", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(97339))))) }, "25630": { shareScope: "default", shareKey: "@jupyterlab/codemirror-extension", import: "@jupyterlab/codemirror-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("7979"), __webpack_require__.e("7991"), __webpack_require__.e("7819"), __webpack_require__.e("8424"), __webpack_require__.e("5451"), __webpack_require__.e("7493")]).then(() => (() => (__webpack_require__(17770))))) }, "11142": { shareScope: "default", shareKey: "@jupyterlab/application-extension", import: "@jupyterlab/application-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("2355"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("3443"), __webpack_require__.e("6392")]).then(() => (() => (__webpack_require__(19508))))) }, "41035": { shareScope: "default", shareKey: "@lumino/application", import: "@lumino/application", requiredVersion: "~2.4.5", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(62534))))) }, "74134": { shareScope: "default", shareKey: "@jupyterlab/filebrowser", import: "@jupyterlab/filebrowser", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("4004"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1755"), __webpack_require__.e("7767"), __webpack_require__.e("5177")]).then(() => (() => (__webpack_require__(9949))))) }, "16118": { shareScope: "default", shareKey: "@jupyter/web-components", import: "@jupyter/web-components", requiredVersion: "~0.16.7", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("7820").then(() => (() => (__webpack_require__(8631))))) }, "6951": { shareScope: "default", shareKey: "@lezer/highlight", import: "@lezer/highlight", requiredVersion: "~1.2.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("5244"), __webpack_require__.e("6983")]).then(() => (() => (__webpack_require__(6311))))) }, "49666": { shareScope: "default", shareKey: "@jupyterlab/help-extension", import: "@jupyterlab/help-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4435")]).then(() => (() => (__webpack_require__(83775))))) }, "45488": { shareScope: "default", shareKey: "@jupyterlab/toc", import: "@jupyterlab/toc", requiredVersion: "^6.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(68873))))) }, "12779": { shareScope: "default", shareKey: "color", import: "color", requiredVersion: "^5.0.0", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("8458").then(() => (() => (__webpack_require__(10353))))) }, "43890": { shareScope: "default", shareKey: "@jupyterlab/extensionmanager", import: "@jupyterlab/extensionmanager", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("1773"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("1611"), __webpack_require__.e("4004")]).then(() => (() => (__webpack_require__(77095))))) }, "96690": { shareScope: "default", shareKey: "@jupyterlab/launcher", import: "@jupyterlab/launcher", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(52507))))) }, "64926": { shareScope: "default", shareKey: "@jupyter-notebook/tree-extension", import: "@jupyter-notebook/tree-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("2379"), __webpack_require__.e("3621"), __webpack_require__.e("8297"), __webpack_require__.e("5448"), __webpack_require__.e("2213")]).then(() => (() => (__webpack_require__(51017))))) }, "93918": { shareScope: "default", shareKey: "@jupyter-notebook/docmanager-extension", import: "@jupyter-notebook/docmanager-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("6629"), __webpack_require__.e("1755"), __webpack_require__.e("8109")]).then(() => (() => (__webpack_require__(52913))))) }, "58282": { shareScope: "default", shareKey: "@jupyterlab/csvviewer-extension", import: "@jupyterlab/csvviewer-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("6969"), __webpack_require__.e("4435"), __webpack_require__.e("8267")]).then(() => (() => (__webpack_require__(17242))))) }, "79138": { shareScope: "default", shareKey: "@jupyterlab/markedparser-extension", import: "@jupyterlab/markedparser-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7871"), __webpack_require__.e("7979"), __webpack_require__.e("5813")]).then(() => (() => (__webpack_require__(41979))))) }, "58948": { shareScope: "default", shareKey: "@jupyterlab/ui-components", import: "@jupyterlab/ui-components", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("723"), __webpack_require__.e("9784"), __webpack_require__.e("8706"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("8637"), __webpack_require__.e("1231"), __webpack_require__.e("3443"), __webpack_require__.e("7767"), __webpack_require__.e("3274"), __webpack_require__.e("7559"), __webpack_require__.e("9419"), __webpack_require__.e("5817")]).then(() => (() => (__webpack_require__(80640))))) }, "5234": { shareScope: "default", shareKey: "@jupyterlab/debugger-extension", import: "@jupyterlab/debugger-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("6969"), __webpack_require__.e("9867"), __webpack_require__.e("7991"), __webpack_require__.e("6321"), __webpack_require__.e("422"), __webpack_require__.e("5917"), __webpack_require__.e("6567"), __webpack_require__.e("9831")]).then(() => (() => (__webpack_require__(39112))))) }, "34390": { shareScope: "default", shareKey: "@jupyterlab/codeeditor", import: "@jupyterlab/codeeditor", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("73"), __webpack_require__.e("9980"), __webpack_require__.e("7676")]).then(() => (() => (__webpack_require__(50459))))) }, "45384": { shareScope: "default", shareKey: "marked", import: "marked", requiredVersion: "^16.2.1", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("953").then(() => (() => (__webpack_require__(56320))))) }, "86554": { shareScope: "default", shareKey: "@lumino/algorithm", import: "@lumino/algorithm", requiredVersion: "~2.0.4", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(52144))))) }, "71094": { shareScope: "default", shareKey: "@jupyterlab/audio-extension", import: "@jupyterlab/audio-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("7195"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(89346))))) }, "30444": { shareScope: "default", shareKey: "@jupyterlab/imageviewer", import: "@jupyterlab/imageviewer", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("5289"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(76882))))) }, "53638": { shareScope: "default", shareKey: "@jupyterlab/theme-dark-high-contrast-extension", import: "@jupyterlab/theme-dark-high-contrast-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(12272))))) }, "1910": { shareScope: "default", shareKey: "@rjsf/validator-ajv8", import: "@rjsf/validator-ajv8", requiredVersion: "^5.13.4", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("723"), __webpack_require__.e("1459"), __webpack_require__.e("6863"), __webpack_require__.e("5817")]).then(() => (() => (__webpack_require__(28290))))) }, "60930": { shareScope: "default", shareKey: "@lumino/domutils", import: "@lumino/domutils", requiredVersion: "~2.0.4", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(91356))))) }, "59300": { shareScope: "default", shareKey: "@jupyterlab/ui-components-extension", import: "@jupyterlab/ui-components-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6975")]).then(() => (() => (__webpack_require__(86241))))) }, "94138": { shareScope: "default", shareKey: "@jupyterlab/extensionmanager-extension", import: "@jupyterlab/extensionmanager-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("9967")]).then(() => (() => (__webpack_require__(56016))))) }, "37514": { shareScope: "default", shareKey: "@jupyterlab/javascript-extension", import: "@jupyterlab/javascript-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7871")]).then(() => (() => (__webpack_require__(24207))))) }, "65702": { shareScope: "default", shareKey: "@jupyterlab/logconsole", import: "@jupyterlab/logconsole", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("8523")]).then(() => (() => (__webpack_require__(1786))))) }, "5066": { shareScope: "default", shareKey: "@jupyterlab/debugger", import: "@jupyterlab/debugger", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("1611"), __webpack_require__.e("9980"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(61681))))) }, "88804": { shareScope: "default", shareKey: "color", import: "color", requiredVersion: "^5.0.0", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("8776").then(() => (() => (__webpack_require__(60379))))) }, "16292": { shareScope: "default", shareKey: "@jupyterlab/running", import: "@jupyterlab/running", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("2355"), __webpack_require__.e("5887"), __webpack_require__.e("3274")]).then(() => (() => (__webpack_require__(23203))))) }, "10054": { shareScope: "default", shareKey: "@jupyterlab/docmanager-extension", import: "@jupyterlab/docmanager-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("73"), __webpack_require__.e("1189"), __webpack_require__.e("1755")]).then(() => (() => (__webpack_require__(59341))))) }, "59332": { shareScope: "default", shareKey: "@codemirror/search", import: "@codemirror/search", requiredVersion: "^6.5.10", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("3732"), __webpack_require__.e("11"), __webpack_require__.e("2808")]).then(() => (() => (__webpack_require__(28271))))) }, "35900": { shareScope: "default", shareKey: "@jupyterlab/hub-extension", import: "@jupyterlab/hub-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195")]).then(() => (() => (__webpack_require__(56715))))) }, "53816": { shareScope: "default", shareKey: "@jupyterlab/translation", import: "@jupyterlab/translation", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("5289"), __webpack_require__.e("4004"), __webpack_require__.e("1189")]).then(() => (() => (__webpack_require__(68154))))) }, "69360": { shareScope: "default", shareKey: "@jupyterlab/statusbar", import: "@jupyterlab/statusbar", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(57217))))) }, "38550": { shareScope: "default", shareKey: "react", import: "react", requiredVersion: "~18.2.0", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("4121").then(() => (() => (__webpack_require__(63696))))) }, "56070": { shareScope: "default", shareKey: "@jupyterlab/theme-dark-extension", import: "@jupyterlab/theme-dark-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(4304))))) }, "96710": { shareScope: "default", shareKey: "@jupyter-notebook/tree", import: "@jupyter-notebook/tree", requiredVersion: "~7.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("2533"), __webpack_require__.e("6899")]).then(() => (() => (__webpack_require__(47907))))) }, "12542": { shareScope: "default", shareKey: "@jupyterlab/mainmenu", import: "@jupyterlab/mainmenu", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(71468))))) }, "19352": { shareScope: "default", shareKey: "@jupyterlab/settingregistry", import: "@jupyterlab/settingregistry", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("1459"), __webpack_require__.e("5876"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("2355"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(51056))))) }, "12624": { shareScope: "default", shareKey: "@jupyterlab/translation-extension", import: "@jupyterlab/translation-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("4435")]).then(() => (() => (__webpack_require__(29271))))) }, "81975": { shareScope: "default", shareKey: "@jupyterlab/observables", import: "@jupyterlab/observables", requiredVersion: "~5.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("8637")]).then(() => (() => (__webpack_require__(80097))))) }, "80996": { shareScope: "default", shareKey: "@jupyterlab/mermaid", import: "@jupyterlab/mermaid", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("5289")]).then(() => (() => (__webpack_require__(43693))))) }, "42590": { shareScope: "default", shareKey: "@jupyterlab/cell-toolbar", import: "@jupyterlab/cell-toolbar", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("9980")]).then(() => (() => (__webpack_require__(2810))))) }, "83044": { shareScope: "default", shareKey: "@lumino/coreutils", import: "@lumino/coreutils", requiredVersion: "~2.2.2", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(92359))))) }, "22778": { shareScope: "default", shareKey: "@lumino/virtualdom", import: "@lumino/virtualdom", requiredVersion: "~2.0.4", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(61848))))) }, "34381": { shareScope: "default", shareKey: "@lumino/widgets", import: "@lumino/widgets", requiredVersion: "~2.7.2", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("1231"), __webpack_require__.e("3443"), __webpack_require__.e("7767"), __webpack_require__.e("5177"), __webpack_require__.e("8063")]).then(() => (() => (__webpack_require__(65352))))) }, "79046": { shareScope: "default", shareKey: "@jupyterlab/pdf-extension", import: "@jupyterlab/pdf-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7742"), __webpack_require__.e("2355")]).then(() => (() => (__webpack_require__(38222))))) }, "94798": { shareScope: "default", shareKey: "@jupyter-notebook/help-extension", import: "@jupyter-notebook/help-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6731"), __webpack_require__.e("4435"), __webpack_require__.e("5555"), __webpack_require__.e("2320")]).then(() => (() => (__webpack_require__(46051))))) }, "1884": { shareScope: "default", shareKey: "@lumino/messaging", import: "@lumino/messaging", requiredVersion: "~2.0.4", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5255")]).then(() => (() => (__webpack_require__(46364))))) }, "33088": { shareScope: "default", shareKey: "@jupyterlab/docregistry", import: "@jupyterlab/docregistry", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("9867"), __webpack_require__.e("8637")]).then(() => (() => (__webpack_require__(77803))))) }, "80070": { shareScope: "default", shareKey: "@jupyterlab/outputarea", import: "@jupyterlab/outputarea", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("5255"), __webpack_require__.e("4004"), __webpack_require__.e("9980"), __webpack_require__.e("1231"), __webpack_require__.e("75")]).then(() => (() => (__webpack_require__(22225))))) }, "82356": { shareScope: "default", shareKey: "@jupyterlab/running-extension", import: "@jupyterlab/running-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("3621")]).then(() => (() => (__webpack_require__(42270))))) }, "28310": { shareScope: "default", shareKey: "@jupyterlab/nbformat", import: "@jupyterlab/nbformat", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(40399))))) }, "8158": { shareScope: "default", shareKey: "@jupyterlab/theme-light-extension", import: "@jupyterlab/theme-light-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398")]).then(() => (() => (__webpack_require__(18688))))) }, "67030": { shareScope: "default", shareKey: "@jupyterlab/vega5-extension", import: "@jupyterlab/vega5-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("7742")]).then(() => (() => (__webpack_require__(84484))))) }, "10728": { shareScope: "default", shareKey: "@jupyterlab/tooltip-extension", import: "@jupyterlab/tooltip-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("7742"), __webpack_require__.e("5255"), __webpack_require__.e("7871"), __webpack_require__.e("7991"), __webpack_require__.e("6321"), __webpack_require__.e("6567"), __webpack_require__.e("8153")]).then(() => (() => (__webpack_require__(71351))))) }, "15010": { shareScope: "default", shareKey: "@jupyterlab/celltags-extension", import: "@jupyterlab/celltags-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7991")]).then(() => (() => (__webpack_require__(61671))))) }, "42574": { shareScope: "default", shareKey: "@lumino/disposable", import: "@lumino/disposable", requiredVersion: "~2.1.5", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(19877))))) }, "14038": { shareScope: "default", shareKey: "@jupyterlab/documentsearch", import: "@jupyterlab/documentsearch", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("3443")]).then(() => (() => (__webpack_require__(9039))))) }, "93182": { shareScope: "default", shareKey: "@jupyterlab/logconsole-extension", import: "@jupyterlab/logconsole-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("1419")]).then(() => (() => (__webpack_require__(45939))))) }, "87880": { shareScope: "default", shareKey: "@codemirror/commands", import: "@codemirror/commands", requiredVersion: "^6.8.1", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("8198"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("7819")]).then(() => (() => (__webpack_require__(16229))))) }, "64972": { shareScope: "default", shareKey: "@jupyterlab/cells", import: "@jupyterlab/cells", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7871"), __webpack_require__.e("1611"), __webpack_require__.e("9867"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("11"), __webpack_require__.e("2681"), __webpack_require__.e("7767"), __webpack_require__.e("7676"), __webpack_require__.e("8523"), __webpack_require__.e("595")]).then(() => (() => (__webpack_require__(20072))))) }, "68678": { shareScope: "default", shareKey: "@jupyterlab/terminal", import: "@jupyterlab/terminal", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("8637"), __webpack_require__.e("5887"), __webpack_require__.e("7621")]).then(() => (() => (__webpack_require__(83651))))) }, "43775": { shareScope: "default", shareKey: "@jupyterlab/services", import: "@jupyterlab/services", requiredVersion: "~7.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("1189")]).then(() => (() => (__webpack_require__(76492))))) }, "16210": { shareScope: "default", shareKey: "@jupyter-notebook/terminal-extension", import: "@jupyter-notebook/terminal-extension", requiredVersion: "~7.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("9515"), __webpack_require__.e("2654")]).then(() => (() => (__webpack_require__(77048))))) }, "81882": { shareScope: "default", shareKey: "@jupyterlab/fileeditor", import: "@jupyterlab/fileeditor", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("6969"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("6585")]).then(() => (() => (__webpack_require__(99241))))) }, "23102": { shareScope: "default", shareKey: "@jupyterlab/markdownviewer", import: "@jupyterlab/markdownviewer", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6629"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(94474))))) }, "92448": { shareScope: "default", shareKey: "@jupyterlab/completer-extension", import: "@jupyterlab/completer-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("4305"), __webpack_require__.e("9867"), __webpack_require__.e("3443"), __webpack_require__.e("422")]).then(() => (() => (__webpack_require__(37921))))) }, "67127": { shareScope: "default", shareKey: "@jupyter/ydoc", import: "@jupyter/ydoc", requiredVersion: "~3.1.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("2878"), __webpack_require__.e("9346")]).then(() => (() => (__webpack_require__(40493))))) }, "13456": { shareScope: "default", shareKey: "@rjsf/utils", import: "@rjsf/utils", requiredVersion: "^5.13.4", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("9784"), __webpack_require__.e("7703"), __webpack_require__.e("6731")]).then(() => (() => (__webpack_require__(85674))))) }, "6202": { shareScope: "default", shareKey: "@lezer/common", import: "@lezer/common", requiredVersion: "~1.2.1", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("6757").then(() => (() => (__webpack_require__(77956))))) }, "66518": { shareScope: "default", shareKey: "@jupyterlab/workspaces", import: "@jupyterlab/workspaces", requiredVersion: "^4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(5218))))) }, "3744": { shareScope: "default", shareKey: "@jupyterlab/coreutils", import: "@jupyterlab/coreutils", requiredVersion: "~6.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("5353"), __webpack_require__.e("2533"), __webpack_require__.e("6629")]).then(() => (() => (__webpack_require__(43228))))) }, "12838": { shareScope: "default", shareKey: "@jupyterlab/htmlviewer", import: "@jupyterlab/htmlviewer", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("2533"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5289"), __webpack_require__.e("6969")]).then(() => (() => (__webpack_require__(78062))))) }, "21170": { shareScope: "default", shareKey: "@jupyterlab/notebook-extension", import: "@jupyterlab/notebook-extension", requiredVersion: "~4.6.0-alpha.0", strictVersion: true, singleton: false, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("7195"), __webpack_require__.e("4305"), __webpack_require__.e("7871"), __webpack_require__.e("2355"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("9867"), __webpack_require__.e("8637"), __webpack_require__.e("4435"), __webpack_require__.e("1189"), __webpack_require__.e("1755"), __webpack_require__.e("9980"), __webpack_require__.e("8267"), __webpack_require__.e("7979"), __webpack_require__.e("2681"), __webpack_require__.e("7991"), __webpack_require__.e("2379"), __webpack_require__.e("6585"), __webpack_require__.e("422"), __webpack_require__.e("6623"), __webpack_require__.e("5917"), __webpack_require__.e("6392"), __webpack_require__.e("5791"), __webpack_require__.e("1419"), __webpack_require__.e("1043")]).then(() => (() => (__webpack_require__(49339))))) }, "31430": { shareScope: "default", shareKey: "@jupyterlab/docmanager", import: "@jupyterlab/docmanager", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("6731"), __webpack_require__.e("5255"), __webpack_require__.e("2355"), __webpack_require__.e("6969"), __webpack_require__.e("1611"), __webpack_require__.e("73"), __webpack_require__.e("8637"), __webpack_require__.e("1231")]).then(() => (() => (__webpack_require__(53158))))) }, "98818": { shareScope: "default", shareKey: "@lumino/properties", import: "@lumino/properties", requiredVersion: "~2.0.4", strictVersion: false, singleton: true, eager: false, fallback: () => (__webpack_require__.e("1407").then(() => (() => (__webpack_require__(25328))))) }, "75272": { shareScope: "default", shareKey: "@jupyterlab/console", import: "@jupyterlab/console", requiredVersion: "~4.6.0-alpha.0", strictVersion: false, singleton: true, eager: false, fallback: () => (Promise.all([__webpack_require__.e("1407"), __webpack_require__.e("8513"), __webpack_require__.e("9398"), __webpack_require__.e("2533"), __webpack_require__.e("7742"), __webpack_require__.e("6975"), __webpack_require__.e("6629"), __webpack_require__.e("5289"), __webpack_require__.e("7871"), __webpack_require__.e("9980"), __webpack_require__.e("5177"), __webpack_require__.e("5917"), __webpack_require__.e("7676")]).then(() => (() => (__webpack_require__(65606))))) }, "48634": { shareScope: "default", shareKey: "marked-mangle", import: "marked-mangle", requiredVersion: "^1.1.11", strictVersion: true, singleton: false, eager: false, fallback: () => (__webpack_require__.e("256").then(() => (() => (__webpack_require__(12787))))) }}, initialConsumes: [] };
__webpack_require__.f.consumes = __webpack_require__.f.consumes || function() { throw new Error("should have __webpack_require__.f.consumes") }
})();
// webpack/runtime/jsonp_chunk_loading
(() => {
__webpack_require__.b = document.baseURI || self.location.href;

      // object to store loaded and loading chunks
      // undefined = chunk not loaded, null = chunk preloaded/prefetched
      // [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
      var installedChunks = {"1889": 0,};
      
        __webpack_require__.f.j = function (chunkId, promises) {
          // JSONP chunk loading for javascript
var installedChunkData = __webpack_require__.o(installedChunks, chunkId)
	? installedChunks[chunkId]
	: undefined;
if (installedChunkData !== 0) {
	// 0 means "already installed".

	// a Promise means "currently loading".
	if (installedChunkData) {
		promises.push(installedChunkData[2]);
	} else {
		if (!/^(4(004|22|305|392|435|539)|2(355|379|533|681|808)|5(8(13|17|87)|(25|55|9)5|177|289|448|451|613|791|917)|6(9(69|75|83)|3(21|27|92)|62[39]|567|585|731|83|871)|1(41[19]|(|23|61)1|043|189|755|867)|8(5(13|23|57)|(26|29|63)7|063|153|424|780|939)|7(8(19|41|71)|(45|55|97)9|195|3|493|5|621|676|742|767|991)|3(274|443|621|833)|9(5(15|7|80)|8(31|67|80)|211|346|398|419|967|980))$/.test(chunkId)) {
			// setup Promise in chunk cache
			var promise = new Promise((resolve, reject) => (installedChunkData = installedChunks[chunkId] = [resolve, reject]));
			promises.push((installedChunkData[2] = promise));

			// start chunk loading
			var url = __webpack_require__.p + __webpack_require__.u(chunkId);
			// create error before stack unwound to get useful stacktrace later
			var error = new Error();
			var loadingEnded = function (event) {
				if (__webpack_require__.o(installedChunks, chunkId)) {
					installedChunkData = installedChunks[chunkId];
					if (installedChunkData !== 0) installedChunks[chunkId] = undefined;
					if (installedChunkData) {
						var errorType =
							event && (event.type === 'load' ? 'missing' : event.type);
						var realSrc = event && event.target && event.target.src;
						error.message =
							'Loading chunk ' +
							chunkId +
							' failed.\n(' +
							errorType +
							': ' +
							realSrc +
							')';
						error.name = 'ChunkLoadError';
						error.type = errorType;
						error.request = realSrc;
						installedChunkData[1](error);
					}
				}
			};
			__webpack_require__.l(url, loadingEnded, "chunk-" + chunkId, chunkId);
		} else installedChunks[chunkId] = 0; 
	}
}

        }
        // install a JSONP callback for chunk loading
var __rspack_jsonp = (parentChunkLoadingFunction, data) => {
	var [chunkIds, moreModules, runtime] = data;
	// add "moreModules" to the modules object,
	// then flag all "chunkIds" as loaded and fire callback
	var moduleId, chunkId, i = 0;
	if (chunkIds.some((id) => (installedChunks[id] !== 0))) {
		for (moduleId in moreModules) {
			if (__webpack_require__.o(moreModules, moduleId)) {
				__webpack_require__.m[moduleId] = moreModules[moduleId];
			}
		}
		if (runtime) var result = runtime(__webpack_require__);
	}
	if (parentChunkLoadingFunction) parentChunkLoadingFunction(data);
	for (; i < chunkIds.length; i++) {
		chunkId = chunkIds[i];
		if (
			__webpack_require__.o(installedChunks, chunkId) &&
			installedChunks[chunkId]
		) {
			installedChunks[chunkId][0]();
		}
		installedChunks[chunkId] = 0;
	}
	
};

var chunkLoadingGlobal = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || [];
chunkLoadingGlobal.forEach(__rspack_jsonp.bind(null, 0));
chunkLoadingGlobal.push = __rspack_jsonp.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));

})();
// webpack/runtime/embed_federation_runtime
(() => {
var prevStartup = __webpack_require__.x;
var hasRun = false;
__webpack_require__.x = function() {
	if (!hasRun) {
		hasRun = true;
		__webpack_require__(35118)
	}
	if (typeof prevStartup === 'function') {
		return prevStartup();
	} else {
		console.warn('[MF] Invalid prevStartup');
	}
};
})();
// module cache are used so entry inlining is disabled
// run startup
var __webpack_exports__ = __webpack_require__.x();
(_JUPYTERLAB = typeof _JUPYTERLAB === 'undefined' ? {} : _JUPYTERLAB).CORE_OUTPUT = __webpack_exports__;
})()
;
//# sourceMappingURL=main.14de2f206283ab72.js.map?v=14de2f206283ab72