(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["1407"], {
19508(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  DEFAULT_CONTEXT_ITEM_RANK: () => (/* binding */ DEFAULT_CONTEXT_ITEM_RANK),
  "default": () => (/* binding */ lib)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/application@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/application/lib/index.js)
var index_js_ = __webpack_require__(11158);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var lib_index_js_ = __webpack_require__(3877);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(3744);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/property-inspector@^4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/property-inspector/lib/index.js)
var property_inspector_lib_index_js_ = __webpack_require__(79814);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(19352);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(36548);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(69360);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/commands@~2.3.3 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/commands/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(99774);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(42574);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(34381);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/lib/topbar.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




const TOPBAR_FACTORY = 'TopBar';
/**
 * A plugin adding a toolbar to the top area.
 */
const topbar = {
    id: '@jupyterlab/application-extension:top-bar',
    description: 'Adds a toolbar to the top area (next to the main menu bar).',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry, lib_index_js_.IToolbarWidgetRegistry],
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, settingRegistry, toolbarRegistry, translator) => {
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const toolbar = new ui_components_lib_index_js_.Toolbar();
        toolbar.id = 'jp-top-bar';
        toolbar.node.setAttribute('aria-label', trans.__('Topbar toolbar'));
        // Set toolbar
        (0,lib_index_js_.setToolbar)(toolbar, (0,lib_index_js_.createToolbarFactory)(toolbarRegistry, settingRegistry, TOPBAR_FACTORY, topbar.id, translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator), toolbar);
        app.shell.add(toolbar, 'top', { rank: 900 });
    }
};
//# sourceMappingURL=topbar.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module application-extension
 */
















/**
 * Default context menu item rank
 */
const DEFAULT_CONTEXT_ITEM_RANK = 100;
/**
 * The command IDs used by the application plugin.
 */
var lib_CommandIDs;
(function (CommandIDs) {
    CommandIDs.activateNextTab = 'application:activate-next-tab';
    CommandIDs.activatePreviousTab = 'application:activate-previous-tab';
    CommandIDs.activateNextTabBar = 'application:activate-next-tab-bar';
    CommandIDs.activatePreviousTabBar = 'application:activate-previous-tab-bar';
    CommandIDs.close = 'application:close';
    CommandIDs.closeOtherTabs = 'application:close-other-tabs';
    CommandIDs.closeRightTabs = 'application:close-right-tabs';
    CommandIDs.closeAll = 'application:close-all';
    CommandIDs.setMode = 'application:set-mode';
    CommandIDs.showPropertyPanel = 'property-inspector:show-panel';
    CommandIDs.resetLayout = 'application:reset-layout';
    CommandIDs.toggleContextMenu = 'application:toggle-context-menu';
    CommandIDs.toggleHeader = 'application:toggle-header';
    CommandIDs.toggleMode = 'application:toggle-mode';
    CommandIDs.toggleLeftArea = 'application:toggle-left-area';
    CommandIDs.toggleRightArea = 'application:toggle-right-area';
    CommandIDs.toggleSideTabBar = 'application:toggle-side-tabbar';
    CommandIDs.toggleSidebarWidget = 'application:toggle-sidebar-widget';
    CommandIDs.togglePresentationMode = 'application:toggle-presentation-mode';
    CommandIDs.toggleFullscreenMode = 'application:toggle-fullscreen-mode';
    CommandIDs.tree = 'router:tree';
    CommandIDs.switchSidebar = 'sidebar:switch';
})(lib_CommandIDs || (lib_CommandIDs = {}));
/**
 * A plugin to register the commands for the main application.
 */
const mainCommands = {
    id: '@jupyterlab/application-extension:commands',
    description: 'Adds commands related to the shell.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILabShell, lib_index_js_.ICommandPalette],
    activate: (app, translator, labShell, palette) => {
        var _a;
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Main Area');
        // Add Command to override the JLab context menu.
        commands.addCommand(index_js_.JupyterFrontEndContextMenu.contextMenu, {
            label: trans.__('Shift+Right Click for Browser Menu'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => false,
            execute: () => void 0
        });
        // Returns the widget associated with the most recent contextmenu event.
        const contextMenuWidget = () => {
            const test = (node) => !!node.dataset.id;
            const node = app.contextMenuHitTest(test);
            if (!node) {
                // Fall back to active widget if path cannot be obtained from event.
                return shell.currentWidget;
            }
            return ((0,index_es6_js_.find)(shell.widgets('main'), widget => widget.id === node.dataset.id) ||
                shell.currentWidget);
        };
        // Closes an array of widgets.
        const closeWidgets = (widgets) => {
            widgets.forEach(widget => widget.close());
        };
        // Find the tab area for a widget within a specific dock area.
        const findTab = (area, widget) => {
            if (area.type === 'tab-area') {
                return area.widgets.includes(widget) ? area : null;
            }
            if (area.type === 'split-area') {
                for (const child of area.children) {
                    const found = findTab(child, widget);
                    if (found) {
                        return found;
                    }
                }
            }
            return null;
        };
        // Find the tab area for a widget within the main dock area.
        const tabAreaFor = (widget) => {
            var _a;
            const layout = labShell === null || labShell === void 0 ? void 0 : labShell.saveLayout();
            const mainArea = layout === null || layout === void 0 ? void 0 : layout.mainArea;
            if (!mainArea || coreutils_lib_index_js_.PageConfig.getOption('mode') !== 'multiple-document') {
                return null;
            }
            const area = (_a = mainArea.dock) === null || _a === void 0 ? void 0 : _a.main;
            return area ? findTab(area, widget) : null;
        };
        // Returns an array of all widgets to the right of a widget in a tab area.
        const widgetsRightOf = (widget) => {
            const { id } = widget;
            const tabArea = tabAreaFor(widget);
            const widgets = tabArea ? tabArea.widgets || [] : [];
            const index = widgets.findIndex(widget => widget.id === id);
            if (index < 0) {
                return [];
            }
            return widgets.slice(index + 1);
        };
        // Gets and returns the dataId of currently active tab in the specified sidebar (left or right)
        // or an empty string
        const activeSidePanelWidget = (side) => {
            // default active element is luancher (luancher-0)
            let activeTab;
            if (side != 'left' && side != 'right') {
                throw Error(`Unsupported sidebar: ${side}`);
            }
            if (side === 'left') {
                activeTab = document.querySelector('.lm-TabBar-tab.lm-mod-current');
            }
            else {
                const query = document.querySelectorAll('.lm-TabBar-tab.lm-mod-current');
                activeTab = query[query.length - 1];
            }
            const activeTabDataId = activeTab === null || activeTab === void 0 ? void 0 : activeTab.getAttribute('data-id');
            if (activeTabDataId) {
                return activeTabDataId === null || activeTabDataId === void 0 ? void 0 : activeTabDataId.toString();
            }
            else {
                return '';
            }
        };
        // Sets tab focus on the element
        function setTabFocus(focusElement) {
            if (focusElement) {
                focusElement.focus();
            }
        }
        commands.addCommand(lib_CommandIDs.close, {
            label: () => trans.__('Close Tab'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => {
                const widget = contextMenuWidget();
                return !!widget && widget.title.closable;
            },
            execute: () => {
                const widget = contextMenuWidget();
                if (widget) {
                    widget.close();
                }
            }
        });
        commands.addCommand(lib_CommandIDs.closeOtherTabs, {
            label: () => trans.__('Close All Other Tabs'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => {
                // Ensure there are at least two widgets.
                return (0,index_es6_js_.some)(shell.widgets('main'), (_, i) => i === 1);
            },
            execute: () => {
                const widget = contextMenuWidget();
                if (!widget) {
                    return;
                }
                const { id } = widget;
                for (const widget of shell.widgets('main')) {
                    if (widget.id !== id) {
                        widget.close();
                    }
                }
            }
        });
        commands.addCommand(lib_CommandIDs.closeRightTabs, {
            label: () => trans.__('Close Tabs to Right'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => !!contextMenuWidget() &&
                widgetsRightOf(contextMenuWidget()).length > 0,
            execute: () => {
                const widget = contextMenuWidget();
                if (!widget) {
                    return;
                }
                closeWidgets(widgetsRightOf(widget));
            }
        });
        (_a = shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            [
                lib_CommandIDs.close,
                lib_CommandIDs.closeOtherTabs,
                lib_CommandIDs.closeRightTabs
            ].forEach(cmd => commands.notifyCommandChanged(cmd));
        });
        if (labShell) {
            commands.addCommand(lib_CommandIDs.activateNextTab, {
                label: trans.__('Activate Next Tab'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.activateNextTab();
                }
            });
            commands.addCommand(lib_CommandIDs.activatePreviousTab, {
                label: trans.__('Activate Previous Tab'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.activatePreviousTab();
                }
            });
            commands.addCommand(lib_CommandIDs.activateNextTabBar, {
                label: trans.__('Activate Next Tab Bar'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.activateNextTabBar();
                }
            });
            commands.addCommand(lib_CommandIDs.activatePreviousTabBar, {
                label: trans.__('Activate Previous Tab Bar'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.activatePreviousTabBar();
                }
            });
            commands.addCommand(lib_CommandIDs.closeAll, {
                label: trans.__('Close All Tabs'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.closeAll();
                }
            });
            commands.addCommand(lib_CommandIDs.toggleHeader, {
                label: trans.__('Show Header'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    if (labShell.mode === 'single-document') {
                        labShell.toggleTopInSimpleModeVisibility();
                    }
                },
                isToggled: () => labShell.isTopInSimpleModeVisible(),
                isVisible: () => labShell.mode === 'single-document'
            });
            commands.addCommand(lib_CommandIDs.toggleLeftArea, {
                label: trans.__('Show Left Sidebar'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    if (labShell.leftCollapsed) {
                        labShell.expandLeft();
                    }
                    else {
                        labShell.collapseLeft();
                        if (labShell.currentWidget) {
                            labShell.activateById(labShell.currentWidget.id);
                        }
                    }
                },
                isToggled: () => !labShell.leftCollapsed,
                isEnabled: () => !labShell.isEmpty('left')
            });
            commands.addCommand(lib_CommandIDs.toggleRightArea, {
                label: trans.__('Show Right Sidebar'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    if (labShell.rightCollapsed) {
                        labShell.expandRight();
                    }
                    else {
                        labShell.collapseRight();
                        if (labShell.currentWidget) {
                            labShell.activateById(labShell.currentWidget.id);
                        }
                    }
                },
                isToggled: () => !labShell.rightCollapsed,
                isEnabled: () => !labShell.isEmpty('right')
            });
            commands.addCommand(lib_CommandIDs.toggleSidebarWidget, {
                label: args => args === undefined ||
                    args.side === undefined ||
                    args.index === undefined
                    ? trans.__('Toggle Sidebar Element')
                    : args.side === 'right'
                        ? trans.__('Toggle Element %1 in Right Sidebar', parseInt(args.index, 10) + 1)
                        : trans.__('Toggle Element %1 in Left Sidebar', parseInt(args.index, 10) + 1),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {
                            side: {
                                type: 'string',
                                enum: ['left', 'right'],
                                description: trans.__('The sidebar side')
                            },
                            index: {
                                type: ['string', 'number'],
                                description: trans.__('The index of the sidebar widget')
                            }
                        },
                        required: ['side', 'index']
                    }
                },
                execute: args => {
                    const index = parseInt(args.index, 10);
                    if (args.side != 'left' && args.side != 'right') {
                        throw Error(`Unsupported sidebar: ${args.side}`);
                    }
                    const widgets = Array.from(labShell.widgets(args.side));
                    if (index >= widgets.length) {
                        return;
                    }
                    const widgetId = widgets[index].id;
                    const focusElement = document.querySelector("[data-id='" + widgetId + "']");
                    if (activeSidePanelWidget(args.side) === widgetId) {
                        if (args.side == 'left') {
                            labShell.collapseLeft();
                            setTabFocus(focusElement);
                        }
                        if (args.side == 'right') {
                            labShell.collapseRight();
                            setTabFocus(focusElement);
                        }
                    }
                    else {
                        labShell.activateById(widgetId);
                        setTabFocus(focusElement);
                    }
                }
            });
            commands.addCommand(lib_CommandIDs.toggleSideTabBar, {
                label: args => args.side === 'right'
                    ? trans.__('Show Right Activity Bar')
                    : trans.__('Show Left Activity Bar'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {
                            side: {
                                type: 'string',
                                enum: ['left', 'right'],
                                description: trans.__('The sidebar side')
                            }
                        },
                        required: ['side']
                    }
                },
                execute: args => {
                    if (args.side === 'right') {
                        labShell.toggleSideTabBarVisibility('right');
                    }
                    else {
                        labShell.toggleSideTabBarVisibility('left');
                    }
                },
                isToggled: args => args.side === 'right'
                    ? labShell.isSideTabBarVisible('right')
                    : labShell.isSideTabBarVisible('left'),
                isEnabled: args => args.side === 'right'
                    ? !labShell.isEmpty('right')
                    : !labShell.isEmpty('left')
            });
            commands.addCommand(lib_CommandIDs.togglePresentationMode, {
                label: () => trans.__('Presentation Mode'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    labShell.presentationMode = !labShell.presentationMode;
                },
                isToggled: () => labShell.presentationMode,
                isVisible: () => true
            });
            commands.addCommand(lib_CommandIDs.toggleFullscreenMode, {
                label: trans.__('Fullscreen Mode'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    if (document.fullscreenElement === null ||
                        document.fullscreenElement === undefined) {
                        document.documentElement.requestFullscreen().catch(reason => {
                            console.error('Failed to enter fullscreen mode.', reason);
                        });
                    }
                    else if (document.fullscreenElement !== null) {
                        document.exitFullscreen().catch(reason => {
                            console.error('Failed to exit fullscreen mode.', reason);
                        });
                    }
                },
                isToggled: () => document.fullscreenElement !== null
            });
            commands.addCommand(lib_CommandIDs.setMode, {
                label: args => args['mode']
                    ? trans.__('Set %1 mode.', args['mode'])
                    : trans.__('Set the layout `mode`.'),
                caption: trans.__('The layout `mode` can be "single-document" or "multiple-document".'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {
                            mode: {
                                type: 'string',
                                enum: ['single-document', 'multiple-document'],
                                description: trans.__('The layout mode')
                            }
                        },
                        required: ['mode']
                    }
                },
                isVisible: args => {
                    const mode = args['mode'];
                    return mode === 'single-document' || mode === 'multiple-document';
                },
                execute: args => {
                    const mode = args['mode'];
                    if (mode === 'single-document' || mode === 'multiple-document') {
                        labShell.mode = mode;
                        return;
                    }
                    throw new Error(`Unsupported application shell mode: ${mode}`);
                }
            });
            commands.addCommand(lib_CommandIDs.toggleMode, {
                label: trans.__('Simple Interface'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                isToggled: () => labShell.mode === 'single-document',
                execute: () => {
                    const args = labShell.mode === 'multiple-document'
                        ? { mode: 'single-document' }
                        : { mode: 'multiple-document' };
                    return commands.execute(lib_CommandIDs.setMode, args);
                }
            });
            commands.addCommand(lib_CommandIDs.resetLayout, {
                label: trans.__('Reset Default Layout'),
                describedBy: {
                    args: {
                        type: 'object',
                        properties: {}
                    }
                },
                execute: () => {
                    // Turn off presentation mode
                    if (labShell.presentationMode) {
                        commands
                            .execute(lib_CommandIDs.togglePresentationMode)
                            .catch(reason => {
                            console.error('Failed to undo presentation mode.', reason);
                        });
                    }
                    // Turn off fullscreen mode
                    if (document.fullscreenElement !== null ||
                        document.fullscreenElement !== undefined) {
                        commands.execute(lib_CommandIDs.toggleFullscreenMode).catch(reason => {
                            console.error('Failed to exit fullscreen mode.', reason);
                        });
                    }
                    // Display top header
                    if (labShell.mode === 'single-document' &&
                        !labShell.isTopInSimpleModeVisible()) {
                        commands.execute(lib_CommandIDs.toggleHeader).catch(reason => {
                            console.error('Failed to display title header.', reason);
                        });
                    }
                    // Display side tabbar
                    ['left', 'right'].forEach(side => {
                        if (!labShell.isSideTabBarVisible(side) &&
                            !labShell.isEmpty(side)) {
                            commands
                                .execute(lib_CommandIDs.toggleSideTabBar, { side })
                                .catch(reason => {
                                console.error(`Failed to show ${side} activity bar.`, reason);
                            });
                        }
                    });
                    // Some actions are also trigger indirectly
                    // - by listening to this command execution.
                }
            });
        }
        if (palette) {
            [
                lib_CommandIDs.activateNextTab,
                lib_CommandIDs.activatePreviousTab,
                lib_CommandIDs.activateNextTabBar,
                lib_CommandIDs.activatePreviousTabBar,
                lib_CommandIDs.close,
                lib_CommandIDs.closeAll,
                lib_CommandIDs.closeOtherTabs,
                lib_CommandIDs.closeRightTabs,
                lib_CommandIDs.toggleHeader,
                lib_CommandIDs.toggleLeftArea,
                lib_CommandIDs.toggleRightArea,
                lib_CommandIDs.togglePresentationMode,
                lib_CommandIDs.toggleFullscreenMode,
                lib_CommandIDs.toggleMode,
                lib_CommandIDs.resetLayout
            ].forEach(command => palette.addItem({ command, category }));
            ['right', 'left'].forEach(side => {
                palette.addItem({
                    command: lib_CommandIDs.toggleSideTabBar,
                    category,
                    args: { side }
                });
            });
        }
    }
};
/**
 * The main extension.
 */
const main = {
    id: '@jupyterlab/application-extension:main',
    description: 'Initializes the application and provides the URL tree path handler.',
    requires: [
        index_js_.IRouter,
        lib_index_js_.IWindowResolver,
        translation_lib_index_js_.ITranslator,
        index_js_.JupyterFrontEnd.ITreeResolver
    ],
    optional: [index_js_.IConnectionLost],
    provides: index_js_.ITreePathUpdater,
    activate: (app, router, resolver, translator, treeResolver, connectionLost) => {
        const trans = translator.load('jupyterlab');
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${main.id} must be activated in JupyterLab.`);
        }
        // These two internal state variables are used to manage the two source
        // of the tree part of the URL being updated: 1) path of the active document,
        // 2) path of the default browser if the active main area widget isn't a document.
        let _docTreePath = '';
        let _defaultBrowserTreePath = '';
        function updateTreePath(treePath) {
            // Wait for tree resolver to finish before updating the path because it use the PageConfig['treePath']
            void treeResolver.paths.then(() => {
                _defaultBrowserTreePath = treePath;
                if (!_docTreePath) {
                    const url = coreutils_lib_index_js_.PageConfig.getUrl({ treePath });
                    const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
                    router.navigate(path, { skipRouting: true });
                    // Persist the new tree path to PageConfig as it is used elsewhere at runtime.
                    coreutils_lib_index_js_.PageConfig.setOption('treePath', treePath);
                }
            });
        }
        // Requiring the window resolver guarantees that the application extension
        // only loads if there is a viable window name. Otherwise, the application
        // will short-circuit and ask the user to navigate away.
        const workspace = resolver.name;
        console.debug(`Starting application in workspace: "${workspace}"`);
        // If there were errors registering plugins, tell the user.
        if (app.registerPluginErrors.length !== 0) {
            const body = (react_index_js_.createElement("pre", null, app.registerPluginErrors.map(e => e.message).join('\n')));
            void (0,lib_index_js_.showErrorMessage)(trans.__('Error Registering Plugins'), {
                message: body
            });
        }
        // Watch the mode and update the page URL to /lab or /doc to reflect the
        // change.
        app.shell.modeChanged.connect((_, args) => {
            const url = coreutils_lib_index_js_.PageConfig.getUrl({ mode: args });
            const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
            router.navigate(path, { skipRouting: true });
            // Persist this mode change to PageConfig as it is used elsewhere at runtime.
            coreutils_lib_index_js_.PageConfig.setOption('mode', args);
        });
        // Wait for tree resolver to finish before updating the path because it use the PageConfig['treePath']
        void treeResolver.paths.then(() => {
            // Watch the path of the current widget in the main area and update the page
            // URL to reflect the change.
            app.shell.currentPathChanged.connect((_, args) => {
                const maybeTreePath = args.newValue;
                const treePath = maybeTreePath || _defaultBrowserTreePath;
                const url = coreutils_lib_index_js_.PageConfig.getUrl({ treePath: treePath });
                const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
                router.navigate(path, { skipRouting: true });
                // Persist the new tree path to PageConfig as it is used elsewhere at runtime.
                coreutils_lib_index_js_.PageConfig.setOption('treePath', treePath);
                _docTreePath = maybeTreePath;
            });
        });
        // If the connection to the server is lost, handle it with the
        // connection lost handler.
        connectionLost = connectionLost || index_js_.ConnectionLost;
        app.serviceManager.connectionFailure.connect((manager, error) => connectionLost(manager, error, translator));
        const builder = app.serviceManager.builder;
        const build = () => {
            return builder
                .build()
                .then(() => {
                return (0,lib_index_js_.showDialog)({
                    title: trans.__('Build Complete'),
                    body: (react_index_js_.createElement("div", null,
                        trans.__('Build successfully completed, reload page?'),
                        react_index_js_.createElement("br", null),
                        trans.__('You will lose any unsaved changes.'))),
                    buttons: [
                        lib_index_js_.Dialog.cancelButton({
                            label: trans.__('Reload Without Saving'),
                            actions: ['reload']
                        }),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Save and Reload') })
                    ],
                    hasClose: true
                });
            })
                .then(({ button: { accept, actions } }) => {
                if (accept) {
                    void app.commands
                        .execute('docmanager:save')
                        .then(() => {
                        router.reload();
                    })
                        .catch(err => {
                        void (0,lib_index_js_.showErrorMessage)(trans.__('Save Failed'), {
                            message: react_index_js_.createElement("pre", null, err.message)
                        });
                    });
                }
                else if (actions.includes('reload')) {
                    router.reload();
                }
            })
                .catch(err => {
                void (0,lib_index_js_.showErrorMessage)(trans.__('Build Failed'), {
                    message: react_index_js_.createElement("pre", null, err.message)
                });
            });
        };
        if (builder.isAvailable && builder.shouldCheck) {
            void builder.getStatus().then(response => {
                if (response.status === 'building') {
                    return build();
                }
                if (response.status !== 'needed') {
                    return;
                }
                const body = (react_index_js_.createElement("div", null,
                    trans.__('JupyterLab build is suggested:'),
                    react_index_js_.createElement("br", null),
                    react_index_js_.createElement("pre", null, response.message)));
                void (0,lib_index_js_.showDialog)({
                    title: trans.__('Build Recommended'),
                    body,
                    buttons: [
                        lib_index_js_.Dialog.cancelButton(),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Build') })
                    ]
                }).then(result => (result.button.accept ? build() : undefined));
            });
        }
        return updateTreePath;
    },
    autoStart: true
};
/**
 * Plugin to build the context menu from the settings.
 */
const contextMenuPlugin = {
    id: '@jupyterlab/application-extension:context-menu',
    description: 'Populates the context menu.',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    activate: (app, settingRegistry, translator, palette) => {
        const trans = translator.load('jupyterlab');
        function createMenu(options) {
            const menu = new ui_components_lib_index_js_.RankedMenu({ ...options, commands: app.commands });
            if (options.label) {
                menu.title.label = trans.__(options.label);
            }
            return menu;
        }
        // Load the context menu lately so plugins are loaded.
        app.started
            .then(() => {
            return lib_Private.loadSettingsContextMenu(app.contextMenu, app.commands, settingRegistry, createMenu, translator);
        })
            .then(() => {
            if (palette) {
                palette === null || palette === void 0 ? void 0 : palette.addItem({
                    category: trans.__('Settings'),
                    command: lib_CommandIDs.toggleContextMenu
                });
            }
        })
            .catch(reason => {
            console.error('Failed to load context menu items from settings registry.', reason);
        });
    }
};
/**
 * Check if the application is dirty before closing the browser tab.
 */
const dirty = {
    id: '@jupyterlab/application-extension:dirty',
    description: 'Adds safeguard dialog when closing the browser tab with unsaved modifications.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${dirty.id} must be activated in JupyterLab.`);
        }
        const trans = translator.load('jupyterlab');
        const message = trans.__('Are you sure you want to exit JupyterLab?\n\nAny unsaved changes will be lost.');
        // The spec for the `beforeunload` event is implemented differently by
        // the different browser vendors. Consequently, the `event.returnValue`
        // attribute needs to set in addition to a return value being returned.
        // For more information, see:
        // https://developer.mozilla.org/en/docs/Web/Events/beforeunload
        window.addEventListener('beforeunload', event => {
            if (app.status.isDirty) {
                return (event.returnValue = message);
            }
        });
    }
};
/**
 * The default layout restorer provider.
 */
const lib_layout = {
    id: '@jupyterlab/application-extension:layout',
    description: 'Provides the shell layout restorer.',
    requires: [statedb_lib_index_js_.IStateDB, index_js_.ILabShell, settingregistry_lib_index_js_.ISettingRegistry],
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, state, labShell, settingRegistry, translator) => {
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const first = app.started;
        const registry = app.commands;
        const mode = coreutils_lib_index_js_.PageConfig.getOption('mode');
        const restorer = new index_js_.LayoutRestorer({
            connector: state,
            first,
            registry,
            mode
        });
        settingRegistry
            .load(lib_shell.id)
            .then(settings => {
            var _a, _b;
            // Add a layer of customization to support app shell mode
            const customizedLayout = settings.composite['layout'];
            // Restore the layout.
            void labShell
                .restoreLayout(mode, restorer, {
                'multiple-document': (_a = customizedLayout.multiple) !== null && _a !== void 0 ? _a : {},
                'single-document': (_b = customizedLayout.single) !== null && _b !== void 0 ? _b : {}
            })
                .then(() => {
                labShell.layoutModified.connect(() => {
                    void restorer.save(labShell.saveLayout());
                });
                settings.changed.connect(onSettingsChanged);
                lib_Private.activateSidebarSwitcher(app, labShell, settings, trans);
            });
        })
            .catch(reason => {
            console.error('Fail to load settings for the layout restorer.');
            console.error(reason);
        });
        return restorer;
        async function onSettingsChanged(settings) {
            if (!dist_index_js_.JSONExt.deepEqual(settings.composite['layout'], {
                single: labShell.userLayout['single-document'],
                multiple: labShell.userLayout['multiple-document']
            })) {
                const result = await (0,lib_index_js_.showDialog)({
                    title: trans.__('Information'),
                    body: trans.__('User layout customization has changed. You may need to reload JupyterLab to see the changes.'),
                    buttons: [
                        lib_index_js_.Dialog.cancelButton(),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Reload') })
                    ]
                });
                if (result.button.accept) {
                    location.reload();
                }
            }
        }
    },
    autoStart: true,
    provides: index_js_.ILayoutRestorer
};
/**
 * The default URL router provider.
 */
const lib_router = {
    id: '@jupyterlab/application-extension:router',
    description: 'Provides the URL router',
    requires: [index_js_.JupyterFrontEnd.IPaths],
    activate: (app, paths) => {
        const { commands } = app;
        const base = paths.urls.base;
        const router = new index_js_.Router({ base, commands });
        void app.started.then(() => {
            // Route the very first request on load.
            void router.route();
            // Route all pop state events.
            window.addEventListener('popstate', () => {
                void router.route();
            });
        });
        return router;
    },
    autoStart: true,
    provides: index_js_.IRouter
};
/**
 * The default tree route resolver plugin.
 */
const tree = {
    id: '@jupyterlab/application-extension:tree-resolver',
    description: 'Provides the tree route resolver',
    autoStart: true,
    requires: [index_js_.IRouter],
    optional: [translation_lib_index_js_.ITranslator],
    provides: index_js_.JupyterFrontEnd.ITreeResolver,
    activate: (app, router, translator) => {
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const { commands } = app;
        const set = new disposable_dist_index_es6_js_.DisposableSet();
        const delegate = new dist_index_js_.PromiseDelegate();
        const treePattern = new RegExp('/(lab|doc)(/workspaces/[a-zA-Z0-9-_]+)?(/tree/.*)?');
        set.add(commands.addCommand(lib_CommandIDs.tree, {
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        search: {
                            type: 'string',
                            description: trans.__('The URL search string containing query parameters')
                        }
                    }
                }
            },
            execute: async (args) => {
                var _a;
                if (set.isDisposed) {
                    return;
                }
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject((_a = args.search) !== null && _a !== void 0 ? _a : '');
                const browser = query['file-browser-path'] || '';
                // Remove the file browser path from the query string.
                delete query['file-browser-path'];
                // Clean up artifacts immediately upon routing.
                set.dispose();
                delegate.resolve({ browser, file: coreutils_lib_index_js_.PageConfig.getOption('treePath') });
            }
        }));
        set.add(router.register({ command: lib_CommandIDs.tree, pattern: treePattern }));
        // If a route is handled by the router without the tree command being
        // invoked, resolve to `null` and clean up artifacts.
        const listener = () => {
            if (set.isDisposed) {
                return;
            }
            set.dispose();
            delegate.resolve(null);
        };
        router.routed.connect(listener);
        set.add(new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            router.routed.disconnect(listener);
        }));
        return { paths: delegate.promise };
    }
};
/**
 * The default URL not found extension.
 */
const notfound = {
    id: '@jupyterlab/application-extension:notfound',
    description: 'Defines the behavior for not found URL (aka route).',
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter, translation_lib_index_js_.ITranslator],
    activate: (_, paths, router, translator) => {
        const trans = translator.load('jupyterlab');
        const bad = paths.urls.notFound;
        if (!bad) {
            return;
        }
        const base = router.base;
        const message = trans.__('The path: %1 was not found. JupyterLab redirected to: %2', bad, base);
        // Change the URL back to the base application URL.
        router.navigate('');
        void (0,lib_index_js_.showErrorMessage)(trans.__('Path Not Found'), { message });
    },
    autoStart: true
};
/**
 * Change the favicon changing based on the busy status;
 */
const busy = {
    id: '@jupyterlab/application-extension:faviconbusy',
    description: 'Handles the favicon depending on the application status.',
    requires: [index_js_.ILabStatus],
    activate: async (_, status) => {
        status.busySignal.connect((_, isBusy) => {
            const favicon = document.querySelector(`link[rel="icon"]${isBusy ? '.idle.favicon' : '.busy.favicon'}`);
            if (!favicon) {
                return;
            }
            const newFavicon = document.querySelector(`link${isBusy ? '.busy.favicon' : '.idle.favicon'}`);
            if (!newFavicon) {
                return;
            }
            // If we have the two icons with the special classes, then toggle them.
            if (favicon !== newFavicon) {
                favicon.rel = '';
                newFavicon.rel = 'icon';
                // Firefox doesn't seem to recognize just changing rel, so we also
                // reinsert the link into the DOM.
                newFavicon.parentNode.replaceChild(newFavicon, newFavicon);
            }
        });
    },
    autoStart: true
};
/**
 * The default JupyterLab application shell.
 */
const lib_shell = {
    id: '@jupyterlab/application-extension:shell',
    description: 'Provides the JupyterLab shell. It has an extended API compared to `app.shell`.',
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settingRegistry) => {
        if (!(app.shell instanceof index_js_.LabShell)) {
            throw new Error(`${lib_shell.id} did not find a LabShell instance.`);
        }
        if (settingRegistry) {
            void settingRegistry.load(lib_shell.id).then(settings => {
                app.shell.updateConfig(settings.composite);
                settings.changed.connect(() => {
                    app.shell.updateConfig(settings.composite);
                });
            });
        }
        return app.shell;
    },
    autoStart: true,
    provides: index_js_.ILabShell
};
/**
 * The default JupyterLab application status provider.
 */
const lib_status = {
    id: '@jupyterlab/application-extension:status',
    description: 'Provides the application status.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${lib_status.id} must be activated in JupyterLab.`);
        }
        return app.status;
    },
    autoStart: true,
    provides: index_js_.ILabStatus
};
/**
 * The default JupyterLab application-specific information provider.
 *
 * #### Notes
 * This plugin should only be used by plugins that specifically need to access
 * JupyterLab application information, e.g., listing extensions that have been
 * loaded or deferred within JupyterLab.
 */
const info = {
    id: '@jupyterlab/application-extension:info',
    description: 'Provides the application information.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${info.id} must be activated in JupyterLab.`);
        }
        return app.info;
    },
    autoStart: true,
    provides: index_js_.JupyterLab.IInfo
};
/**
 * The default JupyterLab paths dictionary provider.
 */
const lib_paths = {
    id: '@jupyterlab/application-extension:paths',
    description: 'Provides the application paths.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${lib_paths.id} must be activated in JupyterLab.`);
        }
        return app.paths;
    },
    autoStart: true,
    provides: index_js_.JupyterFrontEnd.IPaths
};
/**
 * The default property inspector provider.
 */
const propertyInspector = {
    id: '@jupyterlab/application-extension:property-inspector',
    description: 'Provides the property inspector.',
    autoStart: true,
    requires: [index_js_.ILabShell, translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILayoutRestorer],
    provides: property_inspector_lib_index_js_.IPropertyInspectorProvider,
    activate: (app, labshell, translator, restorer) => {
        const trans = translator.load('jupyterlab');
        const widget = new property_inspector_lib_index_js_.SideBarPropertyInspectorProvider({
            shell: labshell,
            translator
        });
        widget.title.icon = ui_components_lib_index_js_.buildIcon;
        widget.title.caption = trans.__('Property Inspector');
        widget.id = 'jp-property-inspector';
        labshell.add(widget, 'right', { rank: 100, type: 'Property Inspector' });
        app.commands.addCommand(lib_CommandIDs.showPropertyPanel, {
            label: trans.__('Property Inspector'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                labshell.activateById(widget.id);
            }
        });
        if (restorer) {
            restorer.add(widget, 'jp-property-inspector');
        }
        return widget;
    }
};
const jupyterLogo = {
    id: '@jupyterlab/application-extension:logo',
    description: 'Sets the application logo.',
    autoStart: true,
    requires: [index_js_.ILabShell],
    activate: (app, shell) => {
        const logo = new widgets_dist_index_es6_js_.Widget();
        ui_components_lib_index_js_.jupyterIcon.element({
            container: logo.node,
            elementPosition: 'center',
            margin: '2px 2px 2px 8px',
            height: 'auto',
            width: '16px'
        });
        logo.id = 'jp-MainLogo';
        shell.add(logo, 'top', { rank: 0 });
    }
};
/**
 * The simple interface mode switch in the status bar.
 */
const modeSwitchPlugin = {
    id: '@jupyterlab/application-extension:mode-switch',
    description: 'Adds the interface mode switch',
    requires: [index_js_.ILabShell, translation_lib_index_js_.ITranslator],
    optional: [statusbar_lib_index_js_.IStatusBar, settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, labShell, translator, statusBar, settingRegistry) => {
        if (statusBar === null) {
            // Bail early
            return;
        }
        const trans = translator.load('jupyterlab');
        const modeSwitch = new ui_components_lib_index_js_.Switch();
        modeSwitch.id = 'jp-single-document-mode';
        modeSwitch.valueChanged.connect((_, args) => {
            labShell.mode = args.newValue ? 'single-document' : 'multiple-document';
        });
        labShell.modeChanged.connect((_, mode) => {
            modeSwitch.value = mode === 'single-document';
        });
        if (settingRegistry) {
            const loadSettings = settingRegistry.load(lib_shell.id);
            const updateSettings = (settings) => {
                const startMode = settings.get('startMode').composite;
                if (startMode) {
                    labShell.mode =
                        startMode === 'single' ? 'single-document' : 'multiple-document';
                }
            };
            Promise.all([loadSettings, app.restored])
                .then(([settings]) => {
                updateSettings(settings);
            })
                .catch((reason) => {
                console.error(reason.message);
            });
        }
        // Show the current file browser shortcut in its title.
        const updateModeSwitchTitle = () => {
            const binding = app.commands.keyBindings.find(b => b.command === 'application:toggle-mode');
            if (binding) {
                const ks = binding.keys.map(dist_index_es6_js_.CommandRegistry.formatKeystroke).join(', ');
                modeSwitch.caption = trans.__('Simple Interface (%1)', ks);
            }
            else {
                modeSwitch.caption = trans.__('Simple Interface');
            }
        };
        updateModeSwitchTitle();
        app.commands.keyBindingChanged.connect(() => {
            updateModeSwitchTitle();
        });
        modeSwitch.label = trans.__('Simple');
        statusBar.registerStatusItem(modeSwitchPlugin.id, {
            priority: 1,
            item: modeSwitch,
            align: 'left',
            rank: -1
        });
    },
    autoStart: true
};
/**
 * Export the plugins as default.
 */
const plugins = [
    contextMenuPlugin,
    dirty,
    main,
    mainCommands,
    lib_layout,
    lib_router,
    tree,
    notfound,
    busy,
    lib_shell,
    lib_status,
    info,
    modeSwitchPlugin,
    lib_paths,
    propertyInspector,
    jupyterLogo,
    topbar
];
/* export default */ const lib = (plugins);
var lib_Private;
(function (Private) {
    async function displayInformation(trans) {
        const result = await (0,lib_index_js_.showDialog)({
            title: trans.__('Information'),
            body: trans.__('Context menu customization has changed. You will need to reload JupyterLab to see the changes.'),
            buttons: [
                lib_index_js_.Dialog.cancelButton(),
                lib_index_js_.Dialog.okButton({ label: trans.__('Reload') })
            ]
        });
        if (result.button.accept) {
            location.reload();
        }
    }
    async function loadSettingsContextMenu(contextMenu, commands, registry, menuFactory, translator) {
        var _a;
        const trans = translator.load('jupyterlab');
        const pluginId = contextMenuPlugin.id;
        let canonical = null;
        let loaded = {};
        /**
         * Populate the plugin's schema defaults.
         *
         * We keep track of disabled entries in case the plugin is loaded
         * after the menu initialization.
         */
        function populate(schema) {
            var _a, _b;
            loaded = {};
            const pluginDefaults = Object.keys(registry.plugins)
                .map(plugin => {
                var _a, _b;
                const items = (_b = (_a = registry.plugins[plugin].schema['jupyter.lab.menus']) === null || _a === void 0 ? void 0 : _a.context) !== null && _b !== void 0 ? _b : [];
                loaded[plugin] = items;
                return items;
            })
                .concat([(_b = (_a = schema['jupyter.lab.menus']) === null || _a === void 0 ? void 0 : _a.context) !== null && _b !== void 0 ? _b : []])
                .reduceRight((acc, val) => settingregistry_lib_index_js_.SettingRegistry.reconcileItems(acc, val, true), []);
            // Apply default value as last step to take into account overrides.json
            // The standard default being [] as the plugin must use `jupyter.lab.menus.context`
            // to define their default value.
            schema.properties.contextMenu.default = settingregistry_lib_index_js_.SettingRegistry.reconcileItems(pluginDefaults, schema.properties.contextMenu.default, true)
                // flatten one level
                .sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); });
        }
        // Transform the plugin object to return different schema than the default.
        registry.transform(pluginId, {
            compose: plugin => {
                var _a, _b, _c, _d;
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                const defaults = (_c = (_b = (_a = canonical.properties) === null || _a === void 0 ? void 0 : _a.contextMenu) === null || _b === void 0 ? void 0 : _b.default) !== null && _c !== void 0 ? _c : [];
                const user = {
                    ...plugin.data.user,
                    contextMenu: (_d = plugin.data.user.contextMenu) !== null && _d !== void 0 ? _d : []
                };
                const composite = {
                    ...plugin.data.composite,
                    contextMenu: settingregistry_lib_index_js_.SettingRegistry.reconcileItems(defaults, user.contextMenu, false)
                };
                plugin.data = { composite, user };
                return plugin;
            },
            fetch: plugin => {
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                return {
                    data: plugin.data,
                    id: plugin.id,
                    raw: plugin.raw,
                    schema: canonical,
                    version: plugin.version
                };
            }
        });
        // Repopulate the canonical variable after the setting registry has
        // preloaded all initial plugins.
        const settings = await registry.load(pluginId);
        // Set the suppress flag on document.body if necessary.
        const setDisabled = (settings) => {
            const root = document.body;
            const isDisabled = root.hasAttribute('data-jp-suppress-context-menu');
            const shouldDisable = settings.get('disabled').composite;
            if (isDisabled && !shouldDisable) {
                root.removeAttribute('data-jp-suppress-context-menu');
            }
            else if (shouldDisable && !isDisabled) {
                root.setAttribute('data-jp-suppress-context-menu', 'true');
            }
        };
        const contextItems = (_a = settings.composite.contextMenu) !== null && _a !== void 0 ? _a : [];
        // Create menu item for non-disabled element
        settingregistry_lib_index_js_.SettingRegistry.filterDisabledItems(contextItems).forEach(item => {
            lib_index_js_.MenuFactory.addContextItem({
                // We have to set the default rank because Lumino is sorting the visible items
                rank: DEFAULT_CONTEXT_ITEM_RANK,
                ...item
            }, contextMenu, menuFactory);
        });
        settings.changed.connect(() => {
            var _a;
            // As extension may change the context menu through API,
            // prompt the user to reload if the menu has been updated.
            const newItems = (_a = settings.composite.contextMenu) !== null && _a !== void 0 ? _a : [];
            if (!dist_index_js_.JSONExt.deepEqual(contextItems, newItems)) {
                void displayInformation(trans);
            }
            setDisabled(settings);
        });
        registry.pluginChanged.connect(async (sender, plugin) => {
            var _a, _b, _c, _d;
            if (plugin !== pluginId) {
                // If the plugin changed its menu.
                const oldItems = (_a = loaded[plugin]) !== null && _a !== void 0 ? _a : [];
                const newItems = (_c = (_b = registry.plugins[plugin].schema['jupyter.lab.menus']) === null || _b === void 0 ? void 0 : _b.context) !== null && _c !== void 0 ? _c : [];
                if (!dist_index_js_.JSONExt.deepEqual(oldItems, newItems)) {
                    if (loaded[plugin]) {
                        // The plugin has changed, request the user to reload the UI
                        await displayInformation(trans);
                    }
                    else {
                        // The plugin was not yet loaded when the menu was built => update the menu
                        loaded[plugin] = dist_index_js_.JSONExt.deepCopy(newItems);
                        // Merge potential disabled state
                        const toAdd = (_d = settingregistry_lib_index_js_.SettingRegistry.reconcileItems(newItems, contextItems, false, false)) !== null && _d !== void 0 ? _d : [];
                        settingregistry_lib_index_js_.SettingRegistry.filterDisabledItems(toAdd).forEach(item => {
                            lib_index_js_.MenuFactory.addContextItem({
                                // We have to set the default rank because Lumino is sorting the visible items
                                rank: DEFAULT_CONTEXT_ITEM_RANK,
                                ...item
                            }, contextMenu, menuFactory);
                        });
                    }
                }
            }
        });
        // Handle disabled status.
        setDisabled(settings);
        commands.addCommand(lib_CommandIDs.toggleContextMenu, {
            label: trans.__('Enable Context Menu'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isToggleable: true,
            isToggled: () => !settings.get('disabled').composite,
            execute: () => void settings.set('disabled', !settings.get('disabled').composite)
        });
    }
    Private.loadSettingsContextMenu = loadSettingsContextMenu;
    function activateSidebarSwitcher(app, labShell, settings, trans) {
        // Add a command to switch a side panels's side
        app.commands.addCommand(lib_CommandIDs.switchSidebar, {
            label: trans.__('Switch Sidebar Side'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                // First, try to find the correct panel based on the application
                // context menu click. Bail if we don't find a sidebar for the widget.
                const contextNode = app.contextMenuHitTest(node => !!node.dataset.id);
                if (!contextNode) {
                    return;
                }
                const id = contextNode.dataset['id'];
                const leftPanel = document.getElementById('jp-left-stack');
                const node = document.getElementById(id);
                let newLayout = null;
                // Move the panel to the other side.
                if (leftPanel && node && leftPanel.contains(node)) {
                    const widget = (0,index_es6_js_.find)(labShell.widgets('left'), w => w.id === id);
                    if (widget) {
                        newLayout = labShell.move(widget, 'right');
                        labShell.activateById(widget.id);
                    }
                }
                else {
                    const widget = (0,index_es6_js_.find)(labShell.widgets('right'), w => w.id === id);
                    if (widget) {
                        newLayout = labShell.move(widget, 'left');
                        labShell.activateById(widget.id);
                    }
                }
                if (newLayout) {
                    settings
                        .set('layout', {
                        single: newLayout['single-document'],
                        multiple: newLayout['multiple-document']
                    })
                        .catch(reason => {
                        console.error('Failed to save user layout customization.', reason);
                    });
                }
            }
        });
        app.commands.commandExecuted.connect((registry, executed) => {
            if (executed.id === lib_CommandIDs.resetLayout) {
                settings.remove('layout').catch(reason => {
                    console.error('Failed to remove user layout customization.', reason);
                });
            }
        });
    }
    Private.activateSidebarSwitcher = activateSidebarSwitcher;
})(lib_Private || (lib_Private = {}));
//# sourceMappingURL=index.js.map

},
73313(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(67842);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(14546);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/property-inspector/style/index.js + 1 modules
var property_inspector_style = __webpack_require__(41113);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/application-extension/style/base.css
var base = __webpack_require__(22708);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */









},
86152(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  JupyterFrontEndContextMenu: () => (/* reexport */ frontend_JupyterFrontEndContextMenu),
  LabShell: () => (/* reexport */ LabShell),
  Router: () => (/* reexport */ Router),
  IConnectionLost: () => (/* reexport */ IConnectionLost),
  LabStatus: () => (/* reexport */ lib_status/* .LabStatus */.g),
  createRendermimePlugin: () => (/* reexport */ mimerenderers/* .createRendermimePlugin */.sU),
  ConnectionLost: () => (/* reexport */ ConnectionLost),
  createSemanticCommand: () => (/* reexport */ createSemanticCommand),
  JupyterFrontEnd: () => (/* reexport */ frontend_JupyterFrontEnd),
  JupyterLab: () => (/* reexport */ lab_JupyterLab),
  ILayoutRestorer: () => (/* reexport */ layoutrestorer/* .ILayoutRestorer */.E),
  IMimeDocumentTracker: () => (/* reexport */ mimerenderers/* .IMimeDocumentTracker */.fo),
  ILabStatus: () => (/* reexport */ ILabStatus),
  addSemanticCommand: () => (/* reexport */ addSemanticCommand),
  ILabShell: () => (/* reexport */ ILabShell),
  LayoutRestorer: () => (/* reexport */ layoutrestorer/* .LayoutRestorer */.r),
  createRendermimePlugins: () => (/* reexport */ mimerenderers/* .createRendermimePlugins */.jO),
  ITreePathUpdater: () => (/* reexport */ ITreePathUpdater),
  IRouter: () => (/* reexport */ IRouter)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var index_js_ = __webpack_require__(3877);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var lib_index_js_ = __webpack_require__(53816);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/connectionlost.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * A default connection lost handler, which brings up an error dialog.
 */
const ConnectionLost = async function (manager, err, translator) {
    translator = translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    const title = trans.__('Server Connection Error');
    const networkMsg = trans.__('A connection to the Jupyter server could not be established.\n' +
        'JupyterLab will continue trying to reconnect.\n' +
        'Check your network connection or Jupyter server configuration.\n');
    if (!connectionlost_Private.displayConnectionLost) {
        return;
    }
    if (connectionlost_Private.serverConnectionLost) {
        // Wait for the pre-existing promise to complete
        await connectionlost_Private.serverConnectionLost;
        return;
    }
    const dialog = (0,index_js_.showDialog)({
        title: title,
        body: networkMsg,
        checkbox: {
            label: trans.__('Do not show this message again in this session.'),
            caption: trans.__('If checked, you will not see a dialog informing you about an issue with server connection in this session.')
        },
        buttons: [index_js_.Dialog.cancelButton({ label: trans.__('Close') })]
    })
        .then(result => {
        if (result.isChecked) {
            connectionlost_Private.displayConnectionLost = false;
        }
        return;
    })
        .catch(error => {
        console.error('An error occurred while showing the dialog: ', error);
    })
        .finally(() => {
        connectionlost_Private.serverConnectionLost = undefined;
    });
    connectionlost_Private.serverConnectionLost = dialog;
};
/**
 * The namespace for module private data.
 */
var connectionlost_Private;
(function (Private) {
    /**
     * Boolean determining if connection lost dialog is displayed.
     */
    Private.displayConnectionLost = true;
})(connectionlost_Private || (connectionlost_Private = {}));
//# sourceMappingURL=connectionlost.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/docregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/docregistry/lib/index.js)
var docregistry_lib_index_js_ = __webpack_require__(33088);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(43775);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/application@~2.4.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/application/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(41035);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(16324);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/frontend.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * The base Jupyter front-end application class.
 *
 * @typeparam `T` - The `shell` type. Defaults to `JupyterFrontEnd.IShell`.
 *
 * @typeparam `U` - The type for supported format names. Defaults to `string`.
 *
 * #### Notes
 * This type is useful as a generic application against which front-end plugins
 * can be authored. It inherits from the Lumino `Application`.
 */
class frontend_JupyterFrontEnd extends index_es6_js_.Application {
    /**
     * Construct a new JupyterFrontEnd object.
     */
    constructor(options) {
        super(options);
        this._formatChanged = new dist_index_es6_js_.Signal(this);
        // Class to scope global Jupyter CSS rules
        options.shell.addClass('jp-ThemedContainer');
        // render context menu/submenus with inline svg icon tweaks
        this.contextMenu = new ui_components_lib_index_js_.ContextMenuSvg({
            commands: this.commands,
            renderer: options.contextMenuRenderer,
            groupByTarget: false,
            sortBySelector: false
        });
        // The default restored promise if one does not exist in the options.
        const restored = new Promise(resolve => {
            requestAnimationFrame(() => {
                resolve();
            });
        });
        this.commandLinker =
            options.commandLinker || new index_js_.CommandLinker({ commands: this.commands });
        this.docRegistry = options.docRegistry || new docregistry_lib_index_js_.DocumentRegistry();
        this.restored =
            options.restored ||
                this.started.then(() => restored).catch(() => restored);
        this.serviceManager = options.serviceManager || new services_lib_index_js_.ServiceManager();
    }
    /**
     * The application form factor, e.g., `desktop` or `mobile`.
     */
    get format() {
        return this._format;
    }
    set format(format) {
        if (this._format !== format) {
            this._format = format;
            document.body.dataset['format'] = format;
            this._formatChanged.emit(format);
        }
    }
    /**
     * A signal that emits when the application form factor changes.
     */
    get formatChanged() {
        return this._formatChanged;
    }
    /**
     * Walks up the DOM hierarchy of the target of the active `contextmenu`
     * event, testing each HTMLElement ancestor for a user-supplied function. This can
     * be used to find an HTMLElement on which to operate, given a context menu click.
     *
     * @param fn - a function that takes an `HTMLElement` and returns a
     *   boolean for whether it is the element the requester is seeking.
     *
     * @returns an HTMLElement or undefined, if none is found.
     */
    contextMenuHitTest(fn) {
        if (!this._contextMenuEvent ||
            !(this._contextMenuEvent.target instanceof Node)) {
            return undefined;
        }
        let node = this._contextMenuEvent.target;
        do {
            if (node instanceof HTMLElement && fn(node)) {
                return node;
            }
            node = node.parentNode;
        } while (node && node.parentNode && node !== node.parentNode);
        return undefined;
        // TODO: we should be able to use .composedPath() to simplify this function
        // down to something like the below, but it seems like composedPath is
        // sometimes returning an empty list.
        /*
        if (this._contextMenuEvent) {
          this._contextMenuEvent
            .composedPath()
            .filter(x => x instanceof HTMLElement)
            .find(test);
        }
        return undefined;
        */
    }
    /**
     * A method invoked on a document `'contextmenu'` event.
     */
    evtContextMenu(event) {
        this._contextMenuEvent = event;
        if (event.shiftKey ||
            frontend_Private.suppressContextMenu(event.target)) {
            return;
        }
        const opened = this.contextMenu.open(event);
        if (opened) {
            const items = this.contextMenu.menu.items;
            // If only the context menu information will be shown,
            // with no real commands, close the context menu and
            // allow the native one to open.
            if (items.length === 1 &&
                items[0].command === frontend_JupyterFrontEndContextMenu.contextMenu) {
                this.contextMenu.menu.close();
                return;
            }
            // Stop propagation and allow the application context menu to show.
            event.preventDefault();
            event.stopPropagation();
        }
    }
}
/**
 * The namespace for `JupyterFrontEnd` class statics.
 */
(function (JupyterFrontEnd) {
    /**
     * Is JupyterLab in document mode?
     *
     * @param path - Full URL of JupyterLab
     * @param paths - The current IPaths object hydrated from PageConfig.
     */
    function inDocMode(path, paths) {
        const docPattern = new RegExp(`^${paths.urls.doc}`);
        const match = path.match(docPattern);
        if (match) {
            return true;
        }
        else {
            return false;
        }
    }
    JupyterFrontEnd.inDocMode = inDocMode;
    /**
     * The application paths dictionary token.
     */
    JupyterFrontEnd.IPaths = new dist_index_js_.Token('@jupyterlab/application:IPaths', `A service providing information about various
  URLs and server paths for the current application. Use this service if you want to
  assemble URLs to use the JupyterLab REST API.`);
    /**
     * The application tree resolver token.
     *
     * #### Notes
     * Not all Jupyter front-end applications will have a tree resolver
     * implemented on the client-side. This token should not be required as a
     * dependency if it is possible to make it an optional dependency.
     */
    JupyterFrontEnd.ITreeResolver = new dist_index_js_.Token('@jupyterlab/application:ITreeResolver', 'A service to resolve the tree path.');
})(frontend_JupyterFrontEnd || (frontend_JupyterFrontEnd = {}));
/**
 * A namespace for module-private functionality.
 */
var frontend_Private;
(function (Private) {
    /**
     * Returns whether the element is itself, or a child of, an element with the `jp-suppress-context-menu` data attribute.
     */
    function suppressContextMenu(element) {
        return element.closest('[data-jp-suppress-context-menu]') !== null;
    }
    Private.suppressContextMenu = suppressContextMenu;
})(frontend_Private || (frontend_Private = {}));
/**
 * A namespace for the context menu override.
 */
var frontend_JupyterFrontEndContextMenu;
(function (JupyterFrontEndContextMenu) {
    /**
     * An id for a private context-menu-info ersatz command.
     */
    JupyterFrontEndContextMenu.contextMenu = '__internal:context-menu-info';
})(frontend_JupyterFrontEndContextMenu || (frontend_JupyterFrontEndContextMenu = {}));
//# sourceMappingURL=frontend.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(3744);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/mimerenderers.js
var mimerenderers = __webpack_require__(82514);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var algorithm_dist_index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/messaging@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/messaging/dist/index.es6.js)
var messaging_dist_index_es6_js_ = __webpack_require__(1884);
// EXTERNAL MODULE: consume shared module (default) @lumino/polling@^2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/polling/dist/index.es6.js)
var polling_dist_index_es6_js_ = __webpack_require__(33206);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(34381);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/shell.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.









/**
 * The class name added to AppShell instances.
 */
const APPLICATION_SHELL_CLASS = 'jp-LabShell';
/**
 * The class name added to side bar instances.
 */
const SIDEBAR_CLASS = 'jp-SideBar';
/**
 * The class name added to the current widget's title.
 */
const CURRENT_CLASS = 'jp-mod-current';
/**
 * The class name added to the active widget's title.
 */
const ACTIVE_CLASS = 'jp-mod-active';
/**
 * The default rank of items added to a sidebar.
 */
const DEFAULT_RANK = 900;
const ACTIVITY_CLASS = 'jp-Activity';
/**
 * The JupyterLab application shell token.
 */
const ILabShell = new dist_index_js_.Token('@jupyterlab/application:ILabShell', 'A service for interacting with the JupyterLab shell. The top-level `application` object also has a reference to the shell, but it has a restricted interface in order to be agnostic to different shell implementations on the application. Use this to get more detailed information about currently active widgets and layout state.');
/**
 * The application shell for JupyterLab.
 */
class LabShell extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new application shell.
     */
    constructor(options) {
        super();
        /**
         * A message hook for child add/remove messages on the main area dock panel.
         */
        this._dockChildHook = (handler, msg) => {
            switch (msg.type) {
                case 'child-added':
                    msg.child.addClass(ACTIVITY_CLASS);
                    this._tracker.add(msg.child);
                    break;
                case 'child-removed':
                    msg.child.removeClass(ACTIVITY_CLASS);
                    this._tracker.remove(msg.child);
                    break;
                default:
                    break;
            }
            return true;
        };
        this._activeChanged = new dist_index_es6_js_.Signal(this);
        this._cachedLayout = null;
        this._currentChanged = new dist_index_es6_js_.Signal(this);
        this._currentPath = '';
        this._currentPathChanged = new dist_index_es6_js_.Signal(this);
        this._modeChanged = new dist_index_es6_js_.Signal(this);
        this._isRestored = false;
        this._layoutModified = new dist_index_es6_js_.Signal(this);
        this._layoutDebouncer = new polling_dist_index_es6_js_.Debouncer(() => {
            this._layoutModified.emit(undefined);
        }, 0);
        this._restored = new dist_index_js_.PromiseDelegate();
        this._tracker = new widgets_dist_index_es6_js_.FocusTracker();
        this._topHandlerHiddenByUser = false;
        this._idTypeMap = new Map();
        this._mainOptionsCache = new Map();
        this._sideOptionsCache = new Map();
        this._delayedWidget = new Array();
        this.addClass(APPLICATION_SHELL_CLASS);
        this.id = 'main';
        if ((options === null || options === void 0 ? void 0 : options.waitForRestore) === false) {
            this._userLayout = { 'multiple-document': {}, 'single-document': {} };
        }
        // Skip Links
        const skipLinkWidget = (this._skipLinkWidget = new shell_Private.SkipLinkWidget(this));
        this._skipLinkWidget.show();
        //  Wrap the skip widget to customize its position and size
        const skipLinkWrapper = new widgets_dist_index_es6_js_.Panel();
        skipLinkWrapper.addClass('jp-skiplink-wrapper');
        skipLinkWrapper.addWidget(skipLinkWidget);
        const headerPanel = (this._headerPanel = new widgets_dist_index_es6_js_.BoxPanel());
        const menuHandler = (this._menuHandler = new shell_Private.PanelHandler());
        menuHandler.panel.node.setAttribute('role', 'navigation');
        const topHandler = (this._topHandler = new shell_Private.PanelHandler());
        topHandler.panel.node.setAttribute('role', 'banner');
        const bottomPanel = (this._bottomPanel = new widgets_dist_index_es6_js_.BoxPanel());
        bottomPanel.node.setAttribute('role', 'contentinfo');
        const hboxPanel = new widgets_dist_index_es6_js_.BoxPanel();
        const vsplitPanel = (this._vsplitPanel =
            new shell_Private.RestorableSplitPanel());
        const dockPanel = (this._dockPanel = new ui_components_lib_index_js_.DockPanelSvg({
            hiddenMode: widgets_dist_index_es6_js_.Widget.HiddenMode.Display
        }));
        messaging_dist_index_es6_js_.MessageLoop.installMessageHook(dockPanel, this._dockChildHook);
        const hsplitPanel = (this._hsplitPanel =
            new shell_Private.RestorableSplitPanel());
        const downPanel = (this._downPanel = new ui_components_lib_index_js_.TabPanelSvg({
            tabsMovable: true
        }));
        const leftHandler = (this._leftHandler = new shell_Private.SideBarHandler());
        const rightHandler = (this._rightHandler = new shell_Private.SideBarHandler());
        const rootLayout = new widgets_dist_index_es6_js_.BoxLayout();
        headerPanel.id = 'jp-header-panel';
        menuHandler.panel.id = 'jp-menu-panel';
        topHandler.panel.id = 'jp-top-panel';
        bottomPanel.id = 'jp-bottom-panel';
        hboxPanel.id = 'jp-main-content-panel';
        vsplitPanel.id = 'jp-main-vsplit-panel';
        dockPanel.id = 'jp-main-dock-panel';
        hsplitPanel.id = 'jp-main-split-panel';
        downPanel.id = 'jp-down-stack';
        leftHandler.sideBar.addClass(SIDEBAR_CLASS);
        leftHandler.sideBar.addClass('jp-mod-left');
        leftHandler.sideBar.node.setAttribute('role', 'complementary');
        leftHandler.stackedPanel.id = 'jp-left-stack';
        rightHandler.sideBar.addClass(SIDEBAR_CLASS);
        rightHandler.sideBar.addClass('jp-mod-right');
        rightHandler.sideBar.node.setAttribute('role', 'complementary');
        rightHandler.stackedPanel.id = 'jp-right-stack';
        dockPanel.node.setAttribute('role', 'main');
        hboxPanel.spacing = 0;
        vsplitPanel.spacing = 1;
        dockPanel.spacing = 5;
        hsplitPanel.spacing = 1;
        headerPanel.direction = 'top-to-bottom';
        vsplitPanel.orientation = 'vertical';
        hboxPanel.direction = 'left-to-right';
        hsplitPanel.orientation = 'horizontal';
        bottomPanel.direction = 'bottom-to-top';
        widgets_dist_index_es6_js_.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(downPanel, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(dockPanel, 1);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(leftHandler.sideBar, 0);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(hsplitPanel, 1);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(rightHandler.sideBar, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(vsplitPanel, 1);
        hsplitPanel.addWidget(leftHandler.stackedPanel);
        hsplitPanel.addWidget(dockPanel);
        hsplitPanel.addWidget(rightHandler.stackedPanel);
        vsplitPanel.addWidget(hsplitPanel);
        vsplitPanel.addWidget(downPanel);
        hboxPanel.addWidget(leftHandler.sideBar);
        hboxPanel.addWidget(vsplitPanel);
        hboxPanel.addWidget(rightHandler.sideBar);
        rootLayout.direction = 'top-to-bottom';
        rootLayout.spacing = 0; // TODO make this configurable?
        // Use relative sizing to set the width of the side panels.
        // This will still respect the min-size of children widget in the stacked
        // panel. The default sizes will be overwritten during layout restoration.
        vsplitPanel.setRelativeSizes([3, 1]);
        hsplitPanel.setRelativeSizes([1, 2.5, 1]);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(headerPanel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(menuHandler.panel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(topHandler.panel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(hboxPanel, 1);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(bottomPanel, 0);
        rootLayout.addWidget(skipLinkWrapper);
        rootLayout.addWidget(headerPanel);
        rootLayout.addWidget(topHandler.panel);
        rootLayout.addWidget(hboxPanel);
        rootLayout.addWidget(bottomPanel);
        // initially hiding header and bottom panel when no elements inside,
        this._headerPanel.hide();
        this._bottomPanel.hide();
        this._downPanel.hide();
        this.layout = rootLayout;
        // Connect change listeners.
        this._tracker.currentChanged.connect(this._onCurrentChanged, this);
        this._tracker.activeChanged.connect(this._onActiveChanged, this);
        // Connect main layout change listener.
        this._dockPanel.layoutModified.connect(this._onLayoutModified, this);
        // Connect vsplit layout change listener
        this._vsplitPanel.updated.connect(this._onLayoutModified, this);
        // Connect down panel change listeners
        this._downPanel.currentChanged.connect(this._onLayoutModified, this);
        this._downPanel.tabBar.tabMoved.connect(this._onTabPanelChanged, this);
        this._downPanel.stackedPanel.widgetRemoved.connect(this._onTabPanelChanged, this);
        // Catch current changed events on the side handlers.
        this._leftHandler.updated.connect(this._onLayoutModified, this);
        this._rightHandler.updated.connect(this._onLayoutModified, this);
        // Catch update events on the horizontal split panel
        this._hsplitPanel.updated.connect(this._onLayoutModified, this);
        // Setup single-document-mode title bar
        const titleHandler = (this._titleHandler = new shell_Private.TitleHandler(this));
        this.add(titleHandler, 'top', { rank: 100 });
        if (this._dockPanel.mode === 'multiple-document') {
            this._topHandler.addWidget(this._menuHandler.panel, 100);
            titleHandler.hide();
        }
        else {
            rootLayout.insertWidget(3, this._menuHandler.panel);
        }
        this.translator = lib_index_js_.nullTranslator;
        // Wire up signals to update the title panel of the simple interface mode to
        // follow the title of this.currentWidget
        this.currentChanged.connect((sender, args) => {
            let newValue = args.newValue;
            let oldValue = args.oldValue;
            // Stop watching the title of the previously current widget
            if (oldValue) {
                oldValue.title.changed.disconnect(this._updateTitlePanelTitle, this);
                if (oldValue instanceof docregistry_lib_index_js_.DocumentWidget) {
                    oldValue.context.pathChanged.disconnect(this._updateCurrentPath, this);
                }
            }
            // Start watching the title of the new current widget
            if (newValue) {
                newValue.title.changed.connect(this._updateTitlePanelTitle, this);
                this._updateTitlePanelTitle();
                if (newValue instanceof docregistry_lib_index_js_.DocumentWidget) {
                    newValue.context.pathChanged.connect(this._updateCurrentPath, this);
                }
            }
            this._updateCurrentPath();
        });
    }
    /**
     * A signal emitted when main area's active focus changes.
     */
    get activeChanged() {
        return this._activeChanged;
    }
    /**
     * The active widget in the shell's main area.
     */
    get activeWidget() {
        return this._tracker.activeWidget;
    }
    /**
     * Whether the add buttons for each main area tab bar are enabled.
     */
    get addButtonEnabled() {
        return this._dockPanel.addButtonEnabled;
    }
    set addButtonEnabled(value) {
        this._dockPanel.addButtonEnabled = value;
    }
    /**
     * A signal emitted when the add button on a main area tab bar is clicked.
     */
    get addRequested() {
        return this._dockPanel.addRequested;
    }
    /**
     * A signal emitted when main area's current focus changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * Current document path.
     */
    // FIXME deprecation `undefined` is to ensure backward compatibility in 4.x
    get currentPath() {
        return this._currentPath;
    }
    /**
     * A signal emitted when the path of the current document changes.
     *
     * This also fires when the current document itself changes.
     */
    get currentPathChanged() {
        return this._currentPathChanged;
    }
    /**
     * The current widget in the shell's main area.
     */
    get currentWidget() {
        return this._tracker.currentWidget;
    }
    /**
     * A signal emitted when the main area's layout is modified.
     */
    get layoutModified() {
        return this._layoutModified;
    }
    /**
     * Whether the left area is collapsed.
     */
    get leftCollapsed() {
        return !this._leftHandler.sideBar.currentTitle;
    }
    /**
     * Whether the left area is collapsed.
     */
    get rightCollapsed() {
        return !this._rightHandler.sideBar.currentTitle;
    }
    /**
     * Whether JupyterLab is in presentation mode with the
     * `jp-mod-presentationMode` CSS class.
     */
    get presentationMode() {
        return this.hasClass('jp-mod-presentationMode');
    }
    set presentationMode(value) {
        this.toggleClass('jp-mod-presentationMode', value);
    }
    /**
     * The main dock area's user interface mode.
     */
    get mode() {
        return this._dockPanel.mode;
    }
    set mode(mode) {
        const dock = this._dockPanel;
        if (mode === dock.mode) {
            return;
        }
        const applicationCurrentWidget = this.currentWidget;
        if (mode === 'single-document') {
            // Cache the current multi-document layout before changing the mode.
            this._cachedLayout = dock.saveLayout();
            dock.mode = mode;
            // In case the active widget in the dock panel is *not* the active widget
            // of the application, defer to the application.
            if (this.currentWidget) {
                dock.activateWidget(this.currentWidget);
            }
            // Adjust menu and title
            this.layout.insertWidget(3, this._menuHandler.panel);
            this._titleHandler.show();
            this._updateTitlePanelTitle();
            if (this._topHandlerHiddenByUser) {
                this._topHandler.panel.hide();
            }
        }
        else {
            // Cache a reference to every widget currently in the dock panel before
            // changing its mode.
            const widgets = Array.from(dock.widgets());
            dock.mode = mode;
            // Restore cached layout if possible.
            if (this._cachedLayout) {
                // Remove any disposed widgets in the cached layout and restore.
                shell_Private.normalizeAreaConfig(dock, this._cachedLayout.main);
                dock.restoreLayout(this._cachedLayout);
                this._cachedLayout = null;
            }
            // If layout restoration has been deferred, restore layout now.
            if (this._layoutRestorer.isDeferred) {
                this._layoutRestorer
                    .restoreDeferred()
                    .then(mainArea => {
                    if (mainArea) {
                        const { currentWidget, dock } = mainArea;
                        if (dock) {
                            this._dockPanel.restoreLayout(dock);
                        }
                        if (currentWidget) {
                            this.activateById(currentWidget.id);
                        }
                    }
                })
                    .catch(reason => {
                    console.error('Failed to restore the deferred layout.');
                    console.error(reason);
                });
            }
            // Add any widgets created during single document mode, which have
            // subsequently been removed from the dock panel after the multiple document
            // layout has been restored. If the widget has add options cached for
            // the widget (i.e., if it has been placed with respect to another widget),
            // then take that into account.
            widgets.forEach(widget => {
                if (!widget.parent) {
                    this._addToMainArea(widget, {
                        ...this._mainOptionsCache.get(widget),
                        activate: false
                    });
                }
            });
            this._mainOptionsCache.clear();
            // In case the active widget in the dock panel is *not* the active widget
            // of the application, defer to the application.
            if (applicationCurrentWidget) {
                dock.activateWidget(applicationCurrentWidget);
            }
            // Adjust menu and title
            this.add(this._menuHandler.panel, 'top', { rank: 100 });
            this._titleHandler.hide();
        }
        // Set the mode data attribute on the applications shell node.
        this.node.dataset.shellMode = mode;
        this._downPanel.fit();
        // Emit the mode changed signal
        this._modeChanged.emit(mode);
    }
    /**
     * A signal emitted when the shell/dock panel change modes (single/multiple document).
     */
    get modeChanged() {
        return this._modeChanged;
    }
    /**
     * Promise that resolves when state is first restored, returning layout
     * description.
     */
    get restored() {
        return this._restored.promise;
    }
    get translator() {
        var _a;
        return (_a = this._translator) !== null && _a !== void 0 ? _a : lib_index_js_.nullTranslator;
    }
    set translator(value) {
        if (value !== this._translator) {
            this._translator = value;
            // Set translator for tab bars
            ui_components_lib_index_js_.TabBarSvg.translator = value;
            const trans = value.load('jupyterlab');
            this._menuHandler.panel.node.setAttribute('aria-label', trans.__('main menu'));
            this._leftHandler.sideBar.node.setAttribute('aria-label', trans.__('main sidebar'));
            this._leftHandler.sideBar.contentNode.setAttribute('aria-label', trans.__('main sidebar'));
            this._rightHandler.sideBar.node.setAttribute('aria-label', trans.__('alternate sidebar'));
            this._rightHandler.sideBar.contentNode.setAttribute('aria-label', trans.__('alternate sidebar'));
            this._topHandler.panel.node.setAttribute('aria-label', trans.__('Top Bar'));
            this._bottomPanel.node.setAttribute('aria-label', trans.__('Bottom Panel'));
            this._dockPanel.node.setAttribute('aria-label', trans.__('Main Content'));
        }
    }
    /**
     * User customized shell layout.
     */
    get userLayout() {
        return dist_index_js_.JSONExt.deepCopy(this._userLayout);
    }
    /**
     * Activate a widget in its area.
     */
    activateById(id) {
        if (this._leftHandler.has(id)) {
            this._leftHandler.activate(id);
            return;
        }
        if (this._rightHandler.has(id)) {
            this._rightHandler.activate(id);
            return;
        }
        const tabIndex = this._downPanel.tabBar.titles.findIndex(title => title.owner.id === id);
        if (tabIndex >= 0) {
            this._downPanel.currentIndex = tabIndex;
            return;
        }
        const dock = this._dockPanel;
        const widget = (0,algorithm_dist_index_es6_js_.find)(dock.widgets(), value => value.id === id);
        if (widget) {
            dock.activateWidget(widget);
        }
    }
    /**
     * Activate widget in specified area.
     *
     * ### Notes
     * The alpha version of this method only supports activating the "main" area.
     *
     * @alpha
     * @param area Name of area to activate
     */
    activateArea(area = 'main') {
        switch (area) {
            case 'main':
                {
                    const current = this._currentTabBar();
                    if (!current) {
                        return;
                    }
                    if (current.currentTitle) {
                        current.currentTitle.owner.activate();
                    }
                }
                return;
            case 'left':
            case 'right':
            case 'header':
            case 'top':
            case 'menu':
            case 'bottom':
                console.debug(`Area: ${area} activation not yet implemented`);
                break;
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Activate the next Tab in the active TabBar.
     */
    activateNextTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci < current.titles.length - 1) {
            current.currentIndex += 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === current.titles.length - 1) {
            const nextBar = this._adjacentBar('next');
            if (nextBar) {
                nextBar.currentIndex = 0;
                if (nextBar.currentTitle) {
                    nextBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /**
     * Activate the previous Tab in the active TabBar.
     */
    activatePreviousTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci > 0) {
            current.currentIndex -= 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === 0) {
            const prevBar = this._adjacentBar('previous');
            if (prevBar) {
                const len = prevBar.titles.length;
                prevBar.currentIndex = len - 1;
                if (prevBar.currentTitle) {
                    prevBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /**
     * Activate the next TabBar.
     */
    activateNextTabBar() {
        const nextBar = this._adjacentBar('next');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    /**
     * Activate the next TabBar.
     */
    activatePreviousTabBar() {
        const nextBar = this._adjacentBar('previous');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    /**
     * Add a widget to the JupyterLab shell
     *
     * @param widget Widget
     * @param area Area
     * @param options Options
     */
    add(widget, area = 'main', options) {
        var _a;
        if (!this._userLayout) {
            this._delayedWidget.push({ widget, area, options });
            return;
        }
        let userPosition;
        if ((options === null || options === void 0 ? void 0 : options.type) && this._userLayout[this.mode][options.type]) {
            userPosition = this._userLayout[this.mode][options.type];
            this._idTypeMap.set(widget.id, options.type);
        }
        else {
            userPosition = this._userLayout[this.mode][widget.id];
        }
        if (options === null || options === void 0 ? void 0 : options.type) {
            this._idTypeMap.set(widget.id, options.type);
            widget.disposed.connect(() => {
                this._idTypeMap.delete(widget.id);
            });
        }
        area = (_a = userPosition === null || userPosition === void 0 ? void 0 : userPosition.area) !== null && _a !== void 0 ? _a : area;
        options =
            options || (userPosition === null || userPosition === void 0 ? void 0 : userPosition.options)
                ? {
                    ...options,
                    ...userPosition === null || userPosition === void 0 ? void 0 : userPosition.options
                }
                : undefined;
        switch (area || 'main') {
            case 'bottom':
                return this._addToBottomArea(widget, options);
            case 'down':
                return this._addToDownArea(widget, options);
            case 'header':
                return this._addToHeaderArea(widget, options);
            case 'left':
                return this._addToLeftArea(widget, options);
            case 'main':
                return this._addToMainArea(widget, options);
            case 'menu':
                return this._addToMenuArea(widget, options);
            case 'right':
                return this._addToRightArea(widget, options);
            case 'top':
                return this._addToTopArea(widget, options);
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Move a widget type to a new area.
     *
     * The type is determined from the `widget.id` and fallback to `widget.id`.
     *
     * #### Notes
     * If `mode` is undefined, both mode are updated.
     * The new layout is now persisted.
     *
     * @param widget Widget to move
     * @param area New area
     * @param mode Mode to change
     * @returns The new user layout
     */
    move(widget, area, mode) {
        var _a;
        const type = (_a = this._idTypeMap.get(widget.id)) !== null && _a !== void 0 ? _a : widget.id;
        for (const m of ['single-document', 'multiple-document'].filter(c => !mode || c === mode)) {
            this._userLayout[m][type] = {
                ...this._userLayout[m][type],
                area
            };
        }
        this.add(widget, area);
        return this._userLayout;
    }
    /**
     * Collapse the left area.
     */
    collapseLeft() {
        this._leftHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Collapse the right area.
     */
    collapseRight() {
        this._rightHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Dispose the shell.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._layoutDebouncer.dispose();
        super.dispose();
    }
    /**
     * Expand the left area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandLeft() {
        this._leftHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Expand the right area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandRight() {
        this._rightHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Close all widgets in the main and down area.
     */
    closeAll() {
        // Make a copy of all the widget in the dock panel (using `Array.from()`)
        // before removing them because removing them while iterating through them
        // modifies the underlying data of the iterator.
        Array.from(this._dockPanel.widgets()).forEach(widget => widget.close());
        this._downPanel.stackedPanel.widgets.forEach(widget => widget.close());
    }
    /**
     * Whether an side tab bar is visible or not.
     *
     * @param side Sidebar of interest
     * @returns Side tab bar visibility
     */
    isSideTabBarVisible(side) {
        switch (side) {
            case 'left':
                return this._leftHandler.isVisible;
            case 'right':
                return this._rightHandler.isVisible;
        }
    }
    /**
     * Whether the top bar in simple mode is visible or not.
     *
     * @returns Top bar visibility
     */
    isTopInSimpleModeVisible() {
        return !this._topHandlerHiddenByUser;
    }
    /**
     * True if the given area is empty.
     */
    isEmpty(area) {
        switch (area) {
            case 'bottom':
                return this._bottomPanel.widgets.length === 0;
            case 'down':
                return this._downPanel.stackedPanel.widgets.length === 0;
            case 'header':
                return this._headerPanel.widgets.length === 0;
            case 'left':
                return this._leftHandler.stackedPanel.widgets.length === 0;
            case 'main':
                return this._dockPanel.isEmpty;
            case 'menu':
                return this._menuHandler.panel.widgets.length === 0;
            case 'right':
                return this._rightHandler.stackedPanel.widgets.length === 0;
            case 'top':
                return this._topHandler.panel.widgets.length === 0;
            default:
                return true;
        }
    }
    /**
     * Restore the layout state and configuration for the application shell.
     *
     * #### Notes
     * This should only be called once.
     */
    async restoreLayout(mode, layoutRestorer, configuration = {}) {
        var _a, _b, _c, _d;
        // Set the configuration and add widgets added before the shell was ready.
        this._userLayout = {
            'single-document': (_a = configuration['single-document']) !== null && _a !== void 0 ? _a : {},
            'multiple-document': (_b = configuration['multiple-document']) !== null && _b !== void 0 ? _b : {}
        };
        this._delayedWidget.forEach(({ widget, area, options }) => {
            this.add(widget, area, options);
        });
        this._delayedWidget.length = 0;
        this._layoutRestorer = layoutRestorer;
        // Get the layout from the restorer
        const layout = await layoutRestorer.fetch();
        // Reset the layout
        const { mainArea, downArea, leftArea, rightArea, topArea, relativeSizes } = layout;
        // Rehydrate the main area.
        if (mainArea) {
            const { currentWidget, dock } = mainArea;
            if (dock && mode === 'multiple-document') {
                this._dockPanel.restoreLayout(dock);
            }
            if (mode) {
                this.mode = mode;
            }
            if (currentWidget) {
                this.activateById(currentWidget.id);
            }
        }
        else {
            // This is needed when loading in an empty workspace in single doc mode
            if (mode) {
                this.mode = mode;
            }
        }
        if ((topArea === null || topArea === void 0 ? void 0 : topArea.simpleVisibility) !== undefined) {
            this._topHandlerHiddenByUser = !topArea.simpleVisibility;
            if (this.mode === 'single-document') {
                this._topHandler.panel.setHidden(this._topHandlerHiddenByUser);
            }
        }
        // Rehydrate the down area
        if (downArea) {
            const { currentWidget, widgets, size } = downArea;
            const widgetIds = (_c = widgets === null || widgets === void 0 ? void 0 : widgets.map(widget => widget.id)) !== null && _c !== void 0 ? _c : [];
            // Remove absent widgets
            this._downPanel.tabBar.titles
                .filter(title => !widgetIds.includes(title.owner.id))
                .map(title => title.owner.close());
            // Add new widgets
            const titleIds = this._downPanel.tabBar.titles.map(title => title.owner.id);
            widgets === null || widgets === void 0 ? void 0 : widgets.filter(widget => !titleIds.includes(widget.id)).map(widget => this._downPanel.addWidget(widget));
            // Reorder tabs
            while (!algorithm_dist_index_es6_js_.ArrayExt.shallowEqual(widgetIds, this._downPanel.tabBar.titles.map(title => title.owner.id))) {
                this._downPanel.tabBar.titles.forEach((title, index) => {
                    const position = widgetIds.findIndex(id => title.owner.id == id);
                    if (position >= 0 && position != index) {
                        this._downPanel.tabBar.insertTab(position, title);
                    }
                });
            }
            if (currentWidget) {
                const index = this._downPanel.stackedPanel.widgets.findIndex(widget => widget.id === currentWidget.id);
                if (index) {
                    this._downPanel.currentIndex = index;
                    (_d = this._downPanel.currentWidget) === null || _d === void 0 ? void 0 : _d.activate();
                }
            }
            if (size && size > 0.0) {
                this._vsplitPanel.setRelativeSizes([1.0 - size, size]);
            }
            else {
                // Close all tabs and hide the panel
                this._downPanel.stackedPanel.widgets.forEach(widget => widget.close());
                this._downPanel.hide();
            }
        }
        // Rehydrate the left area.
        if (leftArea) {
            this._leftHandler.rehydrate(leftArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseLeft();
            }
        }
        // Rehydrate the right area.
        if (rightArea) {
            this._rightHandler.rehydrate(rightArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseRight();
            }
        }
        // Restore the relative sizes.
        if (relativeSizes) {
            this._hsplitPanel.setRelativeSizes(relativeSizes);
        }
        if (!this._isRestored) {
            // Make sure all messages in the queue are finished before notifying
            // any extensions that are waiting for the promise that guarantees the
            // application state has been restored.
            messaging_dist_index_es6_js_.MessageLoop.flush();
            this._restored.resolve(layout);
        }
    }
    /**
     * Save the dehydrated state of the application shell.
     */
    saveLayout() {
        // If the application is in single document mode, use the cached layout if
        // available. Otherwise, default to querying the dock panel for layout.
        const layout = {
            mainArea: {
                currentWidget: this._tracker.currentWidget,
                dock: this.mode === 'single-document'
                    ? this._cachedLayout || this._dockPanel.saveLayout()
                    : this._dockPanel.saveLayout()
            },
            downArea: {
                currentWidget: this._downPanel.currentWidget,
                widgets: Array.from(this._downPanel.stackedPanel.widgets),
                size: this._vsplitPanel.relativeSizes()[1]
            },
            leftArea: this._leftHandler.dehydrate(),
            rightArea: this._rightHandler.dehydrate(),
            topArea: { simpleVisibility: !this._topHandlerHiddenByUser },
            relativeSizes: this._hsplitPanel.relativeSizes()
        };
        return layout;
    }
    /**
     * Toggle top header visibility in simple mode
     *
     * Note: Does nothing in multi-document mode
     */
    toggleTopInSimpleModeVisibility() {
        if (this.mode === 'single-document') {
            if (this._topHandler.panel.isVisible) {
                this._topHandlerHiddenByUser = true;
                this._topHandler.panel.hide();
            }
            else {
                this._topHandlerHiddenByUser = false;
                this._topHandler.panel.show();
                this._updateTitlePanelTitle();
            }
            this._onLayoutModified();
        }
    }
    /**
     * Toggle side tab bar visibility
     *
     * @param side Sidebar of interest
     */
    toggleSideTabBarVisibility(side) {
        if (side === 'right') {
            if (this._rightHandler.isVisible) {
                this._rightHandler.hide();
            }
            else {
                this._rightHandler.show();
            }
        }
        else {
            if (this._leftHandler.isVisible) {
                this._leftHandler.hide();
            }
            else {
                this._leftHandler.show();
            }
        }
    }
    /**
     * Update the shell configuration.
     *
     * @param config Shell configuration
     */
    updateConfig(config) {
        if (config.hiddenMode) {
            switch (config.hiddenMode) {
                case 'display':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.Display;
                    break;
                case 'scale':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.Scale;
                    break;
                case 'contentVisibility':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.ContentVisibility;
                    break;
            }
        }
    }
    /**
     * Returns the widgets for an application area.
     */
    widgets(area) {
        switch (area !== null && area !== void 0 ? area : 'main') {
            case 'main':
                return this._dockPanel.widgets();
            case 'left':
                return (0,algorithm_dist_index_es6_js_.map)(this._leftHandler.sideBar.titles, t => t.owner);
            case 'right':
                return (0,algorithm_dist_index_es6_js_.map)(this._rightHandler.sideBar.titles, t => t.owner);
            case 'header':
                return this._headerPanel.children();
            case 'top':
                return this._topHandler.panel.children();
            case 'menu':
                return this._menuHandler.panel.children();
            case 'bottom':
                return this._bottomPanel.children();
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Handle `after-attach` messages for the application shell.
     */
    onAfterAttach(msg) {
        this.node.dataset.shellMode = this.mode;
    }
    /**
     * Update the title panel title based on the title of the current widget.
     */
    _updateTitlePanelTitle() {
        let current = this.currentWidget;
        const inputElement = this._titleHandler.inputElement;
        inputElement.value = current ? current.title.label : '';
        inputElement.title = current ? current.title.caption : '';
    }
    /**
     * The path of the current widget changed, fire the _currentPathChanged signal.
     */
    _updateCurrentPath() {
        let current = this.currentWidget;
        let newValue = '';
        if (current && current instanceof docregistry_lib_index_js_.DocumentWidget) {
            newValue = current.context.path;
        }
        this._currentPathChanged.emit({
            newValue: newValue,
            oldValue: this._currentPath
        });
        this._currentPath = newValue;
    }
    /**
     * Add a widget to the left content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToLeftArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        this._sideOptionsCache.set(widget, options);
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._leftHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the main content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     * All widgets added to the main area should be disposed after removal
     * (disposal before removal will remove the widget automatically).
     *
     * In the options, `ref` defaults to `null`, `mode` defaults to `'tab-after'`,
     * and `activate` defaults to `true`.
     */
    _addToMainArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const dock = this._dockPanel;
        const mode = options.mode || 'tab-after';
        let ref = this.currentWidget;
        if (options.ref) {
            ref = (0,algorithm_dist_index_es6_js_.find)(dock.widgets(), value => value.id === options.ref) || null;
        }
        const { title } = widget;
        // Add widget ID to tab so that we can get a handle on the tab's widget
        // (for context menu support)
        title.dataset = { ...title.dataset, id: widget.id };
        if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
            // bind an appropriate style to the icon
            title.icon = title.icon.bindprops({
                stylesheet: 'mainAreaTab'
            });
        }
        else if (typeof title.icon === 'string' || !title.icon) {
            // add some classes to help with displaying css background imgs
            title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon');
        }
        dock.addWidget(widget, { mode, ref });
        // The dock panel doesn't account for placement information while
        // in single document mode, so upon rehydrating any widgets that were
        // added will not be in the correct place. Cache the placement information
        // here so that we can later rehydrate correctly.
        if (dock.mode === 'single-document') {
            this._mainOptionsCache.set(widget, options);
        }
        if (options.activate !== false) {
            dock.activateWidget(widget);
        }
    }
    /**
     * Add a widget to the right content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToRightArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._sideOptionsCache.set(widget, options);
        this._rightHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the top content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToTopArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._topHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._topHandler.panel.isHidden) {
            this._topHandler.panel.show();
        }
    }
    /**
     * Add a widget to the title content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToMenuArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._menuHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._menuHandler.panel.isHidden) {
            this._menuHandler.panel.show();
        }
    }
    /**
     * Add a widget to the header content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToHeaderArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._headerPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._headerPanel.isHidden) {
            this._headerPanel.show();
        }
    }
    /**
     * Add a widget to the bottom content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToBottomArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._bottomPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._bottomPanel.isHidden) {
            this._bottomPanel.show();
        }
    }
    _addToDownArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const { title } = widget;
        // Add widget ID to tab so that we can get a handle on the tab's widget
        // (for context menu support)
        title.dataset = { ...title.dataset, id: widget.id };
        if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
            // bind an appropriate style to the icon
            title.icon = title.icon.bindprops({
                stylesheet: 'mainAreaTab'
            });
        }
        else if (typeof title.icon === 'string' || !title.icon) {
            // add some classes to help with displaying css background imgs
            title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon');
        }
        this._downPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._downPanel.isHidden) {
            this._downPanel.show();
        }
    }
    /*
     * Return the tab bar adjacent to the current TabBar or `null`.
     */
    _adjacentBar(direction) {
        const current = this._currentTabBar();
        if (!current) {
            return null;
        }
        const bars = Array.from(this._dockPanel.tabBars());
        const len = bars.length;
        const index = bars.indexOf(current);
        if (direction === 'previous') {
            return index > 0 ? bars[index - 1] : index === 0 ? bars[len - 1] : null;
        }
        // Otherwise, direction is 'next'.
        return index < len - 1
            ? bars[index + 1]
            : index === len - 1
                ? bars[0]
                : null;
    }
    /*
     * Return the TabBar that has the currently active Widget or null.
     */
    _currentTabBar() {
        const current = this._tracker.currentWidget;
        if (!current) {
            return null;
        }
        const title = current.title;
        const bars = this._dockPanel.tabBars();
        return (0,algorithm_dist_index_es6_js_.find)(bars, bar => bar.titles.indexOf(title) > -1) || null;
    }
    /**
     * Handle a change to the dock area active widget.
     */
    _onActiveChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${ACTIVE_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(ACTIVE_CLASS, '');
        }
        this._activeChanged.emit(args);
    }
    /**
     * Handle a change to the dock area current widget.
     */
    _onCurrentChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${CURRENT_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(CURRENT_CLASS, '');
        }
        this._currentChanged.emit(args);
        this._onLayoutModified();
    }
    /**
     * Handle a change on the down panel widgets
     */
    _onTabPanelChanged() {
        if (this._downPanel.stackedPanel.widgets.length === 0) {
            this._downPanel.hide();
        }
        this._onLayoutModified();
    }
    /**
     * Handle a change to the layout.
     */
    _onLayoutModified() {
        void this._layoutDebouncer.invoke();
    }
}
var shell_Private;
(function (Private) {
    /**
     * A less-than comparison function for side bar rank items.
     */
    function itemCmp(first, second) {
        return first.rank - second.rank;
    }
    Private.itemCmp = itemCmp;
    /**
     * Removes widgets that have been disposed from an area config, mutates area.
     */
    function normalizeAreaConfig(parent, area) {
        if (!area) {
            return;
        }
        if (area.type === 'tab-area') {
            area.widgets = area.widgets.filter(widget => !widget.isDisposed && widget.parent === parent);
            return;
        }
        area.children.forEach(child => {
            normalizeAreaConfig(parent, child);
        });
    }
    Private.normalizeAreaConfig = normalizeAreaConfig;
    /**
     * A class which manages a panel and sorts its widgets by rank.
     */
    class PanelHandler {
        constructor() {
            /**
             * A message hook for child add/remove messages on the main area dock panel.
             */
            this._panelChildHook = (handler, msg) => {
                switch (msg.type) {
                    case 'child-added':
                        {
                            const widget = msg.child;
                            // If we already know about this widget, we're done
                            if (this._items.find(v => v.widget === widget)) {
                                break;
                            }
                            // Otherwise, add to the end by default
                            const rank = this._items[this._items.length - 1].rank;
                            this._items.push({ widget, rank });
                        }
                        break;
                    case 'child-removed':
                        {
                            const widget = msg.child;
                            algorithm_dist_index_es6_js_.ArrayExt.removeFirstWhere(this._items, v => v.widget === widget);
                        }
                        break;
                    default:
                        break;
                }
                return true;
            };
            this._items = new Array();
            this._panel = new widgets_dist_index_es6_js_.Panel();
            messaging_dist_index_es6_js_.MessageLoop.installMessageHook(this._panel, this._panelChildHook);
        }
        /**
         * Get the panel managed by the handler.
         */
        get panel() {
            return this._panel;
        }
        /**
         * Add a widget to the panel.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            widget.parent = null;
            const item = { widget, rank };
            const index = algorithm_dist_index_es6_js_.ArrayExt.upperBound(this._items, item, Private.itemCmp);
            algorithm_dist_index_es6_js_.ArrayExt.insert(this._items, index, item);
            this._panel.insertWidget(index, widget);
        }
    }
    Private.PanelHandler = PanelHandler;
    /**
     * A class which manages a side bar and related stacked panel.
     */
    class SideBarHandler {
        /**
         * Construct a new side bar handler.
         */
        constructor() {
            this._isHiddenByUser = false;
            this._items = new Array();
            this._updated = new dist_index_es6_js_.Signal(this);
            this._sideBar = new widgets_dist_index_es6_js_.TabBar({
                insertBehavior: 'none',
                removeBehavior: 'none',
                allowDeselect: true,
                orientation: 'vertical'
            });
            this._stackedPanel = new widgets_dist_index_es6_js_.StackedPanel();
            this._sideBar.hide();
            this._stackedPanel.hide();
            this._lastCurrent = null;
            this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
            this._sideBar.tabActivateRequested.connect(this._onTabActivateRequested, this);
            this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
        }
        /**
         * Whether the side bar is visible
         */
        get isVisible() {
            return this._sideBar.isVisible;
        }
        /**
         * Get the tab bar managed by the handler.
         */
        get sideBar() {
            return this._sideBar;
        }
        /**
         * Get the stacked panel managed by the handler
         */
        get stackedPanel() {
            return this._stackedPanel;
        }
        /**
         * Signal fires when the stack panel or the sidebar changes
         */
        get updated() {
            return this._updated;
        }
        /**
         * Handles a movement to the handles of a widget
         */
        _onHandleMoved() {
            return this._refreshVisibility();
        }
        /**
         * Handles changes to the expansion status of a widget
         */
        _onExpansionToggle(sender, index) {
            return this._refreshVisibility();
        }
        /**
         * Expand the sidebar.
         *
         * #### Notes
         * This will open the most recently used tab, or the first tab
         * if there is no most recently used.
         */
        expand() {
            const previous = this._lastCurrent || (this._items.length > 0 && this._items[0].widget);
            if (previous) {
                this.activate(previous.id);
            }
        }
        /**
         * Activate a widget residing in the side bar by ID.
         *
         * @param id - The widget's unique ID.
         */
        activate(id) {
            const widget = this._findWidgetByID(id);
            if (widget) {
                this._sideBar.currentTitle = widget.title;
                widget.activate();
            }
        }
        /**
         * Test whether the sidebar has the given widget by id.
         */
        has(id) {
            return this._findWidgetByID(id) !== null;
        }
        /**
         * Collapse the sidebar so no items are expanded.
         */
        collapse() {
            this._sideBar.currentTitle = null;
        }
        /**
         * Add a widget and its title to the stacked panel and side bar.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            var _a, _b, _c, _d;
            widget.parent = null;
            widget.hide();
            const item = { widget, rank };
            const index = this._findInsertIndex(item);
            algorithm_dist_index_es6_js_.ArrayExt.insert(this._items, index, item);
            this._stackedPanel.insertWidget(index, widget);
            const title = this._sideBar.insertTab(index, widget.title);
            // Store the parent id in the title dataset
            // in order to dispatch click events to the right widget.
            title.dataset = { id: widget.id };
            if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
                // bind an appropriate style to the icon
                title.icon = title.icon.bindprops({
                    stylesheet: 'sideBar'
                });
            }
            else if (typeof title.icon === 'string' && title.icon != '') {
                // add some classes to help with displaying css background imgs
                title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon', 'jp-Icon-20');
            }
            else if (!title.icon && !title.label) {
                // add a fallback icon if there is no title label nor icon
                title.icon = ui_components_lib_index_js_.tabIcon.bindprops({
                    stylesheet: 'sideBar'
                });
            }
            // @ts-expect-error sometimes widget is an Accordion Panel
            (_b = (_a = widget.content) === null || _a === void 0 ? void 0 : _a.expansionToggled) === null || _b === void 0 ? void 0 : _b.connect(this._onExpansionToggle, this);
            // @ts-expect-error sometimes widget is a SidePanel
            (_d = (_c = widget.content) === null || _c === void 0 ? void 0 : _c.handleMoved) === null || _d === void 0 ? void 0 : _d.connect(this._onHandleMoved, this);
            this._refreshVisibility();
        }
        /**
         * Dehydrate the side bar data.
         */
        dehydrate() {
            const collapsed = this._sideBar.currentTitle === null;
            const widgets = Array.from(this._stackedPanel.widgets);
            const currentWidget = widgets[this._sideBar.currentIndex];
            const widgetStates = {};
            this._stackedPanel.widgets.forEach((w) => {
                if (w.id && w.content instanceof widgets_dist_index_es6_js_.SplitPanel) {
                    widgetStates[w.id] = {
                        sizes: w.content.relativeSizes(),
                        expansionStates: w.content.widgets.map(wi => wi.isVisible)
                    };
                }
            });
            return {
                collapsed,
                currentWidget,
                visible: !this._isHiddenByUser,
                widgets,
                widgetStates
            };
        }
        /**
         * Rehydrate the side bar.
         */
        rehydrate(data) {
            if (data.currentWidget) {
                this.activate(data.currentWidget.id);
            }
            if (data.collapsed) {
                this.collapse();
            }
            if (!data.visible) {
                this.hide();
            }
            if (data.widgetStates) {
                this._stackedPanel.widgets.forEach((w) => {
                    var _a;
                    if (w.id && w.content instanceof widgets_dist_index_es6_js_.SplitPanel) {
                        const state = (_a = data.widgetStates[w.id]) !== null && _a !== void 0 ? _a : {};
                        w.content.widgets.forEach((wi, widx) => {
                            var _a;
                            const expansion = ((_a = state.expansionStates) !== null && _a !== void 0 ? _a : [])[widx];
                            if (typeof expansion === 'boolean' &&
                                w.content instanceof widgets_dist_index_es6_js_.AccordionPanel) {
                                expansion ? w.content.expand(widx) : w.content.collapse(widx);
                            }
                        });
                        if (state.sizes) {
                            w.content.setRelativeSizes(state.sizes);
                        }
                    }
                });
            }
        }
        /**
         * Hide the side bar even if it contains widgets
         */
        hide() {
            this._isHiddenByUser = true;
            this._refreshVisibility();
        }
        /**
         * Show the side bar if it contains widgets
         */
        show() {
            this._isHiddenByUser = false;
            this._refreshVisibility();
        }
        /**
         * Find the insertion index for a rank item.
         */
        _findInsertIndex(item) {
            return algorithm_dist_index_es6_js_.ArrayExt.upperBound(this._items, item, Private.itemCmp);
        }
        /**
         * Find the index of the item with the given widget, or `-1`.
         */
        _findWidgetIndex(widget) {
            return algorithm_dist_index_es6_js_.ArrayExt.findFirstIndex(this._items, i => i.widget === widget);
        }
        /**
         * Find the widget which owns the given title, or `null`.
         */
        _findWidgetByTitle(title) {
            const item = (0,algorithm_dist_index_es6_js_.find)(this._items, value => value.widget.title === title);
            return item ? item.widget : null;
        }
        /**
         * Find the widget with the given id, or `null`.
         */
        _findWidgetByID(id) {
            const item = (0,algorithm_dist_index_es6_js_.find)(this._items, value => value.widget.id === id);
            return item ? item.widget : null;
        }
        /**
         * Refresh the visibility of the side bar and stacked panel.
         */
        _refreshVisibility() {
            this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
            this._sideBar.setHidden(this._isHiddenByUser || this._sideBar.titles.length === 0);
            this._updated.emit();
        }
        /**
         * Handle the `currentChanged` signal from the sidebar.
         */
        _onCurrentChanged(sender, args) {
            const oldWidget = args.previousTitle
                ? this._findWidgetByTitle(args.previousTitle)
                : null;
            const newWidget = args.currentTitle
                ? this._findWidgetByTitle(args.currentTitle)
                : null;
            if (oldWidget) {
                oldWidget.hide();
            }
            if (newWidget) {
                newWidget.show();
            }
            this._lastCurrent = newWidget || oldWidget;
            this._refreshVisibility();
        }
        /**
         * Handle a `tabActivateRequest` signal from the sidebar.
         */
        _onTabActivateRequested(sender, args) {
            args.title.owner.activate();
        }
        /*
         * Handle the `widgetRemoved` signal from the stacked panel.
         */
        _onWidgetRemoved(sender, widget) {
            if (widget === this._lastCurrent) {
                this._lastCurrent = null;
            }
            algorithm_dist_index_es6_js_.ArrayExt.removeAt(this._items, this._findWidgetIndex(widget));
            this._sideBar.removeTab(widget.title);
            this._refreshVisibility();
        }
    }
    Private.SideBarHandler = SideBarHandler;
    class SkipLinkWidget extends widgets_dist_index_es6_js_.Widget {
        /**
         * Construct a new skipLink widget.
         */
        constructor(shell) {
            super();
            this.addClass('jp-skiplink');
            this.id = 'jp-skiplink';
            this._shell = shell;
            this._createSkipLink('Skip to main panel', 'main');
        }
        handleEvent(event) {
            var _a, _b;
            switch (event.type) {
                case 'click':
                    if (event.target instanceof HTMLElement) {
                        this._shell.activateArea((_b = (_a = event.target) === null || _a === void 0 ? void 0 : _a.dataset) === null || _b === void 0 ? void 0 : _b.targetarea);
                    }
                    break;
            }
        }
        /**
         * Handle `after-attach` messages for the widget.
         */
        onAfterAttach(msg) {
            super.onAfterAttach(msg);
            this.node.addEventListener('click', this);
        }
        /**
         * A message handler invoked on a `'before-detach'`
         * message
         */
        onBeforeDetach(msg) {
            this.node.removeEventListener('click', this);
            super.onBeforeDetach(msg);
        }
        _createSkipLink(skipLinkText, area) {
            const skipLink = document.createElement('a');
            skipLink.href = '#';
            skipLink.tabIndex = 0;
            skipLink.text = skipLinkText;
            skipLink.className = 'skip-link';
            skipLink.dataset['targetarea'] = area;
            this.node.appendChild(skipLink);
        }
    }
    Private.SkipLinkWidget = SkipLinkWidget;
    class TitleHandler extends widgets_dist_index_es6_js_.Widget {
        /**
         * Construct a new title handler.
         */
        constructor(shell) {
            super();
            this._selected = false;
            const inputElement = document.createElement('input');
            inputElement.type = 'text';
            this.node.appendChild(inputElement);
            this._shell = shell;
            this.id = 'jp-title-panel-title';
        }
        /**
         * Handle `after-attach` messages for the widget.
         */
        onAfterAttach(msg) {
            super.onAfterAttach(msg);
            this.inputElement.addEventListener('keyup', this);
            this.inputElement.addEventListener('click', this);
            this.inputElement.addEventListener('blur', this);
        }
        /**
         * Handle `before-detach` messages for the widget.
         */
        onBeforeDetach(msg) {
            super.onBeforeDetach(msg);
            this.inputElement.removeEventListener('keyup', this);
            this.inputElement.removeEventListener('click', this);
            this.inputElement.removeEventListener('blur', this);
        }
        handleEvent(event) {
            switch (event.type) {
                case 'keyup':
                    void this._evtKeyUp(event);
                    break;
                case 'click':
                    this._evtClick(event);
                    break;
                case 'blur':
                    this._selected = false;
                    break;
            }
        }
        /**
         * Handle `keyup` events on the handler.
         */
        async _evtKeyUp(event) {
            if (event.key == 'Enter') {
                const widget = this._shell.currentWidget;
                if (widget == null) {
                    return;
                }
                const oldName = widget.title.label;
                const inputElement = this.inputElement;
                const newName = inputElement.value;
                inputElement.blur();
                if (newName !== oldName) {
                    widget.title.label = newName;
                }
                else {
                    inputElement.value = oldName;
                }
            }
        }
        /**
         * Handle `click` events on the handler.
         */
        _evtClick(event) {
            // only handle primary button clicks
            if (event.button !== 0 || this._selected) {
                return;
            }
            const inputElement = this.inputElement;
            event.preventDefault();
            event.stopPropagation();
            this._selected = true;
            const selectEnd = inputElement.value.indexOf('.');
            if (selectEnd === -1) {
                inputElement.select();
            }
            else {
                inputElement.setSelectionRange(0, selectEnd);
            }
        }
        /**
         * The input element containing the parent widget's title.
         */
        get inputElement() {
            return this.node.children[0];
        }
    }
    Private.TitleHandler = TitleHandler;
    class RestorableSplitPanel extends widgets_dist_index_es6_js_.SplitPanel {
        /**
         * Construct a new RestorableSplitPanel.
         */
        constructor(options = {}) {
            super(options);
            this._updated = new dist_index_es6_js_.Signal(this);
        }
        /**
         * A signal emitted when the split panel is updated.
         */
        get updated() {
            return this._updated;
        }
        /**
         * Emit 'updated' signal on 'update' requests.
         */
        onUpdateRequest(msg) {
            super.onUpdateRequest(msg);
            this._updated.emit();
        }
    }
    Private.RestorableSplitPanel = RestorableSplitPanel;
})(shell_Private || (shell_Private = {}));
//# sourceMappingURL=shell.js.map
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/status.js
var lib_status = __webpack_require__(3922);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/lab.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * JupyterLab is the main application class. It is instantiated once and shared.
 */
class lab_JupyterLab extends frontend_JupyterFrontEnd {
    /**
     * Construct a new JupyterLab object.
     */
    constructor(options = { shell: new LabShell() }) {
        super({
            ...options,
            shell: options.shell || new LabShell(),
            serviceManager: options.serviceManager ||
                new services_lib_index_js_.ServiceManager({
                    standby: () => {
                        return !this._info.isConnected || 'when-hidden';
                    }
                })
        });
        /**
         * The name of the JupyterLab application.
         */
        this.name = coreutils_lib_index_js_.PageConfig.getOption('appName') || 'JupyterLab';
        /**
         * A namespace/prefix plugins may use to denote their provenance.
         */
        this.namespace = coreutils_lib_index_js_.PageConfig.getOption('appNamespace') || this.name;
        /**
         * A list of all errors encountered when registering plugins.
         *
         * @deprecated This is unused and may be removed in a future version.
         */
        this.registerPluginErrors = [];
        /**
         * The application busy and dirty status signals and flags.
         */
        this.status = new lib_status/* .LabStatus */.g(this);
        /**
         * The version of the JupyterLab application.
         */
        this.version = coreutils_lib_index_js_.PageConfig.getOption('appVersion') || 'unknown';
        this._allPluginsActivated = new dist_index_js_.PromiseDelegate();
        // Populate application info.
        this._info = new lab_JupyterLab.Info(options);
        this.restored = this.shell.restored
            .then(async () => {
            const activated = [];
            const deferred = this.activateDeferredPlugins().catch(error => {
                console.error('Error when activating deferred plugins\n:', error);
            });
            activated.push(deferred);
            if (this._info.deferred) {
                const customizedDeferred = Promise.all(this._info.deferred.matches.map(pluginID => this.activatePlugin(pluginID))).catch(error => {
                    console.error('Error when activating customized list of deferred plugins:\n', error);
                });
                activated.push(customizedDeferred);
            }
            Promise.all(activated)
                .then(() => {
                this._allPluginsActivated.resolve();
            })
                .catch(() => undefined);
        })
            .catch(() => undefined);
        // Populate application paths override the defaults if necessary.
        const defaultURLs = lab_JupyterLab.defaultPaths.urls;
        const defaultDirs = lab_JupyterLab.defaultPaths.directories;
        const optionURLs = (options.paths && options.paths.urls) || {};
        const optionDirs = (options.paths && options.paths.directories) || {};
        this._paths = {
            urls: Object.keys(defaultURLs).reduce((acc, key) => {
                if (key in optionURLs) {
                    const value = optionURLs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultURLs[key];
                }
                return acc;
            }, {}),
            directories: Object.keys(lab_JupyterLab.defaultPaths.directories).reduce((acc, key) => {
                if (key in optionDirs) {
                    const value = optionDirs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultDirs[key];
                }
                return acc;
            }, {})
        };
        if (this._info.devMode) {
            this.shell.addClass('jp-mod-devMode');
        }
        // Add initial model factory.
        this.docRegistry.addModelFactory(new docregistry_lib_index_js_.Base64ModelFactory());
        if (options.mimeExtensions) {
            for (const plugin of (0,mimerenderers/* .createRendermimePlugins */.jO)(options.mimeExtensions)) {
                this.registerPlugin(plugin);
            }
        }
    }
    /**
     * The JupyterLab application information dictionary.
     */
    get info() {
        return this._info;
    }
    /**
     * The JupyterLab application paths dictionary.
     */
    get paths() {
        return this._paths;
    }
    /**
     * Promise that resolves when all the plugins are activated, including the deferred.
     */
    get allPluginsActivated() {
        return this._allPluginsActivated.promise;
    }
    /**
     * Register plugins from a plugin module.
     *
     * @param mod - The plugin module to register.
     *
     * @deprecated This is unused and may be removed in a future version.
     */
    registerPluginModule(mod) {
        let data = mod.default;
        // Handle commonjs exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            try {
                this.registerPlugin(item);
            }
            catch (error) {
                this.registerPluginErrors.push(error);
            }
        });
    }
    /**
     * Register the plugins from multiple plugin modules.
     *
     * @param mods - The plugin modules to register.
     *
     * @deprecated This is unused and may be removed in a future version.
     */
    registerPluginModules(mods) {
        mods.forEach(mod => {
            this.registerPluginModule(mod);
        });
    }
    /**
     * Override keydown handling to prevent command shortcuts from preventing user input.
     *
     * This introduces a slight delay to the command invocation, but no delay to user input.
     */
    evtKeydown(keyDownEvent) {
        const permissionToExecute = new dist_index_js_.PromiseDelegate();
        // Hold the execution of any keybinding until we know if this event would cause text insertion
        this.commands.holdKeyBindingExecution(keyDownEvent, permissionToExecute.promise);
        // Process the key immediately to invoke the prevent default handlers as needed
        this.commands.processKeydownEvent(keyDownEvent);
        // If we do not know the target, we cannot check if input would be inserted
        // as there is no target to attach the `beforeinput` event listener; in that
        // case we just permit execution immediately (this may happen for programmatic
        // uses of keydown)
        const target = keyDownEvent.target;
        if (!target) {
            return permissionToExecute.resolve(true);
        }
        let onBeforeInput = null;
        let onBeforeKeyUp = null;
        const disconnectListeners = () => {
            if (onBeforeInput) {
                target.removeEventListener('beforeinput', onBeforeInput);
            }
            if (onBeforeKeyUp) {
                target.removeEventListener('keyup', onBeforeKeyUp);
            }
        };
        // Permit the execution conditionally, depending on whether the event would lead to text insertion
        const causesInputPromise = Promise.race([
            new Promise(resolve => {
                onBeforeInput = (inputEvent) => {
                    switch (inputEvent.inputType) {
                        case 'historyUndo':
                        case 'historyRedo': {
                            if (inputEvent.target instanceof Element &&
                                inputEvent.target.closest('[data-jp-undoer]')) {
                                // Allow to use custom undo/redo bindings on `jpUndoer`s
                                inputEvent.preventDefault();
                                disconnectListeners();
                                return resolve(false);
                            }
                            break;
                        }
                        case 'insertLineBreak': {
                            if (inputEvent.target instanceof Element &&
                                inputEvent.target.closest('.jp-Cell')) {
                                // Allow to override the default action of Shift + Enter on cells as this is used for cell execution
                                inputEvent.preventDefault();
                                disconnectListeners();
                                return resolve(false);
                            }
                            break;
                        }
                    }
                    disconnectListeners();
                    return resolve(true);
                };
                target.addEventListener('beforeinput', onBeforeInput, { once: true });
            }),
            new Promise(resolve => {
                onBeforeKeyUp = (keyUpEvent) => {
                    if (keyUpEvent.code === keyDownEvent.code) {
                        disconnectListeners();
                        return resolve(false);
                    }
                };
                target.addEventListener('keyup', onBeforeKeyUp, { once: true });
            }),
            new Promise(resolve => {
                setTimeout(() => {
                    disconnectListeners();
                    return resolve(false);
                }, lab_Private.INPUT_GUARD_TIMEOUT);
            })
        ]);
        causesInputPromise
            .then(willCauseInput => {
            permissionToExecute.resolve(!willCauseInput);
        })
            .catch(console.warn);
    }
}
/**
 * The namespace for `JupyterLab` class statics.
 */
(function (JupyterLab) {
    /**
     * The application info token.
     */
    JupyterLab.IInfo = new dist_index_js_.Token('@jupyterlab/application:IInfo', 'A service providing metadata about the current application, including disabled extensions and whether dev mode is enabled.');
    /**
     * The information about a JupyterLab application.
     */
    class Info {
        constructor({ connectionStatus, ...options } = {}) {
            var _a, _b, _c, _d, _e, _f, _g;
            this._connectionStatus = connectionStatus !== null && connectionStatus !== void 0 ? connectionStatus : new services_lib_index_js_.ConnectionStatus();
            this._availablePlugins =
                (_a = options.availablePlugins) !== null && _a !== void 0 ? _a : JupyterLab.defaultInfo.availablePlugins;
            this._devMode = (_b = options.devMode) !== null && _b !== void 0 ? _b : JupyterLab.defaultInfo.devMode;
            this._deferred = JSON.parse(JSON.stringify((_c = options.deferred) !== null && _c !== void 0 ? _c : JupyterLab.defaultInfo.deferred));
            this._disabled = JSON.parse(JSON.stringify((_d = options.disabled) !== null && _d !== void 0 ? _d : JupyterLab.defaultInfo.disabled));
            this._filesCached =
                (_e = options.filesCached) !== null && _e !== void 0 ? _e : JupyterLab.defaultInfo.filesCached;
            this._mimeExtensions = JSON.parse(JSON.stringify((_f = options.mimeExtensions) !== null && _f !== void 0 ? _f : JupyterLab.defaultInfo.mimeExtensions));
            this.isConnected =
                (_g = options.isConnected) !== null && _g !== void 0 ? _g : JupyterLab.defaultInfo.isConnected;
        }
        /**
         * The information about available plugins.
         */
        get availablePlugins() {
            return this._availablePlugins;
        }
        /**
         * Whether the application is in dev mode.
         */
        get devMode() {
            return this._devMode;
        }
        /**
         * The collection of deferred extension patterns and matched extensions.
         */
        get deferred() {
            return this._deferred;
        }
        /**
         * The collection of disabled extension patterns and matched extensions.
         */
        get disabled() {
            return this._disabled;
        }
        /**
         * Whether files are cached on the server.
         */
        get filesCached() {
            return this._filesCached;
        }
        /**
         * Every periodic network polling should be paused while this is set
         * to `false`. Extensions should use this value to decide whether to proceed
         * with the polling.
         * The extensions may also set this value to `false` if there is no need to
         * fetch anything from the server backend basing on some conditions
         * (e.g. when an error message dialog is displayed).
         * At the same time, the extensions are responsible for setting this value
         * back to `true`.
         */
        get isConnected() {
            return this._connectionStatus.isConnected;
        }
        set isConnected(v) {
            this._connectionStatus.isConnected = v;
        }
        /**
         * The mime renderer extensions.
         */
        get mimeExtensions() {
            return this._mimeExtensions;
        }
    }
    JupyterLab.Info = Info;
    /**
     * The default JupyterLab application info.
     */
    JupyterLab.defaultInfo = {
        devMode: coreutils_lib_index_js_.PageConfig.getOption('devMode').toLowerCase() === 'true',
        deferred: { patterns: [], matches: [] },
        disabled: { patterns: [], matches: [] },
        mimeExtensions: [],
        availablePlugins: [],
        filesCached: coreutils_lib_index_js_.PageConfig.getOption('cacheFiles').toLowerCase() === 'true',
        isConnected: true
    };
    /**
     * The default JupyterLab application paths.
     */
    JupyterLab.defaultPaths = {
        urls: {
            base: coreutils_lib_index_js_.PageConfig.getOption('baseUrl'),
            notFound: coreutils_lib_index_js_.PageConfig.getOption('notFoundUrl'),
            app: coreutils_lib_index_js_.PageConfig.getOption('appUrl'),
            doc: coreutils_lib_index_js_.PageConfig.getOption('docUrl'),
            static: coreutils_lib_index_js_.PageConfig.getOption('staticUrl'),
            settings: coreutils_lib_index_js_.PageConfig.getOption('settingsUrl'),
            themes: coreutils_lib_index_js_.PageConfig.getOption('themesUrl'),
            translations: coreutils_lib_index_js_.PageConfig.getOption('translationsApiUrl'),
            hubHost: coreutils_lib_index_js_.PageConfig.getOption('hubHost') || undefined,
            hubPrefix: coreutils_lib_index_js_.PageConfig.getOption('hubPrefix') || undefined,
            hubUser: coreutils_lib_index_js_.PageConfig.getOption('hubUser') || undefined,
            hubServerName: coreutils_lib_index_js_.PageConfig.getOption('hubServerName') || undefined
        },
        directories: {
            appSettings: coreutils_lib_index_js_.PageConfig.getOption('appSettingsDir'),
            schemas: coreutils_lib_index_js_.PageConfig.getOption('schemasDir'),
            static: coreutils_lib_index_js_.PageConfig.getOption('staticDir'),
            templates: coreutils_lib_index_js_.PageConfig.getOption('templatesDir'),
            themes: coreutils_lib_index_js_.PageConfig.getOption('themesDir'),
            userSettings: coreutils_lib_index_js_.PageConfig.getOption('userSettingsDir'),
            serverRoot: coreutils_lib_index_js_.PageConfig.getOption('serverRoot'),
            workspaces: coreutils_lib_index_js_.PageConfig.getOption('workspacesDir')
        }
    };
})(lab_JupyterLab || (lab_JupyterLab = {}));
/**
 * A namespace for module-private functionality.
 */
var lab_Private;
(function (Private) {
    /**
     * The delay for invoking a command introduced by user input guard.
     * Decreasing this value may lead to commands incorrectly triggering
     * on user input. Increasing this value will lead to longer delay for
     * command invocation. Note that user input is never delayed.
     *
     * The value represents the number in milliseconds.
     */
    Private.INPUT_GUARD_TIMEOUT = 10;
})(lab_Private || (lab_Private = {}));
//# sourceMappingURL=lab.js.map
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/layoutrestorer.js
var layoutrestorer = __webpack_require__(8186);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(42574);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/router.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/




/**
 * A static class that routes URLs within the application.
 */
class Router {
    /**
     * Create a URL router.
     */
    constructor(options) {
        /**
         * If a matching rule's command resolves with the `stop` token during routing,
         * no further matches will execute.
         */
        this.stop = new dist_index_js_.Token('@jupyterlab/application:Router#stop');
        this._routed = new dist_index_es6_js_.Signal(this);
        this._rules = new Map();
        this.base = options.base;
        this.commands = options.commands;
    }
    /**
     * Returns the parsed current URL of the application.
     */
    get current() {
        var _a, _b;
        const { base } = this;
        const parsed = coreutils_lib_index_js_.URLExt.parse(window.location.href);
        const { search, hash } = parsed;
        const path = (_b = (_a = parsed.pathname) === null || _a === void 0 ? void 0 : _a.replace(base, '/')) !== null && _b !== void 0 ? _b : '';
        const request = path + search + hash;
        return { hash, path, request, search };
    }
    /**
     * A signal emitted when the router routes a route.
     */
    get routed() {
        return this._routed;
    }
    /**
     * Navigate to a new path within the application.
     *
     * @param path - The new path or empty string if redirecting to root.
     *
     * @param options - The navigation options.
     */
    navigate(path, options = {}) {
        const { base } = this;
        const { history } = window;
        const { hard } = options;
        const old = document.location.href;
        const url = path && path.indexOf(base) === 0 ? path : coreutils_lib_index_js_.URLExt.join(base, path);
        if (url === old) {
            return hard ? this.reload() : undefined;
        }
        history.pushState({}, '', url);
        if (hard) {
            return this.reload();
        }
        if (!options.skipRouting) {
            // Because a `route()` call may still be in the stack after having received
            // a `stop` token, wait for the next stack frame before calling `route()`.
            requestAnimationFrame(() => {
                void this.route();
            });
        }
    }
    /**
     * Register to route a path pattern to a command.
     *
     * @param options - The route registration options.
     *
     * @returns A disposable that removes the registered rule from the router.
     */
    register(options) {
        var _a;
        const { command, pattern } = options;
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : 100;
        const rules = this._rules;
        rules.set(pattern, { command, rank });
        return new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            rules.delete(pattern);
        });
    }
    /**
     * Cause a hard reload of the document.
     */
    reload() {
        window.location.reload();
    }
    /**
     * Route a specific path to an action.
     *
     * #### Notes
     * If a pattern is matched, its command will be invoked with arguments that
     * match the `IRouter.ILocation` interface.
     */
    route() {
        const { commands, current, stop } = this;
        const { request } = current;
        const routed = this._routed;
        const rules = this._rules;
        const matches = [];
        // Collect all rules that match the URL.
        rules.forEach((rule, pattern) => {
            if (request === null || request === void 0 ? void 0 : request.match(pattern)) {
                matches.push(rule);
            }
        });
        // Order the matching rules by rank and enqueue them.
        const queue = matches.sort((a, b) => b.rank - a.rank);
        const done = new dist_index_js_.PromiseDelegate();
        // Process each enqueued command sequentially and short-circuit if a promise
        // resolves with the `stop` token.
        const next = async () => {
            if (!queue.length) {
                routed.emit(current);
                done.resolve(undefined);
                return;
            }
            const { command } = queue.pop();
            try {
                const request = this.current.request;
                const result = await commands.execute(command, current);
                if (result === stop) {
                    queue.length = 0;
                    console.debug(`Routing ${request} was short-circuited by ${command}`);
                }
            }
            catch (reason) {
                console.warn(`Routing ${request} to ${command} failed`, reason);
            }
            void next();
        };
        void next();
        return done.promise;
    }
}
//# sourceMappingURL=router.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/tokens.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A token for which a plugin can provide to respond to connection failures
 * to the application server.
 */
const IConnectionLost = new dist_index_js_.Token('@jupyterlab/application:IConnectionLost', `A service for invoking the dialog shown
  when JupyterLab has lost its connection to the server. Use this if, for some reason,
  you want to bring up the "connection lost" dialog under new circumstances.`);
/**
 * The application status token.
 */
const ILabStatus = new dist_index_js_.Token('@jupyterlab/application:ILabStatus', `A service for interacting with the application busy/dirty
  status. Use this if you want to set the application "busy" favicon, or to set
  the application "dirty" status, which asks the user for confirmation before leaving the application page.`);
/**
 * The URL Router token.
 */
const IRouter = new dist_index_js_.Token('@jupyterlab/application:IRouter', 'The URL router used by the application. Use this to add custom URL-routing for your extension (e.g., to invoke a command if the user navigates to a sub-path).');
//# sourceMappingURL=tokens.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/treepathupdater.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The tree path updater token.
 */
const ITreePathUpdater = new dist_index_js_.Token('@jupyterlab/application:ITreePathUpdater', 'A service to update the tree path.');
//# sourceMappingURL=treepathupdater.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/utils.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Add a semantic commands to the application and take care
 * of setting up the command changed signal.
 *
 * @param options Semantic command options
 */
function addSemanticCommand(options) {
    const { id, commands, shell, semanticCommands, default: defaultValues, overrides, trans } = options;
    commands.addCommand(id, {
        ...createSemanticCommand({ commands, shell }, semanticCommands, defaultValues !== null && defaultValues !== void 0 ? defaultValues : {}, trans !== null && trans !== void 0 ? trans : lib_index_js_.nullTranslator.load('jupyterlab')),
        ...overrides
    });
    const commandList = Array.isArray(semanticCommands)
        ? semanticCommands
        : [semanticCommands];
    const onCommandChanged = (commands, args) => {
        if (args.id) {
            if (args.id === id && args.type === 'removed') {
                commands.commandChanged.disconnect(onCommandChanged);
            }
            else {
                const commandIds = commandList.reduce((agg, cmd) => agg.concat(cmd.ids), []);
                if (commandIds.includes(args.id)) {
                    // eslint-disable-next-line @typescript-eslint/switch-exhaustiveness-check
                    switch (args.type) {
                        case 'changed':
                        case 'many-changed':
                            commands.notifyCommandChanged(id);
                            break;
                        case 'removed':
                            for (const cmd of commandList) {
                                cmd.remove(args.id);
                            }
                            break;
                    }
                }
            }
        }
    };
    commands.commandChanged.connect(onCommandChanged);
}
/**
 * Create the command options from the given semantic commands list
 * and the given default values.
 *
 * @param app Jupyter Application
 * @param semanticCommands Single semantic command  or a list of commands
 * @param defaultValues Default values
 * @param trans Translation bundle
 * @returns Command options
 *
 * @deprecated Please use {@link addSemanticCommand}. This function will
 * be removed of the public API in JupyterLab 5.
 */
function createSemanticCommand(app, semanticCommands, defaultValues, trans) {
    const { commands, shell } = app;
    const commandList = Array.isArray(semanticCommands)
        ? semanticCommands
        : [semanticCommands];
    return {
        label: concatenateTexts('label'),
        caption: concatenateTexts('caption'),
        isEnabled: () => {
            var _a;
            const isEnabled = reduceAttribute('isEnabled');
            return ((isEnabled.length > 0 &&
                !isEnabled.some(enabled => enabled === false)) ||
                ((_a = defaultValues.isEnabled) !== null && _a !== void 0 ? _a : false));
        },
        isToggled: () => {
            var _a;
            const isToggled = reduceAttribute('isToggled');
            return (isToggled.some(enabled => enabled === true) ||
                ((_a = defaultValues.isToggled) !== null && _a !== void 0 ? _a : false));
        },
        isVisible: () => {
            var _a;
            const isVisible = reduceAttribute('isVisible');
            return ((isVisible.length > 0 &&
                !isVisible.some(visible => visible === false)) ||
                ((_a = defaultValues.isVisible) !== null && _a !== void 0 ? _a : true));
        },
        execute: async () => {
            const widget = shell.currentWidget;
            const commandIds = commandList.map(cmd => widget !== null ? cmd.getActiveCommandId(widget) : null);
            const toExecute = commandIds.filter(commandId => commandId !== null && commands.isEnabled(commandId));
            let result = null;
            if (toExecute.length > 0) {
                for (const commandId of toExecute) {
                    const args = { [index_js_.SemanticCommand.WIDGET]: widget.id };
                    result = await commands.execute(commandId, args);
                    if (typeof result === 'boolean' && result === false) {
                        // If a command returns a boolean, assume it is the execution success status
                        // So break if it is false.
                        break;
                    }
                }
            }
            else if (defaultValues.execute) {
                result = await commands.execute(defaultValues.execute);
            }
            return result;
        }
    };
    function reduceAttribute(attribute) {
        const widget = shell.currentWidget;
        const commandIds = commandList.map(cmd => widget !== null ? cmd.getActiveCommandId(widget) : null);
        const attributes = commandIds
            .filter(commandId => commandId !== null)
            .map(commandId => commands[attribute](commandId));
        return attributes;
    }
    function concatenateTexts(attribute) {
        return () => {
            var _a;
            const texts = reduceAttribute(attribute).map((text, textIndex) => attribute == 'caption' && textIndex > 0
                ? text.toLocaleLowerCase()
                : text);
            switch (texts.length) {
                case 0:
                    return (_a = defaultValues[attribute]) !== null && _a !== void 0 ? _a : '';
                case 1:
                    return texts[0];
                default: {
                    const hasEllipsis = texts.some(l => /…$/.test(l));
                    const main = texts
                        .slice(undefined, -1)
                        .map(l => l.replace(/…$/, ''))
                        .join(', ');
                    const end = texts.slice(-1)[0].replace(/…$/, '') + (hasEllipsis ? '…' : '');
                    return trans.__('%1 and %2', main, end);
                }
            }
        };
    }
}
//# sourceMappingURL=utils.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module application
 */











//# sourceMappingURL=index.js.map

},
8186(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
__webpack_require__.d(__webpack_exports__, {
  E: () => (ILayoutRestorer),
  r: () => (LayoutRestorer)
});
/* import */ var _lumino_coreutils__rspack_import_0 = __webpack_require__(83044);
/* import */ var _lumino_coreutils__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__rspack_import_0);
/* import */ var _lumino_properties__rspack_import_1 = __webpack_require__(98818);
/* import */ var _lumino_properties__rspack_import_1_default = /*#__PURE__*/__webpack_require__.n(_lumino_properties__rspack_import_1);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * The layout restorer token.
 */
const ILayoutRestorer = new _lumino_coreutils__rspack_import_0.Token('@jupyterlab/application:ILayoutRestorer', 'A service providing application layout restoration functionality. Use this to have your activities restored across page loads.');
/**
 * The data connector key for restorer data.
 */
const KEY = 'layout-restorer:data';
/**
 * The default implementation of a layout restorer.
 *
 * #### Notes
 * The lifecycle for state restoration is subtle. The sequence of events is:
 *
 * 1. The layout restorer plugin is instantiated and makes a `fetch` call to
 *    the data connector that stores the layout restoration data. The `fetch`
 *    call returns a promise that resolves in step 6, below.
 *
 * 2. Other plugins that care about state restoration require the layout
 *    restorer as a dependency.
 *
 * 3. As each load-time plugin initializes (which happens before the front-end
 *    application has `started`), it instructs the layout restorer whether
 *    the restorer ought to `restore` its widgets by passing in its widget
 *    tracker.
 *    Alternatively, a plugin that does not require its own widget tracker
 *    (because perhaps it only creates a single widget, like a command palette),
 *    can simply `add` its widget along with a persistent unique name to the
 *    layout restorer so that its layout state can be restored when the lab
 *    application restores.
 *
 * 4. After all the load-time plugins have finished initializing, the front-end
 *    application `started` promise will resolve. This is the `first`
 *    promise that the layout restorer waits for. By this point, all of the
 *    plugins that care about restoration will have instructed the layout
 *    restorer to `restore` their widget trackers.
 *
 * 5. The layout restorer will then instruct each plugin's widget tracker
 *    to restore its state and reinstantiate whichever widgets it wants. The
 *    tracker returns a promise to the layout restorer that resolves when it
 *    has completed restoring the tracked widgets it cares about.
 *
 * 6. As each widget tracker finishes restoring the widget instances it cares
 *    about, it resolves the promise that was returned to the layout restorer
 *    (in step 5). After all of the promises that the restorer is awaiting have
 *    settled, the restorer then resolves the outstanding `fetch` promise
 *    (from step 1) and hands off a layout state object to the application
 *    shell's `restoreLayout` method for restoration.
 *
 * 7. Once the application shell has finished restoring the layout, the
 *    JupyterLab application's `restored` promise is resolved.
 *
 * Of particular note are steps 5 and 6: since data restoration of plugins
 * is accomplished by executing commands, the command that is used to restore
 * the data of each plugin must return a promise that only resolves when the
 * widget has been created and added to the plugin's widget tracker.
 */
class LayoutRestorer {
    /**
     * Create a layout restorer.
     */
    constructor(options) {
        this._deferred = new Array();
        this._deferredMainArea = null;
        this._firstDone = false;
        this._promisesDone = false;
        this._promises = [];
        this._restored = new _lumino_coreutils__rspack_import_0.PromiseDelegate();
        this._trackers = new Set();
        this._widgets = new Map();
        this._mode = 'multiple-document';
        this._connector = options.connector;
        this._first = options.first;
        this._registry = options.registry;
        if (options.mode) {
            this._mode = options.mode;
        }
        void this._first
            .then(() => {
            this._firstDone = true;
        })
            .then(() => Promise.all(this._promises))
            .then(() => {
            this._promisesDone = true;
            // Release the tracker set.
            this._trackers.clear();
        })
            .then(() => {
            this._restored.resolve(void 0);
        });
    }
    /**
     * Whether full layout restoration is deferred and is currently incomplete.
     *
     * #### Notes
     * This flag is useful for tracking when the application has started in
     * 'single-document' mode and the main area has not yet been restored.
     */
    get isDeferred() {
        return this._deferred.length > 0;
    }
    /**
     * A promise resolved when the layout restorer is ready to receive signals.
     */
    get restored() {
        return this._restored.promise;
    }
    /**
     * Add a widget to be tracked by the layout restorer.
     */
    add(widget, name) {
        Private.nameProperty.set(widget, name);
        this._widgets.set(name, widget);
        widget.disposed.connect(this._onWidgetDisposed, this);
    }
    /**
     * Fetch the layout state for the application.
     *
     * #### Notes
     * Fetching the layout relies on all widget restoration to be complete, so
     * calls to `fetch` are guaranteed to return after restoration is complete.
     */
    async fetch() {
        var _a;
        const blank = {
            fresh: true,
            mainArea: null,
            downArea: null,
            leftArea: null,
            rightArea: null,
            topArea: null,
            relativeSizes: null
        };
        const layout = this._connector.fetch(KEY);
        try {
            const [data] = await Promise.all([layout, this.restored]);
            if (!data) {
                return blank;
            }
            const { main, down, left, right, relativeSizes, top } = data;
            // If any data exists, then this is not a fresh session.
            const fresh = false;
            // Rehydrate main area.
            let mainArea = null;
            if (this._mode === 'multiple-document') {
                mainArea = this._rehydrateMainArea(main);
            }
            else {
                this._deferredMainArea = main;
            }
            // Rehydrate down area.
            const downArea = this._rehydrateDownArea(down);
            // Rehydrate left area.
            const leftArea = this._rehydrateSideArea(left);
            // Rehydrate right area.
            const rightArea = this._rehydrateSideArea(right);
            return {
                fresh,
                mainArea,
                downArea,
                leftArea,
                rightArea,
                relativeSizes: relativeSizes || null,
                topArea: (_a = top) !== null && _a !== void 0 ? _a : null
            };
        }
        catch (error) {
            return blank;
        }
    }
    /**
     * Restore the widgets of a particular widget tracker.
     *
     * @param tracker - The widget tracker whose widgets will be restored.
     *
     * @param options - The restoration options.
     */
    async restore(tracker, options) {
        if (this._firstDone) {
            throw new Error('restore() must be called before `first` has resolved.');
        }
        const { namespace } = tracker;
        if (this._trackers.has(namespace)) {
            throw new Error(`The tracker "${namespace}" is already restored.`);
        }
        const { args, command, name, when } = options;
        // Add the tracker to the private trackers collection.
        this._trackers.add(namespace);
        // Whenever a new widget is added to the tracker, record its name.
        tracker.widgetAdded.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                this.add(widget, `${namespace}:${widgetName}`);
            }
        }, this);
        // Whenever a widget is updated, get its new name.
        tracker.widgetUpdated.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                const name = `${namespace}:${widgetName}`;
                Private.nameProperty.set(widget, name);
                this._widgets.set(name, widget);
            }
        });
        const first = this._first;
        if (this._mode == 'multiple-document') {
            const promise = tracker
                .restore({
                args: args || (() => _lumino_coreutils__rspack_import_0.JSONExt.emptyObject),
                command,
                connector: this._connector,
                name,
                registry: this._registry,
                when: when ? [first].concat(when) : first
            })
                .catch(error => {
                console.error(error);
            });
            this._promises.push(promise);
            return promise;
        }
        tracker.defer({
            args: args || (() => _lumino_coreutils__rspack_import_0.JSONExt.emptyObject),
            command,
            connector: this._connector,
            name,
            registry: this._registry,
            when: when ? [first].concat(when) : first
        });
        this._deferred.push(tracker);
    }
    /**
     * Restore the application layout if its restoration has been deferred.
     *
     * @returns - the rehydrated main area.
     */
    async restoreDeferred() {
        if (!this.isDeferred) {
            return null;
        }
        // Empty the deferred list and wait for all trackers to restore.
        const wait = Promise.resolve();
        const promises = this._deferred.map(t => wait.then(() => t.restore()));
        this._deferred.length = 0;
        await Promise.all(promises);
        // Rehydrate the main area layout.
        return this._rehydrateMainArea(this._deferredMainArea);
    }
    /**
     * Save the layout state for the application.
     */
    save(layout) {
        var _a;
        // If there are promises that are unresolved, bail.
        if (!this._promisesDone) {
            const warning = 'save() was called prematurely.';
            console.warn(warning);
            return Promise.reject(warning);
        }
        const dehydrated = {};
        // Save the cached main area layout if restoration is deferred.
        dehydrated.main = this.isDeferred
            ? this._deferredMainArea
            : this._dehydrateMainArea(layout.mainArea);
        // Update only the current widget in the db when restoration is deferred.
        // Useful for providing the tab title in doc mode.
        if (this.isDeferred) {
            const currentWidget = (_a = layout.mainArea) === null || _a === void 0 ? void 0 : _a.currentWidget;
            if (currentWidget) {
                const widgetName = Private.nameProperty.get(currentWidget);
                dehydrated.main = {
                    ...dehydrated.main,
                    current: widgetName || undefined
                };
            }
        }
        dehydrated.down = this._dehydrateDownArea(layout.downArea);
        dehydrated.left = this._dehydrateSideArea(layout.leftArea);
        dehydrated.right = this._dehydrateSideArea(layout.rightArea);
        dehydrated.relativeSizes = layout.relativeSizes;
        dehydrated.top = { ...layout.topArea };
        return this._connector.save(KEY, dehydrated);
    }
    /**
     * Dehydrate a main area description into a serializable object.
     */
    _dehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.serializeMain(area);
    }
    /**
     * Rehydrate a serialized main area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.deserializeMain(area, this._widgets);
    }
    /**
     * Dehydrate a down area description into a serializable object.
     */
    _dehydrateDownArea(area) {
        if (!area) {
            return null;
        }
        const dehydrated = {
            size: area.size
        };
        if (area.currentWidget) {
            const current = Private.nameProperty.get(area.currentWidget);
            if (current) {
                dehydrated.current = current;
            }
        }
        if (area.widgets) {
            dehydrated.widgets = area.widgets
                .map(widget => Private.nameProperty.get(widget))
                .filter(name => !!name);
        }
        return dehydrated;
    }
    /**
     * Rehydrate a serialized side area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateDownArea(area) {
        var _a;
        if (!area) {
            return { currentWidget: null, size: 0.0, widgets: null };
        }
        const internal = this._widgets;
        const currentWidget = area.current && internal.has(`${area.current}`)
            ? internal.get(`${area.current}`)
            : null;
        const widgets = !Array.isArray(area.widgets)
            ? null
            : area.widgets
                .map(name => internal.has(`${name}`) ? internal.get(`${name}`) : null)
                .filter(widget => !!widget);
        return {
            currentWidget: currentWidget,
            size: (_a = area.size) !== null && _a !== void 0 ? _a : 0.0,
            widgets: widgets
        };
    }
    /**
     * Dehydrate a side area description into a serializable object.
     */
    _dehydrateSideArea(area) {
        if (!area) {
            return null;
        }
        const dehydrated = {
            collapsed: area.collapsed,
            visible: area.visible
        };
        if (area.currentWidget) {
            const current = Private.nameProperty.get(area.currentWidget);
            if (current) {
                dehydrated.current = current;
            }
        }
        if (area.widgets) {
            dehydrated.widgets = area.widgets
                .map(widget => Private.nameProperty.get(widget))
                .filter(name => !!name);
        }
        if (area.widgetStates) {
            dehydrated.widgetStates = area.widgetStates;
        }
        return dehydrated;
    }
    /**
     * Rehydrate a serialized side area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateSideArea(area) {
        var _a, _b;
        if (!area) {
            return {
                collapsed: true,
                currentWidget: null,
                visible: true,
                widgets: null,
                widgetStates: {
                    ['null']: {
                        sizes: null,
                        expansionStates: null
                    }
                }
            };
        }
        const internal = this._widgets;
        const collapsed = (_a = area.collapsed) !== null && _a !== void 0 ? _a : false;
        const currentWidget = area.current && internal.has(`${area.current}`)
            ? internal.get(`${area.current}`)
            : null;
        const widgets = !Array.isArray(area.widgets)
            ? null
            : area.widgets
                .map(name => internal.has(`${name}`) ? internal.get(`${name}`) : null)
                .filter(widget => !!widget);
        const widgetStates = area.widgetStates;
        return {
            collapsed,
            currentWidget: currentWidget,
            widgets: widgets,
            visible: (_b = area.visible) !== null && _b !== void 0 ? _b : true,
            widgetStates: widgetStates
        };
    }
    /**
     * Handle a widget disposal.
     */
    _onWidgetDisposed(widget) {
        const name = Private.nameProperty.get(widget);
        this._widgets.delete(name);
    }
}
/*
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * An attached property for a widget's ID in the serialized restore data.
     */
    Private.nameProperty = new _lumino_properties__rspack_import_1.AttachedProperty({
        name: 'name',
        create: owner => ''
    });
    /**
     * Serialize individual areas within the main area.
     */
    function serializeArea(area) {
        if (!area || !area.type) {
            return null;
        }
        if (area.type === 'tab-area') {
            return {
                type: 'tab-area',
                currentIndex: area.currentIndex,
                widgets: area.widgets
                    .map(widget => Private.nameProperty.get(widget))
                    .filter(name => !!name)
            };
        }
        return {
            type: 'split-area',
            orientation: area.orientation,
            sizes: area.sizes,
            children: area.children
                .map(serializeArea)
                .filter(area => !!area)
        };
    }
    /**
     * Return a dehydrated, serializable version of the main dock panel.
     */
    function serializeMain(area) {
        const dehydrated = {
            dock: (area && area.dock && serializeArea(area.dock.main)) || null
        };
        if (area) {
            if (area.currentWidget) {
                const current = Private.nameProperty.get(area.currentWidget);
                if (current) {
                    dehydrated.current = current;
                }
            }
        }
        return dehydrated;
    }
    Private.serializeMain = serializeMain;
    /**
     * Deserialize individual areas within the main area.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is:
     * `ITabArea | ISplitArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeArea(area, names) {
        if (!area) {
            return null;
        }
        // Because this data is saved to a foreign data source, its type safety is
        // not guaranteed when it is retrieved, so exhaustive checks are necessary.
        const type = area.type || 'unknown';
        if (type === 'unknown' || (type !== 'tab-area' && type !== 'split-area')) {
            console.warn(`Attempted to deserialize unknown type: ${type}`);
            return null;
        }
        if (type === 'tab-area') {
            const { currentIndex, widgets } = area;
            const hydrated = {
                type: 'tab-area',
                currentIndex: currentIndex || 0,
                widgets: (widgets &&
                    widgets
                        .map(widget => names.get(widget))
                        .filter(widget => !!widget)) ||
                    []
            };
            // Make sure the current index is within bounds.
            if (hydrated.currentIndex > hydrated.widgets.length - 1) {
                hydrated.currentIndex = 0;
            }
            return hydrated;
        }
        const { orientation, sizes, children } = area;
        const hydrated = {
            type: 'split-area',
            orientation: orientation,
            sizes: sizes || [],
            children: (children &&
                children
                    .map(child => deserializeArea(child, names))
                    .filter(widget => !!widget)) ||
                []
        };
        return hydrated;
    }
    /**
     * Return the hydrated version of the main dock panel, ready to restore.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is: `IMainArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeMain(area, names) {
        if (!area) {
            return null;
        }
        const name = area.current || null;
        const dock = area.dock || null;
        return {
            currentWidget: (name && names.has(name) && names.get(name)) || null,
            dock: dock ? { main: deserializeArea(dock, names) } : null
        };
    }
    Private.deserializeMain = deserializeMain;
})(Private || (Private = {}));
//# sourceMappingURL=layoutrestorer.js.map

},
82514(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
__webpack_require__.d(__webpack_exports__, {
  fo: () => (IMimeDocumentTracker),
  jO: () => (createRendermimePlugins),
  sU: () => (createRendermimePlugin)
});
/* import */ var _jupyterlab_apputils__rspack_import_0 = __webpack_require__(3877);
/* import */ var _jupyterlab_apputils__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__rspack_import_0);
/* import */ var _jupyterlab_docregistry__rspack_import_1 = __webpack_require__(33088);
/* import */ var _jupyterlab_docregistry__rspack_import_1_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__rspack_import_1);
/* import */ var _jupyterlab_rendermime__rspack_import_2 = __webpack_require__(45922);
/* import */ var _jupyterlab_rendermime__rspack_import_2_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__rspack_import_2);
/* import */ var _jupyterlab_translation__rspack_import_3 = __webpack_require__(53816);
/* import */ var _jupyterlab_translation__rspack_import_3_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__rspack_import_3);
/* import */ var _jupyterlab_ui_components__rspack_import_4 = __webpack_require__(58948);
/* import */ var _jupyterlab_ui_components__rspack_import_4_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__rspack_import_4);
/* import */ var _lumino_coreutils__rspack_import_5 = __webpack_require__(83044);
/* import */ var _lumino_coreutils__rspack_import_5_default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__rspack_import_5);
/* import */ var _lumino_properties__rspack_import_6 = __webpack_require__(98818);
/* import */ var _lumino_properties__rspack_import_6_default = /*#__PURE__*/__webpack_require__.n(_lumino_properties__rspack_import_6);
/* import */ var _layoutrestorer__rspack_import_7 = __webpack_require__(8186);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The mime document tracker token.
 */
const IMimeDocumentTracker = new _lumino_coreutils__rspack_import_5.Token('@jupyterlab/application:IMimeDocumentTracker', 'A widget tracker for documents rendered using a mime renderer extension. Use this if you want to list and interact with documents rendered by such extensions.');
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugins(extensions) {
    const plugins = [];
    const namespace = 'application-mimedocuments';
    const tracker = new _jupyterlab_apputils__rspack_import_0.WidgetTracker({ namespace });
    extensions.forEach(mod => {
        let data = mod.default;
        // Handle CommonJS exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            plugins.push(createRendermimePlugin(tracker, item));
        });
    });
    // Also add a meta-plugin handling state restoration
    // and exposing the mime document widget tracker.
    plugins.push({
        id: '@jupyterlab/application-extension:mimedocument',
        description: 'Provides a mime document widget tracker.',
        optional: [_layoutrestorer__rspack_import_7/* .ILayoutRestorer */.E],
        provides: IMimeDocumentTracker,
        autoStart: true,
        activate: (app, restorer) => {
            if (restorer) {
                void restorer.restore(tracker, {
                    command: 'docmanager:open',
                    args: widget => ({
                        path: widget.context.path,
                        factory: Private.factoryNameProperty.get(widget)
                    }),
                    name: widget => `${widget.context.path}:${Private.factoryNameProperty.get(widget)}`
                });
            }
            return tracker;
        }
    });
    return plugins;
}
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugin(tracker, item) {
    return {
        id: item.id,
        description: item.description,
        requires: [_jupyterlab_rendermime__rspack_import_2.IRenderMimeRegistry, _jupyterlab_translation__rspack_import_3.ITranslator],
        autoStart: true,
        activate: (app, rendermime, translator) => {
            // Add the mime renderer.
            if (item.rank !== undefined) {
                rendermime.addFactory(item.rendererFactory, item.rank);
            }
            else {
                rendermime.addFactory(item.rendererFactory);
            }
            // Handle the widget factory.
            if (!item.documentWidgetFactoryOptions) {
                return;
            }
            const registry = app.docRegistry;
            let options = [];
            if (Array.isArray(item.documentWidgetFactoryOptions)) {
                options = item.documentWidgetFactoryOptions;
            }
            else {
                options = [
                    item.documentWidgetFactoryOptions
                ];
            }
            if (item.fileTypes) {
                item.fileTypes.forEach(ft => {
                    if (ft.icon) {
                        // upconvert the contents of the icon field to a proper LabIcon
                        ft = { ...ft, icon: _jupyterlab_ui_components__rspack_import_4.LabIcon.resolve({ icon: ft.icon }) };
                    }
                    app.docRegistry.addFileType(ft);
                });
            }
            options.forEach(option => {
                const toolbarFactory = option.toolbarFactory
                    ? (w) => option.toolbarFactory(w.content.renderer)
                    : undefined;
                const factory = new _jupyterlab_docregistry__rspack_import_1.MimeDocumentFactory({
                    renderTimeout: item.renderTimeout,
                    dataType: item.dataType,
                    rendermime,
                    modelName: option.modelName,
                    name: option.name,
                    primaryFileType: registry.getFileType(option.primaryFileType),
                    fileTypes: option.fileTypes,
                    defaultFor: option.defaultFor,
                    defaultRendered: option.defaultRendered,
                    toolbarFactory,
                    translator,
                    factory: item.rendererFactory
                });
                registry.addWidgetFactory(factory);
                factory.widgetCreated.connect((sender, widget) => {
                    Private.factoryNameProperty.set(widget, factory.name);
                    // Notify the widget tracker if restore data needs to update.
                    widget.context.pathChanged.connect(() => {
                        void tracker.save(widget);
                    });
                    void tracker.add(widget);
                });
            });
        }
    };
}
/**
 * Private namespace for the module.
 */
var Private;
(function (Private) {
    /**
     * An attached property for keeping the factory name
     * that was used to create a mimedocument.
     */
    Private.factoryNameProperty = new _lumino_properties__rspack_import_6.AttachedProperty({
        name: 'factoryName',
        create: () => undefined
    });
})(Private || (Private = {}));
//# sourceMappingURL=mimerenderers.js.map

},
3922(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
__webpack_require__.d(__webpack_exports__, {
  g: () => (LabStatus)
});
/* import */ var _lumino_disposable__rspack_import_0 = __webpack_require__(42574);
/* import */ var _lumino_disposable__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__rspack_import_0);
/* import */ var _lumino_signaling__rspack_import_1 = __webpack_require__(16324);
/* import */ var _lumino_signaling__rspack_import_1_default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__rspack_import_1);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * The application status signals and flags class.
 */
class LabStatus {
    /**
     * Construct a new  status object.
     */
    constructor(app) {
        this._busyCount = 0;
        this._dirtyCount = 0;
        this._busySignal = new _lumino_signaling__rspack_import_1.Signal(app);
        this._dirtySignal = new _lumino_signaling__rspack_import_1.Signal(app);
    }
    /**
     * Returns a signal for when application changes its busy status.
     */
    get busySignal() {
        return this._busySignal;
    }
    /**
     * Returns a signal for when application changes its dirty status.
     */
    get dirtySignal() {
        return this._dirtySignal;
    }
    /**
     * Whether the application is busy.
     */
    get isBusy() {
        return this._busyCount > 0;
    }
    /**
     * Whether the application is dirty.
     */
    get isDirty() {
        return this._dirtyCount > 0;
    }
    /**
     * Set the application state to dirty.
     *
     * @returns A disposable used to clear the dirty state for the caller.
     */
    setDirty() {
        const oldDirty = this.isDirty;
        this._dirtyCount++;
        if (this.isDirty !== oldDirty) {
            this._dirtySignal.emit(this.isDirty);
        }
        return new _lumino_disposable__rspack_import_0.DisposableDelegate(() => {
            const oldDirty = this.isDirty;
            this._dirtyCount = Math.max(0, this._dirtyCount - 1);
            if (this.isDirty !== oldDirty) {
                this._dirtySignal.emit(this.isDirty);
            }
        });
    }
    /**
     * Set the application state to busy.
     *
     * @returns A disposable used to clear the busy state for the caller.
     */
    setBusy() {
        const oldBusy = this.isBusy;
        this._busyCount++;
        if (this.isBusy !== oldBusy) {
            this._busySignal.emit(this.isBusy);
        }
        return new _lumino_disposable__rspack_import_0.DisposableDelegate(() => {
            const oldBusy = this.isBusy;
            this._busyCount--;
            if (this.isBusy !== oldBusy) {
                this._busySignal.emit(this.isBusy);
            }
        });
    }
}
//# sourceMappingURL=status.js.map

},
14546(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@fortawesome/fontawesome-free/css/all.min.css
var all_min = __webpack_require__(72776);
// EXTERNAL MODULE: ../node_modules/@fortawesome/fontawesome-free/css/v4-shims.min.css
var v4_shims_min = __webpack_require__(22594);
// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(59372);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/application/style/base.css
var base = __webpack_require__(45020);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */










},
83061(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  toggleHeader: () => (/* binding */ toggleHeader),
  "default": () => (/* binding */ lib),
  kernelSettings: () => (/* binding */ lib_kernelSettings)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/application@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/application/lib/index.js)
var index_js_ = __webpack_require__(11158);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var lib_index_js_ = __webpack_require__(3877);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(3744);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/docregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/docregistry/lib/index.js)
var docregistry_lib_index_js_ = __webpack_require__(33088);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(19352);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(36548);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/disposable/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(42574);
// EXTERNAL MODULE: consume shared module (default) @lumino/polling@^2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/polling/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(33206);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(43775);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/announcements.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





const COMMAND_HELP_OPEN = 'help:open';
const NEWS_API_URL = '/lab/api/news';
const UPDATE_API_URL = '/lab/api/update';
const PRIVACY_URL = 'https://jupyterlab.readthedocs.io/en/latest/privacy_policies.html';
/**
 * Call the announcement API
 *
 * @param endpoint Endpoint to request
 * @param init Initial values for the request
 * @param serverSettings The server settings to use for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endpoint, init = {}, serverSettings) {
    // Make request to Jupyter API
    const settings = serverSettings !== null && serverSettings !== void 0 ? serverSettings : services_lib_index_js_.ServerConnection.makeSettings();
    const requestUrl = coreutils_lib_index_js_.URLExt.join(settings.baseUrl, endpoint);
    let response;
    try {
        response = await services_lib_index_js_.ServerConnection.makeRequest(requestUrl, init, settings);
    }
    catch (error) {
        throw new services_lib_index_js_.ServerConnection.NetworkError(error);
    }
    const data = await response.json();
    if (!response.ok) {
        throw new services_lib_index_js_.ServerConnection.ResponseError(response, data.message);
    }
    return data;
}
const announcements = {
    id: '@jupyterlab/apputils-extension:announcements',
    description: 'Add the announcement feature. It will fetch news on the internet and check for application updates.',
    autoStart: true,
    optional: [services_lib_index_js_.IConfigSectionManager, settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    activate: (app, configSectionManager, settingRegistry, translator) => {
        var _a, _b;
        const CONFIG_SECTION_NAME = announcements.id.replace(/[^\w]/g, '');
        void Promise.all([
            app.restored,
            (_a = settingRegistry === null || settingRegistry === void 0 ? void 0 : settingRegistry.load('@jupyterlab/apputils-extension:notification')) !== null && _a !== void 0 ? _a : Promise.resolve(null),
            // Use config instead of state to store independently of the workspace
            // if a news has been displayed or not.
            (_b = configSectionManager === null || configSectionManager === void 0 ? void 0 : configSectionManager.create({
                name: CONFIG_SECTION_NAME
            })) !== null && _b !== void 0 ? _b : Promise.resolve(null)
        ]).then(async ([_, settings, config]) => {
            const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
            // Store dismiss state
            lib_index_js_.Notification.manager.changed.connect((manager, change) => {
                var _a;
                if (change.type !== 'removed') {
                    return;
                }
                const { id, tags } = ((_a = change
                    .notification.options.data) !== null && _a !== void 0 ? _a : {});
                if ((tags !== null && tags !== void 0 ? tags : []).some(tag => ['news', 'update'].includes(tag)) && id) {
                    const update = {};
                    update[id] = { seen: true, dismissed: true };
                    config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                        console.error(`Failed to update the announcements config:\n${reason}`);
                    });
                }
            });
            const mustFetchNews = settings === null || settings === void 0 ? void 0 : settings.get('fetchNews').composite;
            if (mustFetchNews === 'none') {
                const notificationId = lib_index_js_.Notification.emit(trans.__('Would you like to get notified about official Jupyter news?'), 'default', {
                    autoClose: false,
                    actions: [
                        {
                            label: trans.__('Open privacy policy'),
                            caption: PRIVACY_URL,
                            callback: event => {
                                event.preventDefault();
                                if (app.commands.hasCommand(COMMAND_HELP_OPEN)) {
                                    void app.commands.execute(COMMAND_HELP_OPEN, {
                                        text: trans.__('Privacy policies'),
                                        url: PRIVACY_URL
                                    });
                                }
                                else {
                                    window.open(PRIVACY_URL, '_blank', 'noreferrer');
                                }
                            },
                            displayType: 'link'
                        },
                        {
                            label: trans.__('Yes'),
                            callback: () => {
                                lib_index_js_.Notification.dismiss(notificationId);
                                config === null || config === void 0 ? void 0 : config.update({}).then(() => fetchNews()).catch(reason => {
                                    console.error(`Failed to get the news:\n${reason}`);
                                });
                                settings === null || settings === void 0 ? void 0 : settings.set('fetchNews', 'true').catch((reason) => {
                                    console.error(`Failed to save setting 'fetchNews':\n${reason}`);
                                });
                            }
                        },
                        {
                            label: trans.__('No'),
                            callback: () => {
                                lib_index_js_.Notification.dismiss(notificationId);
                                settings === null || settings === void 0 ? void 0 : settings.set('fetchNews', 'false').catch((reason) => {
                                    console.error(`Failed to save setting 'fetchNews':\n${reason}`);
                                });
                            }
                        }
                    ]
                });
            }
            else {
                await fetchNews();
            }
            async function fetchNews() {
                var _a, _b, _c, _d;
                if (((_a = settings === null || settings === void 0 ? void 0 : settings.get('fetchNews').composite) !== null && _a !== void 0 ? _a : 'false') === 'true') {
                    try {
                        const response = await requestAPI(NEWS_API_URL, {}, app.serviceManager.serverSettings);
                        for (const { link, message, type, options } of response.news) {
                            // @ts-expect-error data has no index
                            const id = options.data['id'];
                            // Filter those notifications
                            const state = (_b = config === null || config === void 0 ? void 0 : config.data[id]) !== null && _b !== void 0 ? _b : {
                                seen: false,
                                dismissed: false
                            };
                            if (!state.dismissed) {
                                options.actions = [
                                    {
                                        label: trans.__('Hide'),
                                        caption: trans.__('Never show this notification again.'),
                                        callback: () => {
                                            const update = {};
                                            update[id] = { seen: true, dismissed: true };
                                            config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                                console.error(`Failed to update the announcements config:\n${reason}`);
                                            });
                                        }
                                    }
                                ];
                                if ((link === null || link === void 0 ? void 0 : link.length) === 2) {
                                    options.actions.push({
                                        label: link[0],
                                        caption: link[1],
                                        callback: () => {
                                            window.open(link[1], '_blank', 'noreferrer');
                                        },
                                        displayType: 'link'
                                    });
                                }
                                if (!state.seen) {
                                    options.autoClose = 5000;
                                    const update = {};
                                    update[id] = { seen: true };
                                    config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                        console.error(`Failed to update the announcements config:\n${reason}`);
                                    });
                                }
                                lib_index_js_.Notification.emit(message, type, options);
                            }
                        }
                    }
                    catch (reason) {
                        console.log('Failed to get the announcements.', reason);
                    }
                }
                if ((_c = settings === null || settings === void 0 ? void 0 : settings.get('checkForUpdates').composite) !== null && _c !== void 0 ? _c : true) {
                    const response = await requestAPI(UPDATE_API_URL, {}, app.serviceManager.serverSettings);
                    if (response.notification) {
                        const { link, message, type, options } = response.notification;
                        // @ts-expect-error data has no index
                        const id = options.data['id'];
                        const state = (_d = config === null || config === void 0 ? void 0 : config.data[id]) !== null && _d !== void 0 ? _d : {
                            seen: false,
                            dismissed: false
                        };
                        if (!state.dismissed) {
                            let notificationId;
                            options.actions = [
                                {
                                    label: trans.__('Ignore all updates'),
                                    caption: trans.__('Do not prompt me if a new JupyterLab version is available.'),
                                    callback: () => {
                                        settings === null || settings === void 0 ? void 0 : settings.set('checkForUpdates', false).then(() => {
                                            lib_index_js_.Notification.dismiss(notificationId);
                                        }).catch((reason) => {
                                            console.error('Failed to set the `checkForUpdates` setting.', reason);
                                        });
                                    }
                                }
                            ];
                            if ((link === null || link === void 0 ? void 0 : link.length) === 2) {
                                options.actions.push({
                                    label: link[0],
                                    caption: link[1],
                                    callback: () => {
                                        window.open(link[1], '_blank', 'noreferrer');
                                    },
                                    // Because the link to the changelog is the primary option,
                                    // display it in an accent color.
                                    displayType: 'accent'
                                });
                            }
                            if (!state.seen) {
                                options.autoClose = 5000;
                                const update = {};
                                update[id] = { seen: true };
                                config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                    console.error(`Failed to update the announcements config:\n${reason}`);
                                });
                            }
                            notificationId = lib_index_js_.Notification.emit(message, type, options);
                        }
                    }
                }
            }
        });
    }
};
//# sourceMappingURL=announcements.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/mainmenu@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/mainmenu/lib/index.js)
var mainmenu_lib_index_js_ = __webpack_require__(12542);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/licensesplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */






/**
 * The command IDs used by the licenses plugin.
 */
var licensesplugin_CommandIDs;
(function (CommandIDs) {
    CommandIDs.licenses = 'apputils:licenses';
    CommandIDs.licenseReport = 'apputils:license-report';
    CommandIDs.refreshLicenses = 'apputils:licenses-refresh';
})(licensesplugin_CommandIDs || (licensesplugin_CommandIDs = {}));
/**
 * The license client plugin for fetching licenses.
 */
const licensesClient = {
    id: '@jupyterlab/apputils-extension:licenses-client',
    description: 'The licenses client plugin for fetching licenses.',
    autoStart: true,
    provides: lib_index_js_.ILicensesClient,
    activate: (app) => {
        const serverSettings = app.serviceManager.serverSettings;
        return new lib_index_js_.Licenses.LicensesClient({ serverSettings });
    }
};
/**
 * A plugin to add a licenses reporting tools.
 */
const licensesPlugin = {
    id: '@jupyterlab/apputils-extension:licenses-plugin',
    description: 'Adds licenses reporting tools.',
    requires: [lib_index_js_.ILicensesClient, translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILayoutRestorer, mainmenu_lib_index_js_.IMainMenu, lib_index_js_.ICommandPalette],
    autoStart: true,
    activate: (app, client, translator, restorer, menu, palette) => {
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Help');
        const downloadAsText = trans.__('Download All Licenses as');
        const refreshLicenses = trans.__('Refresh Licenses');
        const licensesNamespace = 'help-licenses';
        const licensesTracker = new lib_index_js_.WidgetTracker({
            namespace: licensesNamespace
        });
        // translation strings
        const licensesText = trans.__('Licenses');
        // an incrementer for license widget ids
        let counter = 0;
        /**
         * Create a MainAreaWidget for a license viewer
         */
        function createLicenseWidget(args) {
            const licensesModel = new lib_index_js_.Licenses.Model({
                ...args,
                client,
                trans
            });
            const content = new lib_index_js_.Licenses({ model: licensesModel });
            content.id = `${licensesNamespace}-${++counter}`;
            content.title.label = licensesText;
            content.title.icon = ui_components_lib_index_js_.copyrightIcon;
            const main = new lib_index_js_.MainAreaWidget({
                content,
                reveal: licensesModel.licensesReady
            });
            main.toolbar.addItem('refresh-licenses', new ui_components_lib_index_js_.CommandToolbarButton({
                id: licensesplugin_CommandIDs.refreshLicenses,
                args: { noLabel: 1 },
                commands
            }));
            main.toolbar.addItem('spacer', ui_components_lib_index_js_.Toolbar.createSpacerItem());
            for (const format of Object.keys(lib_index_js_.Licenses.REPORT_FORMATS)) {
                const button = new ui_components_lib_index_js_.CommandToolbarButton({
                    id: licensesplugin_CommandIDs.licenseReport,
                    args: { format, noLabel: 1 },
                    commands
                });
                main.toolbar.addItem(`download-${format}`, button);
            }
            return main;
        }
        /**
         * Return a full license report format based on a format name
         */
        function formatOrDefault(format) {
            return (lib_index_js_.Licenses.REPORT_FORMATS[format] ||
                lib_index_js_.Licenses.REPORT_FORMATS[lib_index_js_.Licenses.DEFAULT_FORMAT]);
        }
        // register license-related commands
        commands.addCommand(licensesplugin_CommandIDs.licenses, {
            label: licensesText,
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: (args) => {
                // bail if no license API is available from the server
                if (!coreutils_lib_index_js_.PageConfig.getOption('licensesUrl')) {
                    console.warn('No license API available from the server');
                    return;
                }
                const licenseMain = createLicenseWidget(args);
                shell.add(licenseMain, 'main', { type: 'Licenses' });
                // add to tracker so it can be restored, and update when choices change
                void licensesTracker.add(licenseMain);
                licenseMain.content.model.trackerDataChanged.connect(() => {
                    void licensesTracker.save(licenseMain);
                });
                return licenseMain;
            }
        });
        commands.addCommand(licensesplugin_CommandIDs.refreshLicenses, {
            label: args => (args.noLabel ? '' : refreshLicenses),
            caption: refreshLicenses,
            icon: ui_components_lib_index_js_.refreshIcon,
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        noLabel: {
                            oneOf: [{ type: 'boolean' }, { type: 'number' }],
                            description: 'Whether to hide the label (truthy values hide label)'
                        }
                    }
                }
            },
            execute: async () => {
                var _a;
                return (_a = licensesTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content.model.initLicenses();
            }
        });
        commands.addCommand(licensesplugin_CommandIDs.licenseReport, {
            label: args => {
                if (args.noLabel) {
                    return '';
                }
                const format = formatOrDefault(`${args.format}`);
                return `${downloadAsText} ${format.title}`;
            },
            caption: args => {
                const format = formatOrDefault(`${args.format}`);
                return `${downloadAsText} ${format.title}`;
            },
            icon: args => {
                const format = formatOrDefault(`${args.format}`);
                return format.icon;
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        format: {
                            type: 'string',
                            description: trans.__('The report format to use for download')
                        },
                        noLabel: {
                            oneOf: [{ type: 'boolean' }, { type: 'number' }],
                            description: 'Whether to hide the label (truthy values hide label)'
                        }
                    },
                    required: ['format']
                }
            },
            execute: async (args) => {
                var _a;
                const format = formatOrDefault(`${args.format}`);
                return await ((_a = licensesTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content.model.download({
                    format: format.id
                }));
            }
        });
        // handle optional integrations
        if (palette) {
            palette.addItem({ command: licensesplugin_CommandIDs.licenses, category });
        }
        if (menu) {
            const helpMenu = menu.helpMenu;
            helpMenu.addGroup([{ command: licensesplugin_CommandIDs.licenses }], 0);
        }
        if (restorer) {
            void restorer.restore(licensesTracker, {
                command: licensesplugin_CommandIDs.licenses,
                name: widget => 'licenses',
                args: widget => {
                    const { currentBundleName, currentPackageIndex, packageFilter } = widget.content.model;
                    const args = {
                        currentBundleName,
                        currentPackageIndex,
                        packageFilter
                    };
                    return args;
                }
            });
        }
    }
};
//# sourceMappingURL=licensesplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(69360);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(34381);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
// EXTERNAL MODULE: ../node_modules/react-dom/client.js
var react_dom_client = __webpack_require__(7470);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/notificationplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */









/**
 * Toast close button class
 */
const TOAST_CLOSE_BUTTON_CLASS = 'jp-Notification-Toast-Close';
/**
 * Toast close button class right margin required due to custom hover effect
 */
const TOAST_CLOSE_BUTTON_MARGIN_CLASS = 'jp-Notification-Toast-Close-Margin';
/**
 * Maximal number of characters displayed in a notification.
 */
const MAX_MESSAGE_LENGTH = 140;
var notificationplugin_CommandIDs;
(function (CommandIDs) {
    /**
     * Dismiss a notification
     */
    CommandIDs.dismiss = 'apputils:dismiss-notification';
    /**
     * Display all notifications
     */
    CommandIDs.display = 'apputils:display-notifications';
    /**
     * Create a notification
     */
    CommandIDs.notify = 'apputils:notify';
    /**
     * Update a notification
     */
    CommandIDs.update = 'apputils:update-notification';
})(notificationplugin_CommandIDs || (notificationplugin_CommandIDs = {}));
/**
 * Half spacing between subitems in a status item.
 */
const HALF_SPACING = 4;
/**
 * Notification center view
 */
function NotificationCenter(props) {
    const { manager, onClose, trans } = props;
    // Markdown parsed notifications
    const [notifications, setNotifications] = react_index_js_.useState([]);
    // Load asynchronously react-toastify icons
    const [icons, setIcons] = react_index_js_.useState(null);
    react_index_js_.useEffect(() => {
        async function onChanged() {
            setNotifications(await Promise.all(manager.notifications.map(async (n) => {
                return Object.freeze({
                    ...n
                });
            })));
        }
        if (notifications.length !== manager.count) {
            void onChanged();
        }
        manager.changed.connect(onChanged);
        return () => {
            manager.changed.disconnect(onChanged);
        };
    }, [manager]);
    react_index_js_.useEffect(() => {
        notificationplugin_Private.getIcons()
            .then(toastifyIcons => {
            setIcons(toastifyIcons);
        })
            .catch(r => {
            console.error(`Failed to get react-toastify icons:\n${r}`);
        });
    }, []);
    return (react_index_js_.createElement(ui_components_lib_index_js_.UseSignal, { signal: manager.changed }, () => (react_index_js_.createElement(react_index_js_.Fragment, null,
        react_index_js_.createElement("h2", { className: "jp-Notification-Header jp-Toolbar" },
            react_index_js_.createElement("span", { className: "jp-Toolbar-item" }, manager.count > 0
                ? trans._n('%1 notification', '%1 notifications', manager.count)
                : trans.__('No notifications')),
            react_index_js_.createElement("span", { className: "jp-Toolbar-item jp-Toolbar-spacer" }),
            react_index_js_.createElement(ui_components_lib_index_js_.ToolbarButtonComponent, { noFocusOnClick: false, onClick: () => {
                    manager.dismiss();
                }, icon: ui_components_lib_index_js_.deleteIcon, tooltip: trans.__('Dismiss all notifications'), enabled: manager.count > 0 }),
            react_index_js_.createElement(ui_components_lib_index_js_.ToolbarButtonComponent, { noFocusOnClick: false, onClick: onClose, icon: ui_components_lib_index_js_.closeIcon, tooltip: trans.__('Hide notifications') })),
        react_index_js_.createElement("ol", { className: "jp-Notification-List" }, notifications.map(notification => {
            var _a;
            const { id, message, type, options } = notification;
            const toastType = type === 'in-progress' ? 'default' : type;
            const closeNotification = () => {
                manager.dismiss(id);
            };
            const icon = type === 'default'
                ? null
                : type === 'in-progress'
                    ? (_a = icons === null || icons === void 0 ? void 0 : icons.spinner) !== null && _a !== void 0 ? _a : null
                    : icons && icons[type];
            return (react_index_js_.createElement("li", { className: "jp-Notification-List-Item", key: notification.id, onClick: event => {
                    // Stop propagation to avoid closing the popup on click
                    event.stopPropagation();
                } },
                react_index_js_.createElement("div", { className: `Toastify__toast Toastify__toast-theme--light Toastify__toast--${toastType} jp-Notification-Toast-${toastType}` },
                    react_index_js_.createElement("div", { className: "Toastify__toast-body" },
                        icon && (react_index_js_.createElement("div", { className: "Toastify__toast-icon" }, icon({ theme: 'light', type: toastType }))),
                        react_index_js_.createElement("div", null, notificationplugin_Private.createContent(message, closeNotification, options.actions))),
                    react_index_js_.createElement(notificationplugin_Private.CloseButton, { close: closeNotification, closeIcon: ui_components_lib_index_js_.deleteIcon.react, title: trans.__('Dismiss notification'), closeIconMargin: true }))));
        }))))));
}
/**
 * Status widget model
 */
class NotificationStatusModel extends ui_components_lib_index_js_.VDomModel {
    constructor(manager) {
        super();
        this.manager = manager;
        this._highlight = false;
        this._listOpened = false;
        this._doNotDisturbMode = false;
        this._count = manager.count;
        this.manager.changed.connect(this.onNotificationChanged, this);
    }
    /**
     * Number of notifications.
     */
    get count() {
        return this._count;
    }
    /**
     * Whether to silence all notifications or not.
     */
    get doNotDisturbMode() {
        return this._doNotDisturbMode;
    }
    set doNotDisturbMode(v) {
        this._doNotDisturbMode = v;
    }
    /**
     * Whether to highlight the status widget or not.
     */
    get highlight() {
        return this._highlight;
    }
    /**
     * Whether the popup is opened or not.
     */
    get listOpened() {
        return this._listOpened;
    }
    set listOpened(v) {
        this._listOpened = v;
        if (this._listOpened || this._highlight) {
            this._highlight = false;
        }
        this.stateChanged.emit();
    }
    onNotificationChanged(_, change) {
        // Set private attribute to trigger only once the signal emission
        this._count = this.manager.count;
        const { autoClose } = change.notification.options;
        const noToast = this.doNotDisturbMode ||
            (typeof autoClose === 'number' && autoClose <= 0);
        // Highlight if
        //   the list is not opened (the style change if list is opened due to clickedItem style in statusbar.)
        //   the change type is not removed
        //   the notification will be hidden
        if (!this._listOpened && change.type !== 'removed' && noToast) {
            this._highlight = true;
        }
        this.stateChanged.emit();
    }
}
/**
 * Status view
 */
function NotificationStatus(props) {
    return (react_index_js_.createElement(statusbar_lib_index_js_.GroupItem, { role: "button", tabIndex: 0, "aria-haspopup": true, spacing: HALF_SPACING, onClick: () => {
            props.onClick();
        }, onKeyDown: (event) => {
            if (event.key === 'Enter' || event.key === ' ') {
                props.onClick();
            }
        }, title: props.count > 0
            ? props.trans._n('%1 notification', '%1 notifications', props.count)
            : props.trans.__('No notifications') },
        react_index_js_.createElement(statusbar_lib_index_js_.TextItem, { className: "jp-Notification-Status-Text", source: `${props.count}` }),
        react_index_js_.createElement(ui_components_lib_index_js_.bellIcon.react, { top: '2px', stylesheet: 'statusBar' })));
}
/**
 * Add notification center and toast
 */
const notificationPlugin = {
    id: '@jupyterlab/apputils-extension:notification',
    description: 'Add the notification center and its status indicator.',
    autoStart: true,
    optional: [statusbar_lib_index_js_.IStatusBar, settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    activate: (app, statusBar, settingRegistry, translator) => {
        notificationplugin_Private.translator = translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator;
        const trans = notificationplugin_Private.translator.load('jupyterlab');
        const model = new NotificationStatusModel(lib_index_js_.Notification.manager);
        model.doNotDisturbMode = false;
        if (settingRegistry) {
            void Promise.all([
                settingRegistry.load(notificationPlugin.id),
                app.restored
            ]).then(([plugin]) => {
                const updateSettings = () => {
                    model.doNotDisturbMode = plugin.get('doNotDisturbMode')
                        .composite;
                };
                updateSettings();
                plugin.changed.connect(updateSettings);
            });
        }
        app.commands.addCommand(notificationplugin_CommandIDs.notify, {
            label: trans.__('Emit a notification'),
            caption: trans.__('Notification is described by {message: string, type?: string, options?: {autoClose?: number | false, actions: {label: string, commandId: string, args?: ReadOnlyJSONObject, caption?: string, className?: string}[], data?: ReadOnlyJSONValue}}.'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        message: {
                            type: 'string',
                            description: 'The notification message text'
                        },
                        type: {
                            type: 'string',
                            description: 'The notification type (e.g., "default", "info", "warning", "error")'
                        },
                        options: {
                            type: 'object',
                            description: 'Additional notification options',
                            properties: {
                                autoClose: {
                                    oneOf: [{ type: 'number' }, { type: 'boolean' }],
                                    description: 'Auto-close timeout in milliseconds, or false to disable'
                                },
                                actions: {
                                    type: 'array',
                                    description: 'Array of action buttons for the notification',
                                    items: {
                                        type: 'object',
                                        properties: {
                                            label: {
                                                type: 'string',
                                                description: 'The action button label'
                                            },
                                            commandId: {
                                                type: 'string',
                                                description: 'The command ID to execute when clicked'
                                            },
                                            args: {
                                                description: 'Arguments to pass to the command'
                                            },
                                            caption: {
                                                type: 'string',
                                                description: 'The action button caption/tooltip'
                                            },
                                            className: {
                                                type: 'string',
                                                description: 'CSS class name for the action button'
                                            }
                                        },
                                        required: ['label', 'commandId']
                                    }
                                },
                                data: {
                                    description: 'Additional data associated with the notification'
                                }
                            }
                        }
                    },
                    required: ['message']
                }
            },
            execute: args => {
                var _a;
                const { message, type } = args;
                const options = (_a = args.options) !== null && _a !== void 0 ? _a : {};
                return lib_index_js_.Notification.manager.notify(message, type !== null && type !== void 0 ? type : 'default', {
                    ...options,
                    actions: options.actions
                        ? options.actions.map((action) => {
                            return {
                                ...action,
                                callback: () => {
                                    app.commands
                                        .execute(action.commandId, action.args)
                                        .catch(r => {
                                        console.error(`Failed to executed '${action.commandId}':\n${r}`);
                                    });
                                }
                            };
                        })
                        : null
                });
            }
        });
        app.commands.addCommand(notificationplugin_CommandIDs.update, {
            label: trans.__('Update a notification'),
            caption: trans.__('Notification is described by {id: string, message: string, type?: string, options?: {autoClose?: number | false, actions: {label: string, commandId: string, args?: ReadOnlyJSONObject, caption?: string, className?: string}[], data?: ReadOnlyJSONValue}}.'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        id: {
                            type: 'string',
                            description: 'The notification ID to update'
                        },
                        message: {
                            type: 'string',
                            description: 'The notification message text'
                        },
                        type: {
                            type: 'string',
                            description: 'The notification type (e.g., "default", "info", "warning", "error")'
                        },
                        options: {
                            type: 'object',
                            description: 'Additional notification options',
                            properties: {
                                autoClose: {
                                    oneOf: [{ type: 'number' }, { type: 'boolean' }],
                                    description: 'Auto-close timeout in milliseconds, or false to disable'
                                },
                                actions: {
                                    type: 'array',
                                    description: 'Array of action buttons for the notification',
                                    items: {
                                        type: 'object',
                                        properties: {
                                            label: {
                                                type: 'string',
                                                description: 'The action button label'
                                            },
                                            commandId: {
                                                type: 'string',
                                                description: 'The command ID to execute when clicked'
                                            },
                                            args: {
                                                description: 'Arguments to pass to the command'
                                            },
                                            caption: {
                                                type: 'string',
                                                description: 'The action button caption/tooltip'
                                            },
                                            className: {
                                                type: 'string',
                                                description: 'CSS class name for the action button'
                                            }
                                        },
                                        required: ['label', 'commandId']
                                    }
                                },
                                data: {
                                    description: 'Additional data associated with the notification'
                                }
                            }
                        }
                    },
                    required: ['id', 'message']
                }
            },
            execute: args => {
                const { id, message, type, ...options } = args;
                return lib_index_js_.Notification.manager.update({
                    id,
                    message,
                    type: type !== null && type !== void 0 ? type : 'default',
                    ...options,
                    actions: options.actions
                        ? options.actions.map((action) => {
                            return {
                                ...action,
                                callback: () => {
                                    app.commands
                                        .execute(action.commandId, action.args)
                                        .catch(r => {
                                        console.error(`Failed to executed '${action.commandId}':\n${r}`);
                                    });
                                }
                            };
                        })
                        : null
                });
            }
        });
        app.commands.addCommand(notificationplugin_CommandIDs.dismiss, {
            label: trans.__('Dismiss a notification'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        id: {
                            type: 'string',
                            description: 'The notification ID to dismiss'
                        }
                    },
                    required: ['id']
                }
            },
            execute: args => {
                const { id } = args;
                lib_index_js_.Notification.manager.dismiss(id);
            }
        });
        let popup = null;
        model.listOpened = false;
        const notificationList = lib_index_js_.ReactWidget.create(react_index_js_.createElement(NotificationCenter, { manager: lib_index_js_.Notification.manager, onClose: () => {
                popup === null || popup === void 0 ? void 0 : popup.dispose();
            }, trans: trans }));
        notificationList.addClass('jp-Notification-Center');
        async function onNotification(manager, change) {
            var _a;
            if (model.doNotDisturbMode || (popup !== null && !popup.isDisposed)) {
                return;
            }
            const { message, type, options, id } = change.notification;
            if (typeof options.autoClose === 'number' && options.autoClose <= 0) {
                // If the notification is silent, bail early.
                return;
            }
            switch (change.type) {
                case 'added':
                    await notificationplugin_Private.createToast(id, message, type, options);
                    break;
                case 'updated':
                    {
                        const toast = await notificationplugin_Private.toast();
                        const actions = options.actions;
                        const autoClose = (_a = options.autoClose) !== null && _a !== void 0 ? _a : (actions && actions.length > 0 ? false : null);
                        if (toast.isActive(id)) {
                            // Update existing toast
                            const closeToast = () => {
                                // Dismiss the displayed toast
                                toast.dismiss(id);
                                // Dismiss the notification from the queue
                                manager.dismiss(id);
                            };
                            toast.update(id, {
                                type: type === 'in-progress' ? null : type,
                                isLoading: type === 'in-progress',
                                autoClose: autoClose,
                                render: notificationplugin_Private.createContent(message, closeToast, options.actions)
                            });
                        }
                        else {
                            // Needs to recreate a closed toast
                            await notificationplugin_Private.createToast(id, message, type, options);
                        }
                    }
                    break;
                case 'removed':
                    await notificationplugin_Private.toast().then(t => {
                        t.dismiss(id);
                    });
                    break;
            }
        }
        lib_index_js_.Notification.manager.changed.connect(onNotification);
        const displayNotifications = () => {
            if (popup) {
                popup.dispose();
                popup = null;
            }
            else {
                popup = (0,statusbar_lib_index_js_.showPopup)({
                    body: notificationList,
                    anchor: notificationStatus,
                    align: 'right',
                    hasDynamicSize: true,
                    startHidden: true
                });
                // Dismiss all toasts when opening the notification center
                notificationplugin_Private.toast()
                    .then(t => {
                    t.dismiss();
                })
                    .catch(r => {
                    console.error(`Failed to dismiss all toasts:\n${r}`);
                })
                    .finally(() => {
                    popup === null || popup === void 0 ? void 0 : popup.launch();
                    // Focus on the pop-up
                    notificationList.node.focus();
                    popup === null || popup === void 0 ? void 0 : popup.disposed.connect(() => {
                        model.listOpened = false;
                        popup = null;
                    });
                });
            }
            model.listOpened = popup !== null;
        };
        app.commands.addCommand(notificationplugin_CommandIDs.display, {
            label: trans.__('Show Notifications'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: displayNotifications
        });
        const notificationStatus = lib_index_js_.ReactWidget.create(react_index_js_.createElement(ui_components_lib_index_js_.UseSignal, { signal: model.stateChanged }, () => {
            if (model.highlight || (popup && !popup.isDisposed)) {
                notificationStatus.addClass('jp-mod-selected');
            }
            else {
                notificationStatus.removeClass('jp-mod-selected');
            }
            return (react_index_js_.createElement(NotificationStatus, { count: model.count, highlight: model.highlight, trans: trans, onClick: displayNotifications }));
        }));
        notificationStatus.addClass('jp-Notification-Status');
        if (statusBar) {
            statusBar.registerStatusItem(notificationPlugin.id, {
                item: notificationStatus,
                align: 'right',
                rank: -1
            });
        }
        else {
            notificationStatus.addClass('jp-ThemedContainer');
            // if the status bar is not available, position the notification
            // status in the bottom right corner of the page
            notificationStatus.node.style.position = 'fixed';
            notificationStatus.node.style.bottom = '0';
            // 10px is the default padding for the status bar
            notificationStatus.node.style.right = '10px';
            widgets_dist_index_es6_js_.Widget.attach(notificationStatus, document.body);
            notificationStatus.show();
        }
    }
};
var notificationplugin_Private;
(function (Private) {
    /**
     * Translator object for private namespace
     */
    Private.translator = translation_lib_index_js_.nullTranslator;
    /**
     * Pointer to asynchronously loaded react-toastify
     */
    let toastify = null;
    function CloseButton(props) {
        var _a;
        return (react_index_js_.createElement("button", { className: `jp-Button jp-mod-minimal ${TOAST_CLOSE_BUTTON_CLASS}${props.closeIconMargin ? ` ${TOAST_CLOSE_BUTTON_MARGIN_CLASS}` : ''}`, title: (_a = props.title) !== null && _a !== void 0 ? _a : '', onClick: props.close },
            react_index_js_.createElement(props.closeIcon, { className: "jp-icon-hover", tag: "span" })));
    }
    Private.CloseButton = CloseButton;
    function ToastifyCloseButton(props) {
        const trans = Private.translator.load('jupyterlab');
        return (react_index_js_.createElement(CloseButton, { close: props.closeToast, closeIcon: ui_components_lib_index_js_.closeIcon.react, title: trans.__('Hide notification') }));
    }
    let waitForToastify = null;
    /**
     * Asynchronously load the toast container
     *
     * @returns The toast object
     */
    async function toast() {
        if (waitForToastify === null) {
            waitForToastify = new dist_index_js_.PromiseDelegate();
        }
        else {
            await waitForToastify.promise;
        }
        if (toastify === null) {
            toastify = await __webpack_require__.e(/* import() */ "4539").then(__webpack_require__.t.bind(__webpack_require__, 94854, 23));
            const container = document.body.appendChild(document.createElement('div'));
            container.id = 'react-toastify-container';
            container.classList.add('jp-ThemedContainer');
            const root = (0,react_dom_client.createRoot)(container);
            root.render(react_index_js_.createElement(toastify.ToastContainer, { draggable: false, closeOnClick: false, hideProgressBar: true, newestOnTop: true, pauseOnFocusLoss: true, pauseOnHover: true, position: "bottom-right", className: "jp-toastContainer", transition: toastify.Slide, closeButton: ToastifyCloseButton }));
            waitForToastify.resolve();
        }
        return toastify.toast;
    }
    Private.toast = toast;
    /**
     * react-toastify icons loader
     */
    async function getIcons() {
        if (toastify === null) {
            await toast();
        }
        return toastify.Icons;
    }
    Private.getIcons = getIcons;
    const displayType2Class = {
        accent: 'jp-mod-accept',
        link: 'jp-mod-link',
        warn: 'jp-mod-warn',
        default: ''
    };
    /**
     * Create a button with customized callback in a toast
     */
    function ToastButton({ action, closeToast }) {
        var _a, _b;
        const clickHandler = (event) => {
            action.callback(event);
            if (!event.defaultPrevented) {
                closeToast();
            }
        };
        const classes = [
            'jp-toast-button',
            displayType2Class[(_a = action.displayType) !== null && _a !== void 0 ? _a : 'default']
        ].join(' ');
        return (react_index_js_.createElement(ui_components_lib_index_js_.Button, { title: (_b = action.caption) !== null && _b !== void 0 ? _b : action.label, className: classes, onClick: clickHandler, small: true }, action.label));
    }
    /**
     * Helper function to construct the notification content
     *
     * @param message Message to print in the notification
     * @param closeHandler Function closing the notification
     * @param actions Toast actions
     */
    function createContent(message, closeHandler, actions) {
        var _a;
        const shortenMessage = message.length > MAX_MESSAGE_LENGTH
            ? message.slice(0, MAX_MESSAGE_LENGTH) + '…'
            : message;
        return (react_index_js_.createElement(react_index_js_.Fragment, null,
            react_index_js_.createElement("div", { className: "jp-toast-message" }, shortenMessage.split('\n').map((part, index) => (react_index_js_.createElement(react_index_js_.Fragment, { key: `part-${index}` },
                index > 0 ? react_index_js_.createElement("br", null) : null,
                part)))),
            ((_a = actions === null || actions === void 0 ? void 0 : actions.length) !== null && _a !== void 0 ? _a : 0) > 0 && (react_index_js_.createElement("div", { className: "jp-toast-buttonBar" },
                react_index_js_.createElement("div", { className: "jp-toast-spacer" }),
                actions.map((action, idx) => {
                    return (react_index_js_.createElement(ToastButton, { key: 'button-' + idx, action: action, closeToast: closeHandler }));
                })))));
    }
    Private.createContent = createContent;
    /**
     * Create a toast notification
     *
     * @param toastId Toast unique id
     * @param message Toast message
     * @param type Toast type
     * @param options Toast options
     * @returns Toast id
     */
    async function createToast(toastId, message, type, options = {}) {
        const { actions, autoClose, data } = options;
        const t = await toast();
        const toastOptions = {
            autoClose: autoClose !== null && autoClose !== void 0 ? autoClose : (actions && actions.length > 0 ? false : undefined),
            data: data,
            className: `jp-Notification-Toast-${type}`,
            toastId,
            type: type === 'in-progress' ? null : type,
            isLoading: type === 'in-progress'
        };
        return t(({ closeToast }) => createContent(message, () => {
            if (closeToast)
                closeToast();
            lib_index_js_.Notification.manager.dismiss(toastId);
        }, actions), toastOptions);
    }
    Private.createToast = createToast;
})(notificationplugin_Private || (notificationplugin_Private = {}));
//# sourceMappingURL=notificationplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var algorithm_dist_index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/commands@~2.3.3 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/commands/dist/index.es6.js)
var commands_dist_index_es6_js_ = __webpack_require__(99774);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/palette.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/







/**
 * The command IDs used by the apputils extension.
 */
var palette_CommandIDs;
(function (CommandIDs) {
    CommandIDs.activate = 'apputils:activate-command-palette';
})(palette_CommandIDs || (palette_CommandIDs = {}));
const PALETTE_PLUGIN_ID = '@jupyterlab/apputils-extension:palette';
/**
 * A thin wrapper around the `CommandPalette` class to conform with the
 * JupyterLab interface for the application-wide command palette.
 */
class palette_Palette {
    /**
     * Create a palette instance.
     */
    constructor(palette, translator) {
        this.translator = translator || translation_lib_index_js_.nullTranslator;
        const trans = this.translator.load('jupyterlab');
        this._palette = palette;
        this._palette.title.label = '';
        this._palette.title.caption = trans.__('Command Palette');
    }
    /**
     * The placeholder text of the command palette's search input.
     */
    set placeholder(placeholder) {
        this._palette.inputNode.placeholder = placeholder;
    }
    get placeholder() {
        return this._palette.inputNode.placeholder;
    }
    /**
     * Activate the command palette for user input.
     */
    activate() {
        this._palette.activate();
    }
    /**
     * Add a command item to the command palette.
     *
     * @param options - The options for creating the command item.
     *
     * @returns A disposable that will remove the item from the palette.
     */
    addItem(options) {
        const item = this._palette.addItem(options);
        return new index_es6_js_.DisposableDelegate(() => {
            this._palette.removeItem(item);
        });
    }
}
/**
 * A namespace for `Palette` statics.
 */
(function (Palette) {
    /**
     * Activate the command palette.
     */
    function activate(app, translator, settingRegistry) {
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const palette = palette_Private.createPalette(app, translator);
        const modalPalette = new lib_index_js_.ModalCommandPalette({
            commandPalette: palette,
            restore: () => {
                const widget = app.shell.currentWidget;
                if (widget) {
                    widget.activate();
                }
            }
        });
        let modal = false;
        palette.node.setAttribute('role', 'region');
        palette.node.setAttribute('aria-label', trans.__('Command Palette Section'));
        shell.add(palette, 'left', { rank: 300, type: 'Command Palette' });
        if (settingRegistry) {
            const loadSettings = settingRegistry.load(PALETTE_PLUGIN_ID);
            const updateSettings = (settings) => {
                const newModal = settings.get('modal').composite;
                if (modal && !newModal) {
                    palette.parent = null;
                    modalPalette.detach();
                    shell.add(palette, 'left', { rank: 300, type: 'Command Palette' });
                }
                else if (!modal && newModal) {
                    palette.parent = null;
                    modalPalette.palette = palette;
                    palette.show();
                    modalPalette.attach();
                }
                modal = newModal;
            };
            Promise.all([loadSettings, app.restored])
                .then(([settings]) => {
                updateSettings(settings);
                settings.changed.connect(settings => {
                    updateSettings(settings);
                });
            })
                .catch((reason) => {
                console.error(reason.message);
            });
        }
        // Show the current palette shortcut in its title.
        const updatePaletteTitle = () => {
            const binding = (0,algorithm_dist_index_es6_js_.find)(app.commands.keyBindings, b => b.command === palette_CommandIDs.activate);
            if (binding) {
                const ks = binding.keys.map(commands_dist_index_es6_js_.CommandRegistry.formatKeystroke).join(', ');
                palette.title.caption = trans.__('Commands (%1)', ks);
            }
            else {
                palette.title.caption = trans.__('Commands');
            }
        };
        updatePaletteTitle();
        app.commands.keyBindingChanged.connect(() => {
            updatePaletteTitle();
        });
        commands.addCommand(palette_CommandIDs.activate, {
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                if (modal) {
                    modalPalette.activate();
                }
                else {
                    shell.activateById(palette.id);
                }
            },
            label: trans.__('Activate Command Palette')
        });
        palette.inputNode.placeholder = trans.__('SEARCH');
        return new Palette(palette, translator);
    }
    Palette.activate = activate;
    /**
     * Restore the command palette.
     */
    function restore(app, restorer, translator) {
        const palette = palette_Private.createPalette(app, translator);
        // Let the application restorer track the command palette for restoration of
        // application state (e.g. setting the command palette as the current side bar
        // widget).
        restorer.add(palette, 'command-palette');
    }
    Palette.restore = restore;
})(palette_Palette || (palette_Palette = {}));
/**
 * The namespace for module private data.
 */
var palette_Private;
(function (Private) {
    /**
     * The private command palette instance.
     */
    let palette;
    /**
     * Create the application-wide command palette.
     */
    function createPalette(app, translator) {
        if (!palette) {
            // use a renderer tweaked to use inline svg icons
            palette = new widgets_dist_index_es6_js_.CommandPalette({
                commands: app.commands,
                renderer: ui_components_lib_index_js_.CommandPaletteSvg.defaultRenderer
            });
            palette.id = 'command-palette';
            palette.title.icon = ui_components_lib_index_js_.paletteIcon;
            const trans = translator.load('jupyterlab');
            palette.title.label = trans.__('Commands');
        }
        return palette;
    }
    Private.createPalette = createPalette;
})(palette_Private || (palette_Private = {}));
//# sourceMappingURL=palette.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/settingconnector.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * A data connector for fetching settings.
 *
 * #### Notes
 * This connector adds a query parameter to the base services setting manager.
 */
class SettingConnector extends statedb_lib_index_js_.DataConnector {
    constructor(connector) {
        super();
        this._throttlers = Object.create(null);
        this._connector = connector;
    }
    /**
     * Fetch settings for a plugin.
     * @param id - The plugin ID
     *
     * #### Notes
     * The REST API requests are throttled at one request per plugin per 100ms.
     */
    fetch(id) {
        const throttlers = this._throttlers;
        if (!(id in throttlers)) {
            throttlers[id] = new dist_index_es6_js_.Throttler(() => this._connector.fetch(id), 100);
        }
        return throttlers[id].invoke();
    }
    async list(query = 'all') {
        const { isDisabled } = coreutils_lib_index_js_.PageConfig.Extension;
        const { ids, values } = await this._connector.list(query === 'ids' ? 'ids' : undefined);
        if (query === 'all') {
            return { ids, values };
        }
        if (query === 'ids') {
            return { ids };
        }
        return {
            ids: ids.filter(id => !isDisabled(id)),
            values: values.filter(({ id }) => !isDisabled(id))
        };
    }
    async save(id, raw) {
        await this._connector.save(id, raw);
    }
}
//# sourceMappingURL=settingconnector.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/settingsplugin.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * Provides the settings connector as a separate plugin to allow for alternative
 * implementations that may want to fetch settings from a different source or
 * endpoint.
 */
const settingsplugin_settingsConnector = {
    id: '@jupyterlab/apputils-extension:settings-connector',
    description: 'Provides the settings connector.',
    autoStart: true,
    provides: settingregistry_lib_index_js_.ISettingConnector,
    activate: (app) => new SettingConnector(app.serviceManager.settings)
};
/**
 * The default setting registry provider.
 */
const settingsPlugin = {
    id: '@jupyterlab/apputils-extension:settings',
    autoStart: true,
    provides: settingregistry_lib_index_js_.ISettingRegistry,
    optional: [settingregistry_lib_index_js_.ISettingConnector],
    description: 'Provides the setting registry.',
    activate: async (app, settingsConnector) => {
        const { isDisabled } = coreutils_lib_index_js_.PageConfig.Extension;
        const connector = settingsConnector !== null && settingsConnector !== void 0 ? settingsConnector : new SettingConnector(app.serviceManager.settings);
        // On startup, check if a plugin is available in the application.
        // This helps avoid loading plugin files from other lab-based applications
        // that have placed their schemas next to the JupyterLab schemas. Different lab-based
        // applications might not have the same set of plugins loaded on the page.
        // As an example this helps prevent having new toolbar items added by another application
        // appear in JupyterLab as a side-effect when they are defined via the settings system.
        const registry = new settingregistry_lib_index_js_.SettingRegistry({
            connector,
            plugins: (await connector.list('active')).values.filter(value => app.hasPlugin(value.id))
        });
        // If there are plugins that have schemas that are not in the setting
        // registry after the application has restored, try to load them manually
        // because otherwise, its settings will never become available in the
        // setting registry.
        void app.restored.then(async () => {
            const plugins = await connector.list('ids');
            plugins.ids.forEach(async (id) => {
                if (!app.hasPlugin(id) || isDisabled(id) || id in registry.plugins) {
                    return;
                }
                try {
                    await registry.load(id);
                }
                catch (error) {
                    console.warn(`Settings failed to load for (${id})`, error);
                    if (!app.isPluginActivated(id)) {
                        console.warn(`If 'jupyter.lab.transform=true' in the plugin schema, this ` +
                            `may happen if {autoStart: false} in (${id}) or if it is ` +
                            `one of the deferredExtensions in page config.`);
                    }
                }
            });
        });
        return registry;
    }
};
//# sourceMappingURL=settingsplugin.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/statusbarplugin.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/





/**
 * A plugin that provides a kernel status item to the status bar.
 */
const kernelStatus = {
    id: '@jupyterlab/apputils-extension:kernel-status',
    description: 'Provides the kernel status indicator model.',
    autoStart: true,
    requires: [statusbar_lib_index_js_.IStatusBar],
    provides: lib_index_js_.IKernelStatusModel,
    optional: [lib_index_js_.ISessionContextDialogs, translation_lib_index_js_.ITranslator, index_js_.ILabShell],
    activate: (app, statusBar, sessionDialogs_, translator_, labShell) => {
        const translator = translator_ !== null && translator_ !== void 0 ? translator_ : translation_lib_index_js_.nullTranslator;
        const sessionDialogs = sessionDialogs_ !== null && sessionDialogs_ !== void 0 ? sessionDialogs_ : new lib_index_js_.SessionContextDialogs({ translator });
        // When the status item is clicked, launch the kernel
        // selection dialog for the current session.
        const changeKernel = async () => {
            if (!item.model.sessionContext) {
                return;
            }
            await sessionDialogs.selectKernel(item.model.sessionContext);
        };
        const changeKernelOnKeyDown = async (event) => {
            if (event.key === 'Enter' ||
                event.key === 'Spacebar' ||
                event.key === ' ') {
                event.preventDefault();
                event.stopPropagation();
                return changeKernel();
            }
        };
        // Create the status item.
        const item = new lib_index_js_.KernelStatus({ onClick: changeKernel, onKeyDown: changeKernelOnKeyDown }, translator);
        const providers = new Set();
        const addSessionProvider = (provider) => {
            providers.add(provider);
            if (app.shell.currentWidget) {
                updateSession(app.shell, {
                    newValue: app.shell.currentWidget,
                    oldValue: null
                });
            }
        };
        function updateSession(shell, changes) {
            var _a;
            const { oldValue, newValue } = changes;
            // Clean up after the old value if it exists,
            // listen for changes to the title of the activity
            if (oldValue) {
                oldValue.title.changed.disconnect(onTitleChanged);
            }
            item.model.sessionContext =
                (_a = [...providers]
                    .map(provider => provider(changes.newValue))
                    .filter(session => session !== null)[0]) !== null && _a !== void 0 ? _a : null;
            if (newValue && item.model.sessionContext) {
                onTitleChanged(newValue.title);
                newValue.title.changed.connect(onTitleChanged);
            }
        }
        // When the title of the active widget changes, update the label
        // of the hover text.
        const onTitleChanged = (title) => {
            item.model.activityName = title.label;
        };
        if (labShell) {
            labShell.currentChanged.connect(updateSession);
        }
        statusBar.registerStatusItem(kernelStatus.id, {
            priority: 1,
            item,
            align: 'left',
            rank: 1,
            isActive: () => item.model.sessionContext !== null
        });
        return { addSessionProvider };
    }
};
/*
 * A plugin providing running terminals and sessions information
 * to the status bar.
 */
const runningSessionsStatus = {
    id: '@jupyterlab/apputils-extension:running-sessions-status',
    description: 'Add the running sessions and terminals status bar item.',
    autoStart: true,
    requires: [statusbar_lib_index_js_.IStatusBar, translation_lib_index_js_.ITranslator],
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, statusBar, translator, settingRegistry) => {
        const createStatusItem = (options) => {
            const item = new lib_index_js_.RunningSessions({
                onClick: () => app.shell.activateById('jp-running-sessions'),
                onKeyDown: (event) => {
                    if (event.key === 'Enter' ||
                        event.key === 'Spacebar' ||
                        event.key === ' ') {
                        event.preventDefault();
                        event.stopPropagation();
                        app.shell.activateById('jp-running-sessions');
                    }
                },
                serviceManager: app.serviceManager,
                translator,
                ...options
            });
            item.model.sessions = Array.from(app.serviceManager.sessions.running()).length;
            item.model.terminals = Array.from(app.serviceManager.terminals.running()).length;
            return item;
        };
        const registerItem = (options) => {
            const item = createStatusItem(options);
            return statusBar.registerStatusItem(runningSessionsStatus.id, {
                item,
                align: 'left',
                rank: 0
            });
        };
        if (settingRegistry) {
            let disposable;
            const onSettingsUpdated = (kernelSettings, terminalsSettings) => {
                var _a, _b;
                const showTerminalsMap = {
                    'if-any': undefined,
                    never: false,
                    always: true
                };
                const showKernels = (_a = kernelSettings === null || kernelSettings === void 0 ? void 0 : kernelSettings.get('showStatusBarItem').composite) !== null && _a !== void 0 ? _a : true;
                const showTerminals = showTerminalsMap[(_b = terminalsSettings === null || terminalsSettings === void 0 ? void 0 : terminalsSettings.get('showStatusBarItem').composite) !== null && _b !== void 0 ? _b : 'if-any'];
                disposable === null || disposable === void 0 ? void 0 : disposable.dispose();
                if (showKernels || showTerminals !== false) {
                    disposable = registerItem({
                        showKernels,
                        showTerminals
                    });
                }
            };
            const kernelsPluginId = '@jupyterlab/apputils-extension:kernels-settings';
            const terminalPluginId = '@jupyterlab/terminal-extension:plugin';
            void Promise.all([
                // Settings may be missing if the respective plugins are not enabled/included.
                kernelsPluginId in settingRegistry.plugins
                    ? settingRegistry.load(kernelsPluginId).catch(() => undefined)
                    : Promise.resolve(undefined),
                terminalPluginId in settingRegistry.plugins
                    ? settingRegistry.load(terminalPluginId).catch(() => undefined)
                    : Promise.resolve(undefined)
            ]).then(([kernelSettings, terminalSettings]) => {
                onSettingsUpdated(kernelSettings, terminalSettings);
                if (kernelSettings) {
                    kernelSettings.changed.connect(settings => {
                        kernelSettings = settings;
                        onSettingsUpdated(kernelSettings, terminalSettings);
                    });
                }
                if (terminalSettings) {
                    terminalSettings.changed.connect(settings => {
                        terminalSettings = settings;
                        onSettingsUpdated(kernelSettings, terminalSettings);
                    });
                }
            });
        }
        else {
            registerItem({
                showKernels: true
            });
        }
    }
};
//# sourceMappingURL=statusbarplugin.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/subshell-settings.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*
 * A plugin loading kernel subshell settings.
 */
const subshell_settings_subshellsSettings = {
    id: '@jupyterlab/apputils-extension:subshell-settings',
    description: 'Kernel subshell settings.',
    autoStart: true,
    requires: [],
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settingRegistry) => {
        if (settingRegistry) {
            app.started
                .then(async () => {
                const subshellsSettings = await settingRegistry.load('@jupyterlab/apputils-extension:kernels-settings');
                const commsOverSubshells = subshellsSettings.get('commsOverSubshells')
                    .composite;
                app.serviceManager.kernels.commsOverSubshells = commsOverSubshells;
                subshellsSettings.changed.connect(() => {
                    const commsOverSubshells = subshellsSettings.get('commsOverSubshells').composite;
                    app.serviceManager.kernels.commsOverSubshells = commsOverSubshells;
                });
            })
                .catch(reason => {
                console.error('Fail to load settings for the subshells.');
                console.error(reason);
            });
        }
    }
};
//# sourceMappingURL=subshell-settings.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/scrollbar.raw.css
const scrollbar_raw_namespaceObject = "/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n/*\n * Webkit scrollbar styling.\n * Separate file which is dynamically loaded based on user/theme settings.\n */\n\n/* use standard opaque scrollbars for most nodes */\n\n::-webkit-scrollbar,\n::-webkit-scrollbar-corner {\n  background: var(--jp-scrollbar-background-color);\n}\n\n::-webkit-scrollbar-thumb {\n  background: rgb(var(--jp-scrollbar-thumb-color));\n  border: var(--jp-scrollbar-thumb-margin) solid transparent;\n  background-clip: content-box;\n  border-radius: var(--jp-scrollbar-thumb-radius);\n}\n\n::-webkit-scrollbar-track:horizontal {\n  border-left: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n  border-right: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n}\n\n::-webkit-scrollbar-track:vertical {\n  border-top: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n  border-bottom: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n}\n\n/* for code nodes, use a transparent style of scrollbar */\n\n.CodeMirror-hscrollbar::-webkit-scrollbar,\n.CodeMirror-vscrollbar::-webkit-scrollbar,\n.CodeMirror-hscrollbar::-webkit-scrollbar-corner,\n.CodeMirror-vscrollbar::-webkit-scrollbar-corner {\n  background-color: transparent;\n}\n\n.CodeMirror-hscrollbar::-webkit-scrollbar-thumb,\n.CodeMirror-vscrollbar::-webkit-scrollbar-thumb {\n  background: rgba(var(--jp-scrollbar-thumb-color), 0.5);\n  border: var(--jp-scrollbar-thumb-margin) solid transparent;\n  background-clip: content-box;\n  border-radius: var(--jp-scrollbar-thumb-radius);\n}\n\n.CodeMirror-hscrollbar::-webkit-scrollbar-track:horizontal {\n  border-left: var(--jp-scrollbar-endpad) solid transparent;\n  border-right: var(--jp-scrollbar-endpad) solid transparent;\n}\n\n.CodeMirror-vscrollbar::-webkit-scrollbar-track:vertical {\n  border-top: var(--jp-scrollbar-endpad) solid transparent;\n  border-bottom: var(--jp-scrollbar-endpad) solid transparent;\n}\n";
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/themesplugins.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/







var themesplugins_CommandIDs;
(function (CommandIDs) {
    CommandIDs.changeTheme = 'apputils:change-theme';
    CommandIDs.changePreferredLightTheme = 'apputils:change-light-theme';
    CommandIDs.changePreferredDarkTheme = 'apputils:change-dark-theme';
    CommandIDs.toggleAdaptiveTheme = 'apputils:adaptive-theme';
    CommandIDs.themeScrollbars = 'apputils:theme-scrollbars';
    CommandIDs.changeFont = 'apputils:change-font';
    CommandIDs.incrFontSize = 'apputils:incr-font-size';
    CommandIDs.decrFontSize = 'apputils:decr-font-size';
})(themesplugins_CommandIDs || (themesplugins_CommandIDs = {}));
function createStyleSheet(text) {
    const style = document.createElement('style');
    style.setAttribute('type', 'text/css');
    style.appendChild(document.createTextNode(text));
    return style;
}
/**
 * The default theme manager provider.
 */
const themesPlugin = {
    id: '@jupyterlab/apputils-extension:themes',
    description: 'Provides the theme manager.',
    requires: [settingregistry_lib_index_js_.ISettingRegistry, index_js_.JupyterFrontEnd.IPaths, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ISplashScreen],
    activate: (app, settings, paths, translator, splash) => {
        const trans = translator.load('jupyterlab');
        const host = app.shell;
        const commands = app.commands;
        const url = coreutils_lib_index_js_.URLExt.join(app.serviceManager.serverSettings.baseUrl, paths.urls.themes);
        const key = themesPlugin.id;
        const manager = new lib_index_js_.ThemeManager({
            key,
            host,
            settings,
            splash: splash !== null && splash !== void 0 ? splash : undefined,
            url
        });
        let scrollbarsStyleElement = null;
        // Keep a synchronously set reference to the current theme,
        // since the asynchronous setting of the theme in `changeTheme`
        // can lead to an incorrect toggle on the currently used theme.
        let currentTheme;
        manager.themeChanged.connect((sender, args) => {
            // Set data attributes on the application shell for the current theme.
            currentTheme = args.newValue;
            document.body.dataset.jpThemeLight = String(manager.isLight(currentTheme));
            document.body.dataset.jpThemeName = currentTheme;
            document.body.style.colorScheme = manager.isLight(currentTheme)
                ? 'light'
                : 'dark';
            if (document.body.dataset.jpThemeScrollbars !==
                String(manager.themeScrollbars(currentTheme))) {
                document.body.dataset.jpThemeScrollbars = String(manager.themeScrollbars(currentTheme));
                if (manager.themeScrollbars(currentTheme)) {
                    if (!scrollbarsStyleElement) {
                        scrollbarsStyleElement = createStyleSheet(scrollbar_raw_namespaceObject);
                    }
                    if (!scrollbarsStyleElement.parentElement) {
                        document.body.appendChild(scrollbarsStyleElement);
                    }
                }
                else {
                    if (scrollbarsStyleElement && scrollbarsStyleElement.parentElement) {
                        scrollbarsStyleElement.parentElement.removeChild(scrollbarsStyleElement);
                    }
                }
            }
            commands.notifyCommandChanged(themesplugins_CommandIDs.changeTheme);
        });
        commands.addCommand(themesplugins_CommandIDs.changeTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Use Theme: %1', displayName)
                    : displayName;
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        theme: {
                            type: 'string',
                            description: trans.__('The theme name to switch to')
                        },
                        isPalette: {
                            type: 'boolean',
                            description: trans.__('Whether the command is being called from the palette')
                        }
                    },
                    required: ['theme']
                }
            },
            isToggled: args => args['theme'] === currentTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.theme) {
                    return;
                }
                // Disable adaptive theme if users decide to change the theme when adaptive theme is on
                if (manager.isToggledAdaptiveTheme()) {
                    return manager.toggleAdaptiveTheme();
                }
                return manager.setTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.changePreferredLightTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided light `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Set Preferred Light Theme: %1', displayName)
                    : displayName;
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        theme: {
                            type: 'string',
                            description: trans.__('The preferred light theme name')
                        },
                        isPalette: {
                            type: 'boolean',
                            description: trans.__('Whether the command is being called from the palette')
                        }
                    },
                    required: ['theme']
                }
            },
            isToggled: args => args['theme'] === manager.preferredLightTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.preferredLightTheme) {
                    return;
                }
                return manager.setPreferredLightTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.changePreferredDarkTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided dark `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Set Preferred Dark Theme: %1', displayName)
                    : displayName;
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        theme: {
                            type: 'string',
                            description: trans.__('The preferred dark theme name')
                        },
                        isPalette: {
                            type: 'boolean',
                            description: trans.__('Whether the command is being called from the palette')
                        }
                    },
                    required: ['theme']
                }
            },
            isToggled: args => args['theme'] === manager.preferredDarkTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.preferredDarkTheme) {
                    return;
                }
                return manager.setPreferredDarkTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.toggleAdaptiveTheme, {
            // Avoid lengthy option text in menu
            label: args => args['isPalette']
                ? trans.__('Synchronize Styling Theme with System Settings')
                : trans.__('Synchronize with System Settings'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        isPalette: {
                            type: 'boolean',
                            description: trans.__('Whether the command is being called from the palette')
                        }
                    }
                }
            },
            isToggled: () => manager.isToggledAdaptiveTheme(),
            execute: () => {
                manager.toggleAdaptiveTheme().catch(console.warn);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.themeScrollbars, {
            label: trans.__('Theme Scrollbars'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isToggled: () => manager.isToggledThemeScrollbars(),
            execute: () => manager.toggleThemeScrollbars()
        });
        commands.addCommand(themesplugins_CommandIDs.changeFont, {
            label: args => args['enabled'] ? `${args['font']}` : trans.__('waiting for fonts'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        enabled: {
                            type: 'boolean',
                            description: trans.__('Whether the font is available and enabled')
                        },
                        font: {
                            type: 'string',
                            description: trans.__('The font name')
                        },
                        key: {
                            type: 'string',
                            description: trans.__('The CSS property key to modify')
                        }
                    },
                    required: ['enabled', 'font', 'key']
                }
            },
            isEnabled: args => args['enabled'],
            isToggled: args => manager.getCSS(args['key']) === args['font'],
            execute: args => manager.setCSSOverride(args['key'], args['font'])
        });
        commands.addCommand(themesplugins_CommandIDs.incrFontSize, {
            label: args => {
                switch (args.key) {
                    case 'code-font-size':
                        return trans.__('Increase Code Font Size');
                    case 'content-font-size1':
                        return trans.__('Increase Content Font Size');
                    case 'ui-font-size1':
                        return trans.__('Increase UI Font Size');
                    default:
                        return trans.__('Increase Font Size');
                }
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        key: {
                            type: 'string',
                            description: trans.__('The font size key to increase (e.g., "code-font-size", "content-font-size1", "ui-font-size1")')
                        }
                    },
                    required: ['key']
                }
            },
            execute: args => manager.incrFontSize(args['key'])
        });
        commands.addCommand(themesplugins_CommandIDs.decrFontSize, {
            label: args => {
                switch (args.key) {
                    case 'code-font-size':
                        return trans.__('Decrease Code Font Size');
                    case 'content-font-size1':
                        return trans.__('Decrease Content Font Size');
                    case 'ui-font-size1':
                        return trans.__('Decrease UI Font Size');
                    default:
                        return trans.__('Decrease Font Size');
                }
            },
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        key: {
                            type: 'string',
                            description: trans.__('The font size key to decrease (e.g., "code-font-size", "content-font-size1", "ui-font-size1")')
                        }
                    },
                    required: ['key']
                }
            },
            execute: args => manager.decrFontSize(args['key'])
        });
        const darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
        const syncThemeOnSystemChange = (event) => {
            // Only act if the "Synchronize with System Settings" option is enabled.
            if (manager.isToggledAdaptiveTheme()) {
                const newTheme = event.matches
                    ? manager.preferredDarkTheme
                    : manager.preferredLightTheme;
                // Switch the theme if it's not already the correct one.
                if (manager.theme !== newTheme) {
                    void manager.setTheme(newTheme);
                }
            }
        };
        darkModeMediaQuery.addEventListener('change', syncThemeOnSystemChange);
        return manager;
    },
    autoStart: true,
    provides: lib_index_js_.IThemeManager
};
/**
 * The default theme manager's UI command palette and main menu functionality.
 *
 * #### Notes
 * This plugin loads separately from the theme manager plugin in order to
 * prevent blocking of the theme manager while it waits for the command palette
 * and main menu to become available.
 */
const themesPaletteMenuPlugin = {
    id: '@jupyterlab/apputils-extension:themes-palette-menu',
    description: 'Adds theme commands to the menu and the command palette.',
    requires: [lib_index_js_.IThemeManager, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette, mainmenu_lib_index_js_.IMainMenu],
    activate: (app, manager, translator, palette, mainMenu) => {
        const trans = translator.load('jupyterlab');
        // If we have a main menu, add the theme manager to the settings menu.
        if (mainMenu) {
            void app.restored.then(() => {
                var _a;
                const isPalette = false;
                const themeMenu = (_a = mainMenu.settingsMenu.items.find(item => {
                    var _a;
                    return item.type === 'submenu' &&
                        ((_a = item.submenu) === null || _a === void 0 ? void 0 : _a.id) === 'jp-mainmenu-settings-apputilstheme';
                })) === null || _a === void 0 ? void 0 : _a.submenu;
                // choose a theme
                if (themeMenu) {
                    manager.themes.forEach((theme, index) => {
                        themeMenu.insertItem(index, {
                            command: themesplugins_CommandIDs.changeTheme,
                            args: { isPalette, theme }
                        });
                    });
                }
            });
        }
        // If we have a command palette, add theme switching options to it.
        if (palette) {
            void app.restored.then(() => {
                const category = trans.__('Theme');
                const command = themesplugins_CommandIDs.changeTheme;
                const isPalette = true;
                // choose a theme
                manager.themes.forEach(theme => {
                    palette.addItem({ command, args: { isPalette, theme }, category });
                });
                // choose preferred light theme
                manager.themes.forEach(theme => {
                    palette.addItem({
                        command: themesplugins_CommandIDs.changePreferredLightTheme,
                        args: { isPalette, theme },
                        category
                    });
                });
                // choose preferred dark theme
                manager.themes.forEach(theme => {
                    palette.addItem({
                        command: themesplugins_CommandIDs.changePreferredDarkTheme,
                        args: { isPalette, theme },
                        category
                    });
                });
                // toggle adaptive theme
                palette.addItem({
                    command: themesplugins_CommandIDs.toggleAdaptiveTheme,
                    args: { isPalette },
                    category
                });
                // toggle scrollbar theming
                palette.addItem({ command: themesplugins_CommandIDs.themeScrollbars, category });
                // increase/decrease code font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'code-font-size'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'code-font-size'
                    },
                    category
                });
                // increase/decrease content font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'content-font-size1'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'content-font-size1'
                    },
                    category
                });
                // increase/decrease ui font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'ui-font-size1'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'ui-font-size1'
                    },
                    category
                });
            });
        }
    },
    autoStart: true
};
//# sourceMappingURL=themesplugins.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/toolbarregistryplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/**
 * The default toolbar registry.
 */
const toolbarRegistry = {
    id: '@jupyterlab/apputils-extension:toolbar-registry',
    description: 'Provides toolbar items registry.',
    autoStart: true,
    provides: lib_index_js_.IToolbarWidgetRegistry,
    activate: (app) => {
        const registry = new lib_index_js_.ToolbarWidgetRegistry({
            defaultFactory: (0,lib_index_js_.createDefaultFactory)(app.commands)
        });
        return registry;
    }
};
//# sourceMappingURL=toolbarregistryplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/workspaces@^4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/workspaces/lib/index.js)
var workspaces_lib_index_js_ = __webpack_require__(66518);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/workspacesplugin.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







const WORKSPACE_NAME = 'jupyterlab-workspace';
const WORKSPACE_EXT = '.' + WORKSPACE_NAME;
const LAST_SAVE_ID = 'workspace-ui:lastSave';
const ICON_NAME = 'jp-JupyterIcon';
/**
 * The workspace MIME renderer.
 */
const workspacesPlugin = {
    id: '@jupyterlab/apputils-extension:workspaces',
    description: 'Add workspace file type.',
    autoStart: true,
    requires: [statedb_lib_index_js_.IStateDB, translation_lib_index_js_.ITranslator, index_js_.JupyterFrontEnd.IPaths],
    optional: [index_js_.IRouter, workspaces_lib_index_js_.IWorkspaceCommands],
    activate: (app, state, translator, paths, router, workspaceCommands) => {
        // The workspace factory creates dummy widgets to load a new workspace.
        const factory = new workspacesplugin_Private.WorkspaceFactory({
            workspaces: app.serviceManager.workspaces,
            state,
            translator,
            open: async (id) => {
                if (workspaceCommands) {
                    await app.commands.execute(workspaceCommands.open, { workspace: id });
                }
                else {
                    const workspacesBase = coreutils_lib_index_js_.URLExt.join(paths.urls.app, 'workspaces');
                    const url = coreutils_lib_index_js_.URLExt.join(workspacesBase, id);
                    if (!url.startsWith(workspacesBase)) {
                        throw new Error('Can only be used for workspaces');
                    }
                    if (router) {
                        router.navigate(url, { hard: true });
                    }
                    else {
                        document.location.href = url;
                    }
                }
            }
        });
        const trans = translator.load('jupyterlab');
        app.docRegistry.addFileType({
            name: WORKSPACE_NAME,
            contentType: 'file',
            fileFormat: 'text',
            displayName: trans.__('JupyterLab Workspace File'),
            extensions: [WORKSPACE_EXT],
            mimeTypes: ['text/json'],
            iconClass: ICON_NAME
        });
        app.docRegistry.addWidgetFactory(factory);
    }
};
var workspacesplugin_Private;
(function (Private) {
    /**
     * This widget factory is used to handle double click on workspace
     */
    class WorkspaceFactory extends docregistry_lib_index_js_.ABCWidgetFactory {
        /**
         * Construct a widget factory that uploads a workspace and navigates to it.
         *
         * @param options - The instantiation options for a `WorkspaceFactory`.
         */
        constructor(options) {
            const trans = (options.translator || translation_lib_index_js_.nullTranslator).load('jupyterlab');
            super({
                name: 'Workspace loader',
                label: trans.__('Workspace loader'),
                fileTypes: [WORKSPACE_NAME],
                defaultFor: [WORKSPACE_NAME],
                readOnly: true
            });
            this._state = options.state;
            this._workspaces = options.workspaces;
            this._open = options.open;
        }
        /**
         * Loads the workspace into load, and jump to it
         * @param context This is used to query the workspace content
         */
        createNewWidget(context) {
            // Save a file's contents as a workspace and navigate to that workspace.
            void context.ready.then(async () => {
                const file = context.model;
                const workspace = file.toJSON();
                const path = context.path;
                const id = workspace.metadata.id;
                // Save the file contents as a workspace.
                await this._workspaces.save(id, workspace);
                // Save last save location for the save command.
                await this._state.save(LAST_SAVE_ID, path);
                // Navigate to new workspace.
                await this._open(id);
            });
            return dummyWidget(context);
        }
    }
    Private.WorkspaceFactory = WorkspaceFactory;
    /**
     * Returns a dummy widget with disposed content that doesn't render in the UI.
     *
     * @param context - The file context.
     */
    function dummyWidget(context) {
        const widget = new docregistry_lib_index_js_.DocumentWidget({ content: new widgets_dist_index_es6_js_.Widget(), context });
        widget.content.dispose();
        return widget;
    }
})(workspacesplugin_Private || (workspacesplugin_Private = {}));
//# sourceMappingURL=workspacesplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/domutils@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/domutils/dist/index.es6.js)
var domutils_dist_index_es6_js_ = __webpack_require__(60930);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/shortcuts.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




/**
 * The class name for each row of ContextShortcutTable
 */
const SHORTCUT_TABLE_ROW_CLASS = 'jp-ContextualShortcut-TableRow';
/**
 * The class name for the last row of ContextShortcutTable
 */
const SHORTCUT_TABLE_LAST_ROW_CLASS = 'jp-ContextualShortcut-TableLastRow';
/**
 * The class name for each item of ContextShortcutTable
 */
const SHORTCUT_TABLE_ITEM_CLASS = 'jp-ContextualShortcut-TableItem';
/**
 * The class name for each button-like symbol representing a key used in a shortcut in the ContextShortcutTable
 */
const SHORTCUT_KEY_CLASS = 'jp-ContextualShortcut-Key';
function displayShortcuts(options) {
    const { commands, trans, activeElement } = options;
    const elt = activeElement !== null && activeElement !== void 0 ? activeElement : document.activeElement;
    /**
     * Find the distance from the target node to the first matching node.
     *
     * Based on Lumino private function commands.Private.targetDistance
     * This traverses the DOM path from `elt` to the root
     * computes the distance from `elt` to the first node which matches
     * the CSS selector. If no match is found, `-1` is returned.
     *
     * It also stops traversal if the `data-lm-suppress-shortcuts` or
     * `data-p-suppress-shortcuts` attributes are found.
     */
    function formatKeys(keys) {
        const topContainer = [];
        keys.forEach((key, index) => {
            const container = [];
            key.split(' ').forEach((ch, chIndex) => {
                container.push(react_index_js_.createElement("span", { className: SHORTCUT_KEY_CLASS, key: `ch-${chIndex}` },
                    react_index_js_.createElement("kbd", null, ch)), react_index_js_.createElement(react_index_js_.Fragment, { key: `fragment-${chIndex}` }, " + "));
            });
            topContainer.push(react_index_js_.createElement("span", { key: `key-${index}` }, container.slice(0, -1)), react_index_js_.createElement(react_index_js_.Fragment, { key: `fragment-${index}` }, " + "));
        });
        return react_index_js_.createElement("span", null, topContainer.slice(0, -1));
    }
    function capitalizeString(str) {
        const capitalizedStr = str.charAt(0).toUpperCase() + str.slice(1);
        return capitalizedStr;
    }
    function formatLabel(b) {
        const label = commands.label(b.command);
        const commandID = b.command.split(':')[1];
        const automaticLabel = commandID.split('-');
        let capitalizedLabel = '';
        for (let i = 0; i < automaticLabel.length; i++) {
            const str = capitalizeString(automaticLabel[i]);
            capitalizedLabel = capitalizedLabel + ' ' + str;
        }
        if (label.length > 0) {
            return label;
        }
        else {
            return capitalizedLabel;
        }
    }
    function matchDistance(selector, elt) {
        let targ = elt;
        for (let dist = 0; targ !== null && targ !== targ.parentElement; targ = targ.parentElement, ++dist) {
            if (targ.hasAttribute('data-lm-suppress-shortcuts')) {
                return -1;
            }
            if (targ.matches(selector)) {
                return dist;
            }
        }
        return -1;
    }
    // Find active keybindings for target element
    const activeBindings = new Map();
    for (let i = 0; i < commands.keyBindings.length; i++) {
        const kb = commands.keyBindings[i];
        let distance = matchDistance(kb.selector, elt);
        if (distance < 0) {
            continue;
        }
        let formatted = commands_dist_index_es6_js_.CommandRegistry.formatKeystroke(kb.keys);
        if (activeBindings.has(formatted)) {
            let oldBinding = activeBindings.get(formatted);
            // if the existing binding takes precedence, ignore this binding by continuing
            if (oldBinding[0] < distance ||
                (oldBinding[0] === distance &&
                    domutils_dist_index_es6_js_.Selector.calculateSpecificity(oldBinding[1].selector) >
                        domutils_dist_index_es6_js_.Selector.calculateSpecificity(kb.selector))) {
                continue;
            }
        }
        activeBindings.set(formatted, [distance, kb]);
    }
    // Group shortcuts by distance
    let maxDistance = -1;
    const groupedBindings = new Map();
    for (let [distance, binding] of activeBindings.values()) {
        maxDistance = Math.max(distance, maxDistance);
        if (!groupedBindings.has(distance)) {
            groupedBindings.set(distance, []);
        }
        groupedBindings.get(distance).push(binding);
    }
    // Display shortcuts by group
    const bindingTable = [];
    for (let d = 0; d <= maxDistance; d++) {
        if (groupedBindings.has(d)) {
            bindingTable.push(groupedBindings.get(d).map(b => (react_index_js_.createElement("tr", { className: SHORTCUT_TABLE_ROW_CLASS, key: `${b.command}-${b.keys.join('-').replace(' ', '_')}` },
                react_index_js_.createElement("td", { className: SHORTCUT_TABLE_ITEM_CLASS }, formatLabel(b)),
                react_index_js_.createElement("td", { className: SHORTCUT_TABLE_ITEM_CLASS }, formatKeys([...b.keys]))))));
            bindingTable.push(react_index_js_.createElement("tr", { className: SHORTCUT_TABLE_LAST_ROW_CLASS, key: `group-${d}-last` }));
        }
    }
    const body = (react_index_js_.createElement("table", null,
        react_index_js_.createElement("tbody", null, bindingTable)));
    return (0,lib_index_js_.showDialog)({
        title: trans.__('Keyboard Shortcuts'),
        body,
        buttons: [
            lib_index_js_.Dialog.cancelButton({
                label: trans.__('Close')
            })
        ]
    });
}
//# sourceMappingURL=shortcuts.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module apputils-extension
 */






















/**
 * The interval in milliseconds before recover options appear during splash.
 */
const SPLASH_RECOVER_TIMEOUT = 12000;
/**
 * The command IDs used by the apputils plugin.
 */
var lib_CommandIDs;
(function (CommandIDs) {
    CommandIDs.loadState = 'apputils:load-statedb';
    CommandIDs.print = 'apputils:print';
    CommandIDs.reset = 'apputils:reset';
    CommandIDs.resetOnLoad = 'apputils:reset-on-load';
    CommandIDs.runFirstEnabled = 'apputils:run-first-enabled';
    CommandIDs.runAllEnabled = 'apputils:run-all-enabled';
    CommandIDs.toggleHeader = 'apputils:toggle-header';
    CommandIDs.displayShortcuts = 'apputils:display-shortcuts';
})(lib_CommandIDs || (lib_CommandIDs = {}));
/**
 * The default command palette extension.
 */
const lib_palette = {
    id: '@jupyterlab/apputils-extension:palette',
    description: 'Provides the command palette.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    provides: lib_index_js_.ICommandPalette,
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, translator, settingRegistry) => {
        return palette_Palette.activate(app, translator, settingRegistry);
    }
};
/**
 * The default command palette's restoration extension.
 *
 * #### Notes
 * The command palette's restoration logic is handled separately from the
 * command palette provider extension because the layout restorer dependency
 * causes the command palette to be unavailable to other extensions earlier
 * in the application load cycle.
 */
const paletteRestorer = {
    id: '@jupyterlab/apputils-extension:palette-restorer',
    description: 'Restores the command palette.',
    autoStart: true,
    requires: [index_js_.ILayoutRestorer, translation_lib_index_js_.ITranslator],
    activate: (app, restorer, translator) => {
        palette_Palette.restore(app, restorer, translator);
    }
};
/**
 * The default window name resolver provider.
 */
const lib_resolver = {
    id: '@jupyterlab/apputils-extension:resolver',
    description: 'Provides the window name resolver.',
    autoStart: true,
    provides: lib_index_js_.IWindowResolver,
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter],
    activate: async (app, paths, router) => {
        const { hash, search } = router.current;
        const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
        const solver = new lib_index_js_.WindowResolver();
        const workspace = coreutils_lib_index_js_.PageConfig.getOption('workspace');
        const treePath = coreutils_lib_index_js_.PageConfig.getOption('treePath');
        const mode = coreutils_lib_index_js_.PageConfig.getOption('mode') === 'multiple-document' ? 'lab' : 'doc';
        // This is used as a key in local storage to refer to workspaces, either the name
        // of the workspace or the string PageConfig.defaultWorkspace. Both lab and doc modes share the same workspace.
        const candidate = workspace ? workspace : coreutils_lib_index_js_.PageConfig.defaultWorkspace;
        const rest = treePath ? coreutils_lib_index_js_.URLExt.join('tree', treePath) : '';
        try {
            await solver.resolve(candidate);
            return solver;
        }
        catch (error) {
            // Window resolution has failed so the URL must change. Return a promise
            // that never resolves to prevent the application from loading plugins
            // that rely on `IWindowResolver`.
            return new Promise(() => {
                const { base } = paths.urls;
                const pool = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                const random = pool[Math.floor(Math.random() * pool.length)];
                let path = coreutils_lib_index_js_.URLExt.join(base, mode, 'workspaces', `auto-${random}`);
                path = rest ? coreutils_lib_index_js_.URLExt.join(path, coreutils_lib_index_js_.URLExt.encodeParts(rest)) : path;
                // Reset the workspace on load.
                query['reset'] = '';
                const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + (hash || '');
                router.navigate(url, { hard: true });
            });
        }
    }
};
/**
 * The default splash screen provider.
 */
const lib_splash = {
    id: '@jupyterlab/apputils-extension:splash',
    description: 'Provides the splash screen.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    provides: lib_index_js_.ISplashScreen,
    activate: (app, translator) => {
        const trans = translator.load('jupyterlab');
        const { commands, restored } = app;
        // Create splash element and populate it.
        const splash = document.createElement('div');
        const galaxy = document.createElement('div');
        const logo = document.createElement('div');
        splash.id = 'jupyterlab-splash';
        galaxy.id = 'galaxy';
        logo.id = 'main-logo';
        ui_components_lib_index_js_.jupyterFaviconIcon.element({
            container: logo,
            stylesheet: 'splash'
        });
        galaxy.appendChild(logo);
        ['1', '2', '3'].forEach(id => {
            const moon = document.createElement('div');
            const planet = document.createElement('div');
            moon.id = `moon${id}`;
            moon.className = 'moon orbit';
            planet.id = `planet${id}`;
            planet.className = 'planet';
            moon.appendChild(planet);
            galaxy.appendChild(moon);
        });
        splash.appendChild(galaxy);
        // Create debounced recovery dialog function.
        let dialog;
        const recovery = new dist_index_es6_js_.Throttler(async () => {
            if (dialog) {
                return;
            }
            dialog = new lib_index_js_.Dialog({
                title: trans.__('Loading…'),
                body: trans.__(`The loading screen is taking a long time.
Would you like to clear the workspace or keep waiting?`),
                buttons: [
                    lib_index_js_.Dialog.cancelButton({ label: trans.__('Keep Waiting') }),
                    lib_index_js_.Dialog.warnButton({ label: trans.__('Clear Workspace') })
                ]
            });
            try {
                const result = await dialog.launch();
                dialog.dispose();
                dialog = null;
                if (result.button.accept && commands.hasCommand(lib_CommandIDs.reset)) {
                    return commands.execute(lib_CommandIDs.reset);
                }
                // Re-invoke the recovery timer in the next frame.
                requestAnimationFrame(() => {
                    // Because recovery can be stopped, handle invocation rejection.
                    void recovery.invoke().catch(_ => undefined);
                });
            }
            catch (error) {
                /* no-op */
            }
        }, { limit: SPLASH_RECOVER_TIMEOUT, edge: 'trailing' });
        // Return ISplashScreen.
        let splashCount = 0;
        return {
            show: (light = true) => {
                splash.classList.remove('splash-fade');
                splash.classList.toggle('light', light);
                splash.classList.toggle('dark', !light);
                splashCount++;
                document.body.appendChild(splash);
                // Because recovery can be stopped, handle invocation rejection.
                void recovery.invoke().catch(_ => undefined);
                return new index_es6_js_.DisposableDelegate(async () => {
                    await restored;
                    if (--splashCount === 0) {
                        void recovery.stop();
                        if (dialog) {
                            dialog.dispose();
                            dialog = null;
                        }
                        splash.classList.add('splash-fade');
                        window.setTimeout(() => {
                            document.body.removeChild(splash);
                        }, 200);
                    }
                });
            }
        };
    }
};
const print = {
    id: '@jupyterlab/apputils-extension:print',
    description: 'Add the print capability',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        var _a;
        const trans = translator.load('jupyterlab');
        app.commands.addCommand(lib_CommandIDs.print, {
            label: trans.__('Print…'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => {
                const widget = app.shell.currentWidget;
                return lib_index_js_.Printing.getPrintFunction(widget) !== null;
            },
            execute: async () => {
                const widget = app.shell.currentWidget;
                const printFunction = lib_index_js_.Printing.getPrintFunction(widget);
                if (printFunction) {
                    await printFunction();
                }
            }
        });
        (_a = app.shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            app.commands.notifyCommandChanged(lib_CommandIDs.print);
        });
    }
};
const toggleHeader = {
    id: '@jupyterlab/apputils-extension:toggle-header',
    description: 'Adds a command to display the main area widget content header.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    activate: (app, translator, palette) => {
        var _a;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Main Area');
        app.commands.addCommand(lib_CommandIDs.toggleHeader, {
            label: trans.__('Show Header Above Content'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            isEnabled: () => app.shell.currentWidget instanceof lib_index_js_.MainAreaWidget &&
                !app.shell.currentWidget.contentHeader.isDisposed &&
                app.shell.currentWidget.contentHeader.widgets.length > 0,
            isToggled: () => {
                const widget = app.shell.currentWidget;
                return widget instanceof lib_index_js_.MainAreaWidget
                    ? !widget.contentHeader.isHidden
                    : false;
            },
            execute: async () => {
                const widget = app.shell.currentWidget;
                if (widget instanceof lib_index_js_.MainAreaWidget) {
                    widget.contentHeader.setHidden(!widget.contentHeader.isHidden);
                }
            }
        });
        (_a = app.shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            app.commands.notifyCommandChanged(lib_CommandIDs.toggleHeader);
        });
        if (palette) {
            palette.addItem({ command: lib_CommandIDs.toggleHeader, category });
        }
    }
};
/**
 * Update the browser title based on the workspace and the current
 * active item.
 */
async function updateTabTitle(options) {
    var _a, _b;
    const { workspace, db, name, currentWidget } = options;
    const data = await db.toJSON();
    let current = (_b = (_a = data['layout-restorer:data']) === null || _a === void 0 ? void 0 : _a.main) === null || _b === void 0 ? void 0 : _b.current;
    if (current === undefined ||
        !(current.startsWith('notebook') || current.startsWith('editor'))) {
        document.title = `${coreutils_lib_index_js_.PageConfig.getOption('appName') || 'JupyterLab'}${workspace === 'default' ? '' : ` (${workspace})`}`;
    }
    else {
        let currentFile;
        // If we have a DocumentWidget, use its context.path for more reliable file name
        // rather than parsing the URL which may not always reflect the actual file,
        // may be missing, or may be formatted in a different way in other lab-based
        // applications (for example with a query string parameter such as ?path=example.ipynb)
        if (currentWidget instanceof docregistry_lib_index_js_.DocumentWidget) {
            currentFile = coreutils_lib_index_js_.PathExt.basename(currentWidget.context.path);
        }
        else {
            // File name from current path
            currentFile = coreutils_lib_index_js_.PathExt.basename(decodeURIComponent(window.location.href));
        }
        // Truncate to first 12 characters of current document name + ... if length > 15
        currentFile =
            currentFile.length > 15
                ? currentFile.slice(0, 12).concat(`…`)
                : currentFile;
        const truncatedWorkspace = workspace.length > 15 ? workspace.slice(0, 12).concat(`…`) : workspace;
        // Number of restorable items that are either notebooks or editors
        const count = Object.keys(data).filter(item => item.startsWith('notebook') || item.startsWith('editor')).length;
        document.title = `${currentFile}${count > 1 ? ` (${count})` : ``} - ${workspace === 'default' ? name : truncatedWorkspace}`;
    }
}
/**
 * The default state database for storing application state.
 *
 * #### Notes
 * If this extension is loaded with a window resolver, it will automatically add
 * state management commands, URL support for `clone` and `reset`, and workspace
 * auto-saving. Otherwise, it will return a simple in-memory state database.
 */
const lib_state = {
    id: '@jupyterlab/apputils-extension:state',
    description: 'Provides the application state. It is stored per workspaces.',
    autoStart: true,
    provides: statedb_lib_index_js_.IStateDB,
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.IWindowResolver],
    activate: (app, paths, router, translator, resolver) => {
        const trans = translator.load('jupyterlab');
        if (resolver === null) {
            return new statedb_lib_index_js_.StateDB();
        }
        let resolved = false;
        const { commands, name, serviceManager } = app;
        const { workspaces } = serviceManager;
        const workspace = resolver.name;
        const transform = new dist_index_js_.PromiseDelegate();
        const db = new statedb_lib_index_js_.StateDB({ transform: transform.promise });
        const save = new dist_index_es6_js_.Debouncer(async () => {
            const id = workspace;
            const metadata = { id };
            const data = await db.toJSON();
            await workspaces.save(id, { data, metadata });
        });
        // Any time the local state database changes, save the workspace.
        db.changed.connect(() => void save.invoke(), db);
        db.changed.connect(() => {
            var _a;
            return updateTabTitle({
                workspace,
                db,
                name,
                currentWidget: (_a = app.shell.currentWidget) !== null && _a !== void 0 ? _a : undefined
            });
        });
        commands.addCommand(lib_CommandIDs.loadState, {
            label: trans.__('Load state for the current workspace.'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        hash: {
                            type: 'string',
                            description: trans.__('The URL hash')
                        },
                        path: {
                            type: 'string',
                            description: trans.__('The URL path')
                        },
                        search: {
                            type: 'string',
                            description: trans.__('The URL search string containing query parameters')
                        }
                    }
                }
            },
            execute: async (args) => {
                // Since the command can be executed an arbitrary number of times, make
                // sure it is safe to call multiple times.
                if (resolved) {
                    return;
                }
                const { hash, path, search } = args;
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
                const clone = typeof query['clone'] === 'string'
                    ? query['clone'] === ''
                        ? coreutils_lib_index_js_.PageConfig.defaultWorkspace
                        : query['clone']
                    : null;
                const source = clone || workspace || null;
                if (source === null) {
                    console.error(`${lib_CommandIDs.loadState} cannot load null workspace.`);
                    return;
                }
                try {
                    const saved = await workspaces.fetch(source);
                    // If this command is called after a reset, the state database
                    // will already be resolved.
                    if (!resolved) {
                        resolved = true;
                        transform.resolve({ type: 'overwrite', contents: saved.data });
                    }
                }
                catch ({ message }) {
                    console.warn(`Fetching workspace "${workspace}" failed.`, message);
                    // If the workspace does not exist, cancel the data transformation
                    // and save a workspace with the current user state data.
                    if (!resolved) {
                        resolved = true;
                        transform.resolve({ type: 'cancel', contents: null });
                    }
                }
                if (source === clone) {
                    // Maintain the query string parameters but remove `clone`.
                    delete query['clone'];
                    const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + hash;
                    const cloned = save.invoke().then(() => router.stop);
                    // After the state has been cloned, navigate to the URL.
                    void cloned.then(() => {
                        router.navigate(url);
                    });
                    return cloned;
                }
                // After the state database has finished loading, save it.
                await save.invoke();
            }
        });
        commands.addCommand(lib_CommandIDs.reset, {
            label: trans.__('Reset Application State'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        reload: {
                            type: 'boolean',
                            description: trans.__('Whether to reload the page after resetting')
                        }
                    }
                }
            },
            execute: async ({ reload }) => {
                await db.clear();
                await save.invoke();
                if (reload) {
                    router.reload();
                }
            }
        });
        commands.addCommand(lib_CommandIDs.resetOnLoad, {
            label: trans.__('Reset state when loading for the workspace.'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        hash: {
                            type: 'string',
                            description: trans.__('The URL hash')
                        },
                        path: {
                            type: 'string',
                            description: trans.__('The URL path')
                        },
                        search: {
                            type: 'string',
                            description: trans.__('The URL search string containing query parameters')
                        }
                    }
                }
            },
            execute: (args) => {
                const { hash, path, search } = args;
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
                const reset = 'reset' in query;
                const clone = 'clone' in query;
                if (!reset) {
                    return;
                }
                // If the state database has already been resolved, resetting is
                // impossible without reloading.
                if (resolved) {
                    return router.reload();
                }
                // Empty the state database.
                resolved = true;
                transform.resolve({ type: 'clear', contents: null });
                // Maintain the query string parameters but remove `reset`.
                delete query['reset'];
                const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + hash;
                const cleared = db.clear().then(() => save.invoke());
                // After the state has been reset, navigate to the URL.
                if (clone) {
                    void cleared.then(() => {
                        router.navigate(url, { hard: true });
                    });
                }
                else {
                    void cleared.then(() => {
                        router.navigate(url);
                    });
                }
                return cleared;
            }
        });
        router.register({
            command: lib_CommandIDs.loadState,
            pattern: /.?/,
            rank: 30 // High priority: 30:100.
        });
        router.register({
            command: lib_CommandIDs.resetOnLoad,
            pattern: /(\?reset|\&reset)($|&)/,
            rank: 20 // High priority: 20:100.
        });
        return db;
    }
};
/**
 * The default session context dialogs extension.
 */
const lib_sessionDialogs = {
    id: '@jupyterlab/apputils-extension:sessionDialogs',
    description: 'Provides the session context dialogs.',
    provides: lib_index_js_.ISessionContextDialogs,
    optional: [translation_lib_index_js_.ITranslator, settingregistry_lib_index_js_.ISettingRegistry],
    autoStart: true,
    activate: async (app, translator, settingRegistry) => {
        return new lib_index_js_.SessionContextDialogs({
            translator: translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator,
            settingRegistry: settingRegistry !== null && settingRegistry !== void 0 ? settingRegistry : null
        });
    }
};
/**
 * Utility commands
 */
const utilityCommands = {
    id: '@jupyterlab/apputils-extension:utilityCommands',
    description: 'Adds meta commands to run set of other commands.',
    requires: [translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    autoStart: true,
    activate: (app, translator, palette) => {
        const trans = translator.load('jupyterlab');
        const { commands } = app;
        commands.addCommand(lib_CommandIDs.runFirstEnabled, {
            label: trans.__('Run First Enabled Command'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        commands: {
                            type: 'array',
                            items: {
                                type: 'string'
                            },
                            description: trans.__('Array of command IDs to attempt to run')
                        },
                        args: {
                            description: trans.__('Arguments to pass to the commands')
                        }
                    },
                    required: ['commands']
                }
            },
            execute: args => {
                const commands = args.commands;
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                for (let i = 0; i < commands.length; i++) {
                    const cmd = commands[i];
                    const arg = argList ? commandArgs[i] : commandArgs;
                    if (app.commands.isEnabled(cmd, arg)) {
                        return app.commands.execute(cmd, arg);
                    }
                }
            }
        });
        // Add a command for taking lists of commands and command arguments
        // and running all the enabled commands.
        commands.addCommand(lib_CommandIDs.runAllEnabled, {
            label: trans.__('Run All Enabled Commands Passed as Args'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {
                        commands: {
                            type: 'array',
                            items: {
                                type: 'string'
                            },
                            description: trans.__('Array of command IDs to run')
                        },
                        args: {
                            description: trans.__('Arguments to pass to the commands')
                        },
                        errorIfNotEnabled: {
                            type: 'boolean',
                            description: trans.__('Whether to log an error if a command is not enabled')
                        }
                    }
                }
            },
            execute: async (args) => {
                var _a, _b;
                const commands = (_a = args.commands) !== null && _a !== void 0 ? _a : [];
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                const errorIfNotEnabled = (_b = args.errorIfNotEnabled) !== null && _b !== void 0 ? _b : false;
                for (let i = 0; i < commands.length; i++) {
                    const cmd = commands[i];
                    const arg = argList ? commandArgs[i] : commandArgs;
                    if (app.commands.isEnabled(cmd, arg)) {
                        await app.commands.execute(cmd, arg);
                    }
                    else {
                        if (errorIfNotEnabled) {
                            console.error(`${cmd} is not enabled.`);
                        }
                    }
                }
            },
            isEnabled: args => {
                var _a;
                const commands = (_a = args.commands) !== null && _a !== void 0 ? _a : [];
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                return commands.some((cmd, idx) => app.commands.isEnabled(cmd, argList ? commandArgs[idx] : commandArgs));
            }
        });
        commands.addCommand(lib_CommandIDs.displayShortcuts, {
            label: trans.__('Show Keyboard Shortcuts…'),
            caption: trans.__('Show relevant keyboard shortcuts for the current active widget'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: args => {
                var _a;
                const currentWidget = app.shell.currentWidget;
                const included = currentWidget === null || currentWidget === void 0 ? void 0 : currentWidget.node.contains(document.activeElement);
                if (!included && currentWidget instanceof lib_index_js_.MainAreaWidget) {
                    const currentNode = (_a = currentWidget.content.node) !== null && _a !== void 0 ? _a : currentWidget === null || currentWidget === void 0 ? void 0 : currentWidget.node;
                    currentNode === null || currentNode === void 0 ? void 0 : currentNode.focus();
                }
                const options = { commands, trans };
                return displayShortcuts(options);
            }
        });
        if (palette) {
            const category = trans.__('Help');
            palette.addItem({ command: lib_CommandIDs.displayShortcuts, category });
        }
    }
};
/**
 * The default HTML sanitizer.
 */
const lib_sanitizer = {
    id: '@jupyterlab/apputils-extension:sanitizer',
    description: 'Provides the HTML sanitizer.',
    autoStart: true,
    provides: lib_index_js_.ISanitizer,
    requires: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settings) => {
        const sanitizer = new lib_index_js_.Sanitizer();
        const loadSetting = (setting) => {
            const allowedSchemes = setting.get('allowedSchemes')
                .composite;
            const autolink = setting.get('autolink').composite;
            const allowNamedProperties = setting.get('allowNamedProperties')
                .composite;
            if (allowedSchemes) {
                sanitizer.setAllowedSchemes(allowedSchemes);
            }
            sanitizer.setAutolink(autolink);
            sanitizer.setAllowNamedProperties(allowNamedProperties);
        };
        // Wait for the application to be restored and
        // for the settings for this plugin to be loaded
        settings
            .load('@jupyterlab/apputils-extension:sanitizer')
            .then(setting => {
            // Read the settings
            loadSetting(setting);
            // Listen for your plugin setting changes using Signal
            setting.changed.connect(loadSetting);
        })
            .catch(reason => {
            console.error(`Failed to load sanitizer settings:`, reason);
        });
        return sanitizer;
    }
};
/*
 * A plugin owning the kernel settings
 */
const lib_kernelSettings = {
    id: '@jupyterlab/apputils-extension:kernels-settings',
    description: 'Reserves the name for kernel settings.',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (_app, settingRegistry) => {
        void settingRegistry.load(lib_kernelSettings.id);
    }
};
/**
 * Export the plugins as default.
 */
const lib_plugins = [
    lib_kernelSettings,
    announcements,
    kernelStatus,
    licensesClient,
    licensesPlugin,
    notificationPlugin,
    lib_palette,
    paletteRestorer,
    print,
    lib_resolver,
    runningSessionsStatus,
    subshell_settings_subshellsSettings,
    lib_sanitizer,
    settingsplugin_settingsConnector,
    settingsPlugin,
    lib_state,
    lib_splash,
    lib_sessionDialogs,
    themesPlugin,
    themesPaletteMenuPlugin,
    toggleHeader,
    toolbarRegistry,
    utilityCommands,
    workspacesPlugin
];
/* export default */ const lib = (lib_plugins);
//# sourceMappingURL=index.js.map

},
32550(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(67842);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(59372);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(14546);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/mainmenu/style/index.js
var mainmenu_style = __webpack_require__(75200);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/apputils-extension/style/base.css
var base = __webpack_require__(18024);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */











},
5706(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  translateKernelStatuses: () => (/* reexport */ translateKernelStatuses),
  DOMUtils: () => (/* reexport */ domutils_DOMUtils),
  createDefaultFactory: () => (/* reexport */ createDefaultFactory),
  addCommandToolbarButtonClass: () => (/* reexport */ index_js_.addCommandToolbarButtonClass),
  VDomRenderer: () => (/* reexport */ index_js_.VDomRenderer),
  Styling: () => (/* reexport */ index_js_.Styling),
  ILicensesClient: () => (/* reexport */ ILicensesClient),
  InputDialog: () => (/* reexport */ inputdialog_InputDialog),
  Collapse: () => (/* reexport */ index_js_.Collapser),
  KernelStatus: () => (/* reexport */ kernelstatuses_KernelStatus),
  showErrorMessage: () => (/* reexport */ showErrorMessage),
  IThemeManager: () => (/* reexport */ IThemeManager),
  CommandToolbarButton: () => (/* reexport */ index_js_.CommandToolbarButton),
  RunningSessions: () => (/* reexport */ runningSessions_RunningSessions),
  showDialog: () => (/* reexport */ showDialog),
  CommandToolbarButtonComponent: () => (/* reexport */ index_js_.CommandToolbarButtonComponent),
  NotificationManager: () => (/* reexport */ NotificationManager),
  Printing: () => (/* reexport */ printing_Printing),
  SessionContextDialogs: () => (/* reexport */ sessioncontext_SessionContextDialogs),
  Toolbar: () => (/* binding */ lib_Toolbar),
  Notification: () => (/* reexport */ notification_Notification),
  IToolbarWidgetRegistry: () => (/* reexport */ IToolbarWidgetRegistry),
  MainAreaWidget: () => (/* reexport */ MainAreaWidget),
  SessionContext: () => (/* reexport */ sessioncontext_SessionContext),
  CommandLinker: () => (/* reexport */ CommandLinker),
  SemanticCommand: () => (/* reexport */ SemanticCommand),
  addToolbarButtonClass: () => (/* reexport */ index_js_.addToolbarButtonClass),
  ToolbarButton: () => (/* reexport */ index_js_.ToolbarButton),
  UseSignal: () => (/* reexport */ index_js_.UseSignal),
  Dialog: () => (/* reexport */ dialog_Dialog),
  MenuFactory: () => (/* reexport */ menufactory_MenuFactory),
  Spinner: () => (/* reexport */ index_js_.Spinner),
  ToolbarButtonComponent: () => (/* reexport */ index_js_.ToolbarButtonComponent),
  ICommandPalette: () => (/* reexport */ ICommandPalette),
  ISanitizer: () => (/* reexport */ ISanitizer),
  ISessionContextDialogs: () => (/* reexport */ ISessionContextDialogs),
  HoverBox: () => (/* reexport */ index_js_.HoverBox),
  Sanitizer: () => (/* reexport */ Sanitizer),
  IKernelStatusModel: () => (/* reexport */ IKernelStatusModel),
  ReactWidget: () => (/* reexport */ index_js_.ReactWidget),
  Licenses: () => (/* reexport */ licenses_Licenses),
  ModalCommandPalette: () => (/* reexport */ ModalCommandPalette),
  IFrame: () => (/* reexport */ index_js_.IFrame),
  SystemClipboard: () => (/* reexport */ clipboard_SystemClipboard),
  ThemeManager: () => (/* reexport */ ThemeManager),
  ToolbarWidgetRegistry: () => (/* reexport */ ToolbarWidgetRegistry),
  VDomModel: () => (/* reexport */ index_js_.VDomModel),
  Clipboard: () => (/* reexport */ clipboard_Clipboard),
  WidgetTracker: () => (/* reexport */ WidgetTracker),
  IWindowResolver: () => (/* reexport */ IWindowResolver),
  WindowResolver: () => (/* reexport */ WindowResolver),
  createToolbarFactory: () => (/* reexport */ createToolbarFactory),
  setToolbar: () => (/* reexport */ setToolbar),
  ISplashScreen: () => (/* reexport */ ISplashScreen)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var lib_index_js_ = __webpack_require__(53816);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(34381);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
var react_index_js_default = /*#__PURE__*/__webpack_require__.n(react_index_js_);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(3744);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var signaling_dist_index_es6_js_ = __webpack_require__(16324);
// EXTERNAL MODULE: consume shared module (default) @lumino/messaging@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/messaging/dist/index.es6.js)
var messaging_dist_index_es6_js_ = __webpack_require__(1884);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(36548);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/widgettracker.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * A class that keeps track of widget instances on an Application shell.
 *
 * @typeparam T - The type of widget being tracked. Defaults to `Widget`.
 *
 * #### Notes
 * The API surface area of this concrete implementation is substantially larger
 * than the widget tracker interface it implements. The interface is intended
 * for export by JupyterLab plugins that create widgets and have clients who may
 * wish to keep track of newly created widgets. This class, however, can be used
 * internally by plugins to restore state as well.
 */
class WidgetTracker {
    /**
     * Create a new widget tracker.
     *
     * @param options - The instantiation options for a widget tracker.
     */
    constructor(options) {
        this._currentChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._deferred = null;
        this._isDisposed = false;
        this._widgetAdded = new signaling_dist_index_es6_js_.Signal(this);
        this._widgetUpdated = new signaling_dist_index_es6_js_.Signal(this);
        const focus = (this._focusTracker = new index_es6_js_.FocusTracker());
        const pool = (this._pool = new statedb_lib_index_js_.RestorablePool(options));
        this.namespace = options.namespace;
        focus.currentChanged.connect((_, current) => {
            if (current.newValue !== this.currentWidget) {
                pool.current = current.newValue;
            }
        }, this);
        pool.added.connect((_, widget) => {
            this._widgetAdded.emit(widget);
        }, this);
        pool.currentChanged.connect((_, widget) => {
            // If the pool's current reference is `null` but the focus tracker has a
            // current widget, update the pool to match the focus tracker.
            if (widget === null && focus.currentWidget) {
                pool.current = focus.currentWidget;
                return;
            }
            this.onCurrentChanged(widget);
            this._currentChanged.emit(widget);
        }, this);
        pool.updated.connect((_, widget) => {
            this._widgetUpdated.emit(widget);
        }, this);
    }
    /**
     * A signal emitted when the current widget changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * The current widget is the most recently focused or added widget.
     *
     * #### Notes
     * It is the most recently focused widget, or the most recently added
     * widget if no widget has taken focus.
     */
    get currentWidget() {
        return this._pool.current || null;
    }
    /**
     * A promise resolved when the tracker has been restored.
     */
    get restored() {
        if (this._deferred) {
            return Promise.resolve();
        }
        else {
            return this._pool.restored;
        }
    }
    /**
     * The number of widgets held by the tracker.
     */
    get size() {
        return this._pool.size;
    }
    /**
     * A signal emitted when a widget is added.
     *
     * #### Notes
     * This signal will only fire when a widget is added to the tracker. It will
     * not fire if a widget is injected into the tracker.
     */
    get widgetAdded() {
        return this._widgetAdded;
    }
    /**
     * A signal emitted when a widget is updated.
     */
    get widgetUpdated() {
        return this._widgetUpdated;
    }
    /**
     * Add a new widget to the tracker.
     *
     * @param widget - The widget being added.
     *
     * #### Notes
     * The widget passed into the tracker is added synchronously; its existence in
     * the tracker can be checked with the `has()` method. The promise this method
     * returns resolves after the widget has been added and saved to an underlying
     * restoration connector, if one is available.
     *
     * The newly added widget becomes the current widget unless the focus tracker
     * already had a focused widget.
     */
    async add(widget) {
        this._focusTracker.add(widget);
        await this._pool.add(widget);
        if (!this._focusTracker.activeWidget) {
            this._pool.current = widget;
        }
    }
    /**
     * Test whether the tracker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the tracker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._pool.dispose();
        this._focusTracker.dispose();
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Find the first widget in the tracker that satisfies a filter function.
     *
     * @param fn The filter function to call on each widget.
     *
     * #### Notes
     * If no widget is found, the value returned is `undefined`.
     */
    find(fn) {
        return this._pool.find(fn);
    }
    /**
     * Iterate through each widget in the tracker.
     *
     * @param fn - The function to call on each widget.
     */
    forEach(fn) {
        return this._pool.forEach(fn);
    }
    /**
     * Filter the widgets in the tracker based on a predicate.
     *
     * @param fn - The function by which to filter.
     */
    filter(fn) {
        return this._pool.filter(fn);
    }
    /**
     * Inject a foreign widget into the widget tracker.
     *
     * @param widget - The widget to inject into the tracker.
     *
     * #### Notes
     * Injected widgets will not have their state saved by the tracker.
     *
     * The primary use case for widget injection is for a plugin that offers a
     * sub-class of an extant plugin to have its instances share the same commands
     * as the parent plugin (since most relevant commands will use the
     * `currentWidget` of the parent plugin's widget tracker). In this situation,
     * the sub-class plugin may well have its own widget tracker for layout and
     * state restoration in addition to injecting its widgets into the parent
     * plugin's widget tracker.
     */
    inject(widget) {
        return this._pool.inject(widget);
    }
    /**
     * Check if this tracker has the specified widget.
     *
     * @param widget - The widget whose existence is being checked.
     */
    has(widget) {
        return this._pool.has(widget);
    }
    /**
     * Restore the widgets in this tracker's namespace.
     *
     * @param options - The configuration options that describe restoration.
     *
     * @returns A promise that resolves when restoration has completed.
     *
     * #### Notes
     * This function should not typically be invoked by client code.
     * Its primary use case is to be invoked by a restorer.
     */
    async restore(options) {
        const deferred = this._deferred;
        if (deferred) {
            this._deferred = null;
            return this._pool.restore(deferred);
        }
        if (options) {
            return this._pool.restore(options);
        }
        console.warn('No options provided to restore the tracker.');
    }
    /**
     * Save the restore options for this tracker, but do not restore yet.
     *
     * @param options - The configuration options that describe restoration.
     *
     * ### Notes
     * This function is useful when starting the shell in 'single-document' mode,
     * to avoid restoring all useless widgets. It should not ordinarily be called
     * by client code.
     */
    defer(options) {
        this._deferred = options;
    }
    /**
     * Save the restore data for a given widget.
     *
     * @param widget - The widget being saved.
     */
    async save(widget) {
        return this._pool.save(widget);
    }
    /**
     * Handle the current change event.
     *
     * #### Notes
     * The default implementation is a no-op.
     */
    onCurrentChanged(value) {
        /* no-op */
    }
}
//# sourceMappingURL=widgettracker.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/dialog.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * Create and show a dialog.
 *
 * @param options - The dialog setup options.
 *
 * @returns A promise that resolves with whether the dialog was accepted.
 */
function showDialog(options = {}) {
    const dialog = new dialog_Dialog(options);
    return dialog.launch();
}
/**
 * Show an error message dialog.
 *
 * @param title - The title of the dialog box.
 *
 * @param error - the error to show in the dialog body (either a string
 *   or an object with a string `message` property).
 */
function showErrorMessage(title, error, buttons) {
    const trans = dialog_Dialog.translator.load('jupyterlab');
    buttons = buttons !== null && buttons !== void 0 ? buttons : [dialog_Dialog.cancelButton({ label: trans.__('Close') })];
    console.warn('Showing error:', error);
    // Cache promises to prevent multiple copies of identical dialogs showing
    // to the user.
    const body = typeof error === 'string' ? error : error.message;
    const key = title + '----' + body;
    const promise = dialog_Private.errorMessagePromiseCache.get(key);
    if (promise) {
        return promise;
    }
    else {
        const dialogPromise = showDialog({
            title: title,
            body: body,
            buttons: buttons
        }).then(() => {
            dialog_Private.errorMessagePromiseCache.delete(key);
        }, error => {
            // TODO: Use .finally() above when supported
            dialog_Private.errorMessagePromiseCache.delete(key);
            throw error;
        });
        dialog_Private.errorMessagePromiseCache.set(key, dialogPromise);
        return dialogPromise;
    }
}
/**
 * A modal dialog widget.
 */
class dialog_Dialog extends index_es6_js_.Widget {
    /**
     * Create a dialog panel instance.
     *
     * @param options - The dialog setup options.
     */
    constructor(options = {}) {
        const dialogNode = document.createElement('dialog');
        dialogNode.ariaModal = 'true';
        super({ node: dialogNode });
        this._hasValidationErrors = false;
        this._ready = new dist_index_js_.PromiseDelegate();
        this._focusNodeSelector = '';
        this.addClass('jp-Dialog');
        this.addClass('jp-ThemedContainer');
        const normalized = dialog_Private.handleOptions(options);
        const renderer = normalized.renderer;
        this._host = normalized.host;
        this._defaultButton = normalized.defaultButton;
        this._buttons = normalized.buttons;
        this._hasClose = normalized.hasClose;
        this._buttonNodes = this._buttons.map(b => renderer.createButtonNode(b));
        this._checkboxNode = null;
        this._lastMouseDownInDialog = false;
        if (normalized.checkbox) {
            const { label = '', caption = '', checked = false, className = '' } = normalized.checkbox;
            this._checkboxNode = renderer.createCheckboxNode({
                label,
                caption: caption !== null && caption !== void 0 ? caption : label,
                checked,
                className
            });
        }
        const layout = (this.layout = new index_es6_js_.PanelLayout());
        const content = new index_es6_js_.Panel();
        content.addClass('jp-Dialog-content');
        if (typeof options.body === 'string') {
            content.addClass('jp-Dialog-content-small');
            dialogNode.ariaLabel = [normalized.title, options.body].join(' ');
        }
        layout.addWidget(content);
        this._body = normalized.body;
        const header = renderer.createHeader(normalized.title, () => this.reject(), options);
        const body = renderer.createBody(normalized.body);
        const footer = renderer.createFooter(this._buttonNodes, this._checkboxNode);
        content.addWidget(header);
        content.addWidget(body);
        content.addWidget(footer);
        this._bodyWidget = body;
        this._primary = this._buttonNodes[this._defaultButton];
        this._focusNodeSelector = options.focusNodeSelector;
        // Add new dialogs to the tracker.
        void dialog_Dialog.tracker.add(this);
    }
    /**
     * A promise that resolves when the Dialog first rendering is done.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Dispose of the resources used by the dialog.
     */
    dispose() {
        const promise = this._promise;
        if (promise) {
            this._promise = null;
            promise.reject(void 0);
            dist_index_es6_js_.ArrayExt.removeFirstOf(dialog_Private.launchQueue, promise.promise);
        }
        super.dispose();
    }
    /**
     * Launch the dialog as a modal window.
     *
     * @returns a promise that resolves with the result of the dialog.
     */
    launch() {
        // Return the existing dialog if already open.
        if (this._promise) {
            return this._promise.promise;
        }
        const promise = (this._promise = new dist_index_js_.PromiseDelegate());
        const promises = Promise.all(dialog_Private.launchQueue);
        dialog_Private.launchQueue.push(this._promise.promise);
        return promises.then(() => {
            // Do not show Dialog if it was disposed of before it was at the front of the launch queue
            if (!this._promise) {
                return Promise.resolve({
                    button: dialog_Dialog.cancelButton(),
                    isChecked: null,
                    value: null
                });
            }
            index_es6_js_.Widget.attach(this, this._host);
            return promise.promise;
        });
    }
    /**
     * Resolve the current dialog.
     *
     * @param index - An optional index to the button to resolve.
     *
     * #### Notes
     * Will default to the defaultIndex.
     * Will resolve the current `show()` with the button value.
     * Will be a no-op if the dialog is not shown.
     */
    resolve(index) {
        if (!this._promise) {
            return;
        }
        if (index === undefined) {
            index = this._defaultButton;
        }
        this._resolve(this._buttons[index]);
    }
    /**
     * Reject the current dialog with a default reject value.
     *
     * #### Notes
     * Will be a no-op if the dialog is not shown.
     */
    reject() {
        if (!this._promise) {
            return;
        }
        this._resolve(dialog_Dialog.cancelButton());
    }
    /**
     * Handle the DOM events for the directory listing.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'mousedown':
                this._evtMouseDown(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            case 'input':
                this._evtInput(event);
                break;
            case 'focus':
                this._evtFocus(event);
                break;
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        const node = this.node;
        node.addEventListener('keydown', this, true);
        node.addEventListener('contextmenu', this, true);
        node.addEventListener('click', this, true);
        document.addEventListener('mousedown', this, true);
        document.addEventListener('focus', this, true);
        document.addEventListener('input', this, true);
        this._first = dialog_Private.findFirstFocusable(this.node);
        this._original = document.activeElement;
        const setFocus = () => {
            var _a;
            if (this._focusNodeSelector) {
                const body = this.node.querySelector('.jp-Dialog-body');
                const el = body === null || body === void 0 ? void 0 : body.querySelector(this._focusNodeSelector);
                if (el) {
                    this._primary = el;
                }
            }
            (_a = this._primary) === null || _a === void 0 ? void 0 : _a.focus();
            this._ready.resolve();
        };
        if (this._bodyWidget instanceof index_js_.ReactWidget &&
            this._bodyWidget.renderPromise !== undefined) {
            this._bodyWidget
                .renderPromise.then(() => {
                setFocus();
            })
                .catch(() => {
                console.error("Error while loading Dialog's body");
            });
        }
        else {
            setFocus();
        }
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        const node = this.node;
        node.removeEventListener('keydown', this, true);
        node.removeEventListener('contextmenu', this, true);
        node.removeEventListener('click', this, true);
        document.removeEventListener('focus', this, true);
        document.removeEventListener('mousedown', this, true);
        document.removeEventListener('input', this, true);
        this._original.focus();
    }
    /**
     * A message handler invoked on a `'close-request'` message.
     */
    onCloseRequest(msg) {
        if (this._promise) {
            this.reject();
        }
        super.onCloseRequest(msg);
    }
    /**
     * Handle the `'input'` event for dialog's children.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtInput(_event) {
        this._hasValidationErrors = !!this.node.querySelector(':invalid');
        for (let i = 0; i < this._buttons.length; i++) {
            if (this._buttons[i].accept) {
                this._buttonNodes[i].disabled = this._hasValidationErrors;
            }
        }
    }
    /**
     * Handle the `'click'` event for a dialog button.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtClick(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        if (!content.contains(event.target)) {
            event.stopPropagation();
            event.preventDefault();
            if (this._hasClose && !this._lastMouseDownInDialog) {
                this.reject();
            }
            return;
        }
        for (const buttonNode of this._buttonNodes) {
            if (buttonNode.contains(event.target)) {
                const index = this._buttonNodes.indexOf(buttonNode);
                this.resolve(index);
            }
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                if (this._hasClose) {
                    this.reject();
                }
                break;
            case 37: {
                // Left arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) - 1;
                    // Handle a left arrows on the first button
                    if (idx < 0) {
                        idx = this._buttonNodes.length - 1;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 39: {
                // Right arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) + 1;
                    // Handle a right arrows on the last button
                    if (idx == this._buttons.length) {
                        idx = 0;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 9: {
                // Tab.
                // Handle a tab on the last button.
                const node = this._buttonNodes[this._buttons.length - 1];
                if (document.activeElement === node && !event.shiftKey) {
                    event.stopPropagation();
                    event.preventDefault();
                    this._first.focus();
                }
                break;
            }
            case 13: {
                // Enter.
                event.stopPropagation();
                event.preventDefault();
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    const index = this._buttonNodes.indexOf(activeEl);
                    if (index !== -1) {
                        this.resolve(index);
                    }
                }
                else if (!(activeEl instanceof HTMLTextAreaElement)) {
                    const index = this._defaultButton;
                    this.resolve(index);
                }
                break;
            }
            default:
                break;
        }
    }
    /**
     * Handle the `'focus'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtFocus(event) {
        var _a;
        const target = event.target;
        if (!this.node.contains(target)) {
            event.stopPropagation();
            (_a = this._buttonNodes[this._defaultButton]) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    /**
     * Handle the `'mousedown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtMouseDown(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        const target = event.target;
        this._lastMouseDownInDialog = content.contains(target);
    }
    /**
     * Resolve a button item.
     */
    _resolve(button) {
        var _a, _b, _c;
        if (this._hasValidationErrors && button.accept) {
            // Do not allow accepting with validation errors
            return;
        }
        // Prevent loopback.
        const promise = this._promise;
        if (!promise) {
            this.dispose();
            return;
        }
        this._promise = null;
        dist_index_es6_js_.ArrayExt.removeFirstOf(dialog_Private.launchQueue, promise.promise);
        const body = this._body;
        let value = null;
        if (button.accept &&
            body instanceof index_es6_js_.Widget &&
            typeof body.getValue === 'function') {
            value = body.getValue();
        }
        this.dispose();
        promise.resolve({
            button,
            isChecked: (_c = (_b = (_a = this._checkboxNode) === null || _a === void 0 ? void 0 : _a.querySelector('input')) === null || _b === void 0 ? void 0 : _b.checked) !== null && _c !== void 0 ? _c : null,
            value
        });
    }
}
/**
 * The namespace for Dialog class statics.
 */
(function (Dialog) {
    /**
     * Translator object.
     */
    Dialog.translator = lib_index_js_.nullTranslator;
    /**
     * Create a button item.
     */
    function createButton(value) {
        value.accept = value.accept !== false;
        const trans = Dialog.translator.load('jupyterlab');
        const defaultLabel = value.accept ? trans.__('Ok') : trans.__('Cancel');
        return {
            ariaLabel: value.ariaLabel || value.label || defaultLabel,
            label: value.label || defaultLabel,
            iconClass: value.iconClass || '',
            iconLabel: value.iconLabel || '',
            caption: value.caption || '',
            className: value.className || '',
            accept: value.accept,
            actions: value.actions || [],
            displayType: value.displayType || 'default'
        };
    }
    Dialog.createButton = createButton;
    /**
     * Create a reject button.
     */
    function cancelButton(options = {}) {
        options.accept = false;
        return createButton(options);
    }
    Dialog.cancelButton = cancelButton;
    /**
     * Create an accept button.
     */
    function okButton(options = {}) {
        options.accept = true;
        return createButton(options);
    }
    Dialog.okButton = okButton;
    /**
     * Create a warn button.
     */
    function warnButton(options = {}) {
        options.displayType = 'warn';
        return createButton(options);
    }
    Dialog.warnButton = warnButton;
    /**
     * Disposes all dialog instances.
     *
     * #### Notes
     * This function should only be used in tests or cases where application state
     * may be discarded.
     */
    function flush() {
        Dialog.tracker.forEach(dialog => {
            dialog.dispose();
        });
    }
    Dialog.flush = flush;
    /**
     * The default implementation of a dialog renderer.
     */
    class Renderer {
        /**
         * Create the header of the dialog.
         *
         * @param title - The title of the dialog.
         *
         * @returns A widget for the dialog header.
         */
        createHeader(title, reject = () => {
            /* empty */
        }, options = {}) {
            let header;
            const handleMouseDown = (event) => {
                // Fire action only when left button is pressed.
                if (event.button === 0) {
                    event.preventDefault();
                    reject();
                }
            };
            const handleKeyDown = (event) => {
                const { key } = event;
                if (key === 'Enter' || key === ' ') {
                    reject();
                }
            };
            if (typeof title === 'string') {
                const trans = Dialog.translator.load('jupyterlab');
                header = index_js_.ReactWidget.create(react_index_js_.createElement(react_index_js_.Fragment, null,
                    title,
                    options.hasClose && (react_index_js_.createElement(index_js_.Button, { className: "jp-Dialog-close-button", onMouseDown: handleMouseDown, onKeyDown: handleKeyDown, title: trans.__('Cancel'), minimal: true },
                        react_index_js_.createElement(index_js_.LabIcon.resolveReact, { icon: index_js_.closeIcon, tag: "span" })))));
            }
            else {
                header = index_js_.ReactWidget.create(title);
            }
            header.addClass('jp-Dialog-header');
            index_js_.Styling.styleNode(header.node);
            return header;
        }
        /**
         * Create the body of the dialog.
         *
         * @param value - The input value for the body.
         *
         * @returns A widget for the body.
         */
        createBody(value) {
            const styleReactWidget = (widget) => {
                if (widget.renderPromise !== undefined) {
                    widget.renderPromise
                        .then(() => {
                        index_js_.Styling.styleNode(widget.node);
                    })
                        .catch(() => {
                        console.error("Error while loading Dialog's body");
                    });
                }
                else {
                    index_js_.Styling.styleNode(widget.node);
                }
            };
            let body;
            if (typeof value === 'string') {
                body = new index_es6_js_.Widget({ node: document.createElement('span') });
                body.node.textContent = value;
            }
            else if (value instanceof index_es6_js_.Widget) {
                body = value;
                if (body instanceof index_js_.ReactWidget) {
                    styleReactWidget(body);
                }
                else {
                    index_js_.Styling.styleNode(body.node);
                }
            }
            else {
                body = index_js_.ReactWidget.create(value);
                // Immediately update the body even though it has not yet attached in
                // order to trigger a render of the DOM nodes from the React element.
                messaging_dist_index_es6_js_.MessageLoop.sendMessage(body, index_es6_js_.Widget.Msg.UpdateRequest);
                styleReactWidget(body);
            }
            body.addClass('jp-Dialog-body');
            return body;
        }
        /**
         * Create the footer of the dialog.
         *
         * @param buttons - The buttons nodes to add to the footer.
         * @param checkbox - The checkbox node to add to the footer.
         *
         * @returns A widget for the footer.
         */
        createFooter(buttons, checkbox) {
            const footer = new index_es6_js_.Widget();
            footer.addClass('jp-Dialog-footer');
            if (checkbox) {
                footer.node.appendChild(checkbox);
                footer.node.insertAdjacentHTML('beforeend', '<div class="jp-Dialog-spacer"></div>');
            }
            const footerButton = document.createElement('div');
            footerButton.classList.add('jp-Dialog-footerButtons');
            for (const button of buttons) {
                footerButton.appendChild(button);
            }
            footer.node.appendChild(footerButton);
            index_js_.Styling.styleNode(footer.node);
            return footer;
        }
        /**
         * Create a button node for the dialog.
         *
         * @param button - The button data.
         *
         * @returns A node for the button.
         */
        createButtonNode(button) {
            const e = document.createElement('button');
            e.className = this.createItemClass(button);
            e.appendChild(this.renderIcon(button));
            e.appendChild(this.renderLabel(button));
            return e;
        }
        /**
         * Create a checkbox node for the dialog.
         *
         * @param checkbox - The checkbox data.
         *
         * @returns A node for the checkbox.
         */
        createCheckboxNode(checkbox) {
            const e = document.createElement('label');
            e.className = 'jp-Dialog-checkbox';
            if (checkbox.className) {
                e.classList.add(checkbox.className);
            }
            e.title = checkbox.caption;
            e.textContent = checkbox.label;
            const input = document.createElement('input');
            input.type = 'checkbox';
            input.checked = !!checkbox.checked;
            e.insertAdjacentElement('afterbegin', input);
            return e;
        }
        /**
         * Create the class name for the button.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the button.
         */
        createItemClass(data) {
            // Setup the initial class name.
            let name = 'jp-Dialog-button';
            // Add the other state classes.
            if (data.accept) {
                name += ' jp-mod-accept';
            }
            else {
                name += ' jp-mod-reject';
            }
            if (data.displayType === 'warn') {
                name += ' jp-mod-warn';
            }
            // Add the extra class.
            const extra = data.className;
            if (extra) {
                name += ` ${extra}`;
            }
            // Return the complete class name.
            return name;
        }
        /**
         * Render an icon element for a dialog item.
         *
         * @param data - The data to use for rendering the icon.
         *
         * @returns An HTML element representing the icon.
         */
        renderIcon(data) {
            const e = document.createElement('div');
            e.className = this.createIconClass(data);
            e.appendChild(document.createTextNode(data.iconLabel));
            return e;
        }
        /**
         * Create the class name for the button icon.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the item icon.
         */
        createIconClass(data) {
            const name = 'jp-Dialog-buttonIcon';
            const extra = data.iconClass;
            return extra ? `${name} ${extra}` : name;
        }
        /**
         * Render the label element for a button.
         *
         * @param data - The data to use for rendering the label.
         *
         * @returns An HTML element representing the item label.
         */
        renderLabel(data) {
            const e = document.createElement('div');
            e.className = 'jp-Dialog-buttonLabel';
            e.title = data.caption;
            e.ariaLabel = data.ariaLabel;
            e.appendChild(document.createTextNode(data.label));
            return e;
        }
    }
    Dialog.Renderer = Renderer;
    /**
     * The default renderer instance.
     */
    Dialog.defaultRenderer = new Renderer();
    /**
     * The dialog widget tracker.
     */
    Dialog.tracker = new WidgetTracker({
        namespace: '@jupyterlab/apputils:Dialog'
    });
})(dialog_Dialog || (dialog_Dialog = {}));
/**
 * The namespace for module private data.
 */
var dialog_Private;
(function (Private) {
    /**
     * The queue for launching dialogs.
     */
    Private.launchQueue = [];
    Private.errorMessagePromiseCache = new Map();
    /**
     * Handle the input options for a dialog.
     *
     * @param options - The input options.
     *
     * @returns A new options object with defaults applied.
     */
    function handleOptions(options = {}) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const buttons = (_a = options.buttons) !== null && _a !== void 0 ? _a : [
            dialog_Dialog.cancelButton(),
            dialog_Dialog.okButton()
        ];
        return {
            title: (_b = options.title) !== null && _b !== void 0 ? _b : '',
            body: (_c = options.body) !== null && _c !== void 0 ? _c : '',
            host: (_d = options.host) !== null && _d !== void 0 ? _d : document.body,
            checkbox: (_e = options.checkbox) !== null && _e !== void 0 ? _e : null,
            buttons,
            defaultButton: (_f = options.defaultButton) !== null && _f !== void 0 ? _f : buttons.length - 1,
            renderer: (_g = options.renderer) !== null && _g !== void 0 ? _g : dialog_Dialog.defaultRenderer,
            focusNodeSelector: (_h = options.focusNodeSelector) !== null && _h !== void 0 ? _h : '',
            hasClose: (_j = options.hasClose) !== null && _j !== void 0 ? _j : true
        };
    }
    Private.handleOptions = handleOptions;
    /**
     *  Find the first focusable item in the dialog.
     */
    function findFirstFocusable(node) {
        const candidateSelectors = [
            'input',
            'select',
            'a[href]',
            'textarea',
            'button',
            '[tabindex]'
        ].join(',');
        return node.querySelectorAll(candidateSelectors)[0];
    }
    Private.findFirstFocusable = findFirstFocusable;
})(dialog_Private || (dialog_Private = {}));
//# sourceMappingURL=dialog.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/sessioncontext.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The default implementation for a session context object.
 */
class sessioncontext_SessionContext {
    /**
     * Construct a new session context.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        this._path = '';
        this._name = '';
        this._type = '';
        this._prevKernelName = '';
        this._isDisposed = false;
        this._disposed = new signaling_dist_index_es6_js_.Signal(this);
        this._session = null;
        this._ready = new dist_index_js_.PromiseDelegate();
        this._initializing = false;
        this._initStarted = new dist_index_js_.PromiseDelegate();
        this._initPromise = new dist_index_js_.PromiseDelegate();
        this._isReady = false;
        this._isTerminating = false;
        this._isRestarting = false;
        this._kernelChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._preferenceChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._sessionChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._statusChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._connectionStatusChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._pendingInput = false;
        this._iopubMessage = new signaling_dist_index_es6_js_.Signal(this);
        this._unhandledMessage = new signaling_dist_index_es6_js_.Signal(this);
        this._propertyChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._dialog = null;
        this._busyDisposable = null;
        this._pendingKernelName = '';
        this._pendingSessionRequest = '';
        this.kernelManager = options.kernelManager;
        this.sessionManager = options.sessionManager;
        this.specsManager = options.specsManager;
        this.translator = options.translator || lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this._path = (_a = options.path) !== null && _a !== void 0 ? _a : dist_index_js_.UUID.uuid4();
        this._type = (_b = options.type) !== null && _b !== void 0 ? _b : '';
        this._name = (_c = options.name) !== null && _c !== void 0 ? _c : '';
        this._setBusy = options.setBusy;
        this._kernelPreference = (_d = options.kernelPreference) !== null && _d !== void 0 ? _d : {};
    }
    /**
     * The current session connection.
     */
    get session() {
        var _a;
        return (_a = this._session) !== null && _a !== void 0 ? _a : null;
    }
    /**
     * The session path.
     *
     * #### Notes
     * Typically `.session.path` should be used. This attribute is useful if
     * there is no current session.
     */
    get path() {
        return this._path;
    }
    /**
     * The session type.
     *
     * #### Notes
     * Typically `.session.type` should be used. This attribute is useful if
     * there is no current session.
     */
    get type() {
        return this._type;
    }
    /**
     * The session name.
     *
     * #### Notes
     * Typically `.session.name` should be used. This attribute is useful if
     * there is no current session.
     */
    get name() {
        return this._name;
    }
    /**
     * A signal emitted when the kernel connection changes, proxied from the session connection.
     */
    get kernelChanged() {
        return this._kernelChanged;
    }
    /**
     * A signal emitted when the session connection changes.
     */
    get sessionChanged() {
        return this._sessionChanged;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get statusChanged() {
        return this._statusChanged;
    }
    /**
     * A flag indicating if the session has pending input, proxied from the kernel.
     */
    get pendingInput() {
        return this._pendingInput;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * A signal emitted for iopub kernel messages, proxied from the kernel.
     */
    get iopubMessage() {
        return this._iopubMessage;
    }
    /**
     * A signal emitted for an unhandled kernel message, proxied from the kernel.
     */
    get unhandledMessage() {
        return this._unhandledMessage;
    }
    /**
     * A signal emitted when a session property changes, proxied from the current session.
     */
    get propertyChanged() {
        return this._propertyChanged;
    }
    /**
     * The kernel preference of this client session.
     *
     * This is used when selecting a new kernel, and should reflect the sort of
     * kernel the activity prefers.
     */
    get kernelPreference() {
        return this._kernelPreference;
    }
    set kernelPreference(value) {
        if (!dist_index_js_.JSONExt.deepEqual(value, this._kernelPreference)) {
            const oldValue = this._kernelPreference;
            this._kernelPreference = value;
            this._preferenceChanged.emit({
                name: 'kernelPreference',
                oldValue,
                newValue: dist_index_js_.JSONExt.deepCopy(value)
            });
        }
    }
    /**
     * Signal emitted if the kernel preference changes.
     */
    get kernelPreferenceChanged() {
        return this._preferenceChanged;
    }
    /**
     * Whether the context is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that is fulfilled when the context is ready.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Whether the context is terminating.
     */
    get isTerminating() {
        return this._isTerminating;
    }
    /**
     * Whether the context is restarting.
     */
    get isRestarting() {
        return this._isRestarting;
    }
    /**
     * Whether the kernel is "No Kernel" or not.
     *
     * #### Notes
     * As the displayed name is translated, this can be used directly.
     */
    get hasNoKernel() {
        return this.kernelDisplayName === this.noKernelName;
    }
    /**
     * The display name of the current kernel, or a sensible alternative.
     *
     * #### Notes
     * This is a convenience function to have a consistent sensible name for the
     * kernel.
     */
    get kernelDisplayName() {
        var _a, _b, _c, _d, _e, _f, _g;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._pendingKernelName === this.noKernelName) {
            return this.noKernelName;
        }
        if (this._pendingKernelName) {
            return ((_d = (_c = (_b = this.specsManager.specs) === null || _b === void 0 ? void 0 : _b.kernelspecs[this._pendingKernelName]) === null || _c === void 0 ? void 0 : _c.display_name) !== null && _d !== void 0 ? _d : this._pendingKernelName);
        }
        if (!kernel) {
            return this.noKernelName;
        }
        return ((_g = (_f = (_e = this.specsManager.specs) === null || _e === void 0 ? void 0 : _e.kernelspecs[kernel.name]) === null || _f === void 0 ? void 0 : _f.display_name) !== null && _g !== void 0 ? _g : kernel.name);
    }
    /**
     * A sensible status to display
     *
     * #### Notes
     * This combines the status and connection status into a single status for
     * the user.
     */
    get kernelDisplayStatus() {
        var _a, _b;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._isTerminating) {
            return 'terminating';
        }
        if (this._isRestarting) {
            return 'restarting';
        }
        if (this._pendingKernelName === this.noKernelName) {
            return 'unknown';
        }
        if (!kernel && this._pendingKernelName) {
            return 'initializing';
        }
        if (!kernel &&
            !this.isReady &&
            this.kernelPreference.canStart !== false &&
            this.kernelPreference.shouldStart !== false) {
            return 'initializing';
        }
        return ((_b = ((kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus) === 'connected'
            ? kernel === null || kernel === void 0 ? void 0 : kernel.status
            : kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus)) !== null && _b !== void 0 ? _b : 'unknown');
    }
    /**
     * The name of the previously started kernel.
     */
    get prevKernelName() {
        return this._prevKernelName;
    }
    /**
     * Test whether the context is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * A signal emitted when the poll is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Get the constant displayed name for "No Kernel"
     */
    get noKernelName() {
        return this._trans.__('No Kernel');
    }
    /**
     * Dispose of the resources held by the context.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        if (this._session) {
            if (this.kernelPreference.shutdownOnDispose) {
                // Fire and forget the session shutdown request
                this.sessionManager.shutdown(this._session.id).catch(reason => {
                    console.error(`Kernel not shut down ${reason}`);
                });
            }
            // Dispose the session connection
            this._session.dispose();
            this._session = null;
        }
        if (this._dialog) {
            this._dialog.dispose();
        }
        if (this._busyDisposable) {
            this._busyDisposable.dispose();
            this._busyDisposable = null;
        }
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Starts new Kernel.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async startKernel() {
        const preference = this.kernelPreference;
        if (!preference.autoStartDefault && preference.shouldStart === false) {
            return true;
        }
        let options;
        if (preference.id) {
            options = { id: preference.id };
        }
        else {
            const name = sessioncontext_Private.getDefaultKernel({
                specs: this.specsManager.specs,
                sessions: this.sessionManager.running(),
                preference
            });
            if (name) {
                options = { name };
            }
        }
        if (options) {
            try {
                await this._changeKernel(options);
                return false;
            }
            catch (err) {
                /* no-op */
            }
        }
        // Always fall back to selecting a kernel
        return true;
    }
    /**
     * Restart the current Kernel.
     *
     * @returns A promise that resolves when the kernel is restarted.
     */
    async restartKernel() {
        var _a, _b, _c, _d, _e, _f;
        const kernel = ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) || null;
        if (this._isRestarting) {
            return;
        }
        this._isRestarting = true;
        this._isReady = false;
        this._statusChanged.emit('restarting');
        try {
            await ((_c = (_b = this.session) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.restart());
            this._isReady = true;
        }
        catch (e) {
            console.error(e);
        }
        this._isRestarting = false;
        this._statusChanged.emit(((_e = (_d = this.session) === null || _d === void 0 ? void 0 : _d.kernel) === null || _e === void 0 ? void 0 : _e.status) || 'unknown');
        this._kernelChanged.emit({
            name: 'kernel',
            oldValue: kernel,
            newValue: ((_f = this.session) === null || _f === void 0 ? void 0 : _f.kernel) || null
        });
    }
    /**
     * Change the current kernel associated with the session.
     */
    async changeKernel(options = {}) {
        if (this.isDisposed) {
            throw new Error('Disposed');
        }
        // Wait for the initialization method to try
        // and start its kernel first to ensure consistent
        // ordering.
        await this._initStarted.promise;
        return this._changeKernel(options);
    }
    /**
     * Kill the kernel and shutdown the session.
     *
     * @returns A promise that resolves when the session is shut down.
     */
    async shutdown() {
        if (this.isDisposed || !this._initializing) {
            return;
        }
        await this._initStarted.promise;
        this._pendingSessionRequest = '';
        this._pendingKernelName = this.noKernelName;
        return this._shutdownSession();
    }
    /**
     * Initialize the session context
     *
     * @returns A promise that resolves with whether to ask the user to select a kernel.
     *
     * #### Notes
     * If a server session exists on the current path, we will connect to it.
     * If preferences include disabling `canStart` or `shouldStart`, no
     * server session will be started.
     * If a kernel id is given, we attempt to start a session with that id.
     * If a default kernel is available, we connect to it.
     * Otherwise we ask the user to select a kernel.
     */
    async initialize() {
        if (this._initializing) {
            return this._initPromise.promise;
        }
        this._initializing = true;
        const needsSelection = await this._initialize();
        if (!needsSelection) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        this._initPromise.resolve(needsSelection);
        return needsSelection;
    }
    /**
     * Inner initialize function that doesn't handle promises.
     * This makes it easier to consolidate promise handling logic.
     */
    async _initialize() {
        const manager = this.sessionManager;
        await manager.ready;
        await manager.refreshRunning();
        const model = (0,dist_index_es6_js_.find)(manager.running(), item => {
            return item.path === this._path;
        });
        if (model) {
            try {
                const session = manager.connectTo({ model });
                this._handleNewSession(session);
            }
            catch (err) {
                void this._handleSessionError(err);
                return Promise.reject(err);
            }
        }
        return await this._startIfNecessary();
    }
    /**
     * Shut down the current session.
     */
    async _shutdownSession() {
        var _a;
        const session = this._session;
        // Capture starting values in case an error is raised.
        const isTerminating = this._isTerminating;
        const isReady = this._isReady;
        this._isTerminating = true;
        this._isReady = false;
        this._statusChanged.emit('terminating');
        try {
            await (session === null || session === void 0 ? void 0 : session.shutdown());
            this._isTerminating = false;
            session === null || session === void 0 ? void 0 : session.dispose();
            this._session = null;
            const kernel = (session === null || session === void 0 ? void 0 : session.kernel) || null;
            this._statusChanged.emit('unknown');
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: kernel,
                newValue: null
            });
            this._sessionChanged.emit({
                name: 'session',
                oldValue: session,
                newValue: null
            });
        }
        catch (err) {
            this._isTerminating = isTerminating;
            this._isReady = isReady;
            const status = (_a = session === null || session === void 0 ? void 0 : session.kernel) === null || _a === void 0 ? void 0 : _a.status;
            if (status === undefined) {
                this._statusChanged.emit('unknown');
            }
            else {
                this._statusChanged.emit(status);
            }
            throw err;
        }
        return;
    }
    /**
     * Start the session if necessary.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async _startIfNecessary() {
        var _a;
        const preference = this.kernelPreference;
        if (this.isDisposed ||
            ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) ||
            preference.shouldStart === false ||
            preference.canStart === false) {
            // Not necessary to start a kernel
            return false;
        }
        return this.startKernel();
    }
    /**
     * Change the kernel.
     */
    async _changeKernel(model = {}) {
        if (model.name) {
            this._pendingKernelName = model.name;
        }
        if (!this._session) {
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: null,
                newValue: null
            });
        }
        // Guarantee that the initialized kernel
        // will be started first.
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        // If we already have a session, just change the kernel.
        if (this._session && !this._isTerminating) {
            try {
                await this._session.changeKernel(model);
                return this._session.kernel;
            }
            catch (err) {
                void this._handleSessionError(err);
                throw err;
            }
        }
        // Use a UUID for the path to overcome a race condition on the server
        // where it will re-use a session for a given path but only after
        // the kernel finishes starting.
        // We later switch to the real path below.
        // Use the correct directory so the kernel will be started in that directory.
        const dirName = coreutils_lib_index_js_.PathExt.dirname(this._path);
        const requestId = (this._pendingSessionRequest = coreutils_lib_index_js_.PathExt.join(dirName, dist_index_js_.UUID.uuid4()));
        try {
            this._statusChanged.emit('starting');
            const session = await this.sessionManager.startNew({
                path: requestId,
                type: this._type,
                name: this._name,
                kernel: model
            });
            // Handle a preempt.
            if (this._pendingSessionRequest !== session.path) {
                await session.shutdown();
                session.dispose();
                return null;
            }
            // Change to the real path.
            await session.setPath(this._path);
            // Update the name in case it has changed since we launched the session.
            await session.setName(this._name);
            if (this._session && !this._isTerminating) {
                await this._shutdownSession();
            }
            return this._handleNewSession(session);
        }
        catch (err) {
            void this._handleSessionError(err);
            throw err;
        }
    }
    /**
     * Handle a new session object.
     */
    _handleNewSession(session) {
        var _a, _b, _c;
        if (this.isDisposed) {
            throw Error('Disposed');
        }
        if (!this._isReady) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (this._session) {
            this._session.dispose();
        }
        this._session = session;
        this._pendingKernelName = '';
        if (session) {
            this._prevKernelName = (_b = (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : '';
            session.disposed.connect(this._onSessionDisposed, this);
            session.propertyChanged.connect(this._onPropertyChanged, this);
            session.kernelChanged.connect(this._onKernelChanged, this);
            session.statusChanged.connect(this._onStatusChanged, this);
            session.connectionStatusChanged.connect(this._onConnectionStatusChanged, this);
            session.pendingInput.connect(this._onPendingInput, this);
            session.iopubMessage.connect(this._onIopubMessage, this);
            session.unhandledMessage.connect(this._onUnhandledMessage, this);
            if (session.path !== this._path) {
                this._onPropertyChanged(session, 'path');
            }
            if (session.name !== this._name) {
                this._onPropertyChanged(session, 'name');
            }
            if (session.type !== this._type) {
                this._onPropertyChanged(session, 'type');
            }
        }
        // Any existing session/kernel connection was disposed above when the session was
        // disposed, so the oldValue should be null.
        this._sessionChanged.emit({
            name: 'session',
            oldValue: null,
            newValue: session
        });
        this._kernelChanged.emit({
            oldValue: null,
            newValue: (session === null || session === void 0 ? void 0 : session.kernel) || null,
            name: 'kernel'
        });
        this._statusChanged.emit(((_c = session === null || session === void 0 ? void 0 : session.kernel) === null || _c === void 0 ? void 0 : _c.status) || 'unknown');
        return (session === null || session === void 0 ? void 0 : session.kernel) || null;
    }
    /**
     * Handle an error in session startup.
     */
    async _handleSessionError(err) {
        this._handleNewSession(null);
        let traceback = '';
        let message = '';
        try {
            traceback = err.traceback;
            message = err.message;
        }
        catch (err) {
            // no-op
        }
        await this._displayKernelError(message, traceback);
    }
    /**
     * Display kernel error
     */
    async _displayKernelError(message, traceback) {
        const body = (react_index_js_.createElement("div", null,
            message && react_index_js_.createElement("pre", null, message),
            traceback && (react_index_js_.createElement("details", { className: "jp-mod-wide" },
                react_index_js_.createElement("pre", null, traceback)))));
        const dialog = (this._dialog = new dialog_Dialog({
            title: this._trans.__('Error Starting Kernel'),
            body,
            buttons: [dialog_Dialog.okButton()]
        }));
        await dialog.launch();
        this._dialog = null;
    }
    /**
     * Handle a session termination.
     */
    _onSessionDisposed() {
        if (this._session) {
            const oldValue = this._session;
            this._session = null;
            const newValue = this._session;
            this._sessionChanged.emit({ name: 'session', oldValue, newValue });
        }
    }
    /**
     * Handle a change to a session property.
     */
    _onPropertyChanged(sender, property) {
        switch (property) {
            case 'path':
                this._path = sender.path;
                break;
            case 'name':
                this._name = sender.name;
                break;
            case 'type':
                this._type = sender.type;
                break;
            default:
                throw new Error(`unrecognized property ${property}`);
        }
        this._propertyChanged.emit(property);
    }
    /**
     * Handle a change to the kernel.
     */
    _onKernelChanged(sender, args) {
        this._kernelChanged.emit(args);
    }
    /**
     * Handle a change to the session status.
     */
    _onStatusChanged(sender, status) {
        var _a;
        if (status === 'dead') {
            const model = (_a = sender.kernel) === null || _a === void 0 ? void 0 : _a.model;
            if (model === null || model === void 0 ? void 0 : model.reason) {
                const traceback = model.traceback || '';
                void this._displayKernelError(model.reason, traceback);
            }
        }
        // Set that this kernel is busy, if we haven't already
        // If we have already, and now we aren't busy, dispose
        // of the busy disposable.
        if (this._setBusy) {
            if (status === 'busy') {
                if (!this._busyDisposable) {
                    this._busyDisposable = this._setBusy();
                }
            }
            else {
                if (this._busyDisposable) {
                    this._busyDisposable.dispose();
                    this._busyDisposable = null;
                }
            }
        }
        // Proxy the signal
        this._statusChanged.emit(status);
    }
    /**
     * Handle a change to the session status.
     */
    _onConnectionStatusChanged(sender, status) {
        // Proxy the signal
        this._connectionStatusChanged.emit(status);
    }
    /**
     * Handle a change to the pending input.
     */
    _onPendingInput(sender, value) {
        // Set the signal value
        this._pendingInput = value;
    }
    /**
     * Handle an iopub message.
     */
    _onIopubMessage(sender, message) {
        if (message.header.msg_type === 'shutdown_reply') {
            this.session.kernel.removeInputGuard();
        }
        this._iopubMessage.emit(message);
    }
    /**
     * Handle an unhandled message.
     */
    _onUnhandledMessage(sender, message) {
        this._unhandledMessage.emit(message);
    }
}
/**
 * A namespace for `SessionContext` statics.
 */
(function (SessionContext) {
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        const { preference } = options;
        const { shouldStart } = preference;
        if (shouldStart === false) {
            return null;
        }
        return sessioncontext_Private.getDefaultKernel(options);
    }
    SessionContext.getDefaultKernel = getDefaultKernel;
})(sessioncontext_SessionContext || (sessioncontext_SessionContext = {}));
/**
 * The default implementation of the client session dialog provider.
 */
class sessioncontext_SessionContextDialogs {
    constructor(options = {}) {
        var _a;
        this._translator = (_a = options.translator) !== null && _a !== void 0 ? _a : lib_index_js_.nullTranslator;
        this._settingRegistry = options.settingRegistry || null;
    }
    /**
     * Select a kernel for the session.
     */
    async selectKernel(sessionContext) {
        if (sessionContext.isDisposed) {
            return Promise.resolve();
        }
        const translator = this._translator;
        const trans = translator.load('jupyterlab');
        // If there is no existing kernel, offer the option to keep no kernel.
        let label = trans.__('Cancel');
        if (sessionContext.hasNoKernel) {
            label = sessionContext.kernelDisplayName;
        }
        const buttons = [
            dialog_Dialog.cancelButton({ label }),
            dialog_Dialog.okButton({
                label: trans.__('Select'),
                ariaLabel: trans.__('Select Kernel')
            })
        ];
        const autoStartDefault = sessionContext.kernelPreference.autoStartDefault;
        const hasCheckbox = typeof autoStartDefault === 'boolean';
        const dialog = new dialog_Dialog({
            title: trans.__('Select Kernel'),
            body: sessioncontext_Private.createKernelSelector(sessionContext, translator),
            buttons,
            checkbox: hasCheckbox
                ? {
                    label: trans.__('Always start the preferred kernel'),
                    caption: trans.__('Remember my choice and always start the preferred kernel'),
                    checked: autoStartDefault
                }
                : null
        });
        const result = await dialog.launch();
        if (sessionContext.isDisposed || !result.button.accept) {
            return;
        }
        if (hasCheckbox && result.isChecked !== null) {
            sessionContext.kernelPreference = {
                ...sessionContext.kernelPreference,
                autoStartDefault: result.isChecked
            };
        }
        const model = result.value;
        if (model === null && !sessionContext.hasNoKernel) {
            return sessionContext.shutdown();
        }
        if (model) {
            await sessionContext.changeKernel(model);
        }
    }
    /**
     * Restart the session.
     *
     * @returns A promise that resolves with whether the kernel has restarted.
     *
     * #### Notes
     * If there is a running kernel, present a dialog.
     * If there is no kernel, we start a kernel with the last run
     * kernel name and resolves with `true`.
     */
    async restart(sessionContext, restartOptions) {
        var _a, _b, _c, _d, _e;
        const trans = this._translator.load('jupyterlab');
        await sessionContext.initialize();
        if (sessionContext.isDisposed) {
            throw new Error('session already disposed');
        }
        const kernel = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (!kernel && sessionContext.prevKernelName) {
            await sessionContext.changeKernel({
                name: sessionContext.prevKernelName
            });
            return true;
        }
        // Bail if there is no previous kernel to start.
        if (!kernel) {
            throw new Error('No kernel to restart');
        }
        // Skip the dialog and restart the kernel
        const kernelPluginId = '@jupyterlab/apputils-extension:sessionDialogs';
        const skipKernelRestartDialog = (_c = (_b = sessionContext.kernelPreference) === null || _b === void 0 ? void 0 : _b.skipKernelRestartDialog) !== null && _c !== void 0 ? _c : false;
        const skipKernelRestartDialogSetting = (_e = (await ((_d = this._settingRegistry) === null || _d === void 0 ? void 0 : _d.get(kernelPluginId, 'skipKernelRestartDialog')))) === null || _e === void 0 ? void 0 : _e.composite;
        if (skipKernelRestartDialogSetting || skipKernelRestartDialog) {
            await sessionContext.restartKernel();
            return true;
        }
        const restartBtn = dialog_Dialog.warnButton({
            label: trans.__('Restart'),
            ariaLabel: trans.__('Confirm Kernel Restart')
        });
        const result = await showDialog({
            title: trans.__('Restart Kernel?'),
            body: trans.__('Do you want to restart the kernel of %1? All variables will be lost.', sessionContext.name),
            buttons: [
                dialog_Dialog.cancelButton({ ariaLabel: trans.__('Cancel Kernel Restart') }),
                restartBtn
            ],
            checkbox: {
                label: trans.__('Do not ask me again.'),
                caption: trans.__('If checked, the kernel will restart without confirmation prompt in the future; you can change this back in the settings.')
            }
        });
        if (kernel.isDisposed) {
            return false;
        }
        if (result.button.accept) {
            if (typeof result.isChecked === 'boolean' && result.isChecked == true) {
                sessionContext.kernelPreference = {
                    ...sessionContext.kernelPreference,
                    skipKernelRestartDialog: true
                };
            }
            await (restartOptions === null || restartOptions === void 0 ? void 0 : restartOptions.onBeforeRestart());
            await sessionContext.restartKernel();
            return true;
        }
        return false;
    }
}
(function (SessionContextDialogs) {
    /**
     * Returns available kernel options grouped based on session context.
     *
     * #### Notes
     * If a language preference is set in the given session context, the options
     * returned are grouped with the language preference at the top:
     *
     *  - (Start %1 Kernel, language)
     *    - { all kernelspecs whose language matches in alphabetical order }
     *  - (Use No Kernel)
     *    - `No Kernel`
     *  - (Start Kernel)
     *    - { all other kernelspecs in alphabetical order }
     *  - (Connect to Existing %1 Kernel, language)
     *    - { all running kernels whose language matches in alphabetical order }
     *  - (Connect to Kernel)
     *    - { all other running kernels in alphabetical order }
     *
     * If no language preference is set, these groups and options are returned:
     *
     *  - (Start Kernel)
     *    - { all kernelspecs in alphabetical order }
     *  - (Use No Kernel)
     *    - `No Kernel`
     *  - (Connect to Existing Kernel)
     *    - { all running kernels in alphabetical order  }
     *
     * If the session has a kernel ID and a kernel exists with that id, its
     * corresponding option has `selected` set to `true`. Otherwise if the session
     * context language preference is set, the first kernelspec that matches it is
     * selected.
     */
    function kernelOptions(sessionContext, translator = null) {
        var _a, _b, _c, _d, _e, _f, _g;
        const options = { disabled: false, groups: [] };
        // Create mapping of sessions and kernel ids.
        const kernels = Array.from((_b = (_a = sessionContext.kernelManager) === null || _a === void 0 ? void 0 : _a.running()) !== null && _b !== void 0 ? _b : 
        // If kernel manager is unavailable use kernels from running sessions.
        // TODO: Remove this (next version) when kernel manager is guaranteed.
        Array.from(sessionContext.sessionManager.running())
            .filter(session => !!session.kernel)
            .map(session => session.kernel));
        const sessions = Array.from((_c = sessionContext.sessionManager.running()) !== null && _c !== void 0 ? _c : []).reduce((sessions, session) => {
            var _a;
            if ((_a = session.kernel) === null || _a === void 0 ? void 0 : _a.id)
                sessions[session.kernel.id] = session;
            return sessions;
        }, {});
        const preference = {
            ...sessionContext.kernelPreference,
            id: (_e = (_d = sessionContext.session) === null || _d === void 0 ? void 0 : _d.kernel) === null || _e === void 0 ? void 0 : _e.id
        };
        const currentKernelDisplayName = !sessionContext.hasNoKernel
            ? sessionContext.kernelDisplayName
            : null;
        const specs = {
            default: '',
            kernelspecs: Object.create(null),
            ...sessionContext.specsManager.specs
        };
        // Create mapping of languages and kernel names.
        const sorted = [];
        const languages = Object.create(null);
        for (const name in specs.kernelspecs) {
            sorted.push(specs.kernelspecs[name]);
            languages[name] = specs.kernelspecs[name].language;
        }
        sorted.sort((a, b) => a.display_name.localeCompare(b.display_name));
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const language = preference.language ||
            languages[preference.name] ||
            (preference.id ? languages[(_f = sessions[preference.id]) === null || _f === void 0 ? void 0 : _f.name] : '');
        const labels = {
            connectKernel: trans.__('Connect to Existing Kernel'),
            startPreferred: trans.__('Start %1 Kernel', language),
            startOther: trans.__('Start Kernel'),
            connectToPreferred: trans.__('Connect to Existing %1 Kernel', language),
            connectToOther: trans.__('Connect to Other Kernel'),
            noKernel: trans.__('No Kernel'),
            startKernel: trans.__('Start Kernel'),
            useNoKernel: trans.__('Use No Kernel')
        };
        const noKernel = {
            label: labels.useNoKernel,
            options: [
                {
                    text: labels.noKernel,
                    title: labels.noKernel,
                    value: JSON.stringify(null)
                }
            ]
        };
        const optionForKernel = (kernel, displayName, session) => {
            const sessionName = session
                ? session.name || coreutils_lib_index_js_.PathExt.basename(session.path)
                : kernel.name || trans.__('Unknown Kernel');
            return {
                text: `${sessionName} (${kernel.id.split('-')[0]})`,
                title: (session ? `${trans.__('Path: %1', session.path)}\n` : ``) +
                    `${trans.__('Name: %1', sessionName)}\n` +
                    `${trans.__('Kernel Name: %1', displayName !== null && displayName !== void 0 ? displayName : kernel.name)}\n` +
                    `${trans.__('Kernel Id: %1', kernel.id)}`,
                value: JSON.stringify({ id: kernel.id })
            };
        };
        const optionForSpec = (spec) => ({
            text: spec.display_name,
            value: JSON.stringify({ name: spec.name })
        });
        // If a kernel cannot be started, bail.
        if (preference.canStart === false) {
            options.disabled = true;
            options.groups.push(noKernel);
            return options;
        }
        // Create kernel option groups based on whether language preference exists.
        if (language) {
            // Add all kernelspecs, separating out the preferred language first.
            const preferred = {
                label: labels.startPreferred,
                options: []
            };
            const other = {
                label: labels.startOther,
                options: []
            };
            const preferredRunning = {
                label: labels.connectToPreferred,
                options: []
            };
            const otherRunning = {
                label: labels.connectToOther,
                options: []
            };
            for (const spec of sorted) {
                (spec.language === language ? preferred : other).options.push(optionForSpec(spec));
            }
            options.groups.push(preferred);
            options.groups.push(noKernel);
            options.groups.push(other);
            kernels
                .map(kernel => {
                var _a, _b;
                return ({
                    option: optionForKernel(kernel, (_b = (_a = specs.kernelspecs[kernel.name]) === null || _a === void 0 ? void 0 : _a.display_name) !== null && _b !== void 0 ? _b : '', sessions[kernel.id]),
                    language: languages[kernel.name]
                });
            })
                .sort((a, b) => a.option.text.localeCompare(b.option.text))
                .forEach(kernel => (language === kernel.language
                ? preferredRunning
                : otherRunning).options.push(kernel.option));
            if (preferredRunning.options.length)
                options.groups.push(preferredRunning);
            if (otherRunning.options.length)
                options.groups.push(otherRunning);
        }
        else {
            // Add kernelspecs first.
            options.groups.push({
                label: labels.startKernel,
                options: sorted.map(spec => optionForSpec(spec))
            });
            // Next add the no kernel option.
            options.groups.push(noKernel);
            // Add running kernels.
            options.groups.push({
                label: labels.connectKernel,
                options: kernels
                    .map(kernel => {
                    var _a, _b;
                    return optionForKernel(kernel, (_b = (_a = specs.kernelspecs[kernel.name]) === null || _a === void 0 ? void 0 : _a.display_name) !== null && _b !== void 0 ? _b : '', sessions[kernel.id]);
                })
                    .sort((a, b) => a.text.localeCompare(b.text))
            });
        }
        // Set the selected option.
        if (preference.id || currentKernelDisplayName || preference.name) {
            for (const group of options.groups) {
                for (const option of group.options) {
                    const choice = JSON.parse(option.value);
                    if (!choice)
                        continue;
                    if (preference.id) {
                        if (preference.id === choice.id) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                    if (currentKernelDisplayName) {
                        if (currentKernelDisplayName ===
                            ((_g = specs.kernelspecs[choice.name]) === null || _g === void 0 ? void 0 : _g.display_name)) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                    if (preference.name) {
                        if (preference.name === choice.name) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                }
            }
        }
        return options;
    }
    SessionContextDialogs.kernelOptions = kernelOptions;
})(sessioncontext_SessionContextDialogs || (sessioncontext_SessionContextDialogs = {}));
/**
 * The namespace for module private data.
 */
var sessioncontext_Private;
(function (Private) {
    /**
     * Return a kernel selector widget.
     */
    Private.createKernelSelector = (sessionContext, translator) => new KernelSelector({
        node: createSelectorNode(sessionContext, translator)
    });
    /**
     * A widget that provides a kernel selection.
     */
    class KernelSelector extends index_es6_js_.Widget {
        /**
         * Get the value of the kernel selector widget.
         */
        getValue() {
            const selector = this.node.querySelector('select');
            return JSON.parse(selector.value);
        }
    }
    /**
     * Create an HTML node for a kernel selector widget.
     */
    function createSelectorNode(sessionContext, translator) {
        // Create the dialog body.
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const body = document.createElement('div');
        const text = document.createElement('label');
        text.textContent = `${trans.__('Select kernel for:')} "${sessionContext.name}"`;
        body.appendChild(text);
        const select = document.createElement('select');
        const options = sessioncontext_SessionContextDialogs.kernelOptions(sessionContext, translator);
        if (options.disabled)
            select.disabled = true;
        for (const group of options.groups) {
            const { label, options } = group;
            const optgroup = document.createElement('optgroup');
            optgroup.label = label;
            for (const { selected, text, title, value } of options) {
                const option = document.createElement('option');
                if (selected)
                    option.selected = true;
                if (title)
                    option.title = title;
                option.text = text;
                option.value = value;
                optgroup.appendChild(option);
            }
            select.appendChild(optgroup);
        }
        body.appendChild(select);
        return body;
    }
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        var _a;
        const { specs, preference } = options;
        const { name, language, canStart, autoStartDefault } = preference;
        if (!specs || canStart === false) {
            return null;
        }
        const defaultName = autoStartDefault ? specs.default : null;
        if (!name && !language) {
            return defaultName;
        }
        // Look for an exact match of a spec name.
        for (const specName in specs.kernelspecs) {
            if (specName === name) {
                return name;
            }
        }
        // Bail if there is no language.
        if (!language) {
            return defaultName;
        }
        // Check for a single kernel matching the language.
        const matches = [];
        for (const specName in specs.kernelspecs) {
            const kernelLanguage = (_a = specs.kernelspecs[specName]) === null || _a === void 0 ? void 0 : _a.language;
            if (language === kernelLanguage) {
                matches.push(specName);
            }
        }
        if (matches.length === 1) {
            const specName = matches[0];
            console.warn('No exact match found for ' +
                specName +
                ', using kernel ' +
                specName +
                ' that matches ' +
                'language=' +
                language);
            return specName;
        }
        // No matches found.
        return defaultName;
    }
    Private.getDefaultKernel = getDefaultKernel;
})(sessioncontext_Private || (sessioncontext_Private = {}));
//# sourceMappingURL=sessioncontext.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(69360);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/kernelstatuses.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * Helper function to translate kernel statuses mapping by using
 * input translator.
 *
 * @param translator - Language translator.
 * @return The translated kernel status mapping.
 */
function translateKernelStatuses(translator) {
    translator = translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    const translated = {
        unknown: trans.__('Unknown'),
        starting: trans.__('Starting'),
        idle: trans.__('Idle'),
        busy: trans.__('Busy'),
        terminating: trans.__('Terminating'),
        restarting: trans.__('Restarting'),
        autorestarting: trans.__('Autorestarting'),
        dead: trans.__('Dead'),
        connected: trans.__('Connected'),
        connecting: trans.__('Connecting'),
        disconnected: trans.__('Disconnected'),
        initializing: trans.__('Initializing'),
        '': ''
    };
    return translated;
}
/**
 * A pure functional component for rendering kernel status.
 */
function KernelStatusComponent(props) {
    const translator = props.translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    let statusText = '';
    if (props.status) {
        statusText = ` | ${props.status}`;
    }
    return (react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { role: "button", "aria-haspopup": true, onClick: props.handleClick, onKeyDown: props.handleKeyDown, source: `${props.kernelName}${statusText}`, title: trans.__('Change kernel for %1', props.activityName), tabIndex: 0 }));
}
/**
 * A VDomRenderer widget for displaying the status of a kernel.
 */
class kernelstatuses_KernelStatus extends index_js_.VDomRenderer {
    /**
     * Construct the kernel status widget.
     */
    constructor(opts, translator) {
        super(new kernelstatuses_KernelStatus.Model(translator));
        this.translator = translator || lib_index_js_.nullTranslator;
        this._handleClick = opts.onClick;
        this._handleKeyDown = opts.onKeyDown;
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the kernel status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react_index_js_default().createElement(KernelStatusComponent, { status: this.model.status, kernelName: this.model.kernelName, activityName: this.model.activityName, handleClick: this._handleClick, handleKeyDown: this._handleKeyDown, translator: this.translator }));
        }
    }
}
/**
 * A namespace for KernelStatus statics.
 */
(function (KernelStatus) {
    /**
     * A VDomModel for the kernel status indicator.
     */
    class Model extends index_js_.VDomModel {
        constructor(translator) {
            super();
            this._activityName = '';
            this._kernelName = '';
            this._kernelStatus = '';
            this._sessionContext = null;
            translator = translator !== null && translator !== void 0 ? translator : lib_index_js_.nullTranslator;
            this._trans = translator.load('jupyterlab');
            this._statusNames = translateKernelStatuses(translator);
        }
        /**
         * The name of the kernel.
         */
        get kernelName() {
            return this._kernelName;
        }
        /**
         * The current status of the kernel.
         */
        get status() {
            return this._kernelStatus
                ? this._statusNames[this._kernelStatus]
                : undefined;
        }
        /**
         * A display name for the activity.
         */
        get activityName() {
            return this._activityName;
        }
        set activityName(val) {
            const oldVal = this._activityName;
            if (oldVal === val) {
                return;
            }
            this._activityName = val;
            this.stateChanged.emit();
        }
        /**
         * The current client session associated with the kernel status indicator.
         */
        get sessionContext() {
            return this._sessionContext;
        }
        set sessionContext(sessionContext) {
            var _a, _b, _c, _d;
            (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.statusChanged.disconnect(this._onKernelStatusChanged, this);
            (_b = this._sessionContext) === null || _b === void 0 ? void 0 : _b.connectionStatusChanged.disconnect(this._onKernelStatusChanged, this);
            (_c = this._sessionContext) === null || _c === void 0 ? void 0 : _c.kernelChanged.disconnect(this._onKernelChanged, this);
            const oldState = this._getAllState();
            this._sessionContext = sessionContext;
            this._kernelStatus = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayStatus;
            this._kernelName =
                (_d = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName) !== null && _d !== void 0 ? _d : this._trans.__('No Kernel');
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.statusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.connectionStatusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelChanged.connect(this._onKernelChanged, this);
            this._triggerChange(oldState, this._getAllState());
        }
        /**
         * React to changes to the kernel status.
         */
        _onKernelStatusChanged() {
            var _a;
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this.stateChanged.emit(void 0);
        }
        /**
         * React to changes in the kernel.
         */
        _onKernelChanged(_sessionContext, change) {
            var _a;
            const oldState = this._getAllState();
            // sync setting of status and display name
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this._kernelName = _sessionContext.kernelDisplayName;
            this._triggerChange(oldState, this._getAllState());
        }
        _getAllState() {
            return [this._kernelName, this._kernelStatus, this._activityName];
        }
        _triggerChange(oldState, newState) {
            if (dist_index_js_.JSONExt.deepEqual(oldState, newState)) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    KernelStatus.Model = Model;
})(kernelstatuses_KernelStatus || (kernelstatuses_KernelStatus = {}));
//# sourceMappingURL=kernelstatuses.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/widget.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * The class name added to toolbar kernel name text.
 */
const TOOLBAR_KERNEL_NAME_CLASS = 'jp-Toolbar-kernelName';
/**
 * The class name added to toolbar kernel status icon.
 */
const TOOLBAR_KERNEL_STATUS_CLASS = 'jp-Toolbar-kernelStatus';
/**
 * The namespace for Toolbar class statics.
 */
var widget_Toolbar;
(function (Toolbar) {
    /**
     * Create an interrupt toolbar item.
     *
     * @deprecated since version v3.2
     * This is dead code now.
     */
    function createInterruptButton(sessionContext, translator) {
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new index_js_.ToolbarButton({
            icon: index_js_.stopIcon,
            onClick: () => {
                var _a, _b;
                void ((_b = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.interrupt());
            },
            tooltip: trans.__('Interrupt the kernel')
        });
    }
    Toolbar.createInterruptButton = createInterruptButton;
    /**
     * Create a restart toolbar item.
     *
     * @deprecated since v3.2
     * This is dead code now.
     */
    function createRestartButton(sessionContext, dialogs, translator) {
        translator = translator !== null && translator !== void 0 ? translator : lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new index_js_.ToolbarButton({
            icon: index_js_.refreshIcon,
            onClick: () => {
                void (dialogs !== null && dialogs !== void 0 ? dialogs : new sessioncontext_SessionContextDialogs({ translator })).restart(sessionContext);
            },
            tooltip: trans.__('Restart the kernel')
        });
    }
    Toolbar.createRestartButton = createRestartButton;
    /**
     * Create a kernel name indicator item.
     *
     * #### Notes
     * It will display the `'display_name`' of the session context. It can
     * handle a change in context or kernel.
     */
    function createKernelNameItem(sessionContext, dialogs, translator) {
        const el = index_js_.ReactWidget.create(react_index_js_.createElement(widget_Private.KernelNameComponent, { sessionContext: sessionContext, dialogs: dialogs !== null && dialogs !== void 0 ? dialogs : new sessioncontext_SessionContextDialogs({ translator }), translator: translator }));
        el.addClass('jp-KernelName');
        return el;
    }
    Toolbar.createKernelNameItem = createKernelNameItem;
    /**
     * Create a kernel status indicator item.
     *
     * @deprecated since v3.5
     * The kernel status indicator is now replaced by the execution status indicator.
     *
     * #### Notes
     * It will show a busy status if the kernel status is busy.
     * It will show the current status in the node title.
     * It can handle a change to the context or the kernel.
     */
    function createKernelStatusItem(sessionContext, translator) {
        return new widget_Private.KernelStatus(sessionContext, translator);
    }
    Toolbar.createKernelStatusItem = createKernelStatusItem;
})(widget_Toolbar || (widget_Toolbar = {}));
/**
 * A namespace for private data.
 */
var widget_Private;
(function (Private) {
    /**
     * React component for a kernel name button.
     *
     * This wraps the ToolbarButtonComponent and watches the kernel
     * session for changes.
     */
    function KernelNameComponent(props) {
        const translator = props.translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const callback = () => {
            void props.dialogs.selectKernel(props.sessionContext);
        };
        return (react_index_js_.createElement(index_js_.UseSignal, { signal: props.sessionContext.kernelChanged, initialSender: props.sessionContext }, sessionContext => (react_index_js_.createElement(index_js_.ToolbarButtonComponent, { className: TOOLBAR_KERNEL_NAME_CLASS, onClick: callback, tooltip: trans.__('Switch kernel'), label: sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName }))));
    }
    Private.KernelNameComponent = KernelNameComponent;
    /**
     * A toolbar item that displays kernel status.
     *
     * @deprecated This code is not use any longer and will be removed in JupyterLab 5
     */
    class KernelStatus extends index_es6_js_.Widget {
        /**
         * Construct a new kernel status widget.
         */
        constructor(sessionContext, translator) {
            super();
            this.translator = translator || lib_index_js_.nullTranslator;
            this._trans = this.translator.load('jupyterlab');
            this.addClass(TOOLBAR_KERNEL_STATUS_CLASS);
            this._statusNames = translateKernelStatuses(this.translator);
            this._onStatusChanged(sessionContext);
            sessionContext.statusChanged.connect(this._onStatusChanged, this);
            sessionContext.connectionStatusChanged.connect(this._onStatusChanged, this);
        }
        /**
         * Handle a status on a kernel.
         */
        _onStatusChanged(sessionContext) {
            if (this.isDisposed) {
                return;
            }
            const status = sessionContext.kernelDisplayStatus;
            const circleIconProps = {
                container: this.node,
                title: this._trans.__('Kernel %1', this._statusNames[status] || status),
                stylesheet: 'toolbarButton',
                alignSelf: 'normal',
                height: '24px'
            };
            // set the icon
            index_js_.LabIcon.remove(this.node);
            if (status === 'busy' ||
                status === 'starting' ||
                status === 'terminating' ||
                status === 'restarting' ||
                status === 'initializing') {
                index_js_.circleIcon.element(circleIconProps);
            }
            else if (status === 'connecting' ||
                status === 'disconnected' ||
                status === 'unknown') {
                index_js_.offlineBoltIcon.element(circleIconProps);
            }
            else {
                index_js_.circleEmptyIcon.element(circleIconProps);
            }
        }
    }
    Private.KernelStatus = KernelStatus;
})(widget_Private || (widget_Private = {}));
//# sourceMappingURL=widget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/clipboard.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The clipboard interface.
 */
var clipboard_Clipboard;
(function (Clipboard) {
    /**
     * Get the application clipboard instance.
     *
     * @deprecated To use `SystemClipboard.getInstance` for copy/cut/paste cells.
     */
    function getInstance() {
        return clipboard_Private.instance;
    }
    Clipboard.getInstance = getInstance;
    /**
     * Set the application clipboard instance.
     *
     * @deprecated will be removed in a future release. Use `SystemClipboard.getInstance`.
     */
    function setInstance(value) {
        clipboard_Private.instance = value;
    }
    Clipboard.setInstance = setInstance;
    /**
     * Copy text to the system clipboard.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function copyToSystem(clipboardData) {
        const node = document.body;
        const handler = (event) => {
            const data = event.clipboardData || window.clipboardData;
            if (typeof clipboardData === 'string') {
                data.setData('text', clipboardData);
            }
            else {
                clipboardData.types().map((mimeType) => {
                    data.setData(mimeType, clipboardData.getData(mimeType));
                });
            }
            event.preventDefault();
            node.removeEventListener('copy', handler);
        };
        node.addEventListener('copy', handler);
        generateEvent(node);
    }
    Clipboard.copyToSystem = copyToSystem;
    /**
     * Generate a clipboard event on a node.
     *
     * @param node - The element on which to generate the event.
     *
     * @param type - The type of event to generate.
     *   `'paste'` events cannot be programmatically generated.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function generateEvent(node, type = 'copy') {
        // http://stackoverflow.com/a/5210367
        // Identify selected text.
        let sel = window.getSelection();
        // Save the current selection.
        const savedRanges = [];
        for (let i = 0, len = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) || 0; i < len; ++i) {
            savedRanges[i] = sel.getRangeAt(i).cloneRange();
        }
        // Select the node content.
        const range = document.createRange();
        range.selectNodeContents(node);
        if (sel) {
            sel.removeAllRanges();
            sel.addRange(range);
        }
        // Execute the command.
        document.execCommand(type);
        // Restore the previous selection.
        sel = window.getSelection();
        if (sel) {
            sel.removeAllRanges();
            for (let i = 0, len = savedRanges.length; i < len; ++i) {
                sel.addRange(savedRanges[i]);
            }
        }
    }
    Clipboard.generateEvent = generateEvent;
})(clipboard_Clipboard || (clipboard_Clipboard = {}));
/**
 * The clipboard interface supporting the native clipboard API.
 */
var clipboard_SystemClipboard;
(function (SystemClipboard) {
    /**
     * Get the system clipboard instance.
     */
    function getInstance() {
        return clipboard_Private.systemInstance;
    }
    SystemClipboard.getInstance = getInstance;
})(clipboard_SystemClipboard || (clipboard_SystemClipboard = {}));
/**
 * The namespace for module private data.
 */
var clipboard_Private;
(function (Private) {
    /**
     * The mimetype used for Jupyter cell data.
     */
    const JUPYTER_CELL_MIME = 'application/vnd.jupyter.cells';
    /**
     * An implementation of the clipboard interface.
     * This uses the native clipboard API when available, with a fallback to
     * a MimeData instance otherwise - The native clipboard API only works in
     * secure contexts (pages served over HTTPS or localhost).
     */
    class ClipboardImpl {
        /**
         * Create a new clipboard instance.
         */
        constructor(fallback) {
            this.fallback = fallback || new dist_index_js_.MimeData();
            const { systemClipboard } = this;
            if (!systemClipboard) {
                console.warn('Clipboard API not available');
            }
        }
        /**
         * Clear the clipboard.
         * This is a no-op for the native clipboard API.
         * The fallback clipboard is cleared by setting the data to an empty
         */
        clear() {
            this.fallback.clear();
        }
        /**
         * Whether the clipboard has data for a given mime type.
         * Returns `false` if the data does not exist.
         *
         * @param mime - The mime type to check.
         */
        async hasData(mime) {
            const { systemClipboard } = this;
            if (!systemClipboard) {
                return this.fallback.hasData(mime);
            }
            let text;
            try {
                text = await systemClipboard.readText();
            }
            catch (reason) {
                console.warn('Failed to read data from clipboard:', reason);
                if (reason.name === 'NotAllowedError') {
                    // If the clipboard API is not allowed, fall back to the
                    // internal clipboard.
                    return this.fallback.hasData(mime);
                }
                return false;
            }
            try {
                this.convertStringToData(mime, text);
                return true;
            }
            catch (reason) {
                return false;
            }
        }
        /**
         * Retrieve the data for a given mime type.
         *
         * @param mime - The mime type to retrieve.
         * @returns A promise that resolves with the data for the given mime type.
         */
        async getData(mime) {
            const { systemClipboard } = this;
            if (!systemClipboard) {
                return this.fallback.getData(mime);
            }
            try {
                const text = await systemClipboard.readText();
                return this.convertStringToData(mime, text);
            }
            catch (reason) {
                console.warn('Failed to read data from clipboard:', reason);
                if (reason.name === 'NotAllowedError') {
                    // If the clipboard API is not allowed, fall back to the
                    // internal clipboard.
                    return this.fallback.getData(mime);
                }
                return null;
            }
        }
        /**
         * Set the data for a given mime type.
         *
         * @param mime - The mime type to set.
         * @param data - The data to set.
         */
        async setData(mime, data) {
            const { systemClipboard } = this;
            if (!systemClipboard) {
                this.fallback.clear();
                this.fallback.setData(mime, data);
                return;
            }
            try {
                await systemClipboard.writeText(this.convertDataToString(mime, data));
            }
            catch (reason) {
                console.warn('Failed to write data to clipboard:', reason);
                // If the clipboard API is not allowed, fall back to the
                // internal clipboard.
                this.fallback.clear();
                this.fallback.setData(mime, data);
            }
        }
        /**
         * Convert the data to a string for the given mime type.
         */
        convertDataToString(mime, data) {
            if (mime === JUPYTER_CELL_MIME) {
                return JSON.stringify(data);
            }
            return (data || '').toString();
        }
        /**
         * Convert the string to data for the given mime type.
         */
        convertStringToData(mime, text) {
            if (mime === JUPYTER_CELL_MIME) {
                return JSON.parse(text);
            }
            return text;
        }
        /**
         * Get the system clipboard instance.
         */
        get systemClipboard() {
            return navigator.clipboard;
        }
    }
    /**
     * The application clipboard instance.
     */
    Private.instance = new dist_index_js_.MimeData();
    /**
     * The system clipboard instance.
     */
    Private.systemInstance = new ClipboardImpl();
})(clipboard_Private || (clipboard_Private = {}));
//# sourceMappingURL=clipboard.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/commandlinker.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The command data attribute added to nodes that are connected.
 */
const COMMAND_ATTR = 'commandlinker-command';
/**
 * The args data attribute added to nodes that are connected.
 */
const ARGS_ATTR = 'commandlinker-args';
/**
 * A static class that provides helper methods to generate clickable nodes that
 * execute registered commands with pre-populated arguments.
 */
class CommandLinker {
    /**
     * Instantiate a new command linker.
     */
    constructor(options) {
        this._isDisposed = false;
        this._commands = options.commands;
        document.body.addEventListener('click', this);
    }
    /**
     * Test whether the linker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the linker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        document.body.removeEventListener('click', this);
    }
    /**
     * Connect a command/argument pair to a given node so that when it is clicked,
     * the command will execute.
     *
     * @param node - The node being connected.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns The same node that was passed in, after it has been connected.
     *
     * #### Notes
     * Only `click` events will execute the command on a connected node. So, there
     * are two considerations that are relevant:
     * 1. If a node is connected, the default click action will be prevented.
     * 2. The `HTMLElement` passed in should be clickable.
     */
    connectNode(node, command, args) {
        node.setAttribute(`data-${COMMAND_ATTR}`, command);
        if (args !== void 0) {
            node.setAttribute(`data-${ARGS_ATTR}`, JSON.stringify(args));
        }
        return node;
    }
    /**
     * Disconnect a node that has been connected to execute a command on click.
     *
     * @param node - The node being disconnected.
     *
     * @returns The same node that was passed in, after it has been disconnected.
     *
     * #### Notes
     * This method is safe to call multiple times and is safe to call on nodes
     * that were never connected.
     *
     * This method can be called on rendered virtual DOM nodes that were populated
     * using the `populateVNodeDataset` method in order to disconnect them from
     * executing their command/argument pair.
     */
    disconnectNode(node) {
        node.removeAttribute(`data-${COMMAND_ATTR}`);
        node.removeAttribute(`data-${ARGS_ATTR}`);
        return node;
    }
    /**
     * Handle the DOM events for the command linker helper class.
     *
     * @param event - The DOM event sent to the class.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'click':
                this._evtClick(event);
                break;
            default:
                return;
        }
    }
    /**
     * Populate the `dataset` attribute within the collection of attributes used
     * to instantiate a virtual DOM node with the values necessary for its
     * rendered DOM node to respond to clicks by executing a command/argument
     * pair.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns A `dataset` collection for use within virtual node attributes.
     *
     * #### Notes
     * The return value can be used on its own as the value for the `dataset`
     * attribute of a virtual element, or it can be added to an existing `dataset`
     * as in the example below.
     *
     * #### Example
     * ```typescript
     * let command = 'some:command-id';
     * let args = { alpha: 'beta' };
     * let anchor = h.a({
     *   className: 'some-class',
     *   dataset: {
     *     foo: '1',
     *     bar: '2',
     *     ../...linker.populateVNodeDataset(command, args)
     *   }
     * }, 'some text');
     * ```
     */
    populateVNodeDataset(command, args) {
        let dataset;
        if (args !== void 0) {
            dataset = { [ARGS_ATTR]: JSON.stringify(args), [COMMAND_ATTR]: command };
        }
        else {
            dataset = { [COMMAND_ATTR]: command };
        }
        return dataset;
    }
    /**
     * The global click handler that deploys commands/argument pairs that are
     * attached to the node being clicked.
     */
    _evtClick(event) {
        let target = event.target;
        while (target && target.parentElement) {
            if (target.hasAttribute(`data-${COMMAND_ATTR}`)) {
                event.preventDefault();
                const command = target.getAttribute(`data-${COMMAND_ATTR}`);
                if (!command) {
                    return;
                }
                const argsValue = target.getAttribute(`data-${ARGS_ATTR}`);
                let args = dist_index_js_.JSONExt.emptyObject;
                if (argsValue) {
                    args = JSON.parse(argsValue);
                }
                void this._commands.execute(command, args);
                return;
            }
            target = target.parentElement;
        }
    }
}
//# sourceMappingURL=commandlinker.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/commandpalette.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * Class name identifying the input group with search icon.
 */
const SEARCH_ICON_GROUP_CLASS = 'jp-SearchIconGroup';
/**
 * Wrap the command palette in a modal to make it more usable.
 */
class ModalCommandPalette extends index_es6_js_.Panel {
    constructor(options) {
        super();
        this._options = options;
        this.addClass('jp-ModalCommandPalette');
        this.addClass('jp-ThemedContainer');
        this.id = 'modal-command-palette';
        this.palette = options.commandPalette;
        this._commandPalette.commands.commandExecuted.connect(() => {
            if (this.isAttached && this.isVisible) {
                this.hideAndReset();
            }
        });
        // required to properly receive blur and focus events;
        // selection of items with mouse may not work without this.
        this.node.tabIndex = 0;
    }
    get palette() {
        return this._commandPalette;
    }
    set palette(value) {
        this._commandPalette = value;
        if (!this.searchIconGroup) {
            this._commandPalette.inputNode.insertAdjacentElement('afterend', this.createSearchIconGroup());
        }
        this.addWidget(value);
        this.hideAndReset();
    }
    attach() {
        index_es6_js_.Widget.attach(this, document.body);
    }
    detach() {
        index_es6_js_.Widget.detach(this);
    }
    /**
     * Hide the modal command palette and reset its search.
     */
    hideAndReset() {
        var _a, _b;
        this.hide();
        this._commandPalette.inputNode.value = '';
        this._commandPalette.refresh();
        (_b = (_a = this._options).restore) === null || _b === void 0 ? void 0 : _b.call(_a);
    }
    /**
     * Handle incoming events.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'blur': {
                // if the focus shifted outside of this DOM element, hide and reset.
                if (
                // focus went away from child element
                this.node.contains(event.target) &&
                    // and it did NOT go to another child element but someplace else
                    !this.node.contains(event.relatedTarget)) {
                    event.stopPropagation();
                    this.hideAndReset();
                }
                break;
            }
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     * Find the element with search icon group.
     */
    get searchIconGroup() {
        return this._commandPalette.node.getElementsByClassName(SEARCH_ICON_GROUP_CLASS)[0];
    }
    /**
     * Create element with search icon group.
     */
    createSearchIconGroup() {
        const inputGroup = document.createElement('div');
        inputGroup.classList.add(SEARCH_ICON_GROUP_CLASS);
        index_js_.searchIcon.render(inputGroup);
        return inputGroup;
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        this.node.addEventListener('keydown', this, true);
        this.node.addEventListener('contextmenu', this, true);
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        this.node.removeEventListener('keydown', this, true);
        this.node.removeEventListener('contextmenu', this, true);
    }
    onBeforeHide(msg) {
        document.removeEventListener('blur', this, true);
    }
    onAfterShow(msg) {
        document.addEventListener('blur', this, true);
    }
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    onActivateRequest(msg) {
        if (this.isAttached) {
            this.show();
            this._commandPalette.activate();
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                this.hideAndReset();
                break;
            default:
                break;
        }
    }
}
//# sourceMappingURL=commandpalette.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/domutils@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/domutils/dist/index.es6.js)
var domutils_dist_index_es6_js_ = __webpack_require__(60930);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/domutils.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The namespace for DOM utilities.
 */
var domutils_DOMUtils;
(function (DOMUtils) {
    /**
     * Get the index of the node at a client position, or `-1`.
     */
    function hitTestNodes(nodes, x, y) {
        return dist_index_es6_js_.ArrayExt.findFirstIndex(nodes, node => {
            return domutils_dist_index_es6_js_.ElementExt.hitTest(node, x, y);
        });
    }
    DOMUtils.hitTestNodes = hitTestNodes;
    /**
     * Find the first element matching a class name.
     * Only use this function when the element existence is guaranteed.
     */
    function findElement(parent, className) {
        return parent.querySelector(`.${className}`);
    }
    DOMUtils.findElement = findElement;
    /**
     * Find the first element matching a class name.
     */
    function findElements(parent, className) {
        return parent.getElementsByClassName(className);
    }
    DOMUtils.findElements = findElements;
    /**
     * Create a DOM id with prefix "id-" to solve bug for UUIDs beginning with numbers.
     */
    function createDomID() {
        return `id-${dist_index_js_.UUID.uuid4()}`;
    }
    DOMUtils.createDomID = createDomID;
    /**
     * Check whether the active element descendant from given parent is editable.
     * When checking active elements it includes elements in the open shadow DOM.
     */
    function hasActiveEditableElement(parent, root = document) {
        const element = root.activeElement;
        return !!(element &&
            parent.contains(element) &&
            (element.matches(':read-write') ||
                (element.shadowRoot &&
                    hasActiveEditableElement(element.shadowRoot, element.shadowRoot))));
    }
    DOMUtils.hasActiveEditableElement = hasActiveEditableElement;
})(domutils_DOMUtils || (domutils_DOMUtils = {}));
//# sourceMappingURL=domutils.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/inputdialog.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


const INPUT_DIALOG_CLASS = 'jp-Input-Dialog';
const INPUT_BOOLEAN_DIALOG_CLASS = 'jp-Input-Boolean-Dialog';
/**
 * Namespace for input dialogs
 */
var inputdialog_InputDialog;
(function (InputDialog) {
    /**
     * Create and show a input dialog for a boolean.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getBoolean(options) {
        return showDialog({
            ...options,
            body: new InputBooleanDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getBoolean = getBoolean;
    /**
     * Create and show a input dialog for a number.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getNumber(options) {
        return showDialog({
            ...options,
            body: new InputNumberDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getNumber = getNumber;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getItem(options) {
        return showDialog({
            ...options,
            body: new InputItemsDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: options.editable ? 'input' : 'select'
        });
    }
    InputDialog.getItem = getItem;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getMultipleItems(options) {
        return showDialog({
            ...options,
            body: new InputMultipleItemsDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ]
        });
    }
    InputDialog.getMultipleItems = getMultipleItems;
    /**
     * Create and show a input dialog for a text.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getText(options) {
        return showDialog({
            ...options,
            body: new InputTextDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getText = getText;
    /**
     * Create and show a input dialog for a password.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getPassword(options) {
        return showDialog({
            ...options,
            body: new InputPasswordDialog(options),
            buttons: [
                dialog_Dialog.cancelButton({ label: options.cancelLabel }),
                dialog_Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getPassword = getPassword;
})(inputdialog_InputDialog || (inputdialog_InputDialog = {}));
/**
 * Base widget for input dialog body
 */
class InputDialogBase extends index_es6_js_.Widget {
    /**
     * InputDialog constructor
     *
     * @param label Input field label
     */
    constructor(options) {
        super();
        this.addClass(INPUT_DIALOG_CLASS);
        this._input = document.createElement('input');
        this._input.classList.add('jp-mod-styled');
        this._input.id = 'jp-dialog-input-id';
        if (options.label !== undefined) {
            const labelElement = document.createElement('label');
            labelElement.textContent = options.label;
            labelElement.htmlFor = this._input.id;
            // Initialize the node
            this.node.appendChild(labelElement);
        }
        const wrapper = document.createElement('div');
        wrapper.className = 'jp-InputDialog-inputWrapper';
        if (options.prefix) {
            const prefix = document.createElement('span');
            prefix.className = 'jp-InputDialog-inputPrefix';
            prefix.textContent = options.prefix;
            // Both US WDS (https://designsystem.digital.gov/components/input-prefix-suffix/)
            // and UK DS (https://design-system.service.gov.uk/components/text-input/) recommend
            // hiding prefixes and suffixes from screen readers.
            prefix.ariaHidden = 'true';
            wrapper.appendChild(prefix);
        }
        wrapper.appendChild(this._input);
        if (options.suffix) {
            const suffix = document.createElement('span');
            suffix.className = 'jp-InputDialog-inputSuffix';
            suffix.textContent = options.suffix;
            suffix.ariaHidden = 'true';
            wrapper.appendChild(suffix);
        }
        this.node.appendChild(wrapper);
    }
}
/**
 * Widget body for input boolean dialog
 */
class InputBooleanDialog extends InputDialogBase {
    /**
     * InputBooleanDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this.addClass(INPUT_BOOLEAN_DIALOG_CLASS);
        this._input.type = 'checkbox';
        this._input.checked = options.value ? true : false;
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.checked;
    }
}
/**
 * Widget body for input number dialog
 */
class InputNumberDialog extends InputDialogBase {
    /**
     * InputNumberDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.type = 'number';
        this._input.value = options.value ? options.value.toString() : '0';
    }
    /**
     * Get the number specified by the user.
     */
    getValue() {
        if (this._input.value) {
            return Number(this._input.value);
        }
        else {
            return Number.NaN;
        }
    }
}
/**
 * Base widget body for input text/password/email dialog
 */
class InputDialogTextBase extends InputDialogBase {
    /**
     * InputDialogTextBase constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.value = options.text ? options.text : '';
        if (options.placeholder) {
            this._input.placeholder = options.placeholder;
        }
        if (options.pattern) {
            this._input.pattern = options.pattern;
        }
        if (options.required) {
            this._input.required = options.required;
        }
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.value;
    }
}
/**
 * Widget body for input text dialog
 */
class InputTextDialog extends InputDialogTextBase {
    /**
     * InputTextDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        var _a;
        super(options);
        this._input.type = 'text';
        this._initialSelectionRange = Math.min(this._input.value.length, Math.max(0, (_a = options.selectionRange) !== null && _a !== void 0 ? _a : this._input.value.length));
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._initialSelectionRange > 0 && this._input.value) {
            this._input.setSelectionRange(0, this._initialSelectionRange);
        }
    }
}
/**
 * Widget body for input password dialog
 */
class InputPasswordDialog extends InputDialogTextBase {
    /**
     * InputPasswordDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.type = 'password';
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._input.value) {
            this._input.select();
        }
    }
}
/**
 * Widget body for input list dialog
 */
class InputItemsDialog extends InputDialogBase {
    /**
     * InputItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._editable = options.editable || false;
        let current = options.current || 0;
        let defaultIndex;
        if (typeof current === 'number') {
            defaultIndex = Math.max(0, Math.min(current, options.items.length - 1));
            current = '';
        }
        this._list = document.createElement('select');
        options.items.forEach((item, index) => {
            const option = document.createElement('option');
            if (index === defaultIndex) {
                option.selected = true;
                current = item;
            }
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        if (options.editable) {
            /* Use of list and datalist */
            const data = document.createElement('datalist');
            data.id = 'input-dialog-items';
            data.appendChild(this._list);
            this._input.type = 'list';
            this._input.value = current;
            this._input.setAttribute('list', data.id);
            if (options.placeholder) {
                this._input.placeholder = options.placeholder;
            }
            this.node.appendChild(data);
        }
        else {
            /* Use select directly */
            this._input.parentElement.replaceChild(this._list, this._input);
        }
    }
    /**
     * Get the user choice
     */
    getValue() {
        if (this._editable) {
            return this._input.value;
        }
        else {
            return this._list.value;
        }
    }
}
/**
 * Widget body for input list dialog
 */
class InputMultipleItemsDialog extends InputDialogBase {
    /**
     * InputMultipleItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        let defaults = options.defaults || [];
        this._list = document.createElement('select');
        this._list.setAttribute('multiple', '');
        options.items.forEach(item => {
            const option = document.createElement('option');
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        // use the select
        this._input.remove();
        this.node.appendChild(this._list);
        // select the current ones
        const htmlOptions = this._list.options;
        for (let i = 0; i < htmlOptions.length; i++) {
            const option = htmlOptions[i];
            if (defaults.includes(option.value)) {
                option.selected = true;
            }
            else {
                option.selected = false;
            }
        }
    }
    /**
     * Get the user choices
     */
    getValue() {
        let result = [];
        for (let opt of this._list.options) {
            if (opt.selected && !opt.classList.contains('hidden')) {
                result.push(opt.value || opt.text);
            }
        }
        return result;
    }
}
//# sourceMappingURL=inputdialog.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(43775);
// EXTERNAL MODULE: consume shared module (default) @lumino/virtualdom@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/virtualdom/dist/index.es6.js)
var virtualdom_dist_index_es6_js_ = __webpack_require__(22778);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/licenses.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








const FILTER_SECTION_TITLE_CLASS = 'jp-Licenses-Filters-title';
/**
 * A license viewer
 */
class licenses_Licenses extends index_es6_js_.SplitPanel {
    constructor(options) {
        super();
        this.addClass('jp-Licenses');
        this.model = options.model;
        this.initLeftPanel();
        this.initFilters();
        this.initBundles();
        this.initGrid();
        this.initLicenseText();
        this.setRelativeSizes([1, 2, 3]);
        void this.model.initLicenses().then(() => this._updateBundles());
        this.model.trackerDataChanged.connect(() => {
            this.title.label = this.model.title;
        });
    }
    /**
     * Handle disposing of the widget
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._bundles.currentChanged.disconnect(this.onBundleSelected, this);
        this.model.dispose();
        super.dispose();
    }
    /**
     * Initialize the left area for filters and bundles
     */
    initLeftPanel() {
        this._leftPanel = new index_es6_js_.Panel();
        this._leftPanel.addClass('jp-Licenses-FormArea');
        this.addWidget(this._leftPanel);
        index_es6_js_.SplitPanel.setStretch(this._leftPanel, 1);
    }
    /**
     * Initialize the filters
     */
    initFilters() {
        this._filters = new licenses_Licenses.Filters(this.model);
        index_es6_js_.SplitPanel.setStretch(this._filters, 1);
        this._leftPanel.addWidget(this._filters);
    }
    /**
     * Initialize the listing of available bundles
     */
    initBundles() {
        this._bundles = new index_es6_js_.TabBar({
            orientation: 'vertical',
            renderer: new licenses_Licenses.BundleTabRenderer(this.model)
        });
        this._bundles.addClass('jp-Licenses-Bundles');
        index_es6_js_.SplitPanel.setStretch(this._bundles, 1);
        this._leftPanel.addWidget(this._bundles);
        this._bundles.currentChanged.connect(this.onBundleSelected, this);
        this.model.stateChanged.connect(() => this._bundles.update());
    }
    /**
     * Initialize the listing of packages within the current bundle
     */
    initGrid() {
        this._grid = new licenses_Licenses.Grid(this.model);
        index_es6_js_.SplitPanel.setStretch(this._grid, 1);
        this.addWidget(this._grid);
    }
    /**
     * Initialize the full text of the current package
     */
    initLicenseText() {
        this._licenseText = new licenses_Licenses.FullText(this.model);
        index_es6_js_.SplitPanel.setStretch(this._grid, 1);
        this.addWidget(this._licenseText);
    }
    /**
     * Event handler for updating the model with the current bundle
     */
    onBundleSelected() {
        var _a;
        if ((_a = this._bundles.currentTitle) === null || _a === void 0 ? void 0 : _a.label) {
            this.model.currentBundleName = this._bundles.currentTitle.label;
        }
    }
    /**
     * Update the bundle tabs.
     */
    _updateBundles() {
        this._bundles.clearTabs();
        let i = 0;
        const { currentBundleName } = this.model;
        let currentIndex = 0;
        for (const bundle of this.model.bundleNames) {
            const tab = new index_es6_js_.Widget();
            tab.title.label = bundle;
            if (bundle === currentBundleName) {
                currentIndex = i;
            }
            this._bundles.insertTab(++i, tab.title);
        }
        this._bundles.currentIndex = currentIndex;
    }
}
/** A namespace for license components */
(function (Licenses) {
    /**
     * License report formats understood by the server (once lower-cased)
     */
    Licenses.REPORT_FORMATS = {
        markdown: {
            id: 'markdown',
            title: 'Markdown',
            icon: index_js_.markdownIcon
        },
        csv: {
            id: 'csv',
            title: 'CSV',
            icon: index_js_.spreadsheetIcon
        },
        json: {
            id: 'json',
            title: 'JSON',
            icon: index_js_.jsonIcon
        }
    };
    /**
     * The default format (most human-readable)
     */
    Licenses.DEFAULT_FORMAT = 'markdown';
    /**
     * A class used for fetching licenses from the server.
     */
    class LicensesClient {
        /**
         * Create a new license client.
         */
        constructor(options = {}) {
            var _a;
            this._preferredLicensesUrl = options.licensesUrl;
            this._serverSettings =
                (_a = options.serverSettings) !== null && _a !== void 0 ? _a : services_lib_index_js_.ServerConnection.makeSettings();
        }
        /**
         * Download the licenses in the requested format.
         */
        async download(options) {
            const url = `${this._licensesUrl}?format=${options.format}&download=1`;
            const element = document.createElement('a');
            element.href = url;
            element.download = '';
            document.body.appendChild(element);
            element.click();
            document.body.removeChild(element);
            URL.revokeObjectURL(url);
            return void 0;
        }
        /**
         * Fetch the license bundles from the server.
         */
        async getBundles() {
            const response = await services_lib_index_js_.ServerConnection.makeRequest(this._licensesUrl, {}, this._serverSettings);
            return response.json();
        }
        /**
         * The licences URL.
         *
         * This respects runtime changes to the `licensesUrl` page config option.
         */
        get _licensesUrl() {
            var _a;
            return ((_a = this._preferredLicensesUrl) !== null && _a !== void 0 ? _a : coreutils_lib_index_js_.URLExt.join(this._serverSettings.baseUrl, coreutils_lib_index_js_.PageConfig.getOption('licensesUrl')) + '/');
        }
    }
    Licenses.LicensesClient = LicensesClient;
    /**
     * A model for license data
     */
    class Model extends index_js_.VDomModel {
        constructor(options) {
            super();
            this._selectedPackageChanged = new signaling_dist_index_es6_js_.Signal(this);
            this._trackerDataChanged = new signaling_dist_index_es6_js_.Signal(this);
            this._currentPackageIndex = 0;
            this._licensesReady = new dist_index_js_.PromiseDelegate();
            this._packageFilter = {};
            this._trans = options.trans;
            this._client = options.client;
            if (options.currentBundleName) {
                this._currentBundleName = options.currentBundleName;
            }
            if (options.packageFilter) {
                this._packageFilter = options.packageFilter;
            }
            if (options.currentPackageIndex) {
                this._currentPackageIndex = options.currentPackageIndex;
            }
        }
        /**
         * Handle the initial request for the licenses from the server.
         */
        async initLicenses() {
            try {
                this._serverResponse = await this._client.getBundles();
                this._licensesReady.resolve();
                this.stateChanged.emit(void 0);
            }
            catch (err) {
                this._licensesReady.reject(err);
            }
        }
        /**
         * Download the licenses in the requested format.
         */
        async download(options) {
            return this._client.download(options);
        }
        /**
         * A promise that resolves when the licenses from the server change
         */
        get selectedPackageChanged() {
            return this._selectedPackageChanged;
        }
        /**
         * A promise that resolves when the trackable data changes
         */
        get trackerDataChanged() {
            return this._trackerDataChanged;
        }
        /**
         * The names of the license bundles available
         */
        get bundleNames() {
            var _a;
            return Object.keys(((_a = this._serverResponse) === null || _a === void 0 ? void 0 : _a.bundles) || {});
        }
        /**
         * The current license bundle
         */
        get currentBundleName() {
            if (this._currentBundleName) {
                return this._currentBundleName;
            }
            if (this.bundleNames.length) {
                return this.bundleNames[0];
            }
            return null;
        }
        /**
         * Set the current license bundle, and reset the selected index
         */
        set currentBundleName(currentBundleName) {
            if (this._currentBundleName !== currentBundleName) {
                this._currentBundleName = currentBundleName;
                this.stateChanged.emit(void 0);
                this._trackerDataChanged.emit(void 0);
            }
        }
        /**
         * A promise that resolves when the licenses are available from the server
         */
        get licensesReady() {
            return this._licensesReady.promise;
        }
        /**
         * All the license bundles, keyed by the distributing packages
         */
        get bundles() {
            var _a;
            return ((_a = this._serverResponse) === null || _a === void 0 ? void 0 : _a.bundles) || {};
        }
        /**
         * The index of the currently-selected package within its license bundle
         */
        get currentPackageIndex() {
            return this._currentPackageIndex;
        }
        /**
         * Update the currently-selected package within its license bundle
         */
        set currentPackageIndex(currentPackageIndex) {
            if (this._currentPackageIndex === currentPackageIndex) {
                return;
            }
            this._currentPackageIndex = currentPackageIndex;
            this._selectedPackageChanged.emit(void 0);
            this.stateChanged.emit(void 0);
            this._trackerDataChanged.emit(void 0);
        }
        /**
         * The license data for the currently-selected package
         */
        get currentPackage() {
            var _a;
            if (this.currentBundleName &&
                this.bundles &&
                this._currentPackageIndex != null) {
                return this.getFilteredPackages(((_a = this.bundles[this.currentBundleName]) === null || _a === void 0 ? void 0 : _a.packages) || [])[this._currentPackageIndex];
            }
            return null;
        }
        /**
         * A translation bundle
         */
        get trans() {
            return this._trans;
        }
        get title() {
            return `${this._currentBundleName || ''} ${this._trans.__('Licenses')}`.trim();
        }
        /**
         * The current package filter
         */
        get packageFilter() {
            return this._packageFilter;
        }
        set packageFilter(packageFilter) {
            this._packageFilter = packageFilter;
            this.stateChanged.emit(void 0);
            this._trackerDataChanged.emit(void 0);
        }
        /**
         * Get filtered packages from current bundle where at least one token of each
         * key is present.
         */
        getFilteredPackages(allRows) {
            let rows = [];
            let filters = Object.entries(this._packageFilter)
                .filter(([k, v]) => v && `${v}`.trim().length)
                .map(([k, v]) => [k, `${v}`.toLowerCase().trim().split(' ')]);
            for (const row of allRows) {
                let keyHits = 0;
                for (const [key, bits] of filters) {
                    let bitHits = 0;
                    let rowKeyValue = `${row[key]}`.toLowerCase();
                    for (const bit of bits) {
                        if (rowKeyValue.includes(bit)) {
                            bitHits += 1;
                        }
                    }
                    if (bitHits) {
                        keyHits += 1;
                    }
                }
                if (keyHits === filters.length) {
                    rows.push(row);
                }
            }
            return Object.values(rows);
        }
    }
    Licenses.Model = Model;
    /**
     * A filter form for limiting the packages displayed
     */
    class Filters extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            /**
             * Render a filter input
             */
            this.renderFilter = (key) => {
                const value = this.model.packageFilter[key] || '';
                return (react_index_js_.createElement("input", { type: "text", name: key, defaultValue: value, className: "jp-mod-styled", onInput: this.onFilterInput }));
            };
            /**
             * Handle a filter input changing
             */
            this.onFilterInput = (evt) => {
                const input = evt.currentTarget;
                const { name, value } = input;
                this.model.packageFilter = { ...this.model.packageFilter, [name]: value };
            };
            this.addClass('jp-Licenses-Filters');
            this.addClass('jp-RenderedHTMLCommon');
        }
        render() {
            const { trans } = this.model;
            return (react_index_js_.createElement("div", null,
                react_index_js_.createElement("label", null,
                    react_index_js_.createElement("strong", { className: FILTER_SECTION_TITLE_CLASS }, trans.__('Filter Licenses By'))),
                react_index_js_.createElement("ul", null,
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('Package')),
                        this.renderFilter('name')),
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('Version')),
                        this.renderFilter('versionInfo')),
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('License')),
                        this.renderFilter('licenseId'))),
                react_index_js_.createElement("label", null,
                    react_index_js_.createElement("strong", { className: FILTER_SECTION_TITLE_CLASS }, trans.__('Distributions')))));
        }
    }
    Licenses.Filters = Filters;
    /**
     * A fancy bundle renderer with the package count
     */
    class BundleTabRenderer extends index_es6_js_.TabBar.Renderer {
        constructor(model) {
            super();
            this.closeIconSelector = '.lm-TabBar-tabCloseIcon';
            this.model = model;
        }
        /**
         * Render a full bundle
         */
        renderTab(data) {
            let title = data.title.caption;
            let key = this.createTabKey(data);
            let style = this.createTabStyle(data);
            let className = this.createTabClass(data);
            let dataset = this.createTabDataset(data);
            return virtualdom_dist_index_es6_js_.h.li({ key, className, title, style, dataset }, this.renderIcon(data), this.renderLabel(data), this.renderCountBadge(data));
        }
        /**
         * Render the package count
         */
        renderCountBadge(data) {
            const bundle = data.title.label;
            const { bundles } = this.model;
            const packages = this.model.getFilteredPackages((bundles && bundle ? bundles[bundle].packages : []) || []);
            return virtualdom_dist_index_es6_js_.h.label({}, `${packages.length}`);
        }
    }
    Licenses.BundleTabRenderer = BundleTabRenderer;
    /**
     * A grid of licenses
     */
    class Grid extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            /**
             * Render a single package's license information
             */
            this.renderRow = (row, index) => {
                const selected = index === this.model.currentPackageIndex;
                const onCheck = () => (this.model.currentPackageIndex = index);
                return (react_index_js_.createElement("tr", { key: row.name, className: selected ? 'jp-mod-selected' : '', onClick: onCheck },
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("input", { type: "radio", name: "show-package-license", value: index, onChange: onCheck, checked: selected })),
                    react_index_js_.createElement("th", null, row.name),
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("code", null, row.versionInfo)),
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("code", null, row.licenseId))));
            };
            this.addClass('jp-Licenses-Grid');
            this.addClass('jp-RenderedHTMLCommon');
        }
        /**
         * Render a grid of package license information
         */
        render() {
            var _a;
            const { bundles, currentBundleName, trans } = this.model;
            const filteredPackages = this.model.getFilteredPackages(bundles && currentBundleName
                ? ((_a = bundles[currentBundleName]) === null || _a === void 0 ? void 0 : _a.packages) || []
                : []);
            if (!filteredPackages.length) {
                return (react_index_js_.createElement("blockquote", null,
                    react_index_js_.createElement("em", null, trans.__('No Packages found'))));
            }
            return (react_index_js_.createElement("form", null,
                react_index_js_.createElement("table", null,
                    react_index_js_.createElement("thead", null,
                        react_index_js_.createElement("tr", null,
                            react_index_js_.createElement("td", null),
                            react_index_js_.createElement("th", null, trans.__('Package')),
                            react_index_js_.createElement("th", null, trans.__('Version')),
                            react_index_js_.createElement("th", null, trans.__('License')))),
                    react_index_js_.createElement("tbody", null, filteredPackages.map(this.renderRow)))));
        }
    }
    Licenses.Grid = Grid;
    /**
     * A package's full license text
     */
    class FullText extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            this.addClass('jp-Licenses-Text');
            this.addClass('jp-RenderedHTMLCommon');
            this.addClass('jp-RenderedMarkdown');
        }
        /**
         * Render the license text, or a null state if no package is selected
         */
        render() {
            const { currentPackage, trans } = this.model;
            let head = '';
            let quote = trans.__('No Package selected');
            let code = '';
            if (currentPackage) {
                const { name, versionInfo, licenseId, extractedText } = currentPackage;
                head = `${name} v${versionInfo}`;
                quote = `${trans.__('License')}: ${licenseId || trans.__('No License ID found')}`;
                code = extractedText || trans.__('No License Text found');
            }
            return [
                react_index_js_.createElement("h1", { key: "h1" }, head),
                react_index_js_.createElement("blockquote", { key: "quote" },
                    react_index_js_.createElement("em", null, quote)),
                react_index_js_.createElement("code", { key: "code" }, code)
            ];
        }
    }
    Licenses.FullText = FullText;
})(licenses_Licenses || (licenses_Licenses = {}));
//# sourceMappingURL=licenses.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/printing.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Any object is "printable" if it implements the `IPrintable` interface.
 *
 * To do this it, it must have a method called `Printing.symbol` which returns either a function
 * to print the object or null if it cannot be printed.
 *
 * One way of printing is to use the `printWidget` function, which creates a hidden iframe
 * and copies the DOM nodes from your widget to that iframe and printing just that iframe.
 *
 * Another way to print is to use the `printURL` function, which takes a URL and prints that page.
 */
var printing_Printing;
(function (Printing) {
    /**
     * Symbol to use for a method that returns a function to print an object.
     */
    Printing.symbol = Symbol('printable');
    /**
     * Returns whether an object implements a print method.
     */
    function isPrintable(a) {
        if (typeof a !== 'object' || !a) {
            return false;
        }
        return Printing.symbol in a;
    }
    Printing.isPrintable = isPrintable;
    /**
     * Returns the print function for an object, or null if it does not provide a handler.
     */
    function getPrintFunction(val) {
        if (isPrintable(val)) {
            return val[Printing.symbol]();
        }
        return null;
    }
    Printing.getPrintFunction = getPrintFunction;
    /**
     * Prints a widget by copying it's DOM node
     * to a hidden iframe and printing that iframe.
     */
    function printWidget(widget) {
        return printContent(widget.node);
    }
    Printing.printWidget = printWidget;
    /**
     * Prints a URL by loading it into an iframe.
     *
     * @param url URL to load into an iframe.
     * @param serverSettings The server settings to use for the request.
     */
    async function printURL(url, serverSettings) {
        const settings = serverSettings !== null && serverSettings !== void 0 ? serverSettings : services_lib_index_js_.ServerConnection.makeSettings();
        const text = await (await services_lib_index_js_.ServerConnection.makeRequest(url, {}, settings)).text();
        return printContent(text);
    }
    Printing.printURL = printURL;
    /**
     * Prints a URL or an element in an iframe and then removes the iframe after printing.
     */
    async function printContent(textOrEl) {
        const isText = typeof textOrEl === 'string';
        const iframe = createIFrame();
        const parent = window.document.body;
        parent.appendChild(iframe);
        if (isText) {
            iframe.srcdoc = textOrEl;
            await resolveWhenLoaded(iframe);
        }
        else {
            iframe.src = 'about:blank';
            await resolveWhenLoaded(iframe);
            setIFrameNode(iframe, textOrEl);
        }
        const printed = resolveAfterEvent();
        launchPrint(iframe.contentWindow);
        // Once the print dialog has been dismissed, we regain event handling,
        // and it should be safe to discard the hidden iframe.
        await printed;
        parent.removeChild(iframe);
    }
    /**
     * Creates a new hidden iframe and appends it to the document
     *
     * Modified from
     * https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L24
     */
    function createIFrame() {
        const el = window.document.createElement('iframe');
        // We need both allow-modals and allow-same-origin to be able to
        // call print in the iframe.
        // We intentionally do not allow scripts:
        // https://github.com/jupyterlab/jupyterlab/pull/5850#pullrequestreview-230899790
        el.setAttribute('sandbox', 'allow-modals allow-same-origin');
        const css = 'visibility:hidden;width:0;height:0;position:absolute;z-index:-9999;bottom:0;';
        el.setAttribute('style', css);
        el.setAttribute('width', '0');
        el.setAttribute('height', '0');
        return el;
    }
    /**
     * Copies a node from the base document to the iframe.
     */
    function setIFrameNode(iframe, node) {
        iframe.contentDocument.body.appendChild(node.cloneNode(true));
        iframe.contentDocument.close();
    }
    /**
     * Promise that resolves when all resources are loaded in the window.
     */
    function resolveWhenLoaded(iframe) {
        return new Promise(resolve => {
            iframe.onload = () => resolve();
        });
    }
    /**
     * A promise that resolves after the next mousedown, mousemove, or
     * keydown event. We use this as a proxy for determining when the
     * main window has regained control after the print dialog is removed.
     *
     * We can't use the usual window.onafterprint handler because we
     * disallow Javascript execution in the print iframe.
     */
    function resolveAfterEvent() {
        return new Promise(resolve => {
            const onEvent = () => {
                document.removeEventListener('mousemove', onEvent, true);
                document.removeEventListener('mousedown', onEvent, true);
                document.removeEventListener('keydown', onEvent, true);
                resolve();
            };
            document.addEventListener('mousemove', onEvent, true);
            document.addEventListener('mousedown', onEvent, true);
            document.addEventListener('keydown', onEvent, true);
        });
    }
    /**
     * Prints a content window.
     */
    function launchPrint(contentWindow) {
        const result = contentWindow.document.execCommand('print', false);
        // execCommand won't work in firefox so we call the `print` method instead if it fails
        // https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L148
        if (!result) {
            contentWindow.print();
        }
    }
})(printing_Printing || (printing_Printing = {}));
//# sourceMappingURL=printing.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/mainareawidget.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * A flag to indicate that event handlers are caught in the capture phase.
 */
const USE_CAPTURE = true;
/**
 * A widget meant to be contained in the JupyterLab main area.
 *
 * #### Notes
 * Mirrors all of the `title` attributes of the content.
 * This widget is `closable` by default.
 * This widget is automatically disposed when closed.
 * This widget ensures its own focus when activated.
 */
class MainAreaWidget extends index_es6_js_.Widget {
    /**
     * Construct a new main area widget.
     *
     * @param options - The options for initializing the widget.
     */
    constructor(options) {
        super(options);
        this._changeGuard = false;
        this._spinner = new index_js_.Spinner();
        this._isRevealed = false;
        this._evtMouseDown = () => {
            if (!this.node.contains(document.activeElement)) {
                this._focusContent();
            }
        };
        this.addClass('jp-MainAreaWidget');
        // Set contain=strict to avoid many forced layout rendering while adding cells.
        // Don't forget to remove the CSS class when your remove the spinner to allow
        // the content to be rendered.
        // @see https://github.com/jupyterlab/jupyterlab/issues/9381
        this.addClass('jp-MainAreaWidget-ContainStrict');
        this.id = domutils_DOMUtils.createDomID();
        const trans = (options.translator || lib_index_js_.nullTranslator).load('jupyterlab');
        const content = (this._content = options.content);
        content.node.setAttribute('role', 'region');
        content.node.setAttribute('aria-label', trans.__('main area content'));
        const toolbar = (this._toolbar =
            options.toolbar || new index_js_.ReactiveToolbar({ noFocusOnClick: true }));
        toolbar.node.setAttribute('role', 'toolbar');
        toolbar.node.setAttribute('aria-label', trans.__('main area toolbar'));
        const contentHeader = (this._contentHeader =
            options.contentHeader ||
                new index_es6_js_.BoxPanel({
                    direction: 'top-to-bottom',
                    spacing: 0
                }));
        const layout = (this.layout = new index_es6_js_.BoxLayout({ spacing: 0 }));
        layout.direction = 'top-to-bottom';
        index_es6_js_.BoxLayout.setStretch(toolbar, 0);
        index_es6_js_.BoxLayout.setStretch(contentHeader, 0);
        index_es6_js_.BoxLayout.setStretch(content, 1);
        layout.addWidget(toolbar);
        layout.addWidget(contentHeader);
        layout.addWidget(content);
        if (!content.id) {
            content.id = domutils_DOMUtils.createDomID();
        }
        content.node.tabIndex = -1;
        this._updateTitle();
        content.title.changed.connect(this._updateTitle, this);
        this.title.closable = true;
        this.title.changed.connect(this._updateContentTitle, this);
        if (options.reveal) {
            this.node.appendChild(this._spinner.node);
            this._revealed = options.reveal
                .then(() => {
                if (content.isDisposed) {
                    this.dispose();
                    return;
                }
                content.disposed.connect(() => this.dispose());
                const active = document.activeElement === this._spinner.node;
                this._disposeSpinner();
                this._isRevealed = true;
                if (active) {
                    this._focusContent();
                }
            })
                .catch(e => {
                // Show a revealed promise error.
                const error = new index_es6_js_.Widget();
                error.addClass('jp-MainAreaWidget-error');
                // Show the error to the user.
                const pre = document.createElement('pre');
                pre.textContent = String(e);
                error.node.appendChild(pre);
                index_es6_js_.BoxLayout.setStretch(error, 1);
                this._disposeSpinner();
                content.dispose();
                this._content = null;
                toolbar.dispose();
                this._toolbar = null;
                layout.addWidget(error);
                this._isRevealed = true;
                throw error;
            });
        }
        else {
            // Handle no reveal promise.
            this._spinner.dispose();
            this.removeClass('jp-MainAreaWidget-ContainStrict');
            content.disposed.connect(() => this.dispose());
            this._isRevealed = true;
            this._revealed = Promise.resolve(undefined);
        }
    }
    /**
     * Print method. Deferred to content.
     */
    [printing_Printing.symbol]() {
        if (!this._content) {
            return null;
        }
        return printing_Printing.getPrintFunction(this._content);
    }
    /**
     * The content hosted by the widget.
     */
    get content() {
        return this._content;
    }
    /**
     * The toolbar hosted by the widget.
     */
    get toolbar() {
        return this._toolbar;
    }
    /**
     * A panel for widgets that sit between the toolbar and the content.
     * Imagine a formatting toolbar, notification headers, etc.
     */
    get contentHeader() {
        return this._contentHeader;
    }
    /**
     * Whether the content widget or an error is revealed.
     */
    get isRevealed() {
        return this._isRevealed;
    }
    /**
     * A promise that resolves when the widget is revealed.
     */
    get revealed() {
        return this._revealed;
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        if (this._isRevealed) {
            this._focusContent();
        }
        else {
            this._spinner.node.focus();
        }
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        // Focus content in capture phase to ensure relevant commands operate on the
        // current main area widget.
        // Add the event listener directly instead of using `handleEvent` in order
        // to save sub-classes from needing to reason about calling it as well.
        this.node.addEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        this.node.removeEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
        super.onBeforeDetach(msg);
    }
    /**
     * Handle `'close-request'` messages.
     */
    onCloseRequest(msg) {
        this.dispose();
    }
    /**
     * Handle `'update-request'` messages by forwarding them to the content.
     */
    onUpdateRequest(msg) {
        if (this._content) {
            messaging_dist_index_es6_js_.MessageLoop.sendMessage(this._content, msg);
        }
    }
    _disposeSpinner() {
        this.node.removeChild(this._spinner.node);
        this._spinner.dispose();
        this.removeClass('jp-MainAreaWidget-ContainStrict');
    }
    /**
     * Update the title based on the attributes of the child widget.
     */
    _updateTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        this.title.label = content.title.label;
        this.title.mnemonic = content.title.mnemonic;
        this.title.icon = content.title.icon;
        this.title.iconClass = content.title.iconClass;
        this.title.iconLabel = content.title.iconLabel;
        this.title.caption = content.title.caption;
        this.title.className = content.title.className;
        this.title.dataset = content.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Update the content title based on attributes of the main widget.
     */
    _updateContentTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        content.title.label = this.title.label;
        content.title.mnemonic = this.title.mnemonic;
        content.title.icon = this.title.icon;
        content.title.iconClass = this.title.iconClass;
        content.title.iconLabel = this.title.iconLabel;
        content.title.caption = this.title.caption;
        content.title.className = this.title.className;
        content.title.dataset = this.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Give focus to the content.
     */
    _focusContent() {
        if (!this.content) {
            return;
        }
        // Focus the content node if we aren't already focused on it or a
        // descendent.
        if (!this.content.node.contains(document.activeElement)) {
            this.content.node.focus();
        }
        // Activate the content asynchronously (which may change the focus).
        this.content.activate();
    }
}
//# sourceMappingURL=mainareawidget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/menufactory.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Helper functions to build a menu from the settings
 */
var menufactory_MenuFactory;
(function (MenuFactory) {
    /**
     * Create menus from their description
     *
     * @param data Menubar description
     * @param menuFactory Factory for empty menu
     */
    function createMenus(data, menuFactory) {
        return data
            .filter(item => !item.disabled)
            .sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); })
            .map(menuItem => {
            return dataToMenu(menuItem, menuFactory);
        });
    }
    MenuFactory.createMenus = createMenus;
    /**
     * Convert a menu description in a JupyterLabMenu object
     *
     * @param item Menu description
     * @param menuFactory Empty menu factory
     * @returns The menu widget
     */
    function dataToMenu(item, menuFactory) {
        var _a, _b;
        const menu = menuFactory(item);
        menu.id = item.id;
        // Set the label in case the menu factory did not.
        if (!menu.title.label) {
            menu.title.label = (_a = item.label) !== null && _a !== void 0 ? _a : coreutils_lib_index_js_.Text.titleCase(menu.id.trim());
        }
        if (item.icon) {
            menu.title.icon = index_js_.LabIcon.resolve({ icon: item.icon });
        }
        if (item.mnemonic !== undefined) {
            menu.title.mnemonic = item.mnemonic;
        }
        (_b = item.items) === null || _b === void 0 ? void 0 : _b.filter(item => !item.disabled).sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); }).map(item => {
            addItem(item, menu, menuFactory);
        });
        return menu;
    }
    /**
     * Convert an item description in a context menu item object
     *
     * @param item Context menu item
     * @param menu Context menu to populate
     * @param menuFactory Empty menu factory
     */
    function addContextItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    MenuFactory.addContextItem = addContextItem;
    /**
     * Convert an item description in a menu item object
     *
     * @param item Menu item
     * @param menu Menu to populate
     * @param menuFactory Empty menu factory
     */
    function addItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    /**
     * Update an existing list of menu and returns
     * the new elements.
     *
     * #### Note
     * New elements are added to the current menu list.
     *
     * @param menus Current menus
     * @param data New description to take into account
     * @param menuFactory Empty menu factory
     * @returns Newly created menus
     */
    function updateMenus(menus, data, menuFactory) {
        const newMenus = [];
        data.forEach(item => {
            const menu = menus.find(menu => menu.id === item.id);
            if (menu) {
                mergeMenus(item, menu, menuFactory);
            }
            else {
                if (!item.disabled) {
                    newMenus.push(dataToMenu(item, menuFactory));
                }
            }
        });
        menus.push(...newMenus);
        return newMenus;
    }
    MenuFactory.updateMenus = updateMenus;
    function mergeMenus(item, menu, menuFactory) {
        var _a;
        if (item.disabled) {
            menu.dispose();
        }
        else {
            (_a = item.items) === null || _a === void 0 ? void 0 : _a.forEach(entry => {
                var _a, _b;
                const existingItem = menu === null || menu === void 0 ? void 0 : menu.items.find((i, idx) => {
                    var _a, _b, _c;
                    return i.type === entry.type &&
                        i.command === ((_a = entry.command) !== null && _a !== void 0 ? _a : '') &&
                        ((_b = i.submenu) === null || _b === void 0 ? void 0 : _b.id) === ((_c = entry.submenu) === null || _c === void 0 ? void 0 : _c.id);
                });
                if (existingItem && entry.type !== 'separator') {
                    if (entry.disabled) {
                        menu.removeItem(existingItem);
                    }
                    else {
                        switch ((_a = entry.type) !== null && _a !== void 0 ? _a : 'command') {
                            case 'command':
                                if (entry.command) {
                                    if (!dist_index_js_.JSONExt.deepEqual(existingItem.args, (_b = entry.args) !== null && _b !== void 0 ? _b : {})) {
                                        addItem(entry, menu, menuFactory);
                                    }
                                }
                                break;
                            case 'submenu':
                                if (entry.submenu) {
                                    mergeMenus(entry.submenu, existingItem.submenu, menuFactory);
                                }
                        }
                    }
                }
                else {
                    addItem(entry, menu, menuFactory);
                }
            });
        }
    }
})(menufactory_MenuFactory || (menufactory_MenuFactory = {}));
//# sourceMappingURL=menufactory.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/notification.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Notification manager
 */
class NotificationManager {
    constructor() {
        this._isDisposed = false;
        this._queue = [];
        this._changed = new signaling_dist_index_es6_js_.Signal(this);
    }
    /**
     * Signal emitted whenever a notification changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * Total number of notifications.
     */
    get count() {
        return this._queue.length;
    }
    /**
     * Whether the manager is disposed or not.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * The list of notifications.
     */
    get notifications() {
        return this._queue.slice();
    }
    /**
     * Dismiss one notification (specified by its id) or all if no id provided.
     *
     * @param id Notification id
     */
    dismiss(id) {
        if (typeof id === 'undefined') {
            const q = this._queue.slice();
            this._queue.length = 0;
            for (const notification of q) {
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
        else {
            const notificationIndex = this._queue.findIndex(n => n.id === id);
            if (notificationIndex > -1) {
                const notification = this._queue.splice(notificationIndex, 1)[0];
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
    }
    /**
     * Dispose the manager.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Test whether a notification exists or not.
     *
     * @param id Notification id
     * @returns Notification status
     */
    has(id) {
        return this._queue.findIndex(n => n.id === id) > -1;
    }
    /**
     * Add a new notification.
     *
     * This will trigger the `changed` signal with an `added` event.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Notification option
     * @returns Notification unique id
     */
    notify(message, type, options) {
        const now = Date.now();
        const { progress, ...othersOptions } = options;
        const notification = Object.freeze({
            id: dist_index_js_.UUID.uuid4(),
            createdAt: now,
            modifiedAt: now,
            message,
            type,
            options: {
                // By default notification will be silent
                autoClose: 0,
                progress: typeof progress === 'number'
                    ? Math.min(Math.max(0, progress), 1)
                    : progress,
                ...othersOptions
            }
        });
        this._queue.unshift(notification);
        this._changed.emit({
            type: 'added',
            notification
        });
        return notification.id;
    }
    /**
     * Update an existing notification.
     *
     * If the notification does not exists this won't do anything.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    update(args) {
        const { id, message, actions, autoClose, data, progress, type } = args;
        const newProgress = typeof progress === 'number'
            ? Math.min(Math.max(0, progress), 1)
            : progress;
        const notificationIndex = this._queue.findIndex(n => n.id === id);
        if (notificationIndex > -1) {
            const oldNotification = this._queue[notificationIndex];
            // We need to create a new object as notification are frozen; i.e. cannot be edited
            const notification = Object.freeze({
                ...oldNotification,
                message: message !== null && message !== void 0 ? message : oldNotification.message,
                type: type !== null && type !== void 0 ? type : oldNotification.type,
                options: {
                    actions: actions !== null && actions !== void 0 ? actions : oldNotification.options.actions,
                    autoClose: autoClose !== null && autoClose !== void 0 ? autoClose : oldNotification.options.autoClose,
                    data: data !== null && data !== void 0 ? data : oldNotification.options.data,
                    progress: newProgress !== null && newProgress !== void 0 ? newProgress : oldNotification.options.progress
                },
                modifiedAt: Date.now()
            });
            this._queue.splice(notificationIndex, 1);
            this._queue.unshift(notification);
            this._changed.emit({
                type: 'updated',
                notification
            });
            return true;
        }
        return false;
    }
}
/**
 * Notification namespace
 */
var notification_Notification;
(function (Notification) {
    /**
     * The global notification manager.
     */
    Notification.manager = new NotificationManager();
    /**
     * Dismiss one notification (specified by its id) or all if no id provided
     *
     * @param id notification id
     */
    function dismiss(id) {
        Notification.manager.dismiss(id);
    }
    Notification.dismiss = dismiss;
    /**
     * Helper function to emit a notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function emit(message, type = 'default', options = {}) {
        return Notification.manager.notify(message, type, options);
    }
    Notification.emit = emit;
    /**
     * Helper function to emit an error notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function error(message, options = {}) {
        return Notification.manager.notify(message, 'error', options);
    }
    Notification.error = error;
    /**
     * Helper function to emit an info notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the info notification
     * @returns Notification unique id
     */
    function info(message, options = {}) {
        return Notification.manager.notify(message, 'info', options);
    }
    Notification.info = info;
    /**
     * Helper function to show an in-progress notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param promise Promise to wait for
     * @param options Options for the in-progress notification
     * @returns Notification unique id
     */
    function promise(promise, options) {
        var _a;
        const { pending, error, success } = options;
        const id = Notification.manager.notify(pending.message, 'in-progress', (_a = pending.options) !== null && _a !== void 0 ? _a : {});
        promise
            .then(result => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: success.message(result, (_a = success.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'success',
                ...success.options,
                data: (_c = (_b = success.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : result
            });
        })
            .catch(reason => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: error.message(reason, (_a = error.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'error',
                ...error.options,
                data: (_c = (_b = error.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : reason
            });
        });
        return id;
    }
    Notification.promise = promise;
    /**
     * Helper function to emit a success notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the success notification
     * @returns Notification unique id
     */
    function success(message, options = {}) {
        return Notification.manager.notify(message, 'success', options);
    }
    Notification.success = success;
    /**
     * Helper function to update a notification.
     *
     * If the notification does not exists, nothing will happen.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    function update(args) {
        return Notification.manager.update(args);
    }
    Notification.update = update;
    /**
     * Helper function to emit a warning notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the warning notification
     * @returns Notification unique id
     */
    function warning(message, options = {}) {
        return Notification.manager.notify(message, 'warning', options);
    }
    Notification.warning = warning;
})(notification_Notification || (notification_Notification = {}));
//# sourceMappingURL=notification.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/runningSessions.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * Half spacing between subitems in a status item, in pixels.
 */
const HALF_SPACING = 4;
/**
 * A pure functional component for rendering kernel and terminal sessions.
 *
 * @param props the props for the component.
 *
 * @returns a tsx component for the running sessions.
 */
function RunningSessionsComponent(props) {
    var _a, _b;
    const showKernels = (_a = props.showKernels) !== null && _a !== void 0 ? _a : true;
    const showTerminals = (_b = props.showTerminals) !== null && _b !== void 0 ? _b : props.terminals > 0;
    return (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { role: "button", tabIndex: 0, spacing: HALF_SPACING, onClick: props.handleClick, onKeyDown: props.handleKeyDown, style: { cursor: 'pointer' } },
        showTerminals ? (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { spacing: HALF_SPACING },
            react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { source: props.terminals }),
            react_index_js_default().createElement(index_js_.terminalIcon.react, { verticalAlign: "middle", stylesheet: "statusBar" }))) : null,
        showKernels ? (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { spacing: HALF_SPACING },
            react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { source: props.sessions }),
            react_index_js_default().createElement(index_js_.kernelIcon.react, { verticalAlign: "middle", stylesheet: "statusBar" }))) : null));
}
/**
 * A VDomRenderer for a RunningSessions status item.
 */
class runningSessions_RunningSessions extends index_js_.VDomRenderer {
    /**
     * Create a new RunningSessions widget.
     */
    constructor(opts) {
        super(new runningSessions_RunningSessions.Model());
        this._serviceManager = opts.serviceManager;
        this._handleClick = opts.onClick;
        this._handleKeyDown = opts.onKeyDown;
        this.translator = opts.translator || lib_index_js_.nullTranslator;
        this._showKernels = opts.showKernels;
        this._showTerminals = opts.showTerminals;
        this._trans = this.translator.load('jupyterlab');
        this._serviceManager.sessions.runningChanged.connect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.connect(this._onTerminalsRunningChanged, this);
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the running sessions widget.
     */
    render() {
        if (!this.model) {
            return null;
        }
        // TODO-TRANS: Should probably be handled differently.
        // This is more localizable friendly: "Terminals: %1 | Kernels: %2"
        // Generate a localized caption for the tooltip
        const caption = this._trans.__('%1 Terminals, %2 Kernel sessions', this.model.terminals, this.model.sessions);
        // Explicitly synchronize the title attribute with the Lumino widget's DOM
        // This ensures the tooltip displays correctly when hovering over the widget
        this.node.title = caption;
        return (react_index_js_default().createElement(RunningSessionsComponent, { sessions: this.model.sessions, terminals: this.model.terminals, handleClick: this._handleClick, handleKeyDown: this._handleKeyDown, showKernels: this._showKernels, showTerminals: this._showTerminals }));
    }
    /**
     * Dispose of the status item.
     */
    dispose() {
        super.dispose();
        this._serviceManager.sessions.runningChanged.disconnect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.disconnect(this._onTerminalsRunningChanged, this);
    }
    /**
     * Set the number of kernel sessions when the list changes.
     */
    _onSessionsRunningChanged(manager, sessions) {
        this.model.sessions = sessions.length;
    }
    /**
     * Set the number of terminal sessions when the list changes.
     */
    _onTerminalsRunningChanged(manager, terminals) {
        this.model.terminals = terminals.length;
    }
}
/**
 * A namespace for RunningSessions statics.
 */
(function (RunningSessions) {
    /**
     * A VDomModel for the RunningSessions status item.
     */
    class Model extends index_js_.VDomModel {
        constructor() {
            super(...arguments);
            this._terminals = 0;
            this._sessions = 0;
        }
        /**
         * The number of active kernel sessions.
         */
        get sessions() {
            return this._sessions;
        }
        set sessions(sessions) {
            const oldSessions = this._sessions;
            this._sessions = sessions;
            if (oldSessions !== this._sessions) {
                this.stateChanged.emit(void 0);
            }
        }
        /**
         * The number of active terminal sessions.
         */
        get terminals() {
            return this._terminals;
        }
        set terminals(terminals) {
            const oldTerminals = this._terminals;
            this._terminals = terminals;
            if (oldTerminals !== this._terminals) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    RunningSessions.Model = Model;
})(runningSessions_RunningSessions || (runningSessions_RunningSessions = {}));
//# sourceMappingURL=runningSessions.js.map
// EXTERNAL MODULE: ../node_modules/sanitize-html/index.js
var sanitize_html = __webpack_require__(74004);
var sanitize_html_default = /*#__PURE__*/__webpack_require__.n(sanitize_html);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/sanitizer.js
/* eslint-disable camelcase */
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Helper class that contains regular expressions for inline CSS style validation.
 *
 * Which properties (and values) to allow is largely based on the Google Caja project:
 *   https://github.com/google/caja
 *
 * The regular expressions are largly based on the syntax definition found at
 * https://developer.mozilla.org/en-US/docs/Web/CSS.
 */
class CssProp {
    static reg(r) {
        return new RegExp('^' + r + '$', 'i');
    }
}
/*
 * Numeric base expressions used to help build more complex regular expressions
 */
CssProp.N = {
    integer: `[+-]?[0-9]+`,
    integer_pos: `[+]?[0-9]+`,
    integer_zero_ff: `([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])`,
    integer_non_zero: `[+-]?([1-9][0-9]*)`,
    integer_pos_non_zero: `[+]?([1-9][0-9]*)`,
    number: `[+-]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_pos: `[+]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_zero_hundred: `[+]?(([0-9]|[1-9][0-9])([.][0-9]+)?|100)`,
    number_zero_one: `[+]?(1([.][0]+)?|0?([.][0-9]+)?)`
};
/*
 * Base expressions of common CSS syntax elements
 */
CssProp._B = {
    angle: `(${CssProp.N.number}(deg|rad|grad|turn)|0)`,
    frequency: `${CssProp.N.number}(Hz|kHz)`,
    ident: String.raw `-?([_a-z]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])([_a-z0-9-]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*`,
    len_or_perc: `(0|${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc|%))`,
    length: `(${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    length_pos: `(${CssProp.N.number_pos}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    percentage: `${CssProp.N.number}%`,
    percentage_pos: `${CssProp.N.number_pos}%`,
    percentage_zero_hundred: `${CssProp.N.number_zero_hundred}%`,
    string: String.raw `(\"([^\n\r\f\\"]|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\")|(\'([^\n\r\f\\']|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\')`,
    time: `${CssProp.N.number}(s|ms)`,
    url: `url\\(.*?\\)`,
    z_index: `[+-]?[0-9]{1,7}`
};
/*
 * Extended base expressions of common CSS syntax elements
 */
CssProp._B1 = {
    flex: `(${CssProp.N.number}|${CssProp._B.len_or_perc}|none|auto)\\s*((${CssProp.N.number}|${CssProp._B.len_or_perc}|auto)\\s*){0,2}`,
    fixed_breadth: `${CssProp._B.len_or_perc}`,
    grid_line: `auto|${CssProp._B.ident}|(${CssProp.N.integer_non_zero}(\\s+${CssProp._B.ident})?)|(span\\s+(${CssProp.N.integer_pos_non_zero}|${CssProp._B.ident}))`,
    line_names: String.raw `\[\s*${CssProp._B.ident}(\s+${CssProp._B.ident})*\s*\]`
};
CssProp._B2 = {
    inflexible_breadth: `${CssProp._B.len_or_perc}|auto|min-content|max-content`,
    track_breadth: `${CssProp._B.len_or_perc}|${CssProp._B1.flex}|auto|min-content|max-content`
};
CssProp._B3 = {
    fixed_size: `${CssProp._B1.fixed_breadth}|minmax\\(\\s*${CssProp._B2.inflexible_breadth}\\s*,\\s*${CssProp._B1.fixed_breadth}\\s*\\)|minmax\\(\\s*${CssProp._B1.fixed_breadth}\\s*,\\s*${CssProp._B2.track_breadth}\\s*\\)`,
    track_size: `${CssProp._B2.track_breadth}|minmax\\(\\s*${CssProp._B2.inflexible_breadth}\\s*,\\s*${CssProp._B2.track_breadth}\\s*\\)|fit-content\\(\\s*(${CssProp._B.len_or_perc}\\s*)*\\)`
};
CssProp._B4 = {
    name_repeat: `repeat\\(\\s*(${CssProp.N.integer_pos_non_zero}|auto-fill)\\s*,\\s*(${CssProp._B1.line_names})+\\s*\\)`,
    auto_repeat: `repeat\\(\\s*(auto-fill|auto-fit)\\s*,\\s*((${CssProp._B1.line_names}\\s+)?${CssProp._B3.fixed_size}\\s*)+(${CssProp._B1.line_names})?\\s*\\)`,
    fixed_repeat: `repeat\\(\\s*(${CssProp.N.integer_pos_non_zero})\\s*,\\s*((${CssProp._B1.line_names}\\s+)?${CssProp._B3.fixed_size}\\s*)+(${CssProp._B1.line_names})?\\s*\\)`
};
CssProp._B5 = {
    auto_track_list: `(${CssProp._B1.line_names}\\s*)?(${CssProp._B3.fixed_size}|${CssProp._B4.fixed_repeat})*(${CssProp._B1.line_names}\\s*)?${CssProp._B4.auto_repeat}(${CssProp._B1.line_names}\\s*)?(${CssProp._B3.fixed_size}|${CssProp._B4.fixed_repeat})*(${CssProp._B1.line_names}\\s*)?`,
    explicit_track_list: `(${CssProp._B1.line_names}\\s*)?(${CssProp._B3.track_size})+(${CssProp._B1.line_names}\\s*)?`,
    track_list: `(${CssProp._B1.line_names}\\s*)?(${CssProp._B3.track_size}|${CssProp._B4.name_repeat})+(${CssProp._B1.line_names}\\s*)?`
};
CssProp._B6 = {
    grid_template_rows: `none|${CssProp._B5.track_list}|${CssProp._B5.auto_track_list}|subgrid\\s*(${CssProp._B1.line_names})?`,
    grid_template_columns: `none|${CssProp._B5.track_list}|${CssProp._B5.auto_track_list}|subgrid\\s*(${CssProp._B1.line_names})?`
};
CssProp.B = {
    ...CssProp._B,
    ...CssProp._B1,
    ...CssProp._B2,
    ...CssProp._B3,
    ...CssProp._B4,
    ...CssProp._B5,
    ...CssProp._B6
};
/*
 * Atomic (i.e. not dependent on other regular expressions) sub RegEx segments
 */
CssProp.A = {
    absolute_size: `xx-small|x-small|small|medium|large|x-large|xx-large`,
    attachment: `scroll|fixed|local`,
    bg_origin: `border-box|padding-box|content-box`,
    border_style: `none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset`,
    box: `border-box|padding-box|content-box`,
    display_inside: `auto|block|table|flex|grid`,
    display_outside: `block-level|inline-level|none|table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption`,
    ending_shape: `circle|ellipse`,
    generic_family: `serif|sans-serif|cursive|fantasy|monospace`,
    generic_voice: `male|female|child`,
    relative_size: `smaller|larger`,
    repeat_style: `repeat-x|repeat-y|((?:repeat|space|round|no-repeat)(?:\\s*(?:repeat|space|round|no-repeat))?)`,
    side_or_corner: `(left|right)?\\s*(top|bottom)?`,
    single_animation_direction: `normal|reverse|alternate|alternate-reverse`,
    single_animation_fill_mode: `none|forwards|backwards|both`,
    single_animation_play_state: `running|paused`
};
/*
 * Color definition sub expressions
 */
CssProp._COLOR = {
    hex: `\\#(0x)?[0-9a-f]+`,
    name: `aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|transparent|violet|wheat|white|whitesmoke|yellow|yellowgreen`,
    rgb: String.raw `rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)`,
    rgba: String.raw `rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred})\s*\)`
};
/*
 * Compound (i.e. dependent on other (sub) regular expressions) sub RegEx segments
 */
CssProp._C = {
    alpha: `${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred}`,
    alphavalue: CssProp.N.number_zero_one,
    bg_position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    bg_size: `(${CssProp.B.length_pos}|${CssProp.B.percentage}|auto){1,2}|cover|contain`,
    border_width: `thin|medium|thick|${CssProp.B.length}`,
    bottom: `${CssProp.B.length}|auto`,
    color: `${CssProp._COLOR.hex}|${CssProp._COLOR.rgb}|${CssProp._COLOR.rgba}|${CssProp._COLOR.name}`,
    color_stop_length: `(${CssProp.B.len_or_perc}\\s*){1,2}`,
    linear_color_hint: `${CssProp.B.len_or_perc}`,
    family_name: `${CssProp.B.string}|(${CssProp.B.ident}\\s*)+`,
    image_decl: CssProp.B.url,
    left: `${CssProp.B.length}|auto`,
    loose_quotable_words: `(${CssProp.B.ident})+`,
    margin_width: `${CssProp.B.len_or_perc}|auto`,
    padding_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    page_url: CssProp.B.url,
    position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    right: `${CssProp.B.length}|auto`,
    shadow: '',
    size: `closest-side|farthest-side|closest-corner|farthest-corner|${CssProp.B.length}|(${CssProp.B.len_or_perc})\\s+(${CssProp.B.len_or_perc})`,
    top: `${CssProp.B.length}|auto`
};
CssProp._C1 = {
    image_list: `image\\(\\s*(${CssProp.B.url})*\\s*(${CssProp.B.url}|${CssProp._C.color})\\s*\\)`,
    linear_color_stop: `(${CssProp._C.color})(\\s*${CssProp._C.color_stop_length})?`,
    shadow: `((${CssProp._C.color})\\s+((${CssProp.B.length})\\s*){2,4}(\s+inset)?)|((inset\\s+)?((${CssProp.B.length})\\s*){2,4}\\s*(${CssProp._C.color})?)`
};
CssProp._C2 = {
    color_stop_list: `((${CssProp._C1.linear_color_stop})(\\s*(${CssProp._C.linear_color_hint}))?\\s*,\\s*)+(${CssProp._C1.linear_color_stop})`,
    shape: `rect\\(\\s*(${CssProp._C.top})\\s*,\\s*(${CssProp._C.right})\\s*,\\s*(${CssProp._C.bottom})\\s*,\\s*(${CssProp._C.left})\\s*\\)`
};
CssProp._C3 = {
    linear_gradient: `linear-gradient\\((((${CssProp.B.angle})|to\\s+(${CssProp.A.side_or_corner}))\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`,
    radial_gradient: `radial-gradient\\(((((${CssProp.A.ending_shape})|(${CssProp._C.size}))\\s*)*\\s*(at\\s+${CssProp._C.position})?\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`
};
CssProp._C4 = {
    image: `${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list}`,
    bg_image: `(${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list})|none`
};
CssProp.C = {
    ...CssProp._C,
    ...CssProp._C1,
    ...CssProp._C2,
    ...CssProp._C3,
    ...CssProp._C4
};
/*
 * Property value regular expressions not dependent on other sub expressions
 */
CssProp.AP = {
    baseline_position: `baseline|first baseline|last baseline`,
    border_collapse: `collapse|separate`,
    box: `normal|none|contents`,
    box_sizing: `content-box|padding-box|border-box`,
    caption_side: `top|bottom`,
    clear: `none|left|right|both`,
    content_position: `start|end|center|flex-start|flex-end`,
    content_distribution: `stretch|space-between|space-around|space-evenly`,
    direction: `ltr|rtl`,
    empty_cells: `show|hide`,
    flex_direction: `row|row-reverse|column|column-reverse`,
    flex_wrap: `nowrap|wrap|wrap-reverse`,
    float: `left|right|none`,
    font_stretch: `normal|wider|narrower|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded`,
    font_style: `normal|italic|oblique`,
    font_variant: `normal|small-caps`,
    font_weight: `normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900`,
    list_style_position: `inside|outside`,
    gap: `normal`,
    grid_auto_flow: `row|column|dense|row dense|column dense`,
    justify_content: `start|end|center|stretch|space-between|space-around|space-evenly`,
    justify_items: `start|end|center|stretch`,
    justify_self: `auto|start|end|center|stretch`,
    list_style_type: `disc|circle|square|decimal|decimal-leading-zero|lower-roman|upper-roman|lower-greek|lower-latin|upper-latin|armenian|georgian|lower-alpha|upper-alpha|none`,
    overflow: `visible|hidden|scroll|auto`,
    overflow_position: `unsafe|safe`,
    overflow_wrap: `normal|break-word`,
    overflow_x: `visible|hidden|scroll|auto|no-display|no-content`,
    page_break_after: `auto|always|avoid|left|right`,
    page_break_before: `auto|always|avoid|left|right`,
    page_break_inside: `avoid|auto`,
    place_content: `(center|start|end|space-between|space-around|space-evenly|stretch){1,2}`,
    place_items: `(center|start|end|baseline|stretch){1,2}`,
    place_self: `(center|start|end|baseline|stretch){1,2}`,
    position: `static|relative|absolute`,
    resize: `none|both|horizontal|vertical`,
    speak: `normal|none|spell-out`,
    self_position: `center|start|end|self-start|self-end|flex-start|flex-end`,
    speak_header: `once|always`,
    speak_numeral: `digits|continuous`,
    speak_punctuation: `code|none`,
    table_layout: `auto|fixed`,
    text_align: `left|right|center|justify`,
    text_decoration: `none|((underline|overline|line-through|blink)\\s*)+`,
    text_transform: `capitalize|uppercase|lowercase|none`,
    text_wrap: `normal|unrestricted|none|suppress`,
    unicode_bidi: `normal|embed|bidi-override`,
    visibility: `visible|hidden|collapse`,
    white_space: `normal|pre|nowrap|pre-wrap|pre-line`,
    word_break: `normal|keep-all|break-all`
};
/*
 * Compound propertiy value regular expressions (i.e. dependent on other sub expressions)
 */
CssProp._CP = {
    align_content: `normal|${CssProp.AP.baseline_position}|${CssProp.AP.content_distribution}|${CssProp.AP.overflow_position}|${CssProp.AP.content_position}`,
    align_items: `normal|stretch|${CssProp.AP.baseline_position}|(${CssProp.AP.overflow_position})?\\s*${CssProp.AP.self_position}|anchor-center`,
    align_self: `auto|normal|stretch|${CssProp.AP.baseline_position}|(${CssProp.AP.overflow_position})?\\s*${CssProp.AP.self_position}|anchor-center`,
    background_attachment: `${CssProp.A.attachment}(,\\s*${CssProp.A.attachment})*`,
    background_color: CssProp.C.color,
    background_origin: `${CssProp.A.box}(,\\s*${CssProp.A.box})*`,
    background_repeat: `${CssProp.A.repeat_style}(,\\s*${CssProp.A.repeat_style})*`,
    border: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_radius: `((${CssProp.B.len_or_perc})\\s*){1,4}(\\/\\s*((${CssProp.B.len_or_perc})\\s*){1,4})?`,
    border_spacing: `${CssProp.B.length}\\s*(${CssProp.B.length})?`,
    border_top_color: CssProp.C.color,
    border_top_style: CssProp.A.border_style,
    border_width: `((${CssProp.C.border_width})\\s*){1,4}`,
    color: CssProp.C.color,
    cursor: `(${CssProp.B.url}(\\s*,\\s*)?)*(auto|crosshair|default|pointer|move|e-resize|ne-resize|nw-resize|n-resize|se-resize|sw-resize|s-resize|w-resize|text|wait|help|progress|all-scroll|col-resize|hand|no-drop|not-allowed|row-resize|vertical-text)`,
    display: `inline|block|list-item|run-in|inline-list-item|inline-block|table|inline-table|table-cell|table-caption|flex|inline-flex|grid|inline-grid|${CssProp.A.display_inside}|${CssProp.A.display_outside}|inherit|inline-box|inline-stack`,
    display_outside: CssProp.A.display_outside,
    elevation: `${CssProp.B.angle}|below|level|above|higher|lower`,
    font_family: `(${CssProp.C.family_name}|${CssProp.A.generic_family})(,\\s*(${CssProp.C.family_name}|${CssProp.A.generic_family}))*`,
    height: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    letter_spacing: `normal|${CssProp.B.length}`,
    list_style_image: `${CssProp.C.image}|none`,
    margin_right: CssProp.C.margin_width,
    max_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    min_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    opacity: CssProp.C.alphavalue,
    outline_color: `${CssProp.C.color}|invert`,
    outline_width: CssProp.C.border_width,
    padding: `((${CssProp.C.padding_width})\\s*){1,4}`,
    padding_top: CssProp.C.padding_width,
    pitch_range: CssProp.N.number,
    right: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    stress: CssProp.N.number,
    text_indent: `${CssProp.B.length}|${CssProp.B.percentage}`,
    text_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    volume: `${CssProp.N.number_pos}|${CssProp.B.percentage_pos}|silent|x-soft|soft|medium|loud|x-loud`,
    word_wrap: CssProp.AP.overflow_wrap,
    zoom: `normal|${CssProp.N.number_pos}|${CssProp.B.percentage_pos}`,
    backface_visibility: CssProp.AP.visibility,
    background_clip: `${CssProp.A.box}(,\\s*(${CssProp.A.box}))*`,
    background_position: `${CssProp.C.bg_position}(,\\s*(${CssProp.C.bg_position}))*`,
    border_bottom_color: CssProp.C.color,
    border_bottom_style: CssProp.A.border_style,
    border_color: `((${CssProp.C.color})\\s*){1,4}`,
    border_left_color: CssProp.C.color,
    border_right_color: CssProp.C.color,
    border_style: `((${CssProp.A.border_style})\\s*){1,4}`,
    border_top_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_top_width: CssProp.C.border_width,
    box_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    clip: `${CssProp.C.shape}|auto`,
    display_inside: CssProp.A.display_inside,
    font_size: `${CssProp.A.absolute_size}|${CssProp.A.relative_size}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    line_height: `normal|${CssProp.N.number_pos}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    margin_left: CssProp.C.margin_width,
    max_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    outline_style: CssProp.A.border_style,
    padding_bottom: CssProp.C.padding_width,
    padding_right: CssProp.C.padding_width,
    perspective: `none|${CssProp.B.length}`,
    richness: CssProp.N.number,
    text_overflow: `((clip|ellipsis|${CssProp.B.string})\\s*){1,2}`,
    top: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    z_index: `auto|${CssProp.B.z_index}`,
    // Simplified background
    background: `(((${CssProp.C.bg_position}\\s*(\\/\\s*${CssProp.C.bg_size})?)|(${CssProp.A.repeat_style})|(${CssProp.A.attachment})|(${CssProp.A.bg_origin})|(${CssProp.C.bg_image})|(${CssProp.C.color}))\\s*)+`,
    background_size: `${CssProp.C.bg_size}(,\\s*${CssProp.C.bg_size})*`,
    border_bottom_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_bottom_width: CssProp.C.border_width,
    border_left_style: CssProp.A.border_style,
    border_right_style: CssProp.A.border_style,
    border_top: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    bottom: `${CssProp.B.len_or_perc}|auto`,
    list_style: `((${CssProp.AP.list_style_type}|${CssProp.AP.list_style_position}|${CssProp.C.image}|none})\\s*){1,3}`,
    margin_top: CssProp.C.margin_width,
    outline: `((${CssProp.C.color}|invert|${CssProp.A.border_style}|${CssProp.C.border_width})\\s*){1,3}`,
    overflow_y: CssProp.AP.overflow_x,
    pitch: `${CssProp.B.frequency}|x-low|low|medium|high|x-high`,
    vertical_align: `baseline|sub|super|top|text-top|middle|bottom|text-bottom|${CssProp.B.len_or_perc}`,
    word_spacing: `normal|${CssProp.B.length}`,
    background_image: `${CssProp.C.bg_image}(,\\s*${CssProp.C.bg_image})*`,
    border_bottom_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_left_width: CssProp.C.border_width,
    border_right_width: CssProp.C.border_width,
    left: `${CssProp.B.len_or_perc}|auto`,
    margin_bottom: CssProp.C.margin_width,
    pause_after: `${CssProp.B.time}|${CssProp.B.percentage}`,
    speech_rate: `${CssProp.N.number}|x-slow|slow|medium|fast|x-fast|faster|slower`,
    transition_duration: `${CssProp.B.time}(,\\s*${CssProp.B.time})*`,
    border_bottom: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_right: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    margin: `((${CssProp.C.margin_width})\\s*){1,4}`,
    padding_left: CssProp.C.padding_width,
    border_left: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    quotes: `(${CssProp.B.string}\\s*${CssProp.B.string})+|none`,
    border_top_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    min_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    // Add flexbox and grid properties
    flex_basis: `${CssProp.B.len_or_perc}|auto|content|max-content|min-content|fit-content\\(\\s*(${CssProp.B.len_or_perc}\\s*)*\\)`, // simplified no <calc-size()> and <anchor-size()>
    flex_grow: CssProp.N.number_pos,
    flex_shrink: CssProp.N.number_pos,
    grid: `(${CssProp.B.string}|none|subgrid)\\s*(\\/\\s*(${CssProp.B.string}|none|subgrid))?`,
    grid_area: `${CssProp.B.ident}|auto|(${CssProp.N.integer}\\s*\\/\\s*${CssProp.N.integer}\\s*\\/\\s*${CssProp.N.integer}\\s*\\/\\s*${CssProp.N.integer})`,
    grid_auto_columns: `(${CssProp.B.track_size})+`,
    grid_auto_rows: `(${CssProp.B.track_size})+`,
    grid_column: `${CssProp.B.grid_line}(\\s*\\/\\s*${CssProp.B.grid_line})?`,
    grid_column_start: `${CssProp.B.grid_line}`,
    grid_column_end: `${CssProp.B.grid_line}`,
    grid_column_gap: `${CssProp.B.len_or_perc}|normal`,
    grid_gap: `(${CssProp.B.len_or_perc}|normal)(\\s*(${CssProp.B.len_or_perc}|normal))?`,
    grid_row: `${CssProp.B.grid_line}(\\s*\\/\\s*${CssProp.B.grid_line})?`,
    grid_row_start: `${CssProp.B.grid_line}`,
    grid_row_end: `${CssProp.B.grid_line}`,
    grid_row_gap: `${CssProp.B.len_or_perc}|normal`,
    grid_template: `none|(${CssProp.B.grid_template_rows}\\s*\\/\\s*${CssProp.B.grid_template_columns})|(${CssProp.B.line_names}\\s*)?(${CssProp.B.string}\\s*${CssProp.B.track_size}\\s*(${CssProp.B.line_names}\\s*)?)+\\s*(\\/\\s*${CssProp.B.explicit_track_list})?`,
    grid_template_areas: `none|(${CssProp.B.string})+`,
    grid_template_columns: `${CssProp.B.grid_template_columns}`,
    grid_template_rows: `${CssProp.B.grid_template_rows}`,
    row_gap: `${CssProp.B.len_or_perc}|normal`,
    column_gap: `${CssProp.B.len_or_perc}|normal`,
    gap: `(${CssProp.B.len_or_perc}|normal)(\\s*(${CssProp.B.len_or_perc}|normal))?`,
    order: CssProp.N.integer
};
CssProp._CP1 = {
    font: `(((((${CssProp.AP.font_style}|${CssProp.AP.font_variant}|${CssProp.AP.font_weight})\\s*){1,3})?\\s*(${CssProp._CP.font_size})\\s*(\\/\\s*(${CssProp._CP.line_height}))?\\s+(${CssProp._CP.font_family}))|caption|icon|menu|message-box|small-caption|status-bar)`
};
CssProp.CP = { ...CssProp._CP, ...CssProp._CP1 };
// CSS Property value validation regular expressions for use with sanitize-html
CssProp.BORDER_COLLAPSE = CssProp.reg(CssProp.AP.border_collapse);
CssProp.BOX = CssProp.reg(CssProp.AP.box);
CssProp.BOX_SIZING = CssProp.reg(CssProp.AP.box_sizing);
CssProp.CAPTION_SIDE = CssProp.reg(CssProp.AP.caption_side);
CssProp.CLEAR = CssProp.reg(CssProp.AP.clear);
CssProp.DIRECTION = CssProp.reg(CssProp.AP.direction);
CssProp.EMPTY_CELLS = CssProp.reg(CssProp.AP.empty_cells);
CssProp.FLOAT = CssProp.reg(CssProp.AP.float);
CssProp.FONT_STRETCH = CssProp.reg(CssProp.AP.font_stretch);
CssProp.FONT_STYLE = CssProp.reg(CssProp.AP.font_style);
CssProp.FONT_VARIANT = CssProp.reg(CssProp.AP.font_variant);
CssProp.FONT_WEIGHT = CssProp.reg(CssProp.AP.font_weight);
CssProp.LIST_STYLE_POSITION = CssProp.reg(CssProp.AP.list_style_position);
CssProp.LIST_STYLE_TYPE = CssProp.reg(CssProp.AP.list_style_type);
CssProp.OVERFLOW = CssProp.reg(CssProp.AP.overflow);
CssProp.OVERFLOW_WRAP = CssProp.reg(CssProp.AP.overflow_wrap);
CssProp.OVERFLOW_X = CssProp.reg(CssProp.AP.overflow_x);
CssProp.PAGE_BREAK_AFTER = CssProp.reg(CssProp.AP.page_break_after);
CssProp.PAGE_BREAK_BEFORE = CssProp.reg(CssProp.AP.page_break_before);
CssProp.PAGE_BREAK_INSIDE = CssProp.reg(CssProp.AP.page_break_inside);
CssProp.POSITION = CssProp.reg(CssProp.AP.position);
CssProp.RESIZE = CssProp.reg(CssProp.AP.resize);
CssProp.SPEAK = CssProp.reg(CssProp.AP.speak);
CssProp.SPEAK_HEADER = CssProp.reg(CssProp.AP.speak_header);
CssProp.SPEAK_NUMERAL = CssProp.reg(CssProp.AP.speak_numeral);
CssProp.SPEAK_PUNCTUATION = CssProp.reg(CssProp.AP.speak_punctuation);
CssProp.TABLE_LAYOUT = CssProp.reg(CssProp.AP.table_layout);
CssProp.TEXT_ALIGN = CssProp.reg(CssProp.AP.text_align);
CssProp.TEXT_DECORATION = CssProp.reg(CssProp.AP.text_decoration);
CssProp.TEXT_TRANSFORM = CssProp.reg(CssProp.AP.text_transform);
CssProp.TEXT_WRAP = CssProp.reg(CssProp.AP.text_wrap);
CssProp.UNICODE_BIDI = CssProp.reg(CssProp.AP.unicode_bidi);
CssProp.VISIBILITY = CssProp.reg(CssProp.AP.visibility);
CssProp.WHITE_SPACE = CssProp.reg(CssProp.AP.white_space);
CssProp.WORD_BREAK = CssProp.reg(CssProp.AP.word_break);
CssProp.BACKGROUND_ATTACHMENT = CssProp.reg(CssProp.CP.background_attachment);
CssProp.BACKGROUND_COLOR = CssProp.reg(CssProp.CP.background_color);
CssProp.BACKGROUND_ORIGIN = CssProp.reg(CssProp.CP.background_origin);
CssProp.BACKGROUND_REPEAT = CssProp.reg(CssProp.CP.background_repeat);
CssProp.BORDER = CssProp.reg(CssProp.CP.border);
CssProp.BORDER_RADIUS = CssProp.reg(CssProp.CP.border_radius);
CssProp.BORDER_SPACING = CssProp.reg(CssProp.CP.border_spacing);
CssProp.BORDER_TOP_COLOR = CssProp.reg(CssProp.CP.border_top_color);
CssProp.BORDER_TOP_STYLE = CssProp.reg(CssProp.CP.border_top_style);
CssProp.BORDER_WIDTH = CssProp.reg(CssProp.CP.border_width);
CssProp.COLOR = CssProp.reg(CssProp.CP.color);
CssProp.CURSOR = CssProp.reg(CssProp.CP.cursor);
CssProp.DISPLAY = CssProp.reg(CssProp.CP.display);
CssProp.DISPLAY_OUTSIDE = CssProp.reg(CssProp.CP.display_outside);
CssProp.ELEVATION = CssProp.reg(CssProp.CP.elevation);
CssProp.FONT_FAMILY = CssProp.reg(CssProp.CP.font_family);
CssProp.HEIGHT = CssProp.reg(CssProp.CP.height);
CssProp.LETTER_SPACING = CssProp.reg(CssProp.CP.letter_spacing);
CssProp.LIST_STYLE_IMAGE = CssProp.reg(CssProp.CP.list_style_image);
CssProp.MARGIN_RIGHT = CssProp.reg(CssProp.CP.margin_right);
CssProp.MAX_HEIGHT = CssProp.reg(CssProp.CP.max_height);
CssProp.MIN_HEIGHT = CssProp.reg(CssProp.CP.min_height);
CssProp.OPACITY = CssProp.reg(CssProp.CP.opacity);
CssProp.OUTLINE_COLOR = CssProp.reg(CssProp.CP.outline_color);
CssProp.OUTLINE_WIDTH = CssProp.reg(CssProp.CP.outline_width);
CssProp.PADDING = CssProp.reg(CssProp.CP.padding);
CssProp.PADDING_TOP = CssProp.reg(CssProp.CP.padding_top);
CssProp.PITCH_RANGE = CssProp.reg(CssProp.CP.pitch_range);
CssProp.RIGHT = CssProp.reg(CssProp.CP.right);
CssProp.STRESS = CssProp.reg(CssProp.CP.stress);
CssProp.TEXT_INDENT = CssProp.reg(CssProp.CP.text_indent);
CssProp.TEXT_SHADOW = CssProp.reg(CssProp.CP.text_shadow);
CssProp.VOLUME = CssProp.reg(CssProp.CP.volume);
CssProp.WORD_WRAP = CssProp.reg(CssProp.CP.word_wrap);
CssProp.ZOOM = CssProp.reg(CssProp.CP.zoom);
CssProp.BACKFACE_VISIBILITY = CssProp.reg(CssProp.CP.backface_visibility);
CssProp.BACKGROUND_CLIP = CssProp.reg(CssProp.CP.background_clip);
CssProp.BACKGROUND_POSITION = CssProp.reg(CssProp.CP.background_position);
CssProp.BORDER_BOTTOM_COLOR = CssProp.reg(CssProp.CP.border_bottom_color);
CssProp.BORDER_BOTTOM_STYLE = CssProp.reg(CssProp.CP.border_bottom_style);
CssProp.BORDER_COLOR = CssProp.reg(CssProp.CP.border_color);
CssProp.BORDER_LEFT_COLOR = CssProp.reg(CssProp.CP.border_left_color);
CssProp.BORDER_RIGHT_COLOR = CssProp.reg(CssProp.CP.border_right_color);
CssProp.BORDER_STYLE = CssProp.reg(CssProp.CP.border_style);
CssProp.BORDER_TOP_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_top_left_radius);
CssProp.BORDER_TOP_WIDTH = CssProp.reg(CssProp.CP.border_top_width);
CssProp.BOX_SHADOW = CssProp.reg(CssProp.CP.box_shadow);
CssProp.CLIP = CssProp.reg(CssProp.CP.clip);
CssProp.DISPLAY_INSIDE = CssProp.reg(CssProp.CP.display_inside);
CssProp.FONT_SIZE = CssProp.reg(CssProp.CP.font_size);
CssProp.LINE_HEIGHT = CssProp.reg(CssProp.CP.line_height);
CssProp.MARGIN_LEFT = CssProp.reg(CssProp.CP.margin_left);
CssProp.MAX_WIDTH = CssProp.reg(CssProp.CP.max_width);
CssProp.OUTLINE_STYLE = CssProp.reg(CssProp.CP.outline_style);
CssProp.PADDING_BOTTOM = CssProp.reg(CssProp.CP.padding_bottom);
CssProp.PADDING_RIGHT = CssProp.reg(CssProp.CP.padding_right);
CssProp.PERSPECTIVE = CssProp.reg(CssProp.CP.perspective);
CssProp.RICHNESS = CssProp.reg(CssProp.CP.richness);
CssProp.TEXT_OVERFLOW = CssProp.reg(CssProp.CP.text_overflow);
CssProp.TOP = CssProp.reg(CssProp.CP.top);
CssProp.WIDTH = CssProp.reg(CssProp.CP.width);
CssProp.Z_INDEX = CssProp.reg(CssProp.CP.z_index);
CssProp.BACKGROUND = CssProp.reg(CssProp.CP.background);
CssProp.BACKGROUND_SIZE = CssProp.reg(CssProp.CP.background_size);
CssProp.BORDER_BOTTOM_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_left_radius);
CssProp.BORDER_BOTTOM_WIDTH = CssProp.reg(CssProp.CP.border_bottom_width);
CssProp.BORDER_LEFT_STYLE = CssProp.reg(CssProp.CP.border_left_style);
CssProp.BORDER_RIGHT_STYLE = CssProp.reg(CssProp.CP.border_right_style);
CssProp.BORDER_TOP = CssProp.reg(CssProp.CP.border_top);
CssProp.BOTTOM = CssProp.reg(CssProp.CP.bottom);
CssProp.LIST_STYLE = CssProp.reg(CssProp.CP.list_style);
CssProp.MARGIN_TOP = CssProp.reg(CssProp.CP.margin_top);
CssProp.OUTLINE = CssProp.reg(CssProp.CP.outline);
CssProp.OVERFLOW_Y = CssProp.reg(CssProp.CP.overflow_y);
CssProp.PITCH = CssProp.reg(CssProp.CP.pitch);
CssProp.VERTICAL_ALIGN = CssProp.reg(CssProp.CP.vertical_align);
CssProp.WORD_SPACING = CssProp.reg(CssProp.CP.word_spacing);
CssProp.BACKGROUND_IMAGE = CssProp.reg(CssProp.CP.background_image);
CssProp.BORDER_BOTTOM_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_right_radius);
CssProp.BORDER_LEFT_WIDTH = CssProp.reg(CssProp.CP.border_left_width);
CssProp.BORDER_RIGHT_WIDTH = CssProp.reg(CssProp.CP.border_right_width);
CssProp.LEFT = CssProp.reg(CssProp.CP.left);
CssProp.MARGIN_BOTTOM = CssProp.reg(CssProp.CP.margin_bottom);
CssProp.PAUSE_AFTER = CssProp.reg(CssProp.CP.pause_after);
CssProp.SPEECH_RATE = CssProp.reg(CssProp.CP.speech_rate);
CssProp.TRANSITION_DURATION = CssProp.reg(CssProp.CP.transition_duration);
CssProp.BORDER_BOTTOM = CssProp.reg(CssProp.CP.border_bottom);
CssProp.BORDER_RIGHT = CssProp.reg(CssProp.CP.border_right);
CssProp.MARGIN = CssProp.reg(CssProp.CP.margin);
CssProp.PADDING_LEFT = CssProp.reg(CssProp.CP.padding_left);
CssProp.BORDER_LEFT = CssProp.reg(CssProp.CP.border_left);
CssProp.FONT = CssProp.reg(CssProp.CP.font);
CssProp.QUOTES = CssProp.reg(CssProp.CP.quotes);
CssProp.BORDER_TOP_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_top_right_radius);
CssProp.MIN_WIDTH = CssProp.reg(CssProp.CP.min_width);
// Flexbox properties
CssProp.ALIGN_CONTENT = CssProp.reg(CssProp.CP.align_content);
CssProp.ALIGN_ITEMS = CssProp.reg(CssProp.CP.align_items);
CssProp.ALIGN_SELF = CssProp.reg(CssProp.CP.align_self);
CssProp.FLEX = CssProp.reg(CssProp.B.flex);
CssProp.FLEX_BASIS = CssProp.reg(CssProp.CP.flex_basis);
CssProp.FLEX_DIRECTION = CssProp.reg(CssProp.AP.flex_direction);
CssProp.FLEX_GROW = CssProp.reg(CssProp.CP.flex_grow);
CssProp.FLEX_SHRINK = CssProp.reg(CssProp.CP.flex_shrink);
CssProp.FLEX_WRAP = CssProp.reg(CssProp.AP.flex_wrap);
CssProp.JUSTIFY_CONTENT = CssProp.reg(CssProp.AP.justify_content);
CssProp.JUSTIFY_ITEMS = CssProp.reg(CssProp.AP.justify_items);
CssProp.JUSTIFY_SELF = CssProp.reg(CssProp.AP.justify_self);
CssProp.ORDER = CssProp.reg(CssProp.CP.order);
// Grid properties
CssProp.GRID = CssProp.reg(CssProp.CP.grid);
CssProp.GRID_AREA = CssProp.reg(CssProp.CP.grid_area);
CssProp.GRID_AUTO_COLUMNS = CssProp.reg(CssProp.CP.grid_auto_columns);
CssProp.GRID_AUTO_FLOW = CssProp.reg(CssProp.AP.grid_auto_flow);
CssProp.GRID_AUTO_ROWS = CssProp.reg(CssProp.CP.grid_auto_rows);
CssProp.GRID_COLUMN = CssProp.reg(CssProp.CP.grid_column);
CssProp.GRID_COLUMN_END = CssProp.reg(CssProp.CP.grid_column_end);
CssProp.GRID_COLUMN_GAP = CssProp.reg(CssProp.CP.grid_column_gap);
CssProp.GRID_COLUMN_START = CssProp.reg(CssProp.CP.grid_column_start);
CssProp.GRID_GAP = CssProp.reg(CssProp.CP.grid_gap);
CssProp.GRID_ROW = CssProp.reg(CssProp.CP.grid_row);
CssProp.GRID_ROW_END = CssProp.reg(CssProp.CP.grid_row_end);
CssProp.GRID_ROW_GAP = CssProp.reg(CssProp.CP.grid_row_gap);
CssProp.GRID_ROW_START = CssProp.reg(CssProp.CP.grid_row_start);
CssProp.GRID_TEMPLATE = CssProp.reg(CssProp.CP.grid_template);
CssProp.GRID_TEMPLATE_AREAS = CssProp.reg(CssProp.CP.grid_template_areas);
CssProp.GRID_TEMPLATE_COLUMNS = CssProp.reg(CssProp.CP.grid_template_columns);
CssProp.GRID_TEMPLATE_ROWS = CssProp.reg(CssProp.CP.grid_template_rows);
CssProp.GAP = CssProp.reg(CssProp.CP.gap);
CssProp.ROW_GAP = CssProp.reg(CssProp.CP.row_gap);
CssProp.COLUMN_GAP = CssProp.reg(CssProp.CP.column_gap);
CssProp.PLACE_CONTENT = CssProp.reg(CssProp.AP.place_content);
CssProp.PLACE_ITEMS = CssProp.reg(CssProp.AP.place_items);
CssProp.PLACE_SELF = CssProp.reg(CssProp.AP.place_self);
/**
 * A class to sanitize HTML strings.
 */
class Sanitizer {
    constructor() {
        this._autolink = true;
        this._allowNamedProperties = false;
        this._generateOptions = () => {
            const schemesToAllow = Array.isArray(this._customAllowedSchemes)
                ? this._customAllowedSchemes
                : [...(sanitize_html_default()).defaults.allowedSchemes];
            return {
                // HTML tags that are allowed to be used. Tags were extracted from Google Caja
                allowedTags: [
                    'a',
                    'abbr',
                    'acronym',
                    'address',
                    'area',
                    'article',
                    'aside',
                    'audio',
                    'b',
                    'bdi',
                    'bdo',
                    'big',
                    'blockquote',
                    'br',
                    'button',
                    'canvas',
                    'caption',
                    'center',
                    'cite',
                    'code',
                    'col',
                    'colgroup',
                    'colspan',
                    'command',
                    'data',
                    'datalist',
                    'dd',
                    'del',
                    'details',
                    'dfn',
                    'dir',
                    'div',
                    'dl',
                    'dt',
                    'em',
                    'fieldset',
                    'figcaption',
                    'figure',
                    'font',
                    'footer',
                    'form',
                    'h1',
                    'h2',
                    'h3',
                    'h4',
                    'h5',
                    'h6',
                    'header',
                    'hgroup',
                    'hr',
                    'i',
                    // 'iframe' is allowed by Google Caja, but disallowed by default by sanitize-html
                    // , 'iframe'
                    'img',
                    'input',
                    'ins',
                    'kbd',
                    'label',
                    'legend',
                    'li',
                    'map',
                    'mark',
                    'menu',
                    'meter',
                    'nav',
                    'nobr',
                    'ol',
                    'optgroup',
                    'option',
                    'output',
                    'p',
                    'pre',
                    'progress',
                    'q',
                    'rowspan',
                    's',
                    'samp',
                    'section',
                    'select',
                    'small',
                    'source',
                    'span',
                    'strike',
                    'strong',
                    'sub',
                    'summary',
                    'sup',
                    'table',
                    'tbody',
                    'td',
                    'textarea',
                    'tfoot',
                    'th',
                    'thead',
                    'time',
                    'tr',
                    'track',
                    'tt',
                    'u',
                    'ul',
                    'var',
                    'video',
                    'wbr'
                ],
                // Attributes that HTML tags are allowed to have, extracted from Google Caja.
                // See https://github.com/jupyterlab/jupyterlab/issues/1812#issuecomment-285848435
                allowedAttributes: {
                    '*': [
                        'class',
                        'data-jupyter-id',
                        'dir',
                        'draggable',
                        'hidden',
                        'id',
                        'inert',
                        'itemprop',
                        'itemref',
                        'itemscope',
                        'lang',
                        'spellcheck',
                        'style',
                        'title',
                        'translate'
                    ],
                    // 'rel' and 'target' were *not* allowed by Google Caja
                    a: [
                        'accesskey',
                        'coords',
                        'href',
                        'hreflang',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'rel',
                        'shape',
                        'tabindex',
                        'target',
                        'type'
                    ],
                    area: [
                        'accesskey',
                        'alt',
                        'coords',
                        'href',
                        'nohref',
                        'shape',
                        'tabindex'
                    ],
                    // 'autoplay' was *not* allowed by Google Caja
                    audio: [
                        'autoplay',
                        'controls',
                        'loop',
                        'mediagroup',
                        'muted',
                        'preload',
                        'src'
                    ],
                    bdo: ['dir'],
                    blockquote: ['cite'],
                    br: ['clear'],
                    button: [
                        'accesskey',
                        'data-commandlinker-args',
                        'data-commandlinker-command',
                        'disabled',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'tabindex',
                        'type',
                        'value'
                    ],
                    canvas: ['height', 'width'],
                    caption: ['align'],
                    col: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                    colgroup: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                    command: [
                        'checked',
                        'command',
                        'disabled',
                        'icon',
                        'label',
                        'radiogroup',
                        'type'
                    ],
                    data: ['value'],
                    del: ['cite', 'datetime'],
                    details: ['open'],
                    dir: ['compact'],
                    div: ['align'],
                    dl: ['compact'],
                    fieldset: ['disabled'],
                    font: ['color', 'face', 'size'],
                    form: [
                        'accept',
                        'autocomplete',
                        'enctype',
                        'method',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'novalidate'
                    ],
                    h1: ['align'],
                    h2: ['align'],
                    h3: ['align'],
                    h4: ['align'],
                    h5: ['align'],
                    h6: ['align'],
                    hr: ['align', 'noshade', 'size', 'width'],
                    iframe: [
                        'align',
                        'frameborder',
                        'height',
                        'marginheight',
                        'marginwidth',
                        'width'
                    ],
                    img: [
                        'align',
                        'alt',
                        'border',
                        'height',
                        'hspace',
                        'ismap',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'src',
                        'usemap',
                        'vspace',
                        'width'
                    ],
                    input: [
                        'accept',
                        'accesskey',
                        'align',
                        'alt',
                        'autocomplete',
                        'checked',
                        'disabled',
                        'inputmode',
                        'ismap',
                        'list',
                        'max',
                        'maxlength',
                        'min',
                        'multiple',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'placeholder',
                        'readonly',
                        'required',
                        'size',
                        'src',
                        'step',
                        'tabindex',
                        'type',
                        'usemap',
                        'value'
                    ],
                    ins: ['cite', 'datetime'],
                    label: ['accesskey', 'for'],
                    legend: ['accesskey', 'align'],
                    li: ['type', 'value'],
                    map: this._allowNamedProperties ? ['name'] : [],
                    menu: ['compact', 'label', 'type'],
                    meter: ['high', 'low', 'max', 'min', 'value'],
                    ol: ['compact', 'reversed', 'start', 'type'],
                    optgroup: ['disabled', 'label'],
                    option: ['disabled', 'label', 'selected', 'value'],
                    output: ['for', ...(this._allowNamedProperties ? ['name'] : [])],
                    p: ['align'],
                    pre: ['width'],
                    progress: ['max', 'min', 'value'],
                    q: ['cite'],
                    select: [
                        'autocomplete',
                        'disabled',
                        'multiple',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'required',
                        'size',
                        'tabindex'
                    ],
                    source: ['type'],
                    table: [
                        'align',
                        'bgcolor',
                        'border',
                        'cellpadding',
                        'cellspacing',
                        'frame',
                        'rules',
                        'summary',
                        'width'
                    ],
                    tbody: ['align', 'char', 'charoff', 'valign'],
                    td: [
                        'abbr',
                        'align',
                        'axis',
                        'bgcolor',
                        'char',
                        'charoff',
                        'colspan',
                        'headers',
                        'height',
                        'nowrap',
                        'rowspan',
                        'scope',
                        'valign',
                        'width'
                    ],
                    textarea: [
                        'accesskey',
                        'autocomplete',
                        'cols',
                        'disabled',
                        'inputmode',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'placeholder',
                        'readonly',
                        'required',
                        'rows',
                        'tabindex',
                        'wrap'
                    ],
                    tfoot: ['align', 'char', 'charoff', 'valign'],
                    th: [
                        'abbr',
                        'align',
                        'axis',
                        'bgcolor',
                        'char',
                        'charoff',
                        'colspan',
                        'headers',
                        'height',
                        'nowrap',
                        'rowspan',
                        'scope',
                        'valign',
                        'width'
                    ],
                    thead: ['align', 'char', 'charoff', 'valign'],
                    tr: ['align', 'bgcolor', 'char', 'charoff', 'valign'],
                    track: ['default', 'kind', 'label', 'srclang'],
                    ul: ['compact', 'type'],
                    video: [
                        'autoplay',
                        'controls',
                        'height',
                        'loop',
                        'mediagroup',
                        'muted',
                        'poster',
                        'preload',
                        'src',
                        'width'
                    ]
                },
                // Inline CSS styles that HTML tags may have (and their allowed values)
                allowedStyles: {
                    // To simplify the data, all styles are allowed on all tags that allow the style attribute
                    '*': {
                        'backface-visibility': [CssProp.BACKFACE_VISIBILITY],
                        background: [CssProp.BACKGROUND],
                        'background-attachment': [CssProp.BACKGROUND_ATTACHMENT],
                        'background-clip': [CssProp.BACKGROUND_CLIP],
                        'background-color': [CssProp.BACKGROUND_COLOR],
                        'background-image': [CssProp.BACKGROUND_IMAGE],
                        'background-origin': [CssProp.BACKGROUND_ORIGIN],
                        'background-position': [CssProp.BACKGROUND_POSITION],
                        'background-repeat': [CssProp.BACKGROUND_REPEAT],
                        'background-size': [CssProp.BACKGROUND_SIZE],
                        border: [CssProp.BORDER],
                        'border-bottom': [CssProp.BORDER_BOTTOM],
                        'border-bottom-color': [CssProp.BORDER_BOTTOM_COLOR],
                        'border-bottom-left-radius': [CssProp.BORDER_BOTTOM_LEFT_RADIUS],
                        'border-bottom-right-radius': [CssProp.BORDER_BOTTOM_RIGHT_RADIUS],
                        'border-bottom-style': [CssProp.BORDER_BOTTOM_STYLE],
                        'border-bottom-width': [CssProp.BORDER_BOTTOM_WIDTH],
                        'border-collapse': [CssProp.BORDER_COLLAPSE],
                        'border-color': [CssProp.BORDER_COLOR],
                        'border-left': [CssProp.BORDER_LEFT],
                        'border-left-color': [CssProp.BORDER_LEFT_COLOR],
                        'border-left-style': [CssProp.BORDER_LEFT_STYLE],
                        'border-left-width': [CssProp.BORDER_LEFT_WIDTH],
                        'border-radius': [CssProp.BORDER_RADIUS],
                        'border-right': [CssProp.BORDER_RIGHT],
                        'border-right-color': [CssProp.BORDER_RIGHT_COLOR],
                        'border-right-style': [CssProp.BORDER_RIGHT_STYLE],
                        'border-right-width': [CssProp.BORDER_RIGHT_WIDTH],
                        'border-spacing': [CssProp.BORDER_SPACING],
                        'border-style': [CssProp.BORDER_STYLE],
                        'border-top': [CssProp.BORDER_TOP],
                        'border-top-color': [CssProp.BORDER_TOP_COLOR],
                        'border-top-left-radius': [CssProp.BORDER_TOP_LEFT_RADIUS],
                        'border-top-right-radius': [CssProp.BORDER_TOP_RIGHT_RADIUS],
                        'border-top-style': [CssProp.BORDER_TOP_STYLE],
                        'border-top-width': [CssProp.BORDER_TOP_WIDTH],
                        'border-width': [CssProp.BORDER_WIDTH],
                        bottom: [CssProp.BOTTOM],
                        box: [CssProp.BOX],
                        'box-shadow': [CssProp.BOX_SHADOW],
                        'box-sizing': [CssProp.BOX_SIZING],
                        'caption-side': [CssProp.CAPTION_SIDE],
                        clear: [CssProp.CLEAR],
                        clip: [CssProp.CLIP],
                        color: [CssProp.COLOR],
                        cursor: [CssProp.CURSOR],
                        direction: [CssProp.DIRECTION],
                        display: [CssProp.DISPLAY],
                        'display-inside': [CssProp.DISPLAY_INSIDE],
                        'display-outside': [CssProp.DISPLAY_OUTSIDE],
                        elevation: [CssProp.ELEVATION],
                        'empty-cells': [CssProp.EMPTY_CELLS],
                        float: [CssProp.FLOAT],
                        font: [CssProp.FONT],
                        'font-family': [CssProp.FONT_FAMILY],
                        'font-size': [CssProp.FONT_SIZE],
                        'font-stretch': [CssProp.FONT_STRETCH],
                        'font-style': [CssProp.FONT_STYLE],
                        'font-variant': [CssProp.FONT_VARIANT],
                        'font-weight': [CssProp.FONT_WEIGHT],
                        height: [CssProp.HEIGHT],
                        left: [CssProp.LEFT],
                        'letter-spacing': [CssProp.LETTER_SPACING],
                        'line-height': [CssProp.LINE_HEIGHT],
                        'list-style': [CssProp.LIST_STYLE],
                        'list-style-image': [CssProp.LIST_STYLE_IMAGE],
                        'list-style-position': [CssProp.LIST_STYLE_POSITION],
                        'list-style-type': [CssProp.LIST_STYLE_TYPE],
                        margin: [CssProp.MARGIN],
                        'margin-bottom': [CssProp.MARGIN_BOTTOM],
                        'margin-left': [CssProp.MARGIN_LEFT],
                        'margin-right': [CssProp.MARGIN_RIGHT],
                        'margin-top': [CssProp.MARGIN_TOP],
                        'max-height': [CssProp.MAX_HEIGHT],
                        'max-width': [CssProp.MAX_WIDTH],
                        'min-height': [CssProp.MIN_HEIGHT],
                        'min-width': [CssProp.MIN_WIDTH],
                        opacity: [CssProp.OPACITY],
                        outline: [CssProp.OUTLINE],
                        'outline-color': [CssProp.OUTLINE_COLOR],
                        'outline-style': [CssProp.OUTLINE_STYLE],
                        'outline-width': [CssProp.OUTLINE_WIDTH],
                        overflow: [CssProp.OVERFLOW],
                        'overflow-wrap': [CssProp.OVERFLOW_WRAP],
                        'overflow-x': [CssProp.OVERFLOW_X],
                        'overflow-y': [CssProp.OVERFLOW_Y],
                        padding: [CssProp.PADDING],
                        'padding-bottom': [CssProp.PADDING_BOTTOM],
                        'padding-left': [CssProp.PADDING_LEFT],
                        'padding-right': [CssProp.PADDING_RIGHT],
                        'padding-top': [CssProp.PADDING_TOP],
                        'page-break-after': [CssProp.PAGE_BREAK_AFTER],
                        'page-break-before': [CssProp.PAGE_BREAK_BEFORE],
                        'page-break-inside': [CssProp.PAGE_BREAK_INSIDE],
                        'pause-after': [CssProp.PAUSE_AFTER],
                        perspective: [CssProp.PERSPECTIVE],
                        pitch: [CssProp.PITCH],
                        'pitch-range': [CssProp.PITCH_RANGE],
                        position: [CssProp.POSITION],
                        quotes: [CssProp.QUOTES],
                        resize: [CssProp.RESIZE],
                        richness: [CssProp.RICHNESS],
                        right: [CssProp.RIGHT],
                        speak: [CssProp.SPEAK],
                        'speak-header': [CssProp.SPEAK_HEADER],
                        'speak-numeral': [CssProp.SPEAK_NUMERAL],
                        'speak-punctuation': [CssProp.SPEAK_PUNCTUATION],
                        'speech-rate': [CssProp.SPEECH_RATE],
                        stress: [CssProp.STRESS],
                        'table-layout': [CssProp.TABLE_LAYOUT],
                        'text-align': [CssProp.TEXT_ALIGN],
                        'text-decoration': [CssProp.TEXT_DECORATION],
                        'text-indent': [CssProp.TEXT_INDENT],
                        'text-overflow': [CssProp.TEXT_OVERFLOW],
                        'text-shadow': [CssProp.TEXT_SHADOW],
                        'text-transform': [CssProp.TEXT_TRANSFORM],
                        'text-wrap': [CssProp.TEXT_WRAP],
                        top: [CssProp.TOP],
                        'unicode-bidi': [CssProp.UNICODE_BIDI],
                        'vertical-align': [CssProp.VERTICAL_ALIGN],
                        visibility: [CssProp.VISIBILITY],
                        volume: [CssProp.VOLUME],
                        'white-space': [CssProp.WHITE_SPACE],
                        width: [CssProp.WIDTH],
                        'word-break': [CssProp.WORD_BREAK],
                        'word-spacing': [CssProp.WORD_SPACING],
                        'word-wrap': [CssProp.WORD_WRAP],
                        'z-index': [CssProp.Z_INDEX],
                        zoom: [CssProp.ZOOM],
                        // Flexbox and Grid properties
                        'align-content': [CssProp.ALIGN_CONTENT],
                        'align-items': [CssProp.ALIGN_ITEMS],
                        'align-self': [CssProp.ALIGN_SELF],
                        flex: [CssProp.FLEX],
                        'flex-basis': [CssProp.FLEX_BASIS],
                        'flex-direction': [CssProp.FLEX_DIRECTION],
                        'flex-grow': [CssProp.FLEX_GROW],
                        'flex-shrink': [CssProp.FLEX_SHRINK],
                        'flex-wrap': [CssProp.FLEX_WRAP],
                        grid: [CssProp.GRID],
                        'grid-area': [CssProp.GRID_AREA],
                        'grid-auto-columns': [CssProp.GRID_AUTO_COLUMNS],
                        'grid-auto-flow': [CssProp.GRID_AUTO_FLOW],
                        'grid-auto-rows': [CssProp.GRID_AUTO_ROWS],
                        'grid-column': [CssProp.GRID_COLUMN],
                        'grid-column-end': [CssProp.GRID_COLUMN_END],
                        'grid-column-gap': [CssProp.GRID_COLUMN_GAP],
                        'grid-column-start': [CssProp.GRID_COLUMN_START],
                        'grid-gap': [CssProp.GRID_GAP],
                        'grid-row': [CssProp.GRID_ROW],
                        'grid-row-end': [CssProp.GRID_ROW_END],
                        'grid-row-gap': [CssProp.GRID_ROW_GAP],
                        'grid-row-start': [CssProp.GRID_ROW_START],
                        'grid-template': [CssProp.GRID_TEMPLATE],
                        'grid-template-areas': [CssProp.GRID_TEMPLATE_AREAS],
                        'grid-template-columns': [CssProp.GRID_TEMPLATE_COLUMNS],
                        'grid-template-rows': [CssProp.GRID_TEMPLATE_ROWS],
                        gap: [CssProp.GAP],
                        'row-gap': [CssProp.ROW_GAP],
                        'column-gap': [CssProp.COLUMN_GAP],
                        'justify-content': [CssProp.JUSTIFY_CONTENT],
                        'justify-items': [CssProp.JUSTIFY_ITEMS],
                        'justify-self': [CssProp.JUSTIFY_SELF],
                        order: [CssProp.ORDER],
                        'place-content': [CssProp.PLACE_CONTENT],
                        'place-items': [CssProp.PLACE_ITEMS],
                        'place-self': [CssProp.PLACE_SELF]
                    }
                },
                transformTags: {
                    // Set the "rel" attribute for <a> tags to "nofollow".
                    a: sanitize_html_default().simpleTransform('a', { rel: 'nofollow' }),
                    // Set the "disabled" attribute for <input> tags.
                    input: sanitize_html_default().simpleTransform('input', { disabled: 'disabled' }),
                    // Replace "id" attribute by "data-jupyter-id" if "id" is not allowed.
                    ...(this._allowNamedProperties
                        ? {}
                        : {
                            '*': function (tagName, attribs) {
                                if (attribs.id !== undefined) {
                                    attribs['data-jupyter-id'] = attribs.id;
                                    delete attribs.id;
                                }
                                return {
                                    tagName,
                                    attribs: {
                                        ...attribs
                                    }
                                };
                            }
                        })
                },
                allowedSchemes: schemesToAllow,
                allowedSchemesByTag: {
                    // Allow 'attachment:' img src (used for markdown cell attachments).
                    img: [...schemesToAllow, 'attachment']
                },
                // Override of the default option, so we can skip 'src' attribute validation.
                // 'src' Attributes are validated to be URIs, which does not allow for embedded (image) data.
                // Since embedded data is no longer deemed to be a threat, validation can be skipped.
                // See https://github.com/jupyterlab/jupyterlab/issues/5183
                allowedSchemesAppliedToAttributes: ['href', 'cite']
            };
        };
        this._options = this._generateOptions();
    }
    /**
     * Sanitize an HTML string.
     *
     * @param dirty - The dirty text.
     *
     * @param options - The optional sanitization options.
     *
     * @returns The sanitized string.
     */
    sanitize(dirty, options) {
        return sanitize_html_default()(dirty, { ...this._options, ...(options || {}) });
    }
    /**
     * @returns Whether to replace URLs by HTML anchors.
     */
    getAutolink() {
        return this._autolink;
    }
    /**
     * @returns Whether to allow name and id attributes.
     */
    get allowNamedProperties() {
        return this._allowNamedProperties;
    }
    /**
     * Set the allowed schemes
     *
     * @param scheme Allowed schemes.
     * Automatically regenerates sanitizer options to apply the change.
     * Note: the schemes merge into the current config and does not get overwritten.
     */
    setAllowedSchemes(scheme) {
        // Force copy of `scheme`
        this._customAllowedSchemes = [...scheme];
        this._options = this._generateOptions();
    }
    /**
     * Set the URL replacement boolean.
     *
     * @param autolink URL replacement boolean.
     */
    setAutolink(autolink) {
        this._autolink = autolink;
    }
    /**
     * Set the whether to allow `name` and `id` attributes.
     */
    setAllowNamedProperties(allowNamedProperties) {
        this._allowNamedProperties = allowNamedProperties;
        this._options = this._generateOptions();
    }
}
//# sourceMappingURL=sanitizer.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/semanticCommand.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
/**
 * Semantic group of commands
 */
class SemanticCommand {
    constructor() {
        this._commands = new Array();
    }
    /**
     * The command IDs used by this semantic command.
     */
    get ids() {
        return this._commands.map(c => c.id);
    }
    /**
     * Add a command to the semantic group
     *
     * @param command Command to add
     */
    add(command) {
        if (this._commands.map(c => c.id).includes(command.id)) {
            throw Error(`Command ${command.id} is already defined.`);
        }
        this._commands.push({
            isEnabled: () => true,
            rank: SemanticCommand.DEFAULT_RANK,
            ...command
        });
    }
    /**
     * Get the command id of the enabled command from this group
     * for the given widget.
     *
     * @param widget Widget
     * @returns Command id
     */
    getActiveCommandId(widget) {
        var _a;
        const commands = this._commands
            .filter(c => c.isEnabled(widget))
            .sort((a, b) => {
            const rankDelta = a.rank - b.rank;
            return rankDelta || (a.id < b.id ? -1 : 1);
        });
        const command = (_a = commands[0]) !== null && _a !== void 0 ? _a : { id: null };
        return command.id;
    }
    /**
     * Remove a command ID.
     *
     * @param id Command ID to remove
     */
    remove(id) {
        const index = this._commands.findIndex(c => c.id === id);
        if (index >= 0) {
            this._commands.splice(index, 1);
        }
    }
}
/**
 * Default rank for semantic command
 */
SemanticCommand.DEFAULT_RANK = 500;
/**
 * The `args` key for a semantic command's current widget ID.
 */
SemanticCommand.WIDGET = 'semanticWidget';
//# sourceMappingURL=semanticCommand.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(42574);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/thememanager.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * The number of milliseconds between theme loading attempts.
 */
const REQUEST_INTERVAL = 75;
/**
 * The number of times to attempt to load a theme before giving up.
 */
const REQUEST_THRESHOLD = 20;
/**
 * A class that provides theme management.
 */
class ThemeManager {
    /**
     * Construct a new theme manager.
     */
    constructor(options) {
        this._current = null;
        this._links = [];
        this._overrides = {};
        this._overrideProps = {};
        this._outstanding = null;
        this._pending = 0;
        this._requests = {};
        this._themes = {};
        this._themeChanged = new signaling_dist_index_es6_js_.Signal(this);
        const { host, key, splash, url } = options;
        this.translator = options.translator || lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        const registry = options.settings;
        this._base = url;
        this._host = host;
        this._splash = splash || null;
        void registry.load(key).then(settings => {
            this._settings = settings;
            // set up css overrides once we have a pointer to the settings schema
            this._initOverrideProps();
            this._settings.changed.connect(this._loadSettings, this);
            this._loadSettings();
        });
    }
    /**
     * Get the name of the current theme.
     */
    get theme() {
        return this._current;
    }
    /**
     * Get the name of the preferred light theme.
     */
    get preferredLightTheme() {
        return this._settings.composite['preferred-light-theme'];
    }
    /**
     * Get the name of the preferred dark theme.
     */
    get preferredDarkTheme() {
        return this._settings.composite['preferred-dark-theme'];
    }
    /**
     * Get the name of the preferred theme
     * When `adaptive-theme` is disabled, get current theme;
     * Else, depending on the system settings, get preferred light or dark theme.
     */
    get preferredTheme() {
        if (!this.isToggledAdaptiveTheme()) {
            return this.theme;
        }
        if (this.isSystemColorSchemeDark()) {
            return this.preferredDarkTheme;
        }
        return this.preferredLightTheme;
    }
    /**
     * The names of the registered themes.
     */
    get themes() {
        return Object.keys(this._themes);
    }
    /**
     * Get the names of the light themes.
     */
    get lightThemes() {
        return Object.entries(this._themes)
            .filter(([_, theme]) => theme.isLight)
            .map(([name, _]) => name);
    }
    /**
     * Get the names of the dark themes.
     */
    get darkThemes() {
        return Object.entries(this._themes)
            .filter(([_, theme]) => !theme.isLight)
            .map(([name, _]) => name);
    }
    /**
     * A signal fired when the application theme changes.
     */
    get themeChanged() {
        return this._themeChanged;
    }
    /**
     * Test if the system's preferred color scheme is dark
     */
    isSystemColorSchemeDark() {
        return (window.matchMedia &&
            window.matchMedia('(prefers-color-scheme: dark)').matches);
    }
    /**
     * Get the value of a CSS variable from its key.
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @returns value - The current value of the Jupyterlab CSS variable
     */
    getCSS(key) {
        var _a;
        return ((_a = this._overrides[key]) !== null && _a !== void 0 ? _a : getComputedStyle(document.documentElement).getPropertyValue(`--jp-${key}`));
    }
    /**
     * Load a theme CSS file by path.
     *
     * @param path - The path of the file to load.
     */
    loadCSS(path) {
        const base = this._base;
        const href = coreutils_lib_index_js_.URLExt.isLocal(path) ? coreutils_lib_index_js_.URLExt.join(base, path) : path;
        const links = this._links;
        return new Promise((resolve, reject) => {
            const link = document.createElement('link');
            link.setAttribute('rel', 'stylesheet');
            link.setAttribute('type', 'text/css');
            link.setAttribute('href', href);
            link.addEventListener('load', () => {
                resolve(undefined);
            });
            link.addEventListener('error', () => {
                reject(`Stylesheet failed to load: ${href}`);
            });
            document.body.appendChild(link);
            links.push(link);
            // add any css overrides to document
            this.loadCSSOverrides();
        });
    }
    /**
     * Loads all current CSS overrides from settings. If an override has been
     * removed or is invalid, this function unloads it instead.
     */
    loadCSSOverrides() {
        var _a;
        const newOverrides = (_a = this._settings.user['overrides']) !== null && _a !== void 0 ? _a : {};
        // iterate over the union of current and new CSS override keys
        Object.keys({ ...this._overrides, ...newOverrides }).forEach(key => {
            const val = newOverrides[key];
            if (val && this.validateCSS(key, val)) {
                // validation succeeded, set the override
                document.documentElement.style.setProperty(`--jp-${key}`, val);
            }
            else {
                // if key is not present or validation failed, the override will be removed
                delete newOverrides[key];
                document.documentElement.style.removeProperty(`--jp-${key}`);
            }
        });
        // replace the current overrides with the new ones
        this._overrides = newOverrides;
    }
    /**
     * Validate a CSS value w.r.t. a key
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @param val - A candidate CSS value
     */
    validateCSS(key, val) {
        // determine the css property corresponding to the key
        const prop = this._overrideProps[key];
        if (!prop) {
            console.warn('CSS validation failed: could not find property corresponding to key.\n' +
                `key: '${key}', val: '${val}'`);
            return false;
        }
        // use built-in validation once we have the corresponding property
        if (CSS.supports(prop, val)) {
            return true;
        }
        else {
            console.warn('CSS validation failed: invalid value.\n' +
                `key: '${key}', val: '${val}', prop: '${prop}'`);
            return false;
        }
    }
    /**
     * Register a theme with the theme manager.
     *
     * @param theme - The theme to register.
     *
     * @returns A disposable that can be used to unregister the theme.
     */
    register(theme) {
        const { name } = theme;
        const themes = this._themes;
        if (themes[name]) {
            throw new Error(`Theme already registered for ${name}`);
        }
        themes[name] = theme;
        return new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            delete themes[name];
        });
    }
    /**
     * Add a CSS override to the settings.
     */
    setCSSOverride(key, value) {
        return this._settings.set('overrides', {
            ...this._overrides,
            [key]: value
        });
    }
    /**
     * Set the current theme.
     */
    setTheme(name) {
        return this._settings.set('theme', name);
    }
    /**
     * Set the preferred light theme.
     */
    setPreferredLightTheme(name) {
        return this._settings.set('preferred-light-theme', name);
    }
    /**
     * Set the preferred dark theme.
     */
    setPreferredDarkTheme(name) {
        return this._settings.set('preferred-dark-theme', name);
    }
    /**
     * Test whether a given theme is light.
     */
    isLight(name) {
        return this._themes[name].isLight;
    }
    /**
     * Increase a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    incrFontSize(key) {
        return this._incrFontSize(key, true);
    }
    /**
     * Decrease a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    decrFontSize(key) {
        return this._incrFontSize(key, false);
    }
    /**
     * Test whether a given theme styles scrollbars,
     * and if the user has scrollbar styling enabled.
     */
    themeScrollbars(name) {
        return (!!this._settings.composite['theme-scrollbars'] &&
            !!this._themes[name].themeScrollbars);
    }
    /**
     * Test if the user has scrollbar styling enabled.
     */
    isToggledThemeScrollbars() {
        return !!this._settings.composite['theme-scrollbars'];
    }
    /**
     * Toggle the `theme-scrollbars` setting.
     */
    toggleThemeScrollbars() {
        return this._settings.set('theme-scrollbars', !this._settings.composite['theme-scrollbars']);
    }
    /**
     * Test if the user enables adaptive theme.
     */
    isToggledAdaptiveTheme() {
        return !!this._settings.composite['adaptive-theme'];
    }
    /**
     * Toggle the `adaptive-theme` setting.
     */
    toggleAdaptiveTheme() {
        return this._settings.set('adaptive-theme', !this._settings.composite['adaptive-theme']);
    }
    /**
     * Get the display name of the theme.
     */
    getDisplayName(name) {
        var _a, _b;
        return (_b = (_a = this._themes[name]) === null || _a === void 0 ? void 0 : _a.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * Change a font size by a positive or negative increment.
     */
    _incrFontSize(key, add = true) {
        var _a;
        // get the numeric and unit parts of the current font size
        const parts = ((_a = this.getCSS(key)) !== null && _a !== void 0 ? _a : '13px').split(/([a-zA-Z]+)/);
        // determine the increment
        const incr = (add ? 1 : -1) * (parts[1] === 'em' ? 0.1 : 1);
        // increment the font size and set it as an override
        return this.setCSSOverride(key, `${Number(parts[0]) + incr}${parts[1]}`);
    }
    /**
     * Initialize the key -> property dict for the overrides
     */
    _initOverrideProps() {
        const definitions = this._settings.schema.definitions;
        const overidesSchema = definitions.cssOverrides.properties;
        Object.keys(overidesSchema).forEach(key => {
            // override validation is against the CSS property in the description
            // field. Example: for key ui-font-family, .description is font-family
            let description;
            switch (key) {
                case 'code-font-size':
                case 'content-font-size1':
                case 'ui-font-size1':
                    description = 'font-size';
                    break;
                default:
                    description = overidesSchema[key].description;
                    break;
            }
            this._overrideProps[key] = description;
        });
    }
    /**
     * Handle the current settings.
     */
    _loadSettings() {
        const outstanding = this._outstanding;
        const pending = this._pending;
        const requests = this._requests;
        // If another request is pending, cancel it.
        if (pending) {
            window.clearTimeout(pending);
            this._pending = 0;
        }
        const settings = this._settings;
        const themes = this._themes;
        let theme = settings.composite['theme'];
        if (this.isToggledAdaptiveTheme()) {
            if (this.isSystemColorSchemeDark()) {
                theme = this.preferredDarkTheme;
            }
            else {
                theme = this.preferredLightTheme;
            }
        }
        // If another promise is outstanding, wait until it finishes before
        // attempting to load the settings. Because outstanding promises cannot
        // be aborted, the order in which they occur must be enforced.
        if (outstanding) {
            outstanding
                .then(() => {
                this._loadSettings();
            })
                .catch(() => {
                this._loadSettings();
            });
            this._outstanding = null;
            return;
        }
        // Increment the request counter.
        requests[theme] = requests[theme] ? requests[theme] + 1 : 1;
        // If the theme exists, load it right away.
        if (themes[theme]) {
            this._outstanding = this._loadTheme(theme);
            delete requests[theme];
            return;
        }
        // If the request has taken too long, give up.
        if (requests[theme] > REQUEST_THRESHOLD) {
            const fallback = settings.default('theme');
            // Stop tracking the requests for this theme.
            delete requests[theme];
            if (!themes[fallback]) {
                this._onError(this._trans.__('Neither theme %1 nor default %2 loaded.', theme, fallback));
                return;
            }
            console.warn(`Could not load theme ${theme}, using default ${fallback}.`);
            this._outstanding = this._loadTheme(fallback);
            return;
        }
        // If the theme does not yet exist, attempt to wait for it.
        this._pending = window.setTimeout(() => {
            this._loadSettings();
        }, REQUEST_INTERVAL);
    }
    /**
     * Load the theme.
     *
     * #### Notes
     * This method assumes that the `theme` exists.
     */
    _loadTheme(theme) {
        var _a;
        const current = this._current;
        const links = this._links;
        const themes = this._themes;
        const splash = this._splash
            ? this._splash.show(themes[theme].isLight)
            : new disposable_dist_index_es6_js_.DisposableDelegate(() => undefined);
        // Unload any CSS files that have been loaded.
        links.forEach(link => {
            if (link.parentElement) {
                link.parentElement.removeChild(link);
            }
        });
        links.length = 0;
        const themeProps = (_a = this._settings.schema.properties) === null || _a === void 0 ? void 0 : _a.theme;
        if (themeProps) {
            themeProps.enum = Object.keys(themes).map(value => { var _a; return (_a = themes[value].displayName) !== null && _a !== void 0 ? _a : value; });
        }
        // Unload the previously loaded theme.
        const old = current ? themes[current].unload() : Promise.resolve();
        return Promise.all([old, themes[theme].load()])
            .then(() => {
            this._current = theme;
            this._themeChanged.emit({
                name: 'theme',
                oldValue: current,
                newValue: theme
            });
            // Need to force a redraw of the app here to avoid a Chrome rendering
            // bug that can leave the scrollbars in an invalid state
            this._host.hide();
            // If we hide/show the widget too quickly, no redraw will happen.
            // requestAnimationFrame delays until after the next frame render.
            requestAnimationFrame(() => {
                this._host.show();
                thememanager_Private.fitAll(this._host);
                splash.dispose();
            });
        })
            .catch(reason => {
            this._onError(reason);
            splash.dispose();
        });
    }
    /**
     * Handle a theme error.
     */
    _onError(reason) {
        void showDialog({
            title: this._trans.__('Error Loading Theme'),
            body: String(reason),
            buttons: [dialog_Dialog.okButton({ label: this._trans.__('OK') })]
        });
    }
}
/**
 * A namespace for module private data.
 */
var thememanager_Private;
(function (Private) {
    /**
     * Fit a widget and all of its children, recursively.
     */
    function fitAll(widget) {
        for (const child of widget.children()) {
            fitAll(child);
        }
        widget.fit();
    }
    Private.fitAll = fitAll;
})(thememanager_Private || (thememanager_Private = {}));
//# sourceMappingURL=thememanager.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/tokens.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The command palette token.
 */
const ICommandPalette = new dist_index_js_.Token('@jupyterlab/apputils:ICommandPalette', `A service for the application command palette
  in the left panel. Use this to add commands to the palette.`);
/**
 * The kernel status indicator model.
 */
const IKernelStatusModel = new dist_index_js_.Token('@jupyterlab/apputils:IKernelStatusModel', 'A service to register kernel session provider to the kernel status indicator.');
/**
 * The license client for fetching licenses.
 */
const ILicensesClient = new dist_index_js_.Token('@jupyterlab/apputils:ILicensesClient', 'A service for fetching licenses.');
/**
 * The session context dialogs token.
 */
const ISessionContextDialogs = new dist_index_js_.Token('@jupyterlab/apputils:ISessionContextDialogs', 'A service for handling the session dialogs.');
/**
 * The theme manager token.
 */
const IThemeManager = new dist_index_js_.Token('@jupyterlab/apputils:IThemeManager', 'A service for the theme manager for the application. This is used primarily in theme extensions to register new themes.');
/**
 * The sanitizer token.
 */
const ISanitizer = new dist_index_js_.Token('@jupyterlab/apputils:ISanitizer', 'A service for sanitizing HTML strings.');
/**
 * The main menu token.
 */
const ISplashScreen = new dist_index_js_.Token('@jupyterlab/apputils:ISplashScreen', `A service for the splash screen for the application.
  Use this if you want to show the splash screen for your own purposes.`);
/**
 * The default window resolver token.
 */
const IWindowResolver = new dist_index_js_.Token('@jupyterlab/apputils:IWindowResolver', `A service for a window resolver for the
  application. JupyterLab workspaces are given a name, which are determined using
  the window resolver. Require this if you want to use the name of the current workspace.`);
/**
 * The toolbar registry token.
 */
const IToolbarWidgetRegistry = new dist_index_js_.Token('@jupyterlab/apputils:IToolbarWidgetRegistry', `A registry for toolbar widgets. Require this
  if you want to build the toolbar dynamically from a data definition (stored in settings for example).`);
//# sourceMappingURL=tokens.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/registry.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Concrete implementation of IToolbarWidgetRegistry interface
 */
class ToolbarWidgetRegistry {
    constructor(options) {
        this._widgets = new Map();
        this._factoryAdded = new signaling_dist_index_es6_js_.Signal(this);
        this._defaultFactory = options.defaultFactory;
    }
    /**
     * Default toolbar item factory
     */
    get defaultFactory() {
        return this._defaultFactory;
    }
    set defaultFactory(factory) {
        this._defaultFactory = factory;
    }
    /**
     * A signal emitted when a factory widget has been added.
     */
    get factoryAdded() {
        return this._factoryAdded;
    }
    /**
     * Create a toolbar item widget
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param widget The newly widget containing the toolbar
     * @param toolbarItem The toolbar item definition
     * @returns The widget to be inserted in the toolbar.
     */
    createWidget(widgetFactory, widget, toolbarItem) {
        var _a;
        const factory = (_a = this._widgets.get(widgetFactory)) === null || _a === void 0 ? void 0 : _a.get(toolbarItem.name);
        return factory
            ? factory(widget)
            : this._defaultFactory(widgetFactory, widget, toolbarItem);
    }
    /**
     * Add a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     */
    addFactory(widgetFactory, toolbarItemName, factory) {
        let namespace = this._widgets.get(widgetFactory);
        const oldFactory = namespace === null || namespace === void 0 ? void 0 : namespace.get(toolbarItemName);
        if (!namespace) {
            namespace = new Map();
            this._widgets.set(widgetFactory, namespace);
        }
        namespace.set(toolbarItemName, factory);
        this._factoryAdded.emit(toolbarItemName);
        return oldFactory;
    }
    /**
     * Register a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     *
     * @deprecated since v4 use `addFactory` instead
     */
    registerFactory(widgetFactory, toolbarItemName, factory) {
        return this.addFactory(widgetFactory, toolbarItemName, factory);
    }
}
/**
 * Create the default toolbar item widget factory
 *
 * @param commands Application commands registry
 * @returns Default factory
 */
function createDefaultFactory(commands) {
    return (widgetFactory, widget, toolbarItem) => {
        var _a, _b;
        switch ((_a = toolbarItem.type) !== null && _a !== void 0 ? _a : 'command') {
            case 'command': {
                const { command: tId, args: tArgs, label: tLabel, caption: tCaption, icon: tIcon } = toolbarItem;
                const id = tId !== null && tId !== void 0 ? tId : '';
                const args = { toolbar: true, ...tArgs };
                const icon = tIcon ? index_js_.LabIcon.resolve({ icon: tIcon }) : undefined;
                const toolbar = widget.toolbar;
                // If there is an icon, undefined label will results in no label
                // otherwise the label will be set using the setting or the command label
                const label = (icon !== null && icon !== void 0 ? icon : commands.icon(id, args)) ? tLabel !== null && tLabel !== void 0 ? tLabel : '' : tLabel;
                return new index_js_.CommandToolbarButton({
                    commands,
                    id,
                    args,
                    icon,
                    label,
                    caption: tCaption,
                    noFocusOnClick: (_b = toolbar === null || toolbar === void 0 ? void 0 : toolbar.noFocusOnClick) !== null && _b !== void 0 ? _b : false
                });
            }
            case 'spacer':
                return index_js_.Toolbar.createSpacerItem();
            default:
                return new index_es6_js_.Widget();
        }
    };
}
//# sourceMappingURL=registry.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/observables/lib/index.js)
var observables_lib_index_js_ = __webpack_require__(81975);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(19352);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/factory.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





/**
 * Default toolbar item rank
 *
 * #### Notes
 * This will place item just before the white spacer item in the notebook toolbar.
 */
const DEFAULT_TOOLBAR_ITEM_RANK = 50;
const TOOLBAR_KEY = 'jupyter.lab.toolbars';
/**
 * Display warning when the toolbar definition have been modified.
 *
 * @param trans Translation bundle
 */
async function displayInformation(trans) {
    const result = await showDialog({
        title: trans.__('Information'),
        body: trans.__('Toolbar customization has changed. You will need to reload JupyterLab to see the changes.'),
        buttons: [
            dialog_Dialog.cancelButton(),
            dialog_Dialog.okButton({ label: trans.__('Reload') })
        ]
    });
    if (result.button.accept) {
        location.reload();
    }
}
/**
 * Set the toolbar definition by accumulating all settings definition.
 *
 * The list will be populated only with the enabled items.
 *
 * @param toolbarItems Observable list to populate
 * @param registry Application settings registry
 * @param factoryName Widget factory name that needs a toolbar
 * @param pluginId Settings plugin id
 * @param translator Translator object
 * @param propertyId Property holding the toolbar definition in the settings; default 'toolbar'
 * @returns List of toolbar items
 */
async function setToolbarItems(toolbarItems, registry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    var _a;
    const trans = translator.load('jupyterlab');
    let canonical = null;
    let loaded = {};
    let listenPlugin = true;
    try {
        /**
         * Populate the plugin's schema defaults.
         *
         * We keep track of disabled entries in case the plugin is loaded
         * after the toolbar initialization.
         */
        function populate(schema) {
            var _a, _b;
            loaded = {};
            const pluginDefaults = Object.keys(registry.plugins)
                // Filter out the current plugin (will be listed when reloading)
                // because we control its addition after the mapping step
                .filter(plugin => plugin !== pluginId)
                .map(plugin => {
                var _a, _b;
                const items = (_b = ((_a = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : [];
                loaded[plugin] = items;
                return items;
            })
                .concat([(_b = ((_a = schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : []])
                .reduceRight((acc, val) => settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(acc, val, true), []);
            // Apply default value as last step to take into account overrides.json
            // The standard toolbars default is [] as the plugin must use
            // `jupyter.lab.toolbars.<factory>` to define its default value.
            schema.properties[propertyId].default =
                settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(pluginDefaults, schema.properties[propertyId].default, true).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
        }
        // Transform the plugin object to return different schema than the default.
        registry.transform(pluginId, {
            compose: plugin => {
                var _a, _b, _c, _d, _e;
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                const defaults = (_c = ((_b = ((_a = canonical.properties) !== null && _a !== void 0 ? _a : {})[propertyId]) !== null && _b !== void 0 ? _b : {}).default) !== null && _c !== void 0 ? _c : [];
                // Initialize the settings
                const user = plugin.data.user;
                const composite = plugin.data.composite;
                // Overrides the value with using the aggregated default for the toolbar property
                user[propertyId] =
                    (_d = plugin.data.user[propertyId]) !== null && _d !== void 0 ? _d : [];
                composite[propertyId] = ((_e = settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(defaults, user[propertyId], false)) !== null && _e !== void 0 ? _e : []).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
                plugin.data = { composite, user };
                return plugin;
            },
            fetch: plugin => {
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                return {
                    data: plugin.data,
                    id: plugin.id,
                    raw: plugin.raw,
                    schema: canonical,
                    version: plugin.version
                };
            }
        });
    }
    catch (error) {
        if (error.name === 'TransformError') {
            // Assume the existing transformer is the toolbar builder transformer
            // from another factory set up.
            listenPlugin = false;
        }
        else {
            throw error;
        }
    }
    // Repopulate the canonical variable after the setting registry has
    // preloaded all initial plugins.
    const settings = await registry.load(pluginId);
    // React to customization by the user
    settings.changed.connect(() => {
        var _a;
        const newItems = (_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : [];
        transferSettings(newItems);
    });
    const transferSettings = (newItems) => {
        // This is not optimal but safer because a toolbar item with the same
        // name cannot be inserted (it will be a no-op). But that could happen
        // if the settings are changing the items order.
        toolbarItems.clear();
        toolbarItems.pushAll(newItems.filter(item => !item.disabled));
    };
    // Initialize the toolbar
    transferSettings((_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : []);
    // React to plugin changes if no other transformer exists, otherwise bail.
    if (!listenPlugin) {
        return;
    }
    registry.pluginChanged.connect(async (sender, plugin) => {
        var _a, _b, _c;
        // Since the plugin storing the toolbar definition is transformed above,
        // if it has changed, it means that a request to reload was triggered.
        // Hence the toolbar definitions from the other plugins have been
        // automatically reset during the transform step.
        if (plugin === pluginId) {
            return;
        }
        // If a plugin changed its toolbar items
        const oldItems = (_a = loaded[plugin]) !== null && _a !== void 0 ? _a : [];
        const newItems = (_c = ((_b = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _b !== void 0 ? _b : {})[factoryName]) !== null && _c !== void 0 ? _c : [];
        if (!dist_index_js_.JSONExt.deepEqual(oldItems, newItems)) {
            if (loaded[plugin]) {
                // The plugin has changed, request the user to reload the UI
                await displayInformation(trans);
            }
            else {
                if (newItems.length > 0) {
                    // Empty the default values to avoid toolbar settings collisions.
                    canonical = null;
                    const schema = registry.plugins[pluginId].schema;
                    schema.properties.toolbar.default = [];
                    // Run again the transformations.
                    await registry.load(pluginId, true);
                }
            }
        }
    });
}
/**
 * Create the toolbar factory for a given container widget based
 * on a data description stored in settings
 *
 * @param toolbarRegistry Toolbar widgets registry
 * @param settingsRegistry Settings registry
 * @param factoryName Toolbar container factory name
 * @param pluginId Settings plugin id
 * @param translator Translator
 * @param propertyId Toolbar definition key in the settings plugin
 * @returns List of toolbar widgets factory
 */
function createToolbarFactory(toolbarRegistry, settingsRegistry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    const items = new observables_lib_index_js_.ObservableList({
        itemCmp: (a, b) => dist_index_js_.JSONExt.deepEqual(a, b)
    });
    // Get toolbar definition from the settings
    setToolbarItems(items, settingsRegistry, factoryName, pluginId, translator, propertyId).catch(reason => {
        console.error(`Failed to load toolbar items for factory ${factoryName} from ${pluginId}`, reason);
    });
    return (widget) => {
        const updateToolbar = (list, change) => {
            switch (change.type) {
                case 'move':
                    toolbar.move(change.oldIndex, change.newIndex);
                    break;
                case 'add':
                    change.newValues.forEach(item => toolbar.push({
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
                case 'remove':
                    change.oldValues.forEach(() => toolbar.remove(change.oldIndex));
                    break;
                case 'set':
                    change.newValues.forEach(item => toolbar.set(change.newIndex, {
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
                case 'clear':
                    change.oldValues.forEach(() => toolbar.remove(change.oldIndex));
                    break;
            }
        };
        const updateWidget = (registry, itemName) => {
            const itemIndex = Array.from(items).findIndex(item => item.name === itemName);
            if (itemIndex >= 0) {
                toolbar.set(itemIndex, {
                    name: itemName,
                    widget: toolbarRegistry.createWidget(factoryName, widget, items.get(itemIndex))
                });
            }
        };
        const toolbar = new observables_lib_index_js_.ObservableList({
            values: Array.from(items).map(item => {
                return {
                    name: item.name,
                    widget: toolbarRegistry.createWidget(factoryName, widget, item)
                };
            })
        });
        // Re-render the widget if a new factory has been added.
        toolbarRegistry.factoryAdded.connect(updateWidget);
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
            toolbarRegistry.factoryAdded.disconnect(updateWidget);
        });
        return toolbar;
    };
}
/**
 * Set the toolbar items of a widget from a factory
 *
 * @param widget Widget with the toolbar to set
 * @param factory Toolbar items factory
 * @param toolbar Separated toolbar if widget is a raw widget
 */
function setToolbar(widget, factory, toolbar) {
    var _a;
    // @ts-expect-error Widget has no toolbar
    if (!widget.toolbar && !toolbar) {
        console.log(`Widget ${widget.id} has no 'toolbar' and no explicit toolbar was provided.`);
        return;
    }
    // @ts-expect-error Widget has no toolbar
    const toolbar_ = (_a = widget.toolbar) !== null && _a !== void 0 ? _a : toolbar;
    const items = factory(widget);
    if (Array.isArray(items)) {
        items.forEach(({ name, widget: item }) => {
            toolbar_.addItem(name, item);
        });
    }
    else {
        const updateToolbar = (list, changes) => {
            switch (changes.type) {
                case 'add':
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'move':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'remove':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    break;
                case 'set':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        const existingIndex = (0,dist_index_es6_js_.findIndex)(toolbar_.names(), name => item.name === name);
                        if (existingIndex >= 0) {
                            Array.from(toolbar_.children())[existingIndex].parent = null;
                        }
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'clear':
                    Array.from(toolbar_.children()).forEach(child => {
                        child.parent = null;
                    });
                    break;
            }
        };
        updateToolbar(items, {
            newIndex: 0,
            newValues: Array.from(items),
            oldIndex: 0,
            oldValues: [],
            type: 'add'
        });
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
        });
    }
}
//# sourceMappingURL=factory.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/windowresolver.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A concrete implementation of a window name resolver.
 */
class WindowResolver {
    /**
     * The resolved window name.
     *
     * #### Notes
     * If the `resolve` promise has not resolved, the behavior is undefined.
     */
    get name() {
        return this._name;
    }
    /**
     * Resolve a window name to use as a handle among shared resources.
     *
     * @param candidate - The potential window name being resolved.
     *
     * #### Notes
     * Typically, the name candidate should be a JupyterLab workspace name or
     * an empty string if there is no workspace.
     *
     * If the returned promise rejects, a window name cannot be resolved without
     * user intervention, which typically means navigation to a new URL.
     */
    resolve(candidate) {
        return windowresolver_Private.resolve(candidate).then(name => {
            this._name = name;
        });
    }
}
/*
 * A namespace for private module data.
 */
var windowresolver_Private;
(function (Private) {
    /**
     * The internal prefix for private local storage keys.
     */
    const PREFIX = '@jupyterlab/statedb:StateDB';
    /**
     * The local storage beacon key.
     */
    const BEACON = `${PREFIX}:beacon`;
    /**
     * The timeout (in ms) to wait for beacon responders.
     *
     * #### Notes
     * This value is a whole number between 200 and 500 in order to prevent
     * perfect timeout collisions between multiple simultaneously opening windows
     * that have the same URL. This is an edge case because multiple windows
     * should not ordinarily share the same URL, but it can be contrived.
     */
    const TIMEOUT = Math.floor(200 + Math.random() * 300);
    /**
     * The local storage window key.
     */
    const WINDOW = `${PREFIX}:window`;
    /**
     * Current beacon request
     *
     * #### Notes
     * We keep track of the current request so that we can ignore our own beacon
     * requests. This is to work around a bug in Safari, where Safari sometimes
     * triggers local storage events for changes made by the current tab. See
     * https://github.com/jupyterlab/jupyterlab/issues/6921#issuecomment-540817283
     * for more details.
     */
    let currentBeaconRequest = null;
    /**
     * A potential preferred default window name.
     */
    let candidate = null;
    /**
     * The window name promise.
     */
    const delegate = new dist_index_js_.PromiseDelegate();
    /**
     * The known window names.
     */
    const known = {};
    /**
     * The window name.
     */
    let name = null;
    /**
     * Whether the name resolution has completed.
     */
    let resolved = false;
    /**
     * Start the storage event handler.
     */
    function initialize() {
        // Listen to all storage events for beacons and window names.
        window.addEventListener('storage', (event) => {
            const { key, newValue } = event;
            // All the keys we care about have values.
            if (newValue === null) {
                return;
            }
            // If the beacon was fired, respond with a ping.
            if (key === BEACON &&
                newValue !== currentBeaconRequest &&
                candidate !== null) {
                ping(resolved ? name : candidate);
                return;
            }
            // If the window name is resolved, bail.
            if (resolved || key !== WINDOW) {
                return;
            }
            const reported = newValue.replace(/\-\d+$/, '');
            // Store the reported window name.
            known[reported] = null;
            // If a reported window name and candidate collide, reject the candidate.
            if (!candidate || candidate in known) {
                reject();
            }
        });
    }
    /**
     * Ping peers with payload.
     */
    function ping(payload) {
        if (payload === null) {
            return;
        }
        const { localStorage } = window;
        localStorage.setItem(WINDOW, `${payload}-${new Date().getTime()}`);
    }
    /**
     * Reject the candidate.
     */
    function reject() {
        resolved = true;
        currentBeaconRequest = null;
        delegate.reject(`Window name candidate "${candidate}" already exists`);
    }
    /**
     * Returns a promise that resolves with the window name used for restoration.
     */
    function resolve(potential) {
        if (resolved) {
            return delegate.promise;
        }
        // Set the local candidate.
        candidate = potential;
        if (candidate in known) {
            reject();
            return delegate.promise;
        }
        const { localStorage, setTimeout } = window;
        // Wait until other windows have reported before claiming the candidate.
        setTimeout(() => {
            if (resolved) {
                return;
            }
            // If the window name has not already been resolved, check one last time
            // to confirm it is not a duplicate before resolving.
            if (!candidate || candidate in known) {
                return reject();
            }
            resolved = true;
            currentBeaconRequest = null;
            delegate.resolve((name = candidate));
            ping(name);
        }, TIMEOUT);
        // Fire the beacon to collect other windows' names.
        currentBeaconRequest = `${Math.random()}-${new Date().getTime()}`;
        localStorage.setItem(BEACON, currentBeaconRequest);
        return delegate.promise;
    }
    Private.resolve = resolve;
    // Initialize the storage listener at runtime.
    (() => {
        initialize();
    })();
})(windowresolver_Private || (windowresolver_Private = {}));
//# sourceMappingURL=windowresolver.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module apputils
 */


/**
 * @deprecated since v4
 * These widgets are now in @jupyterlab/ui-components
 */






















// Merge Toolbar namespace to preserve API
/**
 * @deprecated since v4
 * This class is in @jupyterlab/ui-components
 */
class lib_Toolbar extends index_js_.Toolbar {
}
(function (Toolbar) {
    Toolbar.createInterruptButton = widget_Toolbar.createInterruptButton;
    Toolbar.createKernelNameItem = widget_Toolbar.createKernelNameItem;
    Toolbar.createKernelStatusItem = widget_Toolbar.createKernelStatusItem;
    Toolbar.createRestartButton = widget_Toolbar.createRestartButton;
    /**
     * @deprecated since v4
     * This helper function is in @jupyterlab/ui-components
     */
    Toolbar.createSpacerItem = index_js_.Toolbar.createSpacerItem;
})(lib_Toolbar || (lib_Toolbar = {}));
//# sourceMappingURL=index.js.map

},
4620(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(67842);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/apputils/style/base.css
var base = __webpack_require__(45224);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */







},
25312(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  AttachmentsResolver: () => (/* reexport */ AttachmentsResolver),
  AttachmentsModel: () => (/* reexport */ model_AttachmentsModel)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/observables/lib/index.js)
var index_js_ = __webpack_require__(81975);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/rendermime@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/rendermime/lib/index.js)
var lib_index_js_ = __webpack_require__(45922);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(16324);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/attachments/lib/model.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The default implementation of the IAttachmentsModel.
 */
class model_AttachmentsModel {
    /**
     * Construct a new observable outputs instance.
     */
    constructor(options) {
        var _a;
        this._map = new index_js_.ObservableMap();
        this._isDisposed = false;
        this._stateChanged = new index_es6_js_.Signal(this);
        this._changed = new index_es6_js_.Signal(this);
        this._serialized = null;
        this._changeGuard = false;
        this.contentFactory =
            (_a = options.contentFactory) !== null && _a !== void 0 ? _a : model_AttachmentsModel.defaultContentFactory;
        if (options.values) {
            for (const key of Object.keys(options.values)) {
                if (options.values[key] !== undefined) {
                    this.set(key, options.values[key]);
                }
            }
        }
        this._map.changed.connect(this._onMapChanged, this);
    }
    /**
     * A signal emitted when the model state changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * A signal emitted when the model changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * The keys of the attachments in the model.
     */
    get keys() {
        return this._map.keys();
    }
    /**
     * Get the length of the items in the model.
     */
    get length() {
        return this._map.keys().length;
    }
    /**
     * Test whether the model is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._map.dispose();
        index_es6_js_.Signal.clearData(this);
    }
    /**
     * Whether the specified key is set.
     */
    has(key) {
        return this._map.has(key);
    }
    /**
     * Get an item at the specified key.
     */
    get(key) {
        return this._map.get(key);
    }
    /**
     * Set the value at the specified key.
     */
    set(key, value) {
        // Normalize stream data.
        const item = this._createItem({ value });
        this._map.set(key, item);
    }
    /**
     * Remove the attachment whose name is the specified key
     */
    remove(key) {
        this._map.delete(key);
    }
    /**
     * Clear all of the attachments.
     */
    clear() {
        this._map.values().forEach((item) => {
            item.dispose();
        });
        this._map.clear();
    }
    /**
     * Deserialize the model from JSON.
     *
     * #### Notes
     * This will clear any existing data.
     */
    fromJSON(values) {
        this.clear();
        Object.keys(values).forEach(key => {
            if (values[key] !== undefined) {
                this.set(key, values[key]);
            }
        });
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        const ret = {};
        for (const key of this._map.keys()) {
            ret[key] = this._map.get(key).toJSON();
        }
        return ret;
    }
    /**
     * Create an attachment item and hook up its signals.
     */
    _createItem(options) {
        const factory = this.contentFactory;
        const item = factory.createAttachmentModel(options);
        item.changed.connect(this._onGenericChange, this);
        return item;
    }
    /**
     * Handle a change to the list.
     */
    _onMapChanged(sender, args) {
        if (this._serialized && !this._changeGuard) {
            this._changeGuard = true;
            this._serialized.set(this.toJSON());
            this._changeGuard = false;
        }
        this._changed.emit(args);
        this._stateChanged.emit(void 0);
    }
    /**
     * Handle a change to an item.
     */
    _onGenericChange() {
        this._stateChanged.emit(void 0);
    }
}
/**
 * The namespace for AttachmentsModel class statics.
 */
(function (AttachmentsModel) {
    /**
     * The default implementation of a `IAttachmentsModel.IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an attachment model.
         */
        createAttachmentModel(options) {
            return new lib_index_js_.AttachmentModel(options);
        }
    }
    AttachmentsModel.ContentFactory = ContentFactory;
    /**
     * The default attachment model factory.
     */
    AttachmentsModel.defaultContentFactory = new ContentFactory();
})(model_AttachmentsModel || (model_AttachmentsModel = {}));
/**
 * A resolver for cell attachments 'attachment:filename'.
 *
 * Will resolve to a data: url.
 */
class AttachmentsResolver {
    /**
     * Create an attachments resolver object.
     */
    constructor(options) {
        this._parent = options.parent || null;
        this._model = options.model;
    }
    /**
     * Resolve a relative url to a correct server path.
     */
    async resolveUrl(url, context) {
        if (this._parent && !url.startsWith('attachment:')) {
            return this._parent.resolveUrl(url, context);
        }
        return url;
    }
    /**
     * Get the download url of a given absolute server path.
     *
     * #### Notes
     * The returned URL may include a query parameter.
     */
    async getDownloadUrl(path) {
        if (this._parent && !path.startsWith('attachment:')) {
            return this._parent.getDownloadUrl(path);
        }
        // Return a data URL with the data of the url
        const key = path.slice('attachment:'.length);
        const attachment = this._model.get(key);
        if (attachment === undefined) {
            // Resolve with unprocessed path, to show as broken image
            return path;
        }
        const { data } = attachment;
        const mimeType = Object.keys(data)[0];
        // Only support known safe types:
        if (mimeType === undefined ||
            lib_index_js_.imageRendererFactory.mimeTypes.indexOf(mimeType) === -1) {
            throw new Error(`Cannot render unknown image mime type "${mimeType}".`);
        }
        const dataUrl = `data:${mimeType};base64,${data[mimeType]}`;
        return dataUrl;
    }
    /**
     * Whether the URL should be handled by the resolver
     * or not.
     */
    isLocal(url) {
        var _a, _b, _c;
        if (this._parent && !url.startsWith('attachment:')) {
            return (_c = (_b = (_a = this._parent).isLocal) === null || _b === void 0 ? void 0 : _b.call(_a, url)) !== null && _c !== void 0 ? _c : true;
        }
        return true;
    }
}
//# sourceMappingURL=model.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/attachments/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module attachments
 */

//# sourceMappingURL=index.js.map

},
89346(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
__webpack_require__.r(__webpack_exports__);
__webpack_require__.d(__webpack_exports__, {
  AudioDocumentWidget: () => (AudioDocumentWidget),
  AudioViewer: () => (AudioViewer),
  AudioViewerFactory: () => (AudioViewerFactory),
  "default": () => (__rspack_default_export)
});
/* import */ var _jupyterlab_application__rspack_import_0 = __webpack_require__(11158);
/* import */ var _jupyterlab_application__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__rspack_import_0);
/* import */ var _jupyterlab_apputils__rspack_import_1 = __webpack_require__(3877);
/* import */ var _jupyterlab_apputils__rspack_import_1_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__rspack_import_1);
/* import */ var _jupyterlab_docregistry__rspack_import_2 = __webpack_require__(33088);
/* import */ var _jupyterlab_docregistry__rspack_import_2_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__rspack_import_2);
/* import */ var _jupyterlab_services__rspack_import_3 = __webpack_require__(43775);
/* import */ var _jupyterlab_services__rspack_import_3_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__rspack_import_3);
/* import */ var _jupyterlab_translation__rspack_import_4 = __webpack_require__(53816);
/* import */ var _jupyterlab_translation__rspack_import_4_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__rspack_import_4);
/* import */ var _lumino_widgets__rspack_import_5 = __webpack_require__(34381);
/* import */ var _lumino_widgets__rspack_import_5_default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__rspack_import_5);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module audio-extension
 */






/**
 * The class name added to an audio viewer.
 */
const AUDIO_CLASS = 'jp-AudioViewer';
/**
 * The name of the factory that creates audio widgets.
 */
const FACTORY_AUDIO = 'AudioViewer';
/**
 * Content provider ID for audio streaming
 */
const AUDIO_CONTENT_PROVIDER_ID = 'audio-provider';
/**
 * Get audio file types from the document registry
 */
function getAudioFileTypes(docRegistry) {
    const audioFileTypes = [];
    // Iterate through all registered file types
    for (const fileType of docRegistry.fileTypes()) {
        // Check if it's an audio file type by checking the MIME types
        if (fileType.mimeTypes.some(mimeType => mimeType.startsWith('audio/'))) {
            audioFileTypes.push(fileType.name);
        }
    }
    return audioFileTypes;
}
/**
 * An audio viewer widget.
 */
class AudioViewer extends _lumino_widgets__rspack_import_5.Widget {
    /**
     * Construct a new audio viewer widget.
     */
    constructor(options) {
        super();
        this.addClass(AUDIO_CLASS);
        this._context = options.context;
        this._contentsManager = options.contentsManager;
        // Create the audio element
        this._audio = document.createElement('audio');
        this._audio.controls = true;
        this.node.appendChild(this._audio);
        // Load audio when context is ready
        void this._context.ready.then(() => {
            void this._updateAudio();
        });
        // Listen for context model changes
        this._context.model.contentChanged.connect(this._updateAudio, this);
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
    }
    /**
     * Handle `resize` messages for the widget.
     */
    onResize(msg) {
        super.onResize(msg);
        if (this._audio) {
            this._audio.style.width = '100%';
        }
    }
    /**
     * Update the audio source.
     */
    async _updateAudio() {
        // Use getDownloadUrl for proper URL encoding and security tokens
        const audioUrl = await this._contentsManager.getDownloadUrl(this._context.path);
        this._audio.src = audioUrl;
    }
}
/**
 * A document widget for audio.
 */
class AudioDocumentWidget extends _jupyterlab_docregistry__rspack_import_2.DocumentWidget {
    constructor(options) {
        super(options);
    }
}
/**
 * A widget factory for audio viewers.
 */
class AudioViewerFactory extends _jupyterlab_docregistry__rspack_import_2.ABCWidgetFactory {
    /**
     * Construct a new audio viewer factory.
     */
    constructor(options) {
        super(options);
        this._contentsManager = options.contentsManager;
    }
    /**
     * Create a new widget given a context.
     */
    createNewWidget(context) {
        const content = new AudioViewer({
            context,
            contentsManager: this._contentsManager
        });
        const widget = new AudioDocumentWidget({
            content,
            context
        });
        return widget;
    }
}
/**
 * A content provider for audio files.
 *
 * This overrides the default behavior of the RestContentProvider to not include the file content.
 */
class AudioContentProvider extends _jupyterlab_services__rspack_import_3.RestContentProvider {
    constructor(options) {
        super(options);
    }
    /**
     * Get a file or directory.
     *
     * @param localPath - The path to the file.
     * @param options - The options used to fetch the file.
     *
     * @returns A promise which resolves with the file content.
     */
    async get(localPath, options) {
        return super.get(localPath, { ...options, content: false });
    }
}
/**
 * The audio extension.
 */
const plugin = {
    id: '@jupyterlab/audio-extension:plugin',
    description: 'Adds a viewer for audio files',
    autoStart: true,
    requires: [_jupyterlab_translation__rspack_import_4.ITranslator, _jupyterlab_services__rspack_import_3.IDefaultDrive],
    optional: [_jupyterlab_application__rspack_import_0.ILayoutRestorer],
    activate: (app, translator, defaultDrive, restorer) => {
        const trans = translator.load('jupyterlab');
        const { contents, serverSettings } = app.serviceManager;
        // Get audio file types from the document registry
        const audioFileTypes = getAudioFileTypes(app.docRegistry);
        // Register the audio stream content provider once
        const registry = defaultDrive.contentProviderRegistry;
        if (registry) {
            const audioContentProvider = new AudioContentProvider({
                apiEndpoint: '/api/contents',
                serverSettings
            });
            registry.register(AUDIO_CONTENT_PROVIDER_ID, audioContentProvider);
        }
        // Create tracker for all audio widgets
        const tracker = new _jupyterlab_apputils__rspack_import_1.WidgetTracker({
            namespace: 'audioviewer'
        });
        // Create single factory for all audio types
        const factory = new AudioViewerFactory({
            name: FACTORY_AUDIO,
            label: trans.__('Audio Viewer'),
            fileTypes: audioFileTypes,
            defaultFor: audioFileTypes,
            readOnly: true,
            translator,
            modelName: 'base64',
            contentProviderId: AUDIO_CONTENT_PROVIDER_ID,
            contentsManager: contents
        });
        app.docRegistry.addWidgetFactory(factory);
        factory.widgetCreated.connect(async (sender, widget) => {
            // Track the widget
            void tracker.add(widget);
            // Notify the widget tracker if restore data needs to update
            widget.context.pathChanged.connect(() => {
                void tracker.save(widget);
            });
            // Set appropriate icon based on file type from document registry
            const fileTypes = app.docRegistry.getFileTypesForPath(widget.context.path);
            const audioFileType = fileTypes.find(ft => ft.mimeTypes.some(mimeType => mimeType.startsWith('audio/')));
            if (audioFileType) {
                widget.title.icon = audioFileType.icon;
                widget.title.iconClass = audioFileType.iconClass || '';
                widget.title.iconLabel = audioFileType.iconLabel || '';
            }
        });
        if (restorer) {
            // Handle state restoration for all audio types
            void restorer.restore(tracker, {
                command: 'docmanager:open',
                args: widget => ({
                    path: widget.context.path,
                    factory: FACTORY_AUDIO
                }),
                name: widget => widget.context.path
            });
        }
    }
};
/**
 * Export the plugin as default.
 */
/* export default */ const __rspack_default_export = (plugin);
//# sourceMappingURL=index.js.map

},
79341(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(59372);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(14546);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/audio-extension/style/base.css
var base = __webpack_require__(79280);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/audio-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/audio-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */








},
87722(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
__webpack_require__.r(__webpack_exports__);
__webpack_require__.d(__webpack_exports__, {
  "default": () => (__rspack_default_export)
});
/* import */ var _jupyterlab_settingregistry__rspack_import_0 = __webpack_require__(19352);
/* import */ var _jupyterlab_settingregistry__rspack_import_0_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__rspack_import_0);
/* import */ var _jupyterlab_cell_toolbar__rspack_import_1 = __webpack_require__(42590);
/* import */ var _jupyterlab_cell_toolbar__rspack_import_1_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_cell_toolbar__rspack_import_1);
/* import */ var _jupyterlab_apputils__rspack_import_2 = __webpack_require__(3877);
/* import */ var _jupyterlab_apputils__rspack_import_2_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__rspack_import_2);
/* import */ var _jupyterlab_translation__rspack_import_3 = __webpack_require__(53816);
/* import */ var _jupyterlab_translation__rspack_import_3_default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__rspack_import_3);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module cell-toolbar-extension
 */




const PLUGIN_ID = '@jupyterlab/cell-toolbar-extension:plugin';
const cellToolbar = {
    id: PLUGIN_ID,
    description: 'Add the cells toolbar.',
    autoStart: true,
    activate: async (app, settingRegistry, toolbarRegistry, translator) => {
        /**
         * Load the settings for this extension
         *
         * @param setting Extension settings
         */
        function loadSetting(setting) {
            // Read the setting and convert to the correct type
            const showCellToolbar = setting === null
                ? true
                : setting.get('showToolbar').composite;
            extension.enabled = showCellToolbar;
        }
        const toolbarItems = settingRegistry && toolbarRegistry
            ? (0,_jupyterlab_apputils__rspack_import_2.createToolbarFactory)(toolbarRegistry, settingRegistry, _jupyterlab_cell_toolbar__rspack_import_1.CellBarExtension.FACTORY_NAME, cellToolbar.id, translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__rspack_import_3.nullTranslator)
            : undefined;
        const extension = new _jupyterlab_cell_toolbar__rspack_import_1.CellBarExtension(app.commands, toolbarItems);
        // Wait for the application to be restored and
        // for the settings for this plugin to be loaded
        if (settingRegistry !== null) {
            void Promise.all([app.restored, settingRegistry.load(PLUGIN_ID)]).then(([, setting]) => {
                // Read the settings
                loadSetting(setting);
                // Listen for your plugin setting changes using Signal
                setting.changed.connect(loadSetting);
            });
        }
        app.docRegistry.addWidgetExtension('Notebook', extension);
    },
    optional: [_jupyterlab_settingregistry__rspack_import_0.ISettingRegistry, _jupyterlab_apputils__rspack_import_2.IToolbarWidgetRegistry, _jupyterlab_translation__rspack_import_3.ITranslator]
};
/* export default */ const __rspack_default_export = (cellToolbar);
//# sourceMappingURL=index.js.map

},
8251(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(14546);
// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var widgets_style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(59372);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/cells/style/index.js + 2 modules
var cells_style = __webpack_require__(72600);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/notebook/style/index.js + 1 modules
var notebook_style = __webpack_require__(78320);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/cell-toolbar/style/base.css
var base = __webpack_require__(14454);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cell-toolbar/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cell-toolbar/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */









;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cell-toolbar-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */





},
2810(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  CellToolbarTracker: () => (/* reexport */ CellToolbarTracker),
  CellBarExtension: () => (/* reexport */ CellBarExtension)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var index_js_ = __webpack_require__(3877);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/observables/lib/index.js)
var lib_index_js_ = __webpack_require__(81975);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(16324);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cell-toolbar/lib/celltoolbartracker.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/






/*
 * Text mime types
 */
const TEXT_MIME_TYPES = [
    'text/plain',
    'application/vnd.jupyter.stdout',
    'application/vnd.jupyter.stderr'
];
/**
 * Widget cell toolbar classes
 */
const CELL_TOOLBAR_CLASS = 'jp-cell-toolbar';
// @deprecated to be removed
const CELL_MENU_CLASS = 'jp-cell-menu';
/**
 * Class for a cell whose contents overlap with the cell toolbar
 */
const TOOLBAR_OVERLAP_CLASS = 'jp-toolbar-overlap';
/**
 * Watch a notebook so that a cell toolbar appears on the active cell
 */
class CellToolbarTracker {
    /**
     * CellToolbarTracker constructor
     *
     * @param panel The notebook panel
     * @param toolbar The toolbar; deprecated use {@link toolbarFactory} instead
     * @param toolbarFactory The toolbar factory
     */
    constructor(panel, toolbar, toolbarFactory, translator) {
        this._isDisposed = false;
        this._toolbar = null;
        this._toolbarItems = null;
        this._toolbarFactory = null;
        this._panel = panel;
        this._previousActiveCell = this._panel.content.activeCell;
        this._toolbarItems = toolbar !== null && toolbar !== void 0 ? toolbar : null;
        this._toolbarFactory = toolbarFactory !== null && toolbarFactory !== void 0 ? toolbarFactory : null;
        this._enabled = true; // If this has been set to false, it will be modified after settings are available
        this._trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        if (this._toolbarItems === null && this._toolbarFactory === null) {
            throw Error('You must provide the toolbarFactory or the toolbar items.');
        }
        // deprecated to be removed when we remove toolbar from input arguments
        if (!this._toolbarFactory && this._toolbarItems) {
            this._onToolbarChanged();
            this._toolbarItems.changed.connect(this._onToolbarChanged, this);
        }
        // Only add the toolbar to the notebook's active cell (if any) once it has fully rendered and been revealed.
        void panel.revealed.then(() => {
            requestAnimationFrame(() => {
                const notebook = panel.content;
                this._onActiveCellChanged(notebook);
                // Handle subsequent changes of active cell.
                notebook.activeCellChanged.connect(this._onActiveCellChanged, this);
                // Check whether the toolbar should be rendered upon a layout change
                notebook.renderingLayoutChanged.connect(this._onActiveCellChanged, this);
                notebook.disposed.connect(() => {
                    notebook.activeCellChanged.disconnect(this._onActiveCellChanged);
                });
            });
        });
    }
    /**
     * @deprecated Will become protected in JupyterLab 5
     */
    _onMetadataChanged(model, args) {
        if (args.key === 'jupyter') {
            if (typeof args.newValue === 'object' &&
                args.newValue.source_hidden === true &&
                (args.type === 'add' || args.type === 'change')) {
                // Cell just became hidden; remove toolbar
                this._removeToolbar(model);
            }
            // Check whether input visibility changed
            else if (typeof args.oldValue === 'object' &&
                args.oldValue.source_hidden === true) {
                // Cell just became visible; add toolbar
                this._addToolbar(model);
            }
        }
    }
    /**
     * @deprecated Will become protected in JupyterLab 5
     */
    _onActiveCellChanged(notebook) {
        if (this._previousActiveCell && !this._previousActiveCell.isDisposed) {
            // Disposed cells do not have a model anymore.
            this._removeToolbar(this._previousActiveCell.model);
            this._previousActiveCell.model.metadataChanged.disconnect(this._onMetadataChanged);
        }
        const activeCell = notebook.activeCell;
        // Change previously active cell.
        this._previousActiveCell = activeCell;
        if (activeCell === null || activeCell.inputHidden) {
            return;
        }
        activeCell.model.metadataChanged.connect(this._onMetadataChanged, this);
        this._addToolbar(activeCell.model);
    }
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Whether the cell toolbar is shown, if there is enough room
     */
    get enabled() {
        return this._enabled;
    }
    /**
     * Sets whether the cell toolbar is shown, if there is enough room
     */
    set enabled(value) {
        this._enabled = value;
        this._onToolbarChanged();
    }
    dispose() {
        var _a, _b;
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        (_a = this._toolbarItems) === null || _a === void 0 ? void 0 : _a.changed.disconnect(this._onToolbarChanged, this);
        (_b = this._toolbar) === null || _b === void 0 ? void 0 : _b.dispose();
        this._panel = null;
        dist_index_es6_js_.Signal.clearData(this);
    }
    _addToolbar(model) {
        // Do nothing if the toolbar shouldn't be visible.
        if (!this.enabled) {
            return;
        }
        const cell = this._getCell(model);
        if (cell && !cell.isDisposed) {
            const toolbarWidget = (this._toolbar = new ui_components_lib_index_js_.Toolbar());
            // Note: CELL_MENU_CLASS is deprecated.
            toolbarWidget.addClass(CELL_MENU_CLASS);
            toolbarWidget.addClass(CELL_TOOLBAR_CLASS);
            toolbarWidget.node.setAttribute('aria-label', this._trans.__('Cell toolbar'));
            const promises = [cell.ready];
            if (this._toolbarFactory) {
                // Use our custom factory directly instead of setToolbar
                const toolbarItems = this._toolbarFactory(cell);
                for (const { name, widget } of toolbarItems) {
                    toolbarWidget.addItem(name, widget);
                    if (widget instanceof ui_components_lib_index_js_.ReactWidget &&
                        widget.renderPromise !== undefined) {
                        widget.update();
                        promises.push(widget.renderPromise);
                    }
                }
            }
            else {
                for (const { name, widget } of this._toolbarItems) {
                    toolbarWidget.addItem(name, widget);
                    if (widget instanceof ui_components_lib_index_js_.ReactWidget &&
                        widget.renderPromise !== undefined) {
                        widget.update();
                        promises.push(widget.renderPromise);
                    }
                }
            }
            promises.push(cell.ready);
            // Wait for all the buttons to be rendered before attaching the toolbar.
            Promise.all(promises)
                .then(() => {
                var _a;
                if (cell.isDisposed || ((_a = this._panel) === null || _a === void 0 ? void 0 : _a.content.activeCell) !== cell) {
                    toolbarWidget.dispose();
                    return;
                }
                // Hide the toolbar by default, to avoid temporary overlapping.
                cell.node.classList.add(TOOLBAR_OVERLAP_CLASS);
                cell.inputArea.layout.insertWidget(0, toolbarWidget);
                // For rendered markdown, watch for resize events.
                cell.displayChanged.connect(this._resizeEventCallback, this);
                // Watch for changes in the cell's contents.
                cell.model.contentChanged.connect(this._changedEventCallback, this);
                // Hide the cell toolbar if it overlaps with cell contents
                this._updateCellForToolbarOverlap(cell);
            })
                .catch(e => {
                console.error('Error rendering buttons of the cell toolbar: ', e);
            });
        }
    }
    _getCell(model) {
        var _a;
        return (_a = this._panel) === null || _a === void 0 ? void 0 : _a.content.widgets.find(widget => widget.model === model);
    }
    _removeToolbar(model) {
        var _a, _b;
        const cell = this._getCell(model);
        if (cell && !cell.isDisposed) {
            // Attempt to remove the resize and changed event handlers.
            cell.displayChanged.disconnect(this._resizeEventCallback, this);
        }
        model.contentChanged.disconnect(this._changedEventCallback, this);
        if (((_a = this._toolbar) === null || _a === void 0 ? void 0 : _a.parent) === (cell === null || cell === void 0 ? void 0 : cell.inputArea) &&
            ((_b = this._toolbar) === null || _b === void 0 ? void 0 : _b.isDisposed) === false) {
            this._toolbar.dispose();
        }
    }
    /**
     * Call back on settings changes
     *
     * @deprecated To remove when toolbar can not be provided directly to the tracker
     */
    _onToolbarChanged() {
        var _a;
        // Reset toolbar when settings changes
        const activeCell = (_a = this._panel) === null || _a === void 0 ? void 0 : _a.content.activeCell;
        if (activeCell) {
            this._removeToolbar(activeCell.model);
            this._addToolbar(activeCell.model);
        }
    }
    _changedEventCallback() {
        var _a;
        const activeCell = (_a = this._panel) === null || _a === void 0 ? void 0 : _a.content.activeCell;
        if (activeCell === null || activeCell === undefined) {
            return;
        }
        this._updateCellForToolbarOverlap(activeCell);
    }
    _resizeEventCallback() {
        var _a;
        const activeCell = (_a = this._panel) === null || _a === void 0 ? void 0 : _a.content.activeCell;
        if (activeCell === null || activeCell === undefined) {
            return;
        }
        this._updateCellForToolbarOverlap(activeCell);
    }
    _updateCellForToolbarOverlap(activeCell) {
        // When we do change in cell, the browser might not have completed the layout
        // update if we don't wait, resulting in the previous width being returned
        // using `getBoundingClientRect().width` in later functions. This also wait for
        // the toolbar to be rendered the first time (on page reload), allowing us to
        // retrieve the right widgets width.
        requestIdleCallback(() => {
            // Remove the "toolbar overlap" class from the cell, rendering the cell's toolbar
            const activeCellElement = activeCell.node;
            activeCellElement.classList.remove(TOOLBAR_OVERLAP_CLASS);
            if (this._cellToolbarOverlapsContents(activeCell)) {
                // Add the "toolbar overlap" class to the cell, completely concealing the toolbar,
                // if the first line of the content overlaps with it at all
                activeCellElement.classList.add(TOOLBAR_OVERLAP_CLASS);
            }
        });
    }
    _cellToolbarOverlapsContents(activeCell) {
        var _a, _b, _c, _d;
        // Fail safe when the active cell is not ready yet
        if (!activeCell.model) {
            return false;
        }
        const cellType = activeCell.model.type;
        // If the toolbar is too large for the current cell, hide it.
        const editorRect = (_a = activeCell.editorWidget) === null || _a === void 0 ? void 0 : _a.node.getBoundingClientRect();
        const cellLeft = (_b = editorRect === null || editorRect === void 0 ? void 0 : editorRect.left) !== null && _b !== void 0 ? _b : 0;
        const cellRight = (_c = editorRect === null || editorRect === void 0 ? void 0 : editorRect.right) !== null && _c !== void 0 ? _c : 0;
        const toolbarLeft = this._cellToolbarLeft(activeCell);
        if (toolbarLeft === null) {
            return false;
        }
        // The toolbar should not take up more than 50% of the cell.
        if ((cellLeft + cellRight) / 2 > toolbarLeft) {
            return true;
        }
        if (cellType === 'markdown' && activeCell.rendered) {
            // Check for overlap in rendered markdown content
            return this._markdownOverlapsToolbar(activeCell);
        }
        // Check for overlap in code content
        if (((_d = this._panel) === null || _d === void 0 ? void 0 : _d.content.renderingLayout) === 'default') {
            return this._codeOverlapsToolbar(activeCell);
        }
        else {
            return this._outputOverlapsToolbar(activeCell);
        }
    }
    /**
     * Check for overlap between rendered Markdown and the cell toolbar
     *
     * @param activeCell A rendered MarkdownCell
     * @returns `true` if the first line of the output overlaps with the cell toolbar, `false` otherwise
     */
    _markdownOverlapsToolbar(activeCell) {
        const markdownOutput = activeCell.inputArea; // Rendered markdown appears in the input area
        if (!markdownOutput) {
            return false;
        }
        // Get the rendered markdown as a widget.
        const markdownOutputWidget = markdownOutput.renderedInput;
        const markdownOutputElement = markdownOutputWidget.node;
        const firstOutputElementChild = markdownOutputElement.firstElementChild;
        if (firstOutputElementChild === null) {
            return false;
        }
        // Temporarily set the element's max width so that the bounding client rectangle only encompasses the content.
        const oldMaxWidth = firstOutputElementChild.style.maxWidth;
        firstOutputElementChild.style.maxWidth = 'max-content';
        const lineRight = firstOutputElementChild.getBoundingClientRect().right;
        // Reinstate the old max width.
        firstOutputElementChild.style.maxWidth = oldMaxWidth;
        const toolbarLeft = this._cellToolbarLeft(activeCell);
        return toolbarLeft === null ? false : lineRight > toolbarLeft;
    }
    _outputOverlapsToolbar(activeCell) {
        const outputArea = activeCell.outputArea.node;
        if (outputArea) {
            const outputs = outputArea.querySelectorAll('[data-mime-type]');
            const toolbarRect = this._cellToolbarRect(activeCell);
            if (toolbarRect) {
                const { left: toolbarLeft, bottom: toolbarBottom } = toolbarRect;
                return (0,index_es6_js_.some)(outputs, output => {
                    const node = output.firstElementChild;
                    if (node) {
                        const range = new Range();
                        if (TEXT_MIME_TYPES.includes(output.getAttribute('data-mime-type') || '')) {
                            // If the node is plain text, it's in a <pre>. To get the true bounding box of the
                            // text, the node contents need to be selected.
                            range.selectNodeContents(node);
                        }
                        else {
                            range.selectNode(node);
                        }
                        const { right: nodeRight, top: nodeTop } = range.getBoundingClientRect();
                        // Note: y-coordinate increases toward the bottom of page
                        return nodeRight > toolbarLeft && nodeTop < toolbarBottom;
                    }
                    return false;
                });
            }
        }
        return false;
    }
    _codeOverlapsToolbar(activeCell) {
        const editorWidget = activeCell.editorWidget;
        const editor = activeCell.editor;
        if (!editorWidget || !editor) {
            return false;
        }
        if (editor.lineCount < 1) {
            return false; // Nothing in the editor
        }
        const codeMirrorLines = editorWidget.node.getElementsByClassName('cm-line');
        if (codeMirrorLines.length < 1) {
            return false; // No lines present
        }
        let lineRight = codeMirrorLines[0].getBoundingClientRect().left;
        const range = document.createRange();
        range.selectNodeContents(codeMirrorLines[0]);
        lineRight += range.getBoundingClientRect().width;
        const toolbarLeft = this._cellToolbarLeft(activeCell);
        return toolbarLeft === null ? false : lineRight > toolbarLeft;
    }
    _cellToolbarRect(activeCell) {
        var _a;
        if (((_a = this._toolbar) === null || _a === void 0 ? void 0 : _a.parent) !== activeCell.inputArea) {
            return null;
        }
        const activeCellToolbar = this._toolbar.node;
        return activeCellToolbar.getBoundingClientRect();
    }
    _cellToolbarLeft(activeCell) {
        var _a;
        return ((_a = this._cellToolbarRect(activeCell)) === null || _a === void 0 ? void 0 : _a.left) || null;
    }
}
const defaultToolbarItems = [
    {
        command: 'notebook:duplicate-below',
        name: 'duplicate-cell'
    },
    {
        command: 'notebook:move-cell-up',
        name: 'move-cell-up'
    },
    {
        command: 'notebook:move-cell-down',
        name: 'move-cell-down'
    },
    {
        command: 'notebook:insert-cell-above',
        name: 'insert-cell-above'
    },
    {
        command: 'notebook:insert-cell-below',
        name: 'insert-cell-below'
    },
    {
        command: 'notebook:delete-cell',
        name: 'delete-cell'
    }
];
/**
 * Widget extension that creates a CellToolbarTracker each time a notebook is
 * created.
 */
class CellBarExtension {
    constructor(commands, toolbarFactory) {
        this._commands = commands;
        this._toolbarFactory = toolbarFactory !== null && toolbarFactory !== void 0 ? toolbarFactory : this.defaultToolbarFactory;
    }
    createItemFactory(commands) {
        return (0,index_js_.createDefaultFactory)(commands);
    }
    get defaultToolbarFactory() {
        const itemFactory = this.createItemFactory(this._commands);
        return (widget, commandArgs) => new lib_index_js_.ObservableList({
            values: defaultToolbarItems.map(item => {
                const itemWithArgs = commandArgs
                    ? {
                        ...item,
                        args: { ...item.args, ...commandArgs }
                    }
                    : item;
                return {
                    name: item.name,
                    widget: itemFactory(CellBarExtension.FACTORY_NAME, widget, itemWithArgs)
                };
            })
        });
    }
    createNew(panel) {
        // Create a factory that passes the widget ID to the toolbar factory
        const factoryWithWidgetId = (widget) => {
            return this._toolbarFactory(widget, {
                [CellBarExtension.WIDGET_ID_ARG]: panel.id
            });
        };
        return (this._tracker = new CellToolbarTracker(panel, undefined, factoryWithWidgetId));
    }
    /**
     * Whether the cell toolbar is displayed, if there is enough room for it
     */
    get enabled() {
        return this._tracker.enabled;
    }
    /**
     * Sets whether the cell toolbar is displayed, if there is enough room for it
     */
    set enabled(value) {
        if (this._tracker) {
            this._tracker.enabled = value;
        }
    }
}
CellBarExtension.FACTORY_NAME = 'Cell';
CellBarExtension.WIDGET_ID_ARG = 'widgetId';
//# sourceMappingURL=celltoolbartracker.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cell-toolbar/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module cell-toolbar
 */

//# sourceMappingURL=index.js.map

},
20072(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  isRawCellModel: () => (/* reexport */ isRawCellModel),
  OutputCollapser: () => (/* reexport */ OutputCollapser),
  Placeholder: () => (/* reexport */ Placeholder),
  RawCellModel: () => (/* reexport */ RawCellModel),
  CellFooter: () => (/* reexport */ CellFooter),
  CodeCell: () => (/* reexport */ widget_CodeCell),
  InputArea: () => (/* reexport */ inputarea_InputArea),
  CellDragUtils: () => (/* reexport */ celldragutils_CellDragUtils),
  AttachmentsCell: () => (/* reexport */ AttachmentsCell),
  createCellSearchProvider: () => (/* reexport */ createCellSearchProvider),
  CellHeader: () => (/* reexport */ CellHeader),
  CellSearchProvider: () => (/* reexport */ CellSearchProvider),
  Cell: () => (/* reexport */ widget_Cell),
  CellModel: () => (/* reexport */ CellModel),
  isCodeCellModel: () => (/* reexport */ isCodeCellModel),
  AttachmentsCellModel: () => (/* reexport */ model_AttachmentsCellModel),
  InputCollapser: () => (/* reexport */ InputCollapser),
  MarkdownCell: () => (/* reexport */ widget_MarkdownCell),
  RawCell: () => (/* reexport */ RawCell),
  Collapser: () => (/* reexport */ Collapser),
  MarkdownCellModel: () => (/* reexport */ MarkdownCellModel),
  SELECTED_HIGHLIGHT_CLASS: () => (/* reexport */ SELECTED_HIGHLIGHT_CLASS),
  CodeCellLayout: () => (/* reexport */ CodeCellLayout),
  InputPrompt: () => (/* reexport */ InputPrompt),
  OutputPlaceholder: () => (/* reexport */ OutputPlaceholder),
  isMarkdownCellModel: () => (/* reexport */ isMarkdownCellModel),
  CodeCellModel: () => (/* reexport */ model_CodeCellModel),
  InputPlaceholder: () => (/* reexport */ InputPlaceholder)
});

// EXTERNAL MODULE: consume shared module (default) @lumino/virtualdom@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/virtualdom/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(22778);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/celldragutils.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * Constants for drag
 */
/**
 * The threshold in pixels to start a drag event.
 */
const DRAG_THRESHOLD = 5;
/**
 * The class name added to drag images.
 */
const DRAG_IMAGE_CLASS = 'jp-dragImage';
/**
 * The class name added to singular drag images
 */
const SINGLE_DRAG_IMAGE_CLASS = 'jp-dragImage-singlePrompt';
/**
 * The class name added to the drag image cell content.
 */
const CELL_DRAG_CONTENT_CLASS = 'jp-dragImage-content';
/**
 * The class name added to the drag image cell content.
 */
const CELL_DRAG_PROMPT_CLASS = 'jp-dragImage-prompt';
/**
 * The class name added to the drag image cell content.
 */
const CELL_DRAG_MULTIPLE_BACK = 'jp-dragImage-multipleBack';
var celldragutils_CellDragUtils;
(function (CellDragUtils) {
    /**
     * Find the cell index containing the target html element.
     * This function traces up the DOM hierarchy to find the root cell
     * node. Then find the corresponding child and select it.
     *
     * @param node - the cell node or a child of the cell node.
     * @param cells - an iterable of Cells
     * @param isCellNode - a function that takes in a node and checks if
     * it is a cell node.
     *
     * @returns index of the cell we're looking for. Returns -1 if
     * the cell is not founds
     */
    function findCell(node, cells, isCellNode) {
        let cellIndex = -1;
        while (node && node.parentElement) {
            if (isCellNode(node)) {
                let index = -1;
                for (const cell of cells) {
                    if (cell.node === node) {
                        cellIndex = ++index;
                        break;
                    }
                }
                break;
            }
            node = node.parentElement;
        }
        return cellIndex;
    }
    CellDragUtils.findCell = findCell;
    /**
     * Detect which part of the cell triggered the MouseEvent
     *
     * @param cell - The cell which contains the MouseEvent's target
     * @param target - The DOM node which triggered the MouseEvent
     */
    function detectTargetArea(cell, target) {
        var _a, _b;
        let targetArea;
        if (cell) {
            if ((_a = cell.editorWidget) === null || _a === void 0 ? void 0 : _a.node.contains(target)) {
                targetArea = 'input';
            }
            else if ((_b = cell.promptNode) === null || _b === void 0 ? void 0 : _b.contains(target)) {
                targetArea = 'prompt';
            }
            else {
                targetArea = 'cell';
            }
        }
        else {
            targetArea = 'unknown';
        }
        return targetArea;
    }
    CellDragUtils.detectTargetArea = detectTargetArea;
    /**
     * Detect if a drag event should be started. This is down if the
     * mouse is moved beyond a certain distance (DRAG_THRESHOLD).
     *
     * @param prevX - X Coordinate of the mouse pointer during the mousedown event
     * @param prevY - Y Coordinate of the mouse pointer during the mousedown event
     * @param nextX - Current X Coordinate of the mouse pointer
     * @param nextY - Current Y Coordinate of the mouse pointer
     */
    function shouldStartDrag(prevX, prevY, nextX, nextY) {
        const dx = Math.abs(nextX - prevX);
        const dy = Math.abs(nextY - prevY);
        return dx >= DRAG_THRESHOLD || dy >= DRAG_THRESHOLD;
    }
    CellDragUtils.shouldStartDrag = shouldStartDrag;
    /**
     * Create an image for the cell(s) to be dragged
     *
     * @param activeCell - The cell from where the drag event is triggered
     * @param selectedCells - The cells to be dragged
     */
    function createCellDragImage(activeCell, selectedCells) {
        const count = selectedCells.length;
        let promptNumber;
        if (activeCell.model.type === 'code') {
            const executionCount = activeCell.model
                .executionCount;
            promptNumber = ' ';
            if (executionCount) {
                promptNumber = executionCount.toString();
            }
        }
        else {
            promptNumber = '';
        }
        const cellContent = activeCell.model.sharedModel
            .getSource()
            .split('\n')[0]
            .slice(0, 26);
        if (count > 1) {
            if (promptNumber !== '') {
                return index_es6_js_.VirtualDOM.realize(index_es6_js_.h.div(index_es6_js_.h.div({ className: DRAG_IMAGE_CLASS }, index_es6_js_.h.span({ className: CELL_DRAG_PROMPT_CLASS }, '[' + promptNumber + ']:'), index_es6_js_.h.span({ className: CELL_DRAG_CONTENT_CLASS }, cellContent)), index_es6_js_.h.div({ className: CELL_DRAG_MULTIPLE_BACK }, '')));
            }
            else {
                return index_es6_js_.VirtualDOM.realize(index_es6_js_.h.div(index_es6_js_.h.div({ className: DRAG_IMAGE_CLASS }, index_es6_js_.h.span({ className: CELL_DRAG_PROMPT_CLASS }), index_es6_js_.h.span({ className: CELL_DRAG_CONTENT_CLASS }, cellContent)), index_es6_js_.h.div({ className: CELL_DRAG_MULTIPLE_BACK }, '')));
            }
        }
        else {
            if (promptNumber !== '') {
                return index_es6_js_.VirtualDOM.realize(index_es6_js_.h.div(index_es6_js_.h.div({ className: `${DRAG_IMAGE_CLASS} ${SINGLE_DRAG_IMAGE_CLASS}` }, index_es6_js_.h.span({ className: CELL_DRAG_PROMPT_CLASS }, '[' + promptNumber + ']:'), index_es6_js_.h.span({ className: CELL_DRAG_CONTENT_CLASS }, cellContent))));
            }
            else {
                return index_es6_js_.VirtualDOM.realize(index_es6_js_.h.div(index_es6_js_.h.div({ className: `${DRAG_IMAGE_CLASS} ${SINGLE_DRAG_IMAGE_CLASS}` }, index_es6_js_.h.span({ className: CELL_DRAG_PROMPT_CLASS }), index_es6_js_.h.span({ className: CELL_DRAG_CONTENT_CLASS }, cellContent))));
            }
        }
    }
    CellDragUtils.createCellDragImage = createCellDragImage;
})(celldragutils_CellDragUtils || (celldragutils_CellDragUtils = {}));
//# sourceMappingURL=celldragutils.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/domutils@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/domutils/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(60930);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/collapser.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The CSS class added to all collapsers.
 */
const COLLAPSER_CLASS = 'jp-Collapser';
/**
 * The CSS class added to the collapser child.
 */
const COLLAPSER_CHILD_CLASS = 'jp-Collapser-child';
/**
 * The CSS class added to input collapsers.
 */
const INPUT_COLLAPSER = 'jp-InputCollapser';
/**
 * The CSS class added to output collapsers.
 */
const OUTPUT_COLLAPSER = 'jp-OutputCollapser';
/**
 * Abstract collapser base class.
 *
 * ### Notes
 * A collapser is a visible div to the left of a cell's
 * input/output that a user can click on to collapse the
 * input/output.
 */
class Collapser extends index_js_.ReactWidget {
    /**
     * Construct a new collapser.
     */
    constructor() {
        super();
        this.addClass(COLLAPSER_CLASS);
    }
    /**
     * Is the input/output of the parent collapsed.
     */
    get collapsed() {
        return false;
    }
    /**
     * Render the collapser with the virtual DOM.
     */
    render() {
        const childClass = COLLAPSER_CHILD_CLASS;
        return react_index_js_.createElement("div", { className: childClass, onClick: e => this.handleClick(e) });
    }
}
/**
 * A collapser subclass to collapse a cell's input area.
 */
class InputCollapser extends Collapser {
    /**
     * Construct a new input collapser.
     */
    constructor() {
        super();
        this.addClass(INPUT_COLLAPSER);
    }
    /**
     * Is the cell's input collapsed?
     */
    get collapsed() {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            return cell.inputHidden;
        }
        else {
            return false;
        }
    }
    /**
     * Handle a click event for the user to collapse the cell's input.
     */
    handleClick(e) {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            cell.inputHidden = !cell.inputHidden;
        }
        /* We need this until we watch the cell state */
        this.update();
    }
}
/**
 * A collapser subclass to collapse a cell's output area.
 */
class OutputCollapser extends Collapser {
    /**
     * Construct a new output collapser.
     */
    constructor() {
        super();
        this.addClass(OUTPUT_COLLAPSER);
    }
    /**
     * Is the cell's output collapsed?
     */
    get collapsed() {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            return cell.outputHidden;
        }
        else {
            return false;
        }
    }
    /**
     * Handle a click event for the user to collapse the cell's output.
     */
    handleClick(e) {
        var _a, _b;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            cell.outputHidden = !cell.outputHidden;
            /* Scroll cell into view after output collapse */
            if (cell.outputHidden) {
                let area = (_b = cell.parent) === null || _b === void 0 ? void 0 : _b.node;
                if (area) {
                    dist_index_es6_js_.ElementExt.scrollIntoViewIfNeeded(area, cell.node);
                }
            }
        }
        /* We need this until we watch the cell state */
        this.update();
    }
}
//# sourceMappingURL=collapser.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(34381);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/headerfooter.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The CSS class added to the cell header.
 */
const CELL_HEADER_CLASS = 'jp-CellHeader';
/**
 * The CSS class added to the cell footer.
 */
const CELL_FOOTER_CLASS = 'jp-CellFooter';
/**
 * Default implementation of a cell header.
 */
class CellHeader extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new cell header.
     */
    constructor() {
        super();
        this.addClass(CELL_HEADER_CLASS);
    }
}
/**
 * Default implementation of a cell footer.
 */
class CellFooter extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new cell footer.
     */
    constructor() {
        super();
        this.addClass(CELL_FOOTER_CLASS);
    }
}
//# sourceMappingURL=headerfooter.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/codeeditor@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/codeeditor/lib/index.js)
var lib_index_js_ = __webpack_require__(34390);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/inputarea.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The class name added to input area widgets.
 */
const INPUT_AREA_CLASS = 'jp-InputArea';
/**
 * The class name added to the prompt area of cell.
 */
const INPUT_AREA_PROMPT_CLASS = 'jp-InputArea-prompt';
/**
 * The class name added to OutputPrompt.
 */
const INPUT_PROMPT_CLASS = 'jp-InputPrompt';
/**
 * The class name added to the editor area of the cell.
 */
const INPUT_AREA_EDITOR_CLASS = 'jp-InputArea-editor';
/** ****************************************************************************
 * InputArea
 ******************************************************************************/
/**
 * An input area widget, which hosts a prompt and an editor widget.
 */
class inputarea_InputArea extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct an input area widget.
     */
    constructor(options) {
        super();
        this.addClass(INPUT_AREA_CLASS);
        const { contentFactory, editorOptions, model } = options;
        this.model = model;
        this.contentFactory = contentFactory;
        // Prompt
        const prompt = (this._prompt = contentFactory.createInputPrompt());
        prompt.addClass(INPUT_AREA_PROMPT_CLASS);
        // Editor
        const editor = (this._editor = new lib_index_js_.CodeEditorWrapper({
            factory: contentFactory.editorFactory,
            model,
            editorOptions
        }));
        editor.addClass(INPUT_AREA_EDITOR_CLASS);
        const layout = (this.layout = new widgets_dist_index_es6_js_.PanelLayout());
        layout.addWidget(prompt);
        layout.addWidget(editor);
    }
    /**
     * Get the CodeEditorWrapper used by the cell.
     */
    get editorWidget() {
        return this._editor;
    }
    /**
     * Get the CodeEditor used by the cell.
     */
    get editor() {
        return this._editor.editor;
    }
    /**
     * Get the prompt node used by the cell.
     */
    get promptNode() {
        return this._prompt.node;
    }
    /**
     * Get the rendered input area widget, if any.
     */
    get renderedInput() {
        return this._rendered;
    }
    /**
     * Render an input instead of the text editor.
     */
    renderInput(widget) {
        const layout = this.layout;
        if (this._rendered) {
            this._rendered.parent = null;
        }
        this._editor.hide();
        this._rendered = widget;
        layout.addWidget(widget);
    }
    /**
     * Show the text editor.
     */
    showEditor() {
        if (this._rendered) {
            this._rendered.parent = null;
        }
        this._editor.show();
    }
    /**
     * Set the prompt of the input area.
     */
    setPrompt(value) {
        this._prompt.executionCount = value;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        // Do nothing if already disposed.
        if (this.isDisposed) {
            return;
        }
        this._prompt = null;
        this._editor = null;
        this._rendered = null;
        super.dispose();
    }
}
/**
 * A namespace for `InputArea` statics.
 */
(function (InputArea) {
    /**
     * Default implementation of `IContentFactory`.
     *
     * This defaults to using an `editorFactory` based on CodeMirror.
     */
    class ContentFactory {
        /**
         * Construct a `ContentFactory`.
         */
        constructor(options) {
            this._editor = options.editorFactory;
        }
        /**
         * Return the `CodeEditor.Factory` being used.
         */
        get editorFactory() {
            return this._editor;
        }
        /**
         * Create an input prompt.
         */
        createInputPrompt() {
            return new InputPrompt();
        }
    }
    InputArea.ContentFactory = ContentFactory;
})(inputarea_InputArea || (inputarea_InputArea = {}));
/**
 * The default input prompt implementation.
 */
class InputPrompt extends widgets_dist_index_es6_js_.Widget {
    /*
     * Create an output prompt widget.
     */
    constructor() {
        super();
        this._executionCount = null;
        this.addClass(INPUT_PROMPT_CLASS);
    }
    /**
     * The execution count for the prompt.
     */
    get executionCount() {
        return this._executionCount;
    }
    set executionCount(value) {
        this._executionCount = value;
        if (value === null) {
            this.node.textContent = ' ';
        }
        else {
            this.node.textContent = `[${value || ' '}]:`;
        }
    }
}
//# sourceMappingURL=inputarea.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var signaling_dist_index_es6_js_ = __webpack_require__(16324);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/attachments@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/attachments/lib/index.js)
var attachments_lib_index_js_ = __webpack_require__(93822);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/outputarea@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/outputarea/lib/index.js)
var outputarea_lib_index_js_ = __webpack_require__(80070);
// EXTERNAL MODULE: consume shared module (default) @jupyter/ydoc@~3.1.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyter/ydoc/lib/index.js)
var ydoc_lib_index_js_ = __webpack_require__(67127);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/model.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/





const globalModelDBMutex = (0,ydoc_lib_index_js_.createMutex)();
function isCodeCellModel(model) {
    return model.type === 'code';
}
function isMarkdownCellModel(model) {
    return model.type === 'markdown';
}
function isRawCellModel(model) {
    return model.type === 'raw';
}
/**
 * An implementation of the cell model.
 */
class CellModel extends lib_index_js_.CodeEditor.Model {
    constructor(options = {}) {
        const { cell_type, sharedModel, ...others } = options;
        super({
            sharedModel: sharedModel !== null && sharedModel !== void 0 ? sharedModel : (0,ydoc_lib_index_js_.createStandaloneCell)({
                cell_type: cell_type !== null && cell_type !== void 0 ? cell_type : 'raw',
                id: options.id
            }),
            ...others
        });
        /**
         * A signal emitted when the state of the model changes.
         */
        this.contentChanged = new signaling_dist_index_es6_js_.Signal(this);
        /**
         * A signal emitted when a model state changes.
         */
        this.stateChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._metadataChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._trusted = false;
        this.standaloneModel = typeof options.sharedModel === 'undefined';
        this.trusted = !!this.getMetadata('trusted') || !!options.trusted;
        this.sharedModel.changed.connect(this.onGenericChange, this);
        this.sharedModel.metadataChanged.connect(this._onMetadataChanged, this);
    }
    /**
     * Signal emitted when cell metadata changes.
     */
    get metadataChanged() {
        return this._metadataChanged;
    }
    /**
     * The id for the cell.
     */
    get id() {
        return this.sharedModel.getId();
    }
    /**
     * The metadata associated with the cell.
     */
    get metadata() {
        return this.sharedModel.metadata;
    }
    /**
     * The trusted state of the model.
     */
    get trusted() {
        return this._trusted;
    }
    set trusted(newValue) {
        const oldValue = this.trusted;
        if (oldValue !== newValue) {
            this._trusted = newValue;
            this.onTrustedChanged(this, { newValue, oldValue });
        }
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.sharedModel.changed.disconnect(this.onGenericChange, this);
        this.sharedModel.metadataChanged.disconnect(this._onMetadataChanged, this);
        super.dispose();
    }
    /**
     * Handle a change to the trusted state.
     *
     * The default implementation is a no-op.
     */
    onTrustedChanged(trusted, args) {
        /* no-op */
    }
    /**
     * Delete a metadata
     *
     * @param key Metadata key
     */
    deleteMetadata(key) {
        return this.sharedModel.deleteMetadata(key);
    }
    /**
     * Get a metadata
     *
     * ### Notes
     * This returns a copy of the key value.
     *
     * @param key Metadata key
     */
    getMetadata(key) {
        return this.sharedModel.getMetadata(key);
    }
    /**
     * Set a metadata
     *
     * @param key Metadata key
     * @param value Metadata value
     */
    setMetadata(key, value) {
        if (typeof value === 'undefined') {
            this.sharedModel.deleteMetadata(key);
        }
        else {
            this.sharedModel.setMetadata(key, value);
        }
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return this.sharedModel.toJSON();
    }
    /**
     * Handle a change to the observable value.
     */
    onGenericChange() {
        this.contentChanged.emit(void 0);
    }
    _onMetadataChanged(sender, change) {
        this._metadataChanged.emit(change);
    }
}
/**
 * A base implementation for cell models with attachments.
 */
class model_AttachmentsCellModel extends CellModel {
    /**
     * Construct a new cell with optional attachments.
     */
    constructor(options) {
        var _a;
        super(options);
        const factory = (_a = options.contentFactory) !== null && _a !== void 0 ? _a : model_AttachmentsCellModel.defaultContentFactory;
        const values = this.sharedModel.getAttachments();
        this._attachments = factory.createAttachmentsModel({ values });
        this._attachments.stateChanged.connect(this.onGenericChange, this);
        this._attachments.changed.connect(this._onAttachmentsChange, this);
        this.sharedModel.changed.connect(this._onSharedModelChanged, this);
    }
    /**
     * Get the attachments of the model.
     */
    get attachments() {
        return this._attachments;
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._attachments.stateChanged.disconnect(this.onGenericChange, this);
        this._attachments.changed.disconnect(this._onAttachmentsChange, this);
        this._attachments.dispose();
        this.sharedModel.changed.disconnect(this._onSharedModelChanged, this);
        super.dispose();
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
    /**
     * Handle a change to the cell outputs modelDB and reflect it in the shared model.
     */
    _onAttachmentsChange(sender, event) {
        const cell = this.sharedModel;
        globalModelDBMutex(() => cell.setAttachments(sender.toJSON()));
    }
    /**
     * Handle a change to the code cell value.
     */
    _onSharedModelChanged(slot, change) {
        if (change.attachmentsChange) {
            const cell = this.sharedModel;
            globalModelDBMutex(() => { var _a; return this._attachments.fromJSON((_a = cell.getAttachments()) !== null && _a !== void 0 ? _a : {}); });
        }
    }
}
/**
 * The namespace for `AttachmentsCellModel` statics.
 */
(function (AttachmentsCellModel) {
    /**
     * The default implementation of an `IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an attachments model.
         */
        createAttachmentsModel(options) {
            return new attachments_lib_index_js_.AttachmentsModel(options);
        }
    }
    AttachmentsCellModel.ContentFactory = ContentFactory;
    /**
     * The shared `ContentFactory` instance.
     */
    AttachmentsCellModel.defaultContentFactory = new ContentFactory();
})(model_AttachmentsCellModel || (model_AttachmentsCellModel = {}));
/**
 * An implementation of a raw cell model.
 */
class RawCellModel extends model_AttachmentsCellModel {
    /**
     * Construct a raw cell model from optional shared model.
     */
    constructor(options = {}) {
        super({
            cell_type: 'raw',
            ...options
        });
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'raw';
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
}
/**
 * An implementation of a markdown cell model.
 */
class MarkdownCellModel extends model_AttachmentsCellModel {
    /**
     * Construct a markdown cell model from optional shared model.
     */
    constructor(options = {}) {
        super({
            cell_type: 'markdown',
            ...options
        });
        // Use the Github-flavored markdown mode.
        this.mimeType = 'text/x-ipythongfm';
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'markdown';
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
}
/**
 * An implementation of a code cell Model.
 */
class model_CodeCellModel extends CellModel {
    /**
     * Construct a new code cell with optional original cell content.
     */
    constructor(options = {}) {
        var _a;
        super({
            cell_type: 'code',
            ...options
        });
        this._executedCode = '';
        this._isDirty = false;
        const factory = (_a = options === null || options === void 0 ? void 0 : options.contentFactory) !== null && _a !== void 0 ? _a : model_CodeCellModel.defaultContentFactory;
        const trusted = this.trusted;
        const outputs = this.sharedModel.getOutputs();
        this._outputs = factory.createOutputArea({ trusted, values: outputs });
        this.sharedModel.changed.connect(this._onSharedModelChanged, this);
        this._outputs.changed.connect(this.onGenericChange, this);
        this._outputs.changed.connect(this.onOutputsChange, this);
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'code';
    }
    /**
     * The execution count of the cell.
     */
    get executionCount() {
        return this.sharedModel.execution_count || null;
    }
    set executionCount(newValue) {
        this.sharedModel.execution_count = newValue || null;
    }
    /**
     * The execution state of the cell.
     */
    get executionState() {
        return this.sharedModel.executionState;
    }
    set executionState(newValue) {
        this.sharedModel.executionState = newValue;
    }
    /**
     * Whether the cell is dirty or not.
     *
     * A cell is dirty if it is output is not empty and does not
     * result of the input code execution.
     */
    get isDirty() {
        // Test could be done dynamically with this._executedCode
        // but for performance reason, the diff status is stored in a boolean.
        return this._isDirty;
    }
    /**
     * Public Set whether the cell is dirty or not.
     */
    set isDirty(dirty) {
        this._setDirty(dirty);
    }
    /**
     * The cell outputs.
     */
    get outputs() {
        return this._outputs;
    }
    clearExecution() {
        this.outputs.clear();
        this.executionCount = null;
        this.executionState = 'idle';
        this._setDirty(false);
        this.sharedModel.deleteMetadata('execution');
        // We trust this cell as it no longer has any outputs.
        this.trusted = true;
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.sharedModel.changed.disconnect(this._onSharedModelChanged, this);
        this._outputs.changed.disconnect(this.onGenericChange, this);
        this._outputs.changed.disconnect(this.onOutputsChange, this);
        this._outputs.dispose();
        this._outputs = null;
        super.dispose();
    }
    /**
     * Handle a change to the trusted state.
     */
    onTrustedChanged(trusted, args) {
        const newTrusted = args.newValue;
        if (this._outputs) {
            this._outputs.trusted = newTrusted;
        }
        if (newTrusted) {
            const codeCell = this.sharedModel;
            const metadata = codeCell.getMetadata();
            metadata.trusted = true;
            codeCell.setMetadata(metadata);
        }
        this.stateChanged.emit({
            name: 'trusted',
            oldValue: args.oldValue,
            newValue: newTrusted
        });
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
    /**
     * Handle a change to the cell outputs modelDB and reflect it in the shared model.
     */
    onOutputsChange(sender, event) {
        const codeCell = this.sharedModel;
        globalModelDBMutex(() => {
            switch (event.type) {
                case 'add': {
                    for (const output of event.newValues) {
                        if (output.type === 'stream') {
                            output.streamText.changed.connect((sender, textEvent) => {
                                if (textEvent.options !== undefined &&
                                    textEvent.options['silent']) {
                                    return;
                                }
                                const codeCell = this.sharedModel;
                                if (textEvent.type === 'remove') {
                                    codeCell.removeStreamOutput(event.newIndex, textEvent.start, 'silent-change');
                                }
                                else {
                                    codeCell.appendStreamOutput(event.newIndex, textEvent.value, 'silent-change');
                                }
                            }, this);
                        }
                    }
                    const outputs = event.newValues.map(output => output.toJSON());
                    codeCell.updateOutputs(event.newIndex, event.newIndex, outputs, 'silent-change');
                    break;
                }
                case 'set': {
                    const newValues = event.newValues.map(output => output.toJSON());
                    codeCell.updateOutputs(event.oldIndex, event.oldIndex + newValues.length, newValues, 'silent-change');
                    break;
                }
                case 'remove':
                    codeCell.updateOutputs(event.oldIndex, event.oldValues.length, [], 'silent-change');
                    break;
                case 'clear':
                    codeCell.clearOutputs();
                    break;
                default:
                    throw new Error(`Invalid event type: ${event.type}`);
            }
        });
    }
    /**
     * Handle a change to the code cell value.
     */
    _onSharedModelChanged(slot, change) {
        if (change.streamOutputChange) {
            globalModelDBMutex(() => {
                for (const streamOutputChange of change.streamOutputChange) {
                    if ('delete' in streamOutputChange) {
                        this._outputs.removeStreamOutput(streamOutputChange.delete);
                    }
                    if ('insert' in streamOutputChange) {
                        this._outputs.appendStreamOutput(streamOutputChange.insert.toString());
                    }
                }
            });
        }
        if (change.outputsChange) {
            globalModelDBMutex(() => {
                let retain = 0;
                for (const outputsChange of change.outputsChange) {
                    if ('retain' in outputsChange) {
                        retain += outputsChange.retain;
                    }
                    if ('delete' in outputsChange) {
                        for (let i = 0; i < outputsChange.delete; i++) {
                            this._outputs.remove(retain);
                        }
                    }
                    if ('insert' in outputsChange) {
                        // Inserting an output always results in appending it.
                        for (const output of outputsChange.insert) {
                            // For compatibility with older ydoc where a plain object,
                            // (rather than a Map instance) could be provided.
                            // In a future major release the use of Map will be required.
                            this._outputs.add('toJSON' in output ? output.toJSON() : output);
                        }
                    }
                }
            });
        }
        if (change.executionCountChange) {
            this.stateChanged.emit({
                name: 'executionCount',
                oldValue: change.executionCountChange.oldValue,
                newValue: change.executionCountChange.newValue
            });
        }
        if (change.executionStateChange) {
            if (change.executionStateChange.newValue === 'running') {
                this._setDirty(false);
            }
            this.stateChanged.emit({
                name: 'executionState',
                oldValue: change.executionStateChange.oldValue,
                newValue: change.executionStateChange.newValue
            });
        }
        if (change.sourceChange &&
            (this.executionCount !== null || this.executionState === 'running')) {
            this._setDirty(this._executedCode !== this.sharedModel.getSource().trim());
        }
    }
    /**
     * Set whether the cell is dirty or not.
     */
    _setDirty(v) {
        if (!v) {
            this._executedCode = this.sharedModel.getSource().trim();
        }
        if (v !== this._isDirty) {
            this._isDirty = v;
            this.stateChanged.emit({
                name: 'isDirty',
                oldValue: !v,
                newValue: v
            });
        }
    }
}
/**
 * The namespace for `CodeCellModel` statics.
 */
(function (CodeCellModel) {
    /**
     * The default implementation of an `IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an output area.
         */
        createOutputArea(options) {
            return new outputarea_lib_index_js_.OutputAreaModel(options);
        }
    }
    CodeCellModel.ContentFactory = ContentFactory;
    /**
     * The shared `ContentFactory` instance.
     */
    CodeCellModel.defaultContentFactory = new ContentFactory();
})(model_CodeCellModel || (model_CodeCellModel = {}));
//# sourceMappingURL=model.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/placeholder.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The CSS class added to placeholders.
 */
const PLACEHOLDER_CLASS = 'jp-Placeholder';
/**
 * The CSS classes added to input placeholder prompts.
 */
const placeholder_INPUT_PROMPT_CLASS = 'jp-Placeholder-prompt jp-InputPrompt';
/**
 * The CSS classes added to output placeholder prompts.
 */
const OUTPUT_PROMPT_CLASS = 'jp-Placeholder-prompt jp-OutputPrompt';
/**
 * The CSS class added to placeholder content.
 */
const CONTENT_CLASS = 'jp-Placeholder-content';
/**
 * The CSS class added to input placeholders.
 */
const INPUT_PLACEHOLDER_CLASS = 'jp-InputPlaceholder';
/**
 * The CSS class added to output placeholders.
 */
const OUTPUT_PLACEHOLDER_CLASS = 'jp-OutputPlaceholder';
/**
 * An base class for placeholders
 *
 * ### Notes
 * A placeholder is the element that is shown when input/output
 * is hidden.
 */
class Placeholder extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new placeholder.
     */
    constructor(options) {
        var _a, _b, _c;
        const node = document.createElement('div');
        super({ node });
        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const innerNode = document.createElement('div');
        innerNode.className = (_b = options.promptClass) !== null && _b !== void 0 ? _b : '';
        node.insertAdjacentHTML('afterbegin', innerNode.outerHTML);
        this._cell = document.createElement('div');
        this._cell.classList.add(CONTENT_CLASS);
        this._cell.title = trans.__('Click to expand');
        const container = this._cell.appendChild(document.createElement('div'));
        container.classList.add('jp-Placeholder-contentContainer');
        this._textContent = container.appendChild(document.createElement('span'));
        this._textContent.className = 'jp-PlaceholderText';
        this._textContent.innerText = (_c = options.text) !== null && _c !== void 0 ? _c : '';
        node.appendChild(this._cell);
        index_js_.ellipsesIcon.element({
            container: container.appendChild(document.createElement('span')),
            className: 'jp-MoreHorizIcon',
            elementPosition: 'center',
            height: 'auto',
            width: '32px'
        });
        this.addClass(PLACEHOLDER_CLASS);
        this._callback = options.callback;
    }
    /**
     * The text displayed in the placeholder.
     */
    set text(t) {
        this._textContent.innerText = t;
    }
    get text() {
        return this._textContent.innerText;
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.node.addEventListener('click', this._callback);
    }
    onBeforeDetach(msg) {
        this.node.removeEventListener('click', this._callback);
        super.onBeforeDetach(msg);
    }
}
/**
 * The input placeholder class.
 */
class InputPlaceholder extends Placeholder {
    /**
     * Construct a new input placeholder.
     */
    constructor(options) {
        super({ ...options, promptClass: placeholder_INPUT_PROMPT_CLASS });
        this.addClass(INPUT_PLACEHOLDER_CLASS);
    }
}
/**
 * The output placeholder class.
 */
class OutputPlaceholder extends Placeholder {
    /**
     * Construct a new output placeholder.
     */
    constructor(options) {
        super({ ...options, promptClass: OUTPUT_PROMPT_CLASS });
        this.addClass(OUTPUT_PLACEHOLDER_CLASS);
    }
}
//# sourceMappingURL=placeholder.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/codemirror@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/codemirror/lib/index.js)
var codemirror_lib_index_js_ = __webpack_require__(48774);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(3744);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/documentsearch@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/documentsearch/lib/index.js)
var documentsearch_lib_index_js_ = __webpack_require__(14038);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/searchprovider.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * Class applied on highlighted search matches
 */
const SELECTED_HIGHLIGHT_CLASS = 'jp-mod-selected';
/**
 * Search provider for cells.
 */
class CellSearchProvider extends codemirror_lib_index_js_.EditorSearchProvider {
    constructor(cell) {
        super();
        this.cell = cell;
        if (!this.cell.inViewport && !this.cell.editor) {
            void (0,coreutils_lib_index_js_.signalToPromise)(cell.inViewportChanged).then(([, inViewport]) => {
                if (inViewport) {
                    this.cmHandler.setEditor(this.editor);
                }
            });
        }
    }
    /**
     * Text editor
     */
    get editor() {
        return this.cell.editor;
    }
    /**
     * Editor content model
     */
    get model() {
        return this.cell.model;
    }
}
/**
 * Code cell search provider
 */
class CodeCellSearchProvider extends CellSearchProvider {
    /**
     * Constructor
     *
     * @param cell Cell widget
     */
    constructor(cell) {
        super(cell);
        this.currentProviderIndex = -1;
        this.outputsProvider = [];
        const outputs = this.cell.outputArea;
        this._onOutputsChanged(outputs, outputs.widgets.length).catch(reason => {
            console.error(`Failed to initialize search on cell outputs.`, reason);
        });
        outputs.outputLengthChanged.connect(this._onOutputsChanged, this);
        outputs.disposed.connect(() => {
            outputs.outputLengthChanged.disconnect(this._onOutputsChanged);
        }, this);
    }
    /**
     * Number of matches in the cell.
     */
    get matchesCount() {
        if (!this.isActive) {
            return 0;
        }
        return (super.matchesCount +
            this.outputsProvider.reduce((sum, provider) => { var _a; return sum + ((_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0));
    }
    /**
     * Clear currently highlighted match.
     */
    async clearHighlight() {
        await super.clearHighlight();
        await Promise.all(this.outputsProvider.map(provider => provider.clearHighlight()));
    }
    /**
     * Dispose the search provider
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this.outputsProvider.map(provider => {
            provider.dispose();
        });
        this.outputsProvider.length = 0;
    }
    getCurrentMatch() {
        var _a;
        if (this.currentProviderIndex === -1) {
            return super.getCurrentMatch();
        }
        else if (this.currentProviderIndex < this.outputsProvider.length) {
            const provider = this.outputsProvider[this.currentProviderIndex];
            return (_a = provider.currentMatch) !== null && _a !== void 0 ? _a : undefined;
        }
    }
    /**
     * Highlight the next match.
     *
     * @returns The next match if there is one.
     */
    async highlightNext(loop, options) {
        var _a;
        // If we're scanning from the previous match, test whether we're
        // at the end of the matches list.
        const from = (_a = options === null || options === void 0 ? void 0 : options.from) !== null && _a !== void 0 ? _a : '';
        if (this.matchesCount === 0 ||
            (from === 'previous-match' &&
                this.currentIndex !== null &&
                this.currentIndex + 1 >= this.cmHandler.matches.length) ||
            !this.isActive) {
            this.currentIndex = null;
        }
        else {
            if (this.currentProviderIndex === -1) {
                const match = await super.highlightNext(loop, options);
                if (match) {
                    this.currentIndex = this.cmHandler.currentIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex = 0;
                }
            }
            while (this.currentProviderIndex < this.outputsProvider.length) {
                const provider = this.outputsProvider[this.currentProviderIndex];
                const match = await provider.highlightNext(false);
                if (match) {
                    this.currentIndex =
                        super.matchesCount +
                            this.outputsProvider
                                .slice(0, this.currentProviderIndex)
                                .reduce((sum, provider) => { var _a; return (sum += (_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0) +
                            provider.currentMatchIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex += 1;
                }
            }
            this.currentProviderIndex = -1;
            this.currentIndex = null;
            return undefined;
        }
    }
    /**
     * Highlight the previous match.
     *
     * @returns The previous match if there is one.
     */
    async highlightPrevious() {
        if (this.matchesCount === 0 || !this.isActive) {
            this.currentIndex = null;
        }
        else {
            if (this.currentIndex === null) {
                this.currentProviderIndex = this.outputsProvider.length - 1;
            }
            while (this.currentProviderIndex >= 0) {
                const provider = this.outputsProvider[this.currentProviderIndex];
                const match = await provider.highlightPrevious(false);
                if (match) {
                    this.currentIndex =
                        super.matchesCount +
                            this.outputsProvider
                                .slice(0, this.currentProviderIndex)
                                .reduce((sum, provider) => { var _a; return (sum += (_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0) +
                            provider.currentMatchIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex -= 1;
                }
            }
            const match = await super.highlightPrevious();
            if (match) {
                this.currentIndex = this.cmHandler.currentIndex;
                return match;
            }
            else {
                this.currentIndex = null;
                return undefined;
            }
        }
    }
    /**
     * Initialize the search using the provided options. Should update the UI to highlight
     * all matches and "select" the first match.
     *
     * @param query A RegExp to be use to perform the search
     * @param filters Filter parameters to pass to provider
     */
    async startQuery(query, filters) {
        await super.startQuery(query, filters);
        // Search outputs
        if ((filters === null || filters === void 0 ? void 0 : filters.output) !== false && this.isActive) {
            await Promise.all(this.outputsProvider.map(provider => provider.startQuery(query)));
        }
    }
    async endQuery() {
        var _a;
        await super.endQuery();
        if (((_a = this.filters) === null || _a === void 0 ? void 0 : _a.output) !== false && this.isActive) {
            await Promise.all(this.outputsProvider.map(provider => provider.endQuery()));
        }
    }
    /**
     * Replace all matches in the cell source with the provided text
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    async replaceAllMatches(newText, options) {
        if (this.model.getMetadata('editable') === false)
            return Promise.resolve(false);
        const result = await super.replaceAllMatches(newText, options);
        return result;
    }
    /**
     * Replace the currently selected match with the provided text.
     * If no match is selected, it won't do anything.
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    async replaceCurrentMatch(newText, loop, options) {
        if (this.model.getMetadata('editable') === false)
            return Promise.resolve(false);
        const result = await super.replaceCurrentMatch(newText, loop, options);
        return result;
    }
    async _onOutputsChanged(outputArea, changes) {
        var _a;
        this.outputsProvider.forEach(provider => {
            provider.dispose();
        });
        this.outputsProvider.length = 0;
        this.currentProviderIndex = -1;
        this.outputsProvider = this.cell.outputArea.widgets.map(output => new documentsearch_lib_index_js_.GenericSearchProvider(output));
        if (this.isActive && this.query && ((_a = this.filters) === null || _a === void 0 ? void 0 : _a.output) !== false) {
            await Promise.all([
                this.outputsProvider.map(provider => {
                    void provider.startQuery(this.query);
                })
            ]);
        }
        this._stateChanged.emit();
    }
}
/**
 * Markdown cell search provider
 */
class MarkdownCellSearchProvider extends CellSearchProvider {
    /**
     * Constructor
     *
     * @param cell Cell widget
     */
    constructor(cell) {
        super(cell);
        this._unrenderedByHighlight = false;
        this.renderedProvider = new documentsearch_lib_index_js_.GenericSearchProvider(cell.renderer);
    }
    /**
     * Clear currently highlighted match
     */
    async clearHighlight() {
        await super.clearHighlight();
        await this.renderedProvider.clearHighlight();
    }
    /**
     * Dispose the search provider
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this.renderedProvider.dispose();
    }
    /**
     * Stop the search and clean any UI elements.
     */
    async endQuery() {
        await super.endQuery();
        await this.renderedProvider.endQuery();
    }
    /**
     * Highlight the next match.
     *
     * @returns The next match if there is one.
     */
    async highlightNext(loop = true, options) {
        let match = undefined;
        if (!this.isActive) {
            return match;
        }
        const cell = this.cell;
        if (cell.rendered && this.matchesCount > 0) {
            // Unrender the cell
            this._unrenderedByHighlight = true;
            const waitForRendered = (0,coreutils_lib_index_js_.signalToPromise)(cell.renderedChanged);
            cell.rendered = false;
            await waitForRendered;
        }
        match = await super.highlightNext(loop, options);
        return match;
    }
    /**
     * Highlight the previous match.
     *
     * @returns The previous match if there is one.
     */
    async highlightPrevious() {
        let match = undefined;
        const cell = this.cell;
        if (cell.rendered && this.matchesCount > 0) {
            // Unrender the cell if there are matches within the cell
            this._unrenderedByHighlight = true;
            const waitForRendered = (0,coreutils_lib_index_js_.signalToPromise)(cell.renderedChanged);
            cell.rendered = false;
            await waitForRendered;
        }
        match = await super.highlightPrevious();
        return match;
    }
    /**
     * Initialize the search using the provided options. Should update the UI
     * to highlight all matches and "select" the first match.
     *
     * @param query A RegExp to be use to perform the search
     * @param filters Filter parameters to pass to provider
     */
    async startQuery(query, filters) {
        await super.startQuery(query, filters);
        const cell = this.cell;
        if (cell.rendered) {
            this.onRenderedChanged(cell, cell.rendered);
        }
        cell.renderedChanged.connect(this.onRenderedChanged, this);
    }
    /**
     * Replace all matches in the cell source with the provided text
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    async replaceAllMatches(newText, options) {
        if (this.model.getMetadata('editable') === false)
            return Promise.resolve(false);
        const result = await super.replaceAllMatches(newText, options);
        // if the cell is rendered force update
        if (this.cell.rendered) {
            this.cell.update();
        }
        return result;
    }
    /**
     * Replace the currently selected match with the provided text.
     * If no match is selected, it won't do anything.
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    async replaceCurrentMatch(newText, loop, options) {
        if (this.model.getMetadata('editable') === false)
            return Promise.resolve(false);
        const result = await super.replaceCurrentMatch(newText, loop, options);
        return result;
    }
    /**
     * Callback on rendered state change
     *
     * @param cell Cell that emitted the change
     * @param rendered New rendered value
     */
    onRenderedChanged(cell, rendered) {
        var _a;
        if (!this._unrenderedByHighlight) {
            this.currentIndex = null;
        }
        this._unrenderedByHighlight = false;
        if (this.isActive) {
            if (rendered) {
                void this.renderedProvider.startQuery(this.query);
            }
            else {
                // Force cursor position to ensure reverse search is working as expected
                (_a = cell.editor) === null || _a === void 0 ? void 0 : _a.setCursorPosition({ column: 0, line: 0 });
                void this.renderedProvider.endQuery();
            }
        }
    }
}
/**
 * Factory to create a cell search provider
 *
 * @param cell Cell widget
 * @returns Cell search provider
 */
function createCellSearchProvider(cell) {
    if (cell.isPlaceholder()) {
        return new CellSearchProvider(cell);
    }
    switch (cell.model.type) {
        case 'code':
            return new CodeCellSearchProvider(cell);
        case 'markdown':
            return new MarkdownCellSearchProvider(cell);
        default:
            return new CellSearchProvider(cell);
    }
}
//# sourceMappingURL=searchprovider.js.map
// EXTERNAL MODULE: consume shared module (default) @codemirror/view@~6.38.1 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/view/dist/index.js)
var dist_index_js_ = __webpack_require__(62358);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var apputils_lib_index_js_ = __webpack_require__(3877);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/rendermime@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/rendermime/lib/index.js)
var rendermime_lib_index_js_ = __webpack_require__(45922);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/toc@^6.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/toc/lib/index.js)
var toc_lib_index_js_ = __webpack_require__(45488);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var coreutils_dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var algorithm_dist_index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @lumino/messaging@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/messaging/dist/index.es6.js)
var messaging_dist_index_es6_js_ = __webpack_require__(1884);
// EXTERNAL MODULE: consume shared module (default) @lumino/polling@^2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/polling/dist/index.es6.js)
var polling_dist_index_es6_js_ = __webpack_require__(33206);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/resizeHandle.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



const RESIZE_HANDLE_CLASS = 'jp-CellResizeHandle';
const CELL_RESIZED_CLASS = 'jp-mod-resizedCell';
/**
 * A handle that allows to change input/output proportions in side-by-side mode.
 */
class ResizeHandle extends widgets_dist_index_es6_js_.Widget {
    constructor(targetNode) {
        super();
        this.targetNode = targetNode;
        this._isActive = false;
        this._isDragging = false;
        /**
         * A public signal used to indicate the size of the cell and output has changed.
         */
        this.sizeChanged = new signaling_dist_index_es6_js_.Signal(this);
        this.addClass(RESIZE_HANDLE_CLASS);
        this._resizer = new polling_dist_index_es6_js_.Throttler(event => this._resize(event), 50);
    }
    /**
     * Dispose the resizer handle.
     */
    dispose() {
        this._resizer.dispose();
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     */
    handleEvent(event) {
        var _a, _b;
        switch (event.type) {
            case 'dblclick':
                (_a = this.targetNode.parentNode) === null || _a === void 0 ? void 0 : _a.childNodes.forEach(node => {
                    node.classList.remove(CELL_RESIZED_CLASS);
                });
                document.documentElement.style.setProperty('--jp-side-by-side-output-size', `1fr`);
                this._isActive = false;
                break;
            case 'mousedown':
                this._isDragging = true;
                if (!this._isActive) {
                    (_b = this.targetNode.parentNode) === null || _b === void 0 ? void 0 : _b.childNodes.forEach(node => {
                        node.classList.add(CELL_RESIZED_CLASS);
                    });
                    this._isActive = true;
                }
                window.addEventListener('mousemove', this);
                window.addEventListener('mouseup', this);
                break;
            case 'mousemove': {
                if (this._isActive && this._isDragging) {
                    void this._resizer.invoke(event);
                }
                break;
            }
            case 'mouseup':
                this._isDragging = false;
                window.removeEventListener('mousemove', this);
                window.removeEventListener('mouseup', this);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `after-attach` messages.
     */
    onAfterAttach(msg) {
        this.node.addEventListener('dblclick', this);
        this.node.addEventListener('mousedown', this);
        super.onAfterAttach(msg);
    }
    /**
     * Handle `before-detach` messages.
     */
    onBeforeDetach(msg) {
        this.node.removeEventListener('dblclick', this);
        this.node.removeEventListener('mousedown', this);
        super.onBeforeDetach(msg);
    }
    _resize(event) {
        // Gate the output size ratio between {0.05, 50} as sensible defaults.
        const { width, x } = this.targetNode.getBoundingClientRect();
        const position = event.clientX - x;
        const ratio = width / position - 1;
        if (0 < ratio) {
            const normalized = Math.max(Math.min(Math.abs(ratio), 50), 0.05);
            document.documentElement.style.setProperty('--jp-side-by-side-output-size', `${normalized}fr`);
            this.sizeChanged.emit(normalized);
        }
    }
}
//# sourceMappingURL=resizeHandle.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/widget.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/





















/**
 * The CSS class added to cell widgets.
 */
const CELL_CLASS = 'jp-Cell';
/**
 * The CSS class added to the cell header.
 */
const widget_CELL_HEADER_CLASS = 'jp-Cell-header';
/**
 * The CSS class added to the cell footer.
 */
const widget_CELL_FOOTER_CLASS = 'jp-Cell-footer';
/**
 * The CSS class added to the cell input wrapper.
 */
const CELL_INPUT_WRAPPER_CLASS = 'jp-Cell-inputWrapper';
/**
 * The CSS class added to the cell output wrapper.
 */
const CELL_OUTPUT_WRAPPER_CLASS = 'jp-Cell-outputWrapper';
/**
 * The CSS class added to the cell input area.
 */
const CELL_INPUT_AREA_CLASS = 'jp-Cell-inputArea';
/**
 * The CSS class added to the cell output area.
 */
const CELL_OUTPUT_AREA_CLASS = 'jp-Cell-outputArea';
/**
 * The CSS class added to the cell input collapser.
 */
const CELL_INPUT_COLLAPSER_CLASS = 'jp-Cell-inputCollapser';
/**
 * The CSS class added to the cell output collapser.
 */
const CELL_OUTPUT_COLLAPSER_CLASS = 'jp-Cell-outputCollapser';
/**
 * The class name added to the cell when dirty.
 */
const DIRTY_CLASS = 'jp-mod-dirty';
/**
 * The class name added to code cells.
 */
const CODE_CELL_CLASS = 'jp-CodeCell';
/**
 * The class name added to markdown cells.
 */
const MARKDOWN_CELL_CLASS = 'jp-MarkdownCell';
/**
 * The class name added to rendered markdown output widgets.
 */
const MARKDOWN_OUTPUT_CLASS = 'jp-MarkdownOutput';
const MARKDOWN_HEADING_COLLAPSED = 'jp-MarkdownHeadingCollapsed';
const HEADING_COLLAPSER_CLASS = 'jp-collapseHeadingButton';
const SHOW_HIDDEN_CELLS_CLASS = 'jp-showHiddenCellsButton';
/**
 * The class name added to raw cells.
 */
const RAW_CELL_CLASS = 'jp-RawCell';
/**
 * The class name added to a rendered input area.
 */
const RENDERED_CLASS = 'jp-mod-rendered';
const NO_OUTPUTS_CLASS = 'jp-mod-noOutputs';
/**
 * The timeout to wait for change activity to have ceased before rendering.
 */
const RENDER_TIMEOUT = 1000;
/**
 * The mime type for a rich contents drag object.
 */
const CONTENTS_MIME_RICH = 'application/x-jupyter-icontentsrich';
/** ****************************************************************************
 * Cell
 ******************************************************************************/
/**
 * A base cell widget.
 */
class widget_Cell extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new base cell widget.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        super();
        this.prompt = '';
        this._displayChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._scrollRequested = new signaling_dist_index_es6_js_.Signal(this);
        /**
         * Editor extension emitting `scrollRequested` signal on scroll.
         *
         * Scrolling within editor will be prevented when a cell is out out viewport.
         * Windowed containers including cells should listen to the scroll request
         * signal and invoke the `scrollWithinCell()` callback after scrolling the cell
         * back into the view (and after updating the `inViewport` property).
         */
        this._scrollHandlerExtension = dist_index_js_.EditorView.scrollHandler.of((view, range, options) => {
            // When cell is in the viewport we can scroll within the editor immediately.
            // When cell is out of viewport, the windowed container needs to first
            // scroll the cell into the viewport (otherwise CodeMirror is unable to
            // calculate the correct scroll delta) before invoking scrolling in editor.
            const inWindowedContainer = this._inViewport !== null;
            const preventDefault = inWindowedContainer && !this._inViewport;
            this._scrollRequested.emit({
                defaultPrevented: preventDefault,
                scrollWithinCell: () => {
                    view.dispatch({
                        effects: dist_index_js_.EditorView.scrollIntoView(range, options)
                    });
                }
            });
            return preventDefault;
        });
        this._editorConfig = {};
        this._editorExtensions = [];
        this._inputHidden = false;
        this._inViewportChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._readOnly = false;
        this._ready = new coreutils_dist_index_js_.PromiseDelegate();
        this._resizeDebouncer = new polling_dist_index_es6_js_.Debouncer(() => {
            this._displayChanged.emit();
        }, 0);
        this._syncCollapse = false;
        this._syncEditable = false;
        this.addClass(CELL_CLASS);
        const model = (this._model = options.model);
        this.contentFactory = options.contentFactory;
        this.layout = (_a = options.layout) !== null && _a !== void 0 ? _a : new widgets_dist_index_es6_js_.PanelLayout();
        // Set up translator for aria labels
        this.translator = (_b = options.translator) !== null && _b !== void 0 ? _b : translation_lib_index_js_.nullTranslator;
        // For cells disable searching with CodeMirror search panel.
        this._editorConfig = { searchWithCM: false, ...options.editorConfig };
        this._editorExtensions = (_c = options.editorExtensions) !== null && _c !== void 0 ? _c : [];
        this._editorExtensions.push(this._scrollHandlerExtension);
        this._placeholder = true;
        this._inViewport = null;
        this.placeholder = (_d = options.placeholder) !== null && _d !== void 0 ? _d : true;
        model.metadataChanged.connect(this.onMetadataChanged, this);
    }
    /**
     * Initialize view state from model.
     *
     * #### Notes
     * Should be called after construction. For convenience, returns this, so it
     * can be chained in the construction, like `new Foo().initializeState();`
     */
    initializeState() {
        this.loadCollapseState();
        this.loadEditableState();
        return this;
    }
    /**
     * Signal to indicate that widget has changed visibly (in size, in type, etc)
     */
    get displayChanged() {
        return this._displayChanged;
    }
    /**
     * Whether the cell is in viewport or not.
     *
     * #### Notes
     * This property is managed by the windowed container which holds the cell.
     * When a cell is not in a windowed container, it always returns `false`,
     * but this may change in the future major version.
     */
    get inViewport() {
        var _a;
        return (_a = this._inViewport) !== null && _a !== void 0 ? _a : false;
    }
    set inViewport(v) {
        if (this._inViewport !== v) {
            this._inViewport = v;
            this._inViewportChanged.emit(this._inViewport);
        }
    }
    /**
     * Will emit true just after the node is attached to the DOM
     * Will emit false just before the node is detached of the DOM
     */
    get inViewportChanged() {
        return this._inViewportChanged;
    }
    /**
     * Whether the cell is a placeholder not yet fully rendered or not.
     */
    get placeholder() {
        return this._placeholder;
    }
    set placeholder(v) {
        if (this._placeholder !== v && v === false) {
            this.initializeDOM();
            this._placeholder = v;
            this._ready.resolve();
        }
    }
    /**
     * Get the prompt node used by the cell.
     */
    get promptNode() {
        if (this.placeholder) {
            return null;
        }
        if (!this._inputHidden) {
            return this._input.promptNode;
        }
        else {
            return this._inputPlaceholder.node
                .firstElementChild;
        }
    }
    /**
     * Get the CodeEditorWrapper used by the cell.
     */
    get editorWidget() {
        var _a, _b;
        return (_b = (_a = this._input) === null || _a === void 0 ? void 0 : _a.editorWidget) !== null && _b !== void 0 ? _b : null;
    }
    /**
     * Get the CodeEditor used by the cell.
     */
    get editor() {
        var _a, _b;
        return (_b = (_a = this._input) === null || _a === void 0 ? void 0 : _a.editor) !== null && _b !== void 0 ? _b : null;
    }
    /**
     * Editor configuration
     */
    get editorConfig() {
        return this._editorConfig;
    }
    /**
     * Cell headings
     *
     * @deprecated Use the asynchronous {@link getHeadings} method instead.
     * This getter only returns the last cached value.
     */
    get headings() {
        return new Array();
    }
    /**
     * Async Cell headings
     *
     */
    async getHeadings() {
        return [];
    }
    /**
     * Get the model used by the cell.
     */
    get model() {
        return this._model;
    }
    /**
     * Get the input area for the cell.
     */
    get inputArea() {
        return this._input;
    }
    /**
     * The read only state of the cell.
     */
    get readOnly() {
        return this._readOnly;
    }
    set readOnly(value) {
        if (value === this._readOnly) {
            return;
        }
        this._readOnly = value;
        if (this.syncEditable) {
            this.saveEditableState();
        }
        this.update();
    }
    /**
     * Whether the cell is a placeholder that defer rendering
     *
     * #### Notes
     * You can wait for the promise `Cell.ready` to wait for the
     * cell to be rendered.
     */
    isPlaceholder() {
        return this.placeholder;
    }
    /**
     * Save view editable state to model
     */
    saveEditableState() {
        const { sharedModel } = this.model;
        const current = sharedModel.getMetadata('editable');
        if ((this.readOnly && current === false) ||
            (!this.readOnly && current === undefined)) {
            return;
        }
        if (this.readOnly) {
            sharedModel.setMetadata('editable', false);
        }
        else {
            sharedModel.deleteMetadata('editable');
        }
    }
    /**
     * Load view editable state from model.
     */
    loadEditableState() {
        this.readOnly =
            this.model.sharedModel.getMetadata('editable') ===
                false;
    }
    /**
     * A promise that resolves when the widget renders for the first time.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Set the prompt for the widget.
     * @deprecated - set the `executionState` on the model instead.
     */
    setPrompt(value) {
        return this._setPrompt(value);
    }
    /**
     * Set the prompt for the widget.
     *
     * Note: this method is protected because it is needed in the CodeCell subclass,
     * but it cannot be defined there because input is private to Cell class.
     */
    _setPrompt(value) {
        var _a;
        this.prompt = value;
        (_a = this._input) === null || _a === void 0 ? void 0 : _a.setPrompt(value);
    }
    /**
     * The view state of input being hidden.
     */
    get inputHidden() {
        return this._inputHidden;
    }
    set inputHidden(value) {
        var _a;
        if (this._inputHidden === value) {
            return;
        }
        if (!this.placeholder) {
            const layout = this._inputWrapper.layout;
            if (value) {
                this._input.parent = null;
                if (this._inputPlaceholder) {
                    this._inputPlaceholder.text = (_a = this.model.sharedModel
                        .getSource()
                        .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
                }
                layout.addWidget(this._inputPlaceholder);
            }
            else {
                this._inputPlaceholder.parent = null;
                layout.addWidget(this._input);
            }
        }
        this._inputHidden = value;
        if (this.syncCollapse) {
            this.saveCollapseState();
        }
        this.handleInputHidden(value);
    }
    /**
     * Save view collapse state to model
     */
    saveCollapseState() {
        const jupyter = { ...this.model.getMetadata('jupyter') };
        if ((this.inputHidden && jupyter.source_hidden === true) ||
            (!this.inputHidden && jupyter.source_hidden === undefined)) {
            return;
        }
        if (this.inputHidden) {
            jupyter.source_hidden = true;
        }
        else {
            delete jupyter.source_hidden;
        }
        if (Object.keys(jupyter).length === 0) {
            this.model.deleteMetadata('jupyter');
        }
        else {
            this.model.setMetadata('jupyter', jupyter);
        }
    }
    /**
     * Revert view collapse state from model.
     */
    loadCollapseState() {
        var _a;
        const jupyter = (_a = this.model.getMetadata('jupyter')) !== null && _a !== void 0 ? _a : {};
        this.inputHidden = !!jupyter.source_hidden;
    }
    /**
     * Handle the input being hidden.
     *
     * #### Notes
     * This is called by the `inputHidden` setter so that subclasses
     * can perform actions upon the input being hidden without accessing
     * private state.
     */
    handleInputHidden(value) {
        return;
    }
    /**
     * Whether to sync the collapse state to the cell model.
     */
    get syncCollapse() {
        return this._syncCollapse;
    }
    set syncCollapse(value) {
        if (this._syncCollapse === value) {
            return;
        }
        this._syncCollapse = value;
        if (value) {
            this.loadCollapseState();
        }
    }
    /**
     * Whether to sync the editable state to the cell model.
     */
    get syncEditable() {
        return this._syncEditable;
    }
    set syncEditable(value) {
        if (this._syncEditable === value) {
            return;
        }
        this._syncEditable = value;
        if (value) {
            this.loadEditableState();
        }
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            placeholder: false,
            translator: this.translator
        });
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        // Do nothing if already disposed.
        if (this.isDisposed) {
            return;
        }
        this._resizeDebouncer.dispose();
        this._input = null;
        this._model = null;
        this._inputWrapper = null;
        this._inputPlaceholder = null;
        super.dispose();
    }
    /**
     * Update the editor configuration with the partial provided dictionary.
     *
     * @param v Partial editor configuration
     */
    updateEditorConfig(v) {
        this._editorConfig = { ...this._editorConfig, ...v };
        if (this.editor) {
            this.editor.setBaseOptions(this._editorConfig);
        }
    }
    /**
     * Signal emitted when cell requests scrolling to its element.
     */
    get scrollRequested() {
        return this._scrollRequested;
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        const contentFactory = this.contentFactory;
        const model = this._model;
        // Header
        const header = contentFactory.createCellHeader();
        header.addClass(widget_CELL_HEADER_CLASS);
        this.layout.addWidget(header);
        // Input
        const inputWrapper = (this._inputWrapper = new widgets_dist_index_es6_js_.Panel());
        inputWrapper.addClass(CELL_INPUT_WRAPPER_CLASS);
        const inputCollapser = new InputCollapser();
        inputCollapser.addClass(CELL_INPUT_COLLAPSER_CLASS);
        const input = (this._input = new inputarea_InputArea({
            model,
            contentFactory,
            editorOptions: this.getEditorOptions()
        }));
        input.addClass(CELL_INPUT_AREA_CLASS);
        inputWrapper.addWidget(inputCollapser);
        inputWrapper.addWidget(input);
        this.layout.addWidget(inputWrapper);
        this._inputPlaceholder = new InputPlaceholder({
            callback: () => {
                this.inputHidden = !this.inputHidden;
            },
            text: input.model.sharedModel.getSource().split('\n')[0],
            translator: this.translator
        });
        input.model.contentChanged.connect((sender, args) => {
            var _a;
            if (this._inputPlaceholder && this.inputHidden) {
                this._inputPlaceholder.text = (_a = sender.sharedModel
                    .getSource()
                    .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
            }
        });
        if (this.inputHidden) {
            input.parent = null;
            inputWrapper.layout.addWidget(this._inputPlaceholder);
        }
        // Footer
        const footer = this.contentFactory.createCellFooter();
        footer.addClass(widget_CELL_FOOTER_CLASS);
        this.layout.addWidget(footer);
    }
    /**
     * Get the editor options at initialization.
     *
     * @returns Editor options
     */
    getEditorOptions() {
        return { config: this.editorConfig, extensions: this._editorExtensions };
    }
    /**
     * Handle `before-attach` messages.
     */
    onBeforeAttach(msg) {
        if (this.placeholder) {
            this.placeholder = false;
        }
    }
    /**
     * Handle `after-attach` messages.
     */
    onAfterAttach(msg) {
        this.update();
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        var _a;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.focus();
    }
    /**
     * Handle `resize` messages.
     */
    onResize(msg) {
        void this._resizeDebouncer.invoke();
    }
    /**
     * Handle `update-request` messages.
     */
    onUpdateRequest(msg) {
        var _a, _b;
        if (!this._model) {
            return;
        }
        // Handle read only state.
        if (((_a = this.editor) === null || _a === void 0 ? void 0 : _a.getOption('readOnly')) !== this._readOnly) {
            (_b = this.editor) === null || _b === void 0 ? void 0 : _b.setOption('readOnly', this._readOnly);
        }
    }
    onContentChanged() {
        var _a;
        if (this.inputHidden && this._inputPlaceholder) {
            this._inputPlaceholder.text = (_a = this.model.sharedModel
                .getSource()
                .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
        }
    }
    /**
     * Handle changes in the metadata.
     */
    onMetadataChanged(model, args) {
        switch (args.key) {
            case 'jupyter':
                if (this.syncCollapse) {
                    this.loadCollapseState();
                }
                break;
            case 'editable':
                if (this.syncEditable) {
                    this.loadEditableState();
                }
                break;
            default:
                break;
        }
    }
}
/**
 * The namespace for the `Cell` class statics.
 */
(function (Cell) {
    /**
     * Type of headings
     */
    let HeadingType;
    (function (HeadingType) {
        /**
         * Heading from HTML output
         */
        HeadingType[HeadingType["HTML"] = 0] = "HTML";
        /**
         * Heading from Markdown cell or Markdown output
         */
        HeadingType[HeadingType["Markdown"] = 1] = "Markdown";
    })(HeadingType = Cell.HeadingType || (Cell.HeadingType = {}));
    /**
     * The default implementation of an `IContentFactory`.
     *
     * This includes a CodeMirror editor factory to make it easy to use out of the box.
     */
    class ContentFactory {
        /**
         * Create a content factory for a cell.
         */
        constructor(options) {
            this._editorFactory = options.editorFactory;
        }
        /**
         * The readonly editor factory that create code editors
         */
        get editorFactory() {
            return this._editorFactory;
        }
        /**
         * Create a new cell header for the parent widget.
         */
        createCellHeader() {
            return new CellHeader();
        }
        /**
         * Create a new cell footer for the parent widget.
         */
        createCellFooter() {
            return new CellFooter();
        }
        /**
         * Create an input prompt.
         */
        createInputPrompt() {
            return new InputPrompt();
        }
        /**
         * Create the output prompt for the widget.
         */
        createOutputPrompt() {
            return new outputarea_lib_index_js_.OutputPrompt();
        }
        /**
         * Create an stdin widget.
         */
        createStdin(options) {
            return new outputarea_lib_index_js_.Stdin(options);
        }
    }
    Cell.ContentFactory = ContentFactory;
})(widget_Cell || (widget_Cell = {}));
/** ****************************************************************************
 * CodeCell
 ******************************************************************************/
/**
 * Code cell layout
 *
 * It will not detached the output area when the cell is detached.
 */
class CodeCellLayout extends widgets_dist_index_es6_js_.PanelLayout {
    /**
     * A message handler invoked on a `'before-attach'` message.
     *
     * #### Notes
     * The default implementation of this method forwards the message
     * to all widgets. It assumes all widget nodes are attached to the
     * parent widget node.
     *
     * This may be reimplemented by subclasses as needed.
     */
    onBeforeAttach(msg) {
        let beforeOutputArea = true;
        const outputAreaWrapper = this.parent.node.firstElementChild;
        for (const widget of this) {
            if (outputAreaWrapper) {
                if (widget.node === outputAreaWrapper) {
                    beforeOutputArea = false;
                }
                else {
                    messaging_dist_index_es6_js_.MessageLoop.sendMessage(widget, msg);
                    if (beforeOutputArea) {
                        this.parent.node.insertBefore(widget.node, outputAreaWrapper);
                    }
                    else {
                        this.parent.node.appendChild(widget.node);
                    }
                    // Force setting isVisible to true as it requires the parent widget to be
                    // visible. But that flag will be set only during the `onAfterAttach` call.
                    if (!this.parent.isHidden) {
                        widget.setFlag(widgets_dist_index_es6_js_.Widget.Flag.IsVisible);
                    }
                    // Not called in NotebookWindowedLayout to avoid outputArea
                    // widgets unwanted update or reset.
                    messaging_dist_index_es6_js_.MessageLoop.sendMessage(widget, widgets_dist_index_es6_js_.Widget.Msg.AfterAttach);
                }
            }
        }
    }
    /**
     * A message handler invoked on an `'after-detach'` message.
     *
     * #### Notes
     * The default implementation of this method forwards the message
     * to all widgets. It assumes all widget nodes are attached to the
     * parent widget node.
     *
     * This may be reimplemented by subclasses as needed.
     */
    onAfterDetach(msg) {
        for (const widget of this) {
            // TODO we could improve this further by removing outputs based
            // on their mime type (for example plain/text or markdown could safely be detached)
            // If the cell is out of the view port, its children are already detached -> skip detaching
            if (!widget.hasClass(CELL_OUTPUT_WRAPPER_CLASS) &&
                widget.node.isConnected) {
                // Not called in NotebookWindowedLayout for windowed notebook
                messaging_dist_index_es6_js_.MessageLoop.sendMessage(widget, widgets_dist_index_es6_js_.Widget.Msg.BeforeDetach);
                this.parent.node.removeChild(widget.node);
                messaging_dist_index_es6_js_.MessageLoop.sendMessage(widget, msg);
            }
        }
    }
}
/**
 * A widget for a code cell.
 */
class widget_CodeCell extends widget_Cell {
    /**
     * Construct a code cell widget.
     */
    constructor(options) {
        var _a;
        super({ layout: new CodeCellLayout(), ...options, placeholder: true });
        /**
         * Detect the movement of the caret in the output area.
         *
         * Emits scroll request if the caret moved.
         */
        this._detectCaretMovementInOuput = (e) => {
            const inWindowedContainer = this._inViewport !== null;
            const defaultPrevented = inWindowedContainer && !this._inViewport;
            // Because we do not want to scroll on any key, but only on keys which
            // move the caret (this on keys which cause input and on keys like left,
            // right, top, bottom arrow, home, end, page down/up - but only if the
            // cursor is not at the respective end of the input) we need to listen
            // to the `selectionchange` event on target inputs/textareas, etc.
            const target = e.target;
            if (!target || !(target instanceof HTMLElement)) {
                return;
            }
            // Make sure the previous listener gets disconnected
            if (this._lastTarget) {
                this._lastTarget.removeEventListener('selectionchange', this._lastOnCaretMovedHandler);
                document.removeEventListener('selectionchange', this._lastOnCaretMovedHandler);
            }
            const onCaretMoved = () => {
                this._scrollRequested.emit({
                    scrollWithinCell: ({ scroller }) => {
                        dist_index_es6_js_.ElementExt.scrollIntoViewIfNeeded(scroller, target);
                    },
                    defaultPrevented
                });
            };
            // Remember the most recent target/handler to disconnect them next time.
            this._lastTarget = target;
            this._lastOnCaretMovedHandler = onCaretMoved;
            // Firefox only supports `selectionchange` on the actual input element,
            // all other browsers only support it on the top-level document.
            target.addEventListener('selectionchange', onCaretMoved, { once: true });
            document.addEventListener('selectionchange', onCaretMoved, {
                once: true
            });
            // Schedule removal of the listener.
            setTimeout(() => {
                target.removeEventListener('selectionchange', onCaretMoved);
                document.removeEventListener('selectionchange', onCaretMoved);
            }, 250);
        };
        this._headingsCache = null;
        this._outputHidden = false;
        this._outputWrapper = null;
        this._outputPlaceholder = null;
        this._syncScrolled = false;
        this._lastTarget = null;
        this._lastOutputHeight = '';
        this.addClass(CODE_CELL_CLASS);
        const trans = this.translator.load('jupyterlab');
        // Only save options not handled by parent constructor.
        const rendermime = (this._rendermime = options.rendermime);
        const contentFactory = this.contentFactory;
        const model = this.model;
        this.maxNumberOutputs = options.maxNumberOutputs;
        // Note that modifying the below label warrants one to also modify
        // the same in this._outputLengthHandler. Ideally, this label must
        // have been a constant and used in both places but it is not done
        // so because of limitations in the translation manager.
        const ariaLabel = model.outputs.length === 0
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
        const output = (this._output = new outputarea_lib_index_js_.OutputArea({
            model: this.model.outputs,
            rendermime,
            contentFactory: contentFactory,
            maxNumberOutputs: this.maxNumberOutputs,
            translator: this.translator,
            promptOverlay: true,
            inputHistoryScope: options.inputHistoryScope,
            showInputPlaceholder: options.showInputPlaceholder
        }));
        output.node.addEventListener('keydown', this._detectCaretMovementInOuput);
        output.addClass(CELL_OUTPUT_AREA_CLASS);
        output.toggleScrolling.connect(() => {
            this.outputsScrolled = !this.outputsScrolled;
        });
        output.initialize.connect(() => {
            this.updatePromptOverlayIcon();
        });
        // Defer setting placeholder as OutputArea must be instantiated before initializing the DOM
        this.placeholder = (_a = options.placeholder) !== null && _a !== void 0 ? _a : true;
        model.outputs.changed.connect(this.onOutputChanged, this);
        model.outputs.stateChanged.connect(this.onOutputChanged, this);
        model.stateChanged.connect(this.onStateChanged, this);
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        super.initializeDOM();
        this._updatePrompt();
        // Insert the output before the cell footer.
        const outputWrapper = (this._outputWrapper = new widgets_dist_index_es6_js_.Panel());
        outputWrapper.addClass(CELL_OUTPUT_WRAPPER_CLASS);
        const outputCollapser = new OutputCollapser();
        outputCollapser.addClass(CELL_OUTPUT_COLLAPSER_CLASS);
        outputWrapper.addWidget(outputCollapser);
        // Set a CSS if there are no outputs, and connect a signal for future
        // changes to the number of outputs. This is for conditional styling
        // if there are no outputs.
        if (this.model.outputs.length === 0) {
            this.addClass(NO_OUTPUTS_CLASS);
        }
        this._output.outputLengthChanged.connect(this._outputLengthHandler, this);
        outputWrapper.addWidget(this._output);
        const layout = this.layout;
        const resizeHandle = new ResizeHandle(this.node);
        resizeHandle.sizeChanged.connect(this._sizeChangedHandler, this);
        layout.insertWidget(layout.widgets.length - 1, resizeHandle);
        layout.insertWidget(layout.widgets.length - 1, outputWrapper);
        if (this.model.isDirty) {
            this.addClass(DIRTY_CLASS);
        }
        this._outputPlaceholder = new OutputPlaceholder({
            callback: () => {
                this.outputHidden = !this.outputHidden;
            },
            text: this.getOutputPlaceholderText(),
            translator: this.translator
        });
        const layoutWrapper = outputWrapper.layout;
        if (this.outputHidden) {
            layoutWrapper.removeWidget(this._output);
            layoutWrapper.addWidget(this._outputPlaceholder);
            if (this.inputHidden && !outputWrapper.isHidden) {
                this._outputWrapper.hide();
            }
        }
        const trans = this.translator.load('jupyterlab');
        const ariaLabel = this.model.outputs.length === 0
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
    }
    getOutputPlaceholderText() {
        var _a;
        const firstOutput = this.model.outputs.get(0);
        const outputData = firstOutput === null || firstOutput === void 0 ? void 0 : firstOutput.data;
        if (!outputData) {
            return undefined;
        }
        const supportedOutputTypes = [
            'text/html',
            'image/svg+xml',
            'application/pdf',
            'text/markdown',
            'text/plain',
            'application/vnd.jupyter.stderr',
            'application/vnd.jupyter.stdout',
            'text'
        ];
        const preferredOutput = supportedOutputTypes.find(mt => {
            const data = firstOutput.data[mt];
            return (Array.isArray(data) ? typeof data[0] : typeof data) === 'string';
        });
        const dataToDisplay = firstOutput.data[preferredOutput !== null && preferredOutput !== void 0 ? preferredOutput : ''];
        if (dataToDisplay !== undefined) {
            return (_a = (Array.isArray(dataToDisplay)
                ? dataToDisplay
                : dataToDisplay === null || dataToDisplay === void 0 ? void 0 : dataToDisplay.split('\n'))) === null || _a === void 0 ? void 0 : _a.find(part => part !== '');
        }
        return undefined;
    }
    /**
     * Initialize view state from model.
     *
     * #### Notes
     * Should be called after construction. For convenience, returns this, so it
     * can be chained in the construction, like `new Foo().initializeState();`
     */
    initializeState() {
        super.initializeState();
        this.loadScrolledState();
        this._updatePrompt();
        return this;
    }
    get headings() {
        var _a;
        return (_a = this._headingsCache) !== null && _a !== void 0 ? _a : [];
    }
    async getHeadings() {
        if (!this._headingsCache) {
            const headings = [];
            // Iterate over the code cell outputs to check for Markdown or HTML from which we can generate ToC headings...
            const outputs = this.model.outputs;
            for (let j = 0; j < outputs.length; j++) {
                const m = outputs.get(j);
                let htmlType = null;
                let mdType = null;
                Object.keys(m.data).forEach(t => {
                    if (!mdType && toc_lib_index_js_.TableOfContentsUtils.Markdown.isMarkdown(t)) {
                        mdType = t;
                    }
                    else if (!htmlType && toc_lib_index_js_.TableOfContentsUtils.isHTML(t)) {
                        htmlType = t;
                    }
                });
                // Parse HTML output
                if (htmlType) {
                    let htmlData = m.data[htmlType];
                    if (typeof htmlData !== 'string') {
                        htmlData = htmlData.join('\n');
                    }
                    headings.push(...toc_lib_index_js_.TableOfContentsUtils.getHTMLHeadings(this._rendermime.sanitizer.sanitize(htmlData)).map(heading => {
                        return {
                            ...heading,
                            outputIndex: j,
                            type: widget_Cell.HeadingType.HTML
                        };
                    }));
                }
                else if (mdType) {
                    const mdHeading = await toc_lib_index_js_.TableOfContentsUtils.Markdown.parseHeadings(m.data[mdType], this._rendermime.markdownParser);
                    headings.push(...mdHeading.map(heading => {
                        return {
                            ...heading,
                            outputIndex: j,
                            type: widget_Cell.HeadingType.Markdown
                        };
                    }));
                }
            }
            this._headingsCache = headings;
        }
        return [...this._headingsCache];
    }
    /**
     * Get the output area for the cell.
     */
    get outputArea() {
        return this._output;
    }
    /**
     * The view state of output being collapsed.
     */
    get outputHidden() {
        return this._outputHidden;
    }
    set outputHidden(value) {
        var _a;
        if (this._outputHidden === value) {
            return;
        }
        if (!this.placeholder) {
            const layout = this._outputWrapper.layout;
            if (value) {
                layout.removeWidget(this._output);
                layout.addWidget(this._outputPlaceholder);
                if (this.inputHidden && !this._outputWrapper.isHidden) {
                    this._outputWrapper.hide();
                }
                if (this._outputPlaceholder) {
                    this._outputPlaceholder.text = (_a = this.getOutputPlaceholderText()) !== null && _a !== void 0 ? _a : '';
                }
            }
            else {
                if (this._outputWrapper.isHidden) {
                    this._outputWrapper.show();
                }
                layout.removeWidget(this._outputPlaceholder);
                layout.addWidget(this._output);
            }
        }
        this._outputHidden = value;
        if (this.syncCollapse) {
            this.saveCollapseState();
        }
    }
    /**
     * Save view collapse state to model
     */
    saveCollapseState() {
        // Because collapse state for a code cell involves two different pieces of
        // metadata (the `collapsed` and `jupyter` metadata keys), we block reacting
        // to changes in metadata until we have fully committed our changes.
        // Otherwise setting one key can trigger a write to the other key to
        // maintain the synced consistency.
        this.model.sharedModel.transact(() => {
            super.saveCollapseState();
            const collapsed = this.model.getMetadata('collapsed');
            if ((this.outputHidden && collapsed === true) ||
                (!this.outputHidden && collapsed === undefined)) {
                return;
            }
            // Do not set jupyter.outputs_hidden since it is redundant. See
            // and https://github.com/jupyter/nbformat/issues/137
            if (this.outputHidden) {
                this.model.setMetadata('collapsed', true);
            }
            else {
                this.model.deleteMetadata('collapsed');
            }
        }, false, 'silent-change');
    }
    /**
     * Revert view collapse state from model.
     *
     * We consider the `collapsed` metadata key as the source of truth for outputs
     * being hidden.
     */
    loadCollapseState() {
        super.loadCollapseState();
        this.outputHidden = !!this.model.getMetadata('collapsed');
    }
    /**
     * Whether the output is in a scrolled state?
     */
    get outputsScrolled() {
        return this._outputsScrolled;
    }
    set outputsScrolled(value) {
        this.toggleClass('jp-mod-outputsScrolled', value);
        this._outputsScrolled = value;
        if (this.syncScrolled) {
            this.saveScrolledState();
        }
        this.updatePromptOverlayIcon();
    }
    /**
     * Update the Prompt Overlay Icon
     */
    updatePromptOverlayIcon() {
        var _a;
        const overlay = apputils_lib_index_js_.DOMUtils.findElement(this.node, 'jp-OutputArea-promptOverlay');
        if (!overlay) {
            return;
        }
        // If you are changing this, don't forget about svg.
        const ICON_HEIGHT = 16 + 4 + 4; // 4px for padding
        if (overlay.clientHeight <= ICON_HEIGHT) {
            (_a = overlay.firstChild) === null || _a === void 0 ? void 0 : _a.remove();
            return;
        }
        let overlayTitle;
        if (this._outputsScrolled) {
            index_js_.expandIcon.element({
                container: overlay
            });
            overlayTitle = 'Expand Output';
        }
        else {
            index_js_.collapseIcon.element({
                container: overlay
            });
            overlayTitle = 'Collapse Output';
        }
        const trans = this.translator.load('jupyterlab');
        overlay.title = trans.__(overlayTitle);
    }
    /**
     * Save view collapse state to model
     */
    saveScrolledState() {
        const current = this.model.getMetadata('scrolled');
        if ((this.outputsScrolled && current === true) ||
            (!this.outputsScrolled && current === undefined)) {
            return;
        }
        if (this.outputsScrolled) {
            this.model.setMetadata('scrolled', true);
        }
        else {
            this.outputArea.node.style.height = '';
            this.model.deleteMetadata('scrolled');
        }
    }
    /**
     * Revert view collapse state from model.
     */
    loadScrolledState() {
        // We don't have the notion of 'auto' scrolled, so we make it false.
        if (this.model.getMetadata('scrolled') === 'auto') {
            this.outputsScrolled = false;
        }
        else {
            this.outputsScrolled = !!this.model.getMetadata('scrolled');
        }
    }
    /**
     * Whether to sync the scrolled state to the cell model.
     */
    get syncScrolled() {
        return this._syncScrolled;
    }
    set syncScrolled(value) {
        if (this._syncScrolled === value) {
            return;
        }
        this._syncScrolled = value;
        if (value) {
            this.loadScrolledState();
        }
    }
    /**
     * Handle the input being hidden.
     *
     * #### Notes
     * This method is called by the case cell implementation and is
     * subclasses here so the code cell can watch to see when input
     * is hidden without accessing private state.
     */
    handleInputHidden(value) {
        if (this.placeholder) {
            return;
        }
        if (!value && this._outputWrapper.isHidden) {
            this._outputWrapper.show();
        }
        else if (value && !this._outputWrapper.isHidden && this._outputHidden) {
            this._outputWrapper.hide();
        }
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime,
            placeholder: false,
            translator: this.translator
        });
    }
    /**
     * Clone the OutputArea alone, returning a simplified output area, using the same model.
     */
    cloneOutputArea() {
        return new outputarea_lib_index_js_.SimplifiedOutputArea({
            model: this.model.outputs,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime
        });
    }
    /**
     * Dispose of the resources used by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._output.outputLengthChanged.disconnect(this._outputLengthHandler, this);
        this._output.node.removeEventListener('keydown', this._detectCaretMovementInOuput);
        this._rendermime = null;
        this._output = null;
        this._outputWrapper = null;
        this._outputPlaceholder = null;
        super.dispose();
    }
    /**
     * Handle changes in the model.
     */
    onStateChanged(model, args) {
        switch (args.name) {
            case 'executionCount':
                if (args.newValue !== null) {
                    // Mark execution state if execution count was set.
                    this.model.executionState = 'idle';
                }
                this._updatePrompt();
                break;
            case 'executionState':
                this._updatePrompt();
                break;
            case 'isDirty':
                if (model.isDirty) {
                    this.addClass(DIRTY_CLASS);
                }
                else {
                    this.removeClass(DIRTY_CLASS);
                }
                break;
            default:
                break;
        }
    }
    /**
     * Callback on output changes
     */
    onOutputChanged() {
        var _a;
        this._headingsCache = null;
        if (this._outputPlaceholder && this.outputHidden) {
            this._outputPlaceholder.text = (_a = this.getOutputPlaceholderText()) !== null && _a !== void 0 ? _a : '';
        }
        // This is to hide/show icon on single line output.
        this.updatePromptOverlayIcon();
        // Clear output area when empty
        const height = this.outputArea.node.style.height;
        if (this.model.outputs.length === 0 && height !== '') {
            this._lastOutputHeight = height;
            this.outputArea.node.style.height = '';
        }
        else if (this.model.outputs.length > 0 && height === '') {
            this.outputArea.node.style.height = this._lastOutputHeight;
        }
    }
    /**
     * Handle changes in the metadata.
     */
    onMetadataChanged(model, args) {
        switch (args.key) {
            case 'scrolled':
                if (this.syncScrolled) {
                    this.loadScrolledState();
                }
                break;
            case 'collapsed':
                if (this.syncCollapse) {
                    this.loadCollapseState();
                }
                break;
            default:
                break;
        }
        super.onMetadataChanged(model, args);
    }
    _updatePrompt() {
        let prompt;
        if (this.model.executionState == 'running') {
            prompt = '*';
        }
        else {
            prompt = `${this.model.executionCount || ''}`;
        }
        this._setPrompt(prompt);
    }
    /**
     * Handle changes in the number of outputs in the output area.
     */
    _outputLengthHandler(sender, args) {
        const force = args === 0 ? true : false;
        this.toggleClass(NO_OUTPUTS_CLASS, force);
        const trans = this.translator.load('jupyterlab');
        const ariaLabel = force
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
    }
    /**
     * Handle changes in input/output proportions in side-by-side mode.
     */
    _sizeChangedHandler(sender) {
        this._displayChanged.emit();
    }
}
/**
 * The namespace for the `CodeCell` class statics.
 */
(function (CodeCell) {
    /**
     * Execute a cell given a client session.
     */
    async function execute(cell, sessionContext, metadata) {
        var _a;
        const model = cell.model;
        const code = model.sharedModel.getSource();
        if (!code.trim() || !((_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel)) {
            model.sharedModel.transact(() => {
                model.clearExecution();
            }, false);
            return;
        }
        const cellId = { cellId: model.sharedModel.getId() };
        metadata = {
            ...model.metadata,
            ...metadata,
            ...cellId
        };
        const { recordTiming } = metadata;
        model.sharedModel.transact(() => {
            model.clearExecution();
            cell.outputHidden = false;
        }, false, 'silent-change');
        // note: in future we would like to distinguish running from scheduled
        model.executionState = 'running';
        model.trusted = true;
        let future;
        try {
            const msgPromise = outputarea_lib_index_js_.OutputArea.execute(code, cell.outputArea, sessionContext, metadata);
            // cell.outputArea.future assigned synchronously in `execute`
            if (recordTiming) {
                const recordTimingHook = (msg) => {
                    let label;
                    switch (msg.header.msg_type) {
                        case 'status':
                            label = `status.${msg.content.execution_state}`;
                            break;
                        case 'execute_input':
                            label = 'execute_input';
                            break;
                        default:
                            return true;
                    }
                    // If the data is missing, estimate it to now
                    // Date was added in 5.1: https://jupyter-client.readthedocs.io/en/stable/messaging.html#message-header
                    const value = msg.header.date || new Date().toISOString();
                    const timingInfo = Object.assign({}, model.getMetadata('execution'));
                    timingInfo[`iopub.${label}`] = value;
                    model.setMetadata('execution', timingInfo);
                    return true;
                };
                cell.outputArea.future.registerMessageHook(recordTimingHook);
            }
            else {
                model.deleteMetadata('execution');
            }
            // Save this execution's future so we can compare in the catch below.
            future = cell.outputArea.future;
            const msg = (await msgPromise);
            model.executionCount = msg.content.execution_count;
            if (recordTiming) {
                const timingInfo = Object.assign({}, model.getMetadata('execution'));
                const started = msg.metadata.started;
                // Started is not in the API, but metadata IPyKernel sends
                if (started) {
                    timingInfo['shell.execute_reply.started'] = started;
                }
                // Per above, the 5.0 spec does not assume date, so we estimate is required
                const finished = msg.header.date;
                timingInfo['shell.execute_reply'] =
                    finished || new Date().toISOString();
                model.setMetadata('execution', timingInfo);
            }
            return msg;
        }
        catch (e) {
            // If we started executing, and the cell is still indicating this
            // execution, clear the prompt.
            if (future && !cell.isDisposed && cell.outputArea.future === future) {
                cell.model.executionState = 'idle';
                if (recordTiming && future.isDisposed) {
                    // Record the time when the cell execution was aborted
                    const timingInfo = Object.assign({}, model.getMetadata('execution'));
                    timingInfo['execution_failed'] = new Date().toISOString();
                    model.setMetadata('execution', timingInfo);
                }
            }
            throw e;
        }
    }
    CodeCell.execute = execute;
})(widget_CodeCell || (widget_CodeCell = {}));
/**
 * `AttachmentsCell` - A base class for a cell widget that allows
 *  attachments to be drag/drop'd or pasted onto it
 */
class AttachmentsCell extends widget_Cell {
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'lm-dragover':
                this._evtDragOver(event);
                break;
            case 'lm-drop':
                this._evtDrop(event);
                break;
            default:
                break;
        }
    }
    /**
     * Get the editor options at initialization.
     *
     * @returns Editor options
     */
    getEditorOptions() {
        var _a, _b;
        const base = (_a = super.getEditorOptions()) !== null && _a !== void 0 ? _a : {};
        base.extensions = [
            ...((_b = base.extensions) !== null && _b !== void 0 ? _b : []),
            dist_index_js_.EditorView.domEventHandlers({
                dragenter: (event) => {
                    event.preventDefault();
                },
                dragover: (event) => {
                    event.preventDefault();
                },
                drop: (event) => {
                    this._evtNativeDrop(event);
                },
                paste: (event) => {
                    this._evtPaste(event);
                }
            })
        ];
        return base;
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        const node = this.node;
        node.addEventListener('lm-dragover', this);
        node.addEventListener('lm-drop', this);
    }
    /**
     * A message handler invoked on a `'before-detach'`
     * message
     */
    onBeforeDetach(msg) {
        const node = this.node;
        node.removeEventListener('lm-dragover', this);
        node.removeEventListener('lm-drop', this);
        super.onBeforeDetach(msg);
    }
    _evtDragOver(event) {
        const supportedMimeType = (0,algorithm_dist_index_es6_js_.some)(rendermime_lib_index_js_.imageRendererFactory.mimeTypes, mimeType => {
            if (!event.mimeData.hasData(CONTENTS_MIME_RICH)) {
                return false;
            }
            const data = event.mimeData.getData(CONTENTS_MIME_RICH);
            return data.model.mimetype === mimeType;
        });
        if (!supportedMimeType) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        event.dropAction = event.proposedAction;
    }
    /**
     * Handle the `paste` event for the widget
     */
    _evtPaste(event) {
        var _a;
        const isEditable = (_a = this.model.getMetadata('editable')) !== null && _a !== void 0 ? _a : true;
        if (event.clipboardData && isEditable) {
            const items = event.clipboardData.items;
            for (let i = 0; i < items.length; i++) {
                if (items[i].type === 'text/plain') {
                    // Skip if this text is the path to a file
                    if (i < items.length - 1 && items[i + 1].kind === 'file') {
                        continue;
                    }
                    items[i].getAsString(text => {
                        var _a, _b;
                        (_b = (_a = this.editor).replaceSelection) === null || _b === void 0 ? void 0 : _b.call(_a, text.replace(/\r\n/g, '\n').replace(/\r/g, '\n'));
                    });
                }
                this._attachFiles(event.clipboardData.items);
            }
        }
        event.preventDefault();
    }
    /**
     * Handle the `drop` event for the widget
     */
    _evtNativeDrop(event) {
        if (event.dataTransfer) {
            this._attachFiles(event.dataTransfer.items);
        }
        event.preventDefault();
    }
    /**
     * Handle the `'lm-drop'` event for the widget.
     */
    _evtDrop(event) {
        const supportedMimeTypes = event.mimeData.types().filter(mimeType => {
            if (mimeType === CONTENTS_MIME_RICH) {
                const data = event.mimeData.getData(CONTENTS_MIME_RICH);
                return (rendermime_lib_index_js_.imageRendererFactory.mimeTypes.indexOf(data.model.mimetype) !== -1);
            }
            return rendermime_lib_index_js_.imageRendererFactory.mimeTypes.indexOf(mimeType) !== -1;
        });
        if (supportedMimeTypes.length === 0) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        if (event.proposedAction === 'none') {
            event.dropAction = 'none';
            return;
        }
        event.dropAction = 'copy';
        for (const mimeType of supportedMimeTypes) {
            if (mimeType === CONTENTS_MIME_RICH) {
                const { model, withContent } = event.mimeData.getData(CONTENTS_MIME_RICH);
                if (model.type === 'file') {
                    const URI = this._generateURI(model.name);
                    this.updateCellSourceWithAttachment(model.name, URI);
                    void withContent().then(fullModel => {
                        this.model.attachments.set(URI, {
                            [fullModel.mimetype]: fullModel.content
                        });
                    });
                }
            }
            else {
                // Pure mimetype, no useful name to infer
                const URI = this._generateURI();
                this.model.attachments.set(URI, {
                    [mimeType]: event.mimeData.getData(mimeType)
                });
                this.updateCellSourceWithAttachment(URI, URI);
            }
        }
    }
    /**
     * Attaches all DataTransferItems (obtained from
     * clipboard or native drop events) to the cell
     */
    _attachFiles(items) {
        for (let i = 0; i < items.length; i++) {
            const item = items[i];
            if (item.kind === 'file') {
                const blob = item.getAsFile();
                if (blob) {
                    this._attachFile(blob);
                }
            }
        }
    }
    /**
     * Takes in a file object and adds it to
     * the cell attachments
     */
    _attachFile(blob) {
        const reader = new FileReader();
        reader.onload = evt => {
            const { href, protocol } = coreutils_lib_index_js_.URLExt.parse(reader.result);
            if (protocol !== 'data:') {
                return;
            }
            const dataURIRegex = /([\w+\/\+]+)?(?:;(charset=[\w\d-]*|base64))?,(.*)/;
            const matches = dataURIRegex.exec(href);
            if (!matches || matches.length !== 4) {
                return;
            }
            const mimeType = matches[1];
            const encodedData = matches[3];
            const bundle = { [mimeType]: encodedData };
            const URI = this._generateURI(blob.name);
            if (mimeType.startsWith('image/')) {
                this.model.attachments.set(URI, bundle);
                this.updateCellSourceWithAttachment(blob.name, URI);
            }
        };
        reader.onerror = evt => {
            console.error(`Failed to attach ${blob.name}` + evt);
        };
        reader.readAsDataURL(blob);
    }
    /**
     * Generates a unique URI for a file
     * while preserving the file extension.
     */
    _generateURI(name = '') {
        const lastIndex = name.lastIndexOf('.');
        return lastIndex !== -1
            ? coreutils_dist_index_js_.UUID.uuid4().concat(name.substring(lastIndex))
            : coreutils_dist_index_js_.UUID.uuid4();
    }
}
/** ****************************************************************************
 * MarkdownCell
 ******************************************************************************/
/**
 * A widget for a Markdown cell.
 *
 * #### Notes
 * Things get complicated if we want the rendered text to update
 * any time the text changes, the text editor model changes,
 * or the input area model changes.  We don't support automatically
 * updating the rendered text in all of these cases.
 */
class widget_MarkdownCell extends AttachmentsCell {
    /**
     * Construct a Markdown cell widget.
     */
    constructor(options) {
        var _a, _b, _c, _d, _e;
        super({ ...options, placeholder: true });
        this._headingsCache = null;
        this._headingCollapsedChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._prevText = '';
        this._rendered = true;
        this._renderedChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._showEditorForReadOnlyMarkdown = true;
        this._cachedHeadingText = '';
        this._headingResolved = false;
        this.addClass(MARKDOWN_CELL_CLASS);
        this.model.contentChanged.connect(this.onContentChanged, this);
        const trans = this.translator.load('jupyterlab');
        this.node.setAttribute('aria-label', trans.__('Markdown Cell Content'));
        // Ensure we can resolve attachments:
        this._rendermime = options.rendermime.clone({
            resolver: new attachments_lib_index_js_.AttachmentsResolver({
                parent: (_a = options.rendermime.resolver) !== null && _a !== void 0 ? _a : undefined,
                model: this.model.attachments
            })
        });
        this._renderer = this._rendermime.createRenderer('text/markdown');
        this._renderer.addClass(MARKDOWN_OUTPUT_CLASS);
        // Check if heading cell is set to be collapsed
        this._headingCollapsed = ((_b = this.model.getMetadata(MARKDOWN_HEADING_COLLAPSED)) !== null && _b !== void 0 ? _b : false);
        this._showEditorForReadOnlyMarkdown =
            (_c = options.showEditorForReadOnlyMarkdown) !== null && _c !== void 0 ? _c : widget_MarkdownCell.defaultShowEditorForReadOnlyMarkdown;
        // Defer setting placeholder as the renderer must be instantiated before initializing the DOM
        this.placeholder = (_d = options.placeholder) !== null && _d !== void 0 ? _d : true;
        this._monitor = new coreutils_lib_index_js_.ActivityMonitor({
            signal: this.model.contentChanged,
            timeout: RENDER_TIMEOUT
        });
        // Throttle the rendering rate of the widget.
        this.ready
            .then(() => {
            if (this.isDisposed) {
                // Bail early
                return;
            }
            this._monitor.activityStopped.connect(() => {
                if (this._rendered) {
                    this.update();
                }
            }, this);
        })
            .catch(reason => {
            console.error('Failed to be ready', reason);
        });
        this._cachedHeadingText = this.model.sharedModel.getSource();
        this._emptyPlaceholder =
            (_e = options.emptyPlaceholder) !== null && _e !== void 0 ? _e : trans.__('Type Markdown and LaTeX: $ α^2 $');
    }
    /**
     * Text that represents the highest heading (i.e. lowest level) if cell is a heading.
     * Returns empty string if not a heading.
     */
    get headingInfo() {
        // Use table of content algorithm for consistency
        const headings = this.headings;
        if (headings.length > 0) {
            // Return the highest level
            const { text, level } = headings.reduce((prev, curr) => (prev.level <= curr.level ? prev : curr), headings[0]);
            return { text, level };
        }
        else {
            return { text: '', level: -1 };
        }
    }
    get headings() {
        var _a;
        return (_a = this._headingsCache) !== null && _a !== void 0 ? _a : [];
    }
    /**
     * Parses and returns the list of Markdown headings in the cell.
     *
     * @returns A promise that resolves to an array of cell headings.
     *
     * @remarks
     * This method caches the result after the first call to avoid redundant parsing.
     **/
    async getHeadings() {
        if (!this._headingsCache) {
            const headings = await toc_lib_index_js_.TableOfContentsUtils.Markdown.parseHeadings(this.model.sharedModel.getSource(), this._rendermime.markdownParser);
            this._headingsCache = headings.map(h => {
                return { ...h, type: widget_Cell.HeadingType.Markdown };
            });
            this._headingResolved = true;
            this.renderCollapseButtons();
        }
        return [...this._headingsCache];
    }
    /**
     * Whether the heading is collapsed or not.
     */
    get headingCollapsed() {
        return this._headingCollapsed;
    }
    set headingCollapsed(value) {
        var _a;
        if (this._headingCollapsed !== value) {
            this._headingCollapsed = value;
            if (value) {
                this.model.setMetadata(MARKDOWN_HEADING_COLLAPSED, value);
            }
            else if (this.model.getMetadata(MARKDOWN_HEADING_COLLAPSED) !== 'undefined') {
                this.model.deleteMetadata(MARKDOWN_HEADING_COLLAPSED);
            }
            const collapseButton = (_a = this.inputArea) === null || _a === void 0 ? void 0 : _a.promptNode.getElementsByClassName(HEADING_COLLAPSER_CLASS)[0];
            if (collapseButton) {
                if (value) {
                    collapseButton.classList.add('jp-mod-collapsed');
                }
                else {
                    collapseButton.classList.remove('jp-mod-collapsed');
                }
            }
            this.renderCollapseButtons(this._renderer);
            this._headingCollapsedChanged.emit(this._headingCollapsed);
        }
    }
    /**
     * Number of collapsed sub cells.
     */
    get numberChildNodes() {
        return this._numberChildNodes;
    }
    set numberChildNodes(value) {
        this._numberChildNodes = value;
        this.renderCollapseButtons(this._renderer);
    }
    /**
     * Signal emitted when the cell collapsed state changes.
     */
    get headingCollapsedChanged() {
        return this._headingCollapsedChanged;
    }
    /**
     * Whether the cell is rendered.
     */
    get rendered() {
        return this._rendered;
    }
    set rendered(value) {
        // Show cell as rendered when cell is not editable
        if (this.readOnly && this._showEditorForReadOnlyMarkdown === false) {
            value = true;
        }
        if (value === this._rendered) {
            return;
        }
        this._rendered = value;
        this._handleRendered()
            .then(() => {
            // If the rendered state changed, raise an event.
            this._displayChanged.emit();
            this._renderedChanged.emit(this._rendered);
        })
            .catch(reason => {
            console.error('Failed to render', reason);
        });
    }
    /**
     * Signal emitted when the markdown cell rendered state changes
     */
    get renderedChanged() {
        return this._renderedChanged;
    }
    /*
     * Whether the Markdown editor is visible in read-only mode.
     */
    get showEditorForReadOnly() {
        return this._showEditorForReadOnlyMarkdown;
    }
    set showEditorForReadOnly(value) {
        this._showEditorForReadOnlyMarkdown = value;
        if (value === false) {
            this.rendered = true;
        }
    }
    /**
     * Renderer
     */
    get renderer() {
        return this._renderer;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._monitor.dispose();
        super.dispose();
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        super.initializeDOM();
        this.renderCollapseButtons(this._renderer);
        this._handleRendered().catch(reason => {
            console.error('Failed to render', reason);
        });
    }
    maybeCreateCollapseButton() {
        var _a;
        const { level } = this.headingInfo;
        if (level > 0 &&
            ((_a = this.inputArea) === null || _a === void 0 ? void 0 : _a.promptNode.getElementsByClassName(HEADING_COLLAPSER_CLASS).length) == 0) {
            let collapseButton = this.inputArea.promptNode.appendChild(document.createElement('button'));
            collapseButton.className = `jp-Button ${HEADING_COLLAPSER_CLASS}`;
            collapseButton.setAttribute('data-heading-level', level.toString());
            if (this._headingCollapsed) {
                collapseButton.classList.add('jp-mod-collapsed');
            }
            else {
                collapseButton.classList.remove('jp-mod-collapsed');
            }
            collapseButton.onclick = (event) => {
                this.headingCollapsed = !this.headingCollapsed;
            };
        }
    }
    /**
     * Create, update or remove the hidden cells button.
     * Note that the actual visibility is controlled in Static Notebook by toggling jp-mod-showHiddenCellsButton class.
     */
    maybeCreateOrUpdateExpandButton() {
        const showHiddenCellsButtonList = this.node.getElementsByClassName(SHOW_HIDDEN_CELLS_CLASS);
        let trans = this.translator.load('jupyterlab');
        let buttonText = trans._n('%1 cell hidden', '%1 cells hidden', this._numberChildNodes);
        let needToCreateButton = this.headingCollapsed &&
            this._numberChildNodes > 0 &&
            showHiddenCellsButtonList.length == 0;
        if (needToCreateButton) {
            const newShowHiddenCellsButton = document.createElement('button');
            newShowHiddenCellsButton.className = `jp-mod-minimal jp-Button ${SHOW_HIDDEN_CELLS_CLASS}`;
            index_js_.addIcon.render(newShowHiddenCellsButton);
            const buttonTextElement = document.createElement('div');
            buttonTextElement.textContent = buttonText;
            newShowHiddenCellsButton.appendChild(buttonTextElement);
            newShowHiddenCellsButton.onclick = () => {
                this.headingCollapsed = false;
            };
            this.node.appendChild(newShowHiddenCellsButton);
        }
        let needToUpdateButtonText = this.headingCollapsed &&
            this._numberChildNodes > 0 &&
            showHiddenCellsButtonList.length == 1;
        if (needToUpdateButtonText) {
            showHiddenCellsButtonList[0].childNodes[1].textContent = buttonText;
        }
        let needToRemoveButton = !(this.headingCollapsed && this._numberChildNodes > 0);
        if (needToRemoveButton) {
            for (const button of showHiddenCellsButtonList) {
                this.node.removeChild(button);
            }
        }
    }
    /**
     * Callback on content changed
     */
    onContentChanged() {
        super.onContentChanged();
        const model = this.model;
        const text = model && model.sharedModel.getSource();
        // Do not set headingCache to null, if the text has not changed.
        if (text !== this._cachedHeadingText) {
            this._cachedHeadingText = text;
            this._headingsCache = null;
            this._headingResolved = false;
        }
    }
    /**
     * Render the collapse button for heading cells,
     * and for collapsed heading cells render the "expand hidden cells"
     * button.
     */
    renderCollapseButtons(widget) {
        this.node.classList.toggle(MARKDOWN_HEADING_COLLAPSED, this._headingCollapsed);
        this.maybeCreateCollapseButton();
        this.maybeCreateOrUpdateExpandButton();
    }
    /**
     * Render an input instead of the text editor.
     */
    renderInput(widget) {
        this.addClass(RENDERED_CLASS);
        if (!this.placeholder && !this.isDisposed) {
            this.renderCollapseButtons(widget);
            this.inputArea.renderInput(widget);
        }
    }
    /**
     * Show the text editor instead of rendered input.
     */
    showEditor() {
        this.removeClass(RENDERED_CLASS);
        if (!this.placeholder && !this.isDisposed) {
            this.inputArea.showEditor();
            // if this is going to be a heading, place the cursor accordingly
            let numHashAtStart = (this.model.sharedModel
                .getSource()
                .match(/^#+/g) || [''])[0].length;
            if (numHashAtStart > 0) {
                this.inputArea.editor.setCursorPosition({
                    column: numHashAtStart + 1,
                    line: 0
                }, { scroll: false });
            }
        }
    }
    /*
     * Handle `update-request` messages.
     */
    onUpdateRequest(msg) {
        // Make sure we are properly rendered.
        this._handleRendered().catch(reason => {
            console.error('Failed to render', reason);
        });
        super.onUpdateRequest(msg);
    }
    /**
     * Modify the cell source to include a reference to the attachment.
     */
    updateCellSourceWithAttachment(attachmentName, URI) {
        var _a, _b;
        const textToBeAppended = `![${attachmentName}](attachment:${URI !== null && URI !== void 0 ? URI : attachmentName})`;
        // TODO this should be done on the model...
        (_b = (_a = this.editor) === null || _a === void 0 ? void 0 : _a.replaceSelection) === null || _b === void 0 ? void 0 : _b.call(_a, textToBeAppended);
    }
    /**
     * Handle the rendered state.
     */
    async _handleRendered() {
        if (!this._rendered) {
            this.showEditor();
        }
        else {
            // TODO: It would be nice for the cell to provide a way for
            // its consumers to hook into when the rendering is done.
            await this._updateRenderedInput();
            if (this._rendered) {
                // The rendered flag may be updated in the mean time
                this.renderInput(this._renderer);
            }
        }
    }
    /**
     * Update the rendered input.
     */
    _updateRenderedInput() {
        if (this.placeholder) {
            return Promise.resolve();
        }
        const model = this.model;
        const text = (model && model.sharedModel.getSource()) || this._emptyPlaceholder;
        // Do not re-render if the text has not changed.
        if (text !== this._prevText) {
            const mimeModel = new rendermime_lib_index_js_.MimeModel({ data: { 'text/markdown': text } });
            this._prevText = text;
            return this._renderer.renderModel(mimeModel);
        }
        return Promise.resolve();
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime,
            placeholder: false,
            translator: this.translator
        });
    }
    get headingsResolved() {
        return this._headingResolved;
    }
}
/**
 * The namespace for the `CodeCell` class statics.
 */
(function (MarkdownCell) {
    /**
     * Default value for showEditorForReadOnlyMarkdown.
     */
    MarkdownCell.defaultShowEditorForReadOnlyMarkdown = true;
})(widget_MarkdownCell || (widget_MarkdownCell = {}));
/** ****************************************************************************
 * RawCell
 ******************************************************************************/
/**
 * A widget for a raw cell.
 */
class RawCell extends widget_Cell {
    /**
     * Construct a raw cell widget.
     */
    constructor(options) {
        super(options);
        this.addClass(RAW_CELL_CLASS);
        const trans = this.translator.load('jupyterlab');
        this.node.setAttribute('aria-label', trans.__('Raw Cell Content'));
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            placeholder: false,
            translator: this.translator
        });
    }
}
//# sourceMappingURL=widget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module cells
 */








//# sourceMappingURL=index.js.map

},
72600(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/rendermime/style/index.js + 1 modules
var rendermime_style = __webpack_require__(44847);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/attachments/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */


// EXTERNAL MODULE: ../node_modules/@lumino/dragdrop/style/index.js + 1 modules
var dragdrop_style = __webpack_require__(3809);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/codeeditor/style/index.js + 1 modules
var codeeditor_style = __webpack_require__(59259);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/documentsearch/style/index.js + 1 modules
var documentsearch_style = __webpack_require__(74357);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/codemirror/style/index.js + 1 modules
var codemirror_style = __webpack_require__(37957);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/filebrowser/style/index.js + 1 modules
var filebrowser_style = __webpack_require__(91618);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/outputarea/style/index.js + 1 modules
var outputarea_style = __webpack_require__(94888);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/toc/style/index.js + 1 modules
var toc_style = __webpack_require__(59982);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/cells/style/base.css
var base = __webpack_require__(77831);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/cells/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */
















},
61671(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ lib)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/notebook@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/notebook/lib/index.js)
var index_js_ = __webpack_require__(3530);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
var react_index_js_default = /*#__PURE__*/__webpack_require__.n(react_index_js_);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/algorithm/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(86554);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/celltags-extension/lib/celltag.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




/**
 * The class name added to the cell-tags field.
 */
const CELL_TAGS_WIDGET_CLASS = 'jp-CellTags';
/**
 * The class name added to each tag element.
 */
const CELL_TAGS_ELEMENT_CLASS = 'jp-CellTags-Tag';
/**
 * The class name added to each applied tag element.
 */
const CELL_TAGS_ELEMENT_APPLIED_CLASS = 'jp-CellTags-Applied';
/**
 * The class name added to each unapplied tag element.
 */
const CELL_TAGS_ELEMENT_UNAPPLIED_CLASS = 'jp-CellTags-Unapplied';
/**
 * The class name added to the tag holder.
 */
const CELL_TAGS_HOLDER_CLASS = 'jp-CellTags-Holder';
/**
 * The class name added to the add-tag input.
 */
const CELL_TAGS_ADD_CLASS = 'jp-CellTags-Add';
/**
 * The class name added to an empty input.
 */
const CELL_TAGS_EMPTY_CLASS = 'jp-CellTags-Empty';
class CellTagField {
    constructor(tracker, translator) {
        this._tracker = tracker;
        this._translator = translator || translation_lib_index_js_.nullTranslator;
        this._trans = this._translator.load('jupyterlab');
        this._editing = false;
    }
    addTag(props, tag) {
        const data = props.formData;
        if (tag && !data.includes(tag)) {
            data.push(tag);
            props.formContext.updateMetadata({ [props.name]: data }, true);
        }
    }
    /**
     * Pull from cell metadata all the tags used in the notebook and update the
     * stored tag list.
     */
    pullTags() {
        var _a, _b;
        const notebook = (_a = this._tracker) === null || _a === void 0 ? void 0 : _a.currentWidget;
        const cells = (_b = notebook === null || notebook === void 0 ? void 0 : notebook.model) === null || _b === void 0 ? void 0 : _b.cells;
        if (cells === undefined) {
            return [];
        }
        const allTags = (0,index_es6_js_.reduce)(cells, (allTags, cell) => {
            var _a;
            const tags = (_a = cell.getMetadata('tags')) !== null && _a !== void 0 ? _a : [];
            return [...allTags, ...tags];
        }, []);
        return [...new Set(allTags)].filter(tag => tag !== '');
    }
    _emptyAddTag(target) {
        target.value = '';
        target.style.width = '';
        target.classList.add(CELL_TAGS_EMPTY_CLASS);
    }
    _onAddTagKeyDown(props, event) {
        const input = event.target;
        if (event.ctrlKey)
            return;
        if (event.key === 'Enter') {
            this.addTag(props, input.value);
        }
        else if (event.key === 'Escape') {
            this._emptyAddTag(input);
        }
    }
    _onAddTagFocus(event) {
        if (!this._editing) {
            event.target.blur();
        }
    }
    _onAddTagBlur(input) {
        if (this._editing) {
            this._editing = false;
            this._emptyAddTag(input);
        }
    }
    _onChange(event) {
        if (!event.target.value) {
            this._emptyAddTag(event.target);
        }
        else {
            event.target.classList.remove(CELL_TAGS_EMPTY_CLASS);
            const tmp = document.createElement('span');
            tmp.className = CELL_TAGS_ADD_CLASS;
            tmp.textContent = event.target.value;
            // set width to the pixel length of the text
            document.body.appendChild(tmp);
            event.target.style.setProperty('width', `calc(${tmp.getBoundingClientRect().width}px + var(--jp-add-tag-extra-width))`);
            document.body.removeChild(tmp);
        }
    }
    _onAddTagClick(props, event) {
        const elem = event.target.closest('div');
        const input = elem === null || elem === void 0 ? void 0 : elem.childNodes[0];
        if (!this._editing) {
            this._editing = true;
            input.value = '';
            input.focus();
        }
        else if (event.target !== input) {
            this.addTag(props, input.value);
        }
        event.preventDefault();
    }
    _onTagClick(props, tag) {
        const data = props.formData;
        if (data.includes(tag)) {
            data.splice(data.indexOf(tag), 1);
        }
        else {
            data.push(tag);
        }
        props.formContext.updateMetadata({ [props.name]: data }, true);
    }
    render(props) {
        const allTags = this.pullTags();
        return (react_index_js_default().createElement("div", { className: CELL_TAGS_WIDGET_CLASS },
            react_index_js_default().createElement("div", { className: "jp-FormGroup-fieldLabel jp-FormGroup-contentItem" }, "Cell Tags"),
            allTags &&
                allTags.map((tag, i) => (react_index_js_default().createElement("div", { key: i, className: `${CELL_TAGS_ELEMENT_CLASS} ${props.formData.includes(tag)
                        ? CELL_TAGS_ELEMENT_APPLIED_CLASS
                        : CELL_TAGS_ELEMENT_UNAPPLIED_CLASS}`, onClick: () => this._onTagClick(props, tag) },
                    react_index_js_default().createElement("div", { className: CELL_TAGS_HOLDER_CLASS },
                        react_index_js_default().createElement("span", null, tag),
                        props.formData.includes(tag) && (react_index_js_default().createElement(lib_index_js_.LabIcon.resolveReact, { icon: lib_index_js_.checkIcon, tag: "span", elementPosition: "center", height: "18px", width: "18px", marginLeft: "5px", marginRight: "-3px" })))))),
            react_index_js_default().createElement("div", { className: `${CELL_TAGS_ELEMENT_CLASS} ${CELL_TAGS_ELEMENT_UNAPPLIED_CLASS}` },
                react_index_js_default().createElement("div", { className: CELL_TAGS_HOLDER_CLASS, onMouseDown: (e) => this._onAddTagClick(props, e) },
                    react_index_js_default().createElement("input", { className: `${CELL_TAGS_ADD_CLASS} ${CELL_TAGS_EMPTY_CLASS}`, type: "text", placeholder: this._trans.__('Add Tag'), onKeyDown: (e) => this._onAddTagKeyDown(props, e), onFocus: (e) => this._onAddTagFocus(e), onBlur: (e) => this._onAddTagBlur(e.target), onChange: (e) => {
                            this._onChange(e);
                        } }),
                    react_index_js_default().createElement(lib_index_js_.LabIcon.resolveReact, { icon: lib_index_js_.addIcon, tag: "span", height: "18px", width: "18px", className: CELL_TAGS_HOLDER_CLASS })))));
    }
}
//# sourceMappingURL=celltag.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/celltags-extension/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module celltags-extension
 */



/**
 * Registering cell tag field.
 */
const customCellTag = {
    id: '@jupyterlab/celltags-extension:plugin',
    description: 'Adds the cell tags editor.',
    autoStart: true,
    requires: [index_js_.INotebookTracker],
    optional: [lib_index_js_.IFormRendererRegistry],
    activate: (app, tracker, formRegistry) => {
        // Register the custom field
        if (formRegistry) {
            const component = {
                fieldRenderer: (props) => {
                    return new CellTagField(tracker).render(props);
                }
            };
            formRegistry.addRenderer('@jupyterlab/celltags-extension:plugin.renderer', component);
        }
    }
};
/* export default */ const lib = ([customCellTag]);
//# sourceMappingURL=index.js.map

},
91879(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(14546);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/notebook/style/index.js + 1 modules
var notebook_style = __webpack_require__(78320);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/celltags-extension/style/base.css
var base = __webpack_require__(3873);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/celltags-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/celltags-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */







},
50459(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  IPositionModel: () => (/* reexport */ IPositionModel),
  CodeViewerWidget: () => (/* reexport */ CodeViewerWidget),
  IEditorServices: () => (/* reexport */ IEditorServices),
  LineCol: () => (/* reexport */ lineCol_LineCol),
  COMPLETER_LINE_BEGINNING_CLASS: () => (/* reexport */ COMPLETER_LINE_BEGINNING_CLASS),
  CodeEditor: () => (/* reexport */ editor_CodeEditor),
  CodeEditorWrapper: () => (/* reexport */ CodeEditorWrapper),
  JSONEditor: () => (/* reexport */ JSONEditor),
  IEditorMimeTypeService: () => (/* reexport */ mimetype_IEditorMimeTypeService),
  COMPLETER_ENABLED_CLASS: () => (/* reexport */ COMPLETER_ENABLED_CLASS),
  COMPLETER_ACTIVE_CLASS: () => (/* reexport */ COMPLETER_ACTIVE_CLASS)
});

// EXTERNAL MODULE: consume shared module (default) @jupyter/ydoc@~3.1.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyter/ydoc/lib/index.js)
var index_js_ = __webpack_require__(67127);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/observables/lib/index.js)
var lib_index_js_ = __webpack_require__(81975);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(16324);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/mimetype.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * A namespace for `IEditorMimeTypeService`.
 */
var mimetype_IEditorMimeTypeService;
(function (IEditorMimeTypeService) {
    /**
     * The default mime type.
     */
    IEditorMimeTypeService.defaultMimeType = 'text/plain';
})(mimetype_IEditorMimeTypeService || (mimetype_IEditorMimeTypeService = {}));
//# sourceMappingURL=mimetype.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/editor.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * A namespace for code editors.
 *
 * #### Notes
 * - A code editor is a set of common assumptions which hold for all concrete editors.
 * - Changes in implementations of the code editor should only be caused by changes in concrete editors.
 * - Common JLab services which are based on the code editor should belong to `IEditorServices`.
 */
var editor_CodeEditor;
(function (CodeEditor) {
    /**
     * The default implementation of the editor model.
     */
    class Model {
        /**
         * Construct a new Model.
         */
        constructor(options = {}) {
            var _a, _b;
            /**
             * Whether the model should disposed the shared model on disposal or not.
             */
            this.standaloneModel = false;
            this._isDisposed = false;
            this._selections = new lib_index_js_.ObservableMap();
            this._mimeType = mimetype_IEditorMimeTypeService.defaultMimeType;
            this._mimeTypeChanged = new index_es6_js_.Signal(this);
            // Track if we need to dispose the model or not.
            this.standaloneModel = typeof options.sharedModel === 'undefined';
            this.sharedModel = (_a = options.sharedModel) !== null && _a !== void 0 ? _a : new index_js_.YFile();
            this._mimeType =
                (_b = options.mimeType) !== null && _b !== void 0 ? _b : mimetype_IEditorMimeTypeService.defaultMimeType;
        }
        /**
         * A signal emitted when a mimetype changes.
         */
        get mimeTypeChanged() {
            return this._mimeTypeChanged;
        }
        /**
         * Get the selections for the model.
         */
        get selections() {
            return this._selections;
        }
        /**
         * A mime type of the model.
         */
        get mimeType() {
            return this._mimeType;
        }
        set mimeType(newValue) {
            const oldValue = this.mimeType;
            if (oldValue === newValue) {
                return;
            }
            this._mimeType = newValue;
            this._mimeTypeChanged.emit({
                name: 'mimeType',
                oldValue: oldValue,
                newValue: newValue
            });
        }
        /**
         * Whether the model is disposed.
         */
        get isDisposed() {
            return this._isDisposed;
        }
        /**
         * Dispose of the resources used by the model.
         */
        dispose() {
            if (this._isDisposed) {
                return;
            }
            this._isDisposed = true;
            this._selections.dispose();
            if (this.standaloneModel) {
                this.sharedModel.dispose();
            }
            index_es6_js_.Signal.clearData(this);
        }
    }
    CodeEditor.Model = Model;
})(editor_CodeEditor || (editor_CodeEditor = {}));
//# sourceMappingURL=editor.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/widgets/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(34381);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/jsoneditor.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * The class name added to a JSONEditor instance.
 */
const JSONEDITOR_CLASS = 'jp-JSONEditor';
/**
 * The class name added when the Metadata editor contains invalid JSON.
 */
const ERROR_CLASS = 'jp-mod-error';
/**
 * The class name added to the editor host node.
 */
const HOST_CLASS = 'jp-JSONEditor-host';
/**
 * The class name added to the header area.
 */
const HEADER_CLASS = 'jp-JSONEditor-header';
/**
 * A widget for editing observable JSON.
 */
class JSONEditor extends dist_index_es6_js_.Widget {
    /**
     * Construct a new JSON editor.
     */
    constructor(options) {
        super();
        this._dataDirty = false;
        this._inputDirty = false;
        this._source = null;
        this._originalValue = dist_index_js_.JSONExt.emptyObject;
        this._changeGuard = false;
        this.translator = options.translator || translation_lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this.addClass(JSONEDITOR_CLASS);
        this.headerNode = document.createElement('div');
        this.headerNode.className = HEADER_CLASS;
        this.revertButtonNode = ui_components_lib_index_js_.undoIcon.element({
            tag: 'span',
            title: this._trans.__('Revert changes to data')
        });
        this.commitButtonNode = ui_components_lib_index_js_.checkIcon.element({
            tag: 'span',
            title: this._trans.__('Commit changes to data'),
            marginLeft: '8px'
        });
        this.editorHostNode = document.createElement('div');
        this.editorHostNode.className = HOST_CLASS;
        this.headerNode.appendChild(this.revertButtonNode);
        this.headerNode.appendChild(this.commitButtonNode);
        this.node.appendChild(this.headerNode);
        this.node.appendChild(this.editorHostNode);
        const model = new editor_CodeEditor.Model({ mimeType: 'application/json' });
        model.sharedModel.changed.connect(this._onModelChanged, this);
        this.model = model;
        this.editor = options.editorFactory({
            host: this.editorHostNode,
            model,
            config: {
                readOnly: true
            }
        });
    }
    /**
     * The observable source.
     */
    get source() {
        return this._source;
    }
    set source(value) {
        if (this._source === value) {
            return;
        }
        if (this._source) {
            this._source.changed.disconnect(this._onSourceChanged, this);
        }
        this._source = value;
        this.editor.setOption('readOnly', value === null);
        if (value) {
            value.changed.connect(this._onSourceChanged, this);
        }
        this._setValue();
    }
    /**
     * Get whether the editor is dirty.
     */
    get isDirty() {
        return this._dataDirty || this._inputDirty;
    }
    /**
     * Dispose of the editor.
     */
    dispose() {
        var _a;
        if (this.isDisposed) {
            return;
        }
        (_a = this.source) === null || _a === void 0 ? void 0 : _a.dispose();
        this.model.dispose();
        this.editor.dispose();
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'blur':
                this._evtBlur(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        const node = this.editorHostNode;
        node.addEventListener('blur', this, true);
        node.addEventListener('click', this, true);
        this.revertButtonNode.hidden = true;
        this.commitButtonNode.hidden = true;
        this.headerNode.addEventListener('click', this);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        const node = this.editorHostNode;
        node.removeEventListener('blur', this, true);
        node.removeEventListener('click', this, true);
        this.headerNode.removeEventListener('click', this);
    }
    /**
     * Handle a change to the metadata of the source.
     */
    _onSourceChanged(sender, args) {
        if (this._changeGuard) {
            return;
        }
        if (this._inputDirty || this.editor.hasFocus()) {
            this._dataDirty = true;
            return;
        }
        this._setValue();
    }
    /**
     * Handle change events.
     */
    _onModelChanged(model, change) {
        if (change.sourceChange) {
            let valid = true;
            try {
                const value = JSON.parse(this.editor.model.sharedModel.getSource());
                this.removeClass(ERROR_CLASS);
                this._inputDirty =
                    !this._changeGuard && !dist_index_js_.JSONExt.deepEqual(value, this._originalValue);
            }
            catch (err) {
                this.addClass(ERROR_CLASS);
                this._inputDirty = true;
                valid = false;
            }
            this.revertButtonNode.hidden = !this._inputDirty;
            this.commitButtonNode.hidden = !valid || !this._inputDirty;
        }
    }
    /**
     * Handle blur events for the text area.
     */
    _evtBlur(event) {
        // Update the metadata if necessary.
        if (!this._inputDirty && this._dataDirty) {
            this._setValue();
        }
    }
    /**
     * Handle click events for the buttons.
     */
    _evtClick(event) {
        const target = event.target;
        if (this.revertButtonNode.contains(target)) {
            this._setValue();
        }
        else if (this.commitButtonNode.contains(target)) {
            if (!this.commitButtonNode.hidden && !this.hasClass(ERROR_CLASS)) {
                this._changeGuard = true;
                this._mergeContent();
                this._changeGuard = false;
                this._setValue();
            }
        }
        else if (this.editorHostNode.contains(target)) {
            this.editor.focus();
        }
    }
    /**
     * Merge the user content.
     */
    _mergeContent() {
        const model = this.editor.model;
        const old = this._originalValue;
        const user = JSON.parse(model.sharedModel.getSource());
        const source = this.source;
        if (!source) {
            return;
        }
        // If it is in user and has changed from old, set in new.
        for (const key in user) {
            if (!dist_index_js_.JSONExt.deepEqual(user[key], old[key] || null)) {
                source.set(key, user[key]);
            }
        }
        // If it was in old and is not in user, remove from source.
        for (const key in old) {
            if (!(key in user)) {
                source.delete(key);
            }
        }
    }
    /**
     * Set the value given the owner contents.
     */
    _setValue() {
        this._dataDirty = false;
        this._inputDirty = false;
        this.revertButtonNode.hidden = true;
        this.commitButtonNode.hidden = true;
        this.removeClass(ERROR_CLASS);
        const model = this.editor.model;
        const content = this._source ? this._source.toJSON() : {};
        this._changeGuard = true;
        if (content === void 0) {
            model.sharedModel.setSource(this._trans.__('No data!'));
            this._originalValue = dist_index_js_.JSONExt.emptyObject;
        }
        else {
            const value = JSON.stringify(content, null, 4);
            model.sharedModel.setSource(value);
            this._originalValue = content;
            // Move the cursor to within the brace.
            if (value.length > 1 && value[0] === '{') {
                this.editor.setCursorPosition({ line: 0, column: 1 });
            }
        }
        this._changeGuard = false;
        this.commitButtonNode.hidden = true;
        this.revertButtonNode.hidden = true;
    }
}
//# sourceMappingURL=jsoneditor.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(69360);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
var react_index_js_default = /*#__PURE__*/__webpack_require__.n(react_index_js_);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var apputils_lib_index_js_ = __webpack_require__(3877);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/lineCol.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * A component for rendering a "go-to-line" form.
 */
class LineFormComponent extends (react_index_js_default()).Component {
    /**
     * Construct a new LineFormComponent.
     */
    constructor(props) {
        super(props);
        /**
         * Handle a change to the value in the input field.
         */
        this._handleChange = (event) => {
            this.setState({ value: event.currentTarget.value });
        };
        /**
         * Handle submission of the input field.
         */
        this._handleSubmit = (event) => {
            event.preventDefault();
            const value = parseInt(this._textInput.value, 10);
            if (!isNaN(value) &&
                isFinite(value) &&
                1 <= value &&
                value <= this.props.maxLine) {
                this.props.handleSubmit(value);
            }
            return false;
        };
        /**
         * Handle focusing of the input field.
         */
        this._handleFocus = () => {
            this.setState({ hasFocus: true });
        };
        /**
         * Handle blurring of the input field.
         */
        this._handleBlur = () => {
            this.setState({ hasFocus: false });
        };
        this._textInput = null;
        this.translator = props.translator || translation_lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this.state = {
            value: '',
            hasFocus: false,
            textInputId: apputils_lib_index_js_.DOMUtils.createDomID() + '-line-number-input'
        };
    }
    /**
     * Focus the element on mount.
     */
    componentDidMount() {
        this._textInput.focus();
    }
    /**
     * Render the LineFormComponent.
     */
    render() {
        return (react_index_js_default().createElement("div", { className: "jp-lineFormSearch" },
            react_index_js_default().createElement("form", { name: "lineColumnForm", onSubmit: this._handleSubmit, noValidate: true },
                react_index_js_default().createElement("div", { className: (0,ui_components_lib_index_js_.classes)('jp-lineFormWrapper', 'lm-lineForm-wrapper', this.state.hasFocus ? 'jp-lineFormWrapperFocusWithin' : undefined) },
                    react_index_js_default().createElement("input", { type: "text", id: this.state.textInputId, className: "jp-lineFormInput", onChange: this._handleChange, onFocus: this._handleFocus, onBlur: this._handleBlur, value: this.state.value, ref: input => {
                            this._textInput = input;
                        } }),
                    react_index_js_default().createElement("div", { className: "jp-baseLineForm jp-lineFormButtonContainer" },
                        react_index_js_default().createElement(ui_components_lib_index_js_.lineFormIcon.react, { className: "jp-baseLineForm jp-lineFormButtonIcon", elementPosition: "center" }),
                        react_index_js_default().createElement("input", { type: "submit", className: "jp-baseLineForm jp-lineFormButton", value: "" }))),
                react_index_js_default().createElement("label", { className: "jp-lineFormCaption", htmlFor: this.state.textInputId }, this._trans.__('Go to line number between 1 and %1', this.props.maxLine)))));
    }
}
/**
 * A pure functional component for rendering a line/column
 * status item.
 */
function LineColComponent(props) {
    const translator = props.translator || translation_lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    const keydownHandler = (event) => {
        if (event.key === 'Enter' ||
            event.key === 'Spacebar' ||
            event.key === ' ') {
            event.preventDefault();
            event.stopPropagation();
            props.handleClick();
        }
        else {
            return;
        }
    };
    return (react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { role: "button", "aria-haspopup": true, onClick: props.handleClick, source: trans.__('Ln %1, Col %2', props.line, props.column), title: trans.__('Go to line number…'), tabIndex: 0, onKeyDown: keydownHandler }));
}
/**
 * A widget implementing a line/column status item.
 */
class lineCol_LineCol extends ui_components_lib_index_js_.VDomRenderer {
    /**
     * Construct a new LineCol status item.
     */
    constructor(translator) {
        super(new lineCol_LineCol.Model());
        this._popup = null;
        this.addClass('jp-mod-highlighted');
        this.translator = translator || translation_lib_index_js_.nullTranslator;
    }
    /**
     * Render the status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react_index_js_default().createElement(LineColComponent, { line: this.model.line, column: this.model.column, translator: this.translator, handleClick: () => this._handleClick() }));
        }
    }
    /**
     * A click handler for the widget.
     */
    _handleClick() {
        if (this._popup) {
            this._popup.dispose();
        }
        const body = ui_components_lib_index_js_.ReactWidget.create(react_index_js_default().createElement(LineFormComponent, { handleSubmit: val => this._handleSubmit(val), currentLine: this.model.line, maxLine: this.model.editor.lineCount, translator: this.translator }));
        this._popup = (0,statusbar_lib_index_js_.showPopup)({
            body: body,
            anchor: this,
            align: 'right'
        });
    }
    /**
     * Handle submission for the widget.
     */
    _handleSubmit(value) {
        this.model.editor.setCursorPosition({ line: value - 1, column: 0 });
        this._popup.dispose();
        this.model.editor.focus();
    }
}
/**
 * A namespace for LineCol statics.
 */
(function (LineCol) {
    /**
     * A VDom model for a status item tracking the line/column of an editor.
     */
    class Model extends ui_components_lib_index_js_.VDomModel {
        constructor() {
            super(...arguments);
            /**
             * React to a change in the cursors of the current editor.
             */
            this._onSelectionChanged = () => {
                const oldState = this._getAllState();
                const pos = this.editor.getCursorPosition();
                this._line = pos.line + 1;
                this._column = pos.column + 1;
                this._triggerChange(oldState, this._getAllState());
            };
            this._line = 1;
            this._column = 1;
            this._editor = null;
        }
        /**
         * The current editor of the model.
         */
        get editor() {
            return this._editor;
        }
        set editor(editor) {
            var _a;
            const oldEditor = this._editor;
            if ((_a = oldEditor === null || oldEditor === void 0 ? void 0 : oldEditor.model) === null || _a === void 0 ? void 0 : _a.selections) {
                oldEditor.model.selections.changed.disconnect(this._onSelectionChanged);
            }
            const oldState = this._getAllState();
            this._editor = editor;
            if (!this._editor) {
                this._column = 1;
                this._line = 1;
            }
            else {
                this._editor.model.selections.changed.connect(this._onSelectionChanged);
                const pos = this._editor.getCursorPosition();
                this._column = pos.column + 1;
                this._line = pos.line + 1;
            }
            this._triggerChange(oldState, this._getAllState());
        }
        /**
         * The current line of the model.
         */
        get line() {
            return this._line;
        }
        /**
         * The current column of the model.
         */
        get column() {
            return this._column;
        }
        _getAllState() {
            return [this._line, this._column];
        }
        _triggerChange(oldState, newState) {
            if (oldState[0] !== newState[0] || oldState[1] !== newState[1]) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    LineCol.Model = Model;
})(lineCol_LineCol || (lineCol_LineCol = {}));
//# sourceMappingURL=lineCol.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/tokens.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A class added to editors that can host a completer.
 */
const COMPLETER_ENABLED_CLASS = 'jp-mod-completer-enabled';
/**
 * A class added to editors that have an active completer.
 */
const COMPLETER_ACTIVE_CLASS = 'jp-mod-completer-active';
/**
 * A class added to editors that have a cursor at the beginning of the line.
 */
const COMPLETER_LINE_BEGINNING_CLASS = 'jp-mod-at-line-beginning';
/**
 * Code editor services token.
 */
const IEditorServices = new dist_index_js_.Token('@jupyterlab/codeeditor:IEditorServices', `A service for the text editor provider
  for the application. Use this to create new text editors and host them in your
  UI elements.`);
/**
 * Code editor cursor position token.
 */
const IPositionModel = new dist_index_js_.Token('@jupyterlab/codeeditor:IPositionModel', `A service to handle an code editor cursor position.`);
//# sourceMappingURL=tokens.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/widget.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The class name added to an editor widget that has a primary selection.
 */
const HAS_SELECTION_CLASS = 'jp-mod-has-primary-selection';
/**
 * The class name added to an editor widget that has a cursor/selection
 * within the whitespace at the beginning of a line
 */
const HAS_IN_LEADING_WHITESPACE_CLASS = 'jp-mod-in-leading-whitespace';
/**
 * A class used to indicate a drop target.
 */
const DROP_TARGET_CLASS = 'jp-mod-dropTarget';
/**
 * RegExp to test for leading whitespace
 */
const leadingWhitespaceRe = /^\s+$/;
/**
 * A widget which hosts a code editor.
 */
class CodeEditorWrapper extends dist_index_es6_js_.Widget {
    /**
     * Construct a new code editor widget.
     */
    constructor(options) {
        super();
        const { factory, model, editorOptions } = options;
        const editor = (this.editor = factory({
            host: this.node,
            model,
            ...editorOptions
        }));
        editor.model.selections.changed.connect(this._onSelectionsChanged, this);
    }
    /**
     * Get the model used by the widget.
     */
    get model() {
        return this.editor.model;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.editor.dispose();
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'lm-dragenter':
                this._evtDragEnter(event);
                break;
            case 'lm-dragleave':
                this._evtDragLeave(event);
                break;
            case 'lm-dragover':
                this._evtDragOver(event);
                break;
            case 'lm-drop':
                this._evtDrop(event);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        this.editor.focus();
    }
    /**
     * A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        const node = this.node;
        node.addEventListener('lm-dragenter', this);
        node.addEventListener('lm-dragleave', this);
        node.addEventListener('lm-dragover', this);
        node.addEventListener('lm-drop', this);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        const node = this.node;
        node.removeEventListener('lm-dragenter', this);
        node.removeEventListener('lm-dragleave', this);
        node.removeEventListener('lm-dragover', this);
        node.removeEventListener('lm-drop', this);
    }
    /**
     * Handle a change in model selections.
     */
    _onSelectionsChanged() {
        const { start, end } = this.editor.getSelection();
        if (start.column !== end.column || start.line !== end.line) {
            // a selection was made
            this.addClass(HAS_SELECTION_CLASS);
            this.removeClass(HAS_IN_LEADING_WHITESPACE_CLASS);
        }
        else {
            // the cursor was placed
            this.removeClass(HAS_SELECTION_CLASS);
            if (this.editor
                .getLine(end.line)
                .slice(0, end.column)
                .match(leadingWhitespaceRe)) {
                this.addClass(HAS_IN_LEADING_WHITESPACE_CLASS);
            }
            else {
                this.removeClass(HAS_IN_LEADING_WHITESPACE_CLASS);
            }
        }
    }
    /**
     * Handle the `'lm-dragenter'` event for the widget.
     */
    _evtDragEnter(event) {
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = widget_Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        this.addClass('jp-mod-dropTarget');
    }
    /**
     * Handle the `'lm-dragleave'` event for the widget.
     */
    _evtDragLeave(event) {
        this.removeClass(DROP_TARGET_CLASS);
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = widget_Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
    }
    /**
     * Handle the `'lm-dragover'` event for the widget.
     */
    _evtDragOver(event) {
        this.removeClass(DROP_TARGET_CLASS);
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = widget_Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        event.dropAction = 'copy';
        this.addClass(DROP_TARGET_CLASS);
    }
    /**
     * Handle the `'lm-drop'` event for the widget.
     */
    _evtDrop(event) {
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = widget_Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        const coordinate = {
            top: event.y,
            bottom: event.y,
            left: event.x,
            right: event.x
        };
        const position = this.editor.getPositionForCoordinate(coordinate);
        if (position === null) {
            return;
        }
        this.removeClass(DROP_TARGET_CLASS);
        event.preventDefault();
        event.stopPropagation();
        if (event.proposedAction === 'none') {
            event.dropAction = 'none';
            return;
        }
        const offset = this.editor.getOffsetAt(position);
        this.model.sharedModel.updateSource(offset, offset, data);
    }
}
/**
 * A namespace for private functionality.
 */
var widget_Private;
(function (Private) {
    /**
     * Given a MimeData instance, extract the first text data, if any.
     */
    function findTextData(mime) {
        const types = mime.types();
        const textType = types.find(t => t.indexOf('text') === 0);
        if (textType === undefined) {
            return undefined;
        }
        return mime.getData(textType);
    }
    Private.findTextData = findTextData;
})(widget_Private || (widget_Private = {}));
//# sourceMappingURL=widget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/viewer.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



class CodeViewerWidget extends dist_index_es6_js_.Widget {
    /**
     * Construct a new code viewer widget.
     */
    constructor(options) {
        var _a;
        super();
        this.model = options.model;
        const editorWidget = new CodeEditorWrapper({
            factory: options.factory,
            model: this.model,
            editorOptions: {
                ...options.editorOptions,
                config: { ...(_a = options.editorOptions) === null || _a === void 0 ? void 0 : _a.config, readOnly: true }
            }
        });
        this.editor = editorWidget.editor;
        const layout = (this.layout = new dist_index_es6_js_.StackedLayout());
        layout.addWidget(editorWidget);
    }
    static createCodeViewer(options) {
        const { content, mimeType, ...others } = options;
        const model = new editor_CodeEditor.Model({
            mimeType
        });
        model.sharedModel.setSource(content);
        const widget = new CodeViewerWidget({ ...others, model });
        widget.disposed.connect(() => {
            model.dispose();
        });
        return widget;
    }
    get content() {
        return this.model.sharedModel.getSource();
    }
    get mimeType() {
        return this.model.mimeType;
    }
}
//# sourceMappingURL=viewer.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module codeeditor
 */








//# sourceMappingURL=index.js.map

},
59259(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(29401);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(21455);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(67842);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(4620);
// EXTERNAL MODULE: ../node_modules/@lumino/dragdrop/style/index.js + 1 modules
var dragdrop_style = __webpack_require__(3809);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(95292);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(49893);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(9383);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(56884);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(99088);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(27997);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/codeeditor/style/base.css
var base = __webpack_require__(59284);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* ["default"] */.A, options);




       /* export default */ const style_base = (base/* ["default"] */.A && base/* ["default"].locals */.A.locals ? base/* ["default"].locals */.A.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codeeditor/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */









},
17770(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ lib),
  lineColItem: () => (/* binding */ lineColItem)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/application@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/application/lib/index.js)
var index_js_ = __webpack_require__(11158);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/codeeditor@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/codeeditor/lib/index.js)
var lib_index_js_ = __webpack_require__(34390);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(69360);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
// EXTERNAL MODULE: consume shared module (default) @codemirror/commands@^6.8.1 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/commands/dist/index.js)
var dist_index_js_ = __webpack_require__(87880);
// EXTERNAL MODULE: consume shared module (default) @codemirror/language@^6.11.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/language/dist/index.js)
var language_dist_index_js_ = __webpack_require__(82614);
// EXTERNAL MODULE: consume shared module (default) @codemirror/search@^6.5.10 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/search/dist/index.js)
var search_dist_index_js_ = __webpack_require__(59332);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/notebook@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/notebook/lib/index.js)
var notebook_lib_index_js_ = __webpack_require__(3530);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.7.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/apputils/lib/index.js)
var apputils_lib_index_js_ = __webpack_require__(3877);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror-extension/lib/commands.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */






/**
 * Identifiers of commands.
 */
var commands_CommandIDs;
(function (CommandIDs) {
    CommandIDs.deleteLine = 'codemirror:delete-line';
    CommandIDs.toggleBlockComment = 'codemirror:toggle-block-comment';
    CommandIDs.toggleComment = 'codemirror:toggle-comment';
    CommandIDs.selectNextOccurrence = 'codemirror:select-next-occurrence';
    CommandIDs.toggleTabFocusMode = 'codemirror:toggle-tab-focus-mode';
    CommandIDs.foldCurrent = 'codemirror:fold-current';
    CommandIDs.unfoldCurrent = 'codemirror:unfold-current';
    CommandIDs.foldSubregions = 'codemirror:fold-subregions';
    CommandIDs.unfoldSubregions = 'codemirror:unfold-subregions';
    CommandIDs.foldAll = 'codemirror:fold-all';
    CommandIDs.unfoldAll = 'codemirror:unfold-all';
})(commands_CommandIDs || (commands_CommandIDs = {}));
/**
 * Selector for CodeMirror editor with `cmView` attribute.
 */
const CODE_MIRROR_SELECTOR = '.cm-content';
/**
 * The editor commands.
 */
const commandsPlugin = {
    id: '@jupyterlab/codemirror-extension:commands',
    description: 'Registers commands acting on selected/active CodeMirror editor.',
    autoStart: true,
    requires: [notebook_lib_index_js_.INotebookTracker],
    optional: [translation_lib_index_js_.ITranslator, apputils_lib_index_js_.ICommandPalette],
    activate: (app, tracker, translator, palette) => {
        translator = translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const isCodeMirror = (node) => node.classList.contains(CODE_MIRROR_SELECTOR);
        const findEditorView = () => {
            var _a, _b;
            const node = (_a = app.contextMenuHitTest(isCodeMirror)) !== null && _a !== void 0 ? _a : (_b = document.activeElement) === null || _b === void 0 ? void 0 : _b.closest(CODE_MIRROR_SELECTOR);
            if (!node) {
                return;
            }
            if (!('cmView' in node)) {
                return;
            }
            return node.cmView.view;
        };
        const isEnabled = () => {
            return !!findEditorView();
        };
        const getActiveEditorInfo = () => {
            var _a, _b;
            const currentWidget = app.shell.currentWidget;
            // Check for active notebook
            const notebook = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
            if (tracker.currentWidget !== null &&
                tracker.currentWidget === currentWidget &&
                notebook &&
                notebook.activeCell) {
                return {
                    type: 'notebook',
                    widget: currentWidget,
                    notebook,
                    isEnabled: true
                };
            }
            // Check for file editor
            const fileEditorWidget = currentWidget;
            if (fileEditorWidget &&
                fileEditorWidget.content &&
                typeof ((_b = fileEditorWidget.content.editor) === null || _b === void 0 ? void 0 : _b.focus) === 'function') {
                return {
                    type: 'fileEditor',
                    widget: fileEditorWidget,
                    isEnabled: true
                };
            }
            return {
                type: 'none',
                widget: null,
                isEnabled: false
            };
        };
        // Simplified isEnabled function using the helper
        const isCodeFoldingEnabled = () => {
            return getActiveEditorInfo().isEnabled;
        };
        app.commands.addCommand(commands_CommandIDs.deleteLine, {
            label: trans.__('Delete the current line'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                const view = findEditorView();
                if (!view) {
                    return;
                }
                (0,dist_index_js_.deleteLine)(view);
            },
            isEnabled
        });
        app.commands.addCommand(commands_CommandIDs.toggleBlockComment, {
            label: trans.__('Toggle Block Comment'),
            caption: trans.__('Toggles block comments in languages which support it (e.g. C, JavaScript)'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                const view = findEditorView();
                if (!view) {
                    return;
                }
                (0,dist_index_js_.toggleBlockComment)(view);
            },
            isEnabled
        });
        app.commands.addCommand(commands_CommandIDs.toggleComment, {
            label: trans.__('Toggle Comment'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                const view = findEditorView();
                if (!view) {
                    return;
                }
                (0,dist_index_js_.toggleComment)(view);
            },
            isEnabled
        });
        app.commands.addCommand(commands_CommandIDs.toggleTabFocusMode, {
            label: trans.__('Toggle Tab Focus Mode'),
            caption: trans.__('Toggles behavior of Tab key between inserting indentation and moving to next focusable element'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                const view = findEditorView();
                if (!view) {
                    return;
                }
                (0,dist_index_js_.toggleTabFocusMode)(view);
            },
            isEnabled
        });
        app.commands.addCommand(commands_CommandIDs.selectNextOccurrence, {
            label: trans.__('Select Next Occurrence'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                const view = findEditorView();
                if (!view) {
                    return;
                }
                (0,search_dist_index_js_.selectNextOccurrence)(view);
            },
            isEnabled
        });
        app.commands.addCommand(commands_CommandIDs.foldCurrent, {
            label: trans.__('Fold Current Region'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            // Updated execute function using the helper
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                const { state } = view;
                const pos = state.selection.main.head;
                const line = state.doc.lineAt(pos);
                const range = (0,language_dist_index_js_.foldable)(state, line.from, line.to);
                if (range) {
                    (0,language_dist_index_js_.foldCode)(view);
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        app.commands.addCommand(commands_CommandIDs.unfoldCurrent, {
            label: trans.__('Unfold Current Region'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                const { state } = view;
                const pos = state.selection.main.head;
                const line = state.doc.lineAt(pos);
                const range = (0,language_dist_index_js_.foldable)(state, line.from, line.to);
                if (range) {
                    (0,language_dist_index_js_.unfoldCode)(view);
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        app.commands.addCommand(commands_CommandIDs.foldSubregions, {
            label: trans.__('Fold All Subregions'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                try {
                    const { state } = view;
                    const pos = state.selection.main.head;
                    const line = state.doc.lineAt(pos);
                    const topRegion = (0,language_dist_index_js_.foldable)(state, line.from, line.to);
                    let hasFoldState = false;
                    try {
                        const currentFoldState = state.field(language_dist_index_js_.foldState, false);
                        hasFoldState = currentFoldState !== undefined;
                    }
                    catch (e) {
                        hasFoldState = false;
                    }
                    if (!hasFoldState) {
                        // Prime the folding system with a dummy fold/unfold
                        (0,language_dist_index_js_.foldCode)(view);
                        (0,language_dist_index_js_.unfoldCode)(view);
                    }
                    if (!topRegion) {
                        return;
                    }
                    const effects = [];
                    let subPos = topRegion.from + 1;
                    while (subPos < topRegion.to) {
                        const subLine = state.doc.lineAt(subPos);
                        const subRange = (0,language_dist_index_js_.foldable)(state, subLine.from, subLine.to);
                        if (subRange &&
                            subRange.from > topRegion.from &&
                            subRange.to <= topRegion.to) {
                            effects.push(language_dist_index_js_.foldEffect.of(subRange));
                            subPos = subRange.to;
                        }
                        else {
                            subPos = subLine.to + 1;
                        }
                    }
                    if (effects.length > 0) {
                        view.dispatch({ effects });
                    }
                }
                catch (e) {
                    // Silent fail
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        app.commands.addCommand(commands_CommandIDs.unfoldSubregions, {
            label: trans.__('Unfold All Subregions'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                try {
                    const { state } = view;
                    const pos = state.selection.main.head;
                    const line = state.doc.lineAt(pos);
                    const topRegion = (0,language_dist_index_js_.foldable)(state, line.from, line.to);
                    if (!topRegion) {
                        return;
                    }
                    const foldedRanges = state.field(language_dist_index_js_.foldState, false);
                    if (!foldedRanges) {
                        return;
                    }
                    const effects = [];
                    foldedRanges.between(topRegion.from + 1, topRegion.to, (from, to) => {
                        if (from > topRegion.from && to <= topRegion.to) {
                            effects.push(language_dist_index_js_.unfoldEffect.of({ from, to }));
                        }
                    });
                    if (effects.length > 0) {
                        view.dispatch({ effects });
                    }
                }
                catch (e) {
                    // Silent fail
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        app.commands.addCommand(commands_CommandIDs.foldAll, {
            label: trans.__('Fold All Regions'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                try {
                    (0,language_dist_index_js_.foldAll)(view);
                }
                catch (e) {
                    // Silent fail
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        app.commands.addCommand(commands_CommandIDs.unfoldAll, {
            label: trans.__('Unfold All Regions'),
            describedBy: {
                args: {
                    type: 'object',
                    properties: {}
                }
            },
            execute: () => {
                var _a;
                const editorInfo = getActiveEditorInfo();
                if (editorInfo.type === 'notebook') {
                    editorInfo.notebook.mode = 'edit';
                    if (editorInfo.notebook.activeCell) {
                        (_a = editorInfo.notebook.activeCell.editor) === null || _a === void 0 ? void 0 : _a.focus();
                    }
                }
                else if (editorInfo.type === 'fileEditor') {
                    editorInfo.widget.content.editor.focus();
                }
                const view = findEditorView();
                if (!view) {
                    return;
                }
                try {
                    (0,language_dist_index_js_.unfoldAll)(view);
                }
                catch (e) {
                    // Silent fail
                }
            },
            isEnabled: isCodeFoldingEnabled
        });
        if (palette) {
            const category = trans.__('File Operations');
            [
                commands_CommandIDs.foldCurrent,
                commands_CommandIDs.unfoldCurrent,
                commands_CommandIDs.foldSubregions,
                commands_CommandIDs.unfoldSubregions,
                commands_CommandIDs.foldAll,
                commands_CommandIDs.unfoldAll
            ].forEach(command => {
                palette.addItem({ command, category });
            });
        }
    }
};
//# sourceMappingURL=commands.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/codemirror@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/codemirror/lib/index.js)
var codemirror_lib_index_js_ = __webpack_require__(48774);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(19352);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(58948);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var coreutils_dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @rjsf/validator-ajv8@^5.13.4 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@rjsf/validator-ajv8/lib/index.js)
var validator_ajv8_lib_index_js_ = __webpack_require__(1910);
var validator_ajv8_lib_index_js_default = /*#__PURE__*/__webpack_require__.n(validator_ajv8_lib_index_js_);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/react/index.js)
var react_index_js_ = __webpack_require__(38550);
var react_index_js_default = /*#__PURE__*/__webpack_require__.n(react_index_js_);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror-extension/lib/services.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */









/**
 * CodeMirror settings plugin ID
 */
const SETTINGS_ID = '@jupyterlab/codemirror-extension:plugin';
/**
 * CodeMirror language registry provider.
 */
const languagePlugin = {
    id: '@jupyterlab/codemirror-extension:languages',
    description: 'Provides the CodeMirror languages registry.',
    provides: codemirror_lib_index_js_.IEditorLanguageRegistry,
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        const languages = new codemirror_lib_index_js_.EditorLanguageRegistry();
        // Register default languages
        for (const language of codemirror_lib_index_js_.EditorLanguageRegistry.getDefaultLanguages(translator)) {
            languages.addLanguage(language);
        }
        // Add Jupyter Markdown flavor here to support
        // code block highlighting.
        languages.addLanguage({
            name: 'ipythongfm',
            mime: 'text/x-ipythongfm',
            load: async () => {
                const [m, py, tex] = await Promise.all([
                    __webpack_require__.e(/* import() */ "9580").then(__webpack_require__.t.bind(__webpack_require__, 42167, 23)),
                    Promise.all(/* import() */ [__webpack_require__.e("9924"), __webpack_require__.e("7451"), __webpack_require__.e("11"), __webpack_require__.e("2808"), __webpack_require__.e("6983"), __webpack_require__.e("8780")]).then(__webpack_require__.bind(__webpack_require__, 39558)),
                    __webpack_require__.e(/* import() */ "8179").then(__webpack_require__.bind(__webpack_require__, 73358))
                ]);
                const mdlang = m.markdown({
                    base: m.markdownLanguage,
                    codeLanguages: (info) => languages.findBest(info),
                    extensions: [
                        (0,codemirror_lib_index_js_.parseMathIPython)(language_dist_index_js_.StreamLanguage.define(tex.stexMath).parser)
                    ]
                });
                return new language_dist_index_js_.LanguageSupport(mdlang.language, [
                    mdlang.support,
                    (0,codemirror_lib_index_js_.pythonBuiltin)(py.pythonLanguage)
                ]);
            }
        });
        return languages;
    }
};
/**
 * CodeMirror theme registry provider.
 */
const themePlugin = {
    id: '@jupyterlab/codemirror-extension:themes',
    description: 'Provides the CodeMirror theme registry',
    provides: codemirror_lib_index_js_.IEditorThemeRegistry,
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        const themes = new codemirror_lib_index_js_.EditorThemeRegistry();
        // Register default themes
        for (const theme of codemirror_lib_index_js_.EditorThemeRegistry.getDefaultThemes(translator)) {
            themes.addTheme(theme);
        }
        return themes;
    }
};
/**
 * CodeMirror editor extensions registry provider.
 */
const extensionPlugin = {
    id: '@jupyterlab/codemirror-extension:extensions',
    description: 'Provides the CodeMirror extension factory registry.',
    provides: codemirror_lib_index_js_.IEditorExtensionRegistry,
    requires: [codemirror_lib_index_js_.IEditorThemeRegistry],
    optional: [translation_lib_index_js_.ITranslator, settingregistry_lib_index_js_.ISettingRegistry, ui_components_lib_index_js_.IFormRendererRegistry],
    activate: (app, themes, translator, settingRegistry, formRegistry) => {
        const registry = new codemirror_lib_index_js_.EditorExtensionRegistry();
        // Register default extensions
        for (const extensionFactory of codemirror_lib_index_js_.EditorExtensionRegistry.getDefaultExtensions({
            themes,
            translator
        })) {
            registry.addExtension(extensionFactory);
        }
        if (settingRegistry) {
            const updateSettings = (settings) => {
                var _a;
                registry.baseConfiguration =
                    (_a = settings.get('defaultConfig').composite) !== null && _a !== void 0 ? _a : {};
            };
            void Promise.all([
                settingRegistry.load(SETTINGS_ID),
                app.restored
            ]).then(([settings]) => {
                updateSettings(settings);
                settings.changed.connect(updateSettings);
            });
            formRegistry === null || formRegistry === void 0 ? void 0 : formRegistry.addRenderer(`${SETTINGS_ID}.defaultConfig`, {
                fieldRenderer: (props) => {
                    let defaultFormData;
                    const properties = react_index_js_default().useMemo(() => registry.settingsSchema, []);
                    if (props.name in props.formContext.defaultFormData) {
                        defaultFormData = props.formContext.defaultFormData[props.name];
                    }
                    else {
                        defaultFormData = {};
                    }
                    // Only provide customizable options
                    for (const [key, value] of Object.entries(registry.defaultConfiguration)) {
                        if (typeof properties[key] !== 'undefined' &&
                            !(key in defaultFormData)) {
                            defaultFormData[key] = value;
                        }
                    }
                    return (react_index_js_default().createElement("div", { className: "jp-FormGroup-contentNormal" },
                        react_index_js_default().createElement("h3", { className: "jp-FormGroup-fieldLabel jp-FormGroup-contentItem" }, props.schema.title),
                        props.schema.description && (react_index_js_default().createElement("div", { className: "jp-FormGroup-description" }, props.schema.description)),
                        react_index_js_default().createElement(ui_components_lib_index_js_.FormComponent, { schema: {
                                title: props.schema.title,
                                description: props.schema.description,
                                type: 'object',
                                properties,
                                additionalProperties: false
                            }, validator: (validator_ajv8_lib_index_js_default()), formData: { ...defaultFormData, ...props.formData }, formContext: { defaultFormData }, liveValidate: true, onChange: e => {
                                var _a;
                                // Only save non-default values
                                const nonDefault = {};
                                for (const [property, value] of Object.entries((_a = e.formData) !== null && _a !== void 0 ? _a : {})) {
                                    const default_ = defaultFormData[property];
                                    if (default_ === undefined ||
                                        !coreutils_dist_index_js_.JSONExt.deepEqual(value, default_)) {
                                        nonDefault[property] = value;
                                    }
                                }
                                props.onChange(nonDefault);
                            }, tagName: "div", translator: translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator })));
                }
            });
        }
        return registry;
    }
};
/**
 * CodeMirror shared model binding provider.
 */
const bindingPlugin = {
    id: '@jupyterlab/codemirror-extension:binding',
    description: 'Register the CodeMirror extension factory binding the editor and the shared model.',
    autoStart: true,
    requires: [codemirror_lib_index_js_.IEditorExtensionRegistry],
    activate: (app, extensions) => {
        extensions.addExtension({
            name: 'shared-model-binding',
            factory: options => {
                var _a;
                const sharedModel = options.model.sharedModel;
                return codemirror_lib_index_js_.EditorExtensionRegistry.createImmutableExtension((0,codemirror_lib_index_js_.ybinding)({
                    ytext: sharedModel.ysource,
                    undoManager: (_a = sharedModel.undoManager) !== null && _a !== void 0 ? _a : undefined
                }));
            }
        });
    }
};
/**
 * The editor services.
 */
const servicesPlugin = {
    id: '@jupyterlab/codemirror-extension:services',
    description: 'Provides the service to instantiate CodeMirror editors.',
    provides: lib_index_js_.IEditorServices,
    requires: [codemirror_lib_index_js_.IEditorLanguageRegistry, codemirror_lib_index_js_.IEditorExtensionRegistry],
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, languages, extensions, translator) => {
        const factory = new codemirror_lib_index_js_.CodeMirrorEditorFactory({
            extensions,
            languages,
            translator: translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator
        });
        return {
            factoryService: factory,
            mimeTypeService: new codemirror_lib_index_js_.CodeMirrorMimeTypeService(languages)
        };
    }
};
//# sourceMappingURL=services.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror-extension/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module codemirror-extension
 */






/**
 * A plugin providing a line/column status item to the application.
 */
const lineColItem = {
    id: '@jupyterlab/codemirror-extension:line-col-status',
    description: 'Provides the code editor cursor position model.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILabShell, statusbar_lib_index_js_.IStatusBar],
    provides: lib_index_js_.IPositionModel,
    activate: (app, translator, labShell, statusBar) => {
        const item = new lib_index_js_.LineCol(translator);
        const providers = new Set();
        if (statusBar) {
            // Add the status item to the status bar.
            statusBar.registerStatusItem(lineColItem.id, {
                priority: 1,
                item,
                align: 'right',
                rank: 2,
                isActive: () => !!item.model.editor
            });
        }
        const addEditorProvider = (provider) => {
            providers.add(provider);
            if (app.shell.currentWidget) {
                updateEditor(app.shell, {
                    newValue: app.shell.currentWidget,
                    oldValue: null
                });
            }
        };
        const update = () => {
            updateEditor(app.shell, {
                oldValue: app.shell.currentWidget,
                newValue: app.shell.currentWidget
            });
        };
        function updateEditor(shell, changes) {
            Promise.all([...providers].map(provider => provider(changes.newValue)))
                .then(editors => {
                var _a;
                item.model.editor =
                    (_a = editors.filter(editor => editor !== null)[0]) !== null && _a !== void 0 ? _a : null;
            })
                .catch(reason => {
                console.error('Get editors', reason);
            });
        }
        if (labShell) {
            labShell.currentChanged.connect(updateEditor);
        }
        return { addEditorProvider, update };
    }
};
/**
 * Export the plugins as default.
 */
const plugins = [
    commandsPlugin,
    languagePlugin,
    themePlugin,
    bindingPlugin,
    extensionPlugin,
    servicesPlugin,
    lineColItem
];
/* export default */ const lib = (plugins);
//# sourceMappingURL=index.js.map

},
14640(__unused_rspack_module, __unused_rspack___webpack_exports__, __webpack_require__) {
"use strict";
/* import */ var _lumino_widgets_style_index_js__rspack_import_0 = __webpack_require__(29401);
/* import */ var _jupyterlab_ui_components_style_index_js__rspack_import_1 = __webpack_require__(21455);
/* import */ var _jupyterlab_statusbar_style_index_js__rspack_import_2 = __webpack_require__(67842);
/* import */ var _jupyterlab_apputils_style_index_js__rspack_import_3 = __webpack_require__(4620);
/* import */ var _jupyterlab_codeeditor_style_index_js__rspack_import_4 = __webpack_require__(59259);
/* import */ var _jupyterlab_application_style_index_js__rspack_import_5 = __webpack_require__(14546);
/* import */ var _jupyterlab_codemirror_style_index_js__rspack_import_6 = __webpack_require__(37957);
/* import */ var _jupyterlab_notebook_style_index_js__rspack_import_7 = __webpack_require__(78320);
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */










},
52075(__unused_rspack_module, __webpack_exports__, __webpack_require__) {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  customTheme: () => (/* reexport */ customTheme),
  YRange: () => (/* reexport */ YRange),
  CodeMirrorEditor: () => (/* reexport */ CodeMirrorEditor),
  jupyterTheme: () => (/* reexport */ jupyterTheme),
  CodeMirrorEditorFactory: () => (/* reexport */ CodeMirrorEditorFactory),
  CodeMirrorSearchHighlighter: () => (/* reexport */ CodeMirrorSearchHighlighter),
  IEditorExtensionRegistry: () => (/* reexport */ IEditorExtensionRegistry),
  IEditorThemeRegistry: () => (/* reexport */ IEditorThemeRegistry),
  jupyterEditorTheme: () => (/* reexport */ jupyterEditorTheme),
  parseMathIPython: () => (/* reexport */ parseMathIPython),
  EditorThemeRegistry: () => (/* reexport */ theme_EditorThemeRegistry),
  jupyterHighlightStyle: () => (/* reexport */ jupyterHighlightStyle),
  pythonBuiltin: () => (/* reexport */ pythonBuiltin),
  rulers: () => (/* reexport */ rulers),
  ySync: () => (/* reexport */ ySync),
  CodeMirrorMimeTypeService: () => (/* reexport */ CodeMirrorMimeTypeService),
  EditorLanguageRegistry: () => (/* reexport */ language_EditorLanguageRegistry),
  ySyncFacet: () => (/* reexport */ ySyncFacet),
  StateCommands: () => (/* reexport */ commands_StateCommands),
  ybinding: () => (/* reexport */ ybinding),
  ySyncAnnotation: () => (/* reexport */ ySyncAnnotation),
  EditorSearchProvider: () => (/* reexport */ EditorSearchProvider),
  PythonBuiltin: () => (/* reexport */ PythonBuiltin),
  EditorExtensionRegistry: () => (/* reexport */ extension_EditorExtensionRegistry),
  ExtensionsHandler: () => (/* reexport */ ExtensionsHandler),
  IEditorLanguageRegistry: () => (/* reexport */ IEditorLanguageRegistry),
  YSyncConfig: () => (/* reexport */ YSyncConfig)
});

// EXTERNAL MODULE: consume shared module (default) @codemirror/commands@^6.8.1 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/commands/dist/index.js)
var index_js_ = __webpack_require__(87880);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/codeeditor@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/codeeditor/lib/index.js)
var lib_index_js_ = __webpack_require__(34390);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/commands.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Selector for a widget that can run code.
 */
const CODE_RUNNER_SELECTOR = '[data-jp-code-runner]';
/**
 * Selector for a widget that can run code in terminal mode.
 */
const TERMINAL_CODE_RUNNER_SELECTOR = '[data-jp-interaction-mode="terminal"]';
/**
 * Selector for a widget that can open a tooltip.
 */
const TOOLTIP_OPENER_SELECTOR = '.jp-CodeMirrorEditor:not(.jp-mod-has-primary-selection):not(.jp-mod-in-leading-whitespace):not(.jp-mod-completer-active)';
/**
 * Selector for an active cell in edit mode.
 */
const ACTIVE_CELL_IN_EDIT_MODE_SELECTOR = '.jp-mod-editMode .jp-Cell.jp-mod-active';
/**
 * CodeMirror commands namespace
 */
var commands_StateCommands;
(function (StateCommands) {
    /**
     * Indent or insert a tab as appropriate.
     */
    function indentMoreOrInsertTab(target) {
        var _a;
        let classList = (_a = target.dom.parentElement) === null || _a === void 0 ? void 0 : _a.classList;
        let completerEnabled = classList === null || classList === void 0 ? void 0 : classList.contains(lib_index_js_.COMPLETER_ENABLED_CLASS);
        let lineBeggining = classList === null || classList === void 0 ? void 0 : classList.contains(lib_index_js_.COMPLETER_LINE_BEGINNING_CLASS);
        if (completerEnabled && !lineBeggining) {
            return false;
        }
        const arg = { state: target.state, dispatch: target.dispatch };
        const from = target.state.selection.main.from;
        const to = target.state.selection.main.to;
        if (from != to) {
            return (0,index_js_.indentMore)(arg);
        }
        const line = target.state.doc.lineAt(from);
        const before = target.state.doc.slice(line.from, from).toString();
        if (/^\s*$/.test(before)) {
            return (0,index_js_.indentMore)(arg);
        }
        else {
            return (0,index_js_.insertTab)(arg);
        }
    }
    StateCommands.indentMoreOrInsertTab = indentMoreOrInsertTab;
    /**
     * Insert new line if completer is not active.
     */
    function completerOrInsertNewLine(target) {
        var _a;
        if ((_a = target.dom.parentElement) === null || _a === void 0 ? void 0 : _a.classList.contains(lib_index_js_.COMPLETER_ACTIVE_CLASS)) {
            // do not prevent default to allow completer `enter` action
            return false;
        }
        if (target.dom.closest(TERMINAL_CODE_RUNNER_SELECTOR)) {
            // do not prevent default to allow for the cell to run
            return false;
        }
        const arg = { state: target.state, dispatch: target.dispatch };
        return (0,index_js_.insertNewlineAndIndent)(arg);
    }
    StateCommands.completerOrInsertNewLine = completerOrInsertNewLine;
    /**
     * Prevent insertion of new line when running cell with Ctrl/Command + Enter
     * @deprecated
     */
    function preventNewLineOnRun(target) {
        if (target.dom.closest(CODE_RUNNER_SELECTOR)) {
            return true;
        }
        return false;
    }
    StateCommands.preventNewLineOnRun = preventNewLineOnRun;
    /**
     * Insert a new line or run a cell with Ctrl/Command + Enter
     */
    function insertBlankLineOnRun(target) {
        if (target.dom.closest(CODE_RUNNER_SELECTOR)) {
            // do not prevent default to allow `run` action to be handled by lumino
            return false;
        }
        else {
            const arg = { state: target.state, dispatch: target.dispatch };
            return (0,index_js_.insertBlankLine)(arg);
        }
    }
    StateCommands.insertBlankLineOnRun = insertBlankLineOnRun;
    /**
     * Simplify selection but do not prevent default to allow switching to command mode.
     */
    function simplifySelectionAndMaybeSwitchToCommandMode(target) {
        const arg = { state: target.state, dispatch: target.dispatch };
        const preventDefault = (0,index_js_.simplifySelection)(arg);
        if (target.dom.closest(ACTIVE_CELL_IN_EDIT_MODE_SELECTOR)) {
            // do not prevent default to allow switching to command mode
            return false;
        }
        else {
            return preventDefault;
        }
    }
    StateCommands.simplifySelectionAndMaybeSwitchToCommandMode = simplifySelectionAndMaybeSwitchToCommandMode;
    /**
     * Prevent dedenting when launching inspection request (a.k.a tooltip).
     *
     * This function should be removed once a better way to prevent default
     * CodeMirror commands is implemented, as tracked in
     * https://github.com/jupyterlab/jupyterlab/issues/15897
     */
    function dedentIfNotLaunchingTooltip(target) {
        if (target.dom.closest(TOOLTIP_OPENER_SELECTOR)) {
            return false;
        }
        return (0,index_js_.indentLess)(target);
    }
    StateCommands.dedentIfNotLaunchingTooltip = dedentIfNotLaunchingTooltip;
})(commands_StateCommands || (commands_StateCommands = {}));
//# sourceMappingURL=commands.js.map
// EXTERNAL MODULE: consume shared module (default) @codemirror/language@^6.11.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/language/dist/index.js)
var dist_index_js_ = __webpack_require__(82614);
// EXTERNAL MODULE: consume shared module (default) @codemirror/state@~6.5.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/state/dist/index.js)
var state_dist_index_js_ = __webpack_require__(81947);
// EXTERNAL MODULE: consume shared module (default) @codemirror/view@~6.38.1 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/view/dist/index.js)
var view_dist_index_js_ = __webpack_require__(62358);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.2 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/coreutils/dist/index.js)
var coreutils_dist_index_js_ = __webpack_require__(83044);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.5 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lumino/signaling/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(16324);
// EXTERNAL MODULE: ../node_modules/@codemirror/autocomplete/dist/index.js
var dist = __webpack_require__(73343);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.6.0-alpha.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(53816);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/customStyle.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Custom theme configuration
 *
 * The first non-null value takes precedence
 */
const customThemeConfig = state_dist_index_js_.Facet.define({
    combine(configs) {
        return (0,state_dist_index_js_.combineConfig)(configs, {
            fontFamily: null,
            fontSize: null,
            lineHeight: null
        }, {
            fontFamily: (a, b) => a !== null && a !== void 0 ? a : b,
            fontSize: (a, b) => a !== null && a !== void 0 ? a : b,
            lineHeight: (a, b) => a !== null && a !== void 0 ? a : b
        });
    }
});
function setEditorStyle(view) {
    const { fontFamily, fontSize, lineHeight } = view.state.facet(customThemeConfig);
    let style = '';
    if (fontSize) {
        style += `font-size: ${fontSize}px !important;`;
    }
    if (fontFamily) {
        style += `font-family: ${fontFamily} !important;`;
    }
    if (lineHeight) {
        style += `line-height: ${lineHeight.toString()} !important`;
    }
    return { style: style };
}
/**
 * Get the extension to customize an editor theme.
 *
 * @param config Theme customization
 * @returns Editor extension
 */
function customTheme(config) {
    return [
        customThemeConfig.of(config),
        view_dist_index_js_.EditorView.editorAttributes.of(setEditorStyle)
    ];
}
//# sourceMappingURL=customStyle.js.map
// EXTERNAL MODULE: consume shared module (default) @lezer/common@~1.2.1 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lezer/common/dist/index.js)
var common_dist_index_js_ = __webpack_require__(6202);
// EXTERNAL MODULE: consume shared module (default) @lezer/highlight@~1.2.0 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@lezer/highlight/dist/index.js)
var highlight_dist_index_js_ = __webpack_require__(6951);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/ipython-md.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


// Mathematical expression delimiters
const INLINE_MATH_DOLLAR = 'InlineMathDollar';
const INLINE_MATH_BRACKET = 'InlineMathBracket';
const BLOCK_MATH_DOLLAR = 'BlockMathDollar';
const BLOCK_MATH_BRACKET = 'BlockMathBracket';
/**
 * Length of the delimiter for a math expression
 */
const DELIMITER_LENGTH = {
    [INLINE_MATH_DOLLAR]: 1,
    [INLINE_MATH_BRACKET]: 3,
    [BLOCK_MATH_DOLLAR]: 2,
    [BLOCK_MATH_BRACKET]: 3
};
/**
 * Delimiters for math expressions
 */
// Delimiters must be defined as constant because they are used in object match tests
const DELIMITERS = Object.keys(DELIMITER_LENGTH).reduce((agg, name) => {
    agg[name] = { mark: `${name}Mark`, resolve: name };
    return agg;
}, {});
/**
 * Define an IPython mathematical expression parser for Markdown.
 *
 * @param latexParser CodeMirror {@link Parser} for LaTeX mathematical expression
 * @returns Markdown extension
 */
function parseMathIPython(latexParser) {
    const defineNodes = new Array();
    Object.keys(DELIMITER_LENGTH).forEach(name => {
        defineNodes.push({
            name,
            style: highlight_dist_index_js_.tags.emphasis
        }, { name: `${name}Mark`, style: highlight_dist_index_js_.tags.processingInstruction });
    });
    return {
        defineNodes,
        parseInline: [
            {
                name: BLOCK_MATH_DOLLAR,
                parse(cx, next, pos) {
                    if (next != 36 /* '$' */ || cx.char(pos + 1) != 36) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[BLOCK_MATH_DOLLAR], pos, pos + DELIMITER_LENGTH[BLOCK_MATH_DOLLAR], true, true);
                }
            },
            {
                name: INLINE_MATH_DOLLAR,
                parse(cx, next, pos) {
                    if (next != 36 /* '$' */ || cx.char(pos + 1) == 36) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[INLINE_MATH_DOLLAR], pos, pos + DELIMITER_LENGTH[INLINE_MATH_DOLLAR], true, true);
                }
            },
            // Inline expression wrapped in \\( ... \\)
            {
                name: INLINE_MATH_BRACKET,
                before: 'Escape', // Search for this delimiter before the escape character
                parse(cx, next, pos) {
                    if (next != 92 /* '\' */ ||
                        cx.char(pos + 1) != 92 ||
                        ![40 /* '(' */, 41 /* ')' */].includes(cx.char(pos + 2))) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[INLINE_MATH_BRACKET], pos, pos + DELIMITER_LENGTH[INLINE_MATH_BRACKET], cx.char(pos + 2) == 40, cx.char(pos + 2) == 41);
                }
            },
            // Block expression wrapped in \\[ ... \\]
            {
                name: BLOCK_MATH_BRACKET,
                before: 'Escape', // Search for this delimiter before the escape character
                parse(cx, next, pos) {
                    if (next != 92 /* '\' */ ||
                        cx.char(pos + 1) != 92 ||
                        ![91 /* '[' */, 93 /* ']' */].includes(cx.char(pos + 2))) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[BLOCK_MATH_BRACKET], pos, pos + DELIMITER_LENGTH[BLOCK_MATH_BRACKET], cx.char(pos + 2) == 91, cx.char(pos + 2) == 93);
                }
            }
        ],
        wrap: latexParser
            ? (0,common_dist_index_js_.parseMixed)((node, input) => {
                // Test if the node type is one of the math expression
                const delimiterLength = DELIMITER_LENGTH[node.type.name];
                if (delimiterLength) {
                    return {
                        parser: latexParser,
                        // Remove delimiter from LaTeX parser otherwise it won't be highlighted
                        overlay: [
                            {
                                from: node.from + delimiterLength,
                                to: node.to - delimiterLength
                            }
                        ]
                    };
                }
                return null;
            })
            : undefined
    };
}
//# sourceMappingURL=ipython-md.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/rulers.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
// Inspired by https://discuss.codemirror.net/t/how-to-implement-ruler/4616/



const RULERS_CLASSNAME = 'cm-rulers';
/**
 * Rulers style
 */
const baseTheme = view_dist_index_js_.EditorView.baseTheme({
    [`.${RULERS_CLASSNAME}`]: { borderRight: '1px dotted gray', opacity: 0.7 }
});
/**
 * Rulers facet
 */
const rulerConfig = state_dist_index_js_.Facet.define({
    // Merge all unique values
    combine(value) {
        const final = value.reduce((agg, arr) => agg.concat(
        // Check value is not in aggregate nor multiple time in the array.
        arr.filter((v, idx) => !agg.includes(v) && idx == arr.lastIndexOf(v))), []);
        return final;
    }
});
/**
 * View plugin displaying the rulers
 */
const rulers_plugin = view_dist_index_js_.ViewPlugin.fromClass(class {
    constructor(view) {
        var _a, _b;
        this.rulersContainer = view.dom.appendChild(document.createElement('div'));
        this.rulersContainer.style.cssText = `
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                pointer-events: none;
                overflow: hidden;
            `;
        const defaultCharacterWidth = view.defaultCharacterWidth;
        const widths = view.state.facet(rulerConfig);
        const guttersWidths = (_b = (_a = view.scrollDOM.querySelector('.cm-gutters')) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : 0;
        this.rulers = widths.map(width => {
            const ruler = this.rulersContainer.appendChild(document.createElement('div'));
            ruler.classList.add(RULERS_CLASSNAME);
            ruler.style.cssText = `
                position: absolute;
                left: ${guttersWidths + width * defaultCharacterWidth}px;
                height: 100%;
            `;
            // FIXME: This should be equal to the amount of padding on a line.
            // This value should be extracted from CodeMirror rather than hardcoded.
            ruler.style.width = '6px';
            return ruler;
        });
    }
    update(update) {
        var _a, _b;
        const widths = update.view.state.facet(rulerConfig);
        if (update.viewportChanged ||
            update.geometryChanged ||
            !coreutils_dist_index_js_.JSONExt.deepEqual(widths, update.startState.facet(rulerConfig))) {
            const guttersWidth = (_b = (_a = update.view.scrollDOM.querySelector('.cm-gutters')) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : 0;
            const defaultCharacterWidth = update.view.defaultCharacterWidth;
            this.rulers.forEach((ruler, rulerIdx) => {
                ruler.style.left = `${guttersWidth + widths[rulerIdx] * defaultCharacterWidth}px`;
            });
        }
    }
    destroy() {
        this.rulers.forEach(ruler => {
            ruler.remove();
        });
        this.rulersContainer.remove();
    }
});
/**
 * Extension for CodeMirror 6 displaying rulers.
 *
 * @param value Rulers position
 * @returns CodeMirror 6 extension
 */
function rulers(value) {
    return [baseTheme, rulerConfig.of(value), rulers_plugin];
}
//# sourceMappingURL=rulers.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/yundomanager.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 *
 * Vendored from https://github.com/yjs/y-codemirror.next
 * licensed under MIT License by Kevin Jahns.
 *
 * Ideally we would depend on the y-codemirror.next, but it is impractical
 * until https://github.com/yjs/y-codemirror.next/issues/27 is resolved.
 *
 * Modifications compared to upstream:
 * - removed spurious mutex (https://github.com/yjs/y-codemirror.next/issues/15)
 * - added TypeScript types
 * - simplified `YUndoManagerConfig` by removing public methods
 * - moved `_onStackItemAdded`, `_onStackItemPopped` and `_storeSelection` definitions out of constructor
 */



class YUndoManagerConfig {
    constructor(undoManager) {
        this.undoManager = undoManager;
    }
}
const yUndoManagerFacet = state_dist_index_js_.Facet.define({
    combine(inputs) {
        return inputs[inputs.length - 1];
    }
});
class YUndoManagerPluginValue {
    constructor(view) {
        this._onStackItemAdded = ({ stackItem, changedParentTypes }) => {
            // only store metadata if this type was affected
            if (changedParentTypes.has(this._syncConf.ytext) &&
                this._beforeChangeSelection &&
                !stackItem.meta.has(this)) {
                // do not overwrite previous stored selection
                stackItem.meta.set(this, this._beforeChangeSelection);
            }
        };
        this._onStackItemPopped = ({ stackItem }) => {
            const sel = stackItem.meta.get(this);
            if (sel) {
                const selection = this._syncConf.fromYRange(sel);
                this._view.dispatch(this._view.state.update({
                    selection,
                    effects: [view_dist_index_js_.EditorView.scrollIntoView(selection)]
                }));
                this._storeSelection();
            }
        };
        this._storeSelection = () => {
            // store the selection before the change is applied so we can restore it with the undo manager.
            this._beforeChangeSelection = this._syncConf.toYRange(this._view.state.selection.main);
        };
        this._view = view;
        this._conf = view.state.facet(yUndoManagerFacet);
        this._undoManager = this._conf.undoManager;
        this._syncConf = view.state.facet(ySyncFacet);
        this._beforeChangeSelection = null;
        this._undoManager.on('stack-item-added', this._onStackItemAdded);
        this._undoManager.on('stack-item-popped', this._onStackItemPopped);
        this._undoManager.addTrackedOrigin(this._syncConf);
    }
    update(update) {
        if (update.selectionSet &&
            (update.transactions.length === 0 ||
                update.transactions[0].annotation(ySyncAnnotation) !== this._syncConf)) {
            // This only works when YUndoManagerPlugin is included before the sync plugin
            this._storeSelection();
        }
    }
    destroy() {
        this._undoManager.off('stack-item-added', this._onStackItemAdded);
        this._undoManager.off('stack-item-popped', this._onStackItemPopped);
        this._undoManager.removeTrackedOrigin(this._syncConf);
    }
}
const yUndoManager = view_dist_index_js_.ViewPlugin.fromClass(YUndoManagerPluginValue);
//# sourceMappingURL=yundomanager.js.map
// EXTERNAL MODULE: consume shared module (default) yjs@~13.6.8 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/yjs/dist/yjs.mjs)
var yjs_mjs_ = __webpack_require__(60553);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/ybinding.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 *
 * Binding for yjs and codemirror
 *
 * It is a simplification of https://github.com/yjs/y-codemirror.next
 * licensed under MIT License by Kevin Jahns
 */




/**
 * Defines a range on text using relative positions that can be transformed back to
 * absolute positions. (https://docs.yjs.dev/api/relative-positions)
 */
class YRange {
    /**
     * @param yanchor
     * @param yhead
     */
    constructor(yanchor, yhead) {
        this.yanchor = yanchor;
        this.yhead = yhead;
    }
    /**
     * Convert the position to JSON
     */
    toJSON() {
        return {
            yanchor: (0,yjs_mjs_.relativePositionToJSON)(this.yanchor),
            yhead: (0,yjs_mjs_.relativePositionToJSON)(this.yhead)
        };
    }
    /**
     * Convert a JSON range to a YRange
     * @param json Range to convert
     * @return The range as YRange
     */
    static fromJSON(json) {
        return new YRange((0,yjs_mjs_.createRelativePositionFromJSON)(json.yanchor), (0,yjs_mjs_.createRelativePositionFromJSON)(json.yhead));
    }
}
/**
 * Yjs binding configuration
 */
class YSyncConfig {
    /**
     * Create a new binding configuration
     *
     * @param ytext Yjs text to synchronize
     */
    constructor(ytext) {
        this.ytext = ytext;
    }
    /**
     * Helper function to transform an absolute index position to a Yjs-based relative position
     * (https://docs.yjs.dev/api/relative-positions).
     *
     * A relative position can be transformed back to an absolute position even after the document has changed. The position is
     * automatically adapted. This does not require any position transformations. Relative positions are computed based on
     * the internal Yjs document model. Peers that share content through Yjs are guaranteed that their positions will always
     * synced up when using relative positions.
     *
     * ```js
     * import { ySyncFacet } from 'y-codemirror'
     *
     * ..
     * const ysync = view.state.facet(ySyncFacet)
     * // transform an absolute index position to a ypos
     * const ypos = ysync.getYPos(3)
     * // transform the ypos back to an absolute position
     * ysync.fromYPos(ypos) // => 3
     * ```
     *
     * It cannot be guaranteed that absolute index positions can be synced up between peers.
     * This might lead to undesired behavior when implementing features that require that all peers see the
     * same marked range (e.g. a comment plugin).
     *
     * @param pos
     * @param assoc
     */
    toYPos(pos, assoc = 0) {
        return (0,yjs_mjs_.createRelativePositionFromTypeIndex)(this.ytext, pos, assoc);
    }
    /**
     * @param rpos
     */
    fromYPos(rpos) {
        const pos = (0,yjs_mjs_.createAbsolutePositionFromRelativePosition)((0,yjs_mjs_.createRelativePositionFromJSON)(rpos), this.ytext.doc);
        if (pos == null || pos.type !== this.ytext) {
            throw new Error('[y-codemirror] The position you want to retrieve was created by a different document');
        }
        return {
            pos: pos.index,
            assoc: pos.assoc
        };
    }
    /**
     * @param range
     * @return
     */
    toYRange(range) {
        const assoc = range.assoc;
        const yanchor = this.toYPos(range.anchor, assoc);
        const yhead = this.toYPos(range.head, assoc);
        return new YRange(yanchor, yhead);
    }
    /**
     * @param yrange
     */
    fromYRange(yrange) {
        const anchor = this.fromYPos(yrange.yanchor);
        const head = this.fromYPos(yrange.yhead);
        if (anchor.pos === head.pos) {
            return state_dist_index_js_.EditorSelection.cursor(head.pos, head.assoc);
        }
        return state_dist_index_js_.EditorSelection.range(anchor.pos, head.pos);
    }
}
/**
 * Yjs binding facet
 */
const ySyncFacet = state_dist_index_js_.Facet.define({
    combine(inputs) {
        return inputs[inputs.length - 1];
    }
});
/**
 * Yjs binding annotation
 *
 * It is used to track the origin of the document changes
 */
const ySyncAnnotation = state_dist_index_js_.Annotation.define();
/**
 * Yjs binding view plugin to synchronize the
 * editor state with the Yjs document.
 */
const ySync = view_dist_index_js_.ViewPlugin.fromClass(class {
    constructor(view) {
        this.conf = view.state.facet(ySyncFacet);
        this._observer = (event, tr) => {
            var _a;
            if (tr.origin !== this.conf) {
                const delta = event.delta;
                const changes = [];
                let pos = 0;
                for (let i = 0; i < delta.length; i++) {
                    const d = delta[i];
                    if (d.insert != null) {
                        changes.push({ from: pos, to: pos, insert: d.insert });
                    }
                    else if (d.delete != null) {
                        changes.push({ from: pos, to: pos + d.delete, insert: '' });
                        pos += d.delete;
                    }
                    else {
                        pos += (_a = d.retain) !== null && _a !== void 0 ? _a : 0;
                    }
                }
                view.dispatch({
                    changes,
                    // Specified the changes origin to not loop when synchronizing
                    annotations: [ySyncAnnotation.of(this.conf)]
                });
            }
        };
        this._ytext = this.conf.ytext;
        this._ytext.observe(this._observer);
    }
    update(update) {
        if (!update.docChanged ||
            (update.transactions.length > 0 &&
                update.transactions[0].annotation(ySyncAnnotation) === this.conf)) {
            return;
        }
        const ytext = this.conf.ytext;
        ytext.doc.transact(() => {
            /**
             * This variable adjusts the fromA position to the current position in the Y.Text type.
             */
            let adj = 0;
            update.changes.iterChanges((fromA, toA, fromB, toB, insert) => {
                const insertText = insert.sliceString(0, insert.length, '\n');
                if (fromA !== toA) {
                    ytext.delete(fromA + adj, toA - fromA);
                }
                if (insertText.length > 0) {
                    ytext.insert(fromA + adj, insertText);
                }
                adj += insertText.length - (toA - fromA);
            });
            // Set the configuration as origin to not loop when synchronizing
        }, this.conf);
    }
    destroy() {
        this._ytext.unobserve(this._observer);
    }
});
/**
 * Extension for CodeMirror 6 binding the Yjs text (source of truth)
 * and the editor state.
 *
 * @param options.ytext Yjs text to bind
 * @param options.undoManager Yjs text undo manager
 * @returns CodeMirror 6 extension
 */
function ybinding(options) {
    const { ytext, undoManager } = options;
    const ySyncConfig = new YSyncConfig(ytext);
    const plugins = [ySyncFacet.of(ySyncConfig), ySync];
    if (undoManager) {
        plugins.push(
        // We need to add a new origin to the undo manager to ensure text updates
        // are tracked; we also need to restore selection after undo/redo.
        yUndoManagerFacet.of(new YUndoManagerConfig(undoManager)), yUndoManager);
    }
    return plugins;
}
//# sourceMappingURL=ybinding.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extensions/index.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: consume shared module (default) @codemirror/search@^6.5.10 (strict) (fallback: /home/runner/work/notebook/notebook/.jupyter_releaser_checkout/node_modules/@codemirror/search/dist/index.js)
var search_dist_index_js_ = __webpack_require__(59332);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/codemirror/lib/extension.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.











/**
 * The class name added to read only editor widgets.
 */
const READ_ONLY_CLASS = 'jp-mod-readOnly';
/**
 * Editor configuration handler
 *
 * It stores the editor configuration and the editor extensions.
 * It also allows to inject new extensions into an editor.
 */
class ExtensionsHandler {
    constructor({ baseConfiguration, config, defaultExtensions } = {}) {
        this._configChanged = new index_es6_js_.Signal(this);
        this._disposed = new index_es6_js_.Signal(this);
        this._isDisposed = false;
        this._immutables = new Set();
        this._baseConfig = baseConfiguration !== null && baseConfiguration !== void 0 ? baseConfiguration : {};
        this._config = config !== null && config !== void 0 ? config : {};
        this._configurableBuilderMap = new Map(defaultExtensions);
        const configurables = Object.keys(this._config).concat(Object.keys(this._baseConfig));
        this._immutables = new Set([...this._configurableBuilderMap.keys()].filter(key => !configurables.includes(key)));
    }
    /**
     * Signal triggered when the editor configuration changes.
     * It provides the mapping of the new configuration (only those that changed).
     *
     * It should result in a call to `IExtensionsHandler.reconfigureExtensions`.
     */
    get configChanged() {
        return this._configChanged;
    }
    /**
     * A signal emitted when the object is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Tests whether the object is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the object.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        index_es6_js_.Signal.clearData(this);
    }
    /**
     * Get a config option for the editor.
     */
    getOption(option) {
        var _a;
        return (_a = this._config[option]) !== null && _a !== void 0 ? _a : this._baseConfig[option];
    }
    /**
     * Whether the option exists or not.
     */
    hasOption(option) {
        return (Object.keys(this._config).includes(option) ||
            Object.keys(this._baseConfig).includes(option));
    }
    /**
     * Set a config option for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `IExtensionsHandler.configChanged`.
     */
    setOption(option, value) {
        // Don't bother setting the option if it is already the same.
        if (this._config[option] !== value) {
            this._config[option] = value;
            this._configChanged.emit({ [option]: value });
        }
    }
    /**
     * Set a base config option for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `IExtensionsHandler.configChanged`.
     */
    setBaseOptions(options) {
        // Change values of baseConfig
        const changed = this._getChangedOptions(options, this._baseConfig);
        if (changed.length > 0) {
            this._baseConfig = options;
            const customizedKeys = Object.keys(this._config);
            const notOverridden = changed.filter(k => !customizedKeys.includes(k));
            if (notOverridden.length > 0) {
                this._configChanged.emit(notOverridden.reduce((agg, key) => {
                    agg[key] = this._baseConfig[key];
                    return agg;
                }, {}));
            }
        }
        // Change values of config keys if present in options
        for (const key of Object.keys(options)) {
            if (key in this._config && this._config[key] != options[key]) {
                this.setOption(key, options[key]);
            }
        }
    }
    /**
     * Set config options for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `EditorHandler.configChanged`.
     *
     * This method is preferred when setting several options. The
     * options are set within an operation, which only performs
     * the costly update at the end, and not after every option
     * is set.
     */
    setOptions(options) {
        const changed = this._getChangedOptions(options, this._config);
        if (changed.length > 0) {
            this._config = { ...options };
            this._configChanged.emit(changed.reduce((agg, key) => {
                var _a;
                agg[key] = (_a = this._config[key]) !== null && _a !== void 0 ? _a : this._baseConfig[key];
                return agg;
            }, {}));
        }
    }
    /**
     * Reconfigures the extension mapped with key with the provided value.
     *
     * @param view Editor view
     * @param key Parameter unique key
     * @param value Parameter value to be applied
     */
    reconfigureExtension(view, key, value) {
        const effect = this.getEffect(view.state, key, value);
        if (effect) {
            view.dispatch({
                effects: [effect]
            });
        }
    }
    /**
     * Reconfigures all the extensions mapped with the options from the
     * provided partial configuration.
     *
     * @param view Editor view
     * @param configuration Editor configuration
     */
    reconfigureExtensions(view, configuration) {
        const effects = Object.keys(configuration)
            .filter(key => this.has(key))
            .map(key => this.getEffect(view.state, key, configuration[key]));
        view.dispatch({
            effects: effects.filter(effect => effect !== null)
        });
    }
    /**
     * Appends extensions to the top-level configuration of the
     * editor.
     *
     * Injected extension cannot be removed.
     *
     * ### Notes
     * You should prefer registering a IEditorExtensionFactory instead
     * of this feature.
     *
     * @alpha
     * @param view Editor view
     * @param extension Editor extension to inject
     */
    injectExtension(view, extension) {
        view.dispatch({
            effects: state_dist_index_js_.StateEffect.appendConfig.of(extension)
        });
    }
    /**
     * Returns the list of initial extensions of an editor
     * based on the configuration.
     *
     * @returns The initial editor extensions
     */
    getInitialExtensions() {
        const configuration = { ...this._baseConfig, ...this._config };
        const extensions = [...this._immutables]
            .map(key => { var _a; return (_a = this.get(key)) === null || _a === void 0 ? void 0 : _a.instance(undefined); })
            .filter(ext => ext);
        for (const k of Object.keys(configuration)) {
            const builder = this.get(k);
            if (builder) {
                const value = configuration[k];
                extensions.push(builder.instance(value));
            }
        }
        return extensions;
    }
    /**
     * Get a extension builder
     * @param key Extension unique identifier
     * @returns The extension builder
     */
    get(key) {
        return this._configurableBuilderMap.get(key);
    }
    /**
     * Whether the editor has an extension for the identifier.
     *
     * @param key Extension unique identifier
     * @returns Extension existence
     */
    has(key) {
        return this._configurableBuilderMap.has(key);
    }
    getEffect(state, key, value) {
        var _a;
        const builder = this.get(key);
        return (_a = builder === null || builder === void 0 ? void 0 : builder.reconfigure(value)) !== null && _a !== void 0 ? _a : null;
    }
    _getChangedOptions(newConfig, oldConfig) {
        const changed = new Array();
        const newKeys = new Array();
        for (const [key, value] of Object.entries(newConfig)) {
            newKeys.push(key);
            if (oldConfig[key] !== value) {
                changed.push(key);
            }
        }
        // Add removed old keys
        changed.push(...Object.keys(oldConfig).filter(k => !newKeys.includes(k)));
        return changed;
    }
}
/**
 * CodeMirror extensions registry
 */
class extension_EditorExtensionRegistry {
    constructor() {
        this.configurationBuilder = new Map();
        this.configurationSchema = {};
        this.defaultOptions = {};
        this.handlers = new Set();
        this.immutableExtensions = new Set();
        this._baseConfiguration = {};
    }
    /**
     * Base editor configuration
     *
     * This is the default configuration optionally modified by the user;
     * e.g. through user settings.
     */
    get baseConfiguration() {
        return { ...this.defaultOptions, ...this._baseConfiguration };
    }
    set baseConfiguration(v) {
        if (!coreutils_dist_index_js_.JSONExt.deepEqual(v, this._baseConfiguration)) {
            this._baseConfiguration = v;
            for (const handler of this.handlers) {
                handler.setBaseOptions(this.baseConfiguration);
            }
        }
    }
    /**
     * Default editor configuration
     *
     * This is the default configuration as defined when extensions
     * are registered.
     */
    get defaultConfiguration() {
        // Only options with schema should be JSON serializable
        // So we cannot use `JSONExt.deepCopy` on the default options.
        return Object.freeze({ ...this.defaultOptions });
    }
    /**
     * Editor configuration JSON schema
     */
    get settingsSchema() {
        return Object.freeze(coreutils_dist_index_js_.JSONExt.deepCopy(this.configurationSchema));
    }
    /**
     * Add a default editor extension
     *
     * @template T Extension parameter type
     * @param factory Extension factory
     */
    addExtension(factory) {
        var _a;
        if (this.configurationBuilder.has(factory.name)) {
            throw new Error(`Extension named ${factory.name} is already registered.`);
        }
        this.configurationBuilder.set(factory.name, factory);
        if (typeof factory.default != 'undefined') {
            this.defaultOptions[factory.name] = factory.default;
        }
        if (factory.schema) {
            this.configurationSchema[factory.name] = {
                default: (_a = factory.default) !== null && _a !== void 0 ? _a : null,
                ...factory.schema
            };
            this.defaultOptions[factory.name] =
                this.configurationSchema[factory.name].default;
        }
    }
    /**
     * Create a new extensions handler for an editor
     *
     * @param options Extensions options and initial editor configuration
     */
    createNew(options) {
        const configuration = new Array();
        for (const [key, builder] of this.configurationBuilder.entries()) {
            const extension = builder.factory(options);
            if (extension) {
                configuration.push([key, extension]);
            }
        }
        const handler = new ExtensionsHandler({
            baseConfiguration: this.baseConfiguration,
            config: options.config,
            defaultExtensions: configuration
        });
        this.handlers.add(handler);
        handler.disposed.connect(() => {
            this.handlers.delete(handler);
        });
        return handler;
    }
}
/**
 * Editor extension registry namespace
 */
(function (EditorExtensionRegistry) {
    /**
     * Dynamically configurable editor extension.
     */
    class ConfigurableExtension {
        /**
         * Create a dynamic editor extension.
         *
         * @param builder Extension builder
         */
        constructor(builder) {
            this._compartment = new state_dist_index_js_.Compartment();
            this._builder = builder;
        }
        /**
         * Create an editor extension for the provided value.
         *
         * @param value Editor extension parameter value
         * @returns The editor extension
         */
        instance(value) {
            return this._compartment.of(this._builder(value));
        }
        /**
         * Reconfigure an editor extension.
         *
         * @param value Editor extension value
         * @returns Editor state effect
         */
        reconfigure(value) {
            return this._compartment.reconfigure(this._builder(value));
        }
    }
    /**
     * Immutable editor extension class
     */
    class ImmutableExtension {
        /**
         * Create an immutable editor extension.
         *
         * @param extension Extension
         */
        constructor(extension) {
            this._extension = extension;
        }
        /**
         * Create an editor extension.
         *
         * @returns The editor extension
         */
        instance() {
            return this._extension;
        }
        /**
         * Reconfigure an editor extension.
         *
         * This is a no-op
         */
        reconfigure() {
            // This is a no-op
            return null;
        }
    }
    /**
     * Creates a dynamically configurable editor extension.
     *
     * @param builder Extension builder
     * @return The extension
     */
    function createConfigurableExtension(builder) {
        return new ConfigurableExtension(builder);
    }
    EditorExtensionRegistry.createConfigurableExtension = createConfigurableExtension;
    /**
     * Creates a configurable extension returning
     * one of two extensions depending on a boolean value.
     *
     * @param truthy Extension to apply when the parameter is true
     * @param falsy Extension to apply when the parameter is false
     * @return The extension
     */
    function createConditionalExtension(truthy, falsy = []) {
        return new ConfigurableExtension(value => value ? truthy : falsy);
    }
    EditorExtensionRegistry.createConditionalExtension = createConditionalExtension;
    /**
     * Creates an immutable extension.
     *
     * @param extension Immutable extension
     * @return The extension
     */
    function createImmutableExtension(extension) {
        return new ImmutableExtension(extension);
    }
    EditorExtensionRegistry.createImmutableExtension = createImmutableExtension;
    /**
     * Get the default editor extensions.
     *
     * @returns CodeMirror 6 extension factories
     */
    function getDefaultExtensions(options = {}) {
        const { themes, translator } = options;
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const extensions = [
            Object.freeze({
                name: 'autoClosingBrackets',
                default: false,
                factory: () => createConditionalExtension((0,dist/* .closeBrackets */.wm)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Auto Closing Brackets')
                }
            }),
            Object.freeze({
                name: 'codeFolding',
                default: false,
                factory: () => createConditionalExtension((0,dist_index_js_.foldGutter)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Code Folding')
                }
            }),
            Object.freeze({
                name: 'cursorBlinkRate',
                default: 1200,
                factory: () => createConfigurableExtension((value) => (0,view_dist_index_js_.drawSelection)({ cursorBlinkRate: value })),
                schema: {
                    type: 'number',
                    title: trans.__('Cursor blinking rate'),
                    description: trans.__('Half-period in milliseconds used for cursor blinking. The default blink rate is 1200ms. By setting this to zero, blinking can be disabled.')
                }
            }),
            Object.freeze({
                name: 'highlightActiveLine',
                default: false,
                factory: () => createConditionalExtension((0,view_dist_index_js_.highlightActiveLine)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight the active line')
                }
            }),
            Object.freeze({
                name: 'highlightSpecialCharacters',
                default: true,
                factory: () => createConditionalExtension((0,view_dist_index_js_.highlightSpecialChars)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight special characters')
                }
            }),
            Object.freeze({
                name: 'highlightTrailingWhitespace',
                default: false,
                factory: () => createConditionalExtension((0,view_dist_index_js_.highlightTrailingWhitespace)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight trailing white spaces')
                }
            }),
            Object.freeze({
                name: 'highlightWhitespace',
                default: false,
                factory: () => createConditionalExtension((0,view_dist_index_js_.highlightWhitespace)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight white spaces')
                }
            }),
            Object.freeze({
                name: 'indentUnit',
                default: '4',
                factory: () => createConfigurableExtension((value) => value == 'Tab'
                    ? dist_index_js_.indentUnit.of('\t')
                    : dist_index_js_.indentUnit.of(' '.repeat(parseInt(value, 10)))),
                schema: {
                    type: 'string',
                    title: trans.__('Indentation unit'),
                    description: trans.__('The indentation is a `Tab` or the number of spaces. This defaults to 4 spaces.'),
                    enum: ['Tab', '1', '2', '4', '8']
                }
            }),
            // Default keyboard shortcuts
            // TODO at some point we may want to get this configurable
            Object.freeze({
                name: 'keymap',
                default: [
                    {
                        key: 'Mod-Enter',
                        run: commands_StateCommands.insertBlankLineOnRun
                    },
                    {
                        key: 'Enter',
                        run: commands_StateCommands.completerOrInsertNewLine
                    },
                    {
                        key: 'Escape',
                 