from enum import Enum


class Tag(Enum):
    """
    Tagset for the Oblubienica dataset.
    """

    A_ACC_PL_F = "a_ Acc Pl f"
    A_ACC_PL_F_CMP = "a_ Acc Pl f Cmp"
    A_ACC_PL_M = "a_ Acc Pl m"
    A_ACC_PL_M_CMP = "a_ Acc Pl m Cmp"
    A_ACC_PL_N = "a_ Acc Pl n"
    A_ACC_PL_N_CMP = "a_ Acc Pl n Cmp"
    A_ACC_SG_F = "a_ Acc Sg f"
    A_ACC_SG_F_CMP = "a_ Acc Sg f Cmp"
    A_ACC_SG_F_SUP = "a_ Acc Sg f Sup"
    A_ACC_SG_M = "a_ Acc Sg m"
    A_ACC_SG_M_CMP = "a_ Acc Sg m Cmp"
    A_ACC_SG_N = "a_ Acc Sg n"
    A_ACC_SG_N_CMP = "a_ Acc Sg n Cmp"
    A_DAT_PL_F = "a_ Dat Pl f"
    A_DAT_PL_M = "a_ Dat Pl m"
    A_DAT_PL_M_CMP = "a_ Dat Pl m Cmp"
    A_DAT_PL_N = "a_ Dat Pl n"
    A_DAT_SG_F = "a_ Dat Sg f"
    A_DAT_SG_F_CMP = "a_ Dat Sg f Cmp"
    A_DAT_SG_F_SUP = "a_ Dat Sg f Sup"
    A_DAT_SG_M = "a_ Dat Sg m"
    A_DAT_SG_M_CMP = "a_ Dat Sg m Cmp"
    A_DAT_SG_M_SUP = "a_ Dat Sg m Sup"
    A_DAT_SG_N = "a_ Dat Sg n"
    A_DAT_SG_N_CMP = "a_ Dat Sg n Cmp"
    A_GEN = "a_ Gen"
    A_GEN_PL_F = "a_ Gen Pl f"
    A_GEN_PL_M = "a_ Gen Pl m"
    A_GEN_PL_M_CMP = "a_ Gen Pl m Cmp"
    A_GEN_PL_N = "a_ Gen Pl n"
    A_GEN_PL_N_CMP = "a_ Gen Pl n Cmp"
    A_GEN_SG_F = "a_ Gen Sg f"
    A_GEN_SG_F_CMP = "a_ Gen Sg f Cmp"
    A_GEN_SG_M = "a_ Gen Sg m"
    A_GEN_SG_M_CMP = "a_ Gen Sg m Cmp"
    A_GEN_SG_N = "a_ Gen Sg n"
    A_GEN_SG_N_SUP = "a_ Gen Sg n Sup"
    A_NOM = "a_ Nom"
    A_NOM_PL_F = "a_ Nom Pl f"
    A_NOM_PL_F_CMP = "a_ Nom Pl f Cmp"
    A_NOM_PL_M = "a_ Nom Pl m"
    A_NOM_PL_M_CMP = "a_ Nom Pl m Cmp"
    A_NOM_PL_N = "a_ Nom Pl n"
    A_NOM_PL_N_CMP = "a_ Nom Pl n Cmp"
    A_NOM_PL_N_SUP = "a_ Nom Pl n Sup"
    A_NOM_SG = "a_ Nom Sg"
    A_NOM_SG_F = "a_ Nom Sg f"
    A_NOM_SG_F_CMP = "a_ Nom Sg f Cmp"
    A_NOM_SG_M = "a_ Nom Sg m"
    A_NOM_SG_M_ATT = "a_ Nom Sg m Att"
    A_NOM_SG_M_CMP = "a_ Nom Sg m Cmp"
    A_NOM_SG_N = "a_ Nom Sg n"
    A_NOM_SG_N_CMP = "a_ Nom Sg n Cmp"
    A_VOC_PL_M = "a_ Voc Pl m"
    A_VOC_SG_F = "a_ Voc Sg f"
    A_VOC_SG_M = "a_ Voc Sg m"
    ADV = "Adv"
    ADV_CON = "Adv Con"
    ADV_INT = "Adv Int"
    ADV_SUP = "Adv Sup"
    ARAMAIC = "Aramaic"
    COND = "Cond"
    COND_CON = "Cond Con"
    CONJ = "Conj"
    HEBREW = "Hebrew"
    INJ = "Inj"
    N_ACC_PL_F = "n_ Acc Pl f"
    N_ACC_PL_F_CON = "n_ Acc Pl f Con"
    N_ACC_PL_M = "n_ Acc Pl m"
    N_ACC_PL_N = "n_ Acc Pl n"
    N_ACC_SG_F = "n_ Acc Sg f"
    N_ACC_SG_F_CON = "n_ Acc Sg f Con"
    N_ACC_SG_M = "n_ Acc Sg m"
    N_ACC_SG_N = "n_ Acc Sg n"
    N_DAT_PL_F = "n_ Dat Pl f"
    N_DAT_PL_M = "n_ Dat Pl m"
    N_DAT_PL_N = "n_ Dat Pl n"
    N_DAT_SG_F = "n_ Dat Sg f"
    N_DAT_SG_M = "n_ Dat Sg m"
    N_DAT_SG_N = "n_ Dat Sg n"
    N_GEN = "n_ Gen"
    N_GEN_PL_F = "n_ Gen Pl f"
    N_GEN_PL_M = "n_ Gen Pl m"
    N_GEN_PL_N = "n_ Gen Pl n"
    N_GEN_SG_F = "n_ Gen Sg f"
    N_GEN_SG_M = "n_ Gen Sg m"
    N_GEN_SG_N = "n_ Gen Sg n"
    N_NOM_M = "n_ Nom m"
    N_NOM_PL_F = "n_ Nom Pl f"
    N_NOM_PL_M = "n_ Nom Pl m"
    N_NOM_PL_N = "n_ Nom Pl n"
    N_NOM_SG_F = "n_ Nom Sg f"
    N_NOM_SG_M = "n_ Nom Sg m"
    N_NOM_SG_N = "n_ Nom Sg n"
    N_NOM_SG_N_CON = "n_ Nom Sg n Con"
    N_VOC_PL_F = "n_ Voc Pl f"
    N_VOC_PL_M = "n_ Voc Pl m"
    N_VOC_PL_N = "n_ Voc Pl n"
    N_VOC_SG_F = "n_ Voc Sg f"
    N_VOC_SG_M = "n_ Voc Sg m"
    N_VOC_SG_N = "n_ Voc Sg n"
    NI_LETTER = "ni letter"
    NI_OTHER = "ni other"
    NI_PROPER = "ni proper"
    PART = "Part"
    PART_INT = "Part Int"
    PART_NEG = "Part Neg"
    PC_ACC_PL_M = "pc Acc Pl m"
    PC_DAT_PL_M = "pc Dat Pl m"
    PC_GEN_PL_M = "pc Gen Pl m"
    PC_GEN_PL_N = "pc Gen Pl n"
    PD_ACC_PL_F = "pd Acc Pl f"
    PD_ACC_PL_M = "pd Acc Pl m"
    PD_ACC_PL_N = "pd Acc Pl n"
    PD_ACC_SG_F = "pd Acc Sg f"
    PD_ACC_SG_M = "pd Acc Sg m"
    PD_ACC_SG_M_CON = "pd Acc Sg m Con"
    PD_ACC_SG_N = "pd Acc Sg n"
    PD_DAT_PL_F = "pd Dat Pl f"
    PD_DAT_PL_M = "pd Dat Pl m"
    PD_DAT_PL_N = "pd Dat Pl n"
    PD_DAT_SG_F = "pd Dat Sg f"
    PD_DAT_SG_M = "pd Dat Sg m"
    PD_DAT_SG_N = "pd Dat Sg n"
    PD_GEN_PL_F = "pd Gen Pl f"
    PD_GEN_PL_M = "pd Gen Pl m"
    PD_GEN_PL_N = "pd Gen Pl n"
    PD_GEN_SG_F = "pd Gen Sg f"
    PD_GEN_SG_M = "pd Gen Sg m"
    PD_GEN_SG_N = "pd Gen Sg n"
    PD_NOM_PL_F = "pd Nom Pl f"
    PD_NOM_PL_M = "pd Nom Pl m"
    PD_NOM_PL_M_CON = "pd Nom Pl m Con"
    PD_NOM_PL_N = "pd Nom Pl n"
    PD_NOM_PL_N_CON = "pd Nom Pl n Con"
    PD_NOM_SG_F = "pd Nom Sg f"
    PD_NOM_SG_M = "pd Nom Sg m"
    PD_NOM_SG_M_CON = "pd Nom Sg m Con"
    PD_NOM_SG_N = "pd Nom Sg n"
    PF_1_ACC_SG_M = "pf 1 Acc Sg m"
    PF_1_DAT_SG_M = "pf 1 Dat Sg m"
    PF_1_GEN_SG_M = "pf 1 Gen Sg m"
    PF_2_ACC_SG_M = "pf 2 Acc Sg m"
    PF_2_DAT_SG_M = "pf 2 Dat Sg m"
    PF_2_GEN_SG_M = "pf 2 Gen Sg m"
    PF_3_ACC_PL_F = "pf 3 Acc Pl f"
    PF_3_ACC_PL_M = "pf 3 Acc Pl m"
    PF_3_ACC_PL_N = "pf 3 Acc Pl n"
    PF_3_ACC_SG_F = "pf 3 Acc Sg f"
    PF_3_ACC_SG_M = "pf 3 Acc Sg m"
    PF_3_DAT_PL_F = "pf 3 Dat Pl f"
    PF_3_DAT_PL_M = "pf 3 Dat Pl m"
    PF_3_DAT_SG_F = "pf 3 Dat Sg f"
    PF_3_DAT_SG_M = "pf 3 Dat Sg m"
    PF_3_GEN_PL_M = "pf 3 Gen Pl m"
    PF_3_GEN_SG_F = "pf 3 Gen Sg f"
    PF_3_GEN_SG_M = "pf 3 Gen Sg m"
    PI_ACC_PL_F = "pi Acc Pl f"
    PI_ACC_SG_F = "pi Acc Sg f"
    PI_ACC_SG_M = "pi Acc Sg m"
    PI_ACC_SG_N = "pi Acc Sg n"
    PI_DAT_PL_M = "pi Dat Pl m"
    PI_DAT_SG_F = "pi Dat Sg f"
    PI_DAT_SG_M = "pi Dat Sg m"
    PI_DAT_SG_N = "pi Dat Sg n"
    PI_GEN_PL_M = "pi Gen Pl m"
    PI_GEN_PL_N = "pi Gen Pl n"
    PI_GEN_SG_F = "pi Gen Sg f"
    PI_GEN_SG_M = "pi Gen Sg m"
    PI_GEN_SG_N = "pi Gen Sg n"
    PI_NOM_PL_M = "pi Nom Pl m"
    PI_NOM_PL_N = "pi Nom Pl n"
    PI_NOM_SG_F = "pi Nom Sg f"
    PI_NOM_SG_M = "pi Nom Sg m"
    PI_NOM_SG_N = "pi Nom Sg n"
    PK_ACC_PL_M = "pk Acc Pl m"
    PK_ACC_PL_N = "pk Acc Pl n"
    PK_ACC_SG_M = "pk Acc Sg m"
    PK_ACC_SG_N = "pk Acc Sg n"
    PK_DAT_SG_N = "pk Dat Sg n"
    PK_GEN_PL_M = "pk Gen Pl m"
    PK_NOM_PL_F = "pk Nom Pl f"
    PK_NOM_PL_M = "pk Nom Pl m"
    PK_NOM_PL_N = "pk Nom Pl n"
    PK_NOM_SG_M = "pk Nom Sg m"
    PK_NOM_SG_N = "pk Nom Sg n"
    PP_1_ACC_PL = "pp 1 Acc Pl"
    PP_1_ACC_SG = "pp 1 Acc Sg"
    PP_1_ACC_SG_CON = "pp 1 Acc Sg Con"
    PP_1_DAT_PL = "pp 1 Dat Pl"
    PP_1_DAT_SG = "pp 1 Dat Sg"
    PP_1_DAT_SG_CON = "pp 1 Dat Sg Con"
    PP_1_GEN_PL = "pp 1 Gen Pl"
    PP_1_GEN_SG = "pp 1 Gen Sg"
    PP_1_NOM_PL = "pp 1 Nom Pl"
    PP_1_NOM_SG = "pp 1 Nom Sg"
    PP_1_NOM_SG_CON = "pp 1 Nom Sg Con"
    PP_2_ACC_PL = "pp 2 Acc Pl"
    PP_2_ACC_SG = "pp 2 Acc Sg"
    PP_2_DAT_PL = "pp 2 Dat Pl"
    PP_2_DAT_SG = "pp 2 Dat Sg"
    PP_2_GEN_PL = "pp 2 Gen Pl"
    PP_2_GEN_SG = "pp 2 Gen Sg"
    PP_2_NOM_PL = "pp 2 Nom Pl"
    PP_2_NOM_SG = "pp 2 Nom Sg"
    PP_ACC_PL_F = "pp Acc Pl f"
    PP_ACC_PL_M = "pp Acc Pl m"
    PP_ACC_PL_N = "pp Acc Pl n"
    PP_ACC_SG_F = "pp Acc Sg f"
    PP_ACC_SG_M = "pp Acc Sg m"
    PP_ACC_SG_N = "pp Acc Sg n"
    PP_DAT_PL_F = "pp Dat Pl f"
    PP_DAT_PL_M = "pp Dat Pl m"
    PP_DAT_PL_N = "pp Dat Pl n"
    PP_DAT_SG_F = "pp Dat Sg f"
    PP_DAT_SG_M = "pp Dat Sg m"
    PP_DAT_SG_N = "pp Dat Sg n"
    PP_GEN_PL_F = "pp Gen Pl f"
    PP_GEN_PL_M = "pp Gen Pl m"
    PP_GEN_PL_N = "pp Gen Pl n"
    PP_GEN_SG_F = "pp Gen Sg f"
    PP_GEN_SG_M = "pp Gen Sg m"
    PP_GEN_SG_N = "pp Gen Sg n"
    PP_NOM_PL_M = "pp Nom Pl m"
    PP_NOM_PL_N = "pp Nom Pl n"
    PP_NOM_SG_F = "pp Nom Sg f"
    PP_NOM_SG_M = "pp Nom Sg m"
    PP_NOM_SG_N = "pp Nom Sg n"
    PQ_ACC_PL_F = "pq Acc Pl f"
    PQ_ACC_PL_M = "pq Acc Pl m"
    PQ_ACC_PL_N = "pq Acc Pl n"
    PQ_ACC_SG_F = "pq Acc Sg f"
    PQ_ACC_SG_N = "pq Acc Sg n"
    PQ_DAT_SG_N = "pq Dat Sg n"
    PQ_GEN_PL_N = "pq Gen Pl n"
    PQ_NOM_PL_F = "pq Nom Pl f"
    PQ_NOM_PL_M = "pq Nom Pl m"
    PQ_NOM_SG_M = "pq Nom Sg m"
    PQ_NOM_SG_N = "pq Nom Sg n"
    PR_ACC_PL_F = "pr Acc Pl f"
    PR_ACC_PL_M = "pr Acc Pl m"
    PR_ACC_PL_N = "pr Acc Pl n"
    PR_ACC_SG_F = "pr Acc Sg f"
    PR_ACC_SG_M = "pr Acc Sg m"
    PR_ACC_SG_N = "pr Acc Sg n"
    PR_DAT_PL_F = "pr Dat Pl f"
    PR_DAT_PL_M = "pr Dat Pl m"
    PR_DAT_PL_N = "pr Dat Pl n"
    PR_DAT_SG_F = "pr Dat Sg f"
    PR_DAT_SG_M = "pr Dat Sg m"
    PR_DAT_SG_N = "pr Dat Sg n"
    PR_GEN_PL_F = "pr Gen Pl f"
    PR_GEN_PL_M = "pr Gen Pl m"
    PR_GEN_PL_N = "pr Gen Pl n"
    PR_GEN_SG_F = "pr Gen Sg f"
    PR_GEN_SG_M = "pr Gen Sg m"
    PR_GEN_SG_N = "pr Gen Sg n"
    PR_GEN_SG_N_ATT = "pr Gen Sg n Att"
    PR_NOM_PL_F = "pr Nom Pl f"
    PR_NOM_PL_M = "pr Nom Pl m"
    PR_NOM_PL_N = "pr Nom Pl n"
    PR_NOM_SG_F = "pr Nom Sg f"
    PR_NOM_SG_M = "pr Nom Sg m"
    PR_NOM_SG_N = "pr Nom Sg n"
    PREP = "Prep"
    PS_1_ACC_PL = "ps 1 Acc Pl"
    PS_1_ACC_SG = "ps 1 Acc Sg"
    PS_1_DAT_PL = "ps 1 Dat Pl"
    PS_1_DAT_SG = "ps 1 Dat Sg"
    PS_1_GEN_PL = "ps 1 Gen Pl"
    PS_1_GEN_SG = "ps 1 Gen Sg"
    PS_1_NOM_PL = "ps 1 Nom Pl"
    PS_1_NOM_SG = "ps 1 Nom Sg"
    PS_2_ACC_PL = "ps 2 Acc Pl"
    PS_2_ACC_SG = "ps 2 Acc Sg"
    PS_2_DAT_PL = "ps 2 Dat Pl"
    PS_2_DAT_SG = "ps 2 Dat Sg"
    PS_2_GEN_PL = "ps 2 Gen Pl"
    PS_2_GEN_SG = "ps 2 Gen Sg"
    PS_2_NOM_PL = "ps 2 Nom Pl"
    PS_2_NOM_SG = "ps 2 Nom Sg"
    PX_ACC_PL_F = "px Acc Pl f"
    PX_ACC_PL_M = "px Acc Pl m"
    PX_ACC_PL_N = "px Acc Pl n"
    PX_ACC_SG_F = "px Acc Sg f"
    PX_ACC_SG_M = "px Acc Sg m"
    PX_ACC_SG_N = "px Acc Sg n"
    PX_DAT_PL_M = "px Dat Pl m"
    PX_DAT_SG_F = "px Dat Sg f"
    PX_DAT_SG_M = "px Dat Sg m"
    PX_DAT_SG_N = "px Dat Sg n"
    PX_GEN_PL_F = "px Gen Pl f"
    PX_GEN_PL_M = "px Gen Pl m"
    PX_GEN_PL_N = "px Gen Pl n"
    PX_GEN_SG_M = "px Gen Sg m"
    PX_GEN_SG_N = "px Gen Sg n"
    PX_NOM_PL_F = "px Nom Pl f"
    PX_NOM_PL_M = "px Nom Pl m"
    PX_NOM_PL_N = "px Nom Pl n"
    PX_NOM_SG_F = "px Nom Sg f"
    PX_NOM_SG_J = "px Nom Sg j"
    PX_NOM_SG_M = "px Nom Sg m"
    PX_NOM_SG_N = "px Nom Sg n"
    T_ACC_PL_F = "t_ Acc Pl f"
    T_ACC_PL_M = "t_ Acc Pl m"
    T_ACC_PL_N = "t_ Acc Pl n"
    T_ACC_SG_F = "t_ Acc Sg f"
    T_ACC_SG_M = "t_ Acc Sg m"
    T_ACC_SG_N = "t_ Acc Sg n"
    T_DAT_PL_F = "t_ Dat Pl f"
    T_DAT_PL_M = "t_ Dat Pl m"
    T_DAT_PL_N = "t_ Dat Pl n"
    T_DAT_SG_F = "t_ Dat Sg f"
    T_DAT_SG_M = "t_ Dat Sg m"
    T_DAT_SG_N = "t_ Dat Sg n"
    T_GEN_PL_F = "t_ Gen Pl f"
    T_GEN_PL_M = "t_ Gen Pl m"
    T_GEN_PL_N = "t_ Gen Pl n"
    T_GEN_SG_F = "t_ Gen Sg f"
    T_GEN_SG_M = "t_ Gen Sg m"
    T_GEN_SG_N = "t_ Gen Sg n"
    T_NOM_PL_F = "t_ Nom Pl f"
    T_NOM_PL_M = "t_ Nom Pl m"
    T_NOM_PL_N = "t_ Nom Pl n"
    T_NOM_SG_F = "t_ Nom Sg f"
    T_NOM_SG_M = "t_ Nom Sg m"
    T_NOM_SG_N = "t_ Nom Sg n"
    VI_2AOR_ACT_1_PL = "vi 2Aor Act 1 Pl"
    VI_2AOR_ACT_1_SG = "vi 2Aor Act 1 Sg"
    VI_2AOR_ACT_2_PL = "vi 2Aor Act 2 Pl"
    VI_2AOR_ACT_2_SG = "vi 2Aor Act 2 Sg"
    VI_2AOR_ACT_3_PL = "vi 2Aor Act 3 Pl"
    VI_2AOR_ACT_3_PL_ATT = "vi 2Aor Act 3 Pl Att"
    VI_2AOR_ACT_3_SG = "vi 2Aor Act 3 Sg"
    VI_2AOR_MID_1_PL = "vi 2Aor Mid 1 Pl"
    VI_2AOR_MID_1_SG = "vi 2Aor Mid 1 Sg"
    VI_2AOR_MID_2_PL = "vi 2Aor Mid 2 Pl"
    VI_2AOR_MID_2_SG = "vi 2Aor Mid 2 Sg"
    VI_2AOR_MID_3_PL = "vi 2Aor Mid 3 Pl"
    VI_2AOR_MID_3_SG = "vi 2Aor Mid 3 Sg"
    VI_2AOR_MIDD_1_SG = "vi 2Aor midD 1 Sg"
    VI_2AOR_MIDD_2_PL = "vi 2Aor midD 2 Pl"
    VI_2AOR_MIDD_2_SG = "vi 2Aor midD 2 Sg"
    VI_2AOR_MIDD_3_PL = "vi 2Aor midD 3 Pl"
    VI_2AOR_MIDD_3_SG = "vi 2Aor midD 3 Sg"
    VI_2AOR_PAS_1_PL = "vi 2Aor Pas 1 Pl"
    VI_2AOR_PAS_1_SG = "vi 2Aor Pas 1 Sg"
    VI_2AOR_PAS_2_PL = "vi 2Aor Pas 2 Pl"
    VI_2AOR_PAS_2_SG = "vi 2Aor Pas 2 Sg"
    VI_2AOR_PAS_3_PL = "vi 2Aor Pas 3 Pl"
    VI_2AOR_PAS_3_SG = "vi 2Aor Pas 3 Sg"
    VI_2AOR_PASD_1_PL = "vi 2Aor pasD 1 Pl"
    VI_2AOR_PASD_1_SG = "vi 2Aor pasD 1 Sg"
    VI_2AOR_PASD_2_PL = "vi 2Aor pasD 2 Pl"
    VI_2AOR_PASD_3_PL = "vi 2Aor pasD 3 Pl"
    VI_2AOR_PASD_3_SG = "vi 2Aor pasD 3 Sg"
    VI_2FUT_MID_3_SG = "vi 2Fut Mid 3 Sg"
    VI_2FUT_MIDD_3_PL = "vi 2Fut midD 3 Pl"
    VI_2FUT_PAS_1_PL = "vi 2Fut Pas 1 Pl"
    VI_2FUT_PAS_2_PL = "vi 2Fut Pas 2 Pl"
    VI_2FUT_PAS_2_SG = "vi 2Fut Pas 2 Sg"
    VI_2FUT_PAS_3_PL = "vi 2Fut Pas 3 Pl"
    VI_2FUT_PAS_3_SG = "vi 2Fut Pas 3 Sg"
    VI_2FUT_PASD_3_PL = "vi 2Fut pasD 3 Pl"
    VI_2FUT_PASD_3_SG = "vi 2Fut pasD 3 Sg"
    VI_2PERF_ACT_1_PL = "vi 2Perf Act 1 Pl"
    VI_2PERF_ACT_1_PL_ATT = "vi 2Perf Act 1 Pl Att"
    VI_2PERF_ACT_1_SG = "vi 2Perf Act 1 Sg"
    VI_2PERF_ACT_2_PL = "vi 2Perf Act 2 Pl"
    VI_2PERF_ACT_2_PL_ATT = "vi 2Perf Act 2 Pl Att"
    VI_2PERF_ACT_2_SG = "vi 2Perf Act 2 Sg"
    VI_2PERF_ACT_3_PL = "vi 2Perf Act 3 Pl"
    VI_2PERF_ACT_3_PL_ATT = "vi 2Perf Act 3 Pl Att"
    VI_2PERF_ACT_3_SG = "vi 2Perf Act 3 Sg"
    VI_2PERF_ACT_3_SG_ATT = "vi 2Perf Act 3 Sg Att"
    VI_2PLUP_ACT_3_SG = "vi 2Plup Act 3 Sg"
    VI_AOR_ACT_1_PL = "vi Aor Act 1 Pl"
    VI_AOR_ACT_1_SG = "vi Aor Act 1 Sg"
    VI_AOR_ACT_2_PL = "vi Aor Act 2 Pl"
    VI_AOR_ACT_2_SG = "vi Aor Act 2 Sg"
    VI_AOR_ACT_3_PL = "vi Aor Act 3 Pl"
    VI_AOR_ACT_3_SG = "vi Aor Act 3 Sg"
    VI_AOR_MID_1_PL = "vi Aor Mid 1 Pl"
    VI_AOR_MID_1_SG = "vi Aor Mid 1 Sg"
    VI_AOR_MID_2_PL = "vi Aor Mid 2 Pl"
    VI_AOR_MID_2_SG = "vi Aor Mid 2 Sg"
    VI_AOR_MID_3_PL = "vi Aor Mid 3 Pl"
    VI_AOR_MID_3_SG = "vi Aor Mid 3 Sg"
    VI_AOR_MIDD_1_PL = "vi Aor midD 1 Pl"
    VI_AOR_MIDD_1_SG = "vi Aor midD 1 Sg"
    VI_AOR_MIDD_2_PL = "vi Aor midD 2 Pl"
    VI_AOR_MIDD_2_SG = "vi Aor midD 2 Sg"
    VI_AOR_MIDD_3_PL = "vi Aor midD 3 Pl"
    VI_AOR_MIDD_3_SG = "vi Aor midD 3 Sg"
    VI_AOR_MIDD_PASD_3_PL = "vi Aor midD/pasD 3 Pl"
    VI_AOR_MIDD_PASD_3_SG = "vi Aor midD/pasD 3 Sg"
    VI_AOR_PAS_1_PL = "vi Aor Pas 1 Pl"
    VI_AOR_PAS_1_SG = "vi Aor Pas 1 Sg"
    VI_AOR_PAS_2_PL = "vi Aor Pas 2 Pl"
    VI_AOR_PAS_2_SG = "vi Aor Pas 2 Sg"
    VI_AOR_PAS_3_PL = "vi Aor Pas 3 Pl"
    VI_AOR_PAS_3_SG = "vi Aor Pas 3 Sg"
    VI_AOR_PAS_3_SG_MIDS = "vi Aor Pas 3 Sg MidS"
    VI_AOR_PASD_1_PL = "vi Aor pasD 1 Pl"
    VI_AOR_PASD_1_PL_ATT = "vi Aor pasD 1 Pl Att"
    VI_AOR_PASD_1_SG = "vi Aor pasD 1 Sg"
    VI_AOR_PASD_1_SG_ATT = "vi Aor pasD 1 Sg Att"
    VI_AOR_PASD_2_PL = "vi Aor pasD 2 Pl"
    VI_AOR_PASD_2_PL_ATT = "vi Aor pasD 2 Pl Att"
    VI_AOR_PASD_3_PL = "vi Aor pasD 3 Pl"
    VI_AOR_PASD_3_PL_ATT = "vi Aor pasD 3 Pl Att"
    VI_AOR_PASD_3_SG = "vi Aor pasD 3 Sg"
    VI_AOR_PASD_3_SG_ATT = "vi Aor pasD 3 Sg Att"
    VI_FUT_ACT_1_PL = "vi Fut Act 1 Pl"
    VI_FUT_ACT_1_SG = "vi Fut Act 1 Sg"
    VI_FUT_ACT_1_SG_ATT = "vi Fut Act 1 Sg Att"
    VI_FUT_ACT_2_PL = "vi Fut Act 2 Pl"
    VI_FUT_ACT_2_SG = "vi Fut Act 2 Sg"
    VI_FUT_ACT_3_PL = "vi Fut Act 3 Pl"
    VI_FUT_ACT_3_PL_ATT = "vi Fut Act 3 Pl Att"
    VI_FUT_ACT_3_SG = "vi Fut Act 3 Sg"
    VI_FUT_ACT_3_SG_ATT = "vi Fut Act 3 Sg Att"
    VI_FUT_MID_1_PL = "vi Fut Mid 1 Pl"
    VI_FUT_MID_1_SG = "vi Fut Mid 1 Sg"
    VI_FUT_MID_2_PL = "vi Fut Mid 2 Pl"
    VI_FUT_MID_2_SG = "vi Fut Mid 2 Sg"
    VI_FUT_MID_3_PL = "vi Fut Mid 3 Pl"
    VI_FUT_MID_3_SG = "vi Fut Mid 3 Sg"
    VI_FUT_MIDD_1_PL = "vi Fut midD 1 Pl"
    VI_FUT_MIDD_1_SG = "vi Fut midD 1 Sg"
    VI_FUT_MIDD_2_PL = "vi Fut midD 2 Pl"
    VI_FUT_MIDD_2_PL_ATT = "vi Fut midD 2 Pl Att"
    VI_FUT_MIDD_2_SG = "vi Fut midD 2 Sg"
    VI_FUT_MIDD_3_PL = "vi Fut midD 3 Pl"
    VI_FUT_MIDD_3_SG = "vi Fut midD 3 Sg"
    VI_FUT_MIDD_PASD_3_PL = "vi Fut midD/pasD 3 Pl"
    VI_FUT_MIDD_PASD_3_SG = "vi Fut midD/pasD 3 Sg"
    VI_FUT_PAS_1_PL = "vi Fut Pas 1 Pl"
    VI_FUT_PAS_1_SG = "vi Fut Pas 1 Sg"
    VI_FUT_PAS_2_PL = "vi Fut Pas 2 Pl"
    VI_FUT_PAS_2_SG = "vi Fut Pas 2 Sg"
    VI_FUT_PAS_3_PL = "vi Fut Pas 3 Pl"
    VI_FUT_PAS_3_SG = "vi Fut Pas 3 Sg"
    VI_FUT_PASD_1_SG = "vi Fut pasD 1 Sg"
    VI_FUT_PASD_3_PL = "vi Fut pasD 3 Pl"
    VI_FUT_PASD_3_SG = "vi Fut pasD 3 Sg"
    VI_FUT_PRES_1_SG = "vi Fut Pres 1 Sg"
    VI_FUT_VXX_1_PL = "vi Fut vxx 1 Pl"
    VI_FUT_VXX_1_SG = "vi Fut vxx 1 Sg"
    VI_FUT_VXX_2_PL = "vi Fut vxx 2 Pl"
    VI_FUT_VXX_2_SG = "vi Fut vxx 2 Sg"
    VI_FUT_VXX_3_PL = "vi Fut vxx 3 Pl"
    VI_FUT_VXX_3_SG = "vi Fut vxx 3 Sg"
    VI_IMPF_ACT_1_PL = "vi Impf Act 1 Pl"
    VI_IMPF_ACT_1_SG = "vi Impf Act 1 Sg"
    VI_IMPF_ACT_2_PL = "vi Impf Act 2 Pl"
    VI_IMPF_ACT_2_SG = "vi Impf Act 2 Sg"
    VI_IMPF_ACT_3_PL = "vi Impf Act 3 Pl"
    VI_IMPF_ACT_3_SG = "vi Impf Act 3 Sg"
    VI_IMPF_ACT_3_SG_ATT = "vi Impf Act 3 Sg Att"
    VI_IMPF_IM_ACT_3_SG = "vi Impf im-Act 3 Sg"
    VI_IMPF_MID_1_PL = "vi Impf Mid 1 Pl"
    VI_IMPF_MID_1_SG = "vi Impf Mid 1 Sg"
    VI_IMPF_MID_3_PL = "vi Impf Mid 3 Pl"
    VI_IMPF_MID_3_SG = "vi Impf Mid 3 Sg"
    VI_IMPF_MID_PAS_3_PL = "vi Impf Mid/Pas 3 Pl"
    VI_IMPF_MID_PAS_3_SG = "vi Impf mid/pas 3 Sg"
    VI_IMPF_MIDD_3_PL = "vi Impf midD 3 Pl"
    VI_IMPF_MIDD_PASD_1_PL = "vi Impf midD/pasD 1 Pl"
    VI_IMPF_MIDD_PASD_1_SG = "vi Impf midD/pasD 1 Sg"
    VI_IMPF_MIDD_PASD_2_PL = "vi Impf midD/pasD 2 Pl"
    VI_IMPF_MIDD_PASD_2_SG = "vi Impf midD/pasD 2 Sg"
    VI_IMPF_MIDD_PASD_3_PL = "vi Impf midD/pasD 3 Pl"
    VI_IMPF_MIDD_PASD_3_PL_ATT = "vi Impf midD/pasD 3 Pl Att"
    VI_IMPF_MIDD_PASD_3_SG = "vi Impf midD/pasD 3 Sg"
    VI_IMPF_MIDD_PASD_3_SG_ATT = "vi Impf midD/pasD 3 Sg Att"
    VI_IMPF_PAS_1_PL = "vi Impf Pas 1 Pl"
    VI_IMPF_PAS_1_SG = "vi Impf Pas 1 Sg"
    VI_IMPF_PAS_2_PL = "vi Impf Pas 2 Pl"
    VI_IMPF_PAS_3_PL = "vi Impf Pas 3 Pl"
    VI_IMPF_PAS_3_SG = "vi Impf Pas 3 Sg"
    VI_IMPF_VXX_1_PL = "vi Impf vxx 1 Pl"
    VI_IMPF_VXX_1_SG = "vi Impf vxx 1 Sg"
    VI_IMPF_VXX_2_PL = "vi Impf vxx 2 Pl"
    VI_IMPF_VXX_2_SG = "vi Impf vxx 2 Sg"
    VI_IMPF_VXX_3_PL = "vi Impf vxx 3 Pl"
    VI_IMPF_VXX_3_SG = "vi Impf vxx 3 Sg"
    VI_PERF_ACT_1_PL = "vi Perf Act 1 Pl"
    VI_PERF_ACT_1_PL_ATT = "vi Perf Act 1 Pl Att"
    VI_PERF_ACT_1_SG = "vi Perf Act 1 Sg"
    VI_PERF_ACT_1_SG_ATT = "vi Perf Act 1 Sg Att"
    VI_PERF_ACT_2_PL = "vi Perf Act 2 Pl"
    VI_PERF_ACT_2_PL_ATT = "vi Perf Act 2 Pl Att"
    VI_PERF_ACT_2_SG = "vi Perf Act 2 Sg"
    VI_PERF_ACT_2_SG_ATT = "vi Perf Act 2 Sg Att"
    VI_PERF_ACT_3_PL = "vi Perf Act 3 Pl"
    VI_PERF_ACT_3_PL_ATT = "vi Perf Act 3 Pl Att"
    VI_PERF_ACT_3_SG = "vi Perf Act 3 Sg"
    VI_PERF_ACT_3_SG_ATT = "vi Perf Act 3 Sg Att"
    VI_PERF_MID_2_SG = "vi Perf Mid 2 Sg"
    VI_PERF_MID_3_SG = "vi Perf Mid 3 Sg"
    VI_PERF_MID_PAS_1_SG = "vi Perf Mid/Pas 1 Sg"
    VI_PERF_MID_PAS_3_SG = "vi Perf Mid/Pas 3 Sg"
    VI_PERF_MIDD_3_SG = "vi Perf midD 3 Sg"
    VI_PERF_MIDD_PASD_1_PL = "vi Perf midD/pasD 1 Pl"
    VI_PERF_MIDD_PASD_1_SG = "vi Perf midD/pasD 1 Sg"
    VI_PERF_MIDD_PASD_3_SG = "vi Perf midD/pasD 3 Sg"
    VI_PERF_PAS_1_PL = "vi Perf Pas 1 Pl"
    VI_PERF_PAS_1_SG = "vi Perf Pas 1 Sg"
    VI_PERF_PAS_2_PL = "vi Perf Pas 2 Pl"
    VI_PERF_PAS_2_SG = "vi Perf Pas 2 Sg"
    VI_PERF_PAS_3_PL = "vi Perf Pas 3 Pl"
    VI_PERF_PAS_3_SG = "vi Perf Pas 3 Sg"
    VI_PLUP_ACT_1_SG = "vi Plup Act 1 Sg"
    VI_PLUP_ACT_2_PL = "vi Plup Act 2 Pl"
    VI_PLUP_ACT_2_SG = "vi Plup Act 2 Sg"
    VI_PLUP_ACT_3_PL = "vi Plup Act 3 Pl"
    VI_PLUP_ACT_3_PL_ATT = "vi Plup Act 3 Pl Att"
    VI_PLUP_ACT_3_SG = "vi Plup Act 3 Sg"
    VI_PLUP_ACT_3_SG_ATT = "vi Plup Act 3 Sg Att"
    VI_PLUP_MID_3_PL = "vi Plup Mid 3 Pl"
    VI_PLUP_MIDD_3_SG = "vi Plup midD 3 Sg"
    VI_PLUP_PAS_3_SG = "vi Plup Pas 3 Sg"
    VI_PRES_ACT_1_PL = "vi Pres Act 1 Pl"
    VI_PRES_ACT_1_SG = "vi Pres Act 1 Sg"
    VI_PRES_ACT_1_SG_CON = "vi Pres Act 1 Sg Con"
    VI_PRES_ACT_2_PL = "vi Pres Act 2 Pl"
    VI_PRES_ACT_2_SG = "vi Pres Act 2 Sg"
    VI_PRES_ACT_3_PL = "vi Pres Act 3 Pl"
    VI_PRES_ACT_3_PL_ATT = "vi Pres Act 3 Pl Att"
    VI_PRES_ACT_3_SG = "vi Pres Act 3 Sg"
    VI_PRES_IM_ACT_3_SG = "vi Pres im-Act 3 Sg"
    VI_PRES_MID_1_PL = "vi Pres Mid 1 Pl"
    VI_PRES_MID_1_SG = "vi Pres Mid 1 Sg"
    VI_PRES_MID_2_PL = "vi Pres Mid 2 Pl"
    VI_PRES_MID_3_PL = "vi Pres Mid 3 Pl"
    VI_PRES_MID_3_SG = "vi Pres Mid 3 Sg"
    VI_PRES_MID_PAS_1_PL = "vi Pres mid/pas 1 Pl"
    VI_PRES_MID_PAS_1_SG = "vi Pres mid/pas 1 Sg"
    VI_PRES_MID_PAS_2_PL = "vi Pres mid/pas 2 Pl"
    VI_PRES_MID_PAS_3_PL = "vi Pres mid/pas 3 Pl"
    VI_PRES_MID_PAS_3_SG = "vi Pres mid/pas 3 Sg"
    VI_PRES_MIDD_PASD_1_PL = "vi Pres midD/pasD 1 Pl"
    VI_PRES_MIDD_PASD_1_SG = "vi Pres midD/pasD 1 Sg"
    VI_PRES_MIDD_PASD_1_SG_CON = "vi Pres midD/pasD 1 Sg Con"
    VI_PRES_MIDD_PASD_2_PL = "vi Pres midD/pasD 2 Pl"
    VI_PRES_MIDD_PASD_2_SG = "vi Pres midD/pasD 2 Sg"
    VI_PRES_MIDD_PASD_2_SG_ATT = "vi Pres midD/pasD 2 Sg Att"
    VI_PRES_MIDD_PASD_2_SG_CON = "vi Pres midD/pasD 2 Sg Con"
    VI_PRES_MIDD_PASD_3_PL = "vi Pres midD/pasD 3 Pl"
    VI_PRES_MIDD_PASD_3_SG = "vi Pres midD/pasD 3 Sg"
    VI_PRES_PAS_1_PL = "vi Pres Pas 1 Pl"
    VI_PRES_PAS_1_SG = "vi Pres Pas 1 Sg"
    VI_PRES_PAS_2_PL = "vi Pres Pas 2 Pl"
    VI_PRES_PAS_2_SG = "vi Pres Pas 2 Sg"
    VI_PRES_PAS_2_SG_IRR = "vi Pres Pas 2 Sg Irr"
    VI_PRES_PAS_3_PL = "vi Pres Pas 3 Pl"
    VI_PRES_PAS_3_SG = "vi Pres Pas 3 Sg"
    VI_PRES_VXX_1_PL = "vi Pres vxx 1 Pl"
    VI_PRES_VXX_1_SG = "vi Pres vxx 1 Sg"
    VI_PRES_VXX_2_PL = "vi Pres vxx 2 Pl"
    VI_PRES_VXX_2_SG = "vi Pres vxx 2 Sg"
    VI_PRES_VXX_3_PL = "vi Pres vxx 3 Pl"
    VI_PRES_VXX_3_SG = "vi Pres vxx 3 Sg"
    VM_2AOR_ACT_2_PL = "vm 2Aor Act 2 Pl"
    VM_2AOR_ACT_2_SG = "vm 2Aor Act 2 Sg"
    VM_2AOR_ACT_3_PL = "vm 2Aor Act 3 Pl"
    VM_2AOR_ACT_3_SG = "vm 2Aor Act 3 Sg"
    VM_2AOR_MID_2_PL = "vm 2Aor Mid 2 Pl"
    VM_2AOR_MID_2_SG = "vm 2Aor Mid 2 Sg"
    VM_2AOR_MIDD_2_SG = "vm 2Aor midD 2 Sg"
    VM_2AOR_MIDD_3_SG = "vm 2Aor midD 3 Sg"
    VM_2AOR_PAS_2_PL = "vm 2Aor Pas 2 Pl"
    VM_2AOR_PAS_2_SG = "vm 2Aor Pas 2 Sg"
    VM_2AOR_PAS_3_SG = "vm 2Aor Pas 3 Sg"
    VM_AOR_ACT_2_PL = "vm Aor Act 2 Pl"
    VM_AOR_ACT_2_SG = "vm Aor Act 2 Sg"
    VM_AOR_ACT_3_PL = "vm Aor Act 3 Pl"
    VM_AOR_ACT_3_SG = "vm Aor Act 3 Sg"
    VM_AOR_MID_2_PL = "vm Aor Mid 2 Pl"
    VM_AOR_MID_2_SG = "vm Aor Mid 2 Sg"
    VM_AOR_MID_3_SG = "vm Aor Mid 3 Sg"
    VM_AOR_MIDD_2_PL = "vm Aor midD 2 Pl"
    VM_AOR_MIDD_2_SG = "vm Aor midD 2 Sg"
    VM_AOR_MIDD_3_PL = "vm Aor midD 3 Pl"
    VM_AOR_MIDD_3_SG = "vm Aor midD 3 Sg"
    VM_AOR_PAS_2_PL = "vm Aor Pas 2 Pl"
    VM_AOR_PAS_2_SG = "vm Aor Pas 2 Sg"
    VM_AOR_PAS_3_PL = "vm Aor Pas 3 Pl"
    VM_AOR_PAS_3_SG = "vm Aor Pas 3 Sg"
    VM_AOR_PASD_2_PL = "vm Aor pasD 2 Pl"
    VM_AOR_PASD_2_SG = "vm Aor pasD 2 Sg"
    VM_AOR_PASD_3_SG = "vm Aor pasD 3 Sg"
    VM_PERF_ACT_2_PL = "vm Perf Act 2 Pl"
    VM_PERF_PAS_2_PL = "vm Perf Pas 2 Pl"
    VM_PERF_PAS_2_SG = "vm Perf Pas 2 Sg"
    VM_PRES_ACT_2_PL = "vm Pres Act 2 Pl"
    VM_PRES_ACT_2_SG = "vm Pres Act 2 Sg"
    VM_PRES_ACT_3_PL = "vm Pres Act 3 Pl"
    VM_PRES_ACT_3_SG = "vm Pres Act 3 Sg"
    VM_PRES_MID_2_PL = "vm Pres Mid 2 Pl"
    VM_PRES_MID_2_SG = "vm Pres Mid 2 Sg"
    VM_PRES_MID_3_SG = "vm Pres Mid 3 Sg"
    VM_PRES_MID_PAS_2_PL = "vm Pres mid/pas 2 Pl"
    VM_PRES_MID_PAS_3_PL = "vm Pres Mid/Pas 3 Pl"
    VM_PRES_MIDD_PASD_2_PL = "vm Pres midD/pasD 2 Pl"
    VM_PRES_MIDD_PASD_2_SG = "vm Pres midD/pasD 2 Sg"
    VM_PRES_MIDD_PASD_3_PL = "vm Pres midD/pasD 3 Pl"
    VM_PRES_MIDD_PASD_3_SG = "vm Pres midD/pasD 3 Sg"
    VM_PRES_PAS_2_PL = "vm Pres Pas 2 Pl"
    VM_PRES_PAS_2_SG = "vm Pres Pas 2 Sg"
    VM_PRES_PAS_3_PL = "vm Pres Pas 3 Pl"
    VM_PRES_PAS_3_SG = "vm Pres Pas 3 Sg"
    VM_PRES_VXX_2_SG = "vm Pres vxx 2 Sg"
    VM_PRES_VXX_3_PL = "vm Pres vxx 3 Pl"
    VM_PRES_VXX_3_SG = "vm Pres vxx 3 Sg"
    VM_TXX_VXX_2_PL = "vm txx vxx 2 Pl"
    VM_TXX_VXX_2_SG = "vm txx vxx 2 Sg"
    VN_2AOR_ACT = "vn 2Aor Act"
    VN_2AOR_MID = "vn 2Aor Mid"
    VN_2AOR_MIDD = "vn 2Aor midD"
    VN_2AOR_PAS = "vn 2Aor Pas"
    VN_2AOR_PASD = "vn 2Aor pasD"
    VN_2PERF_ACT = "vn 2Perf Act"
    VN_AOR_ACT = "vn Aor Act"
    VN_AOR_MID = "vn Aor Mid"
    VN_AOR_MIDD = "vn Aor midD"
    VN_AOR_PAS = "vn Aor Pas"
    VN_AOR_PAS_MIDS = "vn Aor Pas MidS"
    VN_AOR_PASD = "vn Aor pasD"
    VN_FUT_MIDD = "vn Fut midD"
    VN_FUT_VXX = "vn Fut vxx"
    VN_PERF_ACT = "vn Perf Act"
    VN_PERF_ACT_ACC_ATT = "vn Perf Act Acc Att"
    VN_PERF_MID_PAS = "vn Perf Mid/Pas"
    VN_PERF_PAS = "vn Perf Pas"
    VN_PRES_ACT = "vn Pres Act"
    VN_PRES_IM_ACT = "vn Pres im-Act"
    VN_PRES_MID = "vn Pres Mid"
    VN_PRES_MID_PAS = "vn Pres mid/pas"
    VN_PRES_MIDD = "vn Pres midD"
    VN_PRES_MIDD_PASD = "vn Pres midD/pasD"
    VN_PRES_PAS = "vn Pres Pas"
    VN_PRES_PAS_2_PL = "vn Pres Pas 2 Pl"
    VN_PRES_VXX = "vn Pres vxx"
    VO_2AOR_ACT_3_PL = "vo 2Aor Act 3 Pl"
    VO_2AOR_ACT_3_SG = "vo 2Aor Act 3 Sg"
    VO_2AOR_MIDD_1_SG = "vo 2Aor midD 1 Sg"
    VO_2AOR_MIDD_3_SG = "vo 2Aor midD 3 Sg"
    VO_AOR_ACT_3_PL = "vo Aor Act 3 Pl"
    VO_AOR_ACT_3_SG = "vo Aor Act 3 Sg"
    VO_AOR_MIDD_1_SG = "vo Aor midD 1 Sg"
    VO_AOR_PAS_3_SG = "vo Aor Pas 3 Sg"
    VO_AOR_PASD_3_SG = "vo Aor pasD 3 Sg"
    VO_PRES_ACT_2_PL = "vo Pres Act 2 Pl"
    VO_PRES_ACT_3_PL = "vo Pres Act 3 Pl"
    VO_PRES_ACT_3_SG = "vo Pres Act 3 Sg"
    VO_PRES_MIDD_PASD_1_SG = "vo Pres midD/pasD 1 Sg"
    VO_PRES_MIDD_PASD_3_PL = "vo Pres midD/pasD 3 Pl"
    VO_PRES_MIDD_PASD_3_SG = "vo Pres midD/pasD 3 Sg"
    VO_PRES_VXX_3_SG = "vo Pres vxx 3 Sg"
    VP_2AOR_ACT_ACC_PL_F = "vp 2Aor Act Acc Pl f"
    VP_2AOR_ACT_ACC_PL_M = "vp 2Aor Act Acc Pl m"
    VP_2AOR_ACT_ACC_SG_F = "vp 2Aor Act Acc Sg f"
    VP_2AOR_ACT_ACC_SG_M = "vp 2Aor Act Acc Sg m"
    VP_2AOR_ACT_ACC_SG_N = "vp 2Aor Act Acc Sg n"
    VP_2AOR_ACT_DAT_PL_F = "vp 2Aor Act Dat Pl f"
    VP_2AOR_ACT_DAT_PL_M = "vp 2Aor Act Dat Pl m"
    VP_2AOR_ACT_DAT_SG_F = "vp 2Aor Act Dat Sg f"
    VP_2AOR_ACT_DAT_SG_M = "vp 2Aor Act Dat Sg m"
    VP_2AOR_ACT_GEN_PL_M = "vp 2Aor Act Gen Pl m"
    VP_2AOR_ACT_GEN_SG_F = "vp 2Aor Act Gen Sg f"
    VP_2AOR_ACT_GEN_SG_M = "vp 2Aor Act Gen Sg m"
    VP_2AOR_ACT_GEN_SG_N = "vp 2Aor Act Gen Sg n"
    VP_2AOR_ACT_NOM_PL_F = "vp 2Aor Act Nom Pl f"
    VP_2AOR_ACT_NOM_PL_M = "vp 2Aor Act Nom Pl m"
    VP_2AOR_ACT_NOM_PL_N = "vp 2Aor Act Nom Pl n"
    VP_2AOR_ACT_NOM_SG_F = "vp 2Aor Act Nom Sg f"
    VP_2AOR_ACT_NOM_SG_M = "vp 2Aor Act Nom Sg m"
    VP_2AOR_ACT_NOM_SG_N = "vp 2Aor Act Nom Sg n"
    VP_2AOR_MID_GEN_SG_M = "vp 2Aor Mid Gen Sg m"
    VP_2AOR_MID_NOM_PL_M = "vp 2Aor Mid Nom Pl m"
    VP_2AOR_MID_NOM_SG_M = "vp 2Aor Mid Nom Sg m"
    VP_2AOR_MIDD_ACC_PL_M = "vp 2Aor midD Acc Pl m"
    VP_2AOR_MIDD_ACC_PL_N = "vp 2Aor midD Acc Pl n"
    VP_2AOR_MIDD_ACC_SG_F = "vp 2Aor midD Acc Sg f"
    VP_2AOR_MIDD_ACC_SG_M = "vp 2Aor midD Acc Sg m"
    VP_2AOR_MIDD_ACC_SG_N = "vp 2Aor midD Acc Sg n"
    VP_2AOR_MIDD_DAT_PL_M = "vp 2Aor midD Dat Pl m"
    VP_2AOR_MIDD_GEN_PL_F = "vp 2Aor midD Gen Pl f"
    VP_2AOR_MIDD_GEN_PL_M = "vp 2Aor midD Gen Pl m"
    VP_2AOR_MIDD_GEN_PL_N = "vp 2Aor midD Gen Pl n"
    VP_2AOR_MIDD_GEN_SG_F = "vp 2Aor midD Gen Sg f"
    VP_2AOR_MIDD_GEN_SG_M = "vp 2Aor midD Gen Sg m"
    VP_2AOR_MIDD_GEN_SG_N = "vp 2Aor midD Gen Sg n"
    VP_2AOR_MIDD_NOM_PL_F = "vp 2Aor midD Nom Pl f"
    VP_2AOR_MIDD_NOM_PL_M = "vp 2Aor midD Nom Pl m"
    VP_2AOR_MIDD_NOM_SG_M = "vp 2Aor midD Nom Sg m"
    VP_2AOR_PAS_ACC_SG_M = "vp 2Aor Pas Acc Sg m"
    VP_2AOR_PAS_DAT_SG_N = "vp 2Aor Pas Dat Sg n"
    VP_2AOR_PAS_GEN_PL_M = "vp 2Aor Pas Gen Pl m"
    VP_2AOR_PAS_NOM_PL_F = "vp 2Aor Pas Nom Pl f"
    VP_2AOR_PAS_NOM_PL_M = "vp 2Aor Pas Nom Pl m"
    VP_2AOR_PAS_NOM_SG_F = "vp 2Aor Pas Nom Sg f"
    VP_2AOR_PAS_NOM_SG_M = "vp 2Aor Pas Nom Sg m"
    VP_2AOR_PAS_NOM_SG_N = "vp 2Aor Pas Nom Sg n"
    VP_2AOR_VXX_GEN_PL_M = "vp 2Aor vxx Gen Pl m"
    VP_2PERF_ACT_ACC_PL_M = "vp 2Perf Act Acc Pl m"
    VP_2PERF_ACT_ACC_PL_M_ATT = "vp 2Perf Act Acc Pl m Att"
    VP_2PERF_ACT_ACC_PL_N = "vp 2Perf Act Acc Pl n"
    VP_2PERF_ACT_ACC_SG_F = "vp 2Perf Act Acc Sg f"
    VP_2PERF_ACT_ACC_SG_M = "vp 2Perf Act Acc Sg m"
    VP_2PERF_ACT_ACC_SG_N = "vp 2Perf Act Acc Sg n"
    VP_2PERF_ACT_DAT_SG_N = "vp 2Perf Act Dat Sg n"
    VP_2PERF_ACT_NOM_PL_M = "vp 2Perf Act Nom Pl m"
    VP_2PERF_ACT_NOM_SG_F = "vp 2Perf Act Nom Sg f"
    VP_2PERF_ACT_NOM_SG_M = "vp 2Perf Act Nom Sg m"
    VP_2PERF_ACT_NOM_SG_N = "vp 2Perf Act Nom Sg n"
    VP_2PERF_PAS_ACC_SG_M = "vp 2Perf Pas Acc Sg m"
    VP_AOR_ACT_ACC_PL_M = "vp Aor Act Acc Pl m"
    VP_AOR_ACT_ACC_PL_N = "vp Aor Act Acc Pl n"
    VP_AOR_ACT_ACC_SG_F = "vp Aor Act Acc Sg f"
    VP_AOR_ACT_ACC_SG_M = "vp Aor Act Acc Sg m"
    VP_AOR_ACT_ACC_SG_N = "vp Aor Act Acc Sg n"
    VP_AOR_ACT_DAT_PL_M = "vp Aor Act Dat Pl m"
    VP_AOR_ACT_DAT_SG_M = "vp Aor Act Dat Sg m"
    VP_AOR_ACT_GEN_PL_M = "vp Aor Act Gen Pl m"
    VP_AOR_ACT_GEN_SG_M = "vp Aor Act Gen Sg m"
    VP_AOR_ACT_NOM_PL = "vp Aor Act Nom Pl"
    VP_AOR_ACT_NOM_PL_F = "vp Aor Act Nom Pl f"
    VP_AOR_ACT_NOM_PL_M = "vp Aor Act Nom Pl m"
    VP_AOR_ACT_NOM_SG = "vp Aor Act Nom Sg"
    VP_AOR_ACT_NOM_SG_F = "vp Aor Act Nom Sg f"
    VP_AOR_ACT_NOM_SG_M = "vp Aor Act Nom Sg m"
    VP_AOR_ACT_NOM_SG_N = "vp Aor Act Nom Sg n"
    VP_AOR_MID_ACC_PL_M = "vp Aor Mid Acc Pl m"
    VP_AOR_MID_DAT_PL_M = "vp Aor Mid Dat Pl m"
    VP_AOR_MID_GEN_PL_M = "vp Aor Mid Gen Pl m"
    VP_AOR_MID_GEN_SG_M = "vp Aor Mid Gen Sg m"
    VP_AOR_MID_NOM_PL_M = "vp Aor Mid Nom Pl m"
    VP_AOR_MID_NOM_SG_F = "vp Aor Mid Nom Sg f"
    VP_AOR_MID_NOM_SG_M = "vp Aor Mid Nom Sg m"
    VP_AOR_MIDD_ACC_PL_M = "vp Aor midD Acc Pl m"
    VP_AOR_MIDD_ACC_SG_M = "vp Aor midD Acc Sg m"
    VP_AOR_MIDD_DAT_PL_M = "vp Aor midD Dat Pl m"
    VP_AOR_MIDD_GEN_SG_F = "vp Aor midD Gen Sg f"
    VP_AOR_MIDD_NOM_PL_M = "vp Aor midD Nom Pl m"
    VP_AOR_MIDD_NOM_SG_F = "vp Aor midD Nom Sg f"
    VP_AOR_MIDD_NOM_SG_M = "vp Aor midD Nom Sg m"
    VP_AOR_MIDD_PASD_NOM_SG_M = "vp Aor midD/pasD Nom Sg m"
    VP_AOR_MIDD_PASD_NOM_SG_N = "vp Aor midD/pasD Nom Sg n"
    VP_AOR_PAS_ACC_PL_M = "vp Aor Pas Acc Pl m"
    VP_AOR_PAS_ACC_PL_N = "vp Aor Pas Acc Pl n"
    VP_AOR_PAS_ACC_SG_F = "vp Aor Pas Acc Sg f"
    VP_AOR_PAS_ACC_SG_M = "vp Aor Pas Acc Sg m"
    VP_AOR_PAS_ACC_SG_N = "vp Aor Pas Acc Sg n"
    VP_AOR_PAS_DAT_PL_N = "vp Aor Pas Dat Pl n"
    VP_AOR_PAS_DAT_SG_F = "vp Aor Pas Dat Sg f"
    VP_AOR_PAS_DAT_SG_M = "vp Aor Pas Dat Sg m"
    VP_AOR_PAS_GEN_PL_F = "vp Aor Pas Gen Pl f"
    VP_AOR_PAS_GEN_PL_M = "vp Aor Pas Gen Pl m"
    VP_AOR_PAS_GEN_PL_N = "vp Aor Pas Gen Pl n"
    VP_AOR_PAS_GEN_SG_F = "vp Aor Pas Gen Sg f"
    VP_AOR_PAS_GEN_SG_M = "vp Aor Pas Gen Sg m"
    VP_AOR_PAS_GEN_SG_N = "vp Aor Pas Gen Sg n"
    VP_AOR_PAS_NOM_PL_M = "vp Aor Pas Nom Pl m"
    VP_AOR_PAS_NOM_PL_N = "vp Aor Pas Nom Pl n"
    VP_AOR_PAS_NOM_SG_F = "vp Aor Pas Nom Sg f"
    VP_AOR_PAS_NOM_SG_M = "vp Aor Pas Nom Sg m"
    VP_AOR_PAS_NOM_SG_M_MIDS = "vp Aor Pas Nom Sg m MidS"
    VP_AOR_PAS_NOM_SG_N = "vp Aor Pas Nom Sg n"
    VP_AOR_PASD_ACC_PL_M = "vp Aor pasD Acc Pl m"
    VP_AOR_PASD_DAT_SG_M = "vp Aor pasD Dat Sg m"
    VP_AOR_PASD_GEN_PL_M = "vp Aor pasD Gen Pl m"
    VP_AOR_PASD_GEN_PL_N = "vp Aor pasD Gen Pl n"
    VP_AOR_PASD_GEN_SG_M = "vp Aor pasD Gen Sg m"
    VP_AOR_PASD_NOM_PL_F = "vp Aor pasD Nom Pl f"
    VP_AOR_PASD_NOM_PL_M = "vp Aor pasD Nom Pl m"
    VP_AOR_PASD_NOM_SG_F = "vp Aor pasD Nom Sg f"
    VP_AOR_PASD_NOM_SG_M = "vp Aor pasD Nom Sg m"
    VP_AOR_PASD_NOM_SG_N = "vp Aor pasD Nom Sg n"
    VP_FUT_ACT_ACC_PL_N = "vp Fut Act Acc Pl n"
    VP_FUT_ACT_NOM_PL_M = "vp Fut Act Nom Pl m"
    VP_FUT_ACT_NOM_SG_M = "vp Fut Act Nom Sg m"
    VP_FUT_MIDD_ACC_SG_N = "vp Fut midD Acc Sg n"
    VP_FUT_PAS_GEN_PL_N = "vp Fut Pas Gen Pl n"
    VP_FUT_VXX_ACC_SG_N = "vp Fut vxx Acc Sg n"
    VP_PERF_ACT_ACC_PL_M = "vp Perf Act Acc Pl m"
    VP_PERF_ACT_ACC_PL_N = "vp Perf Act Acc Pl n"
    VP_PERF_ACT_ACC_SG_F = "vp Perf Act Acc Sg f"
    VP_PERF_ACT_ACC_SG_M = "vp Perf Act Acc Sg m"
    VP_PERF_ACT_ACC_SG_M_CON = "vp Perf Act Acc Sg m Con"
    VP_PERF_ACT_ACC_SG_N = "vp Perf Act Acc Sg n"
    VP_PERF_ACT_DAT_PL_M = "vp Perf Act Dat Pl m"
    VP_PERF_ACT_DAT_SG_M = "vp Perf Act Dat Sg m"
    VP_PERF_ACT_DAT_SG_N = "vp Perf Act Dat Sg n"
    VP_PERF_ACT_GEN_PL_M = "vp Perf Act Gen Pl m"
    VP_PERF_ACT_GEN_PL_N = "vp Perf Act Gen Pl n"
    VP_PERF_ACT_GEN_SG = "vp Perf Act Gen Sg"
    VP_PERF_ACT_GEN_SG_F = "vp Perf Act Gen Sg f"
    VP_PERF_ACT_GEN_SG_M = "vp Perf Act Gen Sg m"
    VP_PERF_ACT_GEN_SG_N_ATT = "vp Perf Act Gen Sg n Att"
    VP_PERF_ACT_NOM_PL_F = "vp Perf Act Nom Pl f"
    VP_PERF_ACT_NOM_PL_M = "vp Perf Act Nom Pl m"
    VP_PERF_ACT_NOM_PL_M_ATT = "vp Perf Act Nom Pl m Att"
    VP_PERF_ACT_NOM_PL_M_CON = "vp Perf Act Nom Pl m Con"
    VP_PERF_ACT_NOM_PL_N = "vp Perf Act Nom Pl n"
    VP_PERF_ACT_NOM_SG_F = "vp Perf Act Nom Sg f"
    VP_PERF_ACT_NOM_SG_M = "vp Perf Act Nom Sg m"
    VP_PERF_ACT_NOM_SG_M_ATT = "vp Perf Act Nom Sg m Att"
    VP_PERF_ACT_NOM_SG_N = "vp Perf Act Nom Sg n"
    VP_PERF_MID_ACC_SG_M = "vp Perf Mid Acc Sg m"
    VP_PERF_MID_NOM_PL_M = "vp Perf Mid Nom Pl m"
    VP_PERF_MID_NOM_SG_M = "vp Perf Mid Nom Sg m"
    VP_PERF_MID_PAS_ACC_PL_M = "vp Perf Mid/Pas Acc Pl m"
    VP_PERF_MID_PAS_ACC_SG_F = "vp Perf Mid/Pas Acc Sg f"
    VP_PERF_MID_PAS_ACC_SG_M = "vp Perf Mid/Pas Acc Sg m"
    VP_PERF_MID_PAS_DAT_PL_M = "vp Perf Mid/Pas Dat Pl m"
    VP_PERF_MID_PAS_GEN_PL_M = "vp Perf Mid/Pas Gen Pl m"
    VP_PERF_MID_PAS_GEN_SG_F = "vp Perf Mid/Pas Gen Sg f"
    VP_PERF_MID_PAS_NOM_PL_M = "vp Perf Mid/Pas Nom Pl m"
    VP_PERF_MID_PAS_NOM_SG_M = "vp Perf Mid/Pas Nom Sg m"
    VP_PERF_MID_PAS_NOM_SG_N = "vp Perf Mid/Pas Nom Sg n"
    VP_PERF_MIDD_PASD_ACC_PL_M = "vp Perf midD/pasD Acc Pl m"
    VP_PERF_MIDD_PASD_DAT_PL_F = "vp Perf midD/pasD Dat Pl f"
    VP_PERF_MIDD_PASD_NOM_PL_M = "vp Perf midD/pasD Nom Pl m"
    VP_PERF_MIDD_PASD_NOM_SG_M = "vp Perf midD/pasD Nom Sg m"
    VP_PERF_PAS_ACC_PL_F = "vp Perf Pas Acc Pl f"
    VP_PERF_PAS_ACC_PL_M = "vp Perf Pas Acc Pl m"
    VP_PERF_PAS_ACC_PL_N = "vp Perf Pas Acc Pl n"
    VP_PERF_PAS_ACC_SG_F = "vp Perf Pas Acc Sg f"
    VP_PERF_PAS_ACC_SG_M = "vp Perf Pas Acc Sg m"
    VP_PERF_PAS_ACC_SG_N = "vp Perf Pas Acc Sg n"
    VP_PERF_PAS_ACC_SG_N_ATT = "vp Perf Pas Acc Sg n Att"
    VP_PERF_PAS_DAT_PL_M = "vp Perf Pas Dat Pl m"
    VP_PERF_PAS_DAT_PL_N = "vp Perf Pas Dat Pl n"
    VP_PERF_PAS_DAT_SG_F = "vp Perf Pas Dat Sg f"
    VP_PERF_PAS_DAT_SG_M = "vp Perf Pas Dat Sg m"
    VP_PERF_PAS_DAT_SG_N = "vp Perf Pas Dat Sg n"
    VP_PERF_PAS_GEN_PL_M = "vp Perf Pas Gen Pl m"
    VP_PERF_PAS_GEN_PL_N = "vp Perf Pas Gen Pl n"
    VP_PERF_PAS_GEN_SG_F = "vp Perf Pas Gen Sg f"
    VP_PERF_PAS_GEN_SG_M = "vp Perf Pas Gen Sg m"
    VP_PERF_PAS_GEN_SG_N = "vp Perf Pas Gen Sg n"
    VP_PERF_PAS_NOM_PL_F = "vp Perf Pas Nom Pl f"
    VP_PERF_PAS_NOM_PL_M = "vp Perf Pas Nom Pl m"
    VP_PERF_PAS_NOM_PL_N = "vp Perf Pas Nom Pl n"
    VP_PERF_PAS_NOM_SG_F = "vp Perf Pas Nom Sg f"
    VP_PERF_PAS_NOM_SG_M = "vp Perf Pas Nom Sg m"
    VP_PERF_PAS_NOM_SG_N = "vp Perf Pas Nom Sg n"
    VP_PERF_PAS_NOM_SG_N_ATT = "vp Perf Pas Nom Sg n Att"
    VP_PERF_PAS_VOC_SG_M = "vp Perf Pas Voc Sg m"
    VP_PRES_ACT_ACC_PL_F = "vp Pres Act Acc Pl f"
    VP_PRES_ACT_ACC_PL_M = "vp Pres Act Acc Pl m"
    VP_PRES_ACT_ACC_PL_N = "vp Pres Act Acc Pl n"
    VP_PRES_ACT_ACC_SG_F = "vp Pres Act Acc Sg f"
    VP_PRES_ACT_ACC_SG_M = "vp Pres Act Acc Sg m"
    VP_PRES_ACT_ACC_SG_N = "vp Pres Act Acc Sg n"
    VP_PRES_ACT_DAT_PL_F = "vp Pres Act Dat Pl f"
    VP_PRES_ACT_DAT_PL_M = "vp Pres Act Dat Pl m"
    VP_PRES_ACT_DAT_PL_N = "vp Pres Act Dat Pl n"
    VP_PRES_ACT_DAT_SG_F = "vp Pres Act Dat Sg f"
    VP_PRES_ACT_DAT_SG_M = "vp Pres Act Dat Sg m"
    VP_PRES_ACT_DAT_SG_N = "vp Pres Act Dat Sg n"
    VP_PRES_ACT_GEN_PL_F = "vp Pres Act Gen Pl f"
    VP_PRES_ACT_GEN_PL_M = "vp Pres Act Gen Pl m"
    VP_PRES_ACT_GEN_PL_N = "vp Pres Act Gen Pl n"
    VP_PRES_ACT_GEN_SG_F = "vp Pres Act Gen Sg f"
    VP_PRES_ACT_GEN_SG_M = "vp Pres Act Gen Sg m"
    VP_PRES_ACT_GEN_SG_N = "vp Pres Act Gen Sg n"
    VP_PRES_ACT_NOM_PL = "vp Pres Act Nom Pl"
    VP_PRES_ACT_NOM_PL_F = "vp Pres Act Nom Pl f"
    VP_PRES_ACT_NOM_PL_M = "vp Pres Act Nom Pl m"
    VP_PRES_ACT_NOM_PL_N = "vp Pres Act Nom Pl n"
    VP_PRES_ACT_NOM_SG_F = "vp Pres Act Nom Sg f"
    VP_PRES_ACT_NOM_SG_M = "vp Pres Act Nom Sg m"
    VP_PRES_ACT_NOM_SG_N = "vp Pres Act Nom Sg n"
    VP_PRES_IM_ACT_ACC_PL_N = "vp Pres im-Act Acc Pl n"
    VP_PRES_IM_ACT_NOM_SG_N = "vp Pres im-Act Nom Sg n"
    VP_PRES_MID_ACC_PL_M = "vp Pres Mid Acc Pl m"
    VP_PRES_MID_ACC_SG_F = "vp Pres Mid Acc Sg f"
    VP_PRES_MID_ACC_SG_M = "vp Pres Mid Acc Sg m"
    VP_PRES_MID_ACC_SG_N = "vp Pres Mid Acc Sg n"
    VP_PRES_MID_DAT_PL_M = "vp Pres Mid Dat Pl m"
    VP_PRES_MID_DAT_SG_M = "vp Pres Mid Dat Sg m"
    VP_PRES_MID_GEN_PL_F = "vp Pres Mid Gen Pl f"
    VP_PRES_MID_GEN_PL_M = "vp Pres Mid Gen Pl m"
    VP_PRES_MID_GEN_SG = "vp Pres Mid Gen Sg"
    VP_PRES_MID_GEN_SG_F = "vp Pres Mid Gen Sg f"
    VP_PRES_MID_GEN_SG_M = "vp Pres Mid Gen Sg m"
    VP_PRES_MID_GEN_SG_M_TRA = "vp Pres Mid Gen Sg m Tra"
    VP_PRES_MID_GEN_SG_N = "vp Pres Mid Gen Sg n"
    VP_PRES_MID_NOM_PL_F = "vp Pres Mid Nom Pl f"
    VP_PRES_MID_NOM_PL_M = "vp Pres Mid Nom Pl m"
    VP_PRES_MID_NOM_SG = "vp Pres Mid Nom Sg"
    VP_PRES_MID_NOM_SG_F = "vp Pres Mid Nom Sg f"
    VP_PRES_MID_NOM_SG_M = "vp Pres Mid Nom Sg m"
    VP_PRES_MID_NOM_SG_N = "vp Pres Mid Nom Sg n"
    VP_PRES_MID_PAS_ACC_PL_M = "vp Pres Mid/Pas Acc Pl m"
    VP_PRES_MID_PAS_ACC_SG_N = "vp Pres Mid/Pas Acc Sg n"
    VP_PRES_MID_PAS_DAT_PL_M = "vp Pres mid/pas Dat Pl m"
    VP_PRES_MID_PAS_DAT_SG_M = "vp Pres mid/pas Dat Sg m"
    VP_PRES_MID_PAS_DAT_SG_N = "vp Pres Mid/Pas Dat Sg n"
    VP_PRES_MID_PAS_GEN_PL_N = "vp Pres mid/pas Gen Pl n"
    VP_PRES_MID_PAS_GEN_SG_F = "vp Pres mid/pas Gen Sg f"
    VP_PRES_MID_PAS_GEN_SG_M = "vp Pres mid/pas Gen Sg m"
    VP_PRES_MID_PAS_GEN_SG_N = "vp Pres Mid/Pas Gen Sg n"
    VP_PRES_MID_PAS_NOM_PL_F = "vp Pres mid/pas Nom Pl f"
    VP_PRES_MID_PAS_NOM_PL_M = "vp Pres mid/pas Nom Pl m"
    VP_PRES_MID_PAS_NOM_PL_N = "vp Pres Mid/Pas Nom Pl n"
    VP_PRES_MID_PAS_NOM_SG_F = "vp Pres mid/pas Nom Sg f"
    VP_PRES_MID_PAS_NOM_SG_M = "vp Pres Mid/Pas Nom Sg m"
    VP_PRES_MID_PAS_NOM_SG_N = "vp Pres Mid/Pas Nom Sg n"
    VP_PRES_MIDD_NOM_PL_M = "vp Pres midD Nom Pl m"
    VP_PRES_MIDD_PASD_ACC_PL_F = "vp Pres midD/pasD Acc Pl f"
    VP_PRES_MIDD_PASD_ACC_PL_M = "vp Pres midD/pasD Acc Pl m"
    VP_PRES_MIDD_PASD_ACC_PL_N = "vp Pres midD/pasD Acc Pl n"
    VP_PRES_MIDD_PASD_ACC_SG_F = "vp Pres midD/pasD Acc Sg f"
    VP_PRES_MIDD_PASD_ACC_SG_M = "vp Pres midD/pasD Acc Sg m"
    VP_PRES_MIDD_PASD_ACC_SG_N = "vp Pres midD/pasD Acc Sg n"
    VP_PRES_MIDD_PASD_DAT_PL_F = "vp Pres midD/pasD Dat Pl f"
    VP_PRES_MIDD_PASD_DAT_PL_M = "vp Pres midD/pasD Dat Pl m"
    VP_PRES_MIDD_PASD_DAT_PL_N = "vp Pres midD/pasD Dat Pl n"
    VP_PRES_MIDD_PASD_DAT_SG_F = "vp Pres midD/pasD Dat Sg f"
    VP_PRES_MIDD_PASD_DAT_SG_M = "vp Pres midD/pasD Dat Sg m"
    VP_PRES_MIDD_PASD_DAT_SG_N = "vp Pres midD/pasD Dat Sg n"
    VP_PRES_MIDD_PASD_GEN_PL_F = "vp Pres midD/pasD Gen Pl f"
    VP_PRES_MIDD_PASD_GEN_PL_M = "vp Pres midD/pasD Gen Pl m"
    VP_PRES_MIDD_PASD_GEN_PL_N = "vp Pres midD/pasD Gen Pl n"
    VP_PRES_MIDD_PASD_GEN_SG_F = "vp Pres midD/pasD Gen Sg f"
    VP_PRES_MIDD_PASD_GEN_SG_M = "vp Pres midD/pasD Gen Sg m"
    VP_PRES_MIDD_PASD_GEN_SG_N = "vp Pres midD/pasD Gen Sg n"
    VP_PRES_MIDD_PASD_NOM_PL_F = "vp Pres midD/pasD Nom Pl f"
    VP_PRES_MIDD_PASD_NOM_PL_M = "vp Pres midD/pasD Nom Pl m"
    VP_PRES_MIDD_PASD_NOM_PL_N = "vp Pres midD/pasD Nom Pl n"
    VP_PRES_MIDD_PASD_NOM_SG_F = "vp Pres midD/pasD Nom Sg f"
    VP_PRES_MIDD_PASD_NOM_SG_M = "vp Pres midD/pasD Nom Sg m"
    VP_PRES_MIDD_PASD_NOM_SG_N = "vp Pres midD/pasD Nom Sg n"
    VP_PRES_PAS_ACC_PL = "vp Pres Pas Acc Pl"
    VP_PRES_PAS_ACC_PL_F = "vp Pres Pas Acc Pl f"
    VP_PRES_PAS_ACC_PL_M = "vp Pres Pas Acc Pl m"
    VP_PRES_PAS_ACC_PL_N = "vp Pres Pas Acc Pl n"
    VP_PRES_PAS_ACC_SG_F = "vp Pres Pas Acc Sg f"
    VP_PRES_PAS_ACC_SG_M = "vp Pres Pas Acc Sg m"
    VP_PRES_PAS_ACC_SG_N = "vp Pres Pas Acc Sg n"
    VP_PRES_PAS_DAT_PL_M = "vp Pres Pas Dat Pl m"
    VP_PRES_PAS_DAT_PL_N = "vp Pres Pas Dat Pl n"
    VP_PRES_PAS_DAT_SG_F = "vp Pres Pas Dat Sg f"
    VP_PRES_PAS_DAT_SG_M = "vp Pres Pas Dat Sg m"
    VP_PRES_PAS_DAT_SG_N = "vp Pres Pas Dat Sg n"
    VP_PRES_PAS_GEN_PL_M = "vp Pres Pas Gen Pl m"
    VP_PRES_PAS_GEN_PL_N = "vp Pres Pas Gen Pl n"
    VP_PRES_PAS_GEN_SG_F = "vp Pres Pas Gen Sg f"
    VP_PRES_PAS_GEN_SG_M = "vp Pres Pas Gen Sg m"
    VP_PRES_PAS_GEN_SG_N = "vp Pres Pas Gen Sg n"
    VP_PRES_PAS_NOM_PL_F = "vp Pres Pas Nom Pl f"
    VP_PRES_PAS_NOM_PL_M = "vp Pres Pas Nom Pl m"
    VP_PRES_PAS_NOM_PL_N = "vp Pres Pas Nom Pl n"
    VP_PRES_PAS_NOM_SG_F = "vp Pres Pas Nom Sg f"
    VP_PRES_PAS_NOM_SG_M = "vp Pres Pas Nom Sg m"
    VP_PRES_PAS_NOM_SG_N = "vp Pres Pas Nom Sg n"
    VP_PRES_PASD_NOM_PL_M = "vp Pres pasD Nom Pl m"
    VP_PRES_VXX_ACC_PL_M = "vp Pres vxx Acc Pl m"
    VP_PRES_VXX_ACC_PL_N = "vp Pres vxx Acc Pl n"
    VP_PRES_VXX_ACC_SG_F = "vp Pres vxx Acc Sg f"
    VP_PRES_VXX_ACC_SG_M = "vp Pres vxx Acc Sg m"
    VP_PRES_VXX_ACC_SG_N = "vp Pres vxx Acc Sg n"
    VP_PRES_VXX_DAT_PL_M = "vp Pres vxx Dat Pl m"
    VP_PRES_VXX_DAT_PL_N = "vp Pres vxx Dat Pl n"
    VP_PRES_VXX_DAT_SG_F = "vp Pres vxx Dat Sg f"
    VP_PRES_VXX_DAT_SG_M = "vp Pres vxx Dat Sg m"
    VP_PRES_VXX_GEN_PL_F = "vp Pres vxx Gen Pl f"
    VP_PRES_VXX_GEN_PL_M = "vp Pres vxx Gen Pl m"
    VP_PRES_VXX_GEN_PL_N = "vp Pres vxx Gen Pl n"
    VP_PRES_VXX_GEN_SG_F = "vp Pres vxx Gen Sg f"
    VP_PRES_VXX_GEN_SG_M = "vp Pres vxx Gen Sg m"
    VP_PRES_VXX_GEN_SG_N = "vp Pres vxx Gen Sg n"
    VP_PRES_VXX_NOM_PL_F = "vp Pres vxx Nom Pl f"
    VP_PRES_VXX_NOM_PL_M = "vp Pres vxx Nom Pl m"
    VP_PRES_VXX_NOM_PL_N = "vp Pres vxx Nom Pl n"
    VP_PRES_VXX_NOM_SG_F = "vp Pres vxx Nom Sg f"
    VP_PRES_VXX_NOM_SG_M = "vp Pres vxx Nom Sg m"
    VS_2AOR_ACT_1_PL = "vs 2Aor Act 1 Pl"
    VS_2AOR_ACT_1_SG = "vs 2Aor Act 1 Sg"
    VS_2AOR_ACT_2_PL = "vs 2Aor Act 2 Pl"
    VS_2AOR_ACT_2_SG = "vs 2Aor Act 2 Sg"
    VS_2AOR_ACT_3_PL = "vs 2Aor Act 3 Pl"
    VS_2AOR_ACT_3_SG = "vs 2Aor Act 3 Sg"
    VS_2AOR_MID_1_PL = "vs 2Aor Mid 1 Pl"
    VS_2AOR_MID_1_SG = "vs 2Aor Mid 1 Sg"
    VS_2AOR_MID_2_SG = "vs 2Aor Mid 2 Sg"
    VS_2AOR_MID_3_PL = "vs 2Aor Mid 3 Pl"
    VS_2AOR_MID_3_SG = "vs 2Aor Mid 3 Sg"
    VS_2AOR_MIDD_1_PL = "vs 2Aor midD 1 Pl"
    VS_2AOR_MIDD_1_SG = "vs 2Aor midD 1 Sg"
    VS_2AOR_MIDD_2_PL = "vs 2Aor midD 2 Pl"
    VS_2AOR_MIDD_3_PL = "vs 2Aor midD 3 Pl"
    VS_2AOR_MIDD_3_SG = "vs 2Aor midD 3 Sg"
    VS_2AOR_PAS_1_PL = "vs 2Aor Pas 1 Pl"
    VS_2AOR_PAS_2_PL = "vs 2Aor Pas 2 Pl"
    VS_2AOR_PAS_2_SG = "vs 2Aor Pas 2 Sg"
    VS_2AOR_PAS_3_PL = "vs 2Aor Pas 3 Pl"
    VS_2AOR_PAS_3_SG = "vs 2Aor Pas 3 Sg"
    VS_2AOR_PASD_2_PL = "vs 2Aor pasD 2 Pl"
    VS_2AOR_VXX_2_PL = "vs 2Aor vxx 2 Pl"
    VS_AOR_ACT_1_PL = "vs Aor Act 1 Pl"
    VS_AOR_ACT_1_SG = "vs Aor Act 1 Sg"
    VS_AOR_ACT_2_PL = "vs Aor Act 2 Pl"
    VS_AOR_ACT_2_SG = "vs Aor Act 2 Sg"
    VS_AOR_ACT_3_PL = "vs Aor Act 3 Pl"
    VS_AOR_ACT_3_SG = "vs Aor Act 3 Sg"
    VS_AOR_MID_1_PL = "vs Aor Mid 1 Pl"
    VS_AOR_MID_1_SG = "vs Aor Mid 1 Sg"
    VS_AOR_MID_2_PL = "vs Aor Mid 2 Pl"
    VS_AOR_MID_2_SG = "vs Aor Mid 2 Sg"
    VS_AOR_MID_3_PL = "vs Aor Mid 3 Pl"
    VS_AOR_MID_3_SG = "vs Aor Mid 3 Sg"
    VS_AOR_MIDD_1_PL = "vs Aor midD 1 Pl"
    VS_AOR_MIDD_1_SG = "vs Aor midD 1 Sg"
    VS_AOR_MIDD_2_PL = "vs Aor midD 2 Pl"
    VS_AOR_MIDD_2_SG = "vs Aor midD 2 Sg"
    VS_AOR_MIDD_3_PL = "vs Aor midD 3 Pl"
    VS_AOR_MIDD_3_SG = "vs Aor midD 3 Sg"
    VS_AOR_PAS_1_PL = "vs Aor Pas 1 Pl"
    VS_AOR_PAS_1_SG = "vs Aor Pas 1 Sg"
    VS_AOR_PAS_2_PL = "vs Aor Pas 2 Pl"
    VS_AOR_PAS_2_SG = "vs Aor Pas 2 Sg"
    VS_AOR_PAS_3_PL = "vs Aor Pas 3 Pl"
    VS_AOR_PAS_3_SG = "vs Aor Pas 3 Sg"
    VS_AOR_PASD_1_PL = "vs Aor pasD 1 Pl"
    VS_AOR_PASD_1_SG = "vs Aor pasD 1 Sg"
    VS_AOR_PASD_2_PL = "vs Aor pasD 2 Pl"
    VS_AOR_PASD_2_SG = "vs Aor pasD 2 Sg"
    VS_AOR_PASD_3_PL = "vs Aor pasD 3 Pl"
    VS_AOR_PASD_3_SG = "vs Aor pasD 3 Sg"
    VS_AOR_PRES_2_PL = "vs Aor Pres 2 Pl"
    VS_PERF_ACT_1_PL = "vs Perf Act 1 Pl"
    VS_PERF_ACT_1_SG = "vs Perf Act 1 Sg"
    VS_PERF_ACT_2_PL = "vs Perf Act 2 Pl"
    VS_PERF_ACT_2_SG = "vs Perf Act 2 Sg"
    VS_PRES_ACC_1_SG = "vs Pres Acc 1 Sg"
    VS_PRES_ACT_1_PL = "vs Pres Act 1 Pl"
    VS_PRES_ACT_1_SG = "vs Pres Act 1 Sg"
    VS_PRES_ACT_2_PL = "vs Pres Act 2 Pl"
    VS_PRES_ACT_2_SG = "vs Pres Act 2 Sg"
    VS_PRES_ACT_3_PL = "vs Pres Act 3 Pl"
    VS_PRES_ACT_3_SG = "vs Pres Act 3 Sg"
    VS_PRES_IM_ACT_3_SG = "vs Pres im-Act 3 Sg"
    VS_PRES_MID_1_PL = "vs Pres Mid 1 Pl"
    VS_PRES_MID_1_SG = "vs Pres Mid 1 Sg"
    VS_PRES_MID_2_SG = "vs Pres Mid 2 Sg"
    VS_PRES_MID_3_SG = "vs Pres Mid 3 Sg"
    VS_PRES_MID_PAS_3_SG = "vs Pres Mid/Pas 3 Sg"
    VS_PRES_MIDD_PASD_1_PL = "vs Pres midD/pasD 1 Pl"
    VS_PRES_MIDD_PASD_1_SG = "vs Pres midD/pasD 1 Sg"
    VS_PRES_MIDD_PASD_2_PL = "vs Pres midD/pasD 2 Pl"
    VS_PRES_MIDD_PASD_2_SG = "vs Pres midD/pasD 2 Sg"
    VS_PRES_MIDD_PASD_3_PL = "vs Pres midD/pasD 3 Pl"
    VS_PRES_MIDD_PASD_3_SG = "vs Pres midD/pasD 3 Sg"
    VS_PRES_PAS_1_PL = "vs Pres Pas 1 Pl"
    VS_PRES_PAS_1_SG = "vs Pres Pas 1 Sg"
    VS_PRES_PAS_2_PL = "vs Pres Pas 2 Pl"
    VS_PRES_PAS_3_PL = "vs Pres Pas 3 Pl"
    VS_PRES_PAS_3_SG = "vs Pres Pas 3 Sg"
    VS_PRES_VXX_1_PL = "vs Pres vxx 1 Pl"
    VS_PRES_VXX_1_SG = "vs Pres vxx 1 Sg"
    VS_PRES_VXX_2_PL = "vs Pres vxx 2 Pl"
    VS_PRES_VXX_2_SG = "vs Pres vxx 2 Sg"
    VS_PRES_VXX_3_PL = "vs Pres vxx 3 Pl"
    VS_PRES_VXX_3_SG = "vs Pres vxx 3 Sg"
