"""
Color data include conversion coefficients, primaries, and
tristimulus data..
"""
from frads.types import ColorPrimaries

LEMAX = 683
# Melanopic max luminous efficacy for D65
MLEMAX = 754

# Color Primaries
CP_RAD = ColorPrimaries(0.64, 0.33, 0.29, 0.6, 0.15, 0.06, 1 / 3, 1 / 3)
CP_SHP = ColorPrimaries(0.6898, 0.3206, 0.0736, 0.9003, 0.1166, 0.0374, 1 / 3, 1 / 3)
CP_ADB = ColorPrimaries(0.640, 0.330, 0.210, 0.710, 0.150, 0.060, 0.3127, 0.3290)
CP_RIM = ColorPrimaries(0.7347, 0.2653, 0.1596, 0.8404, 0.0366, 0.0001, 0.3457, 0.3585)
CP_P3 = ColorPrimaries(0.680, 0.320, 0.265, 0.690, 0.150, 0.060, 0.314, 0.351)
CP_2020 = ColorPrimaries(0.708, 0.292, 0.170, 0.797, 0.131, 0.046, 0.3127, 0.3290)
CP_SRGB = ColorPrimaries(0.640, 0.330, 0.300, 0.600, 0.150, 0.060, 0.3127, 0.3290)

# Conversion matrices
XYZ2RGB_RAD = (
    2.565312843029638,
    -1.1668496158068056,
    -0.39846322722283206,
    -1.0221081721279117,
    1.978286616660087,
    0.04382155546782474,
    0.07472437729685599,
    -0.25193956717027366,
    1.1772151898734173,
)
RGB2XYZ_RAD = (
    0.5141446208112873,
    0.32388447971781287,
    0.1619708994708995,
    0.26510582010582007,
    0.6701058201058199,
    0.06478835978835978,
    0.024100529100529074,
    0.12285273368606696,
    0.853046737213404,
)

XYZ2RGB_ADB = (
    2.0415879038107465,
    -0.5650069742788598,
    -0.3447313507783297,
    -0.9692436362808802,
    1.875967501507721,
    0.04155505740717565,
    0.013444280632031154,
    -0.11836239223101852,
    1.0151749943912054,
)

RGB2XYZ_ADB = (
    0.5766690429101305,
    0.18555823790654624,
    0.18822864623499475,
    0.29734497525053605,
    0.6273635662554659,
    0.0752914584939979,
    0.027031361386412343,
    0.0706888525358272,
    0.9913375368376389,
)

XYZ2RGB_RIM = (
    1.3457989731028284,
    -0.25558010007997545,
    -0.051106285067534014,
    -0.5446224939028348,
    1.5082327413132786,
    0.02053603239147973,
    0.0,
    0.0,
    1.2119675456389456,
)

RGB2XYZ_RIM = (
    0.7977604896723026,
    0.13518583717574031,
    0.0313493495815248,
    0.2880711282292934,
    0.7118432178101013,
    8.565396060525902e-05,
    0.0,
    0.0,
    0.8251046025104601,
)

XYZ2RGB_P3 = (
    2.7253940304917337,
    -1.0180030062271856,
    -0.4401631951900367,
    -0.7951680258087642,
    1.6897320548436239,
    0.022647190608477454,
    0.04124189139570011,
    -0.08763901921586228,
    1.100929378646322,
)

RGB2XYZ_p3 = (
    0.4451698155645523,
    0.27713440920677773,
    0.17228266981556462,
    0.2094916779127305,
    0.7215952541610439,
    0.06891306792622585,
    -3.634101316969855e-17,
    0.04706056005398116,
    0.9073553943619739,
)

XYZ2RGB_2020 = (
    1.7166511879712683,
    -0.35567078377639255,
    -0.2533662813736599,
    -0.666684351832489,
    1.616481236634939,
    0.01576854581391114,
    0.017639857445310676,
    -0.04277061325780856,
    0.9421031212354742,
)

RGB2XYZ_2020 = (
    0.6369580483012911,
    0.14461690358620838,
    0.16888097516417205,
    0.262700212011267,
    0.677998071518871,
    0.05930171646986194,
    4.994106574466074e-17,
    0.028072693049087438,
    1.0609850577107907,
)

XYZ2RGB_SRGB = (
    3.240969941904522,
    -1.5373831775700937,
    -0.49861076029300333,
    -0.9692436362808802,
    1.875967501507721,
    0.04155505740717565,
    0.055630079696993656,
    -0.20397695888897674,
    1.0569715142428786,
)

RGB2XYZ_SRGB = (
    0.41239079926595945,
    0.35758433938387785,
    0.1804807884018343,
    0.21263900587151033,
    0.7151686787677557,
    0.07219231536073371,
    0.01933081871559183,
    0.11919477979462592,
    0.9505321522496606,
)


COLOR_PRIMARIES = {
    "radiance": CP_RAD,
    "sharp": CP_SHP,
    "adobe": CP_ADB,
    "rimm": CP_RIM,
    "p3": CP_P3,
    "2020": CP_2020,
    "srgb": CP_SRGB,
}

CIE_XYZ_2 = {
    360: (0.0001299, 0.000003917, 0.0006061),
    361: (0.000145847, 0.000004393581, 0.00068087),
    362: (0.0001638021, 0.000004929604, 0.00076514),
    363: (0.0001840037, 0.000005532136, 0.00086001),
    364: (0.0002066902, 0.000006208245, 0.00096659),
    365: (0.0002321, 0.000006965, 0.0010860),
    366: (0.000260728, 0.000007813219, 0.00122058),
    367: (0.000293075, 0.000008767336, 0.00137272),
    368: (0.000329388, 0.000009839844, 0.00154357),
    369: (0.000369914, 0.00001104323, 0.00173428),
    370: (0.0004149, 0.00001239, 0.0019460),
    371: (0.0004641587, 0.00001388641, 0.00217777),
    372: (0.000518986, 0.00001555728, 0.00243580),
    373: (0.000581854, 0.00001744296, 0.00273195),
    374: (0.0006552347, 0.00001958375, 0.00307806),
    375: (0.0007416, 0.00002202, 0.0034860),
    376: (0.0008450296, 0.00002483965, 0.00397522),
    377: (0.0009645268, 0.00002804126, 0.00454088),
    378: (0.001094949, 0.00003153104, 0.00515832),
    379: (0.001231154, 0.00003521521, 0.00580290),
    380: (0.0013680, 0.0000390, 0.00645000),
    381: (0.00150205, 0.0000428264, 0.00708321),
    382: (0.001642328, 0.0000469146, 0.00774548),
    383: (0.001802382, 0.0000515896, 0.00850115),
    384: (0.001995757, 0.0000571764, 0.00941454),
    385: (0.0022360, 0.0000640, 0.01054999),
    386: (0.002535385, 0.00007234421, 0.0119658),
    387: (0.002892603, 0.00008221224, 0.01365587),
    388: (0.003300829, 0.00009350816, 0.01558805),
    389: (0.003753236, 0.0001061361, 0.01773015),
    390: (0.0042430, 0.0001200, 0.02005001),
    391: (0.004762389, 0.000134984, 0.02251136),
    392: (0.005330048, 0.000151492, 0.02520288),
    393: (0.005978712, 0.000170208, 0.02827972),
    394: (0.006741117, 0.000191816, 0.03189704),
    395: (0.0076500, 0.0002170, 0.0362100),
    396: (0.008751373, 0.0002469067, 0.04143771),
    397: (0.01002888, 0.00028124, 0.04750372),
    398: (0.0114217, 0.00031852, 0.05411988),
    399: (0.01286901, 0.0003572667, 0.06099803),
    400: (0.0143100, 0.0003960, 0.06785001),
    401: (0.01570443, 0.0004337147, 0.07448632),
    402: (0.01714744, 0.000473024, 0.08136156),
    403: (0.01878122, 0.000517876, 0.08915364),
    404: (0.02074801, 0.0005722187, 0.09854048),
    405: (0.0231900, 0.0006400, 0.1102000),
    406: (0.02620736, 0.00072456, 0.1246133),
    407: (0.02978248, 0.0008255, 0.1417017),
    408: (0.03388092, 0.00094116, 0.1613035),
    409: (0.03846824, 0.00106988, 0.1832568),
    410: (0.0435100, 0.0012100, 0.2074000),
    411: (0.0489956, 0.001362091, 0.2336921),
    412: (0.0550226, 0.001530752, 0.2626114),
    413: (0.0617188, 0.001720368, 0.2947746),
    414: (0.0692120, 0.001935323, 0.3307985),
    415: (0.0776300, 0.0021800, 0.3713000),
    416: (0.08695811, 0.0024548, 0.4162091),
    417: (0.09717672, 0.0027640, 0.4654642),
    418: (0.1084063, 0.0031178, 0.5196948),
    419: (0.1207672, 0.0035264, 0.5795303),
    420: (0.1343800, 0.0040000, 0.6456000),
    421: (0.1493582, 0.00454624, 0.7184838),
    422: (0.1653957, 0.00515932, 0.7967133),
    423: (0.1819831, 0.00582928, 0.8778459),
    424: (0.1986110, 0.00654616, 0.9594390),
    425: (0.2147700, 0.0073000, 1.0390501),
    426: (0.2301868, 0.008086507, 1.1153673),
    427: (0.2448797, 0.00890872, 1.1884971),
    428: (0.2587773, 0.00976768, 1.2581233),
    429: (0.2718079, 0.01066443, 1.3239296),
    430: (0.2839000, 0.0116000, 1.3856000),
    431: (0.2949438, 0.01257317, 1.4426352),
    432: (0.3048965, 0.01358272, 1.4948035),
    433: (0.3137873, 0.01462968, 1.5421903),
    434: (0.3216454, 0.01571509, 1.5848807),
    435: (0.3285000, 0.0168400, 1.6229600),
    436: (0.3343513, 0.01800736, 1.6564048),
    437: (0.3392101, 0.01921448, 1.6852959),
    438: (0.3431213, 0.02045392, 1.7098745),
    439: (0.3461296, 0.02171824, 1.7303821),
    440: (0.3482800, 0.0230000, 1.7470600),
    441: (0.3495999, 0.02429461, 1.7600446),
    442: (0.3501474, 0.02561024, 1.7696233),
    443: (0.3500130, 0.02695857, 1.7762637),
    444: (0.3492870, 0.02835125, 1.7804334),
    445: (0.3480600, 0.0298000, 1.7826000),
    446: (0.3463733, 0.03131083, 1.7829682),
    447: (0.3442624, 0.03288368, 1.7816998),
    448: (0.3418088, 0.03452112, 1.7791982),
    449: (0.3390941, 0.03622571, 1.7758671),
    450: (0.3362000, 0.0380000, 1.7721100),
    451: (0.3331977, 0.03984667, 1.7682589),
    452: (0.3300411, 0.0417680, 1.7640390),
    453: (0.3266357, 0.0437660, 1.7589438),
    454: (0.3228868, 0.04584267, 1.7524663),
    455: (0.3187000, 0.0480000, 1.7441000),
    456: (0.3140251, 0.05024368, 1.7335595),
    457: (0.3088840, 0.05257304, 1.7208581),
    458: (0.3032904, 0.05498056, 1.7059369),
    459: (0.2972579, 0.05745872, 1.6887372),
    460: (0.2908000, 0.0600000, 1.6692000),
    461: (0.2839701, 0.06260197, 1.6475287),
    462: (0.2767214, 0.06527752, 1.6234127),
    463: (0.2689178, 0.06804208, 1.5960223),
    464: (0.2604227, 0.07091109, 1.5645280),
    465: (0.2511000, 0.0739000, 1.5281000),
    466: (0.2408475, 0.0770160, 1.4861114),
    467: (0.2298512, 0.0802664, 1.4395215),
    468: (0.2184072, 0.0836668, 1.3898799),
    469: (0.2068115, 0.0872328, 1.3387362),
    470: (0.1953600, 0.0909800, 1.2876400),
    471: (0.1842136, 0.09491755, 1.2374223),
    472: (0.1733273, 0.09904584, 1.1878243),
    473: (0.1626881, 0.1033674, 1.1387611),
    474: (0.1522833, 0.1078846, 1.0901480),
    475: (0.1421000, 0.1126000, 1.0419000),
    476: (0.1321786, 0.1175320, 0.9941976),
    477: (0.1225696, 0.1226744, 0.9473473),
    478: (0.1132752, 0.1279928, 0.9014531),
    479: (0.1042979, 0.1334528, 0.8566193),
    480: (0.0956400, 0.1390200, 0.8129501),
    481: (0.08729955, 0.1446764, 0.7705173),
    482: (0.07930804, 0.1504693, 0.7294448),
    483: (0.07171776, 0.1564619, 0.6899136),
    484: (0.06458099, 0.1627177, 0.6521049),
    485: (0.05795001, 0.1693000, 0.6162000),
    486: (0.05186211, 0.1762431, 0.5823286),
    487: (0.04628152, 0.1835581, 0.5504162),
    488: (0.04115088, 0.1912735, 0.5203376),
    489: (0.03641283, 0.1994180, 0.4919673),
    490: (0.0320100, 0.2080200, 0.4651800),
    491: (0.0279172, 0.2171199, 0.4399246),
    492: (0.0241444, 0.2267345, 0.4161836),
    493: (0.0206870, 0.2368571, 0.3938822),
    494: (0.0175404, 0.2474812, 0.3729459),
    495: (0.0147000, 0.2586000, 0.3533000),
    496: (0.01216179, 0.2701849, 0.3348578),
    497: (0.00991996, 0.2822939, 0.3175521),
    498: (0.00796724, 0.2950505, 0.3013375),
    499: (0.006296346, 0.3085780, 0.2861686),
    500: (0.0049000, 0.3230000, 0.2720000),
    501: (0.003777173, 0.3384021, 0.2588171),
    502: (0.00294532, 0.3546858, 0.2464838),
    503: (0.00242488, 0.3716986, 0.2347718),
    504: (0.002236293, 0.3892875, 0.2234533),
    505: (0.0024000, 0.4073000, 0.2123000),
    506: (0.00292552, 0.4256299, 0.2011692),
    507: (0.00383656, 0.4443096, 0.1901196),
    508: (0.00517484, 0.4633944, 0.1792254),
    509: (0.00698208, 0.4829395, 0.1685608),
    510: (0.0093000, 0.5030000, 0.1582000),
    511: (0.01214949, 0.5235693, 0.1481383),
    512: (0.01553588, 0.5445120, 0.1383758),
    513: (0.01947752, 0.5656900, 0.1289942),
    514: (0.02399277, 0.5869653, 0.1200751),
    515: (0.0291000, 0.6082000, 0.1117000),
    516: (0.03481485, 0.6293456, 0.1039048),
    517: (0.04112016, 0.6503068, 0.09666748),
    518: (0.04798504, 0.6708752, 0.08998272),
    519: (0.05537861, 0.6908424, 0.08384531),
    520: (0.0632700, 0.7100000, 0.07824999),
    521: (0.07163501, 0.7281852, 0.07320899),
    522: (0.08046224, 0.7454636, 0.06867816),
    523: (0.08973996, 0.7619694, 0.06456784),
    524: (0.09945645, 0.7778368, 0.06078835),
    525: (0.1096000, 0.7932000, 0.05725001),
    526: (0.1201674, 0.8081104, 0.05390435),
    527: (0.1311145, 0.8224962, 0.05074664),
    528: (0.1423679, 0.8363068, 0.04775276),
    529: (0.1538542, 0.8494916, 0.04489859),
    530: (0.1655000, 0.8620000, 0.0421600),
    531: (0.1772571, 0.8738108, 0.03950728),
    532: (0.1891400, 0.8849624, 0.03693564),
    533: (0.2011694, 0.8954936, 0.03445836),
    534: (0.2133658, 0.9054432, 0.03208872),
    535: (0.2257499, 0.9148501, 0.0298400),
    536: (0.2383209, 0.9237348, 0.02771181),
    537: (0.2510668, 0.9320924, 0.02569444),
    538: (0.2639922, 0.9399226, 0.02378716),
    539: (0.2771017, 0.9472252, 0.02198925),
    540: (0.2904000, 0.9540000, 0.0203000),
    541: (0.3038912, 0.9602561, 0.01871805),
    542: (0.3175726, 0.9660074, 0.01724036),
    543: (0.3314384, 0.9712606, 0.01586364),
    544: (0.3454828, 0.9760225, 0.01458461),
    545: (0.3597000, 0.9803000, 0.0134000),
    546: (0.3740839, 0.9840924, 0.01230723),
    547: (0.3886396, 0.9874182, 0.01130188),
    548: (0.4033784, 0.9903128, 0.01037792),
    549: (0.4183115, 0.9928116, 0.00952930),
    550: (0.4334499, 0.9949501, 0.00874999),
    551: (0.4487953, 0.9967108, 0.0080352),
    552: (0.4643360, 0.9980983, 0.0073816),
    553: (0.4800640, 0.9991120, 0.0067854),
    554: (0.4959713, 0.9997482, 0.0062428),
    555: (0.5120501, 1.0000000, 0.00574999),
    556: (0.5282959, 0.9998567, 0.0053036),
    557: (0.5446916, 0.9993046, 0.0048998),
    558: (0.5612094, 0.9983255, 0.0045342),
    559: (0.5778215, 0.9968987, 0.0042024),
    560: (0.5945000, 0.9950000, 0.0039000),
    561: (0.6112209, 0.9926005, 0.0036232),
    562: (0.6279758, 0.9897426, 0.0033706),
    563: (0.6447602, 0.9864444, 0.0031414),
    564: (0.6615697, 0.9827241, 0.0029348),
    565: (0.6784000, 0.9786000, 0.00274999),
    566: (0.6952392, 0.9740837, 0.0025852),
    567: (0.7120586, 0.9691712, 0.0024386),
    568: (0.7288284, 0.9638568, 0.0023094),
    569: (0.7455188, 0.9581349, 0.0021968),
    570: (0.7621000, 0.9520000, 0.0021000),
    571: (0.7785432, 0.9454504, 0.00201773),
    572: (0.7948256, 0.9384992, 0.0019482),
    573: (0.8109264, 0.9311628, 0.0018898),
    574: (0.8268248, 0.9234576, 0.00184093),
    575: (0.8425000, 0.9154000, 0.0018000),
    576: (0.8579325, 0.9070064, 0.00176626),
    577: (0.8730816, 0.8982772, 0.0017378),
    578: (0.8878944, 0.8892048, 0.0017112),
    579: (0.9023181, 0.8797816, 0.00168306),
    580: (0.9163000, 0.8700000, 0.00165000),
    581: (0.9297995, 0.8598613, 0.00161013),
    582: (0.9427984, 0.8493920, 0.0015644),
    583: (0.9552776, 0.8386220, 0.0015136),
    584: (0.9672179, 0.8275813, 0.00145853),
    585: (0.9786000, 0.8163000, 0.0014000),
    586: (0.9893856, 0.8047947, 0.00133666),
    587: (0.9995488, 0.7930820, 0.0012700),
    588: (1.0090892, 0.7811920, 0.0012050),
    589: (1.0180064, 0.7691547, 0.00114666),
    590: (1.0263000, 0.7570000, 0.0011000),
    591: (1.0339827, 0.7447541, 0.0010688),
    592: (1.0409860, 0.7324224, 0.0010494),
    593: (1.0471880, 0.7200036, 0.0010356),
    594: (1.0524667, 0.7074965, 0.0010212),
    595: (1.0567000, 0.6949000, 0.0010000),
    596: (1.0597944, 0.6822192, 0.00096864),
    597: (1.0617992, 0.6694716, 0.00092992),
    598: (1.0628068, 0.6566744, 0.00088688),
    599: (1.0629096, 0.6438448, 0.00084256),
    600: (1.0622000, 0.6310000, 0.0008000),
    601: (1.0607352, 0.6181555, 0.00076096),
    602: (1.0584436, 0.6053144, 0.00072368),
    603: (1.0552244, 0.5924756, 0.00068592),
    604: (1.0509768, 0.5796379, 0.00064544),
    605: (1.0456000, 0.5668000, 0.0006000),
    606: (1.0390369, 0.5539611, 0.00054786),
    607: (1.0313608, 0.5411372, 0.0004916),
    608: (1.0226662, 0.5283528, 0.0004354),
    609: (1.0130477, 0.5156323, 0.00038346),
    610: (1.0026000, 0.5030000, 0.0003400),
    611: (0.9913675, 0.4904688, 0.00030725),
    612: (0.9793314, 0.4780304, 0.00028316),
    613: (0.9664916, 0.4656776, 0.00026544),
    614: (0.9528479, 0.4534032, 0.00025181),
    615: (0.9384000, 0.4412000, 0.0002400),
    616: (0.9231940, 0.4290800, 0.00022954),
    617: (0.9072440, 0.4170360, 0.00022064),
    618: (0.8905020, 0.4050320, 0.00021196),
    619: (0.8729200, 0.3930320, 0.00020218),
    620: (0.8544499, 0.3810000, 0.0001900),
    621: (0.8350840, 0.3689184, 0.00017421),
    622: (0.8149460, 0.3568272, 0.00015564),
    623: (0.7941860, 0.3447768, 0.00013596),
    624: (0.7729540, 0.3328176, 0.00011685),
    625: (0.7514000, 0.3210000, 0.0001000),
    626: (0.7295836, 0.3093381, 0.00008613),
    627: (0.7075888, 0.2978504, 0.0000746),
    628: (0.6856022, 0.2865936, 0.0000650),
    629: (0.6638104, 0.2756245, 0.00005693),
    630: (0.6424000, 0.2650000, 0.00004999),
    631: (0.6215149, 0.2547632, 0.00004416),
    632: (0.6011138, 0.2448896, 0.00003948),
    633: (0.5811052, 0.2353344, 0.00003572),
    634: (0.5613977, 0.2260528, 0.00003264),
    635: (0.5419000, 0.2170000, 0.0000300),
    636: (0.5225995, 0.2081616, 0.00002765),
    637: (0.5035464, 0.1995488, 0.00002556),
    638: (0.4847436, 0.1911552, 0.00002364),
    639: (0.4661939, 0.1829744, 0.00002181),
    640: (0.4479000, 0.1750000, 0.0000200),
    641: (0.4298613, 0.1672235, 0.00001813),
    642: (0.4120980, 0.1596464, 0.0000162),
    643: (0.3946440, 0.1522776, 0.0000142),
    644: (0.3775333, 0.1451259, 0.00001213),
    645: (0.3608000, 0.1382000, 0.0000100),
    646: (0.3444563, 0.1315003, 0.00000773),
    647: (0.3285168, 0.1250248, 0.0000054),
    648: (0.3130192, 0.1187792, 0.0000032),
    649: (0.2980011, 0.1127691, 0.00000133),
    650: (0.2835000, 0.1070000, 0.0000000),
    651: (0.2695448, 0.1014762, 0.0000000),
    652: (0.2561184, 0.09618864, 0.0000000),
    653: (0.2431896, 0.09112296, 0.0000000),
    654: (0.2307272, 0.08626485, 0.0000000),
    655: (0.2187000, 0.0816000, 0.0000000),
    656: (0.2070971, 0.07712064, 0.0000000),
    657: (0.1959232, 0.07282552, 0.0000000),
    658: (0.1851708, 0.06871008, 0.0000000),
    659: (0.1748323, 0.06476976, 0.0000000),
    660: (0.1649000, 0.0610000, 0.0000000),
    661: (0.1553667, 0.05739621, 0.0000000),
    662: (0.1462300, 0.05395504, 0.0000000),
    663: (0.1374900, 0.05067376, 0.0000000),
    664: (0.1291467, 0.04754965, 0.0000000),
    665: (0.1212000, 0.0445800, 0.0000000),
    666: (0.1136397, 0.04175872, 0.0000000),
    667: (0.1064650, 0.03908496, 0.0000000),
    668: (0.09969044, 0.03656384, 0.0000000),
    669: (0.09333061, 0.03420048, 0.0000000),
    670: (0.0874000, 0.0320000, 0.0000000),
    671: (0.08190096, 0.02996261, 0.0000000),
    672: (0.07680428, 0.02807664, 0.0000000),
    673: (0.07207712, 0.02632936, 0.0000000),
    674: (0.06768664, 0.02470805, 0.0000000),
    675: (0.0636000, 0.0232000, 0.0000000),
    676: (0.05980685, 0.02180077, 0.0000000),
    677: (0.05628216, 0.02050112, 0.0000000),
    678: (0.05297104, 0.01928108, 0.0000000),
    679: (0.04981861, 0.01812069, 0.0000000),
    680: (0.0467700, 0.0170000, 0.0000000),
    681: (0.04378405, 0.01590379, 0.0000000),
    682: (0.04087536, 0.01483718, 0.0000000),
    683: (0.03807264, 0.01381068, 0.0000000),
    684: (0.03540461, 0.01283478, 0.0000000),
    685: (0.0329000, 0.0119200, 0.0000000),
    686: (0.03056419, 0.01106831, 0.0000000),
    687: (0.02838056, 0.01027339, 0.0000000),
    688: (0.02634484, 0.009533311, 0.0000000),
    689: (0.02445275, 0.008846157, 0.0000000),
    690: (0.0227000, 0.0082100, 0.0000000),
    691: (0.02108429, 0.007623781, 0.0000000),
    692: (0.01959988, 0.007085424, 0.0000000),
    693: (0.01823732, 0.006591476, 0.0000000),
    694: (0.01698717, 0.006138485, 0.0000000),
    695: (0.0158400, 0.0057230, 0.0000000),
    696: (0.01479064, 0.005343059, 0.0000000),
    697: (0.01383132, 0.004995796, 0.0000000),
    698: (0.01294868, 0.004676404, 0.0000000),
    699: (0.0121292, 0.004380075, 0.0000000),
    700: (0.01135916, 0.0041020, 0.0000000),
    701: (0.01062935, 0.003838453, 0.0000000),
    702: (0.009938846, 0.003589099, 0.0000000),
    703: (0.009288422, 0.003354219, 0.0000000),
    704: (0.008678854, 0.003134093, 0.0000000),
    705: (0.008110916, 0.0029290, 0.0000000),
    706: (0.007582388, 0.002738139, 0.0000000),
    707: (0.007088746, 0.002559876, 0.0000000),
    708: (0.006627313, 0.002393244, 0.0000000),
    709: (0.006195408, 0.002237275, 0.0000000),
    710: (0.005790346, 0.0020910, 0.0000000),
    711: (0.005409826, 0.001953587, 0.0000000),
    712: (0.005052583, 0.00182458, 0.0000000),
    713: (0.004717512, 0.00170358, 0.0000000),
    714: (0.004403507, 0.001590187, 0.0000000),
    715: (0.004109457, 0.0014840, 0.0000000),
    716: (0.003833913, 0.001384496, 0.0000000),
    717: (0.003575748, 0.001291268, 0.0000000),
    718: (0.003334342, 0.001204092, 0.0000000),
    719: (0.003109075, 0.001122744, 0.0000000),
    720: (0.002899327, 0.0010470, 0.0000000),
    721: (0.002704348, 0.0009765896, 0.0000000),
    722: (0.00252302, 0.0009111088, 0.0000000),
    723: (0.002354168, 0.0008501332, 0.0000000),
    724: (0.002196616, 0.0007932384, 0.0000000),
    725: (0.00204919, 0.0007400, 0.0000000),
    726: (0.00191096, 0.0006900827, 0.0000000),
    727: (0.001781438, 0.00064331, 0.0000000),
    728: (0.00166011, 0.000599496, 0.0000000),
    729: (0.001546459, 0.0005584547, 0.0000000),
    730: (0.001439971, 0.0005200, 0.0000000),
    731: (0.001340042, 0.0004839136, 0.0000000),
    732: (0.001246275, 0.0004500528, 0.0000000),
    733: (0.001158471, 0.0004183452, 0.0000000),
    734: (0.00107643, 0.0003887184, 0.0000000),
    735: (0.0009999493, 0.0003611, 0.0000000),
    736: (0.0009287358, 0.0003353835, 0.0000000),
    737: (0.0008624332, 0.0003114404, 0.0000000),
    738: (0.0008007503, 0.0002891656, 0.0000000),
    739: (0.000743396, 0.0002684539, 0.0000000),
    740: (0.0006900786, 0.0002492, 0.0000000),
    741: (0.0006405156, 0.0002313019, 0.0000000),
    742: (0.0005945021, 0.0002146856, 0.0000000),
    743: (0.0005518646, 0.0001992884, 0.0000000),
    744: (0.000512429, 0.0001850475, 0.0000000),
    745: (0.0004760213, 0.0001719, 0.0000000),
    746: (0.0004424536, 0.0001597781, 0.0000000),
    747: (0.0004115117, 0.0001486044, 0.0000000),
    748: (0.0003829814, 0.0001383016, 0.0000000),
    749: (0.0003566491, 0.0001287925, 0.0000000),
    750: (0.0003323011, 0.0001200, 0.0000000),
    751: (0.0003097586, 0.0001118595, 0.0000000),
    752: (0.0002888871, 0.0001043224, 0.0000000),
    753: (0.0002695394, 0.0000973356, 0.0000000),
    754: (0.0002515682, 0.00009084587, 0.0000000),
    755: (0.0002348261, 0.0000848, 0.0000000),
    756: (0.000219171, 0.00007914667, 0.0000000),
    757: (0.0002045258, 0.000073858, 0.0000000),
    758: (0.0001908405, 0.000068916, 0.0000000),
    759: (0.0001780654, 0.00006430267, 0.0000000),
    760: (0.0001661505, 0.0000600, 0.0000000),
    761: (0.0001550236, 0.00005598187, 0.0000000),
    762: (0.0001446219, 0.0000522256, 0.0000000),
    763: (0.0001349098, 0.0000487184, 0.0000000),
    764: (0.000125852, 0.00004544747, 0.0000000),
    765: (0.000117413, 0.0000424, 0.0000000),
    766: (0.0001095515, 0.00003956104, 0.0000000),
    767: (0.0001022245, 0.00003691512, 0.0000000),
    768: (0.00009539445, 0.00003444868, 0.0000000),
    769: (0.0000890239, 0.00003214816, 0.0000000),
    770: (0.00008307527, 0.0000300, 0.0000000),
    771: (0.00007751269, 0.00002799125, 0.0000000),
    772: (0.00007231304, 0.00002611356, 0.0000000),
    773: (0.00006745778, 0.00002436024, 0.0000000),
    774: (0.00006292844, 0.00002272461, 0.0000000),
    775: (0.00005870652, 0.0000212, 0.0000000),
    776: (0.00005477028, 0.00001977855, 0.0000000),
    777: (0.00005109918, 0.00001845285, 0.0000000),
    778: (0.00004767654, 0.00001721687, 0.0000000),
    779: (0.00004448567, 0.00001606459, 0.0000000),
    780: (0.00004150994, 0.00001499, 0.0000000),
    781: (0.00003873324, 0.00001398728, 0.0000000),
    782: (0.00003614203, 0.00001305155, 0.0000000),
    783: (0.00003372352, 0.00001217818, 0.0000000),
    784: (0.00003146487, 0.00001136254, 0.0000000),
    785: (0.00002935326, 0.0000106, 0.0000000),
    786: (0.00002737573, 0.000009885877, 0.0000000),
    787: (0.00002552433, 0.000009217304, 0.0000000),
    788: (0.00002379376, 0.000008592362, 0.0000000),
    789: (0.0000221787, 0.000008009133, 0.0000000),
    790: (0.00002067383, 0.0000074657, 0.0000000),
    791: (0.00001927226, 0.000006959567, 0.0000000),
    792: (0.0000179664, 0.000006487995, 0.0000000),
    793: (0.00001674991, 0.000006048699, 0.0000000),
    794: (0.00001561648, 0.000005639396, 0.0000000),
    795: (0.00001455977, 0.0000052578, 0.0000000),
    796: (0.00001357387, 0.000004901771, 0.0000000),
    797: (0.00001265436, 0.00000456972, 0.0000000),
    798: (0.00001179723, 0.000004260194, 0.0000000),
    799: (0.00001099844, 0.000003971739, 0.0000000),
    800: (0.00001025398, 0.0000037029, 0.0000000),
    801: (0.000009559646, 0.000003452163, 0.0000000),
    802: (0.000008912044, 0.000003218302, 0.0000000),
    803: (0.000008308358, 0.0000030003, 0.0000000),
    804: (0.000007745769, 0.000002797139, 0.0000000),
    805: (0.000007221456, 0.0000026078, 0.0000000),
    806: (0.000006732475, 0.00000243122, 0.0000000),
    807: (0.000006276423, 0.000002266531, 0.0000000),
    808: (0.000005851304, 0.000002113013, 0.0000000),
    809: (0.000005455118, 0.000001969943, 0.0000000),
    810: (0.000005085868, 0.0000018366, 0.0000000),
    811: (0.000004741466, 0.00000171223, 0.0000000),
    812: (0.000004420236, 0.000001596228, 0.0000000),
    813: (0.000004120783, 0.00000148809, 0.0000000),
    814: (0.000003841716, 0.000001387314, 0.0000000),
    815: (0.000003581652, 0.0000012934, 0.0000000),
    816: (0.000003339127, 0.00000120582, 0.0000000),
    817: (0.000003112949, 0.000001124143, 0.0000000),
    818: (0.000002902121, 0.000001048009, 0.0000000),
    819: (0.000002705645, 0.000000977058, 0.0000000),
    820: (0.000002522525, 0.00000091093, 0.0000000),
    821: (0.000002351726, 0.000000849251, 0.0000000),
    822: (0.000002192415, 0.000000791721, 0.0000000),
    823: (0.000002043902, 0.00000073809, 0.0000000),
    824: (0.000001905497, 0.00000068811, 0.0000000),
    825: (0.000001776509, 0.00000064153, 0.0000000),
    826: (0.000001656215, 0.00000059809, 0.0000000),
    827: (0.000001544022, 0.000000557575, 0.0000000),
    828: (0.00000143944, 0.000000519808, 0.0000000),
    829: (0.000001341977, 0.000000484612, 0.0000000),
    830: (0.000001251141, 0.00000045181, 0.0000000),
}

CIE_XYZ_10 = {
    360: (0.0000001222, 0.000000013398, 0.000000535027),
    361: (0.000000185138, 0.000000020294, 0.00000081072),
    362: (0.00000027883, 0.00000003056, 0.0000012212),
    363: (0.00000041747, 0.00000004574, 0.0000018287),
    364: (0.00000062133, 0.00000006805, 0.0000027222),
    365: (0.00000091927, 0.00000010065, 0.0000040283),
    366: (0.00000135198, 0.00000014798, 0.0000059257),
    367: (0.00000197654, 0.00000021627, 0.0000086651),
    368: (0.0000028725, 0.0000003142, 0.000012596),
    369: (0.0000041495, 0.0000004537, 0.000018201),
    370: (0.0000059586, 0.0000006511, 0.0000261437),
    371: (0.0000085056, 0.0000009288, 0.00003733),
    372: (0.0000120686, 0.0000013175, 0.000052987),
    373: (0.0000170226, 0.0000018572, 0.000074764),
    374: (0.000023868, 0.000002602, 0.00010487),
    375: (0.000033266, 0.000003625, 0.00014622),
    376: (0.000046087, 0.000005019, 0.00020266),
    377: (0.000063472, 0.000006907, 0.00027923),
    378: (0.000086892, 0.000009449, 0.00038245),
    379: (0.000118246, 0.000012848, 0.00052072),
    380: (0.000159952, 0.000017364, 0.000704776),
    381: (0.00021508, 0.000023327, 0.00094823),
    382: (0.00028749, 0.00003115, 0.0012682),
    383: (0.00038199, 0.00004135, 0.0016861),
    384: (0.00050455, 0.00005456, 0.0022285),
    385: (0.00066244, 0.00007156, 0.0029278),
    386: (0.0008645, 0.0000933, 0.0038237),
    387: (0.0011215, 0.00012087, 0.0049642),
    388: (0.00144616, 0.00015564, 0.0064067),
    389: (0.00185359, 0.0001992, 0.0082193),
    390: (0.0023616, 0.0002534, 0.0104822),
    391: (0.0029906, 0.0003202, 0.0132890),
    392: (0.0037645, 0.0004024, 0.0167470),
    393: (0.0047102, 0.0005023, 0.0209800),
    394: (0.0058581, 0.0006232, 0.0261270),
    395: (0.0072423, 0.0007685, 0.0323440),
    396: (0.0088996, 0.0009417, 0.0398020),
    397: (0.0108709, 0.0011478, 0.0486910),
    398: (0.0131989, 0.0013903, 0.0592100),
    399: (0.0159292, 0.0016740, 0.0715760),
    400: (0.0191097, 0.0020044, 0.0860109),
    401: (0.0227880, 0.0023860, 0.1027400),
    402: (0.0270110, 0.0028220, 0.1220000),
    403: (0.0318290, 0.0033190, 0.1440200),
    404: (0.0372780, 0.0038800, 0.1689900),
    405: (0.0434000, 0.0045090, 0.1971200),
    406: (0.0502230, 0.0052090, 0.2285700),
    407: (0.0577640, 0.0059850, 0.2634700),
    408: (0.0660380, 0.0068330, 0.3019000),
    409: (0.0750330, 0.0077570, 0.3438700),
    410: (0.0847360, 0.0087560, 0.3893660),
    411: (0.0950410, 0.0098160, 0.4379700),
    412: (0.1058360, 0.0109180, 0.4892200),
    413: (0.1170660, 0.0120580, 0.5429000),
    414: (0.1286820, 0.0132370, 0.5988100),
    415: (0.1406380, 0.0144560, 0.6567600),
    416: (0.1528930, 0.0157170, 0.7165800),
    417: (0.1654160, 0.0170250, 0.7781200),
    418: (0.1781910, 0.0183990, 0.8413100),
    419: (0.1912140, 0.0198480, 0.9061100),
    420: (0.2044920, 0.0213910, 0.9725420),
    421: (0.2176500, 0.0229920, 1.0389000),
    422: (0.2302670, 0.0245980, 1.1031000),
    423: (0.2423110, 0.0262130, 1.1651000),
    424: (0.2537930, 0.0278410, 1.2249000),
    425: (0.2647370, 0.0294970, 1.2825000),
    426: (0.2751950, 0.0311950, 1.3382000),
    427: (0.2853010, 0.0329270, 1.3926000),
    428: (0.2951430, 0.0347380, 1.4461000),
    429: (0.3048690, 0.0366540, 1.4994000),
    430: (0.3146790, 0.0386760, 1.5534800),
    431: (0.3243550, 0.0407920, 1.6072000),
    432: (0.3335700, 0.0429460, 1.6589000),
    433: (0.3422430, 0.0451140, 1.7082000),
    434: (0.3503120, 0.0473330, 1.7548000),
    435: (0.3577190, 0.0496020, 1.7985000),
    436: (0.3644820, 0.0519340, 1.8392000),
    437: (0.3704930, 0.0543370, 1.8766000),
    438: (0.3757270, 0.0568220, 1.9105000),
    439: (0.3801580, 0.0593990, 1.9408000),
    440: (0.3837340, 0.0620770, 1.9672800),
    441: (0.3863270, 0.0647370, 1.9891000),
    442: (0.3878580, 0.0672850, 2.0057000),
    443: (0.3883960, 0.0697640, 2.0174000),
    444: (0.3879780, 0.0722180, 2.0244000),
    445: (0.3867260, 0.0747040, 2.0273000),
    446: (0.3846960, 0.0772720, 2.0264000),
    447: (0.3820060, 0.0799790, 2.0223000),
    448: (0.3787090, 0.0828740, 2.0153000),
    449: (0.3749150, 0.0860000, 2.0060000),
    450: (0.3707020, 0.0894560, 1.9948000),
    451: (0.3660890, 0.0929470, 1.9814000),
    452: (0.3610450, 0.0962750, 1.9653000),
    453: (0.3555180, 0.0995350, 1.9464000),
    454: (0.3494860, 0.1028290, 1.9248000),
    455: (0.3429570, 0.1062560, 1.9007000),
    456: (0.3358930, 0.1099010, 1.8741000),
    457: (0.3282840, 0.1138350, 1.8451000),
    458: (0.3201500, 0.1181670, 1.8139000),
    459: (0.3114750, 0.1229320, 1.7806000),
    460: (0.3022730, 0.1282010, 1.7453700),
    461: (0.2928580, 0.1334570, 1.7091000),
    462: (0.2835020, 0.1383230, 1.6723000),
    463: (0.2740440, 0.1430420, 1.6347000),
    464: (0.2642630, 0.1477870, 1.5956000),
    465: (0.2540850, 0.1527610, 1.5549000),
    466: (0.2433920, 0.1581020, 1.5122000),
    467: (0.2321870, 0.1639410, 1.4673000),
    468: (0.2204880, 0.1703620, 1.4199000),
    469: (0.2081980, 0.1774250, 1.3700000),
    470: (0.1956180, 0.1851900, 1.3175600),
    471: (0.1830340, 0.1930250, 1.2624000),
    472: (0.1702220, 0.2003130, 1.2050000),
    473: (0.1573480, 0.2071560, 1.1466000),
    474: (0.1446500, 0.2136440, 1.0880000),
    475: (0.1323490, 0.2199400, 1.0302000),
    476: (0.1205840, 0.2261700, 0.9738300),
    477: (0.1094560, 0.2324670, 0.9194300),
    478: (0.0990420, 0.2390250, 0.8674600),
    479: (0.0893880, 0.2459970, 0.8182800),
    480: (0.0805070, 0.2535890, 0.7721250),
    481: (0.0720340, 0.2618760, 0.7282900),
    482: (0.0637100, 0.2706430, 0.6860400),
    483: (0.0556940, 0.2796450, 0.6455300),
    484: (0.0481170, 0.2886940, 0.6068500),
    485: (0.0410720, 0.2976650, 0.5700600),
    486: (0.0346420, 0.3064690, 0.5352200),
    487: (0.0288960, 0.3150350, 0.5023400),
    488: (0.0238760, 0.3233350, 0.4714000),
    489: (0.0196280, 0.3313660, 0.4423900),
    490: (0.0161720, 0.3391330, 0.4152540),
    491: (0.0133000, 0.3478600, 0.3900240),
    492: (0.0107590, 0.3583260, 0.3663990),
    493: (0.0085420, 0.3700010, 0.3440150),
    494: (0.0066610, 0.3824640, 0.3226890),
    495: (0.0051320, 0.3953790, 0.3023560),
    496: (0.0039820, 0.4084820, 0.2830360),
    497: (0.0032390, 0.4215880, 0.2648160),
    498: (0.0029340, 0.4346190, 0.2478480),
    499: (0.0031140, 0.4476010, 0.2323180),
    500: (0.0038160, 0.4607770, 0.2185020),
    501: (0.0050950, 0.4743400, 0.2058510),
    502: (0.0069360, 0.4882000, 0.1935960),
    503: (0.0092990, 0.5023400, 0.1817360),
    504: (0.0121470, 0.5167400, 0.1702810),
    505: (0.0154440, 0.5313600, 0.1592490),
    506: (0.0191560, 0.5461900, 0.1486730),
    507: (0.0232500, 0.5611800, 0.1386090),
    508: (0.0276900, 0.5762900, 0.1290960),
    509: (0.0324440, 0.5915000, 0.1202150),
    510: (0.0374650, 0.6067410, 0.1120440),
    511: (0.0429560, 0.6221500, 0.1047100),
    512: (0.0491140, 0.6378300, 0.0981960),
    513: (0.0559200, 0.6537100, 0.0923610),
    514: (0.0633490, 0.6696800, 0.0870880),
    515: (0.0713580, 0.6856600, 0.0822480),
    516: (0.0799010, 0.7015500, 0.0777440),
    517: (0.0889090, 0.7172300, 0.0734560),
    518: (0.0982930, 0.7325700, 0.0692680),
    519: (0.1079490, 0.7474600, 0.0650600),
    520: (0.1177490, 0.7617570, 0.0607090),
    521: (0.1278390, 0.7753400, 0.0564570),
    522: (0.1384500, 0.7882200, 0.0526090),
    523: (0.1495160, 0.8004600, 0.0491220),
    524: (0.1610410, 0.8121400, 0.0459540),
    525: (0.1729530, 0.8233300, 0.0430500),
    526: (0.1852090, 0.8341200, 0.0403680),
    527: (0.1977550, 0.8446000, 0.0378390),
    528: (0.2105380, 0.8548700, 0.0353840),
    529: (0.2234600, 0.8650400, 0.0329490),
    530: (0.2364910, 0.8752110, 0.0304510),
    531: (0.2496330, 0.8853700, 0.0280290),
    532: (0.2629720, 0.8953700, 0.0258620),
    533: (0.2765150, 0.9051500, 0.0239200),
    534: (0.2902690, 0.9146500, 0.0221740),
    535: (0.3042130, 0.9238100, 0.0205840),
    536: (0.3183610, 0.9325500, 0.0191270),
    537: (0.3327050, 0.9408100, 0.0177400),
    538: (0.3472320, 0.9485200, 0.0164030),
    539: (0.3619260, 0.9556000, 0.0150640),
    540: (0.3767720, 0.9619880, 0.0136760),
    541: (0.3916830, 0.9675400, 0.0123080),
    542: (0.4065940, 0.9722300, 0.0110560),
    543: (0.4215390, 0.9761700, 0.0099150),
    544: (0.4365170, 0.9794600, 0.0088720),
    545: (0.4515840, 0.9822000, 0.0079180),
    546: (0.4667820, 0.9845200, 0.0070300),
    547: (0.4821470, 0.9865200, 0.0062230),
    548: (0.4977380, 0.9883200, 0.0054530),
    549: (0.5136060, 0.9900200, 0.0047140),
    550: (0.5298260, 0.9917610, 0.0039880),
    551: (0.5464400, 0.9935300, 0.0032890),
    552: (0.5634260, 0.9952300, 0.0026460),
    553: (0.5807260, 0.9967700, 0.0020630),
    554: (0.5982900, 0.9980900, 0.0015330),
    555: (0.6160530, 0.9991100, 0.0010910),
    556: (0.6339480, 0.9997700, 0.0007110),
    557: (0.6519010, 1.0000000, 0.0004070),
    558: (0.6698240, 0.9997100, 0.0001840),
    559: (0.6876320, 0.9988500, 0.0000470),
    560: (0.7052240, 0.9973400, 0.0000000),
    561: (0.7227730, 0.9952600, 0.0000000),
    562: (0.7404830, 0.9927400, 0.0000000),
    563: (0.7582730, 0.9897500, 0.0000000),
    564: (0.7760830, 0.9863000, 0.0000000),
    565: (0.7938320, 0.9823800, 0.0000000),
    566: (0.8114360, 0.9779800, 0.0000000),
    567: (0.8288220, 0.9731100, 0.0000000),
    568: (0.8458790, 0.9677400, 0.0000000),
    569: (0.8625250, 0.9618900, 0.0000000),
    570: (0.8786550, 0.9555520, 0.0000000),
    571: (0.8942080, 0.9486010, 0.0000000),
    572: (0.9092060, 0.9409810, 0.0000000),
    573: (0.9236720, 0.9327980, 0.0000000),
    574: (0.9376380, 0.9241580, 0.0000000),
    575: (0.9511620, 0.9151750, 0.0000000),
    576: (0.9642830, 0.9059540, 0.0000000),
    577: (0.9770680, 0.8966080, 0.0000000),
    578: (0.9895900, 0.8872490, 0.0000000),
    579: (1.0019100, 0.8779860, 0.0000000),
    580: (1.0141600, 0.8689340, 0.0000000),
    581: (1.0265000, 0.8601640, 0.0000000),
    582: (1.0388000, 0.8515190, 0.0000000),
    583: (1.0510000, 0.8429630, 0.0000000),
    584: (1.0629000, 0.8343930, 0.0000000),
    585: (1.0743000, 0.8256230, 0.0000000),
    586: (1.0852000, 0.8167640, 0.0000000),
    587: (1.0952000, 0.8075440, 0.0000000),
    588: (1.1042000, 0.7979470, 0.0000000),
    589: (1.1120000, 0.7878930, 0.0000000),
    590: (1.1185200, 0.7774050, 0.0000000),
    591: (1.1238000, 0.7664900, 0.0000000),
    592: (1.1280000, 0.7553090, 0.0000000),
    593: (1.1311000, 0.7438450, 0.0000000),
    594: (1.1332000, 0.7321900, 0.0000000),
    595: (1.1343000, 0.7203530, 0.0000000),
    596: (1.1343000, 0.7082810, 0.0000000),
    597: (1.1333000, 0.6960550, 0.0000000),
    598: (1.1312000, 0.6836210, 0.0000000),
    599: (1.1281000, 0.6710480, 0.0000000),
    600: (1.1239900, 0.6583410, 0.0000000),
    601: (1.1189000, 0.6455450, 0.0000000),
    602: (1.1129000, 0.6327180, 0.0000000),
    603: (1.1059000, 0.6198150, 0.0000000),
    604: (1.0980000, 0.6068870, 0.0000000),
    605: (1.0891000, 0.5938780, 0.0000000),
    606: (1.0792000, 0.5807810, 0.0000000),
    607: (1.0684000, 0.5676530, 0.0000000),
    608: (1.0567000, 0.5544900, 0.0000000),
    609: (1.0440000, 0.5412280, 0.0000000),
    610: (1.0304800, 0.5279630, 0.0000000),
    611: (1.0160000, 0.5146340, 0.0000000),
    612: (1.0008000, 0.5013630, 0.0000000),
    613: (0.9847900, 0.4881240, 0.0000000),
    614: (0.9680800, 0.4749350, 0.0000000),
    615: (0.9507400, 0.4618340, 0.0000000),
    616: (0.9328000, 0.4488230, 0.0000000),
    617: (0.9143400, 0.4359170, 0.0000000),
    618: (0.8953900, 0.4231530, 0.0000000),
    619: (0.8760300, 0.4105260, 0.0000000),
    620: (0.8562970, 0.3980570, 0.0000000),
    621: (0.8363500, 0.3858350, 0.0000000),
    622: (0.8162900, 0.3739510, 0.0000000),
    623: (0.7960500, 0.3623110, 0.0000000),
    624: (0.7756100, 0.3508630, 0.0000000),
    625: (0.7549300, 0.3395540, 0.0000000),
    626: (0.7339900, 0.3283090, 0.0000000),
    627: (0.7127800, 0.3171180, 0.0000000),
    628: (0.6912900, 0.3059360, 0.0000000),
    629: (0.6695200, 0.2947370, 0.0000000),
    630: (0.6474670, 0.2834930, 0.0000000),
    631: (0.6251100, 0.2722220, 0.0000000),
    632: (0.6025200, 0.2609900, 0.0000000),
    633: (0.5798900, 0.2498770, 0.0000000),
    634: (0.5573700, 0.2389460, 0.0000000),
    635: (0.5351100, 0.2282540, 0.0000000),
    636: (0.5132400, 0.2178530, 0.0000000),
    637: (0.4918600, 0.2077800, 0.0000000),
    638: (0.4710800, 0.1980720, 0.0000000),
    639: (0.4509600, 0.1887480, 0.0000000),
    640: (0.4315670, 0.1798280, 0.0000000),
    641: (0.4128700, 0.1712850, 0.0000000),
    642: (0.3947500, 0.1630590, 0.0000000),
    643: (0.3772100, 0.1551510, 0.0000000),
    644: (0.3601900, 0.1475350, 0.0000000),
    645: (0.3436900, 0.1402110, 0.0000000),
    646: (0.3276900, 0.1331700, 0.0000000),
    647: (0.3121700, 0.1264000, 0.0000000),
    648: (0.2971100, 0.1198920, 0.0000000),
    649: (0.2825000, 0.1136400, 0.0000000),
    650: (0.2683290, 0.1076330, 0.0000000),
    651: (0.2545900, 0.1018700, 0.0000000),
    652: (0.2413000, 0.0963470, 0.0000000),
    653: (0.2284800, 0.0910630, 0.0000000),
    654: (0.2161400, 0.0860100, 0.0000000),
    655: (0.2043000, 0.0811870, 0.0000000),
    656: (0.1929500, 0.0765830, 0.0000000),
    657: (0.1821100, 0.0721980, 0.0000000),
    658: (0.1717700, 0.0680240, 0.0000000),
    659: (0.1619200, 0.0640520, 0.0000000),
    660: (0.1525680, 0.0602810, 0.0000000),
    661: (0.1436700, 0.0566970, 0.0000000),
    662: (0.1352000, 0.0532920, 0.0000000),
    663: (0.1271300, 0.0500590, 0.0000000),
    664: (0.1194800, 0.0469980, 0.0000000),
    665: (0.1122100, 0.0440960, 0.0000000),
    666: (0.1053100, 0.0413450, 0.0000000),
    667: (0.0987860, 0.0387507, 0.0000000),
    668: (0.0926100, 0.0362978, 0.0000000),
    669: (0.0867730, 0.0339832, 0.0000000),
    670: (0.0812606, 0.0318004, 0.0000000),
    671: (0.0760480, 0.0297395, 0.0000000),
    672: (0.0711140, 0.0277918, 0.0000000),
    673: (0.0664540, 0.0259551, 0.0000000),
    674: (0.0620620, 0.0242263, 0.0000000),
    675: (0.0579300, 0.0226017, 0.0000000),
    676: (0.0540500, 0.0210779, 0.0000000),
    677: (0.0504120, 0.0196505, 0.0000000),
    678: (0.0470060, 0.0183153, 0.0000000),
    679: (0.0438230, 0.0170686, 0.0000000),
    680: (0.0408508, 0.0159051, 0.0000000),
    681: (0.0380720, 0.0148183, 0.0000000),
    682: (0.0354680, 0.0138008, 0.0000000),
    683: (0.0330310, 0.0128495, 0.0000000),
    684: (0.0307530, 0.0119607, 0.0000000),
    685: (0.0286230, 0.0111303, 0.0000000),
    686: (0.0266350, 0.0103555, 0.0000000),
    687: (0.0247810, 0.0096332, 0.0000000),
    688: (0.0230520, 0.0089599, 0.0000000),
    689: (0.0214410, 0.0083324, 0.0000000),
    690: (0.0199413, 0.0077488, 0.0000000),
    691: (0.0185440, 0.0072046, 0.0000000),
    692: (0.0172410, 0.0066975, 0.0000000),
    693: (0.0160270, 0.0062251, 0.0000000),
    694: (0.0148960, 0.0057850, 0.0000000),
    695: (0.0138420, 0.0053751, 0.0000000),
    696: (0.0128620, 0.0049941, 0.0000000),
    697: (0.0119490, 0.0046392, 0.0000000),
    698: (0.0111000, 0.0043093, 0.0000000),
    699: (0.0103110, 0.0040028, 0.0000000),
    700: (0.00957688, 0.00371774, 0.0000000),
    701: (0.0088940, 0.00345262, 0.0000000),
    702: (0.0082581, 0.00320583, 0.0000000),
    703: (0.0076664, 0.00297623, 0.0000000),
    704: (0.0071163, 0.00276281, 0.0000000),
    705: (0.0066052, 0.00256456, 0.0000000),
    706: (0.0061306, 0.00238048, 0.0000000),
    707: (0.0056903, 0.00220971, 0.0000000),
    708: (0.0052819, 0.00205132, 0.0000000),
    709: (0.0049033, 0.00190449, 0.0000000),
    710: (0.00455263, 0.00176847, 0.0000000),
    711: (0.0042275, 0.00164236, 0.0000000),
    712: (0.0039258, 0.00152535, 0.0000000),
    713: (0.0036457, 0.00141672, 0.0000000),
    714: (0.0033859, 0.00131595, 0.0000000),
    715: (0.0031447, 0.00122239, 0.0000000),
    716: (0.0029208, 0.00113555, 0.0000000),
    717: (0.0027130, 0.00105494, 0.0000000),
    718: (0.0025202, 0.00098014, 0.0000000),
    719: (0.0023411, 0.00091066, 0.0000000),
    720: (0.00217496, 0.00084619, 0.0000000),
    721: (0.0020206, 0.00078629, 0.0000000),
    722: (0.0018773, 0.00073068, 0.0000000),
    723: (0.0017441, 0.00067899, 0.0000000),
    724: (0.0016205, 0.00063101, 0.0000000),
    725: (0.0015057, 0.00058644, 0.0000000),
    726: (0.0013992, 0.00054511, 0.0000000),
    727: (0.0013004, 0.00050672, 0.0000000),
    728: (0.0012087, 0.00047111, 0.0000000),
    729: (0.0011236, 0.00043805, 0.0000000),
    730: (0.00104476, 0.00040741, 0.0000000),
    731: (0.00097156, 0.000378962, 0.0000000),
    732: (0.0009036, 0.000352543, 0.0000000),
    733: (0.00084048, 0.000328001, 0.0000000),
    734: (0.00078187, 0.000305208, 0.0000000),
    735: (0.00072745, 0.000284041, 0.0000000),
    736: (0.0006769, 0.000264375, 0.0000000),
    737: (0.00062996, 0.000246109, 0.0000000),
    738: (0.00058637, 0.000229143, 0.0000000),
    739: (0.00054587, 0.000213376, 0.0000000),
    740: (0.000508258, 0.00019873, 0.0000000),
    741: (0.0004733, 0.000185115, 0.0000000),
    742: (0.0004408, 0.000172454, 0.0000000),
    743: (0.00041058, 0.000160678, 0.0000000),
    744: (0.00038249, 0.00014973, 0.0000000),
    745: (0.00035638, 0.00013955, 0.0000000),
    746: (0.00033211, 0.000130086, 0.0000000),
    747: (0.00030955, 0.00012129, 0.0000000),
    748: (0.00028858, 0.000113106, 0.0000000),
    749: (0.00026909, 0.000105501, 0.0000000),
    750: (0.000250969, 0.000098428, 0.0000000),
    751: (0.00023413, 0.000091853, 0.0000000),
    752: (0.00021847, 0.000085738, 0.0000000),
    753: (0.00020391, 0.000080048, 0.0000000),
    754: (0.00019035, 0.000074751, 0.0000000),
    755: (0.00017773, 0.000069819, 0.0000000),
    756: (0.00016597, 0.000065222, 0.0000000),
    757: (0.00015502, 0.000060939, 0.0000000),
    758: (0.0001448, 0.000056942, 0.0000000),
    759: (0.00013528, 0.000053217, 0.0000000),
    760: (0.00012639, 0.000049737, 0.0000000),
    761: (0.0001181, 0.000046491, 0.0000000),
    762: (0.00011037, 0.000043464, 0.0000000),
    763: (0.00010315, 0.000040635, 0.0000000),
    764: (0.000096427, 0.0000380, 0.0000000),
    765: (0.000090151, 0.0000355405, 0.0000000),
    766: (0.000084294, 0.0000332448, 0.0000000),
    767: (0.00007883, 0.0000311006, 0.0000000),
    768: (0.000073729, 0.000029099, 0.0000000),
    769: (0.000068969, 0.0000272307, 0.0000000),
    770: (0.0000645258, 0.000025486, 0.0000000),
    771: (0.000060376, 0.0000238561, 0.0000000),
    772: (0.0000565, 0.0000223332, 0.0000000),
    773: (0.00005288, 0.0000209104, 0.0000000),
    774: (0.000049498, 0.0000195808, 0.0000000),
    775: (0.000046339, 0.0000183384, 0.0000000),
    776: (0.000043389, 0.0000171777, 0.0000000),
    777: (0.000040634, 0.0000160934, 0.0000000),
    778: (0.00003806, 0.00001508, 0.0000000),
    779: (0.000035657, 0.0000141336, 0.0000000),
    780: (0.0000334117, 0.000013249, 0.0000000),
    781: (0.000031315, 0.0000124226, 0.0000000),
    782: (0.000029355, 0.0000116499, 0.0000000),
    783: (0.000027524, 0.0000109277, 0.0000000),
    784: (0.000025811, 0.0000102519, 0.0000000),
    785: (0.000024209, 0.0000096196, 0.0000000),
    786: (0.000022711, 0.0000090281, 0.0000000),
    787: (0.000021308, 0.000008474, 0.0000000),
    788: (0.000019994, 0.0000079548, 0.0000000),
    789: (0.000018764, 0.0000074686, 0.0000000),
    790: (0.0000176115, 0.0000070128, 0.0000000),
    791: (0.000016532, 0.0000065858, 0.0000000),
    792: (0.000015521, 0.0000061857, 0.0000000),
    793: (0.000014574, 0.0000058107, 0.0000000),
    794: (0.000013686, 0.000005459, 0.0000000),
    795: (0.000012855, 0.0000051298, 0.0000000),
    796: (0.000012075, 0.0000048206, 0.0000000),
    797: (0.000011345, 0.0000045312, 0.0000000),
    798: (0.000010659, 0.0000042591, 0.0000000),
    799: (0.000010017, 0.0000040042, 0.0000000),
    800: (0.00000941363, 0.00000376473, 0.0000000),
    801: (0.0000088479, 0.00000353995, 0.0000000),
    802: (0.0000083171, 0.00000332914, 0.0000000),
    803: (0.000007819, 0.00000313115, 0.0000000),
    804: (0.0000073516, 0.00000294529, 0.0000000),
    805: (0.000006913, 0.00000277081, 0.0000000),
    806: (0.0000065015, 0.00000260705, 0.0000000),
    807: (0.0000061153, 0.00000245329, 0.0000000),
    808: (0.0000057529, 0.00000230894, 0.0000000),
    809: (0.0000054127, 0.00000217338, 0.0000000),
    810: (0.00000509347, 0.00000204613, 0.0000000),
    811: (0.0000047938, 0.00000192662, 0.0000000),
    812: (0.0000045125, 0.0000018144, 0.0000000),
    813: (0.0000042483, 0.00000170895, 0.0000000),
    814: (0.0000040002, 0.00000160988, 0.0000000),
    815: (0.0000037671, 0.00000151677, 0.0000000),
    816: (0.000003548, 0.00000142921, 0.0000000),
    817: (0.0000033421, 0.00000134686, 0.0000000),
    818: (0.0000031485, 0.00000126945, 0.0000000),
    819: (0.0000029665, 0.00000119662, 0.0000000),
    820: (0.00000279531, 0.00000112809, 0.0000000),
    821: (0.0000026345, 0.00000106368, 0.0000000),
    822: (0.0000024834, 0.00000100313, 0.0000000),
    823: (0.0000023414, 0.00000094622, 0.0000000),
    824: (0.0000022078, 0.00000089263, 0.0000000),
    825: (0.000002082, 0.00000084216, 0.0000000),
    826: (0.0000019636, 0.00000079464, 0.0000000),
    827: (0.0000018519, 0.00000074978, 0.0000000),
    828: (0.0000017465, 0.00000070744, 0.0000000),
    829: (0.0000016471, 0.00000066748, 0.0000000),
    830: (0.00000155314, 0.0000006297, 0.0000000),
}

CIE_MLNP = {
    360: 0,
    361: 0,
    362: 0,
    363: 0,
    364: 0,
    365: 0,
    366: 0,
    367: 0,
    368: 0,
    369: 0,
    370: 0,
    371: 0,
    372: 0,
    373: 0,
    374: 0,
    375: 0,
    376: 0,
    377: 0,
    378: 0,
    379: 0,
    380: 9.18165e-04,
    381: 1.04557e-03,
    382: 1.17858e-03,
    383: 1.32279e-03,
    384: 1.48381e-03,
    385: 1.66724e-03,
    386: 1.88102e-03,
    387: 2.12989e-03,
    388: 2.41457e-03,
    389: 2.73583e-03,
    390: 3.09442e-03,
    391: 3.50706e-03,
    392: 3.99078e-03,
    393: 4.54679e-03,
    394: 5.17625e-03,
    395: 5.88035e-03,
    396: 6.69334e-03,
    397: 7.65102e-03,
    398: 8.75694e-03,
    399: 1.00146e-02,
    400: 1.14277e-02,
    401: 1.30767e-02,
    402: 1.50397e-02,
    403: 1.73166e-02,
    404: 1.99071e-02,
    405: 2.28112e-02,
    406: 2.63194e-02,
    407: 3.05964e-02,
    408: 3.54538e-02,
    409: 4.07028e-02,
    410: 4.61550e-02,
    411: 5.17822e-02,
    412: 5.77804e-02,
    413: 6.42972e-02,
    414: 7.14801e-02,
    415: 7.94766e-02,
    416: 8.91807e-02,
    417: 1.00756e-01,
    418: 1.13256e-01,
    419: 1.25732e-01,
    420: 1.37237e-01,
    421: 1.47446e-01,
    422: 1.57014e-01,
    423: 1.66463e-01,
    424: 1.76316e-01,
    425: 1.87096e-01,
    426: 1.99210e-01,
    427: 2.12408e-01,
    428: 2.26225e-01,
    429: 2.40199e-01,
    430: 2.53865e-01,
    431: 2.67021e-01,
    432: 2.79976e-01,
    433: 2.93034e-01,
    434: 3.06500e-01,
    435: 3.20679e-01,
    436: 3.36016e-01,
    437: 3.52361e-01,
    438: 3.69128e-01,
    439: 3.85732e-01,
    440: 4.01587e-01,
    441: 4.16472e-01,
    442: 4.30797e-01,
    443: 4.44921e-01,
    444: 4.59203e-01,
    445: 4.74002e-01,
    446: 4.89517e-01,
    447: 5.05522e-01,
    448: 5.21741e-01,
    449: 5.37898e-01,
    450: 5.53715e-01,
    451: 5.69100e-01,
    452: 5.84240e-01,
    453: 5.99281e-01,
    454: 6.14370e-01,
    455: 6.29654e-01,
    456: 6.45193e-01,
    457: 6.60892e-01,
    458: 6.76660e-01,
    459: 6.92409e-01,
    460: 7.08049e-01,
    461: 7.23594e-01,
    462: 7.39105e-01,
    463: 7.54560e-01,
    464: 7.69938e-01,
    465: 7.85216e-01,
    466: 8.00683e-01,
    467: 8.16354e-01,
    468: 8.31798e-01,
    469: 8.46587e-01,
    470: 8.60291e-01,
    471: 8.72925e-01,
    472: 8.84870e-01,
    473: 8.96242e-01,
    474: 9.07158e-01,
    475: 9.17734e-01,
    476: 9.28345e-01,
    477: 9.38950e-01,
    478: 9.49035e-01,
    479: 9.58091e-01,
    480: 9.65605e-01,
    481: 9.71976e-01,
    482: 9.77833e-01,
    483: 9.83006e-01,
    484: 9.87325e-01,
    485: 9.90621e-01,
    486: 9.93343e-01,
    487: 9.95887e-01,
    488: 9.98008e-01,
    489: 9.99461e-01,
    490: 1.00000e00,
    491: 9.99561e-01,
    492: 9.98365e-01,
    493: 9.96590e-01,
    494: 9.94416e-01,
    495: 9.92022e-01,
    496: 9.88792e-01,
    497: 9.84220e-01,
    498: 9.78657e-01,
    499: 9.72451e-01,
    500: 9.65952e-01,
    501: 9.58844e-01,
    502: 9.50716e-01,
    503: 9.41778e-01,
    504: 9.32236e-01,
    505: 9.22299e-01,
    506: 9.11832e-01,
    507: 9.00602e-01,
    508: 8.88663e-01,
    509: 8.76073e-01,
    510: 8.62888e-01,
    511: 8.48801e-01,
    512: 8.33678e-01,
    513: 8.17832e-01,
    514: 8.01579e-01,
    515: 7.85233e-01,
    516: 7.68718e-01,
    517: 7.51807e-01,
    518: 7.34593e-01,
    519: 7.17169e-01,
    520: 6.99628e-01,
    521: 6.81888e-01,
    522: 6.63881e-01,
    523: 6.45724e-01,
    524: 6.27533e-01,
    525: 6.09422e-01,
    526: 5.91339e-01,
    527: 5.73207e-01,
    528: 5.55105e-01,
    529: 5.37112e-01,
    530: 5.19309e-01,
    531: 5.01645e-01,
    532: 4.84067e-01,
    533: 4.66643e-01,
    534: 4.49442e-01,
    535: 4.32533e-01,
    536: 4.15862e-01,
    537: 3.99372e-01,
    538: 3.83136e-01,
    539: 3.67224e-01,
    540: 3.51707e-01,
    541: 3.36537e-01,
    542: 3.21647e-01,
    543: 3.07085e-01,
    544: 2.92899e-01,
    545: 2.79135e-01,
    546: 2.65737e-01,
    547: 2.52648e-01,
    548: 2.39917e-01,
    549: 2.27592e-01,
    550: 2.15722e-01,
    551: 2.04238e-01,
    552: 1.93075e-01,
    553: 1.82288e-01,
    554: 1.71930e-01,
    555: 1.62056e-01,
    556: 1.52601e-01,
    557: 1.43487e-01,
    558: 1.34748e-01,
    559: 1.26416e-01,
    560: 1.18526e-01,
    561: 1.11007e-01,
    562: 1.03793e-01,
    563: 9.69206e-02,
    564: 9.04259e-02,
    565: 8.43457e-02,
    566: 7.86198e-02,
    567: 7.31750e-02,
    568: 6.80288e-02,
    569: 6.31984e-02,
    570: 5.87013e-02,
    571: 5.44832e-02,
    572: 5.04889e-02,
    573: 4.67344e-02,
    574: 4.32357e-02,
    575: 4.00089e-02,
    576: 3.70102e-02,
    577: 3.41903e-02,
    578: 3.15562e-02,
    579: 2.91153e-02,
    580: 2.68747e-02,
    581: 2.48014e-02,
    582: 2.28597e-02,
    583: 2.10534e-02,
    584: 1.93864e-02,
    585: 1.78624e-02,
    586: 1.64578e-02,
    587: 1.51470e-02,
    588: 1.39314e-02,
    589: 1.28120e-02,
    590: 1.17901e-02,
    591: 1.08488e-02,
    592: 9.97112e-03,
    593: 9.15850e-03,
    594: 8.41242e-03,
    595: 7.73430e-03,
    596: 7.11255e-03,
    597: 6.53476e-03,
    598: 6.00110e-03,
    599: 5.51174e-03,
    600: 5.06686e-03,
    601: 4.65869e-03,
    602: 4.27946e-03,
    603: 3.92939e-03,
    604: 3.60872e-03,
    605: 3.31766e-03,
    606: 3.05109e-03,
    607: 2.80374e-03,
    608: 2.57560e-03,
    609: 2.36668e-03,
    610: 2.17698e-03,
    611: 2.00317e-03,
    612: 1.84190e-03,
    613: 1.69317e-03,
    614: 1.55692e-03,
    615: 1.43314e-03,
    616: 1.31972e-03,
    617: 1.21451e-03,
    618: 1.11743e-03,
    619: 1.02839e-03,
    620: 9.47313e-04,
    621: 8.72814e-04,
    622: 8.03576e-04,
    623: 7.39620e-04,
    624: 6.80970e-04,
    625: 6.27648e-04,
    626: 5.78753e-04,
    627: 5.33358e-04,
    628: 4.91440e-04,
    629: 4.52980e-04,
    630: 4.17955e-04,
    631: 3.85789e-04,
    632: 3.55905e-04,
    633: 3.28289e-04,
    634: 3.02926e-04,
    635: 2.79801e-04,
    636: 2.58544e-04,
    637: 2.38785e-04,
    638: 2.20508e-04,
    639: 2.03699e-04,
    640: 1.88341e-04,
    641: 1.74192e-04,
    642: 1.61020e-04,
    643: 1.48821e-04,
    644: 1.37594e-04,
    645: 1.27337e-04,
    646: 1.17891e-04,
    647: 1.09096e-04,
    648: 1.00949e-04,
    649: 9.34437e-05,
    650: 8.65751e-05,
    651: 8.02405e-05,
    652: 7.43383e-05,
    653: 6.88650e-05,
    654: 6.38172e-05,
    655: 5.91914e-05,
    656: 5.49203e-05,
    657: 5.09374e-05,
    658: 4.72404e-05,
    659: 4.38269e-05,
    660: 4.06945e-05,
    661: 3.77990e-05,
    662: 3.50966e-05,
    663: 3.25857e-05,
    664: 3.02647e-05,
    665: 2.81320e-05,
    666: 2.61587e-05,
    667: 2.43158e-05,
    668: 2.26017e-05,
    669: 2.10148e-05,
    670: 1.95535e-05,
    671: 1.81982e-05,
    672: 1.69302e-05,
    673: 1.57493e-05,
    674: 1.46553e-05,
    675: 1.36480e-05,
    676: 1.27143e-05,
    677: 1.18407e-05,
    678: 1.10269e-05,
    679: 1.02723e-05,
    680: 9.57637e-06,
    681: 8.93033e-06,
    682: 8.32543e-06,
    683: 7.76135e-06,
    684: 7.23773e-06,
    685: 6.75425e-06,
    686: 6.30499e-06,
    687: 5.88407e-06,
    688: 5.49115e-06,
    689: 5.12592e-06,
    690: 4.78804e-06,
    691: 4.47347e-06,
    692: 4.17829e-06,
    693: 3.90243e-06,
    694: 3.64583e-06,
    695: 3.40841e-06,
    696: 3.18739e-06,
    697: 2.97998e-06,
    698: 2.78604e-06,
    699: 2.60548e-06,
    700: 2.43819e-06,
    701: 2.28225e-06,
    702: 2.13580e-06,
    703: 1.99874e-06,
    704: 1.87101e-06,
    705: 1.75252e-06,
    706: 1.64197e-06,
    707: 1.53806e-06,
    708: 1.44073e-06,
    709: 1.34993e-06,
    710: 1.26560e-06,
    711: 1.18683e-06,
    712: 1.11273e-06,
    713: 1.04326e-06,
    714: 9.78385e-07,
    715: 9.18078e-07,
    716: 8.61705e-07,
    717: 8.08640e-07,
    718: 7.58853e-07,
    719: 7.12313e-07,
    720: 6.68991e-07,
    721: 6.28444e-07,
    722: 5.90239e-07,
    723: 5.54363e-07,
    724: 5.20798e-07,
    725: 4.89531e-07,
    726: 4.60251e-07,
    727: 4.32648e-07,
    728: 4.06710e-07,
    729: 3.82420e-07,
    730: 3.59766e-07,
    731: 3.38528e-07,
    732: 3.18490e-07,
    733: 2.99644e-07,
    734: 2.81981e-07,
    735: 2.65493e-07,
    736: 2.50026e-07,
    737: 2.35424e-07,
    738: 2.21681e-07,
    739: 2.08789e-07,
    740: 1.96740e-07,
    741: 1.85426e-07,
    742: 1.74736e-07,
    743: 1.64666e-07,
    744: 1.55212e-07,
    745: 1.46370e-07,
    746: 1.38062e-07,
    747: 1.30208e-07,
    748: 1.22805e-07,
    749: 1.15848e-07,
    750: 1.09332e-07,
    751: 1.03202e-07,
    752: 9.74005e-08,
    753: 9.19274e-08,
    754: 8.67807e-08,
    755: 8.19587e-08,
    756: 7.74202e-08,
    757: 7.31243e-08,
    758: 6.90693e-08,
    759: 6.52534e-08,
    760: 6.16749e-08,
    761: 5.83044e-08,
    762: 5.51124e-08,
    763: 5.20972e-08,
    764: 4.92575e-08,
    765: 4.65916e-08,
    766: 4.40782e-08,
    767: 4.16962e-08,
    768: 3.94444e-08,
    769: 3.73218e-08,
    770: 3.53272e-08,
    771: 3.34451e-08,
    772: 3.16600e-08,
    773: 2.99712e-08,
    774: 2.83782e-08,
    775: 2.68803e-08,
    776: 2.54800e-08,
    777: 2.41660e-08,
    778: 2.29167e-08,
    779: 2.17105e-08,
    780: 2.05258e-08,
    781: 0.00000e00,
    782: 0.00000e00,
    783: 0.00000e00,
    784: 0.00000e00,
    785: 0.00000e00,
    786: 0.00000e00,
    787: 0.00000e00,
    788: 0.00000e00,
    789: 0.00000e00,
    790: 0.00000e00,
    791: 0.00000e00,
    792: 0.00000e00,
    793: 0.00000e00,
    794: 0.00000e00,
    795: 0.00000e00,
    796: 0.00000e00,
    797: 0.00000e00,
    798: 0.00000e00,
    799: 0.00000e00,
    800: 0.00000e00,
    801: 0.00000e00,
    802: 0.00000e00,
    803: 0.00000e00,
    804: 0.00000e00,
    805: 0.00000e00,
    806: 0.00000e00,
    807: 0.00000e00,
    808: 0.00000e00,
    809: 0.00000e00,
    810: 0.00000e00,
    811: 0.00000e00,
    812: 0.00000e00,
    813: 0.00000e00,
    814: 0.00000e00,
    815: 0.00000e00,
    816: 0.00000e00,
    817: 0.00000e00,
    818: 0.00000e00,
    819: 0.00000e00,
    820: 0.00000e00,
    821: 0.00000e00,
    822: 0.00000e00,
    823: 0.00000e00,
    824: 0.00000e00,
    825: 0.00000e00,
    826: 0.00000e00,
    827: 0.00000e00,
    828: 0.00000e00,
    829: 0.00000e00,
    830: 0.00000e00,
}

CIE_S012 = {
    300: (0.04, 0.02, 0),
    305: (3.02, 2.26, 1),
    310: (6, 4.5, 2),
    315: (17.8, 13.45, 3),
    320: (29.6, 22.4, 4),
    325: (42.45, 32.2, 6.25),
    330: (55.3, 42, 8.5),
    335: (56.3, 41.3, 8.15),
    340: (57.3, 40.6, 7.8),
    345: (59.55, 41.1, 7.25),
    350: (61.8, 41.6, 6.7),
    355: (61.65, 39.8, 6),
    360: (61.5, 38, 5.3),
    365: (65.15, 40.2, 5.7),
    370: (68.8, 42.4, 6.1),
    375: (66.1, 40.45, 4.55),
    380: (63.4, 38.5, 3),
    385: (64.6, 36.75, 2.1),
    390: (65.8, 35, 1.2),
    395: (80.3, 39.2, 0.05),
    400: (94.8, 43.4, -1.1),
    405: (99.8, 44.85, -0.8),
    410: (104.8, 46.3, -0.5),
    415: (105.35, 45.1, -0.6),
    420: (105.9, 43.9, -0.7),
    425: (101.35, 40.5, -0.95),
    430: (96.8, 37.1, -1.2),
    435: (105.35, 36.9, -1.9),
    440: (113.9, 36.7, -2.6),
    445: (119.75, 36.3, -2.75),
    450: (125.6, 35.9, -2.9),
    455: (125.55, 34.25, -2.85),
    460: (125.5, 32.6, -2.8),
    465: (123.4, 30.25, -2.7),
    470: (121.3, 27.9, -2.6),
    475: (121.3, 26.1, -2.6),
    480: (121.3, 24.3, -2.6),
    485: (117.4, 22.2, -2.2),
    490: (113.5, 20.1, -1.8),
    495: (113.3, 18.15, -1.65),
    500: (113.1, 16.2, -1.5),
    505: (111.95, 14.7, -1.4),
    510: (110.8, 13.2, -1.3),
    515: (108.65, 10.9, -1.25),
    520: (106.5, 8.6, -1.2),
    525: (107.65, 7.35, -1.1),
    530: (108.8, 6.1, -1),
    535: (107.05, 5.15, -0.75),
    540: (105.3, 4.2, -0.5),
    545: (104.85, 3.05, -0.4),
    550: (104.4, 1.9, -0.3),
    555: (102.2, 0.95, -0.15),
    560: (100, 0, 0),
    565: (98, -0.8, 0.1),
    570: (96, -1.6, 0.2),
    575: (95.55, -2.55, 0.35),
    580: (95.1, -3.5, 0.5),
    585: (92.1, -3.5, 1.3),
    590: (89.1, -3.5, 2.1),
    595: (89.8, -4.65, 2.65),
    600: (90.5, -5.8, 3.2),
    605: (90.4, -6.5, 3.65),
    610: (90.3, -7.2, 4.1),
    615: (89.35, -7.9, 4.4),
    620: (88.4, -8.6, 4.7),
    625: (86.2, -9.05, 4.9),
    630: (84, -9.5, 5.1),
    635: (84.55, -10.2, 5.9),
    640: (85.1, -10.9, 6.7),
    645: (83.5, -10.8, 7),
    650: (81.9, -10.7, 7.3),
    655: (82.25, -11.35, 7.95),
    660: (82.6, -12, 8.6),
    665: (83.75, -13, 9.2),
    670: (84.9, -14, 9.8),
    675: (83.1, -13.8, 10),
    680: (81.3, -13.6, 10.2),
    685: (76.6, -12.8, 9.25),
    690: (71.9, -12, 8.3),
    695: (73.1, -12.65, 8.95),
    700: (74.3, -13.3, 9.6),
    705: (75.35, -13.1, 9.05),
    710: (76.4, -12.9, 8.5),
    715: (69.85, -11.75, 7.75),
    720: (63.3, -10.6, 7),
    725: (67.5, -11.1, 7.3),
    730: (71.7, -11.6, 7.6),
    735: (74.35, -11.9, 7.8),
    740: (77, -12.2, 8),
    745: (71.1, -11.2, 7.35),
    750: (65.2, -10.2, 6.7),
    755: (56.45, -9, 5.95),
    760: (47.7, -7.8, 5.2),
    765: (58.15, -9.5, 6.3),
    770: (68.6, -11.2, 7.4),
    775: (66.8, -10.8, 7.1),
    780: (65, -10.4, 6.8),
    785: (65.5, -10.5, 6.9),
    790: (66, -10.6, 7),
    795: (63.5, -10.15, 6.7),
    800: (61, -9.7, 6.4),
    805: (57.15, -9, 5.95),
    810: (53.3, -8.3, 5.5),
    815: (56.1, -8.8, 5.8),
    820: (58.9, -9.3, 6.1),
    825: (60.4, -9.55, 6.3),
    830: (61.9, -9.8, 6.5),
}
