"use strict";
const iam = require("@aws-cdk/aws-iam");
const kms = require("../lib");
module.exports = {
    'Via service, any principal'(test) {
        // WHEN
        const statement = new iam.PolicyStatement({
            actions: ['abc:call'],
            principals: [new kms.ViaServicePrincipal('bla.amazonaws.com')],
            resources: ['*']
        });
        // THEN
        test.deepEqual(statement.toStatementJson(), {
            Action: 'abc:call',
            Condition: { StringEquals: { 'kms:ViaService': 'bla.amazonaws.com' } },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
    'Via service, principal with conditions'(test) {
        // WHEN
        const statement = new iam.PolicyStatement({
            actions: ['abc:call'],
            principals: [new kms.ViaServicePrincipal('bla.amazonaws.com', new iam.OrganizationPrincipal('o-1234'))],
            resources: ['*']
        });
        // THEN
        test.deepEqual(statement.toStatementJson(), {
            Action: 'abc:call',
            Condition: {
                StringEquals: {
                    'kms:ViaService': 'bla.amazonaws.com',
                    'aws:PrincipalOrgID': 'o-1234'
                }
            },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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