"""Add person.jti and person.expiration_date

Revision ID: b8ed0fb263f8
Revises: 4715c2586036
Create Date: 2024-02-01 03:51:51.734172

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "b8ed0fb263f8"
down_revision = "4715c2586036"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("jti", sa.String(length=60), nullable=True)
        )
        batch_op.add_column(
            sa.Column("expiration_date", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "is_bot",
                sa.Boolean(),
                nullable=False,
                server_default=sa.sql.expression.false(),
                default=False,
            )
        )
        batch_op.create_unique_constraint(None, ["jti"])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.drop_constraint("person_jti_key", type_="unique")
        batch_op.drop_column("expiration_date")
        batch_op.drop_column("jti")
        batch_op.drop_column("is_bot")

    # ### end Alembic commands ###
