import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeResourceMonitorsConfig extends cdktf.TerraformMetaArguments {
}
export interface DataSnowflakeResourceMonitorsResourceMonitors {
}
export declare function dataSnowflakeResourceMonitorsResourceMonitorsToTerraform(struct?: DataSnowflakeResourceMonitorsResourceMonitors): any;
export declare class DataSnowflakeResourceMonitorsResourceMonitorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeResourceMonitorsResourceMonitors | undefined;
    set internalValue(value: DataSnowflakeResourceMonitorsResourceMonitors | undefined);
    get comment(): string;
    get creditQuota(): string;
    get frequency(): string;
    get name(): string;
}
export declare class DataSnowflakeResourceMonitorsResourceMonitorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeResourceMonitorsResourceMonitorsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/resource_monitors snowflake_resource_monitors}
*/
export declare class DataSnowflakeResourceMonitors extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_resource_monitors";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/resource_monitors snowflake_resource_monitors} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeResourceMonitorsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeResourceMonitorsConfig);
    get id(): string;
    private _resourceMonitors;
    get resourceMonitors(): DataSnowflakeResourceMonitorsResourceMonitorsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
