import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The role for which to return metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/role#name DataSnowflakeRole#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/role snowflake_role}
*/
export declare class DataSnowflakeRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/role snowflake_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeRoleConfig);
    get comment(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
