/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defines whether this ACL Auth Method is to be set as default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#default AclAuthMethod#default}
    */
    readonly default?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#id AclAuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Defines the maximum life of a token created by this method.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#max_token_ttl AclAuthMethod#max_token_ttl}
    */
    readonly maxTokenTtl: string;
    /**
    * The identifier of the ACL Auth Method.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#name AclAuthMethod#name}
    */
    readonly name: string;
    /**
    * Defines whether the ACL Auth Method creates a local or global token when performing SSO login. This field must be set to either "local" or "global".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#token_locality AclAuthMethod#token_locality}
    */
    readonly tokenLocality: string;
    /**
    * ACL Auth Method SSO workflow type. Currently, the only supported type is "OIDC."
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#type AclAuthMethod#type}
    */
    readonly type: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#config AclAuthMethod#config}
    */
    readonly config: AclAuthMethodConfigA;
}
export interface AclAuthMethodConfigA {
    /**
    * A list of allowed values that can be used for the redirect URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#allowed_redirect_uris AclAuthMethod#allowed_redirect_uris}
    */
    readonly allowedRedirectUris: string[];
    /**
    * List of auth claims that are valid for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#bound_audiences AclAuthMethod#bound_audiences}
    */
    readonly boundAudiences?: string[];
    /**
    * Mappings of claims (key) that will be copied to a metadata field (value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#claim_mappings AclAuthMethod#claim_mappings}
    */
    readonly claimMappings?: {
        [key: string]: string;
    };
    /**
    * PEM encoded CA certs for use by the TLS client used to talk with the OIDC Discovery URL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#discovery_ca_pem AclAuthMethod#discovery_ca_pem}
    */
    readonly discoveryCaPem?: string[];
    /**
    * Mappings of list claims (key) that will be copied to a metadata field (value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#list_claim_mappings AclAuthMethod#list_claim_mappings}
    */
    readonly listClaimMappings?: {
        [key: string]: string;
    };
    /**
    * The OAuth Client ID configured with the OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#oidc_client_id AclAuthMethod#oidc_client_id}
    */
    readonly oidcClientId: string;
    /**
    * The OAuth Client Secret configured with the OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#oidc_client_secret AclAuthMethod#oidc_client_secret}
    */
    readonly oidcClientSecret: string;
    /**
    * The OIDC Discovery URL, without any .well-known component (base path).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#oidc_discovery_url AclAuthMethod#oidc_discovery_url}
    */
    readonly oidcDiscoveryUrl: string;
    /**
    * List of OIDC scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#oidc_scopes AclAuthMethod#oidc_scopes}
    */
    readonly oidcScopes?: string[];
    /**
    * A list of supported signing algorithms.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#signing_algs AclAuthMethod#signing_algs}
    */
    readonly signingAlgs?: string[];
}
export declare function aclAuthMethodConfigAToTerraform(struct?: AclAuthMethodConfigAOutputReference | AclAuthMethodConfigA): any;
export declare class AclAuthMethodConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AclAuthMethodConfigA | undefined;
    set internalValue(value: AclAuthMethodConfigA | undefined);
    private _allowedRedirectUris?;
    get allowedRedirectUris(): string[];
    set allowedRedirectUris(value: string[]);
    get allowedRedirectUrisInput(): string[] | undefined;
    private _boundAudiences?;
    get boundAudiences(): string[];
    set boundAudiences(value: string[]);
    resetBoundAudiences(): void;
    get boundAudiencesInput(): string[] | undefined;
    private _claimMappings?;
    get claimMappings(): {
        [key: string]: string;
    };
    set claimMappings(value: {
        [key: string]: string;
    });
    resetClaimMappings(): void;
    get claimMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _discoveryCaPem?;
    get discoveryCaPem(): string[];
    set discoveryCaPem(value: string[]);
    resetDiscoveryCaPem(): void;
    get discoveryCaPemInput(): string[] | undefined;
    private _listClaimMappings?;
    get listClaimMappings(): {
        [key: string]: string;
    };
    set listClaimMappings(value: {
        [key: string]: string;
    });
    resetListClaimMappings(): void;
    get listClaimMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _oidcClientId?;
    get oidcClientId(): string;
    set oidcClientId(value: string);
    get oidcClientIdInput(): string | undefined;
    private _oidcClientSecret?;
    get oidcClientSecret(): string;
    set oidcClientSecret(value: string);
    get oidcClientSecretInput(): string | undefined;
    private _oidcDiscoveryUrl?;
    get oidcDiscoveryUrl(): string;
    set oidcDiscoveryUrl(value: string);
    get oidcDiscoveryUrlInput(): string | undefined;
    private _oidcScopes?;
    get oidcScopes(): string[];
    set oidcScopes(value: string[]);
    resetOidcScopes(): void;
    get oidcScopesInput(): string[] | undefined;
    private _signingAlgs?;
    get signingAlgs(): string[];
    set signingAlgs(value: string[]);
    resetSigningAlgs(): void;
    get signingAlgsInput(): string[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method nomad_acl_auth_method}
*/
export declare class AclAuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_auth_method";
    /**
    * Generates CDKTF code for importing a AclAuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AclAuthMethod to import
    * @param importFromId The id of the existing AclAuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AclAuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_auth_method nomad_acl_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AclAuthMethodConfig);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    resetDefault(): void;
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTokenTtl?;
    get maxTokenTtl(): string;
    set maxTokenTtl(value: string);
    get maxTokenTtlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tokenLocality?;
    get tokenLocality(): string;
    set tokenLocality(value: string);
    get tokenLocalityInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _config;
    get config(): AclAuthMethodConfigAOutputReference;
    putConfig(value: AclAuthMethodConfigA): void;
    get configInput(): AclAuthMethodConfigA | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
