/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclBindingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the auth method for which this rule applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#auth_method AclBindingRule#auth_method}
    */
    readonly authMethod: string;
    /**
    * Target of the binding.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#bind_name AclBindingRule#bind_name}
    */
    readonly bindName?: string;
    /**
    * Adjusts how this binding rule is applied at login time. Valid values are "role" and "policy".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#bind_type AclBindingRule#bind_type}
    */
    readonly bindType: string;
    /**
    * Description for this ACL binding rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#description AclBindingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#id AclBindingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A boolean expression that matches against verified identity attributes returned from the auth method during login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#selector AclBindingRule#selector}
    */
    readonly selector?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule nomad_acl_binding_rule}
*/
export declare class AclBindingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_binding_rule";
    /**
    * Generates CDKTF code for importing a AclBindingRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AclBindingRule to import
    * @param importFromId The id of the existing AclBindingRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AclBindingRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_binding_rule nomad_acl_binding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclBindingRuleConfig
    */
    constructor(scope: Construct, id: string, config: AclBindingRuleConfig);
    private _authMethod?;
    get authMethod(): string;
    set authMethod(value: string);
    get authMethodInput(): string | undefined;
    private _bindName?;
    get bindName(): string;
    set bindName(value: string);
    resetBindName(): void;
    get bindNameInput(): string | undefined;
    private _bindType?;
    get bindType(): string;
    set bindType(value: string);
    get bindTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
