/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#description AclPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#id AclPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#name AclPolicy#name}
    */
    readonly name: string;
    /**
    * HCL or JSON representation of the rules to enforce on this policy. Use file() to specify a file as input.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#rules_hcl AclPolicy#rules_hcl}
    */
    readonly rulesHcl: string;
    /**
    * job_acl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#job_acl AclPolicy#job_acl}
    */
    readonly jobAcl?: AclPolicyJobAcl;
}
export interface AclPolicyJobAcl {
    /**
    * Group
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#group AclPolicy#group}
    */
    readonly group?: string;
    /**
    * Job
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#job_id AclPolicy#job_id}
    */
    readonly jobId: string;
    /**
    * Namespace
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#namespace AclPolicy#namespace}
    */
    readonly namespace?: string;
    /**
    * Task
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#task AclPolicy#task}
    */
    readonly task?: string;
}
export declare function aclPolicyJobAclToTerraform(struct?: AclPolicyJobAclOutputReference | AclPolicyJobAcl): any;
export declare class AclPolicyJobAclOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AclPolicyJobAcl | undefined;
    set internalValue(value: AclPolicyJobAcl | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _task?;
    get task(): string;
    set task(value: string);
    resetTask(): void;
    get taskInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy nomad_acl_policy}
*/
export declare class AclPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_policy";
    /**
    * Generates CDKTF code for importing a AclPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AclPolicy to import
    * @param importFromId The id of the existing AclPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AclPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/acl_policy nomad_acl_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclPolicyConfig
    */
    constructor(scope: Construct, id: string, config: AclPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rulesHcl?;
    get rulesHcl(): string;
    set rulesHcl(value: string);
    get rulesHclInput(): string | undefined;
    private _jobAcl;
    get jobAcl(): AclPolicyJobAclOutputReference;
    putJobAcl(value: AclPolicyJobAcl): void;
    resetJobAcl(): void;
    get jobAclInput(): AclPolicyJobAcl | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
