/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsiVolumeRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#context CsiVolumeRegistration#context}
    */
    readonly context?: {
        [key: string]: string;
    };
    /**
    * If true, the volume will be deregistered on destroy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#deregister_on_destroy CsiVolumeRegistration#deregister_on_destroy}
    */
    readonly deregisterOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * The ID of the physical volume from the storage provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#external_id CsiVolumeRegistration#external_id}
    */
    readonly externalId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#id CsiVolumeRegistration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#name CsiVolumeRegistration#name}
    */
    readonly name: string;
    /**
    * The namespace in which to create the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#namespace CsiVolumeRegistration#namespace}
    */
    readonly namespace?: string;
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#parameters CsiVolumeRegistration#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * The ID of the CSI plugin that manages this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#plugin_id CsiVolumeRegistration#plugin_id}
    */
    readonly pluginId: string;
    /**
    * An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#secrets CsiVolumeRegistration#secrets}
    */
    readonly secrets?: {
        [key: string]: string;
    };
    /**
    * The unique ID of the volume, how jobs will refer to the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#volume_id CsiVolumeRegistration#volume_id}
    */
    readonly volumeId: string;
    /**
    * capability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#capability CsiVolumeRegistration#capability}
    */
    readonly capability?: CsiVolumeRegistrationCapability[] | cdktf.IResolvable;
    /**
    * mount_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#mount_options CsiVolumeRegistration#mount_options}
    */
    readonly mountOptions?: CsiVolumeRegistrationMountOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#timeouts CsiVolumeRegistration#timeouts}
    */
    readonly timeouts?: CsiVolumeRegistrationTimeouts;
    /**
    * topology_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#topology_request CsiVolumeRegistration#topology_request}
    */
    readonly topologyRequest?: CsiVolumeRegistrationTopologyRequest;
}
export interface CsiVolumeRegistrationTopologies {
}
export declare function csiVolumeRegistrationTopologiesToTerraform(struct?: CsiVolumeRegistrationTopologies): any;
export declare class CsiVolumeRegistrationTopologiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeRegistrationTopologies | undefined;
    set internalValue(value: CsiVolumeRegistrationTopologies | undefined);
    private _segments;
    get segments(): cdktf.StringMap;
}
export declare class CsiVolumeRegistrationTopologiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeRegistrationTopologiesOutputReference;
}
export interface CsiVolumeRegistrationCapability {
    /**
    * Defines whether a volume should be available concurrently.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#access_mode CsiVolumeRegistration#access_mode}
    */
    readonly accessMode: string;
    /**
    * The storage API that will be used by the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#attachment_mode CsiVolumeRegistration#attachment_mode}
    */
    readonly attachmentMode: string;
}
export declare function csiVolumeRegistrationCapabilityToTerraform(struct?: CsiVolumeRegistrationCapability | cdktf.IResolvable): any;
export declare class CsiVolumeRegistrationCapabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeRegistrationCapability | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeRegistrationCapability | cdktf.IResolvable | undefined);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    get accessModeInput(): string | undefined;
    private _attachmentMode?;
    get attachmentMode(): string;
    set attachmentMode(value: string);
    get attachmentModeInput(): string | undefined;
}
export declare class CsiVolumeRegistrationCapabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CsiVolumeRegistrationCapability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeRegistrationCapabilityOutputReference;
}
export interface CsiVolumeRegistrationMountOptions {
    /**
    * The file system type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#fs_type CsiVolumeRegistration#fs_type}
    */
    readonly fsType?: string;
    /**
    * The flags passed to mount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#mount_flags CsiVolumeRegistration#mount_flags}
    */
    readonly mountFlags?: string[];
}
export declare function csiVolumeRegistrationMountOptionsToTerraform(struct?: CsiVolumeRegistrationMountOptionsOutputReference | CsiVolumeRegistrationMountOptions): any;
export declare class CsiVolumeRegistrationMountOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeRegistrationMountOptions | undefined;
    set internalValue(value: CsiVolumeRegistrationMountOptions | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _mountFlags?;
    get mountFlags(): string[];
    set mountFlags(value: string[]);
    resetMountFlags(): void;
    get mountFlagsInput(): string[] | undefined;
}
export interface CsiVolumeRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#create CsiVolumeRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#delete CsiVolumeRegistration#delete}
    */
    readonly delete?: string;
}
export declare function csiVolumeRegistrationTimeoutsToTerraform(struct?: CsiVolumeRegistrationTimeouts | cdktf.IResolvable): any;
export declare class CsiVolumeRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeRegistrationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeRegistrationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface CsiVolumeRegistrationTopologyRequestRequiredTopology {
    /**
    * Define attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#segments CsiVolumeRegistration#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function csiVolumeRegistrationTopologyRequestRequiredTopologyToTerraform(struct?: CsiVolumeRegistrationTopologyRequestRequiredTopology | cdktf.IResolvable): any;
export declare class CsiVolumeRegistrationTopologyRequestRequiredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeRegistrationTopologyRequestRequiredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeRegistrationTopologyRequestRequiredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class CsiVolumeRegistrationTopologyRequestRequiredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CsiVolumeRegistrationTopologyRequestRequiredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeRegistrationTopologyRequestRequiredTopologyOutputReference;
}
export interface CsiVolumeRegistrationTopologyRequestRequired {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#topology CsiVolumeRegistration#topology}
    */
    readonly topology: CsiVolumeRegistrationTopologyRequestRequiredTopology[] | cdktf.IResolvable;
}
export declare function csiVolumeRegistrationTopologyRequestRequiredToTerraform(struct?: CsiVolumeRegistrationTopologyRequestRequiredOutputReference | CsiVolumeRegistrationTopologyRequestRequired): any;
export declare class CsiVolumeRegistrationTopologyRequestRequiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeRegistrationTopologyRequestRequired | undefined;
    set internalValue(value: CsiVolumeRegistrationTopologyRequestRequired | undefined);
    private _topology;
    get topology(): CsiVolumeRegistrationTopologyRequestRequiredTopologyList;
    putTopology(value: CsiVolumeRegistrationTopologyRequestRequiredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | CsiVolumeRegistrationTopologyRequestRequiredTopology[] | undefined;
}
export interface CsiVolumeRegistrationTopologyRequest {
    /**
    * required block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#required CsiVolumeRegistration#required}
    */
    readonly required?: CsiVolumeRegistrationTopologyRequestRequired;
}
export declare function csiVolumeRegistrationTopologyRequestToTerraform(struct?: CsiVolumeRegistrationTopologyRequestOutputReference | CsiVolumeRegistrationTopologyRequest): any;
export declare class CsiVolumeRegistrationTopologyRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeRegistrationTopologyRequest | undefined;
    set internalValue(value: CsiVolumeRegistrationTopologyRequest | undefined);
    private _required;
    get required(): CsiVolumeRegistrationTopologyRequestRequiredOutputReference;
    putRequired(value: CsiVolumeRegistrationTopologyRequestRequired): void;
    resetRequired(): void;
    get requiredInput(): CsiVolumeRegistrationTopologyRequestRequired | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration nomad_csi_volume_registration}
*/
export declare class CsiVolumeRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_csi_volume_registration";
    /**
    * Generates CDKTF code for importing a CsiVolumeRegistration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CsiVolumeRegistration to import
    * @param importFromId The id of the existing CsiVolumeRegistration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CsiVolumeRegistration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume_registration nomad_csi_volume_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsiVolumeRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: CsiVolumeRegistrationConfig);
    private _context?;
    get context(): {
        [key: string]: string;
    };
    set context(value: {
        [key: string]: string;
    });
    resetContext(): void;
    get contextInput(): {
        [key: string]: string;
    } | undefined;
    get controllerRequired(): cdktf.IResolvable;
    get controllersExpected(): number;
    get controllersHealthy(): number;
    private _deregisterOnDestroy?;
    get deregisterOnDestroy(): boolean | cdktf.IResolvable;
    set deregisterOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeregisterOnDestroy(): void;
    get deregisterOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    get externalIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get nodesExpected(): number;
    get nodesHealthy(): number;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    get pluginProvider(): string;
    get pluginProviderVersion(): string;
    get schedulable(): cdktf.IResolvable;
    private _secrets?;
    get secrets(): {
        [key: string]: string;
    };
    set secrets(value: {
        [key: string]: string;
    });
    resetSecrets(): void;
    get secretsInput(): {
        [key: string]: string;
    } | undefined;
    private _topologies;
    get topologies(): CsiVolumeRegistrationTopologiesList;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _capability;
    get capability(): CsiVolumeRegistrationCapabilityList;
    putCapability(value: CsiVolumeRegistrationCapability[] | cdktf.IResolvable): void;
    resetCapability(): void;
    get capabilityInput(): cdktf.IResolvable | CsiVolumeRegistrationCapability[] | undefined;
    private _mountOptions;
    get mountOptions(): CsiVolumeRegistrationMountOptionsOutputReference;
    putMountOptions(value: CsiVolumeRegistrationMountOptions): void;
    resetMountOptions(): void;
    get mountOptionsInput(): CsiVolumeRegistrationMountOptions | undefined;
    private _timeouts;
    get timeouts(): CsiVolumeRegistrationTimeoutsOutputReference;
    putTimeouts(value: CsiVolumeRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CsiVolumeRegistrationTimeouts | undefined;
    private _topologyRequest;
    get topologyRequest(): CsiVolumeRegistrationTopologyRequestOutputReference;
    putTopologyRequest(value: CsiVolumeRegistrationTopologyRequest): void;
    resetTopologyRequest(): void;
    get topologyRequestInput(): CsiVolumeRegistrationTopologyRequest | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
