/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsiVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defines how large the volume can be. The storage provider may return a volume that is smaller than this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#capacity_max CsiVolume#capacity_max}
    */
    readonly capacityMax?: string;
    /**
    * Defines how small the volume can be. The storage provider may return a volume that is larger than this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#capacity_min CsiVolume#capacity_min}
    */
    readonly capacityMin?: string;
    /**
    * The volume ID to clone when creating this volume. Storage provider must support cloning. Conflicts with 'snapshot_id'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#clone_id CsiVolume#clone_id}
    */
    readonly cloneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#id CsiVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#name CsiVolume#name}
    */
    readonly name: string;
    /**
    * The namespace in which to create the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#namespace CsiVolume#namespace}
    */
    readonly namespace?: string;
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#parameters CsiVolume#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * The ID of the CSI plugin that manages this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#plugin_id CsiVolume#plugin_id}
    */
    readonly pluginId: string;
    /**
    * An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#secrets CsiVolume#secrets}
    */
    readonly secrets?: {
        [key: string]: string;
    };
    /**
    * The snapshot ID to restore when creating this volume. Storage provider must support snapshots. Conflicts with 'clone_id'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#snapshot_id CsiVolume#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * The unique ID of the volume, how jobs will refer to the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#volume_id CsiVolume#volume_id}
    */
    readonly volumeId: string;
    /**
    * capability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#capability CsiVolume#capability}
    */
    readonly capability: CsiVolumeCapability[] | cdktf.IResolvable;
    /**
    * mount_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#mount_options CsiVolume#mount_options}
    */
    readonly mountOptions?: CsiVolumeMountOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#timeouts CsiVolume#timeouts}
    */
    readonly timeouts?: CsiVolumeTimeouts;
    /**
    * topology_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#topology_request CsiVolume#topology_request}
    */
    readonly topologyRequest?: CsiVolumeTopologyRequest;
}
export interface CsiVolumeTopologies {
}
export declare function csiVolumeTopologiesToTerraform(struct?: CsiVolumeTopologies): any;
export declare class CsiVolumeTopologiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeTopologies | undefined;
    set internalValue(value: CsiVolumeTopologies | undefined);
    private _segments;
    get segments(): cdktf.StringMap;
}
export declare class CsiVolumeTopologiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeTopologiesOutputReference;
}
export interface CsiVolumeCapability {
    /**
    * Defines whether a volume should be available concurrently.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#access_mode CsiVolume#access_mode}
    */
    readonly accessMode: string;
    /**
    * The storage API that will be used by the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#attachment_mode CsiVolume#attachment_mode}
    */
    readonly attachmentMode: string;
}
export declare function csiVolumeCapabilityToTerraform(struct?: CsiVolumeCapability | cdktf.IResolvable): any;
export declare class CsiVolumeCapabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeCapability | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeCapability | cdktf.IResolvable | undefined);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    get accessModeInput(): string | undefined;
    private _attachmentMode?;
    get attachmentMode(): string;
    set attachmentMode(value: string);
    get attachmentModeInput(): string | undefined;
}
export declare class CsiVolumeCapabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CsiVolumeCapability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeCapabilityOutputReference;
}
export interface CsiVolumeMountOptions {
    /**
    * The file system type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#fs_type CsiVolume#fs_type}
    */
    readonly fsType?: string;
    /**
    * The flags passed to mount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#mount_flags CsiVolume#mount_flags}
    */
    readonly mountFlags?: string[];
}
export declare function csiVolumeMountOptionsToTerraform(struct?: CsiVolumeMountOptionsOutputReference | CsiVolumeMountOptions): any;
export declare class CsiVolumeMountOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeMountOptions | undefined;
    set internalValue(value: CsiVolumeMountOptions | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _mountFlags?;
    get mountFlags(): string[];
    set mountFlags(value: string[]);
    resetMountFlags(): void;
    get mountFlagsInput(): string[] | undefined;
}
export interface CsiVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#create CsiVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#delete CsiVolume#delete}
    */
    readonly delete?: string;
}
export declare function csiVolumeTimeoutsToTerraform(struct?: CsiVolumeTimeouts | cdktf.IResolvable): any;
export declare class CsiVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface CsiVolumeTopologyRequestPreferredTopology {
    /**
    * Define the attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#segments CsiVolume#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function csiVolumeTopologyRequestPreferredTopologyToTerraform(struct?: CsiVolumeTopologyRequestPreferredTopology | cdktf.IResolvable): any;
export declare class CsiVolumeTopologyRequestPreferredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeTopologyRequestPreferredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeTopologyRequestPreferredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class CsiVolumeTopologyRequestPreferredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CsiVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeTopologyRequestPreferredTopologyOutputReference;
}
export interface CsiVolumeTopologyRequestPreferred {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#topology CsiVolume#topology}
    */
    readonly topology: CsiVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable;
}
export declare function csiVolumeTopologyRequestPreferredToTerraform(struct?: CsiVolumeTopologyRequestPreferredOutputReference | CsiVolumeTopologyRequestPreferred): any;
export declare class CsiVolumeTopologyRequestPreferredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeTopologyRequestPreferred | undefined;
    set internalValue(value: CsiVolumeTopologyRequestPreferred | undefined);
    private _topology;
    get topology(): CsiVolumeTopologyRequestPreferredTopologyList;
    putTopology(value: CsiVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | CsiVolumeTopologyRequestPreferredTopology[] | undefined;
}
export interface CsiVolumeTopologyRequestRequiredTopology {
    /**
    * Define the attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#segments CsiVolume#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function csiVolumeTopologyRequestRequiredTopologyToTerraform(struct?: CsiVolumeTopologyRequestRequiredTopology | cdktf.IResolvable): any;
export declare class CsiVolumeTopologyRequestRequiredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CsiVolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: CsiVolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class CsiVolumeTopologyRequestRequiredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CsiVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CsiVolumeTopologyRequestRequiredTopologyOutputReference;
}
export interface CsiVolumeTopologyRequestRequired {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#topology CsiVolume#topology}
    */
    readonly topology: CsiVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
}
export declare function csiVolumeTopologyRequestRequiredToTerraform(struct?: CsiVolumeTopologyRequestRequiredOutputReference | CsiVolumeTopologyRequestRequired): any;
export declare class CsiVolumeTopologyRequestRequiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeTopologyRequestRequired | undefined;
    set internalValue(value: CsiVolumeTopologyRequestRequired | undefined);
    private _topology;
    get topology(): CsiVolumeTopologyRequestRequiredTopologyList;
    putTopology(value: CsiVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | CsiVolumeTopologyRequestRequiredTopology[] | undefined;
}
export interface CsiVolumeTopologyRequest {
    /**
    * preferred block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#preferred CsiVolume#preferred}
    */
    readonly preferred?: CsiVolumeTopologyRequestPreferred;
    /**
    * required block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#required CsiVolume#required}
    */
    readonly required?: CsiVolumeTopologyRequestRequired;
}
export declare function csiVolumeTopologyRequestToTerraform(struct?: CsiVolumeTopologyRequestOutputReference | CsiVolumeTopologyRequest): any;
export declare class CsiVolumeTopologyRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CsiVolumeTopologyRequest | undefined;
    set internalValue(value: CsiVolumeTopologyRequest | undefined);
    private _preferred;
    get preferred(): CsiVolumeTopologyRequestPreferredOutputReference;
    putPreferred(value: CsiVolumeTopologyRequestPreferred): void;
    resetPreferred(): void;
    get preferredInput(): CsiVolumeTopologyRequestPreferred | undefined;
    private _required;
    get required(): CsiVolumeTopologyRequestRequiredOutputReference;
    putRequired(value: CsiVolumeTopologyRequestRequired): void;
    resetRequired(): void;
    get requiredInput(): CsiVolumeTopologyRequestRequired | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume nomad_csi_volume}
*/
export declare class CsiVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_csi_volume";
    /**
    * Generates CDKTF code for importing a CsiVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CsiVolume to import
    * @param importFromId The id of the existing CsiVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CsiVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/csi_volume nomad_csi_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsiVolumeConfig
    */
    constructor(scope: Construct, id: string, config: CsiVolumeConfig);
    private _capacityMax?;
    get capacityMax(): string;
    set capacityMax(value: string);
    resetCapacityMax(): void;
    get capacityMaxInput(): string | undefined;
    private _capacityMin?;
    get capacityMin(): string;
    set capacityMin(value: string);
    resetCapacityMin(): void;
    get capacityMinInput(): string | undefined;
    private _cloneId?;
    get cloneId(): string;
    set cloneId(value: string);
    resetCloneId(): void;
    get cloneIdInput(): string | undefined;
    get controllerRequired(): cdktf.IResolvable;
    get controllersExpected(): number;
    get controllersHealthy(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get nodesExpected(): number;
    get nodesHealthy(): number;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    get pluginProvider(): string;
    get pluginProviderVersion(): string;
    get schedulable(): cdktf.IResolvable;
    private _secrets?;
    get secrets(): {
        [key: string]: string;
    };
    set secrets(value: {
        [key: string]: string;
    });
    resetSecrets(): void;
    get secretsInput(): {
        [key: string]: string;
    } | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _topologies;
    get topologies(): CsiVolumeTopologiesList;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _capability;
    get capability(): CsiVolumeCapabilityList;
    putCapability(value: CsiVolumeCapability[] | cdktf.IResolvable): void;
    get capabilityInput(): cdktf.IResolvable | CsiVolumeCapability[] | undefined;
    private _mountOptions;
    get mountOptions(): CsiVolumeMountOptionsOutputReference;
    putMountOptions(value: CsiVolumeMountOptions): void;
    resetMountOptions(): void;
    get mountOptionsInput(): CsiVolumeMountOptions | undefined;
    private _timeouts;
    get timeouts(): CsiVolumeTimeoutsOutputReference;
    putTimeouts(value: CsiVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CsiVolumeTimeouts | undefined;
    private _topologyRequest;
    get topologyRequest(): CsiVolumeTopologyRequestOutputReference;
    putTopologyRequest(value: CsiVolumeTopologyRequest): void;
    resetTopologyRequest(): void;
    get topologyRequestInput(): CsiVolumeTopologyRequest | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
