/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadAclPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_policies#id DataNomadAclPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ACL Policy Name Prefix
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_policies#prefix DataNomadAclPolicies#prefix}
    */
    readonly prefix?: string;
}
export interface DataNomadAclPoliciesPolicies {
}
export declare function dataNomadAclPoliciesPoliciesToTerraform(struct?: DataNomadAclPoliciesPolicies): any;
export declare class DataNomadAclPoliciesPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadAclPoliciesPolicies | undefined;
    set internalValue(value: DataNomadAclPoliciesPolicies | undefined);
    get description(): string;
    get name(): string;
}
export declare class DataNomadAclPoliciesPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadAclPoliciesPoliciesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_policies nomad_acl_policies}
*/
export declare class DataNomadAclPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_acl_policies";
    /**
    * Generates CDKTF code for importing a DataNomadAclPolicies resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadAclPolicies to import
    * @param importFromId The id of the existing DataNomadAclPolicies that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_policies#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadAclPolicies to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_policies nomad_acl_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadAclPoliciesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadAclPoliciesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policies;
    get policies(): DataNomadAclPoliciesPoliciesList;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
