/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadAclRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_roles#id DataNomadAclRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_roles#prefix DataNomadAclRoles#prefix}
    */
    readonly prefix?: string;
}
export interface DataNomadAclRolesAclRolesPolicies {
}
export declare function dataNomadAclRolesAclRolesPoliciesToTerraform(struct?: DataNomadAclRolesAclRolesPolicies): any;
export declare class DataNomadAclRolesAclRolesPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadAclRolesAclRolesPolicies | undefined;
    set internalValue(value: DataNomadAclRolesAclRolesPolicies | undefined);
    get name(): string;
}
export declare class DataNomadAclRolesAclRolesPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadAclRolesAclRolesPoliciesOutputReference;
}
export interface DataNomadAclRolesAclRoles {
}
export declare function dataNomadAclRolesAclRolesToTerraform(struct?: DataNomadAclRolesAclRoles): any;
export declare class DataNomadAclRolesAclRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadAclRolesAclRoles | undefined;
    set internalValue(value: DataNomadAclRolesAclRoles | undefined);
    get description(): string;
    get id(): string;
    get name(): string;
    private _policies;
    get policies(): DataNomadAclRolesAclRolesPoliciesList;
}
export declare class DataNomadAclRolesAclRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadAclRolesAclRolesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_roles nomad_acl_roles}
*/
export declare class DataNomadAclRoles extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_acl_roles";
    /**
    * Generates CDKTF code for importing a DataNomadAclRoles resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadAclRoles to import
    * @param importFromId The id of the existing DataNomadAclRoles that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_roles#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadAclRoles to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/acl_roles nomad_acl_roles} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadAclRolesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadAclRolesConfig);
    private _aclRoles;
    get aclRoles(): DataNomadAclRolesAclRolesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
