/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadAllocationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the expression used to filter the results.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations#filter DataNomadAllocations#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations#id DataNomadAllocations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies a string to filter node pools based on a name prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations#prefix DataNomadAllocations#prefix}
    */
    readonly prefix?: string;
}
export interface DataNomadAllocationsAllocations {
}
export declare function dataNomadAllocationsAllocationsToTerraform(struct?: DataNomadAllocationsAllocations): any;
export declare class DataNomadAllocationsAllocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadAllocationsAllocations | undefined;
    set internalValue(value: DataNomadAllocationsAllocations | undefined);
    get clientStatus(): string;
    get createIndex(): number;
    get createTime(): number;
    get desiredStatus(): string;
    get evalId(): string;
    get followupEvalId(): string;
    get id(): string;
    get jobId(): string;
    get jobType(): string;
    get jobVersion(): number;
    get modifyIndex(): number;
    get modifyTime(): number;
    get name(): string;
    get namespace(): string;
    get nextAllocation(): string;
    get nodeId(): string;
    get nodeName(): string;
    get preemptedByAllocation(): string;
    get taskGroup(): string;
}
export declare class DataNomadAllocationsAllocationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadAllocationsAllocationsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations nomad_allocations}
*/
export declare class DataNomadAllocations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_allocations";
    /**
    * Generates CDKTF code for importing a DataNomadAllocations resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadAllocations to import
    * @param importFromId The id of the existing DataNomadAllocations that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadAllocations to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/allocations nomad_allocations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadAllocationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadAllocationsConfig);
    private _allocations;
    get allocations(): DataNomadAllocationsAllocationsList;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
