/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadJobParserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag to enable setting any unset fields to their default values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser#canonicalize DataNomadJobParser#canonicalize}
    */
    readonly canonicalize?: boolean | cdktf.IResolvable;
    /**
    * Specifies the HCL definition of the job encoded in a JSON string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser#hcl DataNomadJobParser#hcl}
    */
    readonly hcl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser#id DataNomadJobParser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser nomad_job_parser}
*/
export declare class DataNomadJobParser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_job_parser";
    /**
    * Generates CDKTF code for importing a DataNomadJobParser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadJobParser to import
    * @param importFromId The id of the existing DataNomadJobParser that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadJobParser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job_parser nomad_job_parser} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadJobParserConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadJobParserConfig);
    private _canonicalize?;
    get canonicalize(): boolean | cdktf.IResolvable;
    set canonicalize(value: boolean | cdktf.IResolvable);
    resetCanonicalize(): void;
    get canonicalizeInput(): boolean | cdktf.IResolvable | undefined;
    private _hcl?;
    get hcl(): string;
    set hcl(value: string);
    get hclInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get json(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
