/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job#id DataNomadJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Job ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job#job_id DataNomadJob#job_id}
    */
    readonly jobId: string;
    /**
    * Job Namespace
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job#namespace DataNomadJob#namespace}
    */
    readonly namespace?: string;
}
export interface DataNomadJobConstraints {
}
export declare function dataNomadJobConstraintsToTerraform(struct?: DataNomadJobConstraints): any;
export declare class DataNomadJobConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobConstraints | undefined;
    set internalValue(value: DataNomadJobConstraints | undefined);
    get ltarget(): string;
    get operand(): string;
    get rtarget(): string;
}
export declare class DataNomadJobConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobConstraintsOutputReference;
}
export interface DataNomadJobPeriodicConfig {
}
export declare function dataNomadJobPeriodicConfigToTerraform(struct?: DataNomadJobPeriodicConfig): any;
export declare class DataNomadJobPeriodicConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobPeriodicConfig | undefined;
    set internalValue(value: DataNomadJobPeriodicConfig | undefined);
    get enabled(): cdktf.IResolvable;
    get prohibitOverlap(): cdktf.IResolvable;
    get spec(): string;
    get specType(): string;
    get timezone(): string;
}
export declare class DataNomadJobPeriodicConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobPeriodicConfigOutputReference;
}
export interface DataNomadJobTaskGroupsTaskVolumeMounts {
}
export declare function dataNomadJobTaskGroupsTaskVolumeMountsToTerraform(struct?: DataNomadJobTaskGroupsTaskVolumeMounts): any;
export declare class DataNomadJobTaskGroupsTaskVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobTaskGroupsTaskVolumeMounts | undefined;
    set internalValue(value: DataNomadJobTaskGroupsTaskVolumeMounts | undefined);
    get destination(): string;
    get readOnly(): cdktf.IResolvable;
    get volume(): string;
}
export declare class DataNomadJobTaskGroupsTaskVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobTaskGroupsTaskVolumeMountsOutputReference;
}
export interface DataNomadJobTaskGroupsTask {
}
export declare function dataNomadJobTaskGroupsTaskToTerraform(struct?: DataNomadJobTaskGroupsTask): any;
export declare class DataNomadJobTaskGroupsTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobTaskGroupsTask | undefined;
    set internalValue(value: DataNomadJobTaskGroupsTask | undefined);
    get driver(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _volumeMounts;
    get volumeMounts(): DataNomadJobTaskGroupsTaskVolumeMountsList;
}
export declare class DataNomadJobTaskGroupsTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobTaskGroupsTaskOutputReference;
}
export interface DataNomadJobTaskGroupsVolumes {
}
export declare function dataNomadJobTaskGroupsVolumesToTerraform(struct?: DataNomadJobTaskGroupsVolumes): any;
export declare class DataNomadJobTaskGroupsVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobTaskGroupsVolumes | undefined;
    set internalValue(value: DataNomadJobTaskGroupsVolumes | undefined);
    get name(): string;
    get readOnly(): cdktf.IResolvable;
    get source(): string;
    get type(): string;
}
export declare class DataNomadJobTaskGroupsVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobTaskGroupsVolumesOutputReference;
}
export interface DataNomadJobTaskGroups {
}
export declare function dataNomadJobTaskGroupsToTerraform(struct?: DataNomadJobTaskGroups): any;
export declare class DataNomadJobTaskGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadJobTaskGroups | undefined;
    set internalValue(value: DataNomadJobTaskGroups | undefined);
    get count(): number;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _task;
    get task(): DataNomadJobTaskGroupsTaskList;
    private _volumes;
    get volumes(): DataNomadJobTaskGroupsVolumesList;
}
export declare class DataNomadJobTaskGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadJobTaskGroupsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job nomad_job}
*/
export declare class DataNomadJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_job";
    /**
    * Generates CDKTF code for importing a DataNomadJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadJob to import
    * @param importFromId The id of the existing DataNomadJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/job nomad_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadJobConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadJobConfig);
    get allAtOnce(): cdktf.IResolvable;
    private _constraints;
    get constraints(): DataNomadJobConstraintsList;
    get createIndex(): number;
    get datacenters(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    get jobModifyIndex(): number;
    get modifyIndex(): number;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get parentId(): string;
    private _periodicConfig;
    get periodicConfig(): DataNomadJobPeriodicConfigList;
    get priority(): number;
    get region(): string;
    get stable(): cdktf.IResolvable;
    get status(): string;
    get statusDescription(): string;
    get stop(): cdktf.IResolvable;
    get submitTime(): number;
    private _taskGroups;
    get taskGroups(): DataNomadJobTaskGroupsList;
    get type(): string;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
