/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/namespace#id DataNomadNamespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/namespace#name DataNomadNamespace#name}
    */
    readonly name: string;
}
export interface DataNomadNamespaceCapabilities {
}
export declare function dataNomadNamespaceCapabilitiesToTerraform(struct?: DataNomadNamespaceCapabilities): any;
export declare class DataNomadNamespaceCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadNamespaceCapabilities | undefined;
    set internalValue(value: DataNomadNamespaceCapabilities | undefined);
    get disabledTaskDrivers(): string[];
    get enabledTaskDrivers(): string[];
}
export declare class DataNomadNamespaceCapabilitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadNamespaceCapabilitiesOutputReference;
}
export interface DataNomadNamespaceNodePoolConfig {
}
export declare function dataNomadNamespaceNodePoolConfigToTerraform(struct?: DataNomadNamespaceNodePoolConfig): any;
export declare class DataNomadNamespaceNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadNamespaceNodePoolConfig | undefined;
    set internalValue(value: DataNomadNamespaceNodePoolConfig | undefined);
    get allowed(): string[];
    get default(): string;
    get denied(): string[];
}
export declare class DataNomadNamespaceNodePoolConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadNamespaceNodePoolConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/namespace nomad_namespace}
*/
export declare class DataNomadNamespace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_namespace";
    /**
    * Generates CDKTF code for importing a DataNomadNamespace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadNamespace to import
    * @param importFromId The id of the existing DataNomadNamespace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/namespace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadNamespace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/namespace nomad_namespace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadNamespaceConfig);
    private _capabilities;
    get capabilities(): DataNomadNamespaceCapabilitiesList;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta;
    get meta(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodePoolConfig;
    get nodePoolConfig(): DataNomadNamespaceNodePoolConfigList;
    get quota(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
