/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadNodePoolsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the expression used to filter the results.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools#filter DataNomadNodePools#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools#id DataNomadNodePools#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies a string to filter node pools based on a name prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools#prefix DataNomadNodePools#prefix}
    */
    readonly prefix?: string;
}
export interface DataNomadNodePoolsNodePoolsSchedulerConfig {
}
export declare function dataNomadNodePoolsNodePoolsSchedulerConfigToTerraform(struct?: DataNomadNodePoolsNodePoolsSchedulerConfig): any;
export declare class DataNomadNodePoolsNodePoolsSchedulerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadNodePoolsNodePoolsSchedulerConfig | undefined;
    set internalValue(value: DataNomadNodePoolsNodePoolsSchedulerConfig | undefined);
    get memoryOversubscription(): string;
    get schedulerAlgorithm(): string;
}
export declare class DataNomadNodePoolsNodePoolsSchedulerConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadNodePoolsNodePoolsSchedulerConfigOutputReference;
}
export interface DataNomadNodePoolsNodePools {
}
export declare function dataNomadNodePoolsNodePoolsToTerraform(struct?: DataNomadNodePoolsNodePools): any;
export declare class DataNomadNodePoolsNodePoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadNodePoolsNodePools | undefined;
    set internalValue(value: DataNomadNodePoolsNodePools | undefined);
    get description(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _schedulerConfig;
    get schedulerConfig(): DataNomadNodePoolsNodePoolsSchedulerConfigList;
}
export declare class DataNomadNodePoolsNodePoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadNodePoolsNodePoolsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools nomad_node_pools}
*/
export declare class DataNomadNodePools extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_node_pools";
    /**
    * Generates CDKTF code for importing a DataNomadNodePools resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadNodePools to import
    * @param importFromId The id of the existing DataNomadNodePools that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadNodePools to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/node_pools nomad_node_pools} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadNodePoolsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadNodePoolsConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nodePools;
    get nodePools(): DataNomadNodePoolsNodePoolsList;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
