/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadPluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin#id DataNomadPlugin#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Plugin ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin#plugin_id DataNomadPlugin#plugin_id}
    */
    readonly pluginId: string;
    /**
    * Wait for to be backed by a specified number of controllers
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin#wait_for_healthy DataNomadPlugin#wait_for_healthy}
    */
    readonly waitForHealthy?: boolean | cdktf.IResolvable;
    /**
    * Wait for the plugin to be registered in Noamd
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin#wait_for_registration DataNomadPlugin#wait_for_registration}
    */
    readonly waitForRegistration?: boolean | cdktf.IResolvable;
}
export interface DataNomadPluginNodes {
}
export declare function dataNomadPluginNodesToTerraform(struct?: DataNomadPluginNodes): any;
export declare class DataNomadPluginNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNomadPluginNodes | undefined;
    set internalValue(value: DataNomadPluginNodes | undefined);
    get healthy(): cdktf.IResolvable;
    get healthyDescription(): string;
    get name(): string;
}
export declare class DataNomadPluginNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNomadPluginNodesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin nomad_plugin}
*/
export declare class DataNomadPlugin extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_plugin";
    /**
    * Generates CDKTF code for importing a DataNomadPlugin resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadPlugin to import
    * @param importFromId The id of the existing DataNomadPlugin that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadPlugin to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/plugin nomad_plugin} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadPluginConfig
    */
    constructor(scope: Construct, id: string, config: DataNomadPluginConfig);
    get controllerRequired(): cdktf.IResolvable;
    get controllersExpected(): number;
    get controllersHealthy(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nodes;
    get nodes(): DataNomadPluginNodesList;
    get nodesExpected(): number;
    get nodesHealthy(): number;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    get pluginProvider(): string;
    get pluginProviderVersion(): string;
    private _waitForHealthy?;
    get waitForHealthy(): boolean | cdktf.IResolvable;
    set waitForHealthy(value: boolean | cdktf.IResolvable);
    resetWaitForHealthy(): void;
    get waitForHealthyInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForRegistration?;
    get waitForRegistration(): boolean | cdktf.IResolvable;
    set waitForRegistration(value: boolean | cdktf.IResolvable);
    resetWaitForRegistration(): void;
    get waitForRegistrationInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
