/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadSchedulerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/scheduler_config#id DataNomadSchedulerConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/scheduler_config nomad_scheduler_config}
*/
export declare class DataNomadSchedulerConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_scheduler_config";
    /**
    * Generates CDKTF code for importing a DataNomadSchedulerConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadSchedulerConfig to import
    * @param importFromId The id of the existing DataNomadSchedulerConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/scheduler_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadSchedulerConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/scheduler_config nomad_scheduler_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadSchedulerConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadSchedulerConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get memoryOversubscriptionEnabled(): cdktf.IResolvable;
    private _preemptionConfig;
    get preemptionConfig(): cdktf.BooleanMap;
    get schedulerAlgorithm(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
