/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadVolumesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#id DataNomadVolumes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Volume namespace filter
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#namespace DataNomadVolumes#namespace}
    */
    readonly namespace?: string;
    /**
    * Volume node filter
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#node_id DataNomadVolumes#node_id}
    */
    readonly nodeId?: string;
    /**
    * Plugin ID filter
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#plugin_id DataNomadVolumes#plugin_id}
    */
    readonly pluginId?: string;
    /**
    * Volume Type (currently only 'csi')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#type DataNomadVolumes#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes nomad_volumes}
*/
export declare class DataNomadVolumes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_volumes";
    /**
    * Generates CDKTF code for importing a DataNomadVolumes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataNomadVolumes to import
    * @param importFromId The id of the existing DataNomadVolumes that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataNomadVolumes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/data-sources/volumes nomad_volumes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadVolumesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadVolumesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _nodeId?;
    get nodeId(): string;
    set nodeId(value: string);
    resetNodeId(): void;
    get nodeIdInput(): string | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    resetPluginId(): void;
    get pluginIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _volumes;
    get volumes(): cdktf.StringMapList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
