/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defines how large the volume can be. The storage provider may return a volume that is smaller than this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#capacity_max ExternalVolume#capacity_max}
    */
    readonly capacityMax?: string;
    /**
    * Defines how small the volume can be. The storage provider may return a volume that is larger than this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#capacity_min ExternalVolume#capacity_min}
    */
    readonly capacityMin?: string;
    /**
    * The volume ID to clone when creating this volume. Storage provider must support cloning. Conflicts with 'snapshot_id'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#clone_id ExternalVolume#clone_id}
    */
    readonly cloneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#id ExternalVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#name ExternalVolume#name}
    */
    readonly name: string;
    /**
    * The namespace in which to create the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#namespace ExternalVolume#namespace}
    */
    readonly namespace?: string;
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#parameters ExternalVolume#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * The ID of the CSI plugin that manages this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#plugin_id ExternalVolume#plugin_id}
    */
    readonly pluginId: string;
    /**
    * An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#secrets ExternalVolume#secrets}
    */
    readonly secrets?: {
        [key: string]: string;
    };
    /**
    * The snapshot ID to restore when creating this volume. Storage provider must support snapshots. Conflicts with 'clone_id'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#snapshot_id ExternalVolume#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * The type of the volume. Currently, only 'csi' is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#type ExternalVolume#type}
    */
    readonly type?: string;
    /**
    * The unique ID of the volume, how jobs will refer to the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#volume_id ExternalVolume#volume_id}
    */
    readonly volumeId: string;
    /**
    * capability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#capability ExternalVolume#capability}
    */
    readonly capability: ExternalVolumeCapability[] | cdktf.IResolvable;
    /**
    * mount_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#mount_options ExternalVolume#mount_options}
    */
    readonly mountOptions?: ExternalVolumeMountOptions;
    /**
    * topology_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#topology_request ExternalVolume#topology_request}
    */
    readonly topologyRequest?: ExternalVolumeTopologyRequest;
}
export interface ExternalVolumeTopologies {
}
export declare function externalVolumeTopologiesToTerraform(struct?: ExternalVolumeTopologies): any;
export declare class ExternalVolumeTopologiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeTopologies | undefined;
    set internalValue(value: ExternalVolumeTopologies | undefined);
    private _segments;
    get segments(): cdktf.StringMap;
}
export declare class ExternalVolumeTopologiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeTopologiesOutputReference;
}
export interface ExternalVolumeCapability {
    /**
    * Defines whether a volume should be available concurrently.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#access_mode ExternalVolume#access_mode}
    */
    readonly accessMode: string;
    /**
    * The storage API that will be used by the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#attachment_mode ExternalVolume#attachment_mode}
    */
    readonly attachmentMode: string;
}
export declare function externalVolumeCapabilityToTerraform(struct?: ExternalVolumeCapability | cdktf.IResolvable): any;
export declare class ExternalVolumeCapabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeCapability | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalVolumeCapability | cdktf.IResolvable | undefined);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    get accessModeInput(): string | undefined;
    private _attachmentMode?;
    get attachmentMode(): string;
    set attachmentMode(value: string);
    get attachmentModeInput(): string | undefined;
}
export declare class ExternalVolumeCapabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalVolumeCapability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeCapabilityOutputReference;
}
export interface ExternalVolumeMountOptions {
    /**
    * The file system type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#fs_type ExternalVolume#fs_type}
    */
    readonly fsType?: string;
    /**
    * The flags passed to mount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#mount_flags ExternalVolume#mount_flags}
    */
    readonly mountFlags?: string[];
}
export declare function externalVolumeMountOptionsToTerraform(struct?: ExternalVolumeMountOptionsOutputReference | ExternalVolumeMountOptions): any;
export declare class ExternalVolumeMountOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExternalVolumeMountOptions | undefined;
    set internalValue(value: ExternalVolumeMountOptions | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _mountFlags?;
    get mountFlags(): string[];
    set mountFlags(value: string[]);
    resetMountFlags(): void;
    get mountFlagsInput(): string[] | undefined;
}
export interface ExternalVolumeTopologyRequestPreferredTopology {
    /**
    * Define the attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#segments ExternalVolume#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function externalVolumeTopologyRequestPreferredTopologyToTerraform(struct?: ExternalVolumeTopologyRequestPreferredTopology | cdktf.IResolvable): any;
export declare class ExternalVolumeTopologyRequestPreferredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeTopologyRequestPreferredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalVolumeTopologyRequestPreferredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class ExternalVolumeTopologyRequestPreferredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeTopologyRequestPreferredTopologyOutputReference;
}
export interface ExternalVolumeTopologyRequestPreferred {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#topology ExternalVolume#topology}
    */
    readonly topology: ExternalVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable;
}
export declare function externalVolumeTopologyRequestPreferredToTerraform(struct?: ExternalVolumeTopologyRequestPreferredOutputReference | ExternalVolumeTopologyRequestPreferred): any;
export declare class ExternalVolumeTopologyRequestPreferredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExternalVolumeTopologyRequestPreferred | undefined;
    set internalValue(value: ExternalVolumeTopologyRequestPreferred | undefined);
    private _topology;
    get topology(): ExternalVolumeTopologyRequestPreferredTopologyList;
    putTopology(value: ExternalVolumeTopologyRequestPreferredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | ExternalVolumeTopologyRequestPreferredTopology[] | undefined;
}
export interface ExternalVolumeTopologyRequestRequiredTopology {
    /**
    * Define the attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#segments ExternalVolume#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function externalVolumeTopologyRequestRequiredTopologyToTerraform(struct?: ExternalVolumeTopologyRequestRequiredTopology | cdktf.IResolvable): any;
export declare class ExternalVolumeTopologyRequestRequiredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalVolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class ExternalVolumeTopologyRequestRequiredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeTopologyRequestRequiredTopologyOutputReference;
}
export interface ExternalVolumeTopologyRequestRequired {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#topology ExternalVolume#topology}
    */
    readonly topology: ExternalVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
}
export declare function externalVolumeTopologyRequestRequiredToTerraform(struct?: ExternalVolumeTopologyRequestRequiredOutputReference | ExternalVolumeTopologyRequestRequired): any;
export declare class ExternalVolumeTopologyRequestRequiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExternalVolumeTopologyRequestRequired | undefined;
    set internalValue(value: ExternalVolumeTopologyRequestRequired | undefined);
    private _topology;
    get topology(): ExternalVolumeTopologyRequestRequiredTopologyList;
    putTopology(value: ExternalVolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | ExternalVolumeTopologyRequestRequiredTopology[] | undefined;
}
export interface ExternalVolumeTopologyRequest {
    /**
    * preferred block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#preferred ExternalVolume#preferred}
    */
    readonly preferred?: ExternalVolumeTopologyRequestPreferred;
    /**
    * required block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#required ExternalVolume#required}
    */
    readonly required?: ExternalVolumeTopologyRequestRequired;
}
export declare function externalVolumeTopologyRequestToTerraform(struct?: ExternalVolumeTopologyRequestOutputReference | ExternalVolumeTopologyRequest): any;
export declare class ExternalVolumeTopologyRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExternalVolumeTopologyRequest | undefined;
    set internalValue(value: ExternalVolumeTopologyRequest | undefined);
    private _preferred;
    get preferred(): ExternalVolumeTopologyRequestPreferredOutputReference;
    putPreferred(value: ExternalVolumeTopologyRequestPreferred): void;
    resetPreferred(): void;
    get preferredInput(): ExternalVolumeTopologyRequestPreferred | undefined;
    private _required;
    get required(): ExternalVolumeTopologyRequestRequiredOutputReference;
    putRequired(value: ExternalVolumeTopologyRequestRequired): void;
    resetRequired(): void;
    get requiredInput(): ExternalVolumeTopologyRequestRequired | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume nomad_external_volume}
*/
export declare class ExternalVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_external_volume";
    /**
    * Generates CDKTF code for importing a ExternalVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalVolume to import
    * @param importFromId The id of the existing ExternalVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/external_volume nomad_external_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalVolumeConfig
    */
    constructor(scope: Construct, id: string, config: ExternalVolumeConfig);
    private _capacityMax?;
    get capacityMax(): string;
    set capacityMax(value: string);
    resetCapacityMax(): void;
    get capacityMaxInput(): string | undefined;
    private _capacityMin?;
    get capacityMin(): string;
    set capacityMin(value: string);
    resetCapacityMin(): void;
    get capacityMinInput(): string | undefined;
    private _cloneId?;
    get cloneId(): string;
    set cloneId(value: string);
    resetCloneId(): void;
    get cloneIdInput(): string | undefined;
    get controllerRequired(): cdktf.IResolvable;
    get controllersExpected(): number;
    get controllersHealthy(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get nodesExpected(): number;
    get nodesHealthy(): number;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    get pluginProvider(): string;
    get pluginProviderVersion(): string;
    get schedulable(): cdktf.IResolvable;
    private _secrets?;
    get secrets(): {
        [key: string]: string;
    };
    set secrets(value: {
        [key: string]: string;
    });
    resetSecrets(): void;
    get secretsInput(): {
        [key: string]: string;
    } | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _topologies;
    get topologies(): ExternalVolumeTopologiesList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _capability;
    get capability(): ExternalVolumeCapabilityList;
    putCapability(value: ExternalVolumeCapability[] | cdktf.IResolvable): void;
    get capabilityInput(): cdktf.IResolvable | ExternalVolumeCapability[] | undefined;
    private _mountOptions;
    get mountOptions(): ExternalVolumeMountOptionsOutputReference;
    putMountOptions(value: ExternalVolumeMountOptions): void;
    resetMountOptions(): void;
    get mountOptionsInput(): ExternalVolumeMountOptions | undefined;
    private _topologyRequest;
    get topologyRequest(): ExternalVolumeTopologyRequestOutputReference;
    putTopologyRequest(value: ExternalVolumeTopologyRequest): void;
    resetTopologyRequest(): void;
    get topologyRequestInput(): ExternalVolumeTopologyRequest | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
