/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Consul token used to submit this job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#consul_token Job#consul_token}
    */
    readonly consulToken?: string;
    /**
    * If true, the job will be deregistered on destroy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#deregister_on_destroy Job#deregister_on_destroy}
    */
    readonly deregisterOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * If true, the job will be deregistered when the job ID changes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#deregister_on_id_change Job#deregister_on_id_change}
    */
    readonly deregisterOnIdChange?: boolean | cdktf.IResolvable;
    /**
    * If true, the provider will return immediately after creating or updating, instead of monitoring.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#detach Job#detach}
    */
    readonly detach?: boolean | cdktf.IResolvable;
    /**
    * If true, the `jobspec` will be parsed using the HCL1 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#hcl1 Job#hcl1}
    */
    readonly hcl1?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Job specification. If you want to point to a file use the file() function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#jobspec Job#jobspec}
    */
    readonly jobspec: string;
    /**
    * If true, the `jobspec` will be parsed as json instead of HCL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#json Job#json}
    */
    readonly json?: boolean | cdktf.IResolvable;
    /**
    * Override any soft-mandatory Sentinel policies that fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#policy_override Job#policy_override}
    */
    readonly policyOverride?: boolean | cdktf.IResolvable;
    /**
    * Whether to purge the job when the resource is destroyed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#purge_on_destroy Job#purge_on_destroy}
    */
    readonly purgeOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#read_allocation_ids Job#read_allocation_ids}
    */
    readonly readAllocationIds?: boolean | cdktf.IResolvable;
    /**
    * The Vault token used to submit this job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#vault_token Job#vault_token}
    */
    readonly vaultToken?: string;
    /**
    * hcl2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#hcl2 Job#hcl2}
    */
    readonly hcl2?: JobHcl2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#timeouts Job#timeouts}
    */
    readonly timeouts?: JobTimeouts;
}
export interface JobTaskGroupsTaskVolumeMounts {
}
export declare function jobTaskGroupsTaskVolumeMountsToTerraform(struct?: JobTaskGroupsTaskVolumeMounts): any;
export declare class JobTaskGroupsTaskVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskGroupsTaskVolumeMounts | undefined;
    set internalValue(value: JobTaskGroupsTaskVolumeMounts | undefined);
    get destination(): string;
    get readOnly(): cdktf.IResolvable;
    get volume(): string;
}
export declare class JobTaskGroupsTaskVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskGroupsTaskVolumeMountsOutputReference;
}
export interface JobTaskGroupsTask {
}
export declare function jobTaskGroupsTaskToTerraform(struct?: JobTaskGroupsTask): any;
export declare class JobTaskGroupsTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskGroupsTask | undefined;
    set internalValue(value: JobTaskGroupsTask | undefined);
    get driver(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _volumeMounts;
    get volumeMounts(): JobTaskGroupsTaskVolumeMountsList;
}
export declare class JobTaskGroupsTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskGroupsTaskOutputReference;
}
export interface JobTaskGroupsVolumes {
}
export declare function jobTaskGroupsVolumesToTerraform(struct?: JobTaskGroupsVolumes): any;
export declare class JobTaskGroupsVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskGroupsVolumes | undefined;
    set internalValue(value: JobTaskGroupsVolumes | undefined);
    get name(): string;
    get readOnly(): cdktf.IResolvable;
    get source(): string;
    get type(): string;
}
export declare class JobTaskGroupsVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskGroupsVolumesOutputReference;
}
export interface JobTaskGroups {
}
export declare function jobTaskGroupsToTerraform(struct?: JobTaskGroups): any;
export declare class JobTaskGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JobTaskGroups | undefined;
    set internalValue(value: JobTaskGroups | undefined);
    get count(): number;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _task;
    get task(): JobTaskGroupsTaskList;
    private _volumes;
    get volumes(): JobTaskGroupsVolumesList;
}
export declare class JobTaskGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JobTaskGroupsOutputReference;
}
export interface JobHcl2 {
    /**
    * If true, HCL2 file system functions will be enabled when parsing the `jobspec`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#allow_fs Job#allow_fs}
    */
    readonly allowFs?: boolean | cdktf.IResolvable;
    /**
    * If true, the `jobspec` will be parsed as HCL2 instead of HCL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#enabled Job#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Additional variables to use when templating the job with HCL2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#vars Job#vars}
    */
    readonly vars?: {
        [key: string]: string;
    };
}
export declare function jobHcl2ToTerraform(struct?: JobHcl2OutputReference | JobHcl2): any;
export declare class JobHcl2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobHcl2 | undefined;
    set internalValue(value: JobHcl2 | undefined);
    private _allowFs?;
    get allowFs(): boolean | cdktf.IResolvable;
    set allowFs(value: boolean | cdktf.IResolvable);
    resetAllowFs(): void;
    get allowFsInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vars?;
    get vars(): {
        [key: string]: string;
    };
    set vars(value: {
        [key: string]: string;
    });
    resetVars(): void;
    get varsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface JobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#create Job#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#update Job#update}
    */
    readonly update?: string;
}
export declare function jobTimeoutsToTerraform(struct?: JobTimeouts | cdktf.IResolvable): any;
export declare class JobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job nomad_job}
*/
export declare class Job extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_job";
    /**
    * Generates CDKTF code for importing a Job resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Job to import
    * @param importFromId The id of the existing Job that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Job to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/job nomad_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JobConfig
    */
    constructor(scope: Construct, id: string, config: JobConfig);
    get allocationIds(): string[];
    private _consulToken?;
    get consulToken(): string;
    set consulToken(value: string);
    resetConsulToken(): void;
    get consulTokenInput(): string | undefined;
    get datacenters(): string[];
    get deploymentId(): string;
    get deploymentStatus(): string;
    private _deregisterOnDestroy?;
    get deregisterOnDestroy(): boolean | cdktf.IResolvable;
    set deregisterOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeregisterOnDestroy(): void;
    get deregisterOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _deregisterOnIdChange?;
    get deregisterOnIdChange(): boolean | cdktf.IResolvable;
    set deregisterOnIdChange(value: boolean | cdktf.IResolvable);
    resetDeregisterOnIdChange(): void;
    get deregisterOnIdChangeInput(): boolean | cdktf.IResolvable | undefined;
    private _detach?;
    get detach(): boolean | cdktf.IResolvable;
    set detach(value: boolean | cdktf.IResolvable);
    resetDetach(): void;
    get detachInput(): boolean | cdktf.IResolvable | undefined;
    private _hcl1?;
    get hcl1(): boolean | cdktf.IResolvable;
    set hcl1(value: boolean | cdktf.IResolvable);
    resetHcl1(): void;
    get hcl1Input(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobspec?;
    get jobspec(): string;
    set jobspec(value: string);
    get jobspecInput(): string | undefined;
    private _json?;
    get json(): boolean | cdktf.IResolvable;
    set json(value: boolean | cdktf.IResolvable);
    resetJson(): void;
    get jsonInput(): boolean | cdktf.IResolvable | undefined;
    get modifyIndex(): string;
    get name(): string;
    get namespace(): string;
    private _policyOverride?;
    get policyOverride(): boolean | cdktf.IResolvable;
    set policyOverride(value: boolean | cdktf.IResolvable);
    resetPolicyOverride(): void;
    get policyOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _purgeOnDestroy?;
    get purgeOnDestroy(): boolean | cdktf.IResolvable;
    set purgeOnDestroy(value: boolean | cdktf.IResolvable);
    resetPurgeOnDestroy(): void;
    get purgeOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _readAllocationIds?;
    get readAllocationIds(): boolean | cdktf.IResolvable;
    set readAllocationIds(value: boolean | cdktf.IResolvable);
    resetReadAllocationIds(): void;
    get readAllocationIdsInput(): boolean | cdktf.IResolvable | undefined;
    get region(): string;
    private _taskGroups;
    get taskGroups(): JobTaskGroupsList;
    get type(): string;
    private _vaultToken?;
    get vaultToken(): string;
    set vaultToken(value: string);
    resetVaultToken(): void;
    get vaultTokenInput(): string | undefined;
    private _hcl2;
    get hcl2(): JobHcl2OutputReference;
    putHcl2(value: JobHcl2): void;
    resetHcl2(): void;
    get hcl2Input(): JobHcl2 | undefined;
    private _timeouts;
    get timeouts(): JobTimeoutsOutputReference;
    putTimeouts(value: JobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
