/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#description Namespace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#id Namespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata associated with the namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#meta Namespace#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Unique name for this namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#name Namespace#name}
    */
    readonly name: string;
    /**
    * Quota to set for this namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#quota Namespace#quota}
    */
    readonly quota?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#capabilities Namespace#capabilities}
    */
    readonly capabilities?: NamespaceCapabilities;
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#node_pool_config Namespace#node_pool_config}
    */
    readonly nodePoolConfig?: NamespaceNodePoolConfig;
}
export interface NamespaceCapabilities {
    /**
    * Disabled task drivers for the namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#disabled_task_drivers Namespace#disabled_task_drivers}
    */
    readonly disabledTaskDrivers?: string[];
    /**
    * Enabled task drivers for the namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#enabled_task_drivers Namespace#enabled_task_drivers}
    */
    readonly enabledTaskDrivers?: string[];
}
export declare function namespaceCapabilitiesToTerraform(struct?: NamespaceCapabilitiesOutputReference | NamespaceCapabilities): any;
export declare class NamespaceCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamespaceCapabilities | undefined;
    set internalValue(value: NamespaceCapabilities | undefined);
    private _disabledTaskDrivers?;
    get disabledTaskDrivers(): string[];
    set disabledTaskDrivers(value: string[]);
    resetDisabledTaskDrivers(): void;
    get disabledTaskDriversInput(): string[] | undefined;
    private _enabledTaskDrivers?;
    get enabledTaskDrivers(): string[];
    set enabledTaskDrivers(value: string[]);
    resetEnabledTaskDrivers(): void;
    get enabledTaskDriversInput(): string[] | undefined;
}
export interface NamespaceNodePoolConfig {
    /**
    * The list of node pools allowed to be used in this namespace. Cannot be used with denied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#allowed Namespace#allowed}
    */
    readonly allowed?: string[];
    /**
    * The node pool to use when none are specified in the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#default Namespace#default}
    */
    readonly default?: string;
    /**
    * The list of node pools not allowed to be used in this namespace. Cannot be used with allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#denied Namespace#denied}
    */
    readonly denied?: string[];
}
export declare function namespaceNodePoolConfigToTerraform(struct?: NamespaceNodePoolConfigOutputReference | NamespaceNodePoolConfig): any;
export declare class NamespaceNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamespaceNodePoolConfig | undefined;
    set internalValue(value: NamespaceNodePoolConfig | undefined);
    private _allowed?;
    get allowed(): string[];
    set allowed(value: string[]);
    resetAllowed(): void;
    get allowedInput(): string[] | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _denied?;
    get denied(): string[];
    set denied(value: string[]);
    resetDenied(): void;
    get deniedInput(): string[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace nomad_namespace}
*/
export declare class Namespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_namespace";
    /**
    * Generates CDKTF code for importing a Namespace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Namespace to import
    * @param importFromId The id of the existing Namespace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Namespace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/namespace nomad_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NamespaceConfig
    */
    constructor(scope: Construct, id: string, config: NamespaceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quota?;
    get quota(): string;
    set quota(value: string);
    resetQuota(): void;
    get quotaInput(): string | undefined;
    private _capabilities;
    get capabilities(): NamespaceCapabilitiesOutputReference;
    putCapabilities(value: NamespaceCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): NamespaceCapabilities | undefined;
    private _nodePoolConfig;
    get nodePoolConfig(): NamespaceNodePoolConfigOutputReference;
    putNodePoolConfig(value: NamespaceNodePoolConfig): void;
    resetNodePoolConfig(): void;
    get nodePoolConfigInput(): NamespaceNodePoolConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
