/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#description NodePool#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#id NodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata associated with the node pool
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#meta NodePool#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Unique name for this node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#name NodePool#name}
    */
    readonly name: string;
    /**
    * scheduler_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#scheduler_config NodePool#scheduler_config}
    */
    readonly schedulerConfig?: NodePoolSchedulerConfig;
}
export interface NodePoolSchedulerConfig {
    /**
    * If true, the node pool will have memory oversubscription enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#memory_oversubscription NodePool#memory_oversubscription}
    */
    readonly memoryOversubscription?: string;
    /**
    * The scheduler algorithm to use in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#scheduler_algorithm NodePool#scheduler_algorithm}
    */
    readonly schedulerAlgorithm?: string;
}
export declare function nodePoolSchedulerConfigToTerraform(struct?: NodePoolSchedulerConfigOutputReference | NodePoolSchedulerConfig): any;
export declare class NodePoolSchedulerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NodePoolSchedulerConfig | undefined;
    set internalValue(value: NodePoolSchedulerConfig | undefined);
    private _memoryOversubscription?;
    get memoryOversubscription(): string;
    set memoryOversubscription(value: string);
    resetMemoryOversubscription(): void;
    get memoryOversubscriptionInput(): string | undefined;
    private _schedulerAlgorithm?;
    get schedulerAlgorithm(): string;
    set schedulerAlgorithm(value: string);
    resetSchedulerAlgorithm(): void;
    get schedulerAlgorithmInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool nomad_node_pool}
*/
export declare class NodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_node_pool";
    /**
    * Generates CDKTF code for importing a NodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NodePool to import
    * @param importFromId The id of the existing NodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/node_pool nomad_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NodePoolConfig
    */
    constructor(scope: Construct, id: string, config: NodePoolConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedulerConfig;
    get schedulerConfig(): NodePoolSchedulerConfigOutputReference;
    putSchedulerConfig(value: NodePoolSchedulerConfig): void;
    resetSchedulerConfig(): void;
    get schedulerConfigInput(): NodePoolSchedulerConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
