/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NomadProviderConfig {
    /**
    * URL of the root of the target Nomad agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#address NomadProvider#address}
    */
    readonly address: string;
    /**
    * A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#ca_file NomadProvider#ca_file}
    */
    readonly caFile?: string;
    /**
    * PEM-encoded certificate authority used to verify the remote agent's certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#ca_pem NomadProvider#ca_pem}
    */
    readonly caPem?: string;
    /**
    * A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#cert_file NomadProvider#cert_file}
    */
    readonly certFile?: string;
    /**
    * PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#cert_pem NomadProvider#cert_pem}
    */
    readonly certPem?: string;
    /**
    * Consul token to validate Consul Connect Service Identity policies specified in the job file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#consul_token NomadProvider#consul_token}
    */
    readonly consulToken?: string;
    /**
    * HTTP basic auth configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#http_auth NomadProvider#http_auth}
    */
    readonly httpAuth?: string;
    /**
    * A set of environment variables that are ignored by the provider when configuring the Nomad API client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#ignore_env_vars NomadProvider#ignore_env_vars}
    */
    readonly ignoreEnvVars?: {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
    * A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#key_file NomadProvider#key_file}
    */
    readonly keyFile?: string;
    /**
    * PEM-encoded private key, required if cert_file or cert_pem is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#key_pem NomadProvider#key_pem}
    */
    readonly keyPem?: string;
    /**
    * Region of the target Nomad agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#region NomadProvider#region}
    */
    readonly region?: string;
    /**
    * ACL token secret for API requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#secret_id NomadProvider#secret_id}
    */
    readonly secretId?: string;
    /**
    * Skip TLS verification on client side.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#skip_verify NomadProvider#skip_verify}
    */
    readonly skipVerify?: boolean | cdktf.IResolvable;
    /**
    * Vault token if policies are specified in the job file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#vault_token NomadProvider#vault_token}
    */
    readonly vaultToken?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#alias NomadProvider#alias}
    */
    readonly alias?: string;
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#headers NomadProvider#headers}
    */
    readonly headers?: NomadProviderHeaders[] | cdktf.IResolvable;
}
export interface NomadProviderHeaders {
    /**
    * The header name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#name NomadProvider#name}
    */
    readonly name: string;
    /**
    * The header value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#value NomadProvider#value}
    */
    readonly value: string;
}
export declare function nomadProviderHeadersToTerraform(struct?: NomadProviderHeaders | cdktf.IResolvable): any;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs nomad}
*/
export declare class NomadProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "nomad";
    /**
    * Generates CDKTF code for importing a NomadProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NomadProvider to import
    * @param importFromId The id of the existing NomadProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NomadProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs nomad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NomadProviderConfig
    */
    constructor(scope: Construct, id: string, config: NomadProviderConfig);
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    get addressInput(): string | undefined;
    private _caFile?;
    get caFile(): string | undefined;
    set caFile(value: string | undefined);
    resetCaFile(): void;
    get caFileInput(): string | undefined;
    private _caPem?;
    get caPem(): string | undefined;
    set caPem(value: string | undefined);
    resetCaPem(): void;
    get caPemInput(): string | undefined;
    private _certFile?;
    get certFile(): string | undefined;
    set certFile(value: string | undefined);
    resetCertFile(): void;
    get certFileInput(): string | undefined;
    private _certPem?;
    get certPem(): string | undefined;
    set certPem(value: string | undefined);
    resetCertPem(): void;
    get certPemInput(): string | undefined;
    private _consulToken?;
    get consulToken(): string | undefined;
    set consulToken(value: string | undefined);
    resetConsulToken(): void;
    get consulTokenInput(): string | undefined;
    private _httpAuth?;
    get httpAuth(): string | undefined;
    set httpAuth(value: string | undefined);
    resetHttpAuth(): void;
    get httpAuthInput(): string | undefined;
    private _ignoreEnvVars?;
    get ignoreEnvVars(): {
        [key: string]: (boolean | cdktf.IResolvable);
    } | undefined;
    set ignoreEnvVars(value: {
        [key: string]: (boolean | cdktf.IResolvable);
    } | undefined);
    resetIgnoreEnvVars(): void;
    get ignoreEnvVarsInput(): {
        [key: string]: boolean | cdktf.IResolvable;
    } | undefined;
    private _keyFile?;
    get keyFile(): string | undefined;
    set keyFile(value: string | undefined);
    resetKeyFile(): void;
    get keyFileInput(): string | undefined;
    private _keyPem?;
    get keyPem(): string | undefined;
    set keyPem(value: string | undefined);
    resetKeyPem(): void;
    get keyPemInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secretId?;
    get secretId(): string | undefined;
    set secretId(value: string | undefined);
    resetSecretId(): void;
    get secretIdInput(): string | undefined;
    private _skipVerify?;
    get skipVerify(): boolean | cdktf.IResolvable | undefined;
    set skipVerify(value: boolean | cdktf.IResolvable | undefined);
    resetSkipVerify(): void;
    get skipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _vaultToken?;
    get vaultToken(): string | undefined;
    set vaultToken(value: string | undefined);
    resetVaultToken(): void;
    get vaultTokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _headers?;
    get headers(): NomadProviderHeaders[] | cdktf.IResolvable | undefined;
    set headers(value: NomadProviderHeaders[] | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | NomadProviderHeaders[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
